DELIMITER $$
DROP PROCEDURE IF EXISTS getHESASessionYearEntryDetails $$
CREATE PROCEDURE getHESASessionYearEntryDetails(IN programId BIGINT, IN academicTermId BIGINT)
BEGIN

SELECT 
term.itemCode AS SESSIONYEARID,
term.itemValue AS OWNSESSIONID,
pbpc.programPeriodEnd AS SYENDDATE,
pbpc.programPeriodStart AS SYSTARTDATE 
from prog_batch_period_config pbpc 
left join batches b on b.id=pbpc.programBatchId
left join programs p on p.id=b.programId
left join academic_term term on term.id=pbpc.academicTermId
WHERE
    p.id IN (programId)
    AND term.id IN (academicTermId);

END $$ 
DELIMITER ;