DELIMITER $$
DROP PROCEDURE IF EXISTS getSAGEStudentsData $$
CREATE PROCEDURE `getSAGEStudentsData` (
    IN academyLocationId BIGINT,
    IN programCode varchar(25),
    IN batchCode varchar(25),
    IN admissionFromDate DATE,
    IN admissionToDate DATE,
    IN lastUpdatedFromDate DATE,
    IN lastUpdatedToDate DATE
)
BEGIN
    SELECT 
        u.code AS `studentAccountNumber`,
        u.printName AS `studentName`,
        sal.salutationName AS `title`,
		concat(parentPer.firstName,' ',parentPer.lastName) AS `contactPerson`,
        per.mobileNumber AS `telephone1`,
        parentPer.mobileNumber AS `telephone2`,
        b.printName AS `accountDescription`,
        phyAdd.addressText AS `physicalAddress`,
        posAdd.addressText AS `postalAddress`,
        p.programCode AS `customerGroup`,
        sts.seatName AS `customerArea`,
        DATE(ad.admissionDate) AS `createdDate`,
        DATE(ad.lastUpdate) AS `updatedDate`
    FROM admission ad
    LEFT JOIN users u ON ad.studentId = u.id
    LEFT JOIN students st on u.id=st.userId
    LEFT JOIN persons per on st.personId=per.id
    LEFT JOIN academy_location al on ad.academyLocationId=al.id
    LEFT JOIN prog_batch_seat_config pbsc ON ad.programBatchSeatConfigId = pbsc.id
    LEFT JOIN batches b on pbsc.programBatchId=b.id
    LEFT JOIN programs p on b.programId=p.id
    LEFT JOIN seat_types sts on pbsc.seatTypeId=sts.id
    LEFT JOIN person_relationships rel ON rel.id = (SELECT pr.id FROM person_relationships pr WHERE pr.personId = per.id ORDER BY pr.id LIMIT 1)
    Left join persons parentPer on rel.relatedPersonId=parentPer.id
    LEFT JOIN person_addresses pad on per.id=pad.personId
    LEFT JOIN salutations sal on per.salutationId=sal.id
    LEFT JOIN address phyAdd on pad.addressId=phyAdd.id and phyAdd.addressTypeId='5'
    LEFT JOIN address posAdd on pad.addressId=posAdd.id and posAdd.addressTypeId='6'
      WHERE (academyLocationId IS NULL OR al.id = academyLocationId)
      AND (programCode IS NULL OR p.programCode = programCode)
      AND (batchCode IS NULL OR b.batchName = batchCode)
      AND (admissionFromDate IS NULL OR DATE(ad.admissionDate) >= admissionFromDate)
      AND (admissionToDate IS NULL OR DATE(ad.admissionDate) <= admissionToDate)
      AND (lastUpdatedFromDate IS NULL OR DATE(ad.lastUpdate) >= lastUpdatedFromDate)
      AND (lastUpdatedToDate IS NULL OR DATE(ad.lastUpdate) <= lastUpdatedToDate)
    GROUP BY ad.id,u.id;
END$$

DELIMITER ;