DELIMITER $$
DROP PROCEDURE IF EXISTS V20250701104627__Alter_Std_Hold_Optimization $$
CREATE PROCEDURE V20250701104627__Alter_Std_Hold_Optimization()
BEGIN


-- Index 1: idx_apply_hold_student
    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.statistics
        WHERE table_schema = DATABASE()
          AND table_name = 'student_apply_hold_category'
          AND index_name = 'idx_apply_hold_student'
    ) THEN
        ALTER TABLE student_apply_hold_category
        ADD INDEX idx_apply_hold_student (applyById, holdCatId, studentId);
    END IF;

    -- Index 2: idx_apply_hold_removal
    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.statistics
        WHERE table_schema = DATABASE()
          AND table_name = 'student_apply_hold_category'
          AND index_name = 'idx_apply_hold_removal'
    ) THEN
        ALTER TABLE student_apply_hold_category
        ADD INDEX idx_apply_hold_removal (removalById, holdCatId, studentId);
    END IF;

    -- Index 3: idx_pbs_flags_admission
    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.statistics
        WHERE table_schema = DATABASE()
          AND table_name = 'program_batch_students'
          AND index_name = 'idx_pbs_flags_admission'
    ) THEN
        ALTER TABLE program_batch_students
        ADD INDEX idx_pbs_flags_admission (isCurrentPeriod, isCurrentSection, admissionId);
    END IF;

    -- Index 4: idx_admission_status
    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.statistics
        WHERE table_schema = DATABASE()
          AND table_name = 'admission'
          AND index_name = 'idx_admission_status'
    ) THEN
        ALTER TABLE admission
        ADD INDEX idx_admission_status (studentId, activeStatus, id);
    END IF;


END $$
CALL V20250701104627__Alter_Std_Hold_Optimization() $$
DROP PROCEDURE IF EXISTS V20250701104627__Alter_Std_Hold_Optimization $$
DELIMITER ;