DELIMITER $$

DROP PROCEDURE IF EXISTS V20250718181523__Create_SPortalTransferCreditGridExternal $$

CREATE PROCEDURE V20250718181523__Create_SPortalTransferCreditGridExternal()
BEGIN
   SET SQL_SAFE_UPDATES = 0;
	SET @gridName = 'Academia.view.personinfo.student.StudentForExternalTransferCreditGrid';
    SET @portalId = 3;
	IF NOT EXISTS (SELECT 1 FROM data_grid WHERE gridName = @gridName AND portalId = @portalId) THEN
       INSERT INTO data_grid (gridName, portalId, jsonObject)
        VALUES (
            @gridName,
            @portalId,
            '[
  {
    "id": null,
    "columnName": "PERIOD",
    "dataIndex": "programPeriodName",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 1,
    "mandatory": false
  },
  {
    "id": null,
    "columnName": "COURSE_CODE",
    "dataIndex": "courseCode",
    "columnVisibility": "SHOW",
    "sequence": 2,
    "mandatory": false
  },
  {
    "id": null,
    "columnName": "COURSE_NAME",
    "dataIndex": "courseName",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 3,
    "mandatory": false
  },
  {
    "id": null,
    "columnName": "CREDITS",
    "dataIndex": "courseCredit",
    "flex": 0.5,
    "columnVisibility": "SHOW",
    "sequence": 4,
    "mandatory": false
  },
  {
    "id": null,
    "columnName": "MARKS_OR_GRADE",
    "dataIndex": "marksGrade",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 5,
    "mandatory": false
  },
  {
    "id": null,
    "columnName": "EQUIVALENT_COURSE_CODE",
    "dataIndex": "equivalentCourseCode",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 6,
    "mandatory": true
  },
  {
    "id": null,
    "columnName": "EQUIVALENT_COURSE_NAME",
    "dataIndex": "equivalentCourseName",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 7,
    "mandatory": true
  },
  {
    "id": null,
    "columnName": "INSTITUTE_NAME",
    "dataIndex": "institueName",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 8,
    "mandatory": false
  },
  {
    "id": null,
    "columnName": "EQUIVALENT_COURSE_CREDIT",
    "dataIndex": "equivalentCourseCredit",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 9,
    "mandatory": false
  },
  {
    "id": null,
    "columnName": "STATUS",
    "dataIndex": "applicantTransferCreditStatus",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 10,
    "mandatory": false
  },
  {
    "id": null,
    "columnName": "STUDENT_REMARK",
    "dataIndex": "studentRemark",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 11,
    "mandatory": false
  },
  {
    "id": null,
    "columnName": "FACULTY_REMARK",
    "dataIndex": "facultyRemark",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 12,
    "mandatory": false
  },
  {
    "id": null,
    "columnName": "FACULTY_APPROVER_DATE",
    "dataIndex": "facultyApproverDate",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 13,
    "mandatory": false
  },
  {
    "id": null,
    "columnName": "FACULTY_APPROVER_NAME",
    "dataIndex": "facultyApproverName",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 14,
    "mandatory": false
  },
  {
    "id": null,
    "columnName": "COMPLETION_DATE",
    "dataIndex": "completionDate",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 15,
    "mandatory": false
  },
  {
    "id": null,
    "columnName": "EQUIVALENT_COURSE_SYLLABUS",
    "dataIndex": "document",
    "flex": 1,
    "columnVisibility": "SHOW",
    "sequence": 16,
    "mandatory": false
  }
]' 
        );
    END IF;
SET SQL_SAFE_UPDATES = 1;
END $$
CALL V20250718181523__Create_SPortalTransferCreditGridExternal () $$
DROP PROCEDURE IF EXISTS V20250718181523__Create_SPortalTransferCreditGridExternal $$
DELIMITER ;