DELIMITER $$
DROP PROCEDURE IF EXISTS V20250805105523__Insert_D365SOA_OSM $$
CREATE PROCEDURE V20250805105523__Insert_D365SOA_OSM()
BEGIN

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'd365_soa_conf')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, 
`droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'d365_soa_conf','D365_STATEMENT_OF_ACCOUNT_CONFIGURATION','OTHER',
'MASTER_WITH_AL',0,0,NULL,1,@currentTimeStamp);
END IF;

-- Items
IF  EXISTS ((SELECT * FROM standard_master WHERE tableName = 'd365_soa_conf')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'd365_soa_conf');

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='CLIENT_ID')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,
`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,
`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('clientId','CLIENT_ID',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='SECRET_KEY')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('secretKey','SECRET_KEY',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='TENANT_ID')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,
`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,
`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('tenantId','TENANT_ID',@standardMasterId,'Varchar',NULL,3,0,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='REDIRECTION_URL')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,
`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,
`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('redirectionUrl','REDIRECTION_URL',@standardMasterId,'Varchar',NULL,4,0,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='BIP_CLIENT_ID')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,
`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,
`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('bipClientId','BIP_CLIENT_ID',@standardMasterId,'Varchar',NULL,5,0,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='BIP_URL')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,
`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,
`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('bipUrl','BIP_URL',@standardMasterId,'Varchar',NULL,6,0,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='PARAMETER_1')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,
`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,
`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('parameterOne','PARAMETER_1',@standardMasterId,'Varchar',NULL,7,0,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='PARAMETER_2')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,
`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,
`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('parameterTwo','PARAMETER_2',@standardMasterId,'Varchar',NULL,8,0,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='ON_BEHALF_OF_FLOW')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,
`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,
`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('onBehalfOfFlow','ON_BEHALF_OF_FLOW',@standardMasterId,'Boolean',NULL,9,0,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='ACTIVE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,
`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,
`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('active','ACTIVE',@standardMasterId,'Boolean',NULL,10,0,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());
END IF;

-- translations
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='D365_STATEMENT_OF_ACCOUNT_CONFIGURATION')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames','D365_STATEMENT_OF_ACCOUNT_CONFIGURATION','D365 Statement of Account Configuration',
'D365 Statement of Account Configuration',
'D365 Rekeningstaatkonfigurasie','Báo cáo cấu hình tài khoản D365',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='CLIENT_ID' AND objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','CLIENT_ID','Client Id','Client Id',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='TENANT_ID' AND objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','TENANT_ID','Secret Key','Secret Key',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='SECRET_KEY' AND objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','SECRET_KEY','Tenant Id','Tenant Id',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='REDIRECTION_URL' AND objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','REDIRECTION_URL','Redirection url','Redirection url',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='BIP_CLIENT_ID' AND objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','BIP_CLIENT_ID','Bip Client Id','BIP Client Id',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='BIP_URL' AND objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','BIP_URL','Bip Url','Bip Url',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='PARAMETER_1' AND objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','PARAMETER_1','Parameter 1','Parameter 1',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='PARAMETER_2' AND objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','PARAMETER_2','Parameter 2','Parameter 2',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='ON_BEHALF_OF_FLOW' AND objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','ON_BEHALF_OF_FLOW','On behalf of Flow','On behalf of Flow',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='ACTIVE' AND objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','ACTIVE','Active','Active',now(),1);
END IF;


END IF;
END $$
CALL V20250805105523__Insert_D365SOA_OSM() $$
DROP PROCEDURE IF EXISTS V20250805105523__Insert_D365SOA_OSM $$
DELIMITER ;