DELIMITER $$

DROP PROCEDURE IF EXISTS V20250806162149__Create_Address_Responsive_Dfr $$

CREATE PROCEDURE V20250806162149__Create_Address_Responsive_Dfr()
BEGIN
    -- Step 1: Create table
    SET SQL_SAFE_UPDATES = 0;

    IF NOT EXISTS (
        SELECT * FROM form_field_info
        WHERE formScreenName IN ('Address - Responsive')
    ) THEN

        IF NOT EXISTS (
            SELECT 1 FROM information_schema.TABLES 
            WHERE table_schema = DATABASE() 
              AND table_name = 'form_field_info_responsive'
        ) THEN
            CREATE TABLE form_field_info_responsive AS
            SELECT * FROM form_field_info
            WHERE formScreenName IN ('Address');
        END IF;

        IF EXISTS (
            SELECT 1 FROM form_field_info_responsive 
            WHERE formScreenName = 'Address' AND formAliasName = 'addressformwindow'
        ) THEN
            DELETE FROM form_field_info_responsive
            WHERE formScreenName = 'Address' 
              AND formAliasName = 'addressformwindow'
              AND formFieldName IN ('faxNumber','pincodeNew','parentCountryRegionIdText','countryIdText','cityIdText');
        END IF;

        -- Step 2: Update formAliasName
        UPDATE form_field_info_responsive
        SET formAliasName = CONCAT(formAliasName, 'responsive');

        -- Step 3: Update formScreenName
        UPDATE form_field_info_responsive
        SET formScreenName = CONCAT(formScreenName, ' - Responsive');

        -- Step 4: Insert only non-duplicate rows
        INSERT INTO form_field_info (
            formAliasName,
            formFieldName,
            formFieldId,
            formFieldInputType,
            isMandatory,
            isLocked,
            defaultValue,
            lastUpdatedBy,
            formFieldDefaultLabel,
            formFieldDefaultHelpText,
            formScreenName,
            formScreenMode,
            fieldDisplayName,
            whetherForAllAcademyLocation
        )
        SELECT
            r.formAliasName,
            r.formFieldName,
            r.formFieldId,
            r.formFieldInputType,
            r.isMandatory,
            r.isLocked,
            r.defaultValue,
            r.lastUpdatedBy,
            r.formFieldDefaultLabel,
            r.formFieldDefaultHelpText,
            r.formScreenName,
            r.formScreenMode,
            r.fieldDisplayName,
            r.whetherForAllAcademyLocation
        FROM form_field_info_responsive r
        WHERE NOT EXISTS (
            SELECT 1
            FROM form_field_info f
            WHERE f.formAliasName = r.formAliasName
              AND f.formFieldName = r.formFieldName
              AND f.formFieldId = r.formFieldId
        );

        -- Step 5: Drop temp table
        DROP TABLE IF EXISTS form_field_info_responsive;

        SET SQL_SAFE_UPDATES = 1;

    END IF;


END $$

CALL V20250806162149__Create_Address_Responsive_Dfr() $$

DROP PROCEDURE IF EXISTS V20250806162149__Create_Address_Responsive_Dfr $$

DELIMITER ;