DELIMITER $$
DROP PROCEDURE IF EXISTS V20250829183728__Create_QuickPollAL $$
CREATE PROCEDURE V20250829183728__Create_QuickPollAL()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='general_survey_academy_location')) THEN 
CREATE TABLE general_survey_academy_location (
    id BIGINT NOT NULL AUTO_INCREMENT,
    academyLocationId BIGINT NOT NULL,
    generalSurveyId BIGINT NOT NULL,
    lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    KEY FK_general_survey_academy_location_lastUpdatedBy (lastUpdatedBy),
    KEY FK_general_survey_academy_location_academyLocationId (academyLocationId),
    KEY FK_general_survey_academy_location_generalSurveyId (generalSurveyId),
    CONSTRAINT FK_general_survey_academy_location_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id) ,
    CONSTRAINT FK_general_survey_academy_location_academyLocationId FOREIGN KEY (academyLocationId) REFERENCES academy_location (id),
    CONSTRAINT FK_general_survey_academy_location_generalSurveyId FOREIGN KEY (generalSurveyId) REFERENCES general_survey_csm (id)
) ;
END IF; 

END $$
CALL V20250829183728__Create_QuickPollAL () $$ 
DROP PROCEDURE IF EXISTS V20250829183728__Create_QuickPollAL $$ 
DELIMITER ;