DELIMITER $$
DROP PROCEDURE IF EXISTS V20250916105244__Insert_DynamicDocFeePayer $$
CREATE PROCEDURE V20250916105244__Insert_DynamicDocFeePayer()
BEGIN

IF EXISTS(select 1 from msg_template_config where code='Registration Amendment – Fee Payer Notification') THEN
SET @msgtemplateconfigId=(select id from msg_template_config where code='Registration Amendment – Fee Payer Notification');
SET @dydtdocumenttypeId=(SELECT MAX(id) FROM `dydt_document_type`);
INSERT INTO `dydt_document_type` (`id`,`typeName`, `configLevelCode`, `whetherDeletable`, `typeCode`, `availableForAdhoc`, `whetherEditable`)
VALUES (@dydtdocumenttypeId+1,'Registration Amendment Letter', 'PROGRAM_BATCH_SEAT_TYPE_LEVEL', '0', 'Registration Amendment Letter', '0', '1');


SET @sysmsgevtrcptdefaultconfId=(select T1.id from `sys_msg_evtrcpt_default_conf` T1 left join `sys_msg_evt_default_conf` T2 on T1.sysMsgEvtDefaultConfId = T2.id left join `system_msg_event`
T3 on T2.systemMsgEventId = T3.id where T3.code = 'REGISTRATION_AMENDMENT_FEEPAYER');
SET @sysmsgevtrcpntdocId=(SELECT MAX(id) FROM `sys_msg_evt_rcpnt_doc`);
SET @msgscopeparamId=(select id from msg_scope_param where paramKey='DLS_PROGRAM_BATCH_SEAT_CONFIG_ID');
INSERT INTO `sys_msg_evt_rcpnt_doc`(`id`,`sysMsgEvtRcpntDefaultConfigId`,`docTypeId`,`docGenOwnerMappingDef`,`docGenParamMapDef`)
VALUES(@sysmsgevtrcpntdocId+1,@sysmsgevtrcptdefaultconfId,@dydtdocumenttypeId+1,@msgscopeparamId,'[{\"MSG_PARAM\":\"CONTEXT_RECORD_ID\",\"DOC_GEN_PARAM\":\"PRM_STUDENT_ID\"}]');

-- Start : Mapping of Dynamic Document to MsgTemplate

SET @msgtemplateconfigdocId=(SELECT MAX(id) FROM `msg_template_config_doc`);
INSERT INTO `msg_template_config_doc` (`id`,`msgTemplateconfigId`, `sysMsgEvtRcpntdocId`) VALUES (@msgtemplateconfigdocId+1,@msgtemplateconfigId,@sysmsgevtrcpntdocId+1);

-- End : Mapping of Dynamic Document to Msgtemplate

SET @dydtdataproviderId=(SELECT MAX(id) FROM `dydt_data_provider`);
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'Registration Amendment Letter Dynamic Document', '1');


SET @dydtdocumentdataproviderId=(SELECT MAX(id) FROM `dydt_document_data_provider`);
INSERT INTO `dydt_document_data_provider` (`id`,`dataProviderId`, `documentTypeId`) VALUES (@dydtdocumentdataproviderId+1,@dydtdataproviderId+1, @dydtdocumenttypeId+1);


SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
INSERT INTO dydt_data_line_item 
(id, dataProviderId, dataSourceCode, executionOrder, publishAsParametersDef, 
 whetherDataSource, whetherPrimaryDataSource, sqlSelectQueryDef, whereClauseBindingDef, 
 resultColumnsDef, sqlWhereQueryDef, whetherMultiRecord)
VALUES (
  @dydtdatalinitemId+1, 
  @dydtdataproviderId+1, 
  'REGISTRATION_AMENDMENT_AUTHORIZATION_INFO', 
  '1',
  null,
  '1', 
  '1',
  "SELECT DISTINCT
    T3.userId AS ID,
    T17.printName AS APP_USERNAME,
    T18.firstName AS APP_FIRST_NAME,
    T18.middleName AS APP_MIDDLE_NAME,
    T18.lastName AS APP_LAST_NAME,
    g.itemValue AS APP_GENDER,
    T18.emailId AS APP_EMAIL_ID,
    T18.alternateEmailId AS APP_ALTERNATE_EMAIL_ID,
    T18.birthDate AS APP_DATE_OF_BIRTH,
    T18.alternateMobileNo AS APP_ALTERNATE_MO_NO,
    T18.mobileNumber AS APP_MOBILE_NO,
    T18.mobileCountryCode AS APP_MOBILE_CODE,
    CONVERT( FROM_BASE64(T17.passwordBase64) USING UTF8) AS APP_PASSWORD,
    T5.programNameToBePrint AS APP_PROGRAM_NAME,
    T4.printName AS APP_INTAKE_NAME,
    T6.printName AS APP_PERIOD_NAME,
    T17.code AS APP_STUDENT_ID,
    T15.itemValue AS APP_ACADEMIC_TERM,
    T16.itemValue AS APP_INTAKE_YEAR,
    T20.itemValue AS APP_MODE_OF_DELIVERY,
	if(T4.batchPartTime = TRUE, 'Part Time' 'Full Time') AS APP_REGISTRATION_TYPE,
    T4.startDate AS APP_INTAKE_START_DATE,
    T4.tillDate AS APP_INTAKE_END_DATE,
    T7.academyName AS APP_ACADEMY_NAME,
    T7.locationName AS APP_LOCATION_NAME,
    T7.displayName AS APP_ACADEMY_LOCATION,
    T14.seatName AS APP_SEAT_TYPE,
    T9.phoneCountryCode AS APP_PHONE_COUNTRY_CODE,
    T9.phoneAreaCode AS APP_PHONE_AREA_CODE,
    T9.phoneNo AS APP_PHONE_NO,
    T9.primaryeEmailId AS APP_CAMPUS_EMAILID,
    addr.websiteURL AS APP_CAMPUS_WEBSITE_URL,
    stdaddr.addressText AS APP_STD_ADDRESS,
    T18.nationalID as APP_NATIONAL_ID,
    T22.idTypeName as APP_ID_TYPE,
    T21.salutationName AS APP_TITLE,
    T39.itemValue AS APP_CAST_CATEGORY,
    T23.itemValue AS APP_NATIONALITY,
    T26.value AS APP_HOME_LANGUAGE,
    T2.admissionDate AS APP_ADMISSION_DATE,
	T29.addressText AS APP_CURRENT_ADDRESS,
    T36.countryName AS APP_COUNTRY_NAME_STUDENT,
    T37.countryRegionName AS APP_COUNTRY_REGION_STUDENT,
    T38.cityName AS APP_CITY_STUDENT,
    T29.pincode AS APP_POSTAL_CODE,
	pt.name AS APP_PAYMENT_TERM,
 T1.requestReceivedDate AS APP_REQUEST_RECEIVED_DATE,
    (select itemValue from student_course_enrollment scen join exam_center_csm eccsm on eccsm.id=scen.examCenterId where scen.examCenterId is not null and scen.admissionId=T2.id and scen.programBatchPeriodConfigId=T6.id order by scen.examCenterId desc limit 1 ) AS APP_EXAM_CENTER,
T18.externalSysRefOne AS SU_NUMBER,
    date(now()) as CURRENT_DATE_
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
        LEFT OUTER JOIN
    academy_location T7 ON T7.id = T5.academyLocationId
		LEFT OUTER JOIN
	academy_location_addresses ala on ala.academyLocationId = T7.id
		LEFT OUTER JOIN
    address addr ON addr.id = ala.addressId 
        LEFT OUTER JOIN
    locations T19 ON T19.id = T7.locationId
        LEFT OUTER JOIN
    location_addresses T8 ON T8.locationId = T19.id
        LEFT JOIN
    address T9 ON T9.id = T8.addressId
        LEFT OUTER JOIN
    city T10 ON T10.id = T9.cityId
        LEFT OUTER JOIN
    country T11 ON T11.id = T10.countryId
        LEFT OUTER JOIN
    country_region T12 ON T12.id = T10.countryRegionId
        LEFT OUTER JOIN
    prog_batch_seat_config T13 ON T13.id = T1.progBatchSeatConfigId
        LEFT OUTER JOIN
    seat_types T14 ON T14.id = T13.seatTypeId
        LEFT OUTER JOIN
    academic_term T15 ON T15.id = T6.academicTermId
        LEFT OUTER JOIN
    intake_year T16 ON T16.id = T4.intakeYearId
        LEFT OUTER JOIN
    users T17 ON T17.id = T3.userId
        LEFT OUTER JOIN
    persons T18 ON T18.id = T3.personId
   LEFT OUTER JOIN gender g ON g.id = T18.genderId
        LEFT OUTER JOIN
    person_addresses pa ON T18.id = pa.personId
		AND pa.whetherPrimary = TRUE
        LEFT OUTER JOIN
    address stdaddr ON pa.addressId = stdaddr.id
        LEFT JOIN
    mode_of_delivery T20 ON T20.id = T4.modeOfDeliveryId
       LEFT OUTER JOIN 
    caste_categories T39 on T39.id = T18.castCategoryId
       LEFT OUTER JOIN 
	salutations T21 ON T21.id = T18.salutationId
       Left outer join 
    id_type T22 on T22.id= T18.idTypeId
         Left outer join 
    nationalities T23 on T23.id = T18.nationalityId
		 Left outer join 
    drop_down T26 on T26.id = T18.homeLanguage
         LEFT OUTER JOIN 
    person_addresses T27 on T27.personId = T18.id
         LEFT OUTER JOIN 
    address_type T28 on T28.id = T27.addressTypeId and T28.code = 'CRNT' and T28.addressCategory = 'PERSON'
         LEFT OUTER JOIN 
    address T29 on T29.id = T27.addressId
		 LEFT OUTER JOIN
    city T38 ON T38.id = T29.cityId
         LEFT OUTER JOIN
    country_region T37 ON T37.id = T38.countryRegionId
        LEFT OUTER JOIN
    country T36 ON T36.id = T37.countryId
   left outer join payment_term pt on pt.id = T1.paymentTermId
LEFT OUTER JOIN
    fee_payer_detail T45 ON T45.personId = T18.id",
    'CONTEXT_RECORD_ID',
   'APP_USERNAME,APP_FIRST_NAME,APP_MIDDLE_NAME,APP_LAST_NAME,APP_EMAIL_ID,
   APP_MOBILE_NO,APP_HOME_ADDRESS,APP_CITY,APP_STATE,APP_COUNTRY,APP_DOB,
   APP_GENDER,APP_NATIONAL_ID,APP_ID_TYPE,APP_TITLE,APP_CAST_CATEGORY,
   APP_NATIONALITY,APP_HOME_LANGUAGE,APP_ADMISSION_DATE,APP_CURRENT_ADDRESS,
   APP_COUNTRY_NAME_STUDENT,APP_COUNTRY_REGION_STUDENT,APP_CITY_STUDENT,
   APP_POSTAL_CODE,APP_PAYMENT_TERM',
    'WHERE T45.personId=PRM_STUDENT_ID 
     AND T1.isCurrentPeriod=true 
     AND T1.isCurrentSection=true 
     AND T1.exitDate IS NULL 
   GROUP BY T3.userId',
  '0'
);

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_USERNAME', 'Username',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_FIRST_NAME', 'Student First Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_MIDDLE_NAME', 'Student Middle Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_LAST_NAME', 'Student Last Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_PASSWORD', 'Password',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_EMAIL_ID', 'Email Id',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_MOBILE_NO', 'Mobile No',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_MOBILE_CODE', 'Mobile Code',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_PROGRAM_NAME', 'Program Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_INTAKE_NAME', 'Intake Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_PERIOD_NAME', 'Period Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_STUDENT_ID', 'Student ID',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_ACADEMIC_TERM', 'Academic Term',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_INTAKE_YEAR', 'Intake Year',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_MODE_OF_DELIVERY', 'Mode of Delivery',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_REGISTRATION_TYPE', 'Registration Type',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_INTAKE_START_DATE', 'Intake Start Date',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_INTAKE_END_DATE', 'Intake End Date',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_ACADEMY_NAME', 'Academy Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_LOCATION_NAME', 'Location Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_ACADEMY_LOCATION', 'Academy Location',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_SEAT_TYPE', 'Seat Type',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_PHONE_COUNTRY_CODE', 'Country code',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_PHONE_AREA_CODE', 'Phone Area Code',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_PHONE_NO', 'Phone No',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_CAMPUS_EMAILID', 'Campus Email Id',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_CAMPUS_WEBSITE_URL', 'Website',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_STD_ADDRESS', 'Student Address',@dydtdatalinitemId+1);



INSERT INTO `dydt_template_conf` (`id`, `documentTypeId`, `templateName`, `templateType`, `whetherDefault`,`templateContent`)
VALUES (@dydtTemplateconfId+1, @dydtdocumenttypeId+1, 'Registration Amendment – Fee Payer Notification Template', 'HTMLTEMPLATE', '0',
'<html>
<body bgcolor="silver">

<p>Date: $date.get(&quot;d MMMM, y&quot;)</p>

<p>&nbsp;</p>

<p> Dear $DATA.APP_FIRST_NAME&nbsp;$DATA.APP_MIDDLE_NAME&nbsp;$DATA.APP_LAST_NAME</p>

<p>&nbsp;</p>

<p>$DATA.APP_EMAIL_ID</p>

<p>$DATA.APP_MOBILE_NO</p>

<p>$DATA.APP_USERNAME</p>

<p>$DATA.APP_PASSWORD</p>

<p>&nbsp;</p>

<p>Dear &nbsp;$DATA.APP_PROGRAM_NAME &nbsp;$DATA.APP_INTAKE_NAME</p>

<p>$DATA.APP_PERIOD_NAME</p>

--<p style="margin-bottom: 0cm; line-height: 100%">$DATA.APP_ACADEMY_LOCATION</p>

</body>
</html>');
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REGISTRATION_AMENDMENT_FEEPAYER_DL');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT DISTINCT
    T3.personId AS USER_ID,
    T7.id AS DLS_PROGRAM_BATCH_SEAT_CONFIG_ID
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
LEFT OUTER JOIN
	prog_batch_seat_config T7 on T7.id = T1.progBatchSeatConfigId
WHERE T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null
AND T2.id in(namedParams);'
WHERE
    dataproviderid = @dtproviderId;
 END IF;

END $$
CALL V20250916105244__Insert_DynamicDocFeePayer() $$
DROP PROCEDURE IF EXISTS V20250916105244__Insert_DynamicDocFeePayer $$
DELIMITER ;