DELIMITER $$
DROP PROCEDURE IF EXISTS V20251001125017__Create_EnquiryFormSetupDefaultAL $$
CREATE PROCEDURE V20251001125017__Create_EnquiryFormSetupDefaultAL()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='enquiry_form_setup_default_al')) THEN 
CREATE TABLE `enquiry_form_setup_default_al` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`academyLocationId` BIGINT(20) NOT NULL,  
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	CONSTRAINT `enquiry_form_setup_default_al_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);
END IF;


SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'enquiry_form_setup_default_al')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'enquiry_form_setup_default_al','ENQUIRY_FORM_SETUP_DEFAULT_ACADEMY_LOCATION','Pre Admissions','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;


IF  EXISTS ((SELECT * FROM standard_master WHERE tableName = 'enquiry_form_setup_default_al')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'enquiry_form_setup_default_al');
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='academyLocationId')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('academyLocationId','ACADEMY_LOCATION',@standardMasterId,'Varchar',NULL,1,1,'academy_location','id','academyLocationName',0,0,0,NULL,NULL,NULL,1,now());
END IF;
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'ENQUIRY_FORM_SETUP_DEFAULT_ACADEMY_LOCATION')) THEN 
		INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
		VALUES ('masterNames', 'ENQUIRY_FORM_SETUP_DEFAULT_ACADEMY_LOCATION', 'Enquiry Form Setup Default Academy Location', 'Enquiry Form Setup Default Academy Location','Opstelling van Navraagvorm Standaard Akademieligging','Thiết lập biểu mẫu yêu cầu Vị trí học viện mặc định',now(),1);
	END IF;
END $$	
CALL V20251001125017__Create_EnquiryFormSetupDefaultAL () $$ 
DROP PROCEDURE IF EXISTS V20251001125017__Create_EnquiryFormSetupDefaultAL $$ 
DELIMITER ;