DELIMITER $$
DROP PROCEDURE IF EXISTS V20251003125924__Create_ModifyApplicationStatusCSM $$
CREATE PROCEDURE V20251003125924__Create_ModifyApplicationStatusCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='modify_application_status')) THEN 
CREATE TABLE `modify_application_status` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `allowApplicationStatusUpdate` VARCHAR(255) NOT NULL,
	`whetherEnabled` BIT(1) NOT NULL DEFAULT b'1',
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'modify_application_status')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'modify_application_status','MODIFY_APPLICATION_STATUS','Admissions','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;

IF  EXISTS ((select * from standard_master where tableName = 'modify_application_status')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'modify_application_status');
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='ALLOW_APPLICATION_STATUS_UPDATE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('allowApplicationStatusUpdate','ALLOW_APPLICATION_STATUS_UPDATE',@standardMasterId,'varchar','NULL',1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='WHETHER_ENABLED')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('whetherEnabled','WHETHER_ENABLED',@standardMasterId,'boolean',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
END IF;

INSERT INTO modify_application_status (allowApplicationStatusUpdate, whetherEnabled, lastUpdate, lastUpdatedBy)  VALUES ('Submitted To Approved',true,now(),1);
INSERT INTO modify_application_status (allowApplicationStatusUpdate, whetherEnabled, lastUpdate, lastUpdatedBy)  VALUES ('Submitted To Rejected',true,now(),1);
INSERT INTO modify_application_status (allowApplicationStatusUpdate, whetherEnabled, lastUpdate, lastUpdatedBy)  VALUES ('Submitted To Withdrawn',true,now(),1);

INSERT INTO modify_application_status (allowApplicationStatusUpdate, whetherEnabled, lastUpdate, lastUpdatedBy)  VALUES ('Approved To Rejected',true,now(),1);
INSERT INTO modify_application_status (allowApplicationStatusUpdate, whetherEnabled, lastUpdate, lastUpdatedBy)  VALUES ('Approved To Submitted',true,now(),1);
INSERT INTO modify_application_status (allowApplicationStatusUpdate, whetherEnabled, lastUpdate, lastUpdatedBy)  VALUES ('Approved To Withdrawn',true,now(),1);

INSERT INTO modify_application_status (allowApplicationStatusUpdate, whetherEnabled, lastUpdate, lastUpdatedBy)  VALUES ('Rejected To Submitted',true,now(),1);
INSERT INTO modify_application_status (allowApplicationStatusUpdate, whetherEnabled, lastUpdate, lastUpdatedBy)  VALUES ('Rejected To Approved',true,now(),1);
INSERT INTO modify_application_status (allowApplicationStatusUpdate, whetherEnabled, lastUpdate, lastUpdatedBy)  VALUES ('Withdrawn To Submitted',true,now(),1);

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='MODIFY_APPLICATION_STATUS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames','MODIFY_APPLICATION_STATUS','Modify Application Status','Modify Application Status','Verander aansoekstatus','Sửa đổi trạng thái ứng dụng',now(),1);     
END IF;
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' AND keyName = 'ALLOW_APPLICATION_STATUS_UPDATE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'ALLOW_APPLICATION_STATUS_UPDATE', 'Allow Application Status Update', 'Allow Application Status Update','Laat aansoekstatusopdatering toe','Cho phép cập nhật trạng thái ứng dụng',now(),1);
END IF; 

END $$
CALL V20251003125924__Create_ModifyApplicationStatusCSM () $$ 
DROP PROCEDURE IF EXISTS V20251003125924__Create_ModifyApplicationStatusCSM $$ 
DELIMITER ;