DELIMITER $$
DROP PROCEDURE IF EXISTS V20251006193212__Create_SecondGradeUItrans $$
CREATE PROCEDURE V20251006193212__Create_SecondGradeUItrans()
BEGIN

IF NOT EXISTS (
    SELECT * FROM `ui_translation` 
    WHERE objectName = 'EXAMINATION' 
      AND keyName = 'SECONDARY_GRADE_POINT'
) THEN
    INSERT INTO `ui_translation` (
        `objectName`, 
        `keyName`, 
        `defaultValue`, 
        `customerDefineValue`,
        `lastUpdate`,
        `lastUpdatedBy`
    )
    VALUES (
        'EXAMINATION', 
        'SECONDARY_GRADE_POINT', 
        'Secondary Grade Point', 
        'Secondary Grade Point', 
        NOW(), 
        1
    );
END IF;

IF NOT EXISTS (
    SELECT 1 
    FROM ui_translation 
    WHERE objectName = 'TRANSLATIONS' 
      AND keyName = 'WHETHER_SECONDARY_GRADE'
) THEN
    INSERT INTO `ui_translation` 
    (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `lastUpdate`, `lastUpdatedBy`) 
    VALUES 
    ('TRANSLATIONS', 'WHETHER_SECONDARY_GRADE', 'Whether Secondary Grade', 'Whether Secondary Grade', NOW(), 1);
END IF;

END $$
CALL V20251006193212__Create_SecondGradeUItrans () $$ 
DROP PROCEDURE IF EXISTS V20251006193212__Create_SecondGradeUItrans $$ 
DELIMITER ;