DELIMITER $$
DROP PROCEDURE IF EXISTS V20251013094511__Update_Academy_Location_Transfer_Conf $$
CREATE PROCEDURE V20251013094511__Update_Academy_Location_Transfer_Conf()
BEGIN
    SET SQL_SAFE_UPDATES = 0;
    
    IF EXISTS (SELECT MAX(id) FROM dtprovider WHERE dataProviderName = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_RCPNT') THEN 
        SET @dtproviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_RCPNT');
        IF EXISTS (SELECT id FROM sql_dtprovider WHERE dataProviderId = @dtproviderId) THEN
            UPDATE sql_dtprovider SET 
                sqlQuery = 'SELECT 
                    T7.id AS ID,
                    T9.`displayName` AS ACADEMY_NAME,
                    T7.`printName` AS FATHER_NAME,
                    T7.`firstName` AS FIRST_NAME,
                    T7.`middleName` AS MIDDLE_NAME,
                    T7.`lastName` AS LAST_NAME,
                    T7.`emailId` AS EMAIL_ID,
                    T7.`mobileNumber` AS MOBILE_NO,
                    T3.`printName` AS STUDENT_PRINT_NAME
                FROM
                    students T1
                    LEFT JOIN users T8 ON T1.userId = T8.id
                    LEFT JOIN persons T3 ON T3.id = T1.personId
                    LEFT JOIN admission a ON a.studentId = T8.id
                    LEFT JOIN student_transfer_request_details STRD ON STRD.fromAdmissionId = a.id
                    LEFT JOIN academy_location T9 ON T9.id = STRD.fromALId
                    LEFT JOIN person_relationships T5 ON T3.id = T5.personId
                    LEFT JOIN persons T7 ON T5.relatedPersonId = T7.id
                WHERE
                    T7.id IN (namedParams)
                    AND T5.relationship = ''FATHER''
                    AND T5.whetherDeleted = FALSE
                GROUP BY T1.userId;',
                jsonString = '{
                    "id": 1,
                    "searchResultViewColumns": [
                        {
                            "id": 1,
                            "value": "ACADEMYNAME",
                            "resultKey": "ACADEMY_NAME",
                            "displayCode": "",
                            "displayOrder": 0
                        },
                        {
                            "id": 2,
                            "value": "Email Id",
                            "resultKey": "EMAIL_ID",
                            "displayCode": "",
                            "displayOrder": 1
                        },
                        {
                            "id": 3,
                            "value": "Mobile No",
                            "resultKey": "MOBILE_NO",
                            "displayCode": "",
                            "displayOrder": 2
                        },
                        {
                            "id": 4,
                            "value": "Father Name",
                            "resultKey": "FATHER_NAME",
                            "displayCode": "",
                            "displayOrder": 3
                        },
                        {
                            "id": 5,
                            "value": "First Name",
                            "resultKey": "FIRST_NAME",
                            "displayCode": "",
                            "displayOrder": 4
                        },
                        {
                            "id": 6,
                            "value": "Middle Name",
                            "resultKey": "MIDDLE_NAME",
                            "displayCode": "",
                            "displayOrder": 5
                        },
                        {
                            "id": 7,
                            "value": "Last Name",
                            "resultKey": "LAST_NAME",
                            "displayCode": "",
                            "displayOrder": 6
                        },
                        {
                            "id": 8,
                            "value": "Student Print Name",
                            "resultKey": "STUDENT_PRINT_NAME",
                            "displayCode": "",
                            "displayOrder": 7
                        }
                    ]
                }'
            WHERE dataProviderId = @dtproviderId;     
        END IF;
    END IF;
    
    IF EXISTS (SELECT MAX(id) FROM dtprovider WHERE dataProviderName = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_RCPNT') THEN 
        SET @dtproviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_RCPNT');
        IF EXISTS (SELECT id FROM sql_dtprovider WHERE dataProviderId = @dtproviderId) THEN
            UPDATE sql_dtprovider SET 
                sqlQuery = 'SELECT 
                    T1.id AS ID,
                    T9.`displayName` AS ACADEMY_NAME,
                    T7.`printName` AS MOTHER_NAME,
                    T7.`firstName` AS FIRST_NAME,
                    T7.`middleName` AS MIDDLE_NAME,
                    T7.`lastName` AS LAST_NAME,
                    T7.`emailId` AS EMAIL_ID,
                    T7.`mobileNumber` AS MOBILE_NO,
                    T3.`printName` AS STUDENT_PRINT_NAME
                FROM
                    students T1
                    LEFT JOIN users T8 ON T1.userId = T8.id
                    LEFT JOIN persons T3 ON T3.id = T1.personId
                    LEFT JOIN admission a ON a.studentId = T8.id
                    LEFT JOIN student_transfer_request_details STRD ON STRD.fromAdmissionId = a.id
                    LEFT JOIN academy_location T9 ON T9.id = STRD.fromALId
                    LEFT JOIN person_relationships T5 ON T3.id = T5.personId
                    LEFT JOIN persons T7 ON T5.relatedPersonId = T7.id
                WHERE
                    T7.id IN (namedParams)
                    AND T5.relationship = ''MOTHER''
                    AND T5.whetherDeleted = FALSE
                GROUP BY T1.userId;',
                jsonString = '{
                    "id": 1,
                    "searchResultViewColumns": [
                        {
                            "id": 1,
                            "value": "ACADEMYNAME",
                            "resultKey": "ACADEMY_NAME",
                            "displayCode": "",
                            "displayOrder": 0
                        },
                        {
                            "id": 2,
                            "value": "Email Id",
                            "resultKey": "EMAIL_ID",
                            "displayCode": "",
                            "displayOrder": 1
                        },
                        {
                            "id": 3,
                            "value": "Mobile No",
                            "resultKey": "MOBILE_NO",
                            "displayCode": "",
                            "displayOrder": 2
                        },
                        {
                            "id": 4,
                            "value": "Mother Name",
                            "resultKey": "MOTHER_NAME",
                            "displayCode": "",
                            "displayOrder": 3
                        },
                        {
                            "id": 5,
                            "value": "First Name",
                            "resultKey": "FIRST_NAME",
                            "displayCode": "",
                            "displayOrder": 4
                        },
                        {
                            "id": 6,
                            "value": "Middle Name",
                            "resultKey": "MIDDLE_NAME",
                            "displayCode": "",
                            "displayOrder": 5
                        },
                        {
                            "id": 7,
                            "value": "Last Name",
                            "resultKey": "LAST_NAME",
                            "displayCode": "",
                            "displayOrder": 6
                        },
                        {
                            "id": 8,
                            "value": "Student Print Name",
                            "resultKey": "STUDENT_PRINT_NAME",
                            "displayCode": "",
                            "displayOrder": 7
                        }
                    ]
                }'
            WHERE dataProviderId = @dtproviderId;
        END IF;
    END IF;
    
    IF EXISTS (SELECT MAX(id) FROM dtprovider WHERE dataProviderName = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_RCPNT') THEN 
        SET @dtproviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_RCPNT');
        IF EXISTS (SELECT id FROM sql_dtprovider WHERE dataProviderId = @dtproviderId) THEN
            UPDATE sql_dtprovider SET 
                sqlQuery = 'SELECT 
                    T1.userId AS ID,
                    T9.`displayName` AS ACADEMY_NAME,
                    fpd.`feePayerPrintName` AS FEE_PAYER_NAME,
                    fpd.`firstName` AS FIRST_NAME,
                    fpd.`middleName` AS MIDDLE_NAME,
                    fpd.`lastName` AS LAST_NAME,
                    fpd.`mobileNumber` AS MOBILE_NO,
                    fpd.`emailHome` AS EMAIL_ID,
                    T3.`printName` AS STUDENT_PRINT_NAME
                FROM
                    students T1
                    LEFT JOIN users T8 ON T1.userId = T8.id
                    LEFT JOIN persons T3 ON T3.id = T1.personId
                    LEFT JOIN admission a ON a.studentId = T8.id
                    LEFT JOIN student_transfer_request_details STRD ON STRD.fromAdmissionId = a.id
                    LEFT JOIN academy_location T9 ON T9.id = STRD.fromALId
                    LEFT JOIN fee_payer_detail fpd ON fpd.personId = T3.id
                WHERE
                    T8.id IN (namedParams) 
                    AND fpd.isPrimaryFeePayer = true
                GROUP BY T1.userId;',
                jsonString = '{
                    "id": 1,
                    "searchResultViewColumns": [
                        {
                            "id": 1,
                            "value": "ACADEMYNAME",
                            "resultKey": "ACADEMY_NAME",
                            "displayCode": "",
                            "displayOrder": 0
                        },
                        {
                            "id": 2,
                            "value": "Email Id",
                            "resultKey": "EMAIL_ID",
                            "displayCode": "",
                            "displayOrder": 1
                        },
                        {
                            "id": 3,
                            "value": "Mobile No",
                            "resultKey": "MOBILE_NO",
                            "displayCode": "",
                            "displayOrder": 2
                        },
                        {
                            "id": 4,
                            "value": "Fee Payer Name",
                            "resultKey": "FEE_PAYER_NAME",
                            "displayCode": "",
                            "displayOrder": 3
                        },
                        {
                            "id": 5,
                            "value": "First Name",
                            "resultKey": "FIRST_NAME",
                            "displayCode": "",
                            "displayOrder": 4
                        },
                        {
                            "id": 6,
                            "value": "Middle Name",
                            "resultKey": "MIDDLE_NAME",
                            "displayCode": "",
                            "displayOrder": 5
                        },
                        {
                            "id": 7,
                            "value": "Last Name",
                            "resultKey": "LAST_NAME",
                            "displayCode": "",
                            "displayOrder": 6
                        },
                        {
                            "id": 8,
                            "value": "Student Print Name",
                            "resultKey": "STUDENT_PRINT_NAME",
                            "displayCode": "",
                            "displayOrder": 7
                        }
                    ]
                }'
            WHERE dataProviderId = @dtproviderId;       
        END IF;
    END IF; 
    
    SET SQL_SAFE_UPDATES = 1;
END $$
CALL V20251013094511__Update_Academy_Location_Transfer_Conf() $$
DROP PROCEDURE IF EXISTS V20251013094511__Update_Academy_Location_Transfer_Conf $$
DELIMITER ;