DELIMITER $$
DROP PROCEDURE IF EXISTS V20251103110541__Update_EmnDataProviderOfPostNumber $$
CREATE PROCEDURE V20251103110541__Update_EmnDataProviderOfPostNumber()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT id FROM dydt_data_line_item where dataSourceCode='APPLICATION_INFO' and whereClauseBindingDef='PRM_APPLICATION_ID' and sqlWhereQueryDef='WHERE a.id=PRM_APPLICATION_ID')) THEN 
UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef` = 'SELECT ap.firstName AS applicant_firstname, \nap.lastName AS applicant_lastname, \nap.middleName AS applicant_middlename,\n g.itemValue AS applicant_gender, \n ap.printName AS applicant_printname, \n a.code AS application_code, \n s.salutationName AS applicant_salutation,\n ap.birthDate AS birth_date,  \n ap.photoUrl AS app_photo_url,\n ahr.whetherHostelApplicable AS Hostel_Applicable, \n ml.itemValue AS correspondance_language,\n ca.itemValue AS current_activity, \n s.salutationNameInOtherLanguage AS applicant_salutation_otr_lang,\n ap.nationalID AS ap_nationalID,\n ap.emailId AS ap_primary_email_id, \n applicant_other_information_cd.cf1 AS customfield_1, \n applicant_other_information_cd.cf2 AS customfield_2, \n applicant_other_information_cd.cf3 AS customfield_3,\n applicant_other_information_cd.cf4 AS customfield_4, \n applicant_other_information_cd.cf5 AS customfield_5, \n applicant_other_information_cd.cf6 AS customfield_6, \n applicant_other_information_cd.cf7 AS customfield_7, \n aprel_father.mobileCountryCode AS father_mobileCountryCode, \n aprel_father.mobileNumber AS father_mobileNumber, \n aprel_father.emailId AS father_emailId, \n aprel_guardian.mobileCountryCode AS guardian_mobileCountryCode, \n aprel_guardian.mobileNumber AS guardian_mobileNumber, \n aprel_guardian.emailId AS guardian_emailId, \n ap.initials AS student_id, \n ap.birth_place AS birth_place, \n ap.birth_place_language AS birth_place_language, \n nationalities.itemValue AS nationalitie,\n ap.entryRoute AS entry_route,\n ap.englishProficiency AS english_proficiency,\n ap.motivation AS motivation,\n ecs.itemValue as ProgramMajor,\n cc.itemValue as  AdmissionAcademicTerm,\n atcc.programDuration as Program_Duration,\n atcc.expectedCompletionDate as Expected_Completion_Date,\n atcc.exemptedCredit as Exempted_Credit,\n ap.category as category,\n ap.postNumber as postNumber,\n ap.personalIncome as personalIncome,\n GROUP_CONCAT(DISTINCT c.courseCode ORDER BY c.courseCode SEPARATOR \', \') AS Course_Code\n FROM application a \n LEFT JOIN applicant_person ap ON a.applicantPersonId = ap.id \n LEFT JOIN applicant_hostel_requirement ahr ON ahr.applicantPersonId = ap.id \n LEFT JOIN salutations s ON ap.salutationId = s.id \n LEFT JOIN current_activity ca ON ca.id = ap.current_activity_id \n LEFT JOIN gender g ON g.id = ap.genderId \n LEFT JOIN multi_language ml ON ml.id = ap.correspondence_language \n LEFT JOIN applicant_other_information ON applicant_other_information.applicantPersonId = ap.id \n LEFT JOIN applicant_other_information_cd ON applicant_other_information.id = applicant_other_information_cd.applicantOtherInfoId \n LEFT JOIN applicant_person_relationships AS aprf ON ap.id = aprf.applicantPersonId AND aprf.relationship = \'FATHER\' \n LEFT JOIN applicant_person_relationships AS aprg ON ap.id = aprg.applicantPersonId AND aprg.relationship = \'GUARDIAN\' \n LEFT JOIN applicant_person AS aprel_father ON aprel_father.id = aprf.relatedApplicantPersonId \n LEFT JOIN applicant_person AS aprel_guardian ON aprel_guardian.id = aprg.relatedApplicantPersonId \n LEFT JOIN nationalities AS nationalities ON nationalities.id = ap.nationalityId\n LEFT JOIN exam_center_csm ecs on ecs.id=ap.exam_center_csm_id\n LEFT JOIN caste_categories cc on cc.id=ap.casteCategoryId\n LEFT JOIN applicant_transfer_credit_request atcr ON atcr.applicantId=a.id\n LEFT JOIN applicant_transfer_credit_completion atcc ON atcc.applicantId=a.id\n LEFT JOIN courses c on c.id=atcr.courseId and atcr.status=\'APPROVE\'',`resultColumnsDef` = 'applicant_firstname,applicant_lastname,applicant_middlename,applicant_gender,applicant_printname,\napplication_code,applicant_salutation,birth_date,app_photo_url,Hostel_Applicable,correspondance_language,current_activity,\napplicant_salutation_otr_lang,ap_nationalID,ap_primary_email_id,customfield_1,customfield_2,customfield_3,customfield_4,\ncustomfield_5,customfield_6,customfield_7,father_mobileCountryCode,father_mobileNumber,father_emailId,\nguardian_mobileCountryCode,guardian_mobileNumber,guardian_mobileNumber,guardian_emailId,student_id,birth_place,\nbirth_place_language,nationalitie,entry_route,english_proficiency,motivation,ProgramMajor,AdmissionAcademicTerm,\nProgram_Duration,Exempted_Credit,Expected_Completion_Date,Course_Code,category,postNumber,personalIncome'  where dataSourceCode='APPLICATION_INFO' and whereClauseBindingDef='PRM_APPLICATION_ID' and sqlWhereQueryDef='WHERE a.id=PRM_APPLICATION_ID';
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251103110541__Update_EmnDataProviderOfPostNumber () $$
DROP PROCEDURE IF EXISTS V20251103110541__Update_EmnDataProviderOfPostNumber $$
DELIMITER ;