DELIMITER $$
DROP PROCEDURE IF EXISTS netsuiteFetchReceiptToBePushed $$
CREATE PROCEDURE netsuiteFetchReceiptToBePushed()
BEGIN

SELECT 

SUM(UNIX_TIMESTAMP(rh.lastUpdate) * 1000) + SUM(UNIX_TIMESTAMP(bh.lastUpdate) * 1000) + rh.id + bh.id AS id,
rh.receiptNo AS externalid, #receiptNo
rh.id AS receiptId,	#receiptId
bh.billNo AS billNo, 	    #billNo
bh.id AS billId, 	    #billId
u.code AS student,		#studentCode
rh.studentId AS studentId,		#studentId
SUBSTRING_INDEX(bdm.bankName, '_', 1) AS account,
rh.transactionDate AS date,
rh.narration AS memo,
'Sharjah HO Store' AS warehouse,
# 'DUBAI BATCH 11' AS batch,
b.batchName AS batch,
# 'ABS MBA AI UAE' AS course,
p.programName AS course,
# 'QATAR' AS studyLocation,
st.seatNameOtherLanguage AS studyLocation,
bh.billNo AS doc,     #billNo
true AS applyTrue,	#always true
sum(fad.adjustedAmount) AS amount	#receipt amount

from receipt_header rh
left join receipt_payment_instrument rpi on rpi.receiptHeaderId=rh.id
left join bank_drawn_on_master bdm on rpi.instrumentBank=bdm.id
inner join fee_adjustment_master fam on rh.id=fam.receiptHeaderId
inner join fee_adjustment_details fad on fam.id=fad.adjustmentMasterId
left join bill_header bh on fad.billHeaderId=bh.id
left join users u on rh.studentId = u.id
left join prog_batch_seat_config pbsc on bh.programBatchSeatConfigId=pbsc.id
left join batches b on pbsc.programBatchId=b.id
left join programs p on b.programId=p.id
left join seat_types st on pbsc.seatTypeId=st.id
inner join netsuite_create_customer_mapping nccm on u.id=nccm.academiaUserId
inner join netsuite_create_invoice_mapping ncim on bh.id=ncim.billHeaderId
left join netsuite_create_receipt_mapping ncrm on rh.id=ncrm.receiptHeaderId
 
 where ncrm.receiptHeaderId is null
 # and rh.id=28257  
 
GROUP BY 
    rh.id, bh.id;



END $$ 
DELIMITER ;