DELIMITER $$
DROP PROCEDURE IF EXISTS V20251127155222__Create_FreeFormRequestSportsDetials $$
CREATE PROCEDURE V20251127155222__Create_FreeFormRequestSportsDetials()
BEGIN

IF NOT EXISTS ((SELECT  *  FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = 'free_form_request_sports_details')) THEN 
CREATE TABLE free_form_request_sports_details (
    id BIGINT NOT NULL AUTO_INCREMENT,
    requestDetailId BIGINT NOT NULL,            -- FK to free_form_request_details.id
    sportsTypeId BIGINT NOT NULL,               -- FK to CSM_SPORTS_TYPES
    positionPlayed VARCHAR(255) NULL,           -- Free text
    tShirtSizeId BIGINT NULL,                   -- FK to CSM_TSHIRT_SIZE
    lastUpdatedBy BIGINT(20) NULL,
	lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    
    CONSTRAINT fk_ffrsd_request_detail
        FOREIGN KEY (requestDetailId)
        REFERENCES free_form_request_details(id)
        ON DELETE CASCADE,
        
	CONSTRAINT fk_ffrsd_sports_type
            FOREIGN KEY (sportsTypeId)
            REFERENCES csm_sports_types(id),

	CONSTRAINT fk_ffrsd_tshirt_size
            FOREIGN KEY (tShirtSizeId)
            REFERENCES csm_tshirt_size(id)
);
END IF; 

END $$
CALL V20251127155222__Create_FreeFormRequestSportsDetials () $$ 
DROP PROCEDURE IF EXISTS V20251127155222__Create_FreeFormRequestSportsDetials $$ 
DELIMITER ;