DELIMITER $$
DROP PROCEDURE IF EXISTS V20251202143944__Update_EmailMarksheetRemoveCondition $$
CREATE PROCEDURE V20251202143944__Update_EmailMarksheetRemoveCondition()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_PROCEED_WITH_CONDITION_STATUS_RECIPIENT')) THEN 
SET @dtproviderRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_PROCEED_WITH_CONDITION_STATUS_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`=
"
       SELECT 
       examEvent.id AS ID,
       person.firstName AS FIRST_NAME,
       person.printName AS STUDENT_PRINT_NAME,
       person.lastName AS LAST_NAME,
	   person.emailId AS EMAIL_ID,
	   user.code AS STUDENT_ID,
	   program.programNameToBePrint AS PROGRAM_NAME,
       batch.printName AS BATCH_NAME,
	   period.printName AS PERIOD_NAME,
       location.academyName AS ACADEMY_NAME,
       location.locationName AS LOCATION_NAME,
       prStatus.itemCode as PROGRESSION_STATUS,
	   course.courseCode AS COURSE_CODE,
       course.courseName AS COURSE_NAME,
	   committee.progressionPanelStartDate AS PRINT_DATETIME,
	   marksheetJob.id as JOB_ID,
	   panel.remarks as REMARK,
       DATE_FORMAT(eventDetail.conductedDate, '%Y-%m-%d') AS ASSESSMENT_DATE,
       DATE_FORMAT(eventDetail.time, '%H:%i') AS CONDUCTED_TIME,
       'userGeneratedMsgContent' AS USER_GENERATED_MSG_CONTENT

FROM
 progression_panel_exam_event examEvent
           inner join 
		   progression_panel_decision_template panel on panel.id=examEvent.progressionPanelDecisionId
           inner join 
		   progression_status prStatus on panel.decisionId=prStatus.id
           inner join 
           marksheet_job_details marksheetJob on marksheetJob.id=examEvent.marksheetJobId
		   inner join 
           admission  adm on adm.id=panel.admissionId and adm.studentId=panel.studentId
	       inner join
		   users  user on user.id=adm.studentId
           inner join
		   students student on student.userId=user.id  
		   inner join
		   persons  person on person.id=student.personId
		   inner join 
		   academy_location location on location.id=adm.academyLocationId
		   inner join 
		   prog_batch_period_config period on period.id=panel.periodId
		   inner join
		   batches batch on batch.id=period.programBatchId
	       inner join 
		   programs program on program.id=batch.programId
           inner join 
           evaluation_plan_rank planRank on planRank.admissionId=panel.admissionId and planRank.periodId=panel.periodId
           inner join 
           course_variants cv on cv.id=planRank.courseVariantId 
           inner join 
           courses course on course.id=cv.courseId
		   inner join 
		   examination_result result  ON result.admissionId = panel.admissionId  AND result.periodId = panel.periodId    
		   AND result.courseVariantId = planRank.courseVariantId
           inner join 
           evaluation_type_course typeCourse   ON typeCourse.periodId = result.periodId   AND typeCourse.courseVariantId = result.courseVariantId  
           inner join 
           exam_event_detail eventDetail   ON eventDetail.eventId = result.evaluationDetailSequenceId AND typeCourse.id = eventDetail.evaluationTypeCourseId  
           inner join 
           eval_seq_detail mainEvent ON mainEvent.id = eventDetail.eventId 
           courses course on course.id=cv.courseId
           INNER JOIN 
           committee committee ON committee.id = panel.committeeId
   WHERE
           examEvent.id IN (namedParams) 
           group by course.id"
  
WHERE  dataProviderId =@dtproviderRCPNT;
END IF; 

IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_ACADEMIC_FAILURE_STATUS_RECIPIENT')) THEN 
SET @dtproviderRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_ACADEMIC_FAILURE_STATUS_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`=
"   SELECT 
       examEvent.id AS ID,
       person.firstName AS FIRST_NAME,
       person.printName AS STUDENT_PRINT_NAME,
       person.lastName AS LAST_NAME,
	   person.emailId AS EMAIL_ID,
	   user.code AS STUDENT_ID,
	   program.programNameToBePrint AS PROGRAM_NAME,
       batch.printName AS BATCH_NAME,
	   period.printName AS PERIOD_NAME,
       location.academyName AS ACADEMY_NAME,
       location.locationName AS LOCATION_NAME,
       prStatus.itemCode as PROGRESSION_STATUS,
	   course.courseCode AS COURSE_CODE,
       course.courseName AS COURSE_NAME,
	   committee.progressionPanelStartDate AS PRINT_DATETIME,
	   marksheetJob.id as JOB_ID,
	   panel.remarks as REMARK,
       DATE_FORMAT(eventDetail.conductedDate, '%Y-%m-%d') AS ASSESSMENT_DATE,
       DATE_FORMAT(eventDetail.time, '%H:%i') AS CONDUCTED_TIME,
       'userGeneratedMsgContent' AS USER_GENERATED_MSG_CONTENT

FROM
 progression_panel_exam_event examEvent
           inner join 
		   progression_panel_decision_template panel on panel.id=examEvent.progressionPanelDecisionId
           inner join 
		   progression_status prStatus on panel.decisionId=prStatus.id
           inner join 
           marksheet_job_details marksheetJob on marksheetJob.id=examEvent.marksheetJobId
		   inner join 
           admission  adm on adm.id=panel.admissionId and adm.studentId=panel.studentId
	       inner join
		   users  user on user.id=adm.studentId
           inner join
		   students student on student.userId=user.id  
		   inner join
		   persons  person on person.id=student.personId
		   inner join 
		   academy_location location on location.id=adm.academyLocationId
		   inner join 
		   prog_batch_period_config period on period.id=panel.periodId
		   inner join
		   batches batch on batch.id=period.programBatchId
	       inner join 
		   programs program on program.id=batch.programId
           inner join 
           evaluation_plan_rank planRank on planRank.admissionId=panel.admissionId and planRank.periodId=panel.periodId
           inner join 
           course_variants cv on cv.id=planRank.courseVariantId 
           inner join 
           courses course on course.id=cv.courseId
		   inner join 
		   examination_result result  ON result.admissionId = panel.admissionId  AND result.periodId = panel.periodId    
		   AND result.courseVariantId = planRank.courseVariantId
           inner join 
           evaluation_type_course typeCourse   ON typeCourse.periodId = result.periodId   AND typeCourse.courseVariantId = result.courseVariantId  
           inner join 
           exam_event_detail eventDetail   ON eventDetail.eventId = result.evaluationDetailSequenceId AND typeCourse.id = eventDetail.evaluationTypeCourseId  
           inner join 
           eval_seq_detail mainEvent ON mainEvent.id = eventDetail.eventId 
           courses course on course.id=cv.courseId
           INNER JOIN 
           committee committee ON committee.id = panel.committeeId
   WHERE
           examEvent.id IN (namedParams) 
           group by course.id"

WHERE  dataProviderId =@dtproviderRCPNT;
END IF; 

IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_RECIPIENT')) THEN 
SET @dtproviderRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`=
"   SELECT 
       examEvent.id AS ID,
       person.firstName AS FIRST_NAME,
       person.printName AS STUDENT_PRINT_NAME,
       person.lastName AS LAST_NAME,
	   person.emailId AS EMAIL_ID,
	   user.code AS STUDENT_ID,
	   program.programNameToBePrint AS PROGRAM_NAME,
       batch.printName AS BATCH_NAME,
	   period.printName AS PERIOD_NAME,
       location.academyName AS ACADEMY_NAME,
       location.locationName AS LOCATION_NAME,
       prStatus.itemCode as PROGRESSION_STATUS,
	   course.courseCode AS COURSE_CODE,
       course.courseName AS COURSE_NAME,
	   committee.progressionPanelStartDate AS PRINT_DATETIME,
	   marksheetJob.id as JOB_ID,
	   panel.remarks as REMARK,
       DATE_FORMAT(eventDetail.conductedDate, '%Y-%m-%d') AS ASSESSMENT_DATE,
       DATE_FORMAT(eventDetail.time, '%H:%i') AS CONDUCTED_TIME,
       'userGeneratedMsgContent' AS USER_GENERATED_MSG_CONTENT

FROM
 progression_panel_exam_event examEvent
           inner join 
		   progression_panel_decision_template panel on panel.id=examEvent.progressionPanelDecisionId
           inner join 
		   progression_status prStatus on panel.decisionId=prStatus.id
           inner join 
           marksheet_job_details marksheetJob on marksheetJob.id=examEvent.marksheetJobId
		   inner join 
           admission  adm on adm.id=panel.admissionId and adm.studentId=panel.studentId
	       inner join
		   users  user on user.id=adm.studentId
           inner join
		   students student on student.userId=user.id  
		   inner join
		   persons  person on person.id=student.personId
		   inner join 
		   academy_location location on location.id=adm.academyLocationId
		   inner join 
		   prog_batch_period_config period on period.id=panel.periodId
		   inner join
		   batches batch on batch.id=period.programBatchId
	       inner join 
		   programs program on program.id=batch.programId
           inner join 
           evaluation_plan_rank planRank on planRank.admissionId=panel.admissionId and planRank.periodId=panel.periodId
           inner join 
           course_variants cv on cv.id=planRank.courseVariantId 
           inner join 
           courses course on course.id=cv.courseId
		   inner join 
		   examination_result result  ON result.admissionId = panel.admissionId  AND result.periodId = panel.periodId    
		   AND result.courseVariantId = planRank.courseVariantId
           inner join 
           evaluation_type_course typeCourse   ON typeCourse.periodId = result.periodId   AND typeCourse.courseVariantId = result.courseVariantId  
           inner join 
           exam_event_detail eventDetail   ON eventDetail.eventId = result.evaluationDetailSequenceId AND typeCourse.id = eventDetail.evaluationTypeCourseId  
           inner join 
           eval_seq_detail mainEvent ON mainEvent.id = eventDetail.eventId 
           courses course on course.id=cv.courseId
           INNER JOIN 
           committee committee ON committee.id = panel.committeeId
   WHERE
           examEvent.id IN (namedParams) 
           group by course.id"
WHERE  dataProviderId =@dtproviderRCPNT;
END IF; 

IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_RESIT_STATUS_RECIPIENT')) THEN 
SET @dtproviderRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_RESIT_STATUS_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`=
"   SELECT 
       examEvent.id AS ID,
       person.firstName AS FIRST_NAME,
       person.printName AS STUDENT_PRINT_NAME,
       person.lastName AS LAST_NAME,
	   person.emailId AS EMAIL_ID,
	   user.code AS STUDENT_ID,
	   program.programNameToBePrint AS PROGRAM_NAME,
       batch.printName AS BATCH_NAME,
	   period.printName AS PERIOD_NAME,
       location.academyName AS ACADEMY_NAME,
       location.locationName AS LOCATION_NAME,
       prStatus.itemCode as PROGRESSION_STATUS,
	   course.courseCode AS COURSE_CODE,
       course.courseName AS COURSE_NAME,
	   committee.progressionPanelStartDate AS PRINT_DATETIME,
	   marksheetJob.id as JOB_ID,
	   panel.remarks as REMARK,
       DATE_FORMAT(eventDetail.conductedDate, '%Y-%m-%d') AS ASSESSMENT_DATE,
       DATE_FORMAT(eventDetail.time, '%H:%i') AS CONDUCTED_TIME,
       'userGeneratedMsgContent' AS USER_GENERATED_MSG_CONTENT

FROM
 progression_panel_exam_event examEvent
           inner join 
		   progression_panel_decision_template panel on panel.id=examEvent.progressionPanelDecisionId
           inner join 
		   progression_status prStatus on panel.decisionId=prStatus.id
           inner join 
           marksheet_job_details marksheetJob on marksheetJob.id=examEvent.marksheetJobId
		   inner join 
           admission  adm on adm.id=panel.admissionId and adm.studentId=panel.studentId
	       inner join
		   users  user on user.id=adm.studentId
           inner join
		   students student on student.userId=user.id  
		   inner join
		   persons  person on person.id=student.personId
		   inner join 
		   academy_location location on location.id=adm.academyLocationId
		   inner join 
		   prog_batch_period_config period on period.id=panel.periodId
		   inner join
		   batches batch on batch.id=period.programBatchId
	       inner join 
		   programs program on program.id=batch.programId
           inner join 
           evaluation_plan_rank planRank on planRank.admissionId=panel.admissionId and planRank.periodId=panel.periodId
           inner join 
           course_variants cv on cv.id=planRank.courseVariantId 
           inner join 
           courses course on course.id=cv.courseId
		   inner join 
		   examination_result result  ON result.admissionId = panel.admissionId  AND result.periodId = panel.periodId    
		   AND result.courseVariantId = planRank.courseVariantId
           inner join 
           evaluation_type_course typeCourse   ON typeCourse.periodId = result.periodId   AND typeCourse.courseVariantId = result.courseVariantId  
           inner join 
           exam_event_detail eventDetail   ON eventDetail.eventId = result.evaluationDetailSequenceId AND typeCourse.id = eventDetail.evaluationTypeCourseId  
           inner join 
           eval_seq_detail mainEvent ON mainEvent.id = eventDetail.eventId 
           courses course on course.id=cv.courseId
           INNER JOIN 
           committee committee ON committee.id = panel.committeeId
   WHERE
           examEvent.id IN (namedParams) 
           group by course.id"

WHERE  dataProviderId =@dtproviderRCPNT;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251202143944__Update_EmailMarksheetRemoveCondition () $$
DROP PROCEDURE IF EXISTS V20251202143944__Update_EmailMarksheetRemoveCondition $$
DELIMITER ;