DELIMITER $$
DROP PROCEDURE IF EXISTS V20251208123434__Create_EvaluationGroupApplications $$
CREATE PROCEDURE V20251208123434__Create_EvaluationGroupApplications()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='evaluation_group_applications')) THEN 
CREATE TABLE evaluation_group_applications (
  id bigint NOT NULL AUTO_INCREMENT,
  evaluationGroupId bigint NOT NULL,
  evaluationDetailSequenceId bigint NOT NULL,
  admissionId bigint NOT NULL,
  courseVariantId bigint NOT NULL,
  sectionId bigint NOT NULL,
  periodId bigint NOT NULL,
  applicationStatus varchar(45) NOT NULL,
  feeStatus varchar(45) NOT NULL,
  lastUpdatedBy bigint NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_evaluationGroupId_idx (evaluationGroupId),
  KEY fk_evaluationDetailSequenceId_idx (evaluationDetailSequenceId),
  KEY fk_admissionId_idx (admissionId),
  KEY fk_courseVariantId_idx (courseVariantId),
  KEY fk_sectionId_idx (sectionId),
  KEY fk_periodId_idx (periodId),
  KEY fk_users_lastUpdatedBy_idx (lastUpdatedBy),
  CONSTRAINT fk_evaluation_group_evaluationGroupId FOREIGN KEY (evaluationGroupId) REFERENCES evaluation_group (id),
  CONSTRAINT fk_eval_seq_detail_attributeTypeId FOREIGN KEY (evaluationDetailSequenceId) REFERENCES eval_seq_detail (id),
  CONSTRAINT fk_admission_attributeTypeId FOREIGN KEY (admissionId) REFERENCES admission (id),
  CONSTRAINT fk_course_variants_attributeTypeId FOREIGN KEY (courseVariantId) REFERENCES course_variants (id),
  CONSTRAINT fk_sections_attributeTypeId FOREIGN KEY (sectionId) REFERENCES sections (id),
  CONSTRAINT fk_prog_batch_period_config_attributeTypeId FOREIGN KEY (periodId) REFERENCES prog_batch_period_config (id),
  CONSTRAINT fk_users_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
);

END IF;  

END $$
CALL V20251208123434__Create_EvaluationGroupApplications () $$ 
DROP PROCEDURE IF EXISTS V20251208123434__Create_EvaluationGroupApplications $$ 
DELIMITER ;