DELIMITER $$
DROP PROCEDURE IF EXISTS netsuiteFetchCancelReceiptToBePushed $$
CREATE PROCEDURE netsuiteFetchCancelReceiptToBePushed()
BEGIN
    -- Cancelled receipts to be pushed
    SELECT 
        ncrm.id,
        ncrm.netsuiteCustomerId,
        ncrm.academiaUserId,
        ncrm.academiaStudentCode,
        ncrm.netsuiteReceiptId,
        ncrm.receiptHeaderId,
        ncrm.receiptNo,
        ncrm.netsuiteInvoiceId,
        ncrm.billHeaderId,
        ncrm.billNo,
        ncrm.isCancelled
    FROM
        receipt_header rh
        INNER JOIN netsuite_create_receipt_mapping ncrm 
            ON rh.id = ncrm.receiptHeaderId
        INNER JOIN netsuite_create_customer_mapping nccm 
            ON rh.studentId = nccm.academiaUserId
    WHERE 
        rh.status = 'CANCELLED'
        AND rh.studentId IS NOT NULL
        AND ncrm.isCancelled = FALSE
    GROUP BY 
        ncrm.id;
END $$
DELIMITER ;
