ALTER TABLE `student_program_attendance` 
CHANGE COLUMN `fromTime` `fromTime` DATETIME NULL DEFAULT NULL ,
CHANGE COLUMN `toTime` `toTime` DATETIME NULL DEFAULT NULL ,
ADD COLUMN `academyLocationId` BIGINT(20) NOT NULL AFTER `id`;

ALTER TABLE `student_program_attendance` 
ADD INDEX `Ref_academyLocationId_idx_1` (`academyLocationId` ASC);

ALTER TABLE `student_program_attendance` 
ADD CONSTRAINT `Ref_academyLocationId_1`
  FOREIGN KEY (`academyLocationId`)
  REFERENCES `academy_location` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

ALTER TABLE `student_course_attendance` 
CHANGE COLUMN `fromTime` `fromTime` DATETIME NULL DEFAULT NULL ,
CHANGE COLUMN `toTime` `toTime` DATETIME NULL DEFAULT NULL ;

ALTER TABLE `student_course_attendance` 
ADD COLUMN `academyLocationId` BIGINT(20) NOT NULL AFTER `id`;

ALTER TABLE `student_course_attendance` 
ADD INDEX `Ref_academyLocationId_2_idx` (`academyLocationId` ASC);

ALTER TABLE `student_course_attendance` 
ADD CONSTRAINT `Ref_academyLocationId_2`
  FOREIGN KEY (`academyLocationId`)
  REFERENCES `academy_location` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

ALTER TABLE `student_course_attendance` 
ADD COLUMN `componentTypeId` BIGINT(20) NULL AFTER `courseId`;

ALTER TABLE `student_course_attendance` 
ADD INDEX `Ref_componentTypeId_1_idx` (`componentTypeId` ASC);

ALTER TABLE `student_course_attendance` 
ADD CONSTRAINT `Ref_componentTypeId_1`
  FOREIGN KEY (`componentTypeId`)
  REFERENCES `component_type` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `faculty_program_attendance` 
CHANGE COLUMN `fromTime` `fromTime` DATETIME NULL DEFAULT NULL ,
CHANGE COLUMN `toTime` `toTime` DATETIME NULL DEFAULT NULL ,
ADD COLUMN `academyLocationId` BIGINT(20) NOT NULL AFTER `id`;

ALTER TABLE `faculty_program_attendance` 
ADD INDEX `Ref_academyLocationId_3_idx` (`academyLocationId` ASC);

ALTER TABLE `faculty_program_attendance` 
ADD CONSTRAINT `Ref_academyLocationId_3`
  FOREIGN KEY (`academyLocationId`)
  REFERENCES `academy_location` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

ALTER TABLE `faculty_course_attendance` 
CHANGE COLUMN `fromTime` `fromTime` DATETIME NOT NULL ,
CHANGE COLUMN `toTime` `toTime` DATETIME NOT NULL ,
ADD COLUMN `academyLocationId` BIGINT(20) NOT NULL AFTER `id`;

ALTER TABLE `faculty_course_attendance` 
ADD INDEX `fk_academyLocationId_4_idx` (`academyLocationId` ASC);

ALTER TABLE `faculty_course_attendance` 
ADD CONSTRAINT `fk_academyLocationId_4`
  FOREIGN KEY (`academyLocationId`)
  REFERENCES `academy_location` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

-- leave report changes start
ALTER TABLE `leave_report` 
ADD COLUMN `acdemyLocationId` BIGINT(20) NOT NULL AFTER `lastUpdatedBy`;

ALTER TABLE `leave_report` 
CHANGE COLUMN `acdemyLocationId` `academyLocationId` BIGINT(20) NOT NULL AFTER `id`;

ALTER TABLE `leave_report` 
ADD INDEX `fk_leave_report_acadLocationId_idx` (`academyLocationId` ASC);
ALTER TABLE `leave_report` 
ADD CONSTRAINT `fk_leave_report_acadLocationId`
  FOREIGN KEY (`academyLocationId`)
  REFERENCES `academy_location` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

-- leave report changes end

ALTER TABLE `faculty_program_attendance` 
DROP FOREIGN KEY `Ref_sections_faculty`,
DROP FOREIGN KEY `Ref_program_faculty`,
DROP FOREIGN KEY `Ref_period_faculty`,
DROP FOREIGN KEY `Ref_batch_faculty`;
ALTER TABLE `faculty_program_attendance` 
DROP COLUMN `sectionId`,
DROP COLUMN `periodId`,
DROP COLUMN `batchId`,
DROP COLUMN `programId`,
DROP INDEX `Ref_period_idx_faculty` ,
DROP INDEX `Refsections510_faculty` ,
DROP INDEX `Refbatches203_faculty` ,
DROP INDEX `Refprograms202_faculty` ;

ALTER TABLE `faculty_course_attendance` 
ADD COLUMN `componentTypeId` BIGINT(20) NOT NULL AFTER `courseId`;

ALTER TABLE `faculty_course_attendance` 
ADD INDEX `fk_faculty_course_attendance_6_idx` (`componentTypeId` ASC);
ALTER TABLE `faculty_course_attendance` 
ADD CONSTRAINT `fk_faculty_course_attendance_6`
  FOREIGN KEY (`componentTypeId`)
  REFERENCES `component_type` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;