-- Course Summary : Most & Least Popular courses PBS
DROP VIEW IF EXISTS `pnc_dashboard_most_least_popular_course_pbs`;
CREATE VIEW `pnc_dashboard_most_least_popular_course_pbs` AS
select
    programs.id as programId,
    prog_batch_period_config.programBatchId,
    prog_batch_period_config.id as periodId,
    courses.id as courseId,
    programs.programName,
    batches.batchName,
    prog_batch_period_config.programPeriodName,
    courses.courseCode,
    courses.courseName,
    count(case when whetherRequirementReceived = 1 then whetherRequirementReceived end) "Applied",
    count(case when whetherEnrolled = 1 then whetherEnrolled end) "Enrolled",
    (select sum(maxCapacity) from sections where sections.id in (select id from sections where sections.periodId = pbcd.programBatchPeriodConfigId)) as capacity
from
    prog_batch_course_details pbcd
left outer join
    prog_batch_period_config on pbcd.programBatchPeriodConfigId = prog_batch_period_config.id
left outer join
    batches on prog_batch_period_config.programBatchId = batches.id
left outer join
    programs on batches.programId = programs.id
left outer join
    course_variants on pbcd.courseVarientId = course_variants.id
left outer join
    courses on course_variants.courseId = courses.id
left outer join
    sections on pbcd.sectionId = sections.id
where
    whetherOptional = 1 and
    courses.assignSectionType = "ProgramBatchSection"
group by
    prog_batch_period_config.id;

    
-- Course Summary : Most & Least Popular courses CBS
DROP VIEW IF EXISTS `pnc_dashboard_most_least_popular_course_cbs`;
CREATE VIEW `pnc_dashboard_most_least_popular_course_cbs` AS
select
    courses.id as courseId,
    courses.courseCode,
    courses.courseName,
    count(case when whetherRequirementReceived = 1 then whetherRequirementReceived end) "Applied",
    count(case when whetherEnrolled = 1 then whetherEnrolled end) "Enrolled",
    (select sum(maxCapacity) from sections where sections.id in (select id from sections where sections.courseVariantId in (select id from course_variants where courseId = courses.id))) as capacity
from
    prog_batch_course_details pbcd
left outer join
    course_variants on pbcd.courseVarientId = course_variants.id
left outer join
    courses on course_variants.courseId = courses.id
left outer join
    sections on pbcd.sectionId = sections.id
where
    whetherOptional = 1 and
    courses.assignSectionType = "CourseSection"
group by
    courses.id;