-- P&C Dashboard => Program Summary => Program with vacant seats  
DROP VIEW IF EXISTS `pnc_dashboard_program_with_vacants_seats`;
CREATE VIEW `pnc_dashboard_program_with_vacants_seats` AS 
select
    programs.programCode,
    programs.programName,
    batches.id,
    batches.batchName,
    batches.seatCapacity,
    (batches.seatCapacity - count(*)) seatVacant
from
    admission
left outer join
    batches on admission.batchId = batches.id
left outer join
    programs on batches.programId = programs.id
group by
    batchId;

-- P&C Dashboard => Program Summary => Program with vacant seats => batch hyperlink
DROP VIEW IF EXISTS `pnc_dashboard_program_with_vacants_seats_batch`;
CREATE VIEW `pnc_dashboard_program_with_vacants_seats_batch` AS 
select
    seat_types.seatName,
    prog_batch_seat_config.seatCapacity,
    (prog_batch_seat_config.seatCapacity - count(*)) seatVacant,
    admission.batchId
from
    admission
left outer join
    prog_batch_seat_config on admission.programBatchSeatConfigId = prog_batch_seat_config.id
left outer join
    seat_types on prog_batch_seat_config.seatTypeId = seat_types.id
group by
    admission.programBatchSeatConfigId;