
SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `import_file_template_info`;

CREATE TABLE `import_file_template_info` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `moduleName` varchar(100) NOT NULL,
    `templateName` varchar(100) DEFAULT NULL,
    `filePath` varchar(255) DEFAULT NULL,
    `status` varchar(10) NOT NULL, -- If Active - available for download else not available for download
    `lastUpdatedBy` bigint(20) NOT NULL,
    `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
PRIMARY KEY (`id`),
  KEY `Refusers10614` (`lastUpdatedBy`),
  CONSTRAINT `Refusers10614` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `import_file_info`;

CREATE TABLE `import_file_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `moduleName` varchar(100) NOT NULL,
  `fileName` varchar(100) DEFAULT NULL,
  `importedBy` bigint(20) NOT NULL,
  `importedOn` DATETIME NOT NULL,
  `lastProcessedOn` DATETIME,
  `status` varchar(50) DEFAULT NULL,
  `filePath` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refusers10612` (`importedBy`),
  KEY `Refusers10613` (`lastUpdatedBy`),
  CONSTRAINT `Refusers10612` FOREIGN KEY (`importedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `Refusers10613` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


SET FOREIGN_KEY_CHECKS=1;