set foreign_key_checks=0;

ALTER TABLE `admission_enq_details` 
DROP FOREIGN KEY `Reflocations1625`,
DROP FOREIGN KEY `Refacademies1624`,
DROP COLUMN `locationId`,
DROP COLUMN `academyId`,
DROP INDEX `Reflocations1625` ,
DROP INDEX `Refacademies1624` ;


ALTER TABLE `admission_enq_details` 
ADD COLUMN `academyLocationId` BIGINT(20) NULL AFTER `enqStudentDetailsId`,
ADD CONSTRAINT `fk_admission_enq_details_alid`
  FOREIGN KEY (`academyLocationId`)
  REFERENCES `academy_location` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

set foreign_key_checks=1;


--  added new table enquiry_source and remove enquirySource enumeration 
CREATE TABLE `enquiry_source` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `enquirySource` VARCHAR(255) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `enquirySource_UNIQUE` (`enquirySource` ASC));
  

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master(`id`, `tableName`, `masterName`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`,`moduleName`)
 VALUES (@standardMasterMaxId + 1, 'enquiry_source', 'ENQUIRY_SOURCE', 0, 0, '1', SYSDATE(),'Pre Admissions');

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId + 1, 'enquirySource', 'ENQUIRY_SOURCE', @standardMasterMaxId + 1, 'varchar', '1', 0, 0, 0, 1, '1', SYSDATE());





