drop view if exists evaluation_group_specific;
CREATE 
    
VIEW `evaluation_group_specific` AS
    select 
        `batches`.`programId` AS `programId`,
        `program_batch_students`.`programBatchId` AS `programBatchId`,
        `evaluation_group`.`id` AS `id`,
        `examination_result`.`admissionId` AS `admissionId`,
        `users`.`printName` AS `printName`,
        `evaluation_group`.`evaluationGroupCode` AS `evaluationGroupCode`,
        sum(`eval_seq_detail`.`maxMarks`) AS `markObtainedFrom`,
        sum(`examination_result`.`finalMarks`) AS `markObtained`,
        avg(`examination_result`.`gradePoints`) AS `gradePoint`,
        `program_batch_students`.`isCurrentPeriod` AS `isCurrentPeriod`
    from
        ((((((((`examination_result`
        left join `program_batch_students` ON ((`examination_result`.`admissionId` = `program_batch_students`.`admissionId`)))
        left join `eval_seq_detail` ON ((`examination_result`.`evaluationDetailSequenceId` = `eval_seq_detail`.`id`)))
        left join `evaluation_group` ON ((`examination_result`.`evaluationGroupId` = `evaluation_group`.`id`)))
        left join `admission` ON ((`examination_result`.`admissionId` = `admission`.`id`)))
        left join `students` ON ((`admission`.`studentId` = `students`.`userId`)))
        left join `users` ON ((`students`.`userId` = `users`.`id`)))
        left join `batches` ON ((`program_batch_students`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
    where
        (`program_batch_students`.`isCurrentPeriod` = 1)
    group by `examination_result`.`evaluationGroupId` , `examination_result`.`admissionId`