/*
    This file is generated and updated by Sencha Cmd. You can edit this file as
    needed for your application, but these edits will have to be merged by
    Sencha Cmd when upgrading.
 */
Ext.Loader.setConfig({
	enabled: true,
	disableCaching: false,
	paths: {
		'Ext.calendar': 'app/utilities/calendar'
	}
});
Ext.application({
	name: 'Academia', // application name that becomes the namespace
	extend: 'Academia.Application',
	init: function(){
		Academia.enumStore = {};
		Academia.dataStore = {};
	},
	autoCreateViewport: false, //// automatically refer Viewport.js
	controllers: [ 
		'Academia.controller.menu.CoreERPNavigationController',
		'Academia.controller.base.BaseController',
		'Academia.controller.authentication.AuthenticationController',
		'Academia.controller.dashboard.DashboardController',
		'Academia.controller.criteriabuilder.CriteriaBuilderController',
		'Academia.controller.criteriabuilder.SavedAdvanceSearchCriteriaController',
		'Academia.controller.datasetting.IdGeneratorController',
		'Academia.controller.webcam.ImageCaptureController',
		
		
		//-------comment below function for devlopment mode------------ - 
		'Academia.controller.organization.AcademyController',
		'Academia.controller.organization.AddressController',
		'Academia.controller.organization.LocationStructureController',
		'Academia.controller.organization.ManagementAccountingController',
		'Academia.controller.organization.MappingErrorController',
		'Academia.controller.organization.OrganizationInfoController',
		'Academia.controller.organization.SU-SAU-MAUMappingController',
		'Academia.controller.organization.StatutoryAccounting',
		'Academia.controller.organization.Supervision',
		'Academia.controller.organization.academylocations.AcademyLocationController',
		'Academia.controller.organization.academylocations.AcademyLocationPurposeController',
		'Academia.controller.othermasters.bankmaster.BankMasterController',
		'Academia.controller.othermasters.certificatemaster.CertificateMasterController',
		'Academia.controller.othermasters.communitymaster.CommunityMasterController',
		'Academia.controller.othermasters.currencymaster.CurrencyMasterController',
		'Academia.controller.othermasters.deficitmaster.DeficitCreditMasterController',
//		'Academia.controller.othermasters.requeststatusmaster.RequestStatusMasterController',
		'Academia.controller.othermasters.servicemaster.ServiceMasterController',
		'Academia.controller.customcategories.CustomCategoryController',
		'Academia.controller.customfields.CustomFieldController',
		'Academia.controller.dashboard.DashletRoleMappingController',
		'Academia.controller.dashboard.OveriddenUserDashletsController',
		'Academia.controller.datasetting.DataSettingController',
		'Academia.controller.department.DepartmentController',
		'Academia.controller.department.SubDepartmentController',
		'Academia.controller.document.DocumentController',
		'Academia.controller.documentmanagement.DocumentTemplateController',
		'Academia.controller.dynamicformrendering.DynamicFormRenderingController',
		'Academia.controller.calendar.CalendarController',
		'Academia.controller.gradeMaster.GradeMasterController',
		'Academia.controller.gradeMaster.GradeMasterSearchController',
		'Academia.controller.importutility.ImportUtilityController',
		'Academia.controller.messaging.AdhocMessagingEventController',
		'Academia.controller.messaging.SystemEventConfigurationController',
		'Academia.controller.messaging.TemplateConfigurationController',
		'Academia.controller.setup.dashboard.TablesDashboardController',
		'Academia.controller.setup.templatemapping.TemplateMappingController',
		'Academia.controller.standardMaster.StandardMaster',
		'Academia.controller.quartz.QuartzController',

		// enquiry
		'Academia.controller.enquiry.EnquiryController',
		'Academia.controller.enquiry.TrackEnquiryController',
		'Academia.controller.enquiry.admission.AdmissionReqmntDetailController',
		'Academia.controller.campaign.CampaignController',
		'Academia.controller.enquiry.EnquiryReportsController',
		'Academia.controller.enquiry.closure.ClosureDetailController',
		'Academia.controller.enquiry.enquirydetail.EnquiryDetailController',
		'Academia.controller.enquiry.exam.ExamDetailController',
		'Academia.controller.enquiry.followup.FollowUpDetailController',
		'Academia.controller.enquiry.student.StudentDetailController',
		'Academia.controller.enquiry.EnquiryRevampController',
		'Academia.controller.enquiry.enquirydetail.EnquiryDetailRevampController',
		'Academia.controller.enquiry.student.StudentDetailRevampController',


		//Program
		'Academia.controller.program.ProgramAssignExamCentersController',
		'Academia.controller.program.ProgramController',
		'Academia.controller.program.ProgramCourseGroupsController',
		'Academia.controller.program.ProgramCourseParameterController',
		'Academia.controller.program.ProgramCourseSpecializationController',
		'Academia.controller.program.ProgramCoursesController',
		'Academia.controller.program.ProgramPeriodsBreaksController',
		'Academia.controller.program.ProgramPeriodsController',
		'Academia.controller.program.ProgramRelatedCoursesController',
		'Academia.controller.program.programDetail.BasicDetailProgramController',
		'Academia.controller.program.programDetail.ProgramBatchDetailController',
		'Academia.controller.program.programDetail.batchdetail.ProgramBatchDetailSeatTypeController',
		'Academia.controller.program.reports.ProgramReportController',
		'Academia.controller.programCourseDashboard.DashboardController',
		'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',
		'Academia.controller.reports.admission.AdmissionDashboardController',
		'Academia.controller.reports.admission.AdmissionReportController',
		'Academia.controller.program.CourseFeeDefinitionCentersController',

		//course
		'Academia.controller.course.CourseListController',
		'Academia.controller.course.CreateCourseController',
		'Academia.controller.course.academylocation.AcademyLocationController',
		'Academia.controller.course.basicdetail.BasicDetailController',
		'Academia.controller.course.courseComponent.CourseComponentController',
		'Academia.controller.course.courseEquivalence.CourseEquivalenceController',
		'Academia.controller.course.coursegroup.AssignCoursesController',
		'Academia.controller.course.coursegroup.CourseGroupController',
		'Academia.controller.course.coursegroup.ViewPerformanceController',
		'Academia.controller.course.coursespecialization.CourseSpecializationController',
		'Academia.controller.course.coursevariants.CourseVariantController',
		'Academia.controller.course.history.HistoryController',
		'Academia.controller.course.reports.CourseReportController',
		'Academia.controller.course.topic.TopicController',
		'Academia.controller.coursetracker.CourseTrackerController',
		'Academia.controller.course.readingmaterial.ReadingMaterialController',

		//coursetransaction
		'Academia.controller.coursetransaction.coursereading.CourseReadingController',
		'Academia.controller.coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentController',
		'Academia.controller.coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentListController',
		'Academia.controller.coursetransaction.homework.HomeworkAssignmentController',
		'Academia.controller.coursetransaction.homework.HomeworkEvaluationController',
		'Academia.controller.coursetransaction.homework.HomeworkSubmissionController',
		'Academia.controller.coursetransaction.promotion.PromotionController',
		'Academia.controller.coursetransaction.sectioncoursecoverageplan.CourseCoveragePlanDetailsController',
		'Academia.controller.coursetransaction.sectioncoursecoverageplan.CourseCoveragePlanGridController',
		'Academia.controller.coursetransaction.sectioncoursecoverageplan.MasterTimeTableController',
		'Academia.controller.coursetransaction.sectionmanagement.SectionManagementController',
		'Academia.controller.coursetransaction.studentcourseenrollment.StudentCourseMasterController',
		'Academia.controller.coursetransaction.studentcourseenrollment.StudentEnrollmentDetailTabController',
		'Academia.controller.coursetransaction.studentcourseenrollment.courseGroup.StudentCourseGroupController',
		'Academia.controller.coursetransaction.studymaterialdistribution.StudyMaterialDistributionController',
		'Academia.controller.coursetransaction.viewschedule.ViewScheduleController',
		'Academia.controller.coursetransaction.managedistribution.ManageDistributionController',
		'Academia.controller.coursetransaction.studymaterialdistributionnew.StudyMaterialDistributionNewController',

		//User securitysetup
		'Academia.controller.securitysetup.User',
		'Academia.controller.systemusage.SystemUsageController',
		'Academia.controller.securitysetup.Role',
		'Academia.controller.securitysetup.unlockUser.CurrentLockUserController',
		'Academia.controller.securitysetup.unlockUser.NeverLockUserController',
		'Academia.controller.securitysetup.unlockUser.PreviousLockedUserController',
		'Academia.controller.reports.systemutilization.loginFrequency.LoginFrequencyController',

		//feeandpayment
		'Academia.controller.feeandpayment.AccountStatementReportController',
		'Academia.controller.feeandpayment.AdvanceFeeReportController',
		'Academia.controller.feeandpayment.FeeAndPaymentController',
		'Academia.controller.feeandpayment.FeeAndPaymentReportController',
		'Academia.controller.feeandpayment.accountingConfiguration.AccountingConfigurationController',
		'Academia.controller.feeandpayment.accountingConfigurationMapping.AccountingConfigurationMappingController',
		'Academia.controller.feeandpayment.adjustment.AdjustmentController',
		'Academia.controller.feeandpayment.controlAccount.ControlAccountController',
//		'Academia.controller.feeandpayment.dashboardAndReports.FeeAndPaymentDashboardController',
		'Academia.controller.feeandpayment.feerequest.FeeRequestController',
		'Academia.controller.feeandpayment.managebill.ManageBillController',
		'Academia.controller.feeandpayment.payment.PaymentController',
		'Academia.controller.feeandpayment.receipts.ReceiptsController',
		'Academia.controller.feeandpayment.voucherMode.VoucherModeController',
		'Academia.controller.feeandpayment.receipts.FeeLedgerMasterController',
//		'Academia.controller.feeandpayment.FeeAndPaymentSequenceController',
		'Academia.controller.feeandpayment.FeeAndPaymentConfigureController',
//		'Academia.controller.feeandpayment.managebill.ManageBillInnerController',

//		examinationcenters
		'Academia.controller.examinationcenters.evaluation.EvaluationMasterController',
		'Academia.controller.examinationcenters.evaluation.EvaluationPlanController',
		'Academia.controller.examinationcenters.evaluation.applyrule.ApplyRuleController',
		'Academia.controller.examinationcenters.ExaminationCentersController',
		'Academia.controller.examinationcenters.examlogistic.ExamLogisticController',
		'Academia.controller.examinationcenters.centerunavailability.CenterUnavailabilityMasterController',
//
		'Academia.controller.examinationcenters.evaluation.coverageDetails.CoverageDetailsController',
		'Academia.controller.examinationcenters.evaluation.evaluationDetail.EvaluationDetailTabController',
		'Academia.controller.examinationcenters.evaluation.evaluationPlanHierarchy.EvaluationCreateGroupController',
		'Academia.controller.examinationcenters.evaluation.evaluationPlanHierarchy.EvaluationLevelOneAndTwoFormController',
		'Academia.controller.examinationcenters.evaluation.evaluationPlanHierarchy.EvaluationPalnSequenceController',
		'Academia.controller.examinationcenters.evaluation.evaluationPlanHierarchy.EvaluationPlanHierarchyController',
		'Academia.controller.examinationcenters.evaluationgroup.EvalGroupMasterController',
		'Academia.controller.examinationcenters.evaluationgroup.detailsequenceCovered.DetailSequenceCoveredController',
		'Academia.controller.examinationcenters.evaluationgroup.documents.EvalGroupDocumentController',
		'Academia.controller.examinationcenters.evaluationgroup.evaluationgroupdetail.EvalGroupDetailController',
		'Academia.controller.examinationcenters.evaluationgroup.studentcovered.StudentCoveredGridController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.EvalGroupListingMasterController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.applicationdetail.ApplicationDetailController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.centerallocation.EGListingCenterAlllocationController',
		'Academia.controller.examinationcenters.dasboard.ExamLogisticStatisticsController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.documentsubmit.EvalGroupListingDocumentSubmitController',
		'Academia.controller.examinationcenters.evaluationplanstatus.EvaluationStatusController',
		'Academia.controller.examinationcenters.evaluationresult.EvaluationResultController',
		'Academia.controller.examinationcenters.evalresultlisting.EvalResultListingMasterController',
		'Academia.controller.examinationcenters.roomallocation.RoomAllocationController',
		'Academia.controller.examinationcenters.examstaffallocation.ExamStaffAllocationController',
		'Academia.controller.examinationcenters.manageEvaluation.ManageEvalResultSearchController',
		'Academia.controller.examinationcenters.markgrade.MarkGradeSearchController',
		'Academia.controller.examinationcenters.markgrade.markgradedetail.ResultStatisticController',
		'Academia.controller.examinationcenters.marksheet.MarksheetGenerationController',
		'Academia.controller.examinationcenters.remark.EvaluationRemarkController',
		'Academia.controller.examinationcenters.repetitioncompletion.RepetitionCompletionController',
//
		'Academia.controller.examCenter.sequenceManagement.AssignSequenceController',
		'Academia.controller.examCenter.sequenceManagement.CreateSequenceHeaderController',

		// personinfo
		'Academia.controller.personinfo.common.PersonCommonController',
		'Academia.controller.personinfo.common.PersonCourseExecutionController',
		'Academia.controller.personinfo.common.PersonDisciplinaryController',
		'Academia.controller.personinfo.common.PersonFeedbackSurveyController',
		'Academia.controller.personinfo.common.PersonInfoController',
		'Academia.controller.personinfo.common.PersonPastHistoryController',
		'Academia.controller.personinfo.common.PersonPaymentRefundController',
		'Academia.controller.personinfo.common.PersonRequestActionController',
		'Academia.controller.personinfo.common.PersonServiceController',
		'Academia.controller.personinfo.faculty.FacultyCourseExecutionController',
//		'Academia.controller.personinfo.faculty.FacultyDisciplinaryController',
		'Academia.controller.personinfo.faculty.FacultyDocumentController',
//		'Academia.controller.personinfo.faculty.FacultyFeedbackSurveyController',
		'Academia.controller.personinfo.faculty.FacultyListController',
//		'Academia.controller.personinfo.faculty.FacultyPastHistoryController',
//		'Academia.controller.personinfo.faculty.FacultyPaymentRefundController',
		'Academia.controller.personinfo.faculty.FacultyPersonalController',
		'Academia.controller.personinfo.faculty.FacultyRequestActionController',
//		'Academia.controller.personinfo.faculty.FacultyServiceController',
		'Academia.controller.personinfo.student.StudentCourseExecutionController',
		'Academia.controller.personinfo.student.StudentDebarmentController',
		'Academia.controller.personinfo.student.StudentDisciplinaryController',
		'Academia.controller.personinfo.student.StudentDocumentController',
		'Academia.controller.personinfo.student.StudentFeedbackController',
		'Academia.controller.personinfo.student.StudentKYSController',
		'Academia.controller.personinfo.student.StudentListController',
		'Academia.controller.personinfo.student.StudentPastHistoryController',
		'Academia.controller.personinfo.student.StudentPaymentRefundController',
		'Academia.controller.personinfo.student.StudentPersonalController',
		'Academia.controller.personinfo.student.StudentRequestActionController',
		'Academia.controller.personinfo.student.StudentServiceController',
		'Academia.controller.personinfo.student.StudentTerminationController',
//		'Academia.controller.personinfo.student.StudentTrackRequestController',
		'Academia.controller.personinfo.student.StudentTransferController',
		'Academia.controller.personinfo.dashlet.PersonInfoDashboardController',
		'Academia.controller.hrm.EmployeeAvailabilityController',
		'Academia.controller.hrm.EmployeePatentReportController',
		//servicerequest
		'Academia.controller.servicerequest.PersonalDataChangeRequestController',
		'Academia.controller.servicerequest.ServiceRequestBaseController',
		'Academia.controller.servicerequest.ServiceRequestController',
		'Academia.controller.servicerequest.ServiceRequestSetting',

		//attendance

		'Academia.controller.attendance.AttendanceMasterController',
		'Academia.controller.attendance.attendancesettings.AttendanceSettingController',
		'Academia.controller.attendance.attendancereport.AttendanceReportController',
		'Academia.controller.attendance.FacultyAttendanceController',
		'Academia.controller.attendance.PendingAttendanceController',
		'Academia.controller.attendance.attendancecheck.AttendanceCheckController',
		'Academia.controller.attendance.LeaveReportController',
		'Academia.controller.attendance.AttendanceController',
//		'Academia.controller.attendance.EditAttendanceController',

		//scholarship
		'Academia.controller.scholarship.ScholarshipListingController',
		'Academia.controller.scholarship.ScholarshipMasterController',
		'Academia.controller.scholarship.ScholarshipReceiptController',
		'Academia.controller.sponsorship.SponsorshipListingController',
		'Academia.controller.sponsorship.SponsorshipMasterController',
		'Academia.controller.sponsorship.SponsorshipReceiptController',
		'Academia.controller.sponsorship.SponsorshipBillingController',

		//facilitiesresources
		'Academia.controller.facilitiesresources.resourcemaster.ResourceMaster',
		'Academia.controller.facilitiesresources.resourcebooking.ResourceBookingController',

		//reports
		'Academia.controller.reports.complaints.ComplaintsDashboardReportController',
		'Academia.controller.reports.completion.CompletionDashboardController',
		'Academia.controller.reports.faculty.FacultyDashboardController',
		'Academia.controller.reports.faculty.FacultyReportsController',
		'Academia.controller.reports.programcourse.coursegroupcompletion.CourseGroupCompletionController',
		'Academia.controller.reports.programcourse.specialization.SpecializationReportController',
		'Academia.controller.reports.student.StudentDashboardController',
		'Academia.controller.reports.student.StudentReportController',
		'Academia.controller.reports.systemutilization.inactiveusers.InactiveUserByTimeReportController',
		'Academia.controller.reports.systemutilization.inactiveusers.InactiveUserReportController',
		'Academia.controller.reports.systemutilization.onlineusers.OnlineUserReportController',
		'Academia.controller.examinationcenters.reports.ExamReportCommonController',
		'Academia.controller.student.report.StudentFeePayerReportController',
//		'Academia.controller.examinationcenters.studentportal.SPStudentAssessmentReportController',

		//completion
		'Academia.controller.completion.CompletionCbController',
		'Academia.controller.completion.CompletionFormController',
		'Academia.controller.completion.CompletionSettingController',

		//admission
		'Academia.controller.admission.admissionCommon.AdmissionFormCommonController',
		'Academia.controller.admission.applicationFormSale.ApplicationFormSaleController',
		'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration',
		'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration',
		'Academia.controller.admission.applications.admissionAndMidTermAdmission.AdmissionAndMidTermAdmissionController',
		'Academia.controller.admission.applications.applicantDocuments.ApplicantDocumentController',
		'Academia.controller.admission.applications.applicantProfileBase.ApplicantProfileBaseController',
		'Academia.controller.admission.applications.applicantService.ApplicantServiceController',
		'Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController',
		'Academia.controller.admission.applications.applicantpasthistory.ApplicantPastHistoryController',
		'Academia.controller.admission.applications.applicationBase.ApplicationBaseController',
		'Academia.controller.admission.applications.applicationDetailsAndReferences.ApplicationDetailsAndReferencesController',
		'Academia.controller.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsRefundsAndFeePlansController',
		'Academia.controller.admission.assignApplicationID.AssignApplicationIdController',
		'Academia.controller.admission.directSubmission.DirectSubmissionController',
		'Academia.controller.admission.finalAdmissionList.FinalAdmissionListController',
		'Academia.controller.admission.preAdmissionFeesAndRefund.PreAdmissionFeesAndRefundController',
		'Academia.controller.admission.quotas.QuotaSettingController',
		'Academia.controller.admission.replacement.ReplacementController',
		'Academia.controller.admission.selectionProcess.SelectionProcessController',
		'Academia.controller.admission.selectionStage.SelectionStageController',
		'Academia.controller.admission.admissionCycle.AdmissionCycleController',

		//transport
		'Academia.controller.transport.vehicle.VehicleController',
		'Academia.controller.transport.route.RouteController',
		'Academia.controller.transport.serviceRoute.ServiceRouteController',
		'Academia.controller.transport.reports.JourneyAssignmentReportController',
		'Academia.controller.portal.StudentAttendanceReportController',
		'Academia.controller.feeandpayment.reports.FeeReportCommonController',
		'Academia.controller.reports.programcourse.creditbasedreport.CreditBasedReportController',
		'Academia.controller.reports.survey.SurveyReportController',
		'Academia.controller.admission.applicantFormSaleDirectSubmission.ApplicationFormCommonController',
		'Academia.controller.admission.manageForm.ManageFormController',
//		'Academia.controller.portal.MasterScheduleController',

		// hostel
		'Academia.controller.hostel.manageroomtype.ManageRoomTypeController',
		'Academia.controller.hostel.managerestrictiontype.ManageRestrictionTypeController',
		'Academia.controller.hostel.managehostel.ManageHostelController',
		'Academia.controller.hostel.roomallocation.RoomAllocationStructureController',
		'Academia.controller.hostel.manageallocation.ManageAllocationController',

		//Exam calculate Results
		'Academia.controller.examinationcenters.examcalculateresult.examcalculateresultController',
		// hostel report
		'Academia.controller.hostel.reports.RoomAllocationReportController',
		'Academia.controller.hostel.reports.ManageAllocationReportController',
		'Academia.controller.hostel.reports.HostelFeeReportController',
		//************** Application Report******
		'Academia.controller.applicationreport.ApplicationController',
		'Academia.controller.manageDetention.ManageDetentionController',
		'Academia.controller.leavemanagement.LeaveTypeController',
		'Academia.controller.leavemanagement.LeaveSettingController',
		'Academia.controller.hostel.hostelattendance.HostelAttendanceController',
		'Academia.controller.leavemanagement.sanctionleave.LeaveSanctionSettingController',
		'Academia.controller.examinationcenters.reports.ExaminationDocumentController',
		'Academia.controller.servicerequest.eventcalendar.EventCalendarController',
		// Placement
		'Academia.controller.placement.placementtype.PlacementTypeController',
		'Academia.controller.placement.placementcampus.PlacementCampusController',
		'Academia.controller.placement.createcompany.CreateCompanyController',

		'Academia.controller.leavemanagement.administrativeleave.AdministrativeSettingController',
		'Academia.controller.examinationcenters.questionPaperBank.questionPaperBankController',
		'Academia.controller.placement.placementjob.PlacementJobController',
		'Academia.controller.placement.placementjobapplication.PlacementJobApplicationController',
		'Academia.controller.student.report.StudentTransferReportController',

		'Academia.controller.placement.recruitmentStage.PlacementRecruitmentStageController',
//		'Academia.controller.examinationcenters.dutychart.ExaminationDutyChartController',
		'Academia.controller.examinationcenters.examinationRemark.ExaminationRemarkController',
		'Academia.controller.placement.placementMaster.PlacementMaster',
		'Academia.controller.mobile.mobilesyncreport.MobileSyncController',
		'Academia.controller.filemanagement.ManageFileController',
		'Academia.controller.securitysetup.UserRoleAssociationController',
		'Academia.controller.facilitiesresources.eventAwards.EventAwardsController',
		'Academia.controller.personinfo.student.StudentEnrollmentGenerationController',
		'Academia.controller.coursetransaction.manageperiodenrollment.ManagePeriodEnrollmentController',
		'Academia.controller.coursesessiondiary.CourseSessionDiaryController',
		'Academia.controller.program.sessionReport.SessionReportController',
		'Academia.controller.personinfo.student.StudentProgressController',
		'Academia.controller.committee.committee.CommitteeController',
		'Academia.controller.sgmanagement.sgvisitor.sgVisitorController',
		'Academia.controller.sgappointment.sgappointment.SGAppointmentController',
		'Academia.controller.fdmanagement.FDManagementController',
//		'Academia.controller.feeandpayment.feerequest.StudentPortalFeeRequestController',
		'Academia.controller.programCourseDashboard.enrollmentSummaryReport.EnrollmentSummaryReportController',
//		'Academia.controller.personinfo.student.StudentComplaintController',
//		'Academia.controller.personinfo.student.StudentExaminationDocumentsController',
		'Academia.controller.examinationcenters.manageEvaluation.ManageSpecialGradeController',
		'Academia.controller.student.demographicReport.StudentDemographicReportController',
		'Academia.controller.eventmeetingminutes.EventMeetingMinutesController',
		'Academia.controller.examinationcenters.manageEvaluation.FacultyManageEvalResultSearchController',
//		'Academia.controller.examinationcenters.reports.faculty.FacultyPendingMarksController',
		'Academia.controller.program.SpecializationEnollmentController',
		'Academia.controller.program.transfercredits.TransferCreditsController',
		'Academia.controller.taskmanagement.TaskManagementController',
		'Academia.controller.servicerequest.infirmarymanage.InfirmaryManageController',
//		'Academia.controller.examinationcenters.studentportal.revaluation.RevaluationSPController',
		'Academia.controller.examinationcenters.manageEvaluation.RevaluationMarkentryController',
		'Academia.controller.examinationcenters.revaluation.RevaluationSetupController',
		'Academia.controller.organization.academylocations.AcademyLocationAddressController',
		'Academia.controller.othermasters.programgroupmaster.ProgramGroupMasterController',
		'Academia.controller.managetarget.ManageTargetController',
		'Academia.controller.transport.reports.TransportDuesReportController',
		'Academia.controller.resourceutilization.ResourceUtilizationController',
		'Academia.controller.examinationcenters.assessmentEvent.AssessmentEventController',
//		'Academia.controller.coursetransaction.studentcourseenrollment.StudentPortalCourseRegistrationController',
		'Academia.controller.coursetransaction.studentcourseenrollment.StudentCourseRegistrationController',
		'Academia.controller.admission.applications.applicantDocuments.ApplicationBulkDownloadStatusController',
		'Academia.controller.feeandpayment.discounts.DiscountController',
		'Academia.controller.feeandpayment.discounts.ManageDiscountController',
		'Academia.controller.examinationcenters.calculateAverage.CalculateAverageController',
		'Academia.controller.hrm.HRManagementController',
		'Academia.controller.leavemanagement.approvalsetup.LMApprovalSetupController',
		'Academia.controller.configureloader.ConfigureLoaderController',
		'Academia.controller.receipt.receiptsettings.ReceiptSettingsController',
		'Academia.controller.sgappointment.sgappointment.SGStudentAppointmentController',				  
		'Academia.controller.examinationcenters.marksheet.AssessmentGroupMarksheetController',
		'Academia.controller.bulkdocumentupload.BulkDocumentUploadController',
		'Academia.controller.sgappointment.sgappointment.SGApplicantAppointmentController',
		'Academia.controller.reports.userroleprivilege.UserRolePrivilegeController',
		'Academia.controller.manageMarksModeration.ManageMarksModerationController',
		'Academia.controller.resourceavailability.ResourceAvailabilityReportController',
		'Academia.controller.feeandpayment.finance.ManageFinanceHoldController',
//		'Academia.controller.program.periodTerm.PeriodTermController',
		'Academia.controller.student.incidentsReport.StudentIncidentsReportController',
		'Academia.controller.student.disciplinaryActionsReport.StudentDisciplinaryActionsReportController',
		'Academia.controller.student.studentServiceOptInReport.StudentServiceOptInReportController',
		'Academia.controller.leavemanagement.report.FacultyLeaveReportsController',
		'Academia.controller.admission.selectionStageReport.SelectionStageReportController',
		'Academia.controller.program.lessonplanning.LessonPlanningController',
//		'Academia.controller.committee.committee.StudentCommitteeController',
		'Academia.controller.program.customReports.CustomReportController',
		'Academia.controller.student.studentIdentityDocumentReport.StudentIdentityDocumentReportController',
		'Academia.controller.hrm.BiometricMachineIntegrationController',
		'Academia.controller.inventorymanagement.InventoryMgtController',
//		'Academia.controller.examinationcenters.marksheet.FacultyMarksheetGenerationController',
		'Academia.controller.program.lessonplanning.LessonPlanningInnerController',
		'Academia.controller.examinationcenters.revaluation.RevaluationController',
		'Academia.controller.documentmanagement.DocumentMasterController',
//		'Academia.controller.coursetransaction.studentperiodenrollment.StudentPeriodRegistrationController',
		'Academia.controller.hostel.hostelapplication.HostelApplicationController',
		'Academia.controller.student.currentEnrollmentReport.StudentCurrentEnrollmentReportController',
		'Academia.controller.facilitiesresources.managegallery.ManageGalleryController',
		'Academia.controller.student.studentLeaversReport.StudentLeaversReportController',
		'Academia.controller.translation.TranslationController',
		'Academia.controller.examinationcenters.studentresultreport.StudentResultReportController',
		'Academia.controller.leavemanagement.leavegeneralsetting.LeaveGeneralSettingController',
		'Academia.controller.attendance.ConsolidateAttendanceController',
		'Academia.controller.student.studentDeletedReport.StudentDeletedReportController',
		'Academia.controller.setup.droolrules.DroolRulesController',
		'Academia.controller.facilitiesresources.resourcebooking.EmployeeResourceBookingController',
		'Academia.controller.examinationcenters.evaluationresult.ExamResultPublishController', //till Capetown
		'Academia.controller.setup.campaignmaster.CampaignMasterController',
		'Academia.controller.campaignnew.CampaignNewController',
		'Academia.controller.powerBI.AnalyticsCommonController',
		'Academia.controller.leavemanagement.leavecreditsetting.LeaveCreditSettingController',
		'Academia.controller.examinationdegreeremark.ExaminationDegreeRemarkController',
		'Academia.controller.servicerequest.infirmarymanage.ManageInterventionController',

		'Academia.controller.setup.loginpage.LoginPageConfigurationController',
		'Academia.controller.DMSController.DMSCommonController',
		'Academia.controller.datagridconfiguration.DataGridConfigurationController',
		'Academia.controller.admission.applicantPortalSetup.ApplicantPortalSetupController',
		'Academia.controller.kohaLibraryTransalation.SGStudentLibraryIssuedBookTransactionController',
		'Academia.controller.signupreport.signUpReportController',
		'Academia.controller.program.outcomebasededucation.OutcomeBasedEducationController',
		'Academia.controller.coursetransaction.sectionmanagement.CourseSectionManagementController',
		'Academia.controller.examinationOBEAttainment.ObeAttainmenRuleController',
		'Academia.controller.hrRecruitmentProcess.jobPosting.JobPostingController',
		'Academia.controller.course.requisite.CourseRequisiteController',
		'Academia.controller.admission.applicationOwnerSetup.ApplicationOwnerSetupController',
		'Academia.controller.outcomebasededucation.ObeCorrelationPercentController',
		'Academia.controller.admission.signupAdditionalSetup.SignupAdditionSetupController',
		'Academia.controller.documentmanagement.DocumentGroupMasterController',
		'Academia.controller.registrationsetup.RegistrationTermSetupController',
		'Academia.controller.hrRecruitmentProcess.jobApplication.JobApplicationController',
		'Academia.controller.examinationcenters.averagereport.StudentAverageReportController',
		'Academia.controller.examcancellation.ExamCancellationController',
		'Academia.controller.course.reports.CourseCreditGradeReportController',
		'Academia.controller.election.election.ElectionController',
		'Academia.controller.feeandpayment.coursefeedefinition.CourseFeeDefinitionController',
		'Academia.controller.enquiry.enquirySettings.CtrlPadmEnquiryFormSetupController',
		'Academia.controller.feeandpayment.creditfeemapping.CreditFeeMappingController',
		'Academia.controller.examexecution.StudentMarkRemarkEntryController',
		'Academia.controller.placement.placementReport.PlacementDetailReportController',
		'Academia.controller.examinationcenters.thesisManagement.thesisManagementController',
		'Academia.controller.personinfo.student.StudentManageHoldController',
		'Academia.controller.tvet.TVETReportController',
		'Academia.controller.student.report.StudentMedicalDetailsReportController',
		'Academia.controller.setup.sessionlogouttimesetup.SessionLogoutTimeSetupController',
		'Academia.controller.examconcession.ExamConcessionController',
		'Academia.controller.examinationattendancerule.ExaminationAttendanceRuleController',
		'Academia.controller.reports.completion.CompletionReportController',
		'Academia.controller.setup.manageportalpermission.ManagePortalPermissionController',
		'Academia.controller.program.CatalogueContentController',
		'Academia.controller.setup.dashboard.LicenseDetailsReportController',
		'Academia.controller.examinationcenters.reports.UpdatedMarksRemarksReportController',
		'Academia.controller.student.feeregistrationreset.StudentFeeRegistrationResetController',
        'Academia.controller.powerBI.MarkSummaryAnalyticsReportController',
        'Academia.controller.setup.quickLink.QuickLinkController',
        'Academia.controller.hostel.accommodationProvider.AccommodationProviderController',
        'Academia.controller.feeandpayment.debitOrders.ManageDebitOrdersController',
        'Academia.controller.personinfo.faculty.LearningTargetsController',
        'Academia.controller.sunsuccess.SunSuccessController' ,
        'Academia.controller.personinfo.student.StudentJourneyCoreErpController',
        'Academia.controller.admission.applications.applicationFollowUp.ApplicationFollowUpDetailController',
        'Academia.controller.admission.applications.pandadoc.PandaDocController',
        'Academia.controller.admission.applications.applicationFollowUp.ApplicationFollowUpDetailController',
        'Academia.controller.examinationtimetable.ExamTimetableController',
        'Academia.controller.eventlevelremark.EventLevelRemarkController' ,
		'Academia.controller.scholarship.PoetMasterController',
		'Academia.controller.facultyCourseInterest.FacultyCourseInterestController',
		'Academia.controller.student.bulkUploadDocumentAndNotes.BulkUploadDocumentAndNotesController',
		'Academia.controller.manageCeremony.ManageCeremonyController',
		'Academia.controller.emailAccountStatement.EmailAccountStatementController', 
		'Academia.controller.prereqnotmetreport.PreReqNotmetReportController',
		'Academia.controller.coursetransaction.promotionpanel.PromotionPanelController',
		'Academia.controller.alumniManagementSystem.AlumniManagementController',
		'Academia.controller.alumniManagementSystem.AlumniPortalSetUpController',
		'Academia.controller.alumniManagementSystem.AlumniFundsRaisingController',
		'Academia.controller.alumniManagementSystem.AlumniNewsAndFeedsController', 
		'Academia.controller.lecturerCostingDefinition.LecturerCostingDefinitionController',
		'Academia.controller.hostel.hostelApplicationSetup.HostelApplicationSetupController',
		'Academia.controller.examination.RoomAndStaffAllocationController',
		'Academia.controller.examination.ExamConcessionStaffAllocationController',
		'Academia.controller.examination.ImportPreExamDetailController',
		'Academia.controller.setup.controlPanel.ControlPanelController',
		'Academia.controller.student.report.StudentHealthInformationReportController',
		'Academia.controller.personinfo.studentportalangularsetup.StudentPortalAngularLoginSetupController',
		'Academia.controller.survey.createSurvey.CreateSurveyController',
		'Academia.controller.survey.sendSurvey.SendSurveyController',
		'Academia.controller.survey.surveyReport.SurveyReportController',
		'Academia.controller.student.feeRegistrationFormSetup.FeeRegistrationFormSetupController',
		'Academia.controller.users.userProfileLastActivity.UserProfileController',
		'Academia.controller.personinfo.student.StudentProfileController',
		'Academia.controller.alumniManagementSystem.AlumniCommunicationHistoryController',
		'Academia.controller.personinfo.facultyPortalAngularSetup.FacultyPortalAngularLoginSetupController',
       	'Academia.controller.setup.dashboard.TermsandConditionReportController',
       	'Academia.controller.reports.allReports.ReportsMainController',
		'Academia.controller.AssessmentGroupRegistration.AssessmentGroupRegistrationController',
		'Academia.controller.reports.studyplanreport.StudyPlanReportController',
        'Academia.controller.examscheduled.EvaluationScheduledController',
        'Academia.controller.examblock.ExamBlockController',
        'Academia.controller.feeandpayment.siblingranking.SiblingRankingController'
        
	],
	views: [
		'common.StatusCombo','common.StatusCombos',
              'Academia.view.baselayout.contentarea.ContentPanel',
	          'Academia.view.CustomAlerts',
	          // from base controller
		'reports.admission.admsnDataNullReport',
		'common.LiveSearchCombo',
		'Academia.view.common.AcadLocProgBatchSeattypeComponent',
		'common.NestedTextField',
		'common.IdGeneratorCustomForm',
		'common.DynamicFieldForm',
		'common.DynamicFieldFormWin',
		'common.IdGeneratorCustomFormWin',
		'common.IdGeneratorFormWin',
		'common.AddressDetailPanel',
		'common.CustomFieldForm',
		'messaging.sendmessage.SendMessageWindow',
  			 // form CoreERPNavigationController
            'Academia.view.organization.OrganizationStructure',
            'Academia.utilities.ux.CustomTopPagingToolBar'
          			 ],
	stores: [
		'common.StatusComboStore',
		'common.LiveSearchCombos',
		'Academia.store.common.AcademyStore',
		'Academia.store.common.SeatTypesByBatchId',
		'Academia.store.common.LocationStore',
		'Academia.store.common.ProgramsByAcademyIdLocationId',
		'Academia.store.common.BatchesByProgramId',
		'Academia.store.common.SeatTypesByBatchId',
		'Academia.store.common.Checklist',
		'Academia.store.common.DocumentTypeStore',
		'common.ActiveUserStore',
		'Academia.store.messaging.MessageTemplate'
	],
    models:[
    	'customfields.CustomFieldDataModel',
    	'singleton.Organization',
    	'menu.MegaMenuDataModel',
    	'Academia.model.common.OrgSettingDateTimeModel'
    ],
	requires:[
	          'Academia.constants.CurrencyFormatConstants',
	          'Academia.utilities.CommonUtil',
               'Academia.utilities.vTypeValidations.Validation',
               'Academia.utilities.ErrorHandler',
               'Academia.utilities.plugins.AsteriskPlugin',
               'Academia.utilities.CustomAlerts',
               'Academia.utilities.JsonAjaxRequest',
               'Academia.utilities.ImageActionColumn',
               'Academia.utilities.accessControl.AccessControlManager',
               'Academia.utilities.accessControl.FeaturePrivilegeManager',
               // from base controller
               'Academia.utilities.plugins.TreeFilter',
               'Academia.utilities.ckEditor.CkEditor',
               'Academia.utilities.gridExporter',
               'Academia.utilities.DisplayFormatMap',
               'Academia.utilities.CurrencyFormatMap',
               'Academia.utilities.plugins.SessionMonitor',
               'Academia.utilities.currency.CurrencyManager',
               'Academia.utilities.date.DateHelper',
               'Academia.utilities.ux.PageSize', 
               'Academia.utilities.ux.CustomPagingToolBar',
               'Academia.utilities.ux.AutoGroupedColumn',
               'Academia.utilities.ux.GroupingComboBox',
               'Academia.utilities.ux.CustomCheckboxField',
               'Academia.utilities.reader.CacheRest',
               'Academia.utilities.reader.CustomArrayReader',
               'Academia.config.Runtime'
     ],
     launch :function(){
    	 	Ext.app.autoCallAPIs = true;
	    	//--- code for separating tabs ---//
	    	setTabId();
	    	initGoogleAnalytics();
	    //	document.head.insertAdjacentHTML("beforeend", '<style>#placeholderLbar{height:'+(Ext.getBody().getHeight()-127)+'px !important;}</style>');
	    	var getParams = document.URL.split("?");
    		var params = Ext.urlDecode(getParams[getParams.length - 1]);
    		localStorage.setItem('userHash','');
    		if(params["userHash"])
    		{
    			localStorage.setItem('userHash',params["userHash"]);
    			window.history.pushState("", "", getParams[0]);
    		}
    	       
    	      var tokenApiResponse = Ext.decode(localStorage.getItem('tokenApiResponse'));
    	      var academylocationid = Ext.decode(localStorage.getItem('academylocationid'));
    	      var wheatherSchool = Ext.decode(localStorage.getItem('wheatherSchool'));
		if(isNullOrEmpty(localStorage.getItem('maxLength'))){
  	    		localStorage.setItem('maxLength',160);
		}
  	    		if(!isNullOrEmpty(localStorage.getItem('defaultPage'))){
  	  	    		var defaultPage = localStorage.getItem('defaultPage');
  	  	    		setTimeout(function(){
  	  	    		try{
  	  	    			var defaultPageSplitted = defaultPage.split('-');
  	  	    			this$.openTab(getMegaMenuTranslation(defaultPageSplitted[0]), defaultPageSplitted[1] );
  	  	    			localStorage.setItem('defaultPage','');
  	  	    		}
  	  	    		catch(e){
  	  	    			localStorage.setItem('defaultPage','');
  	  	    		}
  	  	    		},5000);
  	    		}
		if(!isNullOrEmpty(tokenApiResponse) && !isNullOrEmpty(tokenApiResponse.Authorization) && !isNullOrEmpty(academylocationid)){
			Ext.Ajax.defaultHeaders = {
					Authorization: "Bearer " + tokenApiResponse.access_token,
					expires_in: tokenApiResponse.expires_in,
					access_token: tokenApiResponse.access_token,
					refresh_token: tokenApiResponse.refresh_token
			};
			var userInfo = Academia.model.authentication.UserInfoModel;

			userInfo.set("accessToken", tokenApiResponse.access_token);
			userInfo.set("refreshToken", tokenApiResponse.refresh_token);
			userInfo.set("expiryTimeForAccessToken", tokenApiResponse.expires_in);

			Academia.app.getController('Academia.controller.authentication.AuthenticationController').loginAccessLoadMainPanel();
			Academia.app.getController('Academia.controller.authentication.AuthenticationController').loadMultipleLangFilePerAL(academylocationid); //adding for coreERP only for hiding links by school/college
			/*setTimeout(function(){
				Academia.app.getController('Academia.controller.authentication.AuthenticationController').loadDataAfterLogin(); 
			},2000);*/
			loadApisFunction();
		}
		var style = document.createElement('style');
		style.type = 'text/css';
		var fullWidth = window.innerWidth;
		//style.innerHTML = '.x-grid .x-header-text { margin-left: 494px !important; } .x-grid .x-header-text-container { left: 0 !important; }';4
		style.innerHTML = '.contentPanel .x-grid .x-header-text-container { width: '+fullWidth+'px !important;left: -245px !important; } .contentPanel .x-grid .x-header-text { margin-left: 110px !important; }';
		document.getElementsByTagName('head')[0].appendChild(style);
		var style2 = document.createElement('style');
        style2.type = 'text/css';
        style2.innerHTML='.centerAlignTitle.x-grid .x-header-text-container { width: inherit !important;;left: unset!important;; }';
        document.getElementsByTagName('head')[0].appendChild(style2);
        var style3 = document.createElement('style');
        style3.type = 'text/css';
        style3.innerHTML='.parallelGridCenterAlignTitle.x-grid .x-header-text { margin-left: 145px !important; }';
        document.getElementsByTagName('head')[0].appendChild(style3);
        
		window.addEventListener('keydown', function(e) {
    		if(e.keyCode == 32 && e.target == document.body) {
    	    	e.preventDefault();
    	  	}
    	});
	},
	runAction:function(controllerName, actionName){
		var controller = this.getController(controllerName);
	},
	ctrls: []                              
});

/* checkcolumn override for click event to be work on checkbox only */
Ext.override(Ext.grid.column.CheckColumn, {
	processEvent: function(type1, view, cell, recordIndex, cellIndex, e, record, row) {
        var me = this,
            key = (type1 === 'keydown' && e.getKey()),
            mousedown = (type1 == 'mousedown');

        if (mousedown && !Ext.fly(e.getTarget()).hasCls('x-grid-checkcolumn')) {
            return !me.stopSelection;
        }

        me.callParent([type1, view, cell, recordIndex, cellIndex, e, record, row]);
    }
});

/* 
 * @author : abhishek.bais
 * @since  : 04-07-2017
 * @description : This Section Add For Customize Sorting Order Of Grid Column
 */

Ext.override(Ext.grid.column.Column, {
	listeners:{
		hide: function(column){
			resetGridHeaderFix(this.up('grid'));
		},
		show: function(column){
			resetGridHeaderFix(this.up('grid'));
		}
	},
	doSort : function(state) {
		var ds = this.up('grid').store;
		var field = this.getSortParam();
		var grid = this.up('grid');
		if(ds.sorters.length){
			var oldIndex;
			var dataIndex = ds.sorters.keys[0];
			var gridColumns = this.up('grid').columns;
			for (oldIndex = 0; oldIndex < gridColumns.length; ++oldIndex) {
				if (gridColumns[oldIndex].dataIndex == dataIndex) { break; }
			}
			grid.store.applyState({root: "data", property: "", direction: ""});
			if(!isNullOrEmpty(grid.columns[oldIndex])) {
				grid.columns[oldIndex].setSortState(null);
			}
			grid.store.sorters.clear();
			grid.view.refresh();
		}
		if(Ext.isDefined(grid.getStore()) && Ext.isDefined(grid.getStore().getProxy()) && Ext.isDefined(grid.getStore().getProxy().api) && Object.keys(grid.getStore().getProxy().api).length>0  && grid.getStore().count()>0 && Ext.isDefined(grid.getStore().remoteSort) &&  grid.getStore().remoteSort== true){
			grid.getStore().load({
				callback: function(){
					ds.sort({
						property : field,
						direction : state,
						sorterFn : function(v1, v2) {
							var reA = /[^a-zA-Z]/g;
							var reN = /[^0-9]/g;
							if (!isNullOrEmpty(v1.get(field))
									&& !isNullOrEmpty(v2.get(field))) {
								if (typeof (v1.get(field)) == "string" && typeof (v2.get(field)) == "string") {
									v1 = v1.get(field);
									v2 = v2.get(field);
									var aA = v1.replace(reA, "");
									var bA = v2.replace(reA, "");
									if(aA.toLowerCase() === bA.toLowerCase()) {
										var aN = parseInt(v1.replace(reN, ""), 10);
										var bN = parseInt(v2.replace(reN, ""), 10);
										return aN === bN ? 0 : aN > bN ? 1 : -1;
									} else {
										return aA.toLowerCase() > bA.toLowerCase() ? 1 : -1;
									}
								}else if (typeof (v1.get(field)) == "object" && typeof (v2.get(field)) == "object") {
									v1 = v1.get(field).value;
									v2 = v2.get(field).value;
									if (!isNullOrEmpty(v1)
											&& !isNullOrEmpty(v2)) {
										var aA = v1.replace(reA, "");
										var bA = v2.replace(reA, "");
										if(aA.toLowerCase() === bA.toLowerCase()) {
											var aN = parseInt(v1.replace(reN, ""), 10);
											var bN = parseInt(v2.replace(reN, ""), 10);
											return aN === bN ? 0 : aN > bN ? 1 : -1;
										} else {
											return aA.toLowerCase() > bA.toLowerCase() ? 1 : -1;
										}
									}
								} else {
									v1 = v1.get(field);
									v2 = v2.get(field);
									return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
								}
							} else {
								if (isNullOrEmpty(v1.get(field))) {
									v1.set(field, '');
								}
								if (isNullOrEmpty(v2.get(field))) {
									v2.set(field, '');
								}
								v1 = v1.get(field);
								v2 = v2.get(field);
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						}
					});
				}
			});
		}
		else{
			ds.sort({
				property : field,
				direction : state
			});
		}
	}
});

Ext.override(Ext.data.proxy.Ajax, { timeout: CONSTANTS.AJAX_TIMEOUT });
/*
 * Overridden the grid panel, applied for grid row editing like excel
 * @ravi.patidar
 */
Ext.override(Ext.grid.plugin.CellEditing,{
	onSpecialKey: function(ed, field, e) {
		Ext.app.gridRendered = true;
		var grid = this.grid,sm;
		if (e.getKey() === e.TAB) {
			e.stopEvent();
			sm = grid.getSelectionModel();
			if (sm.onEditorTab)sm.onEditorTab(this, e);
		}else if(e.getKey() === e.ENTER){
			e.stopEvent();
			sm = grid.getSelectionModel();
			if (sm.onEditorEnter)sm.onEditorEnter(this, e);
		}
	}
});

Ext.override(Ext.selection.RowModel, {
	lastId:null,
	onEditorTab: function(ep, e) {
		me = this,
		view = me.view,
		record = ep.getActiveRecord(),
		header = ep.getActiveColumn(),
		position = view.getPosition(record, header),
		direction = e.shiftKey ? 'left' : 'right',
				newPosition = view.walkCells(position, direction, e, false),
				newId=newPosition.row,
				grid=view.up('gridpanel');
		if(Ext.isDefined(grid)){
		var myInterval = setInterval(function(){
			if(Ext.app.gridRendered){
				if(newPosition.column >= 10){
					deltaX = -Infinity;
					header=grid.headerCt.getHeaderAtIndex(0);
					position = view.getPosition(record, header);
					position.row = position.row+1;
					if(header){
						while(!header.getEditor()){
							position= view.walkCells(position,direction, e, false);
							header=grid.headerCt.getHeaderAtIndex(position.column);
						}
					}
					newPosition = position;
				} else if (me.lastId!=newId && me.lastId!=null){
					deltaX = me.lastId<newId? -Infinity : Infinity;
					header=grid.headerCt.getHeaderAtIndex(newPosition.column);
					if(header){
						while(!header.getEditor()){
							newPosition= view.walkCells(newPosition,direction, e, false);
							header=grid.headerCt.getHeaderAtIndex(newPosition.column);
						}
					}
				} else {
					deltaX = ep.context.column.width * (direction== 'right' ? 1 : -1);
				}
					if(!isNaN(deltaX)){
				grid.scrollByDeltaX(deltaX);
					}
				me.lastId=newPosition.row;
				if (newPosition)ep.startEditByPosition(newPosition);
				else ep.completeEdit();
				Ext.app.gridRendered = false;
				clearInterval(myInterval);
			}
		}, 100);
		}
	},
	onEditorEnter:function(ep,e){
		var me = this,
		view = me.view,
		record = ep.getActiveRecord(),
		header = ep.getActiveColumn(),
		position = view.getPosition(record, header),
		direction = e.shiftKey ? 'up' : 'down',
				newPosition = view.walkCells(position, direction, e, false),
				newId=newPosition.row,
				grid=view.up('gridpanel');

		deltaY=20 * (direction== 'down' ? 1 : -1);
		if(Ext.isDefined(grid)){
		grid.scrollByDeltaY(deltaY);
		me.lastId=newPosition.row;
		Ext.defer(function(){
			if(Ext.app.gridRendered){
				if (newPosition)ep.startEditByPosition(newPosition);
				else ep.completeEdit();
			}
		}, 100);
	}
	}
});

/**
 * Overridden the text field to set max Length 
 */
Ext.override(Ext.form.field.Text, {
	maxLength : 255,
	enforceMaxLength :true,
	msgTarget: 'side',
	listeners:{
		blur : function(){
			if(this.xtype =='textfield' || this.xtype =='textarea' || this.xtype =='textareafield'){
				var str = this.getValue();
				if(!isNullOrEmpty(str)){
					str = str.replace(/\s{2,}/g, ' ');
					this.setValue(str.trim());				
				}
			}
		}
	}
});

/**
 * Overridden the text Area to set max Length 
 */
Ext.override(Ext.form.field.TextArea, {
	enforceMaxLength :true,
	listeners:{
		render : function(me,eOpts){
			if(me.name=="smsDiscription"){
				var maxLength = localStorage.getItem('maxLength');
				me.maxLength = maxLength;
				me.el.dom.children[0].children[0].children[0].children[1].maxLength = maxLength;
			}
		}
	}
});

/**
 * Overridden the display field to set max Length text
 */
Ext.override(Ext.form.field.Display, {
	listeners:{
		render : function(me,eOpts){
			if(me.name=="smsDiscriptionNotice"){
				var maxLength = localStorage.getItem('maxLength');
				me.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+maxLength+'/'+maxLength+'</span>');
			}
		}
	}
});

/**
 * Overridden the combo field and added a matchFieldWidth.
 * Whether the picker dropdown's width should be explicitly set to match the width of the field
 * @author Rajkumar.Patidar
 */
Ext.override(Ext.form.field.ComboBox, {
	matchFieldWidth : false,
	listConfig: {
		listeners: {
			beforeshow: function(picker) {
				picker.minWidth = picker.up('combobox').getSize().width;
			}
		}
	}
});
/**
 * Overridden each component for help field behaviour.
 * @author Akshay.Kalbhor
 */
Ext.override(Ext.Component, {
	afterRender: function(cmp)
	{
		if(Ext.isDefined(this) && Ext.isDefined(this.xtype)){
			var self = this;
			var parent = this.up();
			var selfXtype = this.xtype;
			var parentXtype = (Ext.isDefined(parent) && parent.xtype) ? parent.xtype+"_" : "";
			var selfName = Ext.isDefined(this.name) ? this.name+"_" : "";
			var selfItemId = Ext.isDefined(this.itemId) ? this.itemId+"_" : "";
			
			var xpath = parentXtype+selfName+selfItemId+selfXtype;
			
			if(selfXtype && selfXtype == "verticalnavigationmenubutton"){
				xpath = xpath + "_" + this.displayCode;
			}
				
			if(self && self.el && self.el.dom && self.el.dom.setAttribute){
				self.el.dom.setAttribute('data-xpath', xpath);
			}
		}
		
		//-- Start - Code to hide combo picker on parent panel scroll - V2D-409676
		if(Ext.isDefined(this) && Ext.isDefined(this.xtype) && Ext.isDefined(this.superclass) && Ext.isDefined(this.superclass.xtypesChain) && Ext.isArray(this.superclass.xtypesChain) && Ext.Array.contains(this.superclass.xtypesChain, "container")){
			if(this.autoScroll){
				try{
					this.body.on('scroll', function(){
						if(Ext.query('.x-boundlist:visible').length){
							var boundListCombo = Ext.getCmp(Ext.query('.x-boundlist:visible')[0].id).up('combo');
							if(boundListCombo && Ext.isDefined(boundListCombo) && boundListCombo.collapse && boundListCombo.xtype != 'multiselectcombofield'){
								boundListCombo.collapse();
							}
						}
					});
				}
				catch(e){
					//
				}
			}
		}
		//-- End - Code to hide combo picker on parent panel scroll - V2D-409676
		
		if (Ext.isDefined(this) && Ext.isDefined(this.xtype)) {
            var F = this;
            var E = this.up();
            var v = this.xtype;
            var J = (Ext.isDefined(E) && E.xtype) ? E.xtype + "_" : "";
            var H = Ext.isDefined(this.name) ? this.name + "_" : "";
            var K = Ext.isDefined(this.itemId) ? this.itemId + "_" : "";
            var A = J + H + K + v;
            if (F && F.el && F.el.dom && F.el.dom.setAttribute) {
                F.el.dom.setAttribute("data-xpath", A)
            }
        }
		
		var elements = Ext.ComponentQuery.query('[translationKey]');
		Ext.each(elements, function(element){
			if(element.translationKey){
				if(element.xtype == 'textfield' || element.xtype == 'combo')
					element.setFieldLabel(getCommonTranslation(element.translationKey));
				else if(element.xtype == 'button')
					element.setText(getCommonTranslation(element.translationKey));
			}
		});
		/**
		 * Apply new CSS and Icon class on all grid button (add, edit, view, delete and print) in Academia 
		 * 
		 */
		if((this && this.superclass && this.superclass.xtypesChain && Ext.Array.contains(this.superclass.xtypesChain,'grid')) || (this &&  this.xtype == 'grid')){
			if(this.getHeader() == false){
				this.header=null;
				if(this.xtype == 'griddashlet'){
					this.setTitle(' ');
				}else{
					this.setTitle(this.title);
				}
				
			}
			if(!this.getHeader()){
				this.setTitle(' ');
			}
			if((this.down('custompagingtoolbar') || this.xtype == 'searchresultgrid')){
				this.getHeader().insert(0, {xtype: 'customTopPagingToolBar'});
				var pagingDisplayField = this.down('#pagingDisplayField');
				if(pagingDisplayField){
					pagingDisplayField.setVisible(false);
				}
			}else{
				if(this.itemId !=='outStandingAmountDashlet' && this.xtype !=='questionpaperdocumentgrid' && this.xtype !=='servicerequestmandatorydocuments' && this.xtype !=='servicerequestvoluntarydocuments' && 
						this.xtype !=='studentfeepayerdetaildocumentgrid' && this.xtype !=='studentpassportdocumentgrid' && this.xtype !=='studentpassporturlgrid' &&
						this.xtype !=='vaccinationinfodocumentgrid' && this.xtype !=='applicantvaccinationinfodocumentgrid'&& this.xtype !=='applicantstaticdocumentattachmentgrid'
						 && this.xtype !=='studentstaticdocumentattachmentgrid'&& this.xtype !=='enquirystaticdocumentattachmentgrid'
						 && this.xtype !=='proofofactivitydocumentgrid'&& this.xtype !=='independentnonexaminingchairpersondocgrid'
						 && this.xtype !=='studentthesisuploaddocumentgrid'&& this.xtype !=='studentethicsclearanceletterdocumentgrid'
						 && this.xtype !=='studentmoudocumentgrid'&& this.xtype !=='functionaryprogressreportdocumentgrid'
						 && this.xtype !=='studentownprogressreportdocumentgrid'&& this.xtype !=='studentjointdegreedocumentgrid'&& this.xtype !=='postdocinfodocumentgrid'
						 && this.xtype !=='studenthealthinformationdocumentgrid'&& this.xtype !=='studenthealthinformationurlgrid'
						 && this.xtype !=='studenteducationhistorydocumentgrid'&& this.xtype !=='studenteducationhistoryurlgrid'
						 && this.xtype !=='studentlanguagedocumentgrid'&& this.xtype !=='studentlanguageurlgrid'
						 && this.xtype !=='trainingtypedocument'&& this.xtype !=='patenttypedocument'&& this.xtype !=='studentvisaurlgrid'&& this.xtype !=='studentvisadocumentgrid'
						 && this.xtype !=='applicantvisadocumentgrid'&& this.xtype !=='applicantvisaurlgrid'&& this.xtype !=='studentlanguagedocumentgrid'&& this.xtype !=='studentlanguageurlgrid'
						 && this.xtype !=='applicantlanguagedocdetailgrid'&& this.xtype !=='applicantlangurlgrid'&& this.xtype !=='permitdocumentgrid'&& this.xtype !=='permiturldocumentgrid'
						 && this.xtype !=='applicantpermitdocumentgrid'&& this.xtype !=='applicantpermiturldocumentgrid'&& this.xtype !=='feepayerdetaildocumentgrid'  && this.xtype !=='studenthomeworkassignmentdocumentgrid'
						 && this.xtype !=='applicanteducationhistoryurlgrid'&& this.xtype !=='applicanteducationhistorydocumentgrid'
						 && this.xtype !=='academictopicdocumentgrid'  && this.xtype !=='programbatchdocumentgrid'
						 && this.xtype !=='lessonplanningdocumentgrid' && this.xtype !=='programdocumentgrid'
						 && this.xtype !=='academictopicdocumenturlgrid' && this.xtype !=='documentandnotesdocumentgrid' && this.xtype !=='documentandnotesurlgrid'
						 && this.xtype !=='applicantpassportdocumentgrid' && this.xtype !=='applicantpassporturlgrid'
						 && this.xtype !=='applicantinsurancedocumentgrid' && this.xtype !=='applicantinsuranceurlgrid'
						 && this.xtype !=='homeworkassignmentdocumentgrid' && this.xtype !=='meetingdocumentgrid' && this.itemId !=='d365dashletgrid' 
						 && this.xtype  !=='coursesessiondocumentgrid' && this.xtype  !=='studenttransferexecutiondocumentgrid'&& this.xtype  !=='applicanthealthinformationdocumentgrid' && this.xtype  !=='applicanthealthinformationurlgrid'
						 && this.itemId  !=='plannedDetailsItemId' && this.itemId  !=='actualDetailsItemId' && this.xtype !=='multiplealandrolesgrid'
						 && this.xtype  !=='coursesessiondocumentgrid' && this.xtype  !=='studenttransferexecutiondocumentgrid'&& this.xtype  !=='applicanthealthinformationdocumentgrid' && this.xtype  !=='applicanthealthinformationurlgrid'
					     && this.xtype  !=='studentinsurancedocumentgrid' && this.xtype  !=='studentinsuranceurlgrid' && this.xtype  !=='bulkAcademicTopicDocumentGrid' && this.xtype  !=='studentexaminersreportdocumentgrid' && this.xtype  !=='positiveincidentdocumentgrid'){
					this.getHeader().insert(0, {xtype:'displayfield',
						minWidth:40,
						height:30,
						//hidden:true,
						itemId:'totalRecordDisplayField',
						name:'totalRecordDisplayField',
						cls:'total-Count-cls',
						margin:'-3x 0px 0px 10px',
						value:getCommonTranslation('TOTAL_RECORDS')+": 0"
						});
					}
			}
			if(this.down('toolbar')){
				var toolbarBtnsArray = Ext.query('#'+this.down('toolbar').id+' .x-btn');
				Ext.each(toolbarBtnsArray, function(currentbtn){
					var currentBtnCmp = Ext.getCmp(currentbtn.id);
					var btnCheck = currentBtnCmp.glyph;
					if(!currentBtnCmp.glyph){
						 btnCheck = currentBtnCmp.iconCls;
					}
					if(currentBtnCmp.icon && currentBtnCmp.icon.indexOf('print1') != -1){
						btnCheck = 'printBtn';
					}
						switch (btnCheck) {
					  case '70@Pictos':
						  var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
					    if(spanBtn && spanBtn[0]){
					    	spanBtn[0].removeAttribute('class');
					    	Ext.get(spanBtn[0]).update('');
					    	spanBtn[0].setAttribute('class','x-btn-icon-el icon-addbutton');
					    	currentBtnCmp.setIconCls('icon-addbutton')
					    	currentBtnCmp.addCls('addbutton')

					    }
					    break;
					  case 'view-icon':
						  var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
						  if(spanBtn && spanBtn[0]){
						    	spanBtn[0].removeAttribute('class');
						    	Ext.get(spanBtn[0]).update('');
						    	spanBtn[0].setAttribute('class','x-btn-icon-el icon-View');
						    	currentBtnCmp.setIconCls('icon-View');
						    	currentBtnCmp.addCls('iconView');

						    }
						  break;
					  case '116@Pictos':
						  var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
						  if(spanBtn && spanBtn[0]){
						    	spanBtn[0].removeAttribute('class');
						    	Ext.get(spanBtn[0]).update('');
						    	spanBtn[0].setAttribute('class','x-btn-icon-el icon-Delete');
						    	currentBtnCmp.setIconCls('icon-Delete');
						    	currentBtnCmp.addCls('iconDelete');

						    }
					    break;
					  case '47@Pictos':
					    var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
					    if(spanBtn && spanBtn[0]){
					    	spanBtn[0].removeAttribute('class');
					    	Ext.get(spanBtn[0]).update('');
					    	spanBtn[0].setAttribute('class','x-btn-icon-el icon-editbutton');
					    	currentBtnCmp.setIconCls('icon-editbutton');
					    	currentBtnCmp.addCls('editbutton');

					    }
				    break;
					  case 'printBtn':
						    var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
						    if(spanBtn && spanBtn[0]){
						    	spanBtn[0].removeAttribute('class');
						    	Ext.get(spanBtn[0]).update('');
						    	spanBtn[0].setAttribute('class','x-btn-icon-el print-btn');
						    	currentBtnCmp.setIconCls('print-btn');

						    }
					    break;
					  case '76@Pictos':
						    var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
						    if(spanBtn && spanBtn[0]){
						    	spanBtn[0].removeAttribute('class');
						    	Ext.get(spanBtn[0]).update('');
						    	spanBtn[0].setAttribute('class','x-btn-icon-el refresh-icon');
						    	currentBtnCmp.setIconCls('refresh-icon');
						    	currentBtnCmp.addCls('refresh-btn');

						    }
					    break;
					}
				});
				var toolItems = this.down('toolbar').items.items;
				var isTbfill = false;
				toolItems.forEach(function(item){
					if(item.xtype == 'tbfill'){
						isTbfill = true;
					}
					if(isTbfill){
						item.addCls('algin-right-cls')
					}
				});
				var splitBtn=this.query('splitbutton');
				splitBtn.forEach(function(rec){
					rec.menu && rec.menu.addCls('moreActionNewMneuBtnCls');
				    if(rec.menu && rec.menu.items && rec.menu.items.items){
				    	rec.menu.items.items.forEach(function(menuItem){
				    		menuItem.addCls('moreActionNewMneuBtnCls');
				    	});
				    }
				});
			}
		}
		
		/**
		 * Overridden Calendar for checking and adding 'Export' button.
		 * @author Raghavendra.Soni
		 */
		try{
			if(Ext.isDefined(this.showExportToPNG) && this.showExportToPNG==true){
				//--getting calendar
				var cal = this;
				
				//--getting buttonContainer to place export button
				var buttonContainer = '';
				if(cal.getDockedItems('toolbar').length){
					buttonContainer = cal.getDockedItems('toolbar')[0];
				}
				else if(cal.up().getDockedItems('toolbar').length){
					buttonContainer = cal.up().getDockedItems('toolbar')[0];
				}
				else if(Ext.isDefined(cal.up().down('fieldcontainer'))){
					buttonContainer = cal.up().down('fieldcontainer');
				}
				
				if(!isNullOrEmpty(buttonContainer)){
					//--generating random id for new export button
					var exportButtonId = randomString(7);
					
					//--adding export button to buttonContainer
					buttonContainer.add({
	        			xtype: 'button',
	        			text: getCommonTranslation('EXPORT_TO_PNG'),
	        			id: exportButtonId,
//	    				buttonAlign : 'right',
	    				ui : 'CustomBtnSubmit',
	    				itemId:'exportToPngBtn',
	    				scale : CONSTANTS.BUTTONSIZE,
	    				cls: 'cstmExportBtn',
	        			handler: function(button){
	        				//--- generating exported file name dynamically
	        				try{
	        					var tabTitle = button.up('tabpanel').getActiveTab().title;
	        				}
	        				catch(e){
	        					var tabTitle = getCommonTranslation('EXPORT_TO_PNG');
	        				}
        					var fileName = tabTitle.replace(/ /g,'_').toLowerCase() + ".png";
	        				
        					//--- reconfigure texts before exporting
        					var evtBody = Ext.query('.ext-evt-bd');
    	            		Ext.each(evtBody, function(currentEvt){
    	            			currentEvt.innerText = currentEvt.innerText.replace(/-/g, ' - ');
    	            		});
	        				var element = '';        					
	        				if(Ext.isDefined(button.up('calendarpanel'))){
	        					var isPrintBtnPresent = false;
	        					try{
	        						if(Ext.isDefined(button.up('calendarpanel').down('#btnPrint'))){
	        							button.up('calendarpanel').down('#btnPrint').el.dom.style.opacity = 0;
	        							isPrintBtnPresent = true;
	        						}
	        					}
	        					catch(e){
	        						isPrintBtnPresent = false;
	        					}
	        					button.el.dom.style.opacity = 0;

	        					var element = button.up('calendarpanel').el.dom;

	        					setTimeout(function(){
	        						button.el.dom.style.opacity = 1;
	        						if(isPrintBtnPresent){
	        							button.up('calendarpanel').down('#btnPrint').el.dom.style.opacity = 1;
	        						}
	        					},1);
	        				}
	        				else if(button.up('panel').down('calendarpanel')){
	        					var element = button.up('panel').down('calendarpanel').el.dom;
	        				}
	        				if(!isNullOrEmpty(element)){
		        				var getCanvas;
		        				html2canvas(element).then(function(canvas){
		        					document.body.appendChild(canvas);
		        		            getCanvas = canvas;
	        						var imgageData = getCanvas.toDataURL("image/png");
	        						var newData = imgageData.replace(/^data:image\/png/, "data:application/octet-stream");
	        						saveExportedPNGFile(fileName, newData);
	        						setTimeout(function(){
	        							document.body.removeChild(canvas);
	        						},300);
		        				});
	        				}
	        			}
	        		});
				}
			}
		}
		catch (e){
		}
		
		try{
			if(Ext.isDefined(this.headerFix) && Ext.isDefined(this.headerFix.headerFix) && Ext.isDefined(this.headerFix.portalIdsWithStructure) && this.headerFix.headerFix==true && Ext.Object.getSize(this.headerFix.portalIdsWithStructure)>0){
				var currentGrid = this;
				var currentPortalId = localStorage.getItem('portalId');
				Ext.each(currentGrid.headerFix.portalIdsWithStructure, function(name){
					var structureName = Object.keys(name)[0];
					var structurePortalId = Object.values(name)[0];
					if(currentPortalId==structurePortalId){
						setTimeout(function(){
							freezeCurrentGrid(currentGrid,structureName);
						},300);
					}
				});
			}
			if(Ext.isDefined(this.isGridConfigurable) && this.isGridConfigurable==true){
				var currentGrid = this;
				var currentPortalId = localStorage.getItem('portalId');
				/*if(this.itemId =='trackenquirygrid' || this.itemId =='trackcorporateenquirygrid' || this.itemId =='tracknonadmissionenquirygrid' || this.itemId == 'campaignnewgridItemId'){
					//currentGrid.addCls('hiddenMenuCls');// Don't open this comment.
				}else{
					currentGrid.addCls('hiddenMenuCls');
				}*/

				var isCBGrid = false;
				var isSync=true;
				if(!isNullOrEmpty(currentGrid.up()) && currentGrid.up().xtype == 'studentattendancegrid')
					{
					var gridClass = 'Academia.view.attendance.StudentAttendanceGrid';
					}else{
					var gridClass = currentGrid.$className;
					}
				
				
				if(gridClass.indexOf("SearchResultGrid")!=-1){
					gridClass = currentGrid.cbViewCode;
					isCBGrid = true;
					isSync=false;
				}
				
				var parentUserId = null;
				if(!isNullOrEmpty(localStorage.getItem('parentUserId')) && !isNullOrEmpty(currentPortalId) && currentPortalId==7) {
					parentUserId = localStorage.getItem('parentUserId');
				}
				
				Ext.Ajax.request({
    				type : 'rest',
    				url : SERVERURL.PATH_GET_GRID_COLUMN_CONFIGURATION,
    				params : {
    					portalId : currentPortalId,
    					parentUserId : parentUserId,
    					gridName : gridClass
    				},
    				method : 'GET',
    				async:isSync,
    				success : function(response) {
    				if(response.responseText!="") {
    					var respData = Ext.decode(response.responseText);
    					var responseData = Ext.decode(respData.jsonObject);
    					
    					var respUserData = respData;
    					
    					var hiddenColumns = [];
    					var removedColumns = [];
    					var visibleColumns = [];
    					Ext.each(responseData, function(currentResponseColumn){
    						if(currentResponseColumn.columnVisibility=="HIDE"){
    							hiddenColumns.push(currentResponseColumn.dataIndex);
    						}
    						else if(currentResponseColumn.columnVisibility=="REMOVE"){
    							removedColumns.push(currentResponseColumn.dataIndex);
    						}
    						else if(currentResponseColumn.columnVisibility=="SHOW"){
    							visibleColumns.push(currentResponseColumn.dataIndex);
    						}
    					});
    					if(!isCBGrid){
							
							if(visibleColumns.length==0)
							{
								currentGrid.headerCt.getGridColumns()[0].hide();
							}
	
    						var gridColumn=currentGrid.columns;
    						if(isNullOrEmpty(gridColumn)){
    							gridColumn=currentGrid.down('grid').columns;
    						}
        					Ext.each(gridColumn, function(currentGridColumn){
        						try{
        							if(Ext.Array.contains(hiddenColumns,currentGridColumn.dataIndex)){
        								currentGridColumn.hide();
        							}
        							/*else if(Ext.Array.contains(removedColumns,currentGridColumn.dataIndex)){
        								currentGridColumn.destroy();
        							}*/
        							else if(Ext.Array.contains(visibleColumns,currentGridColumn.dataIndex)){
        								currentGridColumn.show();
        								currentGridColumn.menuDisabled = true;
        							}
        							else{
        								currentGridColumn.hide();
        							}
        						}
        						catch(e){}
        					});
        					currentGrid.visibleColumns = visibleColumns;
    					}

    					/*currentGrid.getStore().on('beforeload',function(){
    						var baseController = Academia.app.getController('Academia.controller.base.BaseController');
    						currentGrid.getStore().getProxy().extraParams.userId = baseController.getCurrentlyLoggedInUser().id;
    						currentGrid.getStore().getProxy().extraParams.portalId = baseController.getCurrentLoggedPortalId();
    					});*/
    					
    					Ext.Ajax.request({
            				type : 'rest',
            				url : SERVERURL.PATH_GET_GRID_COLUMN_CONFIGURATION_DEFAULT,
            				params : {
            					portalId : currentPortalId,
            					gridName : gridClass
            				},
            				async:isSync,
            				method : 'GET',
            				success : function(response) {
            					var respData = Ext.decode(response.responseText);
            					var responseData1 = Ext.decode(respData[0].jsonObject);
                    			
                    			var resultGridStoreData = [];
                    			Ext.each(responseData1, function(currentGridColumn){
                    				resultGridStoreData.push({
                    					id: currentGridColumn.id,
                    					columnName: currentGridColumn.columnName,
                    					dataIndex: currentGridColumn.dataIndex,
                    					columnVisibility: currentGridColumn.columnVisibility,
                    					mandatory: currentGridColumn.mandatory,
                    					sequence: currentGridColumn.sequence
                    				});
                    			});
                    			if(currentGrid.xtype == "griddashlet"){
                    				var panel = currentGrid.up();
                    				currentGrid.up().addDataGridConfigureButtonDashlet(panel,gridClass,resultGridStoreData,responseData,respUserData);
                    			}
                    			else{
                    				var isWindow=null;
                    				if(isNullOrEmpty(currentGrid.getHeader())){
                    					var grid= currentGrid.down('grid');
                    					if(grid.up('window')){
                    						isWindow=grid.up('window');
                    					}
                    					if(!isNullOrEmpty(grid)){
                    						grid.getHeader().add({
                    							xtype: 'button',
                    							text: getCommonTranslation('COLUMNS'), 
                    							ui: 'CustomBtnSubmit',
                    							cls:'common-btn-cls',
                    							scale: CONSTANTS.BUTTONSIZE,
                    							gridClass: gridClass,
                    							hidden:true,
                    							defaultColumns: resultGridStoreData,
                    							userDefinedColumns: responseData,
                    							recordId: respUserData.id,
                    							dataGridId: respUserData.dataGridId,
                    							gridNamePath:respUserData.gridName,
                    							handler: function(btn){
                    								createColumnWindow(gridClass, btn.recordId, btn.dataGridId, btn.defaultColumns, btn.userDefinedColumns,isWindow,btn.gridNamePath);
                    							}
                    						});
                    						currentGrid.config.isGridColumnBtn=respData[0].isVisibleColumn;
                    					}
                    				}else{
                    					if(currentGrid.up('window')){
                    						isWindow=currentGrid.up('window');
                    					}
                    					currentGrid.getHeader().add({
                    				        xtype: 'button',
                    			            text: getCommonTranslation('COLUMNS'), 
                    			            ui: 'CustomBtnSubmit',
                    			            cls:'common-btn-cls',
                    		    			scale: CONSTANTS.BUTTONSIZE,
                    			            gridClass: gridClass,
                    			            hidden:true,
                    			            defaultColumns: resultGridStoreData,
                    			            userDefinedColumns: responseData,
                    			            recordId: respUserData.id,
                    			            dataGridId: respUserData.dataGridId,
                    			            gridNamePath:respUserData.gridName,
                    			            handler: function(btn){
                    			            	createColumnWindow(gridClass, btn.recordId, btn.dataGridId, btn.defaultColumns, btn.userDefinedColumns,isWindow,btn.gridNamePath);
                    			            }
                    				    });
                    					currentGrid.config.isGridColumnBtn=respData[0].isVisibleColumn;
                    				}
                    			}
            				}
            			});
    				}
    				}
				});
			}
			/**********Start Code added for clear Report Header data for again new tab open*****/
			if(Ext.isDefined(this.config) && Ext.isDefined(this.config.searchFilterForm)){
				delete this.config.searchFilterForm;
			}
			if(Ext.isDefined(this.config) && Ext.isDefined(this.config.htmlFilter)){
				delete this.config.htmlFilter;
			}
			if(Ext.isDefined(this.config) && Ext.isDefined(this.config.htmlFilterExcel)){
				delete this.config.htmlFilterExcel;
			}
			/**********End Code added for clear Report Header data for again new tab open*****/
			if((this.$className == "Ext.tree.Panel" || this.xtype == "treepanel") && this.titleAlign && this.titleAlign == "left") {
				var me = this;
				Ext.defer(function() {
					var domEl = me.el.dom.querySelector('.x-header-text-container');
					var style = document.createElement('style');
					style.type = 'text/css';
					style.innerHTML = '.x-tree-panel.x-grid .x-header-text-container { width: '+domEl.style.width+' !important;left: '+domEl.style.left+' !important; } .x-tree-panel.x-grid .x-header-text { margin-left: initial !important; }';
					document.getElementsByTagName('head')[0].appendChild(style);
					
					me.on('collapse', function() {
						Ext.defer(function() {
							var domEl = me.reExpander.el.dom.querySelector('.x-header-text-container');
							var style = document.createElement('style');
							style.type = 'text/css';
							style.innerHTML = '.x-tree-panel.x-grid .x-header-text-container { width: '+domEl.style.width+' !important;left: '+domEl.style.left+' !important; }';
							document.getElementsByTagName('head')[0].appendChild(style);
						}, 1);
					});
					me.on('beforeexpand', function() {
							var domEl = me.el.dom.querySelector('.x-header-text-container');
							var style = document.createElement('style');
							style.type = 'text/css';
							style.innerHTML = '.x-tree-panel.x-grid .x-header-text-container { width: '+domEl.style.width+' !important;left: 0px !important; }';
							document.getElementsByTagName('head')[0].appendChild(style);
					});
				}, 1);
			}
			
			/** start - validate filefield and form if filefield's browse button clicked and then cancle button **/
			if(this.xtype == "filefield" && this.allowBlank == false) {
				var fileField = this;
				fileField.on('boxready', function() {
					Ext.defer(function() {
						var inputEl = fileField.getEl().down('input[type=file]').dom;
						document.getElementById(inputEl.id).addEventListener('change', function(event) {
						// Check if files were selected
							if (event.target.files.length === 0) {
								fileField.up('form').isValid();
								fileField.clearInvalid();
							}
						});
					}, 500);
					fileField.button.on('click', function() {
						fileFieldInterval = setInterval(fileFieldTimer, 100);
						function fileFieldTimer() {
							if(fileField.up('form') && !fileField.up('form').isValid()) {
								fileField.up('form').getForm().checkValidity();
								fileField.clearInvalid();
								myStopFunction();
							}
						}

						function myStopFunction() {
							clearInterval(fileFieldInterval);
						}
					});
				});
			}
			/** end - validate filefield and form if filefield's browse button clicked and then cancle button **/
		if(this.xtype == "filefield" && this.buttonOnly == true) {
				var fileField = this;
					Ext.defer(function() {
						var inputEl = fileField.getEl().down('input[type=file]').dom;
						document.getElementById(inputEl.id).addEventListener('change', function(event) {
						// Check if files were selected
							if (event.target.files.length === 0) {
								fileField.up('form').isValid();
								fileField.clearInvalid();
								try {
                                    if(fileField.buttonOnly == true) {
                                    	var profileUploadWindow = fileField.up('window');
                                        var profileImage = profileUploadWindow.down('image');
                                    	 // **Restore the last saved image instead of the default**
                                        if (profileUploadWindow.lastSavedImageUrl) {
                                            profileImage.setSrc(profileUploadWindow.lastSavedImageUrl);
                                        } else {
                                            profileImage.setSrc('resources/images/default-profile.png');
                                        }
                                        fileField.up('window').down('#btnSaveItemId').setDisabled(true);
                                    }
                                }
                                catch (e) {}
							}
						});
					}, 500);
			}
		}
		catch(e){
			
		}
		try{
			this.callParent(arguments);
		}
		catch(e){
			
		}
	}
});

//Override Ext.Ajax.request to automatically set options.fns
Ext.override(Ext.Ajax, {
    request: function(options) {
        options = options || {};

        // Set fns to the name of the caller function if available
        try {
            if (arguments.callee.caller && !isNullOrEmpty(arguments.callee.caller)) {
                options.fns = (arguments.callee.caller.name=="")?"EMPTY":arguments.callee.caller.name;
            } else {
                options.fns = '';
            }
        } catch (e) {
            options.fns = '';
        }

        // Call the original Ext.Ajax.request with modified options
        return this.callParent([options]);
    }
});

Ext.override(Ext.form.field.Date, {
	submitFormat:CONSTANTS.NEW_SUBMIT_DATE_FORMAT,
    initComponent: function () {
        this.callParent(arguments);
        
        if (this.vtype === 'daterange') {
            this.on('change', function (field, newValue) {
                var form = field.up('form');
                if (!newValue) {
                    if (field.startDateField) {
                        var start = form.down('datefield#' + field.startDateField);
                        if (start) {
                            start.setMaxValue(null);
                            start.validate();
                        }
                    }
                    if (field.endDateField) {
                        var end = form.down('datefield#' + field.endDateField);
                        if (end) {
                            end.setMinValue(null);
                            end.validate();
                        }
                    }
                }
            });
        }
    }
});
Ext.Msg.on('show', function (msg) {
    msg.maxWidth=900;
    msg.setWidth(400);
    msg.center();
});
//--Tooltip issue on IE
Ext.override(Ext.tip.QuickTip, {
    helperElId: 'ext-quicktips-tip-helper',
    initComponent: function ()
    {
        var me = this;

        me.target = me.target || Ext.getDoc();
        me.targets = me.targets || {};
        me.callParent();

        // new stuff
        me.on('move', function ()
        {
            var offset = me.hasCls('x-tip-form-invalid') ? 35 : 27,
                helperEl = Ext.fly(me.helperElId) || Ext.fly(
                    Ext.DomHelper.createDom({
                        tag: 'div',
                        id: me.helperElId,
                        style: {
                            position: 'absolute',
                            left: '-1000px',
                            top: '-1000px',
                            'font-size': '12px',
                            'font-family': 'tahoma, arial, verdana, sans-serif'
                        }
                    }, Ext.getBody())
                );
            try{
                if(!isNullOrEmpty(me.html) && (me.html.length <= '64000' && me.html.length>='1000')){
                	helperEl.update(me.html);
                	me.setWidth(1200);
                }
                else if (me.html && (me.html !== helperEl.getHTML() || me.getWidth() !== (helperEl.dom.clientWidth + offset)))
                {
                    helperEl.update(me.html);
                    me.setWidth(Ext.Number.constrain(helperEl.dom.clientWidth + offset, me.minWidth, me.maxWidth));
                }
            }
            catch(e){
            	if (me.html && (me.html !== helperEl.getHTML() || me.getWidth() !== (helperEl.dom.clientWidth + offset)))
                {
                    helperEl.update(me.html);
                    me.setWidth(Ext.Number.constrain(helperEl.dom.clientWidth + offset, me.minWidth, me.maxWidth));
                }
            }
        }, this);
    }
});
Ext.override(Ext.window.Window,{
	initComponent: function ()
	{
		var me = this;
		me.target = me.target || Ext.getDoc();
		me.targets = me.targets || {};

		me.callParent();
		me.on('show', function ()
				{
			if(me.id !='NotificationAlertWindow') {
				var el = me.getEl();
				el.setOpacity(0);
				el.fadeIn({
					duration: 800
				});
			}
			
		}, this);

		me.on('beforeclose',function(win){
			if(win.id !='NotificationAlertWindow') {
				
			if (!win.shouldClose) {
					win.getEl().fadeOut({
						duration: 500,
						callback: function () {
							win.shouldClose = true;
							win.close();
						}
					});
				}
			return win.shouldClose ? true : false;
			}
			
		});


	}
});
//to manage sorting menu through translation //

Ext.override(Ext.form.field.File, {
	listeners:{
		change : function(field, value, eOpts){
			try{
				var filename = value.replace(/^.*[\\\/]/, '');
				if(!isValidFile(filename)){
					field.reset();
					return false;
				}
			}
			catch(e){
				//error
			}
		}
	}
});

Ext.override(Ext.grid.header.Container, {
	getMenuItems :function(){
		   var me = this,
           menuItems = [],
           hideableColumns = me.enableColumnHide ? me.getColumnMenu(me) : null;

       if (me.sortable) {
           menuItems = [{
               itemId: 'ascItem',
               text: getCommonTranslation("SORT_ASCENDING"),
               cls: me.menuSortAscCls,
               handler: me.onSortAscClick,
               scope: me
           },{
               itemId: 'descItem',
               text: getCommonTranslation("SORT_DESCENDING"),
               cls: me.menuSortDescCls,
               handler: me.onSortDescClick,
               scope: me
           }];
       }
       if (hideableColumns && hideableColumns.length) {
           if (me.sortable) {
               menuItems.push('-');
           }
           menuItems.push({
               itemId: 'columnItem',
               text: getCommonTranslation('COLUMNS'),
               cls: me.menuColsIcon,
               menu: hideableColumns,
               hideOnClick: false
           });
       }
       return menuItems;
	}	
});

/**
 * Overridden the grid to set total records
 */
Ext.override(Ext.grid.View, {
	refresh : function(grid){
		var me = this,
	        hasFocus = me.el && me.el.isAncestor(Ext.Element.getActiveElement());
	
	    me.callParent(arguments);
	    me.headerCt.setSortState();
	
	    // Create horizontal stretcher element if no records in view and there is overflow of the header container.
	    // Element will be transient and destroyed by the next refresh.
	    if (me.el && !me.all.getCount() && me.headerCt && me.headerCt.tooNarrow) {
	        me.el.createChild({style:'position:absolute;height:1px;width:1px;left:' + (me.headerCt.getFullWidth() - 1) + 'px'});
	    }
	
	    if (hasFocus) {
	        me.selModel.onLastFocusChanged(null, me.selModel.lastFocused);
	    }
	    
		var grid = this.up('grid');
		var gridDom = grid.el ? grid.el.dom : null;
		
		if(gridDom){
			 
			try{
				grid.on('hide', function(){
					try{
						Ext.query('.'+this.id)[0].style.display = 'none';
					}
					catch(e){
						//
					}
				});
				grid.on('destroy', function(){
					try{
						Ext.query('.'+this.id)[0].style.display = 'none';
					}
					catch(e){
						//
					}
				});
				grid.on('show', function(){
					try{
						Ext.query('.'+this.id)[0].style.display = '';
					}
					catch(e){
						//
					}
				});
				grid.on('afterlayout', function(curGrid){
					var curGridLeft = curGrid.el.dom.offsetLeft;
					var curGridWidth = curGrid.el.dom.offsetWidth;
					var curGridTop = curGrid.el.dom.offsetTop;
					var curGridHeight = curGrid.el.dom.offsetHeight;
					
					if(Ext.query('.'+curGrid.id).length){
						Ext.query('.'+curGrid.id)[0].style.width = '150px';
						Ext.query('.'+curGrid.id)[0].style.left = (curGridLeft + curGridWidth - 150) + 'px';
						Ext.query('.'+curGrid.id)[0].style['float'] = 'initial';
						Ext.query('.'+curGrid.id)[0].style['top'] = (curGridTop + curGridHeight + 5) + 'px';
						Ext.query('.'+curGrid.id)[0].style.position = 'absolute';
					}
					
					if(curGrid.xtype == 'fileuploadmultipledraganddrop') {
						var manageFileController = Academia.app.getController('Academia.controller.filemanagement.ManageFileController');
					    var fileuploadmultiplegrid = manageFileController.getFileUploadMultipleDragAndDrop();
					    recordCount = fileuploadmultiplegrid.getStore().getCount();
						var gridDom1 = curGrid.el.el ? curGrid.el.el.dom : null;
						if(gridDom1){
						  gridDom1.nextElementSibling.children[0].innerText = getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount;
					    }
					}
					if(curGrid.xtype == 'roleprivilege') {
					    recordCount = curGrid.getStore().getCount();
						var gridDom1 = curGrid.el.el ? curGrid.el.el.dom : null;
						if(gridDom1){
						  gridDom1.nextElementSibling.children[0].innerText = getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount;
					    }
					}
					
					//-- START HERE --- Grid Header Fix issue on tab change (Generic)
						resetGridHeaderFix(curGrid);
					//-- START HERE --- Grid Header Fix issue on tab change (Generic)
				});
			}
			catch(e){
				//
			}
			
			if(grid.xtype!=="courseparametergrid"){
				if(gridDom.parentNode && (gridDom.parentNode.lastElementChild.className== "gridTotalDivCls")){
					gridDom.parentNode.removeChild(gridDom.parentNode.lastElementChild)
				}
				
				try{
					if(gridDom.parentNode && $('.gridTotalDivCls.'+grid.id).length == 1){
						gridDom.parentNode.removeChild($('.gridTotalDivCls.'+grid.id)[0]);
					}
				}
				catch(e){
					try{
						$('.gridTotalDivCls.'+grid.id)[0].parentNode.removeChild($('.gridTotalDivCls.'+grid.id)[0]);
					}
					catch(ee){
						//--
					}
				}
			}
			
			try{
				if(grid.itemId=="applicationStageBasicSearchGrid" || grid.itemId=="exportAllGrid" || grid.itemId=="d365dashletgrid" || grid.itemId =="enquiryStaticDocumentAttachmentGridMessage"||
					  grid.xtype.indexOf("documentgrid") >= 0 || grid.itemId== "userListGrid" || grid.xtype == "hosteldocument" ||
					  grid.itemId=="userSelectedGrid" || grid.itemId=="programListGrid" || grid.itemId=="programSelectedGrid" || grid.itemId=="courseListGrid"|| 
					  grid.itemId=="courseSelectedGrid" || grid.itemId=="facultyListgrid" || grid.itemId=="facultySelectedgrid" || grid.itemId=="equipmentListGrid"||
					  grid.itemId=="equipmentSelectedGrid" || grid.itemId=="externalResourceListGrid" || grid.itemId=="externalResourceSelectedGrid"||
					  grid.itemId=="studentpassporturlgrid" || grid.itemId=="studentvisaurlgrid" || grid.itemId=="applicantpassporturlgrid"|| grid.itemId=="applicantvisaurlgrid"||
					  grid.itemId=="studenteducationhistoryurlgrid" || grid.itemId=="studentinsuranceurlgrid" || grid.itemId=="applicanteducationhistoryurlgrid" || grid.itemId=="studenthealthinformationurlgrid" || grid.itemId=="applicantinsuranceurlgrid" ||
					  grid.itemId=="applicantlanguagedocdetailgrid" || grid.itemId=="applicantlangurlgrid" ||grid.itemId=="studentlanguagedocumentgrid" ||
					  grid.itemId=="studentlanguageurlgrid" ||grid.itemId=="applicanthealthinformationurlgrid" || grid.xtype=="academictopicdocumenturlgrid" || grid.itemId=="admissionDetailDashletGrid" || grid.itemId=="positiveincidentdocumentgrid" || grid.itemId== 'studentHoldItemId'){
					//--do not show total records here
					try{
						grid.down('#totalRecordDisplayField').hide();
					}
					catch(ex){
						
					}
				}
				else if(grid.isHidden() == false && ($('.gridTotalDivCls.'+grid.id).length == 0)) {
					
					if(grid.xtype!=="courseparametergrid"){
						var totalDiv = document.createElement("div");
						totalDiv.className = "gridTotalDivCls "+grid.id;
						totalDiv.innerHTML = "<span class='totalSpanCls'>"+getCommonTranslation('TOTAL_RECORDS')+": 0</span>";
					}

					if(grid.xtype!=="courseparametergrid"){
						if(gridDom.nextSibling) {
							gridDom.parentNode.insertBefore(totalDiv, gridDom.nextSibling);
						} else {
							gridDom.parentNode.appendChild(totalDiv);
						}
						if(gridDom.style.marginBottom == "0px" || gridDom.style.marginBottom =="" ){
							gridDom.style.marginBottom = "10px";
						}
					}
					if (grid.store.totalCount) {
						if( grid.store.getCount() == 0){
							var recordCount =grid.store.getCount();
						}else{
							var recordCount =grid.store.totalCount;
						}

					}else {
						var recordCount = grid.store.getCount();
					}
					if(grid.itemId == 'sectionGridItemId' || grid.xtype == 'mapprogramoutcomegrid' || grid.xtype == 'paymenttermconfiguredocumentlistgrid' || grid.xtype == 'availableevents' || grid.xtype == 'programbatchsectiongrid'){
						var recordCount =grid.store.getCount();
					}
					if(grid.xtype!=="courseparametergrid"){
						if( recordCount == 0){
							gridDom.nextElementSibling.children[0].innerText = '';
						}else{
							gridDom.nextElementSibling.children[0].innerText = getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount;
						}
						
					}
					else{
						if(recordCount == 0){
							gridDom.nextElementSibling.children[0].children[0].children[0].children[0].children[0].innerText = '';
							
						}else{
							gridDom.nextElementSibling.children[0].children[0].children[0].children[0].children[0].innerText = getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount;	
						}
						}
						if(grid.down('#totalRecordDisplayField')){
							grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount)
						}
						if(recordCount > 0){
							grid.addCls('removeBackgroundImageCls');
							grid.removeCls('gridHeightCls');
							
						}else{
							grid.removeCls('removeBackgroundImageCls');
							grid.addCls('gridHeightCls');
						}
					grid.doLayout();
				}
			}
			catch(e){
				//--
			}
		}
	}
});

/*Ext.override(Ext.grid.header.DragZone, { //Commenting as it is creating issue while drag/drop columns
	getDragData: function(e) {
		if (e.getTarget(this.colInnerSelector)) {
            var header = e.getTarget(this.colHeaderSelector),
                headerCmp,
                ddel;

            if (header) {
                headerCmp = Ext.getCmp(header.id);
                if (!this.headerCt.dragging && headerCmp.draggable && !(headerCmp.isOnLeftEdge(e) || headerCmp.isOnRightEdge(e))) {
                    ddel = document.createElement('div');
                    ddel.innerHTML = Ext.getCmp(header.id).text;
                    $('html,body').css('cursor','move');
                    headerCmp.up('grid').addCls("movingColumnGridCls");
                    return {
                        ddel: ddel,
                        header: headerCmp
                    };
                }
            }
        }
        return false;
    }
});

Ext.override(Ext.grid.header.DropZone, {
	onNodeDrop: function(node, dragZone, e, data) {
		var me = this;
        var headerCmp = Ext.getCmp(me.id);
	    $('html,body').css('cursor','auto');
        headerCmp.up('grid').removeCls("movingColumnGridCls");
        if (this.valid) {
            var dragHeader   = data.header,
                dropLocation = data.dropLocation,
                targetHeader = dropLocation.header,
                fromCt       = dragHeader.ownerCt,
                localFromIdx = fromCt.items.indexOf(dragHeader), // Container.items is a MixedCollection
                toCt         = targetHeader.ownerCt,
                localToIdx   = toCt.items.indexOf(targetHeader),
                headerCt     = this.headerCt,
                columnManager= headerCt.columnManager,
                fromIdx      = columnManager.getHeaderIndex(dragHeader),
                toIdx        = columnManager.getHeaderIndex(targetHeader),
                colsToMove   = dragHeader.isGroupHeader ? dragHeader.query(':not([isGroupHeader])').length : 1,
                sameCt       = fromCt === toCt,
                scrollerOwner, savedWidth;

            // Drop position is to the right of the targetHeader, increment the toIdx correctly
            if (dropLocation.pos === 'after') {
                localToIdx++;
                toIdx += targetHeader.isGroupHeader ? targetHeader.query(':not([isGroupHeader])').length : 1;
            }

            // If we are dragging in between two HeaderContainers that have had the lockable
            // mixin injected we will lock/unlock headers in between sections, and then continue
            // with another execution of onNodeDrop to ensure the header is dropped into the correct group
            if (data.isLock) {
                scrollerOwner = fromCt.up('[scrollerOwner]');
                scrollerOwner.lock(dragHeader, localToIdx);
                data.isLock = false;

                // Now that the header has been transferred into the correct HeaderContainer, recurse, and continue the drop operation with the same dragData
                this.onNodeDrop(node, dragZone, e, data);
            } else if (data.isUnlock) {
                scrollerOwner = fromCt.up('[scrollerOwner]');
                scrollerOwner.unlock(dragHeader, localToIdx);
                data.isUnlock = false;

                // Now that the header has been transferred into the correct HeaderContainer, recurse, and continue the drop operation with the same dragData
                this.onNodeDrop(node, dragZone, e, data);
            }
            
            // This is a drop within the same HeaderContainer.
            else {
                this.invalidateDrop();
                // Cache the width here, we need to get it before we removed it from the DOM
                savedWidth = dragHeader.getWidth();
                
                // Dragging within the same container.
                if (sameCt) {
                    // A no-op. This can happen when cross lockable drag operations recurse (see above).
                    // If a drop was a lock/unlock, and the lock/unlock call placed the column in the
                    // desired position (lock places at end, unlock places at beginning) then we're done.
                    if (localToIdx === localFromIdx) {
                        // We still need to inform the rest of the components so that events can be fired.
                        headerCt.onHeaderMoved(dragHeader, colsToMove, fromIdx, toIdx);
                        return;
                    }
                    // If dragging rightwards, then after removal, the insertion index will be less.
                    if (localToIdx > localFromIdx) {
                        localToIdx -= 1;
                    }
                }

                // Suspend layouts while we sort all this out.
                Ext.suspendLayouts();

                if (sameCt) {
                    toCt.move(localFromIdx, localToIdx);
                } else {
                    fromCt.remove(dragHeader, false);
                    toCt.insert(localToIdx, dragHeader);
                }

                // Group headers acquire the aggregate width of their child headers
                // Therefore a child header may not flex; it must contribute a fixed width.
                // But we restore the flex value when moving back into the main header container
                if (toCt.isGroupHeader) {
                    // Adjust the width of the "to" group header only if we dragged in from somewhere else.
                    if (!sameCt) {
                        dragHeader.savedFlex = dragHeader.flex;
                        delete dragHeader.flex;
                        dragHeader.width = savedWidth;
                    }
                } else {
                    if (dragHeader.savedFlex) {
                        dragHeader.flex = dragHeader.savedFlex;
                        delete dragHeader.width;
                    }
                }

                // Refresh columns cache in case we remove an emptied group column
                headerCt.purgeCache();
                Ext.resumeLayouts(true);
                headerCt.onHeaderMoved(dragHeader, colsToMove, fromIdx, toIdx);

                // Ext.grid.header.Container will handle the removal of empty groups, don't handle it here
            }
        }
    }
});

Ext.override(Ext.dd.DragSource, {
	b4EndDrag: function(){
		var me = this;
		try{
			if(me.id.indexOf('body') == -1){
				var headerCmp = Ext.getCmp(me.id);
				$('html,body').css('cursor','auto');
				headerCmp.up('grid').removeCls("movingColumnGridCls");
			}
		}
		catch(e){
			//--
		}
	}
});*/

Ext.override(Ext.panel.Table, {
	getView: function() {
        var me = this,
            sm;

        if (!me.view) {
            sm = me.getSelectionModel();
            sm.headerWidth = 40;
            
            // TableView injects the view reference into this grid so that we have a reference as early as possible
            Ext.widget(Ext.apply({

                // Features need a reference to the grid, so configure a reference into the View
                grid: me,
                deferInitialRefresh: me.deferRowRender !== false,
                trackOver: me.trackMouseOver !== false,
                scroll: me.scroll,
                xtype: me.viewType,
                store: me.store,
                headerCt: me.headerCt,
                columnLines: me.columnLines,
                rowLines: me.rowLines,
                selModel: sm,
                features: me.features,
                panel: me,
                emptyText: me.emptyText || ''
            }, me.viewConfig));

            // Normalize the application of the markup wrapping the emptyText config.
            // `emptyText` can now be defined on the grid as well as on its viewConfig, and this led to the emptyText not
            // having the wrapping markup when it was defined in the viewConfig. It should be backwards compatible.
            // Note that in the unlikely event that emptyText is defined on both the grid config and the viewConfig that the viewConfig wins.
            if (me.view.emptyText) {
                me.view.emptyText = '<div class="' + me.emptyCls + '">' + me.view.emptyText + '</div>';
            }

            // TableView's custom component layout, Ext.view.TableLayout requires a reference to the headerCt because it depends on the headerCt doing its work.
            me.view.getComponentLayout().headerCt = me.headerCt;

            me.mon(me.view, {
                uievent: me.processEvent,
                scope: me
            });
            sm.view = me.view;
            me.headerCt.view = me.view;
        }
        return me.view;
    }
}); 

/* 
 * @since  : 19-01-2023
 * @description : validates combobox selected value
 */
Ext.override(Ext.form.field.ComboBox, {
	validateValue : function(value) {
		if(this.xtype == 'multiselectcombofield') {
			if(this.hasFocus && this.allowBlank == false) {
				var errs = this.getErrors(value);

				if((value || value != "")){
					var val = this.getValue();
					for(var i = 0;i < val.length; i++) {
						var rec;
						if(typeof val[i] == 'object' && val[i] != "") {
							rec = this.findRecord(this.valueField, val[i].data[this.valueField]);
						}
						else {
							if(val[i] != "") {
								rec = this.findRecord(this.valueField, val[i]);								
							}
						}

						if(!rec)
							errs.push("Invalid Selection"); 
					}
				}

				var error = errs[0];

				if (error == undefined) {
					this.clearInvalid();
					return true;
				} else {
					this.markInvalid(error);
					return false;
				}
			}
			else if(this.allowBlank == true) {
				return true;
			}
			else if(this.allowBlank == false && Ext.isEmpty(value)) {
				return false;
			}
			else if(this.allowBlank == false && !Ext.isEmpty(value)) {
				var rawVal = this.processRawValue(this.getRawValue());
				var errs = this.getErrors(rawVal),
		          	errCount = Ext.isEmpty(errs);
		        if (!this.preventMark) {
		            if (errCount) {
		                this.clearInvalid();
		            }
		            else {
		                this.markInvalid(errs);
		            }
		        }
		        return errCount;
				//return true;
			}
		}
		else if(this.hasFocus && this.allowBlank == false) {
			var errs = this.getErrors(value);

			if((value || value != "")){
				var val = this.getRawValue();
				if(this.xtype == 'livesearchcombo' && this.lastSelection[0]) {
                    val = this.lastSelection[0].get('value');
                }
				var rec = this.findRecord(this.displayField, val);
				if(!rec && !isNaN(parseInt(val))) {
					rec = this.findRecord(this.displayField, parseInt(val));
				}
				if(this.xtype == "timefield"){
					if(this.minValue){
						var time = this.minValue.getTime();
						if(this.getValue()){
							var currentTime = this.getValue().getTime();
							if(currentTime<time){
								this.markInvalid('The time in this field  must be equal to or after '+timeRender(this.minValue.getTime()));
								return false;
							}else{
								this.clearInvalid();
								return true;
							}
						}else{
								this.markInvalid('Not a valid time');
								return false;
						}
					}else{
						this.clearInvalid();
					}
					return true;
				}
				if(!rec)
					errs.push("Invalid Selection"); 
			}

			var error = errs[0];

			if (error == undefined) {
				this.clearInvalid();
				return true;
			} else {
				this.markInvalid(error);
				return false;
			}
		}
		else if(this.allowBlank == true) {
			if(this.xtype == "timefield"){
				if(this.minValue){
					var time = this.minValue.getTime();
					if(this.getValue()){
						var currentTime = this.getValue().getTime();
						if(currentTime<time){
							this.markInvalid('The time in this field  must be equal to or after '+timeRender(this.minValue.getTime()));
							return false;
						}else{
							this.clearInvalid();
							return true;
						}
					}else{
						if(this.getRawValue()){
							this.markInvalid('Not a valid time');
							return false;
						}
					}
				}else{
					this.clearInvalid();
				}
				return true;
			}else{
				return true;
			}
		}
		else if(this.allowBlank == false && Ext.isEmpty(value)) {
			return false;
		}
		else if(this.allowBlank == false && !Ext.isEmpty(value)) {
			return true;
		}
	}
});
Ext.override(Ext.grid.Panel, {
	titleAlign:'center',
	emptyText:' ',
	reserveScrollbar:true
});
Ext.override(Ext.tree.Panel, {
	titleAlign:'center'
});
