/*
 * @author prathamesh.sheth
 * 
 * This controller is used for PreAdmission Fees and Refund details.
 *    
 */
Ext.define('Academia.controller.admission.preAdmissionFeesAndRefund.PreAdmissionFeesAndRefundController', {
    
	extend: 'Academia.controller.admission.admissionCommon.AdmissionFormCommonController',

    alias: "widget.preadmissionfeesandrefundcontroller",

    models: ['admission.preAdmissionFeesAndRefund.preAdmissionFeesAndRefundGridModel'],

    stores: ['admission.preAdmissionFeesAndRefund.ApplicantGridStore',
             	'admission.admissionCommon.PaymentModeStore',
             	'Academia.store.admission.preAdmissionFeesAndRefund.ApplicationFeeDetailsStore','feeandpayment.managebill.BillType',
             	'feeandpayment.managebill.BillFor','feeandpayment.ALUnit','feeandpayment.BillCurrencyStore','feeandpayment.receipts.Bank',
             	'feeandpayment.receipts.FeeLedgerName','feeandpayment.FeePaymentMode','feeandpayment.receipts.DrawnOnBank','feeandpayment.receipts.CostCentreReceipt'],

    views: ['admission.preAdmissionFeesAndRefund.ApplicationFee',
            	'admission.preAdmissionFeesAndRefund.SubmissionFee',
            	'admission.preAdmissionFeesAndRefund.StageFee',
            	'admission.preAdmissionFeesAndRefund.Refund',
            	'admission.preAdmissionFeesAndRefund.ApplicantGrid',
            	'admission.preAdmissionFeesAndRefund.FeeHeadRefundGrid',
            	'admission.admissionCommon.MakePaymentForm',
            	'admission.admissionCommon.MakePaymentWindow','feeandpayment.receipts.MakePaymentWin','admission.preAdmissionFeesAndRefund.RefundAndStageFeeForm'],

    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, 
           
    /********************* Application Fee **********************/
    {
        ref: 'applicationFeeApplicantGrid',
        selector: 'preadmissionapplicantgrid[itemId=ApplicationFeeApplicantGrid]'
    }, {
        ref: 'applicationFeeMakePaymentWindow',
        selector: 'makepaymentwindow[itemId=applicationFeeMakePayment]'
    },

    /********************* Submission Fee **********************/
    {
        ref: 'submissionFeeApplicantGrid',
        selector: 'preadmissionapplicantgrid[itemId=SubmissionFeeApplicantGrid]'
    }, {
        ref: 'submissionFeeMakePaymentWindow',
        selector: 'makepaymentwindow[itemId=submissionFeeMakePayment]'
    },

    /********************* Stage Fee **********************/
    {
        ref: 'stageFeeApplicantGrid',
        selector: 'preadmissionapplicantgrid[itemId=StageFeeApplicantGrid]'
    }, {
        ref: 'stageFeeMakePaymentWindow',
        selector: 'makepaymentwindow[itemId=stageFeeMakePayment]'
    },

    /********************* Refund  **********************/
    {
        ref: 'refundApplicantGrid',
        selector: 'preadmissionapplicantgrid[itemId=RefundApplicantGrid]'
    }, {
        ref: 'refundMakePaymentWindow',
        selector: 'makepaymentwindow[itemId=refundMakePayment]'
    }, {
        ref: 'feeHeadRefundGrid',
        selector: 'refund feeheadrefundgrid[itemId=feeHeadRefundGrid]'
    }, {
        ref: 'stagefee',
        selector: 'stagefee'
    },
    {
   	 ref : 'makePaymentWin',
   	 selector : 'makepaymentwin'
    },
    {
    	ref:'refundStageView',
    	selector:'refundAndStageFeeForm[itemId=refundStageView]'
    },
    {
    	ref:'stageViewItemId',
    	selector:'refundAndStageFeeForm[itemId=stageViewItemId]'
    },
    {
    	ref:'submissionfeeItemId',
    	selector:'refundAndStageFeeForm[itemId=submissionfeeItemId]'
    }
    ],
    config: {
    	//APPLICATION_FEE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_FEE_PRIVILEGES'),
    	//SUBMISSION_FEE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SUBMISSION_FEE_PRIVILEGES'),
    	STAGE_FEE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STAGE_FEE_PRIVILEGES'),
    	REFUND_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('REFUND_PRIVILEGES')
    },
    init: function(application) {

        this.control({

            /********************* Application Fee **********************/
        	
            'preadmissionapplicantgrid[itemId=ApplicationFeeApplicantGrid]': {
            	render:function(grid){
            		var me=this;
            		grid.getStore().load();
            		
            		grid.getStore().on('beforeload', function(store, operation) {            			
            			var searchCriteria = me.createSearchCriteria(grid);
            			searchCriteria.feePlanType=grid.feePlanType;
            			searchCriteria.stageName=grid.stageName;
                        store.proxy.extraParams = searchCriteria;
                    });
            		this.disableMoreActionPivileges(grid,this.getAPPLICATION_FEE_PERMISSIONS(), '#ApplicationFeeApplicantGrid');
            	}                             
            },
            'refundAndStageFeeForm[itemId=refundStageView] button[itemId=btnFindApplication]': {
                click: function() {
                    var applicationFeeApplicantForm = this.getRefundStageView();
                   var applicationFeeApplicantGrid = this.getRefundApplicantGrid();
                    if (applicationFeeApplicantGrid) {
                        var searchCriteria = this.createSearchCriteria(applicationFeeApplicantForm);
                        applicationFeeApplicantGrid.getStore().load({
                            params: searchCriteria
                        });
                    }
                }
            },
            'refundAndStageFeeForm[itemId=refundStageView] button[itemId=resetRefundItemId]': {
                click: function(btn) {
                	btn.up('form').getForm().reset();
                }
            },                                               
            
            'preadmissionapplicantgrid[itemId=ApplicationFeeApplicantGrid] button[itemId=assignApplicationId]': {
                click: function(item, e, eOpts) {
                	var applicationFeeApplicantGrid = this.getApplicationFeeApplicantGrid();
                    this.assignApplicationId(this, applicationFeeApplicantGrid);
                }
            },
            

            'preadmissionapplicantgrid[itemId=ApplicationFeeApplicantGrid] button[itemId=makePayment]': {
                click: function(button, e, eOpts) {
                	 var grid = button.up('grid');
                    /* var selectedRecord = grid.getSelectionModel().getSelection()[0];
                     console.log(selectedRecord)
                     if(selectedRecord.get('totalFee') === 0) {
                    	 
                     }*/
                	 var applicationFeeApplicantGrid = this.getApplicationFeeApplicantGrid();
                     var window = this.getApplicationFeeMakePaymentWindow();
                     this.showMakePaymentWindow(this, applicationFeeApplicantGrid, window, 'applicationFeeMakePayment');
                }
            },

            'makepaymentwindow[itemId=applicationFeeMakePayment] button[itemId=btnCancelMakePaymentForm]': {
                click: function(button, e, eOpts) {
                    var window = this.getApplicationFeeMakePaymentWindow();
                    this.cancelMakePaymentWindow(window);
                }
            },

            'makepaymentwindow[itemId=applicationFeeMakePayment] button[itemId=btnSaveMakePaymentForm]': {
                click: function(button, e, eOpts) {
                    var grid = this.getApplicationFeeApplicantGrid();
                    //var window = this.getApplicationFeeMakePaymentWindow();
                    this.saveMakePayment(grid.getSelectionModel().getSelection()[0]);
                }
            },

            'preadmissionapplicantgrid[itemId=ApplicationFeeApplicantGrid]  textfield[itemId=txtTokenId]': {
                change: function(searchField, newValue, oldValue, eOpts) {
                    var grid = this.getApplicationFeeApplicantGrid();
                    this.hideShowSearchButton(searchField, newValue, grid);
                }
            },
            

            'preadmissionapplicantgrid[itemId=ApplicationFeeApplicantGrid] gridview': {
                expandbody: function(rowNode, record, expandRow, eOpts) {
                    var grid = this.getApplicationFeeApplicantGrid();
                    this.ExpandRowBody(this, grid, record, expandRow, 'applicantRowExpander');
                }
            },

            /********************* Submission Fee **********************/
            
            'preadmissionapplicantgrid[itemId=SubmissionFeeApplicantGrid]': {
            	render:function(grid){
            		var me=this;
            		grid.getStore().load();
            		var form = this.getSubmissionfeeItemId();
            		grid.getStore().on('beforeload', function(store, operation) {            			
            			var searchCriteria = me.createSearchCriteria(form);            
            			searchCriteria.feePlanType=grid.feePlanType;
            			searchCriteria.stageName=grid.stageName;
                        store.proxy.extraParams = searchCriteria;
                    });
            		this.disableMoreActionPivileges(grid,this.getSUBMISSION_FEE_PERMISSIONS(), '#SubmissionFeeApplicantGrid');
            	}   
                
            },
            'refundAndStageFeeForm[itemId=submissionfeeItemId] button[itemId=btnFindApplication]': {
                click: function() {
                    var submissionFeeApplicantGrid = this.getSubmissionFeeApplicantGrid();
                    var form = this.getSubmissionfeeItemId();
                    if (submissionFeeApplicantGrid) {
                        var searchCriteria = this.createSearchCriteria(form);
                        submissionFeeApplicantGrid.getStore().load({
                            params: searchCriteria
                        });
                    }
                }
            },'refundAndStageFeeForm[itemId=submissionfeeItemId] button[itemId=resetRefundItemId]': {
                click: function(btn) {
                	btn.up('#form').getForm().reset();
                }
            },
            'refundAndStageFeeForm[itemId=submissionfeeItemId]  textfield[itemId=txtTokenId]': {
                change: function(searchField, newValue, oldValue, eOpts) {
                    var submissionFeeApplicantGrid = this.getSubmissionfeeItemId();
                    this.hideShowSearchBtnRefund(searchField, newValue, submissionFeeApplicantGrid);
                }
            },
            'refundAndStageFeeForm[itemId=submissionfeeItemId]  textfield[itemId=txtApplicationId]': {
                change: function(searchField, newValue, oldValue, eOpts) {
                    var submissionFeeApplicantGrid = this.getSubmissionfeeItemId();
                    this.hideShowSearchBtnRefund(searchField, newValue, submissionFeeApplicantGrid);
                }
            },
            'refundAndStageFeeForm[itemId=submissionfeeItemId] textfield[itemId=txtApplicantName]': {
                change: function(searchField, newValue, oldValue, eOpts) {
                    var submissionFeeApplicantGrid = this.getSubmissionfeeItemId();
                    this.hideShowSearchBtnRefund(searchField, newValue, submissionFeeApplicantGrid);
                }
            },
            'refundAndStageFeeForm[itemId=submissionfeeItemId]  textfield[itemId=txtReceiptNo]': {
                change: function(searchField, newValue, oldValue, eOpts) {
                    var submissionFeeApplicantGrid = this.getSubmissionfeeItemId();
                    this.hideShowSearchBtnRefund(searchField, newValue, submissionFeeApplicantGrid);
                }
            },
                      
            'preadmissionapplicantgrid[itemId=SubmissionFeeApplicantGrid] button[itemId=assignApplicationId]': {
                click: function(item, e, eOpts) {
                	var submissionFeeApplicantGrid = this.getSubmissionFeeApplicantGrid();
                    this.assignApplicationId(this, submissionFeeApplicantGrid);
                }
            },
            

            'preadmissionapplicantgrid[itemId=SubmissionFeeApplicantGrid] button[itemId=makePayment]': {
                click: function(button, e, eOpts) {
                	 var submissionFeeApplicantGrid = this.getSubmissionFeeApplicantGrid();
                     var window = this.getSubmissionFeeMakePaymentWindow();
                     this.showMakePaymentWindow(this, submissionFeeApplicantGrid, window, 'submissionFeeMakePayment');
                }
            },

            'makepaymentwindow[itemId=submissionFeeMakePayment] button[itemId=btnCancelMakePaymentForm]': {
                click: function(button, e, eOpts) {
                    var window = this.getSubmissionFeeMakePaymentWindow();
                    this.cancelMakePaymentWindow(window);
                }
            },

            'makepaymentwindow[itemId=submissionFeeMakePayment] button[itemId=btnSaveMakePaymentForm]': {
                click: function(button, e, eOpts) {
                    var submissionFeeApplicantGrid = this.getSubmissionFeeApplicantGrid();
                    //var window = this.getSubmissionFeeMakePaymentWindow();
                    this.saveMakePayment(submissionFeeApplicantGrid.getSelectionModel().getSelection()[0]);
                }
            },

           'preadmissionapplicantgrid[itemId=SubmissionFeeApplicantGrid] gridview': {
                expandbody: function(rowNode, record, expandRow, eOpts) {
                    var submissionFeeApplicantGrid = this.getSubmissionFeeApplicantGrid();
                    this.ExpandRowBody(this, submissionFeeApplicantGrid, record, expandRow, 'applicantRowExpander');
                }
            },
            
            /********************* Stage Fee **********************/
                        
            
            'preadmissionapplicantgrid[itemId=StageFeeApplicantGrid]': {
            	render:function(grid){
            		var me=this;
            		
            		grid.getStore().getProxy().api.read =SERVERURL.FEES_PAYMENTS_STAGE_FEE_GRID_API;  //URL-rest/applicationProgramStage/searchStageApplicants
            		grid.getStore().load();            		            		            		                	        	                    	    	    	                                               	   
          	  			
            		grid.getStore().on('beforeload', function(store, operation) {            			
            			var searchCriteria = me.createSearchCriteria(grid);                                                	                            
                        store.proxy.extraParams = searchCriteria;
                    });
            		this.disableMoreActionPivileges(grid,this.getSTAGE_FEE_PERMISSIONS(), '#StageFeeApplicantGrid');
            		var assignApplicationIdButton = grid.down('#assignApplicationId');
            		var form = this.getStageViewItemId();
            		var txtReceiptNo = form.down('#txtReceiptNo');
            		
            		var btnFindApplication=form.down('#btnFindApplication');
            		txtReceiptNo.setVisible(false);
            		assignApplicationIdButton.setVisible(false);
            		btnFindApplication.setDisabled(false);
            	}                   
            },
            'refundAndStageFeeForm[itemId=stageViewItemId] button[itemId=btnFindApplication]': {
                click: function() {
                	var stageView = this.getStageViewItemId();
                    var stageFeeApplicantGrid = this.getStageFeeApplicantGrid();
                    if (stageFeeApplicantGrid) {
                        var searchCriteria = this.createSearchCriteria(stageView);
                        stageFeeApplicantGrid.getStore().load({
                            params: searchCriteria
                        });
                    }
                }
            },
            'refundAndStageFeeForm[itemId=stageViewItemId] button[itemId=resetRefundItemId]': {
                click: function(btn) {
                	btn.up('form').getForm().reset();
                }
            },
           /* 'preadmissionapplicantgrid[itemId=StageFeeApplicantGrid]  textfield[itemId=txtApplicationId]': {
                change: function(searchField, newValue, oldValue, eOpts) {
                    var stageFeeApplicantGrid = this.getStageFeeApplicantGrid();
                    this.hideShowSearchButton(searchField, newValue, stageFeeApplicantGrid);
                }
            },

            'preadmissionapplicantgrid[itemId=StageFeeApplicantGrid]  textfield[itemId=txtApplicantName]': {
                change: function(searchField, newValue, oldValue, eOpts) {
                    var stageFeeApplicantGrid = this.getStageFeeApplicantGrid();
                    this.hideShowSearchButton(searchField, newValue, stageFeeApplicantGrid);
                }
            },

            'preadmissionapplicantgrid[itemId=StageFeeApplicantGrid]  textfield[itemId=txtReceiptNo]': {
                change: function(searchField, newValue, oldValue, eOpts) {
                    var stageFeeApplicantGrid = this.getStageFeeApplicantGrid();
                    this.hideShowSearchButton(searchField, newValue, stageFeeApplicantGrid);
                }
            },    */      
            
            'preadmissionapplicantgrid[itemId=StageFeeApplicantGrid] button[itemId=assignApplicationId]': {
                click: function(item, e, eOpts) {
                	 var stageFeeApplicantGrid = this.getStageFeeApplicantGrid();
                     this.assignApplicationId(this, stageFeeApplicantGrid);
                }
            },
            

            'preadmissionapplicantgrid[itemId=StageFeeApplicantGrid] button[itemId=makePayment]': {
                click: function(button, e, eOpts) {
                	var stageFeeApplicantGrid = this.getStageFeeApplicantGrid();
                    var window = this.getStageFeeMakePaymentWindow();
                    this.showMakePaymentWindowForStage(stageFeeApplicantGrid, window, 'stageFeeMakePayment');
                }
            },

            'makepaymentwindow[itemId=stageFeeMakePayment] button[itemId=btnCancelMakePaymentForm]': {
                click: function(button, e, eOpts) {
                    var window = this.getStageFeeMakePaymentWindow();
                    this.cancelMakePaymentWindow(window);
                }
            },

            'makepaymentwindow[itemId=stageFeeMakePayment] button[itemId=btnSaveMakePaymentForm]': {
                click: function(button, e, eOpts) {
                    var stageFeeApplicantGrid = this.getStageFeeApplicantGrid();
                    //var window = this.getStageFeeMakePaymentWindow();
                    this.saveMakePayment(stageFeeApplicantGrid.getSelectionModel().getSelection()[0]);
                }
            },
            'makepaymentwin[itemId=stageFeeMakePayment] button[itemId=SubmitBtn]': {
            	click: function(button) {
            		var print = false;
            		this.makeStagePayment(button,print);
            	}
            },
            'makepaymentwin[itemId=stageFeeMakePayment] button[itemId=SubmitAndPrintMakePaymentBtn]': {
            	click: function(button) {
            		var print = true;
            		this.makeStagePayment(button,print);
            	}
            },
            

            /********************* Refund **********************/

            'refundAndStageFeeForm[itemId=refundStageView]  textfield[itemId=txtApplicationId]': {
                change: function(searchField, newValue, oldValue, eOpts) {
                    var refundApplicantGrid = this.getRefundStageView();
                    this.hideShowSearchBtnRefund(searchField, newValue, refundApplicantGrid);
                }
            },
            
            'refundAndStageFeeForm[itemId=refundStageView]  textfield[itemId=txtApplicantName]': {
                change: function(searchField, newValue, oldValue, eOpts) {
                    var refundApplicantGrid = this.getRefundStageView();
                    this.hideShowSearchBtnRefund(searchField, newValue, refundApplicantGrid);
                }
            },

            'refundAndStageFeeForm[itemId=refundStageView]  textfield[itemId=txtReceiptNo]': {
                change: function(searchField, newValue, oldValue, eOpts) {
                    var refundApplicantGrid = this.getRefundStageView();
                    this.hideShowSearchBtnRefund(searchField, newValue, refundApplicantGrid);
                }
            },
           'preadmissionapplicantgrid[itemId=RefundApplicantGrid]': {
           	render : function(grid){            		
           		this.disableMoreActionPivileges(grid,this.getREFUND_PERMISSIONS(), '#RefundApplicantGrid');
           	},
           	select :function(grid, record, index, eOpts ){
           		var feeHeadRefundGrid=this.getFeeHeadRefundGrid();
           		 this.loadComponentStore(feeHeadRefundGrid,'applicationId',record.get("id"));
           	}
           	},
           'refund feeheadrefundgrid[itemId=feeHeadRefundGrid] button#processRefund': {
            	  click: function(button) {
            		  this.updateApplicantRefundDetails(button);
            	}
            },           
            
            
            
           
            'preadmissionapplicantgrid[itemId=RefundApplicantGrid]': {
            	render:function(grid){
            		var me=this;
            		grid.getStore().load();
            		
            		grid.getStore().on('beforeload', function(store, operation) {            			
            			var searchCriteria = me.createSearchCriteria(grid);            
            			searchCriteria.feePlanType=grid.feePlanType;
            			searchCriteria.stageName=grid.stageName;
                        store.proxy.extraParams = searchCriteria;
                    });
            		this.disableMoreActionPivileges(grid,this.getREFUND_PERMISSIONS(), '#RefundApplicantGrid');
            	}   
                
            },
            
          
            
            'preadmissionapplicantgrid[itemId=RefundApplicantGrid] button[itemId=btnFindApplication]': {
                click: function() {
                	var refundApplicantGrid = this.getRefundApplicantGrid();
                    if (refundApplicantGrid) {
                        var searchCriteria = this.createSearchCriteria(refundApplicantGrid);
                        refundApplicantGrid.getStore().load({
                            params: searchCriteria
                        });
                    }
                }
            }, 
            'stagefee':{
				afterrender : function(structure){
					var grid = structure.down('preadmissionapplicantgrid');
					this.getGridHeaderFreezeWithoutPaginationCustomized(grid,structure,true);
				}
     		},                                            
            
            'preadmissionapplicantgrid[itemId=RefundApplicantGrid] button[itemId=assignApplicationId]': {
                click: function(item, e, eOpts) { 
                	var refundApplicantGrid = this.getRefundApplicantGrid();
                    this.assignApplicationId(this, refundApplicantGrid);
                }
            },
            

            'preadmissionapplicantgrid[itemId=RefundApplicantGrid] button[itemId=makePayment]': {
                click: function(button, e, eOpts) {
                	 var refundApplicantGrid = this.getRefundApplicantGrid();
                     var window = this.getRefundMakePaymentWindow();
                     this.showMakePaymentWindow(this, refundApplicantGrid, window, 'refundMakePayment');
                }
            },
            
            
            
            'makepaymentwin[itemId=refundMakePayment] nestedJsonCombo#receivingCurrency':{
            	select: function(obj,rec) {
            		var selectGrid = this.getActiveTabfromContentPanel();
            		var grid = selectGrid.down('grid');
            		var record = grid.getSelectionModel().getSelection()[0];
            		var formWindow=this.getMakePaymentWin();
            		var academyLocationId = this.getCurrentAcademyLocation();
            		
            		var fromCurrencyId = record.raw.currencyId;
            		var fromCurrencyName = record.raw.currencyName;
            		var date=formWindow.down('#transactionDate');
            
            		var receiptDate = Ext.Date.format(new Date(date.getValue()),CONSTANTS.NEW_SUBMIT_DATE_FORMAT)
            		var feeAmount = record.raw.totalFee;
            		
            		var currency = formWindow.down('#receivingCurrency');
            		var toCurrencyId=null;
            		var toCurrencyName=null;
            		if(currency!=null){
            			toCurrencyId = currency.getValue();
            			toCurrencyName = currency.getRawValue();            			
            		}

            		Ext.Ajax.request({
  		    		  method: "GET",
  		    		  type: 'rest',
  		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
  		    		  params:{
  		    			  academyLocationId:academyLocationId
  		    		  },
  		    		  success: function(response) {
  		    			  if(response){
  		    				  result=response.responseText;
  		    				  if(result === "true")
  		    				  {
  		    					  Ext.Ajax.request({
  		    		                    type: 'rest',
  		    		                    url: SERVERURL.PATH_CONVERTED_AMOUNT_BILLING_CURRENCY, 												 
  		    		                    method: 'GET',
  		    		                    headers: {
  		    		                        'Content-Type': 'application/json'
  		    		                    },
  		    		                    params: {
  		    		                    	fromCurrencyId:fromCurrencyId,
  		    		                    	toCurrencyId:toCurrencyId,
  		    		                    	receiptDate : receiptDate,
  		    		                    	feeAmount : feeAmount,
  		    		                    
  		    		                        
  		    		                    },
  		    		                   success:function(form,action) {
  		    		    					   var data = Ext.JSON.decode(form.responseText);
  		    		    					   var amountField = formWindow.down('numberfield#amount').setValue(data[0]);
  		    		    					   var instrumentAmountField = formWindow.down('numberfield#instrumentAmount').setValue(data[0]);
  		    		    			
  		    		  
  		    		    				   },
  		    		                    failure: function(form, action) {
  		    		                    	var currencyField = formWindow.down('nestedJsonCombo#receivingCurrency');
  		    		  		                currencyField.setValue(record.raw.currencyName);
  		    		  		                var amountField = formWindow.down('numberfield#amount');
  		    		  		                amountField.setValue(record.get('totalFee'));
  		    		  		                var instrumentAmountField = formWindow.down('numberfield#instrumentAmount');
  		    		  		                instrumentAmountField.setValue(record.get('totalFee'));
  		    		  		               
  		    		  		                

  		    		                    }
  		    		                    
  		    		                });
  		    	            	    
  		    					  
  		    				  }

  		    			  }
  		    			
  	            		
  	            	
  		    	    		
  		    		  }
  		    	  });
          	    
          	    

            	
            	
            	}
            },
            
            
            
            
            
            'makepaymentwin[itemId=stageFeeMakePayment] nestedJsonCombo#receivingCurrency':{
            	select: function(obj,rec) {
            		var selectGrid = this.getActiveTabfromContentPanel();
            		var grid = selectGrid.down('grid');
            		var record = grid.getSelectionModel().getSelection()[0];
            		var formWindow=this.getMakePaymentWin();
            		var academyLocationId = this.getCurrentAcademyLocation();
            		
            		var fromCurrencyId = record.raw.currencyId;
            		var fromCurrencyName = record.raw.currencyName;
            		var date=formWindow.down('#transactionDate');
            
            		var receiptDate = Ext.Date.format(new Date(date.getValue()),CONSTANTS.NEW_SUBMIT_DATE_FORMAT)
            		var feeAmount = record.data.feeAmount;
            		
            		var currency = formWindow.down('#receivingCurrency');
            		var toCurrencyId=null;
            		var toCurrencyName=null;
            		if(currency!=null){
            			toCurrencyId = currency.getValue();
            			toCurrencyName = currency.getRawValue();            			
            		}
            	
            		Ext.Ajax.request({
  		    		  method: "GET",
  		    		  type: 'rest',
  		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
  		    		  params:{
  		    			  academyLocationId:academyLocationId
  		    		  },
  		    		  success: function(response) {
  		    			  if(response){
  		    				  result=response.responseText;
  		    				  if(result === "true")
  		    				  {
  		    					  Ext.Ajax.request({
  		    		                    type: 'rest',
  		    		                    url: SERVERURL.PATH_CONVERTED_AMOUNT_BILLING_CURRENCY, 												 
  		    		                    method: 'GET',
  		    		                    headers: {
  		    		                        'Content-Type': 'application/json'
  		    		                    },
  		    		                    params: {
  		    		                    	fromCurrencyId:fromCurrencyId,
  		    		                    	toCurrencyId:toCurrencyId,
  		    		                    	receiptDate : receiptDate,
  		    		                    	feeAmount : feeAmount,
  		    		                    
  		    		                        
  		    		                    },
  		    		                   success:function(form,action) {
  		    		    					   var data = Ext.JSON.decode(form.responseText);
  		    		    					   var amountField = formWindow.down('numberfield#amount').setValue(data[0]);
  		    		    					   var instrumentAmountField = formWindow.down('numberfield#instrumentAmount').setValue(data[0]);
  		    		    			
  		    		  
  		    		    				   },
  		    		                    failure: function(form, action) {
  		    		                    	var currencyField = formWindow.down('nestedJsonCombo#receivingCurrency');
  		    		  		                currencyField.setValue(record.raw.currencyName);
  		    		  		                var amountField = formWindow.down('numberfield#amount');
  		    		  		                amountField.setValue(record.get('feeAmount'));
  		    		  		                var instrumentAmountField = formWindow.down('numberfield#instrumentAmount');
  		    		  		                instrumentAmountField.setValue(record.get('feeAmount'));
  		    		  		               
  		    		  		                

  		    		                    }
  		    		                    
  		    		                });
  		    	            	    
  		    					  
  		    				  }

  		    			  }
  		    			
  	            		
  	            	
  		    	    		
  		    		  }
  		    	  });
            	
            	
            	}
            },
            'makepaymentwin[itemId=submissionFeeMakePayment] nestedJsonCombo#receivingCurrency':{
            	select: function(obj,rec) {
            		var selectGrid = this.getActiveTabfromContentPanel();
            		var grid = selectGrid.down('grid');
            		var record = grid.getSelectionModel().getSelection()[0];
            		var formWindow=this.getMakePaymentWin();
            		var academyLocationId = this.getCurrentAcademyLocation();
            		
            		var fromCurrencyId = record.raw.currencyId;
            		var fromCurrencyName = record.raw.currencyName;
            		var date=formWindow.down('#transactionDate');
            
            		var receiptDate = Ext.Date.format(new Date(date.getValue()),CONSTANTS.NEW_SUBMIT_DATE_FORMAT)
            		var feeAmount = record.raw.totalFee;
            		
            		var currency = formWindow.down('#receivingCurrency');
            		var toCurrencyId=null;
            		var toCurrencyName=null;
            		if(currency!=null){
            			toCurrencyId = currency.getValue();
            			toCurrencyName = currency.getRawValue();            			
            		}

            		Ext.Ajax.request({
  		    		  method: "GET",
  		    		  type: 'rest',
  		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
  		    		  params:{
  		    			  academyLocationId:academyLocationId
  		    		  },
  		    		  success: function(response) {
  		    			  if(response){
  		    				  result=response.responseText;
  		    				  if(result === "true")
  		    				  {
  		    					  Ext.Ajax.request({
  		    		                    type: 'rest',
  		    		                    url: SERVERURL.PATH_CONVERTED_AMOUNT_BILLING_CURRENCY, 												 
  		    		                    method: 'GET',
  		    		                    headers: {
  		    		                        'Content-Type': 'application/json'
  		    		                    },
  		    		                    params: {
  		    		                    	fromCurrencyId:fromCurrencyId,
  		    		                    	toCurrencyId:toCurrencyId,
  		    		                    	receiptDate : receiptDate,
  		    		                    	feeAmount : feeAmount,
  		    		                    
  		    		                        
  		    		                    },
  		    		                   success:function(form,action) {
  		    		    					   var data = Ext.JSON.decode(form.responseText);
  		    		    					   var amountField = formWindow.down('numberfield#amount').setValue(data[0]);
  		    		    					   var instrumentAmountField = formWindow.down('numberfield#instrumentAmount').setValue(data[0]);
  		    		    			
  		    		  
  		    		    				   },
  		    		                    failure: function(form, action) {
  		    		                    	var currencyField = formWindow.down('nestedJsonCombo#receivingCurrency');
  		    		  		                currencyField.setValue(record.raw.currencyName);
  		    		  		                var amountField = formWindow.down('numberfield#amount');
  		    		  		                amountField.setValue(record.get('totalFee'));
  		    		  		                var instrumentAmountField = formWindow.down('numberfield#instrumentAmount');
  		    		  		                instrumentAmountField.setValue(record.get('totalFee'));
  		    		  		               
  		    		  		                

  		    		                    }
  		    		                    
  		    		                });
  		    	            	    
  		    					  
  		    				  }

  		    			  }
  		    			
  	            		
  	            	
  		    	    		
  		    		  }
  		    	  });
          	    
          	    

            	
            	
            	}
            },
            'makepaymentwin[itemId=applicationFeeMakePayment] nestedJsonCombo#receivingCurrency':{
            	select: function(obj,rec) {
            		 var $this = this;
             		var academyLocationId = $this.getCurrentAcademyLocation();
            		var selectGrid = $this.getActiveTabfromContentPanel();
            		var grid = selectGrid.down('grid');
            		var record = grid.getSelectionModel().getSelection()[0];
            		var formWindow=$this.getMakePaymentWin();
            		
            		var fromCurrencyId = record.raw.currencyId;
            		var fromCurrencyName = record.raw.currencyName;
            		var date=formWindow.down('#transactionDate');
            
            		var receiptDate = Ext.Date.format(new Date(date.getValue()),CONSTANTS.NEW_SUBMIT_DATE_FORMAT)
            		var feeAmount = record.raw.totalFee;
            		
            		var currency = formWindow.down('#receivingCurrency');
            		var toCurrencyId=null;
            		var toCurrencyName=null;
            		if(currency!=null){
            			toCurrencyId = currency.getValue();
            			toCurrencyName = currency.getRawValue();            			
            		}
            	    
            	    
            	    
            		Ext.Ajax.request({
    		    		  method: "GET",
    		    		  type: 'rest',
    		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
    		    		  params:{
    		    			  academyLocationId:academyLocationId
    		    		  },
    		    		  success: function(response) {
    		    			  if(response){
    		    				  result=response.responseText;
    		    				  if(result === "true")
    		    				  {
    		    					  Ext.Ajax.request({
    		    		                    type: 'rest',
    		    		                    url: SERVERURL.PATH_CONVERTED_AMOUNT_BILLING_CURRENCY, 												 
    		    		                    method: 'GET',
    		    		                    headers: {
    		    		                        'Content-Type': 'application/json'
    		    		                    },
    		    		                    params: {
    		    		                    	fromCurrencyId:fromCurrencyId,
    		    		                    	toCurrencyId:toCurrencyId,
    		    		                    	receiptDate : receiptDate,
    		    		                    	feeAmount : feeAmount,
    		    		                    
    		    		                        
    		    		                    },
    		    		                   success:function(form,action) {
    		    		    					   var data = Ext.JSON.decode(form.responseText);
    		    		    					   var amountField = formWindow.down('numberfield#amount').setValue(data[0]);
    		    		    					   var instrumentAmountField = formWindow.down('numberfield#instrumentAmount').setValue(data[0]);
    		    		    			
    		    		  
    		    		    				   },
    		    		                    failure: function(form, action) {
    		    		                    	var currencyField = formWindow.down('nestedJsonCombo#receivingCurrency');
    		    		  		                currencyField.setValue(record.raw.currencyName);
    		    		  		                var amountField = formWindow.down('numberfield#amount');
    		    		  		                amountField.setValue(record.get('totalFee'));
    		    		  		                var instrumentAmountField = formWindow.down('numberfield#instrumentAmount');
    		    		  		                instrumentAmountField.setValue(record.get('totalFee'));
    		    		  		               
    		    		  		                

    		    		                    }
    		    		                    
    		    		                });
    		    	            	    
    		    					  
    		    				  }

    		    			  }
    		    			
    	            		
    	            	
    		    	    		
    		    		  }
    		    	  });
            	    
            	    
            	    
            	    
            	
            	
            	}
            },
           
        });
    },
    /**
     * @author Pravin.Surve
     * This function is to enable more action button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap, itemId) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var grid = this.getContentPanel().down(itemId);
   		var assignApplicationIdButton = grid.down('#assignApplicationId');
   		var makePaymentButton =  grid.down('#makePayment');
        	
   		assignApplicationIdButton.setVisible(false);
   		makePaymentButton.setVisible(false);
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'FINDAPPLICANT') {
           		/*if(!isNullOrEmpty(findApplicationButton)){
           			findApplicationButton.setVisible(true);//enable more action button
           		}   */     		
           	}else if(privilege === 'ASSIGNAPPLID'){
           		if(!isNullOrEmpty(assignApplicationIdButton)){
           			assignApplicationIdButton.setVisible(true);
           		}
           	}else if(privilege === 'MAKEPAYMENT'){
           		if(!isNullOrEmpty(makePaymentButton)){
           			makePaymentButton.setVisible(true);
           		}
           	}
       	});
       },
       
       updateApplicantRefundDetails: function(button) {
           var grid = button.up('grid');
           if (this.validateInputs(grid)) {
               var selectedRecord = grid.getSelectionModel().getSelection()[0];
               var feeStageHeadConfigId = selectedRecord.get('feeStageHeadConfigId');
               var stageName = selectedRecord.get('stageName');
               var feePlanType = selectedRecord.get('feePlanType');
               var applicantId = selectedRecord.get('applicantId');
               var amountToRefund = selectedRecord.get('amountToRefund');

               var url = SERVERURL.APPLICANT_REFUND_AMOUNT_BILL_GENERATE;
               url = url.concat('?stageName=' + stageName);
               url = url.concat('&feePlanType=' + feePlanType);
               url = url.concat('&billFor=Applicant');
               url = url.concat('&feeStageHeadConfigId=' + feeStageHeadConfigId);
               url = url.concat('&id=' + applicantId);
               url = url.concat('&amount=' + amountToRefund);

               this.sendGetAjaxRequest(url, 'GET', null, function(opt, success, response) {
                   if (success) {
                	   showSuccessMessage(getAdmissionTranslation('FEE_HEADS_FOR_REFUND'), getAdmissionTranslation('REFUND_PAID_SUCCESS'));
                   }
               });

           } else {
               showErrorMessage(getAdmissionTranslation('FEE_HEADS_FOR_REFUND'), getAdmissionTranslation('REFUND_FEE_AMOUNT_MAX_ERROR'));
           }
       },

       validateInputs: function(grid) {
           var returnValue = true;

           if (grid.getSelectionModel().getCount() > 0) {

               var selectedRecord = grid.getSelectionModel().getSelection()[0];
               var amountToRefund = selectedRecord.get('amountToRefund');
               var feeAmount = selectedRecord.get('feeAmount');
               if (amountToRefund == 0) {
                   returnValue = false;
               }
               if (amountToRefund > feeAmount) {
                   returnValue = false;
               }
           } else {
               showWarningMessage(getAdmissionTranslation('FEE_HEADS_FOR_REFUND'), getCommonTranslation('PLEASE_SELECT_RECORD'));
           }
           return returnValue;
       },
       showMakePaymentWindowForStage:function(grid, window, itemIdValue){
    	   var me = this;
    	   if (grid.getSelectionModel().getCount() > 0) {
    		   var record = grid.getSelectionModel().getSelection()[0];
    		   if (!isEmpty(record)) {
    			   if (!window) {
    				   window = Ext.widget('makepaymentwin', { // Equivalent to Ext.create('widget.panel')
    					   itemId: itemIdValue
    				   });
    			   }
    			   window.show();
    			   var form = window.down('form');
    			   var currency = form.getForm().findField('currency')
		                var academyLocationId= record.data.academyLocationId;
		                var feeId=record.data.feeId;
		                currency.getStore().getProxy().extraParams = {
		                	academyLocationId : academyLocationId,
		                	feeId : feeId,
						};
		                currency.getStore().load();
		             
    			   form.loadRecord(record);
    			   form.down('hidden[name=id]').setValue(record.get('applicationId'));
    			   var stageNameField = form.down('hidden[name=stageName]');
    			   var feePlanTypeField = form.down('hidden[name=feePlanType]');
    			   var billId=form.down('hidden[name=billId]');
    			   billId.setValue(record.get('billId'));
    			   stageNameField.setValue('Selection Process');
    			   var billTypeCombo = form.down('combo#billType');
    			   billTypeCombo.setValue('P_AND_C_FEE');
    			   billTypeCombo.setEditable(false);
    			   billTypeCombo.setReadOnly(true);

    			   var recieptFormCombo = form.down('nestedJsonCombo#receiptForm');
    			   recieptFormCombo.setValue('APPLICANT');
    			   recieptFormCombo.setEditable(false);
    			   recieptFormCombo.setReadOnly(true);

    			   var  receiptNo = form.down("#receiptNo");
            	   if(receiptNo.readOnly != true){
            		   me.setAllowBlank(receiptNo,false);  
            		   me.setFieldPlaceHolder(receiptNo,'');
            	   }else{
            		   me.setAllowBlank(receiptNo,true);
            		   me.setFieldPlaceHolder(receiptNo,getCommonTranslation('ID_AUTOGENERATE'));
            	   }
    			   
    			   var amountField = form.down('numberfield#amount');
    			   var instrumentAmountField = form.down('numberfield#instrumentAmount');
    			   amountField.setValue(record.get('feeAmount'));
    			   instrumentAmountField.setValue(record.get('feeAmount'));
    			   amountField.setEditable(false);
    			   instrumentAmountField.setEditable(false);

    			   var studentField = form.down('textfield#student');
    			   studentField.setValue(record.get('applicantName'));
    			   studentField.setReadOnly(true);
    			   
    			   var currencyField = form.down('nestedJsonCombo#receivingCurrency');
		              var crStore = currencyField.getStore();
		          
		              
		              
		              setTimeout(function(){
		                	crStore.load({
		                		callback: function(records, operation, success) {
		                			for(var i in records){
		                				if (record.raw.currencyId == records[i].data.id) {
		                					currencyField.setValue(records[i].data.id);
		                				}
		                			}
		                		}
		                	});
		                },100);
		              

    			   if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
    				   var receiptType = form.down('#receiptType');	                           		
    				   receiptType.setVisible(false);		                           			
    			   } 
    		   }
    	   } else {
    		   showWarningMessage(getAdmissionTranslation('COLLECT_PAYMENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
    	   }

       },
     
       /* makePaymentStageFee:function(record){
      	 var serverUrl = SERVERURL.ASSIGN_APPLICATION_ID_MAKE_PAYMENT;
   		serverUrl = serverUrl.concat('?applicationId='+record.get('applicationId'));
   		this.sendSaveAjaxRequest(serverUrl, 'POST', null, function(opt,success,response){
   		});
       },*/

       makeStagePayment:function(button,print){
    	   var grid = this.getStageFeeApplicantGrid();
    	   var form = button.up('form');
    	   var window = button.up('window');
    	   var formValues = form.getValues();
    	   var applicantObject = new Object();
    	   applicantObject.id = formValues.id;
    	   formValues.raiseBillType =  'P_AND_C_FEE';
    	   formValues.applicant = applicantObject;

    	   var recieptForObj = new Object();
    	   recieptForObj.id = 2;
    	   recieptForObj.value = "APPLICANT";
    	   formValues.receiptFor = recieptForObj;

    	   var paymentMode = new Object();
    	   paymentMode.id = formValues.paymentMode;

    	   var instrumentBank = new Object();
    	   if(isNullOrEmpty(formValues.instrumentBank)) {
    		   instrumentBank.id= null;
    	   } else {
    		   instrumentBank.id = formValues.instrumentBank;
    	   }
    		var costCentreId;
        	if(isNullOrEmpty(formValues.costCentre))
        	{
        		delete formValues.costCentre;
        	}
    	   if(formValues.voucherMode === 'BANK') {
    		   var receiptPaymentInstrumentsArray = new Array();
    		   var receiptPaymentInstruments = new Object();
    		   receiptPaymentInstruments.paymentMode = paymentMode;
    		   receiptPaymentInstruments.instrumentBank = instrumentBank;
    		   receiptPaymentInstruments.instrumentNo = formValues.instrumentNo;
    		   receiptPaymentInstruments.instrumentDate = formValues.instrumentDate;
    		   receiptPaymentInstruments.amount = formValues.amount;

    		   delete formValues.instrumentDate;
    		   delete formValues.amount;

    		   receiptPaymentInstrumentsArray.push(receiptPaymentInstruments);
    		   formValues.receiptPaymentInstruments = receiptPaymentInstrumentsArray;
    	   }

    	   if(isNullOrEmpty(formValues.depositedBank)) {
    		   formValues.depositedBank = null;
    	   };

    	   if(isNullOrEmpty(formValues.depositedCash)) {
    		   formValues.depositedCash = null;
    	   };

    	   delete formValues.instrumentNo;
    	   delete formValues.depositedLedger;
    	   delete formValues.id;
    	   delete formValues.paymentMode;
    	   delete formValues.instrumentBank;
    	   delete formValues.instrumentAmount;
    	   if(formValues.customData!=undefined){
    		   delete formValues.customData;
    	   }
    	   var submitData = Ext.encode(formValues); 
    	   this$= this;
    	   // write call make payment
    	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	   this.sendSaveAjaxRequest(SERVERURL.PATH_MAKE_STAGE_FEE, 'POST', submitData, function(opt,success,response){
    		   if(success){
    			   Ext.getBody().unmask();
    			   grid.getStore().reload();
    			   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_ADD_SUCCESS')); 
    			   window.close();
    			   if(print==true){
   		  			this$.getPrintGenerateMakePayment(response.responseText);
   		  		}
    		   }
    	   });
       },
       getPrintGenerateMakePayment : function(id){
    	   	 var fileType = 'pdf';
    	   	 var $this = this;
    	    	var user=$this.getCurrentlyLoggedInUser();
    	    	var code ="MANAGE_RECEIPT_SETTLEMENT_CODE";
    	    	var reportParams =new Object();
    	    	reportParams.userId=user.code;
    	    	reportParams.ids=String(id); // convert int into string
    	    	var reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_RECEIPT_JASPER_TITLE');
    	    	var exportUrl = SERVERURL.MANAGE_RECEIPT_SETTLEMENT_PDF;
    	    	
    	    	  var store=$this.getStore('examinationcenters.IsTemplateMappedStore');
    	    	    store.getProxy().extraParams={
    	    	    	code:code
    	    	    };
    	    	    store.load({
    	    	    	callback:function(rec,obj,success){
    	    	    		if(obj.response.responseText=="true"){
    	    	    			$this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl); 
    	    	    		}else{
    	    	    			showWarningMessage(getCommonTranslation('ALERT'),getTranslation('TEMPLATE_MAPPING_ERROR'));
    	    	    		}
    	    			}
    	    	   });
    	    },
    	    hideShowSearchBtnRefund:function(searchField, newValue, grid){
    	    	if(grid){
    	    		var isButtonDisable=true;
    	    		var searchButton = grid.down("#btnFindApplication");    		
    	    		var toolBars=grid.items.items;
    	    		for(var toolBarCount=0;toolBarCount<toolBars.length;toolBarCount++){
    	    			for(var itemCount=0;itemCount<toolBars[toolBarCount].items.items.length; itemCount++){
    	        			var item=toolBars[toolBarCount].items.items[itemCount];
    	                    if(item.isXType('textfield') && !isNullOrEmpty(item.getValue())){    			
    	                    	isButtonDisable=false;
    	                    	break;
    	                    }		           	
    	    		    }   
    	    		}    		
    	    		if (isButtonDisable) {
    	                searchButton.setDisabled(true);
    	            } else {
    	                searchButton.setDisabled(false);
    	            }
    	    	}  
    	    }
   });
