/**
 * This controller is used for Quota setting
 * @author Akshay.Kalbhor
 * FIXME: [AKR] Extend the BASE CONTROLLER
 */
Ext.define('Academia.controller.admission.quotas.QuotaSettingController', {
    extend: 'Academia.controller.base.BaseController',
    
    models: [ ],
    stores: ['Academia.store.admission.quotas.QuotaTypeLists', 'Academia.store.admission.quotas.QuotaLists',
             'Academia.store.admission.quotas.QuotaValidity','common.StatusComboStore'
             ],

    views: ['Academia.view.admission.quotas.QuotasStructure',
            //Grids
            'Academia.view.admission.quotas.QuotaTypeGrid', 'Academia.view.admission.quotas.QuotaGrid',
            //Forms
            'Academia.view.admission.quotas.QuotaTypeWindow', 'Academia.view.admission.quotas.QuotaWindow',
            'Academia.view.admission.quotas.QuotaValidityWindow', 'Academia.view.admission.quotas.QuotaValidityGridWindow',
            'common.IdGeneratorForm','common.StatusCombo'],

    refs: [{
        ref: 'quotaTypeGrid',
        selector: 'quotatypegrid'
    }, {
    	ref: 'quotaTypeWindow',
    	selector: 'quotatypewindow'
    }, {
        ref: 'quotaGrid',
        selector: 'quotagrid'
    }, {
    	ref: 'quotaWindow',
    	selector: 'quotawindow'
    }, {
    	ref: 'quotaValidityWindow',
    	selector: 'quotavaliditywindow'
    }, {
        ref: 'winQuotaTypeWindow',
        selector: 'quotatypewindow'
    }],
    config: {
    	//QUOTA_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('QUOTA_PRIVILEGES'),
    	//QUOTA_TYPE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('QUOTA_TYPE_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        				//QuotaType Grid listeners
        	'quotatypegrid': {
        		render: function(grid, eOpts ) {
        			grid.getStore().load();
        			this.doAccessControlValidation(grid, this.getQUOTA_TYPE_PERMISSIONS());
        			this.disableMoreActionPivileges(grid,this.getQUOTA_TYPE_PERMISSIONS());
        		},
        		select: function(rowModel, record, index) {
        			this.onRecordSelect(rowModel, record, index);
        		}
        	},
        	
        	'quotatypegrid button':	{
        		click: function(button) {
        			if(button.itemId === 'btnAdd') {
        				this.onQuotaTypeAdd(button);
        			}else if(button.itemId === 'btnEdit') {
        				this.onQuotaTypeEdit(button);
        			}else if(button.itemId === 'btnView') {
        				this.onQuotaTypeView(button);
        			}else if(button.itemId === 'btnDelete') {
        				this.onQuotaTypeDelete(button);
        			}
        		}
        	},
        	
            'quotatypegrid button[itemId=saveReordering]': {
                click: function(button ) {
                	this.onReorderSave(button);
                }
            },
            				//QuotaType Window listeners
            'quotatypewindow button[itemId=btnSaveAddQuotaWindow]': {
            	click: function(button ) {
                	this.onNewQuotaTypeSave(button);
                }
            },
            //FIXME [AKR]: club the add edit view listeners for quotagrid
            'quotagrid button[itemId=btnAdd] menuitem': {
                click:  function(button) {
                		this.onQuotaAdd(button);
                } 
            },
            'quotagrid': {
            	render: function(grid){
            		this.doAccessControlValidation(grid, this.getQUOTA_PERMISSIONS());
            		this.disableMoreActionPivileges(grid,this.getQUOTA_PERMISSIONS());
            	}
            },
            'quotagrid button[itemId=btnEdit] menuitem': {
                click:  function(button  ) {
                	if(button.itemId === "editQuota") {
                		this.onQuotaEdit(button);
                	} else {
                		this.onEditQuotaValidityPeriod(button);
                	}
                } 
            },
            'quotagrid button[itemId=btnView] menuitem': {
                click:  function(button  ) {
					if (button.itemId === "viewQuota") {
						this.onQuotaView(button);
					} else {
						this.onViewQuotaValidityPeriod(button);
					}
                } 
            },
            'quotagrid button[itemId=btnDelete] menuitem': {
                click:  function(button  ) {
                	if (button.itemId === "deleteQuota") {
                		this.onQuotaDelete(button);
					} else {
						this.onDeleteQuotaValidityPeriod(button);
					}
                } 
            },
            'quotavaliditywindow button[itemId=btnSaveQuotaValidity]': {
            	click: function(button  ) {
            		this.onQuotaValiditySave(button);
            	}
            },
            
							//Quota Window listeners
            'quotawindow button[itemId=btnSaveQuotaDetails]': {
            	click: function(button ) {
                	this.onQuotaSave(button);
                }
            },
            
            'quotagrid button[itemId=saveReordering]': {
                click: function(button ) {
                	this.onReorderSave(button);
                }
            },
            
            'quotavaliditygridwindow button[itemId=btnEditQuotaValidity]' : {
            	click: function(button ) {
            		this.editValidityPeriod(button);
            	}
            },
            'quotavaliditygridwindow button[itemId=btnDeleteQuotaValidity]' : {
            	click: function(button) {
            		this.deleteValidityPeriod(button);
            	}
            },
            'quotatypewindow button[itemId=btnCancelAddQuotaWindow]': {
                click:function(button ) { 
                	this.cancelQuotaTypeWindow(button);
                	}
            },
            'quotatypewindow':{
            	render:function(window){
    				var $this = this
    				window.body.on('click', function() {
    					var form = window.down('idgeneratorform');
    					$this.hideInvalidIconFromField(form);
    			       });
    			}
            },
            'quotawindow':{
            	render:function(window){
    				var $this = this
    				window.body.on('click', function() {
    					var form = window.down('idgeneratorform');
    					$this.hideInvalidIconFromField(form);
    			       });
    			}
            },
            'quotavaliditywindow':{
            	render:function(window){
    				var $this = this
    				window.body.on('click', function() {
    					var form = window.down('form');
    					$this.hideInvalidIconFromField(form);
    			       });
    			}
            }
            
        });
    },

    /*
     * 	********************** Quota Type Methods ********************* 
     */
    
    /**
     * method to save the reordered structure.
     * method common for both, Quota and quota type.
     * @param {Object} button reference of the clicked button.
     * FIXME: ADD TO BASE CONTROLLER by adding a parameter 'url' and ensuring that
     *  the variable name is 'order' coming from the server side.
     */
    onReorderSave : function(button) {
    	var grid = button.up('grid');
    	var store = grid.getStore();
    	var updatedRecords =  store.getUpdatedRecords();
    	var modifiedRecords = new Ext.util.HashMap();
    	var url = null; 
    	var formMethod = 'PUT';
    	Ext.each(updatedRecords, function(rec) {
    		modifiedRecords.add(rec.get('id'), rec.get('displayOrder'));  
    	});
    	var formValues =  Ext.encode(modifiedRecords.map);
    	if(formValues !== '{}' && formValues !== "") {
    		if(button.up(grid).xtype === 'quotatypegrid') {
        		url = SERVERURL.QUOTA_TYPE_UPDATEDISPLAYORDER;
        	} else if(button.up(grid).xtype === 'quotagrid') {
        		url = SERVERURL.QUOTA_UPDATEDISPLAYORDER;
        	}
        	
        	Ext.Ajax.request({
                type: 'rest',
                url: url,
                jsonData: formValues,
                method: formMethod,
                success: function() {
               	 grid.getStore().load();
               	 grid.getSelectionModel().deselectAll(true);
                    showSuccessMessage(getAdmissionTranslation('SAVE_REORDERING'), getCommonTranslation('SUCCESS'));
                }
            });
    	} else {
    		showErrorMessage(getAdmissionTranslation('SAVE_REORDERING'), getAdmissionTranslation('REORDER_RECORD'));
    	}
    }, 
    
    /**
     * method to Add Quota type.
     * @param {Object} button: reference of the clicked button.
     */
    onQuotaTypeAdd: function(button) {
    	this.showWindow('quotaTypeWindow');
    },
    
    /**
     * method to Edit Quota type.
     * @param {Object} button: reference of the clicked button.
     */
    onQuotaTypeEdit: function(button) {
    	var grid = button.up('grid');
    	var formWindow = null;
    	if(grid.getSelectionModel().getCount()>0){
        	var quotaTypeRecord=grid.getSelectionModel().getSelection();
        		formWindow = this.showWindow('quotaTypeWindow');
        		var formRef = formWindow.down('form');
        		formRef.loadRecord(quotaTypeRecord[0]);
    	} else {
    		showWarningMessage(getAdmissionTranslation('QUOTA_TYPE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    	
    },
    
    /**
     * method to View Quota type.
     * @param {Object} button: reference of the clicked button.
     * FIXME: use the edit method by adding a viewonly parameter.
     */
    onQuotaTypeView: function(button) {
    	var grid = button.up('grid');
    	var formWindow = null;
    	if(grid.getSelectionModel().getCount()>0){
        	var quotaTypeRecord=grid.getSelectionModel().getSelection();
        		formWindow = this.showWindow('quotaTypeWindow');
        		var formRef = formWindow.down('form');
        		formRef.down('button').setVisible(false);
        		formRef.loadRecord(quotaTypeRecord[0]);
        		this.toggleReadOnlyFormItems(formRef.getForm(), true);
    	} else {
    		showWarningMessage(getAdmissionTranslation('QUOTA_TYPE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    	
    },
    
    /**
     * method to Delete Quota type.
     * @param {Object} button: reference of the clicked button.
     */
    onQuotaTypeDelete: function(button) {
    	var grid = button.up('grid');
    	var url = SERVERURL.QUOTA_TYPE_ADD_UPDATE_DELETE;
    	if(grid.getSelectionModel().getCount()>0){
    		showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    url = url.concat('/'+id);
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'DELETE',
                        url: url,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                            grid.getStore().reload();
                            showSuccessMessage(getAdmissionTranslation('QUOTA_TYPE'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
                        }
                    });
                }
            });
    	} else {
    		showWarningMessage(getAdmissionTranslation('QUOTA_TYPE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
     * method to save the quota Type.
     * @param {Object} button: reference of the clicked button.
     */
    onNewQuotaTypeSave: function(button) {
    	var this$ = this;
    	var formWindow = button.up('window');
    	var grid = this.getQuotaTypeGrid();
    	var formMethod = null;
    	var formValues = button.up('form').getValues();
    	if(formValues.id !== "" && formValues.id !== null && formValues.id !== undefined) {
    		formMethod = 'PUT';
    	} else {
    		formMethod = 'POST';
    	}
       Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	 Ext.Ajax.request({
             type: 'rest',
             url: SERVERURL.QUOTA_TYPE_ADD_UPDATE_DELETE,
             jsonData: formValues,
             method: formMethod,
             success: function() {
            	 grid.getStore().load();
            	 grid.getSelectionModel().deselectAll(true);
        		 Ext.getBody().unmask();
            	 this$.closeFormWindow(formWindow);
                 showSuccessMessage(getAdmissionTranslation('QUOTA_TYPE'), getCommonTranslation('RECORD_ADD_SUCCESS'));
             },
             failure: function(){
            	 this$.closeFormWindow(formWindow);
             }
         });
    },
    
    /**
    This function is used to set all items of form to read only mode.
    @param {view} form: is the form that has to be changed to a readOnly mode,
    @param {boolean} readOnly: is the boolean value, true to make readOnly,
     false for setting the readOnly property to false.
    */
    toggleReadOnlyFormItems: function (form, readOnly) {
        Ext.suspendLayouts();
        form.getFields().each(function(field) {    	
          field.setReadOnly(readOnly);
        });
        Ext.resumeLayouts();
    },
    
    /**
     * method to load the dependent grid of Quota List based on the selected quota type. 
     */
    onRecordSelect: function(rowModel, record, index) {
    	var dependentGrid = this.getQuotaGrid();
    	var store = dependentGrid.getStore();
    	var url = store.getProxy().proxyConfig.api.read;
    	url = url.concat('?quotaTypeId='+record.get('id')); 
    	store.getProxy().api.read = url;
    	store.load();
    },
    /*
     * 	********************** Quota Methods ********************* 
     */  
    
    /**
     * method to Add Quota and Add Quota validity.
     * @param {Object} button: reference of the clicked button.
     */
    onQuotaAdd: function(button) {
    	if(button.itemId === 'addQuota') {
    		var grid = this.getQuotaTypeGrid();
    		if(grid.getSelectionModel().getCount()>0){
    			var quotaRecord=grid.getSelectionModel().getSelection()[0];
    			formWindow = this.showWindow('quotaWindow');
    			var formRef = formWindow.down('form#quotaForm').form;
    			var quotaTypeIdField = formRef.findField('quotaTypeId');
    			quotaTypeIdField.setValue(quotaRecord.get('id'));
    		} else {
        		showWarningMessage(getAdmissionTranslation('QUOTA'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        	}
    	} else {
    		/* if itemId is addValidityPeriod for quota Validity */
    		var grid = button.up('grid');
    		if(grid.getSelectionModel().getCount()>0){
    			var quotaRecord=grid.getSelectionModel().getSelection()[0];
    			formWindow = this.showWindow('quotavaliditywindow');
        		var formRef = formWindow.down('form').form;
        		/* code to Load the id in quotaId*/
        		var quotaIdField = formRef.findField('quotaId');
    			quotaIdField.setValue(quotaRecord.get('id'));
    		} else {
        		showWarningMessage(getAdmissionTranslation('QUOTA_VALIDITY_PERIOD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        	}
    	}
    },
    
    /**
     * method to Edit Quota type.
     * @param {Object} button: reference of the clicked button.
     */
    onQuotaEdit: function(button) {
    	var grid = button.up('grid');
    	var formWindow = null;
    	if(grid.getSelectionModel().getCount()>0){
        	var quotaRecord=grid.getSelectionModel().getSelection()[0];
        		formWindow = this.showWindow('quotaWindow');
        		var formRef = formWindow.down('form').form;
        		formRef.loadRecord(quotaRecord);
        		var quotaTypeIdField = formRef.findField('quotaTypeId');
    			quotaTypeIdField.setValue(quotaRecord.raw.quotaTypeId);
    	} else {
    		showWarningMessage(getAdmissionTranslation('QUOTA'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    	
    },
    
    /**
     * method to View Quota type.
     * @param {Object} button: reference of the clicked button.
     * FIXME: use the edit method by adding a viewonly parameter.
     */
    onQuotaView: function(button) {
    	var grid = button.up('grid');
    	var formWindow = null;
    	if(grid.getSelectionModel().getCount()>0){
        	var quotaRecord=grid.getSelectionModel().getSelection();
        		formWindow = this.showWindow('quotaWindow');
        		var formRef = formWindow.down('form');
        		formRef.down('button').setVisible(false);
        		formRef.loadRecord(quotaRecord[0]);
        		this.toggleReadOnlyFormItems(formRef.getForm(), true);
    	} else {
    		showWarningMessage(getAdmissionTranslation('QUOTA'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    	
    },
    
    /**
     * method to Delete Quota type.
     * @param {Object} button: reference of the clicked button.
     */
    onQuotaDelete: function(button) {
    	var grid = button.up('grid');
    	var url = SERVERURL.QUOTA_ADD_UPDATE_DELETE;
    	if(grid.getSelectionModel().getCount()>0){
    		showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    url = url.concat('/'+id);
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'DELETE',
                        url: url,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                        	grid.getStore().load();
                        	grid.getSelectionModel().deselectAll(true);
                            showSuccessMessage(getAdmissionTranslation('QUOTA'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
                        }
                    });
                }
            });
    	} else {
    		showWarningMessage(getAdmissionTranslation('QUOTA'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
     * method to save the quota details.
     * @param {Object} button: reference of the clicked button.
     */
    onQuotaSave: function(button) {
    	var this$ = this;
    	var formMethod = null;
    	var formWindow = button.up('window');
    	var grid = this.getQuotaGrid();
    	var formValues = button.up('form').getValues();
    	if(formValues.id !== "" && formValues.id !== null && formValues.id !== undefined) {
    		formMethod = 'PUT';
    	} else {
    		formMethod = 'POST';
    	}
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	 Ext.Ajax.request({
             type: 'rest',
             url: SERVERURL.QUOTA_ADD_UPDATE_DELETE,
             jsonData: formValues,
             method: formMethod,
             success: function() {
            	 grid.getStore().load();
            	 grid.getSelectionModel().deselectAll(true);
            	 Ext.getBody().unmask();
            	 this$.closeFormWindow(formWindow);
                 showSuccessMessage(getAdmissionTranslation('QUOTA'), getCommonTranslation('RECORD_ADD_SUCCESS'));
             },
             failure: function(){
            	 this$.closeFormWindow(formWindow);
             }
         });
    },
    
    /*
     * 	********************** Quota Validity Period Methods ********************* 
     */  
 
    /**
     * method to Edit Quota type.
     * @param {Object} button: reference of the clicked button.
     */
    onEditQuotaValidityPeriod: function(button) {
    	var grid = button.up('grid');
    	var gridWindow = null;
    	if(grid.getSelectionModel().getCount()>0){
        	var quotaRecord=grid.getSelectionModel().getSelection()[0];
        		gridWindow = this.showWindow('quotavaliditygridwindow');
        		gridWindow.down('#btnDeleteQuotaValidity').setVisible(false);
        		var gridRef = gridWindow.down('grid');
        		var store = gridRef.getStore();
        		store.loadData(quotaRecord.get('quotaValidities'));
        		gridRef.reconfigure(store);
        		/*
        		 * Will be required if paging toolbar has to be added to the grid
        		 * and the value of the paging toolbar has to be updated.
        		 */
        		//gridRef.down('custompagingtoolbar').bindStore(store);
    	} else {
    		showWarningMessage(getAdmissionTranslation('QUOTA_VALIDITY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    	
    },
    
    /**
     * method to View Quota type.
     * @param {Object} button: reference of the clicked button.
     * FIXME: use the edit method by adding a viewonly parameter.
     */
    onViewQuotaValidityPeriod: function(button) {
    	var quotaGrid = button.up('grid');
    	var gridWindow = null;
    	if(quotaGrid.getSelectionModel().getCount()>0){
    		var quotaRecord = quotaGrid.getSelectionModel().getSelection()[0];
    		gridWindow = this.showWindow('quotavaliditygridwindow');
    		var gridRef = gridWindow.down('grid');
    		var store = gridRef.getStore();
    		store.loadData(quotaRecord.get('quotaValidities'));
    		gridRef.reconfigure(store);
    		/*
    		 * Code to Hide buttons toolbar for viewOnly mode
    		 */
    		var buttonsBar = gridRef.query('toolbar');
    		buttonsBar[0].setVisible(false);
    	} else {
    		showWarningMessage(getAdmissionTranslation('QUOTA_VALIDITY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    	
    },
    
    /**
     * method to Delete Quota type.
     * @param {Object} button: reference of the clicked button.
     */
    onDeleteQuotaValidityPeriod: function(button) {
    	var quotaGrid = button.up('grid');
    	var url = SERVERURL.QUOTA_ADD_UPDATE_DELETE;
    	if(quotaGrid.getSelectionModel().getCount()>0){
    		var quotaRecord = quotaGrid.getSelectionModel().getSelection()[0];
    		gridWindow = this.showWindow('quotavaliditygridwindow');
    		gridWindow.down('#btnEditQuotaValidity').setVisible(false);
    		var gridRef = gridWindow.down('grid');
    		var store = gridRef.getStore();
    		store.loadData(quotaRecord.get('quotaValidities'));
    		gridRef.reconfigure(store);
            /*var record = grid.getSelectionModel().getSelection()[0];
            var id = record.get("id");
            url = url.concat('/'+id);
            Ext.Ajax.request({
                method: "DELETE",
                type: 'DELETE',
                url: url,
                headers: {
                    'Content-Type': 'application/json'
                },
                success: function(form, action) {
                    grid.getStore().reload();
                    showSuccessMessage(getAdmissionTranslation('QUOTA_VALIDITY'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
                }
            });*/
    	} else {
    		showWarningMessage(getAdmissionTranslation('QUOTA_VALIDITY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
     * Method to save the values of the validity for a particular quota.
     * @param {Object} button: reference of the clicked button.
     */
    onQuotaValiditySave: function(button) {
    	var this$ = this;
    	var formMethod = 'POST';
    	var quota = new Object();
    	var formWindow = button.up('window');
    	var grid = this.getQuotaGrid();
    	var formValues = button.up('form').getValues();
    	quota.id = formValues.quotaId;
    	formValues.quota = quota;
    	delete formValues.quotaId;
    	if(formValues.id !== "" && formValues.id !== null && formValues.id !== undefined) {
    		formMethod = 'PUT';
    	}
    	 Ext.Ajax.request({
             type: 'rest',
             url: SERVERURL.QUOTA_VALIDITY_ADD_UPDATE_DELETE,
             jsonData: formValues,
             method: formMethod,
             success: function() {
            	 grid.getStore().load();
            	 grid.getSelectionModel().deselectAll(true);
            	 this$.closeFormWindow(formWindow);
                 showSuccessMessage(getAdmissionTranslation('QUOTA_VALIDITY'), getCommonTranslation('RECORD_ADD_SUCCESS'));
             },
             failure: function(){
            	 this$.closeFormWindow(formWindow);
                 showErrorMessage(getAdmissionTranslation('QUOTA_VALIDITY'), getCommonTranslation('FAILURE'));
             }
         });
    },
    
    /**
     * method is called when the validity period grid record is clicked and edited 
     * @param {Object} button: reference of the clicked button.
     */
    editValidityPeriod: function(button) {
    	var gridWindow = button.up('window');
    	var validityGrid = button.up('grid');
    	if(validityGrid.getSelectionModel().getCount()>0){
                var validityRecord = validityGrid.getSelectionModel().getSelection()[0];
                var quotaGrid = this.getQuotaGrid();
                var quotaGridSelection = quotaGrid.getSelectionModel().getSelection()[0];
                /*
                 *  show quotavaliditywindow & close the grid
                 */
                quotaValidityForm = this.showWindow('quotavaliditywindow');
                gridWindow.close();
                /*
                 * populate data into the window
                 */
                form = quotaValidityForm.down('form').form;
                var quotaIdField = form.findField('quotaId');
    			quotaIdField.setValue(quotaGridSelection.get('id'));
    			if(!isNullOrEmpty(validityRecord.data.validFrom)) {
    				validityRecord.data.validFrom = new Date(validityRecord.data.validFrom);
    			}
    			if(!isNullOrEmpty(validityRecord.data.validTill)) {
    				validityRecord.data.validTill = new Date(validityRecord.data.validTill);
    			}
                form.loadRecord(validityRecord);
    	} else {
    		showWarningMessage(getAdmissionTranslation('QUOTA_VALIDITY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
     * method is called when the validity period grid record is clicked and deleted 
     * @param {Object} button: reference of the clicked button
     */
    deleteValidityPeriod: function(button) {
    	var validityGrid = button.up('grid');
    	var grid = this.getQuotaGrid();
    	if(validityGrid.getSelectionModel().getCount()>0){
    		var gridWindow = button.up('window');
    		var url = SERVERURL.QUOTA_VALIDITY_ADD_UPDATE_DELETE;
    		showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                	var validityRecord = validityGrid.getSelectionModel().getSelection()[0];
                    var id = validityRecord.get("id");
                    url = url.concat('/'+id);
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'DELETE',
                        url: url,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                        	gridWindow.close();
                        	showSuccessMessage(getAdmissionTranslation('QUOTA_VALIDITY'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
                        	grid.getStore().load();
                        	grid.getSelectionModel().deselectAll(true);
                        }
                    });
                }
            });
    	} else {
    		showWarningMessage(getAdmissionTranslation('QUOTA_VALIDITY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /*
     * 	********************** Common Methods ********************* 
     */  
   
    /**
     * method to open the passed form
     * @param {Object} windowReference: reference of the form that has to be opened.
     */
    showWindow: function(windowReference) {
    	var formWindow = null;
    	switch(windowReference) {
    	case 'quotaTypeWindow':
    			formWindow = this.getQuotaTypeWindow();
    		break;
    	case 'quotaWindow':
    			formWindow = this.getQuotaWindow();
    		break;
		case 'quotaValidityWindow':
			formWindow = this.getQuotaValidityWindow();
			break;
    	}
    	
        if (!formWindow) {
        	formWindow = Ext.widget(windowReference.toLowerCase());
        }
        formWindow.show();
        
        return formWindow;
    }, 
    
    /**
     * method to close the passed formWindow
     * @param {Object} windowAlias: alias of the window that has to be closed.
     * @param {Object} windowReference: reference of the form that has to be closed.
     */
    closeFormWindow: function(windowReference) {
    	if(windowReference != null || windowReference != undefined) {
        	windowReference.close();
        } 
    },
    /**
     * @author Pravin.Surve
     * This function is to enable saveReordering button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		
   		var actionbutton = gridReference.down("#saveReordering"); //itemId of saveReordering
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'REORDER') {
           		if(!isNullOrEmpty(actionbutton)){
           			actionbutton.setVisible(true);//enable more action button
           		}      
           	}
       	});
       },
       
       /**
        * This function is used for to close Quota Type Add Dialog box after clicking on cancel button 
        */
       cancelQuotaTypeWindow: function(button) {
           this.getWinQuotaTypeWindow().close();
       }
});