/**
 * @author bhanu ps
 */
Ext.define('Academia.controller.applicationreport.ApplicationController', {
    extend: 'Academia.controller.base.BaseController',
    views: ['applicationreport.ApplicationReport', 'applicationreport.ApplicationReportForm','applicationreport.ApplicationReportFilter',
            'applicationreport.ApplicationReportGrid','salesandadmissionreport.SalesAndAdmissionReport','salesandadmissionreport.SalesAndAdmissionReportForm',
            'salesandadmissionreport.SalesAndAdmissionReportFilter','salesandadmissionreport.SalesAndAdmissionReportGrid','applicationreport.ApplicantExportReportWidow'],
            
    stores: ['common.ProgramsByAcademyIdLocationId','common.BatchesByProgramId','common.SeatTypesByBatchId',
             'reports.applicationreport.ApplicationReportListStore', 'reports.salesandadmissionreport.SalesAndAdmissionReportListStore',
             'reports.applicationreport.ApplicationDetailReportTypeStore','user.UserAcademyLocationStore',
             'admission.applications.applicantProfileBase.ApplicantSmartSearchStore','Academia.store.common.MappedProgramGroupByAL'
             ],
    config:{
    	
	},      
	refs : [{
		ref:'ApplicationReportForm',
		selector:'applicationreportform'
	},{
		ref:'applicationreportfilter',
		selector:'applicationreportfilter'
	},{
		ref:'applicationreportgrid',
		selector:'applicationreportgrid'
	},{
		ref:'SalesAndAdmissionReportForm',
		selector:'salesandadmissionreportform'
	},{
		ref:'SalesAndAdmissionReportFilter',
		selector:'salesandadmissionreportfilter'
	},{
		ref:'SalesAndAdmissionReportGrid',
		selector:'salesandadmissionreportgrid'
	},{
		ref:'applicantexportreportwidow',
		selector:'applicantexportreportwidow'
	}],        
	config: {
		APPLICATION_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_REPORT_PRIVILEGES'),
		requestType: 'STUDENT_REQUEST'   
	},
    init: function(application) {
    	
    	this.control({
    		/*FixingHeaderColumn(Applicaiton Report)*/
     		'applicationreportform':{
				afterrender : function(structure){
					var grid = structure.down('applicationreportgrid');
					this.getGridHeaderFreeze(grid,structure);
				}
     		},
     		'salesandadmissionreportform':{
				afterrender : function(structure){
					var grid = structure.down('salesandadmissionreportgrid');
					this.getGridHeaderFreezeSalesAndAdm(grid,structure);
					
					grid.down('#btnExportToPDFJasper').setDisabled(true);
					grid.down('#btnExportToExcelJasper').setDisabled(true);
				}
     		},
     		'applicationreportfilter':{
     			render:function(obj){
     				var $this = this;
     				var grid = $this.getApplicationreportgrid();
     				grid.down("#exportReportsId").setDisabled(true);

     				var currentLogInUserId = $this.getCurrentlyLoggedInUser().id;
     				var form = $this.getApplicationreportfilter().getForm();
     				var academyLocationfield = form.findField('academyLocation');
     				var alStore = academyLocationfield.getStore();
     				var programGroupField = form.findField('programGroup');
     				var applicationIdNameField = form.findField('applicantNameOrId');
     				var programField = form.findField('program');
     				
     				//acadmy store
     				alStore.getProxy().extraParams={
     					id : currentLogInUserId
     				};
     				alStore.load({
     					callback:function(records,response,success){
     						academyLocationfield.setValue($this.getCurrentAcademyLocation())
     					}
     				});
     				//programGroupField Store
     				programGroupField.getStore().getProxy().extraParams={
     					academyLocationIds:$this.getCurrentAcademyLocation()
     				};
     				programGroupField.getStore().load();
     				
     				//programField Store
     				programField.getStore().getProxy().extraParams={
     					academyLocationIds:$this.getCurrentAcademyLocation()
     				};
     				programField.getStore().load();
     				
     				//applicantnNameOrId
     				applicationIdNameField.getStore().getProxy().extraParams={
     					academyLocationId:$this.getCurrentAcademyLocation()
     				};
     				applicationIdNameField.getStore().load();
     			}
     		},
    		
    		'applicationreportfilter customcombobox[itemId=intakeYear]':{
				select:function(obj, record){
					var $this = this;
					var intakeYearId = record[0].data.id;
					var form = $this.getApplicationreportfilter().getForm();
					
					var batch = form.findField("batch");
					var seatType = form.findField("seatType");
					var al = form.findField("academyLocation").getValue();
					seatType.reset();
					seatType.setDisabled(true);
					batch.setDisabled(true);
					batch.reset();
					
					var programGroupCombo = form.findField("programGroup");
					var programGroupId = programGroupCombo.getValue();
					
					var program = form.findField("program");
					program.reset();
					program.getStore().getProxy().extraParams={
						intakeYearId : intakeYearId,
						programGroupId : programGroupId,
						academyLocationIds:al,
					};
					
					var grid = $this.getApplicationreportgrid();
					grid.down("#exportReportsId").setDisabled(false);
					
					//program.getStore().load();
					var programStore = program.getStore();
					program.setReadOnly(false);
					programStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length == 1){
									program.setValue(records[0].data.id);
									var model = [records[0]];
									program.fireEvent('select', program, model);
									program.setReadOnly(true);
								}	 
							}
						}	   
					});
				}
    		},
    		'applicationreportfilter customcombobox[itemId=programItemId]':{
				select:function(obj, record){
					var $this = this;
					var data = null
					if(record[0]!=undefined){
						data = record[0].data.id;	
					}else{
						data = record.raw.id;
					}
					var form = $this.getApplicationreportfilter().getForm();
					var batch = form.findField("batch");
					var seatType = form.findField("seatType");
					seatType.reset();
					seatType.setDisabled(true);
					batch.setDisabled(false);
					batch.reset();
					batch.getStore().getProxy().extraParams={
						id:data,
					};
					var batchStore = batch.getStore();
					batch.setReadOnly(false);
					batchStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length == 1){
									batch.setValue(records[0].data.id);
									var model = [records[0]];
									batch.fireEvent('select', batch, model);
									batch.setReadOnly(true);
								}	 
							}
						}	   
					});
				},
    		},
    		'applicationreportfilter customcombobox[itemId=programGroupItemId]':{
				select:function(obj, record){
					var $this = this;
					var form = $this.getApplicationreportfilter().getForm();
					var intakeYearCombo = form.findField("intakeYear");
					var intakeYearId = intakeYearCombo.getValue();
					var programGroupId = record[0].data.id;
					
					var batch = form.findField("batch");
					var seatType = form.findField("seatType");
					seatType.reset();
					seatType.setDisabled(true);
					batch.setDisabled(true);
					batch.reset();
					
					var program = form.findField("program");
					program.reset();
					program.getStore().getProxy().extraParams={
						academyLocationIds:$this.getCurrentAcademyLocation(),
						programGroupId : programGroupId,
						intakeYearId : intakeYearId
					};
					var programStore = program.getStore();
					program.setReadOnly(false);
					programStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length == 1){
									program.setValue(records[0].data.id);
									var model = [records[0]];
									program.fireEvent('select', program, model);
									program.setReadOnly(true);
								}	 
							}
						}	   
					});
				}
    		},
    		'applicationreportfilter customcombobox[itemId=batchItemId]':{
				select:function(obj, record){
					var $this = this;
					var data = record[0].data.id;
					var form = $this.getApplicationreportfilter().getForm();
					var seatType = form.findField("seatType");
					seatType.reset();
					seatType.setDisabled(false);
					seatType.getStore().getProxy().extraParams={
						batchId:data,
					};
					//seatType.getStore().load();
					var seatTypeStore = seatType.getStore();
					seatType.setReadOnly(false);
					seatTypeStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length == 1){
									seatType.setValue(records[0].data.seatTypeId);
									var model = [records[0]];
									seatType.fireEvent('select', seatType, model);
									seatType.setReadOnly(true);
								}	 
							}
						}	   
					});
					
					/*var grid = $this.getApplicationreportgrid();
					grid.down("#exportReportsId").setDisabled(false);*/
				}
    		},
    		'applicationreportfilter button[itemId=resetBtn]':{
				click:function(obj, record){
					var $this = this;
					var grid = $this.getApplicationreportgrid();
					grid.down("#exportReportsId").setDisabled(true);
					var form = $this.getApplicationreportfilter().getForm();
					var applicationIdNameField = form.findField('applicantNameOrId');
					applicationIdNameField.reset();
					var programGroupField = form.findField('programGroup');
					programGroupField.reset();
					var academyLocationfield = form.findField('academyLocation');
					academyLocationfield.reset();
     				var programField = form.findField('program');
     				programField.reset();
					var seatType = form.findField("seatType");
					var batch = form.findField("batch");
					var currentLogInUserId = $this.getCurrentlyLoggedInUser().id;
     				var alStore = academyLocationfield.getStore();
     				//acadmy store
     				alStore.getProxy().extraParams={
     					id : currentLogInUserId
     				};
     				alStore.load({
     					callback:function(records,response,success){
     						academyLocationfield.setValue($this.getCurrentAcademyLocation())
     					}
     				});

     				//programField Store
     				programField.getStore().getProxy().extraParams={
     					academyLocationIds:$this.getCurrentAcademyLocation()
     				};
     				programField.getStore().load();
     				
     				//applicantnNameOrId
     				applicationIdNameField.getStore().getProxy().extraParams={
     					academyLocationId:$this.getCurrentAcademyLocation()
     				};
     				applicationIdNameField.getStore().load();
     				//programGroupField Store
     				programGroupField.getStore().getProxy().extraParams={
     					academyLocationIds:$this.getCurrentAcademyLocation()
     				};
     				programGroupField.getStore().load();
     				batch.setDisabled(true);
					seatType.setDisabled(true);
					form.findField("startDate").setMaxValue(null);
    				form.findField("startDate").setMinValue(null);
    				form.findField("endDate").setMaxValue(null);
    				form.findField("endDate").setMinValue(null);
     				form.reset();
				}
    		},
    		
        	'applicationreportfilter button[itemId=searchBtn]':{
				click:function(obj, record){
					this.loadGrid();
				}
    		},

    		'applicationreportgrid button[itemId=exportReportsId]':{
				click:function(obj){
					this.showApplicantReportExportWin();
				}
    		},
    		
    		'applicationreportgrid': {
                render: function(grid) {
                	this.doAccessControlValidation(grid, this.getAPPLICATION_REPORT_PERMISSIONS());
                	this.disableExportBtnActionPivileges(grid, this.getAPPLICATION_REPORT_PERMISSIONS());
                	var buttonsToolBar = grid.query('toolbar')[0];
           		    var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
                	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
                	pdftoolbar.setDisabled(true);
                	exceltoolbar.setDisabled(true);
                }
    		},
    		
    		'salesandadmissionreportfilter multiselectcombofield[itemId=multiselectAcademyId]':{
    			afterrender:function(obj, record){
					var $this = this;
					obj.getStore().load({
						callback: function(record){
							obj.select(obj.getStore().collect(obj.valueField));
						}
					});
				}
    		},
    		
    		'salesandadmissionreportfilter button[itemId=searchBtn]': {
                click: function(btn) {
                	var me = this;
                	//this.doAccessControlValidation(grid, this.getAPPLICATION_REPORT_PERMISSIONS());
                	//this.disableExportBtnActionPivileges(grid, this.getAPPLICATION_REPORT_PERMISSIONS());
                	var formforsalesandadmission =  me.getSalesAndAdmissionReportFilter();
                	var multiselectAcademyIdField = me.getSalesAndAdmissionReportFilter().down('#multiselectAcademyId');
                	var intakeYearField = me.getSalesAndAdmissionReportFilter().down('#intakeYear');
                	var seatTypeField = me.getSalesAndAdmissionReportFilter().down('#seatType');
                	var grid = me.getSalesAndAdmissionReportGrid();
                	 var buttonsToolBar = grid.query('toolbar')[0];
                	 var pdftoolbar = buttonsToolBar.query('#btnExportToPDFJasper')[0];
                	 var exceltoolbar = buttonsToolBar.query('#btnExportToExcelJasper')[0];
                	 var override = grid.plugins[0];
                	
                	var intakeYearId = intakeYearField.getValue();
                	var academyIdsArray = multiselectAcademyIdField.getValue();
                	var seatTypeIds = seatTypeField.getValue();
                	
                	if(typeof academyIdsArray[0]!="object"){
                		var academyIds = academyIdsArray.join(',');
                	}
                	else {
                		var academyIdsTempArray = [];
                		Ext.each(academyIdsArray,function(currentAcademyId){
                			academyIdsTempArray.push(currentAcademyId.data.id);
                		});
                		var academyIds = academyIdsTempArray.join(',');
                	}
                	
                    if (!isNullOrEmpty(seatTypeIds) && !isNullOrEmpty(seatTypeIds[0])) {
                    	var seatTypeIdsArray=[];
                    	for(var i in seatTypeIds) {
                    		if(typeof seatTypeIds[i] == "object") {
                    			seatTypeIdsArray.push(seatTypeIds[i].data.id);
                    		} else {
                    			seatTypeIdsArray.push(seatTypeIds[i]);
                    		}
                    	}
                    	var seatTypeIdsString = seatTypeIdsArray.join(",");
                    	seatTypeIdsString = seatTypeIdsString.toString();
                    }
                	
                	grid.getStore().getProxy().extraParams = {
						intakeYearId:intakeYearId,
						academyIds:academyIds,
						seatTypeIds:seatTypeIdsString
					};
                	
                	grid.getStore().load({
						callback: function(record){
							//--Add Extra Record for Organization In Store
							if(record.length){
								console.log(grid);
								var newOrgRecord = record[0].data;
								
								newOrgRecord.academyName = newOrgRecord.academyName;
								
								newOrgRecord.currLeads = newOrgRecord.currLeadsOrg;
								newOrgRecord.currAp = newOrgRecord.currApOrg;
								newOrgRecord.currAprvd_ap = newOrgRecord.currAprvdApOrg;
								newOrgRecord.currEnrol = newOrgRecord.currEnrolOrg;
								
								newOrgRecord.perc_leads_ap = newOrgRecord.org_perc_leads_ap;
								newOrgRecord.perc_leads_aprvd_ap = newOrgRecord.org_perc_leads_aprvd_ap;
								newOrgRecord.perc_leads_enrol = newOrgRecord.org_perc_leads_enrol;
								
								newOrgRecord.perc_prev_stg_ap = newOrgRecord.org_perc_prev_stg_ap;
								newOrgRecord.perc_prev_stg_aprvd_ap = newOrgRecord.org_perc_prev_stg_aprvd_ap;
								newOrgRecord.perc_prev_stg_enrol = newOrgRecord.org_perc_prev_stg_enrol;
								
								newOrgRecord.prevLeads = newOrgRecord.prevLeadsOrg;
								newOrgRecord.prevAp = newOrgRecord.prevApOrg;
								newOrgRecord.prevAprvdAp = newOrgRecord.prevAprvdApOrg;
								newOrgRecord.prevEnrol = newOrgRecord.prevEnrolOrg;
								
								newOrgRecord.prev_perc_leads_ap = newOrgRecord.org_prev_perc_leads_ap;
								newOrgRecord.prev_perc_leads_aprvd_ap = newOrgRecord.org_prev_perc_leads_aprvd_ap;
								newOrgRecord.prev_perc_leads_enrol = newOrgRecord.org_prev_perc_leads_enrol;
								
								newOrgRecord.prev_perc_prev_stg_ap = newOrgRecord.org_prev_perc_prev_stg_ap;
								newOrgRecord.prev_perc_prev_stg_aprvd_ap = newOrgRecord.org_prev_perc_prev_stg_aprvd_ap;
								newOrgRecord.prev_perc_prev_stg_enrol = newOrgRecord.org_prev_perc_prev_stg_enrol;
								
								newOrgRecord.abs_chng_leads = newOrgRecord.org_abs_chng_leads;
								newOrgRecord.abs_chng_ap = newOrgRecord.org_abs_chng_ap;
								newOrgRecord.abs_chng_aprvd_ap = newOrgRecord.org_abs_chng_aprvd_ap;
								newOrgRecord.abs_chng_enrol = newOrgRecord.org_abs_chng_enrol;
								
								newOrgRecord.abs_perc_chng_leads = newOrgRecord.org_abs_perc_chng_leads;
								newOrgRecord.abs_perc_chng_ap = newOrgRecord.org_abs_perc_chng_ap;
								newOrgRecord.abs_perc_chng_aprvd_ap = newOrgRecord.org_abs_perc_chng_aprvd_ap;
								newOrgRecord.abs_perc_chng_enrol = newOrgRecord.org_abs_perc_chng_enrol;
								
								//grid.getStore().add(newOrgRecord);
								
								//--Expand All Code Here
								override.expandAll();
								
								//--updateTotalRecord Count
								grid.getStore().totalCount = grid.getStore().count();
								grid.getView().refresh();
							}
				 			if(record.length>0){
				 				    	pdftoolbar.setDisabled(false);
									   exceltoolbar.setDisabled(false);
				 					}
						}
					});
                	
                	/***************Start Code added for show filter data on PDF/Excel Export Report **************/
                	    	
                     	grid.config.searchFilterForm = me.getSalesAndAdmissionReportFilter();
                	    	
                	        /***************End Code added for show filter data on PDF/Excel Export Report **************/
                },
                disable: function( me, eOpts ){
                	var grid = Ext.ComponentQuery.query('salesandadmissionreportgrid')[0];
                	grid.down('#btnExportToPDFJasper').setDisabled(true);
					grid.down('#btnExportToExcelJasper').setDisabled(true);
                },
               /* enable: function( me, eOpts ){
                	var grid = Ext.ComponentQuery.query('salesandadmissionreportgrid')[0];
                	grid.down('#btnExportToPDFJasper').setDisabled(false);
					grid.down('#btnExportToExcelJasper').setDisabled(false);
                }*/
    		},
    		
    		'salesandadmissionreportfilter button[itemId=resetBtn]':{
				click:function(obj, record){
					var $this = this;
					var form = $this.getSalesAndAdmissionReportFilter().getForm();
					var multiselectAcademy = form.findField("multiselectAcademy");
					var intakeYear = form.findField("intakeYear");
					multiselectAcademy.reset();
					intakeYear.reset();
					form.reset();
				}
    		},
    		
    		'salesandadmissionreportgrid splitbutton[itemId=btnExportToPDFJasper] #exportPDFCurrentPage':{
    			click : function() {
    				this.exportPDFSalesAndAdmissionSummaryReport();
    			}
    		},
    		
    		'salesandadmissionreportgrid splitbutton[itemId=btnExportToExcelJasper] #exportExcelCurrentPage':{
    			click : function() {
    				this.exportXLSalesAndAdmissionSummaryReport();
    			}
    		},
	        'applicantexportreportwidow button#btnDownload': {
	        	click: function(button) {
	        		var exportWindow = this.getApplicantexportreportwidow();
	        		var applicantDetailReportTypeField = exportWindow.down('#applicantDetailReportType');
	        		var reportTypeValue = applicantDetailReportTypeField.getValue();
	        		this.exportXLFunction(reportTypeValue);
	        		if(Ext.isDefined(exportWindow)){
	        			exportWindow.close();
	        		}
	        	}
	        },
	        'applicationreportfilter customcombobox[itemId=academyLocation]':{
	        	select:function(obj, record){
	        		var $this = this;
	        		var academyLocationId = record[0].data.id;
	        		var form = $this.getApplicationreportfilter().getForm();

	        		var batch = form.findField("batch");
	        		var program = form.findField("program");
	        		var programStore = program.getStore();
	        		var seatType = form.findField("seatType");
	        		var programGroupField = form.findField('programGroup');
	        		var intakeYearId = form.findField("intakeYear");
	        		var applicantNameOrId = form.findField("applicantNameOrId");
	        		
	        		batch.reset();
	        		seatType.reset();
	        		batch.setDisabled(true);
	        		programGroupField.reset();
	        		applicantNameOrId.reset();
	        		seatType.setDisabled(true);
	        		intakeYearId.reset();
	        		
	        		//ApplicantNameOrId
	        		applicantNameOrId.getStore().getProxy().extraParams={
	        			academyLocationId:academyLocationId
	        		};
	        		applicantNameOrId.getStore().load();
	        		
	        		//programGroupField Store
	        		programGroupField.getStore().getProxy().extraParams={
	        			academyLocationIds:academyLocationId
	        		};
	        		programGroupField.getStore().load();
	        		
	        		//programField Store
	        		program.reset();
	        		program.getStore().getProxy().extraParams={
	        			academyLocationIds:academyLocationId,
	        		};
	        		program.setReadOnly(false);
	        		programStore.load({
	        			callback: function(records, operation, success) {
	        				if (success) {
	        					if(records.length == 1){
	        						program.setValue(records[0].data.id);
	        						var model = [records[0]];
	        						program.fireEvent('select', program, model);
	        					}	 
	        				}
	        			}	   
	        		});
	        	}
	        }
    	});
    },
    
    exportPDFSalesAndAdmissionSummaryReport : function(){
		var $this=this;
		var salesAndAdmissionReportFilter = this.getSalesAndAdmissionReportFilter();
		var formValues = salesAndAdmissionReportFilter.getValues();
		var code = 'VelocitySalesAndAdmissionSummaryReport';
		
		var intakeYearId = formValues.intakeYear;
    	var academyIdsArray = formValues.multiselectAcademy;
    	
    	if(typeof academyIdsArray[0]!="object"){
    		var academyIds = academyIdsArray.join(',');
    	}
    	else {
    		var academyIdsTempArray = [];
    		Ext.each(academyIdsArray,function(currentAcademyId){
    			academyIdsTempArray.push(currentAcademyId.data.id);
    		});
    		var academyIds = academyIdsTempArray.join(',');
    	}
		
		var reportParams =new Object();
		reportParams.academyIds = academyIds;
		reportParams.intakeYearId=intakeYearId;
		
		var reportTitle=getAdmissionTranslation('SALES_AND_ADMISSION_SUMMARY_REPORT');
		this.exportJRXMLReport(code,reportParams,reportTitle,'.pdf',SERVERURL.PATH_SALES_AND_ADMISSION_REPORT_GRID_PDF);
	},
	
	exportXLSalesAndAdmissionSummaryReport : function(){
		var $this=this;
		var salesAndAdmissionReportFilter = this.getSalesAndAdmissionReportFilter();
		var formValues = salesAndAdmissionReportFilter.getValues();
		var code = 'VelocitySalesAndAdmissionSummaryReport_Excel';
		
		var intakeYearId = formValues.intakeYear;
    	var academyIdsArray = formValues.multiselectAcademy;
    	
    	if(typeof academyIdsArray[0]!="object"){
    		var academyIds = academyIdsArray.join(',');
    	}
    	else {
    		var academyIdsTempArray = [];
    		Ext.each(academyIdsArray,function(currentAcademyId){
    			academyIdsTempArray.push(currentAcademyId.data.id);
    		});
    		var academyIds = academyIdsTempArray.join(',');
    	}
		
		var reportParams =new Object();
		reportParams.academyIds = academyIds;
		reportParams.intakeYearId=intakeYearId;
		
		var reportTitle=getAdmissionTranslation('SALES_AND_ADMISSION_SUMMARY_REPORT');
		this.exportJRXMLReport(code,reportParams,reportTitle,'.vnd.ms-excel',SERVERURL.PATH_SALES_AND_ADMISSION_REPORT_GRID_EXCEL);
	},
    
    loadGrid:function(){
    	var $this = this;
    	var grid = $this.getApplicationreportgrid();
    	var buttonsToolBar = grid.query('toolbar')[0];
	    var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
	    var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
	    pdftoolbar.setDisabled(true);
	    exceltoolbar.setDisabled(true);
	    var form = $this.getApplicationreportfilter().getForm();
    	var formValue =  $this.getApplicationreportfilter().getForm().getValues();
    	grid.getStore().getProxy().extraParams ={
    		programId:formValue.program,
    		batchId:formValue.batch,
    	    seatTypeId:formValue.seatType,
    	    startDate:formValue.startDate,
    	    endDate:formValue.endDate,
    	    intakeYearId : formValue.intakeYear,
    	    programGroupId : formValue.programGroup,
    	    academyLocationId : formValue.academyLocation,
    	    applicatoinIdOrName : formValue.applicantNameOrId
    	};
    	grid.getStore().load({
	    	  callback: function(records, operation, success) {
					if(records.length>0){
				    	pdftoolbar.setDisabled(false);
				    	exceltoolbar.setDisabled(false);
					}
				  }
			});
 /***************Start Code added for show filter data on PDF/Excel Export Report **************/
     	
     	grid.config.searchFilterForm = $this.getApplicationreportfilter();
     	
        /***************End Code added for show filter data on PDF/Excel Export Report **************/
    },
    
    exportXLFunction:function(reportTypeValue){
    	var $this = this;
    	var form = $this.getApplicationreportfilter().getForm();
    	var values = form.getValues();
    	var code = reportTypeValue;
    	var url=SERVERURL.EXPORT_APPLICATION_REPORT;
    	var reportParams =new Object();
    	reportParams.code = code;
    	reportParams.reportTitle = getAdmissionTranslation('APPLICANTION_REPORT_TITLE');
    	reportParams.programId = values.program;
    	reportParams.intakeYearId = values.intakeYear;
    	reportParams.programGroupId = values.programGroup;
    	reportParams.batchId = values.batch;
    	reportParams.seatTypeId = values.seatType;
    	reportParams.startDate = values.startDate;
    	reportParams.endDate = values.endDate;
    	reportParams.applicantNameOrId = values.applicantNameOrId;
    	reportParams.academyLocationId = values.academyLocation;
    	reportParams.headerName = getAdmissionTranslation('APPLICANTION_REPORT_TITLE');//"Course Wise Marksheet Report";
    	var reportTitle="";
    	if(code=='ApplicantPreEligibilityReport'){
    		url=SERVERURL.PATH_FIND_PRE_ELIGIBILITY_REPORT;
    		reportParams.code ="APPLICANT_PREELIGIBILITY_REPORT";
    	}
    	$this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',url);

    },
    
    
  //******************Disable Export button**********************************
    disableExportBtnActionPivileges: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	buttonsToolBar = gridReference.query('toolbar')[0];
    	var exportButton = gridReference.down('#exportReportsId');
    	
    	exportButton.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'EXPORTREPORTS') {
        		if(!isNullOrEmpty(exportButton)){
        			exportButton.setVisible(true);
        		}        		
        	}
    	});
    },
    showApplicantReportExportWin:function(){
    	var $this = this;
    	var formWindow = $this.getApplicantexportreportwidow();
    	if (!formWindow) {
    		Ext.widget('applicantexportreportwidow');
    		formWindow = $this.getApplicantexportreportwidow();
    	}
    	formWindow.show();
    	
    	var form = $this.getApplicantexportreportwidow();
		var  applicantDetailReportTypeField = form.down("#applicantDetailReportType");
		
		var store = applicantDetailReportTypeField.getStore();
		/*var academyLocationId=$this.getCurrentAcademyLocation();
		store.getProxy().extraParams={
	    	academyLocationId:academyLocationId,
	    	reportType:'Student ID Card'
		};*/
		store.load();
//	}
    }
});