/**
 * @author Dharmendra.Prajapati
 * 
 */
var sessionNumber = "";
var timeSlotId = "";
var attendanceMarkedBy = "";
Ext.define('Academia.controller.attendance.AttendanceController', {
	extend: 'Academia.controller.base.BaseController',
//	extend: 'Academia.controller.importutility.ImportUtilityController',
	
	/*mixins: {
        importUtilityController: 'Academia.controller.importutility.ImportUtilityController'
    },*/
	models : [
	          'attendance.StudentAttendanceList','attendance.StudentAttendance','attendance.StudentCourses',
	          'attendance.SectionByCourseNComponent','attendance.AttendanceFacultyList',
	          'attendance.StudentCourseAttendance', 'attendance.AttendanceQRModel',
	          'attendance.StudentServiceAttendance'
	          ],
	stores : ['attendance.StudentAttendanceType','common.ProgramByAcademyLocationStore','enquiry.AcademicBatchStore',
	          'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','attendance.StudentAttendanceStatus',
	          'attendance.SectionAndFacultyByPeriodID','attendance.StudentAttendanceList','attendance.StudentCourses','course.courseequivalence.CourseComponentEquivalenceStore',
	          'attendance.SectionByCourseNComponent','attendance.AllProgramMappedByCourse','common.BatchesByProgramId',
	          'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','attendance.AttendanceFacultyList',
	          'attendance.TimeSlotList','attendance.CourseLevelFacultyBlank','importutility.ImportUtilityList','importutility.ImportListByModule',
	          'course.coursecomponent.CourseComponentCouseWise','importutility.ModuleName','attendance.AttendanceCountStore','attendance.FacultyGridCompleteNMultipleSession',
	          'attendance.FacultyTimeSlot','course.coursevariants.CourseVariantStore', 'attendance.SectionTypeComboStore', 'coursetransaction.sectionmanagement.CoruseSectionStore',
	          'course.coursetopic.CourseComponentStore', 'coursetransaction.facultytopicassignment.CourseSectionByIDStore', 'coursetransaction.facultytopicassignment.FacultyDetails',
	          'coursetransaction.facultytopicassignment.AssignFacultyStore', 'attendance.SectionByVariant', 'coursetransaction.homework.CourseVarientByCourseIdDropDown',
	          'attendance.StudentAttendanceTopic', 'importutility.ImportUtilityAttendanceList', 'importutility.importUtilityCourseLevelAttendanceList',
	          'attendance.AssignedCoursesFacultyStore', 'attendance.AssignedCoursesFacultyBySectionTypeStore','common.AssignedProgramStore','common.ClassTeacherProgramStore',
	          'common.AcademicTermStore','attendance.AttendanceMarkingTypeStore','attendance.MultipleSessionValueStore','course.coursevariants.ParameterCourseVariantStore',
              'attendance.ServiceStore','attendance.BatchByServiceStore','common.ServiceMappedProgram', 'importutility.ImportUtilityServiceLevelAttendanceList','othermasters.servicemaster.ServiceCoordinatorComboStore',
              'attendance.AattendanceImportStore'
              ],
	 views : ['attendance.AttendanceStructure','attendance.StudentAttendance','attendance.StudentAttendanceGrid',
	           'attendance.FacultyAttendance','attendance.FacultyAttendanceGrid','attendance.TopicList',
	           'attendance.AttendanceSearchStrucure','attendance.FacultySearch','attendance.EditAttendance',
	           'attendance.EditFacultyTopicCoverageGrid','attendance.FacultyGridCompleteNMultipleSession',
	           'attendance.StudentPNCAttendanceStructure','attendance.FacultyPNCAttendanceStructure',
	           'attendance.MarkAttendanceMasterStructure','attendance.StudentAttendanceUploaddownloadStructure','importutility.ImportByModule.ImportUtilityAttendanceList',
	           'attendance.UploadAttendanceForm','attendance.DownloadAttendanceForm','attendance.StudentAttendanceCountGrid',
	           'attendance.OtherEmployeAndadminAttendanceStructure','attendance.OtherEmployeeAttendance',
	           'attendance.AdminGridForSession', 'attendance.StudentCourseLevelAttendanceUploaddownloadStructure', 'attendance.DownloadCourseLevelAttendanceForm',
	           'attendance.UploadCourseLevelAttendanceForm', 'importutility.ImportByModule.ImportUtilityCourseLevelAttendanceList',
	           'attendance.DownloadCourseLevelAttendancePBSForm', 'attendance.DownloadCourseLevelAttendanceCBSForm',
	           'UploadOptionRadioGroup','facultyPortal.attendance.StudentCaptureAttendanceStructure','attendance.GenrateQrCode','attendance.QRCodeWindow',
	           'attendance.StudentServiceLevelAttendanceUploaddownloadStructure','attendance.DownloadServiceLevelAttendanceForm','attendance.UploadServiceLevelAttendanceForm',
	           'importutility.ImportByModule.ImportUtilityServiceLevelAttendanceList',
	           'attendance.importAttendance.AttendanceImport',
	           'attendance.importAttendance.AttendanceImportStructure'
	           ],	
       requires:['Ext.ux.InputTextMask'],
	           config: {
	        	   ATTENDANCE_ENTRY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_PRIVILEGES'),
	        	   ATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES'),
               	   CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES'),
              	   FACULTY_PORTAL_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_LOADER_PRIVILEGES')

	           },
	           refs : [{
	        	   ref : 'attendancestructure',
	        	   selector : 'attendancestructure'
	           },{
	        	   ref : 'studentattendance',
	        	   selector : 'studentattendance'
	           },{
	        	   ref : 'studentattendancegrid',
	        	   selector : 'studentattendancegrid'
	           },{
	        	   ref : 'studentAttendancegrid',
	        	   selector : 'studentattendancegrid grid'
	           },{
	        	   ref : 'facultyattendance',
	        	   selector : 'facultyattendance'
	           },{
	        	   ref : 'attendancesearchstrucure',
	        	   selector : 'attendancesearchstrucure'
	           },{
	        	   ref : 'facultysearch',
	        	   selector : 'facultysearch'
	           },{
	        	   ref : 'editattendance',
	        	   selector : 'editattendance'
	           },{
	        	   ref : 'editattenDance',
	        	   selector : 'editattendance form'
	           },{
	        	   ref: 'studentAttendanceGridId',
	        	   selector: 'searchresultgrid[itemId=studentAttendanceGridId]'
	           },{
	        	   ref: 'studentMultiSessionGridId',
	        	   selector: 'searchresultgrid[itemId=studentMultiSessionGridId]'
	           },{
	        	   ref: 'studentCourseLevelGridId',
	        	   selector: 'searchresultgrid[itemId=studentCourseLevelGridId]'
	           },{
	        	   ref: 'facultyDayWiseGridId',
	        	   selector: 'searchresultgrid[itemId=facultyDayWiseGridId]'
	           },{
	        	   ref: 'facultyMultiSessionGridId',
	        	   selector: 'searchresultgrid[itemId=facultyMultiSessionGridId]'
	           },{
	        	   ref: 'facultyCourseLevelGridId',
	        	   selector: 'searchresultgrid[itemId=facultyCourseLevelGridId]'
	           },{
	        	   ref : 'facultyattendancegrid',
	        	   selector : 'facultyattendancegrid'
	           },{
	        	   ref:'facultytopiccoveragegrid',
	        	   selector:'facultytopiccoveragegrid'
	           },{
	        	   ref:'facultygridcompletenmultiplesession',
	        	   selector:'facultygridcompletenmultiplesession[itemId=facultygridcompletenmultiplesession_Id]'
	           },{
	        	   ref:'attendancegridcompletenmultiplesession',
	        	   selector:'facultygridcompletenmultiplesession[itemId=attendancegridcompletenmultiplesession_Id]'
	           },{
	        	   ref:'studentpncattendancestructure',
	        	   selector:'studentpncattendancestructure'
	           },{
		        	ref:'importUtilityWin',
		        	selector:'importutilitywin'
		        },{
		        	ref:'importUtilityWinForm',
		        	selector:'importutilitywin form'
		        },{
		        	ref:'uploadattendanceform',
		        	selector:'uploadattendanceform'
		        },{
		        	ref:'downloadattendanceform',
		        	selector:'downloadattendanceform'
		        },{
		        	ref:'studentattendanceuploaddownloadstructure',
		        	selector:'studentattendanceuploaddownloadstructure',	
		        },{
		        	   ref : 'studentattendancecountgrid',
		        	   selector : 'studentattendancecountgrid'
		        },{
		        	   ref : 'importutilityattendancelist',
		        	   selector : 'importutilityattendancelist'
		        }, {
		        	   ref : 'admingridforsession',
		        	   selector : 'admingridforsession'
		        },{
		        	   ref : 'markattendancemasterstructure',
		        	   selector : 'markattendancemasterstructure'
		        },{
		        	ref:'importutilitycourselevelattendancelist',
		        	selector:'importutilitycourselevelattendancelist'
		        },{
		        	ref:'downloadcourselevelattendancepbsform',
		        	selector:'downloadcourselevelattendancepbsform'
		        },{
		        	ref:'downloadcourselevelattendanceform',
		        	selector:'downloadcourselevelattendanceform'
		        },{
		        	ref:'downloadcourselevelattendancecbsform',
		        	selector:'downloadcourselevelattendancecbsform'
		        },{
		        	ref : 'attendanceuploadoptionradiogroup',
		        	selector : 'uploadoptionradiogroup[itemId=attendanceUploadOptionRadioGroupItemId]'
		        },{
		        	ref : 'courselevelattendanceuploadoptionradiogroup',
		        	selector : 'uploadoptionradiogroup[itemId=courselevelattendanceUploadOptionRadioGroupItemId]'
		        },{
					ref : 'studentcaptureattendancestructure',
					selector : 'studentcaptureattendancestructure'
				},{
					ref : 'genrateqrstructure',
					selector : 'genrateqrstructure'
				},{
					ref: 'qrcodewindow',
					selector: 'qrcodewindow'
				},{
		        	ref:'downloadservicelevelattendanceform',
		        	selector:'downloadservicelevelattendanceform'
		        },{
		        	ref:'uploadservicelevelattendanceform',
		        	selector:'uploadservicelevelattendanceform'
		        },{
		        	ref:'importutilityservicelevelattendancelist',
		        	selector:'importutilityservicelevelattendancelist'
		        },{
		        	ref : 'serviceattendanceuploadoptionradiogroup',
		        	selector : 'uploadoptionradiogroup[itemId=serviceattendanceUploadOptionRadioGroupItemId]'
		        },{
		        	ref : 'attendanceImport',
		        	selector : 'attendanceImport'
		        }],
	           init : function() {
	        	   this.control({
	        		   'attendancestructure radiogroup[itemId=studentFacultyId]':{
	        			   change: this.studentFacultyChange
	        		   },'attendancestructure':{
	        			   render: function(structure) {
	        				   var radioStruct = structure.down('#studentFacultyId');
	        				   var facultyRadio = radioStruct.items.items[1];
	        				   var adminRadio = radioStruct.items.items[2];
	        				   var otherEmpRadio = radioStruct.items.items[3];
	        				   var studentRadio = radioStruct.items.items[0];
	        				   
	        				   var portalId = this.getCurrentLoggedPortalId();
	                		   if(portalId == 2) {
		        				   radioStruct.setVisible(false);
	                		   }
	        				   adminRadio.setDisabled(true);
	        				   otherEmpRadio.setDisabled(true);
	        				   
	        			   }
	        			  
	        		   },
	        		   'studentattendance radiogroup[itemId=programBatchCourseSectionId]':{
	        			   change: this.programBatchChange
	        		   },'facultyattendance radiogroup[itemId=facultyProgramBatchSectionId]':{
	        			   change: this.programBatchFacultyChange
	        		   },
	        		   'studentpncattendancestructure button[itemId=submitBtn]' : {
	        			   click : function(btn){
	        				   var me = this;
	        				   btn.setDisabled(true);
	        				   setTimeout(function(){
		        				   me.saveStudentAttendance(btn);
	        				   },1000);
	        			   }
	        		   },
	        		   'studentattendance':{
	        			   validitychange: function(form, valid, eOpts ){
	        				   var pncStructure=this.getStudentpncattendancestructure();
    	                	   var studentsAttendanceType = pncStructure.down('#attendanceTypeRadio').getValue();
    	                	   var attendanceType=studentsAttendanceType.attendanceTypeWise;
    	                	   if(attendanceType == 'Service Level' || attendanceType == 'SERVICE_LEVEL'){
    	        				   var form = this.getStudentattendance();
    	                		   var formValue=form.getForm().getValues();
    	                		   if(formValue.adhocRequired=="true"){
    	                			   var isAllFromTimeFilled = true;
    	                			   var isAllToTimeFilled = true;
    	                			   
    	                			   var allFromTimeFields = form.query('[name=fromTime]');
    	                			   var allToTimeFields = form.query('[name=toTime]');
    	                			   
    	                			  
    	                			   Ext.each(allFromTimeFields,function(currentFromTimeField){
    	                				   if(currentFromTimeField.isVisible() && isNullOrEmpty(currentFromTimeField.getValue())){
    	                					   isAllFromTimeFilled = false;
    	                				   }
    	                			   });
    	                			   
    	                			   Ext.each(allToTimeFields,function(currentToTimeField){
    	                				   if(currentToTimeField.isVisible() && isNullOrEmpty(currentToTimeField.getValue())){
    	                					   isAllToTimeFilled = false;
    	                				   }
    	                			   });
    	                			   
    	                			   if(isAllFromTimeFilled && isAllToTimeFilled && form.isValid()){
    	                				   form.down('#searchBtn').setDisabled(false);
    	                			   }else{
    	                				   form.down('#searchBtn').setDisabled(true);
    	                			   }
    	                		   }
    	                	   }
    	                	   else if(form.down){	        					   
		        				   if(form.isValid()){
		        					   form.down('#searchBtn').setDisabled(false);
		        				   }
		        				   else{
		        					   form.down('#searchBtn').setDisabled(true);
		        				   }
	        				   }
	        			   }
	        		   },
	        		   'studentattendance button[itemId=timeBtnAdd]' : {
	        			   click : this.timeFieldsAdd
	        		   },
	        		   'studentattendance button[itemId=timeBtnDelete]' : {
	        			   click : function(deleteButton) {
	        				   this
	        				   .deleteTimeSlotContainer(deleteButton)
	        			   }
	        		   },
	        		   'studentattendance button[itemId=timeBtnAdd1]' : {
	        			   click : this.timeFieldsAdd
	        		   },
	        		   'studentattendance button[itemId=timeBtnDelete1]' : {
	        			   click : function(deleteButton) {
	        				   this.deleteTimeSlotContainer(deleteButton)
	        			   }
	        		   },'studentpncattendancestructure button[itemId=cancelBtn]':{
	        			   click: function(){
	        				   this.cancelStudentAttendance();
	        			   }
	        		   },
	        		   'studentpncattendancestructure radiogroup[itemId=attendanceTypeRadio]':{
	        			   change : function(obj,record){
	        				   this.attendanceTypeOfStudent(obj,record,true); 
	        			   }
	        		   },
	        		   'studentattendance button[itemId=searchBtn]':{
	        			   click: this.searchStudentsGrid,
	        		   },'studentattendance button[itemId=resetBtn]':{
	        			   click: this.resetStudentForm
	        		   },
	        		   'studentattendance button[itemId=GenrateQR]':{
	        			   click: this.genrateQrCodeForCoreErp
	        		   },
	        		   'studentattendance button[itemId=viewQR]':{
	        			   click: this.viewQrCodeForCoreErp
	        		   },
	        		   'genrateqrstructure button[itemId=generateQRWinBtnItemId]':{
	        			   click: function(btn){
	        				   var $this=this;
	        				   var attendancesearchstrucure =  $this.getMarkattendancemasterstructure().getForm();
	        				   var attendanceType = attendancesearchstrucure.findField('attendanceType').getValue();
	        				   var batchId = attendancesearchstrucure.findField('batchId').getValue();
	        				   var attendanceDate = attendancesearchstrucure.findField('dateOfAttendance').getValue();
	        				   var periodId = attendancesearchstrucure.findField('periodId').getValue();
	        				   var programId = attendancesearchstrucure.findField('programId').getValue();
	        				   var sectionId = attendancesearchstrucure.findField('sectionId').getValue();
	        				   var facultyId = null;
	        				   var facultyName = '';
	                           //var endTime = btn.up('window').down('#toTime').getValue(); //using this for expiry of QR code
	        				   var duration = btn.up('window').down('#expirytime').getValue();
	        				   
	        				   if(duration == "00:00:00"){
	                        	   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('EXPIRY_TIME_CANNOT_BE_ZERO'));
	                        	   return false;
	                           }
	        				   
	        				   if (!isValidDuration(duration)) {
	        			            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CALENDAR_HOLIDAY_VALIDATION'));
	        			            return false;
	        			        }
	                           
	                           var isAdHoc = btn.up('window').isAdHoc;
	                           
	                           // Extract the date part from attendanceDate
	                           var datePart = Ext.Date.format(attendanceDate, 'Y-m-d');
	                           
	                           // Extract the time part from startTime

	                           var startTime = null;
	                           if(isAdHoc){
		        				   var startTime = btn.up('window').down('#fromTime').getValue();
		                           var startTimeTimePart = Ext.Date.format(startTime, 'H:i:s');
		                           var endTime1 = btn.up('window').down('#toTime1').getValue();
		                           var endTime1TimePart = Ext.Date.format(endTime1, 'H:i:s');
	                           }
	                           
	                           // Extract the time part from endTime
	                           //var endTimeTimePart = Ext.Date.format(endTime, 'H:i:s');
	                           
	                           // Combine datePart and startTimeTimePart into a new Date object
	                           //var combinedStartDateTime = Ext.Date.parse(datePart + ' ' + startTimeTimePart, 'Y-m-d H:i:s');
	                           
	                           // Combine datePart and endTimeTimePart into a new Date object
	                           //var combinedEndDateTime = Ext.Date.parse(datePart + ' ' + endTimeTimePart, 'Y-m-d H:i:s');
	        				   
	        				   if((attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY') || (attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION')){
	        					   if(portalId==2){
		        					   facultyId = this.getCurrentlyLoggedInUser().id;
		        					   facultyName = this.getCurrentlyLoggedInUser().value;
		        				   }else{
		        					   facultyId =  attendancesearchstrucure.findField('facutly').getValue();
		        					   facultyName =  attendancesearchstrucure.findField('facutly').getDisplayValue();
		        				   }
	        					   
	        					   if((attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY')){
	        						   var sessionNo = null;
	        					   }
	        					   else{
	        						   var sessionNo = attendancesearchstrucure.findField('sessionNo').getValue();
	        					   }
	        					   
	        					   var attendanceModel = new Academia.model.attendance.AttendanceQRModel();
	        					   attendanceModel.set('academyLocationId', this.getCurrentAcademyLocation());
		        				   attendanceModel.set('attendanceType', attendanceType);
		        				   attendanceModel.set('batchId', batchId);
		        				   attendanceModel.set('dateOfAttendance', attendanceDate);
		        				   attendanceModel.set('facultyId', facultyId);
		        				   attendanceModel.set('id', null);
		        				   attendanceModel.set('periodId', periodId);
		        				   attendanceModel.set('programId', programId);
		        				   attendanceModel.set('sectionId', sectionId);
		        				   attendanceModel.set('sessionNo', sessionNo);
		        				   //attendanceModel.set('qrCodeExpiryTime', endTimeTimePart);
		        				   attendanceModel.set('qrCodeExpiryTime', duration);
		        				   var submitUrl =SERVERURL.PATH_ATTENDANCE_CAPTURE_QR_SAVE;
	        				   }
	        				   else{
	        					   if(portalId==2){
		        					   facultyId = this.getCurrentlyLoggedInUser().id;
		        					   facultyName = this.getCurrentlyLoggedInUser().value;
		        				   }else{
		        					   facultyId =  attendancesearchstrucure.findField('facutlyList').getValue();
		        					   facultyName =  attendancesearchstrucure.findField('facutlyList').getDisplayValue();
		        				   }
	        					   var attendanceModel = new Academia.model.attendance.StudentCourseAttendance();
	        					   var sessionPlanningDone=false;
	        					   if(attendancesearchstrucure.findField('attendanceSlot').getValue()=="TIME_TABLE_SLOTS"){
	        						   sessionPlanningDone=true;
	        					   }

	        					   var toTime1 = null;
	        					   if(isAdHoc && !isNullOrEmpty(startTime)){
	        						   var fromTime = startTimeTimePart;
		        					   var toTime1 = endTime1TimePart;
	        					   }
	        					   else{
		        					   var timeSlotStore = $this.getStudentattendance().down('#timetableSlotListId').getStore();
		        					   var data = timeSlotStore.findRecord('id', attendancesearchstrucure.getValues().timetableSlotList[0].data.id).data;
		        					   var attendanceDate = Ext.Date.format(new Date(data.sessionDate), 'Y-m-d');
		        					   var fromTime = data.fromTime;
		        					   var toTime =  data.toTime;
	        					   }
	        					   

	        					   var courseValues = attendancesearchstrucure.findField('courseVariant').getStore().findRecord('id', attendancesearchstrucure.findField('courseVariant').getValue()).data;
	        					   var sectionIds = courseValues.sectionId;

	        					   attendanceModel.set('academyLocationId', $this.getCurrentAcademyLocation());
	        					   attendanceModel.set('attendanceType', attendanceType);
	        					   attendanceModel.set('dateOfAttendance', attendanceDate);
	        					   attendanceModel.set('facultyId', attendancesearchstrucure.findField('facutlyList').getValue());
	        					   //attendanceModel.set('adhocSlot', false);
	        					   attendanceModel.set('attendanceMarkedBy', facultyId);
	        					   attendanceModel.set('isMobile', false);
	        					   attendanceModel.set('sessionPlanningDone', sessionPlanningDone);
	        					   attendanceModel.set('facultyConflictCheck', "false");
	        					   if(isAdHoc){
	        						   attendanceModel.set('slotFrom', fromTime);
	        						   if(!isNullOrEmpty(toTime1)){
			        					   attendanceModel.set('slotTo', toTime1);
	        						   }
	        						   else{
			        					   attendanceModel.set('slotTo', toTime);   
	        						   }
	        						   attendanceModel.set('adhocSlot', true);
		        					   attendanceModel.set('fromTime', fromTime);
		        					   if(!isNullOrEmpty(toTime1)){
			        					   attendanceModel.set('toTime', toTime1);
	        						   }
	        						   else{
			        					   attendanceModel.set('toTime', toTime);   
	        						   }
	        					   }
	        					   else{
	        						   attendanceModel.set('slotFrom', fromTime);
		        					   attendanceModel.set('slotTo', toTime);
	        						   attendanceModel.set('adhocSlot', false);
		        					   attendanceModel.set('fromTime', "");
		        					   attendanceModel.set('toTime', "");
	        					   }
	        					   
	        					   attendanceModel.set('courseId', attendancesearchstrucure.findField('courseId').getValue());
	        					   attendanceModel.set('courseVariantId', attendancesearchstrucure.findField('courseVariant').getValue());
	        					   attendanceModel.set('sectionId', sectionIds);
		        				   //attendanceModel.set('qrCodeExpiryTime', endTimeTimePart);
	        					   attendanceModel.set('qrCodeExpiryTime', duration);
	        					   var submitUrl =SERVERURL.PATH_ATTENDANCE_COURSE_CAPTURE_QR_SAVE;

	        				   }
	        				   var formData = Ext.encode(attendanceModel.data);
	        				   //debugger;
	        				   
	        				  Ext.Ajax.request({
	        					   type : 'rest',
	        					   url : submitUrl,
	        					   method : 'POST',
	        					   async: false,
	        					   jsonData : formData,
	        					   success : function(form1, action) {
	        						   if(form1.responseText != 0){
	        							 //--Code in Success -- START
		        						   var studentList = $this.getStudentAttendancegrid().getStore().data.items;
		        						   if(studentList.length){
		        							   var admissionIds = Ext.Array.pluck(Ext.Array.pluck(studentList,'data'),'admissionId');
		        							   btn.up('window').close();
		        							   var qrDataModel = {};
		        							   if((attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY') || (attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION')){
			        							   qrDataModel.qrData = {
			        									   qrId: form1.responseText,
			        									   //admissionIds: admissionIds,
			        									   academyLocationId: $this.getCurrentAcademyLocation(),
			        									   attendanceType: attendanceType,
			        									   batchId: batchId,
			        									   dateOfAttendance: attendanceDate,
			        									   facultyId: facultyId,
			        									   id: null,
			        									   periodId: periodId,
			        									   programId: programId,
			        									   sectionId: sectionId,
			        									   sessionNo: null,
			        									   //startTime: startTime,
			        									   //endTime: endTime,
			        									   endTime: duration
			        							   };
			        							   
			        							   var qrDisplayData = attendancesearchstrucure.findField('programId').getDisplayValue() + ' | ' + attendancesearchstrucure.findField('batchId').getDisplayValue() + ' | '+ attendancesearchstrucure.findField('periodId').getDisplayValue() + ' | ' + attendancesearchstrucure.findField('sectionId').getDisplayValue() + ' | '+ facultyName +' | '+ dateRender(attendanceDate);
			        									  
		        							   }
		        							   else{
		        								   qrDataModel.qrData = {
		        										   qrId: form1.responseText,
		        										   admissionIds: admissionIds,
		        										   academyLocationId: $this.getCurrentAcademyLocation(),
		        										   attendanceType: attendanceType,
		        										   dateOfAttendance: attendanceDate,
		        										   facultyId: attendancesearchstrucure.findField('facutlyList').getValue(),
		        										   adhocSlot: false,
		        										   attendanceMarkedBy: facultyId,
		        										   isMobile: false,
		        										   sessionPlanningDone: sessionPlanningDone,
		        										   facultyConflictCheck: "false",
		        										   slotFrom: fromTime,
		        										   slotTo: toTime,
		        										   fromTime: "",
		        										   toTime: "",
		        										   courseId: attendancesearchstrucure.findField('courseId').getValue(),
		        										   courseVariantId: attendancesearchstrucure.findField('courseVariant').getValue(),
		        										   sectionId: sectionIds,
		        										   //startTime: startTime,
			        									   //endTime: endTime,
		        										   endTime: duration
		        								   };
		        								   
		        								   if(isAdHoc){
		        									   qrDataModel.qrData.slotFrom = fromTime;
		        	        						   if(!isNullOrEmpty(toTime1)){
		        	        							   qrDataModel.qrData.slotTo = toTime1;
		        	        						   }
		        	        						   else{
		        	        							   qrDataModel.qrData.slotTo = toTime;   
		        	        						   }
		        	        						   qrDataModel.qrData.adhocSlot = true;
		        	        						   qrDataModel.qrData.fromTime = fromTime;
		        		        					   if(!isNullOrEmpty(toTime1)){
		        		        						   qrDataModel.qrData.toTime = toTime1;
		        	        						   }
		        	        						   else{
		        	        							   qrDataModel.qrData.toTime = toTime;   
		        	        						   }
		        		        					   var qrDisplayData = attendancesearchstrucure.findField('courseId').getDisplayValue() + ' | ' + attendancesearchstrucure.findField('courseVariant').getDisplayValue() + ' | ' + fromTime + ' - ' + qrDataModel.qrData.toTime + ' | ' + facultyName + ' | ' + dateRender(attendanceDate);
		        	        					   }
		        								   else{
		        									   var qrDisplayData = attendancesearchstrucure.findField('courseId').getDisplayValue() + ' | ' + attendancesearchstrucure.findField('courseVariant').getDisplayValue() + ' | ' + fromTime + ' - ' + toTime + ' | ' + facultyName + ' | ' + dateRender(attendanceDate);
		        								   }
		        							   }
		        							   var formWindow =  $this.getQrcodewindow();
		        							   if (!formWindow) {
		        								   Ext.widget('qrcodewindow',{
		        									   qrData: Ext.encode(qrDataModel.qrData),
		        									   qrDisplayData: qrDisplayData,
		        									   itemId: 'newQRWin'
		        								   });
		        								   formWindow =  $this.getQrcodewindow();
		        							   }
		        							   formWindow.show();
		        						   }
		        						   //--Code in Success -- END
	        						   }
	        						   else{
	        							   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('QR_ALREADY_GENERATED'));
	        						   }
	        					   }
	        				   });

	        				   
	        			   }
	        		   },
	        		  'qrcodewindow[itemId=newQRWin]':{
	        			   afterrender: function(win){
	        				   var me = this;
	        				   var qrData = win.qrData;
	        				   var qrDisplayData = win.qrDisplayData;
	        				   var qrDataJson = Ext.decode(qrData);
	        				   var base64EncodedQRData = qrDataJson.attendanceType + '|' + qrDataJson.qrId; //Base64.encode(qrData);
	        				   var qrCodeImg = generateQr(base64EncodedQRData, '', "");
	        				   var attendanceType = qrDataJson.attendanceType;
	        				   
	        				   var attendanceQRCode = '';
	        				   if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
	        					   attendanceQRCode = 'CD'; //CompleteDay
	        				   }
	        				   else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
	        					   attendanceQRCode = 'MS'; //MultipleSessions
	        				   }
	        				   else{
	        					   attendanceQRCode = 'CW'; //CourseWise
	        				   }
	        				   
	        				   var acedemyLocationName = me.getAcademyLocationDisplayName(me.getCurrentAcademyLocation());
	        				   
	        				   var printBtmVals = Object.values(qrDataJson);
	        				   
	        				   win.down('#qrALLabelCls').setText(acedemyLocationName);
	        				   win.down('#qrOtherTxtLabelCls').setText(qrDisplayData);
	        				   
	        				   if(Ext.query('#'+win.id+' #qrcodetext').length){
	        					   Ext.query('#'+win.id+' #qrcodetext')[0].innerText=attendanceQRCode+'-'+qrDataJson.qrId;
	        				   }
	        				   
	        				   if((attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY') || (attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION')){
	        					   var submitUrl = SERVERURL.PATH_ATTENDANCE_CAPTURE_QR_SAVE  
	        				   }
	        				   else{
	        					   var submitUrl = SERVERURL.PATH_ATTENDANCE_COURSE_CAPTURE_QR_SAVE;
	        				   }
	        				   setTimeout(function(){
	        					   //debugger;
	        					   var base64Src = Ext.query('#qrcode img')[0].src;
	        					   
	        					   Ext.Ajax.request({
		        					   type : 'rest',
		        					   url : submitUrl ,
		        					   method : 'POST',
		        					   async: false,
		        					   jsonData : {
		        						   'attendanceQRCode': base64Src,
		        						   'duration': qrDataJson.duration,
		        						   'id': qrDataJson.qrId,
		        						   'attendanceType': qrDataJson.attendanceType
		        					   },
		        					   success : function(form1, action) {
		        						   //debugger;
		        						   if(form1.responseText == "SUCCESS"){
                                               showSuccessMessage(getCommonTranslation('GENERATE_QR'), getCommonTranslation('QR_GENERATED_SUCCESSFULLY'));
                                               me.cancelStudentAttendance();
                                               me.downloadQRDivAsImage(win);
		        						   }
		        						   else{
		        						        win.close();
                                               showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('Error while generating QR! Please regenerate.'));
		        						   }
		        					   }
	        					   });
	        				   },500);
	        					   //-- Saving Generated QR Here
	        				   }
	        		   },
	        		   'genrateqrstructure textfield[itemId=expirytime]': {
	        			   change:function(obj)
	        			   {     
	        				   var expirytimevalue=obj.getValue();
	        				   if(expirytimevalue=='00:00:00')
	        				   {
	        					   obj.setValue('00:00:00');	
	        				   }
	        			   }

	        		   },
	        		   'studentattendance button[itemId=programBatchUpload]':{
	        			   click: function(){
	        				   var $this=this;
	        				   var form = $this.getStudentattendance();
	        				   var programBatchUploadField = form.down('#programBatchUpload');
//	        				   var attendancesearchstrucure =  $this.getAttendancesearchstrucure().getForm();
	        				   var attendancesearchstrucure =  $this.getMarkattendancemasterstructure().getForm();
	        				   var attendanceType = attendancesearchstrucure.findField('attendanceType').getValue();
	        				   if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){   
	        					   this.programBatchUploadAttendance();
	        				   }else{
	        					   programBatchUploadField.setVisible(false);
	        				   }
	        			   }
	        		   },
	        		   'studentattendancegrid radiogroup[itemId=markOnlyAttendance_Id]':{
	        			   change:function(obj,record){
	        				   this.changeStatus(obj,record);
	        			   }
	        		   },
	        		   'studentattendancegrid customcombobox[itemId=otherStatusId]':{
	        			   select:function(obj,record){
	        				   this.changeOtherStatus(obj,record);
	        			   }
	        		   },
	        		   'editattendance button[itemId=submitBtn]':{
	        			   click:this.updateAttendance
	        		   } , 'editattendance button[itemId=cancelBtn]':{
	        			   click:this.cancelAttendance
	        		   } ,
	        		   'studentattendance combo#programBatch_programId': {
	        			   select: function(obj, record) {
	        				   var this$ =  this;
	        				   var portalId = this.getCurrentLoggedPortalId();
	        				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	    	                   var wheatherSchool = alinfomodel.get('wheatherSchool');
	        				   var facultyId = null;
	        				   if(portalId==2){
	        				   facultyId = this.getCurrentlyLoggedInUser().id;
	        				   }
	        				   this.getStudentAttendancegrid().getStore().removeAll();
	        				   this.getStudentattendancecountgrid().getStore().removeAll();
	        				   this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
	        				   var programId = record[0].get("id");
	        				   if(programId > 0){
	        					   var form = this$.getStudentattendance();
	        					   form.down("#programBatch_batchId").clearValue();
	        					   form.down("#periodIdItemId").clearValue();
	        					   form.down("#programCoursection_ID").clearValue();
	        					   form.getForm().findField('facutly').clearValue();
	        					   form.down("#programBatch_batchId").setDisabled(false);
	        					   var store = this$.getStore('enquiry.AcademicBatchStore');
        						   store.getProxy().extraParams = {
        							   id: programId,
        							   isActive:true
        						   };
        						   store.load({
        							   callback: function(records, operation, success) {
        								   if (success) {
        									   if(records.length==1){
        										   form.down("#programBatch_batchId").clearInvalid();
        										   form.down("#programBatch_batchId").setValue(records[0].get('id'));
        										   form.down("#periodIdItemId").setDisabled(false);
        										   var store = form.down("#periodIdItemId").getStore();
        										   store.getProxy().extraParams = {
        											   id: records[0].get('id'),
        											   isCurrentPeriod:true
        										   };
        										   store.load({
        											   callback: function(records, operation, success) {
        												   if (success) {
        													   if(records.length == 0){
        														   form.down("#programCoursection_ID").setDisabled(true);
        														   if(wheatherSchool) {
        															   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
        														   }
        														   this$.validateAttendanceSearchForm();
        													   } 
        													   else if(records.length==1){
        														   form.down("#periodIdItemId").setValue(records[0].get('id'));
        														   form.down("#periodIdItemId").clearInvalid();
        														   form.down("#programCoursection_ID").setDisabled(false);
        														   form.isValid();
        														   form.down("#programCoursection_ID").clearInvalid();
        														   var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
        														   store.getProxy().extraParams = {
        															   periodId: records[0].get('id'),
        															   facultyId:facultyId
        														   };
        														   store.load({
        															   callback: function(records, operation, success) {
        																   if (success) {
        																	   if(records.length==1){
        																		   form.down("#programCoursection_ID").setValue(records[0].data.sectionId);
        																		   form.getForm().findField('facutly').setValue(records[0].data.facultyId);
        																		   form.down("#programCoursection_ID").clearInvalid();
        																		   form.getForm().findField('facutly').clearInvalid();
        																		   this$.validateAttendanceSearchForm();
        																	   }
        																	   
        																	  }
        																   this$.validateAttendanceSearchForm();
        															   }
        														   });

        													   }
        												   }
        												   this$.validateAttendanceSearchForm();
        											   }
        										   });
        									   }
        									   this$.validateAttendanceSearchForm();
        								   }
        							   }
        						   });
        						   this$.validateAttendanceSearchForm();
	        				   }
		        		   		this$.validateAttendanceSearchForm();
	        			   }
	        		   },
	        		   
	        		    /*'studentattendance combo#serviceId': {
	        			   select: function(obj, record) {
	        				   var this$ =  this;
	        				   var form = this$.getStudentattendance();
	        				   var serviceCombo = form.down("#serviceId");
	        				   var serviceId = serviceCombo.getValue();
	        				   var serviceProgramCombo = form.down("#serviceProgramId");
	        				   serviceProgramCombo.clearValue();
	        				   serviceProgramCombo.setDisabled(false);
	        				   var programStore = serviceProgramCombo.getStore();
	        				   
	        				   programStore.getProxy().extraParams = {
	        					   serviceId: serviceId
	        				   };
	        				   programStore.load({
	        					   callback: function(records, operation, success) {
	        						   if (success) {
	        							   if(records.length==1){

	        							   }
	        						   }
	        					   }
	        				   });


	        			   }
	        		   },*/
	        		   'studentattendance combo#serviceId': {
	        			   select: function(obj, record) {
	        				   var this$ =  this;
	        				   var form = this$.getStudentattendance();
	        				   var serviceCombo = form.down("#serviceId");
	        				   var serviceId = serviceCombo.getValue();
	        				   var programCombo = form.down("#serviceProgramId");
	        				   var programId = programCombo.getValue();
	        				   var serviceBatchCombo = form.down("#serviceBatchId");
	        				   serviceBatchCombo.clearValue();
	        				   serviceBatchCombo.setDisabled(false);
	        				   var batchStore = serviceBatchCombo.getStore();
	        				   
	        				   var serviceCordinator = form.down("#serviceCoordinatorId");
	        				   serviceCordinator.clearValue();
	        				   serviceCordinator.setDisabled(false);
	        				   var serviceCordinatorStore = serviceCordinator.getStore();
	        				   
	        				   var serviceIdsArr =[]
	        				   serviceIdsArr.push(serviceId);
	        				   var serviceIdsString = serviceIdsArr.join();
	        				   
	        				   batchStore.getProxy().extraParams = {
	        					   serviceId: serviceId,
	        					   programId: null
	        				   };
	        				   batchStore.load({
	        					   callback: function(records, operation, success) {
	        						   if (success) {
	        							   if(records.length==1){

	        							   }
	        						   }
	        					   }
	        				   });
	        				   
	        				   serviceCordinatorStore.getProxy().extraParams = {
	        					   serviceIds:serviceIdsString
	        				   };

	        				   serviceCordinatorStore.load();
	        			   }
	        		   },

	        		   
	        		  /* 'studentattendance combo#serviceBatchId': {
	        			   select: function(obj, record) {
	        				   var this$ =  this;
	        				   var form = this$.getStudentattendance();
	        				   form.isValid();
	        			   }
	        		   },*/
	        		   
	        		   'studentattendancegrid':{
	        			   render:function(obj){
	        				   this.attendanceRadioFields();   
	        				   this.getStudentAttendancegrid().getStore().removeAll();
	        				   this.getStudentattendancecountgrid().getStore().removeAll();
	        			   }
	        			   
	        		   },
	        		   'studentattendancegrid grid':{
	        			   afterrender:function(grid){
	        				   var me = this;
	        				   setTimeout(function(){
	        					   me.addDataGridConfigButton(grid,me.getATTENDANCE_ENTRY_PERMISSIONS());
	                			},1500);
	        			   }
	        		   },
	        		  'studentattendancegrid checkcolumn':{
	        			   checkchange:function(obj, rowIndex, checked, eOpts ){
	        				   var this$ = this;
	        				   var grid = this$.getStudentAttendancegrid();
    	                	   var store = grid.getStore();
    	                	   var models = grid.getStore().getRange();
	        				   if(checked){
		        					   if(obj.text==getProgramandcourseTranslation('ABSENT')){
		        	                	   for(var i =0; i<store.data.length;i++){
		        	                		   if(rowIndex==i){
			        	                		models[rowIndex].set('present', false);
			        	                	    Ext.defer(function() {
			        	                	    	if(models[rowIndex].data.absent == true){
			        	                	    		models[rowIndex].set('attendanceStatus', null);
			        	                	    	}
			        	                	    	 var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
			        		        				   for(var i =0; i<store.data.length;i++){
			        		        					   if(models[i].data.present){
			        		        						   preCount++;
			        			        					   presentSummaryCount++;
			        		        					   }
			        		        					   if(models[i].data.absent){
			        		        						   absCount++;
			        			        					   absentSummaryCount++;
			        		        					   }
			        		        					   if(models[i].data.attendanceStatus){
			        		        						   other++;
			        		        						   var data  = this.getStudentAttendancegrid().down('#StudentAttendanceStatus_Id').getStore().data.items;
			        			        					   	for(var j= 0; j<data.length;j++){
			        			        					   		if(data[j].data.value == models[i].data.attendanceStatus){
			        			        					   			if(data[j].data.code == 'PRESENT')
			        			        					   				presentSummaryCount++;
			        			        					   			if(data[j].data.code == 'ABSENT')
			        			        					   				absentSummaryCount++;
			        			        					   		}
			        			        					   	}
			        		        					   }
			        		        				   }
			        		        				   var gridCount = this$.getStudentattendancecountgrid();
			        	    	                	   var  data = {
			        	    	                			   totalStudent:store.data.length,
			        	    	                			   totalPresent:preCount,
			        	    	                			   totalAbsent:absCount,
			        	    	                			   otherCount:other,
			        	    	                			   presentPercent:parseFloat((presentSummaryCount/store.data.length)*100).toFixed(2)+"%",
			        	    	                			   absentPercent:parseFloat((absentSummaryCount/store.data.length)*100).toFixed(2)+"%",
			        	    	                	   };
			        	    	                	   var gridStore =  gridCount.getStore();
			        	    		            		gridStore.removeAll();
			        	    		            		gridStore.loadRawData(data, true);
			                        	        }, 50, this);
			        	                	    break;
		        	                		   }
		        	                	   }
		        					   }
		        					   if(obj.text==getProgramandcourseTranslation('PRESENT')){
		        	                	   for(var i =0; i<store.data.length;i++){
		        	                		   if(rowIndex==i){
			        	                		models[rowIndex].set('absent', false);
			        	                	    Ext.defer(function() {
			        	                	    	if(models[rowIndex].data.present == true){
			        	                	    		models[rowIndex].set('attendanceStatus', null);
			        	                	    	}
			        	                	    	  var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
			        		        				   for(var i =0; i<store.data.length;i++){
			        		        					   if(models[i].data.present){
			        		        						   preCount++;
			        			        					   presentSummaryCount++;
			        		        					   }
			        		        					   if(models[i].data.absent){
			        		        						   absCount++;
			        			        					   absentSummaryCount++;
			        		        					   }
			        		        					   if(models[i].data.attendanceStatus){
			        		        						   other++;
			        		        						   var data  = this.getStudentAttendancegrid().down('#StudentAttendanceStatus_Id').getStore().data.items;
			        			        					   	for(var j= 0; j<data.length;j++){
			        			        					   		if(data[j].data.value == models[i].data.attendanceStatus){
			        			        					   			if(data[j].data.code == 'PRESENT')
			        			        					   				presentSummaryCount++;
			        			        					   			if(data[j].data.code == 'ABSENT')
			        			        					   				absentSummaryCount++;
			        			        					   		}
			        			        					   	}
			        		        					   }
			        		        				   }
			        		        				   var gridCount = this$.getStudentattendancecountgrid();
			        	    	                	   var  data = {
			        	    	                			   totalStudent:store.data.length,
			        	    	                			   totalPresent:preCount,
			        	    	                			   totalAbsent:absCount,
			        	    	                			   otherCount:other,
			        	    	                			   presentPercent:parseFloat((presentSummaryCount/store.data.length)*100).toFixed(2)+"%",
			        	    	                			   absentPercent:parseFloat((absentSummaryCount/store.data.length)*100).toFixed(2)+"%",
			        	    	                	   };
			        	    	                	   var gridStore =  gridCount.getStore();
			        	    		            		gridStore.removeAll();
			        	    		            		gridStore.loadRawData(data, true);
			                        	        }, 50, this);
			        	                	    break;
		        	                		   }
		        	                	   }
		        					   }
	        				   }else{
	        					   if(obj.text==getProgramandcourseTranslation('ABSENT')){
	        	                	   for(var i =0; i<store.data.length;i++){
	        	                		   if(rowIndex==i){
		        	                		models[rowIndex].set('present', true);
		        	                	    Ext.defer(function() {
		        	                	    	if(models[rowIndex].data.absent == true){
		        	                	    		models[rowIndex].set('attendanceStatus', null);
		        	                	    	}
		        	                	    	var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
		        		        				   for(var i =0; i<store.data.length;i++){
		        		        					   if(models[i].data.present){
		        		        						   preCount++;
		        			        					   presentSummaryCount++;
		        		        					   }
		        		        					   if(models[i].data.absent){
		        		        						   absCount++;
		        			        					   absentSummaryCount++;
		        		        					   }
		        		        					   if(models[i].data.attendanceStatus){
		        		        						   other++;
		        		        						   var data  = this.getStudentAttendancegrid().down('#StudentAttendanceStatus_Id').getStore().data.items;
		        			        					   	for(var j= 0; j<data.length;j++){
		        			        					   		if(data[j].data.value == models[i].data.attendanceStatus){
		        			        					   			if(data[j].data.code == 'PRESENT')
		        			        					   				presentSummaryCount++;
		        			        					   			if(data[j].data.code == 'ABSENT')
		        			        					   				absentSummaryCount++;
		        			        					   		}
		        			        					   	}
		        		        					   }
		        		        				   }
		        		        				   var gridCount = this$.getStudentattendancecountgrid();
		        	    	                	   var  data = {
		        	    	                			   totalStudent:store.data.length,
		        	    	                			   totalPresent:preCount,
		        	    	                			   totalAbsent:absCount,
		        	    	                			   otherCount:other,
		        	    	                			   presentPercent:parseFloat((presentSummaryCount/store.data.length)*100).toFixed(2)+"%",
		        	    	                			   absentPercent:parseFloat((absentSummaryCount/store.data.length)*100).toFixed(2)+"%",
		        	    	                	   };
		        	    	                	   var gridStore =  gridCount.getStore();
		        	    		            		gridStore.removeAll();
		        	    		            		gridStore.loadRawData(data, true);
		                        	        }, 50, this);
		        	                	    break;
	        	                		   }
	        	                	   }
	        					   }
	        					   if(obj.text==getProgramandcourseTranslation('PRESENT')){
	        	                	   for(var i =0; i<store.data.length;i++){
	        	                		   if(rowIndex==i){
		        	                		models[rowIndex].set('absent', true);
		        	                	    Ext.defer(function() {
		        	                	    	if(models[rowIndex].data.present == true){
		        	                	    		models[rowIndex].set('attendanceStatus', null);
		        	                	    	}
		        	                	    	var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
		        		        				   for(var i =0; i<store.data.length;i++){
		        		        					   if(models[i].data.present){
		        		        						   preCount++;
		        			        					   presentSummaryCount++;
		        		        					   }
		        		        					   if(models[i].data.absent){
		        		        						   absCount++;
		        			        					   absentSummaryCount++;
		        		        					   }
		        		        					   if(models[i].data.attendanceStatus){
		        		        						   other++;
		        		        						   var data  = this.getStudentAttendancegrid().down('#StudentAttendanceStatus_Id').getStore().data.items;
		        			        					   	for(var j= 0; j<data.length;j++){
		        			        					   		if(data[j].data.value == models[i].data.attendanceStatus){
		        			        					   			if(data[j].data.code == 'PRESENT')
		        			        					   				presentSummaryCount++;
		        			        					   			if(data[j].data.code == 'ABSENT')
		        			        					   				absentSummaryCount++;
		        			        					   		}
		        			        					   	}
		        		        					   }
		        		        				   }
		        		        				   var gridCount = this$.getStudentattendancecountgrid();
		        	    	                	   var  data = {
		        	    	                			   totalStudent:store.data.length,
		        	    	                			   totalPresent:preCount,
		        	    	                			   totalAbsent:absCount,
		        	    	                			   otherCount:other,
		        	    	                			   presentPercent:parseFloat((presentSummaryCount/store.data.length)*100).toFixed(2)+"%",
		        	    	                			   absentPercent:parseFloat((absentSummaryCount/store.data.length)*100).toFixed(2)+"%",
		        	    	                	   };
		        	    	                	   var gridStore =  gridCount.getStore();
		        	    		            		gridStore.removeAll();
		        	    		            		gridStore.loadRawData(data, true);
		                        	        }, 50, this);
		        	                	    break;
	        	                		   }
	        	                	   }
	        					   }
	        				   }
	        			   }
	        		   },
	        		   'studentattendance combo#programBatch_batchId': {
	        			   select: function(obj, record) {
	        				   var this$  = this;
	        				   var portalId = this.getCurrentLoggedPortalId();
	        				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	    	                   var wheatherSchool = alinfomodel.get('wheatherSchool');
	        				   var facultyId = null;
	        				   if(portalId==2){
	        				   facultyId = this.getCurrentlyLoggedInUser().id;
	        				   }
	        				   this.getStudentAttendancegrid().getStore().removeAll();
	        				   this.getStudentattendancecountgrid().getStore().removeAll();
	        				   this$.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
	        				   var batchId = record[0].get("id");
	        				   if(batchId > 0){
	        					   var form = this.getStudentattendance();
	        					   form.down("#periodIdItemId").clearValue();
	        					   form.down("#programCoursection_ID").clearValue();
	        					   form.down('#facutlyId').clearValue();
	        					   form.down("#periodIdItemId").setDisabled(false);
								   var store = form.down("#periodIdItemId").getStore();
								   store.getProxy().extraParams = {
									   id: batchId,
									   isCurrentPeriod:true
								   };
								   store.load({
									   callback: function(records, operation, success) {
										   if (success) {
											   if(records.length==0)
											   {
												   form.down("#programCoursection_ID").setDisabled(true);
												   if(wheatherSchool) {
													   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
												   }
												   this$.validateAttendanceSearchForm();
											   }
											   if(records.length==1){
												   form.down("#periodIdItemId").setValue(records[0].get('id'));
												   form.down("#periodIdItemId").clearInvalid();
												   form.down("#programCoursection_ID").setDisabled(false);
												   var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
												   store.getProxy().extraParams = {
													   periodId: records[0].get('id'),
													   facultyId:facultyId
												   };
												   store.load({
													   callback: function(records, operation, success) {
														   if (success) {
															   if(records.length==1){
																   form.down("#programCoursection_ID").setValue(records[0].data.sectionId);
																   form.getForm().findField('facutly').setValue(records[0].data.facultyId);
																   form.down("#programCoursection_ID").clearInvalid();
																   form.getForm().findField('facutly').clearInvalid();
																   this$.validateAttendanceSearchForm();
															   }
														   } this$.validateAttendanceSearchForm();
													   }
												   });

											   }
											
										   } this$.validateAttendanceSearchForm();
									   }
								   });this$.validateAttendanceSearchForm();
	        				   }this$.validateAttendanceSearchForm();
	        			   }
	        		   },
	        		   'studentattendance combo#periodIdItemId': {
	        			   select: function(obj, record) {
	        				   var this$  =  this;
	        				   var portalId = this.getCurrentLoggedPortalId();
	        				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	    	                   var wheatherSchool = alinfomodel.get('wheatherSchool');
	        				   var facultyId = null;
	        				   if(portalId==2){
	        				   facultyId = this.getCurrentlyLoggedInUser().id;
	        				   }
	        				   this.getStudentAttendancegrid().getStore().removeAll();
	        				   this.getStudentattendancecountgrid().getStore().removeAll();
	        				   this$.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
	        				   var periodId = record[0].get("id");
	        				   if(periodId > 0){
	        					   var form = this.getStudentattendance();
	        					   form.down("#programCoursection_ID").clearValue();
	        					   form.down('#facutlyId').clearValue();
	        					   form.down("#programCoursection_ID").setDisabled(false);
	        					   var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
								   store.getProxy().extraParams = {
									   periodId: periodId,
									   facultyId:facultyId
								   };
								   store.load({
									   callback: function(records, operation, success) {
										   if (success) {
											   if(records.length==0){
												   form.down("#programCoursection_ID").setDisabled(true);
												   if(wheatherSchool) {
													   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

												   } 
											   }
											   if(records.length==1){
												   form.down("#programCoursection_ID").setValue(records[0].data.sectionId);
												   form.getForm().findField('facutly').setValue(records[0].data.facultyId);
											   }
										   }
									   }
								   });
	        				   }
	        			   }
	        		   },
	        		   'studentattendance combo#studentAtt_studentAttendanceType': {
	        			   select: function(obj, record) {
	        				   this.studentAttendanceTypeDropdown(); 
	        			   }
	        		   },
	        		   'studentattendance combo#programCoursection_ID':{
	        			   select:function(obj, record){
	        				   var $this = this;
	        				   this.getStudentAttendancegrid().getStore().removeAll();
	        				   this.getStudentattendancecountgrid().getStore().removeAll();
	        				   this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
	        				   var form = $this.getStudentattendance().getForm();
	        				   form.findField('facutly').setValue(record[0].data.facultyId);
	        				   form.isValid();
	        			   }
	        		   },
	        		   'studentattendance combo#academicTerm': {
	        			   select: function(obj, record) {
	        				   var academyLocationId = this.getCurrentAcademyLocation();
	        				   var courseCombo = this.getStudentattendance().down('customcombobox#courseId');
	        				   var academicTermId=this.getStudentattendance().down('#academicTerm').getValue();
	        				   courseCombo.clearValue();
	        				   var courseStore = courseCombo.getStore();
	        				   courseStore.getProxy().extraParams = {
	        					   academyLocationIds:academyLocationId,
	        					   academicTermId:academicTermId,
	        					   isCurrentPeriod:true
	        				   };
	        				   courseStore.load();
	        			   }},
	        			   'studentattendance combo#courseId': {
		        			   change: function(obj, record){
		        				   var me = this;
		        				   var form = obj.up('form');
		        				   var courseId = obj.value;
		        				   if(courseId > 0) {
		        					   this.courseNprogramSection(obj, record);
		        					   this.loadCourseTopics(record);
		        				   } else {
		        					   form.down("#courseVariantId").setVisible(true);
		        		        	   form.down("#courseVariantId").clearValue();
		        		        	   form.down("#courseVariantId").setDisabled(true);
		        		        	   form.down("#topicId").setDisabled(true);
		        		        	   form.down("#topicId").clearValue();
		        		        	   form.down("#facutlyListId").clearValue();
		        		        	   form.down("#timeSlotListId").clearValue();
		        		        	   form.down("#timetableSlotListId").clearValue();
		        		        	   form.down("#facutlyListId").setDisabled(true);
		        				   }
		        			   }
		        		   },
	        		   'studentattendance customcombobox[itemId=courseVariantId]':{
	        			   change: function(obj, record){
	        				   var me = this;
	        				   var form = obj.up('form');
	        				   var courseVariantId = obj.value;
        		        	   form.down("#facutlyListId").clearValue();
	        				   if(courseVariantId > 0) {
	        					   me.facultyList(); 
	        				   } else {
	        		        	   form.down("#timeSlotListId").clearValue();
	        		        	   form.down("#timetableSlotListId").clearValue();
	        		        	   form.down("#facutlyListId").setDisabled(true);
	        		        	   form.down("#timeSlotListId").setDisabled(true);
	        		        	   form.down("#timetableSlotListId").setDisabled(true);
	        				   }
	        			   }
	        		   },
	        		   'studentattendance datefield[itemId=dateOfAttendance_Id]':{
	        			   select: function(date) {
	        				   var $this = this;
	        				   var courseVariantId = this.getStudentattendance().down('#courseVariantId').getValue();
	        				   if(courseVariantId > 0) {
	        					   this.facultyList();
	        				   }
	        				   this.getStudentAttendancegrid().getStore().removeAll();
	        				   this.getStudentattendancecountgrid().getStore().removeAll();
	        				   this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
	        				   var grid = $this.getStudentattendancegrid();
	        				   grid.down('#markOnlyAttendance_Id').items.items[0].setValue(false);
	        				   grid.down('#markOnlyAttendance_Id').items.items[1].setValue(false);
	        				   grid.down('#markOnlyAttendance_Id').items.items[2].setValue(false);
	        				   grid.down('#otherStatusId').clearValue();
	        				   grid.down('#otherStatusId').setVisible(false);
	        				   $this.getStudentAttendancegrid().getStore().removeAll();
	        				   $this.getStudentattendancecountgrid().getStore().removeAll();
	        				   
	        				   var dateVal = date.getValue();
	        				   var newDate = null;
								Ext.Ajax.request({
									type : 'rest',
									url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
									method : 'GET',
									async: false,
									success : function(form1, action) {
										data = Ext.JSON.decode(form1.responseText);
										newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
										newDate = new Date(newDate)
										 var fromTime = $this.getStudentattendance().down('#fromTime');
				        				   if(dateVal.getDate() == newDate.getDate()){
				        					   var time = moment(newDate).format("HH:mm"); 
				        					   fromTime.setMaxValue(time);
				        				   }else{
				        					   fromTime.setMaxValue(false);
				        				   }
									}});
	        			   }
	        		   },
	        		   'studentattendance multiselectcombofield#timeSlotListId':{
	        			   change:function(obj, record){
	        				   var $this = this;
	        				   var form = this.getStudentattendance();
	        				   var formVal = this.getStudentattendance().getForm();
	        				   form.down('#fromTime').clearValue();
        					   form.down('#toTime').clearValue();
	        				   if(record != null && record.length > 0){
	        					   form.down('#fromTime').setDisabled(true);
	        					   form.down('#toTime').setDisabled(true);
	        					   form.down('#fromTime').allowBlank=true;
	        					   form.down('#toTime').allowBlank=true;
	        					   form.down('#timeBtnAdd').setVisible(true);
	        					   form.down('#timeBtnAdd').setDisabled(true);
	        				   }else{
	        					   form.down('#fromTime').setDisabled(false);
	        					   form.down('#toTime').setDisabled(false);
	        					   form.down('#fromTime').allowBlank=false;
	        					   form.down('#toTime').allowBlank=false;
	        				   }
	        				   var panelContiner = this.getStudentattendance().down('#panelId');
	        					if(panelContiner.items.length > 1){
	        						for(var i=panelContiner.items.length;i>=1;i--){
	        							panelContiner.remove(panelContiner.items.items[i]);
	        						}
	        					}
	        					formVal.checkValidity();
	        				   var grid = $this.getStudentattendancegrid();
	        				   grid.down('#markOnlyAttendance_Id').items.items[0].setValue(false);
	        				   grid.down('#markOnlyAttendance_Id').items.items[1].setValue(false);
	        				   grid.down('#markOnlyAttendance_Id').items.items[2].setValue(false);
	        				   grid.down('#otherStatusId').clearValue();
	        				   grid.down('#otherStatusId').setVisible(false);
	        				   $this.getStudentAttendancegrid().getStore().removeAll();
	        				   $this.getStudentattendancecountgrid().getStore().removeAll();
	        				   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
	        			   }
	        		   },
	        		   'studentattendance multiselectcombofield#timetableSlotListId':{
	        			   change:function(obj, record){
	        				   var $this = this;
	        				   var form = this.getStudentattendance();
	        				   var formVal = this.getStudentattendance().getForm();
	        				   form.down("#topicId").clearValue();
	        				   form.down('#fromTime').clearValue();
        					   form.down('#toTime').clearValue();
	        				   if(record != null && record.length > 0){
	        					   form.down('#dateOfAttendance_Id').setDisabled(true);
	        					   form.down('#fromTime').setDisabled(true);
	        					   form.down('#toTime').setDisabled(true);
	        					   form.down('#fromTime').allowBlank=true;
	        					   form.down('#toTime').allowBlank=true;
	        					   form.down('#dateOfAttendance_Id').allowBlank=true;
	        					   form.down('#timeBtnAdd').setVisible(true);
	        					   form.down('#timeBtnAdd').setDisabled(true);
	        					   this.loadCourseTopics(form.down('#courseId').getValue());
	        				   }else{
	        					   form.down('#dateOfAttendance_Id').setDisabled(false);
	        					   form.down('#dateOfAttendance_Id').allowBlank=false;
	        					   form.down('#fromTime').setDisabled(false);
	        					   form.down('#toTime').setDisabled(false);
	        					   form.down('#fromTime').allowBlank=false;
	        					   form.down('#toTime').allowBlank=false;
	        					   this.loadCourseTopics(form.down('#courseId').getValue());
	        				   }
	        				   var panelContiner = this.getStudentattendance().down('#panelId');
	        					if(panelContiner.items.length > 1){
	        						for(var i=panelContiner.items.length;i>=1;i--){
	        							panelContiner.remove(panelContiner.items.items[i]);
	        						}
	        					}
	        					formVal.checkValidity();
	        					var grid = $this.getStudentattendancegrid();
	        					grid.down('#markOnlyAttendance_Id').items.items[0].setValue(false);
	        					grid.down('#markOnlyAttendance_Id').items.items[1].setValue(false);
	        					grid.down('#markOnlyAttendance_Id').items.items[2].setValue(false);
	        					grid.down('#otherStatusId').clearValue();
	        					grid.down('#otherStatusId').setVisible(false);
	        					$this.getStudentAttendancegrid().getStore().removeAll();
	        					$this.getStudentattendancecountgrid().getStore().removeAll();
	        					$this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
	        			   }
	        		   },
	        		   'studentattendance timefield#fromTime':{
	        			   change:function(obj, record){
	        				   var $this = this;
	        				   var form = this.getStudentattendance();
	        				   var formVal = this.getStudentattendance().getForm();
	        				   if (!isNullOrEmpty(record)) {
	        					   form.down('#timeBtnAdd').setDisabled(false);
	        					   form.down('#timeBtnAdd').setVisible(true);
	        					   var attendanceSlot = form.getForm().findField('attendanceSlot').getValue();
		        				   if(attendanceSlot == 'TIME_TABLE_SLOTS') {
		        					   form.down('#timetableSlotListId').setDisabled(true);
		        					   form.down('#timetableSlotListId').allowBlank = true;
		        				   } else if(attendanceSlot == 'CALENDAR_SLOTS'){
		        					   form.down('#timeSlotListId').setDisabled(true);
		        					   form.down('#timeSlotListId').allowBlank = true;
		        				   }
	        				   }else{
	        					   var courseVariantId = form.down('#courseVariantId').getValue();
	        					   var facultyId =  form.down('#facutlyListId').getValue();
	        					   form.down('#timeBtnAdd').setDisabled(true);
	        					   form.down('#timeBtnAdd').setVisible(true);
	        					   var attendanceSlot = form.getForm().findField('attendanceSlot').getValue();
		        				   if(attendanceSlot == 'TIME_TABLE_SLOTS' && facultyId > 0) {
		        					   form.down('#timetableSlotListId').setDisabled(false);
		        					   form.down('#timetableSlotListId').allowBlank = false;
		        				   } else if(attendanceSlot == 'CALENDAR_SLOTS' && courseVariantId > 0){
		        					   form.down('#timeSlotListId').setDisabled(false);
		        					   form.down('#timeSlotListId').allowBlank = false;
		        				   }
	        				   }
	        				   formVal.checkValidity();
	        				   var grid = $this.getStudentattendancegrid();
	        				   grid.down('#markOnlyAttendance_Id').items.items[0].setValue(false);
	        				   grid.down('#markOnlyAttendance_Id').items.items[1].setValue(false);
	        				   grid.down('#markOnlyAttendance_Id').items.items[2].setValue(false);
	        				   grid.down('#otherStatusId').clearValue();
	        				   grid.down('#otherStatusId').setVisible(false);
	        				   $this.getStudentAttendancegrid().getStore().removeAll();
	        				   $this.getStudentattendancecountgrid().getStore().removeAll();
	        				   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
	        			   }
	        		   },
	        		   'studentattendance timefield#toTime':{
	        			   change:function(obj, record){
	        				   var $this = this;
	        				   var form = this.getStudentattendance();
	        				   var formVal = this.getStudentattendance().getForm();
	        				   if (!isNullOrEmpty(record)) {
	        					   form.down('#timeBtnAdd').setDisabled(false);
	        					   form.down('#timeBtnAdd').setVisible(true);
	        					   var attendanceSlot = form.getForm().findField('attendanceSlot').getValue();
		        				   if(attendanceSlot == 'TIME_TABLE_SLOTS') {
		        					   form.down('#timetableSlotListId').setDisabled(true);
		        					   form.down('#timetableSlotListId').allowBlank = true;
		        				   } else if(attendanceSlot == 'CALENDAR_SLOTS'){
		        					   form.down('#timeSlotListId').setDisabled(true);
		        					   form.down('#timeSlotListId').allowBlank = true;
		        				   }
		        				   
		        				   var date = form.down('#dateOfAttendance_Id');

		        				   var dateVal = date.getValue();
		        				   var newDate = null;
		        				   Ext.Ajax.request({
		        					   type : 'rest',
		        					   url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
		        					   method : 'GET',
		        					   async: false,
		        					   success : function(form1, action) {
		        						   data = Ext.JSON.decode(form1.responseText);
		        						   newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
		        						   newDate = new Date(newDate)
		        						   var fromTime = form.down('#fromTime');
		        						   if(dateVal.getDate() == newDate.getDate()){
		        							   var time = moment(newDate).format("HH:mm"); 
		        							   fromTime.setMaxValue(time);
		        						   }
		        					   }});

		        				   	 				 
	        				   }else{
	        					   var courseVariantId = form.down('#courseVariantId').getValue();
	        					   var facultyId =  form.down('#facutlyListId').getValue();
	        					   form.down('#timeBtnAdd').setDisabled(true);
	        					   form.down('#timeBtnAdd').setVisible(true);
	        					   var attendanceSlot = form.getForm().findField('attendanceSlot').getValue();
		        				   if(attendanceSlot == 'TIME_TABLE_SLOTS' && facultyId > 0) {
		        					   form.down('#timetableSlotListId').setDisabled(false);
		        					   form.down('#timetableSlotListId').allowBlank = false;
		        				   } else if(attendanceSlot == 'CALENDAR_SLOTS' && courseVariantId > 0){
		        					   form.down('#timeSlotListId').setDisabled(false);
		        					   form.down('#timeSlotListId').allowBlank = false;
		        				   }
	        				   }
	        				   formVal.checkValidity();
	        				   if(formVal.isValid()){
	        					    form.down('#searchBtn').setDisabled(false);
	        				   }
	        				   var grid = $this.getStudentattendancegrid();
	        				   grid.down('#markOnlyAttendance_Id').items.items[0].setValue(false);
	        				   grid.down('#markOnlyAttendance_Id').items.items[1].setValue(false);
	        				   grid.down('#markOnlyAttendance_Id').items.items[2].setValue(false);
	        				   grid.down('#otherStatusId').clearValue();
	        				   grid.down('#otherStatusId').setVisible(false);
	        				   $this.getStudentAttendancegrid().getStore().removeAll();
	        				   $this.getStudentattendancecountgrid().getStore().removeAll();
	        				   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
	        			   }
	        		   },
	        		   'studentattendance numberfield#studentAtt_noOfBackDays':{
	        			   blur:function(obj, record){
	        				   var form = this.getStudentattendance();
	        				   var value = obj.getValue();
	        				   var date = new Date();
	        				   var minDate = Ext.Date.add(date, Ext.Date.DAY, -value);
	        				   form.down("#dateOfAttendance_Id").setMinValue(minDate);
	        			   }
	        		   },
	        		   'studentattendance combo#facutlyListId':{
	        			   change:function(obj, record){
	        				   var form = obj.up('studentattendance').getForm();
	        				   var facultyId =  obj.value;
	        				   var attendanceSlot = form.findField('attendanceSlot').getValue();
	        				   if(facultyId > 0 && attendanceSlot == 'TIME_TABLE_SLOTS') {
	        					   form.findField('timetableSlotList').setDisabled(false);
	        					   form.findField('timetableSlotList').allowBlank = false;
	        					   form.findField('timeSlotList').setDisabled(true);
	        					   form.findField('timeSlotList').allowBlank = true;
	        					   var attendancesearchstrucure =  this.getMarkattendancemasterstructure().getForm();
	        					   var backDaysAllowed = attendancesearchstrucure.findField('noOfBackDays').getValue();
		        				   var courseVariantId =form.findField('courseVariant').getValue();
		        				   var store =form.findField('timetableSlotList').getStore();
		        				   store.getProxy().extraParams = {
		        					   courseVariantId:courseVariantId,
		        					   facultyId:facultyId,
		        					   backDaysAllowed:backDaysAllowed
		        				   };
		        				   store.load();
		        				   this.getStudentattendance().down("#fromTime").reset();
		        					this.getStudentattendance().down("#toTime").reset();
		        					var panelContiner = this.getStudentattendance().down('#panelId');
		        					if(panelContiner.items.length > 1){
		        						for(var i=panelContiner.items.length;i>=1;i--){
		        							panelContiner.remove(panelContiner.items.items[i]);
		        						}
		        					}
	        				   } else {
	        					   form.findField('timetableSlotList').setDisabled(true);
	        					   form.findField('timetableSlotList').allowBlank = true;
	        				   }
	        			   }
	        		   },
	        		   'studentpncattendancestructure':{
	        			   afterrender:function(obj){
	        				   var $this = this;
	        				   if(portalId==2){
	        					   var structure = obj.up('personinfofacultyportal');
		        				   var newStructure = obj.up('markattendancemasterstructure');
		        				   var gridOuter = newStructure.down('studentattendancegrid');
		        				   var grid = gridOuter.down('grid');
		        				   if(Ext.isDefined(structure)){
									   this.getGridHeaderFreezeWithoutPaginationTwoItemsCustomized(grid,structure,false);
		        				   }
								   this.getGridHeaderFreezeWithoutPaginationTwoItemsCustomized(grid,newStructure,false);
	        				   }
	        			   }
	        		   },
	        		   'markattendancemasterstructure':{
	        			   afterrender:function(obj){
	        				   var $this = this;
	        				   
	        				   //START - HIDING TIMESLOT PICKER ON SCROLL
	        				   obj.body.on('scroll', function(e, target) {
	        					   var timetableSlotListId = obj.down('#timetableSlotListId');
	        					   if(timetableSlotListId && timetableSlotListId.getPicker()){
	        						   if(timetableSlotListId.getPicker().isVisible()){
	        							   timetableSlotListId.getPicker().hide();
	        						   }
	        					   }
	        				   });
	        				 //END - HIDING TIMESLOT PICKER ON SCROLL
	        				   
	        				   //$this.getSessionValues(obj);
	        				   /*obj.body.on('scroll', function(e, target) {
		  	    					 var attendancestructure = obj.down('attendancestructure');
		  	    					 structure = attendancestructure.down('studentpncattendancestructure');
		  	    					 if(!isNullOrEmpty(structure)){
		  	    						 var gridOuter = structure.down('studentattendancegrid');
		  	    						 var grid = gridOuter.down('grid');
		  	    						 if(grid != undefined && portalId!=2){
		  	    							$this.getMultipleGridHeaderForMarkAttendanceFreeze(grid,structure,null);
		  	    						 }
		  	    					 }
		  	    				 });*/
		  	    			 
	        			   },
	        			   beforerender:function(structure){
	        				   var $this = this;
	        				   var academyLocationId = this.getCurrentAcademyLocation();
	        				   var portalId = this.getCurrentLoggedPortalId();
	        				   var studentAttendanceType = [];
	        				   var attendanceType=[];
	        				   Ext.Ajax.request({
	      	              		 type : 'rest',
	      	              		 async:false,
	      	              		 url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
	      	              		 params : {
	      	              			 academyLocatonId : academyLocationId
	      	              		 },
	      	              		 method : 'GET',
	      	              		 success : function(f, action) {
	      	              			 if(isNullOrEmpty(f.responseText)){
	      	              				showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
	      	              			 }else{
	      	              				var res = Ext.JSON.decode(f.responseText);
	      	              			 Ext.each(res, function(data) {
	      	              				attendanceType.push(data.studentAttendanceType);
	      	              			 });
	      	              			 studentAttendanceType=attendanceType.join();
	      	              			 }
	      	              		 }
	      		        	   });
	        				   var permissionsMap = new Ext.util.HashMap();
	        				   if(portalId==2){
	        					   permissionsMap = this.getATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES();   
	        				    } else {
	        					   permissionsMap = this.getATTENDANCE_ENTRY_PERMISSIONS();  
	        				   }
	        				   var associatedAcadLocationIds = new Array();
	        			    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	        					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	        					var tab2=false, tab3=false,tab4=false;
	        					var tab5=false;
	        					for (var i = 0; i < permissionList.length; i++) {
	        						if (permissionList[i] === "IMPORTATTENDANCE") {
	        								tab2=true;
	        						}
	        						if (permissionList[i] === "IMPORTATTENDANCE") {
		        							tab4=true;
	        						}
	        						if (permissionList[i] === "IMPORTCOURSELEVELATTENDANCE") {
		        							tab3=true;
	        						}
	        						if (permissionList[i] === "IMPORT_SERVICE_LEVEL_ATTENDANCE") {
	        							tab5=true;
        						}
	        					}
	        					Ext.suspendLayouts();
	        					$this.setTabsVisibility(tab2, tab3, structure,tab4,attendanceType,permissionList,tab5);
	        					Ext.resumeLayouts();
	        			   } 
	        		   },
	        		   'searchresultgrid[itemId=facultyattendancegrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
       		            click: function() {
       		                this.exportUserListFaculty(SERVERURL.PDFEXPORT,'pdf',false);
       		            }
       		        },
       		        'searchresultgrid[itemId=facultyattendancegrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
       		            click: function() {
       		                this.exportUserListFaculty(SERVERURL.PDFEXPORT,'pdf',true);
       		            }
       		        },
       		        'searchresultgrid[itemId=facultyattendancegrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
       		            click: function() {
       		                this.exportUserListFaculty(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
       		            }
       		        },
       		        'searchresultgrid[itemId=facultyattendancegrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
       		            click: function() {
       		                this.exportUserListFaculty(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
       		            }
       		        },
       		     'searchresultgrid[itemId=studentattendancegrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
 		            click: function() {
 		                this.exportUserListStudent(SERVERURL.PDFEXPORT,'pdf',false);
 		            }
 		        },
 		        'searchresultgrid[itemId=studentattendancegrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
 		            click: function() {
 		                this.exportUserListStudent(SERVERURL.PDFEXPORT,'pdf',true);
 		            }
 		        },
 		        'searchresultgrid[itemId=studentattendancegrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
 		            click: function() {
 		                this.exportUserListStudent(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
 		            }
 		        },
 		        'searchresultgrid[itemId=studentattendancegrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
 		            click: function() {
 		                this.exportUserListStudent(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
 		            }
 		        },
 		        
 		       'studentattendanceuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
 	   			   change: this.downloadUploadFormChange
 	   		   	},
 	   		   	'studentservicelevelattendanceuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
	   			   change: this.downloadServiceLevelUploadFormChange
	   		   	},
 	   		'downloadattendanceform':{
 			   render:function(obj){
 				   this.disableCoboByAttendanceType();
 			   }
   			},  
 		    
 		    'importutilityattendancelist':{
 		    	render:function(obj){
 		    		var $this = this;
 		    		var grid = $this.getImportutilityattendancelist();
 		    		var form =this.getAttendanceuploadoptionradiogroup();
	        		var isUploadAll = form.items.items[0].getValue().isUploadAll;
	        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_MODULE_ATTENDANCE');
 		    	},
 		    	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				if (e.target.tagName == 'A') {
    					var fileType=null;
    					if(cellIndex==1){
    						fileType='successFile';
    					}else if(cellIndex==6){
    						fileType='errorFile';
    					}else if(cellIndex==7){
    						fileType='logFile';
    					}
    					var documentId = record.get("id");
    					if (!isNullOrEmpty(documentId)) {
    						this.getDownloadFile(documentId,fileType);
    					}
    				}
    			}
 		    },
 		    
 		   'importutilityattendancelist button[itemId=btnForce]':{
   			click: function(obj) {
	            	var grid = this.getImportutilityattendancelist();
	            	if (grid.getSelectionModel().getCount() > 0) {
	            		if(grid.getSelectionModel().getCount() > 1){
		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
		        		}else{
   	                	var id = grid.getSelectionModel().selectionStart.data.id;
   	                	var urlAppend="?jobName="+id;
   	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
   	    	        	Ext.Ajax.request({
   	    	        		url: submitURL,
   	    	        		method: 'GET',
   	    	        		success: function(response) {
   	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
   	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
   	    	        			}else if(response.responseText==="SUCCESS"){ 
       	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
   	    	        			}
   	    	        		}
   	    	        	});
		        		}
	            	} else {
	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	            	}  
	            }
 		   },
 	   		'downloadattendanceform[itemId=downloadattendanceformId] combo#program_ID': {
 	   			render: function(){
 	   				var this$ = this;
 	   				var portalId = this.getCurrentLoggedPortalId();
 	   				var facultyId = null;
 	   				if(portalId==2){
 	   					facultyId = this.getCurrentlyLoggedInUser().id;
 	   				}
 	   				var form = this.getDownloadattendanceform();
 	   				var programField = form.down('#program_ID');
 	   				var programStore = programField.getStore();
 	   				programStore.getProxy().extraParams = {
 	   					academyLocationIds:this.getCurrentAcademyLocation(),
 	   					facultyId:facultyId
 	   				};
 	   				programStore.load({
 	   					callback: function(records, operation, success) {
 	   						if (success) {
 	   							if(records.length==1){
 	   								form.down("#program_ID").setValue(records[0].get('id'));
 	   								var batch = form.down("#batch_ID");
 	   								batch.setDisabled(false);
 	   								batch.reset();

 	   								var period = form.down("#period_ID"); 					   
 	   								period.setDisabled(true);
 	   								period.reset();

 	   								var section = form.down("#section_ID");
 	   								section.setDisabled(true);
 	   								section.reset();

 	   								var store = this$.getStore('enquiry.AcademicBatchStore');
 	   								store.getProxy().extraParams = {
 	   									id: records[0].get('id')
 	   									//isActive:true
 	   								};
 	   								store.load({
 	   									callback: function(records, operation, success) {
 	   										if (success) {
 	   											if(records.length==1){
 	   												form.down("#batch_ID").setValue(records[0].get('id'));
 	   												form.down("#period_ID").setDisabled(false);
 	   												var store = form.down("#period_ID").getStore();
 	   												store.getProxy().extraParams = {
 	   													id: records[0].get('id'),
 	   													isCurrentPeriod:true
 	   												};
 	   												store.load({
 	   													callback: function(records, operation, success) {
 	   														if (success) {
 	   															if(records.length==1){
 	   																form.down("#period_ID").setValue(records[0].get('id'))
 	   																form.down("#section_ID").setDisabled(false);
 	   																var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
 	   																store.getProxy().extraParams = {
 	   																	periodId: records[0].get('id'),
 	   																	facultyId:facultyId
 	   																};
 	   																store.load({
 	   																	callback: function(records, operation, success) {
 	   																		if (success) {
 	   																			if(records.length==1){
 	   																				form.down("#section_ID").setValue(records[0].data.sectionId);
 	   																				form.getForm().findField('facutly').setValue(records[0].data.facultyId);
 	   																				//form.getForm().findField('facutlyList').setDisabled(false);
 	   																				//this$.facultyList();
 	   																			}
 	   																		}
 	   																	}
 	   																});

 	   															}
 	   														}
 	   													}
 	   												});
 	   											}
 	   										}
 	   									}
 	   								});
 	   							}
 	   						}
 	   					}
 	   				});
 	   			},
 	   			select: function(obj, record) {
 	   				var this$ = this;
 	   				var portalId = this.getCurrentLoggedPortalId();
 	   				var facultyId = null;
 	   				if(portalId==2){
 	   					facultyId = this.getCurrentlyLoggedInUser().id;
 	   				}
 	   				var programId = record[0].get("id");
 	   				if(programId > 0){
 	   					var form = this.getDownloadattendanceform();

 	   					var batch = form.down("#batch_ID");
 	   					batch.setDisabled(false);
 	   					batch.reset();

 	   					var period = form.down("#period_ID"); 					   
 	   					period.setDisabled(true);
 	   					period.reset();

 	   					var section = form.down("#section_ID");
 	   					section.setDisabled(true);
 	   					section.reset();

 	   					var store = this.getStore('enquiry.AcademicBatchStore');
 	   					store.getProxy().extraParams = {
 	   						id: programId
 	   						//isActive:true
 	   					};
 	   					store.load({
 	   						callback: function(records, operation, success) {
 	   							if (success) {
 	   								if(records.length==1){
 	   									form.down("#batch_ID").setValue(records[0].get('id'));
 	   									form.down("#period_ID").setDisabled(false);
 	   									var store = form.down("#period_ID").getStore();
 	   									store.getProxy().extraParams = {
 	   										id: records[0].get('id'),
 	   										isCurrentPeriod:true
 	   									};
 	   									store.load({
 	   										callback: function(records, operation, success) {
 	   											if (success) {
 	   												if(records.length==1){
 	   													form.down("#period_ID").setValue(records[0].get('id'))
 	   													form.down("#section_ID").setDisabled(false);
 	   													var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
 	   													store.getProxy().extraParams = {
 	   														periodId: records[0].get('id'),
 	   														facultyId:facultyId
 	   													};
 	   													store.load({
 	   														callback: function(records, operation, success) {
 	   															if (success) {
 	   																if(records.length==1){
 	   																	form.down("#section_ID").setValue(records[0].data.sectionId);
 	   																	form.getForm().findField('facutly').setValue(records[0].data.facultyId);
 	   																}
 	   															}
 	   														}
 	   													});

 	   												}
 	   											}
 	   										}
 	   									});
 	   								}
 	   							}
 	   						}
 	   					});
 	   				}
 	   			}
 		   },
 	   		'downloadattendanceform[itemId=downloadattendanceformId] combo#batch_ID': {
 	   			select: function(obj, record) {
 	   				var this$ = this;
 	   				var portalId = this.getCurrentLoggedPortalId();
 	   				var facultyId = null;
 	   				if(portalId==2){
 	   					facultyId = this.getCurrentlyLoggedInUser().id;
 	   				}
 	   				var batchId = record[0].get("id");
 	   				if(batchId > 0){
 	   					var form = this.getDownloadattendanceform();

 	   					var period = form.down("#period_ID");
 	   					period.setDisabled(false);
 	   					period.reset();

 	   					var section = form.down("#section_ID");
 	   					section.setDisabled(true);
 	   					section.reset();

 	   					var store = period.getStore();
 	   					store.getProxy().extraParams = {
 	   						id: batchId,
 	   						isCurrentPeriod:true
 	   					};
 	   					store.load({
 	   						callback: function(records, operation, success) {
 	   							if (success) {
 	   								if(records.length==1){
 	   									form.down("#period_ID").setValue(records[0].get('id'))
 	   									form.down("#section_ID").setDisabled(false);
 	   									var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
 	   									store.getProxy().extraParams = {
 	   										periodId: records[0].get('id'),
 	   										facultyId:facultyId
 	   									};
 	   									store.load({
 	   										callback: function(records, operation, success) {
 	   											if (success) {
 	   												if(records.length==1){
 	   													form.down("#section_ID").setValue(records[0].data.sectionId);
 	   													form.getForm().findField('facutly').setValue(records[0].data.facultyId);
 	   												}
 	   											}
 	   										}
 	   									});

 	   								}
 	   							}
 	   						}
 	   					});
 	   				}
 	   			}
 	   			},
 		     
 	   		'downloadattendanceform[itemId=downloadattendanceformId] combo#period_ID': {
 	   			select: function(obj, record) {
 	   				var this$ = this;
 	   				var portalId = this.getCurrentLoggedPortalId();
 	   				var facultyId = null;
 	   				if(portalId==2){
 	   					facultyId = this.getCurrentlyLoggedInUser().id;
 	   				}
 	   				var periodId = record[0].get("id");
 	   				if(periodId > 0){
 	   					var form = this.getDownloadattendanceform();

 	   					var section = form.down("#section_ID");
 	   					section.setDisabled(false);
 	   					section.reset();

 	   					var store = this.getStore('attendance.SectionAndFacultyByPeriodID');
 	   					store.getProxy().extraParams = {
 	   						periodId: records[0].get('id'),
 	   						facultyId:facultyId
 	   					};
 	   					store.load({
 	   						callback: function(records, operation, success) {
 	   							if (success) {
 	   								if(records.length==1){
 	   									form.down("#section_ID").setValue(records[0].data.sectionId);
 	   									form.getForm().findField('facutly').setValue(records[0].data.facultyId);
 	   								}
 	   							}
 	   						}
 	   					});

 	   				}
 	   			}
 	   		},
 	   		'downloadattendanceform[itemId=downloadattendanceformId] combo#section_ID':{
			   select:function(obj, record){
				   var $this = this;
				   var form = $this.getDownloadattendanceform();
				   form.down("#facutly_Id").reset();
				   form.down("#facutly_Id").setValue(record[0].data.facultyId);
				 }
		    },

 	   		'downloadattendanceform datefield[itemId=dateOfAttendance_Id]':{
			   change : function(field, value) {
                	var form = this.getDownloadattendanceform().getForm();
                	form.findField('consolidateEndDate').setMinValue(value);
                }
		    },

 	   		'downloadattendanceform datefield[itemId=consolidateEndDate_Id]':{
			   change : function(field, value) {
                	var form = this.getDownloadattendanceform().getForm();
                	form.findField('dateOfAttendance').setMaxValue(value);
                }
		    },
		   
 	   	   'downloadattendanceform[itemId=downloadattendanceformId] button[itemId=resetBtn]':{
	   			click: this.resetDownloadAttendanceForm
 	   	   },
 	   	   
 	   	   'downloadattendanceform[itemId=downloadattendanceformId] button[itemId=programBatchDownoladBtnId]':{
			   click: function(){
				   var form = this.getDownloadattendanceform();
				   this.programBatchDownload(form);
			   }
		   },
		   'uploadservicelevelattendanceform[itemId=uploadservicelevelattendanceformId] button[itemId=resetBtn]':{
			   click:function(obj){
	        			var $this=this;
	        			var uploadAttendanceForm = $this.getUploadservicelevelattendanceform().getForm();
	        			uploadAttendanceForm.findField('file').reset();
	        			var uploadoptionradiogroupform  = $this.getServiceattendanceuploadoptionradiogroup();
 	        			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
 	        				isUploadAll: false
 	        			});
	        		}
	   	   },
		   'uploadattendanceform[itemId=uploadattendanceformId] button[itemId=resetBtn]':{
			   click:function(obj){
	        			var $this=this;
	        			var uploadAttendanceForm = $this.getUploadattendanceform().getForm();
	        			uploadAttendanceForm.findField('file').reset();
	        			var uploadoptionradiogroupform  = $this.getAttendanceuploadoptionradiogroup();
 	        			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
 	        				isUploadAll: false
 	        			});
	        		}
	   	   },
	        'uploadattendanceform uploadoptionradiogroup[itemId=attendanceUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	        	change: function( radioGroup, newValue, oldValue, eOpts){
	        		var grid =this.getImportutilityattendancelist();
	        		var form =this.getAttendanceuploadoptionradiogroup();
	        		var isUploadAll = newValue.isUploadAll;
	        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_MODULE_ATTENDANCE');
	        	}   
	 		   },
	   	   
	   	  'uploadattendanceform[itemId=uploadattendanceformId] button[itemId=programBatchUpload]':{
	   		click:function(obj){
     			var $this=this;
 	        	var importWin=$this.getUploadattendanceform();
 	        	var grdStore;
 	        	var form=$this.getUploadattendanceform();
 	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	        	$this.getHashOfFile(form);
	        	setTimeout(function() {
	 	        	form.getForm().submit({
	 	        		method : 'POST',
	 	        		url : submitUrl,
	 	        		success : function(form, action){
	 	        			if(action.response.responseText == "SUCCESS") {
	 	        				showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
	 	        				var grid = $this.getImportutilityattendancelist();
	 	        				var uploadoptionradiogroupform =this.getAttendanceuploadoptionradiogroup();
		    	        		var isUploadAll = uploadoptionradiogroupform.items.items[0].getValue().isUploadAll;
		    	        		$this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_MODULE_ATTENDANCE');
	 	        			}
	 	    	        },
	 	        		failure: function(form, action) {
	 	        			if(action.response.responseText == "SUCCESS") {
	 	        				showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	 	 	        			var grid = $this.getImportutilityattendancelist();
	 	 	        			var uploadoptionradiogroupform =$this.getAttendanceuploadoptionradiogroup();
		    	        		var isUploadAll = uploadoptionradiogroupform.items.items[0].getValue().isUploadAll;
		    	        		$this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_MODULE_ATTENDANCE');
	 	        			} else {
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
	 	        			}
	 	    	        }
	 	        	});
	        	},1000);
     		}
		   },
		   'studentcourselevelattendanceuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
 			   change: this.courseLevelAttendanceDownloadUploadFormChange
	 		},
	 		
	 		'downloadcourselevelattendancepbsform button[itemId=resetBtn]':{
	 			click:function(obj){
				   var $this = this;
				   var form =obj.up('downloadcourselevelattendancepbsform').getForm();
				   form.reset();
				   
				   var pbsForm = $this.getDownloadcourselevelattendancepbsform();
					
				   var program = pbsForm.down('#program_ID');
				   program.reset();

				   var batch_ID = pbsForm.down('#batch_ID');
				   batch_ID.setDisabled(true);
				   batch_ID.reset();
		        	  
				   var period_ID = pbsForm.down("#period_ID");
				   period_ID.setDisabled(true);
				   period_ID.reset();
					   
				   var section_ID = pbsForm.down("#section_ID"); 					   
				   section_ID.setDisabled(true);
				   section_ID.reset();
	 			}  
	 		},
	 		'downloadcourselevelattendancepbsform button[itemId=downoladBtnId]':{
	 			click:function(obj){
	 				var $this = this;
	 				var form = this.getDownloadcourselevelattendanceform();
	 				var pbsForm = this.getDownloadcourselevelattendancepbsform();
	 				var formValues = form.getValues();
	 				var pbsFormValues = pbsForm.getValues();
	 				
	 				var academyLocationId = this.getCurrentAcademyLocation();
	 				var sectionType = formValues.sectionType
	 				var programId = pbsFormValues.programId
	 				var batchId = pbsFormValues.batchId
	 				var periodId = pbsFormValues.periodId
	 				var sectionId = pbsFormValues.sectionId
	 				
	 				var csvForm = Ext.create('Ext.form.Panel'); 
	 				csvForm.getForm().submit({
	 					target: '_blank',
	 					method:'POST',
	 					params :{
	 						access_token : Ext.Ajax.defaultHeaders.access_token,
	 						academyLocationId : academyLocationId,
	 						sectionType : sectionType,
	 		 				programId : programId,
	 		 				batchId : batchId,
	 		 				periodId : periodId,
	 		 				sectionId :sectionId
	 					},
	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	 					url: SERVERURL.DOWNLOAD_TEMPLATE_COURSE_LEVEL_ATTENDANDCE,
	 					standardSubmit :true
	 				});
	 			}  
	 		},
	 		'downloadcourselevelattendancecbsform button[itemId=resetBtn]':{
	 			click:function(obj){
	 				
				   var $this = this;
				   var form =obj.up('downloadcourselevelattendancecbsform').getForm();
				   form.reset();
				   var cbsForm = $this.getDownloadcourselevelattendancecbsform();
				   
				   var allCourseId = cbsForm.down('#allCourseId');
				   allCourseId.reset();
		        	  
				   var componentSectionItemId = cbsForm.down("#componentSectionItemId");
				   componentSectionItemId.setDisabled(true);
				   componentSectionItemId.reset();
					   
				   var courseVariantId = cbsForm.down("#courseVariantId"); 					   
				   courseVariantId.setDisabled(true);
				   courseVariantId.reset();
				   
				   var courseSectionId = cbsForm.down("#courseSectionId");
				   courseSectionId.setDisabled(true);
				   courseSectionId.reset();
				  
				   var facultyId = cbsForm.down("#facultyId");
				   facultyId.setDisabled(true);
				   facultyId.reset();
	 			}  
	 		},
	 		'downloadcourselevelattendancecbsform button[itemId=downoladBtnId]':{
	 			click:function(obj){
	 				var $this = this;
	 				var form = this.getDownloadcourselevelattendanceform();
	 				var cbsForm = this.getDownloadcourselevelattendancecbsform();
	 				var formValues = form.getValues();
	 				var cbsFormValues = cbsForm.getValues();
	 				
	 				var academyLocationId = this.getCurrentAcademyLocation();
	 				var sectionType = formValues.sectionType
	 				var courseId = cbsFormValues.ALL_COURSE_ID
	 				var componentId = cbsFormValues.ALL_COMPONENT_ID
	 				var variantId = cbsFormValues.courseVariant
	 				var sectionId = cbsFormValues.ALL_SECTION_ID
	 				var facultyId = cbsFormValues.COURSE_FACULTY_ID
	 				
	 				var csvForm = Ext.create('Ext.form.Panel'); 
	 				csvForm.getForm().submit({
	 					target: '_blank',
	 					method:'POST',
	 					params :{
	 						access_token : Ext.Ajax.defaultHeaders.access_token,
	 						academyLocationId : academyLocationId,
	 						sectionType : sectionType,
	 						courseId : courseId,
	 						componentId : componentId,
	 						variantId : variantId,
	 						sectionId : sectionId,
	 						facultyId :facultyId
	 					},
	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	 					url: SERVERURL.DOWNLOAD_TEMPLATE_COURSE_LEVEL_ATTENDANDCE,
	 					standardSubmit :true
	 				});
	 			}  
	 		},
	 		'uploadcourselevelattendanceform button[itemId=uploadId]':{
	 			   click:function(obj){
	 				   var $this=this;
	 				   var importWin=obj.up('uploadcourselevelattendanceform');
	 				   var grdStore;
	 				   var form=obj.up('uploadcourselevelattendanceform');
	 				   submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	 				   $this.getHashOfFile(form);
	 				   setTimeout(function() {
		 				  form.getForm().submit({
		 					   method : 'POST',
		 					   url : submitUrl,
		 					   success : function(form, action){
		 						   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		 					   },
		 					   failure: function(form, action) {
   		   							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		 					   }
		 				  });
	 				   },1000);
	 				   Ext.defer(function() {
	 					   var grid = $this.getImportutilitycourselevelattendancelist();
	 					   var form = $this.getCourselevelattendanceuploadoptionradiogroup();
	 					   var isUploadAll = form.items.items[0].getValue().isUploadAll;
	 					   $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_COURSE_LEVEL_ATTENDANCE_UPLOAD');
	 				   }, 2000, this);
	 		        }  
	 		   },
	 		   'uploadcourselevelattendanceform button[itemId=resetBtn]':{
	 			   click:function(obj){
	 				   var $this = this;
	 				   var form =obj.up('uploadcourselevelattendanceform').getForm();
	 				   form.findField('file').reset();
	 				   var uploadoptionradiogroupform  = $this.getCourselevelattendanceuploadoptionradiogroup();
    				   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
    					   isUploadAll: false
    				   });
	 				   form.isValid();
	 			   },
	 			   render :function(obj){
	 				   var $this = this;
	 				   var form =obj.up('uploadcourselevelattendanceform').getForm();
	 				   var combo = form.findField('importUtilityMasterId');
	 				   combo.getStore().load({
	 					   callback: function(records, operation, success) {
	 						   for(var i in records){
	 							   if(records[i].data.value=='Bulk Course Level Attendance'){
	 								   combo.setValue(records[i].data.id);
	 								   combo.setReadOnly(true);
	 							   }
	 						   }
	 					   }	   
	 				   });
	 			   }  
	 		   },
     		   'uploadcourselevelattendanceform uploadoptionradiogroup[itemId=courselevelattendanceUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
     			   change: function( radioGroup, newValue, oldValue, eOpts){
     				   var grid =this.getImportutilitycourselevelattendancelist();
     				   var form =this.getCourselevelattendanceuploadoptionradiogroup();
     				   var isUploadAll = newValue.isUploadAll;
     				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_COURSE_LEVEL_ATTENDANCE_UPLOAD');
     			   }   
     		   },
	 		  'importutilitycourselevelattendancelist':{
				   render:function(obj){
					   var $this = this;
					   var grid = $this.getImportutilitycourselevelattendancelist();
					   var form = $this.getCourselevelattendanceuploadoptionradiogroup();
 					   var isUploadAll = form.items.items[0].getValue().isUploadAll;
 					   $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_COURSE_LEVEL_ATTENDANCE_UPLOAD');
				   },
				   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					   if (e.target.tagName == 'A') {
						   var fileType=null;
						   if(cellIndex==1){
							   fileType='successFile';
						   }else if(cellIndex==6){
							   fileType='errorFile';
						   }else if(cellIndex==7){
							   fileType='logFile';
						   }
						   var documentId = record.get("id");
						   if (!isNullOrEmpty(documentId)) {
							   this.getCourseLevelAtttendenceDownloadFile(documentId,fileType);
						   }
					   }
				   }
			   },
			   'importutilitycourselevelattendancelist button[itemId=btnForce]':{
				   click: function(obj) {
					   var grid = this.getImportutilitycourselevelattendancelist();
					   if (grid.getSelectionModel().getCount() > 0) {
						   if(grid.getSelectionModel().getCount() > 1){
							   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
						   }else{
							   var this$ = this;
							   var id = grid.getSelectionModel().selectionStart.data.id;
							   console.log(id);
							   var urlAppend="?jobName="+id;
							   var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
							   Ext.Ajax.request({
								   url: submitURL,
								   method: 'GET',
								   success: function(response) {
									   if(response.responseText==="JOB_STATUS_NOT_PENDING"){
										   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
									   }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
										   //console.log("Manual trigger hit");
										   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
									   }else if(response.responseText==="SUCCESS"){
										   //console.log("Manual trigger hit");
										   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
										   grid.getStore().reload();
									   }
								   }
							   });
						   }
					   } else {
						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					   }  
				   }
			   },
			   'downloadcourselevelattendanceform combobox[itemId=pbscbsgroupId]':{
				   change: this.pbscbsFormChange
			   },
			   
			   // service level
			   'downloadservicelevelattendanceform uploadoptionradiogroup[itemId=serviceattendanceUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
     			   change: function( radioGroup, newValue, oldValue, eOpts){
     				   var grid =this.getImportutilityservicelevelattendancelist();
     				   var form =this.getServiceattendanceuploadoptionradiogroup();
     				   var isUploadAll = newValue.isUploadAll;
     				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_SERVICE_LEVEL_ATTENDANCE');
     			   }   
     		   },
			   'importutilityservicelevelattendancelist':{
	 		    	render:function(obj){
	 		    		var $this = this;
	 		    		var grid = $this.getImportutilityservicelevelattendancelist();
	 		    		var form =this.getServiceattendanceuploadoptionradiogroup();
		        		var isUploadAll = form.items.items[0].getValue().isUploadAll;
		        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_SERVICE_LEVEL_ATTENDANCE');
	 		    	},
	 		    	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	    				if (e.target.tagName == 'A') {
	    					var fileType=null;
	    					if(cellIndex==1){
	    						fileType='successFile';
	    					}else if(cellIndex==6){
	    						fileType='errorFile';
	    					}else if(cellIndex==7){
	    						fileType='logFile';
	    					}
	    					var documentId = record.get("id");
	    					if (!isNullOrEmpty(documentId)) {
	    						this.getDownloadFile(documentId,fileType);
	    					}
	    				}
	    			}
	 		    },
			   
			   'downloadservicelevelattendanceform combo#serviceId': {
	 			   select: function(obj, record) {
    				   var this$ =  this;
    				   var form = obj.up('downloadservicelevelattendanceform');
    				   var academyLocationId = this.getCurrentAcademyLocation();
    				   var serviceCombo = form.down("#serviceId");
    				   var serviceId = serviceCombo.getValue();
    				   var programCombo = form.down("#serviceProgramId");
    				   var programBatchCombo = form.down("#serviceProgramBatchId");
    				   programCombo.setDisabled(false);
    				   programCombo.clearValue();
    				   programBatchCombo.setDisabled(false);
					   programBatchCombo.clearValue();
    				   var programComboStore = programCombo.getStore();
    				   
    				   programComboStore.getProxy().extraParams = {
    					   serviceId: serviceId,
    					   academyLocationId: academyLocationId
    				   };
    				   programComboStore.load({
    					   callback: function(records, operation, success) {
    						   if (success) {
    							   if(records.length==1){
    			    				   var programId = programCombo.getValue();
    			    				   var programBatchStore = programBatchCombo.getStore();
    			    				   programBatchStore.getProxy().extraParams = {
    			    					   serviceId: serviceId,
    			    					   programId: programId
    			    				   };
    			    				   programBatchStore.load({
    			    					   callback: function(records, operation, success) {
    			    						   if (success) {
    			    							   if(records.length==1){

    			    							   }
    			    						   }
    			    					   }
    			    				   });
    							   }
    							   else{
    			    				   var programBatchStore = programBatchCombo.getStore();
    			    				   programBatchStore.getProxy().extraParams = {
    			    					   serviceId: serviceId
    			    				   };
    			    				   programBatchStore.load({
    			    					   callback: function(records, operation, success) {
    			    						   if (success) {
    			    							   if(records.length==1){

    			    							   }
    			    						   }
    			    					   }
    			    				   });
    							   }
    						   }
    					   }
    				   });
    			   }
	 		   },
			   'downloadservicelevelattendanceform combo#serviceProgramId': {
	 			   select: function(obj, record) {
    				   var this$ =  this;
    				   var form = this$.getDownloadservicelevelattendanceform();
    				   var serviceCombo = form.down("#serviceId");
    				   var serviceId = serviceCombo.getValue();
    				   var programCombo = form.down("#serviceProgramId");
    				   var programId = programCombo.getValue();
    				   var programBatchCombo = form.down("#serviceProgramBatchId");
    				   programBatchCombo.setDisabled(false);
    				   programBatchCombo.clearValue();
    				   var programBatchStore = programBatchCombo.getStore();
    				   
    				   programBatchStore.getProxy().extraParams = {
    					   serviceId: serviceId,
    					   programId: programId
    				   };
    				   programBatchStore.load({
    					   callback: function(records, operation, success) {
    						   if (success) {
    							   if(records.length==1){

    							   }
    						   }
    					   }
    				   });
    			   }
	 		   },
	 		  'downloadservicelevelattendanceform datefield[itemId=dateOfAttendance_Id]':{
				   change : function(field, value) {
	                	var form = this.getDownloadservicelevelattendanceform().getForm();
	                	form.findField('consolidateEndDate').setMinValue(value);
	                }
			    },

	 	   		'downloadservicelevelattendanceform datefield[itemId=consolidateEndDate_Id]':{
				   change : function(field, value) {
	                	var form = this.getDownloadservicelevelattendanceform().getForm();
	                	form.findField('dateOfAttendance').setMaxValue(value);
	                }
			    },
			    'downloadservicelevelattendanceform button[itemId=resetBtn]':{
		 			click:function(obj){
					   var $this = this;
					   var form =obj.up('downloadservicelevelattendanceform');
					   form.getForm().reset();
					   
					   var service = form.down('#serviceId');
					   service.reset();

					   var serviceProgramId = form.down('#serviceProgramId');
					   serviceProgramId.setDisabled(true);
					   serviceProgramId.reset();
					   
					   var serviceProgramBatch = form.down('#serviceProgramBatchId');
					   serviceProgramBatch.setDisabled(true);
					   serviceProgramBatch.reset();
					   
					   var fromdate = form.down("#dateOfAttendance_Id");
					   fromdate.reset();
						  
					   var todate = form.down("#consolidateEndDate_Id");
					   todate.reset();
		 			}  
		 		},
		 		'importutilityservicelevelattendancelist button[itemId=btnForce]':{
		   			click: function(obj) {
			            	var grid = this.getImportutilityservicelevelattendancelist();
			            	if (grid.getSelectionModel().getCount() > 0) {
			            		if(grid.getSelectionModel().getCount() > 1){
				        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
				        		}else{
		   	                	var id = grid.getSelectionModel().selectionStart.data.id;
		   	                	var urlAppend="?jobName="+id;
		   	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
		   	    	        	Ext.Ajax.request({
		   	    	        		url: submitURL,
		   	    	        		method: 'GET',
		   	    	        		success: function(response) {
		   	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
		   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
		   	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
		   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
		   	    	        			}else if(response.responseText==="SUCCESS"){ 
		       	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
		   	    	        			}
		   	    	        		}
		   	    	        	});
				        		}
			            	} else {
			            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			            	}  
			            }
		 		},
		 		'uploadservicelevelattendanceform[itemId=uploadservicelevelattendanceformId] button[itemId=programBatchUpload]':{
			   		click:function(obj){
		     			var $this=this;
		 	        	var importWin=$this.getUploadservicelevelattendanceform();
		 	        	var grdStore;
		 	        	var form=$this.getUploadservicelevelattendanceform();
		 	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
			        	$this.getHashOfFile(form);
			        	setTimeout(function() {
			 	        	form.getForm().submit({
			 	        		method : 'POST',
			 	        		url : submitUrl,
			 	        		success : function(form, action){
			 	        			if(action.response.responseText == "SUCCESS") {
			 	        				showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
			 	        				var grid = $this.getImportutilityservicelevelattendancelist();
			 	        				var uploadoptionradiogroupform =this.getServiceattendanceuploadoptionradiogroup();
				    	        		var isUploadAll = uploadoptionradiogroupform.items.items[0].getValue().isUploadAll;
				    	        		$this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_SERVICE_LEVEL_ATTENDANCE');
			 	        			}
			 	    	        },
			 	        		failure: function(form, action) {
			 	        			if(action.response.responseText == "SUCCESS") {
			 	        				showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
			 	 	        			var grid = $this.getImportutilityservicelevelattendancelist();
			 	 	        			var uploadoptionradiogroupform =$this.getServiceattendanceuploadoptionradiogroup();
				    	        		var isUploadAll = uploadoptionradiogroupform.items.items[0].getValue().isUploadAll;
				    	        		$this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_SERVICE_LEVEL_ATTENDANCE');
			 	        			} else {
		   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
			 	        			}
			 	    	        }
			 	        	});
			        	},1000);
			        	Ext.defer(function() {
							var grid = $this.getImportutilityservicelevelattendancelist();
							var isUploadAll = true;
							$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_SERVICE_LEVEL_ATTENDANCE');
						}, 2000, this);
		     		}
				 },
				 'uploadservicelevelattendanceform uploadoptionradiogroup[itemId=serviceattendanceUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
					 change: function( radioGroup, newValue, oldValue, eOpts){
						 var grid =this.getImportutilityservicelevelattendancelist();
						 var form =this.getServiceattendanceuploadoptionradiogroup();
						 var isUploadAll = newValue.isUploadAll;
						 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_SERVICE_LEVEL_ATTENDANCE');
					 }   
				 },
				 'downloadservicelevelattendanceform button[itemId=downoladBtnId]':{
					 click:function(obj){
						 var $this = this;
						 var form = this.getDownloadservicelevelattendanceform();
						 var formValues = form.getValues();
						 var academyLocationId = this.getCurrentAcademyLocation();
						 var serviceId = formValues.service;
						 var serviceProgramId = formValues.serviceprogram;
						 var serviceprogramBatchId = formValues.serviceprogramBatch;
						 var dateOfAttendance = formValues.dateOfAttendance;
						 var consolidateEndDate = formValues.consolidateEndDate;
						 
						 var serviceName = form.getForm().findField('service').getDisplayValue();
						 var programName = form.getForm().findField('serviceprogram').getDisplayValue();
			        	 var batchName = form.getForm().findField('serviceprogramBatch').getDisplayValue();

						 var csvForm = Ext.create('Ext.form.Panel'); 
						 csvForm.getForm().submit({
							 target: '_blank',
							 method:'POST',
							 params :{
								 access_token : Ext.Ajax.defaultHeaders.access_token,
								 academyLocationId : academyLocationId,
								 serviceId : serviceId,
								 serviceProgramId : serviceProgramId,
								 serviceprogramBatchId : serviceprogramBatchId,
								 dateOfAttendance : dateOfAttendance,
								 consolidateEndDate :consolidateEndDate,
								 serviceName :serviceName,
								 programName :programName,
								 batchName :batchName,
							 },
							 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
							 url: SERVERURL.DOWNLOAD_TEMPLATE_SERVICE_LEVEL_ATTENDANDCE,
							 standardSubmit :true
						 });
					 }  
				 },
			   'downloadcourselevelattendancepbsform[itemId=downloadcourselevelattendancepbsformId] combo#program_ID': {
	 			   select: function(obj, record) {
	 				   var programId = record[0].get("id");
	 				   if(programId > 0){
	 					   var form = this.getDownloadcourselevelattendancepbsform();
	 					   
	 					   var batch = form.down("#batch_ID");
	 					   batch.setDisabled(false);
	 					   batch.reset();
	 					   
						   var period = form.down("#period_ID"); 					   
	 					   period.setDisabled(true);
	 					   period.reset();
	 					   
	 					   var section = form.down("#section_ID");
	 					   section.setDisabled(true);
	 					   section.reset();
	 					   
	 					   var store = this.getStore('enquiry.AcademicBatchStore');
	 					   store.getProxy().extraParams = {
	 						   id: programId
	 						   //isActive:true
	 					   };
	 					   store.load();
	 				   }
	 			   }
	 		   },   
	 		   'downloadcourselevelattendancepbsform[itemId=downloadcourselevelattendancepbsformId] combo#batch_ID': {
	 			   select: function(obj, record) {
	 				   var batchId = record[0].get("id");
	 				   if(batchId > 0){
	 					   var form = this.getDownloadcourselevelattendancepbsform();
	 					   
	 					   var period = form.down("#period_ID");
	 					   period.setDisabled(false);
	 					   period.reset();
						   
	 					   var section = form.down("#section_ID");
						   section.setDisabled(true);
						   section.reset();
	 					   
	 					   var store = period.getStore();
	 					   store.getProxy().extraParams = {
	 						   id: batchId,
	 						   isCurrentPeriod:true
	 					   };
	 					   store.load();
	 				   }
	 			   }
	 		   },
	 		   'downloadcourselevelattendancepbsform[itemId=downloadcourselevelattendancepbsformId] combo#period_ID': {
	 			   select: function(obj, record) {
	 				   var periodId = record[0].get("id");
	 				   if(periodId > 0){
	 					   var form = this.getDownloadcourselevelattendancepbsform();
	 					   
	 					   var section = form.down("#section_ID");
	 					   section.setDisabled(false);
	 					   section.reset();
	 					   
	 					   var store = this.getStore('attendance.SectionAndFacultyByPeriodID');
	 					   store.getProxy().extraParams = {
	 						   periodId: periodId
	 					   };
	 					   store.load();
	 				   }
	 			   }
	 		   },
	 		   'downloadcourselevelattendancecbsform combo[itemId=allCourseId]': {
	 			   select: function(obj, record) {
	 				   var $this=this;
	 				   var courseId = record[0].get("courseId");
	 				   var  componentField = this.getDownloadcourselevelattendancecbsform().down("#componentSectionItemId")
	 				   var courseVariantId = this.getDownloadcourselevelattendancecbsform().down("#courseVariantId");
 						courseVariantId.reset();
	 					var sectionAtComponentLevel = record[0].data.sectionAtComponentLevel;
	 					if(sectionAtComponentLevel) {
	 						componentField.setDisabled(false);
	 						componentField.allowBlank = false;
	 						componentField.reset();
	 						$this.getDownloadcourselevelattendancecbsform().down("#courseVariantId").setDisabled(true);
	 						componentField.show();
	 						if(courseId > 0) {//section on the bases of component
	 							componentField.getStore().getProxy().extraParams = {
	 								id : courseId
	 							};
	 							componentField.getStore().load();
	 						}
	 					 } else {
	 						componentField.hide();
	 						componentField.reset();
	 						componentField.allowBlank = true;
	 						$this.getDownloadcourselevelattendancecbsform().down('#courseVariantId').setVisible(true);
	 						$this.getDownloadcourselevelattendancecbsform().down("#courseVariantId").setDisabled(false);
		 					var store = courseVariantId.getStore();
		 					store.getProxy().extraParams = {
		 						courseId: courseId
		        			};
		 					store.load();
	 					}
	 					var componentSectionItemId = this.getDownloadcourselevelattendancecbsform().down("#componentSectionItemId");
	 					componentSectionItemId.reset();
	 					 
	 					var courseSectionId = this.getDownloadcourselevelattendancecbsform().down("#courseSectionId");
	 					courseSectionId.setDisabled(true);
	 					courseSectionId.reset();
	 					
	 					var facultyId = this.getDownloadcourselevelattendancecbsform().down("#facultyId");
	 					facultyId.setDisabled(true);
	 					facultyId.reset();
	 			   }
	 		   }, 
	 			 'downloadcourselevelattendancecbsform combo#componentSectionItemId': {
	 				 select: function(obj, record) {
	 					 var $this=this;
	 					 var courseVariantId = this.getDownloadcourselevelattendancecbsform().down("#courseVariantId");
	 					 courseVariantId.reset();
	 					 var form=$this.getDownloadcourselevelattendancecbsform().getForm();
	 					 var formValues=form.getFieldValues();
	 					 
	 					 var componentId=record[0].get("id");
	 					 var courseId = formValues.ALL_COURSE_ID;
	 					 
	 					 $this.getDownloadcourselevelattendancecbsform().down('#courseVariantId').setVisible(true);
	 					 $this.getDownloadcourselevelattendancecbsform().down('#courseVariantId').setDisabled(false);
	 					 var store = courseVariantId.getStore();
	 					 if(courseId > 0 && componentId > 0){
	 						store.getProxy().extraParams = {
		 						courseId: courseId,
		 						componentId:componentId
		        			};
		 					store.load();
	 					 }
	 					 var courseSectionId = this.getDownloadcourselevelattendancecbsform().down("#courseSectionId");
	 					 courseSectionId.setDisabled(true);
	 					 courseSectionId.reset();
	 					 var facultyId = this.getDownloadcourselevelattendancecbsform().down("#facultyId");
	 					 facultyId.setDisabled(true);
	 					 facultyId.reset();
	 				 }
	 			 },
	 			 'downloadcourselevelattendancecbsform combo#courseVariantId': {
	 				 select: function(obj, record) {
	 					 var $this=this;
	 					 $this.getDownloadcourselevelattendancecbsform().down("#courseSectionId").setDisabled(false);
	 					 
	 					 var form=$this.getDownloadcourselevelattendancecbsform().getForm();
	 					 var formValues=form.getFieldValues();
	 					 
	 					 var variantId = formValues.courseVariant;
	 					 var sectionStore = $this.getDownloadcourselevelattendancecbsform().down("#courseSectionId").getStore();
	 					 if(variantId > 0){
	 						 sectionStore.getProxy().extraParams = {
	 							variantId:variantId
	 						 };
	 						 sectionStore.load();
	 					 }
	 					var facultyId = this.getDownloadcourselevelattendancecbsform().down("#facultyId");
	 					facultyId.setDisabled(true);
	 					facultyId.reset();
	 				 }
	 			 },
	 			'downloadcourselevelattendancecbsform combo#courseSectionId': {
	 				select: function(obj, record) {
	 					 var $this = this;
	 					 var facultyCombo = $this.getDownloadcourselevelattendancecbsform().down("#facultyId");
	 					 facultyCombo.setDisabled(false);
	 					 
	 					 var form = $this.getDownloadcourselevelattendancecbsform().getForm();
	 					 var formValues=form.getFieldValues();
	 					 
	 					 var sectionId = formValues.ALL_SECTION_ID;
	 					 
	 					 var facultyStore = facultyCombo.getStore();
	 					 if(sectionId > 0){
	 						facultyStore.getProxy().extraParams = {
	 							sectionId:sectionId
	 						 };
	 						var portalId = $this.getCurrentLoggedPortalId();
	 						var facultyId = $this.getCurrentlyLoggedInUser();
	 						if(portalId == 2) {
	 							facultyStore.load({
	 		     		   			 callback: function(records, operation, success) {
	 		     		   				 facultyCombo.setValue(facultyId.id);
	 		     		   				 facultyCombo.setReadOnly(true);	 		     		   				 
	 		     		     		   }	   
	 		     		   		});
	 						} else {	
	 							facultyStore.load();
	 						}	
	 					 }
	 				 }
	 			 },
	 			'downloadservicelevelattendanceform':{
  			   		render:function(obj){
  			   		var $this = this;
  					var form = $this.getDownloadservicelevelattendanceform();
  					var academyLocationId = this.getCurrentAcademyLocation();
  					var serviceStore = form.down("#serviceId").getStore();
  					serviceStore.getProxy().extraParams = {
  						academeyLocationId: academyLocationId
  					   };
  					serviceStore.load();
  			   		}
	 			 },
	 			'downloadcourselevelattendancepbsform':{
  			   		render:function(obj){
  			   			this.disableDownloadcourselevelattendancepbsformByAttendanceType();
  			   		}
	 			 },
	 			'downloadcourselevelattendancecbsform':{
	 				render:function(obj){
	 					this.disableDownloadcourselevelattendancecbsformByAttendanceType();
	 					var courseId = obj.down('#allCourseId');
	 					var academyLocationId = this.getCurrentAcademyLocation();
	 					var portalId = this.getCurrentLoggedPortalId();
	 					var facultyId = this.getCurrentlyLoggedInUser();
	 					var studentCoursesStore = courseId.getStore();
	 					if(portalId == 2) {
	 						studentCoursesStore.getProxy().extraParams = {	
	 							facultyId : facultyId.id,
	 							academyLocationId:academyLocationId,
	 							sectionType:'CourseSection'
	 						};
	 					}else{
	 						studentCoursesStore.getProxy().extraParams = {
	 							academyLocationId:academyLocationId,
	 							sectionType:'CourseSection'			
	 						};
	 					}
	 					studentCoursesStore.load();
	 				}
	 			 },
	 			 'downloadcourselevelattendancepbsform':{
	 				 render:function(obj){
	 					 var $this = this;
	 					 
	 					 var academyLocationId = this.getCurrentAcademyLocation();
	 					 var programStore = $this.getStore('common.ProgramByAcademyLocationStore');
	 					 programStore.getProxy().extraParams = {
	 						academyLocationId:academyLocationId
 						 };
	 					 programStore.load();
	 				 }  
	 			 },
	 			'qrcodewindow[itemId=attendanceViewQRWin]':{
					afterrender: function(win){
						var me = this;
						var qrData = win.qrData;
						var qrDisplayData = win.qrDisplayData;
						var path=win.path;
						var qrDataJson = Ext.decode(qrData);

						$('#qrcode').html('<img src="'+path+'"/>');

						var test= path.src;
						var acedemyLocationName = me.getAcademyLocationDisplayName(me.getCurrentAcademyLocation());

						var printBtmVals = Object.values(qrDataJson);

						win.down('#qrALLabelCls').setText(acedemyLocationName);
						win.down('#qrOtherTxtLabelCls').setText(qrDisplayData);

						if(Ext.query('#'+win.id+' #qrcodetext').length){
							Ext.query('#'+win.id+' #qrcodetext')[0].innerText = win.qrCode;
        				}


					}
				},
				
				'attendanceImport panel[itemId=attendanceImportItemId] treepanel[itemId=attendanceImportTreePanelItemId]' : {
					render:function(obj){
						var $this = this;
						var containpanel = $this.getAttendanceImport();
						var treePanel = containpanel.down('#attendanceImportTreePanelItemId');
						var permissionsMap = new Ext.util.HashMap();
						if(portalId==2){
							permissionsMap = this.getATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES();   
						} else {
							permissionsMap = this.getATTENDANCE_ENTRY_PERMISSIONS();  
						}
						var associatedAcadLocationIds = new Array();
						associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
						var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
						var programParentNode = containpanel.down('treepanel').getStore().tree.root;

						if (programParentNode.hasChildNodes()) {
							programParentNode.removeAll();
						}

						Ext.each(permissionList, function (privilege) {
							if (privilege === 'IMPORTATTENDANCE') {
								programParentNode.appendChild({
									text : getProgramandcourseTranslation("UPLOAD_ATTENDANCE"),
									leaf: true,
									reportXtype: 'studentattendanceuploaddownloadstructure',
									reportXtypeItemId: 'studentattendanceuploaddownloadstructure'
								});
							}
						});

						Ext.each(permissionList, function (privilege) {
							if (privilege === 'IMPORTCOURSELEVELATTENDANCE') {
								programParentNode.appendChild({
									text : getProgramandcourseTranslation("UPLOAD_COURSE_LEVEL_ATTENDANCE"),
									leaf: true,
									reportXtype: 'studentcourselevelattendanceuploaddownloadstructure',
									reportXtypeItemId: 'studentcourselevelattendanceuploaddownloadstructure'
								});
							}
						});

						Ext.each(permissionList, function (privilege) {
							if (privilege === 'IMPORT_SERVICE_LEVEL_ATTENDANCE') {
								programParentNode.appendChild({
									text : getCommonTranslation('UPLOAD_SERVICE_LEVEL_ATTENDANCE'),
									leaf: true,
									reportXtype: 'studentservicelevelattendanceuploaddownloadstructure',
									reportXtypeItemId: 'studentservicelevelattendanceuploaddownloadstructure'
								});
							}
						});
					},
					itemclick : this.getOpenAttendanceImport
				},
 	   });
	 },
	 disableDownloadcourselevelattendancepbsformByAttendanceType : function(){
		 var studentForm = "";
		 var attendanceType= "";
		 if(this.getCurrentLoggedPortalId() == 2) {
			 var structure = this.getStudentcaptureattendancestructure();
			 attendanceType = structure.down('#newAttendanceTypeRadio').getValue().newAttendanceTypeWise;
		 } else {
			 studentform = this.getMarkattendancemasterstructure().getForm();
			 attendanceType = studentform.findField('attendanceType').getValue();
		 }
		 var downloadform = this.getDownloadcourselevelattendancepbsform();

		 if(attendanceType != 'COURSE_LEVEL') {
			 downloadform.down('#program_ID').setDisabled(true);
		 }
	 },
	 disableDownloadcourselevelattendancecbsformByAttendanceType : function(){
		 var studentForm = "";
		 var attendanceType= "";
		 if(this.getCurrentLoggedPortalId() == 2) {
			 var structure = this.getStudentcaptureattendancestructure();
			 if(structure != undefined){
				 attendanceType = structure.down('#newAttendanceTypeRadio').getValue().newAttendanceTypeWise;
			 }
		 } else {
			 studentform = this.getMarkattendancemasterstructure().getForm();
			 attendanceType = studentform.findField('attendanceType').getValue();
		 }
		 var downloadform = this.getDownloadcourselevelattendancecbsform();
		
		 if(attendanceType != 'COURSE_LEVEL') {
			 downloadform.down('#allCourseId').setDisabled(true);
		 }
	 },
	 getCourseLevelAtttendenceDownloadFile : function(documentId,fileType){
	 	   if(!isNullOrEmpty(documentId)){
	 		   var csvForm = Ext.create('Ext.form.Panel'); 
	 		   csvForm.getForm().submit({
	 			   target: '_blank',
	 			   method:'POST',
	 			   params :{
	 				   access_token : Ext.Ajax.defaultHeaders.access_token
	 			   },
	 			   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	 			   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
	 			   standardSubmit :true
	 		   });
	 	   }
	    },
	    courseLevelAttendanceDownloadUploadFormChange : function(cb, nv, ov){
			var $this = this;
			var structure = cb.up('studentcourselevelattendanceuploaddownloadstructure');
			var downloadTemplateForm = structure.down('downloadcourselevelattendanceform');
			var uploadTemplateForm = structure.down('uploadcourselevelattendanceform');
			var grid = $this.getImportutilitycourselevelattendancelist();
			if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
				uploadTemplateForm.hide();
				downloadTemplateForm.show();
				grid.setVisible(false);
			}else{
				$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
            	var uploadoptionradiogroupform  = $this.getCourselevelattendanceuploadoptionradiogroup();
            	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
            		isUploadAll: false
            	});
				downloadTemplateForm.hide();
				uploadTemplateForm.show();
				grid.setVisible(true);
				uploadTemplateForm.down("#uploadFileField").reset();
			}
			var pbsForm = $this.getDownloadcourselevelattendancepbsform();
			
			var program = pbsForm.down('#program_ID');
			program.reset();

			var batch_ID = pbsForm.down('#batch_ID');
			batch_ID.setDisabled(true);
			batch_ID.reset();
        	  
			var period_ID = pbsForm.down("#period_ID");
			period_ID.setDisabled(true);
			period_ID.reset();
			   
			var section_ID = pbsForm.down("#section_ID"); 					   
			section_ID.setDisabled(true);
			section_ID.reset();
			var cbsForm = $this.getDownloadcourselevelattendancecbsform();
		   
			var allCourseId = cbsForm.down('#allCourseId');
			allCourseId.reset();
        	  
			var componentSectionItemId = cbsForm.down("#componentSectionItemId");
			componentSectionItemId.setDisabled(true);
			componentSectionItemId.reset();
			   
			var courseVariantId = cbsForm.down("#courseVariantId"); 					   
			courseVariantId.setDisabled(true);
			courseVariantId.reset();
		   
			var courseSectionId = cbsForm.down("#courseSectionId");
			courseSectionId.setDisabled(true);
			courseSectionId.reset();
		  
			var facultyId = cbsForm.down("#facultyId");
			facultyId.setDisabled(true);
			facultyId.reset();
		},
		pbscbsFormChange : function(cb, nv, ov) {
			var $this = this;
			var structure = cb.up('downloadcourselevelattendanceform');
			var pbs = structure.down('downloadcourselevelattendancepbsform');
			
			var cbs = structure.down('downloadcourselevelattendancecbsform');
			 var studentForm = "";
			 var attendanceType= "";
			 if(this.getCurrentLoggedPortalId() == 2) {
				 studentForm = this.getStudentcaptureattendancestructure();
				 attendanceType = studentForm.down('#newAttendanceTypeRadio').getValue().newAttendanceTypeWise;
			 } else {
				 studentform = this.getMarkattendancemasterstructure().getForm();
				 attendanceType = studentform.findField('attendanceType').getValue();
			 }
		 
			var pbsForm = $this.getDownloadcourselevelattendancepbsform();
			var cbsForm = $this.getDownloadcourselevelattendancecbsform();
			pbsForm.getForm().reset();
			cbsForm.getForm().reset();
			
			pbsForm.down("#batch_ID").setDisabled(true);
			pbsForm.down("#period_ID").setDisabled(true);
			pbsForm.down("#section_ID").setDisabled(true);
			
			cbsForm.down("#componentSectionItemId").setDisabled(true);
			cbsForm.down("#componentSectionItemId").hide();
			cbsForm.down("#courseVariantId").setDisabled(true);
			cbsForm.down("#courseVariantId").hide();
			cbsForm.down("#courseSectionId").setDisabled(true);
			cbsForm.down("#facultyId").setDisabled(true);
			
			if(structure.getForm().getValues().sectionType == 'ProgramBatchSection'){
				cbs.hide();
				pbs.show();
				var programField = pbs.down('#program_ID');
				var programStore =  programField.getStore();
				var facultyId = null;
				if(this.getCurrentLoggedPortalId() == 2){
					facultyId = this.getCurrentlyLoggedInUser().id;
				}
				programStore.getProxy().extraParams = {
					academyLocationIds : this.getCurrentAcademyLocation(),
					facultyId : facultyId
				};
				programStore.load();
			} else {
				pbs.hide();
				cbs.show();
			}		
			
			if(attendanceType != 'COURSE_LEVEL') {
				    pbsForm.down('#downoladBtnId').setDisabled(true);
					pbsForm.down('#program_ID').setDisabled(false);

					cbsForm.down('#downoladBtnId').setDisabled(true);
					cbsForm.down('#allCourseId').setDisabled(false);
		     }else if(attendanceType != 'MULTIPLE_SESSION' || attendanceType != 'COMPLETE_DAY') {
		    	    pbsForm.down('#downoladBtnId').setDisabled(true);
					pbsForm.down('#program_ID').setDisabled(false);

					cbsForm.down('#downoladBtnId').setDisabled(true);
					cbsForm.down('#allCourseId').setDisabled(false);
		     }
		},
		attendanceTypeOfStudent:function(obj,record,valid){
			var $this = this;
			var academyLocationId = this.getCurrentAcademyLocation();
			var form = $this.getStudentattendance();
			var studentForm = this.getStudentattendance().getForm();
			var adhocRequired = "";
			var attendanceSlot="";
			var attendancesearchstrucure =  this.getMarkattendancemasterstructure().getForm();
			attendancesearchstrucure.findField('attendanceType').setValue(record.attendanceTypeWise);
			var attendanceType = record.attendanceTypeWise;
			this.generateQrButtonPrivileges(form,this.getATTENDANCE_ENTRY_PERMISSIONS(),attendanceType);
			form.down('#searchBtn').setDisabled(true);
			form.down('#viewQR').setDisabled(true);
			form.down('#viewQR').setVisible(false);
			var noOfBackDay;
			Ext.Ajax.request({
				type : 'rest',
				async:false,
				url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
				params : {
					academyLocatonId : academyLocationId,
					attendanceType :attendanceType,
				},
				method : 'GET',
				success : function(f, action) {
					var portalId = $this.getCurrentLoggedPortalId();
					if(isNullOrEmpty(f.responseText))
					{
						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
					}else{
						var res = Ext.JSON.decode(f.responseText);
						var data=res[0];
						adhocRequired = data.whetherAdhocRequired;
						attendanceSlot=data.attendanceSlot;
						sessionNumber = data.sessionNo;
						if(portalId==2){
							noOfBackDay=data.backDateAllowedForFaculty
						}else{
							noOfBackDay=data.backDateAllowed;
						}
						var timeTablePlanningFlag=false;
						if(data.attendanceSlot=="TIME_TABLE_SLOTS"){
							timeTablePlanningFlag=true;
						}
						attendancesearchstrucure.findField('sessionPlanningFlag').setValue(timeTablePlanningFlag);
						studentForm.findField('sessionPlanningFlag').setValue(timeTablePlanningFlag);
						studentForm.findField('attendanceType').setValue(data.studentAttendanceType);
						studentForm.findField('facultyConflictCheck').setValue(data.concurrentAttendanceAllowed);
						studentForm.findField('adhocRequired').setValue(adhocRequired);
						studentForm.findField('attendanceSlot').setValue(data.attendanceSlot);
						attendancesearchstrucure.findField('noOfBackDays').setValue(noOfBackDay);
						
						var facultyForm = $this.getFacultyattendance().getForm();
						facultyForm.findField('attendanceType').setValue(data.facultyAttendanceType);

					}
				}
			});
			var alinfomodel = Academia.model.authentication.ALInfoModel;
			var wheatherSchool = alinfomodel.get('wheatherSchool');
			var value = noOfBackDay;
			var date = new Date();
			var minDate = Ext.Date.add(date, Ext.Date.DAY, -value);
			form.down("#dateOfAttendance_Id").setVisible(true);
			form.down("#dateOfAttendance_Id").setValue(date);		
			form.down("#dateOfAttendance_Id").setMinValue(minDate);
			if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
				var this$ = this;
				form.down("#periodIdItemId").setDisabled(true);
				if(wheatherSchool){
					form.down("#periodIdItemId").hide();
					this.setAllowBlank(form.down("#periodIdItemId"),true);
				}else{
					form.down("#periodIdItemId").setVisible(true);
					form.down("#periodIdItemId").clearValue();
					form.down("#periodIdItemId").reset();
					this.setAllowBlank(form.down("#periodIdItemId"),false);
				}
				form.down("#serviceId").setVisible(false);
				form.down("#serviceBatchId").setVisible(false);
				form.down("#serviceCoordinatorId").setVisible(false);
				form.down("#serviceProgramId").setVisible(false);
				form.down("#programBatch_programId").clearValue();
				form.down("#programBatch_programId").reset();
				form.down("#programBatch_programId").setVisible(true);
				
				form.down("#programBatch_batchId").clearValue();
				form.down("#programBatch_batchId").reset();
				form.down("#programBatch_batchId").setVisible(true);
				form.down("#programBatch_batchId").setDisabled(true);
				
				form.down("#programCoursection_ID").clearValue();
				form.down("#programCoursection_ID").reset();
				form.down("#programCoursection_ID").setVisible(true);
				form.down("#programCoursection_ID").setDisabled(true);
				form.down("#programCoursection_ID").allowBlank=false;
				
				form.down("#facutlyId").setVisible(true);
				form.down("#facutlyId").clearValue();
				
				/**
				 * For Complete Day Attendance All below field should be Hide and non mandatory
				 */
				form.down("#academicTerm").setVisible(false);
				form.down("#courseId").setVisible(false);
				form.down("#courseId").clearValue();
				this.setAllowBlank(form.down("#courseId"),true);
				
				
				form.down("#topicId").setVisible(false);
				form.down("#topicId").clearValue();
				form.down("#topicId").allowBlank=true;
				
				form.down("#courseVariantId").setVisible(false);
				form.down("#courseVariantId").clearValue();
				this.setAllowBlank(form.down("#courseVariantId"),true);
				
				
				form.down("#sessionItemId").setVisible(false);
				form.down("#sessionItemId").allowBlank=true;
				form.down("#sessionItemId").clearValue();
				
				form.down("#facutlyListId").setVisible(false);
				form.down("#facutlyListId").allowBlank=true;
				form.down("#facutlyListId").clearValue();
				
				form.down("#timeSlotListId").setVisible(false);
				form.down("#timeSlotListId").clearValue();
				this.setAllowBlank(form.down("#timeSlotListId"),true);
				
				form.down("#timetableSlotListId").setVisible(false);
				form.down("#timetableSlotListId").clearValue();
				this.setAllowBlank(form.down("#timetableSlotListId"),true);
				
				form.down("#timeContainer").setVisible(false);
				form.down("#fromTime").reset();
				form.down("#toTime").reset();
				form.down("#fromTime").allowBlank=true;
				form.down("#toTime").allowBlank=true;
				this.setAllowBlank(form.down("#facutlyListId"),true);
				this.setAllowBlank(form.down("#serviceId"),true);
				this.setAllowBlank(form.down("#serviceBatchId"),true);
				this.setAllowBlank(form.down("#serviceProgramId"),true);
				this.setAllowBlank(form.down("#programBatch_programId"),false);
				this.setAllowBlank(form.down("#programBatch_batchId"),false);
				this.setAllowBlank(form.down("#programCoursection_ID"),false);

				var portalId = this.getCurrentLoggedPortalId();
				var facultyId = null;
				if(portalId == 2){
					facultyId = this.getCurrentlyLoggedInUser().id;
				}
				var programByAcademyLocationStore = this$.getStore('common.ClassTeacherProgramStore');
				programByAcademyLocationStore.getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					facultyId:facultyId
				};
				programByAcademyLocationStore.load();
				var timeContiner = this.getStudentattendance().down('#panelId');
				if(timeContiner.items.length > 1){
					for(var i=1;i<timeContiner.items.length;i++){
						timeContiner.items.items[i].removeAll();
					}
				}
				this.getStudentAttendancegrid().getStore().removeAll();
				this.getStudentattendancecountgrid().getStore().removeAll();
				this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);

			}else if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
				form.down("#serviceId").setVisible(false);
				form.down("#serviceBatchId").setVisible(false);
				form.down("#serviceCoordinatorId").setVisible(false);
				form.down("#serviceProgramId").setVisible(false);
				form.down("#programBatch_programId").clearValue();
				form.down("#programBatch_programId").setVisible(false);
				form.down("#programBatch_programId").allowBlank=true;
				
				form.down("#programBatch_batchId").clearValue();
				form.down("#programBatch_batchId").setVisible(false);
				form.down("#programBatch_batchId").allowBlank=true;
				
				form.down("#periodIdItemId").clearValue();
				form.down("#periodIdItemId").setVisible(false);
				form.down("#periodIdItemId").allowBlank=true;
				
				form.down("#programCoursection_ID").clearValue();
				form.down("#programCoursection_ID").setVisible(false);
				form.down("#programCoursection_ID").allowBlank=true;
				
				form.down("#facutlyId").setVisible(false);
				form.down("#facutlyId").clearValue();
				form.down("#facutlyId").allowBlank=true;
				
				/**
				 * For Complete Day Attendance All above field should be Hide and non mandatory
				 */
				form.down("#academicTerm").setVisible(true);
				form.down("#academicTerm").reset();
				
				form.down("#courseId").setVisible(true);
				form.down("#courseId").clearValue();
				form.down("#courseId").reset();
				this.setAllowBlank(form.down("#courseId"),false);
				
				form.down("#topicId").setVisible(true);
				form.down("#topicId").clearValue();
				$this.setAllowBlank(form.down("#topicId"), true);
				form.down("#topicId").setDisabled(true);
				
				form.down("#courseVariantId").setVisible(true);
				form.down("#courseVariantId").clearValue();
				form.down("#courseVariantId").reset();
				this.setAllowBlank(form.down("#courseVariantId"),false);
				form.down("#courseVariantId").setDisabled(true);
				
				form.down("#sessionItemId").setVisible(false);
				form.down("#sessionItemId").allowBlank=true;
				form.down("#sessionItemId").clearValue();
				
				form.down("#facutlyListId").setVisible(true);
				this.setAllowBlank(form.down("#facutlyListId"),false);
				
				form.down("#facutlyListId").clearValue();
				form.down("#facutlyListId").reset();
				form.down("#facutlyListId").setDisabled(true);
				
				form.down("#fromTime").reset();
				form.down("#toTime").reset();
				this.setAllowBlank(form.down("#timetableSlotListId"),false);
				
				this.setAllowBlank(form.down("#serviceId"),true);
				this.setAllowBlank(form.down("#serviceBatchId"),true);
				this.setAllowBlank(form.down("#serviceProgramId"),true);
				var date = form.down('#dateOfAttendance_Id');

				var dateVal = date.getValue();
				var newDate = null;
				Ext.Ajax.request({
					type : 'rest',
					url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
					method : 'GET',
					async: false,
					success : function(form1, action) {
						data = Ext.JSON.decode(form1.responseText);
						newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
						newDate = new Date(newDate)
						var fromTime = form.down('#fromTime');
						if(dateVal.getDate() == newDate.getDate()){
							var time = moment(newDate).format("HH:mm"); 
							fromTime.setMaxValue(time);
						}
					}});
				if(attendanceSlot=="AD_HOC_SLOTS"){
					form.down("#timeSlotListId").setVisible(false);
					form.down("#timeSlotListId").clearValue();
					form.down("#timeSlotListId").allowBlank=true;
					form.down("#timetableSlotListId").setVisible(false);
					form.down("#timetableSlotListId").clearValue();
					form.down("#timetableSlotListId").allowBlank=true;
					
					form.down("#timeContainer").setVisible(true);
					form.down("#fromTime").allowBlank=false;
					form.down("#toTime").allowBlank=false;
					form.down("#timeBtnAdd").setVisible(true);
					form.down("#timeBtnAdd").setDisabled(true);
					form.down("#dateOfAttendance_Id").allowBlank=false;
					form.down("#dateOfAttendance_Id").setVisible(true);
					
				} else if(attendanceSlot=="TIME_TABLE_SLOTS") {
					form.down("#timeSlotListId").setVisible(false);
					form.down("#timeSlotListId").clearValue();
					form.down("#timeSlotListId").reset();
					form.down("#timeSlotListId").allowBlank=true;
					form.down("#timetableSlotListId").setVisible(true);
					form.down("#timetableSlotListId").clearValue();
					form.down("#timetableSlotListId").allowBlank=false;
					form.down("#timetableSlotListId").setDisabled(true);
					if(adhocRequired){
						form.down("#timeContainer").setVisible(true);
						form.down("#fromTime").allowBlank=false;
						form.down("#toTime").allowBlank=false;
						form.down("#timeBtnAdd").setVisible(true);
						form.down("#timeBtnAdd").setDisabled(true);
						form.down("#dateOfAttendance_Id").allowBlank=false;
						form.down("#dateOfAttendance_Id").setVisible(true);
						form.down('#viewQR').setVisible(true);
					}else{
						form.down("#timeContainer").setVisible(false);
						form.down("#fromTime").allowBlank=true;
						form.down("#toTime").allowBlank=true;
						form.down("#dateOfAttendance_Id").allowBlank=true;
						form.down("#dateOfAttendance_Id").setVisible(false);
						form.down('#viewQR').setVisible(false);
					}
				} else {
					form.down("#timeSlotListId").setVisible(true);
					form.down("#timeSlotListId").clearValue();
					form.down("#timeSlotListId").allowBlank=false;
					form.down("#timeSlotListId").setDisabled(true);
					form.down("#timetableSlotListId").setVisible(false);
					form.down("#timetableSlotListId").clearValue();
					form.down("#timetableSlotListId").allowBlank=true;
					form.down("#timetableSlotListId").setDisabled(true);
					form.down("#dateOfAttendance_Id").allowBlank=false;
					form.down("#dateOfAttendance_Id").setVisible(true);
					if(adhocRequired){
						form.down("#timeContainer").setVisible(true);
						form.down("#fromTime").allowBlank=false;
						form.down("#toTime").allowBlank=false;
						form.down("#timeBtnAdd").setVisible(true);
						form.down("#timeBtnAdd").setDisabled(true);
					}else{
						form.down("#timeContainer").setVisible(false);
						form.down("#fromTime").allowBlank=true;
						form.down("#toTime").allowBlank=true;
					}
				}
				this.getStudentAttendancegrid().getStore().removeAll();
				this.getStudentattendancecountgrid().getStore().removeAll();
				this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
				var academicTermStore = form.down("#academicTerm").getStore();
				academicTermStore.getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					onlyCurrentRecord:true
				};
				academicTermStore.load({
					callback: function(records, operation, success) {
						if (success) {
							if(records.length==1){
								form.down("#academicTerm").setValue(records[0].data.id);
								var courseStore = form.down("#courseId").getStore();
								courseStore.getProxy().extraParams = {
									academyLocationIds:academyLocationId,
									isCurrentPeriod:true,
									academicTermId:records[0].data.id
								};
								courseStore.load();
							} else {
								var courseStore = form.down("#courseId").getStore();
								courseStore.getProxy().extraParams = {
									academyLocationIds:academyLocationId,
									isCurrentPeriod:true
								};
								courseStore.load();
							}
						}
					}
				});
				var panelContiner = this.getStudentattendance().down('#panelId');
				if(panelContiner.items.length > 1){
					for(var i=panelContiner.items.length;i>=1;i--){
						panelContiner.remove(panelContiner.items.items[i]);
					}
				}
			}else if(attendanceType=='Multiple Session' || attendanceType=='MULTIPLE_SESSION'){
				
				var this$ = this;
				form.down("#periodIdItemId").setDisabled(true);
				if(wheatherSchool){
					form.down("#periodIdItemId").hide();
					this.setAllowBlank(form.down("#periodIdItemId"),true);
				}else{
					form.down("#periodIdItemId").setVisible(true);
					form.down("#periodIdItemId").clearValue();
					form.down("#periodIdItemId").reset();
					this.setAllowBlank(form.down("#periodIdItemId"),false);
				}
				form.down("#serviceId").setVisible(false);
				form.down("#serviceBatchId").setVisible(false);
				form.down("#serviceCoordinatorId").setVisible(false);
				form.down("#serviceProgramId").setVisible(false);
				form.down("#programBatch_programId").clearValue();
				form.down("#programBatch_programId").reset();
				form.down("#programBatch_programId").setVisible(true);
				this.setAllowBlank(form.down("#programBatch_programId"),false);
				
				form.down("#programBatch_batchId").clearValue();
				form.down("#programBatch_batchId").reset();
				form.down("#programBatch_batchId").setVisible(true);
				form.down("#programBatch_batchId").setDisabled(true);
				form.down("#programBatch_batchId").allowBlank=false;
				this.setAllowBlank(form.down("#programBatch_batchId"),false);
				
				form.down("#programCoursection_ID").clearValue();
				form.down("#programCoursection_ID").reset();
				form.down("#programCoursection_ID").setVisible(true);
				form.down("#programCoursection_ID").setDisabled(true);
				form.down("#programCoursection_ID").allowBlank=false;
				this.setAllowBlank(form.down("#programCoursection_ID"),false);
				
				form.down("#facutlyId").setVisible(true);
				form.down("#facutlyId").clearValue();
				
				/**
				 * For Complete Day Attendance All below field should be Hide and non mandatory
				 */
				form.down("#academicTerm").setVisible(false);
				form.down("#courseId").setVisible(false);
				form.down("#courseId").clearValue();
				form.down("#courseId").allowBlank=true;
				
				form.down("#topicId").setVisible(false);
				form.down("#topicId").clearValue();
				form.down("#topicId").allowBlank=true;
				
				form.down("#courseVariantId").setVisible(false);
				form.down("#courseVariantId").clearValue();
				form.down("#courseVariantId").allowBlank=true;
				
				form.down("#sessionItemId").setVisible(true);
				form.down("#sessionItemId").allowBlank=false;
				form.down("#sessionItemId").clearValue();
				
				form.down("#facutlyListId").setVisible(false);
				form.down("#facutlyListId").allowBlank=true;
				form.down("#facutlyListId").clearValue();
				
				form.down("#timeSlotListId").setVisible(false);
				form.down("#timeSlotListId").clearValue();
				form.down('#timeSlotListId').allowBlank = true;
				form.down("#timetableSlotListId").setVisible(false);
				form.down("#timetableSlotListId").clearValue();
				form.down('#timetableSlotListId').allowBlank = true;
				form.down("#timeContainer").setVisible(false);
				form.down("#fromTime").reset();
				form.down("#toTime").reset();
				form.down("#fromTime").allowBlank=true;
				form.down("#toTime").allowBlank=true;
				this.setAllowBlank(form.down("#serviceId"),true);
				this.setAllowBlank(form.down("#serviceBatchId"),true);
				this.setAllowBlank(form.down("#serviceProgramId"),true);
				
				var storeArray = [];
				var multipleSessionStore = this.getStore('attendance.MultipleSessionValueStore');
				multipleSessionStore.getProxy().extraParams = {
					type:"multipleSession"
				};
				multipleSessionStore.load({
					callback: function(records, operation, success) {
						if (success) {
							for (s=1;s<=sessionNumber;s++) {
								if(multipleSessionStore.find("code",s)>=0){
									storeArray.push({
										'val':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('value'),
										'code':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('code')
									});
								} else {
									storeArray.push({'val':s,
										'code': s});
								}
							}
						}
						var store1 = Ext.create('Ext.data.Store', {
							fields: ['val','code'],
							data : storeArray
						});
						var l = Ext.ComponentQuery.query('[itemId=sessionItemId]').length-1;
						Ext.ComponentQuery.query('[itemId=sessionItemId]')[l].bindStore(store1);
						if(storeArray.length>0)
						{
							Ext.ComponentQuery.query('[itemId=sessionItemId]')[l].setValue(1);
						}
					}
				});
				this.getStudentAttendancegrid().getStore().removeAll();
				this.getStudentattendancecountgrid().getStore().removeAll();
				this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');
				if(wheatherSchool){
					form.down("#periodIdItemId").hide();
					form.down("#periodIdItemId").allowBlank=true;
				}else{
					form.down("#periodIdItemId").setVisible(true); 
				}
				var portalId = this.getCurrentLoggedPortalId();
				var facultyId = null;
				if(portalId==2){
					facultyId = this.getCurrentlyLoggedInUser().id;
				}
				var programByAcademyLocationStore = this.getStore('common.ClassTeacherProgramStore');
				programByAcademyLocationStore.getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					facultyId:facultyId
				};
				programByAcademyLocationStore.load();

				var panelContiner = this.getStudentattendance().down('#panelId');
				if(panelContiner.items.length > 1){
					for(var i=panelContiner.items.length;i>=1;i--){
						panelContiner.remove(panelContiner.items.items[i]);
					}
				}
			}else if(attendanceType == 'SERVICE_LEVEL' || attendanceType == 'Service Level' ){
				var serviceCombo = form.down("#serviceId");
				batchCombo = form.down("#serviceBatchId");
				serviceProgramCombo = form.down("#serviceProgramId");
				var serviceCoordinatorCombo = form.down("#serviceCoordinatorId");
				form.down("#academicTerm").setVisible(false);
				form.down("#programBatch_programId").setVisible(false);
				form.down("#programBatch_batchId").setVisible(false);
				form.down("#periodIdItemId").setVisible(false);
				form.down("#programCoursection_ID").setVisible(false);
				form.down("#facutlyId").setVisible(false);
				form.down("#sessionItemId").setVisible(false);
				form.down("#courseId").setVisible(false);
				form.down("#courseVariantId").setVisible(false);
				form.down("#facutlyListId").setVisible(false);
				form.down("#timetableSlotListId").setVisible(false);
				form.down("#timeContainer").setVisible(false);
				form.down("#fromTime").allowBlank=true;
				form.down("#toTime").allowBlank=true;
				form.down("#topicId").setVisible(false);
				this.setAllowBlank(form.down("#serviceId"),false);
				this.setAllowBlank(form.down("#serviceBatchId"),false);
				this.setAllowBlank(form.down("#serviceProgramId"),false);
				this.setAllowBlank(form.down("#programBatch_programId"),true);
				this.setAllowBlank(form.down("#programBatch_batchId"),true);
				this.setAllowBlank(form.down("#periodIdItemId"),true);
				this.setAllowBlank(form.down("#programCoursection_ID"),true);
				this.setAllowBlank(form.down("#courseId"),true);
				this.setAllowBlank(form.down("#courseVariantId"),true);
				this.setAllowBlank(form.down("#facutlyListId"),true);
				this.setAllowBlank(form.down("#timetableSlotListId"),true);
				
				
				
				serviceCombo.setVisible(true);
				batchCombo.setVisible(true);
				serviceCoordinatorCombo.setVisible(true);
				//serviceProgramCombo.setVisible(true);
				serviceCombo.reset();
				batchCombo.reset();
				serviceCoordinatorCombo.reset();
				serviceProgramCombo.reset();
				batchCombo.setDisabled(true);
				serviceProgramCombo.setDisabled(true);
				serviceCoordinatorCombo.setDisabled(true);
				var serviceStore = form.down("#serviceId").getStore();
				serviceStore.getProxy().extraParams = {
					academeyLocationId: academyLocationId
				   };
				serviceStore.load();
				form.down("#fromTime").reset();
				form.down("#toTime").reset();
				if(adhocRequired){
					form.down("#timeContainer").setVisible(true);
					form.down("#fromTime").allowBlank=false;
					form.down("#toTime").allowBlank=false;
					form.down("#timeBtnAdd").setVisible(true);
					form.down("#timeBtnAdd").setDisabled(true);
				}
			}
		},
		facultyList:function(attendanceMarkedBy){
			var $this = this;
			var form = this.getStudentattendance().getForm();
			var courseVariant = form.findField('courseVariant');
			var dateField = form.findField('dateOfAttendance');
			var facultyCombo = form.findField('facutlyList');
			var calendarSlotList = form.findField('timeSlotList');
			var timeTableSlotList = form.findField('timetableSlotList');
			var courseVariantId = courseVariant.getValue();
			var attendanceSlot  = form.findField('attendanceSlot').getValue();
			facultyCombo.setDisabled(false);
			calendarSlotList.clearValue();
			timeTableSlotList.clearValue();
			this.getStudentattendance().down("#fromTime").reset();
			this.getStudentattendance().down("#toTime").reset();
			var panelContiner = this.getStudentattendance().down('#panelId');
			if(panelContiner.items.length > 1){
				for(var i=panelContiner.items.length;i>=1;i--){
					panelContiner.remove(panelContiner.items.items[i]);
				}
			}
			var facultyStore =facultyCombo.getStore();
			facultyStore.getProxy().setReader({
				type: 'json',
				root: 'facultyList'
			});
			facultyStore.getProxy().extraParams = {
				courseVariantId:courseVariantId
			};
			facultyStore.load({
				callback: function(records, operation, success) {
					if (success) {
						if(attendanceMarkedBy > 0){
							for(var i in records) {
								if(records[i].data.facultyId == attendanceMarkedBy) {
									facultyCombo.setValue(records[i].data.facultyId);
								}
							}
						} else if(records.length == 1) {
							facultyCombo.setValue(records[0].data.facultyId);
						}
					}
				}
			});
			if(attendanceSlot == 'CALENDAR_SLOTS') {
				dateField.setDisabled(false);
				calendarSlotList.setDisabled(false);
				var valueDate = form.findField('dateOfAttendance').getValue();
				var date = Ext.Date.format(new Date(valueDate), 'Y-m-d'); 
				var calendarId = courseVariant.getStore().findRecord('id',courseVariantId).data.calendarId;
				var store =calendarSlotList.getStore();
				store.getProxy().extraParams = {
					calendarId:calendarId,
					attendanceDate:date
				};
				store.load();
			}
		},
		courseNprogramSection:function(obj, record, timeSlotValues, attendanceMarkedBy, cvId, compId){
			var this$ = this;
			var form = this.getStudentattendance();
			form.down("#courseVariantId").setVisible(true);
			form.down("#courseVariantId").clearValue();
			form.down("#courseVariantId").setDisabled(false);
			
			form.down("#topicId").setVisible(true);
			form.down("#topicId").clearValue();
			form.down("#topicId").setDisabled(false);

			form.down("#facutlyListId").clearValue();
			form.down("#timeSlotListId").clearValue();
			form.down("#timetableSlotListId").clearValue();
			form.down("#facutlyListId").setDisabled(true);
			
			form.down("#fromTime").reset();
			form.down("#toTime").reset();
			var panelContiner = this.getStudentattendance().down('#panelId');
			if(panelContiner.items.length > 1){
				for(var i=panelContiner.items.length;i>=1;i--){
					panelContiner.remove(panelContiner.items.items[i]);
				}
			}

			var academicTermId = form.down("#academicTerm").getValue();
			var academyLocationId=this.getCurrentAcademyLocation();
			var store = form.down("#courseVariantId").getStore();
			store.getProxy().extraParams = {
				courseId: record,
				isCurrentPeriod : true,
				academyLocationIds:academyLocationId,
				academicTermId:academicTermId
			};
			store.load({
				callback: function(records, operation, success) {
					if (success) {
						if(records.length==1){
							form.getForm().findField('courseVariant').setValue(records[0].get('id'));
							form.down("#calendarId").setValue(records[0].data.calendarId);
						}
						if(cvId > 0) {
							for(var i in records){
								if(records[i].get('id') == cvId) {
									var timeSlotField = form.down("#timetableSlotListId");
									timeSlotId = timeSlotValues;
									attendanceMarkedBy = attendanceMarkedBy;
									form.getForm().findField('courseVariant').setValue(records[i].get('id'));
									form.down("#calendarId").setValue(records[i].data.calendarId);
									this$.facultyList(attendanceMarkedBy);
										timeSlotFieldStore = timeSlotField.getStore();
		       	    					timeSlotFieldStore.getProxy().extraParams = {
		       	    						courseVariantId:records[i].get('id'),
		       								facultyId:attendanceMarkedBy,
		       								backDaysAllowed:365
		       			       	    	};
		       	    					timeSlotFieldStore.load({
		       			       	    		callback: function(records, operation, success) {
		       			       	    			if (success) {
		       			       	    				timeSlotField.setDisabled(false);
		       			       	    				setTimeout(function(){
		       			       	    					var tsRecord = timeSlotFieldStore.findRecord('id',timeSlotId);
		       			       	    					var tsId = [tsRecord];
			       			       	    				timeSlotField.setValue(tsId);
			       			       	    				timeSlotField.setValue(tsId);
			       			       	    			    var attendanceSlot  = form.getForm().findField('attendanceSlot').getValue();
			       			       	    			    if(attendanceSlot == 'TIME_TABLE_SLOTS') {
			       			       	    			    	form.down('#dateOfAttendance_Id').setDisabled(true);
			       			       	    			    	form.down('#dateOfAttendance_Id').allowBlank=true;
			       			       	    			    	this$.loadCourseTopics(record);
			       			       	    			    	this$.searchStudentsGrid();
			       			       	    			    } else if(attendanceSlot == 'CALENDAR_SLOTS') {
			       			       	    			    	form.down('#dateOfAttendance_Id').setDisabled(false);
			       			       	    			    	form.down('#dateOfAttendance_Id').allowBlank=false;
			       			       	    			    }
			       			       	    			    form.down('#fromTime').clearValue();
			       			       	    			    form.down('#toTime').clearValue();
			       			       	    			    form.down('#fromTime').setDisabled(true);
			       			       	    			    form.down('#toTime').setDisabled(true);
			       			       	    			    form.down('#fromTime').allowBlank=true;
			       			       	    			    form.down('#toTime').allowBlank=true;
			       			       	    			    form.down('#timeBtnAdd').setDisabled(true);
			       			       	    			    form.isValid();
		       			       	    				},300);
		       			       	    			}
		       			       	    		}
		       	    					});
								}
							}
						}
					}
				}	   
			});
		},
	           changeStatus:function(obj,record){
	        	   var attendanceStatus = record.attendance;
	        	   var grid = this.getStudentAttendancegrid();
	        	   var store = grid.getStore();

	        	   var present=false,absent=false,attStatus=null;
	        	   var prePercent='0%', absPercent='0%';
	        	   var abs=0,pre=0,oth=0;
	        	   this.getStudentattendancegrid().down('#otherStatusId').clearValue();
	        	   this.getStudentattendancegrid().down('#otherStatusId').setVisible(false);
	        	   if (attendanceStatus == 'PRESENT' || attendanceStatus == 'Present') {
	        		   present = true;
	        		   absent = false;
	        		   attStatus = null;
	        		   pre=store.data.length;
	        		   prePercent='100%';
	        	   } else if (attendanceStatus == 'ABSENT' || attendanceStatus == 'Absent') {
	        		   attStatus = null;
	        		   present = false;
	        		   absent = true;
	        		   abs=store.data.length;
	        		   absPercent='100%';
	        	   } else {
	        		   this.getStudentattendancegrid().down('#otherStatusId').setVisible(true);
	        		   var store1 = this.getStore('attendance.AttendanceMarkingTypeStore');
	                	 store1.on('load', function(){
	                			 for(var i=0; i< store1.data.items.length;i++){
		                			 if(store1.data.items[i].data.value == 'Present'){
		                					 store1.removeAt(i);
		                			 } 
		                			 if(store1.data.items[i].data.value == 'Absent'){
		                					 store1.removeAt(i);
		                			 }
		                		 }
	                	});
	        	   }

	        	   store.suspendEvents();   
	        	   store.each(function(rec) {
	        		   rec.set('present', present);
	        		   rec.set('absent', absent);
	        		   rec.set('attendanceStatus', attStatus);
	        	   });
	        	   store.resumeEvents();
	        	   grid.getView().refresh();

	        	   var gridCount = this.getStudentattendancecountgrid();
	        	   var data = {
        			   totalStudent:store.data.length,
        			   totalPresent:pre,
        			   totalAbsent:abs,
        			   otherCount:oth,
        			   presentPercent:prePercent,
        			   absentPercent:absPercent,
	        	   };

            		
	        	   var gridStore =  gridCount.getStore();
	        	   if(store.data.length!=0){
	        		   gridStore.removeAll();
	        		   gridStore.loadRawData(data, true);
	        	   }
	           },
	           changeOtherStatus:function(obj,record){
	        	   var attStatus = obj.getValue();
	        	   var grid = this.getStudentAttendancegrid();
	        	   var store = grid.getStore();

	        	   var prePercent='0%', absPercent='0%';
	        	   var abs=0,pre=0,oth=0;
	        	   if(record[0].data.code == 'PRESENT' || record[0].data.code == 'Present') {
	        		   prePercent = '100%'
	        	   } else if(record[0].data.code == 'ABSENT' || record[0].data.code == 'Absent') {
	        		   absPercent = '100%'
	        	   }
	        	   store.suspendEvents();   
	        	   store.each(function(rec) {
	        		   rec.set('present', false);
	        		   rec.set('absent', false);
	        		   rec.set('attendanceStatus', attStatus);
	        		   rec.set('attendanceMarkingType' ,record[0].data.id);
	        		   rec.set('attendanceMarkStatus' ,record[0].data.code);
	        	   });
	        	   store.resumeEvents();
	        	   grid.getView().refresh();

	        	   var gridCount = this.getStudentattendancecountgrid();
	        	   var data = {
	        			   totalStudent:store.data.length,
	        			   totalPresent:0,
	        			   totalAbsent:0,
	        			   otherCount:store.data.length,
	        			   presentPercent:prePercent,
	        			   absentPercent:absPercent,
	        	   };
	        	   var gridStore =  gridCount.getStore();
	        	   if(store.data.length!=0){
	        		   gridStore.removeAll();
	        		   gridStore.loadRawData(data, true);
	        	   }
	           },
	                   searchStudentsGrid:function(){
	                	   var $this = this;
	                	   // Reset all radio buttons
	                	   var forms = $this.getStudentattendancegrid();
	                	   var radioBts = forms.down('#markOnlyAttendance_Id').items.items;
	                	   for(var i =0; i<radioBts.length;i++){
	                		   radioBts[0].setValue(true);
	                	   }
	                	   // Reset Attendence SummaryGrid
	                	   var gridCount = $this.getStudentattendancecountgrid();
	                	   var gridStore =  gridCount.getStore();
	                	   gridStore.removeAll();
	                	   // End
		        		   var getForm = $this.getStudentattendance();
		        		   getForm.down('#searchBtn').setDisabled(true);
	                	   var form = getForm.getForm();
	                	   var programId = form.findField('programId').getValue();
	                	   var batchId = form.findField('batchId').getValue();
	                	   var periodId = form.findField('periodId').getValue();
	                	   var sectionId = form.findField('sectionId').getValue();
	                	   var facutly = form.findField('facutly').getValue();
	                	   
	                	   var sessionNo = form.findField('sessionNo').getValue();
	                	   var attendanceDate = form.findField('dateOfAttendance').getValue();
	                	   
	                	   var courseId = form.findField('courseId').getValue();
	                	   var courseVariant = form.findField('courseVariant');
	                	   var courseVariantId = form.findField('courseVariant').getValue();
	                	   var facutlyListId = form.findField('facutlyList').getValue();
	                	   //var topicId = form.findField('topicId').getValue();
	                	   
	                	   var timeSlotList = form.findField('timeSlotList').getValue();
	                	   var timeTableSlotList = form.findField('timetableSlotList').getValue();
	                	   var fromTime = form.findField('fromTime').getValue();
	                	   var toTime = form.findField('toTime').getValue();
	                	   
	                	   var formValuesData = form.getValues();
	                	   var attendanceSlot = form.findField('attendanceSlot').getValue();
	                	   var serviceId = form.findField('service').getValue();
	                	   var serviceBatchId = form.findField('serviceBatch').getValue();
	                	   var serviceProgramId = form.findField('serviceprogram').getValue();
	                	   
	                	   var searchedFormData = {
	                			   courseId:courseId,
	                			   attendanceDate:attendanceDate,
	                			   sectionId:sectionId,
	                			   courseVariantId:courseVariantId,
	                			   sessionNo:sessionNo,
	                			   programId:programId,
	       	               	       batchId:batchId,
	       	                	   periodId :periodId,
	       	                	   facutly :facutly,
	       	                	   facutlyListId :facutlyListId,
	                	   };
	                	   
	                	   var courseSectionId =null;
	                	   if(courseVariant.valueModels.length > 0){
	                		   courseSectionId = courseVariant.valueModels[0].get("sectionId");   
	                	   }
		    	           var values = form.getValues();
		    	           var date = Ext.Date.format(new Date(attendanceDate), 'Y-m-d');
	                	   var section;
	                	   if(sectionId !='' && sectionId !=null ){
	                		   section = sectionId;
	                	   }else{
	                		   section =courseSectionId;
	                	   }
	                	   
	                	   var structureForm = this.getMarkattendancemasterstructure().getForm();
	                	   var pncStructure=this.getStudentpncattendancestructure();
	                	   var studentsAttendanceType = pncStructure.down('#attendanceTypeRadio').getValue();
	                	   var attendanceType=studentsAttendanceType.attendanceTypeWise;
	                	   if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
	                		   var fromTime;
	                		   var toTime;
	                		   var timeSlot;
	                		   var timetableSlot;
	                		   if(attendanceSlot == 'TIME_TABLE_SLOTS') {
	                			   timetableSlot = formValuesData.timetableSlotList;
	                		   } else if(attendanceSlot == 'CALENDAR_SLOTS') {
	                			  timeSlot = formValuesData.timeSlotList;
	                		   }
	                		   if (!isNullOrEmpty(timeSlot)) {
	                			   var timeSlots = timeSlot;
	                			   var fromrecord =  new Array();
	                			   var toRecords = new Array();

	                			   for(var i in timeSlots){
	                				   var slots = timeSlots[0].data.value;
	                				   var tokens = slots.split(' - ');
	                				   fromrecord.push(tokens[0]);
	                				   toRecords.push(tokens[1]);
	                			   }
	                			   fromTime  = fromrecord;
	                			   toTime  = toRecords;
	                		   } else if (!isNullOrEmpty(timetableSlot)){
	                			   var timeSlots = timetableSlot[0].data;
	                			   fromTime = timeSlots.fromTime;
	                			   toTime = timeSlots.toTime;
	                			   searchedFormData.attendanceDate = Ext.Date.format(new Date(timeSlots.sessionDate), 'Y-m-d');
	                			   date = Ext.Date.format(new Date(timeSlots.sessionDate), 'Y-m-d');
	                		   }else{
	                			   fromTime = formValuesData.fromTime;
	                			   toTime = formValuesData.toTime;
	                		   }
	                		   var dateTimeList = [];
	                		   if(typeof formValuesData.fromTime=="object"){
			                	   for(var j=0; j<formValuesData.fromTime.length &&  formValuesData.toTime.length; j++){
			                		   dateTimeList.push({
			                			   "fromTime":formValuesData.fromTime[j],
			                			   "toTime": formValuesData.toTime[j]
			                		   });
			                	   }
	                		   }
	                		   else {
	                			   dateTimeList.push({
	                				   "fromTime":formValuesData.fromTime,
		                			   "toTime": formValuesData.toTime
		                		   });
	                		   }
			        			  var timeSlots =[];
			        			  var slotsAttay = [];
			        			  if(timeSlot !="" && timeSlot !=null){
			        				  for(var i in timeSlot){
			        					  if(Ext.isObject(timeSlot[0])){
			        						  timeSlotIds = timeSlot[i].get("id");
			        						  slotsAttay.push(timeSlotIds);
			        					  }else{
			        						  timeSlotIds = timeSlot[i];
			        						  slotsAttay.push(timeSlotIds);
			        					  }
			        				  }
			        			  }
			        			  for(var i =0; i< slotsAttay.length;i++){
			        				  timeSlots.push({
			        					  "timeSlot": slotsAttay[i]
			        				  });
			        			  }
			        			  searchedFormData.timeSlots=timeSlots;
			        			  searchedFormData.dateTimeList=dateTimeList;
	                		   
	
	                		   var store = this.getStudentAttendancegrid().getStore();
	                		   store.getProxy().api.read=SERVERURL.GET_STUDENT_ENROLLED_IN_VARIANT;
	                		   store.getProxy().extraParams = {
	                			   sectionId: section,
	                			   attendanceDate:date,
	                			   courseId:courseId,
	                			   fromTime:fromTime,
	                			   toTime:toTime,
	                			   attendanceType:attendanceType,
	                			   portalId:'1'
		                	   };
	                		   store.load({
		                		   callback: function(records, operation, success) {
		                			   if (success) {
		                				   getForm.down('#searchBtn').setDisabled(false);
		                				   if(records.length > 0){
		                					   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(false);
		                					   if(records[0].data.attendanceMarkStatus != null) {
		                						   showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation("ATTENDANCE_ALREADY_MARKED_CL"));
		                						   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
		                						   $this.getStudentAttendancegrid().getStore().removeAll();
		                					   } else if(records[0].data.isDateAllow != null){
		                						   showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation(records[0].data.isDateAllow));
		                						   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
		                						   $this.loadAttendanceSummary();
			                					   $this.changeStatusOnLoad("PRESENT");
		                					   } else if(records[0].data.isWorkingDay != null){
		                						   showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation(records[0].data.isWorkingDay));
		                						   $this.loadAttendanceSummary();
			                					   $this.changeStatusOnLoad("PRESENT");
		                					   } else {
		                						   $this.loadAttendanceSummary();
			                					   $this.changeStatusOnLoad("PRESENT");
		                					   }
		                				   }else{
		                					   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
		                				   }
		                			   }
		                		   }	   
		                	   });

	                	   }else if(attendanceType == 'Service Level' || attendanceType == 'SERVICE_LEVEL'){
	                		  
	                		   var store = this.getStudentAttendancegrid().getStore();
	                		   store.getProxy().api.read=SERVERURL.PATH_GET_STUDENT_LIST_FOR_SERVICE_ATTENDANCE;
	                		   
	                		   if(serviceBatchId && typeof serviceBatchId == "object" && serviceBatchId.length && !isNullOrEmpty(serviceBatchId[0])){
	                			   if(typeof serviceBatchId[0] == "object"){
	                				   var batchIds = Ext.Array.pluck(Ext.Array.pluck(serviceBatchId,'data'),'id').join();
	                			   }
	                			   else{
	                				   var batchIds = serviceBatchId.join();
	                			   }
	                		   }
	                		   else{
	                			   var batchIds = serviceBatchId;
	                		   }
	                		   
	                		   store.getProxy().extraParams = {
	                			   date:date,
	                			   portalId:'1',
	                			   serviceId:serviceId,
	                			   batchIds:batchIds,
	                			   attendanceType:attendanceType,
	                			   programId : serviceProgramId
		                	   };
	                		   store.load({
		                		   callback: function(records, operation, success) {
		                			   if (success) {
		                				   getForm.down('#searchBtn').setDisabled(false);
		                				   if(records.length > 0){
		                					   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(false);
		                					   if(records[0].data.attendanceMarkStatus != null) {
		                						   showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation('DUPLICATE_ATTENDANCE'));
		                						   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
		                						   $this.getStudentAttendancegrid().getStore().removeAll();
		                					   } else if(records[0].data.isDateAllow != null){
		                						   showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation(records[0].data.isDateAllow));
		                						   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
		                						   $this.loadAttendanceSummary();
			                					   $this.changeStatusOnLoad("PRESENT");
		                					   } else if(records[0].data.isWorkingDay != null){
		                						   showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation(records[0].data.isWorkingDay));
		                						   $this.loadAttendanceSummary();
			                					   $this.changeStatusOnLoad("PRESENT");
		                					   } else {
		                						   $this.loadAttendanceSummary();
			                					   $this.changeStatusOnLoad("PRESENT");
		                					   }
		                				   }else{
		                					   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
		                				   }
		                			   }
		                		   }	   
		                	   });

	                	   
	                		   
	                	   }else{
	                		   var store = this.getStudentAttendancegrid().getStore();
	                		   store.getProxy().api.read=SERVERURL.GET_STUDENT_LIST_BY_SECTION_ID;
	                		   store.getProxy().extraParams = {
	                			   sectionId: section,
	                			   date:date,
	                			   sessionNo:sessionNo,
	                			   attendanceType:attendanceType,
	                			   portalId:'1'
		                	   };
	                		   store.load({
		                		   callback: function(records, operation, success) {
		                			   if (success) {
		                				   getForm.down('#searchBtn').setDisabled(false);
		                				   if(records.length > 0){
		                					   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(false);
		                					   if(records[0].data.attendanceMarkStatus != null) {
		                						   if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY')
		                						   { showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation("ATTENDANCE_ALREADY_MARKED_CD"));   
		                						   }
		                						   else
		                						   {showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation("ATTENDANCE_ALREADY_MARKED_SELECTEDT_SESSION_DATE"));
		                						   }
		                						   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
		                						   $this.getStudentAttendancegrid().getStore().removeAll();
		                					   } else if(records[0].data.isDateAllow != null){
		                						   showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation(records[0].data.isDateAllow));
		                						   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
		                						   $this.changeStatusOnLoad("PRESENT");
		                						   $this.loadAttendanceSummary();
		                					   } else if(records[0].data.isWorkingDay != null){
		                						   showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation(records[0].data.isWorkingDay));
		                						   $this.changeStatusOnLoad("PRESENT");
		                						   $this.loadAttendanceSummary();
		                					   } else {
		                						   $this.loadAttendanceSummary();
			                					   $this.changeStatusOnLoad("PRESENT");
		                					   }
		                				   }else{
		                					   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
		                				   }
		                			   }
		                		   }	   
		                	   });
	                	   }
	                	   forms.searchedFormData = searchedFormData;
		                	var store = $this.getStore('attendance.AttendanceMarkingTypeStore');
		                	 store.on('load', function(){
		                			 for(var i=0; i< store.data.items.length;i++){
			                			 if(store.data.items[i].data.value == 'Present'){
			                					 store.removeAt(i);
			                			 } 
			                			 if(store.data.items[i].data.value == 'Absent'){
			                					 store.removeAt(i);
			                			 }
			                		 }
		                	});
	                   },
	                   studentFacultyChange : function(cb, nv, ov, attendance){
	                	   var $this = this;
	                	   var facultyForm = $this.getFacultyattendance().getForm();
	                	   var studentForm = $this.getStudentattendance().getForm();
	                	   
	                	   if((!isNullOrEmpty(nv) && nv.attendance == 'forStudent') || attendance == 'student'){
	                		   Ext.ComponentQuery.query('studentpncattendancestructure#studentattendanceId')[0].show();
	                		   Ext.ComponentQuery.query('facultypncattendancestructure#facultyattendanceId')[0].hide();
	                		   Ext.ComponentQuery.query('otheremployeandadminattendancestructure#otheremployeandadminattendanceId')[0].hide();
	                		   
	                		   studentForm.findField("programId").clearValue();
	                		   studentForm.findField("batchId").clearValue();
	                		   studentForm.findField("periodId").clearValue();
	                		   studentForm.findField("courseId").clearValue();
	                		   studentForm.findField("componentId").clearValue();
//	                		   studentForm.findField("courseSectionId").clearValue();
	                		   studentForm.findField("courseVariant").clearValue();
	                		   studentForm.findField("courseProgramId").clearValue();
	                		   studentForm.findField("programBatchCourse").clearValue();
	                		   studentForm.findField("programBatchPeriod").clearValue();
	                		   studentForm.findField("sectionId").clearValue();
	                		   studentForm.findField("facutlyList").clearValue();
	                		   studentForm.findField("facutlyList").clearValue();
	                		   studentForm.findField("facutly").clearValue();
	                		   
	                		   
	                		   $this.getFacultyattendancegrid().getStore().removeAll();
	                		   $this.getFacultygridcompletenmultiplesession().getStore().removeAll();
	                		   $this.getAdmingridforsession().getStore().removeAll();
	                	   }else if((!isNullOrEmpty(nv) && nv.attendance == 'forFaculty') || attendance == 'Faculty'){
	                		   Ext.ComponentQuery.query('studentpncattendancestructure#studentattendanceId')[0].hide();
	                		   Ext.ComponentQuery.query('otheremployeandadminattendancestructure#otheremployeandadminattendanceId')[0].hide();
	                		   Ext.ComponentQuery.query('facultypncattendancestructure#facultyattendanceId')[0].show();
	                		   
	                		   facultyForm.findField("courseId").clearValue();
	                		   facultyForm.findField("componentId").clearValue();
	                		   facultyForm.findField("courseVariant").clearValue();
	                		   facultyForm.findField("courseProgramId").clearValue();
	                		   facultyForm.findField("programBatchCourse").clearValue();
	                		   facultyForm.findField("programBatchPeriod").clearValue();
	                		   facultyForm.findField("sectionId").clearValue();
	              
	                		   $this.getStudentAttendancegrid().getStore().removeAll();
	                		   this.getStudentattendancecountgrid().getStore().removeAll();
	                		   $this.getAdmingridforsession().getStore().removeAll();
	                		   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
	                		   
	                	   } else {
	                		   Ext.ComponentQuery.query('studentpncattendancestructure#studentattendanceId')[0].hide();
	                		   Ext.ComponentQuery.query('facultypncattendancestructure#facultyattendanceId')[0].hide();
	                		   Ext.ComponentQuery.query('otheremployeandadminattendancestructure#otheremployeandadminattendanceId')[0].show();
	                		   
	                		   facultyForm.findField("courseId").clearValue();
	                		   facultyForm.findField("componentId").clearValue();
//	                		   facultyForm.findField("courseSectionId").clearValue();
	                		   facultyForm.findField("courseVariant").clearValue();
	                		   facultyForm.findField("courseProgramId").clearValue();
	                		   facultyForm.findField("programBatchCourse").clearValue();
	                		   facultyForm.findField("programBatchPeriod").clearValue();
	                		   facultyForm.findField("sectionId").clearValue();
	              
	                		   studentForm.findField("programId").clearValue();
	                		   studentForm.findField("batchId").clearValue();
	                		   studentForm.findField("periodId").clearValue();
	                		   studentForm.findField("courseId").clearValue();
	                		   studentForm.findField("componentId").clearValue();
//	                		   studentForm.findField("courseSectionId").clearValue();
	                		   studentForm.findField("courseVariant").clearValue();
	                		   studentForm.findField("courseProgramId").clearValue();
	                		   studentForm.findField("programBatchCourse").clearValue();
	                		   studentForm.findField("programBatchPeriod").clearValue();
	                		   studentForm.findField("sectionId").clearValue();
	                		   studentForm.findField("facutlyList").clearValue();
	                		   studentForm.findField("facutlyList").clearValue();
	                		   studentForm.findField("facutly").clearValue();
	                		   
	                		   $this.getStudentAttendancegrid().getStore().removeAll();
	                		   this.getStudentattendancecountgrid().getStore().removeAll();
	                		   $this.getFacultyattendancegrid().getStore().removeAll();
	                		   $this.getFacultygridcompletenmultiplesession().getStore().removeAll();
	                		   $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
	                	   }
	                   },
	             programBatchFacultyChange:function(cb, nv, ov){
	        	  if(nv.faculty == 'programBatch'){
	        		  Ext.ComponentQuery.query('fieldcontainer#programBatchFieldId')[0].show();
	        	  }else{
	        		  Ext.ComponentQuery.query('fieldcontainer#programBatchFieldId')[0].hide();
	        	  }
	          },
	          /**
        	   * This function is used for save student attendance course level and multiple session and complete day.    
        	   */
	          saveStudentAttendance:function(btn){
	        	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        	  var $this = this;
	        	  var form = $this.getStudentattendance().getForm();
	        	  var formValues = form.getValues();
	        	  var grid = $this.getStudentattendancegrid();
	        	  var values = grid.searchedFormData;
	        	  var academyLocationId = this.getCurrentAcademyLocation();
	        	  var studentAttendance =new Academia.model.attendance.StudentAttendance();
	        	  
	        	  var timeContiner = this.getStudentattendance().down('#panelId');
	        	  var timeFieldsCount = timeContiner.items.length;
	        	  /**
	        	   * save course level attendance for student. 
	        	   */
	        	  var attendancesearchstrucure =  $this.getMarkattendancemasterstructure().getForm();
				   //var attendanceType = attendancesearchstrucure.findField('attendanceType').getValue();
	        	  var pncStructure=this.getStudentpncattendancestructure();
           	      var studentsAttendanceType = pncStructure.down('#attendanceTypeRadio').getValue();
           	      var attendanceType=studentsAttendanceType.attendanceTypeWise;
	        	  
           	      if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
           	    	  var facutlyListId = values.facutlyListId;
           	    	  var courseVariantId = $this.getStudentattendance().down('#courseVariantId').getValue();
           	    	  var courseValues = $this.getStudentattendance().down('#courseVariantId').getStore().findRecord('id', courseVariantId).data;
           	    	  var sectionIds = courseValues.sectionId;
           	    	  var courseId = courseValues.courseId;
           	    	  var topicId = formValues.topicId;
           	    	  if(!isNullOrEmpty(courseValues.parentCourseId)) {
           	    		  courseId = courseValues.parentCourseId;
           	    	  }
           	    	  var courseComponentId = courseValues.courseComponentId;
           	    	  var facultyConflictCheck = form.findField('facultyConflictCheck').getValue();

           	    	  var store = $this.getStudentAttendancegrid().getStore();
           	    	  var models = store.getRange();
           	    	  var studentCourseAttendanceDetails =[]; 
           	    	  for(var i=0;i<store.data.length;i++){
           	    		  if(!store.data.items[i].data.attendanceStatus){
           	    			  if(models[i].data.present){
           	    				  studentCourseAttendanceDetails.push({
           	    					  "admissionId":store.data.items[i].data.admissionId,
           	    					  "attendanceStatus": 'PRESENT',
           	    					  "attendanceComment" : store.data.items[i].data.comment,
           	    					  "attendanceMarkingType" : this.getIdValueJson(1)
           	    				  }); 
           	    			  }else{
           	    				  studentCourseAttendanceDetails.push({
           	    					  "admissionId":store.data.items[i].data.admissionId,
           	    					  "attendanceStatus": 'ABSENT',
           	    					  "attendanceComment" : store.data.items[i].data.comment,
           	    					  "attendanceMarkingType" : this.getIdValueJson(2)
           	    				  });
           	    			  }
           	    		  } else if(!isNullOrEmpty(store.data.items[i].data.markingType) && !(store.data.items[i].data.markingType=="OTHER")){
           	    			  if(models[i].data.present){
           	    				  studentCourseAttendanceDetails.push({
           	    					  "admissionId":store.data.items[i].data.admissionId,
           	    					  "attendanceStatus": 'PRESENT',
           	    					  "attendanceComment" : store.data.items[i].data.comment,
           	    					  "attendanceMarkingType" : this.getIdValueJson(1)
           	    				  }); 
           	    			  }else{
           	    				  studentCourseAttendanceDetails.push({
           	    					  "admissionId":store.data.items[i].data.admissionId,
           	    					  "attendanceStatus": 'ABSENT',
           	    					  "attendanceComment" : store.data.items[i].data.comment,
           	    					  "attendanceMarkingType" : this.getIdValueJson(2)
           	    				  });
           	    			  }
           	    		  } else{
							if (isNullOrEmpty(store.data.items[i].data.attendanceMarkStatus)) {
							      var attendanceStatus = store.data.items[i].data.attendanceStatus;
							      var attendanceMarkStatus;
							      var attendanceMarkingType;

							      Ext.Ajax.request({
							          type: 'rest',
							          async: false,
							          url: SERVERURL.STUDENT_ATTENDANCE_MARKING_TYPE,
							          method: 'GET',
							          success: function (res, action) {
							              var records = Ext.decode(res.responseText);
							              if (Object.keys(records).length > 0) {
							                  for (var i in records) {
							                      if (records[i].value == attendanceStatus) {
							                          attendanceMarkStatus = records[i].code;
							                          attendanceMarkingType = records[i].id;
							                      }
							                  }
							              }
							          }
							      });

							      studentCourseAttendanceDetails.push({
							          "admissionId": store.data.items[i].data.admissionId,
							          "attendanceStatus": attendanceMarkStatus,
							          "attendanceComment": store.data.items[i].data.comment,
							          "attendanceMarkingType": this.getIdValueJson(attendanceMarkingType)
							      });

							  } else {
							      studentCourseAttendanceDetails.push({
							          "admissionId": store.data.items[i].data.admissionId,
							          "attendanceStatus": store.data.items[i].data.attendanceMarkStatus,
							          "attendanceComment": store.data.items[i].data.comment,
							          "attendanceMarkingType": this.getIdValueJson(store.data.items[i].data.attendanceMarkingType)
							      });
							  }
}
           	    	  }
           	    	  var sessionPlanningDone=false;
           	    	  if(formValues.attendanceSlot=="TIME_TABLE_SLOTS"){
           	    		  sessionPlanningDone=true;
           	    	  }
           	    	  var studentCourseAttendances =[]; 
           	    	  if(!isNullOrEmpty(values.timeSlots) && values.timeSlots.length > 0) {
           	    		  for(var i in values.timeSlots) {
           	    			  var timeSlots =[]; 
           	    			  var studentCourseAttendance = new Academia.model.attendance.StudentCourseAttendance();
           	    			  studentCourseAttendance.set("courseId",courseId);
           	    			  studentCourseAttendance.set("sectionId",sectionIds);
           	    			  studentCourseAttendance.set("courseVariantId",courseVariantId);
           	    			  studentCourseAttendance.set("dateOfAttendance",values.attendanceDate);
           	    			  studentCourseAttendance.set("academyLocationId",academyLocationId);
           	    			  timeSlots = values.timeSlots[i].timeSlot.split(" - ");
           	    			  studentCourseAttendance.set("slotFrom",timeSlots[0]);
           	    			  studentCourseAttendance.set("slotTo",timeSlots[1]);
           	    			  studentCourseAttendance.set("facultyId",facutlyListId);
           	    			  studentCourseAttendance.set("attendanceMarkedBy",$this.getCurrentlyLoggedInUser().id);
           	    			  if(courseComponentId!="" && courseComponentId!= null){
           	    				  studentCourseAttendance.set("componentId",courseComponentId);
           	    			  }
           	    			  studentCourseAttendance.set("sessionPlanningDone", sessionPlanningDone);
           	    			  studentCourseAttendance.set("facultyConflictCheck", facultyConflictCheck);
           	    			  studentCourseAttendance.set("adhocSlot", false);
           	    			  studentCourseAttendance.set("isMobile",false);
           	    			  studentCourseAttendance.set("studentCourseAttendanceDetails",studentCourseAttendanceDetails);
           	    			 var topicId = $this.getStudentattendance().down('#topicId').getValue();
      			        	var topicIds = [];
      			        	if(topicId !=undefined && topicId.length > 0){
      	                		 for(var i in topicId){
      	                			 if(Ext.isObject(topicId[i])){
      	                				 topicIds.push({
                	    					  "courseTopic":$this.getIdValueJson(topicId[i].get("id"))
                	    				  })
      	                			 }else{
      	                				 topicIds.push({
      	                					"courseTopic":$this.getIdValueJson(topicId[i])
      	                				 });
      	                			 }
      	                		 }
      	                		 studentCourseAttendance.set("studentCourseAttendanceTopics", topicIds);
      	                	 }
           	    			 studentCourseAttendances.push(studentCourseAttendance.data);
           	    		  }
           	    	  } else if(!isNullOrEmpty(formValues.timetableSlotList) && formValues.timetableSlotList.length > 0){
           	    		for(var i in formValues.timetableSlotList) {
           	    			var timeSlotStore = $this.getStudentattendance().down('#timetableSlotListId').getStore();
							var data = timeSlotStore.findRecord('id', formValues.timetableSlotList[i].data.id).data;
							var date = new Date(Number(data.sessionDate));
							var attendanceDate = Ext.Date.format(new window.Date(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate()), "Y-m-d");
							var fromTime = data.fromTime;
							var toTime =  data.toTime;
     	    			  var studentCourseAttendance = new Academia.model.attendance.StudentCourseAttendance();
     	    			  studentCourseAttendance.set("courseId",courseId);
     	    			  studentCourseAttendance.set("sectionId",sectionIds);
     	    			  studentCourseAttendance.set("courseVariantId",courseVariantId);
     	    			  studentCourseAttendance.set("dateOfAttendance",attendanceDate);
     	    			  studentCourseAttendance.set("academyLocationId",academyLocationId);
     	    			  studentCourseAttendance.set("slotFrom",fromTime);
     	    			  studentCourseAttendance.set("slotTo",toTime);
     	    			  studentCourseAttendance.set("facultyId",facutlyListId);
     	    			  studentCourseAttendance.set("attendanceMarkedBy",$this.getCurrentlyLoggedInUser().id);
     	    			  if(courseComponentId!="" && courseComponentId!= null){
     	    				  studentCourseAttendance.set("componentId",courseComponentId);
     	    			  }
     	    			  studentCourseAttendance.set("sessionPlanningDone", sessionPlanningDone);
     	    			  studentCourseAttendance.set("facultyConflictCheck", facultyConflictCheck);
     	    			  studentCourseAttendance.set("adhocSlot", false);
     	    			  studentCourseAttendance.set("isMobile",false);
     	    			  studentCourseAttendance.set("studentCourseAttendanceDetails",studentCourseAttendanceDetails);
     	    			 var topicId = $this.getStudentattendance().down('#topicId').getValue();
 			        	var topicIds = [];
 			        	if(topicId !=undefined && topicId.length > 0){
 	                		 for(var i in topicId){
 	                			 if(Ext.isObject(topicId[i])){
 	                				 topicIds.push({
           	    					  "courseTopic":$this.getIdValueJson(topicId[i].get("id"))
           	    				  })
 	                			 }else{
 	                				 topicIds.push({
 	                					"courseTopic":$this.getIdValueJson(topicId[i])
 	                				 });
 	                			 }
 	                		 }
 	                		 studentCourseAttendance.set("studentCourseAttendanceTopics", topicIds);
 	                	 }
     	    			  studentCourseAttendances.push(studentCourseAttendance.data);
           	    	  }
           	    	  } else if(!isNullOrEmpty(values.dateTimeList) && values.dateTimeList.length > 0) {
           	    		  for(var i in values.dateTimeList) {
           	    			  var studentCourseAttendance = new Academia.model.attendance.StudentCourseAttendance();
           	    			  studentCourseAttendance.set("courseId",courseId);
           	    			  studentCourseAttendance.set("sectionId",sectionIds);
           	    			  studentCourseAttendance.set("courseVariantId",courseVariantId);
           	    			  studentCourseAttendance.set("dateOfAttendance",Ext.Date.format(new Date(values.attendanceDate), CONSTANTS.NEW_SUBMIT_DATE_FORMAT));
           	    			  studentCourseAttendance.set("academyLocationId",academyLocationId);
           	    			  studentCourseAttendance.set("slotFrom",values.dateTimeList[i].fromTime);
           	    			  studentCourseAttendance.set("slotTo",values.dateTimeList[i].toTime);
           	    			  studentCourseAttendance.set("facultyId",facutlyListId);
           	    			  studentCourseAttendance.set("attendanceMarkedBy",$this.getCurrentlyLoggedInUser().id);
           	    			  if(courseComponentId!="" && courseComponentId!= null){
           	    				  studentCourseAttendance.set("componentId",courseComponentId);
           	    			  }
           	    			  studentCourseAttendance.set("sessionPlanningDone", sessionPlanningDone);
           	    			  studentCourseAttendance.set("facultyConflictCheck", facultyConflictCheck);
           	    			  studentCourseAttendance.set("adhocSlot", true);
           	    			  studentCourseAttendance.set("isMobile",false);
           	    			  studentCourseAttendance.set("studentCourseAttendanceDetails",studentCourseAttendanceDetails);
           	    			 var topicId = $this.getStudentattendance().down('#topicId').getValue();
      			        	var topicIds = [];
      			        	if(topicId !=undefined && topicId.length > 0){
      	                		 for(var i in topicId){
      	                			 if(Ext.isObject(topicId[i])){
      	                				 topicIds.push({
                	    					  "courseTopic":$this.getIdValueJson(topicId[i].get("id"))
                	    				  })
      	                			 }else{
      	                				 topicIds.push({
      	                					"courseTopic":$this.getIdValueJson(topicId[i])
      	                				 });
      	                			 }
      	                		 }
      	                		 studentCourseAttendance.set("studentCourseAttendanceTopics", topicIds);
      	                	 }
           	    			  studentCourseAttendances.push(studentCourseAttendance.data);
           	    		  }
           	    	  }
           	    	  var submitUrl;
           	    	  if (form.findField('id').getSubmitValue() == null
           	    			  || form.findField('id' ).getSubmitValue() == "") {
           	    		  submitUrl = SERVERURL.CREATE_STUDENT_COURSE_ATTENDANCE;
           	    	  } 
           	    	  var formData = Ext.encode(studentCourseAttendances);
           	    	  Ext.Ajax.request({
           	    		  type : 'rest',
           	    		  url : submitUrl,
           	    		  jsonData : formData,
           	    		  method : 'POST',
           	    		  success : function(form, action) {
           	    			  Ext.getBody().unmask();
           	    			  var msg = form.responseText;
           	    			  if(!isNullOrEmpty(msg) && msg =='DUPLICATE_ATTENDANCE'){
           	    				  showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('ATTENDANCE_ALREADY_MARKED_DATE_TIME_SLOT'));
           	    			  } else if(!isNullOrEmpty(msg) && msg =='NO_SESSION') {
           	    				  showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('NO_SESSION_FOUND'));
           	    			  } else if(!isNullOrEmpty(msg) && msg =='MULTIPLE_SESSION_FOUND'){
           	    				  showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('MULTIPLE_SESSION_FOUND'));
           	    			  } else if(!isNullOrEmpty(msg) && msg =='FROM_TIME_NULL'){
           	    				  showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('FROM_TIME_NULL'));
           	    			  } 
           	    			  else if(msg!='' && msg=='SUCCESS'){
           	    				  var gridCount = Ext.getCmp('studentAttendancecountGridId');
           	    				  var models = gridCount.getStore().getRange();
           	    				  models[0].set('totalStudent',0);
           	    				  models[0].set('totalPresent',0);
           	    				  models[0].set('totalAbsent',0);
           	    				  models[0].set('otherCount',0);
           	    				  models[0].set('presentPercent','0%');
           	    				  models[0].set('absentPercent','0%');
           	    				  showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
           	    				  $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
           	    				  $this.cancelStudentAttendance();
           	    			  }else{
           	    			  }	       			  
           	    		  }
           	    	  });

           	      }else if(attendanceType == 'Service Level' || attendanceType == 'SERVICE_LEVEL'){
            		  var typeOfAttendanc;
            		  var studentServiceAttendanceArray = [];
            		  if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
            			  typeOfAttendanc = 'COMPLETE_DAY';
            		  }else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
            			  typeOfAttendanc = 'MULTIPLE_SESSION';
            		  }else if(attendanceType == 'COURSE_LEVEL' || attendanceType == 'Course Level'){
            			  typeOfAttendanc = 'COURSE_LEVEL';
            		  }else if(attendanceType == 'SERVICE_LEVEL' || attendanceType == 'Service Level'){
            			  typeOfAttendanc = 'SERVICE_LEVEL';
            		  }
            		  var store = $this.getStudentAttendancegrid().getStore();
            		  var serviceCoordinator = formValues.serviceCoordinatorName;
            		  if(typeof formValues.fromTime != "object"){
        				  var fromTimeArray = [formValues.fromTime];
        				  var toTimeArray = [formValues.toTime];
        			  }
        			  else{
        				  var fromTimeArray = formValues.fromTime;
        				  var toTimeArray = formValues.toTime;
        			  }
            		  var wsStdServiceAttendanceCordinatorDtls=[];
            		  var studentServiceAttendance;
            		  if(serviceCoordinator !=undefined && serviceCoordinator.length > 0){
 		        		 for(var i in serviceCoordinator){
 		        			 var coordinator;
 		        			 if(Ext.isObject(serviceCoordinator[i])){
 		        				coordinator={id:serviceCoordinator[i].get("coordinatorId")}
 		        				wsStdServiceAttendanceCordinatorDtls.push({
 		        					coordinator:coordinator
 		        				});
 		   
 		        			 }else{
 		        				coordinator={id:serviceCoordinator[i]}
 		        				wsStdServiceAttendanceCordinatorDtls.push({
 		        					coordinator:coordinator
 		        				});
 		        			 }
 		        		 }
 		        	 }
            		  
    	        	  for(var i=0;i<store.data.length;i++){
    	           	    	var studentServiceAttendance =new Academia.model.attendance.StudentServiceAttendance();
    	        		  studentServiceAttendance.set("programId",store.data.items[i].data.programId);
                		  studentServiceAttendance.set("serviceId",formValues.service);
                		  studentServiceAttendance.set("batchId", store.data.items[i].raw.batchId);
                		  studentServiceAttendance.set("dateOfAttendance",values.attendanceDate);
                		  studentServiceAttendance.set("attendanceType",typeOfAttendanc);
                		  studentServiceAttendance.set("academyLocationId",academyLocationId);
        	        	  studentServiceAttendance.set("id", store.data.items[i].data.attendanceId);
        	        	  var studentServiceAttendanceDetails =[]; 
        	        	  var models = store.getRange();
    	        		  if(!store.data.items[i].data.attendanceStatus){
    	        			  if(models[i].data.present){
    	        				  studentServiceAttendanceDetails.push({
    		        				  "admissionId":store.data.items[i].data.admissionId,
    		        				  "seatConfigId":store.data.items[i].data.seatConfigId,
    		        				  "attendanceStatus": 'PRESENT',
    		        				  "attendanceId":store.data.items[i].data.attendanceId,
    		        				  "id":store.data.items[i].data.id,
    		        				  "attendanceComment" : store.data.items[i].data.comment,
    		        				  "attendanceMarkingType" : this.getIdValueJson(1)
    		        			  }); 
    	        			  }else{
    	        				  studentServiceAttendanceDetails.push({
    		        				  "admissionId":store.data.items[i].data.admissionId,
    		        				  "seatConfigId":store.data.items[i].data.seatConfigId,
    		        				  "attendanceStatus": 'ABSENT',
    		        				  "attendanceId":store.data.items[i].data.attendanceId,
    		        				  "id":store.data.items[i].data.id,
    		        				  "attendanceComment" : store.data.items[i].data.comment,
    		        				  "attendanceMarkingType" : this.getIdValueJson(2)
    		        			  }); 
    	        			  }
    	        		  }else{
    	        			  var attendanceTest = store.data.items[i].data.attendanceStatus;
    	        			  studentServiceAttendanceDetails.push({
    	        				  "admissionId":store.data.items[i].data.admissionId,
    	        				  "seatConfigId":store.data.items[i].data.seatConfigId,
    	        				  "attendanceStatus":store.data.items[i].data.attendanceMarkStatus,
    	        				  "attendanceId":store.data.items[i].data.attendanceId,
    	        				  "id":store.data.items[i].data.id,
    	        				  "attendanceComment" : store.data.items[i].data.comment,
    	        				  "attendanceMarkingType" : this.getIdValueJson(store.data.items[i].data.attendanceMarkingType)
    	        			  });
    	        		  }
        	        	  studentServiceAttendance.set("studentServiceAttendanceDetails",studentServiceAttendanceDetails);
        	        	  studentServiceAttendance.set("studentServiceAttendanceCoordinatorDtls",wsStdServiceAttendanceCordinatorDtls);        	        	  
        	        	  studentServiceAttendanceArray.push(studentServiceAttendance.data);
    	        	  }
    	        	  
    	        	  var allBatchIdsArray = Ext.Array.pluck(studentServiceAttendanceArray, 'batchId');
    	        	  var alreadyPushedBatchIds = [];
    	        	  var finalData = [];
    	        	  
    	        	  Ext.each(studentServiceAttendanceArray, function(currentStudentServiceAttendance){
    	        		  if(alreadyPushedBatchIds.length == 0){
    	        			  finalData.push(currentStudentServiceAttendance);
    	        			  alreadyPushedBatchIds.push(currentStudentServiceAttendance.batchId);
    	        		  }
    	        		  else{
    	        			  var foundIdx = alreadyPushedBatchIds.indexOf(currentStudentServiceAttendance.batchId);
    	        			  
    	        			  if(foundIdx == -1){
    	        				  finalData.push(currentStudentServiceAttendance);
        	        			  alreadyPushedBatchIds.push(currentStudentServiceAttendance.batchId);
    	        			  }
    	        			  else{
    	        				  finalData[foundIdx]['studentServiceAttendanceDetails'].push(currentStudentServiceAttendance.studentServiceAttendanceDetails[0]);
    	        			  }
    	        		  }
    	        	  });

    	        	  if(formValues.adhocRequired=="true"){
    	        		  var tempFinalArray = [];
    	        		  for (var i = 0; i < toTimeArray.length; i++) {
    	        		      for (var j = 0; j < finalData.length; j++) {
    	        		          var tempFinal = Object.assign({}, finalData[j]); // Clone the object
    	        		          var fromTime = fromTimeArray[i];
    	        		          var toTime = toTimeArray[i];
    	        		          tempFinal["fromTime"] = fromTime;
    	        		          tempFinal["toTime"] = toTime;
    	        		          tempFinalArray.push(tempFinal);
    	        		      }
    	        		  }
    	        		  finalData=[];
    	        		  finalData=tempFinalArray;
    	        	  }

    	        	  var submitUrl;
    	        	  if (form.findField('id').getSubmitValue() == null
    	        			  || form.findField('id' ).getSubmitValue() == "") {
    	        		  submitUrl = SERVERURL.SAVE_STUDENT_SERVICE_WISE_ATTENDANCE;
    	        	  } else {
    	        		  //courseReading.set("id", values.id);
    	        		  //submitUrl = SERVERURL.;
    	        	  }
    	        	  var formData = Ext.encode(finalData);
    	        	  //Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	        	  
    	        	  Ext.Ajax.request({
    	        		  type : 'rest',
    	        		  url : submitUrl,
    	        		  jsonData : formData,
    	        		  method : 'POST',
    	        		  success : function(form, action) {
    	        			  Ext.getBody().unmask();
    	        			  //var msg = Ext.JSON.decode(form.responseText);
    	        			  var msg = form.responseText;
    	        			  if(msg!='' && msg=='SUCCESS'){
    	        				  showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
    	        				  $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
    		        			  $this.cancelStudentAttendance();
//    		        			  var gridCount = Ext.getCmp('studentAttendancecountGridId');
    		        			  var gridCount = $this.getStudentattendancecountgrid();;
    		        			  var models = gridCount.getStore().getRange();
    		        			  if(models.length > 0){
    		        			  models[0].set('totalStudent',0);
    		        			  models[0].set('totalPresent',0);
    		        			  models[0].set('totalAbsent',0);
    		        			  models[0].set('otherCount',0);
    		        			  models[0].set('presentPercent','0%');
    		        			  models[0].set('absentPercent','0%');
    		        			 }
    	        			  } 
    	        			  else if(msg!='' && msg=='DUPLICATE_ATTENDANCE'){
    	        				  Ext.getBody().unmask();
    	        				  showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('STUDENT_SERVICE_DUPLICATE_ATTENDANCE'));
    	        			  } else{
    	        			  }
    	        		  }
    	        	  });
           	      }
           	   else{
        		  var typeOfAttendanc;
        		  if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
        			  typeOfAttendanc = 'COMPLETE_DAY';
        		  }else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
        			  typeOfAttendanc = 'MULTIPLE_SESSION';
        		  }else if(attendanceType == 'COURSE_LEVEL' || attendanceType == 'Course Level'){
        			  typeOfAttendanc = 'COURSE_LEVEL';
        		  }
	        	  studentAttendance.set("programId",values.programId);
	        	  studentAttendance.set("batchId",values.batchId);
	        	  studentAttendance.set("periodId",values.periodId);
	        	  studentAttendance.set("sectionId",values.sectionId);
	        	  studentAttendance.set("dateOfAttendance",values.attendanceDate);
	        	  studentAttendance.set("sessionNo",values.sessionNo);
	        	  studentAttendance.set("attendanceType",typeOfAttendanc);
	        	  studentAttendance.set("facultyId",values.facutly);
	        	  studentAttendance.set("academyLocationId",academyLocationId);
	        	 
	        	  if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
	        		  
	        		  var dateTimeList =[];
	        		  
	        		  if(timeFieldsCount > 1){
	        			  for(var j=0; j<values.fromTime.length &&  values.toTime.length; j++){
	        				  dateTimeList.push({
	        					  "fromTime":values.fromTime[j],
	        					  "toTime": values.toTime[j]
	        				  });
	        			  }
	        			  studentAttendance.set("dateTimeList",dateTimeList);
	        		  }else{
	        			  dateTimeList.push({
        					  "fromTime":values.fromTime,
        					  "toTime": values.toTime
        				  });
	        			  studentAttendance.set("dateTimeList",dateTimeList);
	        		  }
	        	   }
	        	  
	        	  var store = $this.getStudentAttendancegrid().getStore();
	        	  studentAttendance.set("id", store.data.items[0].data.attendanceId);
	        	  var studentProgramAttendanceDetails =[]; 
	        	  var models = store.getRange();
	        	  for(var i=0;i<store.data.length;i++){
	        		  if(!store.data.items[i].data.attendanceStatus){
	        			  if(models[i].data.present){
		        			  studentProgramAttendanceDetails.push({
		        				  "admissionId":store.data.items[i].data.admissionId,
		        				  "attendanceStatus": 'PRESENT',
		        				  "attendanceId":store.data.items[i].data.attendanceId,
		        				  "id":store.data.items[i].data.id,
		        				  "attendanceComment" : store.data.items[i].data.comment,
		        				  "attendanceMarkingType" : this.getIdValueJson(1)
		        			  }); 
	        			  }else{
	        				  studentProgramAttendanceDetails.push({
		        				  "admissionId":store.data.items[i].data.admissionId,
		        				  "attendanceStatus": 'ABSENT',
		        				  "attendanceId":store.data.items[i].data.attendanceId,
		        				  "id":store.data.items[i].data.id,
		        				  "attendanceComment" : store.data.items[i].data.comment,
		        				  "attendanceMarkingType" : this.getIdValueJson(2)
		        			  }); 
	        			  }
	        		  }else if(!isNullOrEmpty(store.data.items[i].data.markingType) && !(store.data.items[i].data.markingType=="OTHER")){
	        			  if(models[i].data.present){
		        			  studentProgramAttendanceDetails.push({
		        				  "admissionId":store.data.items[i].data.admissionId,
		        				  "attendanceStatus": 'PRESENT',
		        				  "attendanceId":store.data.items[i].data.attendanceId,
		        				  "id":store.data.items[i].data.id,
		        				  "attendanceComment" : store.data.items[i].data.comment,
		        				  "attendanceMarkingType" : this.getIdValueJson(1)
		        			  }); 
	        			  }else{
	        				  studentProgramAttendanceDetails.push({
		        				  "admissionId":store.data.items[i].data.admissionId,
		        				  "attendanceStatus": 'ABSENT',
		        				  "attendanceId":store.data.items[i].data.attendanceId,
		        				  "id":store.data.items[i].data.id,
		        				  "attendanceComment" : store.data.items[i].data.comment,
		        				  "attendanceMarkingType" : this.getIdValueJson(2)
		        			  }); 
	        			  }
       	    		  }else{
						 var attendanceTest = store.data.items[i].data.attendanceStatus;
					      if (isNullOrEmpty(store.data.items[i].data.attendanceMarkStatus)) {
					      var attendanceStatus = store.data.items[i].data.attendanceStatus;
					      var attendanceMarkStatus;
					      var attendanceMarkingType;

					      Ext.Ajax.request({
					          type: 'rest',
					          async: false,
					          url: SERVERURL.STUDENT_ATTENDANCE_MARKING_TYPE,
					          method: 'GET',
					          success: function(res, action) {
					              var records = Ext.decode(res.responseText);
					              if (Object.keys(records).length > 0) {
					                  for (var j in records) { // changed inner loop variable to j to avoid conflict
					                      if (records[j].value == attendanceStatus) {
					                          attendanceMarkStatus = records[j].code;
					                          attendanceMarkingType = records[j].id;
					                      }
					                  }
					              }
					          }
					      });

					      studentProgramAttendanceDetails.push({
					          "admissionId": store.data.items[i].data.admissionId,
					          "attendanceStatus": attendanceMarkStatus,
					          "attendanceId": store.data.items[i].data.attendanceId,
					          "id": store.data.items[i].data.id,
					          "attendanceComment": store.data.items[i].data.comment,
					          "attendanceMarkingType": this.getIdValueJson(attendanceMarkingType)
					      });

					  } else {
					      studentProgramAttendanceDetails.push({
					          "admissionId": store.data.items[i].data.admissionId,
					          "attendanceStatus": store.data.items[i].data.attendanceMarkStatus,
					          "attendanceId": store.data.items[i].data.attendanceId,
					          "id": store.data.items[i].data.id,
					          "attendanceComment": store.data.items[i].data.comment,
					          "attendanceMarkingType": this.getIdValueJson(store.data.items[i].data.attendanceMarkingType)
					      });
					  }
				  }
	        	  }

	        	  studentAttendance.set("studentProgramAttendanceDetails",studentProgramAttendanceDetails);
	        	  

	        	  var submitUrl;
	        	  if (form.findField('id').getSubmitValue() == null
	        			  || form.findField('id' ).getSubmitValue() == "") {
	        		  submitUrl = SERVERURL.SAVE_STUDENT_ATTENDANCE;
	        	  } else {
	        		  //courseReading.set("id", values.id);
	        		  //submitUrl = SERVERURL.;
	        	  }
	        	  var formData = Ext.encode(studentAttendance.data);
	        	  //Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        	  
	        	  Ext.Ajax.request({
	        		  type : 'rest',
	        		  url : submitUrl,
	        		  jsonData : formData,
	        		  method : 'POST',
	        		  success : function(form, action) {
	        			  Ext.getBody().unmask();
	        			  //var msg = Ext.JSON.decode(form.responseText);
	        			  var msg = form.responseText;
	        			  if(msg!='' && msg=='SUCCESS'){
	        				  showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
	        				  $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
		        			  $this.cancelStudentAttendance();
//		        			  var gridCount = Ext.getCmp('studentAttendancecountGridId');
		        			  var gridCount = $this.getStudentattendancecountgrid();;
		        			  var models = gridCount.getStore().getRange();
		        			  if(models.length > 0){
		        			  models[0].set('totalStudent',0);
		        			  models[0].set('totalPresent',0);
		        			  models[0].set('totalAbsent',0);
		        			  models[0].set('otherCount',0);
		        			  models[0].set('presentPercent','0%');
		        			  models[0].set('absentPercent','0%');
		        			 }
	        			  } 
	        			  else if(msg!='' && msg=='DUPLICATE_ATTENDANCE'){
	        				  Ext.getBody().unmask();
	        				  showWarningMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getProgramandcourseTranslation('DUPLICATE_ATTENDANCE'));
	        			  } else{
	        			  }
	        		  }
	        	  });
	        	 }
	          }, 
	          cancelStudentAttendance:function(){
	        	  var $this = this;
	        	  var studentForm = $this.getStudentattendance().getForm();
	        	  studentForm.findField('dateOfAttendance').setValue(dateRender(new Date));
	        	  var program = studentForm.findField("programId");
	        	  var attendancesearchstrucure =  $this.getMarkattendancemasterstructure().getForm();
				  //var attendanceType = attendancesearchstrucure.findField('attendanceType').getValue();
	        	  var type=$this.getStudentpncattendancestructure().down('#attendanceTypeRadio').getValue();
				  var attendanceType=type.attendanceTypeWise;
				  var PBP = studentForm.findField("sectionId");
				  $this.getStudentattendance().down('#searchBtn').setDisabled(true);
				  $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
				  if((attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY') || (attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION')){
		        	  if(!PBP.isHidden()){
		        		  PBP.reset();
		        	  }
        		  }
				  else{
					  if(!PBP.isHidden()){
						  PBP.reset();
						  PBP.hide();
					  }
					 /* var date = $this.getStudentattendance().down('#dateOfAttendance_Id');

					  var dateVal = date.getValue();
					  var newDate = null;
						Ext.Ajax.request({
							type : 'rest',
							url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
							method : 'GET',
							async: false,
							success : function(form1, action) {
								data = Ext.JSON.decode(form1.responseText);
								newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
								newDate = new Date(newDate)
								var fromTime = $this.getStudentattendance().down('#fromTime');
								if(dateVal.getDate() == newDate.getDate()){
									var time = moment(newDate).format("HH:mm"); 
									fromTime.setMaxValue(time);
								}
							}});*/
				  }
				
	        	  if(!program.isHidden()){
	        		  program.reset();
	        	  }
	        	  var batch = studentForm.findField("batchId");
	        	  if(!batch.isHidden()){
	        		  batch.reset();
	        		  batch.setDisabled(true);
	        		  
	        	  }

	        	  
	        	 var period = studentForm.findField("periodId");
	        	  if(!period.isHidden()){
	        		  period.reset();
	        		  period.setDisabled(true);
	        	  }
	        	  
	        	  var course = studentForm.findField("courseId");
	        	  if(!course.isHidden()){
	        		  course.reset();
	        	  }
	        	  var academicTermId = studentForm.findField("ACADEMIC_TERM");
	        	  if(!academicTermId.isHidden()){
	        		  academicTermId.reset();
					  var academicTermStore = academicTermId.getStore();
						academicTermStore.getProxy().extraParams = {
							academyLocationIds:$this.getCurrentAcademyLocation(),
							onlyCurrentRecord:true
						};
						academicTermStore.load({
							callback: function(records, operation, success) {
								if (success) {
									if(records.length==1){
										academicTermId.setValue(records[0].data.id);
										var courseStore = course.getStore();
										courseStore.getProxy().extraParams = {
											academyLocationIds:$this.getCurrentAcademyLocation(),
											isCurrentPeriod:true,
											academicTermId:records[0].data.id
										};
										courseStore.load();
									} else {
										var courseStore = course.getStore();
										courseStore.getProxy().extraParams = {
											academyLocationIds:$this.getCurrentAcademyLocation(),
											isCurrentPeriod:true
										};
										courseStore.load();
									}
								}
							}
						});
	        	  }
	        	  var courseVariant = studentForm.findField("courseVariant");
	        	  if(!courseVariant.isHidden()){
	        		  courseVariant.reset();
	        		  courseVariant.setDisabled(true);
	        	  }
	        	  
	        	   var section= studentForm.findField("sectionId");//.reset();
	        	  if(!section.isHidden()){
	        		  section.reset();
	        		  section.setDisabled(true);
	        	  }
	        	  
	        	  var faculty = studentForm.findField("facutly");
	        	  if(!faculty.isHidden()){
	        		  faculty.reset();
	        	  }
	        	  
	        	  var facultyList = studentForm.findField("facutlyList");
	        	  if(!facultyList.isHidden()){
	        		  facultyList.reset();
	        	  }
	        	  
	        	  var fromTime =studentForm.findField("fromTime");
	        	  var toTime = studentForm.findField("toTime");
	        	  
	        	  if(!fromTime.isHidden() && !toTime.isHidden()){
	        		  fromTime.reset();
	        		  toTime.reset();
	        	  }
	        	  fromTime.allowBlank=true;
	        	  toTime.allowBlank=true;
	        	  fromTime.setMaxValue(null);
	        	  toTime.setMinValue(null);
	        	  
	        	  if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
        			  var date = $this.getStudentattendance().down('#dateOfAttendance_Id');
        			  var dateVal = date.getValue();
        			  var newDate = null;
      					Ext.Ajax.request({
      					type : 'rest',
      					url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
      					method : 'GET',
      					async: false,
      					success : function(form, action) {
      						data = Ext.JSON.decode(form.responseText);
      						newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
      						newDate = new Date(newDate)
      						var fromTime = $this.getStudentattendance().down('#fromTime');
      						if(dateVal.getDate() == newDate.getDate()){
      							var time = moment(newDate).format("HH:mm"); 
      							fromTime.setMaxValue(time);
      						}
      					}});
        			  
        			  
        		  }
	        	  
	        	  if(attendanceType == 'Service Level' || attendanceType == 'SERVICE_LEVEL'){
	        		  var serviceField=studentForm.findField("service");
	        		  var batchFieldField=studentForm.findField("serviceBatch");
	        		  var programFieldField=studentForm.findField("serviceprogram");
	        		  var serviceCoordinatorField = studentForm.findField("serviceCoordinatorName");
	        		  batchFieldField.setDisabled(true);
	        		  programFieldField.setDisabled(true);
	        		  serviceCoordinatorField.setDisabled(true);
	        		  serviceField.reset();
	        		  batchFieldField.reset();
	        		  programFieldField.reset();
	        		  serviceCoordinatorField.reset();
	        		  var date = $this.getStudentattendance().down('#dateOfAttendance_Id');
        			  var dateVal = date.getValue();
        			  var newDate = null;
      					Ext.Ajax.request({
      					type : 'rest',
      					url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
      					method : 'GET',
      					async: false,
      					success : function(form, action) {
      						data = Ext.JSON.decode(form.responseText);
      						newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
      						newDate = new Date(newDate)
      						var fromTime = $this.getStudentattendance().down('#fromTime');
      						if(dateVal.getDate() == newDate.getDate()){
      							var time = moment(newDate).format("HH:mm"); 
      							fromTime.setMaxValue(time);
      						}
      					}});
        		  }
	        	  
	        	  var topicId = studentForm.findField("topicId");
	        	  if(!topicId.isHidden()){
	        		  topicId.reset();
	        		  topicId.setDisabled(true);
	        	  }
	        	  
	        	  var timeSlot = studentForm.findField("timeSlotList");
	        	  if(!timeSlot.isHidden()){
	        		  timeSlot.reset();
	        		  timeSlot.setDisabled(true);
	        	  }
	        	  var timetableSlotList = studentForm.findField("timetableSlotList");
	        	  if(!timetableSlotList.isHidden()){
	        		  timetableSlotList.reset();
	        		  timetableSlotList.setDisabled(true);
	        	  }
	        	  timetableSlotList.allowBlank=true;
	        	  var sessionNo = studentForm.findField("sessionNo");
	        	  sessionNo.setValue(1);
	        	  //studentForm.reset();
	        	  var forms = $this.getStudentattendancegrid();
	        	  forms.down('#markOnlyAttendance_Id').items.items[0].setValue(false);
	        	  forms.down('#markOnlyAttendance_Id').items.items[1].setValue(false);
	        	  forms.down('#markOnlyAttendance_Id').items.items[2].setValue(false);
	        	  forms.down('#otherStatusId').clearValue();
	        	  forms.down('#otherStatusId').setVisible(false);
	        	  $this.getStudentAttendancegrid().getStore().removeAll();
	        	  $this.getStudentattendancecountgrid().getStore().removeAll();
	        	  $this.getStudentpncattendancestructure().down('#submitBtn').setDisabled(true);
	        	  var timeSlotPanel = $this.getStudentattendance().down('#panelId');
		            if (timeSlotPanel != null && !timeSlotPanel.items.items[0].isHidden()) {
		            	for(var i=timeSlotPanel.items.length;i>=0;i--){
		            		if(i==0){
		            			timeSlotPanel.items.items[i].setVisible(true);
		            		}else{
		            			timeSlotPanel.remove(timeSlotPanel.items.items[i]);
		            		}
		                    this.hideShowSubjectMarksElement(timeSlotPanel);
		            	}
		            }
	        	  $this.getStudentattendancecountgrid().getStore().removeAll();
	        	  studentForm.checkValidity();
	          },
	          
	          resetDownloadAttendanceForm:function(){
	        	  var $this = this;
	        	  var downloadattendanceform = $this.getDownloadattendanceform();
	        	  
	        	  var program = downloadattendanceform.down('#program_ID');
	        	  program.reset();
	        	  
	        	  var batch = downloadattendanceform.down("#batch_ID");
				  batch.setDisabled(true);
				  batch.reset();
				   
				  var period = downloadattendanceform.down("#period_ID"); 					   
				  period.setDisabled(true);
				  period.reset();
				   
				  var section = downloadattendanceform.down("#section_ID");
				  section.setDisabled(true);
				  section.reset();
				  
				  var faculty = downloadattendanceform.down("#facutly_Id");
				  faculty.reset();
				  
				  var fromdate = downloadattendanceform.down("#dateOfAttendance_Id");
				  fromdate.reset();
				  
				  var todate = downloadattendanceform.down("#consolidateEndDate_Id");
				  todate.reset();
	        	  
	          },
	          
	          attendanceRadioFields:function(){
	        	  var $this =this;
	        	  Ext.Ajax.request({
	        		  type : 'rest',
	        		  url :SERVERURL.STUDENT_ATTENDANCE_MARKING_TYPE,
	        		  method : 'GET',
	        		  success : function(form, action) {
	        			  var attendanceType = Ext.JSON.decode(form.responseText);
	        			  var varattendanceTypeRadio = $this.getStudentattendancegrid().down('#markOnlyAttendance_Id');
	        			  for(var i=0, n=attendanceType.length; i<n; i++ ){

	        				  var attendanceName;
	        				  if(attendanceType[i].value == 'Present'){
	        					  attendanceName = getProgramandcourseTranslation('PRESENT');
	        				  }else if(attendanceType[i].value == 'Absent'){
	        					  attendanceName = getProgramandcourseTranslation('ABSENT');
	        				  }
	        				  if(i<=2){
	        					  if(i==0){
			        				  varattendanceTypeRadio.add({
			        					  style:{
			        							 color:'green !important',
			        						 },
			        					  boxLabel: getProgramandcourseTranslation('MARK_ALL')+ attendanceName,
			        					  name:'attendance',
			        					  inputValue: attendanceType[i].value
			        				  });
	        					  }else if(i==1){
	        						  varattendanceTypeRadio.add({
			        					  style:{
			        							 color:'red !important',
			        						 },
			        					  boxLabel: getProgramandcourseTranslation('MARK_ALL') + attendanceName,
			        					  name:'attendance',
			        					  inputValue: attendanceType[i].value
			        				  });
	        					  } else {
	        						  varattendanceTypeRadio.add({
			        					  style:{
			        							 color:'orange !important',
			        						 },
			        					  boxLabel: getProgramandcourseTranslation('MARK_ALL_OTHER'),
			        					  name:'attendance'
			        				  });
	        					  }
	        				  }
	        			  }
	        			  var forms = $this.getStudentattendancegrid();
	        			  forms.down('#markOnlyAttendance_Id').items.items[0].setValue(false);
	        			  forms.down('#markOnlyAttendance_Id').items.items[1].setValue(false);
	        			  forms.down('#markOnlyAttendance_Id').items.items[2].setValue(false);
	        		  }
	        	  });
	          },
	           updateAttendance:function(){
	        	   var $this = this;
	        	   var form = $this.getEditattenDance().getForm();
	        	   var values = form.getValues();
	        	   var attendanceType = form.findField('attendanceType').getValue();
	        	   var ids = form.findField('ids').getValue();
	        	   
	        	   var admissionDetailIDs = ids.split(',');
	        	   var attendanceStatus;
	        	   
	        	   if(values.attendanceStatus !='' && values.attendanceStatus!=null){
	        		   attendanceStatus = values.attendanceStatus;
	        	   }else{
	        		   attendanceStatus = values.attendanceStatusFaculty;
	        	   }

	        	   var courseId = form.findField('courseId').getValue();
	        	   var sectionId = form.findField('sectionId').getValue();
	        	   var dateOfAttendance = form.findField('dateOfAttendance').getValue();
	        	   var attendanceDetailId = form.findField('attendanceDetailId').getValue();


	        	   var typeOfAttendanc;
	        	   if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
	        		   typeOfAttendanc = 'COMPLETE_DAY';
	        	   }else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
	        		   typeOfAttendanc = 'MULTIPLE_SESSION';
	        	   }else if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
	        		   typeOfAttendanc = 'COURSE_LEVEL';
	        	   }

	        	   var attendanceTest;
	        	   if(attendanceStatus == 'Present' || attendanceStatus == 'PRESENT'){
	        		   attendanceTest = 'PRESENT';
	        	   }else if(attendanceStatus == 'Absent' || attendanceStatus == 'ABSENT'){
	        		   attendanceTest = 'ABSENT';
	        	   }else if(values.attendanceStatus !='' && values.attendanceStatus!=null){
	        		   if(attendanceStatus == 'LEAVE' || attendanceStatus == 'Leave'){
	        			   attendanceTest = 'LEAVE';
	        		   }
	        	   }

//	        	   var form = $this.getAttendancesearchstrucure().getForm();
	        	   var form = $this.getMarkattendancemasterstructure().getForm();
	        	   var attendanceDetials = form.findField('attendanceDetials').getValue();


	        	   var store = $this.getStore('attendance.CourseLevelFacultyBlank');
	        	   var data = [];
	        	   for(var i =0;i<store.data.length;i++){
	        		   var status = store.data.items[i].data.status;

	        		   if(status== 'Complete' || status== 'COMPLETE'){
	        			   status = 'COMPLETE';
	        		   }else if(status== 'In Progress' || status == 'IN PROGRESS'){
	        			   status = 'IN_PROGRESS';
	        		   }else {/*if(status== 'Not Started' || status == 'NOT_STARTED'){*/
	        			   status ='NOT_STARTED';
	        		   }
	        		   
	        		   /**
	        		    * data.push are using for only in case of course level of faculty.
	        		    */
	        		   data.push({
	        			   "courseId":courseId,
	        			   "sectionId":sectionId,
	        			   "variantId":null,
	        			   "componentId":null,
	        			   "date":dateOfAttendance,
	        			   "topicId":store.data.items[i].data.courseTopicId,
	        			   "courseTopicStatusId": store.data.items[i].data.courseTopicStatusId,
	        			   "minuteSpent":store.data.items[i].data.minuteSpent,
	        			   "status":status,
	        			   "id":store.data.items[i].data.courseTopicCoverageId
	        		   });
	        	   }
	        	   
	        	   
        		   /**
        		    *  attendanceFormate are use for all attendance type of student. 
        		    */
        		   var attendanceFormate = {
        				   "attendanceType": typeOfAttendanc,
        			       "attendanceStatus": attendanceTest,
        			       "attendanceids": admissionDetailIDs
        			      
        		   };

	        	   var submitUrl;
	        	   if(ids.length > 0 || ids != null){

	        		   if(attendanceDetials){
	        			   submitUrl = SERVERURL.UPDATE_STUDENT_ATTENDANCE;
	        			   $this.applyWindowMask(); 
	        			   
	        			   Ext.Ajax.request({
	        				   type : 'rest',
	        				   url : submitUrl,
	        				   jsonData : attendanceFormate,
	        				   method : 'POST',
	        				   success : function(form, action) {
	        					   $this.hideWindowMask();
	        					   //Ext.JSON.decode(form.responseText);
	        					   showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
	        					   $this.getEditattendance().close();
	        					   $this.getStudentAttendanceGridId().getStore().reload();
	        					   $this.getStudentMultiSessionGridId().getStore().reload();
	        					   $this.getStudentCourseLevelGridId().getStore().reload();

	        				   }
	        			   });
	        		   }else{

	        			   submitUrl = SERVERURL.UPDATE_FACULTY_ATTENDANCE;
	        			   var jsonData =attendanceFormate;

	        			   if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
	        				   submitUrl = SERVERURL.UPDATE_FACULTY_ATTENDANCE_COURSE_LEVEL + '?attendanceDetailId=' +attendanceDetailId + '&attendancStatus=' + attendanceTest;
	        				   jsonData = [];
	        			   }
	        			   $this.applyWindowMask(); 
	        			   Ext.Ajax.request({
	        				   type : 'rest',
	        				   url : submitUrl,
	        				   jsonData : jsonData,
	        				   method : 'POST',
	        				   success : function(form, action) {
	        					   $this.hideWindowMask();
	        					   //Ext.JSON.decode(form.responseText);
	        					   showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
	        					   $this.getEditattendance().close();
	        					   $this.getFacultyDayWiseGridId().getStore().reload();
	        					   $this.getFacultyMultiSessionGridId().getStore().reload();
	        					   $this.getFacultyCourseLevelGridId().getStore().reload();
	        				   }
	        			   });		  
	        		   }
	        	   }
	           },
	           cancelAttendance:function(){
	        	   this.getEditattendance().close();
	           },
	           /**
	            * timeFieldsAdd function are use for add dynamic time fields
	            */
	           timeFieldsAdd:function(){
	        	   var $this = this;
	        	   var form = this.getStudentattendance();
	        	   var timeContiner = this.getStudentattendance().down('#panelId');
	        	   var date = this.getStudentattendance().down('#dateOfAttendance_Id');
	        	   var timeFieldsCount = timeContiner.items.length;
	        	   var panelItem = new Array();
	        	   
	        	   panelItem.push({
	        		   xtype:'fieldcontainer',
	        		   width: 'auto',
	        		   layout : 'hbox',
	        		   defaults : {
	        			   labelAlign : 'top'
	        		   },
	        		   items : [{
	        			   xtype : 'timefield',
	        			   name : 'fromTime',		
	        			   itemId : 'fromTime'+timeFieldsCount,			
	        			   //fieldLabel:getProgramandcourseTranslation('START_TIME')+'<span class="required" style="color:red"> *</span>',
	        			   format:'g:i A',
	        			   vtype: 'timerange',
	        			   increment: 1,
//	        			   endTimeField : 'toTime'+timeFieldsCount,
	        			   allowBlank:false,
	        			   width:100,
	        			   listeners:{
								change:function(obj,val){
									if (!isNullOrEmpty(val)) {
										var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 1);
										obj.nextSibling().setMinValue(sDate);	
									}
								}
							}
	        			   
	        		   },{
	        			   xtype : 'timefield',
	        			   name : 'toTime',		
	        			   itemId : 'toTime'+timeFieldsCount,			
	        			   //fieldLabel:getProgramandcourseTranslation('END_TIME')+'<span class="required" style="color:red"> *</span>',
	        			   format:'g:i A',
	        			   vtype: 'timerange',
	        			   increment: 1,
//	        			   startTimeField :'fromTime'+timeFieldsCount,
	        			   allowBlank:false,
	        			   width:100,
	        			   listeners:{
								change:function(obj,val){
									if (!isNullOrEmpty(val)) {
										var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -1);
										//obj.previousSibling().setMaxValue(eDate);

										var dateVal = date.getValue();
										var newDate = null;
										Ext.Ajax.request({
											type : 'rest',
											url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
											method : 'GET',
											async: false,
											success : function(form1, action) {
												data = Ext.JSON.decode(form1.responseText);
												newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
												var fromTime = form.down('#fromTime');
												newDate = new Date(newDate)
												if(dateVal.getDate() == newDate.getDate()){
													var time = moment(newDate).format("HH:mm"); 
													obj.previousSibling().setMaxValue(time);
												}
											}});
									}
								}
							}
	        		   },{/*
	        			   xtype: 'button',
	        			   glyph: ICONGLYPH.DELETEGLYPH,
	        			   cls: 'CustomBodyBtnReject',
	        			   tooltip: getCommonTranslation('DELETETOOLTIP'),
	        			   style:{
	        				   marginTop:'30px'
	        			   },
	        			   listeners:{
	        				   click:function(obj){
	        					   var container = obj.up('fieldcontainer');
	        					   var panelContiner = $this.getStudentattendance().down('#panelId');
	        					   panelContiner.remove(container);
	        					   $this.getStudentattendance().isValid();
	        				   }
	        			   }*/
	        			   
	   		        		xtype : 'button',
	   		        		itemId: 'timeBtnDelete1',
	   		        		glyph: ICONGLYPH.DELETEGLYPH,
	   			   			cls: 'CustomBodyBtnReject',
	   			   			tooltip: getCommonTranslation('DELETETOOLTIP'),
            			listeners:{
            				click:function(obj){
            					var container = obj.up('fieldcontainer');
            					//panelContiner.remove(container);
         			            var form = $this.getStudentattendance();
            					$this.getStudentattendance().getForm().isValid();
            					$this.getStudentattendance().down('#searchBtn').setDisabled(false);
            				}
            			
            		},
	   			   			
	   		        	}, {
	   		        		xtype : 'button',
	   		        		itemId: 'timeBtnAdd1',
	   		        		cls: 'CustomBodyBtnSettings',
	   						text: getCommonTranslation('ADDBUTTONTEXT'),
	   						tooltip: getCommonTranslation('ADD')
	   						
	        		   }]
	        	   });
	        	   var dateVal = date.getValue();
	        	   var newDate = null;
	        	   Ext.Ajax.request({
	        		   type : 'rest',
	        		   url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
	        		   method : 'GET',
	        		   async: false,
	        		   success : function(form1, action) {
	        			   data = Ext.JSON.decode(form1.responseText);
	        			   newDate=data.serverDateTimeYYYYMMDDTweentyFourHour;
	        			   newDate = new Date(newDate)
	        			   timeContiner.add(panelItem);
	        			   var fromTime = timeContiner.down('#fromTime'+timeFieldsCount);
	        			   if(dateVal.getDate() == newDate.getDate()){
	        				   var time = moment(newDate).format("HH:mm"); 
	        				   fromTime.setMaxValue(time);
	        			   }
	        		   }});
		            this.hideShowSubjectMarksElement(timeContiner);
		            timeContiner.doLayout();
	           },
	           // reset student form
	           resetStudentForm:function(){
	        	var $this = this;
	        	$this.cancelStudentAttendance();
	           },
	           genrateQrCodeForCoreErp:function(){
	        	   var $this=this;
	        	   var form = $this.getStudentattendance();
	        	   var attendancesearchstrucure =  $this.getMarkattendancemasterstructure().getForm();
	        	   var attendanceType = attendancesearchstrucure.findField('attendanceType').getValue();
	        	   var section=form.down("#programCoursection_ID").getValue();
	        	   var sessionNo=form.down("#sessionItemId").getValue();
	        	   var date=form.down("#dateOfAttendance_Id").getValue();
	        	   var courseId=form.down("#courseId").getValue();
	        	   var fromTime=form.down("#fromTime").getValue();
	        	   var toTime=form.down("#toTime").getValue();
	        	   var form1 = $this.getStudentattendance().getForm();
	        	   var sectionId = form1.findField('sectionId').getValue();
	        	   var fromTime = form1.findField('fromTime').getValue();
	        	   var toTime = form1.findField('toTime').getValue();
	        	   var attendanceDate = form1.findField('dateOfAttendance').getValue();
	        	   var courseVariantId = form1.findField('courseVariant').getValue();
	        	   var courseVariant = form1.findField('courseVariant');
	        	   var attendanceSlot = form1.findField('attendanceSlot').getValue();
	        	   var timeTableSlotList = form1.findField('timetableSlotList').getValue();
	        	   var adhocRequired = form.down('[name=adhocRequired]').getValue();

	        	   var store = '';
	        	   var endPointUrl = '';
	        	   var extraParam = {},
	        	   qrCodeExpiryTime;

	        	   if (attendanceType == 'COURSE_WISE' || attendanceType == 'COURSE_LEVEL'){             
	        		   var courseSectionId =null;
	        		   if(courseVariant.valueModels.length > 0){
	        			   courseSectionId = courseVariant.valueModels[0].get("sectionId");   
	        		   }
	        		   var values = form.getValues();
	        		   var date = Ext.Date.format(new Date(attendanceDate), 'Y-m-d');
	        		   var section;
	        		   if(sectionId !='' && sectionId !=null ){
	        			   section = sectionId;
	        		   }else{
	        			   section =courseSectionId;
	        		   }

	        		   store = this.getStudentAttendancegrid().getStore();
	        		   endPointUrl= SERVERURL.GET_STUDENT_ENROLLED_IN_VARIANT;
	        		   extraParam={
	        				   sectionId: section,
	        				   attendanceDate:date,
	        				   courseId:courseId,
	        				   fromTime:fromTime,
	        				   toTime:toTime,
	        				   attendanceType:attendanceType,
	        				   portalId:'1'
	        		   }
	        	   }
	        	   else
	        	   {
	        		   store = this.getStudentAttendancegrid().getStore();
	        		   endPointUrl=SERVERURL.GET_STUDENT_LIST_BY_SECTION_ID;
	        		   extraParam={sectionId: section,
	        				   date:date,
	        				   sessionNo:sessionNo,
	        				   attendanceType:attendanceType,
	        				   portalId:'1'
	        		   };
	        	   }
	        	   store.getProxy().api.read=endPointUrl;
	        	   store.getProxy().extraParams = extraParam;

	        	   var studentForm = this.getStudentattendance().getForm();
	        	   var store = this.getStudentAttendancegrid().getStore();
	        	   store.getProxy().api.read=endPointUrl;
	        	   store.getProxy().extraParams = extraParam;
	        	   
	        	   Ext.Ajax.request({
	                    type: 'rest',
	                    url: SERVERURL.QR_CODE_EXP_BY_AL_AND_ATTENDANCE_TYPE,										 
	                    method: 'GET',
	                    async: true,
	                    headers: {
	                        'Content-Type': 'application/json'
	                    },
	                    params: {
	                    	attendanceType: attendanceType
	                    },
	                    success: function(form, action) {
	                    	qrCodeExpiryTime = Ext.JSON.decode(form.responseText).qrCodeExpiryTime
	                    }
	                });

	        	   store.load({
	        		   callback: function(records, operation, success) {
	        			   if (success) {
	        				   if(records.length > 0){

	        					   var form = $this.getStudentattendance();
	        					   var periodIdItemId=form.down("#periodIdItemId").rawValue;
	        					   var programBatch_programId=form.down("#programBatch_programId").rawValue;
	        					   var programBatch_batchId=form.down("#programBatch_batchId").rawValue;
	        					   var facutlyId=form.down("#facutlyId").rawValue;
	        					   var programCoursection_ID=form.down("#programCoursection_ID").rawValue;
	        					   var dateOfAttendance_Id=form.down("#dateOfAttendance_Id").rawValue;
	        					   var sessionItemId=form.down("#sessionItemId").rawValue;
	        					   var courseId= form.down("#courseId").rawValue;
	        					   var courseVariantId= form.down("#courseVariantId").rawValue;
	        					   var facutlyListId=   form.down("#facutlyListId").rawValue;
	        					   var timetableSlotListId=form.down("#timetableSlotListId").rawValue;
	        					   var topicId=form.down("#topicId").rawValue; 
	        					   var academicTerm= form.down("#academicTerm").rawValue; 


	        					   if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY')
	        					   {
	        						   var formWindow =  $this.getGenrateqrstructure();
	        						   if (!formWindow) {
	        							   Ext.widget('genrateqrstructure');
	        							   formWindow =  $this.getGenrateqrstructure();
	        							   formWindow.down("#periodIdItemId").setVisible(true);
	        							   formWindow.down("#programBatch_programId").setVisible(true);
	        							   formWindow.down("#programBatch_batchId").setVisible(true);
	        							   formWindow.down("#facutlyId").setVisible(true);
	        							   formWindow.down("#programCoursection_ID").setVisible(true); 
	        							   formWindow.down("#dateOfAttendance_Id").setVisible(true);

	        							   formWindow.down("#periodIdItemId").setValue(periodIdItemId);
	        							   formWindow.down("#facutlyId").setValue(facutlyId);
	        							   formWindow.down("#programCoursection_ID").setValue(programCoursection_ID);
	        							   formWindow.down("#dateOfAttendance_Id").setValue(dateOfAttendance_Id); 
	        							   formWindow.down("#programBatch_programId").setValue(programBatch_programId);
	        							   formWindow.down("#programBatch_batchId").setValue(programBatch_batchId);
	        							   //formWindow.down("#fromTime").setValue("12:00 AM");
	        							   //formWindow.down("#toTime").setValue("12:00 AM");
	        							   formWindow.down("#expirytime").setValue(qrCodeExpiryTime);
	        						   }
	        						   formWindow.show();

	        					   }
	        					   else if (attendanceType == 'COURSE_WISE' || attendanceType == 'COURSE_LEVEL')
	        					   {
	        						   var isAdHoc = false;
	        						   if(adhocRequired && adhocRequired=='true'){
	        							   isAdHoc = true;
	        						   }
	        						   if(attendanceSlot == 'TIME_TABLE_SLOTS' && !isAdHoc) {
	        							   var formWindow = $this.getGenrateqrstructure();
	        							   if (!formWindow) {
	        								   Ext.widget('genrateqrstructure');
	        								   formWindow =  $this.getGenrateqrstructure();
	        								   formWindow.down("#courseId").setVisible(true);
	        								   formWindow.down("#courseVariantId").setVisible(true);
	        								   formWindow.down("#facutlyListId").setVisible(true);
	        								   formWindow.down("#timetableSlotListId").setVisible(true);
	        								   formWindow.down("#topicId").setVisible(true);  
	        								   formWindow.down("#academicTerm").setVisible(true);

	        								   formWindow.down("#courseId").setValue(courseId);
	        								   formWindow.down("#courseVariantId").setValue(courseVariantId);
	        								   formWindow.down("#facutlyListId").setValue(facutlyListId);
	        								   formWindow.down("#timetableSlotListId").setValue(timetableSlotListId); 
	        								   formWindow.down("#topicId").setValue(topicId);
	        								   formWindow.down("#academicTerm").setValue(academicTerm);
	        								   //formWindow.down("#fromTime").setValue("12:00 AM");
	        								   //formWindow.down("#toTime").setValue("12:00 AM");
	        								   formWindow.down("#expirytime").setValue(qrCodeExpiryTime);
	        							   }
	        							   formWindow.show();
	        						   } else if(attendanceSlot == 'TIME_TABLE_SLOTS' && isAdHoc){
	        							   
	        							   if(!isNullOrEmpty(timetableSlotListId) && timetableSlotListId.length){
	        								   var formWindow = $this.getGenrateqrstructure();
		        							   if (!formWindow) {
		        								   Ext.widget('genrateqrstructure',{
		        									   isAdHoc: true
		        								   });
		        								   formWindow =  $this.getGenrateqrstructure();
		        								   formWindow.down("#courseId").setVisible(true);
		        								   formWindow.down("#courseVariantId").setVisible(true);
		        								   formWindow.down("#facutlyListId").setVisible(true);
		        								   formWindow.down("#timetableSlotListId").setVisible(true);
		        								   formWindow.down("#topicId").setVisible(true);  
		        								   formWindow.down("#academicTerm").setVisible(true);
		        								   
		        								   formWindow.down("#timetableSlotListId").setFieldLabel(getCommonTranslation('AD_HOC_SLOTS'));

		        								   formWindow.down("#courseId").setValue(courseId);
		        								   formWindow.down("#courseVariantId").setValue(courseVariantId);
		        								   formWindow.down("#facutlyListId").setValue(facutlyListId);
		        								   formWindow.down("#timetableSlotListId").setValue(timetableSlotListId); 
		        								   formWindow.down("#topicId").setValue(topicId);
		        								   formWindow.down("#academicTerm").setValue(academicTerm);
		        								   //formWindow.down("#fromTime").setValue("12:00 AM");
		        								   //formWindow.down("#toTime").setValue("12:00 AM");
		        								   formWindow.down("#expirytime").setValue(qrCodeExpiryTime);
		        							   }
	        							   } else{
		        							   var formValues = form.getValues();
		        							   var fromTimeSelected = formValues.fromTime;
		        							   var toTimeSelected = formValues.toTime;
		        							   
		        							   var fromTimeArray = [];
		        							   var toTimeArray = [];
		        							   if(Ext.isArray(form.getValues().fromTime)){
		        								   fromTimeArray = form.getValues().fromTime;
		        							   }
		        							   else{
		        								   fromTimeArray.push(form.getValues().fromTime)
		        							   }
		        							   
		        							   if(Ext.isArray(form.getValues().toTime)){
		        								   toTimeArray = form.getValues().toTime;
		        							   }
		        							   else{
		        								   toTimeArray.push(form.getValues().toTime)
		        							   }
		        							   
		        							   if(fromTimeArray.length > 1 || toTimeArray.length > 1){
		        								   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('QR_CANNOT_BE_GENERATED_FOR_MULTIPLE_TIME_SLOTS'));	
		        								   return false;
		        							   }
		        							   
		        							   var formWindow = $this.getGenrateqrstructure();
		        							   if (!formWindow) {
		        								   Ext.widget('genrateqrstructure',{
		        									   isAdHoc: true
		        								   });
		        								   formWindow =  $this.getGenrateqrstructure();
		        								   formWindow.down("#courseId").setVisible(true);
		        								   formWindow.down("#courseVariantId").setVisible(true);
		        								   formWindow.down("#facutlyListId").setVisible(true);
		        								   formWindow.down("#timetableSlotListId").setVisible(false);
		        								   formWindow.down("#topicId").setVisible(true);  
		        								   formWindow.down("#academicTerm").setVisible(true);
		        								   formWindow.down("#fromTime").setVisible(true);
		        								   formWindow.down("#toTime1").setVisible(true);
		        								   
		        								   formWindow.down("#courseId").setValue(courseId);
		        								   formWindow.down("#courseVariantId").setValue(courseVariantId);
		        								   formWindow.down("#facutlyListId").setValue(facutlyListId);
		        								   //formWindow.down("#timetableSlotListId").setValue(timetableSlotListId); 
		        								   formWindow.down("#topicId").setValue(topicId);
		        								   formWindow.down("#academicTerm").setValue(academicTerm);
		        								   formWindow.down("#fromTime").setValue(fromTimeSelected);
		        								   formWindow.down("#toTime1").setValue(toTimeSelected);
		        								   //formWindow.down("#toTime").setValue(toTimeSelected);
		        								   formWindow.down("#expirytime").setValue(qrCodeExpiryTime);
		        								   
		        								   formWindow.down("#fromTime").setReadOnly(true);
		        								   formWindow.down("#toTime1").setReadOnly(true);
		        							   }
	        							   }
	        							   formWindow.show();
	        						   } else if(attendanceSlot == 'AD_HOC_SLOTS'){
	        							   var formValues = form.getValues();
	        							   var fromTimeSelected = formValues.fromTime;
	        							   var toTimeSelected = formValues.toTime;
	        							   
	        							   var fromTimeArray = [];
	        							   var toTimeArray = [];
	        							   if(Ext.isArray(form.getValues().fromTime)){
	        								   fromTimeArray = form.getValues().fromTime;
	        							   }
	        							   else{
	        								   fromTimeArray.push(form.getValues().fromTime)
	        							   }
	        							   
	        							   if(Ext.isArray(form.getValues().toTime)){
	        								   toTimeArray = form.getValues().toTime;
	        							   }
	        							   else{
	        								   toTimeArray.push(form.getValues().toTime)
	        							   }
	        							   
	        							   if(fromTimeArray.length > 1 || toTimeArray.length > 1){
	        								   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('QR_CANNOT_BE_GENERATED_FOR_MULTIPLE_TIME_SLOTS'));	
	        								   return false;
	        							   }
	        							   
	        							   var formWindow = $this.getGenrateqrstructure();
	        							   if (!formWindow) {
	        								   Ext.widget('genrateqrstructure',{
	        									   isAdHoc: true
	        								   });
	        								   formWindow =  $this.getGenrateqrstructure();
	        								   formWindow.down("#courseId").setVisible(true);
	        								   formWindow.down("#courseVariantId").setVisible(true);
	        								   formWindow.down("#facutlyListId").setVisible(true);
	        								   formWindow.down("#timetableSlotListId").setVisible(false);
	        								   formWindow.down("#topicId").setVisible(true);  
	        								   formWindow.down("#academicTerm").setVisible(true);
	        								   formWindow.down("#fromTime").setVisible(true);
	        								   formWindow.down("#toTime1").setVisible(true);
	        								   
	        								   formWindow.down("#courseId").setValue(courseId);
	        								   formWindow.down("#courseVariantId").setValue(courseVariantId);
	        								   formWindow.down("#facutlyListId").setValue(facutlyListId);
	        								   //formWindow.down("#timetableSlotListId").setValue(timetableSlotListId); 
	        								   formWindow.down("#topicId").setValue(topicId);
	        								   formWindow.down("#academicTerm").setValue(academicTerm);
	        								   formWindow.down("#fromTime").setValue(fromTimeSelected);
	        								   formWindow.down("#toTime1").setValue(toTimeSelected);
	        								   //formWindow.down("#toTime").setValue(toTimeSelected);
	        								   formWindow.down("#expirytime").setValue(qrCodeExpiryTime);
	        								   
	        								   formWindow.down("#fromTime").setReadOnly(true);
	        								   formWindow.down("#toTime1").setReadOnly(true);
	        							   }
	        							   formWindow.show();
	        						   } else {
	        							   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('QR_Code_is_generated_only_for_Timetable_wise_configuration!'));	
	        						   }
	        					   }
	        					   else
	        					   {
	        						   var formWindow =  $this.getGenrateqrstructure();
	        						   if (!formWindow) {
	        							   Ext.widget('genrateqrstructure');
	        							   formWindow = $this.getGenrateqrstructure();
	        							   formWindow.down("#periodIdItemId").setVisible(true);
	        							   formWindow.down("#programBatch_programId").setVisible(true);
	        							   formWindow.down("#programBatch_batchId").setVisible(true);
	        							   formWindow.down("#facutlyId").setVisible(true);
	        							   formWindow.down("#programCoursection_ID").setVisible(true);  
	        							   formWindow.down("#periodIdItemId").setVisible(true);
	        							   formWindow.down("#sessionItemId").setVisible(true);
	        							   formWindow.down("#dateOfAttendance_Id").setVisible(true);


	        							   formWindow.down("#periodIdItemId").setValue(periodIdItemId);
	        							   formWindow.down("#facutlyId").setValue(facutlyId);
	        							   formWindow.down("#programCoursection_ID").setValue(programCoursection_ID);
	        							   formWindow.down("#dateOfAttendance_Id").setValue(dateOfAttendance_Id); 
	        							   formWindow.down("#programBatch_programId").setValue(programBatch_programId);
	        							   formWindow.down("#programBatch_batchId").setValue(programBatch_batchId);
	        							   formWindow.down("#sessionItemId").setValue(sessionItemId);
	        							   //formWindow.down("#fromTime").setValue("12:00 AM");
	        							   //formWindow.down("#toTime").setValue("12:00 AM");
	        							   formWindow.down("#expirytime").setValue(qrCodeExpiryTime);


	        						   }
	        						   formWindow.show();
	        					   }
	        				   }
	        				   else
	        				   {
	        					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_STUDENTS_ARE_SCHEDULED_TO_TAKE_THIS_CLASS'));	

	        				   } } }});		
	           },
	           viewQrCodeForCoreErp: function(btn){
	        	   var $this=this;
	        	   var form = $this.getStudentattendance();
	        	   var attendancesearchstrucure =  $this.getMarkattendancemasterstructure().getForm();
	        	   var attendanceType = attendancesearchstrucure.findField('attendanceType').getValue();
	        	   var section=form.down("#programCoursection_ID").getValue();
	        	   var sessionNo=form.down("#sessionItemId").getValue();
	        	   var date=form.down("#dateOfAttendance_Id").getValue();
	        	   var courseId=form.down("#courseId").getValue();
	        	   var fromTime=form.down("#fromTime").getValue();
	        	   var toTime=form.down("#toTime").getValue();
	        	   var form1 = $this.getStudentattendance().getForm();
	        	   var sectionId = form1.findField('sectionId').getValue();
	        	   var fromTime = form1.findField('fromTime').getValue();
	        	   var toTime = form1.findField('toTime').getValue();
	        	   var attendanceDate = form1.findField('dateOfAttendance').getValue();
	        	   var courseVariantId = form1.findField('courseVariant').getValue();
	        	   var courseVariant = form1.findField('courseVariant');
	        	   var attendanceSlot = form1.findField('attendanceSlot').getValue();
	        	   var timeTableSlotList = form1.findField('timetableSlotList').getValue();
	        	   var adhocRequired = form.down('[name=adhocRequired]').getValue();
	        	   var timetableSlotListId=form.down("#timetableSlotListId").rawValue;
	        	   var facutlyListId = form.down('#facutlyListId').getValue();
	        	   
	        	   var qrDataModel = {};
	        	   var store = '';
	        	   var endPointUrl = '';
	        	   var extraParam = {};
	        	   
	        	   if (attendanceType == 'COURSE_WISE' || attendanceType == 'COURSE_LEVEL'){             
	        		   var courseSectionId =null;
	        		   if(courseVariant.valueModels.length > 0){
	        			   courseSectionId = courseVariant.valueModels[0].get("sectionId");   
	        		   }
	        		   var values = form.getValues();
	        		   var date = Ext.Date.format(new Date(attendanceDate), 'Y-m-d');
	        		   var section;
	        		   if(sectionId !='' && sectionId !=null ){
	        			   section = sectionId;
	        		   }else{
	        			   section =courseSectionId;
	        		   }
	        		   
	        		   //----
	        		   
					   var isAdHoc = false;
					   if(adhocRequired && adhocRequired=='true'){
						   isAdHoc = true;
					   }
					   if(attendanceSlot == 'TIME_TABLE_SLOTS' && !isAdHoc) {
						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SHOW_QR_FOR_SELECTED_CONFIGURATIONS'));
						   //--CANNOT VIEW
						   return false;
					   } else if(attendanceSlot == 'TIME_TABLE_SLOTS' && isAdHoc){
						   if(!isNullOrEmpty(timetableSlotListId) && timetableSlotListId.length){
							   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SHOW_QR_FOR_SELECTED_CONFIGURATIONS'));
							   //--CANNOT VIEW
							   return false;
						   } else{
							   var formValues = form.getValues();
							   var fromTimeSelected = formValues.fromTime;
							   var toTimeSelected = formValues.toTime;
							   
							   var fromTimeArray = [];
							   var toTimeArray = [];
							   if(Ext.isArray(form.getValues().fromTime)){
								   fromTimeArray = form.getValues().fromTime;
							   }
							   else{
								   fromTimeArray.push(form.getValues().fromTime)
							   }
							   
							   if(Ext.isArray(form.getValues().toTime)){
								   toTimeArray = form.getValues().toTime;
							   }
							   else{
								   toTimeArray.push(form.getValues().toTime)
							   }
							   
							   if(fromTimeArray.length > 1 || toTimeArray.length > 1){
								   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SHOW_QR_FOR_SELECTED_CONFIGURATIONS'));
								   //--CANNOT VIEW
								   return false;
							   }
							   
							   qrDataModel.qrData = {
									   qrId: undefined,
									   courseVariantId:courseVariantId,
									   courseId:courseId
							   };
							   
							   var qrDisplayData = form.down("#courseId").getDisplayValue()
		                        + ' | ' + form1.findField('courseVariant').getDisplayValue();
							   var qrDisplayData = form.down("#courseId").getDisplayValue() + ' | ' + form1.findField('courseVariant').getDisplayValue() + ' | ' + fromTimeSelected + ' - ' + toTimeSelected + ' | ' + form1.findField('facutlyList').getDisplayValue() + ' | ' + dateRender(date);
		 						
							   Ext.Ajax.request({
				                    type: 'rest',
				                    url: SERVERURL.PATH_COURSE_ATTENDANCE_QR,										 
				                    method: 'GET',
				                    headers: {
				                        'Content-Type': 'application/json'
				                    },
				                    params: {
										courseVariantId:courseVariantId,
										academyLocationId:this.getCurrentAcademyLocation(),
										sectionId:sectionId,
										attendanceType:attendanceType,
										facultyId:facutlyListId,
										attendanceDate:date,
										slotFrom:fromTimeSelected,
										slotTo:toTimeSelected,
										programId:"",
										batchId:"",
										periodId:""	
				                    },
				                    success: function(form, action) {
				                    	if(isNullOrEmpty(form.responseText)){
				                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_QR_CODE_FOR_THIS_SESSION_IS_NOT_YET_GENERATED_YOU_CAN_GENERATE_IT_FROM_CAPTURE_ATTENDANCE_SCREEN'));
				                    	}else{
				                    		Ext.Ajax.request({
							                    type: 'rest',
							                    url: SERVERURL.PATH_COURSE_ATTENDANCE_QR_CODE,											 
							                    method: 'GET',
							                    headers: {
							                        'Content-Type': 'application/json'
							                    },
							                    params: {
													courseVariantId:courseVariantId,
													academyLocationId:$this.getCurrentAcademyLocation(),
													sectionId:sectionId,
													attendanceType:attendanceType,
													facultyId:facutlyListId,
													attendanceDate:date,
													slotFrom:fromTimeSelected,
													slotTo:toTimeSelected,
													programId:"",
													batchId:"",
													periodId:"",
													checkExpiry: true
							                    },
							                    success: function(form1, action1) {
							                    	if(isNullOrEmpty(form1.responseText)){
							                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_QR_CODE_FOR_THIS_SESSION_IS_NOT_YET_GENERATED_YOU_CAN_GENERATE_IT_FROM_CAPTURE_ATTENDANCE_SCREEN'));
							                    	} else if (form1.responseText == "QR_CODE_EXPIRE"){
							                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('QR_CODE_EXPIRED'));
							                    	}else{
							                    		
							                    		var qrCodeText = '';
							                    		if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
							                    			qrCodeText = 'CD-'+form1.responseText; //CompleteDay
							                    		}
							                    		else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION'){
							                    			qrCodeText = 'MS-'+form1.responseText; //MultipleSessions
							                    		}
							                    		else{
							                    			qrCodeText = 'CW-'+form1.responseText; //CourseWise
							                    		}
							                    		
							                    		var formWindow =  $this.getQrcodewindow();
							                    		if (!formWindow) {
							                    			Ext.widget('qrcodewindow',{
							                    				qrData: Ext.encode(qrDataModel.qrData),
							                    				path:form.responseText,
							                    				qrDisplayData: qrDisplayData,
							                    				qrCode: qrCodeText,
							                    				itemId: 'attendanceViewQRWin',
							                    				title: getCommonTranslation('VIEW_QR')
							                    			})
							                    			formWindow =  $this.getQrcodewindow();
							                    		}
							                    		formWindow.show();
							                    	}
							     				
							                    }
							                });
				                    	
				                    	}
				     				
				                    }
				                });
						   }
					   } else if(attendanceSlot == 'AD_HOC_SLOTS'){
						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SHOW_QR_FOR_SELECTED_CONFIGURATIONS'));
						   //--CANNOT VIEW
						   return false;
					   } else {
						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SHOW_QR_FOR_SELECTED_CONFIGURATIONS'));
						   //--CANNOT VIEW
						   return false;
					   }
				   
	        		   //----
	        	   }
	           },
	
	           programBatchDownload : function(form1){
	        	   var $this = this;
	        	   var studentForm = "";
					var studentAttendanceType= "";
					var attendanceType= "";
					if(this.getCurrentLoggedPortalId() == 2) {
						var structure = this.getStudentcaptureattendancestructure();
						studentAttendanceType = structure.down('#newAttendanceTypeRadio').getValue().newAttendanceTypeWise;
						attendanceType = structure.down('#newAttendanceTypeRadio').getValue().newAttendanceTypeWise;
					} else {
						studentform = this.getMarkattendancemasterstructure().getForm();
						studentAttendanceType = studentform.findField('attendanceType').getValue();
						attendanceType = studentform.findField('attendanceType').getValue();
					}
	        	 
						if(studentAttendanceType == 'Complete Day' || studentAttendanceType == 'COMPLETE_DAY'){
							
				        	   
				        	   var form = form1.getForm();
				        	   
				        	   var programName = form.findField('PROGRAM_NAME').getRawValue();
				        	   var batchName = form.findField('BATCH_NAME').getRawValue();
				        	   var periodName = form.findField('PERIOD_NAME').getRawValue();
				        	   var sectionName = form.findField('sectionId').getRawValue();
				        	   var sectionId = form.findField('sectionId').getValue();
				        	   var facultyId = form.findField('facutly').getRawValue();
				        	   var sdoa = form.findField('dateOfAttendance').getValue();
				        	   var edoa = form.findField('consolidateEndDate').getValue();
				        	   var academyLocationId = this.getCurrentAcademyLocation();
				        	   var programId =  form.findField('PROGRAM_NAME').getValue();
				        	   var batchId =  form.findField('BATCH_NAME').getValue();
				        	  
				        	   sdoa = Ext.Date.format(sdoa,'Y-m-d');
				        	   edoa = Ext.Date.format(edoa,'Y-m-d');
				        	   
					        	var csvForm = Ext.create('Ext.form.Panel'); 
					    		csvForm.getForm().submit({
					    			target: '_blank',
					    			method:'POST',
					    			params :{
					    				access_token : Ext.Ajax.defaultHeaders.access_token,
					    				alname:academyLocationId,
					    				programName:programName,
					    				batchName:batchName,
					    				period:periodName,
					    				sectionID:sectionId,
					    				section:sectionName,
					    				faculty:facultyId,
					    				AttendanceType:attendanceType,
					    				sdoa:sdoa,
					    				edoa:edoa,
					    				programId:programId,
					    				batchId:batchId
					    			},
					    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
					    			url: SERVERURL.COMPLETE_ATTENDANCE,
					    			standardSubmit :true
					    		});
					    		
					    		 Ext.defer(function() {
					    			 var $this = this;
						    		 var grid = $this.getImportutilityattendancelist();
							    		grid.getStore().getProxy().extraParams = {
							    			moduleName:'IMPORT_MODULE_ATTENDANCE'
							    		};
							    		grid.getStore().load();
			         	        }, 2000, this);
						}
					
				
						if(studentAttendanceType =='Multiple Session' || studentAttendanceType =='MULTIPLE_SESSION'){
							
				        	   var form = form1.getForm();
				        	   var programName = form.findField('PROGRAM_NAME').getRawValue();
				        	   var batchName = form.findField('BATCH_NAME').getRawValue();
				        	   var periodName = form.findField('PERIOD_NAME').getRawValue();
				        	   var sectionName = form.findField('sectionId').getRawValue();
				        	   var sectionId = form.findField('sectionId').getValue();
				        	   var facultyId = form.findField('facutly').getRawValue();
				        	   var sdoa = form.findField('dateOfAttendance').getValue();
				        	   var edoa = form.findField('consolidateEndDate').getValue();
				        	   var academyLocationId = this.getCurrentAcademyLocation();
				        	   var programId =  form.findField('PROGRAM_NAME').getValue();
				        	   var batchId =  form.findField('BATCH_NAME').getValue();
				        	  
					        	var csvForm = Ext.create('Ext.form.Panel'); 
					    		csvForm.getForm().submit({
					    			target: '_blank',
					    			method:'POST',
					    			params :{
					    				access_token : Ext.Ajax.defaultHeaders.access_token,
					    				alname:academyLocationId,
					    				programName:programName,
					    				batchName:batchName,
					    				period:periodName,
					    				sectionID:sectionId,
					    				section:sectionName,
					    				faculty:facultyId,
					    				AttendanceType:attendanceType,
					    				sdoa:sdoa,
					    				edoa:edoa,
					    				programId:programId,
					    				batchId:batchId,
					    				sessionNumber:sessionNumber
					    			},
					    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
					    			url: SERVERURL.MULTIPLE_SESSION_ATTENDANCE,
					    			standardSubmit :true
					    		});
					    		
					    		 Ext.defer(function() {
					    			 var $this = this;
						    		 var grid = $this.getImportutilityattendancelist();
							    		grid.getStore().getProxy().extraParams = {
							    			moduleName:'IMPORT_MODULE_ATTENDANCE'
							    		};
							    		grid.getStore().load();
			         	        }, 2000, this);
						}
			
	           },
	           programBatchUploadAttendance:function(){
	        	   var $this = this;
				   var importUtilityController=$this.getController('Academia.controller.importutility.ImportUtilityController');
				   importUtilityController.getOpenImportUtilityWin();
				   var form=$this.getImportUtilityWinForm();
				   var moduleName = form.down('#moduleName');
				   var store = moduleName.getStore();
				   store.load({
            		   callback: function(records, operation, success) {
            			   if (success) {
            				   if(records.length > 0){
            					   moduleName.setValue(records[1].data.id);
            				   }		 
            			   }
            		   }	   
            	   });
				   
			   
	           },
	    //*******************Export to Pdf and Excel********************************   
	           exportUserListFaculty : function(exportUrl,filetype,whetherAll) {
	        	   var quickSearchForm=this.getFacultyattendance(); 
	        	   var searchResultGrid = this.getSearchresultgrid();
	        	   var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
	        	   var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	        	   var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	        	   var visibleColumns=this.getVisibleColumns(searchResultGrid);
	        	   var reportTitle=getCommonTranslation("USER_LIST");
	        	   if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
	        		   jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	        	   }
	        	   searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

	           },
	           exportUserListStudent : function(exportUrl,filetype,whetherAll) {
	        	   var quickSearchForm=this.getStudentattendance(); 
	        	   var searchResultGrid = this.getSearchresultgrid();
	        	   var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
	        	   var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	        	   var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	        	   var visibleColumns=this.getVisibleColumns(searchResultGrid);
	        	   var reportTitle=getCommonTranslation("USER_LIST");
	        	   if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
	        		   jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	        	   }
	        	   searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

},
createSearchCriteriaString: function(searchForm) {
	var me=this;
	var formValues = new Array();
	formValues = searchForm.getValues();        
	var searchCriteriaString="";
	for (var key in formValues) {
		var value = formValues[key];            
		if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
			var keyValueJsonObject = me.getJsonObject( key , value);
			searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
		}
	}
	searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	return searchCriteriaString;
},

					/** Download upload form change **/

					downloadUploadFormChange : function(cb, nv, ov){
						var $this = this;
						var mainStruct = this.getStudentattendanceuploaddownloadstructure();
						var importGrid = $this.getImportutilityattendancelist();
						var downloadTemplateForm = $this.getDownloadattendanceform();
						var uploadTemplateForm = $this.getUploadattendanceform();
						
						if(nv.downloadUploadTemplate == 'forDownloadTemplate'){

							uploadTemplateForm.hide();
							downloadTemplateForm.show();
							importGrid.setVisible(false);

						}else{
							 var portalId = $this.getCurrentLoggedPortalId();
				     		   if(portalId==2){
				     			   $this.doAccessControlValidationForLoader(uploadTemplateForm,this.getFACULTY_PORTAL_LOADER_PERMISSIONS());
				     		   }else if(portalId==1){
				     			   $this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
				     		   }
				     		   var uploadoptionradiogroupform  = $this.getAttendanceuploadoptionradiogroup();
				     		   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
				     			   isUploadAll: false
				     		   });
							downloadTemplateForm.hide();
							uploadTemplateForm.show();
							importGrid.setVisible(true);
							uploadTemplateForm.down('#moduleName').getStore().load({
								callback:function(recprds, success){
									for(var i in recprds){
										if(recprds[i].data.value=="Bulk Mark Attendance"){
											uploadTemplateForm.down('#moduleName').setValue(recprds[i].data.id);
											uploadTemplateForm.down('#moduleName').setReadOnly(true);
										}
									}
								}
							});
						}
					},
					
					
					/** Download service level upload form change **/

					downloadServiceLevelUploadFormChange : function(cb, nv, ov){
						var $this = this;
						var importGrid = $this.getImportutilityservicelevelattendancelist();
						var downloadTemplateForm = $this.getDownloadservicelevelattendanceform();
						var uploadTemplateForm = $this.getUploadservicelevelattendanceform();
						var downloadButton = downloadTemplateForm.down('#downoladBtnId');
						var isValid=true;
		 				var fieldsArray=[
		 					downloadTemplateForm.down('#serviceId'),
		 					downloadTemplateForm.down('#serviceProgramId'),
		 					downloadTemplateForm.down('#serviceProgramBatchId'),
		 					downloadTemplateForm.down('#dateOfAttendance_Id'),
		 					downloadTemplateForm.down('#consolidateEndDate_Id')
		 				];
		 				
						if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
							uploadTemplateForm.hide();
							downloadTemplateForm.show();
							importGrid.setVisible(false);
							Ext.each(fieldsArray,function(field){
			 					if(field.isVisible()&& !field.allowBlank && isNullOrEmpty(field.getValue())){
			 						isValid=false;
			 					}
			 				});
			 				
			 				if(isValid){
			 					downloadButton.setDisabled(false);	
			 				}else{
			 					downloadButton.setDisabled(true);
			 				}
						}else{
							 var portalId = $this.getCurrentLoggedPortalId();
				     		   if(portalId==2){
				     			   $this.doAccessControlValidationForLoader(uploadTemplateForm,this.getFACULTY_PORTAL_LOADER_PERMISSIONS());
				     		   }else if(portalId==1){
				     			   $this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
				     		   }
				     		   var uploadoptionradiogroupform  = $this.getAttendanceuploadoptionradiogroup();
				     		   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
				     			   isUploadAll: false
				     		   });
							downloadTemplateForm.hide();
							uploadTemplateForm.show();
							importGrid.setVisible(true);
							uploadTemplateForm.down('#moduleName').getStore().load({
								callback:function(records, success){
									for(var i in records){
										if(records[i].data.value=="Bulk Service Attendance Upload"){
											uploadTemplateForm.down('#moduleName').setValue(records[i].data.id);
											uploadTemplateForm.down('#moduleName').setReadOnly(true);
										}
									}
								}
							});
						}
					},
					
					
					/** Check attendance type and disable combo **/
					
					disableCoboByAttendanceType : function(){
						
						/*var studentform = this.getStudentattendance().getForm();
						var attendanceType = studentform.findField('attendanceType').getValue();*/
						var studentForm = "";
						var attendanceType= "";
						if(this.getCurrentLoggedPortalId() == 2) {
							var structure = this.getStudentcaptureattendancestructure();
							var attendanceType = structure.down('#newAttendanceTypeRadio').getValue().newAttendanceTypeWise;
						} else {
							studentform = this.getMarkattendancemasterstructure().getForm();
							attendanceType = studentform.findField('attendanceType').getValue();
						}
						var downloadform = this.getDownloadattendanceform();
						
						if(attendanceType == 'COMPLETE_DAY') {
							downloadform.down('#program_ID').setDisabled(false);
						//	downloadform.down('#dateOfAttendance_Id').allowBlank=true;
							downloadform.down('#dateOfAttendance_Id').setVisible(true);
							//downloadform.down('#consolidateEndDate_Id').allowBlank=true;
							downloadform.down('#consolidateEndDate_Id').setVisible(true);
							
						}
						if(attendanceType == 'MULTIPLE_SESSION') {
							downloadform.down('#program_ID').setDisabled(false);
							//downloadform.down('#dateOfAttendance_Id').allowBlank=true;
							downloadform.down('#dateOfAttendance_Id').setVisible(true);
						    //downloadform.down('#consolidateEndDate_Id').allowBlank=true;
							downloadform.down('#consolidateEndDate_Id').setVisible(true);

						}
						if(this.getCurrentLoggedPortalId() == 2) {
							downloadform.down('#facutly_Id').setVisible(false);
							downloadform.down('#facutly_Id').setDisabled(true);
						}
					},
					
					getDownloadFile : function(documentId,fileType){

			        	if(!isNullOrEmpty(documentId)){
			        		var csvForm = Ext.create('Ext.form.Panel'); 
			        		csvForm.getForm().submit({
			        			target: '_blank',
			        			method:'POST',
			        			params :{
			        				access_token : Ext.Ajax.defaultHeaders.access_token
			        			},
			        			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
			        			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
			        			standardSubmit :true
			        		});
			        	}
			        },
			    
			        // Load Attendance summary grid
			        loadAttendanceSummary:function() {
			        	var this$ = this;
			        	var grid = this$.getStudentAttendancegrid();
			        	var store = grid.getStore();
			        	var models = grid.getStore().getRange();
			        	
			        	var preCount=0,absCount=0, other=0;
			        	for(var i =0; i<store.data.length;i++){
			        		if(models[i].data.present)
			        			preCount++;
			        		if(models[i].data.absent)
			        			absCount++;
			        		if(models[i].data.attendanceStatus)
			        			other++;
			        	}
			        	var gridCount = this$.getStudentattendancecountgrid();
			        	var  data = {
			        			totalStudent:store.data.length,
			        			totalPresent:preCount,
			        			totalAbsent:absCount,
			        			otherCount:other,
			        			presentPercent:parseFloat((preCount/store.data.length)*100).toFixed(2)+"%",
			        			absentPercent:parseFloat((absCount/store.data.length)*100).toFixed(2)+"%",
			        	};
			        	var gridStore =  gridCount.getStore();
			        	gridStore.removeAll();
			        	gridStore.loadRawData(data, true);
			        },
			        
			        loadCourseTopics:function(record) {
			        	var form = this.getStudentattendance();
			        	var courseField = form.down('#courseId');
			        	var values = courseField.getStore().findRecord('courseId',record).data;
			        	var courseId = values.courseId;
			        	var componentId = "";
			        	if(values.courseComponentId > 0) {
			        		courseId = values.parentCourseId;
			        		componentId = values.courseComponentId;
			        	}
			        	var topicField = form.down("#topicId");
			        	topicField.clearValue();     	
			        	var sessionId = form.down('#timetableSlotListId').getValue();
			        	var sessionIds = [];
			        	if(sessionId !=undefined && sessionId.length > 0){
	                		 for(var i in sessionId){
	                			 if(Ext.isObject(sessionId[i])){
	                				 sessionIds.push(sessionId[i].get("id"));
	                			 }else{
	                				 sessionIds.push(sessionId[i]);
	                			 }
	                		 }
	                	 }
			        	var topicStore = topicField.getStore();
			        	topicStore.getProxy().extraParams = {
			        		courseId: courseId,
			        		componentId: componentId,
			        		sessionId:sessionIds.join()
			        	};
			        	topicStore.load({
			        		callback: function(records, operation, success) {
			        			if (success) {
			        				var topicIds = [];
			        				if(records.length > 0 && sessionIds.length > 0 && sessionIds != ""){
			        					for(var i in records) {
			        						topicIds.push(records[i].data.id);
			        					}
			        				}
		        					topicStore.getProxy().extraParams = {
		    			        		courseId: courseId,
		    			        		componentId: componentId
		    			        	};
		    			        	topicStore.load({
		    			        		callback: function(records, operation, success) {
		    			        			if (success) {
		    			        				if(records.length > 0 && sessionIds.length > 0 && sessionIds != ""){
		    			        					topicField.setValue(topicIds);
		    			        				}
		    			        			}
		    			        		}
		    			        	});
			        			}
			        		}
			        	});
			        },
			        deleteTimeSlotContainer: function(deleteButton) {
			            var this$ = this;
			            var form = this$.getStudentattendance();
			            var timeSlotPanel = form.down('#panelId');
			            var container = deleteButton.up('fieldcontainer');

			            if (container != null && timeSlotPanel != null) {
			                if (timeSlotPanel.items.length > 1) {
			                	timeSlotPanel.remove(container);
			                    this$.hideShowSubjectMarksElement(timeSlotPanel);
			                }
			            }
			            if(form.isValid()){
			            	form.down('#searchBtn').setDisabled(false);
			            }else{
			            	form.down('#searchBtn').setDisabled(true);
			            }
			        },
			        hideShowSubjectMarksElement: function(timeSlotPanel) {
			            var this$ = this;
			            var form = this$.getStudentattendance();
			            timeSlotPanel.items.each(function(item, index, items) {
			                var addButton = item.getComponent(item.items.length - 1);
			                if (index == (items - 1)) {
			                    if (addButton != null) {
			                        addButton.show();
			                    }
			                } else {
			                    if (addButton != null) {
			                        addButton.hide();
			                    }
			                }
			            });
			        },
			        setTabsVisibility:function(tab2, tab3, structure,tab4,attendanceType,permissionList,tab5) {
			        	var panelItem = new Array();
			        	var $this = this;
			        	var newcont=structure.items.items.length;
			        	var insertPosition=newcont+1;
			        	var importOption = false;
			        	
			        	if(tab2 || tab3 || tab4 || tab5){
			        		importOption = true;
			        	}
			        	
			        	panelItem.push({
			        		xtype:'tabpanel',
			        		itemId:'allVisibleTP',
			        		plain: true,
			        		style:{overflow:'hidden !important',margin:'0!important'},
			        		bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
			        		frame: false,
			        		border:false,
			        		defaults: {
			        			labelAlign: 'top'
			        		},
			        		items:[{
			        			xtype: 'attendancestructure',
			        			title: getCommonTranslation('SEARCH'),
			        			tabCls: 'right-tab'
			        		}]
			        	});
			        	
			        	insertPosition = insertPosition + 1;
			        	if (importOption) {
			        		panelItem["0"].items[insertPosition] = {
			        				xtype : 'attendanceImportStructure',
			        				title : getCommonTranslation('Import')
			        		};
			        		insertPosition = insertPosition + 1;
			        	}

			        	structure.insert(insertPosition,panelItem);
			        	Ext.defer(function() {
			        		//$this.getSessionValues(structure);
			        		var activeTab = Ext.ComponentQuery.query('contentPanel')[0].getActiveTab();
			        		var studentpncattendancestructure = activeTab.down('studentpncattendancestructure');
			        		var attendanceTypeRadio= studentpncattendancestructure.down('#attendanceTypeRadio');
			        		attendanceTypeRadio.setVisible(false);
			        		var completeDay=false;//tab2
			        		var multipleSession=false;//tab4
			        		var courseLevel=false;//tab3
			        		var serviceLevel=false;//tab5
			        		
			        		if((Ext.Array.contains(permissionList, 'PROGRAM_WISE')) &&(Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
				        			completeDay=true;
	        					}
        					  if((Ext.Array.contains(permissionList, 'SESSION_WISE'))&&(Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
        						multipleSession=true;
        					  }
        					  if((Ext.Array.contains(permissionList, 'COURSE_WISE'))&&(Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
        						courseLevel=true;
        					  }
        					  
        					  if((Ext.Array.contains(permissionList, 'SERVICE_WISE'))&&(Ext.Array.contains(attendanceType, 'SERVICE_LEVEL') || Ext.Array.contains(attendanceType, 'Service Level'))){
        						 serviceLevel=true;
          					  }
        					  
        					  if(!completeDay && !multipleSession && !courseLevel && !serviceLevel){
        						  completeDay=true;
        					  }
			        		
			        		if (completeDay && courseLevel && multipleSession && serviceLevel) {
			        			attendanceTypeRadio.setVisible(true);
			        			attendanceTypeRadio.items.items[0].setValue(true);
			        			attendanceTypeRadio.items.items[1].setValue(false);
			        			attendanceTypeRadio.items.items[2].setValue(false);
			        			attendanceTypeRadio.items.items[3].setValue(false);
                            }else if (completeDay && courseLevel && serviceLevel && !multipleSession) {
                            	attendanceTypeRadio.setVisible(true);
                            	attendanceTypeRadio.items.items[2].setVisible(false);
                            	attendanceTypeRadio.items.items[1].setValue(false);
                            	attendanceTypeRadio.items.items[0].setValue(true);
                            	attendanceTypeRadio.items.items[3].setValue(false);
                            }else if (courseLevel && multipleSession && serviceLevel && !completeDay) {
                            	attendanceTypeRadio.setVisible(true);
                            	attendanceTypeRadio.items.items[2].setValue(false);
                            	attendanceTypeRadio.items.items[1].setValue(true);
                            	attendanceTypeRadio.items.items[0].setVisible(false);
                            	attendanceTypeRadio.items.items[3].setValue(false);
                            }else if (multipleSession && completeDay && serviceLevel && !courseLevel) {
                            	attendanceTypeRadio.setVisible(true);
                            	attendanceTypeRadio.items.items[2].setValue(false);
                            	attendanceTypeRadio.items.items[1].setVisible(false);
                            	attendanceTypeRadio.items.items[0].setValue(true);
                            	attendanceTypeRadio.items.items[3].setValue(false);
                            }else if (multipleSession && completeDay && courseLevel && !serviceLevel ) {
                            	attendanceTypeRadio.setVisible(true);
			        			attendanceTypeRadio.items.items[0].setValue(true);
			        			attendanceTypeRadio.items.items[1].setValue(false);
			        			attendanceTypeRadio.items.items[2].setValue(false);
			        			attendanceTypeRadio.items.items[3].setVisible(false);
                            }else if (completeDay && courseLevel && !serviceLevel && !multipleSession) {
                            	attendanceTypeRadio.setVisible(true);
                            	attendanceTypeRadio.items.items[2].setVisible(false);
                            	attendanceTypeRadio.items.items[1].setValue(false);
                            	attendanceTypeRadio.items.items[0].setValue(true);
                            	attendanceTypeRadio.items.items[3].setVisible(false);
                            }else if (!courseLevel && multipleSession && serviceLevel && !completeDay) {
                            	attendanceTypeRadio.setVisible(true);
                            	attendanceTypeRadio.items.items[2].setValue(true);
                            	attendanceTypeRadio.items.items[1].setVisible(false);
                            	attendanceTypeRadio.items.items[0].setVisible(false);
                            	attendanceTypeRadio.items.items[3].setValue(false);
                            }else if (multipleSession && completeDay && !serviceLevel && !courseLevel) {
                            	attendanceTypeRadio.setVisible(true);
                            	attendanceTypeRadio.items.items[2].setValue(false);
                            	attendanceTypeRadio.items.items[1].setVisible(false);
                            	attendanceTypeRadio.items.items[0].setValue(true);
                            	attendanceTypeRadio.items.items[3].setVisible(false);
                            }else if (multipleSession && !completeDay && courseLevel && !serviceLevel ) {
                            	attendanceTypeRadio.setVisible(true);
			        			attendanceTypeRadio.items.items[0].setVisible(false);
			        			attendanceTypeRadio.items.items[1].setValue(true);
			        			attendanceTypeRadio.items.items[2].setValue(false);
			        			attendanceTypeRadio.items.items[3].setVisible(false);
                            }else if (!multipleSession && completeDay && !courseLevel && serviceLevel ) {
                            	attendanceTypeRadio.setVisible(true);
                            	attendanceTypeRadio.items.items[0].setValue(true);
			        			attendanceTypeRadio.items.items[1].setVisible(false);
			        			attendanceTypeRadio.items.items[2].setVisible(false);
			        			attendanceTypeRadio.items.items[3].setValue(false);
                            }else if (!multipleSession && !completeDay && courseLevel && serviceLevel ) {
                            	attendanceTypeRadio.setVisible(true);
                            	attendanceTypeRadio.items.items[0].setVisible(false);
			        			attendanceTypeRadio.items.items[1].setValue(true);
			        			attendanceTypeRadio.items.items[2].setVisible(false);
			        			attendanceTypeRadio.items.items[3].setValue(false);
                            }else if(completeDay){
			        			attendanceTypeRadio.items.items[0].setValue(true);
			        			attendanceTypeRadio.items.items[1].setValue(false);
			        			attendanceTypeRadio.items.items[2].setValue(false);
			        			attendanceTypeRadio.items.items[3].setValue(false);
			        		}else if(courseLevel){
			        			attendanceTypeRadio.items.items[0].setValue(false);
			        			attendanceTypeRadio.items.items[1].setValue(true);
			        			attendanceTypeRadio.items.items[2].setValue(false);
			        			attendanceTypeRadio.items.items[3].setValue(false);
			        		}else if(multipleSession){
			        			attendanceTypeRadio.items.items[0].setValue(false);
			        			attendanceTypeRadio.items.items[1].setValue(false);
			        			attendanceTypeRadio.items.items[2].setValue(true);
			        			attendanceTypeRadio.items.items[3].setValue(false);
			        		}else if(serviceLevel){
			        			attendanceTypeRadio.items.items[0].setValue(false);
			        			attendanceTypeRadio.items.items[1].setValue(false);
			        			attendanceTypeRadio.items.items[2].setValue(false);
			        			attendanceTypeRadio.items.items[3].setValue(true);
			        		}
			        	}, 500, this);
			        	
			        },
			        getIdValueJson: function(id, value,code) {
	                	 if (id) return {
	                		 id: id,
	                		 value: value,
	                		 code: code
	                	 };
	                 },
	                 changeStatusOnLoad:function(attendanceStatus, isMarkingType){
	  	        	   var grid = this.getStudentAttendancegrid();
	  	        	   var store = grid.getStore();
	  	        	   var present=false,absent=false,attStatus=null;
	  	        	   var prePercent='0%', absPercent='0%';
	  	        	   var abs=0,pre=0,oth=0;
	  	        	   if (attendanceStatus == 'PRESENT' || attendanceStatus == 'Present') {
	  	        		   present = true;
	  	        		   absent = false;
	  	        		   attStatus = null;
	  	        	   } else if (attendanceStatus == 'ABSENT' || attendanceStatus == 'Absent') {
	  	        		   attStatus = null;
	  	        		   present = false;
	  	        		   absent = true;
	  	        	   } else if (attendanceStatus == 'LEAVE' || attendanceStatus == 'Leave') {
	  	        		   attStatus = "Leave";
	  	        		   present = false;
	  	        		   absent = false;
	  	        	   } else if (attendanceStatus == 'SICK_LEAVE' || attendanceStatus == 'Leave') {
	  	        		   attStatus = "Leave";
	  	        		   present = false;
	  	        		   absent = false;
	  	        	   }

	  	        	   var attendanceMarkingType = this.getIdValueJson(3);
	  	        	   store.suspendEvents();   
	  	        	   store.each(function(rec) {
	  	        			 if(isNullOrEmpty(rec.data.attendanceStatus)){
		  	  	        		 if(!isNullOrEmpty(rec.data.leaveStatus) && rec.data.leaveStatus == 'Absent'){
			  	        			 rec.set('present', false);
				  	        		 rec.set('absent', true);
				  	        		 rec.set('attendanceStatus', null);
				  	        		 abs++;
			  	        			 
			  	        		 } else if(!isNullOrEmpty(rec.data.leaveStatus) && rec.data.leaveStatus == 'Leave'){
			  	        			 rec.set('present', false);
				  	        		 rec.set('absent', false);
				  	        		 rec.set('attendanceStatus', "Leave");
				  	        		 rec.set('attendanceMarkStatus', "ABSENT");
				  	        		 rec.set('attendanceMarkingType', attendanceMarkingType.id);
				  	        		 oth++;
			  	        			 
			  	        		 } else{
			  	        			rec.set('present', present);
				  	        		rec.set('absent', absent);
				  	        		rec.set('attendanceStatus', attStatus);
				  	        		if(present){
				  	        			pre++;
				  	        		} else if(absent){
				  	        			abs++;
				  	        		} else {
				  	        			oth++;
				  	        		}
				  	        		
			  	        		 }
		  	        		   }
		  	        		   else{
		  	        			   if(rec.data.markingType == "PRESENT"){
		  	        					pre++;
		  	        					rec.set('present', true);
					  	        		rec.set('absent', false);
		  	        			   }
		  	        			   else if(rec.data.markingType == "ABSENT"){
		  	        				   abs++;
		  	        				   rec.set('present', false);
		  	        				   rec.set('absent', true);
		  	        			   }
		  	        			   else{
			  	        			   oth++;
			  	        			   rec.set('present', false);
		  	        				   rec.set('absent', false);
		  	        				   rec.set('attendanceMarkingType', attendanceMarkingType.id);
		  	        			   }
		  	        		   }
	  	        		  // }
	  	        	   });
	  	        	   store.resumeEvents();
	  	        	   grid.getView().refresh();

	  	        	   var gridCount = this.getStudentattendancecountgrid();
	  	        	   var data = {
	          			   totalStudent:store.data.length,
	          			   totalPresent:pre,
	          			   totalAbsent:abs,
	          			   otherCount:oth,
	          			   presentPercent:parseFloat((pre/store.data.length)*100).toFixed(2)+"%",
            			   absentPercent:parseFloat((abs/store.data.length)*100).toFixed(2)+"%",
	  	        	   };
	  	        	   var gridStore =  gridCount.getStore();
	  	        	   if(store.data.length!=0){
	  	        		   gridStore.removeAll();
	  	        		   gridStore.loadRawData(data, true);
	  	        	   }
	  	           },
                   generateQrButtonPrivileges:function(form,permissionMap,attendanceType){
	                    var associatedAcadLocationIds = new Array();
                        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
                        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
						
						var generateQRProgramWise = form.down('#GenrateQR');
                        generateQRProgramWise.setVisible(false);

                         Ext.each(permissionList, function(privilege) {
                            
                            if (privilege == 'GENERATE_QR_PROGRAM_WISE' && attendanceType=='COMPLETE_DAY') {
                                if(!isNullOrEmpty(generateQRProgramWise)){
                                    generateQRProgramWise.setVisible(true);
                                }                
                            }
                            if (privilege == 'GENERATE_QR_COURSE_WISE' && attendanceType=='COURSE_LEVEL') {
                                if(!isNullOrEmpty(generateQRProgramWise)){
                                    generateQRProgramWise.setVisible(true);
                                }                
                            }
						   if (privilege == 'GENERATE_QR_SESSION_WISE' && attendanceType=='MULTIPLE_SESSION') {
                                if(!isNullOrEmpty(generateQRProgramWise)){
                                    generateQRProgramWise.setVisible(true);
                                }                
                            }
                        });
},
	  	         validateAttendanceSearchForm: function(){

	 				var form = this.getStudentattendance();
	 				var searchButton=form.down('#searchBtn');
	 				var genrateQr=form.down('#GenrateQR');
	 				
	 				var isValid=true;
	 				var fieldsArray=[
	 					form.down('#programBatch_programId'),
	 					form.down('#programBatch_batchId'),
	 				    form.down('#periodIdItemId'),
	 				    form.down('#programCoursection_ID'),
	 				    form.down('#facutlyId'),
	 				    form.down('#dateOfAttendance_Id')
	 				];
	 				
	 				Ext.each(fieldsArray,function(field){
	 					if(field.isVisible()&& !field.allowBlank && isNullOrEmpty(field.getValue())){
	 						isValid=false;
	 					}
	 				});
	 				
	 				if(isValid){
	 					searchButton.setDisabled(false);	
	 					genrateQr.setDisabled(false);	
	 				}else{
	 					searchButton.setDisabled(true);
	 					genrateQr.setDisabled(true);	
	 				}

	 			
	  	         },
	  	         
	  	         downloadQRDivAsImage: function(win) {
	  	        	 // Check if the window and body ID are valid
	  	        	 if (!win || !win.body || !win.body.id) {
	  	        		 return;
	  	        	 }

	  	        	 // Retrieve the body ID and QR data
	  	        	 var bodyId = win.down('#mainQRPanal').body.id;
	  	        	 var qrRawData = win.qrData;

	  	        	 // Check if qrData is valid and decoded
	  	        	 var qrData;
	  	        	 try {
	  	        		 qrData = Ext.decode(qrRawData);
	  	        	 } catch (e) {
	  	        		 return;
	  	        	 }

	  	        	 // Check if the div with the bodyId exists
	  	        	 var original = document.getElementById(bodyId);
	  	        	 if (!original) {
	  	        		 return;
	  	        	 }

	  	        	 // Ensure the window is open (you can define your own condition for checking this)
	  	        	 if (win.isClosed || !win.isVisible()) {
	  	        		 return;
	  	        	 }

	  	        	 // Now, proceed with the html2canvas capture
	  	        	 html2canvas(original).then(function(canvas) {
	  	        		 var link = document.createElement("a");
	  	        		 link.href = canvas.toDataURL("image/png");
	  	        		 link.download = qrData.attendanceType + "-" + qrData.qrId + "-QRImg.png";
	  	        		 link.click();
	  	        	 });
	  	         },
	  	         
	  	       getOpenAttendanceImport: function(treePanel, record, item, index, e, eOpts) {
	  	    	    var $this = this;
	  	    	    var containpanel = $this.getAttendanceImport();
	  	    	    var treePanel = containpanel.down('#attendanceImportTreePanelItemId');
	  	    	    var tabDetail = record.data;
	  	    	    var structure = Ext.widget(tabDetail.reportXtype);
	  	    	    var tabstructure = containpanel.down('#tabpanelIds');

	  	    	  if (!isNullOrEmpty(tabDetail.text)
							&& !isNullOrEmpty(tabDetail.reportXtype)
							&& !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
						treePanel.toggleCollapse();
						openTab(tabstructure, tabDetail.text,structure);
						treePanel.getSelectionModel().deselectAll();
					}
	  	    	}
	});
