/**
 * @author Raj Kumar
 * @author seshagiri.k
 */
Ext.define('Academia.controller.course.CourseListController', {
    extend: 'Academia.controller.base.BaseController',
    models: ['course.CourseMasterGridModel', 'course.NoOfProgAssoGridModel',
             'course.NoOfRegCourseGroupAssoGridModel', 'course.NoOfAuditCourseGroupAssoGridModel',
             'course.NoOfRegCourseGroupAssoGridModel', 'course.NoOfCourseVariantAssoGridModel','course.CourseDocument','Academia.model.common.succeedingCourseDataModel'],
    stores: ['course.CourseMasterGridStore', 'course.NoOfProgAssoGridStore','course.SectionTypeStore',
             'course.NoOfRegCourseGroupAssoGridStore', 'course.NoOfAuditCourseGroupAssoGridStore',
             'course.NoOfCourseSpecializationAssoGridStore', 'course.NoOfCourseVariantAssoGridStore','course.CourseDocument',
             'program.programDetails.programBatches.courseParameter.ProgramCourseAssign','course.CourseNQFLevelStoreFromCSM','course.CourseCESMCodeStoreFromCSM',
             'coursetransaction.studymaterialdistribution.CoursesAllSmartSearch','course.NoOfProgAssociatedGridStore',
             'course.CourseCategoryStore','course.CourseDocument','course.VariantDetailsStore', 'importutility.ImportCourseCreationStore', 
             'importutility.ModuleName','course.coursespecialization.CourseSpecializationProgram','course.academyLocation.MappedCourseAcademyLocationStore',
             'examinationcenters.evaluation.applyrule.CalculationBussinessRule','course.NoOfCoursesDepartmentsGridStore','Academia.store.course.succeedingCourseStore',
             'coursetransaction.studymaterialdistribution.FindAllCoursesByAcademyLocation'],
    views: ['course.CreateCourseForm', 'course.CourseMasterGrid', 'course.CourseGrid',
            'baselayout.contentarea.ContentPanel', 'course.NoOfAuditGrpGridWindow',
            'course.NoOfCourseSpclAssoGridWindow', 'course.NoOfProgAssoGridWindow',
            'course.NoOfRegCourseGrpAssoGrid', 'course.NoOfVariantGridWindow',
            'course.NoOfRegCourseGrpAssoGridWindow', 'course.CourseAdvSearchListing',
            'course.CourseMasterQuickFilter','course.NoOfVariantGrid','course.CourseTabStructure',
            'course.coursegroup.NoOfAssociatedCourse','course.NoOfProgAssociatedWindow','course.NoOfProgAssociatedGrid','course.CourseDocumentList',
            'course.CourseVariantDetailsList', 'course.uploaddownload.CourseCreationDownloadForm',
            'course.uploaddownload.CourseCreationUploaddownloadStructure', 'course.uploaddownload.CourseCreationUploadForm',
            'importutility.ImportByModule.ImportListCourseCreation','course.NoOfCourseSpclAssoGrid','course.coursespecialization.CourseSpecializationProgram',
            'course.coursegroup.NoOfProgram','course.NoOfCourseAcademyLocationWindow','course.NoOfCourseAcademyLocationGrid','course.CourseLinkDetails',
            'UploadOptionRadioGroup','course.NoOfCoursesDepartmentWindow','course.NoOfCoursesDepartmentGrid','course.CourseParentPanel'],
    config:{
    	   /*
       	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
        		   	 */
        	   	/**
        	        * @cfg {Array} COURSE_PERMISSIONS array (required)
        	        * The array of permissions to use for Access control wise enabling and disabling buttons.
        	        * @accessor
        	        */
     COURSE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_PRIVILEGES'),  		  
	 CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES')
},        
    refs: [{
        ref: 'basicdetailform',
        selector: 'basicdetailform'
    }, {
        ref: 'courselistgrid',
        selector: 'courselistgrid'
    }, {
        ref: 'contentpanel',
        selector: 'contentpanel'
    }, {
        ref: 'coursemastergrid',
        selector: 'coursemastergrid'
    }, {
        ref: 'noofprogassogridwindow',
        selector: 'noofprogassogridwindow'
    }, {
        ref: 'coursetabstructure',
        selector: 'coursetabstructure'
    }, {
        ref: 'createcourseform',
        selector: 'createcourseform'
    }, {
        ref: 'noofregcoursegrpassogridwindow',
        selector: 'noofregcoursegrpassogridwindow'
    }, {
        ref: 'noofauditgrpgridwindow',
        selector: 'noofauditgrpgridwindow'
    }, {
        ref: 'noofcoursespclassogridwindow',
        selector: 'noofcoursespclassogridwindow'
    }, {
        ref: 'noofvariantgridwindow',
        selector: 'noofvariantgridwindow'
    }, {
        ref: 'searchresultgrid',
        selector: 'searchresultgrid[itemId=coursemastergrid]'
    },{
        ref: 'courseadvsearchlisting',
        selector: 'courseadvsearchlisting'
    }, {
        ref: 'courseMasterQuickFilter',
        selector: 'courseMasterQuickFilter'
    },{
        ref: 'noofprogassociatedwindow',
        selector: 'noofprogassociatedwindow'
    },{
 	   ref:'coursedocumentlist',
	   selector:'coursedocumentlist[itemId=coreERPCourseDocumentList]'
   },{
 	   ref:'courseDocumentList',
	   selector:'coursedocumentlist grid'
   },{
 	   ref:'courseVariantDetailsList',
	   selector:'coursevariantdetailslist grid'
   },{
 	   ref:'coursevariantdetailslist',
	   selector:'coursevariantdetailslist'
   },{
 	   ref:'importlistcoursecreation',
	   selector:'importlistcoursecreation'
   },{
 	   ref:'noofcoursespclassogrid',
	   selector:'noofcoursespclassogrid'
   },{
 	   ref:'coursespecializationprogram',
	   selector:'coursespecializationprogram'
   },{
 	   ref:'noofprogram',
	   selector:'noofprogram'
   },{
 	   ref:'noofregcoursegrpassogrid',
	   selector:'noofregcoursegrpassogrid'
   },{
 	   ref:'noofcourseacademylocationwindow',
	   selector:'noofcourseacademylocationwindow'
   },{
 	   ref:'noofcourseacademylocationgrid',
	   selector:'noofcourseacademylocationgrid'
   },{
 	   ref:'courselinkdetails',
	   selector:'courselinkdetails'
   },{
  	 ref : 'uploadoptionradiogroup',
	 selector : 'uploadoptionradiogroup[itemId=coursecreationUploadOptionRadioGroupItemId]'
 },{
  	 ref : 'noofcoursesdepartmentwindow',
	 selector : 'noofcoursesdepartmentwindow'
 },{
  	 ref : 'noofcoursesdepartmentgrid',
	 selector : 'noofcoursesdepartmentgrid'
 }],
   
    init: function() {

        this.control({
        	'courseMasterQuickFilter':{
        		  render: function(grid){
        			   var searchForm = this.getCourseMasterQuickFilter();
    				   var searchStore = searchForm.down("#courseNameQuickFiltr").getStore();
    				   var courseDepartmentStore= searchForm.down("#courseDepartment").getStore();
    				   var user=this.getCurrentlyLoggedInUser();
    				   var locations = [];
    				  if(user.code!="sysadmin"){
                  		var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
                  		for(var i=0; i<academyLocationList.length; i++){
                  			locations.push(academyLocationList[i].id);
                  		}
    				  }        			
        			  searchStore.getProxy().extraParams = {
        				   academyLocationList: locations.join(),
        				   limit :1000
      				 };
        			  
        			  searchStore.load();
        			  
        			  courseDepartmentStore.getProxy().extraParams = {
       				   academyLocationList: locations.join()
     				 };
       			  
        			  courseDepartmentStore.load();
                    
                 }
               },
        	
        	'courseadvsearchlisting':{
   			 beforerender : function(structure){
   				 Ext.suspendLayouts();
   				 this.showHideCourseTabs(structure, this.getCOURSE_PERMISSIONS());
   				 Ext.resumeLayouts();
   			 },
   			afterrender:function(structure){
    			var grid = structure.down('#coursemastergrid');
    			this.getCBGridHeaderFreeze(grid,structure, false);
    		}
            },
        	'courselistgrid':{
        		afterrender:function(structure){
        			var me=this;
        			var grid = structure.down('#coursemastergrid');
        			this.getCBGridHeaderFreeze(grid,structure);
        			me.addDataGridConfigButton(grid, this.getCOURSE_PERMISSIONS());
        		}
        	},
            'courseMasterQuickFilter button[itemId=courseQuickSearchId]': {
                click: this.loadGridAndSearchCourses
            },
            'courseMasterQuickFilter button[itemId=courseQuickResetId]': {
                click:function(){
                	this.getCourseMasterQuickFilter().getForm().reset();
                }
            },
            'searchresultgrid[itemId=coursemastergrid]': {
                render: function(grid){
                	 var permissionsMap = new Ext.util.HashMap();
                     this.gridRenderFunction(grid);
                    permissionsMap = this.getCOURSE_PERMISSIONS();
                    this.genericCBGridAccessControlValidation(grid,permissionsMap);
                },
                cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
                	
                	  var searchResultGrid = this.getSearchresultgrid();
                      var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
                	
                	 if(columnName=='NO_OF_REG_COURSE_GROUP_ASSO'){
              		   this.linkNoOfReqCourse(grid, rowIndex, record);
              	     }
                	 
                	 if(columnName=='NO_OF_AUDIT_GROUP_ASSO'){ // checked
               		   this.linkNoOfAudit(grid, rowIndex, record);
               	      }
                     
                	 if(columnName=='NO_OF_COURSE_VARIANTS' && record.data.NO_OF_COURSE_VARIANTS > 0){ // checked
                		   this.linkNoOfVariants(grid, rowIndex, record);
                	  }
                	 if(columnName=='NO_OF_SPCL_GROUP'){ // checked
              		   this.linkNoSpclGroup(grid, rowIndex, record);
                	 }
                	 if(columnName=='PROG_ASSO_PROG_COURSE_COUNT'){
                		 this.linkProgramAssociated(grid, rowIndex, record);
                	 }
                	 if(columnName=='DOCUMENTS' && record.data.DOCUMENTS >0){
                		 this.linkNoOfCourseDocuments(grid, rowIndex, record);
                	 }
                	 if(columnName=='COURSE_ACADEMY_LOCATION_COUNT'){
                		 this.linkNoOfAcademyLocation(grid, rowIndex, record);
                	 }
                	 if(columnName=='NO_OF_COURSE_DEPARTMENTS'){ // checked
             			this.linkNoCoursesDepartments(grid, rowIndex, record);
             		}
                }
            },
            'advancedsearchquerybuilder[itemId=advancedsearchCourse] searchresultgrid[itemId=userAdvSearchResultGrid]': {
            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

            		var searchResultGrid = grid.panel;
            		var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

            		if(columnName=='NO_OF_REG_COURSE_GROUP_ASSO'){
            			this.linkNoOfReqCourse(grid, rowIndex, record);
            		}

            		if(columnName=='NO_OF_AUDIT_GROUP_ASSO'){ // checked
            			this.linkNoOfAudit(grid, rowIndex, record);
            		}
            		if(columnName=='DOCUMENTS' && record.data.DOCUMENTS >0){
            			this.linkNoOfCourseDocuments(grid, rowIndex, record);
            		}
            		if(columnName=='NO_OF_COURSE_VARIANTS'){ // checked
            			this.linkNoOfVariants(grid, rowIndex, record);
            		}
            		if(columnName=='NO_OF_SPCL_GROUP'){ // checked
            			this.linkNoSpclGroup(grid, rowIndex, record);
            		}
            		if(columnName=='NO_OF_COURSE_DEPARTMENTS'){ // checked
            			this.linkNoCoursesDepartments(grid, rowIndex, record);
            		}

            	}
            },
            'searchresultgrid[itemId=coursemastergrid] button[itemId=searchResultGridBtnAdd]': {
                click: function() {
                    this.openNewCourseTab();
                }
            },
            
            'searchresultgrid[itemId=coursemastergrid] button[itemId=searchResultGridBtnEdit]': {
                click: function() {
                    this.editCourseTab();
                }
            },
            
            'coursetabstructure tabpanel':{
            	afterrender: function(tabpanel){
            		var me = this;
            		var permissionsMap = me.getCOURSE_PERMISSIONS()
            		var associatedAcadLocationIds = new Array();
            		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
            		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

            		tabpanel.add({
            			title: getCommonTranslation('SUBJECT_DETAILS'),
            			xtype:'container',
            			items:[{
            				xtype:'basicdetailform',
            				closable: false
            			}]
            		},{		 
            			title: getCommonTranslation('COURSE_VARIANTS'),
            			xtype:'container',
            			items:[{
            				xtype: 'coursevariantstructure',
            				closable: false
            			}]
            		},{
        				title : getCommonTranslation('LINK_ACEDEMY_LOCATION'),
        				xtype:'container',
        				items:[{
        					xtype: 'academylocationstructure',
        					closable: false
        				}]
            		});

            		Ext.each(permissionList, function(privilege) {
            			if (privilege === 'COURSE_COMPONENT') {
            				tabpanel.add({
            					title: getCommonTranslation('COURSE_COMPONENT'),
            					xtype:'coursecomponentsgrid',
            					closable: false
            				});      		
            			}
            		});

            		tabpanel.add({
            			title : getCommonTranslation('COURSE_EQUIVANENCE'),
            			xtype: 'courseequivalencegrid',
            			closable: false
            		});
            		
            		setTimeout(function(){
            			tabpanel.setActiveTab(0);
            		},300);
            	}
            },
            
            'searchresultgrid[itemId=coursemastergrid] button[itemId=searchResultGridBtnView]': {
                click: function() {
                    this.viewCourseTab();
                    this.getCoursetabstructure().getForm().findField('courseViewMode').setValue('View');
                }
            },
            'searchresultgrid[itemId=coursemastergrid] button[itemId=searchResultGridBtnDelete]': {
                click: function() {
                    this.deleteCourseTab();
                }
            },
            //
            'searchresultgrid[itemId=coursemastergrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
	            }
	        },
	        'searchresultgrid[itemId=coursemastergrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
	            }
	        },
	        'searchresultgrid[itemId=coursemastergrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
	            }
	        },
	        'coursedocumentlist[itemId=coreERPCourseDocumentList] grid[itemId=coursedocumentlistId]':{
				  cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					  if (e.target.tagName == 'A') {
						  var documentId = record.get("documentId");
						  if (!isNullOrEmpty(documentId)) {
							  this.getDownloadFileForCourseDocument(documentId);
						  }
					  }
				  }  
			  },
			  //delete course doc
			  'coursedocumentlist grid[itemId=coursedocumentlistId] button[itemId=btnDelete]' : {
				  click : function() {
					  var $this = this;
					  var courselistgrid = this.getCourselistgrid();
					  var grid=$this.getCourseDocumentList();
					  if (grid.getSelectionModel().getCount() > 0) {
						  showConfirmMessage(getProgramandcourseTranslation('Document'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
								  function(btn,text) {
							  if (btn == 'yes') {
								  var records = grid.getSelectionModel().getSelection();
								  var id = records[0].get("id");
								  Ext.Ajax.request({
									  method : "DELETE",
									  type : 'rest',
									  url :  SERVERURL.COURSE_DOCUMENT_DELETE_DOCUMENT_URL+ '?id='+ id,
									  headers : {
										  'Content-Type' : 'application/json'
									  },
									  success : function(form,action) {
										  grid.getStore().reload();
										  courselistgrid.getStore().reload();
										  showSuccessMessage(getProgramandcourseTranslation('COURSE_DETAILS'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
									  }
								  });
							  }
						  });
					  } else {
						  showWarningMessage(getCommonTranslation('Document'), getCommonTranslation('PLEASE_SELECT_RECORD'));
						  }
				  }
			  },
	        'searchresultgrid[itemId=coursemastergrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
	            }
	        },
	        'noofvariantgridwindow grid[itemId=noofvariantgrid]':{
	        	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

	        		var formWindow = this.getNoofvariantgridwindow();
	        		if (e.target.tagName == 'A') {
	        			var totalParamterizedId = record.get("totalParamterized");
	        			if (!isNullOrEmpty(totalParamterizedId)) {
	        				this.getVariantDetails(record,grid);
	        			}
	        		}
	        	}
	        },
	        'coursecreationuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
	 			   change: this.courseCreationDownloadUploadFormChange
	 		},
	 		'coursecreationdownloadform button[itemId=resetBtn]':{
	 			click:function(obj){
	 				var $this = this;
	 				var form =obj.up('coursecreationdownloadform').getForm();
	 				form.reset();
	 			}  
	 		},
	 		'coursecreationdownloadform button[itemId=downoladBtnId]':{
	 			click:function(obj){
	 				var $this = this;
	 				var form =obj.up('coursecreationdownloadform').getForm();

	 				var csvForm = Ext.create('Ext.form.Panel'); 
	 				csvForm.getForm().submit({
	 					target: '_blank',
	 					method:'POST',
	 					params :{
	 						access_token : Ext.Ajax.defaultHeaders.access_token
	 					},
	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	 					url: SERVERURL.DOWNLOAD_TEMPLATE_COURSE_CREATION,
	 					standardSubmit :true
	 				});
	 			}  
	 		},
	 		'coursecreationuploadform button[itemId=uploadId]':{
	 			click:function(obj){
	 				var $this=this;
	 				var form=obj.up('coursecreationuploadform');
	 				submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
    	        	$this.getHashOfFile(form);
		        	setTimeout(function() {
		 				form.getForm().submit({
		 					method : 'POST',
		 					url : submitUrl,
		 					success : function(form, action){
		 						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		 					},
		 					failure: function(form, action) {
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		 					}
		 				});
		        	},1000);

	 				Ext.defer(function() {
	 					var grid = $this.getImportlistcoursecreation();
	 					var form = $this.getUploadoptionradiogroup();
	 					var isUploadAll = form.items.items[0].getValue().isUploadAll;
	 					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_COURSE_CREATION');
	 				}, 2000, this);
	 			}  
	 		},
	 		'coursecreationuploadform button[itemId=resetBtn]':{
	 			click:function(obj){
	 				var $this = this;
	 				var form =obj.up('coursecreationuploadform').getForm();
	 				form.findField('file').reset();
	 				var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
	 				uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	 					isUploadAll: false
	 				});
	 				form.isValid();
	 			},
	 			render :function(obj){
	 				var $this = this;
	 				var form =obj.up('coursecreationuploadform').getForm();
	 				var combo = form.findField('importUtilityMasterId');
	 				combo.getStore().load({
	 					callback: function(records, operation, success) {
	 						for(var i in records){
	 							if(records[i].data.value=='Bulk Course With Component'){
	 								combo.setValue(records[i].data.id);
	 								combo.setReadOnly(true);
	 							}
	 						}
	 					}	   
	 				});
	 			}  
	 		},
  		   'coursecreationuploadform uploadoptionradiogroup[itemId=coursecreationUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
 			   change: function( radioGroup, newValue, oldValue, eOpts){
 				   var grid =this.getImportlistcoursecreation();
 				   var form =this.getUploadoptionradiogroup();
 				   var isUploadAll = newValue.isUploadAll;
 				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_COURSE_CREATION');
 			   }   
 		   },
	 		'importlistcoursecreation':{
	 			render:function(obj){
	 				var $this = this;
	 				var grid = $this.getImportlistcoursecreation();
	 				var form = $this.getUploadoptionradiogroup();
 					var isUploadAll = form.items.items[0].getValue().isUploadAll;
 					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_COURSE_CREATION');
	 			},
	 			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	 				if (e.target.tagName == 'A') {
	 					var fileType=null;
	 					if(cellIndex==1){
	 						fileType='successFile';
	 					}else if(cellIndex==6){
	 						fileType='errorFile';
	 					}else if(cellIndex==7){
	 						fileType='logFile';
	 					}
	 					var documentId = record.get("id");
	 					if (!isNullOrEmpty(documentId)) {
	 						this.getCourseCreationDownloadFile(documentId,fileType);
	 					}
	 				}
	 			}
	 		},
	 		'importlistcoursecreation button[itemId=btnForce]':{
	 			click: function(obj) {
	 				var grid = this.getImportlistcoursecreation();
	 				if (grid.getSelectionModel().getCount() > 0) {
	 					if(grid.getSelectionModel().getCount() > 1){
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	 					}else{
	 						var this$ = this;
	 						var id = grid.getSelectionModel().selectionStart.data.id;
	 						console.log(id);
	 						var urlAppend="?jobName="+id;
	 						var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
	 						Ext.Ajax.request({
	 							url: submitURL,
	 							method: 'GET',
	 							success: function(response) {
	 								if(response.responseText==="JOB_STATUS_NOT_PENDING"){
	 									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	 								}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
	 									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	 								}else if(response.responseText==="SUCCESS"){
	 									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	 									grid.getStore().reload();
	 								}
	 							}
	 						});
	 					}
	 				} else {
	 					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	 				}  
	 			}
	 		}, 
	 		'noofcoursespclassogrid' : {
	 			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	 				  var $this=this;
	              	  var specializationGrid = $this.getNoofcoursespclassogrid();
	                  var columnName=specializationGrid.columnManager.columns[cellIndex].dataIndex;
	                  if(columnName=='classAssociated' &&  record.data.classAssociated > 0){ // checked
		                  	var store=$this.getStore('course.coursespecialization.CourseSpecializationProgram');
		                  	store.getProxy().extraParams = {
		                  		specializationId: record.data.id
		    					    };
		                  	store.load();
		                  	var formWindow = $this.getCoursespecializationprogram();
		     	       		        if (!formWindow) {
		     	       		             Ext.widget('coursespecializationprogram');
		     	       		            formWindow = $this.getCoursespecializationprogram();
		     	       		       }
		  	       		        formWindow.show();
		              	   }
	 			}
	 		}, 
	 		'noofregcoursegrpassogrid' : {
	 			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	 				  var $this=this;
	              	  var regularGroupGrid = $this.getNoofregcoursegrpassogrid();
	                  var columnName=regularGroupGrid.columnManager.columns[cellIndex].dataIndex;
	                  if(columnName=='noOfAssociatdPrograms' &&  record.data.noOfAssociatdPrograms > 0){ // checked
		                  	var store=$this.getStore('course.coursegroup.ProgramBYCourseGroup');
		                  	store.getProxy().extraParams = {
		                  		courseGroupId: record.data.id
		    					    };
		                  	store.load();
		                  	var formWindow = $this.getNoofprogram();
		     	       		        if (!formWindow) {
		     	       		             Ext.widget('noofprogram');
		     	       		            formWindow = $this.getNoofprogram();
		     	       		       }
		  	       		        formWindow.show();
		  	       		   formWindow.setTitle(getProgramandcourseTranslation('PROGRAMS_ASSOCIATED'));
		              	   }
	 			}
	 		},
	 		'basicdetailform customcombobox[itemId=courseDepartment]' : {
			select : function(obj, record) {
				var subDept = obj.up().down('#courseSubDepartment');
				subDept.clearValue();
				var departmentId = record[0].get("id");
				if (departmentId > 0) {
					var store=subDept.getStore();
					store.getProxy().extraParams = {
						parentId : departmentId
					};
					store.load();
				}
			}
		},	
		'basicdetailform combo[itemId=departmentId]' : {
			select : function(obj, record) {
				var departmentId=record[0].get('id');
				var flag = true;
				var pnlMain = obj.up("#panelIdH");
				var rowIndx = obj.rowIndx;
				if(!isNullOrEmpty(pnlMain)){
					pnlMain.items.each(function(item, index, items) {
						var deptNameVal = item.down("[name=departmentName]").getValue();
						if(departmentId == deptNameVal && rowIndx != index){
							flag = false;
							return false;
						}
					});

					if(flag){
						var subDept = obj.up('form').down('#subDepartmentId');
						if(!isNullOrEmpty(subDept)){
							subDept.clearValue();
							subDept.setDisabled(false);
							subDept.reset()
						}
						var departmentId = record[0].get("id");
						if (departmentId > 0) {
							var store=subDept.getStore();
							store.getProxy().extraParams = {
								parentId : departmentId
							};
							store.load();
						}
					}
					else{
						obj.reset();
						var nextSiblingField = obj.nextSibling();
						nextSiblingField.reset();
						nextSiblingField.setDisabled(true);
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_DEPARTMENT_ALREADY_SELECTED_MSG'));
						return false;
					}
				}
			}
		},
		
		'basicdetailform textfield[itemId=courseNameItemId]' : {
			blur : function() {
				//this.showHideAddMoreButton(obj,record);
				var form = this.getBasicdetailform().getForm();
				var courseName = form.findField('courseName').getValue();
				form.findField('nameToBePrinted').setValue(courseName);
				form.findField('courseShortName').setValue(courseName);
			}
		},
		'basicdetailform textfield[itemId=courseNameLanguageOneId]' : {
			blur : function() {
				//this.showHideAddMoreButton(obj,record);
				var form = this.getBasicdetailform().getForm();
				var courseNameLanguageOne = form.findField('courseNameLanguageOne').getValue();
				form.findField('courseShortNameLanguageOne').setValue(courseNameLanguageOne);
			}
		},
		'basicdetailform textfield[itemId=courseNameLanguageTwoId]' : {
			blur : function() {
				//this.showHideAddMoreButton(obj,record);
				var form = this.getBasicdetailform().getForm();
				var courseNameLanguageTwo = form.findField('courseNameLanguageTwo').getValue();
				form.findField('courseShortNameLanguageTwo').setValue(courseNameLanguageTwo);
			}
		},
		'basicdetailform textfield[itemId=courseNameLanguageThreeId]' : {
			blur : function() {
				//this.showHideAddMoreButton(obj,record);
				var form = this.getBasicdetailform().getForm();
				var courseNameLanguageThree = form.findField('courseNameLanguageThree').getValue();
				form.findField('courseShortNameLanguageThree').setValue(courseNameLanguageThree);
			}
		},


		'basicdetailform button[itemId=addDetailedBtn]' : {
			click : function() {
				this.addMoreDetailedOfDepartmentInBasicDetail("Add");
			}
		},
		'basicdetailform button[itemId=addDetailedBtn1]' : {
			click : function() {
				this.addMoreDetailedOfDepartmentInBasicDetail("Add");
			}
		},
		'basicdetailform button[itemId=detailedDeleteButton1]':{
			click : function(deleteButton) {
				 this.deleteMoreDetailedOfDepartmentOfBasicDetail(deleteButton)
			 }
		},
		'basicdetailform button[itemId=addDetailedMSPBtn]' : {
			click : function() {
				this.addMoreDetailedOfModuleSubjectBasicDetail("Add");
			}
		},
		'basicdetailform button[itemId=addDetailedMSPBtn1]' : {
			click : function() {
				this.addMoreDetailedOfModuleSubjectBasicDetail("Add");
			}
		},
		'basicdetailform button[itemId=detailedDeleteMSPButton1]':{
			click : function(deleteButton) {
				 this.deleteMoreDetailedOfModuleSubject(deleteButton)
			 }
		},
		'basicdetailform combo#courseDepartment' : {
			select : function(obj, record) {
				var subDept = obj.up('form').down('#courseSubDepartment');
				if(!isNullOrEmpty(subDept)){
					subDept.clearValue();
				}
				var departmentId = record[0].get("id");
				if (departmentId > 0) {
					var store=subDept.getStore();
					store.getProxy().extraParams = {
						parentId : departmentId
					};
					store.load();
				}
			}
		},
		'basicdetailform radiogroup[itemId=isLMSCoursesId]' : {
			change : function(cb, nv, ov){
				var form=this.getBasicdetailform();
				var lMSCourseOfferYearItemId=form.down('#lMSCourseOfferYearItemId');
				var isPublishToLMS=form.down('#isPublishToLMS');
				lMSCourseOfferYearItemId.reset();
				isPublishToLMS.reset();
				if (nv.isLMSCourses) {
					lMSCourseOfferYearItemId.show();
					isPublishToLMS.show();
					isPublishToLMS.setValue(true);
				}else{
					lMSCourseOfferYearItemId.hide();
					isPublishToLMS.hide();
				}
			}
		},
		'basicdetailform radiogroup[itemId=modulePrerequisitesRadioItemId]' : {
			change : function(cb, nv, ov){
				var me = this;
				var form=this.getBasicdetailform();
				var modulePrerequisitesFieldset = form.down('#modulePrerequisitesFieldsetItemId');
				var radioValue = cb.getValue();
				if(radioValue.modulePrerequisitesRadio == 0){
					modulePrerequisitesFieldset.setVisible(false);
				}
				else{
					modulePrerequisitesFieldset.setVisible(true);
				}
			}
		},
		'basicdetailform customcombobox[itemId=succeedingCourseId]' : {
			afterrender : function(combo) {
				   var store = combo.getStore();
				   store.on('beforeload',function() {
					   var form=this.getBasicdetailform();
					   var courseId = form.getFormValues().id;
					   store.getProxy().extraParams = {
						   courseId: courseId
					   };
				   }, this);
			   }
		   },
		   
		   'basicdetailform radiogroup[itemId=hasCourseComponents_id]' : {
				change : function(cb, nv, ov){
					var form=this.getBasicdetailform();
					var sectionAtComponentLevel=form.down('#sectionAtComponentLevel_id');
					if(nv.hasCourseComponents==1){
						sectionAtComponentLevel.show();
					}else{
						sectionAtComponentLevel.hide();	
					}
				}
			},
			'basicdetailform combo[itemId=moduleSubjectId]' : {
    			select : function(obj, record) {
    				var departmentId=record[0].get('id');
    				var flag = true;
					var pnlMain = obj.up("#panelMSP");
					var rowIndx = obj.rowIndx;
					if(!isNullOrEmpty(pnlMain)){
						pnlMain.items.each(function(item, index, items) {
							var deptNameVal = item.down("[name=moduleSubject]").getValue();
							if(departmentId == deptNameVal && rowIndx != index){
								flag = false;
	        					return false;
							}
						});
						
						if(flag){
							var subDept = obj.up('form').down('#moduleSubjectsProportionId');
            				if(!isNullOrEmpty(subDept)){
            					subDept.setDisabled(false);
            					subDept.reset()
            				}
						}
						else{
							obj.reset();
							var nextSiblingField = obj.nextSibling();
							nextSiblingField.reset();
							nextSiblingField.setDisabled(true);
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MODULE_SUBJECT_ALREADY_SELECTED_MSG'));
							return false;
						}
					}
    			}
    		}
	
			/*	'basicdetailform combo[itemId=courseMax_1]' : {
			select : function(obj, record) {
				var gradeType = record[0]
				.get('value');
				var store = this
				.getStore('examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
				store.getProxy().extraParams = {
					gradeType : gradeType
				};
				store.load();
			}
		},*/
		
        });
    },
    getCourseCreationDownloadFile : function(documentId,fileType){
  	   if(!isNullOrEmpty(documentId)){
  		   var csvForm = Ext.create('Ext.form.Panel'); 
  		   csvForm.getForm().submit({
  			   target: '_blank',
  			   method:'POST',
  			   params :{
  				   access_token : Ext.Ajax.defaultHeaders.access_token
  			   },
  			   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
  			   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
  			   standardSubmit :true
  		   });
  	   }
     },
     courseCreationDownloadUploadFormChange : function(cb, nv, ov){
    	var $this = this;
    	var structure = cb.up('coursecreationuploaddownloadstructure');
    	var downloadTemplateForm = structure.down('coursecreationdownloadform');
    	var uploadTemplateForm = structure.down('coursecreationuploadform');
    	var grid = $this.getImportlistcoursecreation();
    	if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
    		uploadTemplateForm.hide();
    		downloadTemplateForm.show();
    		grid.setVisible(false);
    	}else{
    		$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
        	var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
        	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
        		isUploadAll: false
        	});
    		downloadTemplateForm.hide();
    		uploadTemplateForm.show();
    		grid.setVisible(true);
    		uploadTemplateForm.down("#uploadFileField").reset();
    	}
    },
    closeFormWindow: function() {
        this.getCoursecomponentform().close();
    },
    linkEditCourse: function(view, rowIndex, record,isview) {
    	try {
    		var $this = this;
    		if (record) {
    			var ids = record.get('ID');
    		}
    		var contentpanel = this.getContentpanel();
    		var coursetabstructure = Ext.widget('coursetabstructure');
    		var tabName = getCommonTranslation('COURSE_STRUCTURE');

    		var grid = this.getSearchresultgrid();
    		if (grid.getSelectionModel().getCount() > 0) {
    			/**
    			 * This is to remove tab from content panel and open same tab again
    			 */
    			var getcontroller=$this.getController('menu.CoreERPNavigationController');
    			var getTab = null;
    			for(var i =0 ;i<contentPanel.items.length;i++){
    				if(contentPanel.items.items[i].title == tabName){
    					getTab= contentPanel.items.items[i];
    				}
    			}
    			if(getTab!=null){
    				contentPanel.remove(getTab, true);
    			}

    			if(contentPanel!=undefined){
    				getTab =Ext.create('Academia.view.course.CourseParentPanel',{
    					title: tabName,
    					closable:true,
    					itemId:'editCourseParentPnl',
    					autoScroll:true,
    					menuColorCls: CONSTANTS.MENU_COLOR_THREE,
    					items:[coursetabstructure]
    				}); 
    				contentPanel.add(getTab);
    				contentPanel.setActiveTab(getTab);
    				contentPanel.doLayout();		
    			}		
    			var secAtComponent=null;
    			var tabStcrFrm = $this.getCoursetabstructure().getForm();
    			tabStcrFrm.findField("ids").setValue(ids);
    			var isMultipleResoan = this.getMultipleReasonsRequired();
    			var form = this.getBasicdetailform();
    			var editUrl = SERVERURL.BASIC_COURSES_DETAILS;
    			var cvUrl = SERVERURL.COURSE_VARIANTS_FINDALLBy_ID;
    			Ext.Ajax.request({
    				method: "GET",
    				type: 'rest',
    				url: editUrl,
    				params: {
    					id: ids
    				},
    				success: function(f, action) {
    					try{
	    					var EId = Ext.JSON.decode(f.responseText);
	    					var formModel = new Academia.model.course.CreateCourseModel(EId);
	    					var alinfomodel = Academia.model.authentication.ALInfoModel;
	    					var wheatherSchool = alinfomodel.get('wheatherSchool');
	    					form.loadRecord(formModel);
	    					form.getForm().findField("courseCESMCode").reset();
	    					form.getForm().findField("deficiencyStatus1").setValue(formModel.data.deficiencyStatus);
	    					form.getForm().findField("whetherRepeatable1").setValue(formModel.data.whetherRepeatable);
	    					form.getForm().findField("hasCourseComponents1").setValue(formModel.data.hasCourseComponents);
	    					form.getForm().findField("whetherEvaluationExternal1").setValue(formModel.data.whetherEvaluationExternal);
	    					form.getForm().findField("courseDeficits1").setValue(formModel.data.courseDeficits);
	    					form.getForm().findField("sectionAtComponentLevel1").setValue(formModel.data.sectionAtComponentLevel);
	    					tabStcrFrm.findField("sectionAtComponentLevelFlag").setValue(formModel.data.sectionAtComponentLevel);
	    					tabStcrFrm.findField("whetherCourseExempted").setValue(formModel.data.whetherCourseExemption);
	    					tabStcrFrm.findField("courseSectionType").setValue(formModel.data.assignSectionType);
	
	    					form.getForm().findField("courseNameLanguageOne").setValue(formModel.data.courseNameLanguageOne);
	    					form.getForm().findField("courseShortNameLanguageOne").setValue(formModel.data.courseShortNameLanguageOne);
	    					form.getForm().findField("courseNameLanguageTwo").setValue(formModel.data.courseNameLanguageTwo);
	    					form.getForm().findField("courseShortNameLanguageTwo").setValue(formModel.data.courseShortNameLanguageTwo);
	    					form.getForm().findField("courseNameLanguageThree").setValue(formModel.data.courseNameLanguageThree);
	    					form.getForm().findField("courseShortNameLanguageThree").setValue(formModel.data.courseShortNameLanguageThree);
	    					form.getForm().findField("isLMSCourses").setValue(formModel.data.isLMSCourses);
	    					form.getForm().findField("isPublishToLMS").setValue(formModel.data.isPublishToLMS);
	    					form.getForm().findField("lMSCourseOfferYear").setValue(formModel.data.lMSCourseOfferYear);
	    					form.getForm().findField("isFeeApplicable").setValue(formModel.data.isFeeApplicable);
	    					form.getForm().findField("modulePrerequisite").setValue(formModel.data.modulePrerequisite);
	    					form.getForm().findField("isPublishInCatalogue").setValue(formModel.data.isPublishInCatalogue);
		                    form.getForm().findField("subjectAdditionalCode").setValue(formModel.data.subjectAdditionalCode);
                            form.getForm().findField("courseShortDescriptionInOtherLanguage").setValue(formModel.data.courseShortDescriptionInOtherLanguage);
	    					form.getForm().findField("modulePrerequisitesRadio").setValue({modulePrerequisitesRadio:formModel.data.isModulePrerequisites});
	    					form.getForm().findField("hybridModule").setValue(formModel.data.hybridModule);
	    					form.getForm().findField("moduleHEQSFLevel").setValue(formModel.data.moduleHEQSFLevel);
	    					form.getForm().findField("eligibleTransferCredit").setValue(formModel.data.eligibleTransferCredit);
	    					form.getForm().findField("weightGPA").setValue(formModel.data.weightGPA);
	    					form.getForm().findField("isPrefrenceRequired").setValue(formModel.data.isPrefrenceRequired);
							
	    					
	    					if(isMultipleResoan && formModel.data.courseCredits == 0.0){
	    						form.getForm().findField("courseCredits").setVisible(false);
	    						form.getForm().findField("courseCreditsNBC").setVisible(true);
	    						form.getForm().findField("courseCreditsNBC").setValue("NBC");
	    					}else{
	    						form.getForm().findField("courseCreditsNBC").setVisible(false);
	    					}

	    					
	    					if(isMultipleResoan && formModel.data.ectsCredits==0.0){
	    						form.getForm().findField("ectsCredits").setVisible(false);
	    						form.getForm().findField("ectsCreditsNBC").setVisible(true);
	    						form.getForm().findField("ectsCreditsNBC").setValue("NBC");
	    					}else{
	    						form.getForm().findField("ectsCreditsNBC").setVisible(false);
	    						form.getForm().findField("ectsCredits").setValue(formModel.data.ectsCredits);
	    					}
                           
                            var courseId = formModel.data.courseId;
    							var succeedingCoursStore = form.down('#succeedingCourseId').getStore();
    							succeedingCoursStore.getProxy().extraParams = {
    								courseId: courseId
    							};
    							succeedingCoursStore.load({
        							callback: function(record, operation, success) {
        								if (success && !isNullOrEmpty(record)) {
        									for(var i = 0; i<record.length;i++){
												if(!isNullOrEmpty(EId.succeedingCourseId) && record[i].data.id == EId.succeedingCourseId){
													 form.getForm().findField("succeedingCourse").setValue(record[i].data.id);
													 
												}
											}
        									
    					        }
        				}
					});
	    					var modulePrerequisiteEditor = form.getForm().findField("modulePrerequisite");
	    					modulePrerequisiteEditor.on('instanceReady',function(component,ele){
	    						component.editor.setData(formModel.data.modulePrerequisite);
	    					});
	
	    					var isPublishInCatalogueEditor = form.getForm().findField("isPublishInCatalogue");
	    					isPublishInCatalogueEditor.on('instanceReady',function(component,ele){
	    						component.editor.setData(ormModel.data.isPublishInCatalogue);
	    					});
	
	    					var alinfomodel = Academia.model.authentication.ALInfoModel;
	    					var whetherSchool = alinfomodel.get('wheatherSchool');
	    					var tabPanel = $this.getCoursetabstructure().items.items[4];
	
	    					var courseMarkGradeId=form.down('#courseMarksGrades_id');
	    					var courseCutOffId=form.down('#courseOff_id');
	
	    					if (formModel.data.courseMarksGrades == "M") {
	    						form.down('#courseMarksGrades_id').setValue("MARK");
	    						form.down('#courseOff_id').show();
	    						form.down('#courseMaxMarks_Id').show();
	
	    						form.down('#courseOff_id').allowBlank=false;
	    						form.down('#courseMaxMarks_Id').allowBlank=false;
	
	    						form.down('#courseMax_1').allowBlank=true;
	    						form.down('#courseOff_1').allowBlank=true;
	    						form.down('#courseOff_2').allowBlank=true;
	    						form.down('#courseMax_1').hide();
	    						form.down('#courseOff_1').hide();
	    						form.down('#courseOff_2').hide();
	
	    					} else if (formModel.data.courseMarksGrades == "G") {
	    						if(!isNullOrEmpty(formModel.data.courseGradeType)){
	    							var evaluationFormOneGradesStore = $this.getStore('examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
	    							evaluationFormOneGradesStore.getProxy().extraParams = {
	    								gradeType:formModel.data.courseGradeType
	    							};
	    							evaluationFormOneGradesStore.load();
	    						}
	
	    						form.down('#courseOff_id').allowBlank=true;
	    						form.down('#courseMaxMarks_Id').allowBlank=true;
	    						form.down('#courseOff_id').hide();
	    						form.down('#courseMaxMarks_Id').hide();
	
	    						form.down('#courseMax_1').show();
	    						form.down('#courseOff_1').show();
	    						form.down('#courseOff_2').show();
	
	    						form.down('#courseMax_1').allowBlank=false;
	    						form.down('#courseOff_1').allowBlank=false;
	    						form.down('#courseOff_2').allowBlank=false;
	
	    						form.down('#courseMarksGrades_id').setValue("GRADE");
	    						form.down('#courseMax_1').setValue(formModel.data.courseGradeType);
	    						form.down('#courseOff_1').setValue(formModel.data.courseCutOff);
	    						form.down('#courseOff_2').setValue(formModel.data.courseMaxMark);
	    						
	    					}
    					}
    					catch(e){
    						console.log('errorCatch2');
    					}
    					
    					try{
    						var courseStageStore = form.down('#stage_Type').getStore(); 
    						courseStageStore.load({
    							callback: function(record, operation, success) {
    								if (success) {
    									try{
    										if (formModel.data.selectionStage != null) {
    											for(var i = 0; i<record.length;i++){
    												if(record[i].data.id == formModel.data.selectionStage){
    													form.down('#stage_Type').setValue(record[i].data.id);
    												}
    											}
    											if(formModel.data.selectionStage == "COURSE_EXECUTION"){
    												Ext.ComponentQuery.query('radiogroup#repeatablePeriods_Id')[0].show();
    												Ext.ComponentQuery.query('numberfield#courseCredit_Id')[0].show();
    												if(isMultipleResoan && Ext.ComponentQuery.query('numberfield#courseCredit_Id')[0].getValue() == 0.0){
    						    						form.getForm().findField("courseCredits").setVisible(false);
    						    						form.getForm().findField("courseCreditsNBC").setVisible(true);
    						    						form.getForm().findField("courseCreditsNBC").setValue("NBC");
    						    					}else{
    						    						form.getForm().findField("courseCreditsNBC").setVisible(false);
    						    					}
    												//Ext.ComponentQuery.query('radiogroup#course_Deficiency_Status_Id')[0].show();
    												Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0].show();
    												Ext.ComponentQuery.query('radiogroup#courseRank_Id')[0].show();
    												Ext.ComponentQuery.query('customcombobox#assignSectionTypeId')[0].show();
    											}else{
    												Ext.ComponentQuery.query('radiogroup#repeatablePeriods_Id')[0].hide();
    												Ext.ComponentQuery.query('numberfield#courseCredit_Id')[0].hide();
    												Ext.ComponentQuery.query('radiogroup#course_Deficiency_Status_Id')[0].hide();
    												Ext.ComponentQuery.query('customcombobox#course_Deficits_Id')[0].hide();
    												Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0].hide();
    												Ext.ComponentQuery.query('radiogroup#courseRank_Id')[0].hide();
    												Ext.ComponentQuery.query('customcombobox#assignSectionTypeId')[0].hide();
    											}
    										}
    									}
    									catch(e){
    										console.log('errorCatch2');
    									}
    								}
    							}
    						});
    						
        					var fieldradio = form.down('#repeatablePeriods_Id');
        					var whetherEvaluationExte = form.down('#whetherEvaluationExternalItemId');
        					var deficiencyStatusBasic = form.down('#course_Deficiency_Status_Id');
        					var courseDeficitsBasic = form.down('#course_Deficits_Id');
        					var hasCourseComponentsBasic = form.down('#hasCourseComponents_id');
        					var sectionAtComponentLevel = form.down('#sectionAtComponentLevel_id');
        					var whetherCourseExemption = form.down('#whetherCourseExemptionItemId');
        					var assignSectionType = form.getForm().findField('assignSectionType');
        					var courseDeficitsPoint=form.down('#course_Deficits_Point_Id');

        					var courseRankBasic = form.down('#courseRank_Id');
        					var course_sectionType = form.down('#course_sectionType');
        					var course_whetherFixed = form.down('#course_whetherFixed');
        					course_sectionType.setValue(formModel.data.assignSectionType);
        					course_whetherFixed.setValue(formModel.data.whetherFixed);
        					var includeinPromotion = form.down('#includeinPromotion');
        					
        					if (formModel.data.hasCourseComponents == 1) {
        						hasCourseComponentsBasic.items.items[0].setValue(true);
        						hasCourseComponentsBasic.items.items[1].setValue(false);
        						hasCourseComponentsBasic.setDisabled(true);
        						if (formModel.data.sectionAtComponentLevel == 1) {
        							sectionAtComponentLevel.items.items[0].setValue(true);
        							sectionAtComponentLevel.items.items[1].setValue(false);
        							sectionAtComponentLevel.setDisabled(true);
        						} else if (formModel.data.sectionAtComponentLevel == 0) {
        							sectionAtComponentLevel.items.items[0].setValue(false);
        							sectionAtComponentLevel.items.items[1].setValue(true);
        							sectionAtComponentLevel.setDisabled(true);
        						}
        					} else if (formModel.data.hasCourseComponents == 0) {
        						hasCourseComponentsBasic.setDisabled(false);
        						hasCourseComponentsBasic.items.items[0].setValue(false);
        						hasCourseComponentsBasic.items.items[1].setValue(true);
        						sectionAtComponentLevel.hide();
        					}

        					if (formModel.data.courseRankConsidered == 'Y') {
        						courseRankBasic.items.items[0].setValue(true);
        						courseRankBasic.items.items[1].setValue(false);
        						courseRankBasic.setDisabled(true);
        					} else if (formModel.data.courseRankConsidered == 'N') {
        						courseRankBasic.items.items[0].setValue(false);
        						courseRankBasic.items.items[1].setValue(true);
        						courseRankBasic.setDisabled(true);
        					}

        					if (formModel.data.whetherRepeatable) {
        						setTimeout(function(){
        							try{
            							Ext.ComponentQuery.query('fieldcontainer#repeatablePeriods_Id')[0].setValue({whetherRepeatable:true});
    								}
    								catch(e){
    									console.log('errorCatch2');
    								}
        						},500);
        					} else {
        						setTimeout(function(){
        							try{
            							Ext.ComponentQuery.query('fieldcontainer#repeatablePeriods_Id')[0].setValue({whetherRepeatable:false});
    								}
    								catch(e){
    									console.log('errorCatch2');
    								}
        						},500);
        					}
        					
        					if (formModel.data.whetherEvaluationExternal) {
        						whetherEvaluationExte.items.items[0].setValue(true);
        						whetherEvaluationExte.items.items[1].setValue(false);
        					} else {
        						whetherEvaluationExte.items.items[0].setValue(false);
        						whetherEvaluationExte.items.items[1].setValue(true);
        					}
        					var isLMSCoursesId = form.down('#isLMSCoursesId');
        					if (formModel.data.isLMSCourses) {
        						form.getForm().findField("lMSCourseOfferYear").setVisible(true);
        						form.getForm().findField("isPublishToLMS").setVisible(true);
        						isLMSCoursesId.items.items[0].setValue(true);
        						isLMSCoursesId.items.items[1].setValue(false);
        						form.getForm().findField("isPublishToLMS").setValue(formModel.data.isPublishToLMS);
        						form.getForm().findField("lMSCourseOfferYear").setValue(formModel.data.lMSCourseOfferYear);
        					} else {
        						isLMSCoursesId.items.items[0].setValue(false);
        						isLMSCoursesId.items.items[1].setValue(true);
        						form.getForm().findField("lMSCourseOfferYear").setVisible(false);
        						form.getForm().findField("isPublishToLMS").setVisible(false);
        					}
        					
        					var isFeeApplicable = form.down('#isFeeApplicable');
        					if(formModel.data.isFeeApplicable){
        						isFeeApplicable.items.items[0].setValue(true);
        						isFeeApplicable.items.items[1].setValue(false);
        					}else{
        						isFeeApplicable.items.items[0].setValue(false);
        						isFeeApplicable.items.items[1].setValue(true);
        					}
        					
        					var eligibleTransferCredit = form.down('#eligibleTransferCredit');
        					if(formModel.data.eligibleTransferCredit){
        						eligibleTransferCredit.items.items[0].setValue(true);
        						eligibleTransferCredit.items.items[1].setValue(false);
        					}else{
        						eligibleTransferCredit.items.items[0].setValue(false);
        						eligibleTransferCredit.items.items[1].setValue(true);
        					}
        					
        					var hybridModule = form.down('#hybridModule');
        					if(formModel.data.hybridModule){
        						hybridModule.items.items[0].setValue(true);
        						hybridModule.items.items[1].setValue(false);
        					}else{
        						hybridModule.items.items[0].setValue(false);
        						hybridModule.items.items[1].setValue(true);
        					}
        					
							var isPrefrenceRequired = form.down('#isPrefrenceRequiredId');
							if (formModel.data.isPrefrenceRequired) {
								isPrefrenceRequired.items.items[0].setValue(true);
								isPrefrenceRequired.items.items[1].setValue(false);
							} else {
								isPrefrenceRequired.items.items[0].setValue(false);
								isPrefrenceRequired.items.items[1].setValue(true);
							}
        					form.getForm().findField("isPublishInCatalogue").setValue(formModel.data.isPublishInCatalogue);

        					var modulePrerequisiteEditor = form.getForm().findField("modulePrerequisite");
        					modulePrerequisiteEditor.on('instanceReady',function(component,ele){
        						component.editor.setData(formModel.data.modulePrerequisite);
        					});

        					var isPublishInCatalogueEditor = form.getForm().findField("isPublishInCatalogue");
        					isPublishInCatalogueEditor.on('instanceReady',function(component,ele){
        						component.editor.setData(ormModel.data.isPublishInCatalogue);
        					});
        					
        					if (formModel.data.deficiencyStatus) {
        						courseDeficitsBasic.setVisible(true);
        						deficiencyStatusBasic.items.items[0].setValue(true);
        						deficiencyStatusBasic.items.items[1].setValue(false);
        						deficiencyStatusBasic.setDisabled(true);

        						if(formModel.data.courseDeficits=='F'){
        							courseDeficitsBasic.setValue(getCommonTranslation('FIXED'));
        							courseDeficitsPoint.setDisabled(false);
        							courseDeficitsPoint.setVisible(true);
        							if(!isNullOrEmpty(formModel.data.courseDeficitsPoint) && formModel.data.courseDeficitsPoint>1){
        								courseDeficitsPoint.setValue(formModel.data.courseDeficitsPoint);
        							}
        						}else if(formModel.data.courseDeficits=='R'){
        							courseDeficitsPoint.setVisible(false);
        							courseDeficitsBasic.setValue(getCommonTranslation('RULE_BASED'));
        						}

        					} else {
        						courseDeficitsBasic.setVisible(false);
        						deficiencyStatusBasic.items.items[0].setValue(false);
        						deficiencyStatusBasic.items.items[1].setValue(true);
        						//deficiencyStatusBasic.setDisabled(true);
        						setTimeout(function(){
        							try{
            							courseDeficitsPoint.setVisible(false);
    								}
    								catch(e){
    									console.log('errorCatch2');
    								}
        						},1200);
        					}
        					
        					if (formModel.data.whetherCourseExemption) {
        						whetherCourseExemption.items.items[0].setValue(true);
        						whetherCourseExemption.items.items[1].setValue(false);
        					} else {
        						whetherCourseExemption.items.items[0].setValue(false);
        						whetherCourseExemption.items.items[1].setValue(true);
        					}

        					if (formModel.data.assignSectionType=='ProgramBatchSection'||formModel.data.assignSectionType=='PROGRAM_BATCH_SECTION') {
        						assignSectionType.getStore().load({
        							callback: function(record, operation, success) {
        								if (success) {
        									try{
            									assignSectionType.setValue('PROGRAM_BATCH_SECTION');
        									}
        									catch(e){
        										console.log('errorCatch2');
        									}
        								}
        							}
        						});
        						assignSectionType.setReadOnly(true);
        					} else {
        						assignSectionType.getStore().load({
        							callback: function(record, operation, success) {
        								if (success) {
        									try{
            									assignSectionType.setValue('COURSE_SECTION');
        									}
        									catch(e){
        										console.log('errorCatch2');
        									}
        								}
        							}
        						});
        						form.down('#repeatablePeriods_Id').setDisabled(false);   
        						assignSectionType.setReadOnly(true);
        					}
        					
        					if (!formModel.data.whetherMultipleParam && formModel.data.whetherMultipleParam !=null) {
        						form.down('#repeatablePeriods_Id').setDisabled(true);   
        					} else {
        						form.down('#repeatablePeriods_Id').setDisabled(false);   
        					}

        					var courseDepStore = $this.getStore('course.CourseDepartmentStore');
        					var courseSubDepStore = form.down('#subDepartmentId').getStore();
        					var CourseCoordinatorSmartSearch = $this.getStore('course.CourseCoordinatorSmartSearch');
        					var courseStageStore = $this.getStore('examinationcenters.CenterUseFor');
        					var courseCategoryStore = $this.getStore('course.CourseCategoryStore');
        					var courseMarksGradesStore = $this.getStore('course.CourseMarkGradeStore');
        					var courseSubjectTypeStore = $this.getStore('course.CourseSubjectTypeStore');
        					var CourseNQFLevelStoreFromCSM = $this.getStore('course.CourseNQFLevelStoreFromCSM');
        					var CourseCESMCodeStoreFromCSM = $this.getStore('course.CourseCESMCodeStoreFromCSM');
                             
                             var metaCourseOne=form.getForm().findField('metaCourseOne');
                             var metaCourseTwo=form.getForm().findField('metaCourseTwo');
                             var metaCourseThree=form.getForm().findField('metaCourseThree');

                            var metaCourseStoreOne = metaCourseOne.getStore();
							var metaCourseStoreTwo = metaCourseTwo.getStore();
							var metaCourseStoreThree = metaCourseThree.getStore();

							courseCategoryStore.load({
        						callback: function(record, operation, success) {
        							if (success) {
        								if(formModel.data.courseCategory) {
        									try{
            									form.down('#courseCategory').setValue(formModel.data.courseCategory.id);
            								}
            								catch(e){
            									console.log('errorCatch2');
            								}
        								}
        							}
        						}
        					});
        					if(wheatherSchool){
        						form.down('#stage_Type').hide();
        						whetherEvaluationExte.hide();
        						courseDeficitsBasic.hide();
        						deficiencyStatusBasic.hide();
        						whetherCourseExemption.hide();
        					}
        					form.down('#courseMarksGrades_id').getStore().load();
        					if(formModel.data.courseMarksGrades != null){
        						courseMarksGradesStore.load({
        							callback: function(record, operation, success) {
        								if (success) {
        									try{
            									form.down('#courseMarksGrades_id').setReadOnly(true);
            									if(formModel.data.courseMarksGrades == "M"){
            										form.down('#courseMarksGrades_id').setValue(record[0].data.id);
            									}else if(formModel.data.courseMarksGrades == "G"){
            										form.down('#courseMarksGrades_id').setValue(record[1].data.id);
            									}
        									}
        									catch(e){
        										console.log('errorCatch2');
        									}
        								}
        							}
        						});
        					}
        					if (formModel.data.department != null) {
        						var dId = formModel.data.department.id;
        					}
        					var courseMultipleLanguageMap=new Ext.util.HashMap();
        					var arr=[];
        					if(!isNullOrEmpty(EId.courseMultipleLanguages)){
        						Ext.Array.each(EId.courseMultipleLanguages, function(record, index) {
        							courseMultipleLanguageMap.add(record.multiLanguage.id,record.id);
        							arr.push(record.multiLanguage.id);
        						});
        						form.getForm().findField("courseMultipleLanguageMap").setValue(Ext.JSON.encode(courseMultipleLanguageMap));
        						var multipleLangugeField = form.getForm().findField("multipleLanguage");
        						var multipleLangugeStore=multipleLangugeField.getStore();
        						multipleLangugeStore.load({
        							callback: function(record, operation, success) {
        								if (success) {
        									try{
            									multipleLangugeField.setValue(arr);
        									}
        									catch(e){
        										console.log('errorCatch2');
        									}
        								}
        							}
        						});
        					}
        					
        					if(EId.courseDepartments.length==1){
        						var courseDepartmentInfo=EId.courseDepartments[0];
        						var cDepartment=form.getForm().findField('departmentName');
        						var cDepartmentStore= cDepartment.getStore();
        						var departmentId=courseDepartmentInfo.department.id;
        						cDepartmentStore.load({
        							callback: function(record, operation, success) {
        								if (success) {
        									try{
            									cDepartment.setValue(departmentId);
            									var subCDepartment=form.getForm().findField('subDepartmentName');
            									subCDepartment.setDisabled(false);
            									var subCDepartmentStore=subCDepartment.getStore();
            									subCDepartmentStore.getProxy().extraParams = {
            										parentId : departmentId
            									}
            									subCDepartmentStore.load({
            										callback: function(record, operation, success) {
            											if (success) {
            												if(!isNullOrEmpty(courseDepartmentInfo.subDepartment)){
            													subCDepartment.setValue(courseDepartmentInfo.subDepartment.id);
            												}

            											}}});
            									if(isview){
            										var fieldContainer=$this.getBasicdetailform().down('#panelIdH').items.items[0].items.items;
            										fieldContainer[4].setDisabled(true);
            									}
        									}
        									catch(e){
        										console.log('errorCatch2');
        									}
        								}
        							}});

        						form.getForm().findField('weightage').setValue(courseDepartmentInfo.weightage);
        					}else if(EId.courseDepartments.length>1){
        						$this.addMoreDetailedOfDepartmentInBasicDetail("Edit",EId.courseDepartments, isview);

        					}
        					if(EId.subjectMapping != null && EId.subjectMapping != undefined){
        					if(EId.subjectMapping.length==1){
        						var courseDepartmentInfo=EId.subjectMapping[0];
        						var cDepartment=form.getForm().findField('moduleSubject');
        						var cDepartmentStore= cDepartment.getStore();
        						var departmentId=courseDepartmentInfo.hesaSubjectId;
        						cDepartmentStore.load({
        							callback: function(record, operation, success) {
        								if (success) {
        									try{
            									cDepartment.setValue(departmentId);
        									}
        									catch(e){
        										console.log('errorCatch2');
        									}
        								}
        							}});

        						form.getForm().findField('moduleSubjectsProportion').setValue(courseDepartmentInfo.weightage);
        						form.getForm().findField('moduleSubjectsProportion').setDisabled(false);
        					}else if(EId.subjectMapping.length>1){
        						$this.addMoreDetailedOfModuleSubjectBasicDetail("Edit",EId.subjectMapping, isview);

        					}
        					}
        					
              
        					CourseCoordinatorSmartSearch.load({
        						callback: function(record, operation, success){
        							if (success) {
        								if (formModel.data.user != null) {
        									try{
            									form.down('#courseCoordinator').setValue(formModel.data.user.id);
            								}
            								catch(e){
            									console.log('errorCatch2');
            								}
        								}
        							}
        						}
        					});
        					if (formModel.data.subjectType != null) {
        						var subjectId = formModel.data.subjectType.id;
        					}
        					courseSubjectTypeStore.load({
        						callback: function(record, operation, success) {
        							if (success) {
        								try{
            								form.down('#subjectType_Id').setValue(subjectId);
        								}
        								catch(e){
        									console.log('errorCatch2');
        								}
        							}
        						}
        					});
        					
        					if (formModel.data.courseNQFLevel != null) {
        						var courseNQFLevelId = formModel.data.courseNQFLevel.id;
        					}
        					
        					form.down('#courseNQFLevelId').getStore().load({
        						callback: function(record, operation, success) {
        							if (success) {
        								try{
            								form.down('#courseNQFLevelId').setValue(courseNQFLevelId);
        								}
        								catch(e){
        									console.log('errorCatch2');
        								}
        							}
        						}
        					});
                         if(formModel.data.metaCourseOne!=null) {
								var metaCourseOne=formModel.data.metaCourseOne.id;
							}
                                              
							metaCourseStoreOne.load({
        						callback: function(record, operation, success) {
        							if (success) {
        								try{
            								form.down('#metaCourseOne').setValue(metaCourseOne);
            							}
            							catch(e){
            								console.log('errorCatch2');
            							}					
        							}
        						}
        					});
                            
                           if(formModel.data.metaCourseTwo!=null) {
								var metaCourseTwo=formModel.data.metaCourseTwo.id;
							}
                                              
							metaCourseStoreTwo.load({
        						callback: function(record, operation, success) {
        							if (success) {
        								try{
            								form.down('#metaCourseTwo').setValue(metaCourseTwo);
            							}
            							catch(e){
            								console.log('errorCatch2');
            							}					
        							}
        						}
        					});
                             if(formModel.data.metaCourseThree!=null) {
								var metaCourseThree=formModel.data.metaCourseThree.id;
							}
                                              
							metaCourseStoreThree.load({
        						callback: function(record, operation, success) {
        							if (success) {
        								try{
            								form.down('#metaCourseThree').setValue(metaCourseThree);
            							}
            							catch(e){
            								console.log('errorCatch2');
            							}					
        							}
        						}
        					});
                                 					
        					if (formModel.data.courseCESMCode != null) {
        						var courseCESMCodeId = formModel.data.courseCESMCode.id;
        					}
        					
        					form.down('#courseCESMCodeId').getStore().load({
        						callback: function(record, operation, success) {
        							if (success) {
        								try{
            								form.down('#courseCESMCodeId').setValue(courseCESMCodeId);
        								}
        								catch(e){
        									console.log('errorCatch2');
        								}
        							}
        						}
        					});
        					
        					var documentStore=$this.getStore('course.CourseDocument');
        					documentStore.getProxy().extraParams = {
        						courseId: ids,
        						sort : null
        					};
        					documentStore.load();

        					// Added code for editable course code for deleted courses
        					if(formModel.data.whetherDeleted==true){
        						var course_codeField = Ext.ComponentQuery.query('#courseCode')[0];
        						course_codeField.setReadOnly(false);
        					}else{
        						var course_codeField = Ext.ComponentQuery.query('#courseCode')[0];
        						course_codeField.setReadOnly(true);
        					}

        					if(formModel.data.includeinPromotion){

        						includeinPromotion.items.items[0].setValue(true);
        						includeinPromotion.items.items[1].setValue(false);
        					}else{
        						includeinPromotion.items.items[0].setValue(false);
        						includeinPromotion.items.items[1].setValue(true);
        					}
        					
        					if(whetherSchool) {
        						var tabPanel = $this.getCoursetabstructure().items.items[4];
        						tabPanel.remove(tabPanel.items.getAt(5));
        					}

        					if(formModel.data.sectionAtComponentLevel){
        						form.getForm().findField("CalculationRule").setVisible(true);
        						var ruleCalculation = form.getForm().findField("CalculationRule")
        						setTimeout(function(){
        							ruleCalculation.setValue(formModel.data.calculationRule);
        						},300);
        					}

        					if(!isNullOrEmpty(formModel.data.sectionAtComponentLevel) && formModel.data.sectionAtComponentLevel){
        						secAtComponent=formModel.data.sectionAtComponentLevel
        					}
        					
        					form.getForm().findField("courseCredits").setReadOnly(true);
							form.getForm().findField("ectsCredits").setReadOnly(true);
        					
        					Ext.Ajax.request({
        						method: "GET",
        						type: 'rest',
        						url: cvUrl,
        						params: {
        							courseId: ids,
        							sectionAtComponentLevel:secAtComponent
        						},
        						success: function(f, action) {
        							var cvId = Ext.JSON.decode(f.responseText);
        							if(cvId.rows.length>0)
        							{
        								try{
            								form.getForm().findField("courseCredits").setReadOnly(true);
            								form.getForm().findField("ectsCredits").setReadOnly(true);
            								form.getForm().findField("courseCreditsNBC").setReadOnly(true);
            								form.getForm().findField("ectsCreditsNBC").setReadOnly(true);
        								}
        								catch(e){
        									console.log('errorCatch2');
        								}
        							}
        							else
        								{
        								form.getForm().findField("courseCredits").setReadOnly(false);
        								form.getForm().findField("ectsCredits").setReadOnly(false);
        								form.getForm().findField("courseCreditsNBC").setReadOnly(false);
        								form.getForm().findField("ectsCreditsNBC").setReadOnly(false);
        								}
        						}
        					});
        					Ext.getBody().unmask();        					
    					}
    					catch(e){
    						console.log('errorCatch2');
    					}
    				}
    			});
    		} else {
    			Ext.getBody().unmask();
    			showWarningMessage(getCommonTranslation('COURSE'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    		}
    	} 
    	catch (e) {
    		Ext.getBody().unmask();
    		console.log('errorCatch');
    		//--
    	}
    },
    editCourseTab: function() {
    	setTimeout(function(){
        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    	},10);
        var $this = this;
        var a, b;
        var grid = this.getSearchresultgrid();
        var record = grid.getSelectionModel().getSelection()[0];
        $this.linkEditCourse(a, b, record);
        
        setTimeout(function(){
        	Ext.getBody().unmask();
    	},5000);
    },

    viewCourseTab: function() {
    	setTimeout(function(){
        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    	},10);
        var $this = this;
        var a, b;
        var grid = this.getSearchresultgrid();
        var record = grid.getSelectionModel().getSelection()[0];

        $this.linkEditCourse(a, b, record,true);
        var basicDetailfrm = $this.getBasicdetailform().getForm();
        toggleReadOnlyFormItems(basicDetailfrm, true);
        $this.getBasicdetailform().down('#modulePrerequisiteId').setDisabled(true);
        $this.getBasicdetailform().down('coursedocumentgrid').down('#btnDelete').setVisible(false);
        $this.getBasicdetailform().down('#basicdetail_FormSubmitButtonId').setVisible(false);
        $this.getBasicdetailform().down('#uploadCourseItemId').setVisible(false);
        
        setTimeout(function(){
            Ext.getBody().unmask();
        },5000);
        
    },
    openNewCourseTab: function() {
        var me = this;
        var contentpanel = me.getContentpanel();
        var courseform = Ext.widget('createcourseform');
        var tabName = getCommonTranslation('CREATE_COURSE');
        var alinfomodel = Academia.model.authentication.ALInfoModel;
        var wheatherSchool = alinfomodel.get('wheatherSchool');
        if(wheatherSchool){
        	var stage_type=courseform.down('#stage_Type');
        	var stage_type_Stroe=stage_type.getStore();
        	stage_type_Stroe.load({
				  callback: function(record, operation, success) {
					  if (success) {
						  stage_type.setValue('COURSE_EXECUTION');
					  }
				  }
			  });
        	stage_type.hide();
        	var whetherEvaluation=courseform.down('#whetherEvaluationExternalItemId');
        	whetherEvaluation.items.items[0].setValue(false);
        	whetherEvaluation.items.items[1].setValue(true);
        	whetherEvaluation.hide();
        	courseform.down('#course_Deficiency_Status_Id').hide();
        	courseform.down('#course_Deficits_Id').hide();
        	courseform.down('#course_Deficits_Point_Id').hide();
        	courseform.down('#whetherCourseExemptionItemId').hide();
        }
        
        var getcontroller=me.getController('menu.CoreERPNavigationController');
        var getTab = null;
        for(var i =0 ;i<contentpanel.items.length;i++){
        	if(contentpanel.items.items[i].title == tabName){
        		getTab= contentpanel.items.items[i];
        	}
        }
        if(getTab!=null){
        	contentpanel.remove(getTab, true);
        }
   	   
        if(contentpanel!=undefined){
        	var getTab =Ext.create('Academia.view.course.CourseParentPanel',{
        		title: tabName,
        		closable:true,
        		autoScroll:true,
        		itemId:'addCourseParentPnl',
        		menuColorCls: CONSTANTS.MENU_COLOR_THREE,
        		items:[courseform]
        	}); 
        	contentpanel.add(getTab);																	
        	contentpanel.setActiveTab(getTab);
        	contentpanel.doLayout();		
        }
        
        //openTab(contentpanel, tabName, courseform,CONSTANTS.MENU_COLOR_THREE);
        var documentStore=me.getStore('course.CourseDocument');
        documentStore.removeAll();

    },

    linkNoSpclGroup: function(view, rowIndex, record) {

    	var contentpanel = this.getContentpanel();
    	var structure = Ext.widget('noofcoursespclassogridwindow');
    	var tabName = getProgramandcourseTranslation('SPECIALIZATION_ASSOCIATED');

    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentpanel.remove(getTab, true);
    	}
    	openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_FIVE);
        var courseId = record.data.ID;
        var formWindow = this.getNoofcoursespclassogridwindow();
        if (!formWindow) {
            Ext.widget('noofcoursespclassogridwindow');
            formWindow = this.getNoofcoursespclassogridwindow();
        }
        var store = this.getCourseNoOfCourseSpecializationAssoGridStoreStore();
        store.getProxy().extraParams = {
            courseId: courseId
        };
        store.load();
    },
    linkNoCoursesDepartments: function(view, rowIndex, record) {

        var courseId = record.data.ID;
        var formWindow = this.getNoofcoursesdepartmentwindow();
        if (!formWindow) {
            Ext.widget('noofcoursesdepartmentwindow');
            formWindow = this.getNoofcoursesdepartmentwindow();
        }
        formWindow.show();
        var grid = this.getNoofcoursesdepartmentgrid();
        var store=grid.getStore();
        store.getProxy().extraParams = {
            courseId: courseId
        };
        store.load();
    },
    linkNoOfReqCourse: function(view, rowIndex, record) {

    	var contentpanel = this.getContentpanel();
    	var structure = Ext.widget('noofregcoursegrpassogridwindow');
    	var tabName = getProgramandcourseTranslation('REGULAR_GROUP_ASSOCIATED');

    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentpanel.remove(getTab, true);
    	}
    	openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_FIVE);
    	if(record.data.NO_OF_REG_COURSE_GROUP_ASSO>0){
        var courseId = record.data.ID;
        var formWindow = this.getNoofregcoursegrpassogridwindow();
        if (!formWindow) {
            Ext.widget('noofregcoursegrpassogridwindow');
            formWindow = this.getNoofregcoursegrpassogridwindow();
        }
        //formWindow.show();
        var store = this.getCourseNoOfRegCourseGroupAssoGridStoreStore();
        store.getProxy().extraParams = {
            courseId: courseId,
            regularGroup: true
        };
        store.load();
    	}
    },
    linkNoOfAudit: function(view, rowIndex, record) {

    	var contentpanel = this.getContentpanel();
    	var structure = Ext.widget('noofauditgrpgridwindow');
    	var tabName = getProgramandcourseTranslation('AUDIT_GROUP_ASSOCIATED');

    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentpanel.remove(getTab, true);
    	}
    	openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_FIVE);
    	if(record.data.NO_OF_AUDIT_GROUP_ASSO>0){
        var courseId = record.data.ID;

        var formWindow = this.getNoofauditgrpgridwindow();
        if (!formWindow) {
            Ext.widget('noofauditgrpgridwindow');
            formWindow = this.getNoofauditgrpgridwindow();
        }
        //formWindow.show();
        var store = this.getCourseNoOfAuditCourseGroupAssoGridStoreStore();
        store.getProxy().extraParams = {
            courseId: courseId
        };
        store.load();
    	}
    },
    linkNoOfCourse: function(view, rowIndex, record) {

        var courseId = record.data.ID;

        var formWindow = this.getNoofcoursespclassogridwindow();
        if (!formWindow) {
            Ext.widget('noofcoursespclassogridwindow');
            formWindow = this.getNoofcoursespclassogridwindow();
        }
        formWindow.show();
        var store = this.getCourseNoOfCourseSpecializationAssoGridStoreStore();
        store.getProxy().extraParams = {
            courseId: courseId
        };
        store.load();

    },

    linkProgramAssociated: function(view, rowIndex, record) {

    	if(record.data.PROG_ASSO_PROG_COURSE_COUNT>0){
    		var courseId = record.data.ID;

    		var formWindow = this.getNoofprogassociatedwindow();
    		if (!formWindow) {
    			Ext.widget('noofprogassociatedwindow');
    			formWindow = this.getNoofprogassociatedwindow();
    		}
    		formWindow.show();
    		var store = this.getStore("course.NoOfProgAssociatedGridStore");
    		store.getProxy().extraParams = {
    			courseId: courseId
    		};
    		store.load();
    	}
    },
    
    linkNoOfCourseDocuments: function(view, rowIndex, record) {
    	
    	 var docWindow = this.getCoursedocumentlist();
    	 var courseID = record.data.ID;
	        if (!docWindow) {
	            /*Ext.widget('coursedocumentlist');
	            docWindow = this.getCoursedocumentlist();*/
	        	docWindow =  Ext.widget('coursedocumentlist',{
           			itemId:'coreERPCourseDocumentList'
           		});
	        }
	        docWindow.show();
	        var grid = this.getCourseDocumentList();
	        var store = grid.getStore();
		    store.getProxy().extraParams = {
		    	courseId: courseID
		    };
		    store.load();
    },
    
    linkNoOfVariants: function(view, rowIndex, record) {
    	var contentpanel = this.getContentpanel();
    	var structure = Ext.widget('noofvariantgridwindow');
    	var tabName = getCommonTranslation('NO_OF_COURSE_VARIANT_ASSOCIATED');

    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentpanel.remove(getTab, true);
    	}
    	openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_FIVE);
    	var assignSection=record.data.SECTION_TYPE;
    	var alinfomodel = Academia.model.authentication.ALInfoModel;
		var whetherSchool = alinfomodel.get('wheatherSchool');
    	if(record.data.NO_OF_COURSE_VARIANTS>0){
    		var courseId = record.data.ID;

    		if(assignSection == 'Course Section'){	
    			var formWindow = this.getNoofvariantgridwindow();
    			if (!formWindow) {
    				Ext.widget('noofvariantgridwindow');
    				formWindow = this.getNoofvariantgridwindow();
    			}
    			var grid = formWindow.down("#noofvariantgrid");
    			grid.setVisible(true);
    			grid.columns[0].setVisible(true);
    			grid.columns[1].setVisible(true);
    			grid.columns[2].setVisible(true);
    			grid.columns[3].setVisible(false);
    			grid.columns[4].setVisible(false);
    			grid.columns[5].setVisible(true);
    			grid.columns[6].setVisible(false);
    			grid.columns[7].setVisible(true);
    			grid.columns[8].setVisible(true);
    			if(whetherSchool) {
    				grid.columns[6].setVisible(false);
    			}
    			var store = this.getStore('course.NoOfCourseVariantAssoGridStore');
    			var submitURL=SERVERURL.FIND_COURSE_VARIENT_BY_CRITERIA;
    			store.getProxy().api.read=submitURL;
    			store.getProxy().extraParams = {
    				courseId: courseId
    			};
    			store.load();
    		}else{
    			var formWindow = this.getNoofvariantgridwindow();
    			if (!formWindow) {
    				Ext.widget('noofvariantgridwindow');
    				formWindow = this.getNoofvariantgridwindow();
    			}
    			var grid = formWindow.down("#noofvariantgrid");
    			grid.setVisible(true);
    			grid.columns[0].setVisible(true);
    			grid.columns[1].setVisible(true);
    			grid.columns[2].setVisible(true);
    			grid.columns[3].setVisible(true);
    			grid.columns[4].setVisible(true);
    			grid.columns[5].setVisible(true);
    			grid.columns[6].setVisible(true);
    			grid.columns[7].setVisible(true);
    			grid.columns[8].setVisible(false);
    			if(whetherSchool) {
    				grid.columns[6].setVisible(false);
    			}
    			var store = this.getStore('course.NoOfCourseVariantAssoGridStore');
    			var submitURL= SERVERURL.COURSE_VARIANT_GRID_DATA;
    			store.getProxy().api.read=submitURL;
    			store.getProxy().extraParams = {
    				courseId: courseId
    			};
    			store.load();
    		}
    	}
    },
    linkNoOfAcademyLocation: function(view, rowIndex, record) {

        var courseId = record.data.ID;
        var formWindow = this.getNoofcourseacademylocationwindow();
        if (!formWindow) {
            Ext.widget('noofcourseacademylocationwindow');
            formWindow = this.getNoofcourseacademylocationwindow();
        }
        formWindow.show();
        var detailPanel = this.getCourselinkdetails();
        detailPanel.down('#courseGroup').setVisible(false);
        detailPanel.down('#courseCode').setVisible(true);
        detailPanel.down('#courseName').setVisible(true);
        detailPanel.down('#courseGroupName').setVisible(false);
        detailPanel.down('#courseSpecializationName').setVisible(false);
        detailPanel.down('#courseCode').setValue(record.data.COURSE_CODE);
        detailPanel.down('#courseName').setValue(record.data.COURSE_NAME);
        var store = this.getStore('course.academyLocation.MappedCourseAcademyLocationStore');
        store.getProxy().extraParams = {
            courseId: courseId
        };
        store.load();
    },
    deleteCourseTab: function() {

    	var $this = this;
        var grid = this.getSearchresultgrid();
        var grdStore = grid.getStore();

        if (grid.getSelectionModel().getCount() > 0) {
        	showConfirmMessage(getCommonTranslation('COURSE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var records = grid.getSelectionModel().getSelection();
                    var id = records[0].get("ID");
                    
                    var whetherCourseDel = $this.wheatherCourseDeletable(id);
                    
                    /*Ext.Ajax.request({
                        method: "DELETE",
                        type: 'rest',
                        url: SERVERURL.COURSES_DELETE + '?id=' + id,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        params:{
             							id:id
             						},
                        success: function(form, action) {
                        	if(form.responseText == "DEPENDENCY_EXISTS"){
                        		showWarningMessage(getCommonTranslation('COURSE'), getProgramandcourseTranslation('COURSE_DELETE_MSG'));                         		
                        	}else{
                            grdStore.reload();
                            showSuccessMessage(getCommonTranslation('COURSE'), getCommonTranslation('SUCCESS'));
                        	}
                        }
                    });*/
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('COURSE'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }

    },
    // when grid render than call courseComponentGridRender 
    courseComponentGridRender: function() {
        var $this = this;
        var store = $this.getCoursemastergrid().getStore();
        store.load();
    },
    // getting the values from search form
    loadGridAndSearchCourses: function(model, records) {
        var quickSearchForm = this.getCourseMasterQuickFilter();
        quickSearchForm.down('#courseQuickSearchId').setDisabled(true);
        var jsonFormatFormData = this.createJsonFormat(quickSearchForm, records);
        var user=this.getCurrentlyLoggedInUser();
		   var locations = [];
		  if(user.code!="sysadmin"){
		var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
		for(var i=0; i<academyLocationList.length; i++){
			locations.push(academyLocationList[i].id);
		}
		  jsonFormatFormData.searchCriterias.push({
	     		paramCode: "academyLocationIds",
	     		paramValues: [locations.join()]
	     	});
		  }
        var searchResultGrid = this.getSearchresultgrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.COURSE_LIST_VIEWCODE);
        searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,quickSearchForm.down('#courseQuickSearchId'));
    },
    // rendering the field values into json
    createJsonFormat: function(quickSearchForm, record) {
    	
    	var formvalue = quickSearchForm.getForm().getValues();

        var values = new Object();
        values.configCode = CONSTANTS.CB.COURSE_LIST_CONFIGCODE;
        var searchcriteria = new Array();
        
        if (!isNullOrEmpty(formvalue.courseName)) {
        	var courseId = formvalue.courseName;
        	searchcriteria.push({
        		paramCode: "COURSE_ID",
        		paramValues: [courseId]
        	});
        }
        if(!isNullOrEmpty(formvalue.department)){
        	var departmentID = formvalue.department;
        	searchcriteria.push({
        		paramCode: "DEPARTMENT_ID",
        		paramValues: [departmentID]
        	});
        }
        if(!isNullOrEmpty(formvalue.courseMarkGrade)){
        	var markTypeID = formvalue.courseMarkGrade;
        	if(markTypeID=="MARK"){
        		searchcriteria.push({
            		paramCode: "MARKING_TYPE",
            		paramValues: ["M"]
            	});
        	}else{
        		searchcriteria.push({
            		paramCode: "MARKING_TYPE",
            		paramValues: ["G"]
            	});
        	}
        }
        if(!isNullOrEmpty(formvalue.sectionType)){
        	if(formvalue.sectionType=="PROGRAM_BATCH_SECTION"||formvalue.sectionType=="Program Batch Section"){
        		searchcriteria.push({
            		paramCode: "SECTION_TYPE",
            		paramValues: ["ProgramBatchSection"]
            	});
        	}else if(formvalue.sectionType=="COURSE_SECTION"||formvalue.sectionType=="Course Section"){
        		searchcriteria.push({
            		paramCode: "SECTION_TYPE",
            		paramValues: ["CourseSection"]
            	});
        	}
        	
        }
        
        
      //  if(formvalue.whetherIncludeDeeletedCourses){
        	searchcriteria.push({
                paramCode: "WHETHER_DELETED",
                paramValues: [formvalue.whetherIncludeDeeletedCourses]
            });
      //  }
       
        searchcriteria.push({
            paramCode: "PARENT_COURSE_ID",
            paramValues: ["null"]
        });
        values.searchCriterias = searchcriteria;
        return values;
    },
    gridRenderFunction: function(grid) {
    	 grid.addButtonToolbar();
       
    },
    //***************Export to Pdf and Excel***************************************
    exportUserList : function(exportUrl,filetype,whetherAll) {
        var quickSearchForm=this.getCourseMasterQuickFilter(); 
        var searchResultGrid = this.getSearchresultgrid();
        var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
        var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
        var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
        var visibleColumns=this.getVisibleColumns(searchResultGrid);
        var reportTitle=getCommonTranslation("COURSE_LIST");
if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
                      jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
               }
	searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

},

		createSearchCriteriaString: function(searchForm) {
		    	 var me=this;
		        var formValues = new Array();
		        formValues = searchForm.getValues();        
		        var searchCriteriaString="";
		        for (var key in formValues) {
		        	var value = formValues[key];            
		            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'&& key !=="whetherIncludeDeeletedCourses"){
		               var keyValueJsonObject = me.getJsonObject( key , value);
		searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
		            }
		        }
		        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
		        return searchCriteriaString;
		}, 
		getJsonObject : function(key, value, additionalValue) {
			if (value != '' && value != null
					&& additionalValue == undefined) {
				return {
					"paramCode" : key,
					"paramValues" : [ value ]
				};
			} else if (value != '' && additionalValue != undefined) {
				return {
					"paramCode" : key,
					"paramValues" : [ value, additionalValue ]
				};
			}
		},
		
		  getDownloadFileForCourseDocument : function(documentId){

		    	if(!isNullOrEmpty(documentId)){
		    		var csvForm = Ext.create('Ext.form.Panel'); 
		    		csvForm.getForm().submit({
		    			target: '_blank',
		    			method:'GET',
		    			params :{
		    				access_token : Ext.Ajax.defaultHeaders.access_token
		    			},
		    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		    			url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
		    			standardSubmit :true
		    		});
		    	}
		    },
		wheatherCourseDeletable : function(courseId) {
			
			var $this = this;
			var responseData = "";
			Ext.Ajax.request({
                method: "GET",
                type: 'rest',
                url: SERVERURL.PATH_FIND_WHETHER_COURSE_DELETABLE + '?courseId=' + courseId,
                success: function(success) {
                	
                	if(success.responseText=="COURSE_ASSOCIATED_WITH_VARIANT") {
                		showWarningMessage(getCommonTranslation('COURSE'), getProgramandcourseTranslation('COURSE_ASSOCIATED_WITH_VARIANT'));
                	} else if(success.responseText=="COURSE_ASSOCIATED_WITH_PROGRAM_BATCH_COURSE_PARAM") {
                		showWarningMessage(getCommonTranslation('COURSE'), getProgramandcourseTranslation('COURSE_ASSOCIATED_WITH_PROGRAM_BATCH_COURSE_PARAM'));
                	} else if(success.responseText=="COURSE_ASSOCIATED_WITH_BATCH") {
                		showWarningMessage(getCommonTranslation('COURSE'), getProgramandcourseTranslation('COURSE_ASSOCIATED_WITH_BATCH'));
                	} else if(success.responseText=="COURSE_ASSOCIATED_WITH_ACADEMY_LOCATION") {
                		showWarningMessage(getCommonTranslation('COURSE'), getProgramandcourseTranslation('COURSE_ASSOCIATED_WITH_ACADEMY_LOCATION'));
                	} else {
                		$this.deleteCourse(courseId);
                	}
                }
		});
		},
		
		deleteCourse : function(id) {
			
			var $this = this;
	        var grid = this.getSearchresultgrid();
	        var grdStore = grid.getStore();
	        var searchForm = this.getCourseMasterQuickFilter();
	        var courseCodeField =  searchForm.down("#courseNameQuickFiltr");
	        courseCodeField.reset();
	        courseCodeField.clearValue();
			var searchStore = courseCodeField.getStore();
			
			Ext.Ajax.request({
                method: "DELETE",
                type: 'rest',
                url: SERVERURL.COURSES_DELETE + '?id=' + id,
                headers: {
                    'Content-Type': 'application/json'
                },
                params:{
     				id:id
     			},
                success: function(form, action) {
                	if(form.responseText == "DEPENDENCY_EXISTS"){
                		showWarningMessage(getCommonTranslation('COURSE'), getProgramandcourseTranslation('COURSE_DELETE_MSG'));                         		
                	}else{
                    grdStore.reload();
                    searchStore.reload();
                    showSuccessMessage(getCommonTranslation('COURSE'), getCommonTranslation('SUCCESS'));
                	}
                }
        });
	},
	getVariantDetails : function(record,grid){

		var window =  this .getCoursevariantdetailslist();
		if (!window) {
			Ext.widget('coursevariantdetailslist');
			window = this.getCoursevariantdetailslist();
		}
		window.show();
		var grid = this.getCourseVariantDetailsList();
		var alinfomodel = Academia.model.authentication.ALInfoModel;
		var wheatherSchool = alinfomodel.get('wheatherSchool');
		if(wheatherSchool) {
			//Hidden period column on window for school
			grid.columns[3].hide();
			grid.columns[3].setVisible(false);
		}
		if(!isNullOrEmpty(record)){
			var store = grid.getStore();
			store.getProxy().extraParams = {
				courseVariantIds: record.data.id
			};
			store.load();
		}
	},
	showHideCourseTabs :function(structure, permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var bulkCourse = false;
		Ext.each(permissionList, function(privilege) {
			if (privilege === "BULK_COURSES") {
				bulkCourse=true;
			}
		});

		var panelItem = new Array();
		var $this = this;
		var newcont = structure.items.items.length;
		var insertPosition = newcont;
		panelItem.push({
			xtype:'tabpanel',
			plain: true,
			style:{overflow:'hidden !important',margin:'0!important'},
			bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
			frame: false,
			border:false,
			defaults: {
				labelAlign: 'top'
			},
			items:[{
				xtype: 'courselistgrid',
				title: getCommonTranslation('SEARCH'),
				tabCls: 'right-tab',
				listeners: {
                	activate: function(me, eOpts){
                		var contentPanelMain = $this.getActiveTabfromContentPanel();
                		if(!isNullOrEmpty(contentPanelMain)){
                			contentPanelMain.scrollBy(0,1);
                			contentPanelMain.scrollBy(0,-1);
                		}
                	}
                }
			}, {
				xtype: 'advancedsearchquerybuilder',
				itemId: 'advancedsearchCourse',
				searchConfigCode : CONSTANTS.CB.COURSE_LIST_CONFIGCODE,
				searchResultViewCode: CONSTANTS.CB.COURSE_LIST_VIEWCODE,
				permissionMapKey:'COURSE_PRIVILEGES',
				gridTitle: getCommonTranslation("COURSE_LIST"),
				tabCls: 'right-tab'
			}]
		});
    	var insertAt = panelItem["0"].items.length;;
		if(bulkCourse) {
			panelItem["0"].items[insertAt] = {
					xtype: 'coursecreationuploaddownloadstructure',
					title: getCommonTranslation('IMPORT_COURSES'),
				};
			insertAt = insertAt+1;
		}
		structure.insert(insertPosition, panelItem);
	},
	setTabsVisibility:function(tab2, structure) {
    	var panelItem = new Array();
    	var $this = this;
    	var newcont=structure.items.items.length;
    	var insertPosition=newcont+1;
    	if(tab2) {
    		panelItem.push({
    	    	xtype:'tabpanel',
    	    	plain: true,
    	    	autoScroll: false,
    	    	cls:'horizontalScrollingFixed',
    	  	style:{overflow:'hidden !important',margin:'0!important'}, 
    	    	frame: false,
    	    	border:true,
    	    	items:[{
    	    		title: getCommonTranslation('SUBJECT_DETAILS'),
    	    		xtype:'container',
    	    		items:[
    	    		       {
    	    			xtype:'basicdetailform',
    	    			closable: false
    	    		}]},{		 
    	    			title: getCommonTranslation('COURSE_VARIANTS'),
    	    			xtype:'container',
    	    			items:[{
    	    				xtype: 'coursevariantstructure',
    	    				closable: false
    	    			}]},{
    	    				title : getCommonTranslation('LINK_ACEDEMY_LOCATION'),
    	    				xtype:'container',
    	    				items:[{
    	    					xtype: 'academylocationstructure',
    	    					closable: false
    	    				}]},{
    		        		   title: getCommonTranslation('COURSE_COMPONENT'),
    		        		   xtype:'coursecomponentsgrid',
    		        		   closable: false
    		        	   },{		 
    		        		   title: getCommonTranslation('TOPIC'),
    		        		   xtype: 'topicgrid',
    		        		   closable: false
    		        	   },{
    		        		   title : getCommonTranslation('COURSE_EQUIVANENCE'),
    		        		   xtype: 'courseequivalencegrid',
    		        		   closable: false
    		        	   }/*,{
    		        		   title : getCommonTranslation('HISTORY'),
    		        		   xtype: 'coursehistory',
    		        		   closable: false
    		        	   }*/]
    	    });
    	} else {
    		panelItem.push({
    	    	xtype:'tabpanel',
    	    	plain: true,
    	    	autoScroll: false,
    	    	cls:'horizontalScrollingFixed',
    	  	style:{overflow:'hidden !important',margin:'0!important'}, 
    	    	frame: false,
    	    	border:true,
    	    	items:[{
    	    		title: getCommonTranslation('SUBJECT_DETAILS'),
    	    		xtype:'container',
    	    		items:[
    	    		       {
    	    			xtype:'basicdetailform',
    	    			closable: false
    	    		}]},{		 
    	    			title: getCommonTranslation('COURSE_VARIANTS'),
    	    			xtype:'container',
    	    			items:[{
    	    				xtype: 'coursevariantstructure',
    	    				closable: false
    	    			}]},{
    	    				title : getCommonTranslation('LINK_ACEDEMY_LOCATION'),
    	    				xtype:'container',
    	    				items:[{
    	    					xtype: 'academylocationstructure',
    	    					closable: false
    	    				}]},{
    		        		   title: getCommonTranslation('COURSE_COMPONENT'),
    		        		   xtype:'coursecomponentsgrid',
    		        		   closable: false
    		        	   },{		 
    		        		   title: getCommonTranslation('TOPIC'),
    		        		   xtype: 'topicgrid',
    		        		   closable: false
    		        	   }]
    	    });
    	}
    	structure.insert(insertPosition,panelItem);
    	Ext.defer(function() {
    		//$this.getSessionValues(structure);
    	}, 2000, this);
    },
    addMoreDetailedOfDepartmentInBasicDetail:function(isEdit,record, isView){
		var $this = this;
		var createcourseform=$this.getBasicdetailform()
		if(isEdit == "Add"){
			var panelContiner = createcourseform.down('#panelIdH');
			var indx;
			if(panelContiner.items.items.length<=3){
				var panelItem = new Array();
				indx = panelContiner.items.items.length;
				panelItem.push({

					xtype : 'fieldcontainer',
					layout : 'hbox',
					width: '100%',
					scope: $this,
					defaults : {
						labelAlign : 'top',
						width:'226'
					},
					layout : {
						type : 'hbox'
					},
					margin: '10 0 0 0',
					padding: '0 0 0 0',
					items:[{
						xtype: 'customcombobox',
						width: 226,
						name: 'departmentName',
						store: Ext.create('Academia.store.course.CourseDepartmentStore'),
						valueField: 'id',
						displayField: 'value',
						allowBlank: false,
						typeAhead: false,
						queryParam:'qry',
	        			minChars:3,
	        			rowIndx:indx,
	                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                    forceSelection:true,
	                    listConfig: {
	        				  listeners: {
	        						beforeshow: function(picker) {
	        							picker.minWidth = picker.up('combobox').getSize().width;
	        						}
	        					},
	        	                loadingText: getCommonTranslation('SEARCHING'),
	        	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        	                getInnerTpl: function() {
	        	                    return '<div class="search-item">' +
	        	                        '{value}' +
	        	                    '</div>';
	        	                }
	        	            },
						listeners:{
							select:function(obj,rec,value){
								

								var departmentId=rec[0].get('id');
								var flag = true;
								var pnlMain = obj.up("#panelIdH");
								var rowIndx = obj.rowIndx;
								if(!isNullOrEmpty(pnlMain)){
									pnlMain.items.each(function(item, index, items) {
										var deptNameVal = item.down("[name=departmentName]").getValue();
										if(departmentId == deptNameVal && rowIndx != index){
											flag = false;
											return false;
										}
									});

									if(flag){
										var nextSiblingField = obj.nextSibling();
										nextSiblingField.setDisabled(false);
										nextSiblingField.reset();
										if (departmentId > 0) {
											var store=nextSiblingField.getStore();
											store.getProxy().extraParams = {
												parentId : departmentId
											};
											store.load();
										}
									}
									else{
										obj.reset();
										var nextSiblingField = obj.nextSibling();
										nextSiblingField.reset();
										nextSiblingField.setDisabled(true);
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_DEPARTMENT_ALREADY_SELECTED_MSG'));
										return false;
									}
								}
								
							},
							change:function(obj,rec,value){
								var nextSiblingField = obj.nextSibling();
								nextSiblingField.reset();
								nextSiblingField.setDisabled(true);

							}
						}
					},
					{
						xtype: 'customcombobox',
						name: 'subDepartmentName',
						disabled: true,
						editable: false,
						queryMode: 'local',
						valueField: 'id',
						displayField: 'value',
						width: 226,
						listeners: {
							render: function(combo) {
								var store = Ext
								.create('Academia.store.course.CourseSubDepartmentStore');
								combo.bindStore(store);
							}
						}
					},
					{    
						xtype: 'numberfield',
						name: 'weightage',
						minValue : 1,
						maxValue:100,
	    				maxLength: 3,
	    				allowBlank:false,
	    				allowExponential:false,
	    				keyNavEnabled: false,
	    				mouseWheelEnabled: false,
					},{
	    				xtype: 'hidden',
	    				name: 'courseDepartmentId',
					},
					{
						xtype: 'button',
						glyph: ICONGLYPH.DELETEGLYPH,
						itemId: 'detailedDeleteButton1',
						width: 'auto',
						cls: 'CustomBodyBtnReject',
						tooltip: getCommonTranslation('DELETETOOLTIP'),
						style:{
							marginTop:'8px',
							marginLeft:'10px'
						},
						listeners:{
							click:function(obj){
								var container = obj.up('fieldcontainer');
								//panelContiner.remove(container);
								//$this.getCreatecourseform().getForm().isValid();
								//$this.getMastertimetableDetailedwindow().down('#SubmitBtn').setDisabled(false);
							}
						}
					},
					{
						xtype: 'button',
						itemId: 'addDetailedBtn1',
						width: 'auto',
						cls: 'CustomBodyBtnSettings',
						width: 'auto',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'8px'
						}
					}]

				});
				panelContiner.add(panelItem);
				this.departmentHideShowDetailsOfBasic(panelContiner);
				panelContiner.doLayout();
			}
		}else{
			var panelContiner = createcourseform.down('#panelIdH');
			panelContiner.removeAll();
			var indx = 0;
			if(record.length>0){
				record.forEach(function(obj){
					var panelItem = new Array();
					var departmentId = obj.department.id;
					var subDepartmentId = isNullOrEmpty(obj.subDepartment)? null : obj.subDepartment.id;
					var weightage = obj.weightage;
					if(panelContiner.items.length == 0){
						panelItem.push({
							xtype : 'fieldcontainer',
							layout : 'hbox',
							width: '100%',
							scope: $this,
							defaults : {
								labelAlign : 'top',
								width:'226'
							},
							layout : {
								type : 'hbox'
							},
							margin: '10 0 0 0',
							padding: '0 0 0 0',
							items:[{
								xtype: 'customcombobox',
								width: 226,
								name: 'departmentName',
								fieldLabel: getCommonTranslation('COURSE_DEPARTMENT'),
								store: Ext.create('Academia.store.course.CourseDepartmentStore'),
								valueField: 'id',
								displayField: 'value',
								allowBlank: false,
								typeAhead: false,
								queryParam:'qry',
								minChars:3,
								rowIndx:indx,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								forceSelection:true,
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{value}' +
										'</div>';
									}
								},
								listeners:{
									render: function(combo){
										var cDepartmentStore= combo.getStore();
										cDepartmentStore.getProxy().extraParams = {
											limit:-1
										};
										cDepartmentStore.load({
											callback:function(record, operation, success){
												combo.setValue(departmentId);
												if(isView){
													combo.setReadOnly(true);
												}
											}
										});
									},
									select:function(obj,rec,value){
										var departmentId=rec[0].get('id');
										var flag = true;
										var pnlMain = obj.up("#panelIdH");
										var rowIndx = obj.rowIndx;
										if(!isNullOrEmpty(pnlMain)){
											pnlMain.items.each(function(item, index, items) {
												var deptNameVal = item.down("[name=departmentName]").getValue();
												if(departmentId == deptNameVal && rowIndx != index){
													flag = false;
						        					return false;
												}
											});
											
											if(flag){
												var nextSiblingField = obj.nextSibling();
												nextSiblingField.setDisabled(false);
												nextSiblingField.reset();
												if (departmentId > 0) {
													var store=nextSiblingField.getStore();
													store.getProxy().extraParams = {
														parentId : departmentId
													};
													store.load();
												}
											}
											else{
												obj.reset();
												var nextSiblingField = obj.nextSibling();
												nextSiblingField.reset();
												nextSiblingField.setDisabled(true);
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_DEPARTMENT_ALREADY_SELECTED_MSG'));
												return false;
											}
										}
									},
									/*change:function(obj,rec,value){
			                    var nextSiblingField = obj.nextSibling();
			                    nextSiblingField.reset();
			                    nextSiblingField.setDisabled(true);

			                    }*/
								}
							},
							{
								xtype: 'customcombobox',
								name: 'subDepartmentName',
								fieldLabel: getCommonTranslation('COURSE_SUB_DEPARTMENT'),
								disabled: true,
								editable: false,
								queryMode: 'local',
								valueField: 'id',
								displayField: 'value',
								store: Ext.create('Academia.store.course.CourseSubDepartmentStore'),
								width: 226,
								listeners: {
									render: function(combo) {
										var subDepartmentStore= combo.getStore();
										subDepartmentStore.getProxy().extraParams = {
											limit:-1,
											parentId : departmentId
										};
										subDepartmentStore.load({
											callback:function(record, operation, success){
												combo.setValue(subDepartmentId);
												combo.setDisabled(false);
												if(isView){
													combo.setReadOnly(true);
												}
											}
										});
									}
								}
							},
							{    
								xtype: 'numberfield',
								name: 'weightage',
								minValue : 1,
								maxValue:100,
								fieldLabel: getCommonTranslation('DEPARTMENT_WEIGHTAGE_IN_PERCENTAGE'),
								maxLength: 3,
								allowBlank:false,
								allowExponential:false,
								keyNavEnabled: false,
								mouseWheelEnabled: false,
								value:weightage,
								readOnly:(isView ? true : false)
							},{
								xtype: 'hidden',
								name: 'courseDepartmentId',
							},
							{
								xtype: 'button',
								itemId: 'addDetailedBtn',
								width: 'auto',
								cls: 'CustomBodyBtnSettings',
								disabled:(isView ? true : false),
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD'),
								style:{
									marginTop:'30px'
								}
							}]

						});
					}else{
						panelItem.push({
							xtype : 'fieldcontainer',
							layout : 'hbox',
							width: '100%',
							scope: $this,
							defaults : {
								labelAlign : 'top',
								width:'226'
							},
							layout : {
								type : 'hbox'
							},
							margin: '10 0 0 0',
							padding: '0 0 0 0',
							items:[{
								xtype: 'customcombobox',
								width: 226,
								name: 'departmentName',
								store: Ext.create('Academia.store.course.CourseDepartmentStore'),
								valueField: 'id',
								displayField: 'value',
								allowBlank: false,
								typeAhead: false,
								queryParam:'qry',
								minChars:3,
								rowIndx:indx,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								forceSelection:true,
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{value}' +
										'</div>';
									}
								},
								listeners:{
									render: function(combo){
										var cDepartmentStore= combo.getStore();
										cDepartmentStore.getProxy().extraParams = {
											limit:-1
										};
										cDepartmentStore.load({
											callback:function(record, operation, success){
												combo.setValue(departmentId);
												if(isView){
													combo.setReadOnly(true);
												}
											}
										});
									},
									select:function(obj,rec,value){
										var departmentId=rec[0].get('id');
										var flag = true;
										var pnlMain = obj.up("#panelIdH");
										var rowIndx = obj.rowIndx;
										if(!isNullOrEmpty(pnlMain)){
											pnlMain.items.each(function(item, index, items) {
												var deptNameVal = item.down("[name=departmentName]").getValue();
												if(departmentId == deptNameVal && rowIndx != index){
													flag = false;
						        					return false;
												}
											});
											
											if(flag){
												var nextSiblingField = obj.nextSibling();
												nextSiblingField.setDisabled(false);
												nextSiblingField.reset();
												if (departmentId > 0) {
													var store=nextSiblingField.getStore();
													store.getProxy().extraParams = {
														parentId : departmentId
													};
													store.load();
												}
											}
											else{
												obj.reset();
												var nextSiblingField = obj.nextSibling();
												nextSiblingField.reset();
												nextSiblingField.setDisabled(true);
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_DEPARTMENT_ALREADY_SELECTED_MSG'));
												return false;
											}
										}
									},
									/*change:function(obj,rec,value){
			                    var nextSiblingField = obj.nextSibling();
			                    nextSiblingField.reset();
			                    nextSiblingField.setDisabled(true);

			                    }*/
								}
							},
							{
								xtype: 'customcombobox',
								name: 'subDepartmentName',
								disabled: true,
								editable: false,
								queryMode: 'local',
								valueField: 'id',
								displayField: 'value',
								store: Ext.create('Academia.store.course.CourseSubDepartmentStore'),
								width: 226,
								listeners: {
									render: function(combo) {
										var subDepartmentStore= combo.getStore();
										subDepartmentStore.getProxy().extraParams = {
											limit:-1,
											parentId : departmentId
										};
										subDepartmentStore.load({
											callback:function(record, operation, success){
												combo.setValue(subDepartmentId);
												combo.setDisabled(false);
												if(isView){
													combo.setReadOnly(true);
												}
											}
										});
									}
								}
							},
							{    
								xtype: 'numberfield',
								name: 'weightage',
								minValue : 1,
								maxValue:100,
								maxLength: 3,
								allowBlank:false,
								allowExponential:false,
								keyNavEnabled: false,
								mouseWheelEnabled: false,
								value:weightage,
								readOnly:(isView ? true : false)
							},{
								xtype: 'hidden',
								name: 'courseDepartmentId',
							},
							{
								xtype: 'button',
								glyph: ICONGLYPH.DELETEGLYPH,
								itemId: 'detailedDeleteButton1',
								width: 'auto',
								cls: 'CustomBodyBtnReject',
								tooltip: getCommonTranslation('DELETETOOLTIP'),
								disabled:(isView ? true : false),
								style:{
									marginTop:'8px',
									marginLeft:'10px'
								},
								listeners:{
									click:function(obj){
										var container = obj.up('fieldcontainer');
									}
								}
							},
							{
								xtype: 'button',
								itemId: 'addDetailedBtn1',
								width: 'auto',
								cls: 'CustomBodyBtnSettings',
								width: 'auto',
								disabled:(isView ? true : false),
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD'),
								style:{
									marginTop:'8px'
								}
							}]

						});
					}

					panelContiner.add(panelItem);
					$this.departmentHideShowDetailsOfBasic(panelContiner);
					indx = indx + 1; 
					panelContiner.doLayout();
				});
			}
		}
		
	},
	departmentHideShowDetailsOfBasic: function(detailedPanel) {
    	 var this$ = this;
    	 var form = this.getBasicdetailform();
    	 var cnt = detailedPanel.items.length;
    	 detailedPanel.items.each(function(item, index, items) {
    		 var addButton = item.getComponent(item.items.length - 1);
    		 if (index == (items - 1)) {
    			 if (addButton != null) {
    				 addButton.show();
    				 if(cnt == 4){
    					 addButton.hide();
    				 }
    			 }
    		 } else {
    			 if (addButton != null) {
    				 addButton.hide();
    			 }
    		 }
    	 });
     },
     deleteMoreDetailedOfDepartmentOfBasicDetail: function(deleteButton) {
    	 var this$ = this;
    	 var form=this$.getBasicdetailform()
    	 var departmentPanel = form.down('#panelIdH');
    	 var container = deleteButton.up('fieldcontainer');

    	 if (container != null && departmentPanel != null) {
    		 if (departmentPanel.items.length > 1) {
    			 departmentPanel.remove(container);
    			 this$.departmentHideShowDetailsOfBasic(departmentPanel);
    		 }
    	 }
    	 form.getForm().checkValidity();
    	 //departmentPanel.doLayout();
     },
     
     getMultipleReasonsRequired: function(){
 		var isMultipleReasonsReq = false;
 		Ext.Ajax.request({
 			method : 'GET',
 			url : SERVERURL.PATH_GET_MULTIPLE_REASON,
 			headers : {
 				'Content-Type' : 'application/json'
 			},
 			async: false,
 			success : function(opt, success, response) {
 				if(opt.responseText == "false"){
 					isMultipleReasonsReq = false;
 				}
 				else{
 					isMultipleReasonsReq = true;
 				}
 			}
 		});
 		return isMultipleReasonsReq;
 	},
  	addMoreDetailedOfModuleSubjectBasicDetail:function(isEdit,record, isView){
		var $this = this;
		var createcourseform=$this.getBasicdetailform();
		if(isEdit == "Add"){
			var panelContiner = createcourseform.down('#panelMSP');
			var indx;
			if(panelContiner.items.items.length<=3){
				var panelItem = new Array();
				indx = panelContiner.items.items.length;
				panelItem.push({

					xtype : 'fieldcontainer',
					layout : 'hbox',
					width: '100%',
					scope: $this,
					defaults : {
						labelAlign : 'top',
						width:'226'
					},
					layout : {
						type : 'hbox'
					},
					margin: '10 0 0 0',
					padding: '0 0 0 0',
					items:[{
						xtype: 'customcombobox',
						width: 226,
						name: 'moduleSubject',
						store: Ext.create('Academia.store.program.programDetails.programSubjects.FindAllHesaSubjectComboStore'),
						valueField: 'id',
						displayField: 'value',
						allowBlank: false,
						typeAhead: false,
						queryParam:'qry',
	        			minChars:3,
	        			rowIndx:indx,
	                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                    forceSelection:true,
	                    listConfig: {
	        				  listeners: {
	        						beforeshow: function(picker) {
	        							picker.minWidth = picker.up('combobox').getSize().width;
	        						}
	        					},
	        	                loadingText: getCommonTranslation('SEARCHING'),
	        	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        	                getInnerTpl: function() {
	        	                    return '<div class="search-item">' +
	        	                        '{value}' +
	        	                    '</div>';
	        	                }
	        	            },
						listeners:{
							select:function(obj,rec,value){
								

								var moduleId=rec[0].get('id');
								var flag = true;
								var pnlMain = obj.up("#panelMSP");
								var rowIndx = obj.rowIndx;
								if(!isNullOrEmpty(pnlMain)){
									pnlMain.items.each(function(item, index, items) {
										var deptNameVal = item.down("[name=moduleSubject]").getValue();
										if(moduleId == deptNameVal && rowIndx != index){
											flag = false;
											return false;
										}
									});

									if(flag){
										var nextSiblingField = obj.nextSibling();
										nextSiblingField.setDisabled(false);
										nextSiblingField.reset();
									}
									else{
										obj.reset();
										var nextSiblingField = obj.nextSibling();
										nextSiblingField.reset();
										nextSiblingField.setDisabled(true);
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MODULE_SUBJECT_ALREADY_SELECTED_MSG'));
										return false;
									}
								}
								
							},
							change:function(obj,rec,value){
								var nextSiblingField = obj.nextSibling();
								nextSiblingField.reset();
								nextSiblingField.setDisabled(true);

							}
						}
					},{    
						xtype: 'numberfield',
						name: 'moduleSubjectsProportion',
						minValue : 1,
						maxValue:100,
	    				maxLength: 3,
	    				disabled:true,
	    				allowBlank:false,
	    				allowExponential:false,
	    				keyNavEnabled: false,
	    				mouseWheelEnabled: false,
					},{
	    				xtype: 'hidden',
	    				name: 'courseModuleId',
					},
					{
						xtype: 'button',
						glyph: ICONGLYPH.DELETEGLYPH,
						itemId: 'detailedDeleteMSPButton1',
						width: 'auto',
						cls: 'CustomBodyBtnReject',
						tooltip: getCommonTranslation('DELETETOOLTIP'),
						style:{
							marginTop:'8px',
							marginLeft:'10px'
						},
						listeners:{
							click:function(obj){
								var container = obj.up('fieldcontainer');
								//panelContiner.remove(container);
								//$this.getCreatecourseform().getForm().isValid();
								//$this.getMastertimetableDetailedwindow().down('#SubmitBtn').setDisabled(false);
							}
						}
					},
					{
						xtype: 'button',
						itemId: 'addDetailedMSPBtn1',
						width: 'auto',
						cls: 'CustomBodyBtnSettings',
						width: 'auto',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'8px'
						}
					}]

				});
				panelContiner.add(panelItem);
				this.moduleHideShowDetailsOfBasic(panelContiner);
				panelContiner.doLayout();
			}
		}else{
			var panelContiner = createcourseform.down('#panelMSP');
			panelContiner.removeAll();
			var indx = 0;
			if(record.length>0){
				record.forEach(function(obj){
					var panelItem = new Array();
					var departmentId = obj.hesaSubjectId;
					var moduleSubjectsProportion = obj.weightage;
					if(panelContiner.items.length == 0){
						panelItem.push({
							xtype : 'fieldcontainer',
							layout : 'hbox',
							width: '100%',
							scope: $this,
							defaults : {
								labelAlign : 'top',
								width:'226'
							},
							layout : {
								type : 'hbox'
							},
							margin: '10 0 0 0',
							padding: '0 0 0 0',
							items:[{
								xtype: 'customcombobox',
								width: 226,
								name: 'moduleSubject',
								fieldLabel: getCommonTranslation('MODULE_SUBJECTS'),
								store: Ext.create('Academia.store.program.programDetails.programSubjects.FindAllHesaSubjectComboStore'),
								valueField: 'id',
								displayField: 'value',
								allowBlank: false,
								typeAhead: false,
								queryParam:'qry',
								minChars:3,
								rowIndx:indx,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								forceSelection:true,
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{value}' +
										'</div>';
									}
								},
								listeners:{
									render: function(combo){
										var cDepartmentStore= combo.getStore();
										cDepartmentStore.getProxy().extraParams = {
											limit:-1
										};
										cDepartmentStore.load({
											callback:function(record, operation, success){
												combo.setValue(departmentId);
												if(isView){
													combo.setReadOnly(true);
												}
											}
										});
									},
									select:function(obj,rec,value){
										var departmentId=rec[0].get('id');
										var flag = true;
										var pnlMain = obj.up("#panelMSP");
										var rowIndx = obj.rowIndx;
										if(!isNullOrEmpty(pnlMain)){
											pnlMain.items.each(function(item, index, items) {
												var deptNameVal = item.down("[name=moduleSubject]").getValue();
												if(departmentId == deptNameVal && rowIndx != index){
													flag = false;
						        					return false;
												}
											});
											
											if(flag){
												var nextSiblingField = obj.nextSibling();
												nextSiblingField.setDisabled(false);
												nextSiblingField.reset();
											}
											else{
												obj.reset();
												var nextSiblingField = obj.nextSibling();
												nextSiblingField.reset();
												nextSiblingField.setDisabled(true);
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MODULE_SUBJECT_ALREADY_SELECTED_MSG'));
												return false;
											}
										}
									},
									change:function(obj,rec,value){
										var nextSiblingField = obj.nextSibling();
										nextSiblingField.setDisabled(false);

									}
								}
							},{    
								xtype: 'numberfield',
								name: 'moduleSubjectsProportion',
								minValue : 1,
								maxValue:100,
								fieldLabel: getCommonTranslation('MODULE_SUBJECTS_PROPORTION'),
								maxLength: 3,
								allowBlank:false,
								disabled:true,
								allowExponential:false,
								keyNavEnabled: false,
								mouseWheelEnabled: false,
								value:moduleSubjectsProportion,
								readOnly:(isView ? true : false)
							},{
								xtype: 'hidden',
								name: 'courseDepartmentId',
							},
							{
								xtype: 'button',
								itemId: 'addDetailedMSPBtn',
								width: 'auto',
								cls: 'CustomBodyBtnSettings',
								disabled:(isView ? true : false),
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD'),
								style:{
									marginTop:'30px'
								}
							}]

						});
					}else{
						panelItem.push({
							xtype : 'fieldcontainer',
							layout : 'hbox',
							width: '100%',
							scope: $this,
							defaults : {
								labelAlign : 'top',
								width:'226'
							},
							layout : {
								type : 'hbox'
							},
							margin: '10 0 0 0',
							padding: '0 0 0 0',
							items:[{
								xtype: 'customcombobox',
								width: 226,
								name: 'moduleSubject',
								store: Ext.create('Academia.store.program.programDetails.programSubjects.FindAllHesaSubjectComboStore'),
								valueField: 'id',
								displayField: 'value',
								allowBlank: false,
								typeAhead: false,
								queryParam:'qry',
								minChars:3,
								rowIndx:indx,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								forceSelection:true,
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{value}' +
										'</div>';
									}
								},
								listeners:{
									render: function(combo){
										var cDepartmentStore= combo.getStore();
										cDepartmentStore.getProxy().extraParams = {
											limit:-1
										};
										cDepartmentStore.load({
											callback:function(record, operation, success){
												combo.setValue(departmentId);
												if(isView){
													combo.setReadOnly(true);
												}
											}
										});
									},
									select:function(obj,rec,value){
										var departmentId=rec[0].get('id');
										var flag = true;
										var pnlMain = obj.up("#panelMSP");
										var rowIndx = obj.rowIndx;
										if(!isNullOrEmpty(pnlMain)){
											pnlMain.items.each(function(item, index, items) {
												var deptNameVal = item.down("[name=moduleSubject]").getValue();
												if(departmentId == deptNameVal && rowIndx != index){
													flag = false;
						        					return false;
												}
											});
											
											if(flag){
												var nextSiblingField = obj.nextSibling();
												nextSiblingField.setDisabled(false);
												nextSiblingField.reset();
											}
											else{
												obj.reset();
												var nextSiblingField = obj.nextSibling();
												nextSiblingField.reset();
												nextSiblingField.setDisabled(true);
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MODULE_SUBJECT_ALREADY_SELECTED_MSG'));
												return false;
											}
										}
									},
									change:function(obj,rec,value){
										var nextSiblingField = obj.nextSibling();
										nextSiblingField.setDisabled(false);

									}
								}
							},
							{    
								xtype: 'numberfield',
								name: 'moduleSubjectsProportion',
								minValue : 1,
								maxValue:100,
								maxLength: 3,
								allowBlank:false,
								disabled:true,
								allowExponential:false,
								keyNavEnabled: false,
								mouseWheelEnabled: false,
								value:moduleSubjectsProportion,
								readOnly:(isView ? true : false)
							},{
								xtype: 'hidden',
								name: 'courseDepartmentId',
							},
							{
								xtype: 'button',
								glyph: ICONGLYPH.DELETEGLYPH,
								itemId: 'detailedDeleteMSPButton1',
								width: 'auto',
								cls: 'CustomBodyBtnReject',
								tooltip: getCommonTranslation('DELETETOOLTIP'),
								disabled:(isView ? true : false),
								style:{
									marginTop:'8px',
									marginLeft:'10px'
								},
								listeners:{
									click:function(obj){
										var container = obj.up('fieldcontainer');
									}
								}
							},
							{
								xtype: 'button',
								itemId: 'addDetailedMSPBtn1',
								width: 'auto',
								cls: 'CustomBodyBtnSettings',
								width: 'auto',
								disabled:(isView ? true : false),
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD'),
								style:{
									marginTop:'8px'
								}
							}]

						});
					}

					panelContiner.add(panelItem);
					$this.moduleHideShowDetailsOfBasic(panelContiner);
					indx = indx + 1; 
					panelContiner.doLayout();
				});
			}
		}
		
	},
	moduleHideShowDetailsOfBasic: function(detailedPanel) {
   	 var this$ = this;
	 var form = this.getBasicdetailform();
	 var cnt = detailedPanel.items.length;
	 detailedPanel.items.each(function(item, index, items) {
		 var addButton = item.getComponent(item.items.length - 1);
		 if (index == (items - 1)) {
			 if (addButton != null) {
				 addButton.show();
				 if(cnt == 4){
					 addButton.hide();
				 }
			 }
		 } else {
			 if (addButton != null) {
				 addButton.hide();
			 }
		 }
	 });
 },deleteMoreDetailedOfModuleSubject: function(deleteButton) {
	 var this$ = this;
	 var form=this$.getBasicdetailform();
	 var departmentPanel = form.down('#panelMSP');
	 var container = deleteButton.up('fieldcontainer');

	 if (container != null && departmentPanel != null) {
		 if (departmentPanel.items.length > 1) {
			 departmentPanel.remove(container);
			 this$.moduleHideShowDetailsOfBasic(departmentPanel);
		 }
	 }
	 
	 if(form.isValid()){
         form.down('#basicdetail_FormSubmitButtonId').setDisabled(false);
     }
     else{
         form.down('#basicdetail_FormSubmitButtonId').setDisabled(true);
     }
	 //departmentPanel.doLayout();
 },
	
});