
Ext.define('Academia.controller.course.basicdetail.BasicDetailController', {
	extend : 'Ext.app.Controller',
	models : ['course.CreateCourseModel','course.CourseCoordinatorModel','course.CourseDocument'],
	stores : ['course.CourseBasicDetailsStore','course.CourseGradeStore','course.CourseDocument'],
	views : ['course.basicdetail.BasicDetailForm'],	           

	refs : [ {
		ref : 'coursetabstructure',
		selector : 'coursetabstructure'
	},{
		ref : 'basicdetailform',
		selector : 'basicdetailform'
	} ],

	init : function() {

		this.control({
			'basicdetailform button[itemId=basicdetail_FormSubmitButtonId]' : {
				click : this.updateUser
			},
			'basicdetailform combo[itemId=stage_Type]' : {
				select:function(o,r){
					this.selectionType(o,r);
				}
			},
			'basicdetailform ':{
				/*render:function(){
					this.getBasicDetailLoad();
				}*/
			},
			'basicdetailform combo[itemId=courseMarksGrades_id]' : {
				select:function(o,r){
					this.basicCourseMarkGrade(o,r);
				}
			},
			'basicdetailform numberfield#courseOff_id' : {
    			blur : this.MinMaxValidate
    		},
    		'basicdetailform numberfield#courseMaxMarks_Id' : {
    			blur : this.MinMaxValidate
    		},
			'basicdetailform radiogroup[itemId=course_Deficiency_Status_Id]': {
				change: function(t,n,o) {
					if(n.deficiencyStatus){
						Ext.ComponentQuery.query('radiogroup#course_Deficiency_Status_Id')[0].show();
						Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0].show();
					}else if(!n.deficiencyStatus){
						Ext.ComponentQuery.query('radiogroup#course_Deficiency_Status_Id')[0].hide();
						Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0].hide();
					}
				}
			},'basicdetailform customcombobox[itemId=course_Deficits_Id]': {
				change : this.courseDeficitsChange
			},/*'basicdetailform combo#courseCoordinatorId':{
  			  select:function(obj, record){ 
  				  var code = record[0].get("code");
  				  obj.nextSibling().setValue(code);
  			  }
  		  },*/
  	      'basicdetailform combo[itemId=courseMax_1]':{
  			select:function(obj,record){
  				var gradeType = record[0].get('value');
  				var store = this.getStore('examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
  				 store.getProxy().extraParams = {
  					 gradeType:gradeType
					  };
					  store.load();
  			}  
  		  },
  		'basicdetailform radiogroup[itemId=assignSectionTypeId]' : {
			change : function(obj, record) {
				var form = obj.up('form');
				var assignSectionType = record.assignSectionType;
				if(assignSectionType == 'CourseSection'){
					form.down('#repeatablePeriods_Id').setDisabled(false); 
				}else{
					form.down('#repeatablePeriods_Id').setDisabled(true);
					form.down('#repeatablePeriods_Id').items.items[0].setValue(false);
					form.down('#repeatablePeriods_Id').items.items[1].setValue(true);
				}
			}
		}
		});

	},	
	getBasicDetailLoad : function(){
		var $this = this;
		var tabStcrFrm = $this.getCoursetabstructure().getForm();
		
		var courseId = tabStcrFrm.findField("ids").getValue();
		
		var form = this.getBasicdetailform();
		var editUrl=SERVERURL.BASIC_COURSES_DETAILS;
		Ext.Ajax.request({
			method: "GET",
			type: 'rest',
			url: editUrl,
			params: {
				id: courseId
			},
			success : function(f, action) {
				var EId = Ext.JSON.decode(f.responseText);
				var formModel=new Academia.model.course.CreateCourseModel(EId);
				form.loadRecord(formModel);
			     	
		            if(EId.courseDepartments.length==1){
                    	var courseDepartmentInfo=EId.courseDepartments[0];
                    	var cDepartment=form.getForm().findField('departmentName');
                    	var cDepartmentStore= cDepartment.getStore();
                    	var departmentId=courseDepartmentInfo.department.id;
                    	cDepartmentStore.load({
                    		callback: function(record, operation, success) {
                    			if (success) {
                    				cDepartment.setValue(departmentId);
                    				var subCDepartment=form.getForm().findField('subDepartmentName');
                    				subCDepartment.setDisabled(false);
                    				var subCDepartmentStore=subCDepartment.getStore();
                    				subCDepartmentStore.getProxy().extraParams = {
                    					parentId : departmentId
                    				}
                    				subCDepartmentStore.load({
                    					callback: function(record, operation, success) {
                    						if (success) {
                    							if(!isNullOrEmpty(courseDepartmentInfo.subDepartment)){
                    								subCDepartment.setValue(courseDepartmentInfo.subDepartment.id);
                    							}

                    						}}});
                    				
                    			}
                    		}});

                    	form.getForm().findField('weightage').setValue(courseDepartmentInfo.weightage);
                    }else if(EId.courseDepartments.length>1){
                    	
                    	$this.addMoreDetailedOfDepartmentInDetail("Edit",EId.courseDepartments);
                    }
				  
		            if (formModel.data.courseMarksGrades == "M") {
                    	form.down('#courseMarksGrades_id').setValue("MARK");
                    	form.down('#courseOff_id').show();
                    	form.down('#courseMaxMarks_Id').show();
                        
                    	form.down('#courseOff_id').allowBlank=false;
                    	form.down('#courseMaxMarks_Id').allowBlank=false;
                        
                        
                    	form.down('#courseMax_1').allowBlank=true;
                    	form.down('#courseOff_1').allowBlank=true;
                    	form.down('#courseOff_2').allowBlank=true;
                    	form.down('#courseMax_1').hide();
                    	form.down('#courseOff_1').hide();
                    	form.down('#courseOff_2').hide();
                        
                    } else if (formModel.data.courseMarksGrades == "G") {
                    	if(!isNullOrEmpty(formModel.data.courseGradeType)){
                    	var evaluationFormOneGradesStore = $this.getStore('examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
                    	evaluationFormOneGradesStore.getProxy().extraParams = {
         					 gradeType:formModel.data.courseGradeType
       					  };
                    	evaluationFormOneGradesStore.load();
                    }
                    	
                    	form.down('#courseOff_id').allowBlank=true;
                    	form.down('#courseMaxMarks_Id').allowBlank=true;
                    	form.down('#courseOff_id').hide();
                    	form.down('#courseMaxMarks_Id').hide();
                        
                    	form.down('#courseMax_1').show();
                    	form.down('#courseOff_1').show();
                    	form.down('#courseOff_2').show();
                    	form.down('#courseMax_1').allowBlank=false;
                    	form.down('#courseOff_1').allowBlank=false;
                    	form.down('#courseOff_2').allowBlank=false;
                        
                    	form.down('#courseMarksGrades_id').setValue("GRADE");
                    	Ext.ComponentQuery.query('customcombobox#courseMax_1')[0].setValue(formModel.data.courseGradeType);
        				Ext.ComponentQuery.query('customcombobox#courseOff_1')[0].setValue(formModel.data.courseCutOff);
        				Ext.ComponentQuery.query('customcombobox#courseOff_2')[0].setValue(formModel.data.courseMaxMark);
                    }
		            var fieldradio=form.getForm().findField('whetherRepeatable');
		            var whetherEvaluationExte=Ext.ComponentQuery.query('fieldcontainer#whetherEvaluationExternalItemId')[0];
		            var deficiencyStatusBasic =Ext.ComponentQuery.query('fieldcontainer#course_Deficiency_Status_Id')[0];
		            var hasCourseComponentsBasic=form.getForm().findField('hasCourseComponents');
		            var whetherCourseExemptionRadio =Ext.ComponentQuery.query('fieldcontainer#whetherCourseExemptionItemId')[0];

		            var courseRankBasic =form.getForm().findField('courseRankConsidered');

				if(formModel.data.whetherCourseExemption){
					
					whetherCourseExemptionRadio.items.items[0].setValue(true);
					whetherCourseExemptionRadio.items.items[1].setValue(false);
					}else{
						whetherCourseExemptionRadio.items.items[0].setValue(false);
						whetherCourseExemptionRadio.items.items[1].setValue(true);
					}
					
				if(formModel.data.hasCourseComponents=='1'){
					hasCourseComponentsBasic.items.items[0].setValue(true);
					hasCourseComponentsBasic.items.items[1].setValue(false);
				}else if(formModel.data.hasCourseComponents=='0'){
					hasCourseComponentsBasic.items.items[0].setValue(false);
					hasCourseComponentsBasic.items.items[1].setValue(true);
				}
				
				
				
				if(formModel.data.courseRankConsidered=='Y'){
					
					courseRankBasic.items.items[0].setValue(true);
					courseRankBasic.items.items[1].setValue(false);
					}else if(formModel.data.courseRankConsidered=='N'){
						courseRankBasic.items.items[0].setValue(false);
						courseRankBasic.items.items[1].setValue(true);
					}
				
				if(formModel.data.whetherRepeatable){
				
				fieldradio.items.items[0].setValue(true);
			    fieldradio.items.items[1].setValue(false);
				}else{
					fieldradio.items.items[0].setValue(false);
					fieldradio.items.items[1].setValue(true);
				}

				
				if(formModel.data.whetherEvaluationExternal){
					
					whetherEvaluationExte.items.items[0].setValue(true);
					whetherEvaluationExte.items.items[1].setValue(false);
					}else{
						whetherEvaluationExte.items.items[0].setValue(false);
						whetherEvaluationExte.items.items[1].setValue(true);
					}
                 if(formModel.data.deficiencyStatus){
					
                	 deficiencyStatusBasic.items.items[0].setValue(true);
                	 deficiencyStatusBasic.items.items[1].setValue(false);
					}else{
						deficiencyStatusBasic.items.items[0].setValue(false);
						deficiencyStatusBasic.items.items[1].setValue(true);
					}
				var courseCooStore = $this.getStore('course.CourseCoordinatorStore');
				var courseStageStore = $this.getStore('course.CourseStageStore');
				var courseCategoryStore = $this.getStore('course.CourseCategoryStore');
				var courseSubjectTypeStore = $this.getStore('course.CourseSubjectTypeStore');
		
				var CourseNQFLevelStoreFromCSM = $this.getStore('course.CourseNQFLevelStoreFromCSM');
				var CourseCESMCodeStoreFromCSM = $this.getStore('course.CourseCESMCodeStoreFromCSM');
				
 	            var metaCourseOne=form.getForm().findField('metaCourseOne');
                var metaCourseTwo=form.getForm().findField('metaCourseTwo');
                var metaCourseThree=form.getForm().findField('metaCourseThree');

                var metaCourseStoreOne = metaCourseOne.getStore();
				var metaCourseStoreTwo = metaCourseTwo.getStore();
				var metaCourseStoreThree = metaCourseThree.getStore();

				
				
				if(formModel.data.user!=null){
					courseCooStore.load({
		  				  callback: function(record, operation, success) {
		  					  if (success) {
		  						  form.down('#courseCoordinatorId').setValue(formModel.data.user.id);
		  					  }
		  				  }
		  			  });
				}
				if(formModel.data.courseCESMCode!=null){
					CourseCESMCodeStoreFromCSM.load({
		  				  callback: function(record, operation, success) {
		  					  if (success) {
		  						  form.down('#courseCESMCodeId').setValue(formModel.data.courseCESMCode.id);
		  					  }
		  				  }
		  			  });
				}
					
				if(formModel.data.courseNQFLevel!=null){
					CourseNQFLevelStoreFromCSM.load({
		  				  callback: function(record, operation, success) {
		  					  if (success) {
		  						  form.down('#courseNQFLevelId').setValue(formModel.data.courseNQFLevel.id);
		  					  }
		  				  }
		  			  });
				}
				
				                         if(formModel.data.metaCourseOne!=null) {
								var metaCourseOne=formModel.data.metaCourseOne.id;
							}
                                              
							metaCourseStoreOne.load({
        						callback: function(record, operation, success) {
        							if (success) {
        								try{
            								form.down('#metaCourseOne').setValue(metaCourseOne);
            							}
            							catch(e){
            								console.log('errorCatch2');
            							}					
        							}
        						}
        					});
                            
                           if(formModel.data.metaCourseTwo!=null) {
								var metaCourseTwo=formModel.data.metaCourseTwo.id;
							}
                                              
							metaCourseStoreTwo.load({
        						callback: function(record, operation, success) {
        							if (success) {
        								try{
            								form.down('#metaCourseTwo').setValue(metaCourseTwo);
            							}
            							catch(e){
            								console.log('errorCatch2');
            							}					
        							}
        						}
        					});
                             if(formModel.data.metaCourseThree!=null) {
								var metaCourseThree=formModel.data.metaCourseThree.id;
							}
                                              
							metaCourseStoreThree.load({
        						callback: function(record, operation, success) {
        							if (success) {
        								try{
            								form.down('#metaCourseThree').setValue(metaCourseThree);
            							}
            							catch(e){
            								console.log('errorCatch2');
            							}					
        							}
        						}
        					});
                                 					

				/*courseStageStore.load({
	  				  callback: function(record, operation, success) {
	  					  if (success) {
	  						  if(formModel.data.selectionStage!=null){
	  						  form.down('#stage_Type_Id').setValue(formModel.data.selectionStage);
	  					  }}
	  				  }
	  			  });*/
				courseSubjectTypeStore.load({
	  				  callback: function(record, operation, success) {
	  					  if (success) {
	  						  if(!isNullOrEmpty(formModel.data.subjectType)){
	  							form.down('#subjectType_Id').setValue(formModel.data.subjectType.id);
	  						  }
	  					}
	  				  }
	  			  });
				courseCategoryStore.load({
	  				  callback: function(record, operation, success) {
	  					  if (success) {
	  						  if(formModel.data.courseCategory!=null){
	  						  form.down('#courseCategory').setValue(formModel.data.courseCategory.id);
	  					  }}
	  				  }
	  			  });
				/**
				 * Load document grid on the bases of course id
				 */
				 var documentStore=$this.getStore('course.CourseDocument');
                 documentStore.getProxy().extraParams = {
                     courseId: courseId
                 };
                 documentStore.load();
				
			}
		});

	},
	basicCourseMarkGrade:function(o,r){/*
		
		if(r[0].data.id == 'MARK'){
			Ext.ComponentQuery.query('numberfield#courseOff_id')[0].show();
			Ext.ComponentQuery.query('numberfield#courseMaxMarks_Id')[0].show();
			
			Ext.ComponentQuery.query('combo#course_Max_Mark')[0].hide();
			Ext.ComponentQuery.query('combo#courseOff_1')[0].hide();
			
		}else if(r[0].data.id == 'GRADE'){
				Ext.ComponentQuery.query('numberfield#courseCutOffId')[0].hide();
				Ext.ComponentQuery.query('numberfield#courseMax_Marks_Id')[0].hide();
				
				Ext.ComponentQuery.query('combo#coursePass_Cut_Off')[0].show();
				Ext.ComponentQuery.query('combo#course_Max_Mark')[0].show();
	
		}

	*/},
	selectionType :function(o,r){
		if(r[0].data.id == getProgramandcourseTranslation('SELECTION')){
//			Ext.ComponentQuery.query('radiogroup#repeatable_Period_Id')[0].hide();
			Ext.ComponentQuery.query('numberfield#courseCredit_Id')[0].hide();
			Ext.ComponentQuery.query('radiogroup#course_Deficiency_Status_Id')[0].hide();
			Ext.ComponentQuery.query('radiogroup#course_Deficits_Id')[0].hide();
			Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0].hide();
			Ext.ComponentQuery.query('radiogroup#courseRank_Id')[0].hide();
			Ext.ComponentQuery.query('radiogroup#assignSectionTypeId')[0].hide();
		}
		else{
			if(r[0].data.id == getProgramandcourseTranslation('COURSE_EXECUTION')){
				
				Ext.ComponentQuery.query('numberfield#courseCredit_Id')[0].show();
				Ext.ComponentQuery.query('radiogroup#course_Deficiency_Status_Id')[0].show();
				Ext.ComponentQuery.query('radiogroup#course_Deficits_Id')[0].show();
				Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0].show();
				Ext.ComponentQuery.query('radiogroup#courseRank_Id')[0].show();
				Ext.ComponentQuery.query('radiogroup#assignSectionTypeId')[0].show();
			}
		}
	},
	updateUser:function(){
		var $this = this;
		  var form = this.getBasicdetailform().getForm();
		  var value = form.getValues();
		  var isMarkType = form.findField("courseMarkGrad").getValue();
      	  var cutOffMarks = form.findField("courseCutOff").getValue();
      	  var maxMarks = form.findField("courseMaxMark").getValue();

      	  var isValidData = true;
      	  if (isMarkType != null && (isMarkType == "MARK") || isMarkType == "Marks") {
      		  if (cutOffMarks > maxMarks || isNullOrEmpty(cutOffMarks) || isNullOrEmpty(maxMarks)) {
      			  isValidData = false;
      		  }
      	  }
      	 if (!value.courseCredits) {
      		value.courseCredits = 0;
    	 }
    	 if (!value.ectsCredits) {
    		 value.ectsCredits = 0;
    	  }
      	  if(isValidData){
      		var courseCooId = form.findField('user').getValue();
      	  var courseCooValue = form.findField('user').getRawValue();

      	 /* var stageId = form.findField('selectionStage').getValue();
      	  var stageValue = form.findField('selectionStage').getRawValue();*/
  /*
      	  var courseDepartmentId = form.findField('department').getValue();
      	  var courseDepartmentValue = form.findField('department').getRawValue();

      	  var courseSubDepartmentId = form.findField('subDepartment').getValue();
      	  var courseSubDepartmentValue = form.findField('subDepartment').getRawValue();*/

      	  var courseCategoryId = form.findField('courseCategory').getValue();
      	  var courseCategoryValue = form.findField('courseCategory').getRawValue();
      	  
      	  var subjectTypeId = form.findField('subjectType').getValue();
        	  var subjectTypeValue = form.findField('subjectType').getRawValue();
      	  var courseCombo=this.getIdNameJson(courseCooId,courseCooValue);
      	  
      	  var courseNQFLevelId = form.findField('courseNQFLevel').getValue();
        	  var courseNQFLevelValue = form.findField('courseNQFLevel').getRawValue();
      	  var courseNQFLevelValuecourseCombo=this.getIdValueJson(courseNQFLevelId,courseNQFLevelValue);
      	  
      	  var nbcCourseCredit = form.findField('courseCreditsNBC').getValue();
      	  var nbcCourseCreditValue=form.findField('courseCreditsNBC').getRawValue();
      	  
      	  var nbcEctsCredits = form.findField('ectsCreditsNBC').getValue();

          var metaCourseOne = form.findField('metaCourseOne').getValue();
        	  var metaCourseOneValue = form.findField('metaCourseOne').getRawValue();
      	  var metaCourseOneValueCombo=this.getIdValueJson(metaCourseOne,metaCourseOneValue);
      	  
           var metaCourseTwo = form.findField('metaCourseTwo').getValue();
        	  var metaCourseTwoValue = form.findField('metaCourseTwo').getRawValue();
      	  var metaCourseTwoValueCombo=this.getIdValueJson(metaCourseTwo,metaCourseTwoValue);


           var metaCourseThree = form.findField('metaCourseThree').getValue();
        	  var metaCourseThreeValue = form.findField('metaCourseThree').getRawValue();
      	  var metaCourseThreeValueCombo=this.getIdValueJson(metaCourseThree,metaCourseThreeValue);

      	  var courseCESMCodeId = form.findField('courseCESMCode').getValue();
        	  var courseCESMCodeValue = form.findField('courseCESMCode').getRawValue();
      	  var courseCESMCodeValuecourseCombo=this.getIdValueJson(courseCESMCodeId,courseCESMCodeValue);
      	  
      	 /* var stageCombo=this.getIdValueJson(stageId,stageValue);*/
      	 /* var courseDepartmentCombo=this.getIdValueJson(courseDepartmentId,courseDepartmentValue);
      	  var courseSubDepartmentCombo=this.getIdValueJson(courseSubDepartmentId,courseSubDepartmentValue);*/
      	  var courseCategoryCombo=this.getIdValueJson(courseCategoryId,courseCategoryValue);
      	  var subjectTypeCombo = this.getIdValueJson(subjectTypeId, subjectTypeValue);
      	  
      	  var calculationRuleId = form.findField('CalculationRule').getValue();
      	  var calculationRuleValue = form.findField('CalculationRule').getRawValue();
      	  var calculationRuleCombo = this.getIdValueJson(calculationRuleId, calculationRuleValue);

      	 var succeedingCourseId = form.findField('succeedingCourse').getValue();
      	  var createCourse = new Academia.model.course.CreateCourseModel();
  		  createCourse.set("id",value.id);
  		  createCourse.set("version",value.version);
  		  createCourse.set("courseCode",value.courseCode);
      	  createCourse.set("courseName",value.courseName);
      	  createCourse.set("courseShortName",value.courseShortName);
      	  createCourse.set("courseCodeToBePrinted",value.courseCodeToBePrinted);
      	  createCourse.set("nameToBePrinted",value.nameToBePrinted);
      	  createCourse.set("courseSyllabus",value.courseSyllabus);
      	  if(value.sectionType =='PROGRAM_BATCH_SECTION' || value.sectionType =='ProgramBatchSection'){
      		  createCourse.set("assignSectionType","ProgramBatchSection"  );
      	  }
      	  else{
      		  createCourse.set("assignSectionType","CourseSection");
      	  }
      	  createCourse.set("whetherFixed",value.whetherFixed);
      	  if(value.hasCourseComponents == undefined){
      		createCourse.set("hasCourseComponents",value.hasCourseComponents1);  
      	  }else{
      		 createCourse.set("hasCourseComponents",value.hasCourseComponents);  
      	  }
      	  if(value.hasCourseComponents == undefined){
      		createCourse.set("sectionAtComponentLevel",value.sectionAtComponentLevel1);  
      	  }  else if(value.hasCourseComponents==1){
      		  createCourse.set("sectionAtComponentLevel",value.sectionAtComponentLevel);
      	  }
      	  else{
      		  createCourse.set("sectionAtComponentLevel",value.hasCourseComponents==0 ? false : true);
      	  }
      	  createCourse.set("whetherEvaluationExternal",value.whetherEvaluationExternal);
      	  createCourse.set("courseCredits",value.courseCredits);
      	  //nbc credits
      	 if(!isNullOrEmpty(nbcCourseCredit) && isNumberValidate(nbcCourseCredit)){
      		createCourse.set("courseCredits",value.courseCreditsNBC);
      	 }
          createCourse.set("ectsCredits",value.ectsCredits);
          if(!isNullOrEmpty(nbcEctsCredits) && isNumberValidate(nbcEctsCredits)){
        		createCourse.set("ectsCredits",value.ectsCreditsNBC);
        	 }
      	  createCourse.set("deficiencyStatus",value.deficiencyStatus1);
      	  createCourse.set("courseDeficits",value.courseDeficits1);
      	  if(value.courseDeficitsPoint!=null){
      		  createCourse.set("courseDeficitsPoint",value.courseDeficitsPoint);
      	  }else{
      		  createCourse.set("courseDeficitsPoint",0);
      	  }
      	  createCourse.set("courseShortDescription",value.courseShortDescription);
      	  createCourse.set("courseRankConsidered",value.courseRankConsidered);
      	  createCourse.set("courseEntryCriteriaQuery",value.courseEntryCriteriaQuery);
      	  createCourse.set("courseExitCriteriaQuery",value.courseExitCriteriaQuery);
      	  createCourse.set("whetherRepeatable",value.whetherRepeatable);
      	  createCourse.set("calculationRule",calculationRuleId);
      	  
         	createCourse.set("courseNameLanguageOne",value.courseNameLanguageOne);
        	createCourse.set("courseShortNameLanguageOne",value.courseShortNameLanguageOne);
        	createCourse.set("courseNameLanguageTwo",value.courseNameLanguageTwo);
        	createCourse.set("courseShortNameLanguageTwo",value.courseShortNameLanguageTwo);
        	createCourse.set("courseNameLanguageThree",value.courseNameLanguageThree);
        	createCourse.set("courseShortNameLanguageThree",value.courseShortNameLanguageThree);
        	createCourse.set("courseCESMCode",courseCESMCodeValuecourseCombo);
        	createCourse.set("courseNQFLevel",courseNQFLevelValuecourseCombo);
        	createCourse.set("weightGPA",value.weightGPA);
            createCourse.set("metaCourseOne",metaCourseOneValueCombo);
            createCourse.set("metaCourseTwo",metaCourseTwoValueCombo);
            createCourse.set("metaCourseThree",metaCourseThreeValueCombo);
            createCourse.set("subjectAdditionalCode",value.subjectAdditionalCode);
            createCourse.set("courseShortDescriptionInOtherLanguage",value.courseShortDescriptionInOtherLanguage);
        	createCourse.set("isLMSCourses",value.isLMSCourses);
        	createCourse.set("lMSCourseOfferYear",value.lMSCourseOfferYear);
        	createCourse.set("isPublishToLMS",isNullOrEmpty(value.isPublishToLMS)?false:true);
        	createCourse.set("nameToBePrintedLanguageOne",value.nameToBePrintedLanguageOne);
        	createCourse.set("nameToBePrintedLanguageTwo",value.nameToBePrintedLanguageTwo);
        	createCourse.set("nameToBePrintedLanguageThree",value.nameToBePrintedLanguageThree);
  		    createCourse.set("isFeeApplicable",value.isFeeApplicable);
  		    createCourse.set("hybridModule",value.hybridModule);
  		    createCourse.set("isPrefrenceRequired",value.isPrefrenceRequired);
  			if(!isNullOrEmpty(succeedingCourseId)){
  			createCourse.set("succeedingCourseId",succeedingCourseId);
  			}
  		
      	  if(value.whetherRepeatable1=="true" && typeof(value.whetherRepeatable) == "undefined")
      		  {
      		  createCourse.set("whetherRepeatable",value.whetherRepeatable1);
      		  }
      	/*  createCourse.set("categoryField1",value.categoryField1);
      	  createCourse.set("categoryField2",value.categoryField2);
      	  createCourse.set("categoryField3",value.categoryField3);
      	  createCourse.set("categoryField4",value.categoryField4);
      	  createCourse.set("categoryField5",value.categoryField5);*/
      	  createCourse.set("whetherCourseExemption",value.whetherCourseExemption);
      	  createCourse.set("includeinPromotion",value.includeinPromotion);
      	  createCourse.set("user",courseCombo);
      	  if(value.selectionStage == 'COURSE_EXECUTION' || value.selectionStage == 'Course Execution'){
      		 createCourse.set("selectionStage",'COURSE_EXECUTION');
      	  }else if(value.selectionStage == 'SELECTION' || value.selectionStage == 'Selection'){
      		  createCourse.set("selectionStage",'SELECTION');
      	  }
      	  
      	  var departmentArray = [];
            var totalWeightage=0;
            var duplicateIdMap = new Ext.util.HashMap();
            var duplicateIdFlag=false;
            var courseDepartmentCombo=null;
           var courseSubDepartmentCombo=null
            if (!isNullOrEmpty($this.getBasicdetailform().down('#panelIdH').items.items)
        			&& $this.getBasicdetailform().down('#panelIdH').items.items.length > 1) {
            	courseDepartmentCombo = this.getIdValueJson(value.departmentName[0], value.departmentName[0]);
            	courseSubDepartmentCombo = this.getIdValueJson(value.subDepartmentName[0],value.subDepartmentName[0]);

            	for (var i = 0; i < $this.getBasicdetailform().down('#panelIdH').items.items.length; i++) {
            		var newData = {
        					"department" : $this.getIdValueJson(value.departmentName[i],value.departmentName[i]),
        					"subDepartment" :  $this.getIdValueJson(value.subDepartmentName[i],value.subDepartmentName[i]),
        					"weightage" : value.weightage[i],
        					"course" : $this.getIdValueJson(value.id,value.id),
        					"id":parseInt(value.courseDepartmentId[i])
        			};
            		if(duplicateIdMap.containsKey(value.departmentName[i])){
            			duplicateIdFlag=true;
            			break;
            		}
            		duplicateIdMap.add(value.departmentName[i], i);
            		totalWeightage=totalWeightage+parseInt(value.weightage[i]);
            		departmentArray.push(newData);
            		}
        		
            }else if(!isNullOrEmpty($this.getBasicdetailform().down('#panelIdH').items.items)
        			&& $this.getBasicdetailform().down('#panelIdH').items.items.length == 1){
            	courseDepartmentCombo = this.getIdValueJson(value.departmentName, value.departmentName);
            	courseSubDepartmentCombo = this.getIdValueJson(value.subDepartmentName,value.subDepartmentName);

            	var newData = {
    					"department" : $this.getIdValueJson(value.departmentName,value.departmentName),
    					"subDepartment" :  $this.getIdValueJson(value.subDepartmentName,value.subDepartmentName),
    					"weightage" : value.weightage,
    					"course" : $this.getIdValueJson(value.id,value.id),
    					"id":parseInt(value.courseDepartmentId)
    			};
            	departmentArray.push(newData);
            	totalWeightage=totalWeightage+parseInt(value.weightage);
            }
           if(duplicateIdFlag){
           	showWarningMessage(getCommonTranslation('COURSE'),
  						getCommonTranslation('Duplicate department selected')); 
           	return false;
           }
           if(totalWeightage!=100){
           	showWarningMessage(getCommonTranslation('COURSE'),
  						getCommonTranslation('The sum of all the departments weights should be 100')); 
           	return false;
           }
           
           var moduleArray = [];
           var totalWeightageMSP=0;
            var duplicateIdMap = new Ext.util.HashMap();
            var duplicateIdFlagMSP=false;
            var moduleDepartmentCombo=null;
            var newData1 = null;
           if (!isNullOrEmpty($this.getBasicdetailform().down('#panelMSP').items.items)
        			&& $this.getBasicdetailform().down('#panelMSP').items.items.length > 1) {

            	for (var i = 0; i < $this.getBasicdetailform().down('#panelMSP').items.items.length; i++) {
            		if(!isNullOrEmpty(value.moduleSubject[i])){
            		var newData1 = {
        					"hesaSubjectId" : value.moduleSubject[i],
        					"weightage" : value.moduleSubjectsProportion[i]
        			};
            		}
            		if(duplicateIdMap.containsKey(value.moduleSubject[i])){
            			duplicateIdFlagMSP=true;
            			break;
            		}
            		duplicateIdMap.add(value.moduleSubject[i], i);
            		totalWeightageMSP=totalWeightageMSP+parseInt(value.moduleSubjectsProportion[i]);
            		moduleArray.push(newData1);
            		}
        		
            }else if(!isNullOrEmpty($this.getBasicdetailform().down('#panelMSP').items.items)
        			&& $this.getBasicdetailform().down('#panelMSP').items.items.length == 1){
            	if(!isNullOrEmpty(value.moduleSubject)){
            	var newData1 = {
    					"hesaSubjectId" : value.moduleSubject,
    					"weightage" : value.moduleSubjectsProportion
    			};
            	}
            	moduleArray.push(newData1);
            	totalWeightageMSP=totalWeightageMSP+parseInt(value.moduleSubjectsProportion);
            }
           
            if(duplicateIdFlagMSP){
            	showWarningMessage(getCommonTranslation('COURSE'),
						getCommonTranslation('Duplicate Module Subject selected')); 
            	return false;
            }
            if(form.findField("moduleSubject").isHidden()==false && form.findField("moduleSubjectsProportion").isHidden()==false && form.findField("moduleSubjectsProportion").isDisabled()==false ){
            if(totalWeightageMSP!=100){
            	showWarningMessage(getCommonTranslation('COURSE'),
						getCommonTranslation('The sum of all the Module Subject weights should be 100')); 
            	return false;
            }
            }
           createCourse.set("courseDepartments", departmentArray);
           if(moduleArray[0] != null){
           	createCourse.set("subjectMapping", moduleArray);
           }else{
           	createCourse.set("subjectMapping", []);
           }
           var multipleLanguageArray = [];
           var multipleLanguage=form.findField("multipleLanguage").getValue();
           var courseMultipleLanguageMap=Ext.JSON.decode(form.findField("courseMultipleLanguageMap").getValue());
       	if(multipleLanguage !=undefined && multipleLanguage.length > 0 && multipleLanguage[0] != ""){
       		for(var i in multipleLanguage){
       			if(Ext.isObject(multipleLanguage[i])){
       				var newMultipleData = {
       						"id":isNullOrEmpty(courseMultipleLanguageMap.map[multipleLanguage[i].get("id")]) ?null  :courseMultipleLanguageMap.map[multipleLanguage[i].get("id")],
       						"course" : $this.getIdValueJson(value.id,value.id),
           					"multiLanguage" : $this.getIdValueJson(multipleLanguage[i].get("id"),multipleLanguage[i].get("id")),
           			};
       				multipleLanguageArray.push(newMultipleData);
       			}else{
       				var newMultipleData = {
       						"id":isNullOrEmpty(courseMultipleLanguageMap.map[multipleLanguage[i]]) ?null  :courseMultipleLanguageMap.map[multipleLanguage[i]],
       	     				"course" : $this.getIdValueJson(value.id,value.id),
           					"multiLanguage" : $this.getIdValueJson(multipleLanguage[i],multipleLanguage[i]),
           			};
       				multipleLanguageArray.push(newMultipleData);
       			}
       		}
       	}
           
           createCourse.set("courseMultipleLanguages", multipleLanguageArray);
           
//      	  createCourse.set("selectionStage",value.selectionStage);
           createCourse.set("courseSequence", value.courseSequence);
      	  createCourse.set("department",courseDepartmentCombo);
      	  createCourse.set("subDepartment",courseSubDepartmentCombo);
      	  createCourse.set("customData",value.customData);
      	  createCourse.set("whetherDeleted",value.whetherDeleted);
      	  createCourse.set("createdOn",value.createdOn);
      	  createCourse.set("courseCategory",courseCategoryCombo);
      	  createCourse.set("subjectType",subjectTypeCombo);
      	  if(value.courseMarkGrad=='MARK'||value.courseMarkGrad=='Marks'){
      		  createCourse.set("courseMarksGrades",'M');
      		  createCourse.set("courseCutOff",value.courseCutOff);
      		  createCourse.set("courseMaxMark",value.courseMaxMark);
      	  }else if(value.courseMarkGrad=='GRADE'||value.courseMarkGrad=='Grade'){
      		  createCourse.set("courseMarksGrades",'G');
      		  
      		  createCourse.set("courseGradeType",value.courseMaxMarkCombo);
      		  createCourse.set("courseCutOff",value.courseCutOffComboMin);
      		  createCourse.set("courseMaxMark",value.courseCutOffComboMax);
      		  /*createCourse.set("courseCutOff",value.courseCutOffCombo);
      		  createCourse.set("courseMaxMark",value.courseMaxMarkCombo);*/
      	  }
      	  
      	  createCourse.set("modulePrerequisite",value.modulePrerequisite);
  		  createCourse.set("isPublishInCatalogue",value.isPublishInCatalogue);
  		  createCourse.set("moduleHEQSFLevel",value.moduleHEQSFLevel);
  		  createCourse.set("isModulePrerequisites",value.modulePrerequisitesRadio==0 ? false : true);
  		createCourse.set("eligibleTransferCredit",value.eligibleTransferCredit);
      	  
      	  var store=$this.getStore('course.CourseDocument');
      	  var docArray=[]; 
      	  if(store.data.items!=null&&store.data.items.length>0){
      	  Ext.each(store.data.items, function (val) {
      		  var newData={
      				  "name":val.data.documentName,
      				  "path":val.data.path,
      				  "type":val.data.type,
      				  "createdBy":$this.getIdValueJson(val.data.createdBy.id,val.data.createdBy.value)
      		  };
      		  if(val.data.documentId==""){
      			  docArray.push(newData);  
      		  }
      		  
   		   });
      	  }
      	  createCourse.set("documents",docArray);

      	     createCourse.set("id",value.id);
      	     var formData = Ext.encode(createCourse.data);
      		 submitUrl = SERVERURL.COURSES_UPDATE;
      	    	if(value.modulePrerequisite.length>5000){    	    		
      	    		showWarningMessage(getCommonTranslation('ALERT'), 
      						getProgramandcourseTranslation('MODULE_PREREQUISITE_LENGTH'));
      	}else{
      		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

         	  Ext.Ajax.request({
         		  type : 'rest',
         		  url : submitUrl,
         		  jsonData : formData,
         		  method : 'POST',
         		  success : function(form, action) {
         			  Ext.getBody().unmask();
         			  showSuccessMessage(getCommonTranslation('COURSE'),getCommonTranslation('SUCCESS'));
         			  $this.getBasicDetailLoad();
         		  }
         	  });
      		
      	}
      	  }
	
      },
      getIdValueJson: function(id, value) {
    	  if (id) return {
    		  id: id,
    		  value: value
    	  };
      },
      getIdNameJson: function(id, name) {
    	  if (id) return {
    		  id: id,
    		  nameToBePrinted: name
    	  };
      },
      MinMaxValidate : function() {

      	var $this = this;
      	var form = this.getBasicdetailform().getForm();

      	var cutOffMarks = form.findField("courseCutOff")
      	.getValue();
      	var maxMarks = form.findField("courseMaxMark")
      	.getValue();

      	if (cutOffMarks != null && maxMarks != null) {
      		if (cutOffMarks > maxMarks) {
      			form.findField("courseMaxMark").setValue(null);
      			form.findField("courseCutOff").setValue(null);
      			showWarningMessage(getCommonTranslation('COURSE'),
      					getCommonTranslation('COURSE_MAX_MIN_MSSG'));
      		}
      	}

      },
      courseDeficitsChange : function(cb, nv, ov) {
      	if (nv== getCommonTranslation('FIXED')) {
      		Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0].show();
      	} else if (nv== getCommonTranslation('RULE_BASED')) {
      		Ext.ComponentQuery.query('numberfield#course_Deficits_Point_Id')[0].hide();
      	};
      },
      addMoreDetailedOfDepartmentInDetail:function(isEdit,record, isView){
  		var $this = this;
  		var createcourseform=$this.getBasicdetailform()
  		if(isEdit == "Add"){
  			
  		}else{
			var panelContiner = createcourseform.down('#panelIdH');
			panelContiner.removeAll();
			if(record.length>0){
				record.forEach(function(obj){
					var panelItem = new Array();
					var departmentId = obj.department.id;
					var subDepartmentId = isNullOrEmpty(obj.subDepartment)? null : obj.subDepartment.id;
					var weightage = obj.weightage;

					if(panelContiner.items.length == 0){
						panelItem.push({
							xtype : 'fieldcontainer',
							layout : 'hbox',
							width: '100%',
							scope: $this,
							defaults : {
								labelAlign : 'top',
								width:'226'
							},
							layout : {
								type : 'hbox'
							},
							margin: '10 0 0 0',
							padding: '0 0 0 0',
							items:[{
								xtype: 'customcombobox',
								width: 226,
								name: 'departmentName',
								fieldLabel: getCommonTranslation('COURSE_DEPARTMENT'),
								store: Ext.create('Academia.store.course.CourseDepartmentStore'),
								valueField: 'id',
								displayField: 'value',
								allowBlank: false,
								typeAhead: false,
								queryParam:'qry',
								minChars:3,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								forceSelection:true,
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{value}' +
										'</div>';
									}
								},
								listeners:{
									render: function(combo){
										var cDepartmentStore= combo.getStore();
										cDepartmentStore.getProxy().extraParams = {
											limit:-1
										};
										cDepartmentStore.load({
											callback:function(record, operation, success){
												combo.setValue(departmentId);
												if(isView){
													combo.setReadOnly(true);
												}
											}
										});
									},
									select:function(obj,rec,value){
										var departmentId=rec[0].get('id');
										var nextSiblingField = obj.nextSibling();
										nextSiblingField.setDisabled(false);
										nextSiblingField.reset();
										if (departmentId > 0) {
											var store=nextSiblingField.getStore();
											store.getProxy().extraParams = {
												parentId : departmentId
											};
											store.load();
										}
									},
									/*change:function(obj,rec,value){
			                    var nextSiblingField = obj.nextSibling();
			                    nextSiblingField.reset();
			                    nextSiblingField.setDisabled(true);

			                    }*/
								}
							},
							{
								xtype: 'customcombobox',
								name: 'subDepartmentName',
								fieldLabel: getCommonTranslation('COURSE_SUB_DEPARTMENT'),
								disabled: true,
								editable: false,
								queryMode: 'local',
								valueField: 'id',
								displayField: 'value',
								store: Ext.create('Academia.store.course.CourseSubDepartmentStore'),
								width: 226,
								listeners: {
									render: function(combo) {
										var subDepartmentStore= combo.getStore();
										subDepartmentStore.getProxy().extraParams = {
											limit:-1,
											parentId : departmentId
										};
										subDepartmentStore.load({
											callback:function(record, operation, success){
												combo.setValue(subDepartmentId);
												combo.setDisabled(false);
												if(isView){
													combo.setReadOnly(true);
												}
											}
										});
									}
								}
							},
							{    
								xtype: 'numberfield',
								name: 'weightage',
								minValue : 1,
								maxValue:100,
								fieldLabel: getCommonTranslation('DEPARTMENT_WEIGHTAGE_IN_PERCENTAGE'),
								maxLength: 3,
								allowBlank:false,
								allowExponential:false,
								keyNavEnabled: false,
								mouseWheelEnabled: false,
								value:weightage,
								readOnly:(isView ? true : false)
							},{
								xtype: 'hidden',
								name: 'courseDepartmentId',
							},
							{
								xtype: 'button',
								itemId: 'addDetailedBtn',
								width: 'auto',
								cls: 'CustomBodyBtnSettings',
								disabled:(isView ? true : false),
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD'),
								style:{
									marginTop:'30px'
								}
							}]

						});
					}else{
						panelItem.push({
							xtype : 'fieldcontainer',
							layout : 'hbox',
							width: '100%',
							scope: $this,
							defaults : {
								labelAlign : 'top',
								width:'226'
							},
							layout : {
								type : 'hbox'
							},
							margin: '10 0 0 0',
							padding: '0 0 0 0',
							items:[{
								xtype: 'customcombobox',
								width: 226,
								name: 'departmentName',
								store: Ext.create('Academia.store.course.CourseDepartmentStore'),
								valueField: 'id',
								displayField: 'value',
								allowBlank: false,
								typeAhead: false,
								queryParam:'qry',
								minChars:3,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								forceSelection:true,
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{value}' +
										'</div>';
									}
								},
								listeners:{
									render: function(combo){
										var cDepartmentStore= combo.getStore();
										cDepartmentStore.getProxy().extraParams = {
											limit:-1
										};
										cDepartmentStore.load({
											callback:function(record, operation, success){
												combo.setValue(departmentId);
												if(isView){
													combo.setReadOnly(true);
												}
											}
										});
									},
									select:function(obj,rec,value){
										var departmentId=rec[0].get('id');
										var nextSiblingField = obj.nextSibling();
										nextSiblingField.setDisabled(false);
										nextSiblingField.reset();
										if (departmentId > 0) {
											var store=nextSiblingField.getStore();
											store.getProxy().extraParams = {
												parentId : departmentId
											};
											store.load();
										}
									},
									/*change:function(obj,rec,value){
			                    var nextSiblingField = obj.nextSibling();
			                    nextSiblingField.reset();
			                    nextSiblingField.setDisabled(true);

			                    }*/
								}
							},
							{
								xtype: 'customcombobox',
								name: 'subDepartmentName',
								disabled: true,
								editable: false,
								queryMode: 'local',
								valueField: 'id',
								displayField: 'value',
								store: Ext.create('Academia.store.course.CourseSubDepartmentStore'),
								width: 226,
								listeners: {
									render: function(combo) {
										var subDepartmentStore= combo.getStore();
										subDepartmentStore.getProxy().extraParams = {
											limit:-1,
											parentId : departmentId
										};
										subDepartmentStore.load({
											callback:function(record, operation, success){
												combo.setValue(subDepartmentId);
												combo.setDisabled(false);
												if(isView){
													combo.setReadOnly(true);
												}
											}
										});
									}
								}
							},
							{    
								xtype: 'numberfield',
								name: 'weightage',
								minValue : 1,
								maxValue:100,
								maxLength: 3,
								allowBlank:false,
								allowExponential:false,
								keyNavEnabled: false,
								mouseWheelEnabled: false,
								value:weightage,
								readOnly:(isView ? true : false)
							},{
								xtype: 'hidden',
								name: 'courseDepartmentId',
							},
							{
								xtype: 'button',
								glyph: ICONGLYPH.DELETEGLYPH,
								itemId: 'detailedDeleteButton1',
								width: 'auto',
								cls: 'CustomBodyBtnReject',
								tooltip: getCommonTranslation('DELETETOOLTIP'),
								disabled:(isView ? true : false),
								style:{
									marginTop:'8px'
								},
								listeners:{
									click:function(obj){
										var container = obj.up('fieldcontainer');
									}
								}
							},
							{
								xtype: 'button',
								itemId: 'addDetailedBtn1',
								width: 'auto',
								cls: 'CustomBodyBtnSettings',
								width: 'auto',
								disabled:(isView ? true : false),
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD'),
								style:{
									marginTop:'8px'
								}
							}]

						});
					}

					panelContiner.add(panelItem);
					$this.departmentHideShowDetailOfBasic(panelContiner);
					panelContiner.doLayout();
				});
			}
		}
  		
  	},
	departmentHideShowDetailOfBasic: function(detailedPanel) {
   	 var this$ = this;
   	 var form = this.getBasicdetailform()
   	 detailedPanel.items.each(function(item, index, items) {
   		 var addButton = item.getComponent(item.items.length - 1);
   		 if (index == (items - 1)) {
   			 if (addButton != null) {
   				 addButton.show();
   			 }
   		 } else {
   			 if (addButton != null) {
   				 addButton.hide();
   			 }
   		 }
   	 });
    },

	
});
