/*
 * @author Rajkumar.patidar
 * 
 */
var variantViewMode = "";
Ext.define('Academia.controller.course.coursevariants.CourseVariantController', {
	//extend : 'Ext.app.Controller',
	extend :'Academia.controller.base.BaseController',
	models : ['course.coursevariants.CourseVariantModel','common.IdValueDataModel','course.NoOfCourseVariantAssoGridModel'],
	stores : ['course.coursevariants.CourseVariantStore','calendar.ActiveCalendarStore','course.NoOfCourseVariantAssoGridStore'],
	views : ['course.coursevariants.CourseVariantForm','course.coursevariants.CourseVariantGrid','course.CourseTabStructure',
		'course.CourseVariantDetailsList'],	           
	config: {
    	/*
    	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the Course Variant screen.
    	 */
    	/**
    	 * @cfg {Array} COURSE_VARIANTS_PERMISSIONS array (required)
    	 * The array of permissions to use for Access control wise enabling and disabling buttons.
    	 * @accessor
    	 */
    	COURSE_VARIANT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSEVARIANTS_PRIVILEGES')  		  
    },
	refs : [{
		ref: 'coursevariantForm',
		selector: 'coursevariantform form'
	},{
		ref : 'coursevariantform',
		selector : 'coursevariantform'
	},{
		ref : 'coursevariantgrid',
		selector : 'coursevariantgrid'
	},{
		ref : 'coursetabstructure',
		selector : 'coursetabstructure'		
	},{
        ref: 'coursetabstructure',
        selector: 'coursetabstructure'
    },{
    	ref: 'coursevariantdetailslist',
        selector: 'coursevariantdetailslist'
    }],

	init : function() {

		this.control({

			'coursevariantgrid':{
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var formWindow = this.getCoursevariantgrid(); 
					if (e.target.tagName == 'A') {
						var totalParamterizedId = record.get("totalParamterized");
						if (!isNullOrEmpty(totalParamterizedId)) {
							this.getVariantDetails(record,grid);
						}
					}
				},
				render:function(obj){
					this.courseVaraintGridRender();
					//this.gridRenderFunction(grid);
					this.doAccessControlValidation(obj, this.getCOURSE_VARIANT_PERMISSIONS());
					//this.genericCBGridAccessControlValidation(grid,permissionsMap);
				},
				afterrender:function(grid){
					var viewMode = this.getCoursetabstructure().getForm().findField('courseViewMode').getValue();
					if(viewMode == "View"){
						grid.down('#btnEdit').setVisible(false);
						grid.down('#btnDelete').setVisible(false);
					}
				}
			},
			'coursevariantform button[itemId=coursevariantform_submitbuttonId]' : {
				click : this.courseVaraintAdd
			},
			'coursevariantform button[itemId=coursevariantform_canclebuttonId]' : {
				click : this.courseVaraintClose
			},
			'coursevariantgrid button[itemId=btnAdd]' : {
				click : function(){
					variantViewMode = "";
					this.showFormWindow();
				}
			},
			'coursevariantgrid button[itemId=btnEdit]' : {
				click:  function(){
					variantViewMode = "";
					this.editFormWindow();
				}
			},
			'coursevariantgrid button[itemId=btnDelete]' : {
				click : this.deleteFormWindow
			},
			'coursevariantgrid button[itemId=btnView]' : {
				click : function(){
					variantViewMode = "View";
					this.viewFormWindow();
				}
			},
			'coursevariantform textfield[itemId=courseVariantCode]':{
				blur : function(response){
					if(variantViewMode != "View"){
						this.UniquenessCheck(response);
					}
				}
			},
			'coursevariantform textfield[itemId=courseVariantDescription]':{
				blur : function(response){
					if(variantViewMode != "View"){
						this.UniquenessCheck(response);
					}
				}
			},
			'coursevariantform textfield[itemId=courseVariantShortDescription]':{
				blur : function(response){
					if(variantViewMode != "View"){
						this.UniquenessCheck(response);
					}
				}
			},
			'coursevariantform':{
				render : function(){
					if(variantViewMode == "View"){
					var form = this.getCoursevariantForm();
					form.items.items[2].vtype="";
					form.items.items[4].vtype="";
					form.items.items[6].vtype="";
					}
				}
			}

		});
	},
	UniquenessCheck : function(response){

		var $this = this;

		var tabStcrFrm = $this.getCoursetabstructure().getForm();
		var cId = tabStcrFrm.findField("ids").getValue();
		var sectionAtComponentLevel = tabStcrFrm.findField("sectionAtComponentLevelFlag").getValue();
		
		
		var cvFrm =  $this.getCoursevariantForm().getForm();
		var courseVariantId = cvFrm.findField("id").getValue();
		
		if(!courseVariantId){
			courseVariantId = 0;
		}
		var fieldToBeChecked = response.initialConfig.name;
		var value = response.getValue();
		var courseId = cId;

		Ext.Ajax.request({
			method: "POST",
			type: 'rest',
			url: SERVERURL.COURSE_VARIANTS_CHECK_UNIQUENESS+'?courseId='+courseId+'&fieldToBeChecked='+fieldToBeChecked+'&courseVariantId='+courseVariantId+'&sectionAtComponentLevel='+sectionAtComponentLevel+'&value='+value,
			headers: {
				'Content-Type': 'application/json'
			},
			success:function(form, action){

				var mssg = form.responseText;

				if(mssg=="courseVariantCode not available"){
					cvFrm.findField("courseVariantCode").setValue(null);
					cvFrm.findField("courseVariantCodeMssg").show();
					cvFrm.findField("courseVariantCodeMssg").setValue(getErrorTranslation('courseVariantCode_not_available'));
				}else if(mssg=="courseVariantShortDescription not available"){
					cvFrm.findField("courseVariantShortDescription").setValue(null);
					cvFrm.findField("courseVariantShortDescriptionMssg").show();
					cvFrm.findField("courseVariantShortDescriptionMssg").setValue(getErrorTranslation('courseVariantShortDescription_not_available'));
				}else if(mssg=="courseVariantDescription not available"){
					cvFrm.findField("courseVariantDescription").setValue(null);
					cvFrm.findField("courseVariantDescriptionMssg").show();
					cvFrm.findField("courseVariantDescriptionMssg").setValue(getErrorTranslation('courseVariantDescription_not_available'));
				}else if(mssg=="true"){
					cvFrm.findField("courseVariantCodeMssg").hide();
					cvFrm.findField("courseVariantShortDescriptionMssg").hide();
					cvFrm.findField("courseVariantDescriptionMssg").hide();
				}
			}
		});
	},

	courseVaraintClose:function(){
		var formWindow = this.getCoursevariantform();
		formWindow.close();
	},
	courseVaraintAdd:function(){

		var $this = this;
		var store = $this.getCoursevariantgrid();
		var grdStore = store.getStore();
		
		var tabStcrFrm = $this.getCoursetabstructure().getForm();
		var courseId = tabStcrFrm.findField("ids").getValue();

		var frmWin = $this.getCoursevariantForm().getForm();
		var value = frmWin.getValues();

		var courseVariants = new Academia.model.course.coursevariants.CourseVariantModel();
		
		
		courseVariants.set("version",value.version);
		courseVariants.set("calendar",$this.getIdValueJson(value.assignCalender));
		courseVariants.set("courseVariantCode",value.courseVariantCode);
		courseVariants.set("courseVariantDescription",value.courseVariantDescription);
		courseVariants.set("courseVariantShortDescription",value.courseVariantShortDescription);
		courseVariants.set("courseStatus",true);
		courseVariants.set("courseVariantFileDwlLoc","fieLocation");
		courseVariants.set("courseVariantHwfileLocation","HWfileLocation");
		delete courseVariants.data.calendarId;
		delete courseVariants.data.periodStartDate;
		delete courseVariants.data.sectionType;
		
		var academyLocation={
				id:value.alId,
				academyId:value.academyId,
				locationId:value.locationId,
				locationName:value.locationName
		};
		/*courseVariants.set("academyLocation.academyId",value.academyId);
		courseVariants.set("academyLocation.id",value.ALid);
		courseVariants.set("academyLocation.locationId",value.locationId);
		courseVariants.set("academyLocation.locationName",value.locationName);
		*/
		courseVariants.set("academyLocation",academyLocation);
		
		if (value.id == null ||value.id == "") {
			submitUrl = SERVERURL.COURSE_VARIANTS_CREATE;
		} else {
			courseVariants.set("id",value.id);
			submitUrl = SERVERURL.COURSE_VARIANTS_UPDATE;
		}

		var submitData = Ext.encode(courseVariants.data);

		Ext.Ajax.request({
			url: submitUrl,
			jsonData: submitData,
			method: 'POST',
			success: function(response) {
				store.getSelectionModel().deselectAll(true);
				grdStore.load();
				$this.courseVaraintClose();
				showSuccessMessage(getCommonTranslation('COURSE_VARIANTS')	,getCommonTranslation('SUCCESS'));
			}
		});

	},

	showFormWindow : function() {

		var formWindow = this.getCoursevariantform();
		if (!formWindow) {
			Ext.widget('coursevariantform');
			formWindow = this.getCoursevariantform();
		}
		formWindow.show();
	},
	editFormWindow: function() {

		var grid = this.getCoursevariantgrid();

		if (grid.getSelectionModel().getCount() > 0) {
			this.showFormWindow();
			var form = this.getCoursevariantForm();

			var store=this.getStore('course.coursevariants.CourseVariantStore');
			var records = grid.getSelectionModel().getSelection()[0];

			if (records != undefined && records != "" && records != null) {
				//form.loadRecord(records);
				//Commented: requested CV code change
				//form.down('#courseVariantCode').setReadOnly(true);
				form.down('#assignCalender').setReadOnly(true);
			}
			var calendarId = records.data.calendarId;
			var assignCalenderStore = this.getStore('calendar.ActiveCalendarStore');
			form.getForm().findField('id').setValue(records.data.id);
			form.down('#courseVariantCode').setValue(records.data.courseVariantCode);
			form.down('#courseVariantDescription').setValue(records.data.courseVariantName);
			form.down('#courseVariantShortDescription').setValue(records.data.courseVariantShortDescription);
			form.down('#academyId').setValue(records.data.academyId);
			form.down('#alId').setValue(records.data.academyLocationId);
			form.down('#locationId').setValue(records.data.locationId);
			form.down('#locationName').setValue(records.data.locationName);
			
			assignCalenderStore.load({
				callback: function(record, operation, success) {
					if (success) {
						form.down('#assignCalender').setValue(calendarId);
					}
				}
			});

		} else {
			showWarningMessage(getCommonTranslation('COURSE_VARIANTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	viewFormWindow : function(){
		var $this = this;
		this.editFormWindow();
		var form =this.getCoursevariantForm();
		if (form) {
			form.down('#coursevariantform_submitbuttonId').setVisible(false);
			form = form.getForm();
			toggleReadOnlyFormItems(form, true);
		}
	},
	deleteFormWindow: function() {

		var grid = this.getCoursevariantgrid();
		var grdStore = grid.getStore();

		if(grid.getSelectionModel().getCount()>0){
			showConfirmMessage(getCommonTranslation('COURSE_VARIANTS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					var records=grid.getSelectionModel().getSelection();						        
					var id=records[0].get("id");
					var sectionName=records[0].get("section");
					Ext.Ajax.request({
						method: "DELETE",
						type: 'rest',
						url: SERVERURL.COURSE_VARIANTS_DELETE+'?id='+id+'&sectionName='+sectionName,
						headers: {
							'Content-Type': 'application/json'
						},
						success:function(form, action){
							if(form.responseText != "SUCCESS"){
                        		showWarningMessage(getCommonTranslation('COURSE'), getProgramandcourseTranslation(form.responseText));                         		
                        	}else{
                        		grdStore.reload();
                        		showSuccessMessage(getCommonTranslation('COURSE'), getCommonTranslation('SUCCESS'));
                        	}
						}
					});
				}
			});
		}else{
			showWarningMessage(getCommonTranslation('COURSE_VARIANTS'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
		}

	},

	gridRenderFunction:function(grid){
   	 grid.addButtonToolbar();
	},
	
	/*
	 * @method
	 * method to load the store manually after the rendering of the grid.
	 */
	courseVaraintGridRender : function(){
		var $this = this;
		var tabStcrFrm = $this.getCoursetabstructure().getForm()
		var alinfomodel = Academia.model.authentication.ALInfoModel;
		var whetherSchool = alinfomodel.get('wheatherSchool');;
		var courseId = tabStcrFrm.findField("ids").getValue();
		var store = $this.getCoursevariantgrid().getStore();
		
		var assignSection= tabStcrFrm.findField("courseSectionType").getValue();
		if(assignSection == 'CourseSection'){	
			var grid = Ext.ComponentQuery.query('coursevariantgrid')[0];
			grid.columns[0].setVisible(true);
			grid.columns[1].setVisible(true);
			grid.columns[2].setVisible(true);
			grid.columns[3].hidden = true;
			grid.columns[4].hidden = true;
			grid.columns[5].setVisible(true);
			grid.columns[6].hidden = true;
			grid.columns[7].setVisible(true);
			grid.columns[8].setVisible(true);
			if(whetherSchool) {
				grid.columns[6].hidden = true;
			}
			var submitURL= SERVERURL.FIND_COURSE_VARIENT_BY_CRITERIA;
			store.getProxy().api.read=submitURL;
			store.getProxy().extraParams = {
				courseId: courseId
			};
			store.load();
		}else{
			var grid = Ext.ComponentQuery.query('coursevariantgrid')[0];
			grid.columns[0].setVisible(true);
			grid.columns[1].setVisible(true);
			grid.columns[2].setVisible(true);
			grid.columns[3].setVisible(true);
			grid.columns[4].setVisible(true);
			grid.columns[5].setVisible(true);
			grid.columns[6].setVisible(true);
			grid.columns[7].setVisible(true);
			grid.columns[8].hidden = true;
			if(whetherSchool) {
				grid.columns[6].hidden = true;
			}
			var submitURL= SERVERURL.COURSE_VARIANT_GRID_DATA;
			store.getProxy().api.read=submitURL;
			store.getProxy().extraParams = {
				courseId: courseId
			};
			store.load();
		}

	},
	getIdValueJson: function(id, value) {
		if (id) return {
			id: id,
			value: value
		};
	},

	getVariantDetails : function(record,grid){

		var window =  this .getCoursevariantdetailslist();
		if (!window) {
			Ext.widget('coursevariantdetailslist');
			window = this.getCoursevariantdetailslist();
		}
		window.show();
		var grid = window.down('grid');
		var alinfomodel = Academia.model.authentication.ALInfoModel;
		var wheatherSchool = alinfomodel.get('wheatherSchool');
		if(wheatherSchool) {
			//Hidden period column on window for school
			grid.columns[3].hide();
			grid.columns[3].setVisible(false);
		}
		if(!isNullOrEmpty(record)){
			var store = grid.getStore();
			store.getProxy().extraParams = {
				courseVariantIds: record.data.id
			};
			store.loadPage(1);
		}
	},
	
});
