/**
 * @author Vishal Joshi
 */
Ext.define('Academia.controller.coursesessiondiary.CourseSessionDiaryController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['common.ProgramStore', 'enquiry.AcademicBatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'attendance.AssignedCoursesFacultyStore','coursesessiondiary.CourseSessionDiaryGridStore','attendance.SectionAndFacultyByPeriodID',
	          'course.coursecomponent.CourseComponentCouseWise','attendance.SectionByCourseNComponent','course.coursevariants.CourseVariantStore',
	          'attendance.AttendanceFacultyList','common.AssignedProgramStore', 'course.AssignedPeriodCoursesFacultyStore','coursetransaction.sectionmanagement.AssignClassTeacherSmartSearch',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.MasterTimeTableForVariant','course.CourseDocument','coursesessiondiary.CourseSessionDiaryDocument','common.CurrentBatchStore',
	          'course.coursevariants.ParameterCourseVariantStore','common.AcademicTermStore','coursesessiondiary.CourseSessionDescriptionStore'],
	          views : ['coursesessiondiary.CourseSessionDiaryStructure', 'coursesessiondiary.CourseSessionDiaryFilter',
	                   'coursesessiondiary.CourseSessionDiaryGrid', 'coursesessiondiary.CourseSessionDiaryForm', 'course.CourseDocumentGrid','coursesessiondiary.CourseSessionDiaryDocumentList',
	                   'coursesessiondiary.CourseSessionDiaryDocumentGrid','coursesessiondiary.CourseSessionDocumentGrid','coursesessiondiary.CourseSessionDiaryFacultyPortalStructure','coursesessiondiary.CourseSessionDiaryFacultyPortalFilter',
	                   'coursesessiondiary.CourseSessionDiaryFacultyPortalGrid','coursesessiondiary.CourseSessionDocumentLinkWin'],
	                   config:{
	                	   COURSE_SESSION_DIARY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_SESSION_DIARY_PRIVILEGES'),
	                	   PNC_SESSION_DIARY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PNC_SESSION_DIARY_PRIVILEGES')
	                   },	         
	                   refs : [{
	                	   ref : 'coursesessiondiarystructure',
	                	   selector : 'coursesessiondiarystructure'
	                   },{
	                	   ref : 'coursesessiondiaryfilter',
	                	   selector : 'coursesessiondiaryfilter'
	                   },{
	                	   ref: 'coursesessiondiarygrid',
	                	   selector: 'coursesessiondiarygrid'
	                   },{
	                	   ref: 'contentPanel',
	                	   selector: 'contentPanel'
	                   },{
	                	   ref: 'coursesessiondiaryform',
	                	   selector: 'coursesessiondiaryform'
	                   }, {
	                	   ref : 'simpledocumentform',
	                	   selector : 'simpledocumentform'

	                   }, {
	                	   ref : 'coursedocumentgrid',
	                	   selector : 'coursedocumentgrid'

	                   }, {
	                 	   ref:'coursesessiondiarydocumentlist',
	                	   selector:'coursesessiondiarydocumentlist'
	                   },{
	                 	   ref:'coursesessiondiarydocumentgrid',
	                	   selector:'coursesessiondiarydocumentgrid'
	                   },{
	                 	   ref:'coursesessiondocumentgrid',
	                	   selector:'coursesessiondocumentgrid'
	                   },{
	                 	   ref:'coursesessiondiaryfacultyportalstructure',
	                	   selector:'coursesessiondiaryfacultyportalstructure'
	                   },{
	                 	   ref:'coursesessiondiaryfacultyportalfilter',
	                	   selector:'coursesessiondiaryfacultyportalfilter'
	                   },{
	                 	   ref:'coursesessiondiaryfacultyportalgrid',
	                	   selector:'coursesessiondiaryfacultyportalgrid'
	                   },{
	                	   ref:'coursesessiondocumentlinkwin',
	                	   selector:'coursesessiondocumentlinkwin'
	                   },{
	                	   ref:'coursesessiondiarydocumentform',
	                	   selector:'coursesessiondiarydocumentform'
	                   }],
	                   init : function() {
	                	   this.control({
	                		   'coursesessiondiarystructure' : {
                      			 render : function(structure){
                      				 var grid = structure.down('coursesessiondiarygrid');
                      				 this.getGridHeaderFreeze(grid,structure,false);
                      			}
                      		 },
                      		'coursesessiondiaryfacultyportalstructure' : {
                      			render : function(structure){
                      				var grid = structure.down('coursesessiondiaryfacultyportalgrid');
                      				var newStructure=structure.up('personinfofacultyportal');
                      				if(newStructure!= undefined && !isNullOrEmpty(newStructure)){
                      					this.getGridHeaderFreeze(grid,newStructure,false);
                      				}
                      			}
                     		 },
	                		   'coursesessiondiaryfilter button[itemId=courseReadingSearchBtn]': {
	                			   click: this.loadCourseSessionDiaryGrid
	                		   },
	                		   'coursesessiondiaryfilter button[itemId=courseReadingResetBtn]': {
	                			   click: this.resetCourseSessionDiaryFilter
	                		   },
	                		   'coursesessiondiarygrid button[itemId=btnDelete]':{
	                			   click: this.deleteCourseSessionDiaryRecord
	                		   },
	                		   'coursesessiondiarygrid button[itemId=btnAdd]':{
	                			   click: this.addCourseSessionDiaryRecord
	                		   },
	                		   'coursesessiondiarygrid button[itemId=btnView]':{
	                			   click: Ext.bind(this.editCourseSessionDiaryRecord, this, [true])
	                		   },
	                		   'coursesessiondiaryform button[itemId=submitBtn]':{
	                			   click: this.saveCourseSessionDiaryRecord
	                		   },
	                		   'coursesessiondiarygrid button[itemId=btnEdit]':{
	                			   click: Ext.bind(this.editCourseSessionDiaryRecord, this, [false])
	                		   },

	                		   'coursesessiondiaryfilter customcombobox[itemId=intakeYear]':{
	                			   select:function(obj, record){
	                				   var $this = this;
	                				   var intakeYearId = record[0].data.id;
	                				   var form = $this.getCoursesessiondiaryfilter();
	                				   var program = form.down("#programId");
	                				   var facultyId = null;
	                				   if ($this.getCurrentLoggedPortalId() == 2) {
	                					   facultyId = $this.getCurrentlyLoggedInUser().id;
	                				   }
	                				   program.getStore().getProxy().extraParams = {
	                					   facultyId: facultyId,
	                					   academyLocationIds: $this.getCurrentAcademyLocation(),
	                					   intakeYearId : intakeYearId
	                				   };
	                				   program.getStore().load();
	                			   }
	                		   },

	                		   'coursesessiondiaryfilter combo#programId' : {
	                			   select : function(obj, record) {
	                				   var $this = this;
	                				   var programId = record[0].get("id");
	                				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				   if(wheatherSchool) {
	                					   $this.getCoursesessiondiaryfilter().down('#periodId').setVisible(false);
  				                	 }
	                				   var form = this.getCoursesessiondiaryfilter();
	                				   form.down('#componentId').clearValue();
	                				   form.down('#componentId').setVisible(false);
	                				   var batchComboBox= form.down('#batchId');
	                				   var periodId= form.down('#periodId');
	                				   batchComboBox.setDisabled(false);
	                				   var store = this.getStore('common.CurrentBatchStore');
	                				   store.getProxy().extraParams = {
	                					   programId : programId
	                				   };
	                				   store.load({
	                					   callback: function(records, operation, success) {
	                						   if (success) {
	                							   var batchId = 0;
	                							   for(var i=0,j=0; i<records.length; i++){
	                								   if (records.length == 1) {
	                									   batchId = records[i].data.id;
	                								   } else if(records[i].data.isCurrentPeriodOfProgram){
	                									   if(j==0){
	                										   batchId = records[i].data.id;
	                										   j++;
	                									   } else {
	                										   batchId = 0;
	                										   return;
	                									   }
	                								   }
	                							   }
	                							   if(batchId > 0){
	                								   batchComboBox.setValue(batchId);
	                								   var periodField=form.down('combo#periodId');
	                								   periodField.enable();
	                								   var storePeriod = periodField.getStore();
	                								   storePeriod.getProxy().extraParams = {
	                									   id:batchId,
	                								   };

	                								   storePeriod.load({
	                									   callback: function(records, operation, success) {
	                										   if (success) {
	                											   if(records.length == 0){
	                												   if(wheatherSchool) {
	                													   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
	                												   }
	                											   } else if(records.length == 1){
	                												   if(wheatherSchool) {
	                													   periodField.setVisible(false);
	                												   }
	                												   periodField.setValue(records[0].data.id);
	                												   periodId.setValue(records[0].data.id);
	                												   var sectionComboBox = $this.getCoursesessiondiaryfilter().down('combo#sectionId');
	                												   $this.getCoursesessiondiaryfilter().down('#CourseSection_ID').setVisible(false);
	                												   var course = $this.getCoursesessiondiaryfilter().down('#courseId').reset();
	                												   sectionComboBox.setVisible(true);
	                												   sectionComboBox.setDisabled(false);
	                												   sectionComboBox.clearValue();
	                												   var sectionStore = sectionComboBox.getStore();
	                												   sectionStore.getProxy().extraParams = {
	                													   periodId:records[0].data.id
	                												   };
	                												   sectionStore.load();
	                											   } else {
	                												   periodField.setVisible(true);
	                											   }	 
	                										   }

	                									   }	   
	                								   });
	                							   }		 
	                						   }
	                					   }	   
	                				   });
	                				   form.down('#courseId').reset();
	                			   },
	                			   render: function(obj, record) {
	                				   var $this = this;
	                				   var store = obj.getStore();
	                				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				   if(wheatherSchool) {
	                					   $this.getCoursesessiondiaryfilter().down('#periodId').setVisible(false);
	                				   } else {
	                					   $this.getCoursesessiondiaryfilter().down('#periodId').setVisible(true);
	                				   }
	                				   var form = this.getCoursesessiondiaryfilter();
	                				   var programComboBox = form.down('#programId');
	                				   var batchComboBox = form.down('#batchId');
	                				   var periodId = form.down('#periodId');
	                				   var facultyId = null;
	                				   if (this.getCurrentLoggedPortalId() == 2) {
	                					   facultyId = this.getCurrentlyLoggedInUser().id;
	                				   }
	                				   store.getProxy().extraParams = {
	                					   facultyId: facultyId,
	                					   academyLocationIds: this.getCurrentAcademyLocation()
	                				   };
	                				   store.load();
	                						   /**
	                		 					 * This Code is commented as discussed with the @khushbu(Product team) and @priyal
	                		 					 * this should not get pre-filled on render.V2D-47898
	                		 					 */
	                						   /*{
	                					   callback: function(records, operation, success) {
	                						   if (success) {
	                							   if (records.length == 1) {
	                								   programComboBox.setValue(records[0].data.id);

	                								   batchComboBox.setDisabled(false);
	                								   var store = $this.getStore('common.CurrentBatchStore');
	                								   store.getProxy().extraParams = {
	                									   programId: records[0].data.id
	                								   };
	                								   store.load({
	                									   callback: function(records, operation, success) {
	                										   if (success) {
	                											   var batchId = 0;
	                											   for(var i=0,j=0; i<records.length; i++){
	                												   if (records.length == 1) {
	                													   batchId = records[i].data.id;
	                												   } else if(records[i].data.isCurrentPeriodOfProgram){
	                													   if(j==0){
	                														   batchId = records[i].data.id;
	                														   j++;
	                													   } else {
	                														   batchId = 0;
	                														   return;
	                													   }
	                												   }
	                											   }
	                											   if(batchId > 0){
	                												   batchComboBox.setValue(batchId);
	                												   var periodField=form.down('combo#periodId');
	                												   periodField.enable();
	                												   var storePeriod = periodField.getStore();
	                												   storePeriod.getProxy().extraParams = {
	                													   id:batchId,
	                												   };

	                												   storePeriod.load({
	                													   callback: function(records, operation, success) {
	                														   if (success) {
	                															   if(records.length == 0){
	                																   if(wheatherSchool) {
	                																	   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
	                																   }
	                															   } else if(records.length == 1){
	                																   if(wheatherSchool) {
	                																	   periodField.setVisible(false);
	                																   }
	                																   periodField.setValue(records[0].data.id);
	                																   periodId.setValue(records[0].data.id);
	                																   var sectionComboBox = $this.getCoursesessiondiaryfilter().down('combo#sectionId');
	                																   $this.getCoursesessiondiaryfilter().down('#CourseSection_ID').setVisible(false);
	                																   var course = $this.getCoursesessiondiaryfilter().down('#courseId').reset();
	                																   sectionComboBox.setVisible(true);
	                																   sectionComboBox.setDisabled(false);
	                																   sectionComboBox.clearValue();
	                																   var sectionStore = sectionComboBox.getStore();
	                																   sectionStore.getProxy().extraParams = {
	                																	   periodId:records[0].data.id
	                																   };
	                																   sectionStore.load();
	                															   } else {
	                																   periodField.setVisible(true);
	                															   }	 
	                														   }

	                													   }	   
	                												   });
	                											   }		 
	                										   }
	                									   }	   
	                								   });
	                								   form.down('#courseId').reset();
	                							   }
	                						   }

	                					   }
	                				   }*/
	                			   }
	                		   },

	                		   'coursesessiondiaryfilter combo#batchId' : {
	                			   select : function(obj,record){
	                				   var $this = this;
	                				   var form = obj.up('form');
	                				   var periodComboBox = form.down('combo#periodId');
	                				   periodComboBox.setDisabled(false);
	                				   periodComboBox.clearValue();
	                				   var periodStore = periodComboBox.getStore();
	                				   periodStore.getProxy().extraParams = {
	                					   id: record[0].data.id
	                				   };
	                				   periodStore.load({
	                					   callback: function(records, operation, success) {
	                						   if (success) {
	                							   if(records.length == 0){
	                								   if(wheatherSchool) {
	                									   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
	                								   }
	                							   } else if(records.length == 1){
	                								   if(wheatherSchool) {
	                									   periodComboBox.setVisible(false);
	                								   }
	                								   periodComboBox.setValue(records[0].data.id);
	                								   periodComboBox.setValue(records[0].data.id);
	                								   var sectionComboBox = $this.getCoursesessiondiaryfilter().down('combo#sectionId');
	                								   $this.getCoursesessiondiaryfilter().down('#CourseSection_ID').setVisible(false);
	                								   var course = $this.getCoursesessiondiaryfilter().down('#courseId').reset();
	                								   sectionComboBox.setVisible(true);
	                								   sectionComboBox.setDisabled(false);
	                								   sectionComboBox.clearValue();
	                								   var sectionStore = sectionComboBox.getStore();
	                								   sectionStore.getProxy().extraParams = {
	                									   periodId:records[0].data.id
	                								   };
	                								   sectionStore.load();
	                							   } else {
	                								   periodComboBox.setVisible(true);
	                							   }	 
	                						   }

	                					   }	   
	                				   });
	                			   }
	                		   },

	                		   'coursesessiondiaryfilter combo#periodId' : {
	                			   select : function(obj,record){
	                				   var form = obj.up('form');
	                				   var sectionComboBox = form.down('combo#sectionId');
	                				   form.down('#CourseSection_ID').setVisible(false);
	                				   var course = form.down('#courseId').reset();
	                				   sectionComboBox.setVisible(true);
	                				   sectionComboBox.setDisabled(false);
	                				   sectionComboBox.clearValue();
	                				   var sectionStore = sectionComboBox.getStore();
	                				   sectionStore.getProxy().extraParams = {
	                					   periodId:record[0].data.id
	                				   };
	                				   sectionStore.load();
	                			   }
	                		   },
	                		   'coursesessiondiaryfilter combo#courseId' : {
	                			   afterrender : function(obj,record){
	                				   var form = obj.up('form');
	                				   var $this = this;
	                				   var courseComboBox = form.down('combo#courseId');
	                				   var courseStore = courseComboBox.getStore();
	                				   var facultyId=null;
	                				   if($this.getCurrentLoggedPortalId()==2){
	                					   facultyId=$this.getCurrentlyLoggedInUser().id;
	                				   }
	                				   courseStore.getProxy().extraParams = {
	                					   facultyId:facultyId,
	                					   academyLocationId:$this.getCurrentAcademyLocation()
	                				   };
	                				   courseStore.load();
	                			   },
	                			   select : function(obj,record){
	                				   var form = obj.up('form');
	                				   if(!record[0].data.sectionAtComponentLevel){
	                					   var alinfomodel = Academia.model.authentication.ALInfoModel;
		                				   var wheatherSchool=alinfomodel.get('wheatherSchool');
	                					   form.down('#sectionId').setVisible(false);
	                					   form.down('#componentId').clearValue();
	                					   form.down('#componentId').setVisible(false);
	                					   var sectionCombo = form.down('#CourseSection_ID');
	                					   sectionCombo.setVisible(true);
	                					   sectionCombo.setDisabled(false);
	                					   sectionCombo.clearValue();
	                					   var sectionStore = sectionCombo.getStore();
	                					   sectionStore.getProxy().extraParams = {
	                						   parentCourseId:record[0].data.courseId,
	                						   wheatherSchool:wheatherSchool,
	                						   sectionAtComponentLevel:record[0].data.sectionAtComponentLevel
	                					   }
	                					   sectionStore.load();
	                				   }else{
	                					   form.down('#sectionId').setVisible(false);
	                					   form.down('#CourseSection_ID').setVisible(false);
	                					   form.down('#componentId').setVisible(true);
	                					   var componentCombo = form.down('#componentId');
	                					   var componentStore = componentCombo.getStore();
	                					   componentStore.getProxy().extraParams = {
	                						   courseId:record[0].data.courseId
	                					   }
	                					   componentStore.load();
	                				   }

	                			   }
	                		   },

	                		   'coursesessiondiaryfilter combo#componentId' : {
	                			   select : function(obj,record){
	                				   var componentId = record[0].get("id");
	                				   var form = obj.up('form');
	                				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				   var courseId = form.getForm().findField('courseId').getValue();
	                				   var sectionComboBox = form.down('combo#CourseSection_ID');
	                				   form.down("#CourseSection_ID").setDisabled(false);
	                				   sectionComboBox.setVisible(true);
	                				   sectionComboBox.clearValue();
	                				   var sectionStore = sectionComboBox.getStore();
	                				   sectionStore.getProxy().extraParams = {
	                					   parentCourseId:courseId,
	                					   componentId:componentId,
	                					   sectionAtComponentLevel:true,
	                					   wheatherSchool:wheatherSchool
	                				   };
	                				   sectionStore.load({
	                					   callback: function(records, operation, success) {
	                						   if (success) {
	                							   if(records.length == 1){
	                								   sectionComboBox.setValue(records[0].data.sectionId);
	                							   }		 
	                						   }
	                					   }
	                				   });
	                			   }
	                		   },
	                		   'coursesessiondiarygrid':{
	                			   render:function(grid){
	                				   this.loadCourseSessionDiaryGrid();
	                				   if(this.getCurrentLoggedPortalId()==2){
	                					   this.doAccessControlValidation(grid, this.getCOURSE_SESSION_DIARY_PERMISSIONS());
	                				   }else{
	                					   this.doAccessControlValidation(grid, this.getPNC_SESSION_DIARY_PERMISSIONS());
	                				   }
	                			   },
									afterrender: function(grid) {
                						var me = this;
										setTimeout(function(){
	    									me.addDataGridConfigButton(grid,me.getPNC_SESSION_DIARY_PERMISSIONS());
										}, 1500);
               						},
	                			   cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
	                				   var columnName=grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
	                				   if(columnName=='description'){
	                					   this.openDocumentLinkWindow(record);
	                				   }
	                				   if(columnName=='document' && record.data.documents.length == 1){
	                					   var documentId = record.data.document.code;
	             						  if (!isNullOrEmpty(documentId)) {
	             							  this.getDownloadFileForCourseSessionDiaryDocument(documentId);
	             						  }
	                				   } else if(columnName=='document' && record.data.documents.length > 1){
	                					   this.linkNoOfCourseSessionDiaryDocuments(grid, RowIdx, record);
	                				   }
	                			   }
	                		   },
	                		   'coursesessiondiaryform' : {
	                			   render : function(form){
	                				   var faculty=form.down("#facultyId");
	                				   var courseVariant=form.down("#courseVariantId");
	                				   faculty.getStore().removeAll();
	                				   courseVariant.getStore().removeAll();
	                				   if(this.getCurrentLoggedPortalId()==2){
	                					   faculty.allowBlank=true;
	                					   faculty.setVisible(false);
	                					   //faculty.isValid(true);
	                				   }else{
	                					   faculty.allowBlank=false;
	                					   faculty.setVisible(true);
//	                					   faculty.isValid(true);
	                				   }
	                				  
	                			   }
	                		   },
	                		   'coursesessiondiaryform combo#courseId' : {
	                			   afterrender : function(obj,record){
	                				   var form = obj.up('form');
	                				   var $this = this;
	                				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				   var whetherSchool = alinfomodel.get('wheatherSchool');
	                				   var courseComboBox = form.down('combo#courseId');
	                				   var courseStore = courseComboBox.getStore();
	                				   var facultyId;
	                				   if($this.getCurrentLoggedPortalId()==2){
	                					   facultyId=$this.getCurrentlyLoggedInUser().id;
	                				   }
	                				   courseStore.getProxy().extraParams = {
	                					   facultyId:facultyId,
	                					   academyLocationId:$this.getCurrentAcademyLocation()
	                				   };
	                				   courseStore.load({
	                					   callback: function(record, operation, success) {
	                						   if (success) {
	                							   if (record.length == 1) {
	                								   courseComboBox.setValue(record[0].data.courseId);
	                								   if(!record[0].data.sectionAtComponentLevel){
	                									   var variantCombo = $this.getCoursesessiondiaryform().down('#courseVariantId');
	                									   var courseId = $this.getCoursesessiondiaryform().getForm().findField('courseId').getValue();
	                									   var portalId = $this.getCurrentLoggedPortalId();
	                									   var componentId=form.down('#componentId');
	                									   componentId.clearValue();
	                									   componentId.setVisible(false);
	                									   componentId.allowBlank = true;
	                									   var facultyId = null;
	                									   if(portalId == 2) {
	                										   var faculty = $this.getCurrentlyLoggedInUser();
	                										   facultyId = faculty.id;
	                										   faculty=form.down("#facultyId");
	                									   }
	                									   variantCombo.setDisabled(false);
	                									   var store = variantCombo.getStore();
	                									   store.getProxy().extraParams = {
	                										   courseId: courseId,
	                										   sectionAtComponentLevel:false,
	                										   facultyId:facultyId,
	                										   whetherSchool : whetherSchool,
	                										   academyLocationIds:$this.getCurrentAcademyLocation(),
	                										   isCurrentPeriod:true
	                									   };
	                									   store.load({
	                										   callback: function(record, operation, success) {
	                											   if (success) {
	                												   if (record.length == 1) {
	                													   variantCombo.setValue(record[0].data.id);
	                													   $this.getCoursesessiondiaryform().down('#courseSessionToDateId').setMaxValue(dateFormatRender(new Date(record[0].data.periodEndDate)));
	                													   $this.getCoursesessiondiaryform().down('#courseSessionDateId').setMinValue(dateFormatRender(new Date(record[0].data.periodStartDate)));
	                													   var course = $this.getCoursesessiondiaryform().down("#courseId");
	                													   var timeSlot = form.down("#timeSlot");
	                													   var courseVariantId = form.down("#courseVariantId");
	                													    timeSlot.clearValue();
	                	   													timeSlot.setDisabled(false);
	                													   faculty.clearValue();
	                													   var facultyStore = faculty.getStore();
	                													   facultyStore.getProxy().extraParams = {
	                														   courseVariantId:record[0].data.id,
	                														   componentId:null,
	                														   courseId:course.getValue()
	                													   };
																		   facultyStore.load();
																		   if(!isNullOrEmpty(courseVariantId)) {
																			   var weekDay = $this.getWeekDayFromDate(form.down("#courseSessionDateId").getValue());
																			   var timeSlotStore = timeSlot.getStore();
																			   var calendarId = 0;
																			   /*if(!isNullOrEmpty(courseVariantId.store.data.items[0])){
																				   calendarId=courseVariantId.store.data.items[0].raw.calendar.id;
																			   }*/
																			   if (!isNullOrEmpty(courseVariantId.getValue()) && !isNullOrEmpty(courseVariantId.getStore().findRecord('id', courseVariantId.getValue()))) {
																				   var selectedRecord = courseVariantId.getStore().findRecord('id', courseVariantId.getValue());
																				   if (!isNullOrEmpty(selectedRecord.data.calendar) && !isNullOrEmpty(selectedRecord.data.calendar.id)) {
																					   calendarId = selectedRecord.data.calendar.id;
																				   }
																				   else {
																					   calendarId = null;
																				   }
																			   }

																			   timeSlotStore.getProxy().extraParams = {
																				   variantId: record[0].data.id,
																				   facultyId: facultyId,
																				   weekDay: weekDay,
																				   calendarId: calendarId
																			   };
																			   timeSlotStore.load();
																		   }
	                												   }
	                											   }
	                										   }
	                									   });
	                								   }else{
	                									   form.down('#componentId').setVisible(true);
	                									   var componentCombo = $this.getCoursesessiondiaryform().down('#componentId');
	                									   var componentStore = componentCombo.getStore();
	                									   componentStore.getProxy().extraParams = {
	                										   courseId:record[0].data.courseId
	                									   }
	                									   componentStore.load({
	                										   callback: function(record, operation, success) {
	                											   if (success) {
	                												   if (record.length == 1) {
	                													   componentCombo.setValue(record[0].data.id);
	                													   var courseVariant = $this.getCoursesessiondiaryform().down("#courseVariantId");
	                													   courseVariant.clearValue();
	                													   courseVariant.setDisabled(false);
	                													   var facultyId = null;
	                													   var portalId = $this.getCurrentLoggedPortalId();
	            	                									   if(portalId == 2) {
	            	                										   var faculty = $this.getCurrentlyLoggedInUser();
	            	                										   facultyId = faculty.id;
	            	                									   }
	                													   var courseVariantStore = courseVariant.getStore();
	                													   courseVariantStore.getProxy().extraParams = {
	                														   componentId:record[0].data.id,
	                														   sectionAtComponentLevel:true,
	                														   courseId:courseId,
	                														   facultyId:facultyId,
	                														   whetherSchool : whetherSchool,
	            	                										   academyLocationIds:$this.getCurrentAcademyLocation(),
	            	                										   isCurrentPeriod:true
	                													   };
	                													   courseVariantStore.load({
	                														   callback: function(record, operation, success) {
	                															   if (success) {
	                																   if (record.length == 1) {
	                																	   variantCombo.setValue(record[0].data.id);
	                																	   $this.getCoursesessiondiaryform().down('#courseSessionToDateId').setMaxValue(dateFormatRender(new Date(record[0].data.periodEndDate)));
	                																	   $this.getCoursesessiondiaryform().down('#courseSessionDateId').setMinValue(dateFormatRender(new Date(record[0].data.periodStartDate)));
	                																	   var faculty = $this.getCoursesessiondiaryform().down("#facultyId");
	                																	   var component = $this.getCoursesessiondiaryform().down("#componentId");
	                																	   var course = $this.getCoursesessiondiaryform().down("#courseId");
	                																	   faculty.clearValue();
	                																	   var facultyStore = faculty.getStore();
	                																	   facultyStore.getProxy().extraParams = {
	                																		   courseVariantId:record[0].data.id,
	                																		   componentId:component.getValue(),
	                																		   courseId:course.getValue()
	                																	   };
	                																	   facultyStore.load();
	                																   }
	                															   }
	                														   }
	                													   });
	                												   }
	                											   }
	                										   }
	                									   });
	                								   }
	                							   }
	                						   }
	                					   }
	                				   });
	                			   },
	                			   select : function(obj,record){
	                				   var this$ = this;
	                				   var form = obj.up('form');
	                				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				   var whetherSchool = alinfomodel.get('wheatherSchool');
	                				   if(!record[0].data.sectionAtComponentLevel){
	                					   var variantCombo = form.down('#courseVariantId');
	                					   var courseId = form.getForm().findField('courseId').getValue();
	                					   var portalId = this.getCurrentLoggedPortalId();
	                					   var componentId=form.down('#componentId');
	                					   componentId.clearValue();
	                					   componentId.setVisible(false);
	                					   componentId.allowBlank = true;
	                					   var facultyId = null;
	                					   if(portalId == 2) {
	                						   var faculty = this.getCurrentlyLoggedInUser();
	                						   facultyId = faculty.id;
	                					   }
	                					   variantCombo.setDisabled(false);
	                					   var store = variantCombo.getStore();
	                					   store.getProxy().extraParams = {
	                						   courseId: courseId,
	                						   sectionAtComponentLevel:false,
	                						   facultyId:facultyId,
	                						   whetherSchool:whetherSchool,
    										   academyLocationIds:this$.getCurrentAcademyLocation(),
    										   isCurrentPeriod:true
	                					   };
	                					   store.load({
	                						   callback: function(record, operation, success) {
	                							   if (success) {
	                								   if (record.length == 1) {
	                									   variantCombo.setValue(record[0].data.id);
	                									   this$.getCoursesessiondiaryform().down('#courseSessionToDateId').setMaxValue(dateFormatRender(new Date(record[0].data.periodEndDate)));
	                									   this$.getCoursesessiondiaryform().down('#courseSessionToDateId').setValue(dateFormatRender(new Date(record[0].data.periodEndDate)));
	                									   this$.getCoursesessiondiaryform().down('#courseSessionDateId').setMinValue(dateFormatRender(new Date(record[0].data.periodStartDate)));
	                									   //this$.getCoursesessiondiaryform().down('#courseSessionToDateId').isValid();
	                									   var faculty = this$.getCoursesessiondiaryform().down("#facultyId");
	                									   var course = this$.getCoursesessiondiaryform().down("#courseId");
	                									   faculty.clearValue();
	                									   var facultyStore = faculty.getStore();
	                									   facultyStore.getProxy().extraParams = {
	                										   courseVariantId:record[0].data.id,
	                										   componentId:null,
	                										   courseId:course.getValue()
	                									   };
	                									   facultyStore.load({
	                										   callback: function(record, operation, success) {
	                											   if (success) {
	                												   if (record.length == 1) {
	                													   faculty.setValue(record[0].data.facultyId);
	                													   var timeSlot = form.down("#timeSlot");
	                													   timeSlot.clearValue();
	                													   timeSlot.setDisabled(false);
	                													   this$.loadSessionDiaryTimeSlotCombo(form);
	                												   }
	                											   }
	                										   }
	                									   });
	                								   }
	                							   }
	                						   }
	                					   });
	                				   }else{
	                					   form.down('#componentId').setVisible(true);
	                					   var componentCombo = form.down('#componentId');
	                					   var componentStore = componentCombo.getStore();
	                					   componentStore.getProxy().extraParams = {
	                						   courseId:record[0].data.courseId
	                					   }
	                					   componentStore.load({
	                						   callback: function(record, operation, success) {
	                							   if (success) {
	                								   if (record.length == 1) {
	                									   componentCombo.setValue(record[0].data.id);
	                									   var courseVariant = form.down("#courseVariantId");
	                									   courseVariant.clearValue();
	                									   courseVariant.setDisabled(false);
	                									   var courseVariantStore = courseVariant.getStore();
	                									   courseVariantStore.getProxy().extraParams = {
	                										   componentId:record[0].data.id,
	                										   sectionAtComponentLevel:true,
	                										   courseId:courseId,
	                										   whetherSchool:whetherSchool,
	                										   academyLocationIds:this$.getCurrentAcademyLocation(),
	                										   isCurrentPeriod:true
	                									   };
	                									   courseVariantStore.load({
	                										   callback: function(record, operation, success) {
	                											   if (success) {
	                												   if (record.length == 1) {
	                													   courseVariant.setValue(record[0].data.id);
	                													   this$.getCoursesessiondiaryform().down('#courseSessionToDateId').setValue(dateFormatRender(new Date(record[0].data.periodEndDate)));
	                													   this$.getCoursesessiondiaryform().down('#courseSessionToDateId').setMaxValue(dateFormatRender(new Date(record[0].data.periodEndDate)));
	                													   this$.getCoursesessiondiaryform().down('#courseSessionDateId').setMinValue(dateFormatRender(new Date(record[0].data.periodStartDate)));
	                													   this$.getCoursesessiondiaryform().down('#courseSessionToDateId').isValid();
	                													   var faculty = this$.getCoursesessiondiaryform().down("#facultyId");
	                													   var component = form.down("#componentId");
	                													   var course = this$.getCoursesessiondiaryform().down("#courseId");
	                													   faculty.clearValue();
	                													   var facultyStore = faculty.getStore();
	                													   facultyStore.getProxy().extraParams = {
	                														   courseVariantId:record[0].data.id,
	                														   componentId:component.getValue(),
	                														   courseId:course.getValue()
	                													   };
	                													   facultyStore.load({
	                														   callback: function(record, operation, success) {
	                															   if (success) {
	                																   if (record.length == 1) {
	                																	   faculty.setValue(record[0].data.facultyId);
	                																	   var timeSlot = form.down("#timeSlot");
	                																	   timeSlot.clearValue();
	                																	   timeSlot.setDisabled(false);
	                																	   this$.loadSessionDiaryTimeSlotCombo(form);
	                																   }
	                															   }
	                														   }
	                													   });
	                												   }
	                											   }
	                										   }
	                									   });
	                								   }
	                							   }
	                						   }
	                					   });
	                				   }
	                			   }
	                		   },
	                		   'coursesessiondiaryform combo#courseVariantId' : {
	                			   select : function(obj,record){
	                				   var me  = this;
	                				   var form = this.getCoursesessiondiaryform();
	                				   var faculty = form.down("#facultyId");
	                				   var component = form.down("#componentId");
	                				   var course = form.down("#courseId");
	                				   form.down('#courseSessionToDateId').setValue(dateFormatRender(new Date(record[0].data.periodEndDate)));
	                				   form.down('#courseSessionToDateId').setMaxValue(dateFormatRender(new Date(record[0].data.periodEndDate)));
	                				   form.down('#courseSessionDateId').setMinValue(dateFormatRender(new Date(record[0].data.periodStartDate)));
	                				   form.down('#courseSessionToDateId').isValid();
	                				   faculty.clearValue();
	                				   var facultyStore = faculty.getStore();
	                				   facultyStore.getProxy().extraParams = {
	                					   courseVariantId:record[0].data.id,
	                					   componentId:component.getValue(),
	                					   courseId:course.getValue()
	                				   };
	                				   facultyStore.load({
	                					   callback: function(record, operation, success) {
	                						   if (success) {
	                							   if (record.length == 1) {
	                								   faculty.setValue(record[0].data.facultyId);
	                								   var timeSlot = form.down("#timeSlot");
	                								   timeSlot.clearValue();
	                								   timeSlot.setDisabled(false);
	                								   me.loadSessionDiaryTimeSlotCombo(form);
	                							   }
	                						   }
	                					   }
	                				   });
//	                				   this.loadSessionDiaryTimeSlotCombo(form);
	                			   }
	                		   },
	                		   'coursesessiondiaryform datefield#courseSessionDateId' : {
	                			   select : function(obj,record){
	                				   var form = this.getCoursesessiondiaryform();
	                				   this.loadSessionDiaryTimeSlotCombo(form);
	                			   }
	                		   },
	                		   'coursesessiondiaryform combo#facultyId' : {
	                			   select : function(obj,record){
	                				   var form = this.getCoursesessiondiaryform();
	                				   var timeSlot = form.down("#timeSlot");
	                				   timeSlot.clearValue();
	                				   timeSlot.setDisabled(false);
	                				   this.loadSessionDiaryTimeSlotCombo(form);
	                			   }
	                		   },
	                		   'coursesessiondiaryform combo#componentId' : {
	                			   select : function(obj,record){
	                				   var this$ = this;
	                				   var form = this.getCoursesessiondiaryform();
	                				   var portalId = this.getCurrentLoggedPortalId();
	                				   /*var faculty = form.down("#facultyId");
		                				   faculty.clearValue();
		                				   var facultyStore = faculty.getStore();
		                				   facultyStore.getProxy().extraParams = {
		                					   couseVariantId:record[0].data.id
		                				   };
		                				   facultyStore.load();*/
	                				   var facultyId = null;
									   if(portalId == 2) {
										   var faculty = this$.getCurrentlyLoggedInUser();
										   facultyId = faculty.id;
									   }
	                				   var courseId = form.down("#courseId").getValue();
	                				   var courseVariant = form.down("#courseVariantId");
	                				   courseVariant.clearValue();
	                				   courseVariant.setDisabled(false);
	                				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				   var courseVariantStore = courseVariant.getStore();
	                				   courseVariantStore.getProxy().extraParams = {
	                					   componentId:record[0].data.id,
	                					   sectionAtComponentLevel:true,
	                					   courseId:courseId,
	                					   whetherSchool:wheatherSchool,
	                					   facultyId:facultyId,
										   academyLocationIds:this$.getCurrentAcademyLocation(),
										   isCurrentPeriod:true
	                				   };
	                				   courseVariantStore.load({
	                					   callback: function(record, operation, success) {
	                						   if (success) {
	                							   if (record.length == 1) {
	                								   courseVariant.setValue(record[0].data.id);
	                								   this$.getCoursesessiondiaryform().down('#courseSessionToDateId').setValue(dateFormatRender(new Date(record[0].data.periodEndDate)));
	                								   this$.getCoursesessiondiaryform().down('#courseSessionToDateId').setMaxValue(dateFormatRender(new Date(record[0].data.periodEndDate)));
	                								   this$.getCoursesessiondiaryform().down('#courseSessionDateId').setMinValue(dateFormatRender(new Date(record[0].data.periodStartDate)));
	                								   this$.getCoursesessiondiaryform().down('#courseSessionToDateId').isValid();
	                								   var faculty = this$.getCoursesessiondiaryform().down("#facultyId");
	                								   var component = form.down("#componentId");
	                								   var course = this$.getCoursesessiondiaryform().down("#courseId");
	                								   faculty.clearValue();
	                								   var facultyStore = faculty.getStore();
	                								   facultyStore.getProxy().extraParams = {
	                									   courseVariantId:record[0].data.id,
	                									   componentId:component.getValue(),
	                									   courseId:course.getValue()
	                								   };
	                								   facultyStore.load({
	                									   callback: function(record, operation, success) {
	                										   if (success) {
	                											   var timeSlot = form.down("#timeSlot");
	                			                				   timeSlot.clearValue();
	                			                				   timeSlot.setDisabled(false);
	                			                				   this$.loadSessionDiaryTimeSlotCombo(form);
	                											   if (record.length == 1) {
	                												   faculty.setValue(record[0].data.facultyId);
	                											   }
	                										   }
	                									   }
	                								   });
	                							   }
	                						   }
	                					   }
	                				   });
	                			   }
	                		   },

	                		   'coursesessiondiaryform button[itemId=btnCancelCourseSessionDairy]': {
	                			   click: this.closeCourseSessionDairyDetailTab
	                		   },

	                		   'documentformwindow[itemId=createcourseSessionDiaryformItemId] coursesessiondiarydocumentform[itemId=coursesessiondiarydocumentform] button#courseSessionDocumentFormSubmitButtonId' : {
	                			   click : function() {
	                				   var $this = this;
	                				   var isTransient = true;
	                				   var module = 'courseSessionDiary';
	                				   var entityId;
	                				   var entityType = 'courseSessionDiaryDocument';

	                				   $this
	                				   .getDocumentController()
	                				   .saveDocumentForm(
	                						   entityId,
	                						   module,
	                						   entityType,
	                						   'COURSE_SESSION_DOCUMENT',
	                						   function(success,
	                								   response,
	                								   isCallBackTransient) {
	                							   var documentModel = new Academia.model.course.CourseDocument();
	                							   documentModel
	                							   .set(
	                									   "documentName",
	                									   response.name);
	                							   documentModel
	                							   .set(
	                									   "path",
	                									   response.path);
	                							   documentModel
	                							   .set(
	                									   "type",
	                									   response.type);
	                							   documentModel
	                							   .set(
	                									   "documentName",
	                									   response.name);
	                							   documentModel.set("createdBy", $this.getIdValueJson(response.createdBy.id, response.createdBy.value));
	                							   var courseSessionDocGrid = $this
	                							   .getCoursesessiondocumentgrid();
	                							   var store = courseSessionDocGrid
	                							   .getStore();
	                							   store
	                							   .add(documentModel);
	                							   if (courseSessionDocGrid.isHidden() && store.data.items.length > 0) {
	                								   courseSessionDocGrid.setVisible(true);
	                    							}
	                							   $this.getDocumentController().closeDocumentFormWindow();
	                							   showSuccessMessage(getProgramandcourseTranslation('COURSE_SESSION_DIARY'),getProgramandcourseTranslation('COURSE_SESSION_DIARY_DOCUMENT_ADD_SUCCESSFULLY'));
		                							  
	                						   }, isTransient);
	                			   }
	                		   },
	               		      'coursesessiondocumentgrid': {
	              		    	  cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	              		    		  var $this = this;
	              		    		  var documentGrid = $this.getCoursesessiondocumentgrid();
	              		    		  var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

	              		    		  if (columnName == "documentName") {
	              		    			  if (e.target.tagName == 'A') {
	              		    				  var documentId = record.get("documentId");
	              		    				  if (!isNullOrEmpty(documentId)) {
	              		    					  $this.getDocumentController().downloadDocumentFile(documentId);
	              		    				  }
	              		    			  }
	              		    		  }
	              		    	  }
	              		      },
	              		    'documentformwindow[itemId=createcourseSessionDiaryformItemId] coursesessiondiarydocumentform[itemId=coursesessiondiarydocumentform] button#courseSessionDocumentCancelButtonId' : {
	                			   click : function() {
	                				   this.getDocumentController()
	                				   .closeDocumentFormWindow();
	                			   }
	                		   },

	                		   'coursesessiondiaryform button[itemId=btnSaveCourseSessionDairy]': {
	                			   click: this.saveCourseSessionDiaryRecord
	                		   },
	                		   'coursesessiondiaryform button#uploadCourseSessionDocumentId' : {
	                			   click : function() {
	                				   this.getDocumentController().showDocumentFormWindow('createcourseSessionDiaryformItemId','COURSE_SESSION_DOCUMENT');
	                			   }
	                		   },
	                		   'coursesessiondocumentgrid button#btnDelete' : {
	                			   click : function() {
	                				   var $this = this;
	                				   var grid = $this
	                				   .getCoursesessiondocumentgrid();
	                				   if (grid.getSelectionModel().getCount() > 0) {
	                					   showConfirmMessage(getProgramandcourseTranslation('COURSE_SESSION_DIARY'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	                							   function(btn,text) {
	                								   if (btn == 'yes') {
	                									   var store = grid.getStore();
	                									   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	               	                 						var record = grid.getSelectionModel().getSelection()[0];
	                									   var id = record.get("id");
	                									   if (!isNullOrEmpty(id)) {
	                										   Ext.Ajax
		                									   .request({
		                										   method : "DELETE",
		                										   type : 'rest',
		                										   url : SERVERURL.COURSE_SESSION_DIARY_DOCUMENT_DELETE
		                										   + '?id='
		                										   + id,
		                										   headers : {
		                											   'Content-Type' : 'application/json'
		                										   },
		                										   success : function(
		                												   form,
		                												   action) {
		                											   Ext.getBody().unmask();
		                											   store.reload();
		                											   showSuccessMessage(
		                													   getProgramandcourseTranslation('COURSE_SESSION_DIARY'),
		                													   getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
		                										   }
		                									   });
	                									   }else{
	                										   if (record) {
	               	                 							store.remove(record);
	               	                 						showSuccessMessage(
	               	                 							getProgramandcourseTranslation('COURSE_SESSION_DIARY'),
             													   getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	               	                 						}
	               	                 						Ext.getBody().unmask();
	                									   }
	                									   
	                								   }
	                							   });
	                				   } else {
	                					   showWarningMessage(
	                							   getProgramandcourseTranslation('COURSE_SESSION_DIARY'),
	                							   getCommonTranslation('PLEASE_SELECT_RECORD')); // Please
	                					   // select
	                					   // a
	                					   // record
	                				   }
	                			   }
	                		   },
	                		   'coursedocumentgrid' : {
	                			   cellclick : function(grid, td,
	                					   cellIndex, record, tr,
	                					   rowIndex, e, eOpts) {
	                				   var $this = this;
	                				   var documentGrid = $this
	                				   .getCoursedocumentgrid();
	                				   var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

	                				   if (columnName == "documentName") {
	                					   if (e.target.tagName == 'A') {
	                						   var documentId = record
	                						   .get("documentId");
	                						   if (!isNullOrEmpty(documentId)) {
	                							   $this
	                							   .getDocumentController()
	                							   .downloadDocumentFile(
	                									   documentId);
	                						   }
	                					   }
	                				   }
	                			   }
	                		   },
		                		 'coursesessiondiaryform grid[itemId=periodGridWin]':{
		                			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		                				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
		                				 if(columnName == "documentName"){
		                					 if(e.target.tagName=='A'){
		                						 this.getDownloadFile(record.get('documentId'));
		                					 }
		                				 }
		                			 }
		                		 },
	                		   
	                		   'coursesessiondiaryform combo[itemId=timeSlot]': {
	                			   select: function(obj, records) {
	                				   var form = this.getCoursesessiondiaryform();
	                				   var sessionNo = form.down("#sessionId");
	                				   sessionNo.setValue(records[0].raw.secondId);
	                				//   sessionNo.setReadOnly(true);
	                			   }
	                		   },
	             			 'coursesessiondiarydocumentgrid button[itemId=downloadDocumentItemId]':{
	             				click:function(obj){
	             					this.downloadAllSessionDocumentFormsZip();
	             				}
	             			},
	             			'coursesessiondiaryfacultyportalfilter': {
	                        	render: function(obj) {					
	                        		var courseSessionDiaryForm =  this.getCoursesessiondiaryfacultyportalfilter();
	                        		var academicTerm = courseSessionDiaryForm.down('#academicTerm');
	                        		var grid = this.getCoursesessiondiaryfacultyportalgrid();
	                        		var alinfomodel = Academia.model.authentication.ALInfoModel;
	                        		var wheatherSchool = alinfomodel.get('wheatherSchool');
	                        		if(wheatherSchool){
	                        			courseSessionDiaryForm.down("#periodItemId").hide();
	                        		}else{
	                        			courseSessionDiaryForm.down("#periodItemId").setVisible(true);
	                        		}
	                        	    var academyLocationIds = this.getCurrentAcademyLocation();
	         		 	    	    var facultyId = this.getCurrentlyLoggedInUser().id;
	                        		var academicTermStore = academicTerm.getStore();
	                        		academicTermStore.load({
	                        			callback: function(record, operation, success) {
	                        				if (success) {
	                        					if(record.length>0){
	                        						Ext.each(record, function(value) {
	                        							if(value.get('whetherCurrentAcademicTerm')){
	                        								courseSessionDiaryForm.down("#academicTerm").setValue(value.get('id'));
	                        								var grdStore = grid.getStore();   
	                        								grdStore.getProxy().extraParams = {
	                      	         		 	    		   academyLocationIds: academyLocationIds,
	                      	         		 	    		   facultyId: facultyId,
	                      	         		 	    		   academicTermId:value.get('id')
	                      	         		 	    	   }
	                        								grdStore.reload();
	                        							}
	                        						});
	                        					}
	                        				}
	                        			}
	                        		});
	                        	}
	                        },
	                        'coursesessiondiaryfacultyportalfilter customcombobox[itemId=academicTerm]' : {
	             			   change: function(obj, records){
	             				   var me = this;
	             					var form = obj.up('form');
	             					var academicTermId = obj.getValue();
	             					if(academicTermId > 0) {
	             						this.onChangeAcademicterm(form, academicTermId);
	             					}
	             			    }
	             			   },
	             			  'coursesessiondiaryfacultyportalfilter customcombobox[itemId=courseVariantId]' : {
	             					change: function(obj, record){
	             						var me = this;
	             						var form = obj.up('form');
	             						var courseVariantId = obj.getValue();
	             						if(courseVariantId > 0) {
	             							var assignSectionType = obj.getStore().findRecord('id', courseVariantId).data.sectionType;
	             							this.courseVariantSelection(form, courseVariantId, assignSectionType);
	             						}
	             					}
	             				},
	             				'coursesessiondiaryfacultyportalfilter customcombobox[itemId=programItemId]' : {
	             					change:function(obj,records) {
	             						var me = this;
	             						var form = obj.up('form');
	             						var programId = obj.getValue();
	             						if(programId > 0) {
	             							this.courseSessionDiaryProgramChange(form, programId);
	             						}
	             					}
	             				},
	             				'coursesessiondiaryfacultyportalfilter customcombobox[itemId=batchItemId]' : {
	             					change:function(obj, record) {
	             						var me = this;
	             						var form = obj.up('form');
	             						var batchId = obj.getValue();
	             						if(batchId > 0) {
	             							this.courseSessionDiaryBatchChange(form, batchId);
	             						}
	             					}
	             				},
	             				'coursesessiondiaryfacultyportalfilter customcombobox[itemId=periodItemId]' : {
	             					change: function(obj, record){
	             						var me = this;
	             						var form = obj.up('form');
	             						var periodId = obj.getValue();
	             						if(periodId > 0) {
	             							this.periodSelection(form, periodId);
	             						}
	             					}
	             				},
	             				'coursesessiondiaryfacultyportalfilter button[itemId=courseSessionDiaryResetBtn]' : {
	             					 click: this.resetCourseSessionDairyFacultyPortal
	             						
	             				},
	             				'coursesessiondiaryfacultyportalfilter button[itemId=courseSessionDiarySearchBtn]': {
		                			   click: this.loadCourseSessionDiaryFacultyPortalGrid
		                		},
		                		'coursesessiondiaryfacultyportalgrid button[itemId=btnDelete]':{
		                			   click: this.deleteCourseSessionDiaryRecord
		                		},
		                		'coursesessiondiaryfacultyportalgrid button[itemId=btnAdd]':{
		                			   click: this.addCourseSessionDiaryRecord
		                		},
		                		'coursesessiondiaryfacultyportalgrid button[itemId=btnView]':{
		                			   click: Ext.bind(this.editCourseSessionDiaryRecord, this, [true])
		                		},
		                		'coursesessiondiaryfacultyportalgrid button[itemId=btnEdit]':{
		                			   click: Ext.bind(this.editCourseSessionDiaryRecord, this, [false])
		                		},
		                		'coursesessiondiaryfacultyportalgrid':{
		                			   render:function(grid){
		                				   this.loadCourseSessionDiaryFacultyPortalGrid();
		                					   this.doAccessControlValidation(grid, this.getCOURSE_SESSION_DIARY_PERMISSIONS());
		                					   this.addDataGridConfigButton(grid, this.getCOURSE_SESSION_DIARY_PERMISSIONS());
		                			   },
		                			   cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
		                				   var columnName=grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
		                				   if(columnName=='description'){
		                					   this.openDocumentLinkWindow(record);
		                				   }
		                				   if(columnName=='document' && record.data.documents.length == 1){
		                					   var documentId = record.data.document.code;
		             						  if (!isNullOrEmpty(documentId)) {
		             							  this.getDownloadFileForCourseSessionDiaryDocument(documentId);
		             						  }
		                				   } else if(columnName=='document' && record.data.documents.length > 1){
		                					   this.linkNoOfCourseSessionDiaryDocuments(grid, RowIdx, record);
		                				   }
		                			   }
		                		   }
	                	   });
	                   },
	                   getDocumentController : function() {
	                	   var this$ = this;
	                	   return this$
	                	   .getController('Academia.controller.document.DocumentController');
	                   },
	                   loadCourseSessionDiaryGrid:function(courseVariantId){
	                	   var $this=this;
	                	   var grid = $this.getCoursesessiondiarygrid();
	                	   var getForm = $this.getCoursesessiondiaryfilter();
	                	   getForm.down('#courseReadingSearchBtn').setDisabled(true);
	                	   var form = getForm.getForm();
	                	   var values = form.getValues();
	                	   var gridStore = grid.getStore();
	                	   var sectionVal = form.findField('sectionId').getValue();
	                	   var courseSectionVal = form.findField('courseSectionId').getValue();
	                	   var facultyId = form.findField('facultyIds').getValue();
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   if(portalId == 2) {
	                		   var faculty = this.getCurrentlyLoggedInUser();
	                		   facultyId = faculty.id;
	                	   }
	                	   var sectionId=null;
	                	   if(!isNullOrEmpty(sectionVal)){
	                		   sectionId = sectionVal;
	                	   }else if(!isNullOrEmpty(courseSectionVal)) {
	                		   sectionId = courseSectionVal;
	                	   }
	                	   if(!isNullOrEmpty(courseVariantId) && !isNullOrEmpty(courseVariantId.xtype)){
	                		   courseVariantId = null;
	                	   }
	                	   gridStore.getProxy().extraParams={
	                		   academyLocationId:this.getCurrentAcademyLocation(),
	                		   facultyId:facultyId,
	                		   batchId:values.BATCH,
	                		   programId:values.PROGRAM,
	                		   periodId:values.PERIOD,
	                		   courseId:values.courseId,
	                		   componentId:values.componentId,
	                		   sectionId:sectionId,
	                		   startDate:values.startDate,
	                		   endDate:values.endDate,
	                		   courseVariantId: courseVariantId,
	                		   intakeYearId : values.intakeYearId
	                	   },
	                	   this.resetPageSetting(gridStore);
	                	   gridStore.load({
        					   callback: function(record, operation, success) {
        						   if (success) {
        							   getForm.down('#courseReadingSearchBtn').setDisabled(false);  
        						   }
        					   }
        				   });
	                	   grid.config.searchFilterForm = $this.getCoursesessiondiaryfilter();
	                   }, 
	                   resetCourseSessionDiaryFilter:function(){
	                	   var $this=this;
	                	   var form = $this.getCoursesessiondiaryfilter();
	                	   form.getForm().reset();
	                	   form.down("#batchId").setDisabled(true);
	                	   form.down("#periodId").setDisabled(true);
	                	   form.down("#sectionId").setDisabled(true);
	                	   form.down("#CourseSection_ID").setDisabled(true);
	                	   var startDate =form.down("#startDate");
	                	   var endDate  =form.down("#endDate");
	                	   
	                	    startDate.setMinValue(null);
	                	    startDate.setMaxValue(new Date());
	                	    endDate.setMinValue(null);
	                	    endDate.setMaxValue(new Date());
	                	    var componentId=form.down("#componentId");
	                	   componentId.reset();
	                	   componentId.setVisible(false);
	                	   var program = form.down("#programId");
	                	   var facultyId = null;
	                	   if ($this.getCurrentLoggedPortalId() == 2) {
	                		   facultyId = $this.getCurrentlyLoggedInUser().id;
	                	   }
	                	   program.getStore().getProxy().extraParams = {
	                		   facultyId: facultyId,
	                		   academyLocationIds: $this.getCurrentAcademyLocation()
	                	   };
	                	   program.getStore().load();
	                	   
	                   },
	                   deleteCourseSessionDiaryRecord:function(){
	                	   var $this=this;
	                	   var grid = null;
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   if(portalId == 2) {
	                		   grid = $this.getCoursesessiondiaryfacultyportalgrid();  
	                	   }else{
	                		   grid = $this.getCoursesessiondiarygrid();
	                	   }
	                	   
	                	   if (grid.getSelectionModel().getCount() > 0) {
	                		   showConfirmMessage(
	                				   getProgramandcourseTranslation('COURSE_SESSION_DIARY'),
	                				   getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	                				   function(btn, text) {
	                					   if (btn == 'yes') {
	                						   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                						   var records = grid.getSelectionModel().getSelection();
	                						   var id = records[0].get("id");
	                						   Ext.Ajax.request({
	                							   method : "DELETE",
	                							   type : 'rest',
	                							   url : SERVERURL.COURSE_SESSION_DIARY_DELETE+'?id='+ id,
	                							   headers : {
	                								   'Content-Type' : 'application/json'
	                							   },
	                							   success : function(form,action) {
	                								   Ext.getBody().unmask();
	                								   grid.getStore().reload();
	                								   showSuccessMessage(getProgramandcourseTranslation('COURSE_SESSION_DIARY'),getProgramandcourseTranslation('COURSE_SESSION_DIARY_DELETED_SUCCESSFULLY'));
	                							   }

	                						   });
	                					   }
	                				   });
	                	   }else {
	                		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
	                	   }
	                   },
	                   addCourseSessionDiaryRecord:function(){
	                	   var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	                	   var structure = Ext.widget('coursesessiondiaryform');
	                	   var tabName = getCommonTranslation('COURSE_SESSION_DIARY_DETAILS');
	                	   /**
	                	    * This is to remove tab from content panel and open same tab again
	                	    */
	                	   
	                	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	                	   var getTab=getcontroller.getTab(tabName);
	                	   if(getTab!=null){
	                		   contentPanel.remove(getTab, true);
	                	   }
	                	   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
	                	   var documentStore=this.getStore('coursesessiondiary.CourseSessionDiaryDocument');
	                       documentStore.removeAll();
	                   },
	                   viewCourseSessionDiaryRecord:function(){

	                   },
	                   saveCourseSessionDiaryRecord: function(model, records){
	                	   // Create required json to Save
	                	   var this$ = this;
	                	   var form = this.getCoursesessiondiaryform().getForm();
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   var grid = null;
	                	   if(portalId == 2) {
	                		   grid = this.getCoursesessiondiaryfacultyportalgrid(); 
	                	   }else{
	                		   grid = this.getCoursesessiondiarygrid();   
	                	   }
	                	   
	                	   var grdStore = grid.getStore();
	                	   var submitUrl;
	                	   if (form.findField('id').getSubmitValue() == null || form.findField('id').getSubmitValue() == "") {
	                		   submitUrl = SERVERURL.COURSE_SESSION_DIARY_SAVE_UPDATE;  // API call to save CourseSessionDiary
	                		   var jsonFormatFormData = this.createCourseSessionDairyJson(form, records);
		                	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		                	   Ext.Ajax.request({
		                		   type : 'rest',
		                		   url : submitUrl,
		                		   jsonData : jsonFormatFormData,
		                		   method : 'POST',
		                		   success : function(frm, action) {
		                			   if(frm.responseText==="" ){
		                				   this$.hideWindowMask();
		 									showWarningMessage(getCommonTranslation('COURSE_SESSION_DIARY_DETAILS'), getCommonTranslation('COURSE_SESSION_DIARY_TIME_SLOT_EXIST'));
		 								   this$.getStore('course.CourseDocument').removeAll();
	 		                			   Ext.getBody().unmask();
		                			   }else{
		 									  if (grid.getSelectionModel().getCount() > 0){
		 		                				   grid.getSelectionModel().deselectAll();
		 		                			   }
		 		                			   this$.resetPageSetting(grdStore);
		 		                			   grdStore.reload();
		 		                			   showSuccessMessage(getCommonTranslation('COURSE_SESSION_DIARY_DETAILS'),getCommonTranslation('SUCCESS'));
		 		                			   this$.getStore('course.CourseDocument').removeAll();
		 		                			   Ext.getBody().unmask();
		 		                			  this$.closeCourseSessionDairyDetailTab();
		 								}
		                		   }
		                	   
		                	   });
	                	   } else {
	                		   submitUrl = SERVERURL.UPDATE_COURSE_SESSION_DIARY_SAVE_UPDATE; //URL-rest/academyLocation/update
	                		   var jsonFormatFormData = this.createCourseSessionDairyJson(form, records);
		                	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		                	   Ext.Ajax.request({
		                		   type : 'rest',
		                		   url : submitUrl,
		                		   jsonData : jsonFormatFormData,
		                		   method : 'POST',
		                		   success : function(frm, action) {
		                			   if (grid.getSelectionModel().getCount() > 0){
		                				   grid.getSelectionModel().deselectAll();
		                			   }
		                			   this$.resetPageSetting(grdStore);
		                			   grdStore.reload();
		                			   showSuccessMessage(getCommonTranslation('COURSE_SESSION_DIARY_DETAILS'),getCommonTranslation('SUCCESS'));
		                			   this$.getStore('course.CourseDocument').removeAll();
		                			   Ext.getBody().unmask();
		                		   }
		                	   });
		                	   this.closeCourseSessionDairyDetailTab();
	                	   }
	                   },
	                   createCourseSessionDairyJson: function(form,record){
	                	   // Create required json to Save

	                	   var values = new Object();
	                	   var searchcriteria = new Array();
	                	   var value=form.getValues();
	                	   var facultyId = null;
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   if(portalId == 2) {
	                		   var faculty = this.getCurrentlyLoggedInUser();
	                		   values.facultyId = faculty.id;
	                	   }
	                	   else{
	                		   values.facultyId = value.facultyId;
	                	   }

	                	   if(value.id != "" && value.id != null){
	                		   values.id=value.id;
	                	   }else{
	                		   values.id = ""
	                	   }
	                	   if(value.courseId != "" && value.courseId != null){
	                		   values.courseId = value.courseId;
	                	   }
	                	   if(value.componentId != "" && value.componentId != null){
	                		   values.componentId = value.componentId;
	                	   }
	                	   if(value.courseVariantId != "" && value.courseVariantId != null){
	                		   values.courseVariantId = value.courseVariantId;
	                	   }
	                	   if(value.session != "" && value.session != null){
	                		   values.sessionNumber = value.session;
	                	   }
	                	   if(value.topic != "" && value.topic != null){
	                		   values.topics = value.topic;
	                	   }
	                	   if(value.sessionDate != "" && value.sessionDate != null){
	                		   values.sessionDate = value.sessionDate;
	                	   }
	                	   if(value.fromTime != "" && value.fromTime != null){
	                		   values.fromTime = value.fromTime;
	                	   }
	                	   if(value.toTime != "" && value.toTime != null){
	                		   values.toTime = value.toTime;
	                	   }
	                	   values.publishToStudent = false;
	                	   values.publishToParent = false;
	                	   if(form.findField('publishToStudent').checked) {
	                		   values.publishToStudent = true;
	                	   }
	                	   if(form.findField('publishToParent').checked) {
	                		   values.publishToParent = true;
	                	   }
	                	   var customDataArray = [];
	                	   if(!isNullOrEmpty(value.customData)) {
	                		   values.customData = value.customData;
	                	   }
	                	   var timeSlot = form.findField("timeSlot");
	                	   var slot = timeSlot.getRawValue();
	                	   if(!isNullOrEmpty(slot)) {
	                		   /*var tokens = slot.split(' - ');
	                		   values.fromTime =tokens[0];
	                		   values.toTime = tokens[1];*/ 
//	                		   values.sessionNumber = tokens[1];
	                		   values.calendarSlot = {
	                				   id:timeSlot.getValue()
//	                				   value:timeSlot.get
	                		   }
	                	   }
	                	   if(value.description != "" && value.description != null){
	                		   values.description = value.description;
	                	   }
	                	   var $this = this;
	                	   var docStore = $this.getStore('coursesessiondiary.CourseSessionDiaryDocument');
	                	   var docArray = [];
	                	   if (docStore.data.items != null
	                			   && docStore.data.items.length > 0) {
	                		   Ext.each(docStore.data.items, function(val) {
	                			   var type=null;
	                			   if(isNullOrEmpty(val.data.id) && isNullOrEmpty(val.data.documentId)){
	                			   if(isNullOrEmpty(val.data.type)){
	                				   type="DOCUMENT";
	                			   }else{
	                				   type=val.data.type;
	                			   }
	                			   var newData = {
	                					   "name" : val.data.documentName,
	                					   "path" : val.data.path,
	                					   "type" : type,
	                					   "createdBy" : $this.getIdValueJson(
	                							   val.data.createdBy.id,
	                							   val.data.createdBy.value),
	                					   "submissionDate" : Ext.Date.format(new Date(), CONSTANTS.NEW_SUBMIT_DATE_FORMAT)            			  
	                					   };
	                			   docArray.push(newData);
	                			   }
	                		   });
	                	   }
	                	   values.documents=docArray;
	                	   values.document=  docArray[docArray.length-1];
//	                	   values.customData = customDataArray;
	                	   var formData = Ext.encode(values);
	                	   return formData;
	                   },

	                   closeCourseSessionDairyDetailTab:function(){
	                	   var tabName = getCommonTranslation('COURSE_SESSION_DIARY_DETAILS');
	                	   var contentpanel = this.getContentPanel();
	                	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	                	   var getTab=getcontroller.getTab(tabName);
	                	   if(getTab!=null){
	                		   contentpanel.remove(getTab, true);
	                	   }
	                   },

	                   editCourseSessionDiaryRecord : function(isView){
	                	   var this$ = this;
	                	   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	   var wheatherSchool = alinfomodel.get('wheatherSchool');
//	                	   this$.addCourseSessionDiaryRecord();
//	                	   var form = this.getCoursesessiondiaryform().getForm();
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   var grid = null;
	                	   if(portalId == 2) {
	                		   var grid = this.getCoursesessiondiaryfacultyportalgrid();  
	                	   }else{
	                		   var grid = this.getCoursesessiondiarygrid(); 
	                	   }
	                	  
	                	   if (grid.getSelectionModel().getCount() > 0) {
	                		   this$.addCourseSessionDiaryRecord();
	                		   var form = this.getCoursesessiondiaryform().getForm();
	                		   var records = grid.getSelectionModel().getSelection()[0];
	                		   if (records != "" && records != null && records != undefined) {
	                			   var courseSessionDiary = new Academia.model.coursesessiondiary.CourseSessionDiaryModel(records.data);
	                			   form.loadRecord(courseSessionDiary);
	                			   var facultyId = null;
	                			   var portalId = this.getCurrentLoggedPortalId();
	                			   var facultyCombo = form.findField('facultyId');
	                			   if(portalId == 2) {
	                				   facultyId = this.getCurrentlyLoggedInUser().id;
	                				   facultyCombo.allowBlank=true;
	                				   facultyCombo.setVisible(false);
	                				   //facultyCombo.isValid(true);
	                			   }else{
	                				   facultyCombo.allowBlank=false;
	                				   facultyCombo.setVisible(true);
	                				   var facultyIdstore = facultyCombo.getStore();
	                				   facultyIdstore.getProxy().extraParams = {
	                					   courseVariantId: records.data.courseVariantId,
	                					   componentId:records.data.componentId,
	                					   courseId:records.data.courseId
	                				   };
	                				   facultyIdstore.load({
	                					   callback: function(record, operation, success) {
	                						   if (success) {
	                							   facultyCombo.setValue(records.data.facultyId);
	                						   }
	                					   }
	                				   });
//	                				   faculty.isValid(true);
	                			   }
	                			   form.findField('id').setValue(records.data.id);
	                			   form.findField('courseId').setValue(records.data.courseId);
	                			   form.findField('componentId').setValue(records.data.componentId);
	                			   var variantCombo = form.findField('courseVariantId');
	                			   var calendarId;
	                			   variantCombo.setDisabled(false);
	                			   var sectionAtComponentLevel=false;
	                			   if(records.data.componentId != null){
	                				   var componentCombo=form.findField('componentId');
	                				   componentCombo.setVisible(true);
	                				   var componentStore = componentCombo.getStore();
	                				   componentStore.getProxy().extraParams = {
	                					   courseId:records.data.courseId
	                				   }
	                				   componentStore.load({
	                					   callback: function(record, operation, success) {
	                						   if (success) {
	                							   componentCombo.setValue(records.data.componentId);
	                						   }
	                					   }
	                				   });
	                				   sectionAtComponentLevel=true;
	                			   }else{
	                				   var componentCombo=form.findField('componentId');
	                				   componentCombo.allowBlank = true;
	                			   }
	                			  var documentStore=this.getStore('coursesessiondiary.CourseSessionDiaryDocument');
	                			   documentStore.removeAll();
	                			   documentStore.getProxy().extraParams = {
	                				   ID:records.data.id
                				   }
	                			   documentStore.load();
	                			   var store = variantCombo.getStore();
	                			   store.getProxy().extraParams = {
	                				   courseId: records.data.courseId,
	                				   sectionAtComponentLevel:sectionAtComponentLevel,
	                				   facultyId:facultyId,
	                				   componentId:records.data.componentId,
	                				   whetherSchool:wheatherSchool,
	                				   page:null
	                			   };
	                			   store.load({
	                				   callback: function(record, operation, success) {
	                					   if (success) {
	                						   for(i in record) {
	                							   if(record[i].data.id === records.data.courseVariantId) {
	                								   variantCombo.setValue(records.data.courseVariantId);
	                								   this$.getCoursesessiondiaryform().down('#courseSessionToDateId').setMaxValue(dateFormatRender(new Date(record[i].data.periodEndDate)));
	                								    this$.getCoursesessiondiaryform().down('#courseSessionDateId').setMinValue(dateFormatRender(new Date(record[i].data.periodStartDate)));
	                								   try{
	                									   calendarId=record[i].data.calendar.id;
	                								   }
	                								   catch(e){
	                									   calendarId = null;
	                								   }
//	                								   if(!isNullOrEmpty(records.data.calendarSlot)) {
	                								   var timeSlot = form.findField("timeSlot");
	                								   
	                								   var displayFormatMap = Academia.utilities.DisplayFormatMap;
	                								    var orgModel = Academia.model.common.OrgSettingDateTimeModel;
	                								    var currentDateFormat = orgModel.get('dateFormat');
	                									var format = displayFormatMap.getDisplayFormat(currentDateFormat);
	                								   
	                								   var weekDay = this$.getWeekDayFromDate(Ext.Date.format(new Date(records.data.date), format));
	                								   var timeSlotStore = timeSlot.getStore();
//	                								   var calendarId=courseVariantId.store.data.items[0].raw.calendar.id;
	                								   timeSlotStore.getProxy().extraParams = {
	                									   variantId : records.data.courseVariantId,
	                									   facultyId : records.data.facultyId,
	                									   weekDay : weekDay,
	                									   calendarId : calendarId
	                								   };
	                								   setTimeout(function(){
	                									   timeSlotStore.load({
	                										   callback: function(record, operation, success) {
	                											   if (success) {
	                												   for(i in record) {
	                													   if(record[i].data.id === records.data.calendarSlot) {
	                														   timeSlot.setValue(record[i].data.id);
	                													   }
	                												   }
	                												   timeSlot.setDisabled(false);
	                											   }
	                										   }
	                									   });
	                								   },300);
//	                								   }
	                							   }
	                						   }
	                					   }
	                				   }
	                			   });
	                			   this.getCoursesessiondiaryform().down('#coursesessiondocumentgrid').setVisible(true);
	                			   form.findField('session').setValue(records.data.sessionNumber);
	                			   form.findField('session').setReadOnly(true);
	                			   form.findField('topic').setValue(records.data.topic);
	                			   form.findField('description').setValue(records.data.description);
	                			   form.findField('sessionDate').setValue(dateRender(records.data.date));
	                			   form.findField('publishToStudent').setValue(records.data.publishToStudent);
	                			   form.findField('publishToParent').setValue(records.data.publishToParent);
	                			   form.findField('fromTime').setValue(dateRender(records.data.fromDate));
	                			   form.findField('fromTime').setMinValue(dateRender(records.data.fromDate));
	                			   form.findField('toTime').setValue(dateRender(records.data.toDate));
	                			   form.isValid();
	                		   }
	                		   if (isView) {
	                			   this.getCoursesessiondiaryform().down('coursesessiondocumentgrid').down('#btnDelete').setVisible(false);
	                		       this.getCoursesessiondiaryform().down('#btnSaveCourseSessionDairy').setVisible(false);
	                			   this.getCoursesessiondiaryform().down('#uploadCourseSessionDocumentId').setVisible(false);
	                			   toggleReadOnlyFormItems(form, true);
	                		   }
	                	   } else {
	                		   showWarningMessage(getCommonTranslation('COURSE_SESSION_DAIRY'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
	                	   }
	                   },
	                   loadSessionDiaryTimeSlotCombo : function(form) {
	                	   var me = this;
	                	   var timeSlot = form.down("#timeSlot");
	                	   var courseVariantId = form.down("#courseVariantId");
	                	   timeSlot.clearValue();
	                	   timeSlot.setDisabled(false);
	                	   setTimeout(function(){
		                	   var values = form.getValues();
		                	   var facultyId = values.facultyId;
		                	   if(portalId == 2) {
		                		   facultyId = me.getCurrentlyLoggedInUser().id;
		                	   }
	                		   if(!isNullOrEmpty(values.courseVariantId)) {
		                		   var weekDay = me.getWeekDayFromDate(form.down("#courseSessionDateId").getValue());
		                		   var timeSlotStore = timeSlot.getStore();
		                		   var calendarId=0;
		                		   /*if(!isNullOrEmpty(courseVariantId.store.data.items[0])){
		                			   calendarId=courseVariantId.store.data.items[0].raw.calendar.id;
		                		   }*/
		                		   if(!isNullOrEmpty(courseVariantId.getValue()) && !isNullOrEmpty(courseVariantId.getStore().findRecord('id',courseVariantId.getValue()))){
		                			   var selectedRecord = courseVariantId.getStore().findRecord('id',courseVariantId.getValue());
		                			   if(!isNullOrEmpty(selectedRecord.data.calendar) && !isNullOrEmpty(selectedRecord.data.calendar.id)){
		                				   calendarId = selectedRecord.data.calendar.id;
		                			   }
		                			   else{
		                				   calendarId = null;
		                			   }
		                		   }
		                		  
		                		   timeSlotStore.getProxy().extraParams = {
		                			   variantId : values.courseVariantId,
		                			   facultyId : facultyId,
		                			   weekDay : weekDay,
		                			   calendarId : calendarId
		                		   };
		                		   timeSlotStore.load();
		                	   }
	                	   },300);
	                   },
	                   getIdValueJson : function(id, value) {
	                	   if (id)
	                		   return {
	                		   id : id,
	                		   value : value
	                	   };
	                   },
	                   getDownloadFileForCourseSessionDiaryDocument : function(documentId){

	       		    	if(!isNullOrEmpty(documentId)){
	       		    		var csvForm = Ext.create('Ext.form.Panel'); 
	       		    		csvForm.getForm().submit({
	       		    			target: '_blank',
	       		    			method:'GET',
	       		    			params :{
	       		    				access_token : Ext.Ajax.defaultHeaders.access_token
	       		    			},
	       		    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	       		    			url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
	       		    			standardSubmit :true
	       		    		});
	       		    	}
	       		    },
	       		    linkNoOfCourseSessionDiaryDocuments: function(view, rowIndex, record) {

	       		    	var docWindow = this.getCoursesessiondiarydocumentlist();
	       		    	var ID = record.data.id;
	       		    	if (!docWindow) {
	       		    		Ext.widget('coursesessiondiarydocumentlist');
	       		    		docWindow = this.getCoursesessiondiarydocumentlist();
	       		    	}
	       		    	var String=record.data.courseVariant;
	       		    	var res = String.split("/").join("/\n");
	       		    	docWindow.show();
	       		    	docWindow.down('form').down('#sessionDate').setValue(dateRender(record.data.date));
	       		    	docWindow.down('form').down('#courseVariantName').setValue(res);
	       		    	docWindow.down('form').down('#topicName').setValue(record.data.topic);
	       		    	var grid = this.getCoursesessiondiarydocumentgrid();
	       		    	var store = grid.getStore();
	       		    	store.getProxy().extraParams = {
	       		    		ID: ID
	       		    	};
	       		    	store.load();
	       		    },
	       		    downloadAllSessionDocumentFormsZip:function(){
	       		    	var $this=this;
	       		    	var grid=$this.getCoursesessiondiarydocumentgrid();
	       		    	var records = grid.getStore().data.items;
	       		    	var saveModel=[];  
	       		    	var dispatchZipName = "Course Session Dairy Documnet";
	       		    	for(var i in records){
	       		    		if(!isNullOrEmpty(records[i].get('path'))) {
	       		    			saveModel.push(records[i].get('path'));
	       		    		}
	       		    	}
	       		    	showConfirmMessage(getProgramandcourseTranslation('COURSE_SESSION_DIARY_DOCUMENTS'),getProgramandcourseTranslation('COURSE_SESSION_DIARY_DOCUMENTS_ALERT'),function(btn, text) {
	       		    		if (btn == 'yes') {
	       		    			var directoryType = CONSTANTS.DIRECTORY_TYPE_BASEDIR;
	       		    			$this.getDocumentController().downloadMultipleDocumentFileForCourseSessionDiary(saveModel, dispatchZipName, directoryType);
	       		    		}});

	       		    },
	       		   onChangeAcademicterm : function(form, academicTermId){
		 	    	   var this$=this;
		 	    	   var courseVarientField = form.down("#courseVariantId");
		 	    	   var programField = form.down("#programItemId");
		 	    	   var batchField = form.down("#batchItemId");
		 	    	   var periodField = form.down("#periodItemId");
		 	    	   var sectionField = form.down("#sectionItemId");

		 	    	   courseVarientField.reset();
		 	    	   programField.reset();
		 	    	   batchField.reset();
		 	    	   periodField.reset();
		 	    	   sectionField.reset();

		 	    	   courseVarientField.setDisabled(false);
		 	    	   programField.setDisabled(false);
		 	    	   batchField.setDisabled(true);
		 	    	   periodField.setDisabled(true);
		 	    	   sectionField.setDisabled(true);

		 	    	   var academyLocationIds = this.getCurrentAcademyLocation();
		 	    	   var facultyId = this.getCurrentlyLoggedInUser().id; 
		 	    	   
		 	    	   var courseVarientStore = courseVarientField.getStore();
		 	    	  courseVarientStore.getProxy().extraParams = {
		 	    		   academyLocationIds: academyLocationIds,
		 	    		   facultyId: facultyId,
		 	    		   isCurrentPeriod:false,
		 	    		   academicTermId:academicTermId
		 	    	   };
		 	    	  courseVarientStore.load();
		 	    	   var programStore = programField.getStore();
		 	    	   programStore.getProxy().extraParams = {
		 	    		   academyLocationIds:academyLocationIds,
		 	    		   academicTermId:academicTermId,
		 	    		   facultyId: facultyId,
		 	    		   isAllProgram:true
		 	    	   }
		 	    	   programStore.load();
		 	    	   
		 	       },
		 	      courseVariantSelection : function(form, courseVariantId, assignSectionType) {
		 	    	   var $this = this;
		 	    	   var academicTermField = form.down('#academicTerm');
		 	    	   var courseVariantField = form.down("#courseVariantId");
		 	    	   var programField = form.down("#programItemId");
		 	    	   var batchField = form.down("#batchItemId");
		 	    	   var periodField = form.down("#periodItemId");
		 	    	   var sectionField = form.down("#sectionItemId");

		 	    	   programField.reset();
		 	    	   batchField.reset();
		 	    	   periodField.reset();
		 	    	   sectionField.reset();

		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var academyLocationIds = this.getCurrentAcademyLocation();
		 	    	   var facultyId = this.getCurrentlyLoggedInUser().id; 

		 	    	   if(assignSectionType == 'CourseSection') {
		 	    		   programField.setDisabled(true);
		 	    		   batchField.setDisabled(true);
		 	    		   periodField.setDisabled(true);
		 	    		   sectionField.setDisabled(true);

		 	    	   } else {
		 	    		   programField.setDisabled(false);
		 	    		   batchField.setDisabled(true);
		 	    		   periodField.setDisabled(true);
		 	    		   sectionField.setDisabled(true);
		 	    		   var programStore = programField.getStore();
		 	    		   programStore.getProxy().extraParams = {
		 	    			   academyLocationIds:academyLocationIds,
		 	    			   academicTermId:academicTermId,
		 	    			   facultyId: facultyId,
		 	    			   isAllProgram:true,
		 	    			   courseVariantId:courseVariantId
		 	    		   }
		 	    		   programStore.load({
		 	    			   callback: function(records, operation, success) {
		 	    				   if (success) {
		 	    					   if(records.length == 1){
		 	    						   programField.setValue(records[0].data.id);
		 	    					   } 
		 	    				   }
		 	    			   }
		 	    		   });
		 	    	   }
		 	       },
		 	      courseSessionDiaryProgramChange : function(form, programId){
		 	    	   var $this=this;
		 	    	   var academicTermField = form.down('#academicTerm');
		 	    	   var courseVariantField = form.down("#courseVariantId");
		 	    	   var programField = form.down("#programItemId");
		 	    	   var batchField = form.down("#batchItemId");
		 	    	   var periodField = form.down("#periodItemId");
		 	    	   var sectionField = form.down("#sectionItemId");

		 	    	   batchField.reset();
		 	    	   periodField.reset();
		 	    	   sectionField.reset();

		 	    	   batchField.setDisabled(false);
		 	    	   periodField.setDisabled(true);
		 	    	   sectionField.setDisabled(true);
		 	    	   
		 	    	   var academyLocationIds = this.getCurrentAcademyLocation();
		 	    	   var facultyId = this.getCurrentlyLoggedInUser().id;
		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var courseVariantId = courseVariantField.getValue();
		 	    	   var batchStore = batchField.getStore();
		 	    	   batchStore.getProxy().extraParams = {
		 	    		   academicTermId:academicTermId,
		 	    		   facultyId: facultyId,
		 	    		   isAllProgram:true,
		 	    		   courseVariantId:courseVariantId,
		 	    		   programId:programId
		 	    	   }
		 	    	   batchStore.load({
		 	    		   callback: function(records, operation, success) {
		 	    			   if (success) {
		 	    				   if(records.length == 1){
		 	    					   batchField.setValue(records[0].data.id);
		 	    			   }
		 	    		     }
		 	    		   }
		 	    	   });
		 	       },
		 	       courseSessionDiaryBatchChange : function(form, batchId){
		 	    	   var $this=this;
		 	    	   var alinfomodel = Academia.model.authentication.ALInfoModel;
		 	    	   var wheatherSchool = alinfomodel.get('wheatherSchool');
		 	    	   var academicTermField = form.down('#academicTerm');
		 	    	   var courseVariantField = form.down("#courseVariantId");
		 	    	   var programField = form.down("#programItemId");
		 	    	   var batchField = form.down("#batchItemId");
		 	    	   var periodField = form.down("#periodItemId");
		 	    	   var sectionField = form.down("#sectionItemId");
		 	    	   periodField.reset();
		 	    	   sectionField.reset();

		 	    	   periodField.setDisabled(false);
		 	    	   sectionField.setDisabled(true);

		 	    	   var academyLocationIds = this.getCurrentAcademyLocation();
		 	    	   var facultyId = this.getCurrentlyLoggedInUser().id;
		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var courseVariantId = courseVariantField.getValue();
		 	    	   var periodStore = periodField.getStore();
		 	    	   periodStore.getProxy().extraParams = {
		 	    		   academicTermId:academicTermId,
		 	    		   facultyId: facultyId,
		 	    		   isAllProgram:true,
		 	    		   batchId:batchId
		 	    	   }
		 	    	   periodStore.load({
		 	    		   callback: function(records, operation, success) {
		 	    			   if (success) {
		 	    				   if(records.length == 0){
		 	    					   if(wheatherSchool) {
		 	    						   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
		 	    					   }
		 	    				   } else if(records.length == 1){
		 	    					   periodField.setValue(records[0].data.id);
		 	    					   if(wheatherSchool) {
		 	    						   periodField.setVisible(false);
		 	    					   }
		 	    				   } else {
		 	    					   periodField.setVisible(true);
		 	    					   }
		 	    			       }
		 	    		   }
		 	    	   });
		 	       },
		 	       periodSelection : function(form, periodId) {
		 	    	   var $this = this;
		 	    	   var academicTermField = form.down('#academicTerm');
		 	    	   var courseVariantField = form.down("#courseVariantId");
		 	    	   var programField = form.down("#programItemId");
		 	    	   var batchField = form.down("#batchItemId");
		 	    	   var periodField = form.down("#periodItemId");
		 	    	   var sectionField = form.down("#sectionItemId");

		 	    	   sectionField.reset();

		 	    	   sectionField.setDisabled(false);
		 	    	   var academyLocationIds = this.getCurrentAcademyLocation();
		 	    	   var facultyId = this.getCurrentlyLoggedInUser().id;
		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var courseVariantId = courseVariantField.getValue();
		 	    	   var sectionStore = sectionField.getStore();
		 	    	   sectionStore.getProxy().extraParams = {
		 	    		   academicTermId:academicTermId,
		 	    		   facultyId: facultyId,
		 	    		   isAllProgram:true,
		 	    		   periodId:periodId,
		 	    		   courseVariantId:courseVariantId
		 	    	   }
		 	    	   sectionStore.load({
		 	    		   callback: function(records, operation, success) {
		 	    			   if (success) {
		 	    				   if(records.length == 1 && !isNullOrEmpty(courseVariantId)) {
		 	    					   sectionField.setValue(records[0].data.id)
		 	    				   }
		 	    			   }
		 	    		   }
		 	    	   });
		 	       },
		 	      loadCourseSessionDiaryFacultyPortalGrid:function(){
               	   var $this=this;
               	   var grid = $this.getCoursesessiondiaryfacultyportalgrid();
               	   var form = $this.getCoursesessiondiaryfacultyportalfilter().getForm();
               	   var values = form.getValues();
               	   var gridStore = grid.getStore();
               	   var sectionVal = form.findField('sectionId').getValue();
               	   var facultyId = this.getCurrentlyLoggedInUser().id;
               	   
               	   gridStore.getProxy().extraParams={
               		   academyLocationId:this.getCurrentAcademyLocation(),
               		   facultyId:facultyId,
               		   batchId:values.batchId,
               		   programId:values.programId,
               		   periodId:values.periodId,
               		   sectionId:values.sectionId,
               		   startDate:values.startDate,
               		   endDate:values.endDate,
               		   courseVariantId:values.COURSE_VARIENT_ID,
               		   academicTermId:values.academicTerm
               	   },
               	   gridStore.load();
                  },
                  resetCourseSessionDairyFacultyPortal:function(){
                	  var form = this.getCoursesessiondiaryfacultyportalfilter();
						var academicTermField = form.down("#academicTerm");
						var courseVarientField = form.down("#courseVariantId");
						var programField = form.down("#programItemId");
						var batchField = form.down("#batchItemId");
						var periodField = form.down("#periodItemId");
						var sectionField = form.down("#sectionItemId");

						academicTermField.clearValue();
						courseVarientField.clearValue();
						programField.clearValue();
						batchField.clearValue();
						periodField.clearValue();
						sectionField.clearValue();
						form.getForm().reset();
						
						courseVarientField.setDisabled(true);
						programField.setDisabled(false);
						batchField.setDisabled(true);
						periodField.setDisabled(true);
						sectionField.setDisabled(true);
						
						var academicTermStore = academicTermField.getStore();
	            		academicTermStore.load({
	            			callback: function(record, operation, success) {
	            				if (success) {
	            					if(record.length>0){
	            						Ext.each(record, function(value) {
	            							if(value.get('whetherCurrentAcademicTerm')){
	            								form.down("#academicTerm").setValue(value.get('id'));
	            							}
	            						});
	            					}
	            				}
	            			}
	            		});
                  },
                  openDocumentLinkWindow: function(record){
                	  var formWindow = this.getCoursesessiondocumentlinkwin();
        	    	  if (!formWindow) {
        	    		  formWindow =  Ext.widget('coursesessiondocumentlinkwin');
        	    		  //formWindow = this.getAssignedtopicdetailwindow();
        	    	  }
        	    	  formWindow.show();
        	    	  var grid = formWindow.down('#courseSessionDocumentlinkGrid');
        	    	  grid.getStore().removeAll();
        	    	  grid.getStore().add(record.data)
                	  
                  }
});
