/*
 *  @author Mahendr.Vishvkarma
 * 
 */
var tempArrayProgressionData=[];
var isSubmittedForm=false;
Ext.define('Academia.controller.coursetransaction.promotionpanel.PromotionPanelController', {
	extend : 'Academia.controller.base.BaseController',
	models : ['coursetransaction.promotion.PromotionPanelList'],

	stores : ['common.ProgramByAcademyLocationStore','enquiry.AcademicBatchStore',
		'program.programDetails.programBatches.courseParameter.PeriodsByProgramAndAcademicTerm','attendance.SectionAndFacultyByPeriodID',
		'coursetransaction.promotion.PromotionType','coursetransaction.promotion.PromotionStatus','coursetransaction.promotion.PromotionPanelList',
		'coursetransaction.promotion.PromotionRetainStatus','scholarships.LogedInUserAcademyLocationStore','attendance.attendancereport.AcadmyByAdmission',
		'personinfo.common.personalinfo.AttendanceReportProgramGroupStore','common.AcademicTermStoreForIntakeYearId',
		'student.studentJourney.ProgressionStatusStoreForGrid','messaging.StudentsFilterByAcademyLocationIdStore',
		'coursetransaction.promotion.PromotionPanelPeriodList',
		'coursetransaction.promotion.PromotionPanelCurrentPeriodList','committee.committee.CommitteeProgressionPanelStore',
		'coursetransaction.promotion.PromotionPanelDocumentList','personinfo.common.personalinfo.PromotionPanelEnrollmentStatus','coursetransaction.promotion.EnrollmentStatusStore',
		'coursetransaction.promotion.ProgressionStatusStore','personinfo.common.personalinfo.StudentJourneyCoreERPPeriodStatusStore','committee.committee.AddCommitteeStore',
		'personinfo.common.pasthistory.LearningAllowanceStore','student.managehold.ProgressionPanelStudentHoldGridStore',
		'program.programDetails.programBatches.programPeriod.ProgressionStatusPeriodStore',
		'student.studentprofile.AcademicTopicUrlsStore',
		'student.studentprofile.AcademicTopicDocumentsStore',
		'Academia.store.coursetransaction.promotion.PreviousProgressionLetters'],


		views : [
			'coursetransaction.promotion.PromotionPanelStructure','coursetransaction.promotion.PromotionPanelSearch',
			'coursetransaction.promotion.PromotionPanelList',
			'coursetransaction.promotion.PromotionPanelViewDetailsWindow',
			'coursetransaction.promotion.PromotionAddCommiteeWindow',
			'student.studentprofile.AcademicTopicDocumentsPopup',
			'student.studentprofile.AcademicTopicDocumentsGrid',
			'student.studentprofile.AcademicTopicUrlPopup',
			'student.studentprofile.AcademicTopicUrlGrid',
			'coursetransaction.promotion.DocumentNotesViewAllWindow',
			'coursetransaction.promotion.ProgressionPanelMessageContentWindow',
			'document.DocumentPreviewWindow',
			'coursetransaction.promotion.PreviousProgressionLettersWindow'
			],

			config:{
				PROMOTION_PANEL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROMOTION_PANEL_PERMISSION')
			},

			refs : [{
				ref : 'promotionpanelstructure',
				selector : 'promotionpanelstructure'
			},{
				ref : 'promotionpanelsearch',
				selector : 'promotionpanelsearch'
			},{
				ref : 'promotionpanellist',
				selector : 'promotionpanellist'
			},{
				ref : 'promotionpanelviewdetailswindow',
				selector : 'promotionpanelviewdetailswindow'
			},{
				ref : 'promotionaddcommitteewindow',
				selector : 'promotionaddcommitteewindow'
			},
			{
				ref : 'decisionTempleteRemarkGrid',
				selector : 'decisionTempleteRemarkGrid'
			},{
				ref: 'academictopicdocumentspopup',
				selector: 'academictopicdocumentspopup'
			}, {
				ref: 'academictopicdocumentsgrid',
				selector: 'academictopicdocumentsgrid'
			}, {
				ref: 'academictopicurlpopup',
				selector: 'academictopicurlpopup'
			}, {
				ref: 'academictopicurlgrid',
				selector: 'academictopicurlgrid'
			}, {
				ref: 'documentnotesviewallwindow',
				selector: 'documentnotesviewallwindow'
			},{
				ref: 'progressionpanelmessagecontentwindow',
				selector: 'progressionpanelmessagecontentwindow'
			}, {
				ref: 'documentpreviewwindow',
				selector: 'documentpreviewwindow'
			}],

			init : function() {
				this.control({
					'promotionpanelsearch':{
						afterrender:function(){
							var $this = this;

							var form = $this.getPromotionpanelsearch();
							var structure = $this.getPromotionpanelstructure();
							var grid =  structure.down('grid');

							var ALField = form.down("#academyLocationId");
							var studentId = form.down('#studentId');
							var promotionStatusComobo = form.down("#promotionStatusId");
							var programCombo = form.down('#programId');
							var progressionPanelField = form.down('#progressionPanel');

							$this.setDefaultAcademyLocation(ALField);

							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');

							var aLId = $this.getCurrentAcademyLocation();

							var gridStore = grid.getStore();
							var promotionStatusComoboStore = promotionStatusComobo.getStore();
							var programstore = programCombo.getStore();
							var progressionPanelFieldStore = progressionPanelField.getStore();

							gridStore.removeAll();
							grid.down('#custompagingtoolbar').setVisible(false);

							if(wheatherSchool){
								form.down('#periodId').hide();
							}

							studentId.getStore().getProxy().extraParams = {
								academyLocationIds : aLId
							};

							promotionStatusComoboStore.getProxy().extraParams = {
							};
							promotionStatusComoboStore.load();

							programstore.getProxy().extraParams = {
								academyLocationId : aLId
							};
							programstore.removeAll();

							progressionPanelFieldStore.getProxy().extraParams = {
								alId : aLId
							};
							progressionPanelFieldStore.load();

							gridStore.on('load', function(store, records) {
								var startIndex = store.currentPage > 1
								? (store.currentPage - 1) * store.pageSize
										: 0;

								Ext.Array.each(records, function(record, i) {
									record.set('_originalIndex', startIndex + i + 1);
								});
							});
						}
					},
					'promotionpanelsearch customcombobox#academyLocationId' : {
						select : function(obj, record) {
							var $this = this;
							this.resetPromotionPanelList();
							var form = $this.getPromotionpanelsearch();
							var academicTermField = form.down('#academicTerm');
							var programCombo = form.down('#programId');
							var periodField = form.down('#periodId');
							var progressionPanelField = form.down('#progressionPanel');

							var alId = record[0].get("id");
							var academicTermId = academicTermField.getValue();

							programCombo.reset();
							periodField.reset();
							progressionPanelField.reset();

							programCombo.clearValue();
							periodField.clearValue();
							progressionPanelField.clearValue();

							periodField.setDisabled(true);

							var programstore = programCombo.getStore();
							var progressionPanelFieldStore = progressionPanelField.getStore();

							programstore.getProxy().extraParams = {
								academyLocationId : alId
							};
							programstore.load();

							progressionPanelFieldStore.getProxy().extraParams = {
								alId : alId,
								academicTermId: academicTermId
							};
							progressionPanelFieldStore.load();
						}
					},
					'promotionpanelsearch customcombobox#academicTerm' : {
						select : function(obj, record) {
							var $this = this;
							this.resetPromotionPanelList();

							var form = this.getPromotionpanelsearch();

							var periodComboBox = form.down('customcombobox#periodId');
							var programComboBox = form.down('customcombobox#programId');
							var progressionPanelField = form.down('#progressionPanel');

							var id = record[0].get("id");
							var academyLocationId = form.down('customcombobox#academyLocationId').getValue();

							programComboBox.reset();
							periodComboBox.reset();
							progressionPanelField.reset();

							programComboBox.clearValue();
							periodComboBox.clearValue();
							progressionPanelField.clearValue();

							periodComboBox.setDisabled(true);

							var programStore = programComboBox.getStore();
							var progressionPanelFieldStore = progressionPanelField.getStore();

							programStore.getProxy().extraParams = {
								academicTermId : id,
								academyLocationId:academyLocationId
							};
							programStore.load();

							progressionPanelFieldStore.getProxy().extraParams = {
								alId : academyLocationId,
								academicTermId: id
							};
							progressionPanelFieldStore.load();

							if(this.getPromotionpanelsearch().isValid()){
								this.getPromotionpanelsearch().down("#searchBtn").setDisabled(false);
							}
							else{
								this.getPromotionpanelsearch().down("#searchBtn").setDisabled(true);
							}
						}
					},
					'promotionpanelsearch customcombobox#programId' : {
						select : function(obj, record) {
							var this$=this;
							this.resetPromotionPanelList();

							var form = this.getPromotionpanelsearch();

							var periodComboBox = form.down('customcombobox#periodId');
							var progressionPanelField = form.down('#progressionPanel');

							var programAL = form.down('#academyLocationId').getValue();
							var academicTermId = form.down('customcombobox#academicTerm').getValue();
							var programId = record[0].get("id");

							periodComboBox.reset();
							progressionPanelField.reset();

							periodComboBox.clearValue();
							progressionPanelField.clearValue();

							periodComboBox.setDisabled(false);

							var periodStore = periodComboBox.getStore();
							var progressionPanelFieldStore = progressionPanelField.getStore();

							periodStore.getProxy().extraParams = {
								isFromPromotion:true,
								academicTermId:academicTermId,
								programId:programId
							};
							periodStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if(records.length==0){
											if(wheatherSchool) {
												showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
											}
										}
										else if(records.length==1){
											form.down("#periodId").setValue(records[0].get('id'));
										}else{
											form.down('#periodId').setVisible(true);
										}

										progressionPanelFieldStore.getProxy().extraParams = {
											alId : programAL,
											academicTermId: academicTermId,
											programId: programId,
											periodId: form.down("#periodId").getValue()
										};

										progressionPanelFieldStore.load();

										if(form.isValid()){
											form.down("#searchBtn").setDisabled(false);
										}
										else{
											form.down("#searchBtn").setDisabled(true);
										}
									}
								}
							});
						}
					},
					'promotionpanelsearch customcombobox#periodId' : {
						select : function(obj, record) {
							var me= this;
							var form=this.getPromotionpanelsearch();
							this.resetPromotionPanelList();

							var academyLocationField = form.down('customcombobox#academyLocationId');
							var academicTermField = form.down('#academicTerm');
							var programCombo = form.down('#programId');
							var progressionPanelField = form.down('#progressionPanel');
							progressionPanelField.reset();

							var academyLocationId = academyLocationField.getValue();
							var academicTermId = academicTermField.getValue();
							var programId=programCombo.getValue();
							var periodId = record[0].get("id");

							var progressionPanelFieldStore = progressionPanelField.getStore();

							progressionPanelFieldStore.getProxy().extraParams = {
								alId : academyLocationId,
								academicTermId: academicTermId,
								programId: programId,
								periodId: periodId
							};

							progressionPanelFieldStore.load();

							if(form.isValid()){
								form.down("#searchBtn").setDisabled(false);
							}
							else{
								form.down("#searchBtn").setDisabled(true);
							}
						}
					},

					'promotionpanelsearch customcombobox#studentId' : {
						select : function(obj, record) {
							var me= this;
							this.resetPromotionPanelList();
						}
					},

					'promotionpanelsearch customcombobox#periodStatus' : {
						select : function(obj, record) {
							var me= this;
							this.resetPromotionPanelList();
						}
					},

					'promotionpanelsearch customcombobox#promotionStatusId' : {
						select : function(obj, record) {
							var me= this;
							this.resetPromotionPanelList();
						}
					},

					'promotionpanelsearch customcombobox#enrollmentStatus' : {
						select : function(obj, record) {
							var me= this;
							this.resetPromotionPanelList();
						}
					},

					'promotionpanelsearch checkbox#nonPanelStudentCheckBox':{
						change: function(checkbox, newValue, oldValue) {
							var form = checkbox.up('form');
							var grid = this.getPromotionpanellist();
							var progressionPanel = form.down('#progressionPanel');

							var programField = form.down('#programId');
							var periodField =  form.down('#periodId');

							if(newValue)
							{
								this.setAllowBlank(programField, false);
								this.setAllowBlank(periodField, false);
								progressionPanel.setDisabled(true);
								progressionPanel.reset();
								progressionPanel.clearValue();
							}
							else{
								this.setAllowBlank(programField, true);
								this.setAllowBlank(periodField, true);
								programField.clearInvalid();
								periodField.clearInvalid();
								progressionPanel.setDisabled(false);
							}
							form.isValid();
							this.resetPromotionPanelList();
						}
					},

					'promotionpanelsearch customcombobox#progressionPanel' : {
						select : function(obj, record) {
							var me= this;
							var form=this.getPromotionpanelsearch();
							this.resetPromotionPanelList();
							form.isValid();
						}
					},

					'promotionpanelsearch customcombobox#progressionStatusId' : {
						select : function(obj, record) {
							var me= this;
							this.resetPromotionPanelList();
						}
					},

					'promotionpanelsearch button[itemId=searchBtn]' : {
						click : this.loadPromotionGrid
					},
					'promotionpanelsearch button[itemId=resetBtn]' : {
						click : function(){
							this.getResetPromotion();
						}
					},
					'promotionpanelstructure':{
						beforerender:function(){
							this.getPromotionpanellist().getStore().removeAll();
						}
					},
					'promotionpanelstructure': {
						afterrender : function(structure){
							var grid = structure.down('promotionpanellist');
							this.getGridHeaderFreeze(grid,structure,false);
						}
					},
					'promotionpanellist button[itemId=detailedViewId]':{
						click: this.openDetails
					},
					'promotionpanellist button[itemId=promotionSaveBtn]':{
						click: this.onPromotionSaveClick
					},
					'promotionpanelviewdetailswindow button[itemId=saveAsDraftBtn]': {
						click: function(btn) {
							var btnValue = 'Drafted';
							this.addDecisionTemplateGridData(btn, btnValue);
						}
					},
					'promotionpanelviewdetailswindow button[itemId=submitBtn]': {
						click: function(btn) {
							var btnValue = 'Submitted';
							this.addDecisionTemplateGridDataSubmitted(btn, btnValue);
						}
					},
					'promotionpanelviewdetailswindow button[itemId=complteBtn]': {
						click: function(btn) {
							var btnValue = 'Completed';
							this.completePromotionPassout(btn, btnValue);
						}
					},

					'promotionpanelviewdetailswindow button[itemId=sendProgressionBtn]': {
						click: function(btn) {
							var btnValue = 'Completed';
							this.sendProgressionLetter(btn, btnValue);
						}
					},
					'promotionpanelviewdetailswindow customcombobox#completeButtonId': {
						select: function(cmb){
							var $this = this;
							var win = $this.getPromotionpanelviewdetailswindow();
							if (!isNullOrEmpty(win.panelData)) {
								var panelData = win.panelData;
								var panelId = panelData.id;
								var progressionCompleteBtnStatus = cmb.getValue();
								$this.applyWindowMask();
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.PATH_UPDATE_COMPLETE_BUTTON_STATUS,
									method: 'GET',
									params: {
										id: panelId,
										progressionCompleteBtnStatus:progressionCompleteBtnStatus
									},
									success: function(response, action) {
										if (!isNullOrEmpty(response.responseText)) {
											$this.hideWindowMask();
											if (response.responseText === "SUCCESS") {
												showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
											}
											var completeBtn = win.down('#complteBtn');
											if (!isNullOrEmpty(cmb.getValue()) && cmb.getValue() === 'DO_NOT_SHOW') {
												completeBtn.hide();
											}
											else {
												completeBtn.show();
											}
										}
									}
								});
							}
							else {
								var completeBtn = win.down('#complteBtn');
								if (!isNullOrEmpty(cmb.getValue()) && cmb.getValue() === 'DO_NOT_SHOW') {
									completeBtn.hide();
								}
								else {
									completeBtn.show();
								}

							}



						}
					},

					'promotionpanelviewdetailswindow grid[itemId=previousProgressionLettersGrid] ': {
						cellclick: function (gridView, td, cellIndex, record, tr, rowIndex, e, eOpts) {
							var $this = this;
							var clickedEl = e.getTarget();

							if (clickedEl.tagName === 'A') {
								var response = record.data;
								var subjectLine = response.sujectLine;
								var userGenMes = response.userGeneratedMsg;

								var msgContentWindow = $this.getProgressionpanelmessagecontentwindow();

								if (!msgContentWindow) {
									msgContentWindow = Ext.widget('previousProgressionLettersWindow', {
										itemId: 'previousProgressionLettersWindow',
										resp: response
									});
								}

								msgContentWindow.show();
								msgContentWindow.center();

								// Set values
								msgContentWindow.down('#subjectLine').setValue(subjectLine);
								msgContentWindow.down('#userGeneratedMsgContent').setValue(userGenMes);
							}
						}
					},

					'previousProgressionLettersWindow button[itemId=marksheetPreviewBtn]': {
						click: function (gridView, td, cellIndex, record, tr, rowIndex, e, eOpts) {
							var previewWindow = this.getDocumentpreviewwindow();

							if (!previewWindow) {
								Ext.widget('documentpreviewwindow', {
									documentRecord: record,
									width: '100%',
									height: Ext.getBody().getHeight(),
									itemId: 'promotionPanelMarksheetPreviewWindow'
								});
								previewWindow = this.getDocumentpreviewwindow();
							}
							previewWindow.show();

							var url = SERVERURL.PATH_PREVIEW_MARKSHEET;
							var filePath = gridView.up('window').resp.marksheetPath;
							var fileExtension = filePath.split('.').pop()

							Ext.Ajax.request({
								type: 'rest',
								url: url,
								params: {
									filePath: filePath,
								},
								method: 'GET',
								success: function (res, action) {
									var responseTxt = res.responseText;
									if (responseTxt != '') {
										if (fileExtension.toUpperCase() == "PDF") {
											var fileSizeBytes = atob(responseTxt).length;
											var fileSizeMB = fileSizeBytes / (1024 * 1024);
											if(fileSizeMB > 1.2){
												// Convert base64 string to Blob
												var byteCharacters = atob(responseTxt);
												var byteNumbers = new Array(byteCharacters.length);
												for (var i = 0; i < byteCharacters.length; i++) {
													byteNumbers[i] = byteCharacters.charCodeAt(i);
												}
												var byteArray = new Uint8Array(byteNumbers);
												var blob = new Blob([byteArray], { type: 'application/pdf' });

												// Create a temporary URL for the Blob
												var blobUrl = URL.createObjectURL(blob);

												// Set the src of iframe to the Blob URL
												Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<iframe width='100%' height='100%' src='" + blobUrl + "'></iframe>";

											}else{
												Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<iframe width='100%' height='100%' src='data:application/pdf;base64, " + encodeURI(responseTxt) + "'></iframe>";
											}
										} else {
											Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<img src='data:image/" + fileExtension.toLowerCase() + ";base64," + encodeURI(responseTxt) + "' />";
										}
									} else {
										Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "Document Not Found";
									}
								}
							});
						}
					},

					'promotionpanellist':{
						render: function(grid) {
							var this$=this;
							var permissionsMap = new Ext.util.HashMap();
							permissionsMap = this$.getPROMOTION_PANEL_PERMISSIONS();
							this.disableButtonsPivileges(grid,permissionsMap);
							this.disableMoreActionPivileges(grid,permissionsMap);
						},
						afterrender:function(grid){
							var me = this;
							setTimeout(function(){
								me.addDataGridConfigButton(grid,me.getPROMOTION_PANEL_PERMISSIONS());
							},1500);
						},
						selectionchange: function (column, selected, eOpts) {
							var grid = this.getPromotionpanellist();
							this.enableDisableDetailedViewButton(column, selected);
							this.enableDisableSaveButton(column, selected);
							this.enableDisableRevertToDrafted(column,selected);
						},
						cellclick: this.onPromotionListCellClick,
						edit: function (editor, e) {
							var grid = this.getPromotionpanellist();
							var selected = grid.getSelectionModel().getSelection();
							this.enableDisableSaveButton(null, selected);
						}
					},
					'promotionpanelviewdetailswindow':{
						afterrender: function(win){
							var me = this;
							var minIdx = win.minIdx;
							var currentIdx = win.recordIdx;
							var maxIdx = win.maxIdx;

							me.loadWinRecord(win, minIdx, currentIdx, maxIdx);
						}/*,
    			 cellclick: function(grid1, td, cellIndex, record, tr, rowIndex, e, eOpts) {
 					 var $this = this;
 					 var grid = $this.getCourseregistrationeditablegrid();
 					 var columnName = grid.columnManager.columns[cellIndex].dataIndex;

 					 if (e.target.tagName == 'DIV') {
 						 if (columnName == "promotionStatus") {}
 					 }
 				 }*/
					,render: function(window){
						var $this = this;
						$this.adddecisionTempleteRemarkGridRecord(1);
						window.body.on('click', function() {
							//var filter = window.down('manageSchoolForm');
							//$this.hideInvalidIconFromField($this.getRegistrationsetupdetailstabpanel());
						});
					},
					close:function(win){
						if(isSubmittedForm){
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						var grid = this.getPromotionpanellist();
						var promotionPanelPeriodGridStore = grid.getStore();
						promotionPanelPeriodGridStore.load({
							callback: function(records, operation, success){
								Ext.getBody().unmask();
							}

						});
						grid.getSelectionModel().deselectAll();
						}
					}
					},
					'promotionpanelviewdetailswindow button[itemId=viewDetailsNextBtnItemId]': {
						click: function (btn) {
							var me = this;
							var win = btn.up('window');
							var marksheetJobField = win.down('#marksheetJobField');
							var minIdx = win.minIdx;
							var currentIdx = win.recordIdx + 1;
							var maxIdx = win.maxIdx;
							var calledOnNextPrevious = true;

							win.recordIdx = currentIdx;

							var rawValue = win.down('#selectedCountTool').getEl().getHTML();

							if (rawValue) {
								var parts = rawValue.split('/');
								var incrementedCount = (+parts[0]) + 1;
								var totalCount = parts[1];

								win.down('#selectedCountTool').getEl().setHTML(incrementedCount + '/' + totalCount);
							}

							marksheetJobField.reset();
							me.loadWinRecord(win, minIdx, currentIdx, maxIdx, calledOnNextPrevious);
							var structure = me.getPromotionpanelstructure();
							var grid = structure.down('grid');
							if (grid) {
								var store = grid.getStore();
								var rec = store.getAt(currentIdx);  // pick record at index
								if (rec) {
									grid.getSelectionModel().select(rec); // highlight the row
									grid.getView().focusRow(rec);         // scroll into view
								}
							}
						}
					},

					'promotionpanellist button[itemId=addToPanelBtnId]':{
						click: function() {
							var $this = this;
							var grid = $this.getPromotionpanellist();
							if (grid.getSelectionModel().getCount() > 0) {
								this.showPromotionAddCommiteeWindow();
							}else{
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}

					},

					'promotionaddcommitteewindow':{
						afterrender: function(win){
							var me = this;
							var committeIdField = win.down('#committeId');

							var promotionPanelForm = me.getPromotionpanelsearch();
							var periodIdField = promotionPanelForm.down('#periodId');

							committeIdField.getStore().getProxy().extraParams.periodId = periodIdField.getValue();

						}
					},

					'promotionaddcommitteewindow button[itemId=btnSubmit]' : {
						click : function() {
							this.promotionAddCommitteSave();
						}
					},

					'promotionpanelviewdetailswindow button[itemId=viewDetailsPrevBtnItemId]': {
						click: function (btn) {
							var me = this;
							var win = btn.up('window');
							var marksheetJobField = win.down('#marksheetJobField');
							var minIdx = win.minIdx;
							var currentIdx = win.recordIdx - 1;
							var maxIdx = win.maxIdx;
							var calledOnNextPrevious = true;
							var rawValue = win.down('#selectedCountTool').getEl().getHTML();

							win.recordIdx = currentIdx;

							if (rawValue) {
								var parts = rawValue.split('/');
								var incrementedCount = (+parts[0]) - 1;
								var totalCount = parts[1];

								win.down('#selectedCountTool').getEl().setHTML(incrementedCount + '/' + totalCount);
							}

							marksheetJobField.reset();
							me.loadWinRecord(win, minIdx, currentIdx, maxIdx, calledOnNextPrevious);
							var structure = me.getPromotionpanelstructure();
							var grid = structure.down('grid');
							if (grid) {
								var store = grid.getStore();
								var rec = store.getAt(currentIdx);  // pick record at index
								if (rec) {
									grid.getSelectionModel().select(rec); // highlight the row
									grid.getView().focusRow(rec);         // scroll into view
								}
							}
						}
					},
					'promotionpanelviewdetailswindow customcombobox[itemId=promotionStatusId]':{
						select: function(combo){

							var me = this;
							var grid = combo.up('grid');
							var comboVal = combo.getValue();
							var comboStore = combo.getStore();
							var tempVal ='';
							var selectedRecord = grid.getSelectionModel().getSelection()[0];
							var index = grid.getStore().indexOf(selectedRecord);
							var storeRecord = grid.getStore().getAt(index);
							if(!isNullOrEmpty(comboVal) && (comboVal=='Proceed')){
								tempVal = 'Email Marksheet For Proceed Status Template';
							}
							else if(!isNullOrEmpty(comboVal) && comboVal.toLowerCase() === 'proceed with condition'){
								tempVal = 'Email marksheet for proceed with condition status Template';
							}
							else if(!isNullOrEmpty(comboVal) && comboVal=='Retake'){
								tempVal = 'Email Marksheet for Retake Semester Status Template';
							}
							else if(!isNullOrEmpty(comboVal) && (comboVal=='Resit')){
								tempVal = 'Email marksheet for Resit status Template';
							}
							else if(!isNullOrEmpty(comboVal) && comboVal=='Internship Pending'){
								tempVal = 'Email marksheet for internship pending status Template';
							}
							else if(!isNullOrEmpty(comboVal) && ((comboVal=='Academic Failure') || (comboVal=='Fail'))){
								tempVal = 'Email marksheet for academic failure status Template';
							}
							else if(!isNullOrEmpty(comboVal) && (comboVal=='Partial Validation')){
								tempVal = 'Email marksheet for Partial Validation status Template';
							}
							else if (!isNullOrEmpty(comboVal) && (comboVal=='Partial Resit')) {
								tempVal = 'Email marksheet for Partial Resit status Template';
							}
							else if (!isNullOrEmpty(comboVal) && (comboVal == 'Proceed - Program Completion')) {
								tempVal = 'Email Proceed Program Completion status Template';
							}
							else if (!isNullOrEmpty(comboVal) && (comboVal == 'Promote')) {
								tempVal = 'Email marksheet for Promote status';
							}
							else if (!isNullOrEmpty(comboVal) && (comboVal == 'Deferred Retake')) {
								tempVal = 'Email Marksheet For Deferred Retake Status Template';
							}
							else if (!isNullOrEmpty(comboVal) && (comboVal == 'Deferred Resit')) {
								tempVal = 'Email Marksheet For Deferred Resit Status Template';
							}
							else if (!isNullOrEmpty(comboVal) && (comboVal == 'Deferred')) {
								tempVal = 'Email Marksheet For Deferred Status Template';
							}
							else{
								tempVal = '';
							}
							storeRecord.set('template', tempVal);
							Ext.suspendLayouts();
							if(grid && grid.plugins && grid.plugins.length){
								grid.plugins[0].completeEdit();
							}
							grid.getView().refresh();
							Ext.resumeLayouts();
						}
					},
					'promotionpanelviewdetailswindow numberfield[itemId=moderateId]': {
						keyup: function(field) {
							var me = this;
							var grid = field.up('grid');

							// Get the store of the grid
							var store = grid.getStore();

							var editedValue = field.getValue();
							var record = grid.getSelectionModel().getSelection()[0];

							// Call the function to calculate and set values, passing the grid window (win) and store records
							me.calculateAndSetValues(grid.up('window'), store.getRange(), editedValue, record);
						},

						change: function(field) {
							var me = this;
							var grid = field.up('grid');

							// Get the store of the grid
							var store = grid.getStore();

							var editedValue = field.getValue();
							var record = grid.getSelectionModel().getSelection()[0];

							// Call the function to calculate and set values, passing the grid window (win) and store records
							me.calculateAndSetValues(grid.up('window'), store.getRange(), editedValue, record);
						}
					},
					'promotionpanelviewdetailswindow grid[itemId=promotionPanelDocumentsAndNotesGrid] button[itemId=documentsAndNotesViewAllBtn]':{
						click: function(btn){
							var me = this;

							var promotionpanelviewdetailswindow = btn.up('promotionpanelviewdetailswindow');
							var currentIdx = promotionpanelviewdetailswindow.recordIdx;

							var grid = me.getPromotionpanellist();
							var record = grid.getStore().getAt(currentIdx);

							var studentId = record.raw.studentId;
							var programId = record.raw.programId;
							var admissionId = record.raw.admissionId;
							var periodId = record.raw.periodId;

							var formWindow = me.getDocumentnotesviewallwindow();
							try{
								if(formWindow){
									formWindow.destroy();
								}
							}
							catch(e){
								//
							}

							var formWindow = Ext.widget('documentnotesviewallwindow',{
								studentId: studentId,
								programId: programId,
								admissionId: admissionId,
								periodId: periodId
							});

							formWindow.show();
						}
					},
					'documentnotesviewallwindow': {
						afterrender: function(win){
							var me = this;
							var grid = win.down('grid');
							var gridStore = grid.getStore();

							var structure = me.getPromotionpanelstructure();
							var filterForm = structure.down('promotionpanelsearch');

							var studentId = win.studentId;
							var academicTermId = filterForm.down('#academicTerm').getValue(); //main filter form field


							gridStore.removeAll();
							gridStore.clearFilter();

							var academicTermField = win.down('#academicTerm'); // window filter form field
							academicTermField.getStore().load({
								callback: function(){
									academicTermField.setValue(academicTermId);

									gridStore.getProxy().extraParams = {
										studentId: studentId,
										academicTermId: academicTermId
									};

									gridStore.loadPage(1);
								}
							});
						}
					},
					'documentnotesviewallwindow button[itemId=searchBtn]':{
						click: function(btn){
							var me = this;
							var form  = btn.up('form');
							var win = btn.up('window');
							var grid = win.down('grid');
							var gridStore = grid.getStore();

							var studentId = win.studentId;
							var academicTermId = form.down('#academicTerm').getValue();
							var academictopicId = form.down('#academictopic').getValue();

							gridStore.removeAll();
							gridStore.clearFilter();

							gridStore.getProxy().extraParams = {
								studentId: studentId,
								academicTermId: academicTermId,
								acadmicTypeId: academictopicId
							};

							gridStore.loadPage(1);
						}
					},
					'documentnotesviewallwindow button[itemId=resetBtn]':{
						click: function(btn){
							var me = this;
							var form  = btn.up('form');
							var win = btn.up('window');
							var grid = win.down('grid');
							var gridStore = grid.getStore();

							var academicTermField = form.down('#academicTerm');
							var academicTopicField = form.down('#academictopic');

							var studentId = win.studentId;

							gridStore.removeAll();
							gridStore.clearFilter();

							academicTermField.reset();
							academicTopicField.reset();

							gridStore.getProxy().extraParams = {
								studentId: studentId
							};

							gridStore.loadPage(1);
						}
					},
					'documentnotesviewallwindow grid[itemId=allDocumentsAndNotesGrid]':{
						cellclick: function(gridview, td, cellIndex, record, tr, rowIndex, e, eOpts) {
							var $this = this;
							var grid = gridview.up('grid');
							var columnName = grid.columnManager.columns[cellIndex].dataIndex;
							if(e.target.tagName == 'A' && columnName == 'academicTopicDocuments') {
								if(record.data.documents.length == 1){
									var whetherFile = false;
									var documentId= record.data.documents["0"].encryptedDocId;
									if(!isNullOrEmpty(documentId)){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											method: 'GET',
											callback : function(opt, success, response){
												if(response.responseText == 'true') {
													var csvForm = Ext.create('Ext.form.Panel');
													csvForm.getForm().submit({
														target: '_blank',
														method:'GET',
														params :{
															access_token : Ext.Ajax.defaultHeaders.access_token
														},
														headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														standardSubmit :true
													});
												}
												else {
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												}
											}
										});
									}
								}
								else if(record.data.documents.length > 1){
									var docWindow = this.getAcademictopicdocumentspopup();
									if (!docWindow) {
										docWindow = Ext.widget('academictopicdocumentspopup',{
											itemId:'academictopicdocumentspopup_pp',
											listeners: {
												afterrender: function(win){
													win.down('#btnDelete').hide();
													win.down('#downloadDocumentItemId').hide();
												}
											}
										});
									}
									docWindow.show();
									docWindow.center();
									var academictopicdocumentsgrid = docWindow.down('#academictopicdocumentsgridItemId');
									var store = academictopicdocumentsgrid.getStore();
									store.getProxy().extraParams = {
										academicTopicId: record.data.id
									};
									store.load({
										callback: function() {
											docWindow.center();
										}
									});
								}
							}
							else if(e.target.tagName == 'A' && columnName == 'academicTopicUrls') {
								if(record.data.academicTopicUrls.length == 1){
									var whetherFile = false;
									var documentId= record.data.urlName["0"].id;
									if(!isNullOrEmpty(documentId)){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											method: 'GET',
											callback : function(opt, success, response){
												if(response.responseText == 'true') {
													var csvForm = Ext.create('Ext.form.Panel');
													csvForm.getForm().submit({
														target: '_blank',
														method:'GET',
														params :{
															access_token : Ext.Ajax.defaultHeaders.access_token
														},
														headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														standardSubmit :true
													});
												}
												else {
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												}
											}
										});
									}
								}
								else if(record.data.academicTopicUrls.length > 1){
									var docWindow = this.getAcademictopicurlpopup();
									if (!docWindow) {
										docWindow = Ext.widget('academictopicurlpopup',{
											itemId:'academictopicurlpopup_pp',
											listeners: {
												afterrender: function(win){
													win.down('#btnDelete').hide();
												}
											}
										});
									}
									docWindow.show();
									docWindow.center();
									var academictopicdocumentsgrid = docWindow.down('#academictopicurlsgridItemId');
									var store = academictopicdocumentsgrid.getStore();
									store.getProxy().extraParams = {
										academicTopicId: record.data.id
									};
									store.load({
										callback: function() {
											docWindow.center();
										}
									});
								}
							}
						},
						afterrender: function(grid) {
							Ext.defer(function() {
								var gridId = grid.getId();
								Ext.get(gridId + '_header_hd').el.dom.style.width = (grid.getWidth() - 20) + 'px';
								var leftPos = grid.up('window').el.dom.offsetLeft + 35;
								Ext.get(gridId + '_header_hd').el.dom.style.cssText+= 'left: 0px;';
								Ext.get(gridId + '_header_hd-textEl').el.dom.style.cssText+= 'margin-left: 0px !important';
							}, 250);
						}
					},
					'promotionpanelviewdetailswindow grid[itemId=promotionPanelDocumentsAndNotesGrid]':{
						cellclick: function(gridview, td, cellIndex, record, tr, rowIndex, e, eOpts) {
							var $this = this;
							var grid = gridview.up('grid');
							var columnName = grid.columnManager.columns[cellIndex].dataIndex;
							if(e.target.tagName == 'A' && columnName == 'academicTopicDocuments') {
								if(record.data.documents.length == 1){
									var whetherFile = false;
									var documentId= record.data.documents["0"].encryptedDocId;
									if(!isNullOrEmpty(documentId)){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											method: 'GET',
											callback : function(opt, success, response){
												if(response.responseText == 'true') {
													var csvForm = Ext.create('Ext.form.Panel');
													csvForm.getForm().submit({
														target: '_blank',
														method:'GET',
														params :{
															access_token : Ext.Ajax.defaultHeaders.access_token
														},
														headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														standardSubmit :true
													});
												}
												else {
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												}
											}
										});
									}
								}
								else if(record.data.documents.length > 1){
									var docWindow = this.getAcademictopicdocumentspopup();
									if (!docWindow) {
										docWindow = Ext.widget('academictopicdocumentspopup',{
											itemId:'academictopicdocumentspopup_pp',
											listeners: {
												afterrender: function(win){
													win.down('#btnDelete').hide();
													win.down('#downloadDocumentItemId').hide();
												}
											}
										});
									}
									docWindow.show();
									docWindow.center();
									var academictopicdocumentsgrid = docWindow.down('#academictopicdocumentsgridItemId');
									var store = academictopicdocumentsgrid.getStore();
									store.getProxy().extraParams = {
										academicTopicId: record.data.id
									};
									store.load({
										callback: function() {
											docWindow.center();
										}
									});
								}
							}
							else if(e.target.tagName == 'A' && columnName == 'academicTopicUrls') {
								if(record.data.academicTopicUrls.length == 1){
									var whetherFile = false;
									var documentId= record.data.urlName["0"].id;
									if(!isNullOrEmpty(documentId)){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											method: 'GET',
											callback : function(opt, success, response){
												if(response.responseText == 'true') {
													var csvForm = Ext.create('Ext.form.Panel');
													csvForm.getForm().submit({
														target: '_blank',
														method:'GET',
														params :{
															access_token : Ext.Ajax.defaultHeaders.access_token
														},
														headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														standardSubmit :true
													});
												}
												else {
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												}
											}
										});
									}
								}
								else if(record.data.academicTopicUrls.length > 1){
									var docWindow = this.getAcademictopicurlpopup();
									if (!docWindow) {
										docWindow = Ext.widget('academictopicurlpopup',{
											itemId:'academictopicurlpopup_pp',
											listeners: {
												afterrender: function(win){
													win.down('#btnDelete').hide();
												}
											}
										});
									}
									docWindow.show();
									docWindow.center();
									var academictopicdocumentsgrid = docWindow.down('#academictopicurlsgridItemId');
									var store = academictopicdocumentsgrid.getStore();
									store.getProxy().extraParams = {
										academicTopicId: record.data.id
									};
									store.load({
										callback: function() {
											docWindow.center();
										}
									});
								}
							}
						}
					},
					'promotionpanelviewdetailswindow button[itemId=emailPreviewBtn]':{
						click: this.handleEmailMarksheetPreviewClick
					},
					'promotionpanelviewdetailswindow button[itemId=marksheetPreviewBtn]':{
						click: this.handleEmailMarksheetPreviewClick
					},

					'progressionpanelmessagecontentwindow':{
						afterrender: function(win){
							var me = this;
							var resp = win.resp;

							var messageSubjectField = win.down('#messageSubject');
							var messageContentField = win.down('#messageContent');

							var finalMsgContent = !isNullOrEmpty(resp.userGeneratedMsgContent) ? resp.userGeneratedMsgContent : resp.systemGeneratedMsgContent;

							messageSubjectField.setValue(resp.subjectLine);
							messageContentField.setValue(finalMsgContent);
						}
					},

					'progressionpanelmessagecontentwindow button[itemId=saveTemplateBtnId]':{
						click: function(btn){
							var me = this;
							var win = me.getProgressionpanelmessagecontentwindow();
							var promotionPanelGrid = this.getPromotionpanellist();
							var formWindow = this.getPromotionpanelviewdetailswindow()
							var currentIdx = formWindow.recordIdx;
							var record = promotionPanelGrid.getStore().getAt(currentIdx);

							var promotionPanelGridDecision = record.raw.decision;
							var promotionPanelGridRemark = record.raw.remark;
							var admissionId = record.raw.admissionId;
							var studentId = record.raw.studentId;
							var periodId = record.raw.periodId;
							var programId = record.raw.programId;
							var batchId = record.raw.batchId;
							var academicTermId = record.raw.academicTermId;
							var marksheetJobId = record.raw.marksheetJobId;
							var marksheetPath = formWindow.down('#marksheetJobField').valueModels[0].raw.itemValue;
							var formValues = win.down('form').getForm().getValues();
							var sujectLine = formValues.messageSubject;
							var userGeneratedMsgContent =formValues.messageContent;

							var encodedMsg = btoa(unescape(encodeURIComponent(userGeneratedMsgContent)));

							var studentCacheRecord = Ext.Array.findBy(tempArrayProgressionData, function(item) {
							    return item.studentId === studentId;
							});
							var marksheetJobId = studentCacheRecord.marksheetjob;
							var data={
									admissionId:admissionId,
									studentId:studentId,
									periodId:periodId,
									programId:programId,
									batchId:batchId,
									acdemicTermId:academicTermId,
									marksheetJobId:marksheetJobId,
									sujectLine:sujectLine,
									userGeneratedMsgContent:encodedMsg,
									marksheetPath:marksheetPath
							};
							var formData = Ext.encode(data);
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							win.body.mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							setTimeout(function() {
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.PATH_EMAIL_CONTENT_SAVE,                             
									method: 'POST',
									async: false,
									jsonData : formData,
									success: function(response,form, action) {
										Ext.getBody().unmask();
										showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
										/*var minIdx = formWindow.minIdx;
										var currentIdx = formWindow.recordIdx;
										var maxIdx = formWindow.maxIdx;

										formWindow.recordIdx = currentIdx;

										me.loadWinRecord(formWindow, minIdx, currentIdx, maxIdx);
*/
										formWindow.unmask();
										win.unmask();
										win.close();
									},
									failure: function(){
										win.unmask();
										formWindow.unmask();
									}
								});
							},500);

						}
					},

					'promotionpanellist button[itemId=revertToDraftedBtn]': {
						click: function() {
							var $this = this;
							var grid = $this.getPromotionpanellist();
							var allValid = true;
							var enrollmentCompleted =false;
							var listForRrevert = [];
							if (grid.getSelectionModel().getCount() > 0) {
								var penalData = grid.getSelectionModel().getSelection();
								if (!isNullOrEmpty(penalData) && penalData.length > 0) {
									for (var i = 0; i < penalData.length; i++) {
										var record = penalData[i];
										var progressionPanelId = record.get("progressionStatusId");
										var decision = record.get("decision");
										var periodId = record.get("periodId");
										var admissionId = record.get("admissionId");
										var studentId = record.get("studentId");
										var progressionStatus = record.get("progressionStatus");
										var enrollmentStatus = record.get("enrollmentStatus");
										if ((!isNullOrEmpty(progressionStatus)) && (!isNullOrEmpty(enrollmentStatus)) && (!isNullOrEmpty(decision)) &&
												(progressionStatus.toLowerCase() === 'completed')) {
											allValid = true;
											if(enrollmentStatus.toLowerCase()==='completed'){
												enrollmentCompleted=true;
											}
											var revertRecord = {
													progressionPanelId: progressionPanelId,
													progressionStatus: decision,
													admissionId: admissionId,
													studentId: studentId,
													periodId: periodId,
													progressionStatusValue: progressionStatus,
													enrollmentStatus: enrollmentStatus
											};
											listForRrevert.push(revertRecord);
										}
										else {
											allValid = false;
											break;
										}
									}
									if (allValid) {
										if (enrollmentCompleted) {
											showConfirmMessage(getCommonTranslation('PROGRESSION_PANEL'), getCommonTranslation('THERE_WILL_NO_IMPACTS_ON_PERIOD_TRANSITION_AND_STUDENTJOURNEY_WANT_TO_CONTINUE'), function(btnNew, text) {
												if (btnNew == 'yes') {
													Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
													setTimeout(function() {
														Ext.Ajax.request({
															url: SERVERURL.PATH_REVERT_TO_DRAFT_PROGRESSION_PANEL,
															method: 'POST',
															jsonData: listForRrevert,
															success: function(response) {
																// Optionally handle response here

																var data = response.responseText;
																grid.getStore().load();
																if (data === 'SUCCESS') {
																	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
																}
																if (data === 'REVERT_TO_DRAFT_PROCESS_IN_PROGRESS') {
																	showWarningMessage(getCommonTranslation('SUCCESS'), getExaminationTranslation('REVERT_TO_DRAFT_PROCESS_IN_PROGRESS'));
																}
																grid.getSelectionModel().deselectAll();
																Ext.getBody().unmask();
															},
															failure: function(response) {
																showErrorMessage(getCommonTranslation('FAILURE'), getErrorTranslation('exception_while_updating_entity'));
																Ext.getBody().unmask();
															}
														});
													}, 500);
												}
											});
										}
										else {
											Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
											setTimeout(function() {
												Ext.Ajax.request({
													url: SERVERURL.PATH_REVERT_TO_DRAFT_PROGRESSION_PANEL,
													method: 'POST',
													jsonData: listForRrevert,
													success: function(response) {
														// Optionally handle response here

														var data = response.responseText;
														grid.getStore().load();
														if (data === 'SUCCESS') {
															showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
														}
														if (data === 'REVERT_TO_DRAFT_PROCESS_IN_PROGRESS') {
															showWarningMessage(getCommonTranslation('SUCCESS'), getExaminationTranslation('REVERT_TO_DRAFT_PROCESS_IN_PROGRESS'));
														}
														grid.getSelectionModel().deselectAll();
														Ext.getBody().unmask();
													},
													failure: function(response) {
														showErrorMessage(getCommonTranslation('FAILURE'), getErrorTranslation('exception_while_updating_entity'));
														Ext.getBody().unmask();
													}
												});
											}, 500);
										}
									}
									if (!allValid) {
										showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SOME_RECORDS_ARE_NOT_ELIGIBLE_FOR_REVERT'));
										return false;
									}
								}
							} else {
								showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}

					},

					'promotionpanelviewdetailswindow button[itemId=regenerateLetterBtn]':{
						click: this.handleRegenerateLetter
					},


				});
			},


			disableMoreActionPivileges: function(gridReference,permissionsMap) {

				var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				buttonsToolBar = gridReference.query('toolbar')[0];

				var detailedViewButton = buttonsToolBar.query('#detailedViewId')[0];
				detailedViewButton.setVisible(false);
				Ext.each(permissionList, function(privilege) {

					if (privilege === 'DETAILED_VIEW') {
						var button = buttonsToolBar.query('#detailedViewId')[0];
						if(!isNullOrEmpty(button)){
							button.setVisible(true);
						}
					}

					if (privilege === 'CREATE') {
						var button = buttonsToolBar.query('#promotionSaveBtn')[0];
						if(!isNullOrEmpty(button)){
							button.setVisible(true);
						}
					}
				});
			},



			openDetails: function(btn){
				var $this = this;
				var $this = this;
				var grid = $this.getPromotionpanellist();
				tempArrayProgressionData=[];
				isSubmitted=false;
				if (grid.getSelectionModel().getCount() == 1) {
					var selectedRecord = grid.getSelectionModel().getSelection()[0];
					var formWindow = $this.getPromotionpanelviewdetailswindow();
					if(formWindow){
						formWindow.destroy();
					}

					var currentRecordIdx = grid.getStore().findExact('id',selectedRecord.data.id);

					formWindow = Ext.widget('promotionpanelviewdetailswindow',{
						minIdx: 0,
						recordIdx: currentRecordIdx,
						maxIdx: grid.getStore().getCount()-1
					});
					if(formWindow && formWindow.down && formWindow.down('#decisionTempleteRemarkGrid')){
						formWindow.down('#decisionTempleteRemarkGrid').store.removeAll();
					}
					formWindow.show();

				}else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
				}
			},

			enableDisableDetailedViewButton: function (column, selected) {
				var grid = this.getPromotionpanellist();
				var addToPanelBtnId = grid.down('#addToPanelBtnId');
				var detailsViewtId = grid.down('#detailedViewId');

				var structure = grid.up('promotionpanelstructure');
				var progressionPanelField = structure.down('#progressionPanel');
				var progressionPanelVal = progressionPanelField.getValue();

				var nonPanelStudentCheckBox = structure.down('#nonPanelStudentCheckBox');

				if(!isNullOrEmpty(selected) && isNullOrEmpty(progressionPanelVal) && selected.length){
					addToPanelBtnId.setDisabled(false);
				}
				else{
					addToPanelBtnId.setDisabled(true);
				}

				if(!nonPanelStudentCheckBox.getValue()){
					if (!isNullOrEmpty(selected) && selected.length > 1) {
						detailsViewtId.setDisabled(true);
					} else {
						detailsViewtId.setDisabled(false);
					}
				}
				else{
					detailsViewtId.setDisabled(true);
				}
			},

			enableDisableSaveButton: function (column, selected) {
				var grid = this.getPromotionpanellist();
				var promotionSaveBtn = grid.down('#promotionSaveBtn');
				var allValid = true;
				var nonPanelStudentCheckBox = grid.up('promotionpanelstructure').down('[name=nonPanelStudentCheckBox]').getValue();

				if(nonPanelStudentCheckBox){
					promotionSaveBtn.setDisabled(allValid);
					return
				}

				if (!isNullOrEmpty(selected) && selected.length > 0) {
					for (var i = 0; i < selected.length; i++) {
						var record = selected[i];
						var progressionStatus = record.get('progressionStatus');
						var decision = record.get('decision');

						var isStatusValid = progressionStatus &&
						(progressionStatus.toLowerCase() === 'pending' || progressionStatus.toLowerCase() === 'drafted');

						var hasDecision = !isNullOrEmpty(decision);

						if (!(isStatusValid && hasDecision)) {
							allValid = false;
							break;
						}
					}

					promotionSaveBtn.setDisabled(!allValid);
				} else {
					promotionSaveBtn.setDisabled(true);
				}
			},

			onPromotionSaveClick: function () {
				var grid = this.getPromotionpanellist();
				var selection = grid.getSelectionModel().getSelection();
				var recordsToSend = [];
				var idsToUpdate = [];
				var committeeVal = grid.up('promotionpanelstructure').down('[fieldLabel=Progression Panel]').getValue();
				var completeButtonStatus;

				Ext.Array.forEach(selection, function (record) {
					var status = record.get('progressionStatus');
					var decisionVal =  record.get('decision');

					if(!isNullOrEmpty(record.raw.completeButtonStatus)){
						completeButtonStatus = record.raw.completeButtonStatus
					}else{
						completeButtonStatus='SHOW_WITH_CONFIRMATION';
					}

					if(!isNullOrEmpty(decisionVal) && (decisionVal=='Proceed')){
						tempVal = 'Email Marksheet For Proceed Status Template';
					}
					else if(!isNullOrEmpty(decisionVal) && decisionVal.toLowerCase() === 'proceed with condition'){
						tempVal = 'Email marksheet for proceed with condition status Template';
					}
					else if(!isNullOrEmpty(decisionVal) && decisionVal=='Retake'){
						tempVal = 'Email Marksheet for Retake Semester Status Template';
					}
					else if(!isNullOrEmpty(decisionVal) && (decisionVal=='Resit')){
						tempVal = 'Email marksheet for Resit status Template';
					}
					else if(!isNullOrEmpty(decisionVal) && decisionVal=='Internship Pending'){
						tempVal = 'Email marksheet for internship pending status Template';
					}
					else if(!isNullOrEmpty(decisionVal) && ((decisionVal=='Academic Failure') || (decisionVal=='Fail'))){
						tempVal = 'Email marksheet for academic failure status Template';
					}
					else if (!isNullOrEmpty(decisionVal) && (decisionVal == 'Partial Validation')) {
						tempVal = 'Email marksheet for Partial Validation status Template';
					}
					else if (!isNullOrEmpty(decisionVal) && (decisionVal == 'Partial Resit')) {
						tempVal = 'Email marksheet for Partial Resit status Template';
					}
					else if (!isNullOrEmpty(decisionVal) && (decisionVal == 'Proceed - Program Completion')) {
						tempVal = 'Email Proceed Program Completion status Template';
					}
					else if (!isNullOrEmpty(decisionVal) && (decisionVal == 'Promote')) {
						tempVal = 'Email marksheet for Promote status';
					}
					else if (!isNullOrEmpty(decisionVal) && (decisionVal == 'Deferred Retake')) {
						tempVal = 'Email Marksheet For Deferred Retake Status Template';
					}
					else if (!isNullOrEmpty(decisionVal) && (decisionVal == 'Deferred Resit')) {
						tempVal = 'Email Marksheet For Deferred Resit Status Template';
					}
					else if (!isNullOrEmpty(decisionVal) && (decisionVal == 'Deferred')) {
						tempVal = 'Email Marksheet For Deferred Status Template';
					}
					else{
						tempVal = '';
					}
					var remark = '-';
					if(!isNullOrEmpty(record.get('remark'))){
						remark=record.get('remark');
					}

					if (status && status.toLowerCase() === 'pending' || status.toLowerCase() === 'drafted') {

						var parts = record.get('obtainedCredit').split('/');
						var obtainedCredit=parts[0].trim();
						var projectedECTSCredit= parts[1].trim();
						if(obtainedCredit=='-'){
							obtainedCredit=null;
						}
						if(projectedECTSCredit=='-'){
							projectedECTSCredit=null;
						}
						recordsToSend.push({
							progressionValue: 'Drafted',
							admission: {id:record.get('admissionId')},
							progressionStatusValue: decisionVal,
							marksheetJobDetails: {id: record.get('marksheetJobId')},
							projectedEarnedCredit: obtainedCredit,
							projectedECTSCredit: projectedECTSCredit,
							programBatchPeriodConfiguration: {id: record.get('periodId')},
							id: record.get('progressionStatusId'),
							remark: remark,
							student: {id: record.get('studentId')},
							template: tempVal,
							projectedSpa: record.get('averageSpa'),
							committee:{
								id: committeeVal
							},
							completeButtonStatus:completeButtonStatus,
							isReverted:record.get('isReverted')

						});
						idsToUpdate.push(record.getId());
					}
				});

				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.Ajax.request({
					url: SERVERURL.PATH_SAVE_MULTIPLE_PROGRESSION_DECISION,
					method: 'POST',
					jsonData: recordsToSend,
					success: function (response) {
						// Optionally handle response here
						grid.getStore().load();
						showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
						Ext.getBody().unmask();
					},
					failure: function (response) {
						showErrorMessage(getCommonTranslation('FAILURE'), getErrorTranslation('exception_while_updating_entity'));
						Ext.getBody().unmask();
					}
				});
			},

			loadPromotionGrid:function(){
				var $this = this;
				var promotionPanelForm = $this.getPromotionpanelsearch();
				promotionPanelForm.down('#searchBtn').setDisabled(true);
				var grid = $this.getPromotionpanellist();
				var form = promotionPanelForm.getForm();
				var values = form.getValues();
				var academyLocationId  = values.academyLocationId;
				var periodId = values.periodId;
				var programId = values.programId;
				var promotionType = values.promotionType;
				var promotionStatus = values.promotionStatus;
				var enrollmentStatus = values.enrollmentStatus;
				var periodStatus = values.periodStatus;
				var progressionStatus = values.progressionStatus;
				var isNonPanelStudent = values.nonPanelStudentCheckBox;
				var progressionPanel;
				if(!isNonPanelStudent)
				{
					progressionPanel=values.progressionPanel
				}



				var store = grid.getStore();

				store.getProxy().extraParams = {
					academyLocationId:academyLocationId,
					programId:programId,
					periodId:periodId,
					promotionType:promotionType,
					promotionStatus:promotionStatus,
					academicTermId : values.academicTerm,
					studentId:values.studentId,
					isFromPromotion:true,
					promotionStatus:promotionStatus,
					enrollmentStatus:enrollmentStatus,
					periodStatus:periodStatus,
					progressionStatus:progressionStatus,
					isNonPanelStudent:isNonPanelStudent,
					progressionPanelId:progressionPanel
				};
				this.resetPageSetting(store);
				grid.getStore().removeAll();
				store.load({
					callback: function(records, operation, success) {
						promotionPanelForm.down('#searchBtn').setDisabled(false);
					}
				});
				grid.config.searchFilterForm = promotionPanelForm;
			},

			disableButtonsPivileges: function(gridReference,permissionsMap) {

				var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

				buttonsToolBar = gridReference.query('toolbar')[0];

				var addToPanel = buttonsToolBar.query('#addToPanelBtnId')[0];
				var revertedToDrafted = buttonsToolBar.query('#revertToDraftedBtn')[0];
				addToPanel.setVisible(false);
				revertedToDrafted.setVisible(false);


				Ext.each(permissionList, function(privilege) {

					if (privilege === 'ADD_TO_PANEL') {
						var button = buttonsToolBar.query('#addToPanelBtnId')[0];
						if(!isNullOrEmpty(button)){
							button.setVisible(true);
						}
					}


					if (privilege === 'REVERT_TO_DRAFTED') {
						var button = buttonsToolBar.query('#revertToDraftedBtn')[0];
						if (!isNullOrEmpty(button)) {
							button.setVisible(true);
						}
					}
				});
			},

			getResetPromotion:function(){
				var $this = this;

				var structure = $this.getPromotionpanelstructure();
				var form = $this.getPromotionpanelsearch();
				var grid =  structure.down('grid');

				var ALField = form.down("#academyLocationId");
				var academicTermCombo = form.down('#academicTerm');
				var programCombo = form.down('#programId');
				var progressionPanelField = form.down('#progressionPanel');

				form.getForm().reset();
				$this.setDefaultAcademyLocation(ALField);

				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');

				var aLId = $this.getCurrentAcademyLocation();

				var academicTermComboStore = academicTermCombo.getStore();
				var programComboStore = programCombo.getStore();
				var progressionPanelFieldStore = progressionPanelField.getStore();

				if(wheatherSchool){
					form.down('#periodId').hide();
				}

				academicTermComboStore.getProxy().extraParams = {
				};
				academicTermComboStore.load();

				programComboStore.getProxy().extraParams = {
					academyLocationId : aLId
				};
				programComboStore.load();

				progressionPanelFieldStore.getProxy().extraParams = {
					alId : academyLocationId
				}
				progressionPanelFieldStore.load();

				form.down('#periodId').setDisabled(true);

			},
			setDefaultAcademyLocation : function(){
				var this$ = this;
				var academyLocationIds;
				var accessibleLocations = new Array();
				var form = this$.getPromotionpanelsearch();
				var aLId = this$.getCurrentAcademyLocation();
				var store = form.down('#academyLocationId').getStore();
				store.load({
					callback: function(records, operation, success) {
						for(var i=0; i<records.length; i++){
							if(records[i].get('id')==aLId){
								form.down('#academyLocationId').setValue(records[i].get('id'));
							}
							accessibleLocations.push(records[i].get('id'));
						}
					}
				});
			},

			showPromotionAddCommiteeWindow: function() {
				var this$ = this;
				var formWindow = this$.getPromotionaddcommitteewindow();
				if (!formWindow) {
					Ext.widget('promotionaddcommitteewindow');
					formWindow = this$.getPromotionaddcommitteewindow();
				}

				formWindow.show();

			},

			onPromotionListCellClick: function(view, CellEl, ColIdx, record, RowEl, rowIndex, e,eopts){
				var this$ = this;
				var academyLocationId = this$.getCurrentAcademyLocation();
				var grid = view.up('grid');
				var columnName = grid.columnManager.columns[ColIdx].dataIndex;
				var portalInfo = Academia.model.authentication.StudentERPInfoModel;
				if(columnName=='studentCode'){
					if (e.target.tagName == 'A') {
						var userId = record.raw.studentId;
						var admissionId = record.data.admissionId;

						if (!isNullOrEmpty(userId)) {
							Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');

							var url = SERVERURL.PATH_FIND_STUDENT_DETAILS_BY_STUDENT_ID_AND_ADMISSION_ID ;
							var params = {
									id : userId ,
									admissionId : admissionId
							};
							this$.sendGetAjaxRequest(url, 'GET', params, function(option, success, response) {
								if(success){
									var data = Ext.decode(response.responseText);
									if(!isEmpty(data)){
										var tabTitle = record.get(columnName);
										var personId = data.person.id;//record.data.personId;
										var programBatchSeatTypeConfigId = null;//record.data.progBatchSeatConfigId;

										Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
										var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
										var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');

										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.PATH_FIND_STUDENT_JOURNEY_DASHBOARD_SETTING_BY_AL_ID,
											method : 'GET',
											params:{
												academyLocationId:academyLocationId ,
											},
											success: function(f, action) {
												var data = f.responseText;
												if(data == "true"){
													personController.addContentPanelTabWithSubTab("studentjourneystructureforcoreerp", tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);

												}else{
													personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
												}
											},
											failure: function(result, request) {
												showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
												return false;
											}
										});
										//personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
										var studentProfile = studentListController.getTabReferenceByTabTitle(tabTitle);
										if(!isNullOrEmpty(studentProfile)){
											var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');
											if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
												var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
												studentListController.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);
											}
										}
									}
								}
							});
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.BATCH_ID_BY_STUDENT_ID+'?studentId='+userId,
								method: 'GET',
								async: false,
								success: function(res, action) {
									var data = Ext.decode(res.responseText);
									if(!isEmpty(data)){
										portalInfo.set('admissionDetails',data[0].admissionDetails);
										portalInfo.set('student',data[0].student);
										portalInfo.set('userAacademyLocations',data[0].userAacademyLocations);
										portalInfo.set('programBatchDetails',data[0].programBatchDetails);
										portalInfo.set('pastProgramBatchDetails',data[0].pastProgramBatchDetails);
									}
									Ext.getBody().unmask();
								}
							});
						}

					}
				}
				else if(columnName=='viewDetails'){
					var formWindow = this$.getPromotionpanelviewdetailswindow();
					if (!formWindow) {
						Ext.widget('promotionpanelviewdetailswindow',{
							minIdx: 0,
							recordIdx: rowIndex,
							maxIdx: grid.getStore().getCount()-1
						});
						formWindow = this$.getPromotionpanelviewdetailswindow();
					}
					formWindow.show();
				}
			},

			getIdValueJson : function(id, value, code) {
				if (id)
					return {
					id : id,
					value : value,
					code : code
				};
			},
			addDecisionTemplateGridData: function(btn, btnValue) {
				var me = this;
				var formWindow=this.getPromotionpanelviewdetailswindow();
				var decisionTempleteRemarkGrid=formWindow.down('#decisionTempleteRemarkGrid');
				var currentCoursePeriodGrid = formWindow.down('#promotionPanelCurrentPeriodGrid');
				var spaField = formWindow.down('#spaDisplayBox');
				var projectedEarnedCreditField = formWindow.down('#usCreditDisplayBox');
				var projectedEarnedCreditFieldHtml = projectedEarnedCreditField.getEl().getHTML();
				var spaHtml = spaField.getEl().getHTML();
				var spa = spaHtml.match(/<b[^>]*>([\d.]+)<\/b>/)[1];
				var projectedEarnedCredit = projectedEarnedCreditFieldHtml.match(/<b[^>]*>([\d.]+)<\/b>/)[1];
				var projectedEctsCreditField = formWindow.down('#ectsCreditDisplayBox');
				var projectedEctsCreditFieldHtml = projectedEctsCreditField.getEl().getHTML();
				var projectedECTSCredit = projectedEctsCreditFieldHtml.match(/<b[^>]*>([\d.]+)<\/b>/)[1];
				var completeButtonStatus = formWindow.down('#completeButtonId').value;

				var promotionStatusId =decisionTempleteRemarkGrid.store.data.items[0].data.progressionStatus;
				var remark =decisionTempleteRemarkGrid.store.data.items[0].data.remark;
				var template = decisionTempleteRemarkGrid.store.data.items[0].data.template;
				var isReverted= decisionTempleteRemarkGrid.store.data.items[0].data.isReverted;
				var record=this.getPromotionpanellist().getStore().getAt(formWindow.recordIdx);
				var studentId=record.raw.studentId;
				var admissionId=record.raw.admissionId;
				var periodId = record.getData().periodId;
				var id=decisionTempleteRemarkGrid.store.data.items[0].data.id;
				var currentPeriodData = currentCoursePeriodGrid.getStore().data.items;
				var moderationData=[];
				var programBatchPeriodConfiguration={id:record.getData().periodId};

				var structure = me.getPromotionpanelstructure();
				var filterForm = structure.down('promotionpanelsearch');
				var progressionPanelId = filterForm.down('#progressionPanel').getValue();
				var marksheetJobCombo = formWindow.down('#marksheetJobField');
				if(isNullOrEmpty(remark)){
					remark = "-";
				}

				currentPeriodData.forEach(function(obj){
					moderationData.push({
						id:obj.data.moderateId,
						admissionId:obj.data.admissionId,
						moderateValue:obj.data.moderate,
						courseVariantId:obj.data.courseVariantId,
						desicionId:id,
						periodId:periodId,
					});
				});

				var model = new Academia.model.registrationsetup.DecisionTempleteRemarkGridModel();
				model.set("progressionStatusValue", promotionStatusId);
				model.set("remark",remark);
				model.set("studentId",this.getIdValueJson(studentId));
				model.set("admissionId",this.getIdValueJson(admissionId));
				if(!isNullOrEmpty(promotionStatusId) && !isNullOrEmpty(remark)){

					if(btnValue == "Drafted"){
						btn.setDisabled(true);
					}

					var myModel={
							progressionStatusValue:promotionStatusId,
							remark:remark,
							student:this.getIdValueJson(studentId),
							admission:this.getIdValueJson(admissionId),
							programBatchPeriodConfiguration:programBatchPeriodConfiguration,
							id:id,
							moderationData:moderationData,
							progressionValue:btnValue,
							template:template,
							committee:{
								id: progressionPanelId
							},
							projectedSpa:spa,
							projectedEarnedCredit:projectedEarnedCredit,
							projectedECTSCredit: projectedECTSCredit,
							completeButtonStatus:completeButtonStatus,
							marksheetJobDetails:{
								id: marksheetJobCombo.getValue()
							},
							isReverted:isReverted

					};

					var formData = Ext.encode(myModel);
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.PATH_SAVE_DECISION_TEMPLATE,
						method: 'POST',
						async: false,
						jsonData : formData,
						success: function(response,form, action) {
							Ext.getBody().unmask();
								showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
								var minIdx = formWindow.minIdx;
								var currentIdx = formWindow.recordIdx;
								var maxIdx = formWindow.maxIdx;
								
								formWindow.recordIdx = currentIdx;
								
								me.loadWinRecord(formWindow, minIdx, currentIdx, maxIdx,null,'SUBMITTED');
						}
					});
				}else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_FILL_DETAILS'));
				}
			},

			addDecisionTemplateGridDataSubmitted: function(btn, btnValue) {
				var me = this;

				var formWindow=this.getPromotionpanelviewdetailswindow();
				var grid = this.getPromotionpanellist();
				var decisionTempleteRemarkGrid=formWindow.down('#decisionTempleteRemarkGrid');
				var currentCoursePeriodGrid = formWindow.down('#promotionPanelCurrentPeriodGrid');
				var promotionStatusId =decisionTempleteRemarkGrid.store.data.items[0].data.progressionStatus;
				var remark =decisionTempleteRemarkGrid.store.data.items[0].data.remark;
				var isReverted=decisionTempleteRemarkGrid.store.data.items[0].data.isReverted;
				var record=this.getPromotionpanellist().getStore().getAt(formWindow.recordIdx);
				var template = decisionTempleteRemarkGrid.store.data.items[0].data.template;
				var studentId=record.raw.studentId;
				var admissionId=record.raw.admissionId;
				var periodId = record.getData().periodId;
				var batchId = record.getData().batchId;
				var academicTermId = record.getData().academicTermId;
				var programId = record.getData().programId;
				var id=decisionTempleteRemarkGrid.store.data.items[0].data.id;
				var currentPeriodData = currentCoursePeriodGrid.getStore().data.items;
				var moderationData=[];
				var examStudentSpecificCalculationModel;
				var studentModerationModelList =[];
				var courseVariantIdList=[];
				var programBatchPeriodConfiguration={id:record.getData().periodId};

				var structure = me.getPromotionpanelstructure();
				var filterForm = structure.down('promotionpanelsearch');
				var progressionPanelId = filterForm.down('#progressionPanel').getValue();
				var completeButtonStatus = formWindow.down('#completeButtonId').value;
				var spaField = formWindow.down('#spaDisplayBox');
				var projectedEarnedCreditField = formWindow.down('#usCreditDisplayBox');
				var projectedEarnedCreditFieldHtml = projectedEarnedCreditField.getEl().getHTML();
				var spaHtml = spaField.getEl().getHTML();
				var spa = spaHtml.match(/<b[^>]*>([\d.]+)<\/b>/)[1];
				var projectedEarnedCredit = projectedEarnedCreditFieldHtml.match(/<b[^>]*>([\d.]+)<\/b>/)[1];
				var projectedEctsCreditField = formWindow.down('#ectsCreditDisplayBox');
				var projectedEctsCreditFieldHtml = projectedEctsCreditField.getEl().getHTML();
				var projectedECTSCredit = projectedEctsCreditFieldHtml.match(/<b[^>]*>([\d.]+)<\/b>/)[1];

				var marksheetJobCombo = formWindow.down('#marksheetJobField');
				if(formWindow.down('#marksheetJobField').valueModels[0]){
					var marksheetPath = formWindow.down('#marksheetJobField').valueModels[0].raw.itemValue;
				}
				var marksheetJobId =  formWindow.down('#marksheetJobField').getValue();
				var promotionPanelGrid = this.getPromotionpanellist();
				var currentIdx = formWindow.recordIdx;
				var record = promotionPanelGrid.getStore().getAt(currentIdx);

				if(isNullOrEmpty(marksheetJobCombo.getValue())){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MARKSHEET_JOB_IS_REQUIRED_TO_SELECT'));
					return false;
				}

				/*if(record.raw.marksheetJobId != marksheetJobCombo.getValue()){
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MARKSHEET_JOB_IS_REQUIRED_TO_SAVE'));
			return false;
		}*/

				currentPeriodData.forEach(function(obj){
					moderationData.push({
						id:obj.data.moderateId,
						admissionId:obj.data.admissionId,
						moderateValue:obj.data.moderate,
						courseVariantId:obj.data.courseVariantId,
						desicionId:id,
						periodId:periodId,
					});
					courseVariantIdList.push(
							obj.data.courseVariantId
					);
				});

				currentPeriodData.forEach(function(obj){
					studentModerationModelList.push({
						courseVariantId:obj.data.courseVariantId,
						moderationPoints:obj.data.moderate,
						moderationReason:"From Promotion Panel",
						status:""
					});
				});


				examStudentSpecificCalculationModel={
						studentId:record.getData().studentId,
						admissionId:record.getData().admissionId,
						periodId:record.getData().periodId,
						courseVariantIdList:courseVariantIdList,
						studentModerationModelList:studentModerationModelList
				};

				if(isNullOrEmpty(remark)){
					remark = "-";
				}

				var saveAsDraftBtn = formWindow.down('#saveAsDraftBtn');

				if(!isNullOrEmpty(promotionStatusId) && !isNullOrEmpty(remark)){
					var decision={
							progressionStatusValue:promotionStatusId,
							remark:remark,
							student:this.getIdValueJson(studentId),
							admission:this.getIdValueJson(admissionId),
							programBatchPeriodConfiguration:programBatchPeriodConfiguration,
							id:id,
							moderationData:moderationData,
							progressionValue:btnValue,
							template:template,
							committee:{
								id: progressionPanelId
							},
							completeButtonStatus:completeButtonStatus,
							projectedSpa:spa,
							projectedEarnedCredit:projectedEarnedCredit,
							projectedECTSCredit: projectedECTSCredit,
							marksheetJobDetails:{
								id: marksheetJobCombo.getValue()
							},
							isReverted:isReverted
					};

					var promotionPanelModel={
							studentId:studentId,
							admissionId:admissionId,
							periodId:periodId,
							programId:programId,
							batchId:batchId,
							academicTermId:academicTermId,
							marksheetJobId:marksheetJobId,
							marksheetPath:marksheetPath,
							examStudentSpecificCalculationModel:examStudentSpecificCalculationModel,
							decision:decision
					};

					//----

					saveAsDraftBtn.setDisabled(true);

					var formData = Ext.encode(promotionPanelModel);
					//formWindow.body.mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					me.applyWindowMask();
					setTimeout(function() {
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_SAVE_PROGRESSION_PANEL,
							method: 'POST',
							async: false,
							jsonData : formData,
							success: function(response,form, action) {
								if(response.responseText){
							var response = Ext.decode(response.responseText);
								me.hideWindowMask();
								me.hideWindowMask();
								if(response.message == "STUDENT_IS_NOT_ELIGIBLE_FOR_PROMOTION"){
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STUDENT_IS_NOT_ELIGIBLE_FOR_PROMOTION'));
								}
								else if(response.message=="SUCCESS"){
									var minIdx = formWindow.minIdx;
									var currentIdx = formWindow.recordIdx;
									var maxIdx = formWindow.maxIdx;

									formWindow.recordIdx = currentIdx;
									isSubmittedForm=true;
									me.loadWinRecord(formWindow, minIdx, currentIdx, maxIdx,'','SUBMITTED');
									showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
								}
								else if(response.message=="COMPLETION_SETTING_NOT_DONE"){
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COMPLETION_SETTING_NOT_DONE'));
								}
								else if(response.message=="MARKSHEET_OR_PUBLISH_FAILURE"){
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MARKSHEET_OR_PUBLISH_FAILURE'));
								}
								else if(response.message=="SGPA_CGPA_CALCULATION_FAILURE"){
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SGPA_CGPA_CALCULATION_FAILURE'));
								}
								else if(response.message=="RESULT_CALCULATION_FAILURE"){
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('RESULT_CALCULATION_FAILURE'));
								}
								else if(response.message=="MODERATION_FAILURE"){
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MODERATION_FAILURE'));
								}
								else if(response.message=="PARAM_MISMATCH"){
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PARAM_MISMATCH'));
								}
								else if(response.message=="STUDENT_IS_NOT_ELIGIBLE_FOR_PASS_OUT"){
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STUDENT_IS_NOT_ELIGIBLE_FOR_PASS_OUT'));
								}
								else{
									showWarningMessage(getCommonTranslation('ALERT'),response.responseText);
								}
								formWindow.body.unmask();


							}}
						});
					},500);

					//---
				}
				else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_FILL_DETAILS'));
				}
			},

			verifyEmailPreviewOnSubmit: function(btn, makeCallBack) {
				var $this = this;
				var formWindow = btn.up('window');

				var promotionPanelGrid = this.getPromotionpanellist();
				var currentIdx = formWindow.recordIdx;
				var record = promotionPanelGrid.getStore().getAt(currentIdx);

				var admissionId = record.raw.admissionId;
				var studentId = record.raw.studentId;
				var periodId = record.raw.periodId;
				var programId = record.raw.programId;
				var batchId = record.raw.batchId;
				var academicTermId = record.raw.academicTermId;
				var marksheetJobId =  formWindow.down('#marksheetJobField').getValue();
				var marksheetPath = formWindow.down('#marksheetJobField').valueModels[0].raw.itemValue;
				var decisionTempleteRemarkGrid=formWindow.down('#decisionTempleteRemarkGrid');
				var decisionTempleteRemarkGridStore = decisionTempleteRemarkGrid.getStore();
				var decisionRecord = decisionTempleteRemarkGridStore.data.items[0].data.progressionStatus;
				var remarkRecord = decisionTempleteRemarkGridStore.data.items[0].data.remark;
				var decisionCode = decisionTempleteRemarkGridStore.data.items[0].data.template;
				var studentCacheRecord = Ext.Array.findBy(tempArrayProgressionData, function(item) {
				    return item.studentId === studentId;
				});
					var promotionPanelGridDecision = studentCacheRecord.decision;
				var promotionPanelGridRemark = studentCacheRecord.remark;
				if(isNullOrEmpty(marksheetJobId)){
					marksheetJobId = formWindow.down('#marksheetJobField').getValue();
					record.raw.marksheetJobId = marksheetJobId;
				}

				if(isNullOrEmpty(formWindow.down('#marksheetJobField').getValue())){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MARKSHEET_JOB_IS_REQUIRED_TO_SELECT_FOR_PREVIEWING'));
					$this.hideWindowMask();
					return false;
				}

				// For Email Template Preview
				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.PATH_EMAIL_CONTENT_PREVIEW,
					params: {
						admissionId: admissionId,
						studentId:studentId,
						periodId: periodId,
						programId: programId,
						batchId: batchId,
						academicTermId:academicTermId,
						decisionCode:decisionCode,
						marksheetJobId:marksheetJobId
					},
					method: 'GET',
					success: function (res, action) {
						var responseTxt = res.responseText;
						if (responseTxt != '') {
							var resp = Ext.decode(responseTxt);
							var sujectLine = resp.subjectLine;
							var systemGeneratedMsgContent = resp.systemGeneratedMsgContent;
							var userGeneratedMsgContent = resp.userGeneratedMsgContent;
							var finalMsgContent = systemGeneratedMsgContent || userGeneratedMsgContent;

							// Encode the selected content
							var encodedMsg = btoa(unescape(encodeURIComponent(finalMsgContent)));


							var data = {
									admissionId: admissionId,
									studentId: studentId,
									periodId: periodId,
									programId: programId,
									batchId: batchId,
									acdemicTermId: academicTermId,
									marksheetJobId: marksheetJobId,
									sujectLine: sujectLine,
									userGeneratedMsgContent: encodedMsg,
									marksheetPath: marksheetPath
							};

							var formData = Ext.encode(data);

							setTimeout(function() {
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.PATH_EMAIL_CONTENT_SAVE,
									method: 'POST',
									async: false,
									jsonData: formData,
									success: function(response, form, action) {
										makeCallBack(true);
									}
								});
							}, 1000);
						}
						else{
							makeCallBack(true);
						}
					}
				});
			},

			completePromotionPassout:function(btn, btnValue){
				var me = this;

				if(!me.isMsgContentSaved()){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DECISION_TEMPLATE_NOT_SAVED'));
					return false;
				}


				var formWindow=this.getPromotionpanelviewdetailswindow();
				var grid = this.getPromotionpanellist();
				var decisionTempleteRemarkGrid=formWindow.down('#decisionTempleteRemarkGrid');
				var currentCoursePeriodGrid = formWindow.down('#promotionPanelCurrentPeriodGrid');
				var promotionStatusId =decisionTempleteRemarkGrid.store.data.items[0].data.progressionStatus;
				var remark =decisionTempleteRemarkGrid.store.data.items[0].data.remark;
				var record=this.getPromotionpanellist().getStore().getAt(formWindow.recordIdx);
				var template = decisionTempleteRemarkGrid.store.data.items[0].data.template;
				var isReverted = decisionTempleteRemarkGrid.store.data.items[0].data.isReverted;
				var studentId=record.getData().studentId;
				var admissionId=record.getData().admissionId;
				var periodId = record.getData().periodId;
				var id=decisionTempleteRemarkGrid.store.data.items[0].data.id;
				var currentPeriodData = currentCoursePeriodGrid.getStore().data.items;
				var moderationData=[];
				var examStudentSpecificCalculationModel;
				var studentModerationModelList =[];
				var courseVariantIdList=[];
				var programBatchPeriodConfiguration={id:record.getData().periodId};
				var studentCacheRecord = Ext.Array.findBy(tempArrayProgressionData, function(item) {
				    return item.studentId === studentId;
				});
				var structure = me.getPromotionpanelstructure();
				var filterForm = structure.down('promotionpanelsearch');
				var progressionPanelId = filterForm.down('#progressionPanel').getValue();
				var completeButtonStatus = formWindow.down('#completeButtonId').getValue();
				var spaField = formWindow.down('#spaDisplayBox');
				var projectedEarnedCreditField = formWindow.down('#usCreditDisplayBox');
				var projectedEarnedCreditFieldHtml = projectedEarnedCreditField.getEl().getHTML();
				var spaHtml = spaField.getEl().getHTML();
				var spa = spaHtml.match(/<b[^>]*>([\d.]+)<\/b>/)[1];
				var projectedEarnedCredit = projectedEarnedCreditFieldHtml.match(/<b[^>]*>([\d.]+)<\/b>/)[1];
				var projectedEctsCreditField = formWindow.down('#ectsCreditDisplayBox');
				var projectedEctsCreditFieldHtml = projectedEctsCreditField.getEl().getHTML();
				var projectedECTSCredit = projectedEctsCreditFieldHtml.match(/<b[^>]*>([\d.]+)<\/b>/)[1];

				var marksheetJobCombo = formWindow.down('#marksheetJobField');
				var promotionPanelGrid = this.getPromotionpanellist();
				var currentIdx = formWindow.recordIdx;
				var record = promotionPanelGrid.getStore().getAt(currentIdx);

				var promotionPanelGridDecision =studentCacheRecord.decision;
				var promotionPanelGridRemark = studentCacheRecord.remark;
				var marksheetJobId = studentCacheRecord.marksheetjob;
				var decisionTempleteRemarkGridStore = decisionTempleteRemarkGrid.getStore();
				var decisionRecord = decisionTempleteRemarkGridStore.data.items[0].data.progressionStatus;
				var remarkRecord = decisionTempleteRemarkGridStore.data.items[0].data.remark;
				var sendProgressionBtn = formWindow.down('#sendProgressionBtn');

				if(isNullOrEmpty(decisionRecord)){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DECISION_IS_REQUIRED_TO_SELECT_FOR_PREVIEWING'));
					return false;
				}

				if(decisionRecord != promotionPanelGridDecision){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DECISION_IS_REQUIRED_TO_UPDATE_FOR_PREVIEWING'));
					return false;
				}

				if(isNullOrEmpty(remarkRecord)){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('REMARK_IS_REQUIRED_TO_SELECT_FOR_PREVIEWING'));
					return false;
				}

				if(remarkRecord != promotionPanelGridRemark){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('REMARK_IS_REQUIRED_TO_UPDATE_FOR_PREVIEWING'));
					return false;
				}

				if(isNullOrEmpty(marksheetJobCombo.getValue())){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MARKSHEET_JOB_IS_REQUIRED_TO_SELECT'));
					return false;
				}

				if(marksheetJobId != marksheetJobCombo.getValue()){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MARKSHEET_JOB_IS_REQUIRED_TO_SAVE'));
					return false;
				}

				currentPeriodData.forEach(function(obj){
					moderationData.push({
						id:obj.data.moderateId,
						admissionId:obj.data.admissionId,
						moderateValue:obj.data.moderate,
						courseVariantId:obj.data.courseVariantId,
						desicionId:id,
						periodId:periodId
					});
					courseVariantIdList.push(
							obj.data.courseVariantId
					);
				});

				currentPeriodData.forEach(function(obj){
					studentModerationModelList.push({
						courseVariantId:obj.data.courseVariantId,
						moderationPoints:obj.data.moderate,
						moderationReason:"From Promotion Panel",
						status:""
					});

				});

				examStudentSpecificCalculationModel={
						studentId:record.getData().studentId,
						admissionId:record.getData().admissionId,
						periodId:record.getData().periodId,
						courseVariantIdList:courseVariantIdList,
						studentModerationModelList:studentModerationModelList
				};

				if(isNullOrEmpty(remark)){
					remark = "-";
				}

				if(!isNullOrEmpty(promotionStatusId) && !isNullOrEmpty(remark)){
					var decision={
							progressionStatusValue:promotionStatusId,
							remark:remark,
							student:this.getIdValueJson(studentId),
							admission:this.getIdValueJson(admissionId),
							programBatchPeriodConfiguration:programBatchPeriodConfiguration,
							id:id,
							moderationData:moderationData,
							progressionValue:btnValue,
							template:template,
							committee:{
								id: progressionPanelId
							},
							completeButtonStatus:completeButtonStatus,
							projectedSpa:spa,
							projectedEarnedCredit:projectedEarnedCredit,
							projectedECTSCredit: projectedECTSCredit,
							isReverted:isReverted,
							marksheetJobDetails:{
								id: marksheetJobCombo.getValue()
							}
					};

					var promotionPanelModel={
							studentId:studentId,
							admissionId:admissionId,
							periodId:periodId,
							examStudentSpecificCalculationModel:examStudentSpecificCalculationModel,
							decision:decision
					};

					if(completeButtonStatus == 'SHOW_WITH_CONFIRMATION'){
						showConfirmMessage(getCommonTranslation('PROGRESSION_PANEL'), getProgramandcourseTranslation('PLEASE_CONFIRM_ONCE_AGAIN_DO_YOU_WANT_TO_COMPLETE_THE_PROGRESSION'), function(btnNew, text) {
							if (btnNew == 'yes') {
								var formData = Ext.encode(promotionPanelModel);
								//Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								me.applyWindowMask();
								setTimeout(function() {
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.PATH_COMPLETE_PROMOTION_PANEL,
										method: 'POST',
										async: false,
										jsonData : formData,
										success: function(response,form, action) {
											if(response.responseText){
												var response = Ext.decode(response.responseText);

												me.hideWindowMask();
												if(response.message == "STUDENT_IS_NOT_ELIGIBLE_FOR_PROMOTION"){
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STUDENT_IS_NOT_ELIGIBLE_FOR_PROMOTION'));
												}
												else if(response.message=="SUCCESS"){
													btn.setDisabled(true);
													btn.up('window').down('#saveAsDraftBtn').setDisabled(true);
													//btn.up('window').down('#submitBtn').setDisabled(true);
													var minIdx = formWindow.minIdx;
													var currentIdx = formWindow.recordIdx;
													var maxIdx = formWindow.maxIdx;

													formWindow.recordIdx = currentIdx;
													isSubmittedForm=true;
													var minIdx = formWindow.minIdx;
													var currentIdx = formWindow.recordIdx;
													var maxIdx = formWindow.maxIdx;

													formWindow.recordIdx = currentIdx;
													me.loadWinRecord(formWindow, minIdx, currentIdx, maxIdx, null,'SUBMITTED');
													showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));

												}

												else if(response.message=="COMPLETION_SETTING_NOT_DONE"){
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COMPLETION_SETTING_NOT_DONE'));
												}
												else if(response.message=="MARKSHEET_OR_PUBLISH_FAILURE"){
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MARKSHEET_OR_PUBLISH_FAILURE'));
												}
												else if(response.message=="SGPA_CGPA_CALCULATION_FAILURE"){
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SGPA_CGPA_CALCULATION_FAILURE'));
												}
												else if(response.message=="RESULT_CALCULATION_FAILURE"){
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('RESULT_CALCULATION_FAILURE'));
												}
												else if(response.message=="MODERATION_FAILURE"){
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MODERATION_FAILURE'));
												}
												else if (response.message == "LETTER_SENT_SUCCESSFULLY_NO_IMPACTS_ON_STUDENT_JOURNEY_PERIOD_TRANSITION") {
													btn.setDisabled(true);
													btn.up('window').down('#saveAsDraftBtn').setDisabled(true);
													isSubmittedForm=true;
													var minIdx = formWindow.minIdx;
													var currentIdx = formWindow.recordIdx;
													var maxIdx = formWindow.maxIdx;

													formWindow.recordIdx = currentIdx;
													me.loadWinRecord(formWindow, minIdx, currentIdx, maxIdx, null,'SUBMITTED');
													showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('LETTER_SENT_SUCCESSFULLY_NO_IMPACTS_ON_STUDENT_JOURNEY_PERIOD_TRANSITION'));


												}
												else if(response.message=="PARAM_MISMATCH"){
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PARAM_MISMATCH'));
												}
												else if(response.message=="PROGRESSION_PANEL_RECORD_NOT_FOUND_FOR_THE_UPDATION"){
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PROGRESSION_PANEL_RECORD_NOT_FOUND_FOR_THE_UPDATION'));
												}
												else if(response.message=="STUDENT_IS_NOT_ELIGIBLE_FOR_PASS_OUT"){
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STUDENT_IS_NOT_ELIGIBLE_FOR_PASS_OUT'));
												}
												else if(response.message=="LETTER_SENT_SUCCESSFULLY_STUDENT_IS_NOT_PROMOTED_DUE_TO_UPCOMING_TRANSFER_EXIST"){
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LETTER_SENT_SUCCESSFULLY_STUDENT_IS_NOT_PROMOTED_DUE_TO_UPCOMING_TRANSFER_EXIST'));
												}
												else{
													showWarningMessage(getCommonTranslation('ALERT'),response.responseText);
												}


												}
										}
									});
								},1000);
							}
						});
					}else{

						var formData = Ext.encode(promotionPanelModel);
						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						setTimeout(function() {
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.PATH_COMPLETE_PROMOTION_PANEL,
								method: 'POST',
								async: false,
								jsonData : formData,
								success: function(response,form, action) {
									if(response.responseText){
										var response = Ext.decode(response.responseText);

										Ext.getBody().unmask();
										if(response.message == "STUDENT_IS_NOT_ELIGIBLE_FOR_PROMOTION"){
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STUDENT_IS_NOT_ELIGIBLE_FOR_PROMOTION'));
										}
										else if(response.message=="SUCCESS"){
											btn.setDisabled(true);
											/*var promotionPanelPeriodGridStore = grid.getStore();
											promotionPanelPeriodGridStore.load({
												callback: function(){

												}
											});
	*/
											btn.up('window').down('#saveAsDraftBtn').setDisabled(true);
											//btn.up('window').down('#submitBtn').setDisabled(true);
											showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
											isSubmittedForm=true;
											var minIdx = formWindow.minIdx;
											var currentIdx = formWindow.recordIdx;
											var maxIdx = formWindow.maxIdx;

											formWindow.recordIdx = currentIdx;
											me.loadWinRecord(formWindow, minIdx, currentIdx, maxIdx, null,'SUBMITTED');
										}
										else if(response.message=="COMPLETION_SETTING_NOT_DONE"){
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COMPLETION_SETTING_NOT_DONE'));
										}
										else if(response.message=="MARKSHEET_OR_PUBLISH_FAILURE"){
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MARKSHEET_OR_PUBLISH_FAILURE'));
										}
										else if(response.message=="SGPA_CGPA_CALCULATION_FAILURE"){
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SGPA_CGPA_CALCULATION_FAILURE'));
										}
										else if(response.message=="RESULT_CALCULATION_FAILURE"){
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('RESULT_CALCULATION_FAILURE'));
										}
										else if(response.message=="MODERATION_FAILURE"){
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MODERATION_FAILURE'));
										}
										else if(response.message=="PARAM_MISMATCH"){
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PARAM_MISMATCH'));
										}
										else if(response.message=="STUDENT_IS_NOT_ELIGIBLE_FOR_PASS_OUT"){
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STUDENT_IS_NOT_ELIGIBLE_FOR_PASS_OUT'));
										}
										else if(response.message=="LETTER_SENT_SUCCESSFULLY_STUDENT_IS_NOT_PROMOTED_DUE_TO_UPCOMING_TRANSFER_EXIST"){
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LETTER_SENT_SUCCESSFULLY_STUDENT_IS_NOT_PROMOTED_DUE_TO_UPCOMING_TRANSFER_EXIST'));
										}
										else{
											showWarningMessage(getCommonTranslation('ALERT'),response.responseText);
										}

										//formWindow.close();
										formWindow.unmask();

									}
								}
							});
						},1000);
					}
				}else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_FILL_DETAILS'));
				}
			},

			sendProgressionLetter:function(btn, btnValue){
				var me = this;
				if(!me.isMsgContentSaved()){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DECISION_TEMPLATE_NOT_SAVED'));
					return false;
				}
				var formWindow=this.getPromotionpanelviewdetailswindow();
				var grid = this.getPromotionpanellist();
				var decisionTempleteRemarkGrid=formWindow.down('#decisionTempleteRemarkGrid');
				var currentCoursePeriodGrid = formWindow.down('#promotionPanelCurrentPeriodGrid');
				var promotionStatusId =decisionTempleteRemarkGrid.store.data.items[0].data.progressionStatus;
				var remark =decisionTempleteRemarkGrid.store.data.items[0].data.remark;
				var record=this.getPromotionpanellist().getStore().getAt(formWindow.recordIdx);
				var template = decisionTempleteRemarkGrid.store.data.items[0].data.template;
				var studentId=record.getData().studentId;
				var admissionId=record.getData().admissionId;
				var periodId = record.getData().periodId;
				var id=decisionTempleteRemarkGrid.store.data.items[0].data.id;
				var currentPeriodData = currentCoursePeriodGrid.getStore().data.items;
				var moderationData=[];
				var examStudentSpecificCalculationModel;
				var studentModerationModelList =[];
				var courseVariantIdList=[];
				var programBatchPeriodConfiguration={id:record.getData().periodId};

				var structure = me.getPromotionpanelstructure();
				var filterForm = structure.down('promotionpanelsearch');
				var progressionPanelId = filterForm.down('#progressionPanel').getValue();

				var marksheetJobCombo = formWindow.down('#marksheetJobField');
				var promotionPanelGrid = this.getPromotionpanellist();
				var currentIdx = formWindow.recordIdx;
				var record = promotionPanelGrid.getStore().getAt(currentIdx);

				var studentCacheRecord = Ext.Array.findBy(tempArrayProgressionData, function(item) {
				    return item.studentId === studentId;
				});

				var promotionPanelGridDecision =studentCacheRecord.decision;
				var promotionPanelGridRemark = studentCacheRecord.remark;
				var marksheetJobId = studentCacheRecord.marksheetjob;
				var decisionTempleteRemarkGridStore = decisionTempleteRemarkGrid.getStore();
				var decisionRecord = decisionTempleteRemarkGridStore.data.items[0].data.progressionStatus;
				var remarkRecord = decisionTempleteRemarkGridStore.data.items[0].data.remark;
				var completeButtonStatus = formWindow.down('#completeButtonId').value;
				var spaField = formWindow.down('#spaDisplayBox');
				var projectedEarnedCreditField = formWindow.down('#usCreditDisplayBox');
				var projectedEarnedCreditFieldHtml = projectedEarnedCreditField.getEl().getHTML();
				var spaHtml = spaField.getEl().getHTML();
				var spa = spaHtml.match(/<b[^>]*>([\d.]+)<\/b>/)[1];
				var projectedEarnedCredit = projectedEarnedCreditFieldHtml.match(/<b[^>]*>([\d.]+)<\/b>/)[1];
				var projectedEctsCreditField = formWindow.down('#ectsCreditDisplayBox');
				var projectedEctsCreditFieldHtml = projectedEctsCreditField.getEl().getHTML();
				var projectedECTSCredit = projectedEctsCreditFieldHtml.match(/<b[^>]*>([\d.]+)<\/b>/)[1];


				if(isNullOrEmpty(decisionRecord)){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DECISION_IS_REQUIRED_TO_SELECT_FOR_PREVIEWING'));
					return false;
				}

				if(decisionRecord != promotionPanelGridDecision){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DECISION_IS_REQUIRED_TO_UPDATE_FOR_PREVIEWING'));
					return false;
				}

				if(isNullOrEmpty(remarkRecord)){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('REMARK_IS_REQUIRED_TO_SELECT_FOR_PREVIEWING'));
					return false;
				}

				if(remarkRecord != promotionPanelGridRemark){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('REMARK_IS_REQUIRED_TO_UPDATE_FOR_PREVIEWING'));
					return false;
				}

				if(isNullOrEmpty(marksheetJobCombo.getValue())){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MARKSHEET_JOB_IS_REQUIRED_TO_SELECT'));
					return false;
				}

				if(marksheetJobId != marksheetJobCombo.getValue()){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MARKSHEET_JOB_IS_REQUIRED_TO_SAVE'));
					return false;
				}

				examStudentSpecificCalculationModel={
						studentId:record.getData().studentId,
						admissionId:record.getData().admissionId,
						periodId:record.getData().periodId,
						courseVariantIdList:courseVariantIdList,
						studentModerationModelList:studentModerationModelList
				};

				if(isNullOrEmpty(remark)){
					remark = "-";
				}

				if(!isNullOrEmpty(promotionStatusId) && !isNullOrEmpty(remark)){
					var decision={
							progressionStatusValue:promotionStatusId,
							remark:remark,
							student:this.getIdValueJson(studentId),
							admission:this.getIdValueJson(admissionId),
							programBatchPeriodConfiguration:programBatchPeriodConfiguration,
							id:id,
							moderationData:moderationData,
							progressionValue:btnValue,
							template:template,
							committee:{
								id: progressionPanelId
							},
							marksheetJobDetails:{
								id: marksheetJobCombo.getValue()
							},
							completeButtonStatus:completeButtonStatus,
							projectedSpa:spa,
							projectedEarnedCredit:projectedEarnedCredit,
							projectedECTSCredit: projectedECTSCredit
					};

					var promotionPanelModel={
							studentId:studentId,
							admissionId:admissionId,
							periodId:periodId,
							examStudentSpecificCalculationModel:examStudentSpecificCalculationModel,
							decision:decision
					};


					var formData = Ext.encode(promotionPanelModel);
					me.applyWindowMask();
					setTimeout(function() {
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_SEND_PROGRESSION_LETTER,
							method: 'POST',
							async: false,
							jsonData : formData,
							success: function(response,form, action) {
								if(response.responseText){
									var response = Ext.decode(response.responseText);

									me.hideWindowMask();
									if(response.message == "STUDENT_IS_NOT_ELIGIBLE_FOR_PROMOTION"){
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STUDENT_IS_NOT_ELIGIBLE_FOR_PROMOTION'));
									}
									else if(response.message=="SUCCESS"){
										btn.up('window').down('#complteBtn').setDisabled(true);
										btn.up('window').down('#saveAsDraftBtn').setDisabled(true);
										//btn.up('window').down('#submitBtn').setDisabled(true);
										showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
									}
									else if(response.message=="COMPLETION_SETTING_NOT_DONE"){
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COMPLETION_SETTING_NOT_DONE'));
									}
									else if(response.message=="MARKSHEET_OR_PUBLISH_FAILURE"){
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MARKSHEET_OR_PUBLISH_FAILURE'));
									}
									else if(response.message=="SELECTED_DECISION_IS_NOT_CORRECT"){
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECTED_DECISION_IS_NOT_CORRECT'));
									}
									else if(response.message=="PLEASE_SELECT_DECISION"){
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_FILL_DETAILS'));
									}
									else if(response.message=="PARAM_MISMATCH"){
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PARAM_MISMATCH'));
									}
									else if(response.message=="PROGRESSION_PANEL_RECORD_NOT_FOUND_FOR_THE_UPDATION"){
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PROGRESSION_PANEL_RECORD_NOT_FOUND_FOR_THE_UPDATION'));
									}
									else if(response.message=="STUDENT_IS_NOT_ELIGIBLE_FOR_PASS_OUT"){
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STUDENT_IS_NOT_ELIGIBLE_FOR_PASS_OUT'));
									}
									else{
										showWarningMessage(getCommonTranslation('ALERT'),response.responseText);
									}

									isSubmittedForm=true;
									var minIdx = formWindow.minIdx;
									var currentIdx = formWindow.recordIdx;
									var maxIdx = formWindow.maxIdx;

									formWindow.recordIdx = currentIdx;
									me.loadWinRecord(formWindow, minIdx, currentIdx, maxIdx, null,'SUBMITTED');

									formWindow.unmask();

									}
							}
						});
					},4000);
				}else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_FILL_DETAILS'));
				}
			},

			promotionAddCommitteSave:function() {
				var grid = this.getPromotionpanellist();
				var formWindow = this.getPromotionaddcommitteewindow();
				var commiteeId = formWindow.down('#committeId').getValue();
				var json=[];
				if (grid.getSelectionModel().getCount() > 0) {
					var records = grid.getSelectionModel().getSelection();
				}

				for(var i in records){
					var committee={
							"id":commiteeId
					};
					var participant={
							"id":records[i].data.studentId
					};
					json.push({
						"committee":committee,
						"participant":participant
					})
				}

				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				var	submitUrl=SERVERURL.PATH_ADD_TO_PANEL;
				Ext.Ajax.request({
					type : 'rest',
					url : submitUrl,
					jsonData : json,
					async: false,
					method : 'POST',
					success: function(response, form, action) {
						Ext.getBody().unmask();
						if (response.responseText == "SUCCESS") {
							showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('SUCCESS'));
						}
						else if (response.responseText == "PANEL_END_DATE_HAS_BEEN_PASSED") {
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PANEL_END_DATE_HAS_BEEN_PASSED'));
						}
						else if (response.responseText == "FAILURE") {
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FAILURE'));
						}

						formWindow.close();
					/*	var promotionPanelPeriodGridStore = grid.getStore();
						promotionPanelPeriodGridStore.load();
						grid.getSelectionModel().deselectAll();*/
						formWindow.unmask();
					}
				});
			},

			adddecisionTempleteRemarkGridRecord: function(serialNo,record){
				var me = this;
				var decisionTempleteRemarkGrid = me.getPromotionpanelviewdetailswindow().down('#decisionTempleteRemarkGrid');
				var ObjModel = [];
				if(serialNo == 1){
					var DecisionTempleteRemark = new Academia.model.registrationsetup.DecisionTempleteRemarkGridModel();
					DecisionTempleteRemark.set("serialNo", serialNo);
					DecisionTempleteRemark.set("progressionStatus", '');
					DecisionTempleteRemark.set("template", '');
					DecisionTempleteRemark.set("remark", '');
					DecisionTempleteRemark.commit();
					ObjModel.push(DecisionTempleteRemark);
					if(!decisionTempleteRemarkGrid.getStore().getCount()){
						decisionTempleteRemarkGrid.getStore().loadRawData(ObjModel, true);
					}
				}
			},

			loadWinRecord: function(win, minIdx, currentIdx, maxIdx, calledOnNextPrevious, makeCallBackForSendProgressionBtn){
				try{
					win.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');

					var me = this,
					 grid = me.getPromotionpanellist(),
					 structure = me.getPromotionpanelstructure(),
					 filterForm = structure.down('promotionpanelsearch'),
					 progressionPanelId = filterForm.down('#progressionPanel').getValue(),
					 record = grid.getStore().getAt(currentIdx),
					 prevBtn = win.down('#viewDetailsPrevBtnItemId'),
					 nextBtn = win.down('#viewDetailsNextBtnItemId'),
					 draftBtn = win.down('#saveAsDraftBtn'),
					 submitBtn = win.down('#submitBtn'),
					 completeBtn = win.down('#complteBtn'),
					 sendProgressionBtn = win.down('#sendProgressionBtn'),
					 regenerateLetterBtn = win.down('#regenerateLetterBtn'),
					 regenerateLetterVisible=false,
					 permissionsMap = me.getPROMOTION_PANEL_PERMISSIONS(),
					 associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					Ext.each(permissionList, function(privilege) {
						if (privilege === 'REGENERATE_LETTER') {
							if(!isNullOrEmpty(regenerateLetterBtn)){
								regenerateLetterVisible=true;
							}        		
						}
					});
					var academyLocationVal = record.raw.academyLocationName,
					 programVal = record.raw.programName,
					 academicTermVal = record.raw.academicTerm,
					 levelOfStudyVal = record.raw.periodName,
					 studentIdVal = record.raw.studentCode,
					 studentFirstNameVal = record.raw.firstName,
					 studentLastNameVal = record.raw.lastName,
					 studentEmailVal = record.raw.emailId,
					 enrollmentStatus = record.raw.enrollmentStatus,
					 studentPhotoVal = '',
					 personId = record.raw.personId,
					 admissionId = record.raw.admissionId,
					 batchId = record.raw.batchId,
					 programId = record.raw.programId,
					 periodId = record.raw.periodId,
					 marksheetJobId = record.raw.marksheetJobId,
					 isPreviewSaved = false,
					 marksheetJobCombo = win.down('#marksheetJobField'),
					 marksheetJobComboStore = marksheetJobCombo.getStore(),
					 params={
							admissionId:admissionId,
							periodId:periodId,
							programId:programId,
							batchId:batchId,
							studentId:record.raw.studentId,
							personId:personId,
							progressionPanelId:progressionPanelId
					},

					 studentHold = win.down('#studentHoldItemId'),
					 studentHoldStore = studentHold.getStore(),
					 learningAllowance = win.down('#learningAllowanceItemId'),
					 learningAllowanceStore = learningAllowance.getStore(),
					 previousProgressionLettersGrid =  win.down('#previousProgressionLettersGrid'),
					 previousProgressionLettersGridStore = previousProgressionLettersGrid.getStore(),
					 promotionPanelPeriodGrid = win.down('#promotionPanelPeriodGrid'),
					 promotionPanelPeriodGridStore = promotionPanelPeriodGrid.getStore(),
					 promotionPanelCurrentPeriodGrid = win.down('#promotionPanelCurrentPeriodGrid'),
					 promotionPanelCurrentPeriodGridStore = promotionPanelCurrentPeriodGrid.getStore(),
					 promotionPanelUpcommingPeriodGrid = win.down("#promotionPanelUpcommingPeriodGrid"),
					 promotionPanelUpcommingPeriodGridStore = promotionPanelUpcommingPeriodGrid.getStore(),
					 promotionPanelDocumentsAndNotesGrid = win.down('#promotionPanelDocumentsAndNotesGrid'),
					 promotionPanelDocumentsAndNotesGridStore = promotionPanelDocumentsAndNotesGrid.getStore(),
					 decisionTempleteRemarkGrid = win.down('#decisionTempleteRemarkGrid'),
					 decisionTempleteRemarkGridStore = decisionTempleteRemarkGrid.getStore();
					win.isCompleted = false;
					win.isSubmitted = false;
					var url;


					var minIdx = win.minIdx;
					var currentIdx = win.recordIdx;
					var maxIdx = win.maxIdx;

					if(currentIdx == minIdx){
						prevBtn.setDisabled(true);
					}
					else{
						prevBtn.setDisabled(false);
					}

					if(currentIdx == maxIdx){
						nextBtn.setDisabled(true);
					}
					else{
						nextBtn.setDisabled(false);
					}

					var studentId = record.raw.studentId;
					var programId = record.raw.programId;
					var admissionId = record.raw.admissionId;
					var periodId = record.raw.periodId;
					var studentCode = record.raw.studentCode;


					var totalStoreCount = grid.getStore().getTotalCount();
					var recIndex = grid.getSelectionModel().getSelection()[0].get('_originalIndex');
					var progressionStatusVal = record.data.progressionStatus;
					var formattedLastName = studentLastNameVal ? studentLastNameVal.toUpperCase() : '';
					var formattedFirstName = '';

					if (studentFirstNameVal) {
						var words = studentFirstNameVal.toLowerCase().split(' ');
						var formattedWords = [];

						Ext.each(words, function(word) {
							formattedWords.push(word.charAt(0).toUpperCase() + word.slice(1));
						});

						formattedFirstName = formattedWords.join(' ');
					}

					var fullName = (formattedLastName ? (formattedLastName + ' ') : '') + formattedFirstName;

					win.setTitle(studentCode + ' - ' + fullName + ' - ' + progressionStatusVal);

					calledOnNextPrevious = calledOnNextPrevious || false;
					if(!calledOnNextPrevious){
						win.down('#selectedCountTool').getEl().setHTML( recIndex + '/' + totalStoreCount );
					}
					var studentCacheRecord = Ext.Array.findBy(tempArrayProgressionData, function(item) {
					    return item.studentId === studentId;
					});
					if(!studentCacheRecord){
						if(!isNullOrEmpty(personId)){
						Ext.Ajax.request({
							type: 'rest',
							binary: true,
							url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId=' +personId,
							method: 'GET',
							success : function(response){
								if(response.responseBytes.length>0){
									var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
									 url = window.URL.createObjectURL(blob);
									win.down('#student_profile_image').getEl().dom.src=url;
								}
							}
						});
					}

					Ext.Ajax.request({
						url: SERVERURL.PATH_FIND_PROGRESSION_PANEL_ALL_GRID_DATA,
						method: 'GET',
						params: params,
						success: function (response) {
							// Optionally handle response here tempArrayProgressionData
							if(response.responseText){
								var responseData = Ext.decode(response.responseText);

								//marksheet job
								marksheetJobComboStore.loadData(responseData.findAllMarksheetJobSubLevel);
								if(!isNullOrEmpty(marksheetJobId)){
									marksheetJobCombo.setValue(marksheetJobId);
								}
								else{
									if(marksheetJobComboStore.getCount()){
										marksheetJobCombo.setValue(marksheetJobComboStore.data.items[0].data.id);
									}
								}
								//Hold Student
								if(responseData.findByAllHoldByStudentId && responseData.findByAllHoldByStudentId.length){
									studentHoldStore.loadData(responseData.findByAllHoldByStudentId);
									studentHold.show();
								}else{
									studentHold.hide();
								}
								//Learning allowance
								if(responseData.findLearningAllowance && responseData.findLearningAllowance.length){
									learningAllowanceStore.loadData(responseData.findLearningAllowance);
									learningAllowance.show();
								}else{
									learningAllowance.hide();
								}
								
								if(responseData.getProgressionPanelEmailHistory && responseData.getProgressionPanelEmailHistory.length){
									previousProgressionLettersGridStore.loadData(responseData.getProgressionPanelEmailHistory);
								}else{
									previousProgressionLettersGrid.hide();
								}
								promotionPanelPeriodGridStore.loadData(responseData.findAllPeriodLevelExamData);
								promotionPanelCurrentPeriodGridStore.loadData(responseData.findAllCurrentCourseData);
								me.calculateAndSetValues(win, promotionPanelCurrentPeriodGridStore.data.items);
								Ext.defer(function () {
									var checkbox = win.down('#showNonPassingCourses');

									if (checkbox && checkbox.getValue() === true && promotionPanelCurrentPeriodGrid && typeof promotionPanelCurrentPeriodGrid.applyNonPassingFilter === 'function') {
										promotionPanelCurrentPeriodGrid.getStore().clearFilter();
										promotionPanelCurrentPeriodGrid.applyNonPassingFilter();
									}
								}, 100);
								promotionPanelUpcommingPeriodGridStore.removeAll();
								promotionPanelUpcommingPeriodGridStore.loadData(responseData.getUpcommingPeriodStudentJourney);

								promotionPanelDocumentsAndNotesGridStore.loadData(responseData.documentsAndNotesData)
								Ext.defer(function() {
									var grid = promotionPanelDocumentsAndNotesGrid;
									var gridId = grid.getId();
									Ext.get(gridId + '_header_hd').el.dom.style.width = (grid.getWidth() - 20) + 'px';
									var leftPos = grid.up('window').el.dom.offsetLeft + 35;
									Ext.get(gridId + '_header_hd').el.dom.style.cssText+= 'left: 0px;';
									Ext.get(gridId + '_header_hd-textEl').el.dom.style.cssText+= 'margin-left: 0px !important';
								}, 350);
								// progression Details

								var decisionTempleteRemarkGrid = win.down('#decisionTempleteRemarkGrid');
								var decisionTempleteRemarkGridStore = decisionTempleteRemarkGrid.getStore();
								decisionTempleteRemarkGridStore.getProxy().extraParams = {
									studentId:studentId,
									admissionId:admissionId,
									periodId:periodId
								};

								decisionTempleteRemarkGridStore.load({
									callback: function(records, operation, success){
										if(records && records.length){
											tempArrayProgressionData.push({
												progressionData:responseData,
												studentId:studentId,
												decisionTempleteRemark:records,
												imageUrl:url,
												decision:records[0].data.progressionStatus,
												remark:records[0].data.remark,
												marksheetjob:records[0].data.marksheetjob
											});
										}else{
											tempArrayProgressionData.push({
												progressionData:responseData,
												studentId:studentId,
												decisionTempleteRemark:records,
												imageUrl:url
											});
										}


										var isCompleted = false,
										 isDrafted = false,
										 isSubmitted = false,
										 isReverted;
										if(decisionTempleteRemarkGridStore.data.items.length>0 && !isNullOrEmpty(decisionTempleteRemarkGridStore.data.items[0].data.isReverted) && decisionTempleteRemarkGridStore.data.items[0].data.isReverted)
											isReverted=true;
										else{
											isReverted=false;
										}
										var progressionStatusTextFieldVal = "Pending";
										if(decisionTempleteRemarkGridStore.getCount()){
											if(decisionTempleteRemarkGridStore.data.items[0].data.value=="Drafted"){
												isDrafted = true;
												progressionStatusTextFieldVal = "Drafted";
											}
											else if(decisionTempleteRemarkGridStore.data.items[0].data.value=="Submitted"){
												isSubmitted = true;
												progressionStatusTextFieldVal = "Submitted";
												var spaData = decisionTempleteRemarkGridStore.data.items[0].data.projectedSpa;
												var creditData = decisionTempleteRemarkGridStore.data.items[0].data.projectedEarnedCredit;
												var projectedECTSCredit = decisionTempleteRemarkGridStore.data.items[0].data.projectedECTSCredit;
											}
											else if(decisionTempleteRemarkGridStore.data.items[0].data.value=="Completed"){
												isCompleted = true;
												progressionStatusTextFieldVal = "Completed";
												var spaData = decisionTempleteRemarkGridStore.data.items[0].data.projectedSpa;
												var creditData = decisionTempleteRemarkGridStore.data.items[0].data.projectedEarnedCredit;
												var projectedECTSCredit = decisionTempleteRemarkGridStore.data.items[0].data.projectedECTSCredit;
											}

											if(!isNullOrEmpty(decisionTempleteRemarkGridStore.data.items[0].data.code)){
												var completeButtonStatus = decisionTempleteRemarkGridStore.data.items[0].data.code;
												win.down('#completeButtonId').setValue(completeButtonStatus);
												if(completeButtonStatus == 'DO_NOT_SHOW'){
													completeBtn.hide();
												}else{
													completeBtn.show();

												}
											}
											else{
												completeBtn.show();
												win.down('#completeButtonId').setValue("SHOW_WITH_CONFIRMATION");
											}
										}
										else{
											me.adddecisionTempleteRemarkGridRecord(1);
											win.down('#completeButtonId').setValue("SHOW_WITH_CONFIRMATION");
											if(completeButtonStatus == 'DO_NOT_SHOW'){
												completeBtn.hide();
											}else{
												completeBtn.show();
											}
											isCompleted = false;
										}
										win.isCompleted = isCompleted;
										win.isSubmitted = isSubmitted;
										promotionPanelCurrentPeriodGrid.getView().refresh();

										if(!isNullOrEmpty(responseData.findProgressionDetailsById)){
											var data = responseData.findProgressionDetailsById;
											var completeButtonCombo = win.down('#completeButtonId');

											if(!isEmpty(data)){
												if(!isNullOrEmpty(data.progressionCompleteBtnStatus)){
													completeButtonCombo.setValue(data.progressionCompleteBtnStatus);
												}
												win.panelData =data;
												var validFromDate = data.validFromDate; //"2025-01-15"
												var validTillDate = data.validTillDate; //"2025-01-21"

												var validFromDate = Ext.Date.parse(data.validFromDate, 'Y-m-d');  // "2025-01-15"
												var validTillDate = Ext.Date.parse(data.validTillDate, 'Y-m-d');  // "2025-01-21"
												var today = new Date(); // Current date

												today.setHours(0, 0, 0, 0);
												validFromDate.setHours(0, 0, 0, 0);
												validTillDate.setHours(0, 0, 0, 0);

												// Reset field style if within valid range
												if(!isNullOrEmpty(enrollmentStatus) && enrollmentStatus==='Completed'){
													draftBtn.setDisabled(true);
													//submitBtn.setDisabled(true);
													completeBtn.setDisabled(true);
													if (today < validFromDate) {
														sendProgressionBtn.hide();
													}
													else if (!(today >= validFromDate && today <= validTillDate)) {
														sendProgressionBtn.hide();

													}
													else if(isReverted){
														if (!(today >= validFromDate && today <= validTillDate)) {
															draftBtn.setDisabled(true);
															submitBtn.setDisabled(true);
															completeBtn.setDisabled(true);
															sendProgressionBtn.hide();
															regenerateLetterBtn.hide();
														}
														else if (isSubmitted) {
															draftBtn.setDisabled(true);
															submitBtn.setDisabled(false);
															completeBtn.setDisabled(false);
															sendProgressionBtn.hide();
															if (!isNullOrEmpty(regenerateLetterBtn) && regenerateLetterVisible) {
																regenerateLetterBtn.show();
															}
														}
														else if (isCompleted) {
															draftBtn.setDisabled(true);
															//submitBtn.setDisabled(true);
															completeBtn.setDisabled(true);
															sendProgressionBtn.show();
															regenerateLetterBtn.hide();
														}
														else {
															draftBtn.setDisabled(false);
															submitBtn.setDisabled(false);
															completeBtn.setDisabled(true);
															sendProgressionBtn.hide();
															regenerateLetterBtn.hide();
														}

													}
													else{
														draftBtn.setDisabled(true);
														//submitBtn.setDisabled(true);
														completeBtn.setDisabled(true);
														sendProgressionBtn.show();
														if(!isSubmitted){
															regenerateLetterBtn.hide();
														}
													}
												}
												else{

													if (today < validFromDate) {
														draftBtn.setDisabled(false);
														submitBtn.setDisabled(true);
														completeBtn.setDisabled(true);
														sendProgressionBtn.hide();
													}
													else if (!(today >= validFromDate && today <= validTillDate)) {
														draftBtn.setDisabled(true);
														submitBtn.setDisabled(true);
														completeBtn.setDisabled(true);
														sendProgressionBtn.hide();
														regenerateLetterBtn.hide();
														// Highlight the fields with red background
//														win.down('#panelStartDateField').setFieldStyle('background-color: #FFCCCC;');
//														win.down('#panelEndDate').setFieldStyle('background-color: #FFCCCC;');
													}
													/*else if(isDrafted){
														draftBtn.setDisabled(true);
														submitBtn.setDisabled(false);
														completeBtn.setDisabled(false);
													}*/
													else if(isSubmitted){
														draftBtn.setDisabled(true);
														submitBtn.setDisabled(false);
														completeBtn.setDisabled(false);
														sendProgressionBtn.hide();
														if(!isNullOrEmpty(regenerateLetterBtn) && regenerateLetterVisible){
															regenerateLetterBtn.show();
														}
													}
													else if(isCompleted){
														draftBtn.setDisabled(true);
														//submitBtn.setDisabled(true);
														completeBtn.setDisabled(true);
														sendProgressionBtn.hide();
														regenerateLetterBtn.hide();
													}
													else {
														// disable buttons
														draftBtn.setDisabled(false);
														submitBtn.setDisabled(false);
														completeBtn.setDisabled(true);
														sendProgressionBtn.hide();
														regenerateLetterBtn.hide();
													}
												}

												if(!isNullOrEmpty(data.progressionCompleteBtnStatus) && data.progressionCompleteBtnStatus == 'DO_NOT_SHOW'){
													completeBtn.hide();
												}
												if(!isNullOrEmpty(creditData)){
													win.down('#usCreditDisplayBox').update('<div style="text-align:center;font-size:13px;">Projected Semester Average: <b>' + creditData + '</b></div>');
												}
												if(!isNullOrEmpty(spaData)){
													win.down('#spaDisplayBox').update('<div style="text-align:center;font-size:13px;">Projected US Credit: <b>' + spaData + '</b></div>');
												}
												if(!isNullOrEmpty(projectedECTSCredit)){
													win.down('#ectsCreditDisplayBox').update('<div style="text-align:center;font-size:13px;">Projected ECTS Credit: <b>' + projectedECTSCredit + '</b></div>');
												}
											}
										}
										if (!isNullOrEmpty(makeCallBackForSendProgressionBtn)) {
											makeCallBackForSendProgressionBtn();
										}

										win.unmask();

									}

								});
							}
						},
						failure: function (response) {

						}
					});
				}else if(!isNullOrEmpty(makeCallBackForSendProgressionBtn) && makeCallBackForSendProgressionBtn=='SUBMITTED'){
					var responseData = studentCacheRecord.progressionData;
					promotionPanelCurrentPeriodGridStore.getProxy().extraParams = {
						admissionId:admissionId,
						periodId:periodId
					};
					promotionPanelCurrentPeriodGridStore.load({
						callback: function(records, operation, success) {
							if (success) {
								tempArrayProgressionData.forEach(function(rec){
									if(rec.studentId == studentId){
										rec.progressionData.findAllCurrentCourseData = records;
									}
								});

								// Calculate and set SPA and Projected Earned Credit
								me.calculateAndSetValues(win, records);

								Ext.defer(function () {
									var checkbox = win.down('#showNonPassingCourses');

									if (checkbox && checkbox.getValue() === true && promotionPanelCurrentPeriodGrid && typeof promotionPanelCurrentPeriodGrid.applyNonPassingFilter === 'function') {
										promotionPanelCurrentPeriodGrid.getStore().clearFilter();
										promotionPanelCurrentPeriodGrid.applyNonPassingFilter();
									}
								}, 100);
							} else {
								//console.error('Failed to load data for current period grid');
							}
						}
					});
					decisionTempleteRemarkGridStore.load({
						callback: function(records, operation, success){
							tempArrayProgressionData.forEach(function(rec){
								if(rec.studentId == studentId){
									rec.decisionTempleteRemark=records;
									rec.decision=records[0].data.progressionStatus;
									rec.remark=records[0].data.remark;
									rec.marksheetjob=records[0].data.marksheetjob;
								}
							});
							grid.decision
							var isCompleted = false,
							 isDrafted = false,
							 isSubmitted = false,
							 isReverted;
							if(decisionTempleteRemarkGridStore.data.items.length>0 && !isNullOrEmpty(decisionTempleteRemarkGridStore.data.items[0].data.isReverted) && decisionTempleteRemarkGridStore.data.items[0].data.isReverted)
								isReverted=true;
							else{
								isReverted=false;
							}
							var progressionStatusTextFieldVal = "Pending";
							if(decisionTempleteRemarkGridStore.getCount()){
								if(decisionTempleteRemarkGridStore.data.items[0].data.value=="Drafted"){
									isDrafted = true;
									progressionStatusTextFieldVal = "Drafted";
								}
								else if(decisionTempleteRemarkGridStore.data.items[0].data.value=="Submitted"){
									isSubmitted = true;
									progressionStatusTextFieldVal = "Submitted";
									var spaData = decisionTempleteRemarkGridStore.data.items[0].data.projectedSpa;
									var creditData = decisionTempleteRemarkGridStore.data.items[0].data.projectedEarnedCredit;
									var projectedECTSCredit = decisionTempleteRemarkGridStore.data.items[0].data.projectedECTSCredit;
								}
								else if(decisionTempleteRemarkGridStore.data.items[0].data.value=="Completed"){
									isCompleted = true;
									progressionStatusTextFieldVal = "Completed";
									var spaData = decisionTempleteRemarkGridStore.data.items[0].data.projectedSpa;
									var creditData = decisionTempleteRemarkGridStore.data.items[0].data.projectedEarnedCredit;
									var projectedECTSCredit = decisionTempleteRemarkGridStore.data.items[0].data.projectedECTSCredit;
								}

								if(!isNullOrEmpty(decisionTempleteRemarkGridStore.data.items[0].data.code)){
									var completeButtonStatus = decisionTempleteRemarkGridStore.data.items[0].data.code;
									win.down('#completeButtonId').setValue(completeButtonStatus);
									if(completeButtonStatus == 'DO_NOT_SHOW'){
										completeBtn.hide();
									}else{
										completeBtn.show();

									}
								}
								else{
									completeBtn.show();
									win.down('#completeButtonId').setValue("SHOW_WITH_CONFIRMATION");
								}
							}
							else{
								me.adddecisionTempleteRemarkGridRecord(1);
								win.down('#completeButtonId').setValue("SHOW_WITH_CONFIRMATION");
								if(completeButtonStatus == 'DO_NOT_SHOW'){
									completeBtn.hide();
								}else{
									completeBtn.show();
								}
								isCompleted = false;
							}
							win.setTitle(studentCode + ' - ' + fullName + ' - ' + progressionStatusTextFieldVal);
							win.isCompleted = isCompleted;
							win.isSubmitted = isSubmitted;
							promotionPanelCurrentPeriodGrid.getView().refresh();

							if(!isNullOrEmpty(responseData.findProgressionDetailsById)){
								var data = responseData.findProgressionDetailsById;
								var completeButtonCombo = win.down('#completeButtonId');

								if(!isEmpty(data)){
									if(!isNullOrEmpty(data.progressionCompleteBtnStatus)){
										completeButtonCombo.setValue(data.progressionCompleteBtnStatus);
									}
									win.panelData =data;
									var validFromDate = data.validFromDate; //"2025-01-15"
									var validTillDate = data.validTillDate; //"2025-01-21"

									var validFromDate = Ext.Date.parse(data.validFromDate, 'Y-m-d');  // "2025-01-15"
									var validTillDate = Ext.Date.parse(data.validTillDate, 'Y-m-d');  // "2025-01-21"
									var today = new Date(); // Current date

									today.setHours(0, 0, 0, 0);
									validFromDate.setHours(0, 0, 0, 0);
									validTillDate.setHours(0, 0, 0, 0);

									// Reset field style if within valid range
									if(!isNullOrEmpty(enrollmentStatus) && enrollmentStatus==='Completed'){
										draftBtn.setDisabled(true);
										//submitBtn.setDisabled(true);
										completeBtn.setDisabled(true);
										if (today < validFromDate) {
											sendProgressionBtn.hide();
										}
										else if (!(today >= validFromDate && today <= validTillDate)) {
											sendProgressionBtn.hide();

										}
										else if(isReverted){
											if (!(today >= validFromDate && today <= validTillDate)) {
												draftBtn.setDisabled(true);
												submitBtn.setDisabled(true);
												completeBtn.setDisabled(true);
												sendProgressionBtn.hide();
												regenerateLetterBtn.hide();
											}
											else if (isSubmitted) {
												draftBtn.setDisabled(true);
												submitBtn.setDisabled(false);
												completeBtn.setDisabled(false);
												sendProgressionBtn.hide();
												if (!isNullOrEmpty(regenerateLetterBtn) && regenerateLetterVisible) {
													regenerateLetterBtn.show();
												}
											}
											else if (isCompleted) {
												draftBtn.setDisabled(true);
												//submitBtn.setDisabled(true);
												completeBtn.setDisabled(true);
												sendProgressionBtn.show();
												regenerateLetterBtn.hide();
											}
											else {
												draftBtn.setDisabled(false);
												submitBtn.setDisabled(false);
												completeBtn.setDisabled(true);
												sendProgressionBtn.hide();
												regenerateLetterBtn.hide();
											}

										}
										else{
											draftBtn.setDisabled(true);
											//submitBtn.setDisabled(true);
											completeBtn.setDisabled(true);
											sendProgressionBtn.show();
											if(!isSubmitted){
												regenerateLetterBtn.hide();
											}
										}
									}
									else{

										if (today < validFromDate) {
											draftBtn.setDisabled(false);
											submitBtn.setDisabled(true);
											completeBtn.setDisabled(true);
											sendProgressionBtn.hide();
										}
										else if (!(today >= validFromDate && today <= validTillDate)) {
											draftBtn.setDisabled(true);
											submitBtn.setDisabled(true);
											completeBtn.setDisabled(true);
											sendProgressionBtn.hide();
											regenerateLetterBtn.hide();
											// Highlight the fields with red background
//											win.down('#panelStartDateField').setFieldStyle('background-color: #FFCCCC;');
//											win.down('#panelEndDate').setFieldStyle('background-color: #FFCCCC;');
										}
										/*else if(isDrafted){
											draftBtn.setDisabled(true);
											submitBtn.setDisabled(false);
											completeBtn.setDisabled(false);
										}*/
										else if(isSubmitted){
											draftBtn.setDisabled(true);
											submitBtn.setDisabled(false);
											completeBtn.setDisabled(false);
											sendProgressionBtn.hide();
											if(!isNullOrEmpty(regenerateLetterBtn) && regenerateLetterVisible){
												regenerateLetterBtn.show();
											}
										}
										else if(isCompleted){
											draftBtn.setDisabled(true);
											//submitBtn.setDisabled(true);
											completeBtn.setDisabled(true);
											sendProgressionBtn.hide();
											regenerateLetterBtn.hide();
										}
										else {
											// disable buttons
											draftBtn.setDisabled(false);
											submitBtn.setDisabled(false);
											completeBtn.setDisabled(true);
											sendProgressionBtn.hide();
											regenerateLetterBtn.hide();
										}
									}

									if(!isNullOrEmpty(data.progressionCompleteBtnStatus) && data.progressionCompleteBtnStatus == 'DO_NOT_SHOW'){
										completeBtn.hide();
									}
									if(!isNullOrEmpty(creditData)){
										win.down('#usCreditDisplayBox').update('<div style="text-align:center;font-size:13px;">Projected Semester Average: <b>' + creditData + '</b></div>');
									}
									if(!isNullOrEmpty(spaData)){
										win.down('#spaDisplayBox').update('<div style="text-align:center;font-size:13px;">Projected US Credit: <b>' + spaData + '</b></div>');
									}
									if(!isNullOrEmpty(projectedECTSCredit)){
										win.down('#ectsCreditDisplayBox').update('<div style="text-align:center;font-size:13px;">Projected ECTS Credit: <b>' + projectedECTSCredit + '</b></div>');
									}
								}
							}win.unmask();

						}

					});

				}else{
					win.down('#student_profile_image').getEl().dom.src=studentCacheRecord.imageUrl;

								var responseData = studentCacheRecord.progressionData;

								//marksheet job
								marksheetJobComboStore.loadData(responseData.findAllMarksheetJobSubLevel);
								if(!isNullOrEmpty(marksheetJobId)){
									marksheetJobCombo.setValue(marksheetJobId);
								}
								else{
									if(marksheetJobComboStore.getCount()){
										marksheetJobCombo.setValue(marksheetJobComboStore.data.items[0].data.id);
									}
								}
								//Hold Student
								if(responseData.findByAllHoldByStudentId && responseData.findByAllHoldByStudentId.length){
									studentHoldStore.loadData(responseData.findByAllHoldByStudentId);
									studentHold.show();
								}else{
									studentHold.hide();
								}
								//Learning allowance
								if(responseData.findLearningAllowance && responseData.findLearningAllowance.length){
									learningAllowanceStore.loadData(responseData.findLearningAllowance);
									learningAllowance.show();
								}else{
									learningAllowance.hide();
								}
								
								if(responseData.getProgressionPanelEmailHistory && responseData.getProgressionPanelEmailHistory.length){
									previousProgressionLettersGridStore.loadData(responseData.getProgressionPanelEmailHistory);
								}else{
									previousProgressionLettersGrid.hide();
								}
								promotionPanelPeriodGridStore.loadData(responseData.findAllPeriodLevelExamData);
								promotionPanelCurrentPeriodGridStore.loadData(responseData.findAllCurrentCourseData);
								me.calculateAndSetValues(win, promotionPanelCurrentPeriodGridStore.data.items);
								Ext.defer(function () {
									var checkbox = win.down('#showNonPassingCourses');

									if (checkbox && checkbox.getValue() === true && promotionPanelCurrentPeriodGrid && typeof promotionPanelCurrentPeriodGrid.applyNonPassingFilter === 'function') {
										promotionPanelCurrentPeriodGrid.getStore().clearFilter();
										promotionPanelCurrentPeriodGrid.applyNonPassingFilter();
									}
								}, 100);
								promotionPanelUpcommingPeriodGridStore.removeAll();
								promotionPanelUpcommingPeriodGridStore.loadData(responseData.getUpcommingPeriodStudentJourney);

								promotionPanelDocumentsAndNotesGridStore.loadData(responseData.documentsAndNotesData)
								Ext.defer(function() {
									var grid = promotionPanelDocumentsAndNotesGrid;
									var gridId = grid.getId();
									Ext.get(gridId + '_header_hd').el.dom.style.width = (grid.getWidth() - 20) + 'px';
									var leftPos = grid.up('window').el.dom.offsetLeft + 35;
									Ext.get(gridId + '_header_hd').el.dom.style.cssText+= 'left: 0px;';
									Ext.get(gridId + '_header_hd-textEl').el.dom.style.cssText+= 'margin-left: 0px !important';
								}, 350);
								// progression Details

								var decisionTempleteRemarkGrid = win.down('#decisionTempleteRemarkGrid');
								var decisionTempleteRemarkGridStore = decisionTempleteRemarkGrid.getStore();
								decisionTempleteRemarkGridStore.getProxy().extraParams = {
									studentId:studentId,
									admissionId:admissionId,
									periodId:periodId
								};

								decisionTempleteRemarkGridStore.loadData(studentCacheRecord.decisionTempleteRemark);
										var isCompleted = false,
										 isDrafted = false,
										 isSubmitted = false,
										 isReverted;
										if(decisionTempleteRemarkGridStore.data.items.length>0 && !isNullOrEmpty(decisionTempleteRemarkGridStore.data.items[0].data.isReverted) && decisionTempleteRemarkGridStore.data.items[0].data.isReverted)
											isReverted=true;
										else{
											isReverted=false;
										}
										var progressionStatusTextFieldVal = "Pending";
										if(decisionTempleteRemarkGridStore.getCount()){
											if(decisionTempleteRemarkGridStore.data.items[0].data.value=="Drafted"){
												isDrafted = true;
												progressionStatusTextFieldVal = "Drafted";
											}
											else if(decisionTempleteRemarkGridStore.data.items[0].data.value=="Submitted"){
												isSubmitted = true;
												progressionStatusTextFieldVal = "Submitted";
												var spaData = decisionTempleteRemarkGridStore.data.items[0].data.projectedSpa;
												var creditData = decisionTempleteRemarkGridStore.data.items[0].data.projectedEarnedCredit;
												var projectedECTSCredit = decisionTempleteRemarkGridStore.data.items[0].data.projectedECTSCredit;
											}
											else if(decisionTempleteRemarkGridStore.data.items[0].data.value=="Completed"){
												isCompleted = true;
												progressionStatusTextFieldVal = "Completed";
												var spaData = decisionTempleteRemarkGridStore.data.items[0].data.projectedSpa;
												var creditData = decisionTempleteRemarkGridStore.data.items[0].data.projectedEarnedCredit;
												var projectedECTSCredit = decisionTempleteRemarkGridStore.data.items[0].data.projectedECTSCredit;
											}

											if(!isNullOrEmpty(decisionTempleteRemarkGridStore.data.items[0].data.code)){
												var completeButtonStatus = decisionTempleteRemarkGridStore.data.items[0].data.code;
												win.down('#completeButtonId').setValue(completeButtonStatus);
												if(completeButtonStatus == 'DO_NOT_SHOW'){
													completeBtn.hide();
												}else{
													completeBtn.show();

												}
											}
											else{
												completeBtn.show();
												win.down('#completeButtonId').setValue("SHOW_WITH_CONFIRMATION");
											}
										}
										else{
											me.adddecisionTempleteRemarkGridRecord(1);
											win.down('#completeButtonId').setValue("SHOW_WITH_CONFIRMATION");
											if(completeButtonStatus == 'DO_NOT_SHOW'){
												completeBtn.hide();
											}else{
												completeBtn.show();
											}
											isCompleted = false;
										}
										win.setTitle(studentCode + ' - ' + fullName + ' - ' + progressionStatusTextFieldVal);
										win.isCompleted = isCompleted;
										win.isSubmitted = isSubmitted;
										promotionPanelCurrentPeriodGrid.getView().refresh();

										if(!isNullOrEmpty(responseData.findProgressionDetailsById)){
											var data = responseData.findProgressionDetailsById;
											var completeButtonCombo = win.down('#completeButtonId');

											if(!isEmpty(data)){
												if(!isNullOrEmpty(data.progressionCompleteBtnStatus)){
													completeButtonCombo.setValue(data.progressionCompleteBtnStatus);
												}
												win.panelData =data;
												var validFromDate = data.validFromDate; //"2025-01-15"
												var validTillDate = data.validTillDate; //"2025-01-21"

												var validFromDate = Ext.Date.parse(data.validFromDate, 'Y-m-d');  // "2025-01-15"
												var validTillDate = Ext.Date.parse(data.validTillDate, 'Y-m-d');  // "2025-01-21"
												var today = new Date(); // Current date

												today.setHours(0, 0, 0, 0);
												validFromDate.setHours(0, 0, 0, 0);
												validTillDate.setHours(0, 0, 0, 0);

												// Reset field style if within valid range
												if(!isNullOrEmpty(enrollmentStatus) && enrollmentStatus==='Completed'){
													draftBtn.setDisabled(true);
													//submitBtn.setDisabled(true);
													completeBtn.setDisabled(true);
													if (today < validFromDate) {
														sendProgressionBtn.hide();
													}
													else if (!(today >= validFromDate && today <= validTillDate)) {
														sendProgressionBtn.hide();

													}
													else if(isReverted){
														if (!(today >= validFromDate && today <= validTillDate)) {
															draftBtn.setDisabled(true);
															submitBtn.setDisabled(true);
															completeBtn.setDisabled(true);
															sendProgressionBtn.hide();
															regenerateLetterBtn.hide();
														}
														else if (isSubmitted) {
															draftBtn.setDisabled(true);
															submitBtn.setDisabled(false);
															completeBtn.setDisabled(false);
															sendProgressionBtn.hide();
															if (!isNullOrEmpty(regenerateLetterBtn) && regenerateLetterVisible) {
																regenerateLetterBtn.show();
															}
														}
														else if (isCompleted) {
															draftBtn.setDisabled(true);
															//submitBtn.setDisabled(true);
															completeBtn.setDisabled(true);
															sendProgressionBtn.show();
															regenerateLetterBtn.hide();
														}
														else {
															draftBtn.setDisabled(false);
															submitBtn.setDisabled(false);
															completeBtn.setDisabled(true);
															sendProgressionBtn.hide();
															regenerateLetterBtn.hide();
														}

													}
													else{
														draftBtn.setDisabled(true);
														//submitBtn.setDisabled(true);
														completeBtn.setDisabled(true);
														sendProgressionBtn.show();
														if(!isSubmitted){
															regenerateLetterBtn.hide();
														}
													}
												}
												else{

													if (today < validFromDate) {
														draftBtn.setDisabled(false);
														submitBtn.setDisabled(true);
														completeBtn.setDisabled(true);
														sendProgressionBtn.hide();
													}
													else if (!(today >= validFromDate && today <= validTillDate)) {
														draftBtn.setDisabled(true);
														submitBtn.setDisabled(true);
														completeBtn.setDisabled(true);
														sendProgressionBtn.hide();
														regenerateLetterBtn.hide();
														// Highlight the fields with red background
//														win.down('#panelStartDateField').setFieldStyle('background-color: #FFCCCC;');
//														win.down('#panelEndDate').setFieldStyle('background-color: #FFCCCC;');
													}
													/*else if(isDrafted){
														draftBtn.setDisabled(true);
														submitBtn.setDisabled(false);
														completeBtn.setDisabled(false);
													}*/
													else if(isSubmitted){
														draftBtn.setDisabled(true);
														submitBtn.setDisabled(false);
														completeBtn.setDisabled(false);
														sendProgressionBtn.hide();
														if(!isNullOrEmpty(regenerateLetterBtn) && regenerateLetterVisible){
															regenerateLetterBtn.show();
														}
													}
													else if(isCompleted){
														draftBtn.setDisabled(true);
														//submitBtn.setDisabled(true);
														completeBtn.setDisabled(true);
														sendProgressionBtn.hide();
														regenerateLetterBtn.hide();
													}
													else {
														// disable buttons
														draftBtn.setDisabled(false);
														submitBtn.setDisabled(false);
														completeBtn.setDisabled(true);
														sendProgressionBtn.hide();
														regenerateLetterBtn.hide();
													}
												}

												if(!isNullOrEmpty(data.progressionCompleteBtnStatus) && data.progressionCompleteBtnStatus == 'DO_NOT_SHOW'){
													completeBtn.hide();
												}
												if(!isNullOrEmpty(creditData)){
													win.down('#usCreditDisplayBox').update('<div style="text-align:center;font-size:13px;">Projected Semester Average: <b>' + creditData + '</b></div>');
												}
												if(!isNullOrEmpty(spaData)){
													win.down('#spaDisplayBox').update('<div style="text-align:center;font-size:13px;">Projected US Credit: <b>' + spaData + '</b></div>');
												}
												if(!isNullOrEmpty(projectedECTSCredit)){
													win.down('#ectsCreditDisplayBox').update('<div style="text-align:center;font-size:13px;">Projected ECTS Credit: <b>' + projectedECTSCredit + '</b></div>');
												}
											}
										}
										if (!isNullOrEmpty(makeCallBackForSendProgressionBtn)) {
											makeCallBackForSendProgressionBtn();
										}

										win.unmask();
				}

				}
				catch(e){
					win.unmask();
				}
			},

			isMsgContentSaved: function(){
				var me = this;

				var formWindow = this.getPromotionpanelviewdetailswindow();
				var decisionTempleteRemarkGrid=formWindow.down('#decisionTempleteRemarkGrid');
				var decisionTempleteRemarkGridStore = decisionTempleteRemarkGrid.getStore();
				var decisionRecord = decisionTempleteRemarkGridStore.data.items[0].data.progressionStatus;

				var progressionStatus = decisionTempleteRemarkGridStore.data.items[0].data.progressionStatus;
				var decisionTemplate = decisionTempleteRemarkGridStore.data.items[0].data.template;

				var decisionsToCheck = ['Proceed','Proceed with condition',"Resit",'Retake','Fail','Partial Resit','Partial Validation','Proceed - Program Completion',
					'Promote','Deferred Retake','Deferred Resit','Deferred'
					];

				if(Ext.Array.contains(decisionsToCheck, progressionStatus)){
					var currentIdx = formWindow.recordIdx;
					var grid = me.getPromotionpanellist();
					var record = grid.getStore().getAt(currentIdx);

					var admissionId = record.raw.admissionId;
					var studentId = record.raw.studentId;
					var periodId = record.raw.periodId;
					var programId = record.raw.programId;
					var batchId = record.raw.batchId;
					var academicTermId = record.raw.academicTermId;
					var progressionStatusCode = progressionStatus;

					var isSaved = false;

					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.CHECK_EMAIL_CONTENT_PREVIEW_SAVE,
						params: {
							admissionId: admissionId,
							studentId:studentId,
							periodId: periodId,
							programId: programId,
							batchId: batchId,
							academicTermId:academicTermId,
							status:progressionStatusCode
						},
						method: 'GET',
						async: false,
						success: function (res, action) {
							var responseTxt = Ext.decode(res.responseText);
							if (responseTxt != '') {
								isSaved = responseTxt;
							}
							else{
								//error here
							}
						}
					});

					return isSaved;
				}
				else{
					return true;
				}
			},

			resetPromotionPanelList: function(){
				var me = this;
				var structure = me.getPromotionpanelstructure();

				var filterForm = structure.down('promotionpanelsearch');
				var resultGrid = structure.down('promotionpanellist');

				var addToPanelBtn = resultGrid.down('#addToPanelBtnId');
				var detailedViewBtn = resultGrid.down('#detailedViewId');

				var resultGridStore = resultGrid.getStore();

				addToPanelBtn.setDisabled(true);
				detailedViewBtn.setDisabled(true);
				if(resultGridStore.getCount()){
					resultGridStore.removeAll();
				}
			},

			// Function to calculate and set values
			calculateAndSetValues: function(win, records, editedModerateValue, selectedRecord) {
			var totalUsCredits = 0;
	        var totalEctsCredit = 0;

	        var totalWeightedMarks = 0;
	        var computedUsEarnedCredit = 0;
	        var computedEctsEarnedCredit = 0;

	        // Ensure that the selectedRecord exists and necessary fields are available
	        if (!selectedRecord || !selectedRecord.get) {
	            selectedRecord = null;
	        }

	        Ext.each(records, function(record) {

	        	if(!isNullOrEmpty(record.get('grade')) && !isNullOrEmpty(record.get('status'))){
					var grd =record.get('grade');
					var sts = record.get('status');

					if((grd=='DG' || grd=='I') && sts=='Pending')
						return;
				}

	            var usCredit = record.get('courseCredit');
	            var ectsCredit = record.raw.ectsCredits;

	            var effectiveMarks = parseFloat(record.get('effectiveMarks') || 0);

	            var moderateMarks = (record === selectedRecord) ? editedModerateValue : parseFloat(record.get('moderate') || 0);

	            if (isNaN(moderateMarks)) {
	                moderateMarks = 0;
	            }

				var moderateMarksDone = 0;

				if(record.get('moderationDone') == true){
					moderateMarksDone = moderateMarks;
				}


	            var finalMarks = effectiveMarks + moderateMarks - moderateMarksDone;

	            totalUsCredits += usCredit;
	            totalEctsCredit +=ectsCredit;

				if (finalMarks == 0) {
					usCredit = 0;
					ectsCredit = 0;
				   }
	            totalWeightedMarks += usCredit * finalMarks;


	            var minMarksOrGrade = parseFloat(record.get('minMarksOrGrade'));

	            if (finalMarks >= minMarksOrGrade) {
	                computedUsEarnedCredit += usCredit;
	                computedEctsEarnedCredit += ectsCredit;
	            }
	        });

	        // Compute SPA (Weighted Grade Points)
	        var spa = (totalUsCredits === 0) ? 0 : (totalWeightedMarks / totalUsCredits);

	        // Set computed values to the fields
	        var spaField = win.down('#spaDisplayBox');
	        var projectedUsCreditField = win.down('#usCreditDisplayBox');
	        var projectedEarnedCreditField = win.down('#ectsCreditDisplayBox');

	        if (spaField) {
	            spaField.getEl().setHTML('<div style="padding-top:5px; text-align:center;font-size:13px;font-family:Arial, sans-serif;">Projected Semester Average: <b style="color:#1E1E1E;">' + spa.toFixed(2) + '</b></div>'); // Round SPA to 2 decimal places
	        }

	        if (projectedUsCreditField) {
	        	projectedUsCreditField.getEl().setHTML('<div style="padding-top:5px; text-align:center;font-size:13px;font-family:Arial, sans-serif;">Projected US Credit: <b style="color:#1E1E1E;">' + computedUsEarnedCredit.toFixed(2) + '</b></div>');
	        }

	        if (projectedEarnedCreditField) {
	            projectedEarnedCreditField.getEl().setHTML('<div style="padding-top:5px; text-align:center;font-size:13px;font-family:Arial, sans-serif;">Projected ECTS Credit: <b style="color:#1E1E1E;">' + computedEctsEarnedCredit.toFixed(2) + '</b></div>'); // Round Credit to 2 decimal places
	        }
	        },

			handleEmailMarksheetPreviewClick: function(btn) {
				var $this = this;
				var formWindow = btn.up('window');

				var promotionPanelGrid = this.getPromotionpanellist();
				var currentIdx = formWindow.recordIdx;
				var record = promotionPanelGrid.getStore().getAt(currentIdx);

				var admissionId = record.raw.admissionId;
				var studentId = record.raw.studentId;
				var periodId = record.raw.periodId;
				var programId = record.raw.programId;
				var batchId = record.raw.batchId;
				var academicTermId = record.raw.academicTermId;
				var studentCacheRecord = Ext.Array.findBy(tempArrayProgressionData, function(item) {
				    return item.studentId === studentId;
				});

				var promotionPanelGridDecision =studentCacheRecord.decision;
				var promotionPanelGridRemark = studentCacheRecord.remark;
				var marksheetJobId = studentCacheRecord.marksheetjob;
				var decisionTempleteRemarkGrid=formWindow.down('#decisionTempleteRemarkGrid');
				var decisionTempleteRemarkGridStore = decisionTempleteRemarkGrid.getStore();
				var decisionRecord = decisionTempleteRemarkGridStore.data.items[0].data.progressionStatus;
				var remarkRecord = decisionTempleteRemarkGridStore.data.items[0].data.remark;
				var decisionCode = decisionTempleteRemarkGridStore.data.items[0].data.template;

				if(isNullOrEmpty(decisionRecord)){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DECISION_IS_REQUIRED_TO_SELECT_FOR_PREVIEWING'));
					return false;
				}

				if(decisionRecord != promotionPanelGridDecision){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DECISION_IS_REQUIRED_TO_UPDATE_FOR_PREVIEWING'));
					return false;
				}

				if(decisionTempleteRemarkGridStore.data.items[0].data.value == 'Drafted'){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DECISION_IS_REQUIRED_TO_UPDATE_FOR_PREVIEWING'));
					return false;
				}

				if(isNullOrEmpty(remarkRecord)){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('REMARK_IS_REQUIRED_TO_SELECT_FOR_PREVIEWING'));
					return false;
				}

				if(remarkRecord != promotionPanelGridRemark){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('REMARK_IS_REQUIRED_TO_UPDATE_FOR_PREVIEWING'));
					return false;
				}

				if(isNullOrEmpty(formWindow.down('#marksheetJobField').getValue())){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MARKSHEET_JOB_IS_REQUIRED_TO_SELECT_FOR_PREVIEWING'));
					return false;
				}
				if(marksheetJobId != formWindow.down('#marksheetJobField').getValue()){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_UPDATE_MARKSHEET_JOB_BEFORE_PREVIEWING'));
					return false;
				}

				var clickedBtn = btn.itemId;
				if(clickedBtn == 'emailPreviewBtn') {

					// For Email Template Preview
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.PATH_EMAIL_CONTENT_PREVIEW,
						params: {
							admissionId: admissionId,
							studentId:studentId,
							periodId: periodId,
							programId: programId,
							batchId: batchId,
							academicTermId:academicTermId,
							decisionCode:decisionCode,
							marksheetJobId:marksheetJobId
						},
						method: 'GET',
						success: function (res, action) {
							var responseTxt = res.responseText;
							if (responseTxt != '') {
								var resp = Ext.decode(responseTxt);
								var msgContentWindow = $this.getProgressionpanelmessagecontentwindow();
								if (!msgContentWindow) {
									msgContentWindow = Ext.widget('progressionpanelmessagecontentwindow',{
										itemId:'progressionpanelmessagecontentwindowItemId',
										resp: resp
									});
								}

								msgContentWindow.show();
								msgContentWindow.center();
							}
							else{
								//error here
							}
						}
					});

				}
				else if(clickedBtn == 'marksheetPreviewBtn') {
					//

					var previewWindow = this.getDocumentpreviewwindow();
					if (!previewWindow) {
						Ext.widget('documentpreviewwindow', {
							documentRecord: record,
							width: '100%',
							height: Ext.getBody().getHeight(),
							itemId: 'promotionPanelMarksheetPreviewWindow'
						});
						previewWindow = this.getDocumentpreviewwindow();
					}
					previewWindow.show();

					var url = SERVERURL.PATH_PREVIEW_MARKSHEET;
					var filePath = formWindow.down('#marksheetJobField').valueModels[0].raw.itemValue;
					var fileExtension = filePath.split('.').pop()

					Ext.Ajax.request({
						type: 'rest',
						url: url,
						params: {
							filePath: filePath,
						},
						method: 'GET',
						success: function (res, action) {
							var responseTxt = res.responseText;
							if (responseTxt != '') {
								if (fileExtension.toUpperCase() == "PDF") {
									var fileSizeBytes = atob(responseTxt).length;
									var fileSizeMB = fileSizeBytes / (1024 * 1024);
									if(fileSizeMB > 1.2){
										// Convert base64 string to Blob
										var byteCharacters = atob(responseTxt);
										var byteNumbers = new Array(byteCharacters.length);
										for (var i = 0; i < byteCharacters.length; i++) {
											byteNumbers[i] = byteCharacters.charCodeAt(i);
										}
										var byteArray = new Uint8Array(byteNumbers);
										var blob = new Blob([byteArray], { type: 'application/pdf' });

										// Create a temporary URL for the Blob
										var blobUrl = URL.createObjectURL(blob);

										// Set the src of iframe to the Blob URL
										Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<iframe width='100%' height='100%' src='" + blobUrl + "'></iframe>";

									}else{
										Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<iframe width='100%' height='100%' src='data:application/pdf;base64, " + encodeURI(responseTxt) + "'></iframe>";
									}
								} else {
									Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<img src='data:image/" + fileExtension.toLowerCase() + ";base64," + encodeURI(responseTxt) + "' />";
								}
							} else {
								Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "Document Not Found";
							}
						}
					});
				}
			},

			enableDisableRevertToDrafted: function(column, selected) {
				var grid = this.getPromotionpanellist();
				var revertedToDrafted = grid.down('#revertToDraftedBtn');
				var allValid = true;
				var structure = grid.up('promotionpanelstructure');
				var nonPanelStudentCheckBox = structure.down('#nonPanelStudentCheckBox');

				if (nonPanelStudentCheckBox.getValue()) {
					revertedToDrafted.setDisabled(allValid);
					return false;
				}


				if (!isNullOrEmpty(selected) && selected.length > 0) {
					for (var i = 0; i < selected.length; i++) {
						var record = selected[i];
						var progressionStatus = record.get('progressionStatus');
						var enrollmentStatus = record.get('enrollmentStatus');
						var decision = record.get('decision');



						if((!isNullOrEmpty(progressionStatus)) && (!isNullOrEmpty(enrollmentStatus)) && (!isNullOrEmpty(decision)) &&
								(progressionStatus.toLowerCase() === 'completed')){
							allValid=true;
						}else{
							allValid=false;
							break;
						}

					}

					revertedToDrafted.setDisabled(!allValid);
				} else {
					revertedToDrafted.setDisabled(true);
				}
			},

			handleRegenerateLetter: function(btn) {
				var formWindow = btn.up('window');

				var promotionPanelGrid = this.getPromotionpanellist();
				var currentIdx = formWindow.recordIdx;
				var record = promotionPanelGrid.getStore().getAt(currentIdx);

				var admissionId = record.raw.admissionId;
				var studentId = record.raw.studentId;
				var periodId = record.raw.periodId;
				var programId = record.raw.programId;
				var batchId = record.raw.batchId;
				var academicTermId = record.raw.academicTermId;
				var studentCacheRecord = Ext.Array.findBy(tempArrayProgressionData, function(item) {
				    return item.studentId === studentId;
				});
				var promotionPanelGridDecision = studentCacheRecord.decision;
				var promotionPanelGridRemark = studentCacheRecord.remark;
				var marksheetJobId = studentCacheRecord.marksheetjob;

				var decisionTempleteRemarkGrid = formWindow.down('#decisionTempleteRemarkGrid');
				var decisionTempleteRemarkGridStore = decisionTempleteRemarkGrid.getStore();
				var decisionRecord = decisionTempleteRemarkGridStore.data.items[0].data.progressionStatus;
				var remarkRecord = decisionTempleteRemarkGridStore.data.items[0].data.remark;
				var decisionCode = decisionTempleteRemarkGridStore.data.items[0].data.template;

				if (isNullOrEmpty(decisionRecord)) {
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DECISION_IS_REQUIRED_TO_SELECT_FOR_REGENERATION'));
					return false;
				}

				if (decisionRecord != promotionPanelGridDecision) {
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DECISION_IS_REQUIRED_TO_UPDATE_FOR_REGENERATION'));
					return false;
				}

				if (decisionTempleteRemarkGridStore.data.items[0].data.value == 'Drafted') {
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DECISION_IS_REQUIRED_TO_UPDATE_FOR_REGENERATION'));
					return false;
				}

				if (isNullOrEmpty(remarkRecord)) {
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('REMARK_IS_REQUIRED_TO_SELECT_FOR_REGENERATION'));
					return false;
				}

				if (remarkRecord != promotionPanelGridRemark) {
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('REMARK_IS_REQUIRED_TO_UPDATE_FOR_REGENERATION'));
					return false;
				}

				if (isNullOrEmpty(formWindow.down('#marksheetJobField').getValue())) {
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MARKSHEET_JOB_IS_REQUIRED_TO_SELECT_FOR_REGENERATION'));
					return false;
				}
				if (marksheetJobId != formWindow.down('#marksheetJobField').getValue()) {
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_UPDATE_MARKSHEET_JOB_BEFORE_REGENERATION'));
					return false;
				}


				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.UPDATE_REGENERATE_LETTER,
					params: {
						admissionId: admissionId,
						studentId: studentId,
						periodId: periodId,
						programId: programId,
						batchId: batchId,
						academicTermId: academicTermId,
						decisionCode: decisionCode,
						marksheetJobId: marksheetJobId
					},
					method: 'GET',
					success: function(res, action) {
						var responseTxt = res.responseText;
						if (responseTxt != '') {

							if(responseTxt=="SUCCESS"){
								showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('TEMPLATE_REGENERATED_SUCCESSFULLY'));
							}
							else if (responseTxt == "NO_RECORDS_FOUND_FOR_UPDATION") {
								showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('NO_RECORDS_FOUND_FOR_UPDATION'));
							}
						}

					}
				});
			}

});