/*
 * This controller is used for  Sub Department details (Department Tab)   
 */
Ext.define('Academia.controller.department.SubDepartmentController', {
    extend: 'Academia.controller.base.BaseController',

    models: ['common.IdValueDataModel', 'department.DepartmentModel'],

    stores: ['department.SubDepartmentStore'],

    views: ['department.Department', 'department.SubDepartmentGrid', 'department.SubDepartmentFormWindow'],

    alias: "widget.subdepartmentcontroller",

    refs: [{
        ref: 'grdSubDepartmentGrid',
        selector: 'subdepartmentgrid'
    }, {
        ref: 'winSubDepartmentFormWindow',
        selector: 'subdepartmentformwindow'
    }, {
        ref: 'frmSubDepartmentForm',
        selector: 'subdepartmentformwindow form[itemId=subdepartmentForm]'
    }, {
        ref: 'grdDepartmentGrid',
        selector: 'departmentgrid'
    },{
        ref: 'department',
        selector: 'department'
    }],
    config: {
        SUB_DEPARTMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ORGANIZATION_SUB_DEPARTMENT_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            'subdepartmentgrid': {
                render: function(component, options) {
                    component.getStore().load();
                    this.doAccessControlValidation(component, this.getSUB_DEPARTMENT_PERMISSIONS());
                }
            },
            /*'subdepartmentgrid[itemId=subdepartmentgrid]': {
            	render: function(grid){
            		this.doAccessControlValidation(grid, this.getSUB_DEPARTMENT_PERMISSIONS());
            	}
            },*/
            'subdepartmentgrid button[itemId=btnAdd]': {
                click: this.addSubDepartment
            },
            'subdepartmentgrid button[itemId=btnEdit]': {
                click: Ext.bind(this.editSubDepartment, this, [false])
            },
            'subdepartmentgrid button[itemId=btnDelete]': {
                click: this.deleteSubDepartment
            },
            'subdepartmentgrid button[itemId=btnView]': {
                click: Ext.bind(this.editSubDepartment, this, [true])
            },
            'subdepartmentformwindow button[itemId=btnSaveSubDepartmentForm]': {
                click: this.saveSubDepartment
            },
            'subdepartmentformwindow button[itemId=btnCancelSubDepartmentForm]': {
                click: this.cancelSubDepartmentForm
            }
        });
    },

    /*
     * This function is used for to show Sub Department Details Dialog box after clicking on Add button   
     */
    addSubDepartment: function() {
        var grid = this.getGrdDepartmentGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            this.getGrdSubDepartmentGrid().showSubDepartmentForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var frmSubDepartmentForm = this.getFrmSubDepartmentForm();
                frmSubDepartmentForm.down('#parentDepartmentId').setValue(records[0].data.id);
                frmSubDepartmentForm.down('#parentDepartmentType').setValue(records[0].data.departmentType);
                frmSubDepartmentForm.down('#academyLocationId').setValue(records[0].data.academyLocationId);
            }
        } else {
        	showWarningMessage(getCommonTranslation('SUB_DEPARTMENT'), getCommonTranslation('PLEASE_SELECT_DEPARTMENT')); //Please select a Deparment							
        }
    },

    /*
     * This function is used for to show Sub Department Details Dialog box with values of selected record after clicking on edit button   
     */
    editSubDepartment: function(isView) {
        var me = this;
        var grid = me.getGrdSubDepartmentGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            me.getGrdSubDepartmentGrid().showSubDepartmentForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var frmSubDepartmentForm = me.getFrmSubDepartmentForm();
                var rec = new Academia.model.department.DepartmentModel(records[0].data);
                frmSubDepartmentForm.loadRecord(rec);
                if (isView) {
                    var winSubDepartmentFormWindow = me.getWinSubDepartmentFormWindow();
                    winSubDepartmentFormWindow.down('#btnSaveSubDepartmentForm').setVisible(false);
                    toggleReadOnlyFormItems(frmSubDepartmentForm.getForm(), true);
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('SUB_DEPARTMENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*
     * This function is used for to delete sub departments after clicking on delete button   
     */
    deleteSubDepartment: function() {
        var grid = this.getGrdSubDepartmentGrid();
        var grdStore = grid.getStore();
        if (grid.getSelectionModel().getCount() > 0) {
        	showConfirmMessage(getCommonTranslation('SUB_DEPARTMENT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                    if (btn == 'yes') {
                        if (grid.getSelectionModel().getCount() > 0) {
                            var records = grid.getSelectionModel().getSelection();
                            for (var count = 0; count < records.length; count++) {
                                var id = "";
                                if (records[count].get("id") != "" && records[count].get("id") != undefined && records[count].get("id") != null) {
                                    id = records[count].get("id");
                                }
                                Ext.Ajax.request({
                                    type: 'rest',
                                    method: 'DELETE',
                                    url: SERVERURL.DEPARTMENT_DELETE, //URL-rest/department/delete					
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    params: {
                                        id: id
                                    },
                                    success: function(form, action) {
                                        grdStore.reload();
                                        showSuccessMessage(getCommonTranslation('SUB_DEPARTMENT'), getCommonTranslation('DELETE_SUB_DEPARTMENT_MSG')); //Sub Department deleted successfully
                                    },
                                    failure: function(form, action) {
                                    	if(!isNullOrEmpty(form.responseText)){
                                    		var resp = Ext.decode(form.responseText);
                                    		var keyString = resp[0].key;
                                    		
                                    		if(keyString == 'cant_delete_there_exists_some_related_record'){
                                        		showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('cant_delete_there_exists_some_related_record')); 
                                        	}

                                    	}
                                    	else{
                                    		showErrorMessage(getCommonTranslation('SUB_DEPARTMENT'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction	
                                    	}
                                    }
                                });
                            }
                        }
                    }
                });
        } else {
        	showWarningMessage(getCommonTranslation('SUB_DEPARTMENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*
     * This function is used for to save sub department Details after clicking on save button    
     */
    saveSubDepartment: function(saveBtn) {
    	var me = this;
    	saveBtn.setDisabled(true);
        var winSubDepartmentFormWindow = this.getWinSubDepartmentFormWindow();
        var subDepartmentGrid = this.getGrdSubDepartmentGrid();
        var frmSubDepartmentForm = this.getFrmSubDepartmentForm();
        var loadedRecord = new Academia.model.department.DepartmentModel(frmSubDepartmentForm.getValues());
        //var checkDuplicate=this.checkDuplicate(loadedRecord);
        //if(checkDuplicate==true){
        // Ext.Msg.alert('Sub Department','Department already exits with the same name.');
        //}else{
        //var values = academyLocationLinkForm.getValues();
        //if(academyLocationLinkForm.isValid( )){
        var submitUrl, isUpdate = false;
        var subDepartmentIdField = frmSubDepartmentForm.down('#subDepartmentId');
        if (subDepartmentIdField.getSubmitValue() == null || subDepartmentIdField.getSubmitValue() == "" || subDepartmentIdField.getSubmitValue() === undefined) {
            submitUrl = SERVERURL.SUBDEPARTMENT_CREATE, //URL-rest/department/create
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.SUBDEPARTMENT_UPDATE, //URL-rest/department/update
            isUpdate = true;
        }
        var jsonFormatFormData = Ext.encode(frmSubDepartmentForm.getValues());
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(form, action) {
                winSubDepartmentFormWindow.close();
                subDepartmentGrid.getSelectionModel().deselectAll();
                subDepartmentGrid.getStore().reload();
                me.getDepartment().body.setScrollTop(0);
                if (isUpdate) {
                	showSuccessMessage(getCommonTranslation('SUB_DEPARTMENT'), getCommonTranslation('UPDATE_SUB_DEPARTMENT_MSG')); //Sub Department updated successfully												
                } else {
                	showSuccessMessage(getCommonTranslation('SUB_DEPARTMENT'), getCommonTranslation('ADD_SUB_DEPARTMENT_MSG')); //Sub Department added successfully												
                }
            },
            failure: function(form, action) {
                winSubDepartmentFormWindow.close();
                subDepartmentGrid.getStore().reload();
                me.getDepartment().body.setScrollTop(0);
                showErrorMessage(getCommonTranslation('SUB_DEPARTMENT'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction																		
            }
        });
        //}else{
        //  Ext.Msg.alert('Academy Location', 'please enter a valid input');							
        // }
        //}																	
    },

    /*
     * This function is used for to close Sub Department Details Dialog box after clicking on cancel button   
     */
    cancelSubDepartmentForm: function() {
        this.getWinSubDepartmentFormWindow().close();
    },

    /*
     *This function is used for to check duplicate sub departname name 
     */
    checkDuplicate: function(record) {
        var deptName = record.get("name");
        var academyLocationId = record.get("academyLocationId");
        var isExist = false;
        Ext.Ajax.request({
            type: 'rest',
            async: false,
            url: SERVERURL.SUBDEPARTMENT_CHECKDUPLICATE, //URL-rest/department/checkDuplicate
            params: {
                deptName: deptName,
                academyLocationId: academyLocationId
            },
            method: 'GET',
            success: function(response, form, action) {
                var responseObject = eval("(" + response.responseText + ")");
                if (responseObject == true) {
                    isExist = true;
                }
            },
            failure: function(response, form, action) {
            	 showErrorMessage(getCommonTranslation('SUB_DEPARTMENT'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction									
            }
        });
        return isExist;
    }
});
