
/**
 * @author kamlesh
 */
Ext.define('Academia.controller.examinationcenters.evaluation.evaluationPlanHierarchy.EvaluationPlanHierarchyController', {
    //extend: 'Ext.app.Controller',
	extend: 'Academia.controller.base.BaseController',
    stores: ['common.AcademyStore', 'common.AcademyLocationByAcademyId','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationPlanHeirarchyStore', 
             'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationSectionStore','common.ProgramByAcademyLocationStore', 'common.UsersComboStore','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationStudentList','examinationcenters.evaluation.evaluationPlanHeirarchy.DefineTopicCoverageDisplayList',
             'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationPeriodStore','examinationcenters.evaluation.evaluationPlanHeirarchy.DetailSequenceEquivalentNo','examinationcenters.evaluation.evaluationPlanHeirarchy.EquivalentEventRuleCombo',
             'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationBatchStore','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationProgramStore','examinationcenters.evaluation.coverageDetails.CoverageDetailsGrid',
             'examinationcenters.evaluation.coverageDetails.SectionByVariants','examinationcenters.evaluation.evaluationPlanHeirarchy.createGroup.DetainStudentList',
             'examinationcenters.evaluation.coverageDetails.EvaluationPlanMappedALStore',
             'examinationcenters.evaluation.coverageDetails.EvaluationPlanDetainALStore','examinationcenters.evaluation.evaluationPlanHeirarchy.RuleForAbsentEnumStore',
             'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationEventFormMinGradeComboStore','examinationcenters.evaluation.evaluationPlanHeirarchy.ExamResultPublishModeEventEnumStore'],
    models: ['common.IdValueCodeDataModel', 'organization.LocationAddress', 'common.IdValueDataModel','examinationcenters.evaluation.evaluationPlanHeirarchy.CreateGroupGrid'],//'
    views: ['examinationcenters.evalution.evaluationPlanHierarchy.EvaluationPlanLevelOneForm','baselayout.contentarea.ContentPanel',
            'examinationcenters.evalution.evaluationPlanHierarchy.EvaluationPlanLevelTwoForm','examinationcenters.evalution.evaluationPlanHierarchy.DefineTopicCoverageFormGrid',
            'examinationcenters.evalution.evaluationPlanHierarchy.EvaluationPlanSequenceForm','examinationcenters.evalution.evaluationDetail.EvaluationDetailInnerTabStructure',
            'examinationcenters.evalution.evaluationPlanHierarchy.AcademicElegiableStudentStruct','examinationcenters.evalution.evaluationPlanHierarchy.AcademicMappedStudentStruct','examinationcenters.evalution.evaluationPlanHierarchy.StudentUnMapForOther','examinationcenters.evalution.evaluationPlanHierarchy.EvaluationPlanSequenceDetailForm','examinationcenters.evalution.evaluationPlanHierarchy.CreateGroupGrid','examinationcenters.evalution.evaluationPlanHierarchy.DefineTopicCoverageForm',
            'examinationcenters.evalution.evaluationPlanHierarchy.AcademicMappedStudentStruct','examinationcenters.evalution.evaluationPlanHierarchy.OtherElegiableStudentStruct',
            'examinationcenters.evalution.evaluationPlanHierarchy.OtherMappedStudentStruct','examinationcenters.evalution.evaluationDetail.EvaluationPlanHierarchyCopyWin',
            'examinationcenters.evalution.evaluationPlanHierarchy.DetaineStudentStruct','examinationcenters.evalution.evaluationPlanHierarchy.StudentDetainGrid',
            'examinationcenters.evalution.evaluationDetail.EvaluationDetailTabStructure'],
   config:{
	   		ASSESSMENT_SCHEME_HIERARCHY_MORE_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ASSESSMENT_SCHEME_HIERARCHY_MORE_PRIVILEGES')
		   },
            
    refs: [ {
		        ref: 'evaluationplanleveloneform',
		        selector: 'evaluationplanleveloneform'
	    	},{
		        ref: 'evaluationPlanLeveloneForm',
		        selector: 'evaluationplanleveloneform form'
	    	},{
		        ref: 'evaluationplanleveltwoform',
		        selector: 'evaluationplanleveltwoform'
	    	},{
		        ref: 'evaluationPlanLeveltwoForm',
		        selector: 'evaluationplanleveltwoform form'
	    	},{
		        ref: 'evaluationplansequenceform',
		        selector: 'evaluationplansequenceform'
	    	},{
		        ref: 'evaluationplansequencedetailform',
		        selector: 'evaluationplansequencedetailform'
	    	},{
		        ref: 'evaluationPlanSequenceForm',
		        selector: 'evaluationplansequenceform form'
	    	},{
		        ref: 'evaluationPlanSequenceDetailForm',
		        selector: 'evaluationplansequencedetailform form'
	    	},{
		        ref: 'evaluationdetailinnertabstructure',
		        selector: 'evaluationdetailinnertabstructure'
	    	},{
		        ref: 'creategroupgrid',
		        selector: 'creategroupgrid'
	    	},{
		        ref: 'evaluationplanbasicdetailform',
		        selector: 'evaluationplanbasicdetailform'
	    	},{
		        ref: 'creategroupformgrid',
		        selector: 'creategroupformgrid'
	    	},{
		        ref: 'studentgridforexternalandother',
		        selector: 'studentgridforexternalandother'
	    	},{
		        ref: 'evaluationPlanHierarchyStructureTree',
		        selector: 'evaluationplanhierarchystructure treepanel'
	    	},{
		        ref: 'studentunmapforother',
		        selector: 'studentunmapforother'
	    	},{
		        ref: 'academicelegiablestudentstruct',
		        selector: 'academicelegiablestudentstruct'
	    	},{
		        ref: 'otherelegiablestudentstruct',
		        selector: 'otherelegiablestudentstruct'
	    	},{
		        ref: 'othermappedstudentstruct',
		        selector: 'othermappedstudentstruct'
	    	}, {
		        ref: 'evaluationplanhierarchycopywin',
		        selector: 'evaluationplanhierarchycopywin'
	    	},{
		        ref: 'detainestudentstruct',
		        selector: 'detainestudentstruct'
	    	},{
		        ref: 'evaluationdetailtabstructure',
		        selector: 'evaluationdetailtabstructure'
	    	}
	    	
    ],
    init: function(application) {
        this.control({
        	'evaluationplanhierarchystructure treepanel[itemId=evaluationPlanTreeItemId]':{
        		select:function(obj, record, index,eOpts){
        			var $this = this;
					var buttonsToolBar = obj.view.ownerCt.query('toolbar')[0];
					/**
					 * On click on these 4 nodes tab open directly and on other links tab open through button click.    
					 *
					 */
					var evalPlanHierarchyStr=$this.getEvaluationPlanHierarchyStructureTree();
					var masterBasicForm=$this.getEvaluationplanbasicdetailform().getForm();
    				var isViewMode=masterBasicForm.findField('masterViewMode').getValue();
					
					var copyBtn = evalPlanHierarchyStr.down('#btnCopy');
					if(record.data.parentId == 'root'||record.data.qtitle == '') {
						copyBtn.setVisible(false);
					} 
					else if (isViewMode) {
						copyBtn.setVisible(false);
					}
					else {
						copyBtn.setVisible(true);
					}	
					var struct = $this.getEvaluationdetailtabstructure();
        			if(struct.getWhetherPlanTransferCredit()) {
        				copyBtn.setVisible(false);
        			}
					var tabDetail = record.data;
					var id = tabDetail.id;
					var childItem = tabDetail.qtitle;
					var tabName = tabDetail.text;
					
        			if(childItem=='creategroupgrid' || childItem=='creategroupformgrid' || childItem=='studentgridforexternalandother' 
        				|| childItem=='definetopiccoverageform' || childItem=='assignquestionpaperform' || childItem=='studentlistforother'
        				||  childItem=='studentunmapforother'	|| childItem=='mappedstudentgrid' || childItem=='detainestudentgrid'){
        				buttonsToolBar.setVisible(false);
					var contentPanel = $this
					.getEvaluationdetailinnertabstructure();
					contentPanel.removeAll();
					if(childItem!=""){
					if (contentPanel != undefined) {
						var newTab = contentPanel.items.findBy(function(tab) {
									return tab.title === tabName;
								});
						if(childItem=="mappedstudentgrid"){
							childItem='academicelegiablestudentstruct';
						}
						if(childItem=="creategroupformgrid"){
							childItem='academicmappedstudentstruct';
						}
						if(childItem=="studentlistforother"){
							childItem='otherelegiablestudentstruct';
						}
						if(childItem=="studentunmapforother"){
							childItem='othermappedstudentstruct';
						}
						if(childItem=="detainestudentgrid"){ 
							childItem='detainestudentstruct';
						}
						if (!newTab) {
							contentPanel.add({
								title : tabName,
								closable : true,
								id : id,
								xtype : childItem,
								layout : 'fit'
							// activeTab :0
							}).show();
						}
						//contentPanel.setActiveTab(newTab);
						contentPanel.doLayout();
					}
				  }
        			}else{
        				var evalPlanHierarchyStructure=$this.getEvaluationPlanHierarchyStructureTree();
        				var form=$this.getEvaluationplanbasicdetailform().getForm();
        				var masterViewMode=form.findField('masterViewMode').getValue();
       			    	var evalPlanStatus=form.findField('status').getRawValue();
    				/**
		        	 * if evalPlanStatus  is closed then evaluation detail sequence will only be in edit mode. 
		        	 */
       			    	buttonsToolBar.setVisible(true);
       			    	
       			    	if(evalPlanStatus=="Closed"){
       			    		if(childItem=="evaluationplansequencedetailform"){
       			    			evalPlanHierarchyStructure.down('#btnAdd').setVisible(true);
        		        		evalPlanHierarchyStructure.down('#btnEdit').setVisible(false);
        		        		evalPlanHierarchyStructure.down('#btnDelete').setVisible(false);
           			    	}else{
           			    		evalPlanHierarchyStructure.down('#btnAdd').setVisible(false);
           			    	}
    		        	}
        				
        				var contentPanel = $this.getEvaluationdetailinnertabstructure();
    					contentPanel.removeAll();
        			}
        		},
        		itemexpand:function(obj,eOpts){
   				 var $this=this;
   				 if(obj.data.qtitle=='evaluationplanleveloneform'){
   					$this.loadFirstLevelChild(obj);	 
   				 }else if(obj.data.qtitle=='evaluationplanleveltwoform'){
   					$this.loadSecondLevelChild(obj);	
   				 }else if(obj.data.qtitle=='evaluationplansequenceform'){
   					$this.loadThirdLevelChild(obj);	
   				 }else if(obj.data.qtitle=='evaluationplansequencedetailform'){
   					 $this.loadFourthLevelChild(obj);	
   				 }
   			  },
   			    render:function(){
   			    	var evalPlanHierarchyStructure=this.getEvaluationPlanHierarchyStructureTree();
   			    	this.doAccessControlValidation(evalPlanHierarchyStructure, this.getASSESSMENT_SCHEME_HIERARCHY_MORE_PERMISSION());
   			    	var form=this.getEvaluationplanbasicdetailform().getForm();
   			    	var masterViewMode=form.findField('masterViewMode').getValue();
   			    	var evalPlanStatus=form.findField('status').getRawValue();
   			    	
		        	/**
		        	 * if masterViewMode true then Assessment Scheme will only view mode. 
		        	 */
		        	if(masterViewMode){
		        		evalPlanHierarchyStructure.down('#btnAdd').setVisible(false);
		        		evalPlanHierarchyStructure.down('#btnEdit').setVisible(false);
		        		evalPlanHierarchyStructure.down('#btnDelete').setVisible(false);
		        	}
   			  },
   			  afterrender: function(cmp){
   				 setTimeout(function(){
   				 	try{
   				 		var upperPanelWidth = cmp.up().el.dom.style.width.replace('px','');
   	   					cmp.setWidth(upperPanelWidth - 860);
   				 	}
   				 	catch(e){
   				 		//--
   				 	}
   				 },1000);
   			  }
        	},
        	'evaluationplanhierarchystructure button[itemId=btnEdit]':{
        		click:function(obj){
        			var editBtn=true;
        			this.openEditingTabs(obj,editBtn);
        		}
        	},
        	'evaluationplanhierarchystructure button[itemId=btnView]':{
        		click:function(obj){
        			var viewBtn=false;
        			this.openEditingTabs(obj,viewBtn);
        		}
        	},
        	'evaluationplanhierarchystructure button[itemId=btnDelete]':{
        		click:function(){
        			this.deleteTreeNode();
        		}
        	},
        	'evaluationplanhierarchystructure button[itemId=btnCopy]':{
        		click:function(){
        			var tree=Ext.ComponentQuery.query('treepanel#evaluationPlanTreeItemId')[0];
        		    var node=	tree.getSelectionModel().getSelection()[0];
        		    
        		    var record=node.parentNode;
        			var tabDetail = record.data;
        			var id = tabDetail.id;
        			var childItem = tabDetail.qtitle;
        			var tabName = tabDetail.text;
        			
        			var superParent = tree.getRootNode().childNodes[0].data.text;
        			
        			var formWindow = this.getEvaluationplanhierarchycopywin();
    				if (!formWindow) {
    					Ext.widget('evaluationplanhierarchycopywin');
    					formWindow = this.getEvaluationplanhierarchycopywin();
    				}
    				formWindow.setTitle(getExaminationTranslation('COPY_HIERARCHY_FROM')+' '+node.data.text);
    				var isShowWin = true;
    				
    				if(!isNullOrEmpty(record.data.qtitle)){
    					var form = formWindow.down('form');
    					if(record.data.qtitle=='evaluationplanleveloneform'){
    						
    						if(superParent == 'ACADEMICS') {
    							form.down('#evaluationTypelevelItemId').setVisible(true);
        						form.down('#evaluationOtherTypelevelItemId').allowBlank = true;
    						} else if(superParent == 'OTHER') {
    							form.down('#evaluationOtherTypelevelItemId').setVisible(true);
        						form.down('#evaluationTypelevelItemId').allowBlank = true;
    						}
    						
    						form.down('#evaluationSubTypeLevelItemId').allowBlank = true;
    						form.down('#evaluationOtherSubTypeLevelItemId').allowBlank = true;
    						form.down('#sequenceHeaderIdItemdId').allowBlank = true;
    						
    						form.down('#levelTypeId').setValue('EVALUATION_TYPE');
    						form.down('#levelOneId').setValue(node.data.cls);
    					}else if(record.data.qtitle=='evaluationplanleveltwoform'){
    						
    						if(superParent == 'ACADEMICS') {
    							form.down('#evaluationSubTypeLevelItemId').setVisible(true);
        						form.down('#evaluationOtherSubTypeLevelItemId').allowBlank = true;
    						} else if(superParent == 'OTHER') {
    							form.down('#evaluationOtherSubTypeLevelItemId').setVisible(true);
        						form.down('#evaluationSubTypeLevelItemId').allowBlank = true;
    						}
    						
    						form.down('#evaluationTypelevelItemId').allowBlank = true;
    						form.down('#evaluationOtherTypelevelItemId').allowBlank = true;
    						form.down('#sequenceHeaderIdItemdId').allowBlank = true;
    						
    						form.down('#levelTypeId').setValue('EVALUATION_SUB_TYPE');
    						form.down('#levelTwoId').setValue(node.data.cls);
				    	}else if(record.data.qtitle=='evaluationplansequenceform'){
				    		form.down('#sequenceHeaderIdItemdId').setVisible(true);
				    		
				    		form.down('#evaluationTypelevelItemId').allowBlank = true;
    						form.down('#evaluationSubTypeLevelItemId').allowBlank = true;
    						form.down('#evaluationOtherTypelevelItemId').allowBlank = true;
    						form.down('#evaluationOtherSubTypeLevelItemId').allowBlank = true;
    						
				    		form.down('#levelTypeId').setValue('EVALUATION_METHOD');
				    		form.down('#levelThreeId').setValue(node.data.cls);
				    	} else {
				    		isShowWin = false;
				    	}
	    				if(isShowWin){
	    					formWindow.show();
	    				}
    				}
        		}		
        	},
        	
        	'evaluationplanhierarchycopywin' :{
        		render:function(obj){
        			var form=this.getEvaluationplanbasicdetailform().getForm();
        			var value = form.getValues();
        			
        			var tree=Ext.ComponentQuery.query('treepanel#evaluationPlanTreeItemId')[0];
        		    var node=	tree.getSelectionModel().getSelection()[0];
        		    
//        			var levelTypeId = obj.down('#levelTwoId');
        			var levelOtherTypeOneId = obj.down('#evaluationOtherTypelevelItemId');
        			var evaluationOtherSubTypeLevelField = obj.down('#evaluationOtherSubTypeLevelItemId');
        			var evaluationTypelevelField = obj.down('#evaluationTypelevelItemId');
        			var evaluationSubTypeLevelField = obj.down('#evaluationSubTypeLevelItemId');
        			var sequenceHeaderField = obj.down('#sequenceHeaderIdItemdId');
        			
        			if(!evaluationTypelevelField.isHidden()){
        				var evaluationTypelevelFieldStore=evaluationTypelevelField.getStore();
        				var planId = node.parentNode.data.cls;
        				evaluationTypelevelFieldStore.getProxy().extraParams = {
        					evaluationPlanId: value.id
        				};
        				evaluationTypelevelFieldStore.load();
        			}
        			
        			if(!evaluationSubTypeLevelField.isHidden()){
        				var evaluationSubTypeLevelFieldStore=evaluationSubTypeLevelField.getStore();
        				var levelOneId = node.parentNode.data.cls;
        				evaluationSubTypeLevelFieldStore.getProxy().extraParams = {
        					evaluationPlanLevelOneId: levelOneId
        				};
        				evaluationSubTypeLevelFieldStore.load();
        			}
        			
        			if(!sequenceHeaderField.isHidden()){
        				var sequenceHeaderFieldStore=sequenceHeaderField.getStore();
//        				var levelTwoId = node.data.cls;
        				var levelTwoId = node.parentNode.data.cls;
        				sequenceHeaderFieldStore.getProxy().extraParams = {
        					evaluationPlanLevelTwoId: levelTwoId
        				};
        				sequenceHeaderFieldStore.load();
        			}
        			
        			if(!levelOtherTypeOneId.isHidden()){
        				var levelTypeOneOtherStore=levelOtherTypeOneId.getStore();
        				var planId = node.parentNode.data.cls;
        				levelTypeOneOtherStore.getProxy().extraParams = {
        					evaluationPlanId: value.id,
//        					evaluationPlanLevelOneId: planId
        				};
        				levelTypeOneOtherStore.load();
        			}
        			
        			if(!evaluationOtherSubTypeLevelField.isHidden()){
        				var ccOtherStore=evaluationOtherSubTypeLevelField.getStore();
        				ccOtherStore.getProxy().extraParams = {
        					id: value.categoryId,
        					evaluationPlanLevelOneId: value.id
        				};
        				ccOtherStore.load();
        			}
            	}
        	},
        	
        	'evaluationplanhierarchystructure button[itemId=btnAdd]':{
        		click:function(obj){
        			var $this = this;
        			var selectRec=obj.ownerCt.ownerCt.getSelectionModel().getSelection()[0];
        			/**
        			 * check if data is not selected at first time 
        			 */
        			var record=selectRec;
        			var struct = $this.getEvaluationdetailtabstructure();
        			if(struct.getWhetherPlanTransferCredit()) {
        				var basicForm=this.getEvaluationplanbasicdetailform().getForm();
        				var isTransferCredit=true;
            	    	var evaluationId=basicForm.findField('id').getValue();
        				Ext.Ajax.request({
	  						type : 'rest',
	  						url : SERVERURL.APPLIED_RULE_FOR_COMBO_URL+'?evalPlanId='+evaluationId+'&isTransferCredit='+isTransferCredit,
	  						method : 'GET',
	  						success : function(resp, action) {
	  								var jData=resp.responseText;
	  								var flag = false;
	  								var data = Ext.decode(jData);
	  								if(selectRec.raw.qtitle == 'evaluationplanleveloneform'){
	  									for(var i in data) {
	  										if(data[i].code == 'Assessment Type') {
	  											showWarningMessage(getCommonTranslation('ALERT'),'Scheme for Transfer Credits can not have multiple Type Level');
	  		  		        					return false;
	  										}
	  									}
	  									flag= true;
	  		        				} else if(selectRec.raw.qtitle == 'evaluationplanleveltwoform'){
	  		        					for(var i in data) {
	  										if(data[i].code == 'Assessment Sub Type') {
	  											showWarningMessage(getCommonTranslation('ALERT'),'Scheme for Transfer Credits can not have multiple Sub Type Level');
	  		  		        					return false;
	  										}
	  									}
	  		        					flag= true;
	  		        				} else if(selectRec.raw.qtitle == 'evaluationplansequenceform'){
	  		        					for(var i in data) {
	  										if(data[i].code == 'Assessment Method') {
	  											showWarningMessage(getCommonTranslation('ALERT'),'Scheme for Transfer Credits can not have multiple Method Level');
	  		  		        					return false;
	  										}
	  									}
	  		        					flag= true;
	  		        				} else if(selectRec.raw.qtitle == 'evaluationplansequencedetailform'){
	  		        					for(var i in data) {
	  										if(data[i].code == 'Assessment Method') {
	  											Ext.Ajax.request({
	  												type : 'rest',
	  												url : SERVERURL.EVALUATION_PLAN_TREE_LEVEL_FOURTH_REST_URL+'?evalSeqId='+data[i].levelId,
	  												method : 'GET',
	  												success : function(respons, action) {
	  													var jData1=respons.responseText;
	  													var data1 = Ext.decode(jData1);
	  													if(data1.length>0) {
	  														showWarningMessage(getCommonTranslation('ALERT'),'Scheme for Transfer Credits can not have multiple Event');
		  				  		        					return false;
	  													} else {

	  								        				if(record!=undefined){
	  								        					var tabDetail = record.data;
	  								        					var id = tabDetail.id;
	  								        					var childItem = tabDetail.qtitle;
	  								        					var tabName = tabDetail.text;
	  								        					
	  								        					var contentPanel = $this
	  								        					.getEvaluationdetailinnertabstructure();
	  								        					contentPanel.removeAll();
	  								        					if(childItem!=""){
	  								        					if (contentPanel != undefined) {
	  								        						var newTab = contentPanel.items.findBy(function(tab) {
	  								        									return tab.title === tabName;
	  								        								});

	  								        						if (!newTab) {
	  								        							contentPanel.add({
	  								        								title : tabName,
	  								        								closable : true,
	  								        								id : id,
	  								        								xtype : childItem,
	  								        								layout : 'fit'
	  								        							// activeTab :0
	  								        							}).show();
	  								        						}
	  								        						//contentPanel.setActiveTab(newTab);
	  								        						if(childItem.down('#whetherPassesCriticalId')) {
                                                                          childItem.down('#whetherPassesCriticalId').disable();
                                                                    }

	  								        						contentPanel.doLayout();
	  								        					}
	  								        				  }
	  								                		 }else{
	  								                			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	  								                		 }
	  													}
	  												}
	  											});
	  										}
	  										flag=true;
	  									}
	  		        				}
	  								if(flag) {
	  			        				if(record!=undefined){
	  			        					var tabDetail = record.data;
	  			        					var id = tabDetail.id;
	  			        					var childItem = tabDetail.qtitle;
	  			        					var tabName = tabDetail.text;
	  			        					
	  			        					var contentPanel = $this
	  			        					.getEvaluationdetailinnertabstructure();
	  			        					contentPanel.removeAll();
	  			        					if(childItem!=""){
	  			        					if (contentPanel != undefined) {
	  			        						var newTab = contentPanel.items.findBy(function(tab) {
	  			        									return tab.title === tabName;
	  			        								});

	  			        						if (!newTab) {
	  			        							contentPanel.add({
	  			        								title : tabName,
	  			        								closable : true,
	  			        								id : id,
	  			        								xtype : childItem,
	  			        								layout : 'fit'
	  			        							// activeTab :0
	  			        							}).show();
	  			        						}
	  			        						//contentPanel.setActiveTab(newTab);
	  			        						contentPanel.doLayout();
	  			        					}
	  			        				  }
	  			                		 }else{
	  			                			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	  			                		 }
	  								}
	  						}
        				});
        			} else {
        				if(record!=undefined){
        					var tabDetail = record.data;
        					var id = tabDetail.id;
        					var childItem = tabDetail.qtitle;
        					var tabName = tabDetail.text;
        					
        					var contentPanel = $this
        					.getEvaluationdetailinnertabstructure();
        					contentPanel.removeAll();
        					if(childItem!=""){
        					if (contentPanel != undefined) {
        						var newTab = contentPanel.items.findBy(function(tab) {
        									return tab.title === tabName;
        								});

        						if (!newTab) {
        							contentPanel.add({
        								title : tabName,
        								closable : true,
        								id : id,
        								xtype : childItem,
        								layout : 'fit'
        							// activeTab :0
        							}).show();
        						}
        						//contentPanel.setActiveTab(newTab);
        						contentPanel.doLayout();
        						contentPanel.down(childItem).down('#addEdit').setValue('add');
        					}
        				  }
                		 }else{
                			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                		 }
        			}
        		}
        	},
        	'evaluationplanhierarchycopywin button[itemId=cancelBtn]':{
        		click:function(obj){
		        	this.getEvaluationplanhierarchycopywin().close();
        		}
        	},
        	'evaluationplanhierarchycopywin button[itemId=submitBtn]':{
        		click:function(obj){
        			obj.disable();
        			var formWin = this.getEvaluationplanhierarchycopywin();
        			var form = obj.up('form');
        			var levelName = '';
        			var levelType = form.down('#levelTypeId').getValue();
        			var sequenceHeaderId = '';
        			var evaluationPlanId = '';
        			
        			var tree=Ext.ComponentQuery.query('treepanel#evaluationPlanTreeItemId')[0];
        			var superParent = tree.getRootNode().childNodes[0].data.text;
        			
        			var basicForm=this.getEvaluationplanbasicdetailform().getForm();
        	    	var evaluationId=basicForm.findField('id').getValue();
        			
        	    	if(levelType=='EVALUATION_TYPE'){
        	    		if(superParent == 'ACADEMICS') {
        	    			levelName = form.down('#evaluationTypelevelItemId').getValue();
        	    			sequenceHeaderId=form.down('#evaluationTypelevelItemId').valueModels[0].data.id;
        	    		}else if(superParent == 'OTHER') {
        					levelName = form.down('#evaluationOtherTypelevelItemId').getValue();
        					sequenceHeaderId=form.down('#evaluationOtherTypelevelItemId').valueModels[0].data.id;
        				}
    				}
        			else if(levelType=='EVALUATION_SUB_TYPE'){
        				if(superParent == 'ACADEMICS') {
        					levelName = form.down('#evaluationSubTypeLevelItemId').getValue();
        					sequenceHeaderId=form.down('#evaluationSubTypeLevelItemId').valueModels[0].data.id;
        				} else if(superParent == 'OTHER') {
        					levelName = form.down('#evaluationOtherSubTypeLevelItemId').getValue();
        					sequenceHeaderId=form.down('#evaluationOtherSubTypeLevelItemId').valueModels[0].data.id;
        				}
			    	}
        			else if(levelType=='EVALUATION_METHOD'){
			    		sequenceHeaderId = form.down('#sequenceHeaderIdItemdId').getValue();
			    	}
        			
        			var levelOneId = form.down('#levelOneId').getValue();
		        	var levelTwoId = form.down('#levelTwoId').getValue();
		        	var levelThreeId = form.down('#levelThreeId').getValue();
		        	
		        	var params = {
		        			evaluationLevel : levelType,
		        			copyFromLevelOneId : levelOneId,
		        			copyFromLevelTwoId : levelTwoId,
		        			copyFromLevelThreeId : levelThreeId,
		        			evaluationPlanId : evaluationId,
		        			levelName : levelName,
		        			sequenceHeaderId : sequenceHeaderId
		        	};
		        	var submitUrl = SERVERURL.EVALUATION_PLAN_HIERARCHY_COPY;
		        	
		        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		        	Ext.Ajax.request({
                        type: 'rest',
                        url: submitUrl,
                        method: 'GET',
                        timeout:30000,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        params: params,
                        success: function(form, action) {
                            showSuccessMessage(getCommonTranslation('SUCCESS'),getExaminationTranslation('EVALUATION_PLAN_LEVEL_COPIED_SUCCESS'));
                            formWin.close();
                            tree.collapseAll();
                            setTimeout(function(){
                                tree.expandAll();
                                Ext.getBody().unmask();
                            },300);
                        }
                    });
        		}
        	}
        });
    },
    loadFirstLevelChild:function(obj){
	    	if(obj.hasChildNodes()){
				obj.removeAll();
		    }
	    	/**
	    	 * Whenever the New Assessment Type is created that evaluation Id will be pass in EvaluationId  
	    	 */
	    	var form=this.getEvaluationplanbasicdetailform().getForm();
	    	var evaluationId=form.findField('id').getValue();
	    	
			var firstLevelForm='evaluationplanleveltwoform';
			Ext.Ajax.request({
			 type: 'rest',
			 url: SERVERURL.EVALUATION_PLAN_TREE_LEVEL_ONE_REST_URL,
			 method: 'GET',
			 params:{
				 id:evaluationId
			 },
			 success: function(form, action) {
				 var data = form.responseText;
				 var jData=Ext.JSON.decode(data);
				 if(!isNullOrEmpty(jData)){
					 Ext.Array.each(jData, function(value,firstIndex) {	
						 obj.appendChild({
							 text:value.value,
							 qtitle:firstLevelForm,
							 cls:value.id,
							 id:'firstLevel'+value.id,
							 expanded: false
						 });
					 });
				 }
				 
			 }
		 });
    },
    loadSecondLevelChild:function(obj){
    	if(obj.hasChildNodes()){
			obj.removeAll();
	    }
    	var secondLevelForm='evaluationplansequenceform';
    	 Ext.Ajax.request({
		 type: 'rest',
		 url: SERVERURL.EVALUATION_PLAN_TREE_LEVEL_TWO_REST_URL,
		 method: 'GET',
		 params:{
			 id:obj.data.cls
		 },
		 success: function(rsp, action) {
			 var data = rsp.responseText;
			 var jData=Ext.JSON.decode(data);
		
			 if(!isNullOrEmpty(jData)){
				 Ext.Array.each(jData, function(value,index) {
					  obj.appendChild({
						 text:value.value,
						 qtitle:secondLevelForm,
						 id:'secondLevel'+value.id,
						 cls:value.id,
						 expanded: false
					  });
					});
			 }
		 }
	  });
    },
    loadThirdLevelChild:function(obj){
    	if(obj.hasChildNodes()){
			obj.removeAll();
	    }
    	var thirdLevelForm='evaluationplansequencedetailform';
    	Ext.Ajax.request({
   		 type: 'rest',
   		 url: SERVERURL.EVALUATION_PLAN_TREE_LEVEL_THIRD_REST_URL,
   		 method: 'GET',
   		 params:{
   			 id:obj.data.cls
   		 },
   		 success: function(rsp, action) {
   			 var data = rsp.responseText;
   			 var jData=Ext.JSON.decode(data);
   			 var allMethodIds=[];
   			 if(!isNullOrEmpty(jData)){
   				 Ext.Array.each(jData, function(value) {
   					 allMethodIds.push(value.id);
   					 obj.appendChild({
   						 text:value.value,
   						 qtitle:thirdLevelForm,
   						 id:'thirdLevel'+value.id,
   						 cls:value.id,
   						 expanded: false
   					 });
   				 });
   				 obj.hrefTarget=allMethodIds;
   			 }
   		 }
   	  });
    },
    loadFourthLevelChild:function(obj){
    	var $this=this;
    	if(obj.hasChildNodes()){
			obj.removeAll();
	    }
    	var evalBasicform=$this.getEvaluationplanbasicdetailform().getForm();
    	var evalType=evalBasicform.findField('evaluationPlanType').getValue();
    	/**
    	 * Below Condition Are on the bases of evaluation type, Group And limited Student eval seq detail screen 
    	 */
    	
		Ext.Ajax.request({
	   		 type: 'rest',
	   		 url: SERVERURL.EVALUATION_PLAN_TREE_LEVEL_FOURTH_REST_URL,
	   		 method: 'GET',
	   		 params:{
	   			evalSeqId:obj.data.cls
	   		 },
	   		 success: function(rsp, action) {
	   			 var data = rsp.responseText;
	   			 var jData=Ext.JSON.decode(data);
	   			 
	   		if(jData!=null&&jData.length>0){
	   			 Ext.Array.each(jData, function(value,index) {
	   			  obj.appendChild({
	   				 text:value.detailSequenceNumber,
//	   				 qtitle:thirdLevelForm,
	   				 id:'fourthLevel'+value.id,
	   				 cls:value.id,
	   				 expanded: false
	   			  });
	   			  var groupName=value.whetherBatches;
	   			  var limitedStudentTree= value.whetherLimitedSetOfStudent;
	   			 
	   		   	if(evalType==getExaminationTranslation('CNTRL_ACADEMICS') && !evalBasicform.
	   		   			findField('whetherDynamicScheme').getValue().isDynamicScheme){//This for Academics
	   		    	if(groupName&&!limitedStudentTree){//Group --Yes And  Limited Student-- No
	   		    	
	   		    		obj.childNodes[index].appendChild({
	   					 text:getExaminationTranslation('CREATE_GROUP'),
	   					 qtitle:'creategroupgrid',
	   					 cls:value.id,
	   					 leaf:true
	   					 });
	   		    	}else if(!groupName&&limitedStudentTree){
	   		    		
	   		    		obj.childNodes[index].appendChild({
	   		   			 text:getExaminationTranslation('LIMITED_STUDENT'),
	   		   			 qtitle:'creategroupformgrid',
	   		   		     cls:value.id,
	   		   			 leaf:true
	   		   		     });
	   		    	}else if(!groupName&&!limitedStudentTree){
	   		    		obj.childNodes[index].appendChild({
	   		   			 text:getExaminationTranslation('MAP_ELIGIBLE_STUDENT'),
	   		   			 qtitle:'mappedstudentgrid',
	   		   		     cls:value.id,
	   		   			 leaf:true
	   		   		     });
	   		    		obj.childNodes[index].appendChild({
		   		   			 text:getExaminationTranslation('VIEW_ELIGIBLE_STUDENT'),
		   		   			 qtitle:'creategroupformgrid',
		   		   		     cls:value.id,
		   		   			 leaf:true
		   		   		 });
	   		    		obj.childNodes[index].appendChild({
		   		   			 text:getExaminationTranslation('DETAINED_STUDENT'),
		   		   			 qtitle:'detainestudentgrid',
		   		   		     cls:value.id,
		   		   			 leaf:true
		   		   		 });
	   		    	}
	   		    	
	   		    	obj.childNodes[index].appendChild({
	   					 text:getExaminationTranslation('DEFINE_TOPIC_COVERAGE'),
	   					 qtitle:'definetopiccoverageform',
	   					 cls:value.id,
	   					 leaf:true
	   				 });
	   		    	
	   		        }else if(evalType==getExaminationTranslation('CNTRL_EXTERNAL_ORGANISATION')){//This for External organization
	   		        	if(groupName&&!limitedStudentTree){//Group --Yes And  Limited Student-- No
	   		        		obj.childNodes[index].appendChild({
	   		        			 text:getExaminationTranslation('CREATE_GROUP'),
	   		        			 qtitle:'creategroupgrid',
	   		        			 cls:value.id,
	   		        			 leaf:true
	   		        			 });
	   		            	}else if(!groupName&&limitedStudentTree){
	   		            		obj.childNodes[index].appendChild({
	   		           			 text:getExaminationTranslation('LIMITED_STUDENT'),
	   		           			 qtitle:'studentgridforexternalandother',
	   		           		     cls:value.id,
	   		           			 leaf:true
	   		           		     });
	   		            	}else if(!groupName&&!limitedStudentTree){
	   		            		obj.childNodes[index].appendChild({
	   		           			 text:getExaminationTranslation('ELIGIBLE_STUDENT'),
	   		           			 qtitle:'studentgridforexternalandother',
	   		           		     cls:value.id,
	   		           			 leaf:true
	   		           		     });
	   		            	}	
	   		    	}else if(evalType==getExaminationTranslation('CNTRL_OTHER')){// This for Other
	   		    		if(groupName&&!limitedStudentTree){//Group --Yes And  Limited Student-- No
	   		    			   obj.childNodes[index].appendChild({
	   		    				 text:getExaminationTranslation('CREATE_GROUP'),
	   		    				 qtitle:'creategroupgrid',
	   		    				 cls:value.id,
	   		    				 leaf:true
	   		    				 });
	   		    	    	}else if(!groupName&&limitedStudentTree){
	   		    	    		obj.childNodes[index].appendChild({
	   		    	   			 text:getExaminationTranslation('LIMITED_STUDENT'),
	   		    	   			 qtitle:'studentgridforexternalandother',
	   		    	   		     cls:value.id,
	   		    	   			 leaf:true
	   		    	   		     });
	   		    	    	}else if(!groupName&&!limitedStudentTree){
	   		    	    		
	   		    	    		obj.childNodes[index].appendChild({
	   		   		   			 text:getExaminationTranslation('MAP_ELIGIBLE_STUDENT'),
	   		   		   			 qtitle:'studentlistforother',
	   		   		   		     cls:value.id,
	   		   		   			 leaf:true
	   		   		   		     });
	   		   		    		obj.childNodes[index].appendChild({
	   			   		   			 text:getExaminationTranslation('VIEW_ELIGIBLE_STUDENT'),
	   			   		   			 qtitle:'studentunmapforother',
	   			   		   		     cls:value.id,
	   			   		   			 leaf:true
	   			   		   		 });
	   		    	    	}
	   		    		
	   		    	}
	   		    	if(value.whetherWrittenTest){
	   		    		obj.childNodes[index].appendChild({
		   					 text:getExaminationTranslation('ASSIGN_QUESTION_PAPER'),
		   					 qtitle:'assignquestionpaperform',
		   					 cls:value.id,
		   					 leaf:true
		   				 });
	   		    	 }
	   			 });
	   		  }
	   		 }
	   	  });
    },
    /**
	 * This Functon is used to open different tabs on click of edit and view button. 
	 */
    openEditingTabs:function(obj,boolean1){
    	var $this = this;
		var selectRec=obj.ownerCt.ownerCt.getSelectionModel().getSelection()[0];
		/**
		 * check if data is not selected at first time 
		 */
		if(selectRec!=undefined){
			
		var record=selectRec.parentNode;
		var tabDetail = record.data;
		var id = tabDetail.id;
		var childItem = tabDetail.qtitle;
		var tabName = tabDetail.text;
		
		var contentPanel = $this
		.getEvaluationdetailinnertabstructure();
		contentPanel.removeAll();
		if(childItem!=""){
			var tabFunctionalName=null;
			if(boolean1){
				tabFunctionalName=	'  '+getExaminationTranslation('EDIT');
			}else{
				tabFunctionalName=	'  '+getExaminationTranslation('VIEW');
			}
		if (contentPanel != undefined) {
			var newTab = contentPanel.items.findBy(function(tab) {
						return tab.title === tabName;
					}); 

			if (!newTab) {
				contentPanel.add({
					title : tabName + tabFunctionalName,
					closable : true,
					id : id,
					xtype : childItem,
					layout : 'fit'
				// activeTab :0
				}).show();
			}
			//contentPanel.setActiveTab(newTab);
			contentPanel.doLayout();
		}
	  }
		
		if(boolean1){
			$this.editFormTab(selectRec,record);	
		}else{
			$this.viewFormTabs(selectRec,record);
		}
		
      }else{
		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	 }
    },
    /**
	 * This Functon is used to call different form on click of edit button. 
	 */
    editFormTab:function(selectRec,parentRec){
    	var $this=this;
    	
    	if(parentRec.data.qtitle=='evaluationplanleveloneform'){
    		$this.editLevelOneForm(selectRec,parentRec);
    	}else if(parentRec.data.qtitle=='evaluationplanleveltwoform'){
    		$this.editLevelTwoForm(selectRec,parentRec);
    	}else if(parentRec.data.qtitle=='evaluationplansequenceform'){
    		$this.editEvaluationPlanSequenceForm(selectRec,parentRec);
    	}else if(parentRec.data.qtitle=='evaluationplansequencedetailform'){
	
			var form=$this.getEvaluationPlanSequenceDetailForm().getForm();             				
	  		var copyMarksGradeEvent =form.findField('copyMarksGradeEvent');
    	    if(copyMarksGradeEvent.value == null || copyMarksGradeEvent.value == " " || copyMarksGradeEvent.value == undefined){
	    	    copyMarksGradeEvent.setDisabled(true);
	    	}else{
	    		copyMarksGradeEvent.setDisabled(false);	
	    	}
	
    		$this.editEvaluationPlanSequenceDetailForm(selectRec,parentRec);
    	}
    },
    /**
	 * This Functon is used to call different form on click of view button. 
	 */
    viewFormTabs:function(selectRec,parentRec){
    	var $this=this;
    	if(parentRec.data.qtitle=='evaluationplanleveloneform'){
    		$this.editLevelOneForm(selectRec,parentRec);
    		var levelFormOne=$this.getEvaluationPlanLeveloneForm().getForm();
    		toggleReadOnlyFormItems(levelFormOne,true);
    		var button=Ext.ComponentQuery.query('button#addButtonItemId')[0];
    		button.hide();
    		button.nextSibling().hide();
    	}else if(parentRec.data.qtitle=='evaluationplanleveltwoform'){
    		$this.editLevelTwoForm(selectRec,parentRec);
    		var levelFormTwo=$this.getEvaluationPlanLeveltwoForm().getForm();
    		toggleReadOnlyFormItems(levelFormTwo,true);
    		var button=Ext.ComponentQuery.query('button#levelTwoAddButtonId')[0];
    		button.hide();
    		button.nextSibling().hide();
    	}else if(parentRec.data.qtitle=='evaluationplansequenceform'){
    		$this.editEvaluationPlanSequenceForm(selectRec,parentRec);
    		var evalSequenceForm=$this.getEvaluationPlanSequenceForm().getForm();
    		toggleReadOnlyFormItems(evalSequenceForm,true);
    		var button=Ext.ComponentQuery.query('button#evaluationSequenceAddButtonId')[0];
    		button.hide();
    		button.nextSibling().hide();
    	}else if(parentRec.data.qtitle=='evaluationplansequencedetailform'){
    		$this.editEvaluationPlanSequenceDetailForm(selectRec,parentRec);
    		var evalSequenceDetailForm=$this.getEvaluationPlanSequenceDetailForm().getForm();
    		toggleReadOnlyFormItems(evalSequenceDetailForm,true);
    		var button=Ext.ComponentQuery.query('button#evaluationDetailFormAddButtonId')[0];
    		button.hide();
    		button.nextSibling().hide();
    	}
    },
    /**
	 * This Functon is used to populate data on first level form. 
	 */
    editLevelOneForm:function(selectRec,parentRec){
    	var $this=this;
    	Ext.Ajax.request({
  	   		 type: 'rest',
  	   		 url: SERVERURL.EVALUATION_PLAN_LEVEL_ONE_FORM_FIND_BY_ID,
  	   		 method: 'GET',
  	   		 params:{
  	   			id:selectRec.data.cls
  	   		 },
  	   		 success: function(rsp, action) {
  	   			var data = rsp.responseText;
  	   			
  	   			if(data!=null&&data!=""){
  	   			var jData=Ext.JSON.decode(data);
  	   			var levelFormOne=$this.getEvaluationPlanLeveloneForm().getForm();
  	   		    var evaluationTypeAcademicField=levelFormOne.findField('evaluationTypeAcademic');
  	   		    var evaluationTypeExternalField=levelFormOne.findField('evaluationTypeExternal');
  	        	var evaluationTypeOtherField=levelFormOne.findField('evaluationTypeOther');
  	        	var weightageField=levelFormOne.findField('weightage');
  	        	var whetherPassesCriticalIdField=levelFormOne.findField('whetherPassesCriticalId').items.items;
  	        	var allowblankFalse = '<span class="required" style="color:red"> *</span>';
  	        	levelFormOne.findField('id').setValue(jData.id);
  	        	levelFormOne.findField('evaluationPlanId').setValue(jData.evaluationPlanId);
  	        	levelFormOne.findField('evalPlanLevelOneStatus').setValue(jData.evalPlanLevelOneStatus);
  	        	var repetitionType= levelFormOne.findField('repetitionType');
       			var eventTobeRepeated = levelFormOne.findField('eventTobeRepeated');
       			var resultPublishMode = levelFormOne.findField('resultPublishMode');
       			var obeWeightageField = levelFormOne.findField('obeWeightage');
       			var whetherFinalPromotionLevel = levelFormOne.findField('whetherFinalPromotionLevel');
       			whetherFinalPromotionLevel.setValue(jData.whetherFinalPromotionLevel);
       			obeWeightageField.setValue(jData.obeWeightage);
       			
       			
       			var supplementaryDrool =levelFormOne.findField('supplementaryDrool');
  	        	/**
  	        	 * Here combo value is set as raw value and taken its eval level id as in hidden field 
  	        	 */
  	   	         if(!evaluationTypeAcademicField.isHidden()){
  	   	            evaluationTypeAcademicField.getStore().getProxy().extraParams = {
	 					evaluationPlanId:jData.evaluationPlanId,
	 					notTypeId:jData.id
					   };
  	   	             evaluationTypeAcademicField.getStore().load({
						 callback: function(records, operation, success) {
		          			 if (success) {
		          				 for(var i in records) {
		          					 if(jData.levelName.toLowerCase() === records[i].data.value.toLowerCase()) {
		          						evaluationTypeAcademicField.setValue(records[i].data.id);
		          						evaluationTypeAcademicField.setRawValue(records[i].data.value);
		          						if(!isNullOrEmpty(records[i].data.code) && 
		          								records[i].data.code=="true"){
		          							resultPublishMode.reset();
		          							resultPublishMode.enable();
		          							resultPublishMode.setVisible(true);
		          							resultPublishMode.setValue(jData.resultPublishMode);
		          						}else{
		          							resultPublishMode.reset();
		          							resultPublishMode.disable();
		          							resultPublishMode.setVisible(false);
		          						}
		          						levelFormOne.isValid();
		          					 }
		          				 }
		          			 }
		          		 }
					});
//  	   	            evaluationTypeAcademicField.setReadOnly(true);
  	   	         }else if(!evaluationTypeExternalField.isHidden()){
  	   	             evaluationTypeExternalField.getStore().load({
						 callback: function(records, operation, success) {
		          			 if (success) {
		          				evaluationTypeExternalField.setRawValue(jData.levelName);
		          				for(var i in records) {
		          					if(jData.levelName.toLowerCase() === records[i].data.value.toLowerCase()) {
		          					if(!isNullOrEmpty(records[i].data.code) && 
	          								records[i].data.code=="true"){
			          					resultPublishMode.reset();
	          							resultPublishMode.enable();
	          							resultPublishMode.setVisible(true);
	          							resultPublishMode.setValue(jData.resultPublishMode);
	          						}else{
	          							resultPublishMode.reset();
	          							resultPublishMode.disable();
	          							resultPublishMode.setVisible(false);
	          						}
		          				}
		          				}
		          			 }
		          		 }
					});
  	   	         }else if(!evaluationTypeOtherField.isHidden()){
  	   	        	 
  	   	              evaluationTypeOtherField.getStore().load({
 						 callback: function(records, operation, success) {
 		          			 if (success) {
 		          				evaluationTypeOtherField.setValue(jData.evaluationPlanOtherCategoryId);
 		          				for(var i in records) {
 		          					if(jData.levelName.toLowerCase() === records[i].data.value.toLowerCase()) {
 		 		          				if(!isNullOrEmpty(records[i].data.code) && 
 		          								records[i].data.code=="true"){
 		 		          					resultPublishMode.reset();
 		          							resultPublishMode.enable();
 		          							resultPublishMode.setVisible(true);
 		          							resultPublishMode.setValue(jData.resultPublishMode);
 		          						}else{
 		          							resultPublishMode.reset();
 		          							resultPublishMode.disable();
 		          							resultPublishMode.setVisible(false);
 		          						}
 		 		          			 }
 		          				}
 		          			 }
 		          		 }
 					});
    	   	      }
  	   	         
  	   	         if(!weightageField.isHidden()){
  	   	             weightageField.setValue(jData.levelValue);
  	   	           }
  	   	         levelFormOne.findField('whetherPassesCriticalId').setDisabled(false);
  	   	         if(jData.whetherPassingCritical){
  	   	            whetherPassesCriticalIdField[0].setValue(true);
  	   	            whetherPassesCriticalIdField[1].setValue(false);
  	   	            repetitionType.getStore().load({
			  		  callback: function(records, operation, success) {
	          			 if (success) {
	          				repetitionType.setValue(jData.repetitionType);
	          				if(jData.repetitionType=="EVENT_LEVEL") {
		  	   	            	eventTobeRepeated.getStore().getProxy().extraParams={
		  	   	            		levelId:selectRec.data.cls,
		  	   	            		levelName:'Assessment Type'
		  	   	            	};
		  	   	            	eventTobeRepeated.getStore().load({
						  		  callback: function(records, operation, success) {
				          			 if (success) {
				          				eventTobeRepeated.setValue(jData.repeatedEventId);
				          				eventTobeRepeated.setFieldLabel(eventTobeRepeated.getFieldLabel());
				          				$this.setAllowBlank(eventTobeRepeated,false);
					   	            	eventTobeRepeated.setVisible(true);
					   	            	eventTobeRepeated.allowBlank=false;
				          			 }
						  		  }
		  	   	            	});
		  	   	            }
	          			 }
			  		  }
			  		});
  	   	         }else if(!jData.whetherPassingCritical){
  	   	            whetherPassesCriticalIdField[0].setValue(false);
  	   	            whetherPassesCriticalIdField[1].setValue(true);
  	   	         }
  	   	         
  	   	       /**
	        	 * load print name in marksheet on the bases of evaluationTypeAcademicField,evaluationTypeExternalField,evaluationTypeOtherField.
	        	 */
	        	var printNameInMarksheetField=levelFormOne.findField('printNameInMarksheet');
	        	   // printNameInMarksheetField.allowBlank=true;
	 			  //  printNameInMarksheetField.setVisible(false);
	 			    printNameInMarksheetField.reset();
  	   	        var showInMarksheetField=levelFormOne.findField('showInMarksheet').items.items; 
  	   	         if(jData.whetherShowInMarksheet){
  	   	             showInMarksheetField[0].setValue(true);
  	   	             showInMarksheetField[1].setValue(false);
  	   	             
		  	   	        // printNameInMarksheetField.allowBlank=false;
					    // printNameInMarksheetField.setVisible(true);
			   	      if(!evaluationTypeAcademicField.isHidden()){
			   	    	 printNameInMarksheetField.setFieldLabel(getExaminationTranslation('EVALUATION_PLAN_TO_BE_PRINTED'));
			   	    	 printNameInMarksheetField.setValue(jData.levelName);
			   	      }else if(!evaluationTypeExternalField.isHidden()){
			   	    	 printNameInMarksheetField.setFieldLabel(getExaminationTranslation('EXTERNAL_COURSE_TO_BE_PRINTED'));
			   	    	 printNameInMarksheetField.setValue(jData.levelName);
			   	      }else if(!evaluationTypeOtherField.isHidden()){
			   	    	 printNameInMarksheetField.setFieldLabel(getExaminationTranslation('CATEGORY_TO_BE_PRINTED'));
			   	    	 printNameInMarksheetField.setValue(jData.levelName);
			   	      }
			   	       $this.setAllowBlank(printNameInMarksheetField,false);
  
    
	   	         }else if(!jData.whetherShowInMarksheet){
	   	        	showInMarksheetField[0].setValue(false);
	   	        	showInMarksheetField[1].setValue(true);
	   	         }
	  	   	    if(!isNullOrEmpty(jData.printNameInMarksheet)){
			    	 printNameInMarksheetField.setValue(jData.printNameInMarksheet);
				}
  	   	         
	  	   	    var whetherRemarkField=levelFormOne.findField('whetherRemarkRadioGroup').items.items; 
	   	        if(jData.whetherRemark){
	   	        	whetherRemarkField[0].setValue(true);
	   	        	whetherRemarkField[1].setValue(false);
	   	        }else if(!jData.whetherRemark){
	  	        	whetherRemarkField[0].setValue(false);
	  	        	whetherRemarkField[1].setValue(true);
	  	        }
	   	         
	   	        var remarkOnlyField=levelFormOne.findField('remarkOnlyRadioGroup').items.items; 
	   	        if(jData.remarkOnlyAssessment){
	   	        	remarkOnlyField[0].setValue(true);
	   	        	remarkOnlyField[1].setValue(false);
	   	        }else if(!jData.whetherRemark){
	   	        	remarkOnlyField[0].setValue(false);
	   	        	remarkOnlyField[1].setValue(true);
	  	        }
  	   	        var marksOrGradeField=levelFormOne.findField('marksOrGrade');
  	   	        
  	   	        if(jData.marksOrGrade!=null){
  	   	             marksOrGradeField.getStore().load({
						 callback: function(records, operation, success) {
		         			 if (success) {
		         				marksOrGradeField.setValue(jData.marksOrGrade);
		         			 }
		         		 }
					});
  	   	          }      
  	   	                
  	   	            var minMarksOrGradeNumberField=levelFormOne.findField('minMarksOrGradeNumber');
  	   	            var maxMarksOrGradeNumberField=levelFormOne.findField('maxMarksOrGradeNumber');
	       			var minMarksOrGradeComboField=levelFormOne.findField('minMarksOrGradeCombo');
	       			var maxMarksOrGradeComboField=levelFormOne.findField('maxMarksOrGradeCombo');
	       			
//	       			var minMarksOrGradeAwardNumberField=levelFormOne.findField('minMarksOrGradeAwardNumber');
//	       			var maxMarksOrGradeAwardNumberField=levelFormOne.findField('maxMarksOrGradeAwardNumber');
	       			
	       			var minMarksOrGradeAwardComboField=levelFormOne.findField('minMarksOrGradeAwardCombo');
	       			var maxMarksOrGradeAwardComboField=levelFormOne.findField('maxMarksOrGradeAwardCombo');
	       			var failMarksToBeAwarded=levelFormOne.findField('failMarksToBeAwarded');
	       	    	var failGradeToBeAwarded=levelFormOne.findField('failGradeToBeAwarded');
	       	    	
	       			var gradeTypeField=levelFormOne.findField('gradeType');    
  	   	                
                    gradeTypeField.allowBlank=true;
    				
    				minMarksOrGradeComboField.allowBlank=true;
    				maxMarksOrGradeComboField.allowBlank=true;
    				minMarksOrGradeNumberField.allowBlank=true;
    				maxMarksOrGradeNumberField.allowBlank=true;
	       			
	       			gradeTypeField.setVisible(false);
    				
    				minMarksOrGradeComboField.setVisible(false);
    				maxMarksOrGradeComboField.setVisible(false);
    				minMarksOrGradeNumberField.setVisible(false);
    				maxMarksOrGradeNumberField.setVisible(false);
    				
    				var calculateAverageField=levelFormOne.findField('calculateAverage').items.items; 
    				if(jData.whetherCalculateAverage){
    					calculateAverageField[0].setValue(true);
    					calculateAverageField[1].setValue(false);
    				}else if(!jData.whetherCalculateAverage){
    					calculateAverageField[0].setValue(false);
    					calculateAverageField[1].setValue(true);
    				}
    				
    				//minMarksOrGradeAwardNumberField.setVisible(false);
    				//maxMarksOrGradeAwardNumberField.setVisible(false);
    				
    				//minMarksOrGradeAwardComboField.setVisible(false);
    				//maxMarksOrGradeAwardComboField.setVisible(false);
    				
    				if(jData.marksOrGrade==getExaminationTranslation('CNTRL_MARK')){
        				
    					minMarksOrGradeNumberField.allowBlank=false;
        				maxMarksOrGradeNumberField.allowBlank=false;
    					
        				minMarksOrGradeNumberField.setVisible(true);
        				maxMarksOrGradeNumberField.setVisible(true);
        				
        				//minMarksOrGradeAwardNumberField.setVisible(true);
        				//maxMarksOrGradeAwardNumberField.setVisible(true);
        				
                        minMarksOrGradeNumberField.setValue(jData.minMarksOrGrade);
                        maxMarksOrGradeNumberField.setValue(jData.maxMarksOrGrade);
        				
        				//minMarksOrGradeAwardNumberField.setValue(jData.minMarksOrGradeAward);
        				//maxMarksOrGradeAwardNumberField.setValue(jData.maxMarksOrGradeAward);
        				if(jData.whetherPassingCritical){
        					supplementaryDrool.setVisible(true);
        					supplementaryDrool.setValue(jData.supplementaryDrool);
        					failMarksToBeAwarded.setVisible(true);
       		         		failMarksToBeAwarded.setValue(jData.failMarksGradeToBeAwarded);
	       		         	if(minMarksOrGradeNumberField.getValue()>0) {
	    		    			failMarksToBeAwarded.maxValue=minMarksOrGradeNumberField.getValue()-1;
	    		    		} else {
	    		    			failMarksToBeAwarded.maxValue=minMarksOrGradeNumberField.getValue()!=null?
	    		    					minMarksOrGradeNumberField.getValue():0;
	    		    		}
//	    					if(minMarksOrGradeAwardNumberField.getValue()==null) {
//	    						failMarksToBeAwarded.minValue=0;
//	    					} else {
//	    						failMarksToBeAwarded.minValue=minMarksOrGradeAwardNumberField.getValue();
//	    					}
        				}
        			}else if(jData.marksOrGrade==getExaminationTranslation('CNTRL_GRADE')){
        				gradeTypeField.allowBlank=false;
        				gradeTypeField.setFieldLabel(gradeTypeField.getFieldLabel());
        				$this.setAllowBlank(gradeTypeField,false);
        				minMarksOrGradeComboField.allowBlank=false;
        				maxMarksOrGradeComboField.allowBlank=false;
        				if(jData.whetherPassingCritical){
        					supplementaryDrool.setVisible(true);
        					supplementaryDrool.setValue(jData.supplementaryDrool);
        					
        					failGradeToBeAwarded.setVisible(true);
        					failGradeToBeAwarded.getStore().load({
        						callback: function(records, operation, success) {
       		         			 if (success) {
       		         				failGradeToBeAwarded.setValue(jData.failMarksGradeToBeAwarded);
       		         			 }
       		         		 }
        					});
        					failGradeToBeAwarded.setFieldLabel(failGradeToBeAwarded.getFieldLabel());
        					$this.setAllowBlank(failGradeToBeAwarded,false);
        				}
        				gradeTypeField.setVisible(true);
        				
        				minMarksOrGradeComboField.setVisible(true);
        				maxMarksOrGradeComboField.setVisible(true);
    					//minMarksOrGradeAwardComboField.setVisible(true);
        				//maxMarksOrGradeAwardComboField.setVisible(true);
        				minMarksOrGradeComboField.setFieldLabel(minMarksOrGradeComboField.getFieldLabel());
        				$this.setAllowBlank(minMarksOrGradeComboField,false);
 	    				maxMarksOrGradeComboField.setFieldLabel(maxMarksOrGradeComboField.getFieldLabel());
 	    				$this.setAllowBlank(maxMarksOrGradeComboField,false);
        				
        				if(jData.gradeType!=null){
        					gradeTypeField.getStore().load({
       						 callback: function(records, operation, success) {
       		          			 if (success) {
       		          				gradeTypeField.setValue(jData.gradeType);
       		          			 }
       		          		 }
       					  });
            				
        					minMarksOrGradeComboField.getStore().getProxy().extraParams = {
        						    gradeType:jData.gradeType
        						   };
        					
        					if(jData.minMarksOrGrade!=null){
        						minMarksOrGradeComboField.getStore().load({
       							 callback: function(records, operation, success) {
       			          			 if (success) {
       			          				minMarksOrGradeComboField.setValue(jData.minMarksOrGrade);
       			          			 }
       			          		 }
       						  });        						
        					}
        					if(jData.maxMarksOrGrade!=null){
        						maxMarksOrGradeComboField.getStore().load({
       							 callback: function(records, operation, success) {
       			          			 if (success) {
       			          			maxMarksOrGradeComboField.setValue(jData.maxMarksOrGrade);
       			          			 }
       			          		 }
       						  });        						
        					}
        					
        					/*if(jData.minMarksOrGradeAward!=null){
        					minMarksOrGradeAwardComboField.getStore().load({
   							 callback: function(records, operation, success) {
   			          			 if (success) {
   			          			minMarksOrGradeAwardComboField.setValue(jData.minMarksOrGradeAward);
   			          			 }
   			          		   }
   						     });
        					}
        					
        					if(jData.maxMarksOrGradeAward!=null){
        					maxMarksOrGradeAwardComboField.getStore().load({
   							 callback: function(records, operation, success) {
   			          			 if (success) {
   			          			maxMarksOrGradeAwardComboField.setValue(jData.maxMarksOrGradeAward);
   			          			 }
   			          		   }
   						     });
        					}*/
        				}
        		    }
    				
    				if(jData.roundingMode!=null){
    					var roundingMode=levelFormOne.findField('roundingMode');
    					roundingMode.getStore().load({
    						callback:function(){
    							roundingMode.setValue(jData.roundingMode);		
    						}
    					});
    				}

    				if(jData.roundingCount!=null){
    					var roundingCount=levelFormOne.findField('roundingCount');
    					setTimeout(function(){
    						roundingCount.setValue(jData.roundingCount);
    				  	},300);
    				}
    				
    				levelFormOne.isValid();
  	   		   }
  	   		 }
      	   }); 
    	
    },
    
    /**
	 * This Functon is used to populate data on Second level form. 
	 */
	    editLevelTwoForm:function(selectRec,parentRec){	
	    	var $this=this;
	    	Ext.Ajax.request({
	  	   		 type: 'rest',
	  	   		 url: SERVERURL.EVALUATION_PLAN_LEVEL_TWO_FORM_FIND_BY_ID,
	  	   		 method: 'GET',
	  	   		 params:{
	  	   			id:selectRec.data.cls
	  	   		 },
	  	   		 success: function(rsp, action) {
	  	   			var data = rsp.responseText;
	  	   		if(data!=null&&data!=""){
	  	   			var jData=Ext.JSON.decode(data);
	  	   		    var levelFormTwo=$this.getEvaluationPlanLeveltwoForm().getForm();
		  	   		var courseComponentAcademicField=levelFormTwo.findField('courseComponentAcademic');
	  	   		    var courseComponentExternalField=levelFormTwo.findField('courseComponentExternal');
	  	        	var courseComponentOtherField=levelFormTwo.findField('courseComponentOther');
	  	        	var weightageField=levelFormTwo.findField('weightage');
	  	        	var whetherPassesCriticalIdField=levelFormTwo.findField('whetherPassesCriticalId').items.items;
	  	        	
	  	        	var whetherFinalPromotionLevel = levelFormTwo.findField('whetherFinalPromotionLevel');
	       			whetherFinalPromotionLevel.setValue(jData.whetherFinalPromotionLevel);
	  	        	levelFormTwo.findField('id').setValue(jData.id);
	  	        	levelFormTwo.findField('evaluationPlanOneId').setValue(jData.evaluationPlanOneId);
	  	        	levelFormTwo.findField('evaluationPlan2LevelStatus').setValue(jData.evaluationPlan2LevelStatus);
	       			var repetitionType= levelFormTwo.findField('repetitionType');
	       			var eventTobeRepeated = levelFormTwo.findField('eventTobeRepeated');
	       			var resultPublishMode = levelFormTwo.findField('resultPublishMode');
	       			var allowblankFalse = '<span class="required" style="color:red"> *</span>';

	       			var obeWeightageField = levelFormTwo.findField('obeWeightage');
	       			var supplementaryDrool = levelFormTwo.findField('supplementaryDrool');
                    var WhetherLatestmarksRuleApplicable = levelFormTwo.findField('WhetherLatestmarksRuleApplicable');
                    WhetherLatestmarksRuleApplicable.setValue(jData.whetherLatest);
	       			//obeWeightageField.setValue(jData.obeWeightage);
	  	        	/**
	  	        	 * Here combo value is set as raw value and taken its eval level id as in hidden field 
	  	        	 */
	  	        	
	  	        //	courseComponentAcademicField.setVisible(false);
	  	        	courseComponentAcademicField.allowBlank=true;
	  	        //	courseComponentExternalField.setVisible(false);
	  	        	courseComponentExternalField.allowBlank=true;
	  	        //	courseComponentOtherField.setVisible(false);
	  	        	courseComponentOtherField.allowBlank=true;
	  	   	         if(!courseComponentAcademicField.isHidden()){
	  	   	        	 
	  	   	        courseComponentAcademicField.setVisible(true);
	  	   	        courseComponentAcademicField.allowBlank=false;
	  	   	        courseComponentAcademicField.getStore().getProxy().extraParams={
	  	   	        	evaluationPlanLevelOneId:jData.evaluationPlanOneId,
	  	   	        	notSubTypeId:jData.id
	  	   	        };
	  	   	        courseComponentAcademicField.getStore().load({
	  	   	        	callback: function(records, operation, success) {
	  	   	        		if (success) {

	  	   	        			for(var i in records) {
	  	   	        				if(jData.levelName.toLowerCase() === records[i].data.value.toLowerCase()) {
	  	   	        					courseComponentAcademicField.setValue(records[i].data.id);
	  	   	        					courseComponentAcademicField.setRawValue(records[i].data.value);
	  	   	        					levelFormTwo.isValid();
	  	   	        					if(!isNullOrEmpty(records[i].data.code) && 
	          								records[i].data.code=="true"){
	          							resultPublishMode.reset();
	          							resultPublishMode.enable();
	          							resultPublishMode.setVisible(true);
	          							resultPublishMode.setValue(jData.resultPublishMode);
	  	   	        					}else{
	          							resultPublishMode.reset();
	          							resultPublishMode.disable();
	          							resultPublishMode.setVisible(false);
	  	   	        					}
	  	   	        				}
	  	   	        			}
	  	   	        		}
	  	   	        	}
	  	   	        });
//	  	   	         courseComponentAcademicField.setReadOnly(true);
	  	   	         }else if(!courseComponentExternalField.isHidden()){
	  	   	        	 
	  	   	        courseComponentExternalField.setVisible(true);
	  	   	        courseComponentExternalField.allowBlank=false;
	  	   	        courseComponentExternalField.getStore().load({
	  	   	        	callback: function(records, operation, success) {
	  	   	        		if (success) {
	  	   	        			courseComponentExternalField.setRawValue(jData.levelName);
	  	   	        			for(var i in records) {
	  	   	        				if(jData.levelName.toLowerCase() === records[i].data.value.toLowerCase()) {
	  	   	        					if(!isNullOrEmpty(records[i].data.code) && 
	  	   	        							records[i].data.code=="true"){
	  	   	        						resultPublishMode.reset();
	  	   	        						resultPublishMode.enable();
	  	   	        						resultPublishMode.setVisible(true);
	  	   	        						resultPublishMode.setValue(jData.resultPublishMode);
	  	   	        					}else{
	  	   	        						resultPublishMode.reset();
	  	   	        						resultPublishMode.disable();
	  	   	        						resultPublishMode.setVisible(false);
	  	   	        					}
	  	   	        				}
	  	   	        			}
	  	   	        		}
	  	   	        	}
						});
	  	   	          courseComponentExternalField.setReadOnly(true);
	  	   	         }else if(!courseComponentOtherField.isHidden()){
	  	   	        	 
	  	   	        courseComponentOtherField.setVisible(true);
	  	   	        courseComponentOtherField.allowBlank=false;
	  	   	        courseComponentOtherField.getStore().load({
	 						 callback: function(records, operation, success) {
	 							 if (success) {
	 								 courseComponentOtherField.setValue(jData.evaluationPlanOtherSubCategoryId);
	 								 for(var i in records) {
	 									 if(jData.levelName.toLowerCase() === records[i].data.value.toLowerCase()) {
	 										 if(!isNullOrEmpty(records[i].data.code) && 
	 												 records[i].data.code=="true"){
	 											 resultPublishMode.reset();
	 											 resultPublishMode.enable();
	 											 resultPublishMode.setVisible(true);
	 											 resultPublishMode.setValue(jData.resultPublishMode);
	 										 }else{
	 											 resultPublishMode.reset();
	 											 resultPublishMode.disable();
	 											 resultPublishMode.setVisible(false);
	 										 }
	 									 }
	 								 }
	 							 }
	 		          		 }
	 					});
//	  	   	          courseComponentOtherField.setReadOnly(true);
	    	   	      }
	  	   	         
	  	   	         if(!weightageField.isHidden()){
	  	   	             weightageField.setValue(jData.levelValue);
	  	   	           }
	  	   	         levelFormTwo.findField('whetherPassesCriticalId').setDisabled(false);
	  	   	         if(jData.whetherPassingCritical){
	  	   	            whetherPassesCriticalIdField[0].setValue(true);
	  	   	            whetherPassesCriticalIdField[1].setValue(false);
	  	   	            repetitionType.getStore().load({
				  		  callback: function(records, operation, success) {
		          			 if (success) {
		          				repetitionType.setValue(jData.repetitionType);
		          				if(jData.repetitionType=="EVENT_LEVEL") {
			  	   	            	eventTobeRepeated.getStore().getProxy().extraParams={
			  	   	            		levelId:selectRec.data.cls,
			  	   	            		levelName:'Assessment Sub Type'
			  	   	            	};
			  	   	            	eventTobeRepeated.getStore().load({
							  		  callback: function(records, operation, success) {
					          			 if (success) {
					          				eventTobeRepeated.setValue(jData.repeatedEventId);
					          				eventTobeRepeated.setFieldLabel(eventTobeRepeated.getFieldLabel());
					          				$this.setAllowBlank(eventTobeRepeated,false);
					          				eventTobeRepeated.setVisible(true);
						   	            	eventTobeRepeated.allowBlank=false;
					          			 }
							  		  }
			  	   	            	});
				   	            	
				   	            	
			  	   	            }
		          			 }
				  		  }
				  		});
	  	   	         }else if(!jData.whetherPassingCritical){
	  	   	            whetherPassesCriticalIdField[0].setValue(false);
	  	   	            whetherPassesCriticalIdField[1].setValue(true);
	  	   	         }
	  	   	         
	  	   	       /**
    	        	 * load print name in marksheet on the bases of evaluationTypeAcademicField,evaluationTypeExternalField,evaluationTypeOtherField.
    	        	 */
    	        	var printNameInMarksheetField=levelFormTwo.findField('printNameInMarksheet');
    	        	   // printNameInMarksheetField.allowBlank=true;
  	 			       // printNameInMarksheetField.setVisible(false);
  	 			        printNameInMarksheetField.reset();
  	 			        
		  	   	    var showInMarksheetField=levelFormTwo.findField('showInMarksheet').items.items; 
	 	   	         if(jData.whetherShowInMarksheet){
	 	   	             showInMarksheetField[0].setValue(true);
	 	   	             showInMarksheetField[1].setValue(false);
	 	   	             
		 	   	        // printNameInMarksheetField.allowBlank=false;
	 	 			    // printNameInMarksheetField.setVisible(true);
	 	   	             
	 	   	           if(!courseComponentAcademicField.isHidden()){
			   	    	  printNameInMarksheetField.setFieldLabel(getExaminationTranslation('COURSE_COMPONENT_TO_BE_PRINTED'));
			   	    	  printNameInMarksheetField.setValue(jData.levelName);
			   	        }else if(!courseComponentExternalField.isHidden()){
			   	    	  printNameInMarksheetField.setFieldLabel(getExaminationTranslation('COURSE_ASSESSMENT_TO_BE_PRINTED'));
			   	    	  printNameInMarksheetField.setValue(jData.levelName);
			   	        }else if(!courseComponentOtherField.isHidden()){
			   	    	  printNameInMarksheetField.setFieldLabel(getExaminationTranslation('SUB_CATEGORY_TO_BE_PRINTED'));
			   	    	  printNameInMarksheetField.setValue(jData.levelName);
			   	        }
	 	   	           $this.setAllowBlank(printNameInMarksheetField,false);
		   	         }else if(!jData.whetherShowInMarksheet){
		   	        	showInMarksheetField[0].setValue(false);
		   	        	showInMarksheetField[1].setValue(true);
		   	         }
	 	   	         
	 	   	         if(!isNullOrEmpty(jData.printNameInMarksheet)){
	 	   	        	 printNameInMarksheetField.setValue(jData.printNameInMarksheet);
	 	   	         }
	 	   	         
		 	   	    var contributeToDetentionField=levelFormTwo.findField('contributeToDetentionRadioGroup').items.items; 
	 	   	          if(jData.contributeToDetention){
	 	   	        	contributeToDetentionField[0].setValue(true);
	 	   	        	contributeToDetentionField[1].setValue(false);
		   	          }else if(!jData.contributeToDetention){
		   	        	contributeToDetentionField[0].setValue(false);
		   	        	contributeToDetentionField[1].setValue(true);
		   	          }
	 	   	          
		 	   	    var whetherRemarkField=levelFormTwo.findField('whetherRemarkRadioGroup').items.items; 
	 	   	        if(jData.whetherRemark){
	 	   	        	whetherRemarkField[0].setValue(true);
	 	   	            whetherRemarkField[1].setValue(false);
		   	        }else if(!jData.whetherRemark){
		   	        	whetherRemarkField[0].setValue(false);
		   	        	whetherRemarkField[1].setValue(true);
		   	        }
	 	   	        
	 	   	        var remarkOnlyField=levelFormTwo.findField('remarkOnlyRadioGroup').items.items; 
		   	        if(jData.remarkOnlyAssessment){
		   	        	remarkOnlyField[0].setValue(true);
		   	        	remarkOnlyField[1].setValue(false);
		   	        }else if(!jData.whetherRemark){
		   	        	remarkOnlyField[0].setValue(false);
		   	        	remarkOnlyField[1].setValue(true);
		  	        }
	 	   	        var marksOrGradeField=levelFormTwo.findField('marksOrGrade');
	 	   	        
	 	   	        if(jData.marksOrGrade!=null){
	 	   	             marksOrGradeField.getStore().load({
							 callback: function(records, operation, success) {
			         			 if (success) {
			         				marksOrGradeField.setValue(jData.marksOrGrade);
			         			 }
			         		 }
						});
	 	   	        }      
	 	   	           
	 	   	        var calculateAverageField=levelFormTwo.findField('calculateAverage').items.items; 
	 	   	        if(jData.whetherCalculateAverage){
	 	   	        	calculateAverageField[0].setValue(true);
	 	   	        	calculateAverageField[1].setValue(false);
	 	   	        }else if(!jData.whetherCalculateAverage){
	 	   	        	calculateAverageField[0].setValue(false);
	 	   	        	calculateAverageField[1].setValue(true);
	 	   	        }
				
	 	   	        var zscoreField=levelFormTwo.findField('zscoreId').items.items; 
	 	   	        if(jData.whetherZScore){
	 	   	        zscoreField[0].setValue(true);
	 	   	        zscoreField[1].setValue(false);
	 	   	        }else if(!jData.whetherCalculateAverage){
	 	   	        zscoreField[0].setValue(false);
	 	   	        zscoreField[1].setValue(true);
	 	   	        }
	 	   	            var minMarksOrGradeNumberField=levelFormTwo.findField('minMarksOrGradeNumber');
	 	   	            var maxMarksOrGradeNumberField=levelFormTwo.findField('maxMarksOrGradeNumber');
		       			var minMarksOrGradeComboField=levelFormTwo.findField('minMarksOrGradeCombo');
		       			var maxMarksOrGradeComboField=levelFormTwo.findField('maxMarksOrGradeCombo');
		       			
		       			//var minMarksOrGradeAwardNumberField=levelFormTwo.findField('minMarksOrGradeAwardNumber');
		       			//var maxMarksOrGradeAwardNumberField=levelFormTwo.findField('maxMarksOrGradeAwardNumber');
		       			
		       			//var minMarksOrGradeAwardComboField=levelFormTwo.findField('minMarksOrGradeAwardCombo');
		       			//var maxMarksOrGradeAwardComboField=levelFormTwo.findField('maxMarksOrGradeAwardCombo');
		       			var failMarksToBeAwarded=levelFormTwo.findField('failMarksToBeAwarded');
		       	    	var failGradeToBeAwarded=levelFormTwo.findField('failGradeToBeAwarded');
		       			
		       			var gradeTypeField=levelFormTwo.findField('gradeType');    
	 	   	                
		       			gradeTypeField.allowBlank=true;
		       			minMarksOrGradeComboField.allowBlank=true;
		   				maxMarksOrGradeComboField.allowBlank=true;
		   				minMarksOrGradeNumberField.allowBlank=true;
		   				maxMarksOrGradeNumberField.allowBlank=true;
		   				
		       			gradeTypeField.setVisible(false);
	   				
		   				minMarksOrGradeComboField.setVisible(false);
		   				maxMarksOrGradeComboField.setVisible(false);
		   				minMarksOrGradeNumberField.setVisible(false);
		   				maxMarksOrGradeNumberField.setVisible(false);
		   				
		   				//minMarksOrGradeAwardNumberField.setVisible(false);
		   				//maxMarksOrGradeAwardNumberField.setVisible(false);
		   				
		   				//minMarksOrGradeAwardComboField.setVisible(false);
		   				//maxMarksOrGradeAwardComboField.setVisible(false);
	   				
	   				if(jData.marksOrGrade==getExaminationTranslation('CNTRL_MARK')){
	   					
	   					minMarksOrGradeNumberField.allowBlank=false;
	       				maxMarksOrGradeNumberField.allowBlank=false;
	       				minMarksOrGradeNumberField.setVisible(true);
	       				maxMarksOrGradeNumberField.setVisible(true);
	       				
	       				//minMarksOrGradeAwardNumberField.setVisible(true);
	       				//maxMarksOrGradeAwardNumberField.setVisible(true);
	       				
	                    minMarksOrGradeNumberField.setValue(jData.minMarksOrGrade);
	                    maxMarksOrGradeNumberField.setValue(jData.maxMarksOrGrade);
	       				
	       				//minMarksOrGradeAwardNumberField.setValue(jData.minMarksOrGradeAward);
	       				//maxMarksOrGradeAwardNumberField.setValue(jData.maxMarksOrGradeAward);
	       				if(jData.whetherPassingCritical){
	       					supplementaryDrool.setVisible(true);
          					supplementaryDrool.setValue(jData.supplementaryDrool);
          					
        					failMarksToBeAwarded.setVisible(true);
        					failMarksToBeAwarded.setValue(jData.failMarksGradeToBeAwarded);
        					if(minMarksOrGradeNumberField.getValue()>0) {
        		    			failMarksToBeAwarded.maxValue=minMarksOrGradeNumberField.getValue()-1;
        		    		} else {
        		    			failMarksToBeAwarded.maxValue=minMarksOrGradeNumberField.getValue()!=null?
        		    					minMarksOrGradeNumberField.getValue():0;
        		    		}
//        					if(minMarksOrGradeAwardNumberField.getValue()==null) {
//        						failMarksToBeAwarded.minValue=0;
//        					} else {
//        						failMarksToBeAwarded.minValue=minMarksOrGradeAwardNumberField.getValue();
//        					}
        				}
	       			}else if(jData.marksOrGrade==getExaminationTranslation('CNTRL_GRADE')){
	       				var allowblankFalse = '<span class="required" style="color:red"> *</span>';
                        gradeTypeField.allowBlank=false;
                        gradeTypeField.setFieldLabel(gradeTypeField.getFieldLabel());
                        $this.setAllowBlank(gradeTypeField,false);
                        if(jData.whetherPassingCritical){
                        	supplementaryDrool.setVisible(true);
          					supplementaryDrool.setValue(jData.supplementaryDrool);
          					
        					failGradeToBeAwarded.setVisible(true);
        					failGradeToBeAwarded.getStore().load({
        						callback: function(records, operation, success) {
       		         			 if (success) {
       		         				failGradeToBeAwarded.setValue(jData.failMarksGradeToBeAwarded);
       		         			 }
       		         		 }
        					});
        					failGradeToBeAwarded.setFieldLabel(failGradeToBeAwarded.getFieldLabel());
        					$this.setAllowBlank(failGradeToBeAwarded,false);
        				}
	       				minMarksOrGradeComboField.allowBlank=false;
	       				maxMarksOrGradeComboField.allowBlank=false;
	       				
	       				gradeTypeField.setVisible(true);
	       				
	       				minMarksOrGradeComboField.setVisible(true);
	       				maxMarksOrGradeComboField.setVisible(true);
	   					//minMarksOrGradeAwardComboField.setVisible(true);
	       				//maxMarksOrGradeAwardComboField.setVisible(true);
	       				minMarksOrGradeComboField.setFieldLabel(minMarksOrGradeComboField.getFieldLabel());
	       				$this.setAllowBlank(minMarksOrGradeComboField,false);
 	    				maxMarksOrGradeComboField.setFieldLabel(maxMarksOrGradeComboField.getFieldLabel());
 	    				$this.setAllowBlank(maxMarksOrGradeComboField,false);
	       				if(jData.gradeType!=null){
	       					gradeTypeField.getStore().load({
	      						 callback: function(records, operation, success) {
	      		          			 if (success) {
	      		          				setTimeout(function(){
	      		          					gradeTypeField.setValue(jData.gradeType);
	      		    				  	},300);
	      		          				
	      		          			 }
	      		          		 }
	      					  });
	           				
	       					minMarksOrGradeComboField.getStore().getProxy().extraParams = {
	       						    gradeType:jData.gradeType
	       						   };
	       					
	       				  if(jData.minMarksOrGrade!=null){
	       						minMarksOrGradeComboField.getStore().load({
	      							 callback: function(records, operation, success) {
	      			          			 if (success) {
	      			          				minMarksOrGradeComboField.setValue(jData.minMarksOrGrade);
	      			          			 }
	      			          		 }
	      						  });        						
	       					 }
	       				 
	       				   if(jData.maxMarksOrGrade!=null){
	       					   maxMarksOrGradeComboField.getStore().load({
      							 callback: function(records, operation, success) {
      			          			 if (success) {
      			          				maxMarksOrGradeComboField.setValue(jData.maxMarksOrGrade);
      			          			 }
      			          		 }
      						   });        						
       					     }
	       					
	       					/*if(jData.minMarksOrGradeAward!=null){
	       					minMarksOrGradeAwardComboField.getStore().load({
	  							 callback: function(records, operation, success) {
	  			          			 if (success) {
	  			          			minMarksOrGradeAwardComboField.setValue(jData.minMarksOrGradeAward);
	  			          			 }
	  			          		   }
	  						     });
	       					}
	       					
	       					if(jData.maxMarksOrGradeAward!=null){
	       					maxMarksOrGradeAwardComboField.getStore().load({
	  							 callback: function(records, operation, success) {
	  			          			 if (success) {
	  			          			maxMarksOrGradeAwardComboField.setValue(jData.maxMarksOrGradeAward);
	  			          			 }
	  			          		   }
	  						     });
	       					}*/
	       				}
	       		    }
	   				
	   				if(jData.roundingMode!=null){
    					var roundingMode=levelFormTwo.findField('roundingMode');
    					roundingMode.getStore().load({
    						callback:function(){
    							roundingMode.setValue(jData.roundingMode);		
    						}
    					});
    				}

    				if(jData.roundingCount!=null){
    					var roundingCount=levelFormTwo.findField('roundingCount');
    					setTimeout(function(){
    						roundingCount.setValue(jData.roundingCount);
    				  	},300);
    				}
	   				
	   				levelFormTwo.isValid();
	  	   		 }
	  	   		}
	    	});
	    },
	    /**
		 * This Functon is used to populate data on evaluation sequence form. 
		 */
	    editEvaluationPlanSequenceForm:function(selectRec,parentRec){
	    	var $this=this;
	    	Ext.Ajax.request({
	  	   		 type: 'rest',
	  	   		 url: SERVERURL.EVALUATION_PLAN_SEQUENCE_FORM__FIND_BY_ID,
	  	   		 method: 'GET',
	  	   		 params:{
	  	   			id:selectRec.data.cls
	  	   		 },
	  	   		 success: function(rsp, action) {
	  	   			var data = rsp.responseText;
	  	   		if(data!=null&&data!=""){
	  	   			var jData=Ext.JSON.decode(data);
	  	   		    var evalSequenceForm=$this.getEvaluationPlanSequenceForm().getForm();
	  	   		    
	  	   		    evalSequenceForm.findField('id').setValue(jData.id);
	  	   		    evalSequenceForm.findField('evaluationPlanLevelTwoId').setValue(jData.evaluationPlanLevelTwoId);
	  	   	    	evalSequenceForm.findField('evalSequenceStatus').setValue(jData.evalSequenceStatus);
	  	   	    	var resultPublishMode = evalSequenceForm.findField('resultPublishMode');
	  	   	    	var obeWeightageField = evalSequenceForm.findField('obeWeightage');
	  	   	        var supplementaryDrool =evalSequenceForm.findField('supplementaryDrool');
	  	   	    	obeWeightageField.setValue(jData.obeWeightage);
	  	   		    /**
	  	   		     * sequenceHeaderId field is set only at update time
	  	   		     */
	  	   		    var sequenceHeaderIdUpdateField=evalSequenceForm.findField('sequenceHeaderIdUpdate');
	  	   		    sequenceHeaderIdUpdateField.enable();
	  	   		    sequenceHeaderIdUpdateField.setValue(jData.sequenceHeaderId);
	  	   		    var droolsField = evalSequenceForm.findField("drools");
	  	   		    if(!isNullOrEmpty(jData.methodDroolRule)){
	  	   		    	droolsField.getStore().getProxy().extraParams = {
	  	   		    		moduleName:"EXAM"
		   				 };
	  	   		       droolsField.getStore().load({
  	            		   callback: function(records, operation, success) {
	            			   if (success) {
	            				 		for(var i in records){
	            				 			if(records[i].get('code')==jData.methodDroolRule){
	            				 				droolsField.setVisible(true);
	            				 				var applyDroolField=evalSequenceForm.findField('applyDrool').items.items;
	            				 				applyDroolField[0].setValue(true);
	            				 				applyDroolField[1].setValue(false);
	            				 				droolsField.setValue(records[i].get('id'));
	            				 			}
	            				 	}	 
	            			   }
	            		   }	   
	            	   });
	  	   		    }
	  	   		    var sequenceHeaderIdField= evalSequenceForm.findField('sequenceHeaderId');
	  	   		    if(jData.sequenceHeaderId!=null&&jData.sequenceHeaderId>0){
	  	   		      sequenceHeaderIdField.getStore().load({
						 callback: function(records, operation, success) {
		          			 if (success) {
		          				 /**
		          				  * Here we have to show the name of selected sequence at the time of update
		          				  */
		          				 for(var i in records){
		          					if(selectRec.data.text==records[i].data.code){
		          						sequenceHeaderIdField.setValue(records[i].data.id);
		          						
		          						if(!isNullOrEmpty(records[i].data.value) && 
		          								records[i].data.value=="true"){
		          							resultPublishMode.reset();
		          							resultPublishMode.enable();
		          							resultPublishMode.setVisible(true);
		          							resultPublishMode.setValue(jData.resultPublishMode);
		          						}else{
		          							resultPublishMode.reset();
		          							resultPublishMode.disable();
		          							resultPublishMode.setVisible(false);
		          						}
		          						
		          						break;
		          					}
		          				 }
		          			  }
		          		    }
						});
//		  	   		  sequenceHeaderIdField.setReadOnly(true);
	  	   		    }
	  	   	 	evalSequenceForm.findField('regularDroolsRule').setValue(jData.regularDroolsRule);
	  	      	evalSequenceForm.findField('regularDroolsRuleDesc').setValue(jData.regularDroolsRuleDesc);
	  	        evalSequenceForm.findField('repetitionDroolsRule').setValue(jData.repetitionDroolsRule);
			  	evalSequenceForm.findField('repetitionDroolsRuleDesc').setValue(jData.repetitionDroolsRuleDesc);
			  	evalSequenceForm.findField('evalSequenceWeightage').setValue(jData.evalSequenceWeightage);
			  	evalSequenceForm.findField('numberOfAssessments').setValue(jData.numberOfAssessments);
			  	evalSequenceForm.findField('numberOfAssessmentsCompleted').setValue(jData.numberOfAssessmentsCompleted);
			  	evalSequenceForm.findField('numberOfAssessmentsClosed').setValue(jData.numberOfAssessmentsClosed);
			  	var repetitionType= evalSequenceForm.findField('repetitionType');
       			var eventTobeRepeated = evalSequenceForm.findField('eventTobeRepeated');
       			var allowblankFalse = '<span class="required" style="color:red"> *</span>';
			  	var staffLogisticsIdField= evalSequenceForm.findField('staffLogisticsId');
				  	if(jData.whetherStaffLogistics){
				  		staffLogisticsIdField.items.items[0].setValue(true);
				  		staffLogisticsIdField.items.items[1].setValue(false);
				  	}else if(!jData.whetherStaffLogistics){
				  		staffLogisticsIdField.items.items[0].setValue(false);
				  		staffLogisticsIdField.items.items[1].setValue(true);
				  	}
				  	
				var questionPaperApplicabilityIdField= evalSequenceForm.findField('questionPaperApplicabilityId');
				  	if(jData.whetherQPApplicable){
				  		questionPaperApplicabilityIdField.items.items[0].setValue(true);
				  		questionPaperApplicabilityIdField.items.items[1].setValue(false);
				  	}else if(!jData.whetherQPApplicable){
				  		questionPaperApplicabilityIdField.items.items[0].setValue(false);
				  		questionPaperApplicabilityIdField.items.items[1].setValue(true);
				  	}  	
				  	
			    var examCenterLogisticsIdField= evalSequenceForm.findField('examCenterLogisticsId');
				  	if(jData.whetherExamCenterLogistics){
				  		examCenterLogisticsIdField.items.items[0].setValue(true);
				  		examCenterLogisticsIdField.items.items[1].setValue(false);
				  	}else if(!jData.whetherExamCenterLogistics){
				  		examCenterLogisticsIdField.items.items[0].setValue(false);
				  		examCenterLogisticsIdField.items.items[1].setValue(true);
				  	}
				
			    var isAttendanceRelevantIdField= evalSequenceForm.findField('isAttendanceRelevantId');
				  	if(jData.whetherAttendanceRelevant){
				  		isAttendanceRelevantIdField.items.items[0].setValue(true);
				  		isAttendanceRelevantIdField.items.items[1].setValue(false);
				  	}else if(!jData.whetherAttendanceRelevant){
				  		isAttendanceRelevantIdField.items.items[0].setValue(false);
				  		isAttendanceRelevantIdField.items.items[1].setValue(true);
				  	}
				  	

			     var whetherPassesCriticalIdField= evalSequenceForm.findField('whetherPassesCriticalId');
			     whetherPassesCriticalIdField.setDisabled(false);
					  	if(jData.whetherPassingCritical){
					  		whetherPassesCriticalIdField.items.items[0].setValue(true);
					  		whetherPassesCriticalIdField.items.items[1].setValue(false);
					  		repetitionType.getStore().load({
					  		  callback: function(records, operation, success) {
			          			 if (success) {
			          				if(!isNullOrEmpty(records)){
			          					setTimeout(function(){
			          						if(records[0].data.id==jData.repetitionType){
			          						repetitionType.setValue(records[0].data.id);
			          					}else if (records[1].data.id==jData.repetitionType) {
			          						repetitionType.setValue(records[1].data.id);
			          					}
			          					},300);
			          				}
			          				if(jData.repetitionType=="EVENT_LEVEL") {
				  	   	            	eventTobeRepeated.getStore().getProxy().extraParams={
				  	   	            		levelId:selectRec.data.cls,
				  	   	            		levelName:'Assessment Event'
				  	   	            	};
				  	   	            	eventTobeRepeated.getStore().load({
								  		  callback: function(records, operation, success) {
						          			 if (success && records && records.length) {
						          				eventTobeRepeated.setValue(jData.repeatedEventId);
						          				eventTobeRepeated.setFieldLabel(eventTobeRepeated.getFieldLabel());
						          				 $this.setAllowBlank(eventTobeRepeated,false);
						          				eventTobeRepeated.setVisible(true);
							   	            	eventTobeRepeated.allowBlank=false;
						          			 }
								  		  }
				  	   	            	});
					   	            	
					   	            	
				  	   	            }
			          			 }
					  		  }
					  		});
//		   	            	repetitionType.setFieldLabel(repetitionType.getFieldLabel()+allowblankFalse);
					  	}else if(!jData.whetherPassingCritical){
					  		whetherPassesCriticalIdField.items.items[0].setValue(false);
					  		whetherPassesCriticalIdField.items.items[1].setValue(true);
					  	} 	
					  	
				  	/**
    	        	  * load print name in marksheet on the bases of evaluationTypeAcademicField,evaluationTypeExternalField,evaluationTypeOtherField.
    	        	  */
    	        	   var printNameInMarksheetField=evalSequenceForm.findField('printNameInMarksheet');
	    	        	   // printNameInMarksheetField.allowBlank=true;
	  	 			       // printNameInMarksheetField.setVisible(false);
	  	 			        printNameInMarksheetField.reset();
					  	
					   var showInMarksheetField=evalSequenceForm.findField('showInMarksheet').items.items; 
		 	   	         if(jData.whetherShowInMarksheet){
		 	   	             showInMarksheetField[0].setValue(true);
		 	   	             showInMarksheetField[1].setValue(false);
		 	   	             
			 	   	        // printNameInMarksheetField.allowBlank=false;
		 	 			    // printNameInMarksheetField.setVisible(true);
		 	   	         if(!isNullOrEmpty(jData.printNameInMarksheet)){
		 			    	 printNameInMarksheetField.setValue(jData.printNameInMarksheet);
		 			    	 printNameInMarksheetField.setFieldLabel(getExaminationTranslation('EVALUATION_SEQUENCE_TO_BE_PRINTED'));
		 			    	$this.setAllowBlank(printNameInMarksheetField,false);
		 			      }else{
		 			    	 printNameInMarksheetField.setValue(selectRec.data.text);
		 			      }
			   	         }else if(!jData.whetherShowInMarksheet){
			   	        	showInMarksheetField[0].setValue(false);
			   	        	showInMarksheetField[1].setValue(true);
			   	         }
		 	   	         
		 	   	       var whetherRemarkField=evalSequenceForm.findField('whetherRemarkRadioGroup').items.items; 
	 	   	           if(jData.whetherRemark){
		 	   	        	whetherRemarkField[0].setValue(true);
		 	   	            whetherRemarkField[1].setValue(false);
		   	           }else if(!jData.whetherRemark){
			   	        	whetherRemarkField[0].setValue(false);
			   	        	whetherRemarkField[1].setValue(true);
		   	           }
	 	   	           
		 	   	       var remarkOnlyField=evalSequenceForm.findField('remarkOnlyRadioGroup').items.items; 
			   	       if(jData.remarkOnlyAssessment){
			   	        	remarkOnlyField[0].setValue(true);
			   	        	remarkOnlyField[1].setValue(false);
			   	       }else if(!jData.whetherRemark){
			   	        	remarkOnlyField[0].setValue(false);
			   	        	remarkOnlyField[1].setValue(true);
			  	       }
		 	   	       var contributeToDetentionRadioField=evalSequenceForm.findField('contributeToDetentionRadioGroup').items.items; 
	 	   	           if(jData.contributeToDetention){
	 	   	        	contributeToDetentionRadioField[0].setValue(true);
	 	   	        	contributeToDetentionRadioField[1].setValue(false);
		   	           }else if(!jData.contributeToDetention){
		   	        	contributeToDetentionRadioField[0].setValue(false);
		   	        	contributeToDetentionRadioField[1].setValue(true);
		   	           }   
		 	   	           
		 	   	        var marksOrGradeField=evalSequenceForm.findField('marksOrGrade');
		 	   	        
		 	   	        if(jData.marksOrGrade!=null){
		 	   	             marksOrGradeField.getStore().load({
								 callback: function(records, operation, success) {
				         			 if (success) {
				         				marksOrGradeField.setValue(jData.marksOrGrade);
				         			 }
				         		 }
							});
		 	   	          }      
		 	   	        
		 	   	        var calculateAverageField=evalSequenceForm.findField('calculateAverage').items.items; 
		 	   	        if(jData.whetherCalculateAverage){
		 	   	        	calculateAverageField[0].setValue(true);
		 	   	        	calculateAverageField[1].setValue(false);
		 	   	        }else if(!jData.whetherCalculateAverage){
		 	   	        	calculateAverageField[0].setValue(false);
		 	   	        	calculateAverageField[1].setValue(true);
		 	   	        }
		 	   	        
		 	   	            var minMarksOrGradeNumberField=evalSequenceForm.findField('minMarksOrGradeNumber');
		 	   	            var maxMarksOrGradeNumberField=evalSequenceForm.findField('maxMarksOrGradeNumber');
			       			var minMarksOrGradeComboField=evalSequenceForm.findField('minMarksOrGradeCombo');
			       			var maxMarksOrGradeComboField=evalSequenceForm.findField('maxMarksOrGradeCombo');
			       			
//			       			var minMarksOrGradeAwardNumberField=evalSequenceForm.findField('minMarksOrGradeAwardNumber');
//			       			var maxMarksOrGradeAwardNumberField=evalSequenceForm.findField('maxMarksOrGradeAwardNumber');
			       			
			       			var minMarksOrGradeAwardComboField=evalSequenceForm.findField('minMarksOrGradeAwardCombo');
			       			var maxMarksOrGradeAwardComboField=evalSequenceForm.findField('maxMarksOrGradeAwardCombo');
			       			var failMarksToBeAwarded=evalSequenceForm.findField('failMarksToBeAwarded');
			       	    	var failGradeToBeAwarded=evalSequenceForm.findField('failGradeToBeAwarded');
			       			var gradeTypeField=evalSequenceForm.findField('gradeType');    
			       			
			       			gradeTypeField.allowBlank=true;
			   				
			   				minMarksOrGradeComboField.allowBlank=true;
			   				maxMarksOrGradeComboField.allowBlank=true;
			   				minMarksOrGradeNumberField.allowBlank=true;
			   				maxMarksOrGradeNumberField.allowBlank=true;
		 	   	                
			       			gradeTypeField.setVisible(false);
		   				
			   				minMarksOrGradeComboField.setVisible(false);
			   				maxMarksOrGradeComboField.setVisible(false);
			   				minMarksOrGradeNumberField.setVisible(false);
			   				maxMarksOrGradeNumberField.setVisible(false);
			   				
			   				//minMarksOrGradeAwardNumberField.setVisible(false);
			   				//maxMarksOrGradeAwardNumberField.setVisible(false);
			   				
			   				//minMarksOrGradeAwardComboField.setVisible(false);
			   				//maxMarksOrGradeAwardComboField.setVisible(false);
		   				
		   				if(jData.marksOrGrade==getExaminationTranslation('CNTRL_MARK')){
		       				
		   					minMarksOrGradeNumberField.allowBlank=false;
		       				maxMarksOrGradeNumberField.allowBlank=false;
		       				minMarksOrGradeNumberField.setVisible(true);
		       				maxMarksOrGradeNumberField.setVisible(true);
		       				
		       				//minMarksOrGradeAwardNumberField.setVisible(true);
		       				//maxMarksOrGradeAwardNumberField.setVisible(true);
		       				
		                    minMarksOrGradeNumberField.setValue(jData.minMarksOrGrade);
		                    maxMarksOrGradeNumberField.setValue(jData.maxMarksOrGrade);
		       				
		       				//minMarksOrGradeAwardNumberField.setValue(jData.minMarksOrGradeAward);
		       				//maxMarksOrGradeAwardNumberField.setValue(jData.maxMarksOrGradeAward);
		       				if(jData.whetherPassingCritical){
			       				 supplementaryDrool.setVisible(true);
	           					 supplementaryDrool.setValue(jData.supplementaryDrool);
	           					
	        					failMarksToBeAwarded.setVisible(true);
	        					failMarksToBeAwarded.setValue(jData.failMarksGradeToBeAwarded);
	        					if(minMarksOrGradeNumberField.getValue()>0) {
	        		    			failMarksToBeAwarded.maxValue=minMarksOrGradeNumberField.getValue()-1;
	        		    		} else {
	        		    			failMarksToBeAwarded.maxValue=minMarksOrGradeNumberField.getValue()!=null?
	        		    					minMarksOrGradeNumberField.getValue():0;
	        		    		}
	        					/*if(minMarksOrGradeAwardNumberField.getValue()==null) {
	        						failMarksToBeAwarded.minValue=0;
	        					} else {
	        						failMarksToBeAwarded.minValue=minMarksOrGradeAwardNumberField.getValue();
	        					}*/
	        				}
		       			}else if(jData.marksOrGrade==getExaminationTranslation('CNTRL_GRADE')){
		       				
	                        gradeTypeField.allowBlank=false;
	                        gradeTypeField.setFieldLabel(gradeTypeField.getFieldLabel());
	                        $this.setAllowBlank(gradeTypeField,false);
		       				minMarksOrGradeComboField.allowBlank=false;
		       				maxMarksOrGradeComboField.allowBlank=false;
		       				if(jData.whetherPassingCritical){
	        					failGradeToBeAwarded.setVisible(true);
	        					failGradeToBeAwarded.getStore().load({
	        						callback: function(records, operation, success) {
	       		         			 if (success) {
	       		         				failGradeToBeAwarded.setValue(jData.failMarksGradeToBeAwarded);
	       		         			 }
	       		         		 }
	        					});
	        					failGradeToBeAwarded.setFieldLabel(failGradeToBeAwarded.getFieldLabel());
	        					$this.setAllowBlank(failGradeToBeAwarded,false);
	        				}
		       				gradeTypeField.setVisible(true);
		       				
		       				minMarksOrGradeComboField.setVisible(true);
		       				maxMarksOrGradeComboField.setVisible(true);
		   					//minMarksOrGradeAwardComboField.setVisible(true);
		       				//maxMarksOrGradeAwardComboField.setVisible(true);
		       				minMarksOrGradeComboField.setFieldLabel(minMarksOrGradeComboField.getFieldLabel());
		       				$this.setAllowBlank(minMarksOrGradeComboField,false);
	 	    				maxMarksOrGradeComboField.setFieldLabel(maxMarksOrGradeComboField.getFieldLabel());
	 	    				$this.setAllowBlank(maxMarksOrGradeComboField,false);
		       				if(jData.gradeType!=null){
		       					gradeTypeField.getStore().load({
		      						 callback: function(records, operation, success) {
		      		          			 if (success) {
		      		          				gradeTypeField.setValue(jData.gradeType);
		      		          			 }
		      		          		 }
		      					  });
		           				
		       					minMarksOrGradeComboField.getStore().getProxy().extraParams = {
		       						    gradeType:jData.gradeType
		       						   };
		       					
		       					if(jData.minMarksOrGrade!=null){
		       						minMarksOrGradeComboField.getStore().load({
		      							 callback: function(records, operation, success) {
		      			          			 if (success) {
		      			          				minMarksOrGradeComboField.setValue(jData.minMarksOrGrade);
		      			          			 }
		      			          		 }
		      						  });        						
		       					  }
		       					
		       					if(jData.maxMarksOrGrade!=null){
		       						maxMarksOrGradeComboField.getStore().load({
		      							 callback: function(records, operation, success) {
		      			          			 if (success) {
		      			          				maxMarksOrGradeComboField.setValue(jData.maxMarksOrGrade);
		      			          			 }
		      			          		 }
		      						  });        						
		       					  }
		       					
		       					/*if(jData.minMarksOrGradeAward!=null){
		       					minMarksOrGradeAwardComboField.getStore().load({
		  							 callback: function(records, operation, success) {
		  			          			 if (success) {
		  			          			minMarksOrGradeAwardComboField.setValue(jData.minMarksOrGradeAward);
		  			          			 }
		  			          		   }
		  						     });
		       					}
		       					
		       					if(jData.maxMarksOrGradeAward!=null){
		       					maxMarksOrGradeAwardComboField.getStore().load({
		  							 callback: function(records, operation, success) {
		  			          			 if (success) {
		  			          			maxMarksOrGradeAwardComboField.setValue(jData.maxMarksOrGradeAward);
		  			          			 }
		  			          		   }
		  						     });
		       					}*/
		       				}
		       		    }
		   				
		   				if(jData.roundingMode!=null){
	    					var roundingMode=evalSequenceForm.findField('roundingMode');
	    					roundingMode.getStore().load({
	    						callback:function(){
	    							roundingMode.setValue(jData.roundingMode);		
	    						}
	    					});
	    				}

	    				if(jData.roundingCount!=null){
	    					var roundingCount=evalSequenceForm.findField('roundingCount');
	    					setTimeout(function(){
	    						roundingCount.setValue(jData.roundingCount);
	    				  	},300);
	    				}
		   				
		   				evalSequenceForm.isValid();
	  	   		    }
	  	   		 }
	    	});
	    },
	    /**
		 * This Functon is used to populate data on evaluation sequence detail form. 
		 */
	    editEvaluationPlanSequenceDetailForm:function(selectRec,parentRec){
	       	var $this=this;
	       	var parentRecData=parentRec.data;
	    	Ext.Ajax.request({
	  	   		 type: 'rest',
	  	   		 url: SERVERURL.EVALUATION_PLAN_SEQUENCE_DETAIL_FORM__FIND_BY_ID,
	  	   		 method: 'GET',
	  	   		 params:{
	  	   			id:selectRec.data.cls
	  	   		 },
	  	   		 success: function(rsp, action) {
	  	   			var data = rsp.responseText;
	  	   		 if(data!=null&&data!=""){
	  	   			var jData=Ext.JSON.decode(data);  
	  	   		var evalPlanDetailform=$this.getEvaluationplanbasicdetailform().getForm();
	  	   		var evalSequenceDetailForm=$this.getEvaluationPlanSequenceDetailForm().getForm();
	  	   	    evalSequenceDetailForm.findField('id').setValue(jData.id);
	  	   	    evalSequenceDetailForm.findField('version').setValue(jData.version);    
				evalSequenceDetailForm.findField('requireacademicStanding').setValue(jData.requireacademicStanding);
//	  	   	    evalSequenceDetailForm.findField('evaluationSequence').setValue(parentRecData.text);
	  	   	    evalSequenceDetailForm.findField('evaluationSequenceId').setValue(jData.evaluationSequenceId);
	  	   	    evalSequenceDetailForm.findField('detailSequenceNumber').setValue(jData.detailSequenceNumber);
	  	   	    evalSequenceDetailForm.findField('detailSequenceNumber').setFieldLabel(getExaminationTranslation('DETAILED_SEQUENCE'));
	  	     	evalSequenceDetailForm.findField('detailSequenceDesc').setValue(jData.detailSequenceDesc);
	  	     	evalSequenceDetailForm.findField('detailSequenceDesc').setFieldLabel(getExaminationTranslation('DETAILED_SEQUENCE_DESCRIPTION'));
	  	     	evalSequenceDetailForm.findField('partOfEvaluationGroup').setFieldLabel(getExaminationTranslation('PART_OF_EVALUATION_GROUP'));
	  	     	evalSequenceDetailForm.findField('detailSequenceEqvlnt').setFieldLabel(getExaminationTranslation('DETAILED_SEQUENCE_EQUIVALENT'));
	  	     	var supplementaryDrool =evalSequenceDetailForm.findField('supplementaryDrool');
	  	     	var copyMarksGradeEvent =evalSequenceDetailForm.findField('copyMarksGradeEvent');
	  	     	var copyMarksGradeMethod =evalSequenceDetailForm.findField('copyMarksGradeMethod');
	  	     	evalSequenceDetailForm.findField('maxCappingMark').setValue(jData.maxCappingMark);
	  	     	var ruleForEquivalentEvent=evalSequenceDetailForm.findField('ruleForEquivalentEvent');
	  	     	
	  	     	
	  	         var CopyMarksGradeMethodStore = copyMarksGradeMethod.getStore();

				//passing extra params data to prevent caching issue of store
				 CopyMarksGradeMethodStore.getProxy().extraParams = { 
					evalPlanId :  evalPlanDetailform.getValues().id
				 };
					
	  	        CopyMarksGradeMethodStore.load({
	           		 callback: function(records, operation, success) {
	           			 if (success) {
	           				copyMarksGradeMethod.setValue(jData.copyMethodId);
	           			  }
	           		  }
	           	   });
	  	     
		  	   var copyMarksGradeEventStore = copyMarksGradeEvent.getStore();
		  	       copyMarksGradeEventStore.proxy.extraParams = {
					                                methodId :jData.copyMethodId
					                        };
		  	   	copyMarksGradeEventStore.load({
	           		 callback: function(records, operation, success) {
	           			 if (success) {
	           				copyMarksGradeEvent.setValue(jData.copyEventId);
//	           				copyMarksGradeEvent.setDisabled(false);
	           				if(copyMarksGradeMethod.value == null ||copyMarksGradeMethod.value ==  "" ||copyMarksGradeMethod.value ==  undefined ){
	           					copyMarksGradeEvent.setDisabled(true);
	           				}else{
	           					copyMarksGradeEvent.setDisabled(false);
	           				}
	           				
	           			  }
	           		  }
		
	           	   });
		  	   	
	  	     	Ext.apply(evalSequenceDetailForm,{
	  	     		ruleForEquivalent:null,
	     		  setRuleForEquivalent : function(ruleForEquivalent){
	     			 evalSequenceDetailForm.ruleForEquivalent = ruleForEquivalent;
	     		  },
	     		  getRuleForEquivalent:function(){
	     			  return evalSequenceDetailForm.ruleForEquivalent;
	     		  }
				});
	  	     	evalSequenceDetailForm.setRuleForEquivalent(jData.ruleForEquivalentEvent);
	  	   		 ruleForEquivalentEvent.getStore().load({
	  	   			 callback:function(record) {
	  	   				 if(!isNullOrEmpty(jData.ruleForEquivalentEvent)) {
	  	   					 ruleForEquivalentEvent.setValue(jData.ruleForEquivalentEvent);
	  	   				 }
	  	   			 }
	  	   		 });
		  	   	var ruleForAbsentsField=evalSequenceDetailForm.findField('ruleForAbsents');
				ruleForAbsentsField.getStore().load({
					callback:function(record){
						if(!isNullOrEmpty(jData.ruleForAbsents)) {
							ruleForAbsentsField.setValue(jData.ruleForAbsents);
							if(jData.evalInMarksOrGrade==getExaminationTranslation('CNTRL_GRADE')){
								minMarksForRuleAbsentField.setVisible(false);
								minMarksForRuleAbsentField.reset()
							}else{
								minMarksForRuleAbsentField.setVisible(true);
								minMarksForRuleAbsentField.setValue(jData.minMarksOrGradeForAbsents);
							}
							
						}
					}
				});

				var whetherATKTRequiredField=evalSequenceDetailForm.findField('whetherATKTRequired');
				 
				var roundedMarkEntryCheck=evalSequenceDetailForm.findField('whetherRoundedMark');   
				roundedMarkEntryCheck.setValue(jData.whetherRoundedMark); 
				
 	   	        if(jData.whetherATKTRequired){
 	   	        	evalSequenceDetailForm.config.isFromEditRender = true;
	 	   	        whetherATKTRequiredField.items.items[0].setValue(true);
	 	   	        whetherATKTRequiredField.items.items[1].setValue(false);
	   	        } else {
	   	        	whetherATKTRequiredField.items.items[0].setValue(false);
	   	        	whetherATKTRequiredField.items.items[1].setValue(true);
	   	        }
 	   	    var  attendanceRuleApplicableRadio = evalSequenceDetailForm.findField('attendanceRuleApplicableRadio'); 
 	   	    var attendanceRuleCombo =  evalSequenceDetailForm.findField('attendanceRuleCombo'); 
 	   	    if(jData.isAttendanceRuleApplicable){
	   	        
 	   	        attendanceRuleApplicableRadio.setValue({'isAttendanceRuleApplicable':true});
 	   	        attendanceRuleCombo.setValue(jData.attendanceRuleId);
   	        } else {
   	        	attendanceRuleApplicableRadio.setValue({'isAttendanceRuleApplicable':false});
   	            
   	        }
			
//	  	     	$this.getEvaluationplanbasicdetailform().down('#cancelBtn').setFieldLabel(getExaminationTranslation('CANCEL'));
	  	     	
	  	        evalSequenceDetailForm.findField('plannedOn').setValue(dateRender(jData.plannedOn));
			  	evalSequenceDetailForm.findField('noOfQPRequired').setValue(jData.noOfQPRequired);
			  	evalSequenceDetailForm.findField('notificationNoOfDays').setValue(jData.notificationNoOfDays);
			  	evalSequenceDetailForm.findField('weightage').setValue(jData.weightage);
			  	evalSequenceDetailForm.findField('visibleForFaculty').setValue({isVisibleForFaculty:jData.isVisibleForFaculty});
			  	evalSequenceDetailForm.findField('timeInMinutes').setValue(jData.timeInMinutes);
			  	evalSequenceDetailForm.findField('starttime').setValue(jData.starttime);
			  	evalSequenceDetailForm.findField('feeBillingDate').setValue(dateRender(jData.feeBillingDate));
			  	evalSequenceDetailForm.findField('feedbackQuestionnaire').setValue(jData.feedbackQuestionnaire);
			  	evalSequenceDetailForm.findField('resultApproved').show();
			  	var repetitionType= evalSequenceDetailForm.findField('repetitionType');
       			var eventTobeRepeated = evalSequenceDetailForm.findField('eventTobeRepeated');
       			var allowblankFalse = '<span class="required" style="color:red"> *</span>';
			  	
			  	var modeOfAdministrationField=evalSequenceDetailForm.findField('modeOfAdministration');
    			/**
    			 * Checks on the bases of written test while updating
    			 */
    			/**
    	    	 * as written test is set by default to false and disabled ,So, on the bases these fields are hidden
    	    	 * "objectiveType,answerPaperAvailable,revaluationType,modeOfAdministration,evaluationAnonymous,timeInMinutes,
    	    	 * noOfQPRequired,rndmSlctnAplcble,resultExceptionToTime,exceptionRuleAgendaDescription"
    	    	 */
	    				modeOfAdministrationField.show();
	    				if(jData.modeOfAdministration!=null){
	    					modeOfAdministrationField.allowBlank=false;
	    					modeOfAdministrationField.store.load({
		  	              		 callback: function(records, operation, success) {
		  	              			 if (success) {
		  	              				modeOfAdministrationField.setValue(jData.modeOfAdministration);
		  	              			  }
		  	              		  }
		  	              	   });
		    				}
	    				var evalPlanLevelField=evalSequenceDetailForm.findField('evalPlanLevelId');  
			   	          if(jData.methodLevelEvelDetentionId != null) {
			   	        	  evalPlanLevelField.setValue(jData.methodLevelEvelDetentionId);  
			   	          } else if(jData.subTypeLevelEvelDetentionId != null) {
			   	        	evalPlanLevelField.setValue(jData.subTypeLevelEvelDetentionId);
			   	          } else if(jData.eventLevelEvelDetentionId != null) {
			   	        	evalPlanLevelField.setValue(jData.eventLevelEvelDetentionId);
			   	          }
	    				
	    				  var tree=Ext.ComponentQuery.query('treepanel#evaluationPlanTreeItemId')[0];
		        		  var node=	tree.getSelectionModel().getSelection()[0];
		        		  
		        		  var eventId = node.data.cls;
		        		  var methodId = node.parentNode.data.cls;
		        		  var subTypeId = node.parentNode.parentNode.data.cls;
		        		  var typeId = node.parentNode.parentNode.parentNode.data.cls;
		        		  
		        		  var record=node.parentNode;
		        		  var tabDetail = record.data;
		        		  var id = tabDetail.id;
		        		  var childItem = tabDetail.qtitle;
		        		  var tabName = tabDetail.text;
		      		  
		      		  
		      			  evalPlanLevelField.getStore().getProxy().extraParams = {
		      				  levelOneId:typeId,
		      				  levelTwoId:subTypeId,
		      				  methodId:methodId,
		      				  eventId:eventId
		   					};
		      			 evalPlanLevelField.getStore().load();	
	    				
    				var attendanceBasedDetentionField=evalSequenceDetailForm.findField('attendanceBasedDetention'); 
	 	   	        if(jData.attendanceBasedDetention){
	 	   	        	attendanceBasedDetentionField.items.items[0].setValue(true);
	 	   	        	attendanceBasedDetentionField.items.items[1].setValue(false);
		   	          }else if(!jData.attendanceBasedDetention){
		   	        	attendanceBasedDetentionField.items.items[0].setValue(false);
		   	        	attendanceBasedDetentionField.items.items[1].setValue(true);
		   	        }
	 	   	          
		 	   	      var evalBasedDetentionField=evalSequenceDetailForm.findField('evaluationBasedDetention'); 
		   	          if(jData.evaluationBasedDetention){
		   	        	evalBasedDetentionField.items.items[0].setValue(true);
		   	        	evalBasedDetentionField.items.items[1].setValue(false);
		   	        	evalPlanLevelField.setVisible(true);
		   	          }else if(!jData.evaluationBasedDetention){
		   	        	evalBasedDetentionField.items.items[0].setValue(false);
		   	        	evalBasedDetentionField.items.items[1].setValue(true);
		   	        	evalPlanLevelField.setVisible(false);
		   	        } 
		   	       
	    			var groupsField=evalSequenceDetailForm.findField('groups');
	    			if(jData.whetherBatches){
	    				groupsField.items.items[0].setValue(true);
	    				groupsField.items.items[1].setValue(false);
    				}else if(!jData.whetherBatches){
    					groupsField.items.items[0].setValue(false);
    					groupsField.items.items[1].setValue(true);
    				}
	    			
	    			var limitedSetOfStudentsField=evalSequenceDetailForm.findField('limitedSetOfStudents');
	    			if(jData.whetherLimitedSetOfStudent){
	    				limitedSetOfStudentsField.items.items[0].setValue(true);
	    				limitedSetOfStudentsField.items.items[1].setValue(false);
    				}else if(!jData.whetherLimitedSetOfStudent){
    					limitedSetOfStudentsField.items.items[0].setValue(false);
    					limitedSetOfStudentsField.items.items[1].setValue(true);
    				}
	    			
	    			var evaluationSequenceIdField=evalSequenceDetailForm.findField('evaluationSequenceId');
	    		    var evalSequenceDetailField=evalSequenceDetailForm.findField('evalDetailSeqEquivalentId');
	    		    var ruleForEquivalentEventField=evalSequenceDetailForm.findField('ruleForEquivalentEvent');
	    			var detailSequenceEqvlntField=evalSequenceDetailForm.findField('detailSequenceEqvlnt');
	    			detailSequenceEqvlntField.setVisible(true);
	    			
	    			var revaluationPossible=evalSequenceDetailForm.findField('revaluationPossible');
	    			if(jData.whetherRevaluationApplicable){
	    				revaluationPossible.items.items[0].setValue(true);
	    				revaluationPossible.items.items[1].setValue(false);
	    			}
	    			
	    			if(jData.whetherDetailSeqEquivalent){
	    				detailSequenceEqvlntField.items.items[0].setValue(true);
	    				detailSequenceEqvlntField.items.items[1].setValue(false);
	    				
	    				if(jData.evalDetailSeqEquivalentId!=null){
    					  var courseIdField=evalPlanDetailform.findField('courseId');
    	      			  var externalCourseMasterField=evalPlanDetailform.findField('externalCourseMaster');
    	      			  var categoryIdField=evalPlanDetailform.findField('categoryId');
    	      			  var newCourseId=null;
    	      			  var newExternalCourseId=null;
    	      			  var newCategoryId=null;
    	      			  if(!courseIdField.isHidden()){
    	      				newCourseId=courseIdField.getValue();
    	      			  }else if(!externalCourseMasterField.isHidden()){
    	      				newExternalCourseId=externalCourseMasterField.getValue();  
    	      			  }else if(!categoryIdField.isHidden()){
    	      				newCategoryId=categoryIdField.getValue();
    	      			  }
      			            ruleForEquivalentEventField.setVisible(true);
      			            ruleForEquivalentEventField.setValue(jData.ruleForEquivalentEvent);
      			            
              				evalSequenceDetailField.getStore().getProxy().extraParams={
    		  					evalSeqId:evaluationSequenceIdField.getValue(),
    		  					noteqEventId:jData.id
    		  				};
              				evalSequenceDetailField.getStore().load({
              					callback:function(){
              						evalSequenceDetailField.setValue(jData.evalDetailSeqEquivalentId);
              					}
              				});
	    			    }
    				 
    				}else if(!jData.whetherDetailSeqEquivalent){
    					detailSequenceEqvlntField.items.items[0].setValue(false);
    					detailSequenceEqvlntField.items.items[1].setValue(true);
    					evalSequenceDetailField.setVisible(false);
    				}
	    			var whetherPassesCriticalIdField= evalSequenceDetailForm.findField('passingCritical');
	    			whetherPassesCriticalIdField.setDisabled(false);
				  	if(jData.whetherPassingCritical){
				  		whetherPassesCriticalIdField.items.items[0].setValue(true);
				  		whetherPassesCriticalIdField.items.items[1].setValue(false);
				  		repetitionType.getStore().load({
				  		   callback: function(records, operation, success) {
		          			 if (success) {
		          				repetitionType.setValue(jData.repetitionType);
		          				if(jData.repetitionType=="EVENT_LEVEL") {
			  	   	            	eventTobeRepeated.getStore().getProxy().extraParams={
			  	   	            		levelId:selectRec.data.cls,
			  	   	            		levelName:'Assessment Event'
			  	   	            	};
			  	   	            	eventTobeRepeated.getStore().load({
							  		  callback: function(records, operation, success) {
					          			 if (success) {
					          				eventTobeRepeated.setValue(jData.detailSequenceNumber);
					          				eventTobeRepeated.setFieldLabel(eventTobeRepeated.getFieldLabel());
					          				$this.setAllowBlank(eventTobeRepeated,false);
						   	            	eventTobeRepeated.setVisible(true);
						   	            	eventTobeRepeated.allowBlank=false;
					          			 }
							  		  }
			  	   	            	});
			  	                }
		          		    }
				  	      }
					  });
				  	}else if(!jData.whetherPassingCritical){
				  		whetherPassesCriticalIdField.items.items[0].setValue(false);
				  		whetherPassesCriticalIdField.items.items[1].setValue(true);
				  	} 
	    			var notificationTypeField=evalSequenceDetailForm.findField('notificationType');
	    			if(jData.notificationType!=null){
	    				notificationTypeField.store.load({
	  	              		 callback: function(records, operation, success) {
	  	              			 if (success) {
	  	              				notificationTypeField.setValue(jData.notificationType);
	  	              			  }
	  	              		  }
	  	              	   });
	    				}
	    			
	    			var evalInMarksOrGradeField=evalSequenceDetailForm.findField('evalInMarksOrGrade');

	    			var maxMarkLastValueField=evalSequenceDetailForm.findField('maxMarkLastValue');
	    			var maxMarksField=evalSequenceDetailForm.findField('maxMarks');
                	var minMarksField=evalSequenceDetailForm.findField('minMarks');
             		
             		var minGradeField=evalSequenceDetailForm.findField('minGrade');
                	var maxGradeField=evalSequenceDetailForm.findField('maxGrade');
             		var failMarksToBeAwarded=evalSequenceDetailForm.findField('failMarksToBeAwarded');
	       	    	var failGradeToBeAwarded=evalSequenceDetailForm.findField('failGradeToBeAwarded');
	       	    	// Added by Kuldeep for Rule for Absent
             		var minMarksForRuleAbsentField=evalSequenceDetailForm.findField('minMarksForRuleAbsent');
	       	    	var minGradeForRuleAbsentField=evalSequenceDetailForm.findField('minGradeForRuleAbsent');
             		
             		maxMarksField.setVisible(false);
             		minMarksField.setVisible(false);
             		maxMarksField.allowBlank=true;
             		minMarksField.allowBlank=true;
             		minMarksForRuleAbsentField.setVisible(false);
             		minGradeForRuleAbsentField.setVisible(false);
             		
             		minGradeField.setVisible(false);
             		maxGradeField.setVisible(false);
             		minGradeField.allowBlank=true;
             		maxGradeField.allowBlank=true;
	   				
	    			if(jData.evalInMarksOrGrade!=null){
	    				evalInMarksOrGradeField.store.load({
	  	              		 callback: function(records, operation, success) {
	  	              				evalInMarksOrGradeField.setValue(jData.evalInMarksOrGrade);
	  	              		   }
	  	              	   });
	    				   
	    				if(jData.evalInMarksOrGrade==getExaminationTranslation('CNTRL_MARK')){
	    					   
    					    maxMarksField.setVisible(true);
    	             		minMarksField.setVisible(true);
    	             		if(jData.ruleForAbsents==getExaminationTranslation('MINIMUM_MARKS_GRADE')) {
         	             	   minMarksForRuleAbsentField.setVisible(true);
    	             		   if(!isNullOrEmpty(jData.minMarksOrGradeForAbsents)) {
            						minMarksForRuleAbsentField.setRawValue(jData.minMarksOrGradeForAbsents);
	    					   } else {
           							minMarksForRuleAbsentField.setRawValue(0);
	    					   }
    	             		} else {
    	             			minMarksForRuleAbsentField.reset();
    	             			minMarksForRuleAbsentField.setVisible(false);
    	             		}
    	             		minMarksField.setFieldLabel(getExaminationTranslation('MINIMUM_PASSING_MARKS'));
            		    	maxMarksField.setFieldLabel(getExaminationTranslation('MAXIMUM_PASSING_MARKS'));
            		    	$this.setAllowBlank(minMarksField,false);
            		    	$this.setAllowBlank(maxMarksField,false);
    	             		
            		    	maxMarkLastValueField.setValue(jData.maxMarks);
    	             		maxMarksField.setValue(jData.maxMarks);
    	             		minMarksField.setValue(jData.minMarks);
    	             		if(jData.whetherPassingCritical){
    	             			 supplementaryDrool.setVisible(true);
	           					 supplementaryDrool.setValue(jData.supplementaryDrool);
	           					
	        					failMarksToBeAwarded.setVisible(true);
	        					failMarksToBeAwarded.setValue(jData.failMarksGradeToBeAwarded);
	        					if(minMarksField.getValue()>0) {
	        		    			failMarksToBeAwarded.maxValue=minMarksField.getValue()-1;
	        		    		} else {
	        		    			failMarksToBeAwarded.maxValue=minMarksField.getValue()!=null?
	        		    					minMarksField.getValue():0;
	        		    		}
	        				}
    	             		if(jData.whetherPassingCritical){
    	             			
	        					failMarksToBeAwarded.setVisible(true);
	        					failMarksToBeAwarded.setValue(jData.failMarksGradeToBeAwarded);
	        					if(minMarksField.getValue()>0) {
	        		    			failMarksToBeAwarded.maxValue=minMarksField.getValue()-1;
	        		    		} else {
	        		    			failMarksToBeAwarded.maxValue=minMarksField.getValue()!=null?
	        		    					minMarksField.getValue():0;
	        		    		}
	        				}
    				   }else if(jData.evalInMarksOrGrade==getExaminationTranslation('CNTRL_GRADE')){
	    					   
	    					   minGradeField.setVisible(true);
	    					   maxGradeField.setVisible(true);
	    					   if(jData.ruleForAbsents==getExaminationTranslation('MINIMUM_MARKS_GRADE')) {
		    					   minGradeForRuleAbsentField.setVisible(true);
		    					   if(!isNullOrEmpty(jData.minMarksOrGradeForAbsents)) {
		    						   minGradeForRuleAbsentField.getStore().getProxy().extraParams = {
		    							   gradeType:jData.gradeType
		       						   };
		    						   minGradeForRuleAbsentField.getStore().load({
		                					callback:function(record) {
                								minGradeForRuleAbsentField.setValue(parseInt(jData.minMarksOrGradeForAbsents));
		                					}
	               					   });
		    					   } else {
		    						   minGradeForRuleAbsentField.getStore().getProxy().extraParams = {
		    							   gradeType:jData.gradeType
		       						   };
			    					   minGradeForRuleAbsentField.getStore().load({
		                					callback:function(record) {
		                						for(var i in record) {
		                							if(record[i].data.gradeRangeFrom<1) {
		                								minGradeForRuleAbsentField.setValue(record[i].data.gradePoint);
		                							}
		                						}
		                					}
	               					   });
		    					   }
	    					   } 
	    						   if(jData.ruleForAbsents==getCommonTranslation('MINIMUM_MARKS_GRADES_WITH_REWEIGHT')) {
			    					   minGradeForRuleAbsentField.setVisible(true);
			    					   if(!isNullOrEmpty(jData.minMarksOrGradeForAbsents)) {
			    						   minGradeForRuleAbsentField.getStore().getProxy().extraParams = {
			    							   gradeType:jData.gradeType
			       						   };
			    						   minGradeForRuleAbsentField.getStore().load({
			                					callback:function(record) {
	                								minGradeForRuleAbsentField.setValue(parseInt(jData.minMarksOrGradeForAbsents));
			                					}
		               					   });
			    					   } else {
			    						   minGradeForRuleAbsentField.getStore().getProxy().extraParams = {
			    							   gradeType:jData.gradeType
			       						   };
				    					   minGradeForRuleAbsentField.getStore().load({
			                					callback:function(record) {
			                						for(var i in record) {
			                							if(record[i].data.gradeRangeFrom<1) {
			                								minGradeForRuleAbsentField.setValue(record[i].data.gradePoint);
			                							}
			                						}
			                					}
		               					   });
			    					   }
		    					   }
	    					  else {
	    						   minGradeForRuleAbsentField.setVisible(false);
	    						   minMarksForRuleAbsentField.setVisible(false);
	    					   }
	    					   if(jData.whetherPassingCritical){
	    						   supplementaryDrool.setVisible(true);
	           					    supplementaryDrool.setValue(jData.supplementaryDrool);
	           					
		        					failGradeToBeAwarded.setVisible(true);
		        					failGradeToBeAwarded.getStore().load({
		        						callback: function(records, operation, success) {
		       		         			 if (success) {
		       		         				failGradeToBeAwarded.setValue(jData.failMarksGradeToBeAwarded);
		       		         			 }
		       		         		 }
		        					});
		        					failGradeToBeAwarded.setFieldLabel(failGradeToBeAwarded.getFieldLabel());
		        					$this.setAllowBlank(failGradeToBeAwarded,false);
		        			   }
	    					   minGradeField.allowBlank=false;
	    					   maxGradeField.allowBlank=false;
	    					   
	    					   
	    					   minGradeField.setFieldLabel(getExaminationTranslation('MINIMUM_PASSING_GRADES'));
	    					   $this.setAllowBlank(minGradeField,false);
    	           		       maxGradeField.setFieldLabel(getExaminationTranslation('MAXIMUM_PASSING_GRADES'));
    	           		       $this.setAllowBlank(maxGradeField,false);
	    					   
	    					   if(jData.gradeType!=null){
	    						   minGradeField.getStore().getProxy().extraParams = {
		       						    gradeType:jData.gradeType
		       						   };
	    						   
	    						   minGradeField.store.load({
	    		  	              		 callback: function(records, operation, success) {
	    		  	              			 if (success) {
	    		  	              				minGradeField.setValue(jData.minGrade);
	    		  	              			  }
	    		  	              		  }
	    		  	              	   });
	    						   
	    						   maxGradeField.store.load({
	    		  	              		 callback: function(records, operation, success) {
	    		  	              			 if (success) {
	    		  	              				maxGradeField.setValue(jData.maxGrade);
	    		  	            		    	maxMarkLastValueField.setValue(jData.maxGrade);
	    		  	              			  }
	    		  	              		  }
	    		  	              	   });
	    					   }
	    				   } 
	    				}
	    			
	    			var gradeTypeField=evalSequenceDetailForm.findField('gradeType');
	    			if(jData.gradeType!=null){
	    				gradeTypeField.setVisible(true);
	    				gradeTypeField.store.load({
	  	              		 callback: function(records, operation, success) {
	  	              			 if (success) {
	  	              				gradeTypeField.setValue(jData.gradeType);
	  	              			  }
	  	              		  }
	  	              	   });
	    				}
	    			if(jData.evalInMarksOrGrade=='MARK'){
	    				var whetherShowPenaltyMarksField=evalSequenceDetailForm.findField('whetherShowPenaltyMarks'); 
	    	 	   	    
	    		   	    if(jData.whetherShowPenaltyMarks){
	    		   	        evalSequenceDetailForm.config.isFromEditRender = true;
	    		   	        whetherShowPenaltyMarksField.setValue(true);
	    	   	        } else {
	    	   	        	whetherShowPenaltyMarksField.setValue(false);
	    	   	        }
	    		   	    
	    		   	  var whetherShowGraceMarksField=evalSequenceDetailForm.findField('whetherShowGraceMarks'); 
	    		   	        
	    		   	  if(jData.whetherShowGraceMarks){
	    		   	        evalSequenceDetailForm.config.isFromEditRender = true;
	    		   	     whetherShowGraceMarksField.setValue(true);
	    	   	        } else {
	    	   	        	whetherShowGraceMarksField.setValue(false);
	    	   	        }
	    			}
	    			
	    			var resultApprovedField=evalSequenceDetailForm.findField('resultApproved');
	    			if(jData.whetherResultApproved){
	    				resultApprovedField.items.items[0].setValue(true);
	    				resultApprovedField.items.items[1].setValue(false);
    				}else if(!jData.whetherResultApproved){
    					resultApprovedField.items.items[0].setValue(false);
    					resultApprovedField.items.items[1].setValue(true);
    				}
	    			
	    			var partOfEvaluationGroupField=evalSequenceDetailForm.findField('partOfEvaluationGroup');
	    			if(jData.partOfEvaluationGroup){
	    				partOfEvaluationGroupField.items.items[0].setValue(true);
	    				partOfEvaluationGroupField.items.items[1].setValue(false);
    				}else if(!jData.partOfEvaluationGroup){
    					partOfEvaluationGroupField.items.items[0].setValue(false);
    					partOfEvaluationGroupField.items.items[1].setValue(true);
    				}
	    			
	    			var whetherShowHallTicketNo=evalSequenceDetailForm.findField('whetherShowHallTicketNo');
	    			if(jData.partOfEvaluationGroup){
	    				if(jData.whetherEvalAnonymous){
	    					whetherShowHallTicketNo.setVisible(true);
		    				if(jData.whetherShowHallTicketNo){
		    					whetherShowHallTicketNo.setValue(true);
		    				}else{
		    					whetherShowHallTicketNo.setValue(false);
		    				}
	    				}else{
		    				whetherShowHallTicketNo.setVisible(false);
		    			}
	    			}else{
	    				whetherShowHallTicketNo.setVisible(false);
	    			}
	    			
	    			var isAssignmentEvaluationField=evalSequenceDetailForm.findField('isAssignmentEvaluation'); 
	 	   	        if(jData.isAssignmentEvaluation){
		 	   	        isAssignmentEvaluationField.items.items[0].setValue(true);
		 	   	        isAssignmentEvaluationField.items.items[1].setValue(false);
		   	        } else {
		   	        	isAssignmentEvaluationField.items.items[0].setValue(false);
		   	        	isAssignmentEvaluationField.items.items[1].setValue(true);
		   	        }
	 	   	        var isAppliedMarkEntryField=evalSequenceDetailForm.findField('appliedExamMarkEntry');
	 	   	        if(jData.appliedExamMarkEntry){
	 	   	        	isAppliedMarkEntryField.setValue(true);
	 	   	        }else{
	 	   	        	isAppliedMarkEntryField.setValue(false);
	 	   	        }
	    			var statusField=evalSequenceDetailForm.findField('status');
	    			if(jData.status!=null){
	    				statusField.store.load({
	  	              		 callback: function(records, operation, success) {
	  	              			 if (success) {
	  	              				statusField.setValue(jData.status);
	  	              			  }
	  	              		  }
	  	              	   });
	    				}
	    			
	    			var testAdministrationModeField=evalSequenceDetailForm.findField('testAdministrationMode');
	    			if(jData.testAdministrationMode!=null){
	    				testAdministrationModeField.store.load({
	  	              		 callback: function(records, operation, success) {
	  	              			 if (success) {
	  	              				testAdministrationModeField.setValue(jData.testAdministrationMode);
	  	              			  }
	  	              		  }
	  	              	   });
	    				}
	    			
	    			var approvedByIdField=evalSequenceDetailForm.findField('approvedById');
	    			    approvedByIdField.show();
	    			if(jData.approvedById!=null){
	    				approvedByIdField.store.load({
	  	              		 callback: function(records, operation, success) {
	  	              			 if (success) {
	  	              				approvedByIdField.setValue(jData.approvedById);
	  	              			  }
	  	              		  }
	  	              	   });
	    				}
	    				
	    			var showInMarksheetField=evalSequenceDetailForm.findField('showInMarksheet');
		    			if(jData.whetherShowInMarksheet){
		    				showInMarksheetField.items.items[0].setValue(true);
		    				showInMarksheetField.items.items[1].setValue(false);
	    				}else if(!jData.whetherShowInMarksheet){
	    					showInMarksheetField.items.items[0].setValue(false);
	    					showInMarksheetField.items.items[1].setValue(true);
	    				}
		    			var whetherAutoEnrollField=evalSequenceDetailForm.findField('whetherAutoEnrollRadioGroup').items.items; 
			    		    if(jData.whetherAutoEnrollStudent){
			    		 	whetherAutoEnrollField[0].setValue(true);
			    		 	whetherAutoEnrollField[1].setValue(false);
			    		   }else if(!jData.whetherAutoEnrollField){
			    			whetherAutoEnrollField[0].setValue(false);
			    			whetherAutoEnrollField[1].setValue(true);
			    		   }
			    		    var whetherEvalAnonymous=evalSequenceDetailForm.findField('evaluationAnonymous').items.items; 
			    		    if(jData.whetherEvalAnonymous) {
			    		    	Ext.apply(evalSequenceDetailForm,{
					        	   isRender:true,
					     		   setIsRender : function(isRender){
					     			 evalSequenceDetailForm.isRender = isRender;
					     		   },
					     		   getIsRender:function(){
					     			  return evalSequenceDetailForm.isRender;
					     		   }
								});
			    		    	whetherEvalAnonymous[0].setValue(true);
			    		    	whetherEvalAnonymous[1].setValue(false);
			    		    	evalSequenceDetailForm.findField('evaluationAnonymous').setDisabled(true);
			    		    } else {
			    		    	whetherEvalAnonymous[0].setValue(false);
			    		    	whetherEvalAnonymous[1].setValue(true);
			    		    	evalSequenceDetailForm.findField('evaluationAnonymous').setDisabled(false);
			    		    }
			    		    
			    		    var whetherResultPublish=evalSequenceDetailForm.findField('resultPublish');
			    		    var resultPublishMode=evalSequenceDetailForm.findField('resultPublishMode');
			    		    if(jData.isResultPublish){
			    		    	resultPublishMode.show();
			    		    	resultPublishMode.reset();
			    		    	resultPublishMode.setValue(jData.resultPublishMode);
			    		    	whetherResultPublish.items.items[0].setValue(true);
			    		    	whetherResultPublish.items.items[1].setValue(false);
			    		    }else{
			    		    	whetherResultPublish.items.items[0].setValue(false);
			    		    	whetherResultPublish.items.items[1].setValue(true);
			    		    	resultPublishMode.reset(); 
			    		    	resultPublishMode.hide();
			    		    }
			    		    
	  	   		   }
	  	   		 
	  	   		 if(jData.roundingMode!=null){
	  	   			 var roundingMode=evalSequenceDetailForm.findField('roundingMode');
	  	   			 roundingMode.getStore().load({
	  	   				 callback:function(){
	  	   					 roundingMode.setValue(jData.roundingMode);		
	  	   				 }
	  	   			 });
	  	   		 }

	  	   		 if(jData.roundingCount!=null){
	  	   			 var roundingCount=evalSequenceDetailForm.findField('roundingCount');
	  	   			 setTimeout(function(){
	  	   				 roundingCount.setValue(jData.roundingCount);
	  	   			 },300);
	  	   		 }
	  	   		 evalSequenceDetailForm.findField('autoConfigureATKTEvent').setValue(jData.autoConfigureATKTEvent);
				 evalSequenceDetailForm.findField('autoDetainTheStudent').setValue(jData.autoDetainTheStudent); 
	  	   		 
	  	   		 evalSequenceDetailForm.isValid();
	  	   		 }
	    	});
	    },
	    getDate:function(date){
	    	if(date){
	    		var convertDate = new Date(date);
				var getDate = Ext.Date.format(convertDate,CONSTANTS.SUBMIT_DATE_FORMAT);
				 return getDate;
	    	}
	    },
	    deleteTreeNode:function(){
	    	var tree=Ext.ComponentQuery.query('treepanel#evaluationPlanTreeItemId')[0];
		    var node=	tree.getSelectionModel().getSelection()[0];
		 
		    if(tree.getSelectionModel().getCount()>0){
		    if(!node.isExpanded()){
		    	node.expand();
		    }
		    var childNode=node.hasChildNodes();
		    var parntNode=node.parentNode;
//		    if(!childNode){
		    	var id=node.data.cls;
		    	 if(node.data.qtitle=='evaluationplanleveltwoform'){
		    		submitUrl=SERVERURL.EVALUATION_PLAN_LEVEL_ONE_DELETE;
		    	}else if(node.data.qtitle=='evaluationplansequenceform'){
		    		submitUrl=SERVERURL.EVALUATION_PLAN_LEVEL_TWO_DELETE;
		    	}else if(node.data.qtitle=='evaluationplansequencedetailform'){
		    		submitUrl=SERVERURL.EVALUATION_PLAN_SEQUENCE_DELETE;
		    	}else if(node.data.qtitle==''){
		    		submitUrl=SERVERURL.EVALUATION_PLAN_SEQUENCE_DETAIL_DELETE;
		    	}
		    	
		    	 showConfirmMessage(getExaminationTranslation('EVALUATION'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
        				 function(btn, text) {
        			 if (btn == 'yes'){
        		 Ext.Ajax.request({
        			 method: "DELETE",
        			 type: 'rest',
        			 url: submitUrl+'?id='+id,
        			 headers: {
        				 'Content-Type': 'application/json'
        			 },
        			 params: {
        				 id: id
        			 },
        			 success: function(form, action) {
        				 parntNode.collapse();
        				 parntNode.expand();
        				 showSuccessMessage(getExaminationTranslation('EVALUATION'), getExaminationTranslation('EVALUATION_DELETE_MSG'));
        			 }
        		 });
        			 }
        		 });
//		    }else{
//		    	showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('EVALUATION_WARNNG_MSG'));
//		    }
		   }else{
			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		   }
	    }
});