/*
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.controller.facilitiesresources.resourcebooking.EmployeeResourceBookingController', {
	extend: 'Academia.controller.base.BaseController',
	models: [],
	stores: ['facilitiesresources.resourcebooking.employeePortal.EmployeeResourceBookingStore',
			 'facilitiesresources.resourcebooking.employeePortal.EmployeeEventNameStore',
			 'facilitiesresources.resourcebooking.ResourceBookingPurposeStore',
			 'transport.serviceRoute.WeekDays',
	         'course.QuestionPaperBankDocument'],
	views: ['facilitiesresources.resourcebooking.employeePortal.EmployeeResourceBooking',
		'facilitiesresources.resourcebooking.employeePortal.EmployeeResourceBookingSearchForm',
		'facilitiesresources.resourcebooking.employeePortal.EmployeeResourceBookingGrid',
		'facilitiesresources.resourcebooking.employeePortal.EmployeeResourceBookingFormLayout',
		'examinationcenters.questionPaperBank.MeetingDocumentGrid'],
		alias: 'widget.employeeresourcebookingcontroller',
		refs: [{
			ref: 'contentPanel',
			selector: 'contentPanel'
		},{
			ref: 'employeeResourceBookingSearchForm',
			selector: 'employeeresourcebookingsearchform[itemId=employeeresourcebookingsearchformItemId]'
		},{
			ref: 'employeeresourcebookinggrid',
			selector: 'employeeresourcebookinggrid'
		},{
			ref: 'employeeresourcebookingformlayout',
			selector: 'employeeresourcebookingformlayout'
		},{
	    	ref :'meetingdocumentgrid',
	    	selector : 'meetingdocumentgrid[itemId=documentsGridEmployeeResourceBooking]'
	    }],
		config: {
			FACULTY_EVENT_SCHEDULES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_EVENT_SCHEDULES_PRIVILEGES')
		},
		init: function(application) {
			this.control({
				'employeeresourcebookingsearchform combo#eventIdItemId': {
					render: function(obj) {
						var store = obj.getStore();
	                    var userId = this.getCurrentlyLoggedInUser().id;
	                    var portalId = this.getCurrentLoggedPortalId();
						store.getProxy().extraParams = {
							portalId: portalId,
							userId: userId
						};
						store.load();
					}
				},
				'employeeresourcebookingsearchform[itemId=employeeresourcebookingsearchformItemId] button[itemId=resetButtonId]': {
					click: function(){
						var this$ = this;
						var form = this$.getEmployeeResourceBookingSearchForm();
						form.down('#toDate').setMinValue(false);
						form.down('#fromDate').setMaxValue(false);
						form.getForm().reset();
					}
				},
				'employeeresourcebookinggrid': {
					render: function(grid) {
						this.doAccessControlValidation(grid, this.getFACULTY_EVENT_SCHEDULES_PERMISSIONS());
					},
					select:function(rowModel, record, index, eOpts ){
						var me=this;
					}
				},
				'employeeresourcebookingsearchform[itemId=employeeresourcebookingsearchformItemId] button[itemId=searchButtonId]': {
					click: this.searchEmployeeResourceBookingGrid
				},
				'employeeresourcebookinggrid button[itemId=btnView]': {
					click: function(btn){
						this.openEmployeeResourceBookingTab();
					}
				},
				'meetingdocumentgrid[itemId=documentsGridEmployeeResourceBooking]' : {
					cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
						var $this = this;
						var documentGrid = $this.getMeetingdocumentgrid();
						var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
						if (columnName == "documentName") {
							if (e.target.tagName == 'A') {
								var documentId = record.get("documentId");
								if (!isNullOrEmpty(documentId)) {
									$this.getDocumentController().downloadDocumentFile(documentId);
								}
							}
						}
					}
	    		}
			});
		},
		getDocumentController : function() {
			var this$ = this;
			return this$.getController('Academia.controller.document.DocumentController');
		},
		searchEmployeeResourceBookingGrid: function(){
			var $this=this;
			var form = $this.getEmployeeResourceBookingSearchForm().getForm();
			var formValue = form.getValues();
			if(isNullOrEmpty(formValue.fromDate) || isNullOrEmpty(formValue.toDate)){
				if(!isNullOrEmpty(formValue.fromDate) && isNullOrEmpty(formValue.toDate)){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_EVENT_BOOKED_TO_DATE'));
					return;
				}
				if(isNullOrEmpty(formValue.fromDate) && !isNullOrEmpty(formValue.toDate)){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_EVENT_BOOKED_FROM_DATE'));
					return;
				}
			}
			var grid = $this.getEmployeeresourcebookinggrid();
			var store = grid.getStore();
			grid.getStore().getProxy().extraParams= {
				staffId:$this.getCurrentlyLoggedInUser().id,
				fromDate:formValue.fromDate,
				toDate:formValue.toDate,
				eventId:formValue.eventId
			};
			grid.getSelectionModel().deselectAll();
			$this.resetGridSetting(grid);
			$this.resetPageSetting(store, grid);
			store.load();
		},

		openEmployeeResourceBookingTab: function(){
			var $this=this;
			var grid = $this.getEmployeeresourcebookinggrid();
			var gridData = grid.getSelectionModel().getSelection()[0];
			if (grid.getSelectionModel().getCount() > 0) {
				var contentpanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
				
				$this.viewEmployeeResourceBookingDetail(gridData.data.id);
			}else {
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			}
		},
		viewEmployeeResourceBookingDetail: function(committeeEventId) {
			var $this = this;
			var contentpanel = this.getContentPanel();
			var resourceBookingFormLayout = Ext.widget('employeeresourcebookingformlayout');
			var tabName = "";
			var responseObject = new Object();
			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.RESOURCE_BOOKING_FINDBYIDFORPORTAL, //URL-rest/resourceBookingResource/findById													 
				method: 'GET',
				async: false,
				headers: {
					'Content-Type': 'application/json'
				},
				params: {
					id: committeeEventId
				},
				success: function(response, form, action) {
					Ext.getBody().unmask();
					responseObject = eval("(" + response.responseText + ")"); //make object of response text
					var tabName = responseObject.eventName + " " +getCommonTranslation('EVENT_DETAILS');

					/**
					 * This is to remove tab from content panel and open same tab again 
					 */
					var getcontroller=$this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentPanel.remove(getTab, true);
					}
					
					openTab(contentpanel, tabName, resourceBookingFormLayout, CONSTANTS.MENU_COLOR_NINE);
					//resourceBookingFormLayout.down('#resourceCategoryCode').setValue(responseObject.resourceCategoryCode);
					resourceBookingFormLayout.getForm().setValues(responseObject);
					resourceBookingFormLayout.down('#cmbBookingPurpose').setValue(responseObject.bookingPurpose.value);
					resourceBookingFormLayout.down('#cmbBookedBy').setValue(responseObject.bookedBy.value);
					resourceBookingFormLayout.down('#eventDate').setValue(dateRender(responseObject.eventDate));
					resourceBookingFormLayout.down('#toDate').setValue(dateRender(responseObject.toDate));
					resourceBookingFormLayout.down('#timeFrom').setValue(timeRender(responseObject.timeFrom));
					resourceBookingFormLayout.down('#timeTo').setValue(timeRender(responseObject.timeTo));
					
					var eventDesc   = resourceBookingFormLayout.down('[name=eventDesc]');
					var purposeDesc = resourceBookingFormLayout.down('[name=purposeDesc]');

					if (!isNullOrEmpty(responseObject.committee)) {
						if (!isNullOrEmpty(responseObject.committee.code) && !isNullOrEmpty(responseObject.committee.value)) {
							var committeeCode = responseObject.committee.code;
							var committeeValue = responseObject.committee.value;
							resourceBookingFormLayout.down('#committeeItemId').setVisible(true);
							resourceBookingFormLayout.down('#committeeItemId').setValue(committeeCode + " / " + committeeValue);
						}
					}
					else{
						resourceBookingFormLayout.down('#committeeItemId').setVisible(false);
					}
					if(!isNullOrEmpty(responseObject.repeatOn)) {
						var repeatOnFld = resourceBookingFormLayout.down('#repeatOnItemId');
						repeatOnFld.setVisible(true);
						var repeatOnStore = repeatOnFld.getStore();
						var repeatOnIds=[];
						repeatOnStore.load({
							callback: function(records, operation, success) {
								var repeatOnVals = responseObject.repeatOn.split(',');
								for (var i in repeatOnVals) {
									repeatOnIds.push(repeatOnVals[i]);
								}
								repeatOnFld.setValue(repeatOnIds);
							}
						});
					}
					$this.displayEventBannerImage(resourceBookingFormLayout,responseObject.id);
					resourceBookingFormLayout.down('#eventBannerItemId').setDisabled(true);
					resourceBookingFormLayout.getForm().getFields().each (function (field) {
						field.setReadOnly (true);
					});
					
					var documentGrid = resourceBookingFormLayout.down('#documentsGridEmployeeResourceBooking');
        	        documentGrid.getStore().getProxy().api.read = SERVERURL.FIND_ALL_RESOURCE_BOOKING_DOCS;
        	        documentGrid.getStore().getProxy().extraParams={
        	        	resourceBookingId:committeeEventId
        	        };
					documentGrid.down('#btnDelete').setVisible(false);
					documentGrid.getStore().load();
					
					if(responseObject.bookingPurpose.code === "MEETING"){
						eventDesc.setFieldLabel(getCommonTranslation('MEETING_AGENDA'));
						purposeDesc.setVisible(false);
						eventDesc.setWidth(510);
					}
					else{
						eventDesc.setFieldLabel(getCommonTranslation('EVENT_DESC'));
						purposeDesc.setVisible(true);
						eventDesc.setWidth(226);
					}
					
				},
				failure: function(form, action) {
					showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
				}
			});
		},
		displayEventBannerImage:function(resourceBookingFormLayout,eventId) {
			var this$ = this;
			var form = resourceBookingFormLayout;
			Ext.Ajax.request({
				type: 'rest',
				binary: true,
				url: SERVERURL.RESOURCE_BOOKING_DOWNLOAD_EVENT_BANNER,
				method: 'GET',
				params:{
					eventId : eventId
				},
				success: function(res, action) {
					Ext.suspendLayouts();
					if(res.status == 200){
						var blob = new Blob([res.responseBytes], {type: 'image/jpg'});
						var url = window.URL.createObjectURL(blob);
						form.down('#eventBannerBgImage').getEl().dom.src=url;
					}
					Ext.resumeLayouts();
				}
			});
		}
});