/**
 * @author Dharmendra.prajapati
 * @author Deepak.nigam
 */
Ext.define('Academia.controller.feeandpayment.AdvanceFeeReportController', {
	extend : 'Academia.controller.base.BaseController',
    models : ['common.IdValueCodeDataModel',
              'genericmodels.dropdowns.EnumCombo','feeandpayment.FeePlanDetailModel', 'feeandpayment.dashboardAndReports.FeeAndPaymentReportModel',
              'feeandpayment.dashboardAndReports.StudentBillReportModel','feeandpayment.dashboardAndReports.StudentDetailsModel'
            ],
	stores : ['feeandpayment.dashboardAndReports.FeeFindAllBillTypedUser','feeandpayment.managebill.Student','feeandpayment.dashboardAndReports.FeeProgramCodeStore',
	          'feeandpayment.dashboardAndReports.FeePlanProgramAndService','feeandpayment.dashboardAndReports.AdvanceFeeReportStore',
	          'feeandpayment.dashboardAndReports.FeeProgramCodeStore','feeandpayment.dashboardAndReports.FeeBatchNameByProgramStore',
	          'feeandpayment.dashboardAndReports.FeeStudentDetailsByStudentCodeStore','feeandpayment.managebill.Sponsors','feeandpayment.managebill.Applicant',
	          'feeandpayment.managebill.BillTypeSearch'
	          ],
	          
	views : ['baselayout.contentarea.ContentPanel','feeandpayment.ManageFeeStructure','feeandpayment.AdvanceFeeReportStructure',
	         'feeandpayment.AdvanceFeeReportForm','feeandpayment.AdvanceFeeReportGrid','feeandpayment.AdvanceFeeReportApplicantGrid','feeandpayment.AdvanceFeeReportSponsorGrid'
              ],	
     refs : [{
		   	  ref : 'contentpanel',
		   	  selector : 'contentpanel' 
           },{
        	   ref:'advancefeereportstructure',
        	   selector:'advancefeereportstructure'
           },
           {
        	   ref:'advancefeereportapplicantgrid',
        	   selector:'advancefeereportapplicantgrid'
           },
           {
        	   ref:'advancefeereportsponsorgrid',
        	   selector:'advancefeereportsponsorgrid'
           },
           {
        	   ref:'advancefeereportform',
        	   selector:'advancefeereportform'
           },{
        	   ref:'advancefeereportgrid',
        	   selector:'advancefeereportgrid'
           }],
           
           config : {
        	   ADVANCE_FEE_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADVANCE_FEE_REPORT_PRIVILEGES'),
           },
           
           init : function() {
        	   this.control({
        		   'advancefeereportstructure':{
        			   beforerender:function(){
        				   this.getAdvancefeereportgrid().getStore().removeAll();
        			   }
        		   },
        		   'advancefeereportgrid':{
				/*		render:function(grid){
							this.doAccessControlValidation(grid, this.getADVANCE_FEE_REPORT_PERMISSIONS());
						},*/
						afterrender:function(grid){
							var me = this;
							setTimeout(function(){
								me.addDataGridConfigButton(grid, me.getADVANCE_FEE_REPORT_PERMISSIONS());
							},1500);
						}
					},
					'advancefeereportapplicantgrid':{
								afterrender:function(grid){
									var me = this;
									setTimeout(function(){
										me.addDataGridConfigButton(grid, me.getADVANCE_FEE_REPORT_PERMISSIONS());
									},1500);
								}
							},
					
							'advancefeereportsponsorgrid':{
										afterrender:function(grid){
											var me = this;
											setTimeout(function(){
												me.addDataGridConfigButton(grid, me.getADVANCE_FEE_REPORT_PERMISSIONS());
											},1500);
										}
									},
        		   'advancefeereportform':{
        			   render:function(){
        				   var form = this.getAdvancefeereportform().getForm();
        				   var program = form.findField('programName');
        				   academyLocation = this.getCurrentAcademyLocation();

        				   var billTypeField = form.findField('billType');
        				   var billTypeStore=billTypeField.getStore();
        				   
        				   var recieptField = form.findField('recieptView');
        				   var recieptStore =  recieptField.getStore();
        				   billTypeStore.getProxy().extraParams ={
        					   screenType:'advanceFeeReport',
        				   },
        				   billTypeStore.load({
        					   callback: function(record, operation, success) {
        						   if(success) {
        							   billTypeField.setValue(record[0].data.id); 
        						   }
        					   }
        				   });
        				   recieptStore.getProxy().extraParams ={
        					   screenType:'advanceFeeReport',
        					   raiseBillType:'ALL'
        				   },
        				   recieptStore.load({
        					   callback: function(record, operation, success) {
        						   if (success) {
        							   recieptField.setValue(record[0].data.id);
        						   }
        					   }
        				   });

        				   var store  = program.getStore();
        				   store.getProxy().extraParams = {	
        					   academyLocationId:academyLocation
        				   };
        				   store.load();
        				   
        				   var student = form.findField("student");
	        				student.getStore().getProxy().extraParams ={
	        					allStudents : true
	        				};
        			   }
        		   },'advancefeereportform customcombobox#billType': {
   			   		render:function(obj){
				   		var store=obj.getStore();
				   		store.getProxy().extraParams = {
					   	screenType: 'advanceFeeReport'
				   				};
//				   			store.load();
			   			},
			   			select:function(obj,record){
			   				   var form = this.getAdvancefeereportform();
			   				   var frm = form.getForm();
     					       form.down('#student').reset();
     					       form.down('#applicant').reset();
     					       form.down('#sponsors').reset();
            				   //obj.nextSibling().clearValue();
            				   var raiseBillType = record[0].get("id");
            				   var store = obj.up('form').down("#recieptView").getStore();
            				   store.getProxy().extraParams = {
            					   screenType:'advanceFeeReport',
            					   raiseBillType: raiseBillType
            				   };
            				   var recieptField = frm.findField('recieptView');
            		      		var recieptStore =  recieptField.getStore();
            		      		recieptStore.load({
            		      			callback: function(record, operation, success) {
            		      				if (success) {
            		      					recieptField.setValue(record[0].data.id);
            		      				}
            		      			}
            		      		});
            		      	  store.load();
            			   }
			   },
			   'advancefeereportform customcombobox#recieptView': {
	   			change: function(obj,record) {
	   				var $this = this;
	   				setTimeout(function(){
	   					var form = obj.up('form');
	   					var grid = $this.getAdvancefeereportgrid();
	   					var grid1 = $this.getAdvancefeereportapplicantgrid();
	   					var grid2 =  $this.getAdvancefeereportsponsorgrid();
	   					
	   					grid.config.searchFilterForm = form;
	   					grid1.config.searchFilterForm = form;
	   					grid2.config.searchFilterForm = form;
	   					
	   					grid.getStore().removeAll();
	   					var receiptViewField = form.down('#recieptView');
	   					var recieptValue = receiptViewField.getRawValue();
	   					if(!isNullOrEmpty(recieptValue)){
	   						var studentField = form.down('#student');
	   						var applicantField = form.down('#applicant');
	   						var sponsorsField = form.down('#sponsors');
	   						var programField = form.down('#programName');
	   						var BatchField = form.down('#batchName');
	   						var searchField = form.down('#searchBtn');
	   						var statusField = form.down("#statusComboItemId");

	   						if(recieptValue == 'Student' || recieptValue == 'STUDENT'){
	   							
	   							
	   							
	   							statusField.setVisible(true);
	   						//	grid.columns[2].setVisible(false);
	   						//	grid.columns[3].setVisible(false);
	   						//	grid.columns[4].setVisible(false);
	   					//		grid.columns[5].setVisible(false);
	   						//	grid.columns[6].setVisible(false);
	   							grid.columns[0].setText(getFeeAndPaymentCommonTranslation('STUDENT_ID'));
	   							grid.columns[1].setText(getFeeAndPaymentCommonTranslation('STUDENT'));
	   						//	grid.columns[2].setText(getCommonTranslation('STUDENT_FIRST_NAME'));
	   						//	grid.columns[3].setText(getCommonTranslation('STUDENT_MIDDLE_NAME'));
	   						//	grid.columns[4].setText(getCommonTranslation('STUDENT_LAST_NAME'));
	   							//grid.columns[2].setVisible(true);
	   							//grid.columns[3].setVisible(true);
	   							//grid.columns[4].setVisible(true);
	   						//	grid.columns[2].setVisible(true);
	   						//	grid.columns[3].setVisible(true);
	   						//	grid.columns[4].setVisible(true);
	   							grid.setVisible(true);
	   							grid1.setVisible(false);
	   							grid2.setVisible(false);
	   							studentField.setVisible(true);
	   							applicantField.setVisible(false);
	   							sponsorsField.setVisible(false);
	   							programField.setVisible(true);
	   							BatchField.setVisible(true);
	   							searchField.setDisabled(false);
	   							applicantField.reset();
	   							sponsorsField.reset();
	   						}else if(recieptValue == 'Applicant' || recieptValue == 'APPLICANT'){
	   							
	   							statusField.setVisible(false);
	   							statusField.reset();
	   							/*grid.columns[2].setVisible(false);
	   							grid.columns[3].setVisible(false);
	   							grid.columns[4].setVisible(false);
	   							grid.columns[5].setVisible(false);
	   							grid.columns[6].setVisible(false);*/
	   							grid.columns[0].setText(getFeeAndPaymentCommonTranslation('APPLICANT_ID'));
	   							grid.columns[1].setText(getFeeAndPaymentCommonTranslation('APPLICANT'));
	   							/*grid.columns[2].setText(getCommonTranslation('APPLICANT_FIRST_NAME'));
	   							grid.columns[3].setText(getCommonTranslation('APPLICANT_MIDDLE_NAME'));
	   							grid.columns[4].setText(getCommonTranslation('APPLICANT_LAST_NAME'));*/
	   							//grid.columns[2].setVisible(true);
	   							//grid.columns[3].setVisible(true);
	   							//grid.columns[4].setVisible(true);
	   							//grid.columns[5].setVisible(true);
	   							//grid.columns[6].setVisible(true);
	   							grid1.setVisible(true);
	   							grid.setVisible(false);
	   							grid2.setVisible(false);
	   							studentField.setVisible(false);
	   							applicantField.setVisible(true);
	   							sponsorsField.setVisible(false);
	   							programField.setVisible(true);
	   							BatchField.setVisible(true);
	   							searchField.setDisabled(false);
	   							studentField.reset();
	   							sponsorsField.reset();
	   						}else if (recieptValue == 'Sponsor' || recieptValue == 'SPONSOR'){
	   							
	   							statusField.setVisible(false);
	   							statusField.reset();
	   							grid.columns[0].setText(getFeeAndPaymentCommonTranslation('SPONSOR_ID'));
	   							grid.columns[1].setText(getFeeAndPaymentCommonTranslation('SPONSOR'));
	   							/*grid.columns[2].setText(getCommonTranslation('FIRST_NAME'));
	   							grid.columns[3].setText(getCommonTranslation('MIDDLE_NAME'));
	   							grid.columns[4].setText(getCommonTranslation('LAST_NAME'));
	   							grid.columns[2].setVisible(false);
	   							grid.columns[3].setVisible(false);
	   							grid.columns[4].setVisible(false);
	   							grid.columns[5].setVisible(false);
	   							grid.columns[6].setVisible(false);*/
	   							grid2.setVisible(true);
	   							grid.setVisible(false);
	   							grid1.setVisible(false);
	   							studentField.setVisible(false);
	   							applicantField.setVisible(false);
	   							sponsorsField.setVisible(true);
	   							programField.setVisible(false);
	   							BatchField.setVisible(false);
	   							searchField.setDisabled(true);
	   							studentField.reset();
	   							applicantField.reset();
	   							programField.reset();
	   							BatchField.reset();
	   						}
	   					}
	   				}, 30);
				 
			   }
		   },
		   
		   'advancefeereportform customcombobox#sponsors': {
			   select :function(obj){
				   var form = obj.up('form');
				   form.down('#searchBtn').setDisabled(false);
			   }
			},
			
			'advancefeereportform customcombobox#programName': {
				select: function(obj, record) {
					var form = this.getAdvancefeereportform();
					form.down("#batchName").setDisabled(false);
					var programId = record[0].get("id");

					var batchId = form.down("#batchName");
					batchId.reset();
					batchId.setDisabled(false);
					batchId.setReadOnly(false);
					if(programId > 0){
						var batchNameCombo = this.getAdvancefeereportform().down('#batchName');
						var batchNameComboStore = batchNameCombo.getStore();
						batchNameComboStore.getProxy().extraParams = {
							programIds: programId
						};
						batchNameComboStore.load({
							callback: function(records, operation, success) {
								if(records.length==1){
									batchId.setValue(records[0].get('id'));
									batchId.setReadOnly(true);

								}	
							}
						});
					}
				},
				change: function(value,newValue) {
					if(isNullOrEmpty(newValue)){
						var form = this.getAdvancefeereportform();
						form.down("#batchName").setDisabled(true);

					}
				}
			},
        		   'advancefeereportform button[itemId=searchBtn]' : {
        			   click : function(){ 
        				   this.loadAdvanceFeeReportGrid();
        			   }
        		   },
        		   'advancefeereportform button[itemId=resetBtn]': {
        			   click: function(){
        				   this.resetAdvanceFeeReportForm();
        			   }
        		   },
        		   'advancefeereportform customcombobox#student':{
             			 select:function(obj,record){
             				 var $this = this;
             				 var form = obj.up('form').getForm();

             				 var status = obj.lastSelection[0].raw.status;
             				 if(status==true)
             				 {
             					 form.findField("STATUS").setValue(true);
             					 form.findField("STATUS").setReadOnly(true);
             				 }
             				 else{
             					 form.findField("STATUS").setValue(false);
             					 form.findField("STATUS").setReadOnly(true);
             				 }

             			 }
             		 },
        	   });
           },
    	 loadAdvanceFeeReportGrid:function(){
    		 var form = this.getAdvancefeereportform().getForm();
    		 var form1 = this.getAdvancefeereportform();
    		 form1.down('#searchBtn').setDisabled(true);
    		 var values = form.getValues();
    		 var studentId = values.student;
    		 var applicantId = values.applicant;
    		 var sponsorId = values.sponsors;
    		 var programId = values.programName;
    		 var batchId = values.batchName;
    		 var receiptType = form.findField('billType').value;
    		 var recieptView = form.findField('recieptView').getRawValue();
    		 var studentStatus=form.findField('STATUS').getValue();
    		 var id;
    		 var grid1=this.getAdvancefeereportgrid();
    		 var grid2=this.getAdvancefeereportapplicantgrid();
    		 var grid3=this.getAdvancefeereportsponsorgrid();
    		 
    		 
    		 var message = null;
    		
    			 if(recieptView=='STUDENT')
    			 {
    				 var grid = this.getAdvancefeereportgrid();
    				 var store = grid.getStore();
        			 store.getProxy().extraParams = {
        				 receiptType:receiptType,
        				 reciptView:recieptView,
        				 id:studentId,
        				 programId:programId,
        				 batchId:batchId,
        				 studentStatus:studentStatus
        			 };
        			 store.load({
      				   callback: function(record, operation, success) {
      					 form1.down('#searchBtn').setDisabled(false); 
    				   }
    			   });
    				 
    			}
    			 else if(recieptView=='APPLICANT')
    				 {
    				  var grid = this.getAdvancefeereportapplicantgrid();
    				  var store = grid.getStore();
    	    			 store.getProxy().extraParams = {
    	    				 receiptType:receiptType,
    	    				 reciptView:recieptView,
    	    				 id:applicantId,
    	    				 programId:programId,
    	    				 batchId:batchId,
    	    				 studentStatus:studentStatus
    	    			 };
    	    			 store.load({
    	      				   callback: function(record, operation, success) {
    	      					 form1.down('#searchBtn').setDisabled(false); 
    	    				   }
    	    			   });
    				 }
    			 else if(recieptView=='SPONSOR')
				 {
				 
				  var grid = this.getAdvancefeereportsponsorgrid();
				  var store = grid.getStore();
	    			 store.getProxy().extraParams = {
	    				 receiptType:receiptType,
	    				 reciptView:recieptView,
	    				 id:sponsorId,
	    				 programId:programId,
	    				 batchId:batchId,
	    				 studentStatus:studentStatus
	    			 };
	    			 store.load({
	      				   callback: function(record, operation, success) {
	      					 form1.down('#searchBtn').setDisabled(false); 
	    				   }
	    			   });
				 }
		
    		 grid1.config.searchFilterForm = form1;
    		 grid2.config.searchFilterForm = form1;
    		 grid3.config.searchFilterForm = form1; 
    	 },
      	resetAdvanceFeeReportForm: function(){
      		var form = this.getAdvancefeereportform();
      		form.getForm().reset();
      		var batchNameCmp = form.down('#batchName');
      		batchNameCmp.setDisabled(true);
      		var grid = this.getAdvancefeereportgrid();
      		grid.getStore().removeAll();
      		var frm = form.getForm();
      		var billTypeField = form.down('#billType');
			   var billTypeStore=billTypeField.getStore();
			  
			   billTypeStore.load({
				   callback: function(record, operation, success) {
					   if(success) {
						   billTypeField.setValue(record[0].data.id); 
					   }
				   }
			   });
			   var recieptField = form.down('#recieptView');
			   var recieptStore =  recieptField.getStore();
			   recieptStore.getProxy().extraParams ={
				   screenType:'advanceFeeReport',
				   raiseBillType:'ALL'
			   },
			   recieptStore.load({
				   callback: function(record, operation, success) {
					   if (success) {
						   recieptField.setValue(record[0].data.id);
					   }
				   }
			   });

      		form.down('#student').setVisible(true);
      		form.down('#programName').setVisible(true);
      		form.down('#batchName').setVisible(true);
      		form.down('#applicant').setVisible(false);
      		form.down('#sponsors').setVisible(false);
      		form.down('#searchBtn').setDisabled(false);
      	/*	grid.columns[2].setVisible(false);
			grid.columns[3].setVisible(false);
			grid.columns[4].setVisible(false);
			grid.columns[5].setVisible(false);
			grid.columns[6].setVisible(false);*/
			grid.columns[0].setText(getFeeAndPaymentCommonTranslation('STUDENT_ID'));
			grid.columns[1].setText(getFeeAndPaymentCommonTranslation('STUDENT'));
			grid.columns[2].setText(getCommonTranslation('PROGRAM'));
		    grid.columns[3].setText(getCommonTranslation('BATCH'));
		    grid.columns[4].setText(getCommonTranslation('AMOUNT'));
			/*grid.columns[5].setVisible(true);
			grid.columns[6].setVisible(true);*/
			
			form.down("#statusComboItemId").setReadOnly(false);
			 
			var billTypeField = frm.findField('billType');
			var billTypeStore=billTypeField.getStore();
			billTypeStore.getProxy().extraParams={
				 screenType:'advanceFeeReport'
			 };
			
			var recieptField = frm.findField('recieptView');
      		var recieptStore =  recieptField.getStore();
      		
      		billTypeStore.load({
				 callback: function(record, operation, success) {
					 if (success) {
						 billTypeField.setValue(record[0].data.id);
						 recieptStore.load({
	      						params : {
	      							raiseBillType: record[0].data.id,
	      							screenType:'advanceFeeReport'
								 },
								 callback: function(rec, operation, success) {
									 if (success) {
										 recieptField.setValue(rec[0].data.id); 
									 }
								 }
							});
					 	}
				 }
      		});
      	}
      	
});
