
/**
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.feeandpayment.FeeAndPaymentReportController', {
	extend : 'Academia.controller.base.BaseController',
    models : ['common.IdValueCodeDataModel',
              'genericmodels.dropdowns.EnumCombo','feeandpayment.FeePlanDetailModel', 'feeandpayment.dashboardAndReports.FeeAndPaymentReportModel'
            ],
	stores : ['feeandpayment.FeePlanTypeStore',
	          'feeandpayment.FeePlanStatusStore','feeandpayment.FeeServiceStore',
	          'organization.BaseCurrencyStore','admission.selectionProcess.Documents',
	          'common.ProgramByAcademyLocationStore','feeandpayment.managebill.Student',
	          'feeandpayment.dashboardAndReports.FeePlanProgramAndService','feeandpayment.dashboardAndReports.FeePlanTypeProgramAndService',
	          'feeandpayment.dashboardAndReports.FeeAndPaymentReportGrid', 'feeandpayment.dashboardAndReports.FeePlanNameProgramAndService',
	          'feeandpayment.reports.FeeProjectionReportTreeStore','common.AcademyLocationNameSeparated','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
	          'sponsorship.SponsorsNameCodeStore','program.ProgramGroupStore','feeandpayment.reports.StudentFeeReportProgramStore','enquiry.AcademicBatchStore',
	          'feeandpayment.FeeAndPaymentProjectedSponsorReportGridStore','feeandpayment.FeeAndPaymentProjectedDiscountReportGridStore',
	          'feeandpayment.FeeAndPaymentProjectedSponsorStatementGridStore'],
	views : ['baselayout.contentarea.ContentPanel','feeandpayment.ManageFeeStructure',
	         'feeandpayment.FeeProjectedBillingReportStructure',
	          'feeandpayment.FeeProjectedBillingReportForm','feeandpayment.ProjectedBillingReportGrid','feeandpayment.reports.FeeProjectionReportMainStructure',
	          'feeandpayment.FeeProjectedDiscountReportStructure','feeandpayment.FeeProjectedDiscountReportForm','feeandpayment.ProjectedDiscountReportGrid',
	          'feeandpayment.FeeProjectedSponsorReportStructure','feeandpayment.FeeProjectedSponsorReportForm','feeandpayment.ProjectedSponsorReportGrid',
	          'feeandpayment.FeeProjectedSponsorStatementStructure','feeandpayment.FeeProjectedSponsorStatementReportForm','feeandpayment.ProjectedSponsorStatementReportGrid',
	          'feeandpayment.StudentProjectedBillingReportGrid'
              ],	
     config:{
    	
    	 MANAGE_PROJECTED_BILLING_REPORT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PROJECTED_BILLING_REPORT_PRIVILEGES'),
    	 STUDENT_PROJECTED_BILLING_REPORT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PROJECTED_BILLING_REPORT_PRIVILEGES'),
    	 PARENT_PORTAL_STUDENT_PROJECTED_BILLING_REPORT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_PROJECTED_BILLING_REPORT_PRIVILEGES'),
    	 MANAGE_PROJECTED_DISCOUNT_REPORT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PROJECTED_DISCOUNT_REPORT_PRIVILEGES'),
    	 MANAGE_PROJECTED_SPONSOR_REPORT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PROJECTED_SPONSOR_REPORT_PRIVILEGES')
         
     },         
                        
              
     refs : [{
		   	  ref : 'contentpanel',
		   	  selector : 'contentpanel' 
           },{
        	   ref:'feeprojectedbillingreportstructure',
        	   selector:'feeprojectedbillingreportstructure'
           },{
        	   ref:'feeprojectedbillingreportform',
        	   selector:'feeprojectedbillingreportform'
           },{
        	   ref:'projectedbillingreportgrid',
        	   selector:'projectedbillingreportgrid'
           },{
        	   ref : 'feeprojectionreportmainstructure',
        	   selector : 'feeprojectionreportmainstructure'
           },{
        	   ref : 'feeprojecteddiscountreportform',
        	   selector : 'feeprojecteddiscountreportform'
           },{
        	   ref : 'feeprojectedsponsorreportform',
        	   selector : 'feeprojectedsponsorreportform'
           },{
        	   ref:'projecteddiscountreportgrid',
        	   selector:'projecteddiscountreportgrid'
           },{
        	   ref:'projectedsponsorreportgrid',
        	   selector:'projectedsponsorreportgrid'
           },{
        	   ref:'feeprojectedsponsorstatementstructure',
        	   selector:'feeprojectedsponsorstatementstructure'
           },{
        	   ref:'feeprojectedsponsorstatementreportform',
        	   selector:'feeprojectedsponsorstatementreportform'
           },{
        	   ref:'projectedsponsorstatementreportgrid',
        	   selector:'projectedsponsorstatementreportgrid'
           },
           {
        	   ref:'studentprojectedbillingreportgrid',
        	   selector:'studentprojectedbillingreportgrid'
             
           }],
     
           init : function() {
        	   this.control({
        		   /*'feedomappingwin':{
                 render : function(obj){
                     var ALField=this.getFeedomappingwin().down("#academyLocation");;
                     this.setDefaultAcademyLocation(ALField);
                 }
             },*/
        		   'feeprojectedbillingreportform':{
        			   render:function(form){
        				   var academyLocationId = form.down('#academyLocationId');
        				   var academyLocationStore =  academyLocationId.getStore();
        				   var academyLocation = this.getCurrentAcademyLocation();
        				   academyLocationStore.load({
        					   callback: function(records, operation, success) {
        						   for(var i in records){
        							   if(records[i].data.id==academyLocation){
        								   academyLocationId.setValue(records[i].data.id);
        							   }
        						   }
        					   }
        				   });
        				   var grid = form.down('#projectedbillingreportgrid');
        				   //var store = grid.getStore();
        				   this.getGridHeaderFreeze(grid,form);
        				   form.down('#feePlanType').allowBlank=true;
        				   form.down('#feePlan').allowBlank=true;
        				   var studentField = form.down('#student');
        				   var studentFieldStore =  studentField.getStore();
        				   studentFieldStore.getProxy().extraParams = {
        					   academyLocationIds: academyLocation
        				   };
        				   studentFieldStore.load();
        				   
        				   var feePlanTypeField = form.down('#feePlanType');
        				   var feePlanTypeFieldStore =  feePlanTypeField.getStore();
        				   feePlanTypeFieldStore.getProxy().extraParams = {
        					   academyLocationIds: academyLocation
        				   };
        				   feePlanTypeFieldStore.load();
        				   

        			   },
        			   afterrender:function(form){
        				   var portalId = this.getCurrentLoggedPortalId();
        				   if(portalId==3){
        					   var grid = form.down('#studentprojectedbillingreportgrid').show();
        					   var grid1 = form.down('#projectedbillingreportgrid').hide();
        					   grid.columns[0].destroy();
        					   grid.columns[1].destroy();
        					   grid.columns[5].destroy();
        					   form.down('#searchBYItemId').setVisible(false);
        					   var studentField=form.down('#student');
        					   studentField.setVisible(false);
        					   studentField.allowBlank=true;
        					   this.doAccessControlValidation(grid,this.getSTUDENT_PROJECTED_BILLING_REPORT_PERMISSION());
        				   }else if(portalId == 7){
        					   var grid = form.down('#projectedbillingreportgrid');
        					   grid.columns[0].destroy();
        					   grid.columns[1].destroy();
        					   grid.columns[5].destroy();
        					   form.down('#searchBYItemId').setVisible(false);
        					   var studentField=form.down('#student');
        					   studentField.setVisible(false);
        					   studentField.allowBlank=true;
        					   this.doAccessControlValidation(grid,this.getPARENT_PORTAL_STUDENT_PROJECTED_BILLING_REPORT_PERMISSION());
        				   }

        			   }
        		   },
        		   'feeprojectedbillingreportform radiogroup[itemId=searchBYItemId]':{
        			   change : function(obj){
        				   var form = obj.up('feeprojectedbillingreportform');
        				   var student = form.down('#student');
        				   var feePlanTypePanel = form.down('#searchByFeePlanType');
        				   var feePlanType = form.down('#feePlanType');
        				   var feePlan = form.down('#feePlan');
        				   var value = obj.getValue().searchBY;
        				   
        				   student.reset();
        				   feePlanType.reset();
        				   feePlan.reset();
        				   feePlan.setDisabled(true);

        				   if(value){
        					   feePlanType.allowBlank=true;
        					   feePlan.allowBlank=true;
        					   feePlanTypePanel.setVisible(false); 
        					   student.allowBlank=false;
        					   student.setVisible(true);
        				   }else{
        					   student.allowBlank=true;
        					   student.setVisible(false);
        					   feePlanType.allowBlank=false;
        					   feePlan.allowBlank=false;
        					   feePlanTypePanel.setVisible(true); 
        				   }
        				   student.validate();
        				   feePlanType.validate();
        				   feePlan.validate();
                   		   Ext.resumeLayouts();
                   		   form.down('#searchBtn').setDisabled(true);
                   		   form.isValid();
        			   }
        		   },
        		   'feeprojectedbillingreportform customcombobox#feePlanType': {
        			   select: function(obj, record) {
        				   var feePlanTypeId = record[0].get("id");
        				   if(feePlanTypeId > 0){
        					   var form = this.getFeeprojectedbillingreportform();
        					   form.down("#feePlan").setDisabled(false);
        					   var academyLocationCombo = form.down('#academyLocationId');
        					   var academyLocationId=new Array();
        		        	   var academyLocationId = academyLocationCombo.getValue();
        		        	   var alIds = [];
        		        	   var academyLocationIds = null;
        		        	   if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
        		        		   for (var i in academyLocationId) {
        		        			   if (Ext.isObject(academyLocationId[0])) {
        		        				   if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
        		        					   alIds.push(academyLocationId[i].get("id"));
        		        				   }else{
        		        					   alIds.push(academyLocationId[i]);
        		        				   }
        		        			   } else {
        		        				   alIds.push(academyLocationId[i]);
        		        			   }
        		        		   }
        		        		   academyLocationIds = alIds.join();
        		        	   }else
        		        	   {
        		        		   academyLocationIds = academyLocationId;
        		        	   }
        					   var feePlanCombo = form.down('#feePlan');
        					   var feePlanComboStore = feePlanCombo.getStore();
        					   if(academyLocationIds[0]){
        						   feePlanComboStore.getProxy().extraParams = {
            						   feePlanTypeId: feePlanTypeId,
            						   academyLocationIds : academyLocationIds
            					   };
        		        	   }else
        		        	   {
        		        		   feePlanComboStore.getProxy().extraParams = {
            						   feePlanTypeId: feePlanTypeId,
            						   academyLocationIds : this.getCurrentAcademyLocation()
            					   };
        		        	   }
        					   
        					   feePlanComboStore.load();
        				   }
        				   obj.up('feeprojectedbillingreportform').isValid();
        			   }
        		   },
        		   'feeprojectedbillingreportform customcombobox#feePlan': {
        			   select: function(obj, record) {
        				   var form = this.getFeeprojectedbillingreportform();
        				   form.down('#searchBtn').setDisabled(false);
        			   }
        		   },

        		   'feeprojectedbillingreportform button[itemId=searchBtn]' : {
        			   click : this.loadCreateSeqGrid
        		   },

        		   'feeprojectedbillingreportform button[itemId=resetBtn]': {
        			   click: function(){
        				   this.resetFeeProjectedBillingReportForm();
        			   }
        		   },
        		   'feeprojectionreportmainstructure treepanel[itemId=feeProjectionReportTreePanelItemId]':{
        			   itemclick : this.getOpenFeeProjectionReportStructure
        		   },
        		   'feeprojecteddiscountreportform':{
        			   render:function(form){
        				   var academyLocationId = form.down('#academyLocationId');
        				   var academyLocationStore =  academyLocationId.getStore();
        				   var academyLocation = this.getCurrentAcademyLocation();
        				   academyLocationStore.load({
        					   callback: function(records, operation, success) {
        							   for(var i in records){
        								   if(records[i].data.id==academyLocation){
        									   academyLocationId.setValue(records[i].data.id);
        								   }
        							   }
        					   }
        				   });
        				   var programIdField = form.down('#programId');
        				   var programIdFieldStore =  programIdField.getStore();
        				   programIdFieldStore.getProxy().extraParams = {
        					   academyLocationIds: academyLocation
        				   };
        				   programIdFieldStore.load();
        			   }
        		   },
					 'feeprojecteddiscountreportform customcombobox#programGroupItemId':{
						 select:function(obj,record){
							 var $this = this;
							 var form = $this.getFeeprojecteddiscountreportform();
							 var formValues = form.getValues();
							 var program = form.down('#programId');
							 var ALcombo = form.down('#academyLocationId');
							 var academyLocationId=new Array();
							 var academyLocationId = ALcombo.getValue();
							 if(academyLocationId.length!=0){
								 var alIds = [];
								 var academyLocationIds = null;
								 if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
									 for (var i in academyLocationId) {
										 if (Ext.isObject(academyLocationId[0])) {
											 if(academyLocationId[i]!=""){
											 alIds.push(academyLocationId[i].get("id"));
											 }
										 } else {
											 alIds.push(academyLocationId[i]);
										 }
									 }
									 academyLocationIds = alIds.join();
								 }else
								 {
									 academyLocationIds = academyLocationId;
								 } 
							 }else{
								 academyLocationIds = $this.getCurrentAcademyLocation();
							 }
							
							 var batchId = form.getForm().findField('batchId');
	        				  batchId.reset();
							 program.reset();
							 program.getStore().getProxy().extraParams={
								 programGroupId:record[0].data.id,
								 academyLocationIds:academyLocationIds
							 };
							 program.getStore().load();
						 }
					 },
					 'feeprojecteddiscountreportform multiselectcombofield#academyLocationId' : {
						 change : function(obj) { 
							 var $this = this;
							 setTimeout(function(){
								 $this.loadDiscountProgramStoreWithAcademyLocation(obj);
			            		},300);
							 
							 
						 }
					

					 },
					 'feeprojecteddiscountreportform customcombobox#programId' : {
						 select : function(obj, record) {
							 var form = this.getFeeprojecteddiscountreportform();
							 form.down("#batchId").setDisabled(false);
							 var programId = record[0].get("id");
							 if (programId > 0) {
								 var store = this.getStore('enquiry.AcademicBatchStore');
								 store.getProxy().extraParams = {
									 id : programId
								 };
								 store.load();
							 }
						 },
						 change : function(value, newValue) {
							 if (isNullOrEmpty(newValue)) {
								 var form = this.getFeeprojecteddiscountreportform();
								 form.down("#batchId").setDisabled(true);
							 }
						 }
					 },
	        		   'feeprojectedsponsorreportform':{
	        			   render:function(form){
	        				   var academyLocationId = form.down('#academyLocationSponsorId');
	        				   var academyLocationStore =  academyLocationId.getStore();
	        				   var academyLocation = this.getCurrentAcademyLocation();
	        				   academyLocationStore.load({
	        					   callback: function(records, operation, success) {
	        							   for(var i in records){
	        								   if(records[i].data.id==academyLocation){
	        									   academyLocationId.setValue(records[i].data.id);
	        								   }
	        							   }
	        					   }
	        				   });
	        				   var programIdField = form.down('#programId');
	        				   var programIdFieldStore =  programIdField.getStore();
	        				   programIdFieldStore.getProxy().extraParams = {
	        					   academyLocationIds: academyLocation
	        				   };
	        				   programIdFieldStore.load();
	        			   }
	        		   },
	        		   'feeprojectedsponsorreportform customcombobox#programGroupItemId':{
	        			   select:function(obj,record){
	        				   var $this = this;
	        				   var form = $this.getFeeprojectedsponsorreportform();
	        				   var formValues = form.getValues();
	        				   var program = form.down('#programId');
	        				   var ALcombo = form.down('#academyLocationSponsorId');
	        				   var academyLocationId=new Array();
	        				   var academyLocationId = ALcombo.getValue();
	        				   if(academyLocationId.length!=0){
	        				   var alIds = [];
	        				   var academyLocationIds = null;
	        				   if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
	        					   for (var i in academyLocationId) {
	        						   if (Ext.isObject(academyLocationId[0])) {
	        							   if(academyLocationId[i]!=""){
	        							   alIds.push(academyLocationId[i].get("id"));
	        							   }
	        						   } else {
	        							   alIds.push(academyLocationId[i]);
	        						   }
	        					   }
	        					   academyLocationIds = alIds.join();
	        				   }else
	        				   {
	        					   academyLocationIds = academyLocationId;
	        				   }
	        				   }else{
	        					   academyLocationIds = $this.getCurrentAcademyLocation();
	        				   }

	        				   var batchId = form.getForm().findField('batchId');
	        				   batchId.reset();
	        				   program.reset();
	        				   program.getStore().getProxy().extraParams={
	        					   programGroupId:record[0].data.id,
	        					   academyLocationIds:academyLocationIds
	        				   };
	        				   program.getStore().load();
	        			   }
	        		   },
						 'feeprojectedsponsorreportform multiselectcombofield#academyLocationSponsorId' : {
							 change : function(obj) { 
								 var $this = this;
								 setTimeout(function(){
									 $this.loadSponsorProgramStoreWithAcademyLocation(obj);
				            		},300);
							 }
						 },
						 'feeprojectedsponsorreportform customcombobox#programId' : {
							 select : function(obj, record) {
								 var form = this.getFeeprojectedsponsorreportform();
								 form.down("#batchId").setDisabled(false);
								 var programId = record[0].get("id");
								 if (programId > 0) {
									 var store = this.getStore('enquiry.AcademicBatchStore');
									 store.getProxy().extraParams = {
										 id : programId
									 };
									 store.load();
								 }
							 },
							 change : function(value, newValue) {
								 if (isNullOrEmpty(newValue)) {
									 var form = this.getFeeprojectedsponsorreportform();
									 form.down("#batchId").setDisabled(true);
								 }
							 }
						 },
						 'feeprojectedsponsorreportform button[itemId=resetBtn]': {
							 click : function(obj, record) {
								 var filterForm = this.getFeeprojectedsponsorreportform();
								 filterForm.getForm().reset();
								 filterForm.down('#startDate').setMaxValue(null);
								 filterForm.down('#startDate').setMinValue(null);
								 filterForm.down('#tillDate').setMaxValue(null);
								 filterForm.down('#tillDate').setMinValue(null);
								 var academyLocationId = filterForm.down('#academyLocationSponsorId');
								 academyLocationId.clearAllDataFn();
								 var academyLocationStore =  academyLocationId.getStore();
								 var academyLocation = this.getCurrentAcademyLocation();
								 academyLocationStore.load({
									 callback: function(records, operation, success) {
										 for(var i in records){
											 if(records[i].data.id==academyLocation){
												 academyLocationId.setValue(records[i].data.id);
											 }
										 }
									 }
								 });
								 var programIdField = filterForm.down('#programId');
								 var programIdFieldStore =  programIdField.getStore();
								 programIdFieldStore.getProxy().extraParams = {
									 academyLocationIds: academyLocation
								 };
								 programIdFieldStore.load();
							 }
						 },
						 'feeprojectedsponsorreportform button[itemId=searchBtn]': {
							 click: this.loadProjectedSponsorFeeGrid 
			             },
						 'feeprojecteddiscountreportform button[itemId=searchBtn]': {
							 click: this.loadProjectedDiscountFeeGrid 
			             },
			             'projectedsponsorreportgrid':{
			    			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
			    			 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
			                  var $this =this;
			                  if(columnName == "admissionCount"){
			         			   if(e.target.tagName=='A'){
			         				   this.openSponsorStatementTab(grid,record);
			         			   }
			         		   }
			    			 },
			    			 afterrender:function(grid){
				    				var me = this;
				    				setTimeout(function(){
				    					me.addDataGridConfigButton(grid,me.getMANAGE_PROJECTED_SPONSOR_REPORT_PERMISSION());
				    				},1500);
				    			}

			             },
			             'feeprojecteddiscountreportform button[itemId=resetBtn]': {
						 click : function(obj, record) {
							 var filterForm = this.getFeeprojecteddiscountreportform();
								filterForm.getForm().reset();
								filterForm.down('#startDate').setMaxValue(null);
								filterForm.down('#startDate').setMinValue(null);
								filterForm.down('#tillDate').setMaxValue(null);
								filterForm.down('#tillDate').setMinValue(null);
								 var academyLocationId = filterForm.down('#academyLocationId');
								 academyLocationId.clearAllDataFn();
								 var academyLocationStore =  academyLocationId.getStore();
								 var academyLocation = this.getCurrentAcademyLocation();
								 academyLocationStore.load({
									 callback: function(records, operation, success) {
										 for(var i in records){
											 if(records[i].data.id==academyLocation){
												 academyLocationId.setValue(records[i].data.id);
											 }
										 }
									 }
								 });
								 var programIdField = filterForm.down('#programId');
								 var programIdFieldStore =  programIdField.getStore();
								 programIdFieldStore.getProxy().extraParams = {
									 academyLocationIds: academyLocation
								 };
								 programIdFieldStore.load();
						 }
					 },
					 'feeprojectedbillingreportform multiselectcombofield#academyLocationId' : {
						 change : function(obj) { 
							 var $this = this;
							 setTimeout(function(){
								 $this.loadBillingReportFieldsStoreWithAcademyLocation(obj);
			            		},300);
							 
							 
						 }
					

					 },
					 'projectedbillingreportgrid':{
			    			afterrender:function(grid){
			    				var me = this;
			    				setTimeout(function(){
			    					me.addDataGridConfigButton(grid,me.getMANAGE_PROJECTED_BILLING_REPORT_PERMISSION());
			    				},1500);
			    				
			    			}
					 },
					 'projecteddiscountreportgrid':{
			    			afterrender:function(grid){
			    				var me = this;
			    				setTimeout(function(){
			    					me.addDataGridConfigButton(grid,me.getMANAGE_PROJECTED_DISCOUNT_REPORT_PERMISSION());
			    				},1500);
			    			}
					 }
        	   });
           },
           loadCreateSeqGrid:function(){
        	   var $this = this;
        	   var formFilter = this.getFeeprojectedbillingreportform();
        	   formFilter.down('#searchBtn').setDisabled(true);
        	   var form = formFilter.getForm();
        	   var values = form.getValues();
        	   var student = values.student;
        	   var feePlan = values.feePlan;
        	   var startDate = values.startDate;
        	   var tillDate = values.tillDate;        	 
        	   var currentAcademyLocation = $this.getCurrentAcademyLocation();
        	   
        	   if(portalId==3){
        		   student=this.getCurrentlyLoggedInUserWithPersonId().id;
        		   var isStudentPortal = true;
        	   }else if(portalId == 7){
        		   var portalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
        		   var student = portalInfo.student.id;
        	   }
        	   
        	   var academyLocationId = values.academyLocation;
        	   var alIds = [];
        	   var academyLocationIds = null;
        	   if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
        		   for (var i in academyLocationId) {
        			   if (Ext.isObject(academyLocationId[i])) {
        				   if(academyLocationId[i]!=""){
        					   alIds.push(academyLocationId[i].get("id"));
        				   }
        			   } else {
        				   alIds.push(academyLocationId[i]);
        			   }
        		   }
        		   academyLocationIds = alIds.join();
        	   }else
        	   {
        		   academyLocationIds = academyLocationId;
        	   }

			   var form1 = this.getFeeprojectedbillingreportform();	
        	   var projectedbillingreportgrid = $this.getProjectedbillingreportgrid();
				
			   projectedbillingreportgrid.config.searchFilterForm = form1;

        	   var store = this.getStore('feeandpayment.dashboardAndReports.FeeAndPaymentReportGrid');
        	   store.getProxy().extraParams = {	
        		   feeplanId: feePlan,
        		   studentId:student,
        		   billFrom:startDate,
        		   billTo:tillDate,
        		   academyLocationIds:academyLocationIds,
        		   isStudentPortal:isStudentPortal,
        		   
        	   };
        	   $this.resetPageSetting(store);
        	   store.load({
				  callback: function(record, operation, success) {
					  formFilter.down('#searchBtn').setDisabled(false);
					  Ext.Ajax.request({
	  		    		  method: "GET",
	  		    		  type: 'rest',
	  		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
	  		    		  params:{
	  		    			academyLocationId : currentAcademyLocation
	  		    			  
	  		    		  },
	  		    		success: function(response) {
	  		    			  if(response){
	  		    				  result=response.responseText;
	  		    				  if(result === "true")
	  		    				  {
	  		    					$this.toggleGridSummaryRow(projectedbillingreportgrid,false);
	  		    				  }
	  		    				  else
	  		    					  {

 	  		    					  if(record.length>0){
 	  		    						 $this.toggleGridSummaryRow(projectedbillingreportgrid,true);
 	  		    					  }
 	  		    					  else
 	  		    					  {
 	  		    						 $this.toggleGridSummaryRow(projectedbillingreportgrid,false);
 	  		    					  }
	  		    					  }
	  		    				  }
	  		    		}
					  });
	  		    			  
					  
					  
				  }
			  });
           },
           
           resetFeeProjectedBillingReportForm: function(){
	           	var this$ = this;
	           	var form = this$.getFeeprojectedbillingreportform();
	           	form.getForm().reset();
//	           	this$.clearCombo(form.down('#student'), true);
//	           	this$.clearCombo(form.down('#feePlanType'), true);
//	           	this$.clearCombo(form.down('#feePlan'), true);
	            var academyLocationId = form.down('#academyLocationId');
				 academyLocationId.clearAllDataFn();
				 var academyLocationStore =  academyLocationId.getStore();
				 var academyLocation = this.getCurrentAcademyLocation();
				 academyLocationStore.load({
					 callback: function(records, operation, success) {
						 for(var i in records){
							 if(records[i].data.id==academyLocation){
								 academyLocationId.setValue(records[i].data.id);
							 }
						 }
					 }
				 });
	           	form.down('#feePlan').setDisabled(true);
	           	form.down('#startDate').setMaxValue(null);
	           	form.down('#startDate').setMinValue(null);
	           	form.down('#tillDate').setMaxValue(null);
	           	form.down('#tillDate').setMinValue(null);
           },
           getOpenFeeProjectionReportStructure : function(treePanel, record, item,index, e, eOpts){
        	   var $this = this;
        	   var containpanel = $this.getFeeprojectionreportmainstructure();
        	   var treePanel = containpanel.down('#feeProjectionReportTreePanelItemId');
        	   var tabDetail = record.data;
        	   var structure = Ext.widget(tabDetail.reportXtype);
        	   var tabstructure = containpanel.down('#tabpanelIds');

        	   if (!isNullOrEmpty(tabDetail.text)
        			   && !isNullOrEmpty(tabDetail.reportXtype)
        			   && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
        		   treePanel.toggleCollapse();
        		   openTab(tabstructure, tabDetail.text,structure);
        		   treePanel.getSelectionModel().deselectAll();
        	   }
           },
           loadDiscountProgramStoreWithAcademyLocation : function(obj){
        	   var tabStructure = this.getFeeprojectionreportmainstructure();
			   var activeTabRef = tabStructure.down('#tabpanelIds').getActiveTab()
			   var feeProjectedDiscountReportForm = activeTabRef.down('feeprojecteddiscountreportform');
			   var programs = feeProjectedDiscountReportForm.getForm().findField('programId');
        	   var batchId = feeProjectedDiscountReportForm.getForm().findField('batchId');
        	   programsStore = programs.getStore();
        	   programs.reset();
        	   batchId.reset();
        	   var academyLocationId=new Array();
        	   var academyLocationId = obj.getValue();
        	   var alIds = [];
        	   var academyLocationIds = null;
        	   if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
        		   for (var i in academyLocationId) {
        			   if (Ext.isObject(academyLocationId[0])) {
        				   if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
        					   alIds.push(academyLocationId[i].get("id"));
        				   }else{
        					   alIds.push(academyLocationId[i]);
        				   }
        			   } else {
        				   alIds.push(academyLocationId[i]);
        			   }
        		   }
        		   academyLocationIds = alIds.join();
        	   }else
        	   {
        		   academyLocationIds = academyLocationId;
        	   }


        	   if(academyLocationIds[0]){
        		   programsStore.getProxy().extraParams = {
        			   academyLocationIds : academyLocationIds
        		   };
        	   }else
        	   {
        		   programsStore.getProxy().extraParams = {
        			   academyLocationIds : this.getCurrentAcademyLocation()
        		   };
        	   }
        	   programsStore.load();
        	   var programsGroupField = feeProjectedDiscountReportForm.getForm().findField('programGroup');
        	   programsGroupField.reset();

           },
           loadSponsorProgramStoreWithAcademyLocation : function(obj){
        	   var tabStructure = this.getFeeprojectionreportmainstructure();
			   var activeTabRef = tabStructure.down('#tabpanelIds').getActiveTab()
			   var feeProjectedSponsorReportForm = activeTabRef.down('feeprojectedsponsorreportform');
        	  // var feeProjectedSponsorReportForm = this.getFeeprojectedsponsorreportform();
        	   var programs = feeProjectedSponsorReportForm.getForm().findField('programId');
        	   var batchId = feeProjectedSponsorReportForm.getForm().findField('batchId');
        	   programsStore = programs.getStore();
        	   programs.reset();
        	   batchId.reset();
        	   var academyLocationId=new Array();
        	   var academyLocationId = obj.getValue();
        	   var alIds = [];
        	   var academyLocationIds = null;
        	   if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
        		   for (var i in academyLocationId) {
        			   if (Ext.isObject(academyLocationId[0])) {
        				   if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
        				   alIds.push(academyLocationId[i].get("id"));
        				   }else{
        					   alIds.push(academyLocationId[i]);
        				   }
        			   } else {
        				   alIds.push(academyLocationId[i]);
        			   }
        		   }
        		   academyLocationIds = alIds.join();
        	   }else
        	   {
        		   academyLocationIds = academyLocationId;
        	   }

        	   if(academyLocationIds[0]){
        		   programsStore.getProxy().extraParams = {
        			   academyLocationIds : academyLocationIds
        		   };
        	   }else
        	   {
        		   programsStore.getProxy().extraParams = {
        			   academyLocationIds : this.getCurrentAcademyLocation()
        		   };
        	   }
        	   programsStore.load();
        	   var programsGroupField = feeProjectedSponsorReportForm.getForm().findField('programGroup');
        	   programsGroupField.reset();

           },
           loadProjectedSponsorFeeGrid: function() {
        	   var $this = this;
        	   var quickSearchForm = this.getFeeprojectedsponsorreportform();
        	   quickSearchForm.down('#searchBtn').setDisabled(true);
        	   var projectedSponsorGrid = this.getProjectedsponsorreportgrid();
			   projectedSponsorGrid.config.searchFilterForm = quickSearchForm;
        	   formValues = quickSearchForm.getValues();
        	   var academyLocationId = quickSearchForm.down('#academyLocationSponsorId').getValue();
        	   var currentAcademyLocation = $this.getCurrentAcademyLocation();
        	   var alIds = [];
        	   var academyLocationIds = null;
        	   if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
        		   for (var i in academyLocationId) {
        			   if (Ext.isObject(academyLocationId[i])) {
        				   if(academyLocationId[i]!=""){
        					   alIds.push(academyLocationId[i].get("id"));
        				   }
        			   } else {
        				   alIds.push(academyLocationId[i]);
        			   }
        		   }
        		   academyLocationIds = alIds.join();
        	   }else
        	   {
        		   academyLocationIds = academyLocationId;
        	   }

        	   var store = projectedSponsorGrid.getStore();
        	   store.getProxy().extraParams = {
        		   academyLocationIds:academyLocationIds,
        		   programId:formValues.programId,
        		   batchId:formValues.batchId,
        		   sponsorId:formValues.SPONSOR_ID,
        		   programGroupId:formValues.programGroup,
        		   intakeYear:formValues.intakeYear,
        		   fromdate:formValues.startDate,
        		   todate:formValues.tillDate
        	   };
        	   this.resetPageSetting(store);
        	   store.load({
				  callback: function(record, operation, success) {
					  quickSearchForm.down('#searchBtn').setDisabled(false);
					  Ext.Ajax.request({
 	  		    		  method: "GET",
 	  		    		  type: 'rest',
 	  		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
 	  		    		  params:{
 	  		    			academyLocationId : currentAcademyLocation
 	  		    		  },
 	  		    		success: function(response) {
 	  		    			  if(response){
 	  		    				  result=response.responseText;
 	  		    				  if(result === "true")
 	  		    				  {
 	  		    					$this.toggleGridSummaryRow(projectedSponsorGrid,false);
 	  		    				  }
 	  		    				  else
 	  		    				  {
 	  		    					  if(record.length>0){
 	  		    						  $this.toggleGridSummaryRow(projectedSponsorGrid,true);
 	  		    					  }
 	  		    					  else
 	  		    					  {
 	  		    						 $this.toggleGridSummaryRow(projectedSponsorGrid,false);
 	  		    					  }
 	  		    				  }
 	  		    				  }
 	  		    		}
 					  });
					  
					  
					  
					  
				  }
			  });
           },
           loadProjectedDiscountFeeGrid: function() {
        	   var $this = this;
        	   var quickSearchForm = this.getFeeprojecteddiscountreportform();
        	   quickSearchForm.down('#searchBtn').setDisabled(true);
        	   var projectedDiscountGrid = this.getProjecteddiscountreportgrid();
        	   projectedDiscountGrid.config.searchFilterForm = quickSearchForm;
        	   formValues = quickSearchForm.getValues();

        	   var academyLocationId = quickSearchForm.down('#academyLocationId').getValue();
        	   var alIds = [];
        	   var academyLocationIds = null;
        	   var currentAcademyLocation = $this.getCurrentAcademyLocation();
        	   if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
        		   for (var i in academyLocationId) {
        			   if (Ext.isObject(academyLocationId[0])) {
        				   if(academyLocationId[i]!=""){
        				   alIds.push(academyLocationId[i].get("id"));
        				   }
        			   } else {
        				   alIds.push(academyLocationId[i]);
        			   }
        		   }
        		   academyLocationIds = alIds.join();
        	   }else
        	   {
        		   academyLocationIds = academyLocationId;
        	   }

        	   var store = projectedDiscountGrid.getStore();
        	   store.getProxy().extraParams = {
        		   academyLocationIds:academyLocationIds,
        		   programId:formValues.programId,
        		   batchId:formValues.batchId,
        		   studentId:formValues.student,
        		   programGroupId:formValues.programGroup,
        		   intakeYear:formValues.intakeYear,
        		   fromdate:formValues.startDate,
        		   todate:formValues.tillDate
        	   };
        	   this.resetPageSetting(store);
        	   store.load({
 				  callback: function(record, operation, success) {
 					 quickSearchForm.down('#searchBtn').setDisabled(false);
 					  Ext.Ajax.request({
 	  		    		  method: "GET",
 	  		    		  type: 'rest',
 	  		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
 	  		    		  params:{
 	  		    			academyLocationId : currentAcademyLocation
 	  		    		  },
 	  		    		success: function(response) {
 	  		    			  if(response){
 	  		    				  result=response.responseText;
 	  		    				  if(result === "true")
 	  		    				  {
 	  		    				 $this.toggleGridSummaryRow(projectedDiscountGrid,false);
 	  		    				  }
 	  		    				  else
 	  		    				  {
 	  		    					  if(record.length>0){
 	  		    						  $this.toggleGridSummaryRow(projectedDiscountGrid,true);
 	  		    					  }
 	  		    					  else
 	  		    					  {
 	  		    						  $this.toggleGridSummaryRow(projectedDiscountGrid,false);
 	  		    					  }
 	  		    				  }
 	  		    				  }
 	  		    		}
 					  });
 	  		    			  
 					  
 					  
 				  }
 			  });
        	   
           },
           openSponsorStatementTab: function(grid,record) {
        	   var $this = this;
        	   var containpanel = $this.getFeeprojectionreportmainstructure();
        	   var configfeestructure = Ext.widget('feeprojectedsponsorstatementstructure');
        	   var tabName = getFeeAndPaymentCommonTranslation('SPONSOR_STATEMENT');
        	   var tabstructure = containpanel.down('#tabpanelIds');
        	   var tabDetail = tabstructure.items.items;
        	   for(var i in tabDetail){
        		   if(tabDetail[i].title==tabName){
        			   tabDetail[i].close();
        		   }
        	   }
        	   openTab(tabstructure, tabName, configfeestructure);
        	  var projectedSponsorStatementForm = $this.getFeeprojectedsponsorstatementreportform();
        	  projectedSponsorStatementForm.down('#sponsorId').setValue(record.data.sponsorshipCode);
        	  projectedSponsorStatementForm.down('#sponsorName').setValue(record.data.sponsorName);
        	  projectedSponsorStatementForm.down('#noOfStudent').setValue(record.data.admissionCount);
        	  projectedSponsorStatementForm.down('#invoiceAmount').setValue(currencyRenderer(record.data.amount,record.get("feeCurrencyId")));
        	  projectedSponsorStatementForm.down('#invoiceDate').setValue(dateRender(record.data.billingDate));
        	  
        	  var projectedSponsorStatementReportGrid = $this.getProjectedsponsorstatementreportgrid();
        	 var gridStore =  projectedSponsorStatementReportGrid.getStore();
        	 gridStore.getProxy().extraParams = {
        		 academyLocationIds: record.data.als,
        		 sponsorCode:record.data.sponsorshipCode,
        		 billingDate: Ext.Date.format(new Date(record.data.billingDate),CONSTANTS.NEW_SUBMIT_DATE_FORMAT),
        		 currencyId: record.data.feeCurrencyId
			   };
        	 gridStore.load({
				  callback: function(record, operation, success) {
					  if (record.length > 0) {
						  $this.toggleGridSummaryRow(projectedSponsorStatementReportGrid,false);
					  }else{
						  $this.toggleGridSummaryRow(projectedSponsorStatementReportGrid,false);
					  }
				  }
			  });
           },
           loadBillingReportFieldsStoreWithAcademyLocation : function(obj){
        	   var tabStructure = this.getFeeprojectionreportmainstructure();
			   var activeTabRef = tabStructure.down('#tabpanelIds').getActiveTab()
			   var feeProjectedBillingReportForm = activeTabRef.down('feeprojectedbillingreportform');
			   var studentField = feeProjectedBillingReportForm.getForm().findField('student');
        	   var feePlanTypeField = feeProjectedBillingReportForm.getForm().findField('feePlanType');
        	   var feePlanField = feeProjectedBillingReportForm.getForm().findField('feePlan');
        	   feePlanField.reset();
        	   feePlanField.setDisabled(true);
        	   studentFieldStore = studentField.getStore();
        	   studentField.reset();
        	   feePlanTypeFieldStore = feePlanTypeField.getStore();
        	   feePlanTypeField.reset();
        	   var academyLocationId=new Array();
        	   var academyLocationId = obj.getValue();
        	   var alIds = [];
        	   var academyLocationIds = null;
        	   if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
        		   for (var i in academyLocationId) {
        			   if (Ext.isObject(academyLocationId[0])) {
        				   if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
        					   alIds.push(academyLocationId[i].get("id"));
        				   }else{
        					   alIds.push(academyLocationId[i]);
        				   }
        			   } else {
        				   alIds.push(academyLocationId[i]);
        			   }
        		   }
        		   academyLocationIds = alIds.join();
        	   }else
        	   {
        		   academyLocationIds = academyLocationId;
        	   }
        	   if(academyLocationIds[0]){
        		   studentFieldStore.getProxy().extraParams = {
        			   academyLocationIds : academyLocationIds
        		   };
        		   feePlanTypeFieldStore.getProxy().extraParams = {
        			   academyLocationIds : academyLocationIds
        		   };
        	   }else
        	   {
        		   studentFieldStore.getProxy().extraParams = {
        			   academyLocationIds : this.getCurrentAcademyLocation()
        		   };
        		   feePlanTypeFieldStore.getProxy().extraParams = {
        			   academyLocationIds : this.getCurrentAcademyLocation()
        		   };
        	   }
        	   studentFieldStore.load();
        	   feePlanTypeFieldStore.load();
        	  /* var programsGroupField = feeProjectedDiscountReportForm.getForm().findField('programGroup');
        	   programsGroupField.reset();*/

           }
		
});
