/**
 * @author Narendra Jain
 */
Ext.define('Academia.controller.feeandpayment.siblingranking.SiblingRankingController',{
	extend: 'Academia.controller.base.BaseController',
	stores : ['feeandpayment.siblingranking.SiblingRankingGridStore'],
	views : ['feeandpayment.siblingranking.SiblingRankingStructure','feeandpayment.siblingranking.SiblingRankingGrid','feeandpayment.siblingranking.SiblingRankingTabStructure',
		     'feeandpayment.siblingranking.SiblingRankingAddUpdateGrid','feeandpayment.siblingranking.SiblingRankingFilter','feeandpayment.siblingranking.SiblingRankingDetailsWindow',
		     'feeandpayment.siblingranking.SiblingRankingDetailsPopUpGrid'],
	refs : [{
		ref:'siblingrankinggrid',
		selector:'siblingrankinggrid'
	},{
		ref:'siblingrankingfilter',
		selector:'siblingrankingfilter'
	},{
		ref:'siblingrankingdetailswindow',
		selector:'siblingrankingdetailswindow'
	},{
		ref:'siblingrankingdetailspopupgrid',
		selector:'siblingrankingdetailspopupgrid'
	}],
	config: {
		SIBLING_RANKING_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SIBLING_RANKING_PRIVILEGES')
	},
	init : function() {
		this.control({
			'siblingrankinggrid':{
				render: function(grid){
					this.doAccessControlValidation(grid, this.getSIBLING_RANKING_PERMISSION());
				}
			},
			'siblingrankingfilter button[itemId=searchBtnItemId]':{
				click:function(){
					var filter = this.getSiblingrankingfilter(),
					formValues = filter.getForm() && filter.getForm().getValues(),
					aLFieldValue = formValue.academyLocationId,
					grid = this.getSiblingrankinggrid(),
					store = grid.getStore();
					var alData,acaloc = [],selectedAL;
					 if(aLFieldValue!="" && aLFieldValue!=null){
						  for(var i in aLFieldValue){
							if(!isNullOrEmpty(aLFieldValue[i])){
								 alData = aLFieldValue[i].get("id");
								 acaloc.push(alData);
							}else{
								 alData = aLFieldValue[i];
								 acaloc.push(alData);
							}
						}
					}
					if(acaloc.length>0){
						selectedAL=acaloc.join();
					}else{
						selectedAL=aLFieldValue;
					}
					store.getProxy().extraParams = {
						academyLocationId: selectedAL,
						intakeYear:formValues.intakeYear,
						admissionIdOrStudentId :formValues.admissionIdOrStudentId,
						programId:formValues.programName,
						intake:formValues.intake,
						stClass:formValues.stdClass,
						siblingId:formValues.siblingName,
					};
					grid.getSelectionModel().deselectAll();
					this.resetGridSetting(grid);
					this.resetPageSetting(store);
					store.load();
				}
			},
			'siblingrankingfilter button[itemId=resetBtnItemId]':{
				click:function(){
					var filter = this.getSiblingrankingfilter();
					filter.getForm() && filter.getForm().reset();
				}
			},
			'siblingrankinggrid button[itemId=btnAdd]':{
        		click:function(){
        			var siblingRankingWin = this.getSiblingrankingdetailswindow();
        			 if (!siblingRankingWin) {
        	            Ext.widget('siblingrankingdetailswindow');
        	            siblingRankingWin = this.getSiblingrankingdetailswindow();
        	        }
        			 siblingRankingWin.show();
        		}
        	},
		});
	}
});