
/**
 * @author kamlesh
 */
Ext.define('Academia.controller.gradeMaster.GradeMasterSearchController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['gradeMaster.GroupNameValueStore','gradeMaster.GradeTypeNameValueStore','gradeMaster.GradeStatusStore','gradeMaster.Grade',
             'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades','gradeMaster.ExamResultStatusStore','gradeMaster.GradeMasterGridStore'],
    models: ['genericmodels.dropdowns.EnumCombo','common.IdValueDataModel','common.IdValueCodeDataModel','gradeMaster.GradeMasterGridModel'],
    views: ['gradeMaster.GradeMasterSearchStructure', 'baselayout.contentarea.ContentPanel','gradeMaster.GradeMasterSearch','gradeMaster.grade.GradeMasterAddForm','gradeMaster.group.GroupMasterAddForm','gradeMaster.grade.GradeMasterGrid',
    	'gradeMaster.GradeMasterSearchTab'
    ],
    config:{
		/*
		 	* CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
    		   	 */
    	   	/**
    	        * @cfg {Array} GRADEMASTER_PERMISSIONS array (required)
    	        * The array of permissions to use for Access control wise enabling and disabling buttons.
    	        * @accessor
    	        */
	      GRADEMASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('GRADEMASTER_PRIVILEGES') 
        },
    refs: [ {
	        ref: 'grademastertabstructure',
	        selector: 'grademastertabstructure'
	    	},{
	        ref: 'grademastersearch',
	        selector: 'grademastersearch'
	    	},{
           	 ref: 'searchresultgrid',
           	 selector: 'searchresultgrid[itemId=grademastersearchItemId]'
            },{
           	 ref: 'contentPanel',
        	 selector: 'contentPanel'
            },{
          	 ref: 'grademasteraddform',
        	 selector: 'grademasteraddform'
            },{
         	 ref: 'groupmasteraddform',
        	 selector: 'groupmasteraddform'
            },{
             ref: 'grademastersearchstructure',
           	 selector: 'grademastersearchstructure'
            },{
            	ref:'grademastergrid',
            	selector:'grademastergrid'
            }, {
            	ref: 'grademastersearchtab',
            	selector: 'grademastersearchtab'
            }
    ],
    init: function(application) {
        this.control({
            'grademastersearch button[itemId=gradeMasterSearchBtn]': {
                click:function(){
                	this.loadGridAndSearchPrograms();
                }
            },
	   		'searchresultgrid[itemId=grademastersearchItemId]':{
	   		  render:function(grid){
	   			  var permissionsMap = new Ext.util.HashMap();
	              this.gridRenderFunction(grid);
	             permissionsMap = this.getGRADEMASTER_PERMISSIONS();
	             this.genericCBGridAccessControlValidation(grid,permissionsMap);
	   		  }	
			},
			/*'searchresultgrid[itemId=grademastersearchItemId] button[itemId=searchResultGridBtnAdd]': {
				click: function() {
					this.openNewGradeMasterTab();
				}
			},
			'searchresultgrid[itemId=grademastersearchItemId] button[itemId=searchResultGridBtnEdit]': {
				click: function(btn) {
					this.loadDataOnEditWindow(btn); 
				}
			},
			'searchresultgrid[itemId=grademastersearchItemId] button[itemId=searchResultGridBtnDelete]': {
				click: function() {
					this.deleteGridData();
				}
			},
			'searchresultgrid[itemId=grademastersearchItemId] button[itemId=searchResultGridBtnView]': {
				click: function(btn) {
					this.loadDataOnEditWindow(btn);  
					var form =this.getGrademasteraddform();
					if (form) {
						
						form.down('#gradeMasterAddButtonId').setVisible(false);
						form.down('#gradeMasterResetButtonId').setVisible(false);
						form = form.getForm();      
				        toggleReadOnlyFormItems(form, true); 
					}
				 
				}
			},
			//
			 'searchresultgrid[itemId=grademastersearchItemId] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
		            }
		        },
		        'searchresultgrid[itemId=grademastersearchItemId] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
		            }
		        },
		        'searchresultgrid[itemId=grademastersearchItemId] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
		            }
		        },
		        'searchresultgrid[itemId=grademastersearchItemId] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
		            }
		        },
		        
		        'grademastersearchstructure':{
		        	afterrender : function(structure){
		        		var form = structure.down('form');
		        		var grid = structure.down('searchresultgrid');
		        		this.getCBGridHeaderFreeze(grid,form);
		        	}
	    		}
	    		*/
			'grademastergrid button[itemId=btnAdd]': {
				click: function() {
					this.openNewGradeMasterTab();
				}
			},
			
			'grademastergrid button[itemId=btnEdit]': {
				click: function(btn) {
					this.loadDataOnEditWindow(btn); 
				}
			},
			'grademastergrid button[itemId=btnDelete]': {
				click: function() {
					this.deleteGridData();
				}
			},
			'grademastergrid button[itemId=btnView]': {
				click: function(btn) {
					this.loadDataOnEditWindow(btn);  
					var form =this.getGrademasteraddform();
					if (form) {
						
						form.down('#gradeMasterAddButtonId').setVisible(false);
						form.down('#gradeMasterResetButtonId').setVisible(false);
						form = form.getForm();      
				        toggleReadOnlyFormItems(form, true); 
					}
				 
				}
			},
			//
			 'grademastergrid splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
		            }
		        },
		        'grademastergrid splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
		            }
		        },
		        'grademastergrid splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
		            }
		        },
		        'grademastergrid splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
		            }
		        },
		        
		        'grademastersearchtab':{
		        	afterrender : function(structure){
		        		var grid = structure.down('grademastergrid');
		        		this.getGridHeaderFreezeForGradeMaster(grid, structure);
		        	}
	    		}
        });
    },
    openNewGradeMasterTab:function(){
    	 var $this = this;
    	 var contentpanel = $this.getContentPanel();
    	 var gradeMasterTab = Ext.widget('grademastertabstructure');
    	 var tabName = getExaminationTranslation('MANAGE_GRADE');
    	 var getcontroller=this.getController('menu.CoreERPNavigationController');
    	 var getTab=getcontroller.getTab(tabName);
    	 if(getTab!=null){
    		 contentpanel.remove(getTab, true);
    	 }
    	 openTab(contentpanel, tabName, gradeMasterTab,CONSTANTS.MENU_COLOR_FOUR);
    	 var form=this.getGrademasteraddform();
    	 var gradeForm=form.getForm();
    	 form.down('#gradeMasterAddButtonId').setVisible(true);  
		 form.down('#gradeMasterResetButtonId').setVisible(true);
	     var gradetype=gradeForm.findField('gradeType').getValue();
		 var ResultStatus=gradeForm.findField('resultStatus').getValue();       
		 gradeForm.reset();
    },
    loadDataOnEditWindow:function(btn){    
    	var $this=this;
    	var grid=$this.getGrademastergrid();
    	var recordCount = grid.getSelectionModel().getCount();
		if(recordCount>0){
			$this.openNewGradeMasterTab();  
			var records = grid.getSelectionModel().getSelection()[0];	
			var form=$this.getGrademasteraddform();
			var gradeForm=form.getForm();
			
			form.down('#gradeMasterResetButtonId').setVisible(false);  
			form.down('#editableTransferMarkstoGradeId').setVisible(false);             
			var associatedAcadLocationIds = new Array();  
				   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,$this.getGRADEMASTER_PERMISSIONS()); 
					Ext.each(permissionList, function(privilege) {      
				    if (privilege === 'EDITABLE_GRADE') 
					{
				      form.down('#editableTransferMarkstoGradeId').setVisible(true);
					      
				    }
    			  });
		    var submitUrl=SERVERURL.GRADE_MASTER_FIND_BY_URL;
			Ext.Ajax.request({
				type : 'rest',
				url : submitUrl,
				params:{
					id:records.data.id
				},
				method : 'GET',
				success : function(form, action) {
				 var data = form.responseText;
       			 var  jData=Ext.JSON.decode(data);

       			 var gradeTypeFld = gradeForm.findField('gradeType');
       			 var contributeInTheSgpaCgpa=gradeForm.findField('contributeInTheSgpaCgpa').items.items;
       			 var contributionInTheTotalCredits=gradeForm.findField('contributionInTheTotalCredits').items.items;
   			 
       			 gradeTypeFld.store.load({
       				 callback: function(rec, operation, success) {
       					 if (success) {
       						 gradeTypeFld.setValue(jData.gradeType);
       					 	 
       					     // [V2D-505269] Commented out to prevent unnecessary triggering of 'select' event on gradeTypeFld
       						 //gradeTypeFld.fireEvent('select', gradeTypeFld, gradeTypeFld.lastSelection);
       						 var isSpecialGrade = gradeTypeFld.lastSelection[0].get('secondCheck');
							 
							 var isSecondGrade = gradeTypeFld.lastSelection[0].get('check');
							 var secondGradePoint=gradeForm.findField('secondaryGradePoint');
							 if(isSecondGrade){
								secondGradePoint.setVisible(true);
								gradeForm.findField('secondaryGradePoint').setValue(jData.secondaryGradePoint);      
							 }else{
								secondGradePoint.setDisabled(true);
								secondGradePoint.setVisible(false);       
							 }	
							 
       						 $this.changeLabelOnTheBasesOfGradeType(gradeForm,jData.gradeType,isSpecialGrade);
       						 gradeForm.findField('gradeName').setValue(jData.gradeName);
       						 gradeForm.findField('gradeRangeFrom').setValue(jData.gradeRangeFrom);
       						 gradeForm.findField('gradeRangeTo').setValue(jData.gradeRangeTo);
       						 gradeForm.findField('gradePoint').setValue(jData.gradePoint);
       			    		 if(jData.isContributeInTheTotalCredits) {
       		    				 contributionInTheTotalCredits[0].setValue(true);
       		    				 contributionInTheTotalCredits[1].setValue(false);
       						 } else {
       		    				 contributionInTheTotalCredits[1].setValue(true);
       		    				 contributionInTheTotalCredits[0].setValue(false);
       						 }
       						 if(jData.isContributeInTheSgpaCgpa) {
       							 contributeInTheSgpaCgpa[0].setValue(true);
       							 contributeInTheSgpaCgpa[1].setValue(false);
       						 } else {
       							 contributeInTheSgpaCgpa[1].setValue(true);
       							 contributeInTheSgpaCgpa[0].setValue(false);
       						 }
       					 }
       				 }
       			 });
       			 gradeForm.findField('id').setValue(jData.id);
       			 gradeForm.findField('gradeName').setValue(jData.gradeName);
                if(jData.gradeRangeFrom != 0 || jData.gradeRangeTo != 0){
    			 gradeForm.findField('gradeRangeFrom').setValue(jData.gradeRangeFrom);
    			 gradeForm.findField('gradeRangeTo').setValue(jData.gradeRangeTo);
                 }
    			 gradeForm.findField('gradePoint').setValue(jData.gradePoint);
    			 gradeForm.findField('gradeDescription').setValue(jData.gradeDescription);  
    			  gradeForm.findField('resultStatus').setValue(jData.resultStatus); 
    			  gradeForm.findField('publishMarksOnSP').setValue({isPublishMarksOnSP: jData.publishMarkOnTheStudentPortal}); 
    			  gradeForm.findField('publishGradesOnSP').setValue({isPublishGradesOnSP: jData.publishGradeOnTheStudentPortal});
    			  Ext.defer(function() {
        			  var myRec = gradeForm.findField('resultStatus').lastSelection;
    				  gradeForm.findField('resultStatus').fireEvent('select', gradeForm.findField('resultStatus'), myRec);
    			  }, 1000);
    			 gradeForm.findField('gradeDescriptionOther').setValue(jData.gradeDescriptionOtherLang);

    			 var hasGroupRadio=gradeForm.findField('hasGroupRadio');
    			 if(jData.gradesGroups.length>0){   
    				 var groupValue=jData.gradesGroups[0];	 
    				 gradeForm.findField('extraId').setValue(groupValue.id);
    			 }
    			 var resultStatus=gradeForm.findField('resultStatus');
   	        	 var isSpecialGrade = gradeForm.findField('isSpecialGrade');
    			 resultStatus.setVisible(true);
    				 isSpecialGrade.setValue('true');
              
    				 if(!isNullOrEmpty(jData.resultStatus)){
    					 resultStatus.getStore().load({
    	            		 callback: function(rec, operation, success) {
    	            			 if (success) {
    	            				 resultStatus.setValue(jData.resultStatus);
                 
    	            			 }
    	            		 }
    	            	 });
                     if(!isNullOrEmpty(jData.resultStatus)){        
	                       gradeForm.findField('editableTransferMarkstoGradeId').setDisabled(true);
                    if(jData.resultStatus=='Pass'){      
	                   var formnew=$this.getGrademasteraddform();  
	                  formnew.down('#editableTransferMarkstoGradeId').setDisabled(true);                 
	                  gradeForm.findField('editableTransferMarkstoGradeId').setValue(false);
					  
	
                  }else{  
	                 var form1=$this.getGrademasteraddform();           
    			 gradeForm.findField('editableTransferMarkstoGradeId').setValue(jData.editableTransferMarkstoGrade);
				 form1.down('#editableTransferMarkstoGradeId').setDisabled(false); 
			     if(btn.itemId == 'searchResultGridBtnEdit') {    
				 gradeForm.findField('editableTransferMarkstoGradeId').setReadOnly(false); 
			         }
					else{
				 gradeForm.findField('editableTransferMarkstoGradeId').setReadOnly(true); 
			       }  
							} }
    				 }
					
                     
                 
	    		 if(!jData.whetherSpecialGrade){
    				 isSpecialGrade.setValue('false');
    			 }
    			 /** As discussed siddarth sir feilds are by default true and disabled ; 
    			  * min and max permissible will be hidden
    			  * */
    			 if(jData.hasGroup){
    				 hasGroupRadio.items.items[0].setValue(true);
    				 hasGroupRadio.items.items[1].setValue(false);
    				 /*gradeForm.findField('maxPercent').hide();
    				 gradeForm.findField('minPercent').hide();*/
    			 }else if(!jData.hasGroup){
    				 hasGroupRadio.items.items[0].setValue(false);
    				 hasGroupRadio.items.items[1].setValue(true);
    				/* gradeForm.findField('maxPercent').show();
    				 gradeForm.findField('minPercent').show();
    				 gradeForm.findField('maxPercent').setValue(jData.maxPercent);
        			 gradeForm.findField('minPercent').setValue(jData.minPercent);*/
    			 }
                 
    			 gradeForm.findField('gradeStatus').store.load({
            		 callback: function(rec, operation, success) {
            			 if (success) {
            				 gradeForm.findField('gradeStatus').setValue(jData.gradeStatus);
            			 }
            		 }
            	 });
                   var gradetypevalue=jData.gradeType;
                  Ext.Ajax.request({   
	   	 		 type: 'rest',
	   	 		 url: SERVERURL.GET_STATUS_BY_GRADE_TYPE,
	   	 		 method: 'GET',  
	   	 		 params:{
	   	 		    gradeType:gradetypevalue 
	   	 		 },
	   	 		 success: function(jData1, action) {     
					  
	   	 		      var form=$this.getGrademasteraddform();   
	   	 		     if(jData1.responseText==getExaminationTranslation('RELATIVE') && (jData.resultStatus=='Fail')){
	   	 		        form.down('#editableTransferMarkstoGradeId').setDisabled(false);   
				       } else{
	   	 		        form.down('#editableTransferMarkstoGradeId').setDisabled(true);
	   	 		      }
	   	 		    }
	   	 		 });
				 var whetherDeleteMarksField = gradeForm.findField('whetherDeleteMarks');
				if(jData.whetherSpecialGrade){
					whetherDeleteMarksField.show();
					whetherDeleteMarksField.setDisabled(false);
					whetherDeleteMarksField.setValue({isDeleteMarks: jData.marksRemovalSpecialGrade}); 
				 }else{
					whetherDeleteMarksField.hide(); 
				 }
                 
				}
			});
		}else {
   		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
   	 }
    },
    changeLabelOnTheBasesOfGradeType:function(form,gradeType, isSpecialGrade){
    	$this = this;
	   	 Ext.Ajax.request({
	   	 		 type: 'rest',
	   	 		 url: SERVERURL.GET_STATUS_BY_GRADE_TYPE,
	   	 		 method: 'GET',  
	   	 		 params:{
	   	 		    gradeType:gradeType 
	   	 		 },
	   	 		 success: function(jData, action) {
	   	 		      var gradeRangeFromField= form.findField('gradeRangeFrom');   
	   	 	          var gradeRangeToField= form.findField('gradeRangeTo');
                       var gradePointFld = form.findField('gradePoint');
                       status= form.findField('resultStatus').getValue();     
	   	 		      if(jData.responseText==getExaminationTranslation('ABSOLUTE')){
	   	 		         gradeRangeFromField.setFieldLabel(getExaminationTranslation('MARK_RANGE_FROM'));
	   	 		         if(isSpecialGrade){
	   	 		        	 $this.setAllowBlank(gradeRangeFromField, true);
	   	 		        	 $this.setAllowBlank(gradeRangeToField, true);
	   	 		        	 $this.setAllowBlank(gradePointFld, true);
	   	 		         }else{
	   	 		        	 $this.setAllowBlank(gradeRangeFromField, false);
	   	 		        	 $this.setAllowBlank(gradeRangeToField, false);
	   	 		        	 $this.setAllowBlank(gradePointFld, false);
	   	 		         }
	   	 		         //$this.setAllowBlank (gradeRangeFromField,false);
	   	 		         gradeRangeToField.setFieldLabel(getExaminationTranslation('MARK_RANGE_TO'));
	   	 		         //$this.setAllowBlank (gradeRangeToField,false);     
	   	 		         form.findField('editableTransferMarkstoGradeId').setDisabled(true);
	   	 		      }else if(jData.responseText==getExaminationTranslation('RELATIVE') && status=='Fail'){  
	   	 		    	  gradeRangeFromField.setFieldLabel(getExaminationTranslation('GRADE_POINT_RANGE_FROM'));
	   	 		    	  if(isSpecialGrade){
	   	 		    		  $this.setAllowBlank(gradeRangeFromField, true);
	   	 		    		  $this.setAllowBlank(gradeRangeToField, true);
	   	 		    		  $this.setAllowBlank(gradePointFld, true);
	   	 		    	  }else{
	   	 		    		  $this.setAllowBlank(gradeRangeFromField, false);
	   	 		    		  $this.setAllowBlank(gradeRangeToField, false);
	   	 		    		  $this.setAllowBlank(gradePointFld, false);
	   	 		    	  }
	   	 		         //$this.setAllowBlank (gradeRangeFromField,false);
	   	 		         gradeRangeToField.setFieldLabel(getExaminationTranslation('GRADE_POINT_RANGE_TO'));
	   	 		         //$this.setAllowBlank (gradeRangeToField,false);       
					     form.findField('editableTransferMarkstoGradeId').setDisabled(false);
							
	   	 		      }
	   	 		      Ext.defer(function() {
	   	 		    	  $this.getGrademasteraddform().isValid();
	   	 		      }, 1000);
	   	 		    }
	   	 		 }); 
	    },
    deleteGridData:function(){
    	var $this=this;
    	var grid=$this.getGrademastergrid();
    	var recordCount = grid.getSelectionModel().getCount();
    	if(recordCount>0){
    		var records = grid.getSelectionModel().getSelection()[0];	
    		var id=records.data.id;
    		showConfirmMessage(getExaminationTranslation('GRADE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    				 function(btn, text) {
    			 if (btn == 'yes'){
		    		 Ext.Ajax.request({
		    			 method: "DELETE",
		    			 type: 'rest',
		    			 url: SERVERURL.GRADE_MASTER_DELETE_RECORD_URL+'?id='+id,
		    			 headers: {
		    				 'Content-Type': 'application/json'
		    			 },
		    			 params: {
		    				 id: id
		    			 },
		    			 success: function(form, action) {
				 	if(form.responseText=="false") {
                			showWarningMessage(getCommonTranslation('GRADE'),getExaminationTranslation('RECORD_CANNOT_BE_DELETED_AS_IT_IS_USED_AS_A_REFERENCE'));
                	}else if(form.responseText=="true") {
		    				 grid.store.reload();
		    				 showSuccessMessage(getExaminationTranslation('GRADE'), getExaminationTranslation('GRADE_DELETED_MSG'));
		    			 }
		    			 }
		    		 });
    			 }
    		 });
    	 } else {
    		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
    	 }
    },
    loadGridAndSearchPrograms : function(model, records) {
    	var $this = this;
     	var quickSearchForm = $this.getGrademastersearch();
 		var jsonFormatFormData = $this.createJsonFormat(quickSearchForm,records);
 		var searchResultGrid = $this.getSearchresultgrid();
 		var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
//     	resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.EXAM_GRADE_MASTER_LISTING_VIEWCODE);
//    	searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
 		
 		var filter = this.getGrademastersearch();
 		var gradeType = filter.down("#gradeTypeItemId").getValue();
 		var gradeId = filter.down("#gradeItemId").getValue();
 		var gradeStatus = filter.down("#gradeStatus").getValue();
 		
 		var grid = this.getGrademastergrid();
 		var store = grid.getStore();
 		store.removeAll();
		store.getProxy().extraParams = {
			gradeId: gradeId,
			gradeType:gradeType,
			gradeStatus:gradeStatus
		};
		
		
		$this.resetPageSetting(grid.getStore(), grid);
		//grid.getStore().load(); /*for Multiple time API calling */
		grid.getSelectionModel().deselectAll();
		//grid.getStore().pageSize = 25;
		$this.resetPageSetting(grid.getStore(), grid);
		store.load();

 	},
 	createJsonFormat:function(quickSearchForm, record){			
 		var gradeSearchForm=quickSearchForm.getForm();
 		var formValues=gradeSearchForm.getValues();
 		var values = new Object();
 		values.configCode = CONSTANTS.CB.EXAM_GRADE_MASTER_LISTING_CONFIGCODE;
 		var searchcriteria = new Array();
 		var ID = this.getJsonObject('ID', formValues.grade);
    	this.pushJsonObjectInArray(ID,searchcriteria);
    	var GRADE_TYPE = this.getJsonObject('GRADE_TYPE', formValues.gradeTypeName);
    	this.pushJsonObjectInArray(GRADE_TYPE,searchcriteria);
    	var GRADE_GROUP_ID = this.getJsonObject('GRADE_GROUP_ID', formValues.groupNameValue);
    	this.pushJsonObjectInArray(GRADE_GROUP_ID,searchcriteria);
    	var GRADE_STATUS = this.getJsonObject('GRADE_STATUS', formValues.gradeStatus);
    	this.pushJsonObjectInArray(GRADE_STATUS,searchcriteria);
 		values.searchCriterias=searchcriteria;
 		return values;
 	},
 	getJsonObject : function(key, value, additionalValue) {
		if (value != '' && value != null
				&& additionalValue == undefined) {
			return {
				"paramCode" : key,
				"paramValues" : [ value ]
			};
		} else if (value != '' && additionalValue != undefined) {
			return {
				"paramCode" : key,
				"paramValues" : [ value, additionalValue ]
			};
		}
	},
	pushJsonObjectInArray : function(object, array) {
		if (object) {
			array.push(object);
		}
	},
 	gridRenderFunction:function(grid){
 		 grid.addButtonToolbar();
    },
    //
    /*exportList : function(exportUrl,filetype,whetherAll) {
    	var quickSearchForm=this.getGrademastersearch();	
    	var searchResultGrid = this.getSearchresultgrid();
    	var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
    	if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
    	jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
    	}
    	searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString);
    	}, */
    exportUserList : function(exportUrl,filetype,whetherAll) {
        var quickSearchForm=this.getGrademastersearch(); 
        var searchResultGrid = this.getSearchresultgrid();
        var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
        var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
        var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
        var visibleColumns=this.getVisibleColumns(searchResultGrid);
        var reportTitle=getCommonTranslation('GRADEMASTER_LIST');
if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
                      jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
               }
searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

},


    	createSearchCriteriaString: function(searchForm) {
    	    	 var me=this;
    	        var formValues = new Array();
    	        formValues = searchForm.getValues();        
    	        var searchCriteriaString="";
    	        for (var key in formValues) {
    	        	var value = formValues[key];            
    	            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
    	                var keyValueJsonObject = me.getJsonObject( key , value);
    	searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
    	            }
    	        }
    	        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
    	        return searchCriteriaString;
    	}
    
});
   