/*

 *  @author Deepak Sharma
 * 
 */
Ext.define('Academia.controller.hostel.hostelapplication.HostelApplicationController', {
	extend : 'Academia.controller.base.BaseController',
	
	models:['hostel.hostelapplication.HostelApplicationApplicantModel','hostel.hostelapplication.HostelApplicationsListGridModel'],
	
	stores : ['user.UserAcademyLocationStore','hostel.hostelapplication.HostelSattlementStatusStore','personinfo.common.personalinfo.AttendanceReportProgramGroupStore',
			'common.IntakeYearStore','common.AcademicTermStore','program.StudentsByAcademyLocationIdStore',
			'program.ProgramByGroupIdStore','program.programbatchdetail.BatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			'enquiry.SeatTypeStore','attendance.SectionAndFacultyByPeriodID','hostel.hostelapplication.HostelApplicationStore',
			'hostel.hostelapplication.HostelApplyRuleStore','hostel.hostelapplication.HostelApplicationApplicantTypeStore','hostel.hostelapplication.HostelApplicationApplicantStore',
			'hostel.hostelapplication.HostelWaitingListStore','hostel.hostelapplication.HostelApplicationALGridStore',
			'hostel.hostelapplication.HostelApplicationTypeStore','hostel.hostelapplication.HostelApplicationStatusComboStore',
			'hostel.managehostel.hostel.HostelCodeName','hostel.managehostel.hostel.LocationCodeName','hostel.hostelapplication.HostelApplicantWaitingListStore',
			'hostel.hostelapplication.HostelApplicantDepositCategoryListStore','hostel.hostelapplication.HostelApplicationALStore','hostel.hostelapplication.HostelApplicantYearStore',
			'importutility.ModuleName','importutility.BulkStatusGridStore','hostel.hostelapplication.HostelApplicationsListGridStore','importutility.BulkHostelAllocationGridStore','hostel.hostelapplication.WaitingListForApplicantStore',
			'criteriabuilder.userquicksearch.QuickSearchName','hostel.hostelapplication.GeneralHostelApplicantWindowStore','hostel.managehostel.hostel.HostelAllocatedStore','hostel.hostelapplication.HostelApplicationIssueDepositStore','hostel.hostelapplication.HostelApplicationReservationCategoryStore',
			'hostel.hostelapplication.HostelApplicationLocationStore','criteriabuilder.userquicksearch.UserImportTabStore'],
	          
	views : ['hostel.hostelapplication.HostelApplicationsStructure','hostel.hostelapplication.HostelApplicationSearch',
			'hostel.hostelapplication.HostelApplicationList','hostel.roomallocation.HostelRoomAllocationStructure',
			'hostel.hostelapplication.HostelApplyRuleWindow','hostel.hostelapplication.HostelRejectApplicationWindow','hostel.hostelapplication.HostelFeeDetailWin',
			'hostel.hostelapplication.HostelApplicationApplicantListGrid','hostel.hostelapplication.HostelApplicationALWindow',
			'hostel.hostelapplication.HostelAPPSTDSearchStructure','hostel.hostelapplication.HostelStudentSearch',
			'hostel.hostelapplication.BulkResisdenceApplicantStatusUpdate','hostel.hostelapplication.DownloadApplicantLoaderForm'
			,'hostel.hostelapplication.UploadApplicantLoaderForm','hostel.hostelapplication.BulkResisdenceApplicantStatusUpdate','hostel.hostelapplication.BulkStatusUpdateGrid','UploadOptionRadioGroup'
			,'hostel.hostelapplication.BulkHostelAllocation','hostel.hostelapplication.DownloadAllocationLoaderForm','hostel.hostelapplication.UploadAllocationLoaderForm',
			'hostel.hostelapplication.BulkHostelAllocationGrid','hostel.hostelapplication.HostelApplicationsSearch','hostel.hostelapplication.HostelApplicationsListGrid','hostel.manageallocation.manageallocationuserwise.ManageAllocationUserWiseSearch',
			'hostel.hostelapplication.MarkAsUnsuccessfulPopUp','hostel.hostelapplication.AllocateHostelPopUp','hostel.hostelapplication.GeneralHostelApplicantWindow','hostel.hostelapplication.CancelApplicationWin','hostel.hostelapplication.ResidenceAllocationWin','hostel.hostelapplication.HostelIssueOfferLatter',
			'hostel.hostelapplication.HostelImportStructure','hostel.hostelapplication.HostelImportView'],
	         refs :[ {
				 ref: 'generalhostelapplicantwindow',
				 selector: 'generalhostelapplicantwindow'
			 }, {
	        	 ref : 'contentPanel',
	        	 selector : 'contentPanel'
	         },{
	        	 ref : 'hostelapplicationsstructure',
	        	 selector : 'hostelapplicationsstructure'
	         },{
	        	 ref : 'hostelapplicationsearch',
	        	 selector : 'hostelapplicationsearch'
	         },{
	        	 ref : 'hostelapplicationlist',
	        	 selector : 'hostelapplicationlist'
	         },{
	        	 ref : 'hostelapplyrulewindow',
	        	 selector : 'hostelapplyrulewindow'
	         },{
	        	 ref : 'hostelrejectapplicationwindow',
	        	 selector : 'hostelrejectapplicationwindow'
	         },{
	             ref: 'hostelfeedetailwin',
	             selector: 'hostelfeedetailwin'
	         },{
	             ref: 'hostelapplicationapplicantlistgrid',
	             selector: 'hostelapplicationapplicantlistgrid'
	         },{
	             ref: 'hostelapplicationalwindow',
	             selector: 'hostelapplicationalwindow'
	         },{
	     		ref : 'importHostelApplicantFormRadioGroup',
	    		selector : 'uploadoptionradiogroup[itemId=importHostelApplicantFormRadioGroupItemId]'
	    	},{
	        	 ref : 'hostelstudentsearch',
	        	 selector : 'hostelstudentsearch'
	         },{
	        	 ref:'bulkresisdenceapplicantstatusupdate',
	        	 selector:'bulkresisdenceapplicantstatusupdate'
	         },{
	        	 ref:'downloadApplicantLoaderForm',
	        	 selector:'downloadApplicantLoaderForm'
	         },{
	        	 ref:'uploadApplicantLoaderForm',
	        	 selector:'uploadApplicantLoaderForm'
	         },{
	        	 ref:'bulkstatusupdategrid',
	        	 selector:'bulkstatusupdategrid'
	         },{
	        	 ref:'markasunsuccessfulpopup',
	        	 selector:'markasunsuccessfulpopup'
	         },{        
	          ref : 'uploadoptionradiogroup',        
	          selector : 'uploadoptionradiogroup[itemId=uploadmarksUploadOptionRadioGroupItemId]'      
	        	  },
	        	 {
	        		 ref : 'bulkhostelallocation',        
	        		 selector : 'bulkhostelallocation'  
	        	 },
	        	 {
	        		 ref : 'downloadallocationloaderform',        
	        		 selector : 'downloadallocationloaderform' 
	        	 },{
	        		 ref : 'uploadallocationloaderform',        
	        		 selector : 'uploadallocationloaderform' 
	        	 },
	        	 {
	        		 ref : 'bulkhostelallocationgrid',        
	        		 selector : 'bulkhostelallocationgrid' 
	        	 
	         },{        
	        	 ref : 'uploadoptionradiogroup',        
	        	 selector : 'uploadoptionradiogroup[itemId=uploadmarksUploadOptionRadioGroupItemId]'      
        	 },{
	        	 ref : 'hostelapplicationssearch',
	        	 selector : 'hostelapplicationssearch'
	         },{
	        	 ref:'hostelapplicationslistgrid',
	        	 selector:'hostelapplicationslistgrid'
	         },{
	        	 ref:'manageallocationuserwisesearch',
	        	 selector:'manageallocationuserwisesearch'
	         },{
	        	 ref:'hostelroomallocationstructure',
	        	 selector:'hostelroomallocationstructure'
	         },{
	        	 ref:'userwisesearch',
	        	 selector:'userwisesearch'
	         },{
	        	 ref:'allocatehostelpopup',
	        	 selector:'allocatehostelpopup'
	         },{
	        	 ref:'cancelApplicationWin',
	        	 selector:'cancelApplicationWin'
	         },{
	        	 ref:'hostelIssueOfferLatter',
	        	 selector:'hostelIssueOfferLatter'
	         },{
	        	 ref:'residenceAllocationWin',
	        	 selector:'residenceAllocationWin'
	         },{
	        	 ref:'hostelImportStructure',
	        	 selector:'hostelImportStructure'
	         }],
	         config: {
	        	 HOSTEL_APPLICATION_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOSTEL_APPLICATION_PRIVILEGES'),
	        	 HOSTEL_APPLICATION_APPLICANT_GRID_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOSTEL_APPLICATION_APPLICANT_GRID_PRIVILEGES'),
	        	 RESIDENCE_APPLICATIONS_GRID_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('RESIDENCE_APPLICATIONS_GRID_PRIVILEGES'),
	        	 
	         }, 
	              
	init : function() {
//		this.showStudentHostalGrid = false;
		this.control({
			'hostelapplicationlist[itemId=hostelApplicationListItemId]':{
				render:function(grid){
					this.doAccessControlValidation(grid, this.getHOSTEL_APPLICATION_PERMISSION());
					this.doAccessControlCustomBtnValidation(grid, this.getHOSTEL_APPLICATION_PERMISSION());
				},
				afterrender:function(grid){
					var alinfomodel = Academia.model.authentication.ALInfoModel;
            		var wheatherSchool = alinfomodel.get('wheatherSchool');
            		var academyLocationId = this.getCurrentAcademyLocation();
            		if(wheatherSchool) {
            			grid.down('[dataIndex=period]').hide();
            			grid.down('[dataIndex=seatType]').hide();
            		}
				},
				cellclick: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					var this$ = this;
					var columnName = view.getGridColumns()[cellIndex].dataIndex;
					studentDetails=record;
					var portalInfo = Academia.model.authentication.StudentERPInfoModel;
					var grid = this.getHostelapplicationlist();
					Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
				    var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
					var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
					if (grid.getSelectionModel().getCount() > 0) {
						localStorage.setItem('PROGRAM_ID',record.data.PROGRAM_ID);
						if(grid.getSelectionModel().getCount() > 1) {
						} else {
							/*if (grid.getSelectionModel().getSelection()[0].data.STATUS=='Inactive') {
								grid.down('#raiseRequestButtonItemId').setDisabled(true);
							}
							else {
								grid.down('#raiseRequestButtonItemId').setDisabled(false);
							}*/
						}
					}
					if (columnName == "studentCode") {
						var tabTitle = record.get('studentCode');
						var personId = record.get('studentId');
						var userId = record.get('studentId');
						//var admissionId = record.get('ADMISSION_ID');
						//var programBatchSeatTypeConfigId = record.get('PROGRAM_BATCH_SEAT_CONFIG_ID');
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.BATCH_ID_BY_STUDENT_ID+'?studentId='+userId,
							method: 'GET',
							async: false,
							success: function(res, action) {
								var data = Ext.decode(res.responseText);
								portalInfo.set('admissionDetails',data[0].admissionDetails);
								portalInfo.set('student',data[0].student);
								portalInfo.set('userAacademyLocations',data[0].userAacademyLocations);
								portalInfo.set('programBatchDetails',data[0].programBatchDetails);
								portalInfo.set('pastProgramBatchDetails',data[0].pastProgramBatchDetails);
							}
						});
						personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, null, null);
						personController.addContentPanelTab(tabTitle, 'pendingbillsgrid', userId, personId, null, null, null);
						/*var studentProfile = studentListController.getTabReferenceByTabTitle(tabTitle);
						var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');
						if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
							var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
							studentListController.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);        	
						}*/
					}
				},
				afterrender:function(grid){
    				var me = this;
    				setTimeout(function(){
    					me.addDataGridConfigButton(grid,me.getHOSTEL_APPLICATION_PERMISSION());
    				},1500);

    			}
			},
			'hostelapplicationlist':{
				selectionchange: function() {
					var $this=this;
					var grid = this.getHostelapplicationlist();
					var records = grid.getSelectionModel().getSelection();
					var associatedAcadLocationIds = new Array();
			    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getHOSTEL_APPLICATION_PERMISSION());
					var IsAllotRoom = false;
					var applyRuled =false;
					var isRejected =false;
					var isRejectedApp =false;
					
					Ext.each(permissionList, function(privilege) {
			    		if (privilege === 'ALLOTEROOM') {
			    			IsAllotRoom=true;
			        	}
			    		if (privilege === 'APPLY_RULE') {
			    			applyRuled=true;
			        	}
			    		if (privilege === 'REJECTAPPLICATION') {
			    			isRejectedApp=true;
			        	}
			    		
			    	});
					var grid = this.getHostelapplicationlist();
					var alloteRoomBtn2= grid.down('#btnAllotRoom');
					var applyRuleBtn2 = grid.down('#btnApplyRule')
					var btnRejectApplication2 = grid.down('#btnRejectApplication')
					var isRejected= false;
					for(var i in records){
							if(records[i].data.hostelStatus=='REJECTED'){
								isRejected=true;
								break;
						}
				    }
					if(IsAllotRoom){
						if (grid.getSelectionModel().getCount() >= 2) {
							alloteRoomBtn2.setDisabled(true);
					 }else{
						 if(isRejected){
							 alloteRoomBtn2.setDisabled(true);
						 }else{
							 alloteRoomBtn2.setDisabled(false);
						 }
					  }
					}
					/*if(applyRuled){
						if(isRejected){
							applyRuleBtn2.setDisabled(true);
						}else{
							applyRuleBtn2.setDisabled(false);
						}
					}*/
					if(isRejectedApp){
						if(isRejected){
							btnRejectApplication2.setDisabled(true);
						}else{
							btnRejectApplication2.setDisabled(false);
						}
					}
			  },
			   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				   var hostelapplicationlist = this.getHostelapplicationlist();
					var columnName=hostelapplicationlist.columnManager.columns[cellIndex].dataIndex;
					
					if(columnName=='billStatus'){
						if (e.target.tagName == 'A') {
							this.showHostelFeeDetailWindow(grid,record);
						}
					}
				
					
				}
			},
			'hostelstudentsearch combo#academyLocationItemId': {
            	render: function(obj) {
            		var userId = this.getCurrentlyLoggedInUser().id;
            		var grid2 = this.getHostelapplicationslistgrid();
					var allotButton = grid2.down('#btnAllotRoom');
					allotButton.setDisabled(true);
            		var store = obj.getStore();
            		store.getProxy().extraParams = {
            			id: userId
            		};
            		//store.load();
            	},
            	
            	afterrender:function(combo){
            		var userId = this.getCurrentlyLoggedInUser().id;
            		var store = combo.getStore();
            		store.on('beforeload',function() {
					   store.getProxy().extraParams = {
						  id: userId
					   };
				   }, this);
            	},
            	select: function(obj, record){
            		var hostelStudentSearchFilter = this.getHostelstudentsearch(),
            		programGroupcombo = hostelStudentSearchFilter.down('#programGroupId'),
            		studentNamecombo = hostelStudentSearchFilter.down('#studentName'),
            		programIdCombo = hostelStudentSearchFilter.down('#programId');
            		programGroupcombo.reset();
            		studentNamecombo.reset();
            		programIdCombo.reset();
            		var store = programGroupcombo.getStore(),
            		studentNamecomboStore = studentNamecombo.getStore(),
            		programIdStore = programIdCombo.getStore();
            		if(!isNullOrEmpty(obj.getValue())){
            			store.getProxy().extraParams = {
                			academyLocationId: obj.getValue()
                		};
            			studentNamecomboStore.getProxy().extraParams = {
            				academyLocationId: obj.getValue()
                		};
            			
            			programIdStore.getProxy().extraParams = {
            				academyLocationId: obj.getValue()
                		};
            		}
            		store.load();
            		studentNamecomboStore.load();
            		programIdStore.load();
            		
            		var batch = hostelStudentSearchFilter.down("#batchId");
            		batch.setDisabled(true);
            		batch.reset();

            		var period = hostelStudentSearchFilter.down("#periodId"); 					   
            		period.setDisabled(true);
            		period.reset();
            		
            		var seatType = hostelStudentSearchFilter.down("#seatType"); 					   
            		seatType.setDisabled(true);
            		seatType.reset();

            		var section = hostelStudentSearchFilter.down("#sectionId");
            		section.setDisabled(true);
            		section.reset();
            		
            		var alinfomodel = Academia.model.authentication.ALInfoModel;
            		var wheatherSchool = alinfomodel.get('wheatherSchool');
            		
            		if(wheatherSchool) {
            			period.setVisible(false);
            		}
            	}
            },
            'hostelstudentsearch combo#programGroupId': {
            	render: function(obj) {
            		var hostelStudentSearchFilter = this.getHostelstudentsearch(),
            		academyLocationId = hostelStudentSearchFilter.down('#academyLocationItemId').getValue();
            		var store = obj.getStore();
            		if(!isNullOrEmpty(academyLocationId)){
            			store.getProxy().extraParams = {
                			academyLocationId: academyLocationId
                		};	
            		}
            		store.load();
            	},
            	select: function(combo) {
            		var hostelStudentSearchFilter = this.getHostelstudentsearch(),
            		programIdCombo = hostelStudentSearchFilter.down('#programId'),
            		academyLocationId = hostelStudentSearchFilter.down('#academyLocationItemId').getValue();
            		programIdCombo.reset();
            		var programIdStore = programIdCombo.getStore();
            		
            		programIdStore.getProxy().extraParams = {
            			programGroupId: combo.getValue(),
            			academyLocationId: academyLocationId
            		};
            		programIdStore.load();
            		
            		var batch = hostelStudentSearchFilter.down("#batchId");
            		batch.setDisabled(true);
            		batch.reset();

            		var period = hostelStudentSearchFilter.down("#periodId"); 					   
            		period.setDisabled(true);
            		period.reset();
            		
            		var seatType = hostelStudentSearchFilter.down("#seatType"); 					   
            		seatType.setDisabled(true);
            		seatType.reset();

            		var section = hostelStudentSearchFilter.down("#sectionId");
            		section.setDisabled(true);
            		section.reset();
            		
            		var alinfomodel = Academia.model.authentication.ALInfoModel;
            		var wheatherSchool = alinfomodel.get('wheatherSchool');
            		
            		if(wheatherSchool) {
            			period.setVisible(false);
            		}
            	}
            },
            'hostelstudentsearch combo#programId': {
            	select: function(combo) {
            		var hostelStudentSearchFilter = this.getHostelstudentsearch(),
            		programId = combo.getValue();
            		
            		var batchCombo = hostelStudentSearchFilter.down("#batchId");
            		batchCombo.setDisabled(false);
            		batchCombo.reset();
            		
            		var batchComboStore = batchCombo.getStore();
            		if(!isNullOrEmpty(programId)){
            			batchComboStore.getProxy().extraParams = {
            				id: programId
                		};	
            		}
            		batchComboStore.load();
            		
            		var period = hostelStudentSearchFilter.down("#periodId"); 					   
            		period.setDisabled(true);
            		period.reset();
            		
            		var seatType = hostelStudentSearchFilter.down("#seatType"); 					   
            		seatType.setDisabled(true);
            		seatType.reset();

            		var section = hostelStudentSearchFilter.down("#sectionId");
            		section.setDisabled(true);
            		section.reset();
            		
            		var alinfomodel = Academia.model.authentication.ALInfoModel;
            		var wheatherSchool = alinfomodel.get('wheatherSchool');
            		
            		if(wheatherSchool) {
            			period.setVisible(false);
            		}
            	}
            },
            
            'hostelapplicationssearch customcombobox#locationNameItemId': {
            	select: function(combo) {
            		var form = this.getHostelapplicationssearch();
            	    var location = form.down("#locationNameItemId").getValue();
            		var studentListId = form.down("#studentNameItemId");
            		var programGroup = form.down("#programGroupId");
            		var hostelNameOrCode =  form.down("#hostelCodeName");
            		
            		var applicantType = form.down('#applicantionType').getValue();
            		var Year =  form.down("#YearId").getValue();
            		var waitingList = form.down("#hstlWaitingList");
        			var waitingListStore = waitingList.getStore();
					   
				    waitingListStore.getProxy().extraParams = {
				    	academyLocationId:location,
					    academicTerm:Year,
	  	      			hostelApplicationType:applicantType
	  	          	};
				   
				   waitingListStore.load();
            		
            		var programGroupStore = programGroup.getStore();
            		
            		programGroupStore.getProxy().extraParams = {
            			locationId: location,
                		};	
            		
            		programGroupStore.load();
            		var studentListIdStore = studentListId.getStore();
            		
            		studentListIdStore.getProxy().extraParams = {
            			locationId: location
                		};	
            		
            		studentListIdStore.load();
                     var hostelNameOrCodeStore = hostelNameOrCode.getStore();
            		
                     hostelNameOrCodeStore.getProxy().extraParams = {
            			locationId: location
                		};	
            		
                     hostelNameOrCodeStore.load();
            	}
            },  
            
            
            
            'hostelapplicationssearch customcombobox#studentNameItemId': {
            	select: function(combo) {
            		var form = this.getHostelapplicationssearch();
            	    var location = form.down("#locationNameItemId").getValue();
            		var studentListId = form.down("#studentNameItemId").getValue();
            		
            	}
            },  
            
            'hostelapplicationssearch customcombobox#programGroupId': {
            	change: function(combo) {
            		var form = this.getHostelapplicationssearch();
            		var programGroup = form.down("#programGroupId").getValue();
            		var programCode =  form.down("#programItemId");
            		var batch = form.down("#batchItemId");
            		var seatTypeItemId = form.down("#seatTypeItemId");
            		
            		
            		programCode.reset();
            		programCode.setDisabled(false);
            		batch.reset();
            		batch.setDisabled(true);
            		seatTypeItemId.reset();
            		seatTypeItemId.setDisabled(true);
            		
            		var programCodeStore = programCode.getStore();
            		
            		programCodeStore.getProxy().extraParams = {
            			programGroupId:programGroup
                		};	
            		
            		programCodeStore.load();
            	}
            },
            
            'hostelapplicationssearch customcombobox#programItemId': {
            	select: function(combo) {
            		var form = this.getHostelapplicationssearch();
            		var programCode =  form.down("#programItemId").getValue();
            		var batch = form.down("#batchItemId");
                    var seatTypeItemId = form.down("#seatTypeItemId");
            		
            		batch.reset();
            		batch.setDisabled(false);
            		seatTypeItemId.reset();
            		seatTypeItemId.setDisabled(true);

            		var batchStore = batch.getStore();
            		
            		batchStore.getProxy().extraParams = {
            			id:programCode
                		};	
            		
            		batchStore.load();
            	}
            },
           
            'hostelapplicationssearch customcombobox#batchItemId': {
            	select: function(combo) {
            		var form = this.getHostelapplicationssearch();
            		var batch = form.down("#batchItemId").getValue();
            		var seatTypeItemId = form.down("#seatTypeItemId");
            		var intakeYear = form.down("#intakeYear");
            		
            		seatTypeItemId.reset();
            		seatTypeItemId.setDisabled(false);
            		
            		var intakeYearStore = intakeYear.getStore();
            		
            		intakeYearStore.getProxy().extraParams = {
            			batchId:batch
                		};	
            		
            		intakeYearStore.load();
            		
                    var seatTypeItemIdStore = seatTypeItemId.getStore();
            		
            		seatTypeItemIdStore.getProxy().extraParams = {
            			batchId:batch
                		};	
            		
            		seatTypeItemIdStore.load();
            	}
            },
            
            'hostelapplicationssearch customcombobox#applicantionType': {
            	select:function(combo){
            		var form = combo.up('form');
            		var applicantType = combo.getValue();
            		var Year =  form.down("#YearId").getValue();
            		var waitingList = form.down("#hstlWaitingList");
            		var locationId = form.down('#locationNameItemId').getValue()
        			var waitingListStore = waitingList.getStore();
					   
				   waitingListStore.getProxy().extraParams = {
					   academyLocationId:locationId,
					    academicTerm:Year,
	  	      			hostelApplicationType:applicantType
	  	          	};	
				   waitingListStore.load();
            	}
            },
            
            'hostelapplicationssearch customcombobox#YearId': {
            	select:function(combo){
            		var form = combo.up('form');
            		var Year = combo.getValue();
            		var applicantType =  form.down("#applicantionType").getValue();
            		var waitingList = form.down("#hstlWaitingList");
            		var locationId = form.down('#locationNameItemId').getValue()
        			var waitingListStore = waitingList.getStore();
					   
        			waitingListStore.getProxy().extraParams = {
        				academyLocationId:locationId,
					    academicTerm:Year,
	  	      			hostelApplicationType:applicantType
	  	          	}	
				   waitingListStore.load();
            	}
            },
            
            'hostelapplicationssearch button[itemId=resetButtonItemId]': {
              	click:function(combo){
              		var form = this.getHostelapplicationssearch();
              		var applicantionType = form.down("#applicantionType")
              		var location = form.down("#locationNameItemId")
            		var studentListId = form.down("#studentNameItemId")
              		var programGroup = form.down("#programGroupId")
              		var programCode =  form.down("#programItemId")
              		var intakeYear = form.down("#intakeYear");
            		var seatTypeItemId = form.down("#seatTypeItemId");
              		var batch = form.down("#batchItemId");
            		var waitingListName = form.down("#hstlWaitingList"); 
            		var yearId = form.down("#YearId"); 
            		var applicationStatus = form.down("#applicationStatusItemId");
            		var hostelCodeName = form.down("#hostelCodeName");
            		
            		applicantionType.reset();
            		location.reset();
            		studentListId.reset();
            		intakeYear.reset();
            		programGroup.reset();
            		programCode.reset();
            		programCode.setDisabled(true);
            		batch.reset();
            		batch.setDisabled(true);
            		seatTypeItemId.reset();
            		seatTypeItemId.setDisabled(true);
            		hostelCodeName.reset();
            		waitingListName.reset();
            		var waitingListStore = waitingListName.getStore()
            		delete waitingListStore.getProxy().extraParams.academyLocationId;
            		delete waitingListStore.getProxy().extraParams.hostelApplicationType;
            		delete waitingListStore.getProxy().extraParams.academicTerm;
            		waitingListStore.load();
            		yearId.reset();
            		applicationStatus.reset();
            		
            		
              		var studentListIdStore = studentListId.getStore();
            		
              		delete studentListIdStore.getProxy().extraParams.locationId;
              		studentListIdStore.load();
              		
                    var programGroupStore = programGroup.getStore();
            		
              		delete programGroupStore.getProxy().extraParams.locationId;
              		programGroupStore.load();
              		
                    var hostelCodeNameStore = hostelCodeName.getStore();
            		
              		delete hostelCodeNameStore.getProxy().extraParams.locationId;
              		hostelCodeNameStore.load();
              		
              	}
              },
            
              'hostelapplicationssearch button[itemId=searchButtonItemId]': {
              	click: function(btn) {
              		var form = this.getHostelapplicationssearch();
              		var applicantionType = form.down("#applicantionType").getValue();
              		var location = form.down("#locationNameItemId").getValue();
            		var studentListId = form.down("#studentNameItemId").getValue();
              		var programGroup = form.down("#programGroupId").getValue();
              		var programCode =  form.down("#programItemId").getValue();
              		var intakeYear = form.down("#intakeYear").getValue();
              		var batch = form.down("#batchItemId").getValue();
            		var seatTypeItemId = form.down("#seatTypeItemId").getValue();
            		var hostelCodeName = form.down("#hostelCodeName").getValue();
            		var waitingListName = form.down("#hstlWaitingList").getValue();
            		var yearId = form.down("#YearId").getValue();
              		var applicationStatus = form.down("#applicationStatusItemId").getValue();
              		var grid = this.getHostelapplicationslistgrid();
              		
              		var waitingListConfig = form.down('#hstlWaitingList').getStore()
            		var hstlWaitingListVal='';
            		waitingListConfig.data.items.filter(function(item){
            			if(item.data.id == waitingListName) {
            				hstlWaitingListVal = item.data.value;
            			}
            		})
              		
              		
              		   btn.setDisabled(true);
//              		var submitURL = SERVERURL.STUDENT_HOSTEL_APPLICATION_GRID_DATA;
					
              		        grid.getStore().getProxy().extraParams = {
						    hostelSetupType: applicantionType,
		    				locationId: location,
		    				studentId : studentListId,
		    				programId:programCode,
		    				intakeYearId:intakeYear,
		    				intakeId:batch,
		    				seatTypeId:seatTypeItemId,
		    				academicTermId:yearId,
		    				hostelId:hostelCodeName,
		    				waitingListName:hstlWaitingListVal.length>0 ? hstlWaitingListVal : null,
		    				programGroupId: programGroup,
		    				applicationStatus:applicationStatus,
						        }
						          
						          grid.getSelectionModel().deselectAll();
						          grid.getStore().load(function() {
						              btn.setDisabled(false)
						          })
              	}
              },
            
            
            
//            My code @sanjeev ranjan
            
            'downloadApplicantLoaderForm customcombobox#applicantType': {
            	select:function(combo){
            		var form = combo.up('form');
            		var applicantType = combo.getValue();
//            		var applicantType = form.down("#applicantType").getValue();
            		var waitingList = form.down("#waitingList");
            		var Year =  form.down("#YearId").getValue();
            		var locationId =  form.down("#locationNameItemId").getValue();
        			var waitingListStore = waitingList.getStore();
					   
				   waitingListStore.getProxy().extraParams = {
					   	academicTerm:Year,
	  	      			hostelApplicationType:applicantType,
	  	      			locationId:locationId,
	  	          	};	
				   waitingListStore.load();
            	}
            },
            
            'downloadApplicantLoaderForm customcombobox#YearId': {
            	select:function(combo){
            		var form = combo.up('form');
            		var Year = combo.getValue();
            		
	           		var waitingList = form.down("#waitingList");
	           		var applicantType =  form.down("#applicantType").getValue();
	           		var locationId =  form.down("#locationNameItemId").getValue();
	       			var waitingListStore = waitingList.getStore();
						   
				   waitingListStore.getProxy().extraParams = {
					   	academicTerm:Year,
	  	      			hostelApplicationType:applicantType,
	  	      			locationId:locationId,
	  	          	};	
				   waitingListStore.load();
            	}
            },
            
            'downloadApplicantLoaderForm customcombobox#locationNameItemId': {
            	select: function(combo) {
            		var form = combo.up('form');
            		
            		var locationId = combo.getValue();
            		var Year =  form.down("#YearId").getValue()
            		
	           		var waitingList = form.down("#waitingList");
	           		var applicantType =  form.down("#applicantType").getValue();
	       			var waitingListStore = waitingList.getStore();
						   
				   waitingListStore.getProxy().extraParams = {
					   	academicTerm:Year,
	  	      			hostelApplicationType:applicantType,
	  	      			locationId:locationId,
	  	          	};	
				   waitingListStore.load();
            	}
            },
            
       	 'downloadApplicantLoaderForm button[itemId=searchButtonId]':{
			 click: this.getManageEntryDownload
    	  },
    	  
    	  'downloadApplicantLoaderForm button[itemId=resetButtonId]': {
          	click:function(combo){
          		var form = this.getDownloadApplicantLoaderForm();
          		var applicantType = form.down("#applicantType");
          		var waitingList = form.down("#waitingList");
          		var location = form.down("#locationNameItemId");
          		var year = form.down("#YearId");
          		
          		applicantType.reset();
          		waitingList.reset();
          		location.reset();
          		year.reset();
          		
          		var waitingListStore = waitingList.getStore();
        		
          		delete waitingListStore.getProxy().extraParams.locationId;
          		delete waitingListStore.getProxy().extraParams.academicTerm;
          		delete waitingListStore.getProxy().extraParams.hostelApplicationType;
        			waitingListStore.load();
          		
          	}
          },
          
          
//          upload code start from here
          
    	  'bulkresisdenceapplicantstatusupdate radiogroup[itemId=eventQuestionGroupBulkStatusUpdate]':{
    		  change: function(cb, nv, ov){
    			  var $this = this;
    			  var structure = $this.getContentPanel().getActiveTab();
    			  var uploadTemplateForm = this.getUploadApplicantLoaderForm();
    			  var downloadTemplateForm = this.getDownloadApplicantLoaderForm();
    			  var grid = structure.down('#bulkStatusUpdateGridId');
    			  if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
    				  uploadTemplateForm.hide();
    				  downloadTemplateForm.show();
    				  grid.hide();
    			  }else{
    				  var uploadField = uploadTemplateForm.down("#uploadFileField");
    				  uploadField.reset();
    				  downloadTemplateForm.hide();
    				  uploadTemplateForm.show();
    				  var combo = uploadTemplateForm.down("#moduleName");
		    		  combo.getStore().load({
		    			  callback: function(records, operation, success) {
		    				  for(var i in records){
		    					  if(records[i].data.value == "Bulk Hostel Applicant Status Update"){
		    						  combo.setValue(records[i].data.id);
		    						  combo.setReadOnly(true);
		    					  }
		    				  }
		    			  }
		    		  });
    				  grid.show();
    				  
    			  }
    			  var loaderDownloadForm = this.getDownloadApplicantLoaderForm();
	   	 			var loaderDownloadBtn = loaderDownloadForm.down('#searchButtonId');
	   	 			if(loaderDownloadForm.getForm().isValid()){
	   	 				loaderDownloadBtn.setDisabled(false);
	   	 			}else{
	   	 				loaderDownloadBtn.setDisabled(true);
	   	 			}
    		  }
    	  },
    	  
    	  
    	  
    	  'bulkstatusupdategrid button[itemId=btnForce]':{
    		  click: function(obj) {
    			  var grid = this.getBulkstatusupdategrid();
    			  if (grid.getSelectionModel().getCount() > 0) {
    				  if(grid.getSelectionModel().getCount() > 1){
    					  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
    				  }else{
    					  var this$ = this;
    					  var id = grid.getSelectionModel().selectionStart.data.id;
    					  console.log(id);
    					  var urlAppend="?jobName="+id;
    					  var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
    					  Ext.Ajax.request({
    						  url: submitURL,
    						  method: 'GET',
    						  success: function(response) {
    							  if(response.responseText==="JOB_STATUS_NOT_PENDING"){
    								  showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
    							  }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
    								  //console.log("Manual trigger hit");
    								  showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
    							  }else if(response.responseText==="SUCCESS"){
    								  //console.log("Manual trigger hit");
    								  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
    							  }
    						  }
    					  });
    				  }
    			  } else {
    				  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    			  }  
    		  }
    	  },
    	  
//    	  'uploadallocationloaderform radiogroup[itemId=eventQuestionGroupId]':{
// 			  render :function(obj){
//     			  var $this = this;
//     			  var form =obj.up('uploadallocationloaderform').getForm();
//     			  var combo = form.findField('applicableFor');
//     			  
//     			  combo.getStore().load({
//     				  callback: function(records, operation, success) {
//     					  for(var i in records){
//     						  combo.setValue(records[0].data.id);
//     					  }
//     				  }	   
//     			  });
//     			 var combo1 = form.findField('importUtilityMasterId');
//     			  combo1.getStore().load({
//     				  callback: function(records, operation, success) {
//     					  for(var i in records){
//     						  if(records[i].data.value=='Bulk Nomination Applicant' && obj.getValue()=='APPLICANT'){
//     							combo1.setValue(records[i].data.id);
//     						  }else  if(records[i].data.value=='Bulk Nomination Student' && obj.getValue()=='STUDENT'){
//     							combo1.setValue(records[i].data.id);
//     						  }
//     					  }
//     				  }	   
//     			  });
//     		  },
//     		 select:function(obj,record){
//   			  var $this = this;
//   			 var form =$this.getManagescholarshipuploadtemplateform();
//   			  var combo1 = form.down('#moduleName');
//   			  combo1.getStore().load({
//   				  callback: function(records, operation, success) {
//   					  for(var i in records){
//   						  if(records[i].data.value=='Bulk Nomination Applicant' && obj.getValue()=='APPLICANT'){
//   							combo1.setValue(records[i].data.id);
//   						  }else  if(records[i].data.value=='Bulk Nomination Student' && obj.getValue()=='STUDENT'){
//   							combo1.setValue(records[i].data.id);
//   						  }
//   					  }
//   				  }	   
//   			  });
//   			var grid = $this.getManagescholarshipuploadgrid();
//	      	   var store =  grid.getStore();
//	      	   this.resetPageSetting(store);
//	      	   var moduleName = null;
//	      	   if(obj.getValue()=='APPLICANT'){
//	      		 moduleName='Bulk Nomination Applicant';
//	      	   }else{
//	      		 moduleName='Bulk Nomination Student'
//	      	   }
//	      	   store.getProxy().extraParams = {
//	      		 moduleName:moduleName,
//	      		 uploadedBy:$this.getCurrentlyLoggedInUser().id
//	      	   };
//	      	   store.load();
//	         	}
//     		  },
    	  'uploadallocationloaderform':{
 			  render :function(form){
     			  var $this = this;
     			  form.down('#typeItemId').allowBlank = true;
 			  }
 		  },
    	  'uploadallocationloaderform radiogroup[itemId=eventQuestionGroupId]':{
    		  change :function(cb, nv, ov){ 
    			  var $this = this;
    			  var structure = $this.getContentPanel().getActiveTab();
    			  var uploadTemplateForm = this.getUploadallocationloaderform();
    			  var radioButton = uploadTemplateForm.down("#eventQuestionGroupId") ;
    			  var radioButtonValue = radioButton.lastValue.studentHostel;
    			  var downloadAllocationForm = this.getDownloadallocationloaderform();
    			  var combo = uploadTemplateForm.down("#moduleName");
//    			  var grid = structure.down('#bulkStatusUpdateGridId');
    			  if(radioButtonValue == 'forApplicantFormTemplate'){
    				  uploadTemplateForm.down('#typeItemId').setVisible(false);
    				  uploadTemplateForm.down('#typeItemId').allowBlank=true;
		    		  combo.getStore().load({
		    			  callback: function(records, operation, success) {
		    				  for(var i in records){
		    					  if(records[i].data.value == "Bulk Hostel Applicant Allocation"){
		    						  combo.setValue(records[i].data.id);
		    						  combo.setReadOnly(true);
		    					  }
		    				  }
		    			  }
		    		  });
    			  }
    			  else{
    				  uploadTemplateForm.down('#typeItemId').setVisible(true)
    				  combo.getStore().load({
		    			  callback: function(records, operation, success) {
		    				  for(var i in records){
		    					  if(records[i].data.value == "Bulk Hostel Student Allocation"){
		    						  combo.setValue(records[i].data.id);
		    						  combo.setReadOnly(true);
		    					  }
		    				  }
		    			  }
		    		  });
    				}
    			  
    			   var grid = $this.getBulkhostelallocationgrid();
 		      	   var store =  grid.getStore();
 		      	   this.resetPageSetting(store);
 		      	   var moduleName = null;
 		      	   if(radioButtonValue == 'forApplicantFormTemplate'){
 		      		 moduleName='Bulk Hostel Applicant Allocation';
 		      	   }else{
 		      		 moduleName='Bulk Hostel Student Allocation'
 		      	   }
 		      	   var val = uploadTemplateForm.down('#uploadgroupItemId').getValue();
 		      	   store.getProxy().extraParams = {
 		      		 moduleName:moduleName,
 		      		 uploadedBy:val.isUploadAll?'':$this.getCurrentlyLoggedInUser().id
 		      	   };
 		      	   store.load();
    			  
    			  }
    	  },
    	  
    	  'uploadallocationloaderform customcombobox[itemId=typeItemId]':{
    		  select: function(rowModel, record){
    			  var uploadTemplateForm = this.getUploadallocationloaderform();
    			  var combo = uploadTemplateForm.down("#moduleName");	  
    			  var templateName = uploadTemplateForm.getValues().type;
				 var moduleName = null;
				 var uploadmarksUploadOptionRadioGroup = uploadTemplateForm.down("#uploadmarksUploadOptionRadioGroupItemId");
				 var uploadgroup= uploadmarksUploadOptionRadioGroup.down("#uploadgroupItemId");
				 switch (templateName){
					 case 'WITHOUT_RESIDENCE_APPLICATION':
					 moduleName = 'Without Residence Application';
						 break;
					 case 'WITH_RESIDENCE_APPLICATION':
					 moduleName = 'Bulk Hostel Student Allocation';
						 break;
			 		default : null;
				 }
    			  
    			 
				  combo.getStore().load({
	    			  callback: function(records, operation, success) {
	    				  for(var i in records){
	    					  if(record[0].data.value=="WITHOUT_RESIDENCE_APPLICATION" && records[i].data.value == "Without Residence Application"){
	    						  combo.setValue(records[i].data.id);
	    						  combo.setReadOnly(true);
	    					  }else if(record[0].data.value=="WITH_RESIDENCE_APPLICATION" && records[i].data.value == "Bulk Hostel Student Allocation") {
	    						  combo.setValue(records[i].data.id);
	    						  combo.setReadOnly(true);
	    					  }
	    				  }
	    			  }
	    		  });
				  
				  var grid = this.getBulkhostelallocationgrid();
  				  var form = this.getUploadoptionradiogroup();
  				  var isUploadAllValue = uploadgroup.getValue();
  				 // var isUploadAll = form.items.items[0].getValue().isUploadAll;
  				  this.onChangeUploadOptionRadioGroup(isUploadAllValue.isUploadAll, grid,moduleName);
    		  }
    	  },
    	  
    	  'uploadApplicantLoaderForm button[itemId=markEntryUpload]':{
        		click:function(obj){
        			var $this=this;
    	        	var importWin=$this.getUploadApplicantLoaderForm();
    	        	var grdStore;
    	        	var grid = $this.getBulkstatusupdategrid();
    	        	var form=$this.getUploadApplicantLoaderForm();
    	        	var uploadCsv = form.down('#markEntryUpload');
    	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
    	        	$this.getHashOfFile(form);
  		        	setTimeout(function() {
  	    	        	form.getForm().submit({
  	    	        		method : 'POST',
  	    	        		url : submitUrl,
  	    	        		success : function(form, action){
  	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY') ,getCommonTranslation('SUCCESS'));
  	    	        			form.isValid();
  	    	    	        },
  	    	        		failure: function(form, action) {
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
  	    	    	        }
  	    	        	});
  		        	},1000);
    	        	
    	        	Ext.defer(function() {
    	        		var form =this.getUploadoptionradiogroup();
    	        		var isUploadAll = form.items.items[0].getValue().isUploadAll;
    	        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'Bulk Hostel Applicant Status Update');
    	        	}, 2000, this);
        		} 
        	  },
    	  
      	 'uploadApplicantLoaderForm button[itemId=resetBtn]':{
      		click:function(obj){
      			var $this=this;
  	        	var form=$this.getUploadApplicantLoaderForm();
  	        	var uploadFile = form.down("#uploadFileField");
  	        	
  	        	uploadFile.reset();
  	        	form.isValid();
      		}    
      	 },
      	 
      	 
      	 
	

	'bulkstatusupdategrid':{
		render : function(obj){
			var $this = this;
			var grid = $this.getBulkstatusupdategrid();
			var form =this.getUploadoptionradiogroup();
			var isUploadAll = form.items.items[0].getValue().isUploadAll;
			this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'Bulk Hostel Applicant Status Update');
		},
		cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
			if (e.target.tagName == 'A') {
				var fileType=null;
				if(cellIndex==1){
					fileType='successFile';
				}else if(cellIndex==6){
					fileType='errorFile';
				}else if(cellIndex==7){
					fileType='logFile';
				}
				var documentId = record.get("id");
				if (!isNullOrEmpty(documentId)) {
					this.getImportListDownloadFile(documentId,fileType);
				}
			}
		}
	},
    	  
            
//            end of my code 
	
//	new code for new tab 
	'bulkhostelallocation radiogroup[itemId=eventQuestionGroupBulkStatusUpdate]':{
		  change: function(cb, nv, ov){
			  var $this = this;
			  var structure = $this.getContentPanel().getActiveTab(); 
			  var uploadTemplateForm = this.getUploadallocationloaderform();
			  var downloadTemplateForm = this.getDownloadallocationloaderform();
			  var applicantType = downloadTemplateForm.down("#applicantType");
			  var waitingList = downloadTemplateForm.down("#waitingList");
			  var typeItem = downloadTemplateForm.down("#typeItemId");
			  var location = downloadTemplateForm.down("#locationItemId");
			  var year = downloadTemplateForm.down("#YearId");
			  var applicantYear = downloadTemplateForm.down("#applicantYear");
			  var applicantStatus =  downloadTemplateForm.down("#applicationStatusId");
			  var grid = structure.down('#bulkhostelallocationgridId');
			  var uploadRadioButton = uploadTemplateForm.down("#eventQuestionGroupId");
			  
			  if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
				  applicantType.reset();
				  applicantYear.reset();
				  applicantStatus.reset();
				  applicantStatus.setReadOnly(false)
				  year.reset();
				  waitingList.reset();
				  waitingList.setDisabled(false)
				  location.reset();
				  typeItem.reset();
				  uploadTemplateForm.hide();
				  downloadTemplateForm.show();
				  grid.hide();
			  }else{
				  var uploadField = uploadTemplateForm.down("#uploadFileField");
				  uploadField.reset();
				  downloadTemplateForm.hide();
				  uploadTemplateForm.show();
				  var combo = uploadTemplateForm.down("#moduleName");
	    		  combo.getStore().load({
	    			  callback: function(records, operation, success) {
	    				  for(var i in records){
	    					  if( uploadRadioButton.lastValue.studentHostel == "forApplicantFormTemplate" && records[i].data.value == "Bulk Hostel Applicant Allocation"){
	    						  combo.setValue(records[i].data.id);
	    						  combo.setReadOnly(true);
	    					  }
	    					  else if (uploadRadioButton.lastValue.studentHostel == "forStudentFormTemplate" &&  records[i].data.value == "Bulk Hostel Student Allocation"){
	    							  combo.setValue(records[i].data.id);
	    						     combo.setReadOnly(true);
	    					  }
	    				  }
	    			  }
	    		  });
				  grid.show();
				  
			  }
		  }
	  },
	  
//	  downloadAllocation
	  'downloadallocationloaderform':{
		  render:function(grid){
			  grid.down('#typeItemId').allowBlank = true;
			  grid.down('#applicantYear').allowBlank = true;
		  }
	  },
	  'downloadallocationloaderform customcombobox#typeItemId':{
		  select: function(rowModel, record){
			  var form = this.getDownloadallocationloaderform();
			  var applicationStatus = form.down('#applicationStatusId')
			  applicationStatus.setReadOnly(false)
			  var locationId = form.down('#locationItemId');
			  var listIdName = form.down('#listIdNameId');
			  listIdName.setDisabled(false)
			  locationId.allowBlank = true;
//			  var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
			  locationId.labelSeparator = '';
			  locationId.setFieldLabel(getCommonTranslation('LOCATION'));
			  if(record[0].data.value=="WITHOUT_RESIDENCE_APPLICATION") {
				  locationId.allowBlank = false;
				  listIdName.setDisabled(true)
				  var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
				  locationId.labelSeparator = '';
				  locationId.setFieldLabel(getCommonTranslation('LOCATION')+allowblankFalse);
				  applicationStatus.getStore().load({
					  callback: function(records, operation, success) {
						  for(var i in records){
							  if(records[i].data.id=='ALLOCATED'){
								  applicationStatus.setValue(records[i].data.id);
								  applicationStatus.setReadOnly(true)
							  }
						  }
					  }	   
				  });
			  }
		  }
	  },
	  'downloadallocationloaderform radiogroup[itemId=eventQuestionGroupId]':{
		  change :function(cb, nv, ov){ 
			  var downloadTemplateForm = this.getDownloadallocationloaderform();
			  var radioButton = downloadTemplateForm.down("#eventQuestionGroupId") ;
			  var radioButtonValue = radioButton.lastValue.studentHostel;
			  downloadTemplateForm.down('#typeItemId').reset()
			  downloadTemplateForm.down('#applicantType').reset()
			  downloadTemplateForm.down('#applicationStatusId').reset()
			  downloadTemplateForm.down('#YearId').reset()
			  downloadTemplateForm.down('#applicantYear').reset()
			  downloadTemplateForm.down('#locationItemId').reset()
			  downloadTemplateForm.down('#waitingList').reset()
			  downloadTemplateForm.down('#listIdNameId').reset()
			  downloadTemplateForm.down('#listIdNameId').setDisabled(false)
			  var waitingList = downloadTemplateForm.down('#waitingList')
			  var listIdName = downloadTemplateForm.down('#listIdNameId')
			  var listIdNameStore = listIdName.getStore()
	    		delete listIdNameStore.getProxy().extraParams.locationId;
	    		delete listIdNameStore.getProxy().extraParams.hostelApplicationType;
	    		delete listIdNameStore.getProxy().extraParams.academicTerm;
	    		delete listIdNameStore.getProxy().extraParams.academyLocationId;
	    		var waitingListStore = waitingList.getStore()
	    		delete waitingListStore.getProxy().extraParams.academyLocationId;
	    		delete waitingListStore.getProxy().extraParams.hostelApplicationType;
	    		delete waitingListStore.getProxy().extraParams.academicTerm;
	    		delete waitingListStore.getProxy().extraParams.locationId;
	    		
	    		waitingListStore.load();
	  			listIdNameStore.load()
	    		
			  if(radioButtonValue == 'APPLICANT'){
				  downloadTemplateForm.down('#typeItemId').setVisible(false)
				  downloadTemplateForm.down('#typeItemId').allowBlank = true;
				  downloadTemplateForm.down('#listIdNameId').setVisible(false)
				  downloadTemplateForm.down('#waitingList').setVisible(true)
				  downloadTemplateForm.down('#YearId').allowBlank = false
				  downloadTemplateForm.down('#YearId').setVisible(true)
				  downloadTemplateForm.down('#applicantYear').setVisible(false)
				  downloadTemplateForm.down('#applicantYear').allowBlank = true;
				  downloadTemplateForm.down('#hostelLevelItemId').setVisible(true);
			  }
			  else{
				  downloadTemplateForm.down('#typeItemId').setVisible(true)
				  downloadTemplateForm.down('#typeItemId').allowBlank = false;
				  downloadTemplateForm.down('#waitingList').setVisible(false)
				  downloadTemplateForm.down('#listIdNameId').setVisible(true)
				  downloadTemplateForm.down('#YearId').setVisible(false)
				  downloadTemplateForm.down('#YearId').allowBlank = true
				  downloadTemplateForm.down('#applicantYear').setVisible(true)
				  downloadTemplateForm.down('#applicantYear').allowBlank = false;
				  downloadTemplateForm.down('#hostelLevelItemId').setVisible(false);
				  downloadTemplateForm.down('#hostelLevelItemId').allowBlank = true;
				}			  
			  }
	  },
	  
	  'downloadallocationloaderform customcombobox#applicantYear': {
		  select: function(combo) {
		  this.waitingListStoreFun('applicantType','applicantYear','listIdNameId', 'locationItemId')
			
      	}
      },
      
      'downloadallocationloaderform customcombobox#YearId': {
    	  select: function(combo) {
        	 	  this.waitingListStoreFun('applicantType','YearId','waitingList','locationItemId')				  
        	}
        },
        
        'downloadallocationloaderform customcombobox#locationItemId': {
        	select: function(combo) {
        		var form = this.getDownloadallocationloaderform();
    			var radioButton = form.down("#eventQuestionGroupId") ;
    			var radioButtonValue = radioButton.lastValue.studentHostel;
    			if(radioButtonValue == 'APPLICANT'){
    				this.waitingListStoreFun('applicantType','YearId','waitingList','locationItemId')
    			}else {
    				this.waitingListStoreFun('applicantType','applicantYear','listIdNameId','locationItemId')
    			}			  
        	}
        },
	  
	  'downloadallocationloaderform customcombobox#applicantType': {
      	select:function(combo){
      		var form = this.getDownloadallocationloaderform();
			var radioButton = form.down("#eventQuestionGroupId") ;
			var radioButtonValue = radioButton.lastValue.studentHostel;
			if(radioButtonValue == 'APPLICANT'){
				this.waitingListStoreFun('applicantType','YearId','waitingList','locationItemId')
			}else {
				this.waitingListStoreFun('applicantType','applicantYear','listIdNameId','locationItemId')
			}
      		
      	}
      },
	  
//      'downloadallocationloaderform customcombobox#locationItemId': {
//      	select: function(combo) {
//      		var form = this.getDownloadallocationloaderform();
//      	    var location = form.down("#locationItemId").getValue();
//      		var waitingList = form.down("#waitingList");
//      		
//      		var waitingListStore = waitingList.getStore();
//      		
//      		waitingListStore.getProxy().extraParams = {
//      			academyLocationId: location
//          		};	
//      		
//      			waitingListStore.load();
//      	}
//      },
      
 	 'downloadallocationloaderform button[itemId=searchButtonId]':{
		 click: this.getBulkHostelAllocation
	  },
	  
	  'downloadallocationloaderform button[itemId=resetButtonId]': {
    	click:function(combo){
    		var form = this.getDownloadallocationloaderform();
    		var applicantType = form.down("#applicantType");
    		var waitingList = form.down("#waitingList");
    		var location = form.down("#locationItemId");
    		var hostelLevel = form.down("#hostelLevelItemId");
    		var year = form.down("#YearId");
    		var applicantStatus =  form.down("#applicationStatusId");
    		form.down('#typeItemId').reset()
    		form.down('#applicantYear').reset()
    		form.down('#listIdNameId').reset()
    		var listIdNameStore = form.down('#listIdNameId').getStore()
    		delete listIdNameStore.getProxy().extraParams.academyLocationId;
    		delete listIdNameStore.getProxy().extraParams.hostelApplicationType;
    		delete listIdNameStore.getProxy().extraParams.academicTerm;
    		delete listIdNameStore.getProxy().extraParams.locationId;
    		var waitingListStore = waitingList.getStore()
    		delete waitingListStore.getProxy().extraParams.locationId;
    		delete waitingListStore.getProxy().extraParams.academyLocationId;
    		delete waitingListStore.getProxy().extraParams.hostelApplicationType;
    		delete waitingListStore.getProxy().extraParams.academicTerm;
    		applicantType.reset();
    		waitingList.reset();
    		location.reset();
    		year.reset();
    		applicantStatus.reset();    		
  			hostelLevel.reset();
  			waitingListStore.load();
  			listIdNameStore.load()
    		
    	}
    },
    
      
//	  end of downloadAllocation
	  
//	  uploadHostelAllocation code 
    
    'uploadallocationloaderform button[itemId=resetBtn]':{
  		click:function(obj){
  			var $this=this;
	        	var form=$this.getUploadallocationloaderform();
	        	var uploadFile = form.down("#uploadFileField");
	        	form.down('#typeItemId').reset();
	        	var combo = form.down("#moduleName");
				  combo.getStore().load({
	    			  callback: function(records, operation, success) {
	    				  for(var i in records){
	    					  if(records[i].data.value == "Bulk Hostel Student Allocation") {
	    						  combo.setValue(records[i].data.id);
	    						  combo.setReadOnly(true);
	    					  }
	    				  }
	    			  }
	    		  });
				  form.isValid();
	        	uploadFile.reset();
	        	
  		}    
  	 },
  	 
  	'bulkhostelallocationgrid button[itemId=btnForce]':{
		  click: function(obj) {
			  var grid = this.getBulkhostelallocationgrid();
			  if (grid.getSelectionModel().getCount() > 0) {
				  if(grid.getSelectionModel().getCount() > 1){
					  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
				  }else{
					  var this$ = this;
					  var id = grid.getSelectionModel().selectionStart.data.id;
					  console.log(id);
					  var urlAppend="?jobName="+id;
					  var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
					  Ext.Ajax.request({
						  url: submitURL,
						  method: 'GET',
						  success: function(response) {
							  if(response.responseText==="JOB_STATUS_NOT_PENDING"){
								  showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
							  }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
								  //console.log("Manual trigger hit");
								  showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
							  }else if(response.responseText==="SUCCESS"){
								  //console.log("Manual trigger hit");
								  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
							  }
						  }
					  });
				  }
			  } else {
				  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			  }  
		  }
	  },
	  
	  'uploadallocationloaderform button[itemId=markEntryUpload]': {
  		click:function(obj){
  			var $this=this;
	        	var grid = $this.getBulkhostelallocationgrid();
	        	var uploadTemplateForm = this.getUploadallocationloaderform();
	        	var type = uploadTemplateForm.getValues().type;
	        	var form=$this.getUploadallocationloaderform();
	        	var radioButton = form.down("#eventQuestionGroupId");
        		var templateType = radioButton.lastValue.studentHostel;
	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	        	$this.getHashOfFile(form);
	        	setTimeout(function() {
  	        	form.getForm().submit({
  	        		method : 'POST',
  	        		url : submitUrl,
  	        		success : function(form, action){
  	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY') ,getCommonTranslation('SUCCESS'));
  	    	        },
  	        		failure: function(form, action) {
		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
  	    	        }
  	        	});
	        	},1000);
	        	
	        	var templateName;
  	        	if(templateType=='forApplicantFormTemplate' || templateType=='FORAPPLICANTFORMTEMPLATE'){
  	        		templateName='Bulk Hostel Applicant Allocation';
  	        	}else{
  	        	  switch (type){
					 case 'WITHOUT_RESIDENCE_APPLICATION':
						templateName = 'Without Residence Application';
						 break;
					 case 'WITH_RESIDENCE_APPLICATION':
						 templateName = 'Bulk Hostel Student Allocation';
						 break;
			 		default : null;
				  }
//  	        		templateName='Bulk Hostel Student Allocation';
  	        	}
	        	
	        	Ext.defer(function() {
	        		var form =this.getUploadoptionradiogroup();
	        		var isUploadAll = form.items.items[0].getValue().isUploadAll;
	        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, templateName);
	        	}, 2000, this);
  		}  
  	  
   },
  	 
   'uploadallocationloaderform uploadoptionradiogroup[itemId=uploadmarksUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
			change: function( radioGroup, newValue, oldValue, eOpts){
			var uploadForm=radioGroup.up('uploadallocationloaderform');
			var moduleName = uploadForm.down('#moduleName');
        	var grid = this.getBulkhostelallocationgrid();
        	  var moduleName = moduleName.lastSelection[0].raw.value;
		    var isUploadAll = newValue.isUploadAll;
		    this.onChangeUploadOptionRadioGroup(isUploadAll,grid,moduleName);
			}   
		},

  	 'bulkhostelallocationgrid':{
  		 render : function(obj){
  			 var $this = this;
  			 var grid = $this.getBulkhostelallocationgrid();
  			 var form =this.getUploadoptionradiogroup();
  			 var isUploadAll = form.items.items[0].getValue().isUploadAll;
  			 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'Bulk Hostel Applicant Allocation');
  		 },
  		 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
  			 if (e.target.tagName == 'A') {
  				 var fileType=null;
  				 if(cellIndex==1){
  					 fileType='successFile';
  				 }else if(cellIndex==6){
  					 fileType='errorFile';
  				 }else if(cellIndex==7){
  					 fileType='logFile';
  				 }
  				 var documentId = record.get("id");
  				 if (!isNullOrEmpty(documentId)) {
  					 this.getImportListDownloadFile(documentId,fileType);
  				 }
  			 }
  		 }
  	 },
    
    
    
//    end of upload code 
	
	
//	end of my code 
            
            'hostelstudentsearch combo#batchId': { 
            	select: function(combo, record) {
            		var hostelStudentSearchFilter = this.getHostelstudentsearch(),
            		batchId = combo.getValue();

            		var alinfomodel = Academia.model.authentication.ALInfoModel;
            		var wheatherSchool = alinfomodel.get('wheatherSchool');
            		if(batchId > 0){
            			var periodCombo = hostelStudentSearchFilter.down("#periodId");
            			periodCombo.setDisabled(false);
            			periodCombo.reset();
            			
            			if(wheatherSchool) {
            				periodCombo.setVisible(false);
                		}


            			var periodComboStore = periodCombo.getStore();
            			if(!isNullOrEmpty(batchId)){
            				periodComboStore.getProxy().extraParams = {
            					id: batchId
            				};	
            			}
            			periodComboStore.load({
            				callback: function(records, operation, success) {
            					if (success) {
            						if(records.length == 0){
            							if(wheatherSchool) {
            								showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
            							}
            						}
            						else if(records.length == 1){
            							if(wheatherSchool) {
            								periodCombo.setValue(records[0].data.id);
            								var section = hostelStudentSearchFilter.down("#sectionId");
            		            			section.setDisabled(false);
            		            			section.reset();
            		            			
            		            			var sectionComboStore = section.getStore();
            		                		if(!isNullOrEmpty(records[0].data.id)){
            		                			sectionComboStore.getProxy().extraParams = {
            		                				periodId: records[0].data.id
            		                    		};	
            		                		}
            		                		sectionComboStore.load();
            							}
            						} else {
            							periodCombo.setVisible(true);
            						}
            						var seatType = hostelStudentSearchFilter.down("#seatType"); 					   
                        			seatType.setDisabled(false);
                        			seatType.reset();

                        			var seatTypeStore = seatType.getStore();
                        			if(!isNullOrEmpty(batchId)){
                        				seatTypeStore.getProxy().extraParams = {
                        					batchId: batchId
                        				};	
                        			}
                        			seatTypeStore.load();
            					}
            				}
            			});
            		}
            	}
            },
            'hostelstudentsearch combo#periodId': {
            	select: function(combo) {
            		var hostelStudentSearchFilter = this.getHostelstudentsearch(),
            		periodId = combo.getValue();
            		
            		var sectionCombo = hostelStudentSearchFilter.down("#sectionId");
            		sectionCombo.setDisabled(false);
            		sectionCombo.reset();
            		
            		var sectionComboStore = sectionCombo.getStore();
            		if(!isNullOrEmpty(periodId)){
            			sectionComboStore.getProxy().extraParams = {
            				periodId: periodId
                		};	
            		}
            		sectionComboStore.load();
            	}
            },
            'hostelstudentsearch':{
            	render: function(searchPnl){
            		/*var alinfomodel = Academia.model.authentication.ALInfoModel;
            		var wheatherSchool = alinfomodel.get('wheatherSchool');
            		var academyLocationId = this.getCurrentAcademyLocation();
            		if(wheatherSchool) {
            			searchPnl.down('#academicTerm').setVisible(false);
            			searchPnl.down('#periodId').setVisible(false);
            			searchPnl.down('#seatType').setVisible(false);
            		}
            		this.setAcademyLocationDefault();*/
            	},
            	afterrender:function(searchPnl){
            		var applicantType = searchPnl.down('#applicantType');
            		var HstlApplicationsApplicantName = searchPnl.down('#HstlApplicationsApplicantName');
            		applicantType.getStore().load({
            			 callback: function(records, operation, success) {
            				 for(var i in records){
            					 if(records[i].data.name=='Student'){
            						 applicantType.setValue(records[i].data.value);
            					 }
            				 }
            			 }	   
            		 });
            		HstlApplicationsApplicantName.getStore().getProxy().extraParams={
     					academyLocationId:this.getCurrentAcademyLocation()
     				};
            		HstlApplicationsApplicantName.getStore().load();
            	}
            },
            'hostelstudentsearch button[itemId=searchButtonId]': {
            	click: this.searchHostelSearchForm
            },
            'hostelstudentsearch button[itemId=resetButtonId]': {
            	click: this.resetHostelSearchForm
            },
            'hostelapplicationsearch button[itemId=searchButtonId]': {
            	click: this.searchHostelApplicationSearchForm
            },
            'hostelapplicationsearch button[itemId=resetButtonId]': {
            	click: this.resetHostelApplicationSearchForm
            },
            'hostelstudentsearch combo#studentName': {
            	select: function(combo, record){
            		this.getProgramBatchPeriodByStudentId(combo);
            	}
            },
            'hostelapplicationlist button[itemId=btnAllotRoom]':{
				click:function(btn){
					this.allotRoomBtnClick(btn);
				}
			},
			'hostelapplicationlist  button[itemId=btnApplyRule]':{
				click:function(){
					this.applyRuleBtnClick();
				}
			},
			'hostelapplicationlist  button[itemId=btnRejectApplication]':{
				click:function(){
					this.rejectApplicationBtnClick();
				}
			},
			'hostelapplyrulewindow  button[itemId=applyRuleSubmitbtn]':{
				click:function(obj){
					this.submitApplyRuleForHostel(obj);
				}
			},
			'hostelapplyrulewindow  button[itemId=applyRuleCancelButton]':{
				click:function(obj){
 	        		obj.up('window').close();
     	        	}
			},
			'hostelrejectapplicationwindow  button[itemId=btnSaveRejectApplication]':{
				click:function(obj){
					this.saveRejectApplicationForHostel(obj);
					}
			},
			'hostelrejectapplicationwindow  button[itemId=btnCancelRejectApplication]':{
				click:function(obj){
 	        		obj.up('window').close();
     	        	}
			},
			'hostelapplicationsstructure' :  {
				afterrender : function(structure){
					var $this = this;
					structure.body.on('scroll', function(e, target) {
						var pcstructure = structure.down("hostelapplicationlist");
						var hostelapplicationslistgrid = structure.down("hostelapplicationslistgrid");
						var applicantStructure = structure.down("hostelapplicationapplicantlistgrid");
						var academyLocationId = $this.getCurrentAcademyLocation();
						var grid = null;

						if(!pcstructure.isHidden()){
							grid = pcstructure;
						}
						if(!applicantStructure.isHidden()){
							grid = applicantStructure;
						}
						if(!hostelapplicationslistgrid.isHidden()){
							grid = hostelapplicationslistgrid;
						}
						$this.getMultipleGridHeaderFreeze(grid,structure,true);
					});
				},
				beforerender : function(structure){
					var $this = this;
					this.showHideSectionTabs(structure, this.getHOSTEL_APPLICATION_PERMISSION());
					
	   	 		    Ext.Ajax.request({
						type: 'rest',
             			url: SERVERURL.HOSTEL_OPT_IN, 
             			method: 'GET',
             			async:false,
             			success: function(res, action) {
             				var response = JSON.parse(res.responseText);
             				$this.HostelResponse = JSON.parse(res.responseText);
//             				var structure = $this.getContentPanel().getActiveTab();
             				var hostelstudentsearch = structure.down('#hostelStudentSearchItemId');
             				var hostelapplicationlist  = structure.down("#hostelApplicationListItemId")
             				var hostelapplicationssearch  = structure.down("#hostelapplicationssearchItemId")
             				var hostelapplicationslistgrid  = structure.down("#hostelapplicationslistgridItemId")
             				if( response.length > 0 && (response[0].value == 'NO' || response[0].value == 'no' || response[0].value == 'No')){
             					var ALCombo = hostelstudentsearch.down('#academyLocationItemId');
             					if(!isNullOrEmpty(ALCombo)){
             						$this.setAllowBlank(ALCombo,true);	
             					}
             					$this.showStudentHostalGrid = true;
         						hostelstudentsearch.hide()
         						
         						hostelapplicationlist.hide()
         						hostelapplicationssearch.show()
         						hostelapplicationslistgrid.show()
         					}else {
         						$this.showStudentHostalGrid = false;
         						hostelapplicationssearch.hide()
         						hostelapplicationslistgrid.hide()
         						
         						hostelapplicationlist.show()
         						hostelstudentsearch.show()
         					}
             			}
					})
				}
			},
			
//			'hostelapplicationslistgrid  button[itemId=btnAllotRoom]':{
//				click: function(btn){
//			    	var grid = this.getHostelapplicationslistgrid();
//			    	var contentpanel = this.getContentPanel();
//			    	if (grid.getSelectionModel().getCount() > 0) {
//			    		var roomAllocationStructureController = Academia.app.getController('Academia.view.hostel.roomallocation.userwise.UserWiseSearch');
//			    		var hostelRoomAllocation = Ext.widget('userwisesearch');
////			    		var records = grid.getSelectionModel().getSelection()[0]; 
////			    		var studentId = records.get('studentId');
//			    		var tabName = getMegaMenuTranslation('ROOM_ALLOCATION');
////			    		var getcontroller = this.getController('menu.CoreERPNavigationController');
////			    		var getAddTab = getcontroller.getTab(getMegaMenuTranslation('ROOM_ALLOCATION'));
//			    		if (getAddTab != null) {
//			    			contentPanel.remove(getAddTab, true);
//			    		}
//			    		openTab(contentpanel, tabName, hostelRoomAllocation, CONSTANTS.MENU_COLOR_TWELVE);
//
////			    		if(!isNullOrEmpty(studentId)){
////			    			var studentName = hostelRoomAllocation.down('userwisesearch').down('#studentName');
////			    			var feePlan = hostelRoomAllocation.down('userwisesearch').down('#hostelFeePlanName');
////			    			var feePlanRule = hostelRoomAllocation.down('userwisesearch').down('#hostelFeeRule');
////			    			var feePlanAmount = hostelRoomAllocation.down('userwisesearch').down('#hostelFeeTotalAmount');
////			    			var store = studentName.getStore();
////			    			studentName.config.isAllotRoom = true;
////							store.getProxy().extraParams = {
////								userType: 3, 		//userType = 3(Student)
////								codeOrName:records.data.studentCode
////							};
////							store.load({
////								callback:function(){
////									studentName.setValue(studentId);
////									feePlan.setValue(records.get('feeplan'));
////									feePlanRule.setValue(records.get('feeplanRule'));
////									feePlanAmount.setValue(records.get('totalAmount'));
////									
////								}
////							});
////			    		}
////			    	}else{
////						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
////					}
//			    }
//			},
		
			
			
    			   'hostelfeedetailwin button[itemId=hostelFeeDetailButton]':{
    				   
    				   click: function(obj){
    					   $this=this;
    					   var formWindow = $this.getHostelfeedetailwin();
    						if (!formWindow) {
    							formWindow=	Ext.widget('hostelfeedetailwin');
    							//formWindow = $this.getHosteldocumentgriddetailswin();
    						}
    						formWindow.close();    					   
    				   }
    			   },
    			  /* 'hostelapplicationapplicantlistgrid':{
    					render:function(grid){
    						this.doAccessControlValidation(grid, this.getHOSTEL_APPLICATION_PERMISSION());
    						this.doAccessControlCustomBtnValidation(grid, this.getHOSTEL_APPLICATION_PERMISSION());
    					},
    			   },*/
    			   'hostelstudentsearch combo#applicantType': {
    				   select:function(combo){
    					   var applicantGrid = this.getHostelapplicationapplicantlistgrid();
    					   var studentGrid = this.getHostelapplicationlist();
    					   var filter = combo.up('form');
    					   var studentName = filter.down('#studentName');
    					   var HstlApplicationsApplicantName = filter.down('#HstlApplicationsApplicantName');
    					   var programGroup = filter.down('#programGroupId');
    					   var intakeYear = filter.down('#intakeYear');
    					   var academicTerm = filter.down('#academicTerm');
    					   var programId = filter.down('#programId');
    					   var applicantType = combo.getValue();
    					   if(applicantType=='APPLICANT'){
    						   studentName.setVisible(false);
    						   HstlApplicationsApplicantName.setVisible(true);
    						   studentGrid.hide();
    						   applicantGrid.show();
    						   programGroup.setDisabled(true);
    						   intakeYear.setDisabled(true);
    						   academicTerm.setDisabled(true);
    						   programId.setDisabled(true);
    					   }else{
    						   HstlApplicationsApplicantName.setVisible(false);
    						   studentName.setVisible(true);
    						   applicantGrid.hide();
    						   studentGrid.show();
    						   programGroup.setDisabled(false);
    						   intakeYear.setDisabled(false);
    						   academicTerm.setDisabled(false);
    						   programId.setDisabled(false);
    					   }
    				   }
    			   },
    			   'hostelapplicationsearch combo#applicantType': {
    				   select:function(combo){
    					   var filter = combo.up('form');
    					   var applicantType = combo.getValue();
    					   var locationDropDown = filter.down("#locationItemId");
    					   var alDropDown = filter.down("#academyLocationItemId");
    					   var waitingList = filter.down("#hstlWaitingList");
    					   var Year =  filter.down("#hstlYear").getValue();
    					   
    					   if(applicantType=='HOSTEL_GENERAL_SETUP'){
   		   	 		    		locationDropDown.setDisabled(false);
   		   	 		    		alDropDown.setDisabled(false);
//   		   	 		    		waitingList.setDisabled(true);
   		   	 		    		var store= alDropDown.getStore();
   		   	 		    	    delete store.getProxy().extraParams.locationId;
   		   	 		    	    locationDropDown.getStore().load();
		   	 		    	    alDropDown.getStore().load();
    					   }else{
    						   locationDropDown.reset()
    						    locationDropDown.setDisabled(true);
    						   alDropDown.reset();
  		   	 		    		alDropDown.setDisabled(true);
    					   }
    					   var locationId =  filter.down("#locationItemId").getValue();
   	            		   var academyLocationId =  filter.down("#academyLocationItemId").getValue();
    					   
    	        			var waitingListStore = waitingList.getStore();
    						   
    					   waitingListStore.getProxy().extraParams = {
    						   	academicTerm:Year,
    		  	      			hostelApplicationType:applicantType,
    		  	      			locationId:locationId,
    		  	      			academyLocationId:academyLocationId
    		  	          	};	
    					   waitingListStore.load();
    				   }
    			   },
    			   
    			   'hostelapplicationsearch combo#hstlYear': {
    				   select:function(combo){
    					   var filter = combo.up('form');
    					   var Year = combo.getValue();
    					   var waitingList = filter.down("#hstlWaitingList");
    					   var applicantType =  filter.down("#applicantType").getValue();
					   	   
					   	   var locationId =  filter.down("#locationItemId").getValue();
	            		   var academyLocationId =  filter.down("#academyLocationItemId").getValue();
	            		   var waitingListStore = waitingList.getStore();
						   
						   waitingListStore.getProxy().extraParams = {
							   	academicTerm:Year,
			  	      			hostelApplicationType:applicantType,
			  	      			locationId:locationId,
			  	      			academyLocationId:academyLocationId
			  	          	};	
						   waitingListStore.load();
    				   }
    			   },
    			   
    			   'hostelapplicationsearch combo#locationItemId': {
    				   select:function(combo){
    		            		var hostelApplicationSearchFilter = this.getHostelapplicationsearch(),
    		            		academyLocationId = hostelApplicationSearchFilter.down('#academyLocationItemId').getValue(),
    		            		locationId = hostelApplicationSearchFilter.down('#locationItemId').getValue();
    		            		var hostelCode= hostelApplicationSearchFilter.down('#hstlApplicationsHostelCode');
    		            		var hostelApplicationName= hostelApplicationSearchFilter.down('#hstlApplicationsApplicantName');
    		            		var academyLocation = hostelApplicationSearchFilter.down('#academyLocationItemId');
    		            		var alStore= academyLocation.getStore();
    		            		alStore.removeAll();
    		            		hostelApplicationName.reset();
    		            		hostelCode.reset();
    		            		var store = hostelCode.getStore();
    		            		delete store.getProxy().extraParams.academyLocationId;
    		            		if(!isNullOrEmpty(academyLocationId)){
    		            			store.getProxy().extraParams.academyLocationId= academyLocationId;
    		            		}
    		            		if(!isNullOrEmpty(locationId)){
    		            			store.getProxy().extraParams.locationId=locationId;
    		            			alStore.getProxy().extraParams.locationId=locationId;
    		            		}
    		            		alStore.load();
    		            		
		            		   var waitingList = hostelApplicationSearchFilter.down("#hstlWaitingList");
		            		   var Year = hostelApplicationSearchFilter.down("#hstlYear").getValue();
	    					   var applicantType =  hostelApplicationSearchFilter.down("#applicantType").getValue();
		            		   var waitingListStore = waitingList.getStore();
							   
							   waitingListStore.getProxy().extraParams = {
								   academicTerm:Year,
				  	      			hostelApplicationType:applicantType,
				  	      			locationId:locationId,
				  	      			academyLocationId:academyLocationId
				  	          	};	
							   waitingListStore.load();
    				   }
    			   },
    			   'hostelapplicationsearch combo#academyLocationItemId': {
    				   select:function(combo){
    		            		var hostelApplicationSearchFilter = this.getHostelapplicationsearch(),
    		            		academyLocationId = hostelApplicationSearchFilter.down('#academyLocationItemId').getValue();
    		            		var locationId = hostelApplicationSearchFilter.down('#locationItemId').getValue();
    		            		var hostelCode= hostelApplicationSearchFilter.down('#hstlApplicationsHostelCode');
    		            		var hostelApplicationName= hostelApplicationSearchFilter.down('#hstlApplicationsApplicantName');
    		            		hostelApplicationName.reset();
    		            		hostelCode.reset();
    		            		var store = hostelCode.getStore();
    		            		delete store.getProxy().extraParams.locationId;
    		            		if(!isNullOrEmpty(academyLocationId)){
    		            			store.getProxy().extraParams.academyLocationId= academyLocationId;
    		            		}
    		            		if(!isNullOrEmpty(locationId)){
    		            			store.getProxy().extraParams.locationId=locationId;
    		            		}
    		            		
    		            		var waitingList = hostelApplicationSearchFilter.down("#hstlWaitingList");
	    					   var applicantType =  hostelApplicationSearchFilter.down("#applicantType").getValue();
						   	   var waitingListStore = waitingList.getStore();
    						   	var Year = hostelApplicationSearchFilter.down("#hstlYear").getValue();
							   
							   waitingListStore.getProxy().extraParams = {
								   academicTerm:Year,
				  	      			hostelApplicationType:applicantType,
				  	      			locationId:locationId,
				  	      			academyLocationId:academyLocationId
				  	          	};	
							   waitingListStore.load();
    		            		
    				   }
    			   },
    			   'generalhostelapplicantwindow':{
    				 afterrender: function(win){
    					 var me = this;
    					 var grid = win.down('grid');
    					 var store = grid.getStore();
						  store.getProxy().extraParams = {
							  hostelRequirementId: win.applicantHostelRequiredId
    					  };
    					  store.load();
    				 }  
    			   },
    			   'hostelapplicationapplicantlistgrid[itemId=hostelapplicationapplicantlistgridItemId]':{
    					render:function(grid){
    						this.doAccessControlValidation(grid, this.getHOSTEL_APPLICATION_PERMISSION());
    						this.doAccessControlCustomHosteApplication(grid, this.getHOSTEL_APPLICATION_PERMISSION());
    					},
    					cellclick: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    						var $this = this;
    						var columnName = view.getGridColumns()[cellIndex].dataIndex;
    						if(columnName == 'hostelPreferenceChoices') {
    							if(e.target.tagName=='A'){

									var docWindow = $this.getGeneralhostelapplicantwindow();
									
	             					 
	             						var formWindow = $this.getGeneralhostelapplicantwindow();
	             				    	if (!formWindow) {
	             				    		formWindow = Ext.widget('generalhostelapplicantwindow',{
	             				    			applicantHostelRequiredId: record.data.applicantHostelRequiredId
	             				    		});
	             				    	}
	             				    	formWindow.show();
	             				    	 
		             					  	
								
    							}
    						}
    						},
    					afterrender:function(grid){
    	    				var me = this;
    	    				setTimeout(function(){
    	    					me.addDataGridConfigButton(grid,me.getHOSTEL_APPLICATION_APPLICANT_GRID_PERMISSION());
    	    				},1500);

    	    			},
    	    			selectionchange:function(cmp, selected){
    	    				
    	    					var me = this,
    	    					gridApplication = this.getHostelapplicationapplicantlistgrid(),
    	    					acceptOfferLetterBtn = gridApplication.down("#acceptOfferLetter"),
    	    					sendOfferLetterBtn = gridApplication.down("#sendOfferLetter"),
    	    					cancelOfferLetterBtn = gridApplication.down("#cancelOfferLetter"),
    	    					allocatedApplicationHostelBtn = gridApplication.down("#allocatedApplicationHostel"),
    	    					cancelApplicationHostelBtn = gridApplication.down("#cancelApplicationHostel"),
    	    					btnRejectApplication = gridApplication.down("#btnRejectApplication"),
    	    					allocatedApplicationHostelBtn = gridApplication.down("#allocatedApplicationHostel"),
    	    					checkData = false;
    	    					if(selected.length){
    	    						var $this=this;
    	    						var records = gridApplication.getSelectionModel().getSelection();
    	    						var associatedAcadLocationIds = new Array();
    	    						associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	    						var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getHOSTEL_APPLICATION_PERMISSION());
    	    						var IsAllotRoom = false;
    	    						var applyRuled =false;
    	    						var isRejected =false;
    	    						var isRejectedApp =false;
    	    						Ext.each(permissionList, function(privilege) {
    	    							if (privilege === 'ALLOTEROOM') {
    	    								IsAllotRoom=true;
    	    							}
    	    							if (privilege === 'APPLY_RULE') {
    	    								applyRuled=true;
    	    							}
    	    							if (privilege === 'REJECTAPPLICATION') {
    	    								isRejectedApp=true;
    	    							}
    	    						});

    	    						selected.forEach(function(rec){
    	    							if(rec.data.applicationStatus !== "OFFER_LETTER_ISSUED"){
    	    								checkData=true;
    	    							}
    	    						});
    	    						acceptOfferLetterBtn.setDisabled(checkData);
    	    						cancelOfferLetterBtn.setDisabled(checkData);
    	    						checkData = false;
    	    						selected.forEach(function(rec){
    	    							if(rec.data.applicationStatus !== "ALLOCATED"){
    	    								checkData=true;
    	    							}
    	    						});
    	    						cancelApplicationHostelBtn.setDisabled(checkData);
    	    						checkData = false;
    	    						selected.forEach(function(rec){
    	    							if(rec.data.applicationStatus !== "SUBMITTED" && rec.data.applicationStatus !== "OFFER_LETTER_ISSUED" 
    	    								&& rec.data.applicationStatus !== "OFFER_LETTER_ACCEPTED"){
    	    								checkData=true;
    	    							}
    	    						});
    	    						btnRejectApplication.setDisabled(checkData);
    	    						if(selected.length == 1){
    	    							var rec =selected[0];
    	    							if(rec.data.applicationStatus !== "SUBMITTED" && rec.data.applicationStatus !== "OFFER_LETTER_ACCEPTED"){
    	    	    						allocatedApplicationHostelBtn.setDisabled(true);
    	    							}else{
    	    								allocatedApplicationHostelBtn.setDisabled(false);
    	    							}
    	    							if(rec.data.applicationStatus == "SUBMITTED" || rec.data.applicationStatus == "OFFER_LETTER_DECLINED" || rec.data.applicationStatus == "OFFER_LETTER_REVOKED" || rec.data.applicationStatus == "OFFER_LETTER_EXPIRED"){
    	    								sendOfferLetterBtn.setDisabled(false);
    	    							}else{
    	    								sendOfferLetterBtn.setDisabled(true);
    	    							}

    	    						}else{
    	    							sendOfferLetterBtn.setDisabled(true);
    	    							allocatedApplicationHostelBtn.setDisabled(true);
    	    						}
    	    					}else{
    	    					allocatedApplicationHostelBtn.setDisabled(true);
    	    					cancelApplicationHostelBtn.setDisabled(true);
    	    					btnRejectApplication.setDisabled(true);
    	    					acceptOfferLetterBtn.setDisabled(true);
    	    					cancelOfferLetterBtn.setDisabled(true);
    	    					sendOfferLetterBtn.setDisabled(true);
    	    				}
    	    			}
    				},
    				
    				 'hostelapplicationapplicantlistgrid button[itemId=btnAllotRoom]':{
    						click:function(btn){
    							//this.allotRoomApplicantGridBtnClick(btn);
    						}
    					},
    					'hostelapplicationapplicantlistgrid  button[itemId=btnApplyRule]':{
    						click:function(){
    							//this.applyRuleApplicantGridBtnClick();
    						}
    					},
    					'hostelapplicationapplicantlistgrid  button[itemId=btnRejectApplication]':{
    						click:function(){
    							//this.rejectApplicationApplicantGridBtnClick();
    						}
    					},
    					'hostelappstdsearchstructure radiogroup[itemId=importHostelApplicantFormRadioGroupItemId]': {
    		   	 		    change: this.applicantStudentFormChangeHostelAllocation
    		   	 		},
    					'hostelappstdsearchstructure': {
    						render: function(obj){
    							
    						},
    		   	 		    afterrender: function(cmp){
    		   	 		    	var me = this;
    		   	 		    	Ext.defer(function(){
	    		   	 		    	me.getHostelapplicationsearch().setVisible(true);
	    		   	 		    	me.getHostelapplicationsearch().setVisible(false);
//	    		   	 		    	var waitingList = me.getHostelapplicationsearch().down("#hstlWaitingList");
//	    		   	 		    	waitingList.setDisabled(true);
	    		   	 		    	var locationDropDown = me.getHostelapplicationsearch().down("#locationItemId");
	    		   	 		    	locationDropDown.setDisabled(true);
	    		   	 		    	var alDropDown = me.getHostelapplicationsearch().down("#academyLocationItemId");
	    		   	 		    	alDropDown.setDisabled(true);
	    		   	 		    	var searchButton = me.getHostelapplicationsearch().down("#searchButtonId");
	    		   	 		    	searchButton.setDisabled(false);
    		   	 		    	},1000);
    		   	 		    	
    		   	 		    }
    		   	 		 },
    		   	 		 
    		   	 		 
    		   	 	
    		   	 		'hostelapplicationslistgrid[itemId=hostelapplicationslistgridItemId]':{
        					render:function(grid){
        						this.doAccessControlValidation(grid, this.getRESIDENCE_APPLICATIONS_GRID_PERMISSION());
        						grid.down('#btnAllotRoom').setVisible(true)
        						grid.down('#btnRejectApplication').setVisible(true)
        						grid.down('#spBtnMoreActions').setVisible(true)
//        						this.doAccessControlCustomBtnValidation(grid, this.getRESIDENCE_APPLICATIONS_GRID_PERMISSION());
        					},
        			    	
        					afterrender:function(grid){
        	    				var me = this;
        	    				setTimeout(function(){
        	    					me.addDataGridConfigButton(grid,me.getRESIDENCE_APPLICATIONS_GRID_PERMISSION());
        	    				},1500);
        	    				grid.getStore().load();
        	    			},
        	    			cellclick: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        						var this$ = this;
        						var columnName = view.getGridColumns()[cellIndex].dataIndex;
        						studentDetails=record;
        						var portalInfo = Academia.model.authentication.StudentERPInfoModel;
        						var grid = this.getHostelapplicationlist();
        						var grid2 = this.getHostelapplicationslistgrid();
        						var allotButton = grid2.down('#btnAllotRoom');
        						
        						Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
        					    var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
        						var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
        						if (grid.getSelectionModel().getCount() > 0) {
        							localStorage.setItem('PROGRAM_ID',record.data.PROGRAM_ID);
        							if(grid.getSelectionModel().getCount() > 1) {
        							} else {
        							}
        						}
        						if (columnName == "studentCode") {
        							var tabTitle = record.get('studentCode');
        							var personId = record.get('studentId');
        							var userId = record.get('studentId');
        							//var admissionId = record.get('ADMISSION_ID');
        							//var programBatchSeatTypeConfigId = record.get('PROGRAM_BATCH_SEAT_CONFIG_ID');
        							Ext.Ajax.request({
        								type: 'rest',
        								url: SERVERURL.BATCH_ID_BY_STUDENT_ID+'?studentId='+userId,
        								method: 'GET',
        								async: false,
        								success: function(res, action) {
        									var data = Ext.decode(res.responseText);
        									portalInfo.set('admissionDetails',data[0].admissionDetails);
        									portalInfo.set('student',data[0].student);
        									portalInfo.set('userAacademyLocations',data[0].userAacademyLocations);
        									portalInfo.set('programBatchDetails',data[0].programBatchDetails);
        									portalInfo.set('pastProgramBatchDetails',data[0].pastProgramBatchDetails);
        								}
        							});
        							personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, null, null);
        							personController.addContentPanelTab(tabTitle, 'pendingbillsgrid', userId, personId, null, null, null);
        							/*var studentProfile = studentListController.getTabReferenceByTabTitle(tabTitle);
        							var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');
        							if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
        								var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
        								studentListController.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);        	
        							}*/
        						}
        					},
        					selectionchange: function(column, selected,eOpts ){
        						var $this = this;
        						var grid2 = this.getHostelapplicationslistgrid();
        						var allotButton = grid2.down('#btnAllotRoom');
        						var btnRejectApplication = grid2.down('#btnRejectApplication');
        	                    var grid = column.view.up('grid');
        	                    grid.down('#unallocateResidence').setVisible(true);
        	                    if(selected.length > 0) {
        	                    	for(var i=0;i<selected.length;i++) {
        	                    		if(selected[i].data.applicationStatus == "ALLOCATED") {
        	                    			grid.down('#unallocateResidence').setVisible(true);
        	                    		}else {
        	                    			grid.down('#unallocateResidence').setVisible(false);
        	                    		}
        	                    	}
        	                    }
        	                    if(($this.HostelResponse[0].value == 'no' || $this.HostelResponse[0].value == 'NO' || $this.HostelResponse[0].value == 'No' || $this.HostelResponse[0].value == 'nO') && grid2.getSelectionModel().getCount() == 1 && selected[0].data.applicationStatus == "ALLOCATED"){
        							allotButton.setDisabled(false);
        						}
        						else{
        							allotButton.setDisabled(true);
        						}
        	                    if(($this.HostelResponse[0].value == 'no' || $this.HostelResponse[0].value == 'NO' || $this.HostelResponse[0].value == 'No' || $this.HostelResponse[0].value == 'nO') && selected.length == 0){
        	                    	allotButton.setDisabled(true);
        	                    }
        	                    //for Reject Application Button visibility
        	                    var btnRejectVisibility=0;
        	                    if(selected.length > 0) {
        	                    	for(var i=0;i<selected.length;i++) {
        	                    		if(selected[i].data.applicationStatus != "SUBMITTED" && selected[i].data.applicationStatus != "UNALLOCATED") {
        	                    			btnRejectVisibility=1
        	                    		}
        	                    	}
        	                    }
        	                    if(btnRejectVisibility==1){
        	                    	grid2.down('#btnRejectApplication').setDisabled(true);
        	                    }else{
        	                    	grid2.down('#btnRejectApplication').setDisabled(false);
        	                    }
        	                    if(selected.length==1 && btnRejectVisibility==0) {
        	                    	grid2.down('#allocateResidence').setDisabled(false);
        	                    } else {
        	                    	grid2.down('#allocateResidence').setDisabled(true);
        	                    }
        	      			},
    		   	 		},
    		   	 		'hostelapplicationslistgrid button[itemId=btnRejectApplication]':{
    		   	 			click: function(){
    		   	 				var $this = this;
    		   	 				var grid2 = $this.getHostelapplicationslistgrid();
    		   	 				if (grid2.getSelectionModel().getCount() > 0) {

    		   	 					var markasunsuccessfulpopupWin = this.getMarkasunsuccessfulpopup();
    		   	 					if (!markasunsuccessfulpopupWin) {
    		   	 						Ext.widget('markasunsuccessfulpopup');
    		   	 						markasunsuccessfulpopupWin = this.getMarkasunsuccessfulpopup();
    		   	 					}
    		   	 					markasunsuccessfulpopupWin.show();
    		   	 				}else{
    		   	 					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    		   	 				}
    		   	 			}
    		   	 		},
    		   	 	'markasunsuccessfulpopup button[itemId=CancelBtnMarkAsUnsuccessfulPopUp]':{
    	        		click:function(obj){
    	        			var window = obj.up('window');
    	        			window.close();
    	        		}
    	        	},
    	        	'markasunsuccessfulpopup button[itemId=SubmitBtnMarkAsUnsuccessfulPopUp]':{
    	        		click:function(obj){
    	        			var $this = this;
    	        			var window = this.getMarkasunsuccessfulpopup();
    	        			var grid = $this.getHostelapplicationslistgrid();
    	        			var cancelledBy = window.down('#cancelledBy').getValue();
    	        			var cancellationReason = window.down('#cancellationReason').getValue();
    	        			var studentHostelApplicationIds =null;
    	        			 if (grid.getSelectionModel().getCount() > 0) {
		   	                      var records = grid.getSelectionModel().getSelection();
		   	                      var empIds=[];
		   	                      if(!isNullOrEmpty(records) && records.length > 0) {
		   	                    	  for( var i=0; i<records.length; i++ ) {
		   	                    		  if(!isNullOrEmpty(records[i].data.id)){
		   	                    			empIds.push(records[i].data.id);
		   	                    		  }
		   	                    	  }
		   	                      }
		   	                   studentHostelApplicationIds = empIds.join(',');
    	        			 }
    	        			
    	        			
    	        			var json;
    	        			var url;

    	        			if(!isNullOrEmpty(studentHostelApplicationIds)){
    	        				json = {
    	        						"studentHostelApplicationIds":studentHostelApplicationIds,
    	        						"cancelledById":cancelledBy,
    	        						"cancellationReason":cancellationReason,
    	        				};
    	        				submitUrl=SERVERURL.PATH_FIND_HOSTEL_REJECT_APPLICATION_STUDENTS;
    	        			}
    	        			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	        			var formData = Ext.encode(json);
    	        			Ext.Ajax.request({
    	        				type : 'rest',
    	        				url : submitUrl,
    	        				jsonData : formData,
    	        				method : 'POST',
    	        				success : function(frm, action) {
    	        					Ext.getBody().unmask(); 
    	        					var response = frm.responseText;
    	        					window.close();
    	        					if(!isNullOrEmpty(response)){
    	        						showSuccessMessage(getCommonTranslation('HOSTEL_APPLICATION'), getCommonTranslation('HOSTEL_APPLICATION_HAS_BEEN_SUCCESSFULLY_CANCELLED'));
    	        					}
    	        					$this.getHostelapplicationssearch().getForm().reset();
    	        					grid.getSelectionModel().deselectAll();
    	        					delete grid.getStore().proxy.extraParams.academicTermId;
    	        					delete grid.getStore().proxy.extraParams.applicationStatus;
    	        					delete grid.getStore().proxy.extraParams.hostelId;
    	        					delete grid.getStore().proxy.extraParams.hostelSetupType;
    	        					delete grid.getStore().proxy.extraParams.intakeId;
    	        					delete grid.getStore().proxy.extraParams.intakeYearId;
    	        					delete grid.getStore().proxy.extraParams.locationId;
    	        					delete grid.getStore().proxy.extraParams.programGroupId;
    	        					delete grid.getStore().proxy.extraParams.programId;
    	        					delete grid.getStore().proxy.extraParams.seatTypeId;
    	        					delete grid.getStore().proxy.extraParams.studentId;
    	        					delete grid.getStore().proxy.extraParams.waitingListName;
    	        					grid.getStore().load();
    	        				}
    	        			});
    	        		}
    	        	},
    		   	 		
    		   	 	'hostelapplicationslistgrid button[itemId=btnAllotRoom]':{
    		   	 	 click: function(){
    		   	 		var $this = this;
    		   	 		   if($this.HostelResponse[0].value == 'no' || $this.HostelResponse[0].value == 'NO' || $this.HostelResponse[0].value == 'No' || $this.HostelResponse[0].value == 'nO')
    		   	 		   {
    		   	 			   
    		   	 			var contentpanel = this.getContentPanel();
    		   	    		var roomAllocationStructureController = Academia.app.getController('Academia.controller.hostel.roomallocation.RoomAllocationStructureController');
    		   	    		var hostelRoomAllocation = Ext.widget('hostelroomallocationstructure');
    		   	    		var tabName = getMegaMenuTranslation('ROOM_ALLOCATION');
    		   	    		var getcontroller = this.getController('menu.CoreERPNavigationController');
    		   	    		var grid = this.getHostelapplicationslistgrid();
    		   	    		var selectedGrid = grid.getSelectionModel();
    		   	    		
    		   	    		openTab(contentpanel, tabName, hostelRoomAllocation, CONSTANTS.MENU_COLOR_TWELVE);
    		   	    		
    		   	    		var form = this.getUserwisesearch();
    		   	    		var studentNameDefault = form.down('#studentName');
    		   	    		var studentName = form.down('#studentNameNo');
    		   	    		var studentNameStore = form.down('#studentNameNo').getStore();
    						var hostelStore = form.down("#hostelCodeNo").getStore();
                            var hostel = form.down("#hostelCodeNo");
                            var buildingCodeName  = form.down('#buildingCodeName');
    						var buildingCodeStore =  buildingCodeName.getStore();
//    		    			var userType  = hostelRoomAllocation.down('userwisesearch').down('#userType');
    		   	    		
    		   	    		studentNameStore.getProxy().extraParams = {
    							studentId: selectedGrid.lastSelected.data.studentId
    						};
    		   	    		
    		   	    		studentNameStore.load({
                                callback: function(records, operation, success) {
                                    if (success) {
                                            	studentName.setValue(selectedGrid.lastSelected.data.studentId);
                                    }
                                }
                            });
    		   	    		
    						
    		   	    		hostelStore.getProxy().extraParams = {
    							studentId: selectedGrid.lastSelected.data.studentId
    						};
    		   	    		hostelStore.load({
    							 callback: function(records, operation, success) {
    								   if (success) {
    									   if(records.length > 0){
    										   hostel.setValue(records[0].data.id);
    										   
    										   buildingCodeStore.getProxy().extraParams = {
    												hostelCode:records[0].data.id,
    											};
    												buildingCodeStore.load();
    									   }
    									   
    								   }
    							   }	
    						})

    		   	 		   }
    		   	 		   else{
    		   	 			studentNameDefault.allowBlank = false;
    		   	 		   }
    		   	 	 }
    		   	 	 },
    		   	 		
    		   	 	'hostelapplicationslistgrid  menuitem[itemId=unallocateResidence]':{
    		   	 		click: function(){
    		   	 		var grid = this.getHostelapplicationslistgrid();
    		   	        if (grid.getSelectionModel().getCount() > 0) {
    		   	          showConfirmMessage(getCommonTranslation('CANCEL_HOSTEL_ALLOCATION'), getCommonTranslation('CANCEL_HOSTEL_ALLOCATION_MESSAGE'), function(btn, text) {
    		   	              if (btn == 'yes') {
    		   	                  if (grid.getSelectionModel().getCount() > 0) {
    		   	                      var records = grid.getSelectionModel().getSelection();
    		   	                      var flag=false;
    		   	                   var jsonData=[];
    		                       for (var count = 0; count < records.length; count++) {
    		                           var id = [];
    		                           if (!isNullOrEmpty(records[count].get("id"))) {
    		                               jsonData.push({id:records[count].get("id"),applicationStatus:records[count].get("applicationStatus")});
    		                           }
    		                       }
    		                       Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading'); 
	    		               		this$.sendSaveAjaxRequest(SERVERURL.PATH_UNALLOCATE_RESIDENCE, 'post', jsonData, function(option, success, response) {
	    		               			Ext.getBody().unmask();
	    		               			if(success){
		   	                                  grid.getSelectionModel().deselectAll();
   		   	                                   grid.getStore().reload();
	   		   	                                showSuccessMessage(getCommonTranslation('CANCEL_HOSTEL_ALLOCATION'), getCommonTranslation('CANCEL_HOSTEL_ALLOCATION_SUCCESS')); 
	    		               			}
	    		               		});
    		   	                      
    		   	                  }
    		   	              }
    		   	          });
    		   	      } else {
    		   	          showWarningMessage(getCommonTranslation('CANCEL_HOSTEL_ALLOCATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    		   	      }
    		   	 		}
    		   	 	},
    		   	 	'hostelapplicationslistgrid  menuitem[itemId=allocateResidence]':{
    		   	 		click: function(){
    		   	 			var $this = this;
    		   	 			var grid = $this.getHostelapplicationslistgrid();
    		   	 			if(grid.getSelectionModel().getCount() > 0) {
    		   	 				var allocateHostelPopupWin = $this.getAllocatehostelpopup();
    		   	 				if (!allocateHostelPopupWin) {
    		   	 					Ext.widget('allocatehostelpopup');
    		   	 					allocateHostelPopupWin = $this.getAllocatehostelpopup();
    		   	 				}
    		   	 				allocateHostelPopupWin.show();
    		   	 			} else {
    		   	 				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    		   	 			}
    		   	 		}
    		   	 	},
    		   	 	'allocatehostelpopup button[itemId=CancelButtonId]':{
    		   	 		click:function(obj){
    		   	 			var window = obj.up('window');
    		   	 			window.close();
    		   	 		}
    		   	 	},
    		   	 	'allocatehostelpopup button[itemId=SubmitButtonId]':{
    		   	 		click:function(obj){
	 	        			var $this = this;
	 	        			var window = $this.getAllocatehostelpopup();
	 	        			var grid = $this.getHostelapplicationslistgrid();
	 	        			var allocatedhostel = window.down('#hostelCodeName').getValue();
	 	        			var allocatedBy = window.down('#allocatedBy').getValue();
	 	        			var studentHostelApplicationId = null;
	 	        			if (grid.getSelectionModel().getCount()>0) {
	 	        				var records = grid.getSelectionModel().getSelection();
	 	        				studentHostelApplicationId = records[0].data.id;
	 	        			}
	 	        			var json;
	 	        			var url;
	 	        			if(!isNullOrEmpty(studentHostelApplicationId)){
	 	        				json = {
	 	        					"id":studentHostelApplicationId,
	 	        					"allocatedhostelId":allocatedhostel,
	 	        					"allocatedById":allocatedBy,
	 	        				};
	 	        				submitUrl=SERVERURL.PATH_ALLOCATE_HOSTEL_APPLICATION_STUDENTS;
	 	        			}
	 	        			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 	        			var formData = Ext.encode(json);
	 	        			Ext.Ajax.request({
	 	        				type : 'rest',
	 	        				url : submitUrl,
	 	        				jsonData : formData,
	 	        				method : 'POST',
	 	        				success : function(frm, action) {
	 	        					Ext.getBody().unmask(); 
	 	        					var response = frm.responseText;
	 	        					var responseData = null;
	 	        					if(!isNullOrEmpty(response)){
	 	        						responseData = Ext.decode(response);
	 	        					}
	 	        					if(!isNullOrEmpty(response) && !isNullOrEmpty(responseData) && !isNullOrEmpty(responseData.hostelCapacityExhausted) 
	 	        							&& responseData.hostelCapacityExhausted==true){
	 	        						showWarningMessage(getCommonTranslation('ALERT'), 
	 	        						getCommonTranslation('HOSTEL_CAPACITY_OF') + ' ' + responseData.allocatedHostelCode + '/' + responseData.allocatedHostelName + ' ' +
	 	        						getCommonTranslation('ALREADY_EXHAUSTED_FOR_THE_RESIDENCE_APPLICATION_ACADEMIC_TERM') + ' ' + responseData.hostelApplicationYear);
	 	        						return false;
	 	        					} else {
	 	        						window.close();
	 	        						showSuccessMessage(getCommonTranslation('HOSTEL_ALLOCATION'), getCommonTranslation('HOSTEL_APPLICATION_HAS_BEEN_ALLOCATED_SUCCESSFULLY'));
	 	        						$this.getHostelapplicationssearch().getForm().reset();
		 	        					grid.getSelectionModel().deselectAll();
		 	        					delete grid.getStore().proxy.extraParams.academicTermId;
		 	        					delete grid.getStore().proxy.extraParams.applicationStatus;
		 	        					delete grid.getStore().proxy.extraParams.hostelId;
		 	        					delete grid.getStore().proxy.extraParams.hostelSetupType;
		 	        					delete grid.getStore().proxy.extraParams.intakeId;
		 	        					delete grid.getStore().proxy.extraParams.intakeYearId;
		 	        					delete grid.getStore().proxy.extraParams.locationId;
		 	        					delete grid.getStore().proxy.extraParams.programGroupId;
		 	        					delete grid.getStore().proxy.extraParams.programId;
		 	        					delete grid.getStore().proxy.extraParams.seatTypeId;
		 	        					delete grid.getStore().proxy.extraParams.studentId;
		 	        					delete grid.getStore().proxy.extraParams.waitingListName;
		 	        					grid.getStore().load();
	 	        					}
	 	        				},
	 	        				failure: function(frm, action) {
	 	        					Ext.getBody().unmask(); 
	  	    	    	        }
	 	        			});
    		   	 		}
    		   	 	},
 		   	 	'hostelapplicationapplicantlistgrid menuitem[itemId=cancelOfferLetter]':{
 		   	 		click:function(){
 		   	 			this.cancelOfferLater('OFFER_LETTER_DECLINED');
 		   	 		}
 		   	 	},
 		   	 	'hostelapplicationapplicantlistgrid menuitem[itemId=acceptOfferLetter]':{
 		   	 		click:function(){
 		   	 			this.acceptHostelApplicants('OFFER_LETTER_ACCEPTED');
 		   	 		}
 		   	 	},
 		   	 	'hostelapplicationapplicantlistgrid menuitem[itemId=cancelApplicationHostel]':{
 		   	 		click:function(){
 		   	 			this.cancelHostelApplicants('UNALLOCATED');
 		   	 		}
 		   	 	},
 		   	 	'hostelapplicationapplicantlistgrid menuitem[itemId=sendOfferLetter]':{
 		   	 		click:function(){

 		   	 			var me = this,
 		   	 		hostelGrid =me.getHostelapplicationapplicantlistgrid(),
 		   		    selectedRec = hostelGrid.getSelectionModel().getSelection(),
 		   		    record = selectedRec[0].data;
		 		   	Ext.Ajax.request({
		 				type : 'rest',
		 				url : SERVERURL.FIND_APPLICANT_PATH_HOSTEL_TYPE_SETUP,
		 				params : {
		 					applicantHostelReqId:record.applicantHostelRequiredId
		 				},
		 				method : 'GET',
		 				success : function(frm, action) {
		 					if(isNullOrEmpty(frm.responseText)){
		 						showWarningMessage(getHostelTranslation('ISSUE_OFFER_LETTER'),getHostelTranslation('HOSTEL_APPLICATION_SETUP_IS_NOT_ACTIVE'));
		 					}else{
		 						var data = Ext.decode(frm.responseText);
		 						if(data.offerApplicable==false || data.offerApplicable=='false'){
		 							showWarningMessage(getHostelTranslation('ISSUE_OFFER_LETTER'),getHostelTranslation('OFFER_LETTER_IS_NOT_APPLICABLE_PLEASE_ALLOCATE_APPLICATION'));
		 						}else{
		 	 		   	 			var hostelIssueOfferLatter = Ext.widget('hostelIssueOfferLatter');
		 	 		   	 			hostelIssueOfferLatter.show();
		 	 		   	 			var expiryDate = hostelIssueOfferLatter.down('#offerExpiryDate'),
		 	 		   	 			applicationId = hostelIssueOfferLatter.down('#applicationId'),
		 	 		   	 			applicationType = hostelIssueOfferLatter.down('#applicationType'),
		 	 		   	 			academicTerm = hostelIssueOfferLatter.down('#academicTerm'),
		 	 		   	 			todayDate = new Date(),
		 	 		   	 		    endDate = todayDate.setDate(todayDate.getDate() + (data.maxDaysToAcceptOffer-1));
		 	 		   	 			expiryDate.setMinValue(new Date());
		 	 		   	 			expiryDate.setMaxValue(new Date(endDate));
		 	 		   	 			if(record.applicationType == "WAITING_LIST_SETUP"){
		 	 		   	 				applicationType.setValue(getFeeAndPaymentCommonTranslation('WAITING_LIST_APPLICATION'));
		 	 		   	 			}else{
		 	 		   	 				applicationType.setValue(getFeeAndPaymentCommonTranslation('GENERAL_APPLICATION'));
		 	 		   	 			}
			 	 		   	 		academicTerm.setValue(record.year);
			 	 		   	 	    applicationId.setValue(record.applicantCode+'/'+record.applicantName);

			 	 		   	 	    if(record.applicationStatus == "SUBMITTED"){
			 	 		   	 	    		expiryDate.setDisabled(true);
			 	 		   	 	    	//expiryDate.allowBlank = true;
			 	 		   	 	    	Ext.defer(function(){
			 	 		   	 	    	expiryDate.setValue(dateRender(new Date(endDate)));
			 	 		   	 	    	},500);
			 	 		   	 	       
			 	 		   	 	    }
		 						}
		 					}
		 				}
		 			});
 		   	 		
 		   	 		}
 		   	 	},
 		   	 	'hostelapplicationapplicantlistgrid button[itemId=btnRejectApplication]':{
 		   	 		click:function(){
 		   	 		var cancelApplicationWin = Ext.widget('cancelApplicationWin');
 		   	 		cancelApplicationWin.show();
 		   	 		}
 		   	 	},
 		   	 	'hostelapplicationapplicantlistgrid menuitem[itemId=allocatedApplicationHostel]':{
 		   	 		click:function(){
 		   	 			var me = this,
 		   	 		hostelGrid =me.getHostelapplicationapplicantlistgrid(),
 		   		    selectedRec = hostelGrid.getSelectionModel().getSelection();
 		   	 			if(selectedRec[0].data.applicationStatus == "SUBMITTED"){
 		   	 		 	Ext.Ajax.request({
 			 				type : 'rest',
 			 				url : SERVERURL.PATH_FIND_OFFER_APPLICABLE_FOR_APPLICANT,
 			 				params : {
 			 					id:selectedRec[0].data.applicantHostelRequiredId
 			 				},
 			 				method : 'GET',
 			 				success : function(frm, action) {
 			 					if(frm.responseText == 'true'){
 			 						showWarningMessage(getCommonTranslation('ALLOCATED_HOSTEL'),getHostelTranslation('OFFER_LETTER_MAPPED_ISSUE_OFFER_LETTER_FIRST'));
 			 					}else{
 			 						var residenceAllocationWin = Ext.widget('residenceAllocationWin');
 			 						residenceAllocationWin.show();
 			 						var loggedUser =this.getCurrentlyLoggedInUser(),
 			 						allocatedBy = residenceAllocationWin.down('#allocatedBy');
 			 						allocatedBy.getStore().getProxy().extraParams={
 			 							nameOrCode:loggedUser.code
 			 						}
 			 						Ext.defer(function(){
 			 							allocatedBy.getStore().load(function(){
 			 								allocatedBy.setValue(loggedUser.id);
 			 							})
 			 						},300);
 			 					}
 			 				}
 			 			});
 		   	 			}else{
 		   	 			var residenceAllocationWin = Ext.widget('residenceAllocationWin');
	 	 		   	 		residenceAllocationWin.show();
	 	 		   	 	var loggedUser =this.getCurrentlyLoggedInUser(),
	 						allocatedBy = residenceAllocationWin.down('#allocatedBy');
	 						allocatedBy.getStore().getProxy().extraParams={
	 							nameOrCode:loggedUser.code
	 						}
	 						Ext.defer(function(){
	 							allocatedBy.getStore().load(function(){
	 								allocatedBy.setValue(loggedUser.id);
	 							})
	 						},300);
 		   	 			}
		 		  
 		   	 		}
 		   	 	},
	        	'cancelApplicationWin button[itemId=cancelSubmitBtn]':{
	        		click:function(btn){
	        			var $this = this;
	        			var window = btn.up('window');
	        			var grid = $this.getHostelapplicationapplicantlistgrid();
	        			var cancelledBy = window.down('#cancelledBy').getValue();
	        			var cancellationReason = window.down('#cancelReason').getValue();
	        			var studentHostelApplicationIds =null;
	        			 if (grid.getSelectionModel().getCount() > 0) {
	   	                      var records = grid.getSelectionModel().getSelection();
	   	                      var empIds=[];
	   	                      if(!isNullOrEmpty(records) && records.length > 0) {
	   	                    	  for( var i=0; i<records.length; i++ ) {
	   	                    		  if(!isNullOrEmpty(records[i].data.applicantHostelRequiredId)){
	   	                    			empIds.push(records[i].data.applicantHostelRequiredId);
	   	                    		  }
	   	                    	  }
	   	                      }
	   	                   studentHostelApplicationIds = empIds.join(',');
	        			 }
	        			
	        			
	        			var json;
	        			var url;

	        			if(!isNullOrEmpty(studentHostelApplicationIds)){
	        				json = {
	        						"applicantHostelRequirementIds":studentHostelApplicationIds,
	        						"cancelledById":cancelledBy,
	        						"cancellationReason":cancellationReason,
	        				};
	        				submitUrl=SERVERURL.PATH_FIND_HOSTEL_CANCEL_APPLICATION_APPLICANT;
	        			}
	        			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        			var formData = Ext.encode(json);
	        			Ext.Ajax.request({
	        				type : 'rest',
	        				url : submitUrl,
	        				jsonData : formData,
	        				method : 'POST',
	        				success : function(frm, action) {
	        					Ext.getBody().unmask(); 
	        					var response = frm.responseText;
	        					window.close();
	        					if(!isNullOrEmpty(response)){
	        						showSuccessMessage(getHostelTranslation('CANCEL_APPLICATION'), getHostelTranslation('HOSTEL_ALLOCATION_CANCELED_SUCCESSFULLY'));
	        					}
	        					grid.getSelectionModel().deselectAll();
	        					grid.getStore().load();
	        				}
	        			});
	        		}
	        	},
	        	'cancelApplicationWin button[itemId=cancelButtonId]':{
	        		click:function(btn){
	        			btn.up('window').close();
	        		}
	        	},
	        	'hostelIssueOfferLatter button[itemId=cancelButtonId]':{
	        		click:function(btn){
	        			btn.up('window').close();
	        		}
	        	},
	        	'hostelIssueOfferLatter button[itemId=offerLatterSubmitBtn]':{
	        		click:function(btn){
	        			this.sendOfferLater(btn);
	        		}
	        	},
	        	'residenceAllocationWin button[itemId=residenceCancelButtonId]':{
	        		click:function(btn){
	        			btn.up('window').close();
	        		}
	        	},
	        	'residenceAllocationWin button[itemId=residenceSubmitBtn]':{
	        		click:function(btn){
	        			this.allocatedHostelApplicants('ALLOCATED')
	        		}
	        	},
	        	'hostelImportStructure treepanel[itemId=customImportHostelPanelId]':{
	        		itemclick:this.getOpenhostelReportStructure
	        	}

	        	

		});
		
		  
	},
	
	'userwisesearch combo[itemId=studentNameNo]':{
		 select:function(){
			 var $this =this;
			 var form = this.getUserwisesearch();
			 if($this.HostelResponse[0].value == 'NO' || $this.HostelResponse[0].value == 'No' || $this.HostelResponse[0].value == 'nO' || $this.HostelResponse[0].value == 'no'){
					var studentNameNo = form.down("#studentNameNo").getValue();
					var hostel = form.down("#hostelCodeNo").getStore();
					
					hostel.getProxy().extraParams = {
						studentId: studentNameNo
					};
					hostel.load();
			 }
		}
	},
	
	setAcademyLocationDefault: function(){
		var $this = this,
		academyLocationId = $this.getCurrentAcademyLocation(),
		hostelApplicationSearchFilter = $this.getHostelapplicationsearch(),
		userId = $this.getCurrentlyLoggedInUser().id,
		acadLocCombo = hostelApplicationSearchFilter.down('#academyLocationItemId'),
		studentNamecombo = hostelApplicationSearchFilter.down('#studentName'),
		programGroupcombo = hostelApplicationSearchFilter.down('#programGroupId'),
		programCombo = hostelApplicationSearchFilter.down('#programId');
		var store = acadLocCombo.getStore(),
		studentNamecomboStore = studentNamecombo.getStore(),
		programGroupcomboStore = programGroupcombo.getStore(),
		programComboStore = programCombo.getStore();
		store.getProxy().extraParams = {
			id: userId
		};
		store.load({
			callback:function(){
				acadLocCombo.setValue(academyLocationId);
				studentNamecombo.reset();
				studentNamecomboStore.getProxy().extraParams = {
					academyLocationId: academyLocationId
				};
				studentNamecomboStore.load();
				
				programGroupcombo.reset();
				programGroupcomboStore.getProxy().extraParams = {
        			academyLocationId: academyLocationId
        		};
				programGroupcomboStore.load();
				
				programCombo.reset();
				programComboStore.getProxy().extraParams = {
        			academyLocationId: academyLocationId
        		};
				programComboStore.load();
			}
		});
		
		var batch = hostelApplicationSearchFilter.down("#batchId");
		batch.setDisabled(true);
		batch.reset();

		var period = hostelApplicationSearchFilter.down("#periodId"); 					   
		period.setDisabled(true);
		period.reset();
		
		var seatType = hostelApplicationSearchFilter.down("#seatType"); 					   
		seatType.setDisabled(true);
		seatType.reset();

		var section = hostelApplicationSearchFilter.down("#sectionId");
		section.setDisabled(true);
		section.reset();
	},
	searchHostelSearchForm:function(button){
		var $this = this;
		var hostelApplicationSearchFilter = $this.getHostelapplicationsearch();
		//var form = hostelApplicationSearchFilter.getForm();
		if(!$this.getHostelstudentsearch().isHidden()){
			form = $this.getHostelstudentsearch();
		}else if(!$this.getHostelapplicationsearch().isHidden()){
			form = $this.getHostelapplicationsearch();
		}else{
			form = $this.getHostelapplicationssearch();
		}
		var values = form.getForm().getValues();
		if(values.applicantType=='APPLICANT'){
			var grid = $this.getHostelapplicationapplicantlistgrid();
			var store = grid.getStore();
			store.getProxy().extraParams = {
				hostelId:values.hstlApplicationsHostelCode,
				applicationType:values.applicantType,
				academyLocationId:values.academyLocationId,
				applicantId:values.APPICANT_PRINT_NAME,
				settlementStatus:values.settlementStatus,
				//waitingListTypeId:values.waitingList
			};
		}else{
			var hostelstudentsearchForm = $this.getHostelstudentsearch();
			var form = hostelstudentsearchForm.getForm();
			var values = form.getValues();
			var grid = $this.getHostelapplicationlist();
			var store = grid.getStore();
			store.getProxy().extraParams = {
				academicTermId:values.academicTerm,
				academyLocationId:values.academyLocationId,
				batchId:values.batchId,
				intakeYearId:values.intakeYear,
				periodId:values.periodId,
				programGroupId:values.programGroupId,
				programId:values.programId,
				seatTypeId:values.seatType,
				sectionId:values.sectionId,
				settlementStatus:values.settlementStatus,
				studentId:values.studentName
			};
		}
	
		$this.resetPageSetting(store);
		store.loadPage(1);
		grid.getSelectionModel().deselectAll(true);
		
		var alloteRoomBtn = grid.down('#btnAllotRoom');
		var applyRuleBtn = grid.down('#btnApplyRule');
		var rejectApplicationBtn = grid.down('#btnRejectApplication');
		var rejectApplicationBtn = grid.down('#btnRejectApplication');
		
		alloteRoomBtn.setDisabled(false);
		applyRuleBtn.setDisabled(false);
		rejectApplicationBtn.setDisabled(false);
	},
	resetHostelSearchForm:function(button){
		var $this = this;
		var studentGrid = $this.getHostelapplicationapplicantlistgrid();
		var applicantGrid = $this.getHostelapplicationlist();
		var hostelApplicationSearchFilter = $this.getHostelapplicationsearch();
		hostelApplicationSearchFilter.getForm().reset();

		
		var hostelStudentSearchFilters = this.getHostelstudentsearch(),
		intakeYear = hostelStudentSearchFilters.down('#intakeYear');
		intakeYear.reset();
		
		academicTerm = hostelStudentSearchFilters.down('#academicTerm');
		academicTerm.reset();
		
		academyLocation = hostelStudentSearchFilters.down('#academyLocationItemId');
		academyLocation.reset();
		
		studentName = hostelStudentSearchFilters.down('#studentName');
		studentName.reset();
		
		programGroup = hostelStudentSearchFilters.down('#programGroupId');
		programGroup.reset();
		
		program = hostelStudentSearchFilters.down('#programId');
		program.reset();
		
		batch = hostelStudentSearchFilters.down('#batchId');
		batch.reset();
		
		period = hostelStudentSearchFilters.down('#periodId');
		period.reset();
		
		section = hostelStudentSearchFilters.down('#sectionId');
		section.reset();
		
		settlementStatus = hostelStudentSearchFilters.down('#settlementStatus');
		settlementStatus.reset();
		
		waitingList = hostelStudentSearchFilters.down('#waitingList');
		waitingList.reset();
		
		
		var alinfomodel = Academia.model.authentication.ALInfoModel;
		var wheatherSchool = alinfomodel.get('wheatherSchool');

		var batch = hostelApplicationSearchFilter.down("#batchId");
		batch.setDisabled(true);
		batch.reset();

		var period = hostelApplicationSearchFilter.down("#periodId"); 					   
		period.setDisabled(true);
		period.reset();
		
		var seatType = hostelApplicationSearchFilter.down("#seatType"); 					   
		seatType.setDisabled(true);
		seatType.reset();

		var section = hostelApplicationSearchFilter.down("#sectionId");
		section.setDisabled(true);
		section.reset();
		
		if(wheatherSchool) {
			period.setVisible(false);
		}
		
		var applicantType = hostelApplicationSearchFilter.down('#applicantType');
		var studentName = hostelApplicationSearchFilter.down('#studentName');
		var HstlApplicationsApplicantName = hostelApplicationSearchFilter.down('#HstlApplicationsApplicantName');
		applicantType.getStore().load({
			 callback: function(records, operation, success) {
				 for(var i in records){
					 if(records[i].data.name=='Student'){
						 applicantType.setValue(records[i].data.value);
					 }
				 }
			 }	   
		 });
		studentName.setVisible(true);
		HstlApplicationsApplicantName.setVisible(false);
		
		var programGroup = hostelApplicationSearchFilter.down('#programGroupId');
		var intakeYear = hostelApplicationSearchFilter.down('#intakeYear');
		var academicTerm = hostelApplicationSearchFilter.down('#academicTerm');
		var programId = hostelApplicationSearchFilter.down('#programId');
		programGroup.setDisabled(false);
		intakeYear.setDisabled(false);
		academicTerm.setDisabled(false);
		programId.setDisabled(false);
		
		studentGrid.setVisible(false);
		applicantGrid.setVisible(true);
		
		$this.setAcademyLocationDefault();
	},
	searchHostelApplicationSearchForm:function(button){
		var $this = this;
		var hostelApplicationSearchFilter = $this.getHostelapplicationsearch();
		var form = hostelApplicationSearchFilter.getForm();
		var values = form.getValues();
		var grid = $this.getHostelapplicationapplicantlistgrid();
		var store = grid.getStore(),
		acceptOfferLetterBtn = grid.down("#acceptOfferLetter"),
		sendOfferLetterBtn = grid.down("#sendOfferLetter"),
		cancelOfferLetterBtn = grid.down("#cancelOfferLetter"),
		allocatedApplicationHostelBtn = grid.down("#allocatedApplicationHostel"),
		cancelApplicationHostelBtn = grid.down("#cancelApplicationHostel"),
		btnRejectApplication = grid.down("#btnRejectApplication"),
		allocatedApplicationHostelBtn = grid.down("#allocatedApplicationHostel");
		allocatedApplicationHostelBtn.setDisabled(true);
		cancelApplicationHostelBtn.setDisabled(true);
		btnRejectApplication.setDisabled(true);
		acceptOfferLetterBtn.setDisabled(true);
		cancelOfferLetterBtn.setDisabled(true);
		sendOfferLetterBtn.setDisabled(true);
		grid.getSelectionModel().deselectAll(true);
		store.getProxy().extraParams = {
			applicationType:values.applicantType,
			locationId:values.locationId,
			academyLocationId:values.academyLocationId,
			hostelCode:values.hstlApplicationsHostelCode,
			applicantId:values.hstlApplicationsApplicantName,
			waitingListTypeId:values.hstlWaitingList,
			depositCategoryId:values.hstlDepositCategory,
			applicationStatus:values.hstlApplicationstatus,
			settlementStatus:values.hstlSettlementStatus,
			yearId:values.hstlYear
		};
		$this.resetPageSetting(store);
		store.loadPage(1);
	},
	resetHostelApplicationSearchForm:function(button){
		var $this = this;
		var applicantGrid = $this.getHostelapplicationapplicantlistgrid();
		var hostelApplicationSearchFilter = $this.getHostelapplicationsearch();
		var hostelCode= hostelApplicationSearchFilter.down('#hstlApplicationsHostelCode');
		var academyLocationId = hostelApplicationSearchFilter.down('#academyLocationItemId').getValue();
		var locationId = hostelApplicationSearchFilter.down('#locationItemId').getValue();
		var waitingListName = hostelApplicationSearchFilter.down("#hstlWaitingList"); 
		waitingListName.reset();
		var waitingListStore = waitingListName.getStore()
		delete waitingListStore.getProxy().extraParams.academyLocationId;
		delete waitingListStore.getProxy().extraParams.hostelApplicationType;
		delete waitingListStore.getProxy().extraParams.academicTerm;
		delete waitingListStore.getProxy().extraParams.locationId;
		waitingListStore.load();
		var store = hostelCode.getStore();
		if(!isNullOrEmpty(academyLocationId)){
			store.getProxy().extraParams.academyLocationId= '';
		}
		if(!isNullOrEmpty(locationId)){
			store.getProxy().extraParams.locationId='';
		}
		hostelApplicationSearchFilter.getForm().reset();
		
		var applicantType = hostelApplicationSearchFilter.down('#applicantType');
		applicantType.getStore().load({
			 callback: function(records, operation, success) {
				 for(var i in records){
					 if(records[i].data.name=='Student'){
						 applicantType.setValue(records[i].data.value);
					 }
				 }
			 }	   
		 });
         var alloteRoomBtn2= applicantGrid.down('#btnAllotRoom');
		 var applyRuleBtn2 = applicantGrid.down('#btnApplyRule');
		 alloteRoomBtn2.setVisible(false);
		 applyRuleBtn2.setVisible(false);
         var locationDropDown = hostelApplicationSearchFilter.down("#locationItemId");
		 var alDropDown = hostelApplicationSearchFilter.down("#academyLocationItemId");
//		 var waitingList = hostelApplicationSearchFilter.down("#hstlWaitingList");
		 locationDropDown.getStore().removeAll();
		 alDropDown.getStore().removeAll();
		 locationDropDown.setDisabled(true);
	     alDropDown.setDisabled(true);
//	     waitingList.setDisabled(true);
	},
	getProgramBatchPeriodByStudentId: function(combo){
		var $this = this;
		var hostelApplicationSearchFilter = $this.getHostelstudentsearch();
		
		if(!$this.getHostelstudentsearch().isHidden()){
			hostelApplicationSearchFilter = $this.getHostelstudentsearch();
		}else if(!$this.getHostelapplicationsearch().isHidden()){
			hostelApplicationSearchFilter = $this.getHostelapplicationsearch();
		}else{
			hostelApplicationSearchFilter = $this.getHostelapplicationssearch();
		}
		
		var studentId = combo.getValue(),
		academyLocationId = hostelApplicationSearchFilter.down('#academyLocationItemId').getValue();
		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        Ext.Ajax.request({
            method: "GET",
            type: 'rest',
            url: SERVERURL.PATH_FIND_PROGRAM_BATCH_SECTION_PERIOD_BY_STUDENT_ID,
            headers: {
                'Content-Type': 'application/json'
            },
            params: {
                studentId: studentId
            },
            success: function(response, action) {
                var data = Ext.decode(response.responseText);
                var programCombo = hostelApplicationSearchFilter.down('#programId');
                //programCombo.setReadOnly(true);
                var programComboStore = programCombo.getStore();
                programComboStore.getProxy().extraParams = {
                	academyLocationId:academyLocationId,
                	programId: data[0].programId
                };
                programComboStore.load({
                    callback: function(records, operation, success) {
                        if (!isNullOrEmpty(data[0].programId)) {
                            programCombo.setValue(data[0].programId);
                            var batchCombo = hostelApplicationSearchFilter.down('#batchId');
                            //batchCombo.setReadOnly(true);
                            batchCombo.setDisabled(false);
                            var batchComboStore = batchCombo.getStore();
                            batchComboStore.getProxy().extraParams = {
                            	id: data[0].programId,
                            	batchId: data[0].batchId
                            };

                            batchComboStore.load({
                                callback: function(records, operation, success) {
                                    if (!isNullOrEmpty(data[0].batchId)) {
                                        batchCombo.setValue(data[0].batchId);
                                        var periodCombo = hostelApplicationSearchFilter.down('#periodId');
                                        //periodCombo.setReadOnly(true);
                                        periodCombo.setDisabled(false);
                                        var periodComboStore = periodCombo.getStore();
                                        periodComboStore.getProxy().extraParams = {
                                            id: data[0].batchId,
                                            periodId: data[0].programPeriodId
                                        };
                                        
                                        var alinfomodel = Academia.model.authentication.ALInfoModel;
                                		var wheatherSchool = alinfomodel.get('wheatherSchool');
                                		
                                		if(wheatherSchool) {
                                			periodCombo.setVisible(false);
                                		}

                                        periodComboStore.load({
                                            callback: function(records, operation, success) {
                                                if (!isNullOrEmpty(data[0].programPeriodId)) {
                                                    periodCombo.setValue(data[0].programPeriodId);
                                                    var sectionCombo = hostelApplicationSearchFilter.down('#sectionId');
                                                    sectionCombo.setDisabled(false);
                                                    var sectionComboStore = sectionCombo.getStore();
                                                    sectionComboStore.getProxy().extraParams = {
                                                        periodId: data[0].programPeriodId
                                                    };
                                                    sectionComboStore.load({
                                                        callback: function(records, operation, success) {
                                                        	if (!isNullOrEmpty(data[0].sectionId)) {
                                                               // sectionCombo.setValue(data[0].sectionId);
                                                                Ext.getBody().unmask();
                                                        	}else {
                                                        		Ext.getBody().unmask();
                                                        		sectionCombo.emptyText = [ '' ];
                                                        		sectionCombo.applyEmptyText();
                                                        		sectionCombo.reset();
                                                        	}
                                                        }
                                                    });
                                                }
                                                else{
                                                	Ext.getBody().unmask();
                                                }
                                            }
                                        });
                                        
                                        var seatType = hostelApplicationSearchFilter.down("#seatType"); 
                                        seatType.setDisabled(false);
                                        var seatTypeStore = seatType.getStore();
                                			seatTypeStore.getProxy().extraParams = {
                                				batchId: data[0].batchId
                                    		};	
                                		seatTypeStore.load();
                                    }
                                    else{
                                    	Ext.getBody().unmask();
                                    }
                                }
                            });
                        }
                        else{
                        	Ext.getBody().unmask();
                        }
                    }
                });
            }
        });
	},
	doAccessControlCustomBtnValidation: function(grid,permissionsMap) {
    	
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    
		var alloteRoomBtn = grid.down('#btnAllotRoom');
		var applyRuleBtn = grid.down('#btnApplyRule');
		var rejectApplicationBtn = grid.down('#btnRejectApplication');
		var spBtnMoreActions = grid.down('#spBtnMoreActions');
		var sendOfferLetter = grid.down('#sendOfferLetter');
		var revokeOfferLetter = grid.down('#revokeOfferLetter');
//		var printOfferLetter = grid.down('#printOfferLetter');
//		var assignOfferLetter = grid.down('#assignOfferLetter');
//		var assignOfferExpiryDate = grid.down('#assignOfferExpiryDate');
		
		alloteRoomBtn.setVisible(false);
		applyRuleBtn.setVisible(false);
		rejectApplicationBtn.setVisible(false);
		spBtnMoreActions.setVisible(false);
		sendOfferLetter.setVisible(false);
		revokeOfferLetter.setVisible(false);
//		printOfferLetter.setVisible(false);
//		assignOfferLetter.setVisible(false);
//		assignOfferExpiryDate.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'ALLOTEROOM') {
    			alloteRoomBtn.setVisible(true);
        	}
    		if (privilege === 'APPLY_RULE') {
    			applyRuleBtn.setVisible(true);
        	}
    		if (privilege === 'REJECTAPPLICATION') {
    			rejectApplicationBtn.setVisible(true);
        	}
    		if (privilege === 'MOREACTIONS') {
    			spBtnMoreActions.setVisible(true);
        	}
    		if (privilege === 'SEND_OFFER_LETTER') {
    			sendOfferLetter.setVisible(true);
        	}
    		if (privilege === 'REVOKE_OFFER_LETTER') {
    			revokeOfferLetter.setVisible(true);
        	}
//    		if (privilege === 'PRINT_OFFER_LETTER') {
//    			printOfferLetter.setVisible(true);
//        	}
//    		if (privilege === 'ASSIGN_OFFER_LETTER') {
//    			assignOfferLetter.setVisible(true);
//        	}
//    		if (privilege === 'ASSIGN_OFFER_EXPIRY_DATE') {
//    			assignOfferExpiryDate.setVisible(true);
//        	}
    	});
    },
    allotRoomBtnClick: function(btn){
    	var grid = this.getHostelapplicationlist();
    	var contentpanel = this.getContentPanel();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var roomAllocationStructureController = Academia.app.getController('Academia.controller.hostel.roomallocation.RoomAllocationStructureController');
    		var hostelRoomAllocation = Ext.widget('hostelroomallocationstructure');
    		var records = grid.getSelectionModel().getSelection()[0]; 
    		var studentId = records.get('studentId');
    		var tabName = getMegaMenuTranslation('ROOM_ALLOCATION');
    		var getcontroller = this.getController('menu.CoreERPNavigationController');
    		var getAddTab = getcontroller.getTab(getMegaMenuTranslation('ROOM_ALLOCATION'));
    		if (getAddTab != null) {
    			contentPanel.remove(getAddTab, true);
    		}
    		openTab(contentpanel, tabName, hostelRoomAllocation, CONSTANTS.MENU_COLOR_TWELVE);

    		if(!isNullOrEmpty(studentId)){
    			var studentName = hostelRoomAllocation.down('userwisesearch').down('#studentName');
    			var feePlan = hostelRoomAllocation.down('userwisesearch').down('#hostelFeePlanName');
    			var feePlanRule = hostelRoomAllocation.down('userwisesearch').down('#hostelFeeRule');
    			var feePlanAmount = hostelRoomAllocation.down('userwisesearch').down('#hostelFeeTotalAmount');
    			var store = studentName.getStore();
    			studentName.config.isAllotRoom = true;
				store.getProxy().extraParams = {
					userType: 3, 		//userType = 3(Student)
					codeOrName:records.data.studentCode
				};
				store.load({
					callback:function(){
						studentName.setValue(studentId);
						feePlan.setValue(records.get('feeplan'));
						feePlanRule.setValue(records.get('feeplanRule'));
						feePlanAmount.setValue(records.get('totalAmount'));
						
					}
				});
    		}
    	}else{
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
    applyRuleBtnClick:function(){
    	var $this=this;
    	var grid = this.getHostelapplicationlist();
		var records = grid.getSelectionModel().getSelection();
		if(records.length>0){
			var formWindow = $this.getHostelapplyrulewindow();
	    	if (!formWindow) {
	    		Ext.widget('hostelapplyrulewindow');
	    		formWindow = $this.getHostelapplyrulewindow();
	    	}
	    	formWindow.show();
	    	var store = formWindow.down("#applyRuleItemId").getStore();
	    	store.getProxy().extraParams={
	    	hostelDroolCode:'AU_HOSTEL_APPLICATION_RULE'
		    };
		    store.load();	
		}else{
	        showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
    rejectApplicationBtnClick:function(){
		var $this=this;
		var grid = $this.getHostelapplicationlist();
		var records = grid.getSelectionModel().getSelection();
		if(records.length>0){
			var formWindow = $this.getHostelrejectapplicationwindow();
	    	if (!formWindow) {
	    		Ext.widget('hostelrejectapplicationwindow');
	    		formWindow = $this.getHostelrejectapplicationwindow();
	    	}
	    formWindow.show();	
	    var currentlyLoggedInUserId= $this.getCurrentlyLoggedInUser().id;
	    var rejectedBy = formWindow.down('#rejectedBy');
	    var rejectionByStore = rejectedBy.getStore();
	    rejectionByStore.load({
				   callback: function(records, operation, success) {
					   if (success) {
						  for(var i in records) {
							   	if(records[i].data.id == currentlyLoggedInUserId){
							   		rejectedBy.setValue(records[i].data.id);
							   	}
						   }
					   }
				   }	   
			   });
		}else{
	        showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
    submitApplyRuleForHostel:function(obj){
			var grid = this.getHostelapplicationlist();
			var records = grid.getSelectionModel().getSelection();
			var $this= this;	
			var window = $this.getHostelapplyrulewindow();
			var hostelApplication = window.down('#applyRuleItemId');
			var studentIdArray = [];
			var droolCode=hostelApplication.valueModels[0].data.code;
			var isSubmitted=false;
			for(var i in records) {
				if(records[i].data.hostelStatus!='REJECTED'){
					studentIdArray.push(records[i].data.studentId);
				}
			}
			for(var i in records) {
				if(records[i].data.hostelStatus=='AVAILABLE'){
				isSubmitted=true;
				break;
			}}
			var studentIds = studentIdArray.join(',');
               if(!isSubmitted){
            	   Ext.Ajax.request({
  		 			 method: "GET",
  		             type: 'rest',
  		             url: SERVERURL.PATH_FIND_FOR_HOSTEL_APPLICATION_ROOM_ALLOTTMENT_APPLY_RULE,
  		             headers: {
  		                 'Content-Type': 'application/json'
  		             },
  		             params: {
  		                 studentId: studentIds,
  		                 ruleId : droolCode
  		             },
  		 			success : function(form, action) {
  		 				showSuccessMessage(getCommonTranslation('RULE'),getCommonTranslation('RULE_HAS_BEEN_APPLIED_SUCCESSFULLY'));
  		 				grid.getStore().reload();
  		 				obj.up('window').close();
  		 			}
  		 		});	
            	var contentpanel = this.getContentPanel();
                var roomAllocationStructureController = Academia.app.getController('Academia.controller.hostel.roomallocation.RoomAllocationStructureController');
           		var hostelRoomAllocation = Ext.widget('hostelroomallocationstructure');
           		var tabName = getMegaMenuTranslation('ROOM_ALLOCATION');
           		var getcontroller = this.getController('menu.CoreERPNavigationController');
           		var getAddTab = getcontroller.getTab(getMegaMenuTranslation('ROOM_ALLOCATION'));
           		if (getAddTab != null) {
           			contentPanel.remove(getAddTab, true);
           		}
           		openTab(contentpanel, tabName, hostelRoomAllocation, CONSTANTS.MENU_COLOR_TWELVE);
               }else{
       			showWarningMessage(getPersonModuleTranslation('RULE'),getCommonTranslation('HOSTEL_ROOM_IS_ALREADY_AVAILABLE_FOR_THE_SELECTED_STUDENTS'));
               }
		    	$this.hideWindowMask();
	},
	saveRejectApplicationForHostel:function(obj){
		var grid = this.getHostelapplicationlist();
		var records = grid.getSelectionModel().getSelection();
		var $this= this;	
		var window = $this.getHostelrejectapplicationwindow();
		var rejectedBy = window.down('#rejectedBy').getValue();
		var formDate = window.down('#rejectionDate').getValue();
		var rejectionRemark = window.down('#rejectionRemark').getValue();
		 var rejectionDate=Ext.Date.format(formDate, 'm/d/Y')

		var personServiceOptInIdArray = [];
		for(var i in records) {
			personServiceOptInIdArray.push(records[i].data.serviceId);
		}
		var serviceIds = personServiceOptInIdArray.join(',');
        	   Ext.Ajax.request({
		 			 method: "GET",
		             type: 'rest',
		             url: SERVERURL.PATH_REJECT_HOSTEL_APPLICATION_BY_SERVICEID,
		             headers: {
		                 'Content-Type': 'application/json'
		             },
		             params: {
		            	 serviceId: serviceIds,
		            	 rejectedBy:rejectedBy,
		            	 rejectionDate:rejectionDate,
		            	 rejectionRemark:rejectionRemark
		             },
		 			success : function(form, action) {
		 				showSuccessMessage(getCommonTranslation('REJECT_HOSTEL_APPLICATION'),getCommonTranslation('HOSTEL_APPLICATION_HAS_BEEN_REJECTED_SUCCESSFULLY'));
		 				grid.getStore().reload();
		 				obj.up('window').close();
		 			}
        	   });	
        	   $this.hideWindowMask();
	},
	showHostelFeeDetailWindow:function(grid,record){
		var $this = this;
		var formWindow = $this.getHostelfeedetailwin();
		if (!formWindow) {
			formWindow=	Ext.widget('hostelfeedetailwin');
			//formWindow = $this.getHosteldocumentgriddetailswin();
		}
		formWindow.show();
		var form = $this.getHostelfeedetailwin();

		if(!isNullOrEmpty(record.data.feeplan)){
			var floorNo =   record.data.feeplan;
			form.down('#feePlanName').setValue(floorNo);
		}

		if(!isNullOrEmpty(record.data.feeplanRule)){
			var roomType =   record.data.feeplanRule;
			form.down('#feeRule').setValue(roomType);
		}


		if(!isNullOrEmpty(record.data.totalAmount)){
			var roomNo =   record.data.totalAmount;
			form.down('#totalAmount').setValue(roomNo);
		}
	},
	allotRoomApplicantGridBtnClick: function(btn){
    	var grid = this.getHostelapplicationapplicantlistgrid();
    	var contentpanel = this.getContentPanel();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var roomAllocationStructureController = Academia.app.getController('Academia.controller.hostel.roomallocation.RoomAllocationStructureController');
    		var hostelRoomAllocation = Ext.widget('hostelroomallocationstructure');
    		var records = grid.getSelectionModel().getSelection()[0]; 
    		var studentId = records.get('studentId');
    		var tabName = getMegaMenuTranslation('ROOM_ALLOCATION');
    		var getcontroller = this.getController('menu.CoreERPNavigationController');
    		var getAddTab = getcontroller.getTab(getMegaMenuTranslation('ROOM_ALLOCATION'));
    		if (getAddTab != null) {
    			contentPanel.remove(getAddTab, true);
    		}
    		openTab(contentpanel, tabName, hostelRoomAllocation, CONSTANTS.MENU_COLOR_TWELVE);

    		if(!isNullOrEmpty(studentId)){
    			var studentName = hostelRoomAllocation.down('userwisesearch').down('#studentName');
    			var feePlan = hostelRoomAllocation.down('userwisesearch').down('#hostelFeePlanName');
    			var feePlanRule = hostelRoomAllocation.down('userwisesearch').down('#hostelFeeRule');
    			var feePlanAmount = hostelRoomAllocation.down('userwisesearch').down('#hostelFeeTotalAmount');
    			var store = studentName.getStore();
    			studentName.config.isAllotRoom = true;
				store.getProxy().extraParams = {
					userType: 3, 		//userType = 3(Student)
					codeOrName:records.data.studentCode
				};
				store.load({
					callback:function(){
						studentName.setValue(studentId);
						feePlan.setValue(records.get('feeplan'));
						feePlanRule.setValue(records.get('feeplanRule'));
						feePlanAmount.setValue(records.get('totalAmount'));
						
					}
				});
    		}
    	}else{
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
    applyRuleApplicantGridBtnClick:function(){
    	var $this=this;
    	var grid = this.getHostelapplicationapplicantlistgrid();
		var records = grid.getSelectionModel().getSelection();
		if(records.length>0){
			var formWindow = $this.getHostelapplyrulewindow();
	    	if (!formWindow) {
	    		Ext.widget('hostelapplyrulewindow');
	    		formWindow = $this.getHostelapplyrulewindow();
	    	}
	    	formWindow.show();
	    	var store = formWindow.down("#applyRuleItemId").getStore();
	    	store.getProxy().extraParams={
	    	hostelDroolCode:'AU_HOSTEL_APPLICATION_RULE'
		    };
		    store.load();	
		}else{
	        showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
    rejectApplicationApplicantGridBtnClick:function(){
		var $this=this;
		var grid = $this.getHostelapplicationapplicantlistgrid();
		var records = grid.getSelectionModel().getSelection();
		if(records.length>0){
			var formWindow = $this.getHostelrejectapplicationwindow();
	    	if (!formWindow) {
	    		Ext.widget('hostelrejectapplicationwindow');
	    		formWindow = $this.getHostelrejectapplicationwindow();
	    	}
	    formWindow.show();	
	    var currentlyLoggedInUserId= $this.getCurrentlyLoggedInUser().id;
	    var rejectedBy = formWindow.down('#rejectedBy');
	    var rejectionByStore = rejectedBy.getStore();
	    rejectionByStore.load({
				   callback: function(records, operation, success) {
					   if (success) {
						  for(var i in records) {
							   	if(records[i].data.id == currentlyLoggedInUserId){
							   		rejectedBy.setValue(records[i].data.id);
							   	}
						   }
					   }
				   }	   
			   });
		}else{
	        showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
    loadAlWin:function(grid,record){
    	var formWindow = this.getHostelapplicationalwindow();
    	if (formWindow==undefined) {
    		formWindow=	Ext.widget('hostelapplicationalwindow');
    	}
    	var innergrid=formWindow.down('#hostelApplicationAlGrid');
    	formWindow.show();
    	var store = innergrid.getStore();
    	store.getProxy().extraParams = {
    		applicantHostelRequiredId : record.raw.applicantHostelRequiredId
    	};
    	store.load();
    },
    applicantStudentFormChangeHostelAllocation: function(cb, nv, ov) {
        var $this = this;
        var hostelStudentSearchForm = $this.getHostelstudentsearch();
        var hostelAppllicantSearchForm = $this.getHostelapplicationsearch();
        
        var applicantGrid = $this.getHostelapplicationapplicantlistgrid();
		var studentGrid = $this.getHostelapplicationlist();
		
		var hostelapplicationssearchForm =  $this.getHostelapplicationssearch()
		var hostelapplicationslistgrid = $this.getHostelapplicationslistgrid()
		
        
        //var grid = $this.getImportadmissionsetupupdatesgrid();
        if (nv.studentHostel == 'forStudentFormTemplate') {
           hostelAppllicantSearchForm.setVisible(false);
           if(this.showStudentHostalGrid == true) {
        	   hostelapplicationssearchForm.setVisible(true);
  			   hostelapplicationslistgrid.setVisible(true);
   			}else {
   				hostelStudentSearchForm.setVisible(true);
   				studentGrid.setVisible(true);    				   			
   			}
           applicantGrid.setVisible(false);
           hostelStudentSearchForm.isValid();
           hostelStudentSearchForm.getForm().reset();
           var applicantType = hostelStudentSearchForm.down('#applicantType');
	   		applicantType.getStore().load({
	   			 callback: function(records, operation, success) {
	   				 for(var i in records){
	   					 if(records[i].data.name=='Student'){
	   						 applicantType.setValue(records[i].data.value);
	   					 }
	   				 }
	   			 }	   
	   		 });
        } else {
        	 
             hostelStudentSearchForm.setVisible(false);
             Ext.defer(function(){
            	 hostelAppllicantSearchForm.setVisible(true);
             },1);
             studentGrid.setVisible(false);
             hostelapplicationssearchForm.setVisible(false);
			   hostelapplicationslistgrid.setVisible(false);
             applicantGrid.setVisible(true);
             var alloteRoomBtn2= applicantGrid.down('#btnAllotRoom');
			 var applyRuleBtn2 = applicantGrid.down('#btnApplyRule');
			 alloteRoomBtn2.setVisible(false);
			 applyRuleBtn2.setVisible(false);
             var locationDropDown = hostelAppllicantSearchForm.down("#locationItemId");
			 var alDropDown = hostelAppllicantSearchForm.down("#academyLocationItemId");
			 var waitingList = hostelAppllicantSearchForm.down("#hstlWaitingList");
			 var applicantType = hostelAppllicantSearchForm.down("#applicantType");
			 applicantType.reset();
			 locationDropDown.setDisabled(true);
		     alDropDown.setDisabled(true);
//		     waitingList.setDisabled(true);
		     locationDropDown.reset();
		     locationDropDown.getStore().removeAll();
		     alDropDown.reset();
		     alDropDown.getStore().removeAll();
             hostelAppllicantSearchForm.isValid();
             hostelAppllicantSearchForm.getForm().reset();
        }
    },
    
//    code for hostel search screen author sanjeev ranjan 
  
    
    
    
//    end of search code 
    
    
//    code written by sanjeev ranjan 
    
    showHideSectionTabs : function(structure, permissionsMap) {
		        var associatedAcadLocationIds = new Array();
		        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,permissionsMap);
		        var sectionTrans = false, sectionCreat = false;
		        Ext.each(permissionList, function(privilege) {
		            if (privilege === "BULK_RESIDENCE_APPLICATION_STATUS_UPDATE") {
		                sectionTrans = true;
		            }
		          if (privilege === "BULK_HOSTEL_ALLOCATION") {
			                sectionCreat = true;
			            }
		        });

		        var panelItem = new Array();
		        var $this = this;
		        var newcont = structure.items.items.length;
		        var insertPosition = newcont;
		        panelItem.push({
		            xtype:'tabpanel',
		            plain: true,
		            style:{overflow:'hidden !important',margin:'0!important'},
		            bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
		            frame: false,
		            border:false,
		            defaults: {
		                labelAlign: 'top'
		            },
		            items:[{
			style:{
				marginLeft:'0px !important',
				marginTop:'0px !important'},
				bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},	
			frame: false,
			border:false,
			cls: 'noPaddingPanel',
			title :getCommonTranslation('SEARCH'),  
			xtype:'panel',
			items : [{
				xtype: 'hostelappstdsearchstructure',
				itemId: 'hostelappstdsearchstructureItemId',
			}]
		}
		]
		        });
		        var insertAt = panelItem["0"].items.length;;
		  var arrayImport = [];
		        if (sectionTrans) {
		            /*panelItem["0"].items[insertAt] = {
		                    xtype: 'bulkresisdenceapplicantstatusupdate',
		                    itemId :'BulkResisdenceApplicantStatusUpdate',
							title:getCommonTranslation('BULK_HOSTEL_APPLICATION_STATUS')
		            };
		            insertAt = insertAt + 1;*/
					arrayImport.push({
			    		name:getCommonTranslation('BULK_HOSTEL_APPLICATION_STATUS'),
			    		value:'bulkresisdenceapplicantstatusupdate'
			    	});
		        }
		       if (sectionCreat) {
				          /*  panelItem["0"].items[insertAt] = {
				                    xtype: 'bulkhostelallocation',
				                    itemId :'bulkhostelallocationId',
									title:getCommonTranslation('BULK_HOSTEL_ALLOCATION'),
				            };
				            insertAt = insertAt + 1;*/
							arrayImport.push({
				        		name:getCommonTranslation('BULK_HOSTEL_ALLOCATION'),
				        		value:'bulkhostelallocation'
				        	});
				        }
		               if (arrayImport.length){
		    	   panelItem["0"].items[insertAt] = {
		    			   xtype: 'hostelImportView',
		    			   title: getAdmissionTranslation('IMPORT')

		    	   };
		    	   insertAt = insertAt + 1;
		       }
		        structure.insert(insertPosition, panelItem);
						var customImportUserPanelId = structure.down('#customImportHostelPanelId');
						var reportParantNode = customImportUserPanelId.getStore().tree.root;
						if (reportParantNode.hasChildNodes()) {
							reportParantNode.removeAll();
						}
						arrayImport.forEach(function(rec){
							reportParantNode.appendChild({
								text: rec.name,
								reportXtype:  rec.value,
								reportXtypeItemId: rec.value,
								leaf: true
							});
						});
		    },
		
	  	  getManageEntryDownload:function(record,obj){
        	  var form = this.getDownloadApplicantLoaderForm();
        	  var values = form.getValues();
    	      var applicantType = form.down("#applicantType").getValue();
    	      var year = form.down("#YearId").getValue();
    	      var location = form.down("#locationNameItemId").getValue();
    	      var waitingList = form.down("#waitingList").getValue();
    	      
//    	     var yearIds =  Ext.Array.pluck(Ext.Array.pluck(values.year, 'data'), 'id').join();
//             
//    	    var YearIds = yearIds.toString();
        	var csvForm = Ext.create('Ext.form.Panel'); 
        	
        		csvForm.getForm().submit({
        			target: '_blank',
        			method:'POST',
        			params :{
        				academyLocationIds:location ? location:null,
        				yearIds:year,
        				applicationType:applicantType,
        				waitingListId:waitingList ? waitingList:null,
        				access_token : Ext.Ajax.defaultHeaders.access_token		
        			},
        			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        			url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_HOSTEL_APPLICANT_STATUS_UPDATE,
        			standardSubmit :true
        		});
        		
        		 
  		        },
  		        
  		  	  getBulkHostelAllocation:function(record,obj){
  	        	  var form = this.getDownloadallocationloaderform();
  	        	  var values = form.getValues();
  	    	      var applicantType = form.down("#applicantType").getValue();
  	    	      var year = form.down("#YearId").getValue();
  	    	      var location = form.down("#locationItemId").getValue();
  	    	      var waitingList = form.down("#waitingList").getValue();
  	    	      var applicationStatus = form.down("#applicationStatusId").getValue();
  	    	      var radioButton = form.down("#eventQuestionGroupId");
  	    	      var applicableFor = radioButton.lastValue.studentHostel;
  	    	     
  	    	      var applicantYear = form.down('#applicantYear').getValue()
	 			  var radioButtonValue = radioButton.lastValue.studentHostel;
	 			  var typeItem = form.down('#typeItemId').getValue();
	 			  var listIdName = form.down('#listIdNameId').getValue();
	 			  var hostelLevel = form.down('#hostelLevelItemId').getValue();
	 			  if(radioButtonValue == 'APPLICANT'){
//	 				  var yearIds =  Ext.Array.pluck(Ext.Array.pluck(values.year, 'data'), 'id').join();
	 				  var YearIds = year; 				  
	 			  }else {
	 				 var YearIds = applicantYear; 
	 			  }
  	    	    
  	        	var csvForm = Ext.create('Ext.form.Panel'); 
  	        	
  	        		csvForm.getForm().submit({
  	        			target: '_blank',
  	        			method:'POST',
  	        			params :{
  	        				academyLocationIds:location ? location:null,
  	        				yearIds:YearIds,
  	        				applicationStatus:applicationStatus,
  	        				applicationType:applicantType,
  	        				waitingListId:waitingList ? waitingList:null,
  	        				applicableFor:applicableFor,
  	        				listIdName:listIdName,
  	        				type:typeItem,
  	        				hostelLevel:hostelLevel,
  	        				access_token : Ext.Ajax.defaultHeaders.access_token	
  	        			},
  	        			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
  	        			url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_HOSTEL_ALLOCATION,
  	        			standardSubmit :true
  	        		});
  	        		
  	        		 
  	  		        },
  	  		  	getImportListDownloadFile : function(documentId,fileType){

  	 		    	if(!isNullOrEmpty(documentId)){
  	 		    		var csvForm = Ext.create('Ext.form.Panel'); 
  	 		    		csvForm.getForm().submit({
  	 		    			target: '_blank',
  	 		    			method:'POST',
  	 		    			params :{
  	 		    				access_token : Ext.Ajax.defaultHeaders.access_token
  	 		    			},
  	 		    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
  	 		    			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
  	 		    			standardSubmit :true
  	 		    		});
  	 		    	}
  	 		    },
waitingListStoreFun:function(applicantTypeId,YearId, listIdNameId,locationItemId){
	var form = this.getDownloadallocationloaderform();
	var radioButton = form.down("#eventQuestionGroupId") ;
	var radioButtonValue = radioButton.lastValue.studentHostel;

	var applicantType = form.down("#"+applicantTypeId).getValue();
	var Year =  form.down("#"+YearId).getValue();
	var location = form.down("#"+locationItemId).getValue();


	var listIdName = form.down("#"+listIdNameId);
	listIdName.reset();
	var listIdNameStore = listIdName.getStore();
	var param;

	if(radioButtonValue == 'APPLICANT'){
		delete listIdNameStore.getProxy().extraParams.academyLocationId;
		param = {
				locationId:location,
				hostelApplicationType:applicantType,
				academicTerm:Year
		}
	}else {
		delete listIdNameStore.getProxy().extraParams.locationId;
		param = {
				academyLocationId:location,
				hostelApplicationType:applicantType,
				academicTerm:Year
		}
	}

	listIdNameStore.getProxy().extraParams = param;	
	listIdNameStore.load();
},
cancelOfferLater:function(status){
	var me = this,cancelArray=[],
	hostelGrid =me.getHostelapplicationapplicantlistgrid(),
	selectedRec = hostelGrid.getSelectionModel().getSelection();
	showConfirmMessage(getHostelTranslation("CANCEL_OFFER_LETTER"), getHostelTranslation("CANCEL_THE_ISSUED_OFFER_LETTER"), function(btn, text) {
        if (btn == "yes") {
        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        	
        	selectedRec.forEach(function(rec){
        		cancelArray.push({
        			id:rec.data.applicantHostelRequiredId,
        		applicationStatus:"OFFER_LETTER_REVOKED"	
        		})
        	});
        	var formData = Ext.encode(cancelArray);
        	Ext.Ajax.request({
				type : 'rest',
				url : SERVERURL.PATH_UPDATE_HOSTEL_REQUIREMENT_DETAIL_STATUS,
				method : 'POST',
				jsonData : formData,
				success : function(frm, action) {
					Ext.getBody().unmask(); 
							showSuccessMessage(getHostelTranslation('SUCCESS'), getHostelTranslation('HOSTEL_APPLICATION_OFFER_LETTER_CANCELLED'));
					hostelGrid.getStore().load();
				}
			});
        }
    })
	
},
acceptHostelApplicants:function(status){
	var me = this,acceptArray=[],
	hostelGrid =me.getHostelapplicationapplicantlistgrid(),
	selectedRec = hostelGrid.getSelectionModel().getSelection();
	showConfirmMessage(getHostelTranslation("ACCEPT_OFFER_LETTER"), getHostelTranslation("ACCEPT_THE_ISSUED_OFFER_LETTER"), function(btn, text) {
        if (btn == "yes") {
        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        	selectedRec.forEach(function(rec){
        		acceptArray.push({
        			id:rec.data.applicantHostelRequiredId,
        		applicationStatus:"OFFER_LETTER_ACCEPTED"	
        		})
        	});
        	var formData = Ext.encode(acceptArray);
        	Ext.Ajax.request({
				type : 'rest',
				url : SERVERURL.PATH_UPDATE_HOSTEL_REQUIREMENT_DETAIL_STATUS,
				jsonData : formData,
				method : 'POST',
				success : function(frm, action) {
					Ext.getBody().unmask(); 
							showSuccessMessage(getHostelTranslation('SUCCESS'), getHostelTranslation('HOSTEL_APPLICATION_OFFER_LETTER_ACCEPTED'));
					hostelGrid.getStore().load();
				}
			});
        }
    })
	
},
doAccessControlCustomHosteApplication:function(grid,permissionsMap){
	var associatedAcadLocationIds = new Array();
	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

	var alloteRoomBtn = grid.down('#btnAllotRoom');
	var applyRuleBtn = grid.down('#btnApplyRule');
	var rejectApplicationBtn = grid.down('#btnRejectApplication');
	var spBtnMoreActions = grid.down('#spBtnMoreActions');
	var sendOfferLetter = grid.down('#sendOfferLetter');
	var cancelOfferLetter = grid.down('#cancelOfferLetter');
	var acceptOfferLetter = grid.down('#acceptOfferLetter');
	var allocatedApplicationHostel = grid.down('#allocatedApplicationHostel');
	var cancelApplicationHostel = grid.down('#cancelApplicationHostel');
	alloteRoomBtn.setVisible(false);
	applyRuleBtn.setVisible(false);
	rejectApplicationBtn.setVisible(false);
	spBtnMoreActions.setVisible(false);
	sendOfferLetter.setVisible(false);
	cancelOfferLetter.setVisible(false);
	acceptOfferLetter.setVisible(false);
	allocatedApplicationHostel.setVisible(false);
	cancelApplicationHostel.setVisible(false);
	
	Ext.each(permissionList, function(privilege) {
		if (privilege === 'ALLOTEROOM') {
			alloteRoomBtn.setVisible(true);
    	}
		if (privilege === 'APPLY_RULE') {
			applyRuleBtn.setVisible(true);
    	}
		if (privilege === 'REJECTAPPLICATION') {
			rejectApplicationBtn.setVisible(true);
    	}
		if (privilege === 'MOREACTIONS') {
			spBtnMoreActions.setVisible(true);
    	}
		if (privilege === 'SEND_OFFER_LETTER') {
			sendOfferLetter.setVisible(true);
    	}
		if (privilege === 'REVOKE_OFFER_LETTER') {
			cancelOfferLetter.setVisible(true);
    	}
		if (privilege === 'ACCEPT_OFFER') {
			acceptOfferLetter.setVisible(true);
    	}
		if (privilege === 'ALLOCATED_RESIDENCE') {
			allocatedApplicationHostel.setVisible(true);
    	}
		if (privilege === 'CANCEL_RESIDENCE_ALLOCATION') {
			cancelApplicationHostel.setVisible(true);
    	}

	});

},
cancelHostelApplicants:function(status){
	var me = this,acceptArray=[],
	hostelGrid =me.getHostelapplicationapplicantlistgrid(),
	selectedRec = hostelGrid.getSelectionModel().getSelection();
	showConfirmMessage(getCommonTranslation("CANCEL_HOSTEL_ALLOCATION"), getHostelTranslation("CANCEL_THE_ALLOCATION"), function(btn, text) {
        if (btn == "yes") {
        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        	selectedRec.forEach(function(rec){
        		acceptArray.push({
        			id:rec.data.applicantHostelRequiredId,
        		applicationStatus:"UNALLOCATED"	
        		})
        	});
        	var formData = Ext.encode(acceptArray);
        	Ext.Ajax.request({
				type : 'rest',
				url : SERVERURL.PATH_UPDATE_HOSTEL_REQUIREMENT_DETAIL_STATUS,
				jsonData : formData,
				method : 'POST',
				success : function(frm, action) {
					Ext.getBody().unmask(); 
							showSuccessMessage(getHostelTranslation('SUCCESS'), getHostelTranslation('HOSTEL_ALLOCATION_CANCELED_SUCCESSFULLY'));
					hostelGrid.getStore().load();
				}
			});
        }
    })
	
},
allocatedHostelApplicants:function(status){
	var me = this,acceptArray=[],
	hostelGrid =me.getHostelapplicationapplicantlistgrid(),
	selectedRec = hostelGrid.getSelectionModel().getSelection(),
	residenceForm= me.getResidenceAllocationWin();
      	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        	selectedRec.forEach(function(rec){
        		acceptArray.push({
        			id:rec.data.applicantHostelRequiredId,
        		applicationStatus:"ALLOCATED",
        		"wsAllocatedBy":{
        			id:residenceForm.down('#allocatedBy').getValue()
        		},
        		"wsResource":{
        			category:"INTERNAL",
        			id:residenceForm.down('#hostelCode').getValue()
        		}
        		})
        	});
        	var formData = Ext.encode(acceptArray);
        	Ext.Ajax.request({
				type : 'rest',
				url : SERVERURL.PATH_UPDATE_HOSTEL_REQUIREMENT_DETAIL_STATUS,
				jsonData : formData,
				method : 'POST',
				success : function(frm, action) {
					Ext.getBody().unmask(); 
					residenceForm.close();
							showSuccessMessage(getHostelTranslation('SUCCESS'), getHostelTranslation('HOSTEL_APPLICATION_ALLOCATION_SUCCESSFULLY'));
					hostelGrid.getStore().load();
				},failure: function(response, action) {
					Ext.getBody().unmask(); 
					if(!isNullOrEmpty(response.responseText)) {
		        		var data = Ext.decode(response.responseText);
		        		if(isArray(data)){
		        			if(data[0].key!=undefined && data[0].key.indexOf('HOSTEL_CAPACITY_ALREADY_EXHAUSTED_FOR_APPLICANT') > -1) {
		        				var subString = data[0].key.substring(48);
		        				var hostelAndYearData = subString.split(' :_--_: ');
		        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('HOSTEL_CAPACITY_OF') + ' ' + hostelAndYearData[0] 
		        					+ ' ' + getCommonTranslation('ALREADY_EXHAUSTED_FOR_THE_RESIDENCE_APPLICATION_ACADEMIC_TERM') + ' ' + hostelAndYearData[1]);
		        				return false;
		        			}
		        		}
		        	}
				}
			});
},
sendOfferLater:function(btn){
	var me = this,acceptArray=[],
	offerForm =me.getHostelIssueOfferLatter(),
	hostelGrid =me.getHostelapplicationapplicantlistgrid(),
	selectedRec = hostelGrid.getSelectionModel().getSelection(),
	formRec = offerForm.down('form').getValues(),
	offerExpiryDate = !isNullOrEmpty(offerForm.down('#offerExpiryDate').getValue()) ? offerForm.down('#offerExpiryDate').getValue() : null;
      	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        		params={
	        			applicantHostelRequirementId:selectedRec[0].data.applicantHostelRequiredId,
		        		"location":{
		        			id:formRec.locationId
		        		},
		        		"hostelStudentCategory":{
		        			id:formRec.depositCategory
		        		},
		        		"reservationCategory":{
		        			id:formRec.reservationCategory
		        		},
		        		"offerLetterExpiryDate":formRec.offerExpiryDate ? formRec.offerExpiryDate : offerExpiryDate
        		}
        		var formData = Ext.encode(params);
        		Ext.Ajax.request({
    				type : 'rest',
    				url : SERVERURL.PATH_FIND_ISSUE_OFFER_LETTER_CERP_HOSTEL_APPLICATION_APPLICANT,
    				jsonData : formData,
    				method : 'POST',
    				success : function(frm, action) {
    					Ext.getBody().unmask(); 
    					hostelGrid.getStore().load();
    					showSuccessMessage(getHostelTranslation('SUCCESS'), getHostelTranslation('HOSTEL_APPLICATION_OFFER_LETTER_SUCCESSFULLY'));
    					btn.up('window').close();
    				}
    			});
},
getOpenhostelReportStructure:function(treePanel, record, item,index){
	var $this = this;
	var containpanel = $this.getHostelImportStructure();
	var treePanel = containpanel.down('#customImportHostelPanelId');
	var tabDetail = record.data;
	var structure = Ext.widget(tabDetail.reportXtype);
	var tabstructure = containpanel.down('#hostelImportTabpanelIds');

	if (!isNullOrEmpty(tabDetail.text)
			&& !isNullOrEmpty(tabDetail.reportXtype)
			&& !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
		treePanel.toggleCollapse();
		openTab(tabstructure, tabDetail.text,structure);
		treePanel.getSelectionModel().deselectAll();
	}
}
  	 		 

});


