/**
 * This controller is used for the Biometric Machine IntegrationController Add/Edit/Delete/View

 * 
 * @author Deepak Sharma
 */
Ext.define('Academia.controller.hrm.BiometricMachineIntegrationController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['user.UserAcademyLocationStore','hrm.biometric.BMIActionStore','hrm.biometric.BMIMachineIDStore', 'hrm.biometric.BMIMachineNameStore',
    		'hrm.biometric.BMIResourceTypeStore','hrm.biometric.BMIResourceNameByTypeStore',
    	'program.ProgramByGroupIdStore', 'program.programbatchdetail.BatchStore', 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
    	'programCourseDashboard.CoursesByBatchStore', 'attendance.SectionAndFacultyByPeriodID','hrm.biometric.BMIMachineAcademyLocationStore',
    	'importutility.ModuleName', 'userGroup.UserGroupStore', 'department.ParentDepartmentByAccesibleStore', 'common.DesignationTypeStore', 'scholarships.AssociateProgramStore',
    	'feeandpayment.ProgramSmartSearchStore', 'enquiry.AcademicBatchStore','department.ParentDepartmentByAccesibleStore','importutility.ImportBiometricMachineIntegrationStore',
    	'hrm.biometric.BMIResourceGroupStore', 'hrm.biometric.BMIGridStore', 'hrm.biometric.BMIDetailsALStore','hrm.biometric.BMIResourceDetailsStore',
    	'hrm.biometric.BMIMachineDetailsStore','hrm.biometric.BMIFormResourceGridStore', 'hrm.biometric.BMIAttendanceMachineUserMappingStore'],
    views: ['hrm.biometric.BMIStructure','hrm.biometric.BMITabStructure',
    		'hrm.biometric.BMIFilter','hrm.biometric.BMIGrid','hrm.biometric.BMIForm',
    		'hrm.biometric.BMIFilter','hrm.biometric.BMIGrid','hrm.biometric.BMIBulkImportStructure','hrm.biometric.BMIUploadForm','hrm.biometric.BMIStudentDownloadForm',
    		'hrm.biometric.BMIDownloadForm','hrm.biometric.BMIUploadForm', 'hrm.biometric.BMIEmployeeDownloadForm',
    		'importutility.ImportByModule.ImportListBiometricMachineIntegrationGrid','UploadOptionRadioGroup','hrm.biometric.BMIAcademyLocationWin','hrm.biometric.BMIDetailsALGrid',
    		'hrm.biometric.BMIResourceDetailWin','hrm.biometric.BMIResourceDetailsGrid',
    		'hrm.biometric.StudentBMIMachineDetailsStructure',
    		'hrm.biometric.BMIMachineDetailsGrid','personinfo.common.PersonDetailsLinkPanel',
    		'hrm.biometric.FacultyBMIMachineDetailsStructure','hrm.biometric.BMIFormResourceGrid','hrm.biometric.BMIFormResourceWin','hrm.biometric.BMIAttendanceMachineUserMappingWin'],
    models: ['hrm.biometric.BMIMachineDetailsModel','hrm.biometric.BMIFormResourceGridModel'],
    refs: [{
        ref: 'contentpanel',
        selector: 'contentpanel'
    }, {
    	ref : 'bmistructure',
    	selector : 'bmistructure'
    },{
    	ref : 'bmifilter',
    	selector : 'bmifilter'
    },{
    	ref : 'bmigrid',
    	selector : 'bmigrid'
    },{
    	ref : 'bmiform',
    	selector : 'bmiform'
    },{
    	ref : 'bmibulkimportstructure',
    	selector : 'bmibulkimportstructure'
    },{
    	ref : 'bmidownloadform',
    	selector : 'bmidownloadform'
    },{
    	ref : 'bmistudentdownloadform',
    	selector : 'bmistudentdownloadform'
    },{
    	ref : 'bmiemployeedownloadform',
    	selector : 'bmiemployeedownloadform'
    },{
    	ref : 'importlistbiometricmachineintegrationgrid',
    	selector : 'importlistbiometricmachineintegrationgrid'
    },{
    	ref : 'bmiuploadform',
    	selector : 'bmiuploadform'
    },{
    	ref : 'bmiacademylocationwin',
    	selector : 'bmiacademylocationwin'
    },{
    	ref : 'bmidetailsalgrid',
    	selector : 'bmidetailsalgrid'
    },{
    	ref : 'bmiresourcedetailwin',
    	selector : 'bmiresourcedetailwin'
    },{
    	ref : 'bmiresourcedetailsgrid',
    	selector : 'bmiresourcedetailsgrid'
    },{
    	ref : 'studentbmimachinedetailsstructure',
    	selector : 'studentbmimachinedetailsstructure'
    },{
    	ref : 'studentbmimachinedetailsgrid',
    	selector :'bmimachinedetailsgrid[itemId=studentbmimachinedetailsgridItemId]'
    },{
    	ref : 'facultybmimachinedetailsgrid',
    	selector : 'bmimachinedetailsgrid[itemId=facultybmimachinedetailsgridItemId]'
    },{
    	ref : 'facultybmimachinedetailsstructure',
    	selector : 'facultybmimachinedetailsstructure'
    },{
    	ref : 'bmiformresourcegrid',
    	selector :'bmiformresourcegrid'
    },{
    	ref : 'bmiformresourcewin',
    	selector :'bmiformresourcewin'
    }, {
    	ref : 'bmiattendancemachineusermappingwin',
    	selector :'bmiattendancemachineusermappingwin'
    }],
    config: {
    	STUDENT_BM_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_BM_DETAILS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_BM_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_BM_DETAILS_PRIVILEGES'),
    	EMPLOYEE_BM_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_BM_DETAILS_PRIVILEGES')
    },
   
    init: function() {
        this.control({
        	'bmigrid button[itemId=btnAdd]':{
    			click: this.addBMIRecord
    		},
    		'bmigrid button[itemId=btnEdit]': {
    			click: function() {
    				this.editBMIForm("edit");
    			}
    		},
    		'bmigrid button[itemId=btnDelete]': {
    			click: function() {
    				this.deleteBiometricMachine();
    			}
    		},
    		'bmigrid button[itemId=btnView]': {
    			click: function() {
    				this.editBMIForm("view");
    			}
    		},
        	'bmifilter combo#academyLocationItemId': {
                render: function(obj) {
                    var store = obj.getStore();
                	var user=this.getCurrentlyLoggedInUser();
                    store.getProxy().extraParams = {
                        id: user.id
                    };
                    store.load();
                }
            },
            
            'bmifilter button[itemId=searchBMIFilterItemId]': {
    			click: this.loadBmiGrid
    		},
    		'bmifilter button[itemId=resetBMIFilterItemId]': {
    			click: this.resetBMIFilter
    		},
    		'bmifilter combo#resourceTypeItemId': {
    			select: function(obj, record) {
    				var filter = this.getBmifilter().getForm();
    				var resourceNameItemId = this.getBmifilter().down("#resourceNameItemId");
    				resourceNameItemId.setDisabled(false);
    				resourceNameItemId.reset();
    				var store = resourceNameItemId.getStore();
                    store.getProxy().extraParams = {
                    	resourceTypeId: obj.getValue()
                    };
                    store.proxy.limitParam=null;
                    store.load();
    			}
    		},
    		'bmiformresourcewin customcombobox#resourceTypeItemIdForm':{
    			select: function(combo) {
    				var me = this;
    				this.selectResourceTypeInCtl(combo,me);
    			},
    			render : function(combo){
    				var me = this;
    				combo.getStore().removeAll();
    				//var alForm = me.getBmiformresourcewin().down('form');
    				//combo.setDisabled(false);
    				me.setAllowBlank(combo,false);
    			}
    		},
    		'bmiformresourcewin customcombobox#academyLocationId':{
    			change: this.selectAcademyLocationInCtl
    		},
    		'bmiformresourcewin customcombobox#cmbResourceGroup':{
    			change: this.selectResourceGroupCombo
    		},
    		'bmiform button[itemId=resetBtnBMI]':{
    			click: function(obj){
    				var $this = this;
    				var grid = this.getBmiformresourcegrid();
    				var form = $this.getBmiform();
    				form.getForm().reset();
    				grid.getSelectionModel().deselectAll();
    			}
    		},
    		
    		'bmiform button[itemId=submitBtnBMI]':{
    			click: function(btn){
    				var $this = this;
    				$this.saveBMIForm(btn);
    			}
    		},
    		'bmibulkimportstructure radiogroup[itemId=importBulkGroupIdAS]':{
    			change: this.bmiDownloadUploadRadioChange
    		},
    		'bmidownloadform radiogroup[itemId=bmiStudentEmployeeDownloadForm]':{
    			change: this.bmiStudentEmployeeRadioChange
    		},
    		'bmidownloadform[itemId=bmidownloadformformItemId] button[itemId=downoladBtnIdAS]':{
        		click:function(obj){
        			var $this = this;
        			var form =$this.getBmidownloadform();
        			var studentEmployeeDownloadForm = form.down('#bmiStudentEmployeeDownloadForm').getValue();
        			if(studentEmployeeDownloadForm.studentEmployeeDownloadTemplate == 'studentTemplate') {
        				var studentDownloadForm = form.down('#bmistudentdownloadformItemId');
        				var machineId = studentDownloadForm.down('#machineName').getValue();
        				var machineName = studentDownloadForm.down('#machineName').rawValue;
        				var academyLocationId = studentDownloadForm.down('#lmAcademyLocationComboAS').getValue();
        				/*var programId = studentDownloadForm.down('#program').getValue();
        				var batchId = studentDownloadForm.down('#batch').getValue();
        				var periodId = studentDownloadForm.down('#period').getValue();
        				var courseId = studentDownloadForm.down('#course').getValue();
        				var sectionId = studentDownloadForm.down('#section').getValue();*/
        				
        				var csvForm = Ext.create('Ext.form.Panel');
            			csvForm.getForm().submit({
    	  	        		  target: '_blank',
    	  	        		  method:'POST',
    	  	        		  params :{
    	  	        			  access_token : Ext.Ajax.defaultHeaders.access_token,
    	  	        			  userType : 'student',
    	  	        			  machineId : machineId,
    	  	        			  machineName : machineName,
    	  	        			  academyLocationId : academyLocationId,
    	  	        			 //programId : programId,
    	  	        			 // batchId : batchId,
    	  	        			 // periodId : periodId,
    	  	        			 // courseId : courseId,
    	  	        			 // sectionId : sectionId
    	  	        		  },
    	  	        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    	  	        		  url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_BIOMETRIC_USERS,
    	  	        		  standardSubmit :true,
    	  	        		  success : function(form, action){
    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
    	    	          },
    	        		  failure: function(form, action) {
    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
    	    	          }
    	  	        	  });
        			} else if(studentEmployeeDownloadForm.studentEmployeeDownloadTemplate == 'employeeTemplate'){
        				
        				var employeeDownloadForm = form.down('#bmiemployeedownloadformItemId');
        				var machineId = employeeDownloadForm.down('#machineName').getValue();
        				var academyLocationId = employeeDownloadForm.down('#lmAcademyLocationComboAS').getValue();
        				var userGroupId = employeeDownloadForm.down('#lmUserGroupTypeAS').getValue();
        				var departmentId = employeeDownloadForm.down('#lmDepartmentAS').getValue();
        				var designationId = employeeDownloadForm.down('#lmDesignationComboAS').getValue();
        				var machineName = employeeDownloadForm.down('#machineName').rawValue;
        				var csvForm = Ext.create('Ext.form.Panel');
            			csvForm.getForm().submit({
    	  	        		  target: '_blank',
    	  	        		  method:'POST',
    	  	        		  params :{
    	  	        			  access_token : Ext.Ajax.defaultHeaders.access_token,
    	  	        			  userType : 'employee',
    	  	        			  machineId : machineId,
    	  	        			  machineName : machineName,
    	  	        			  academyLocationId : academyLocationId,
    	  	        			  userGroupId : userGroupId,
    	  	        			  departmentId : departmentId,
    	  	        			  designationId : designationId,
    	  	        		  },
    	  	        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    	  	        		  url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_BIOMETRIC_USERS,
    	  	        		  standardSubmit :true,
    	  	        		  success : function(form, action){
    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
    	    	          },
    	        		  failure: function(form, action) {
    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
    	    	          }
    	  	        	  });
        			}
        		}

          },
          'bmistudentdownloadform customcombobox[itemId=machineName]' :{
        	  select : function(record) {
        		 var attendanceMachineId = record.getValue();
                 var form = this.getBmistudentdownloadform();
                 var alCombo = form.down('#lmAcademyLocationComboAS');
                 alCombo.reset();
                 var store = alCombo.getStore();
                 store.getProxy().extraParams = {
                	 id: attendanceMachineId
             	};
                 store.load();
                 alCombo.setDisabled(false);
                 form.down('#downoladBtnIdAS').setDisabled(true);
        	  }
          },
          'bmistudentdownloadform customcombobox[itemId=lmAcademyLocationComboAS]' :{
        	  select : function(record) {
        		  var academyLocationId = record.getValue();
        		  var form = this.getBmistudentdownloadform();
        		  form.down('#downoladBtnIdAS').setDisabled(false);
        	  }
          },
          'bmistudentdownloadform button[itemId=resetBtnAS]' :{
        	  click : function(){
                  var form = this.getBmistudentdownloadform();
                  form.getForm().reset();
                  var alCombo = form.down('#lmAcademyLocationComboAS');
                  form.down('#downoladBtnIdAS').setDisabled(true);
                  alCombo.setDisabled(true);
        	  }
          },
         /* 'bmistudentdownloadform customcombobox[itemId=lmAcademyLocationComboAS]' :{
        	  select : function(record) {
        		 var academyLocationId = record.getValue();
                 var form = this.getBmistudentdownloadform();
                 var programCombo = form.down('#program');
                 var store = programCombo.getStore();
                 store.getProxy().extraParams = {
                	 academyLocationId: academyLocationId
             	};
                 store.load();
        	  }
          },
          'bmistudentdownloadform customcombobox[itemId=program]' :{
        	  select : function(record) {
        		 var programId = record.getValue();
                 var form = this.getBmistudentdownloadform();
                 var batchCombo = form.down('#batch');
                 var store = batchCombo.getStore();
                 store.getProxy().extraParams = {
                	 id: programId,
                	 isActive : true
             	};
                 store.load();
        	  }
          },
          'bmistudentdownloadform customcombobox[itemId=batch]' :{
        	  select : function(record) {
        		 var batchId = record.getValue();
                 var form = this.getBmistudentdownloadform();
                 var periodCombo = form.down('#period');
                 var store = periodCombo.getStore();
                 store.getProxy().extraParams = {
                	 id: batchId,
             	};
                 store.load();
        	  }
          },
          'bmistudentdownloadform customcombobox[itemId=period]' :{
        	  select : function(record) {
        		 var periodId = record.getValue();
                 var form = this.getBmistudentdownloadform();
                 var courseCombo = form.down('#course');
                 var store = courseCombo.getStore();
                 store.getProxy().extraParams = {
                	 periodId: periodId,
             	};
                 store.load();
                 var sectionCombo = form.down('#section');
                 var sectionStore = sectionCombo.getStore();
                 sectionStore.getProxy().extraParams = {
                	 periodId: periodId,
             	};
                 sectionStore.load();
        	  }
          },*/
          'bmiemployeedownloadform customcombobox[itemId=machineName]' :{
        	  select : function(record) {
        		 var attendanceMachineId = record.getValue();
                 var form = this.getBmiemployeedownloadform();
                 var alCombo = form.down('#lmAcademyLocationComboAS');
                 alCombo.reset();
                 var store = alCombo.getStore();
                 store.getProxy().extraParams = {
                	 id: attendanceMachineId
             	};
                 store.load();
                 alCombo.setDisabled(false);
                 form.down('#downoladBtnIdAS').setDisabled(true);
        	  }
          },
          'bmiemployeedownloadform customcombobox[itemId=lmAcademyLocationComboAS]' :{
        	  select : function(record) {
        		  var academyLocationId = record.getValue();
        		  var form = this.getBmiemployeedownloadform();
        		  form.down('#downoladBtnIdAS').setDisabled(false);

        	  }
          },
          'bmiemployeedownloadform button[itemId=resetBtnAS]' :{
        	  click : function(){
                  var form = this.getBmiemployeedownloadform();
                  form.getForm().reset();
                  var alCombo = form.down('#lmAcademyLocationComboAS');
                  form.down('#downoladBtnIdAS').setDisabled(true);
                  alCombo.setDisabled(true);
        	  }
          },
          'bmiuploadform button[itemId=resetBtnASUpload]':{
       	   click:function(obj){
       		   var $this=this;
       		   var form = $this.getBmiuploadform().getForm();
       		   form.findField('file').reset();
       		   form.isValid();
       	   },
       	   render: function(obj) {
			        var $this = this;
			        var form = obj.up('bmiuploadform').getForm();
			        var combo = form.findField('importUtilityMasterId');
			        combo.getStore().load({
			            callback: function(records, operation, success) {
			                for (var i in records) {
			                    if (records[i].data.value == 'Bulk Biometric Users') {
			                        combo.setValue(records[i].data.id);
			                        combo.setReadOnly(true);
			                        break;
			                    }
			                }
			            }
			        });
			    }
          },
          'bmiuploadform[itemId=bmiuploadformItemId] button[itemId=bmiUpload]' : {
        	  click : function(obj) {
			        var $this = this;
			        var grdStore;
			        var form = obj.up('bmiuploadform');
			        submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
    	        	$this.getHashOfFile(form);
		        	setTimeout(function() {
				        form.getForm().submit({
				            method: 'POST',
				            url: submitUrl,
				            success: function(form, action) {
				                showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
				            },
				            failure: function(form, action) {
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
				            }
				        });
		        	},1000);
			        Ext.defer(function() {
			            var grid = $this.getImportlistbiometricmachineintegrationgrid();
			            grid.getStore().getProxy().extraParams = {
			                moduleName: 'Bulk Biometric Users'
			            };
			            grid.getStore().load();
			        }, 2000, this);
        	  }
          },
          'importlistbiometricmachineintegrationgrid' : {
        	  render : function() {
        		  var $this = this;
        		  var grid = $this.getImportlistbiometricmachineintegrationgrid();
        		  grid.getStore().getProxy().extraParams = {
        			  moduleName: 'Bulk Biometric Users'
        		  };
        		  grid.getStore().load();
        	  },
        	  cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        		  if (e.target.tagName == 'A') {
        			  var fileType = null;
        			  if (cellIndex == 1) {
        				  fileType = 'successFile';
        			  } else if (cellIndex == 6) {
        				  fileType = 'errorFile';
        			  } else if (cellIndex == 7) {
        				  fileType = 'logFile';
        			  }
        			  var documentId = record.get("id");
        			  if (!isNullOrEmpty(documentId)) {
        				  this.getBMIDownloadFile(documentId, fileType);
        			  }
        		  }
        	  }
          },
          'importlistbiometricmachineintegrationgrid button[itemId=btnForce]': {
			    click: function(obj) {
			        var grid = this.getImportlistbiometricmachineintegrationgrid();
			        if (grid.getSelectionModel().getCount() > 0) {
			            if (grid.getSelectionModel().getCount() > 1) {
			                showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
			            } else {
			                var this$ = this;
			                var id = grid.getSelectionModel().selectionStart.data.id;
			                console.log(id);
			                var urlAppend = "?jobName=" + id;
			                var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
			                Ext.Ajax.request({
			                    url: submitURL,
			                    method: 'GET',
			                    success: function(response) {
			                        if (response.responseText === "JOB_STATUS_NOT_PENDING") {
			                            showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
			                        } else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
			                            showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
			                        } else if (response.responseText === "SUCCESS") {
			                            showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
			                            grid.getStore().reload();
			                        }
			                    }
			                });
			            }
			        } else {
			            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			    }
			},
			'bmiform textfield#machineIdItemId': {
                blur: function(obj, record) {
                    var data = obj.getValue();
                    if (data) {
                    	if(!obj.readOnly){
                    		var $this = this;
            				var form = $this.getBmiform();
                            var idItemId = form.down("#idItemId");
                            var submitUrl = SERVERURL.BMI_FIND_MACHINE_ID_SEARCH + '?code=' + data;
                            
                            if (!isNullOrEmpty(idItemId.getValue())) {
                            	submitUrl = submitUrl +  '&id=' + idItemId.getValue();
                            }	
                            Ext.Ajax.request({
                                type: 'rest',
                                url: submitUrl,
                                method: 'GET',
                                success: function(response, action) {
                                    var responseData = Ext.decode(response.responseText);
                                    if (responseData.length > 0) {
                                    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BMI_MACHINE_ID_ALREADY_EXIST_MESSAGE'));
                                        form.down("#machineIdItemId").reset();
                                    }
                                }
                            });
                    	}
                    }
                }
            },
            'bmigrid': {
            	beforerender: function() {
                    this.getStore('hrm.biometric.BMIGridStore').removeAll();
                },
            	cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
            		if (e.target.tagName == 'A') {
            			var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
            			var $this = this;
            			
            			var filter = $this.getBmifilter();
            			var acadmyLocationId = filter.down('#academyLocationItemId').getValue();
            			var resourceTypeId = filter.down('#resourceTypeItemId').getValue();
            			var resourceId = filter.down('#resourceNameItemId').getValue();
            			var resourceGroupItemId = filter.down('#cmbResourceGroupItemId').getValue();

            			var grid = $this.getBmigrid();
            			if (columnName == 'academyLocationCount') {
            				var formWindow = $this.getBmiacademylocationwin();
            				if (!formWindow) {
            					Ext.widget('bmiacademylocationwin');
            					formWindow = $this.getBmiacademylocationwin();
            				}
            				formWindow.down('#machineIdWin').setValue(record.data.machineCode);
            				formWindow.down('#machineNameWin').setValue(record.data.machineName);

            				var bmidetailsalgrid = $this.getBmidetailsalgrid(),
            				store = bmidetailsalgrid.getStore();
            				store.getProxy().extraParams = {
            					academyLocationId :acadmyLocationId,
                				resourceTypeId : resourceTypeId,
                				resourceId : resourceId,
                				resourceGroup: resourceGroupItemId,
            					id: record.data.id
            				};
            				$this.resetPageSetting(store);
            				formWindow.show();
            				store.load();
            			}
            			else if(columnName == 'resourceCount'){
            				var formWindow = $this.getBmiresourcedetailwin();
            				if (!formWindow) {
            					Ext.widget('bmiresourcedetailwin');
            					formWindow = $this.getBmiresourcedetailwin();
            				}
            				formWindow.down('#machineIdWin').setValue(record.data.machineCode);
            				formWindow.down('#machineNameWin').setValue(record.data.machineName);

            				var bmiResourceDetailsGrid = $this.getBmiresourcedetailsgrid(),
            				store = bmiResourceDetailsGrid.getStore();
            				store.getProxy().extraParams = {
            					academyLocationId :acadmyLocationId,
                				resourceTypeId : resourceTypeId,
                				resourceId : resourceId,
                				resourceGroup: resourceGroupItemId,
            					id: record.data.id
            				};
            				$this.resetPageSetting(store);
            				formWindow.show();
            				store.load();

            			}
            		}
            	},
            	selectionchange: function(column, selected) {
            		var grid = this.getBmigrid();
            		if(selected.length== 1){ 
            			grid.down('#btnEdit').setDisabled(false);
            			grid.down('#btnView').setDisabled(false);
            		}
            		else{
            			grid.down('#btnEdit').setDisabled(true);
            			grid.down('#btnView').setDisabled(true);
            		}
            	}
            },
            'bmidetailsalgrid button[itemId=btnDelete]': {
                click: function() {
                	 var $this = this;
                    this.deleteBMIDetailGrid('AL', $this);
                }
            },
            'bmiresourcedetailsgrid': {
                render: function(grid) {
                	this.resetPageSetting(grid.getStore());
                }
            },
            'bmiresourcedetailsgrid button[itemId=btnDelete]': {
                click: function() {
                	 var $this = this;
                    this.deleteBMIDetailGrid('Resource', $this);
                }
            },
            'bmimachinedetailsgrid[itemId=studentbmimachinedetailsgridItemId] button[itemId=btnAdd]' : {
            	click : function(){
            		var studentProfile = this.getActiveTabfromContentPanel();
            		var grid = studentProfile.down('#studentbmimachinedetailsgridItemId');
            		this.showBmiAttendanceMachineUserMappingWin(grid, 'ADD');
            	}
            },
            'bmimachinedetailsgrid[itemId=studentbmimachinedetailsgridItemId] button[itemId=btnEdit]' : {
            	click : function(){
            		var studentProfile = this.getActiveTabfromContentPanel();
            		var grid = studentProfile.down('#studentbmimachinedetailsgridItemId');
            		var records = grid.getSelectionModel().getSelection();
            		if(records.length == 1) {
            			this.showBmiAttendanceMachineUserMappingWin(grid, 'EDIT');
            		} else {
            			showWarningMessage(getCommonTranslation('BMI_MACHINE_DETAILS_ON_PROFILE'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            		}
            	}
            },
            
            'bmimachinedetailsgrid[itemId=facultybmimachinedetailsgridItemId] button[itemId=btnAdd]' : {
            	click : function(){
            		var facultyprofile = this.getActiveTabfromContentPanel();
            		var grid = facultyprofile.down('#facultybmimachinedetailsgridItemId');
            		this.showBmiAttendanceMachineUserMappingWin(grid, 'ADD');
            	}
            },
            'bmimachinedetailsgrid[itemId=facultybmimachinedetailsgridItemId] button[itemId=btnEdit]' : {
            	click : function(){
            		var facultyprofile = this.getActiveTabfromContentPanel();
            		var grid = facultyprofile.down('#facultybmimachinedetailsgridItemId');
            		var records = grid.getSelectionModel().getSelection();
            		if(records.length == 1) {
            			this.showBmiAttendanceMachineUserMappingWin(grid, 'EDIT');
            		} else {
            			showWarningMessage(getCommonTranslation('BMI_MACHINE_DETAILS_ON_PROFILE'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            		}
            	}
            },
            'bmiattendancemachineusermappingwin customcombobox[itemId=attendanceMachineItemId]' : {
            	render : function(combo){
            		var grid = this.getGrid();   
            		this.loadAttendanceMachineOrGridStore(grid, combo);
            		
            	}
            },
            
            'bmiattendancemachineusermappingwin button[itemId=bmiUserMappingCancelButtonId]' : {
            	click : function(){
            		this.getBmiattendancemachineusermappingwin().close();            	
            	}
            },
            
            'bmiattendancemachineusermappingwin button[itemId=bmiUserMappingSaveButtonId]' : {
            	click : function(){
            		var grid = this.getGrid();
            		this.saveUserMapping(grid);            	}
            },
            
            'bmimachinedetailsgrid[itemId=studentbmimachinedetailsgridItemId]': {
            	render: function(grid) {
            		var portalId = this.getCurrentLoggedPortalId();
            		if(portalId == 1){
            			this.doAccessControlValidation(grid, this.getSTUDENT_BM_DETAILS_PERMISSIONS());
            		}else if(portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_BM_DETAILS_PERMISSIONS());
            		}

            		var studentProfile = this.getActiveTabfromContentPanel();
            		var grid = studentProfile.down('#studentbmimachinedetailsgridItemId');

            		this.loadAttendanceMachineOrGridStore(grid, grid);
            	},
            },
            'bmimachinedetailsgrid[itemId=facultybmimachinedetailsgridItemId]': {
            	render: function(grid) {
            		var portalId = this.getCurrentLoggedPortalId();
            		if(portalId == 1){
            			this.doAccessControlValidation(grid, this.getEMPLOYEE_BM_DETAILS_PERMISSIONS());
            		}

            		var facultyprofile = this.getActiveTabfromContentPanel();
            		var grid = facultyprofile.down('#facultybmimachinedetailsgridItemId');
            		this.loadAttendanceMachineOrGridStore(grid, grid);

            	},
            },
            'bmiformresourcegrid button[itemId=btnAdd]':{
    			click: this.addBMIFormResourceRecordWin
    		},
    		'bmiformresourcegrid button[itemId=btnEdit]':{
    			click: this.editBMIFormResourceRecordWin
    		},
    		'bmiformresourcegrid button[itemId=btnDelete]':{
    			click: function() {
    				this.deleteBMIFormResourceRecordWin();
    			}
    		},
    		'bmiformresourcewin button[itemId=bmiResourceSubmitBtnId]': {
    			click: function() {
    				this.submitResourceFormRecord();
    			}
    		},
    		'bmiformresourcewin button[itemId=bmiResourceCancelBtnId]': {
    			click: function() {
    				this.closeFormWindow();
    			}
    		},
    		'bmiform customcombobox#actionItemId':{
    			render: function(combo) {
    				combo.getStore().load();
            	}
    		},
    		'bmiformresourcegrid':{
    			selectionchange: function(column, selected) {
            		var grid = this.getBmiformresourcegrid();
            		if(selected.length== 1){ 
            			grid.down('#btnEdit').setDisabled(false);
            		}
            		else{
            			grid.down('#btnEdit').setDisabled(true);
            		}
            	}
    		}
        });
    },
    addBMIRecord:function(){

    	var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
    	var structure = Ext.widget('bmiform');
    	var tabName = getCommonTranslation('BMI_ADD_MACHINE');
    	/**
    	 * This is to remove tab from content panel and open same tab again
    	 */
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentPanel.remove(getTab, true);
    	}
    	var tabNameEdit = getCommonTranslation('BMI_EDIT_MACHINE');
		var getTabEdit=getcontroller.getTab(tabNameEdit);
		
		if(getTabEdit!=null){
			contentPanel.remove(getTabEdit, true);
		}
		
		var tabNameView = getCommonTranslation('BMI_VIEW_MACHINE');
		var getTabView=getcontroller.getTab(tabNameView);
		
		if(getTabView!=null){
			contentPanel.remove(getTabView, true);
		}
		
    	openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_THIRTEEN);
    	structure.down('#machineIdItemId').setReadOnly(false);
    	structure.down('#resetBtnBMI').show();
    	var grid = this.getBmiformresourcegrid(),
    	store = grid.getStore();
		store.removeAll();
    },
    editBMIForm:function(type){
    	var $this = this;
    	var contentPanel = this.getContentpanel(); 
    	var grid = $this.getBmigrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection();
    		if (records != "" && records != null && records != undefined) {
    			var tabName = getCommonTranslation('BMI_EDIT_MACHINE');
    			var structure = Ext.widget('bmiform');

    			var getcontroller=this.getController('menu.CoreERPNavigationController');
    			var getTab=getcontroller.getTab(tabName);

    			if(getTab!=null){
    				contentPanel.remove(getTab, true);
    			}
    			
    			var tabNameAdd = getCommonTranslation('BMI_ADD_MACHINE');
    			var getTabAdd=getcontroller.getTab(tabNameAdd);
    			
    			if(getTabAdd!=null){
    				contentPanel.remove(getTabAdd, true);
    			}
    			
    			var tabNameView = getCommonTranslation('BMI_VIEW_MACHINE');
    			var getTabView=getcontroller.getTab(tabNameView);
    			
    			if(getTabView!=null){
    				contentPanel.remove(getTabView, true);
    			}
    			
    			if(type == "view"){
    				$this.toggleReadOnlyFormItems(structure.getForm(), true);
    				structure.down('#submitBtnBMI').setVisible(false);
    				structure.down('#resetBtnBMI').setVisible(false);
        			openTab(contentPanel, tabNameView, structure, CONSTANTS.MENU_COLOR_THIRTEEN);
        			var grid = $this.getBmiformresourcegrid();
        			grid.down('#btnAdd').hide();
        			grid.down('#btnEdit').hide();
        			grid.down('#btnDelete').hide();
    			}
    			else{
    				openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_THIRTEEN);
    			}

    			var submitUrl = SERVERURL.PATH_FIND_MACHINE_DETAIL;
    			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    			Ext.Ajax.request({
    				type : 'rest',
    				url : submitUrl+"?id="+records[0].data.id,
    				method : 'GET',
    				success : function(resp, action) {
    					Ext.getBody().unmask();
    					var data = Ext.decode(resp.responseText);
    					var formPnl = structure;

    					if(!isNullOrEmpty(data)){
    						formPnl.getForm().setValues(data);
    						formPnl.down('#machineIdItemId').setReadOnly(true);
    						formPnl.down('#resetBtnBMI').hide();
    						var grid = $this.getBmiformresourcegrid(),
    				    	store = grid.getStore();
    						store.removeAll();
    				    	var dataArr = [],
    				    	isFlag = false;
    				    	if(!isNullOrEmpty(data.attendanceMachineLocation) && data.attendanceMachineLocation.length>0){
    				    		data.attendanceMachineLocation.forEach(function(obj){
    				    			var uniqueKey = obj.academyLocation.id + '-' + obj.resourceType.id + '-' + obj.resource.id;
    				    			var data = {
    				    					id:obj.id,
    				    					academyLocationName : obj.academyLocation.value,
    				    					resourceGroup : obj.resourceGroup,
    				    					resourceType: obj.resourceType.value,
    				    					resourceName : obj.resource.value,
    				    					academyLocationId : obj.academyLocation.id,
    				    					resourceTypeId : obj.resourceType.id,
    				    					resourceId : obj.resource.id,
    				    					keyCheckVal: uniqueKey
    				    			}
    				    			dataArr.push(data);
    				    		});
    				    		store.loadRawData(dataArr, true);
    				    	}
    					}
    				}
    			});
    		}
    	}
    	else{
    		showWarningMessage(getCommonTranslation('EDIT_BMI_INFORMATION'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    	}
    },
    bmiDownloadUploadRadioChange : function(cb, nv, ov){
		var $this = this;
		var structure = cb.up('bmibulkimportstructure');
		var bmiDownloadForm = structure.down('bmidownloadform');
		var uploadTemplateForm = structure.down('bmiuploadform');
		var grid = $this.getImportlistbiometricmachineintegrationgrid();
		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
			uploadTemplateForm.hide();
			var bmiStudentDownloadForm = bmiDownloadForm.down('bmistudentdownloadform');
			bmiDownloadForm.getForm().reset();
			bmiDownloadForm.show();

			bmiStudentDownloadForm.down('#lmAcademyLocationComboAS').setDisabled(true);
	      /*bmiStudentDownloadForm.down('#program').setDisabled(true);
			bmiStudentDownloadForm.down('#batch').setDisabled(true);
			bmiStudentDownloadForm.down('#period').setDisabled(true);
			bmiStudentDownloadForm.down('#course').setDisabled(true);
			bmiStudentDownloadForm.down('#section').setDisabled(true);*/
			bmiStudentDownloadForm.getForm().reset();
			grid.setVisible(false);
		}else{
			bmiDownloadForm.hide();
			uploadTemplateForm.show();
			grid.setVisible(true);
			uploadTemplateForm.down("#uploadFileField").reset();
		}
	},
	bmiStudentEmployeeRadioChange : function(cb, nv, ov){
		var $this = this;
		var structure = cb.up('bmidownloadform');
		var bmiStudentDownloadForm = structure.down('bmistudentdownloadform');
		var bmiEployeeDownloadForm = structure.down('bmiemployeedownloadform');
		//var grid = $this.getImportlistapprovalflowupdategrid();
		if(nv.studentEmployeeDownloadTemplate == 'studentTemplate'){
			bmiEployeeDownloadForm.hide();
			bmiStudentDownloadForm.show();

			bmiStudentDownloadForm.down('#lmAcademyLocationComboAS').setDisabled(true);
			/*bmiStudentDownloadForm.down('#program').setDisabled(true);
			bmiStudentDownloadForm.down('#batch').setDisabled(true);
			bmiStudentDownloadForm.down('#period').setDisabled(true);
			bmiStudentDownloadForm.down('#course').setDisabled(true);
			bmiStudentDownloadForm.down('#section').setDisabled(true);*/
			bmiStudentDownloadForm.down('#downoladBtnIdAS').setDisabled(true);
			bmiStudentDownloadForm.getForm().reset();
			//grid.setVisible(false);
		}else{
			bmiStudentDownloadForm.hide();
			bmiEployeeDownloadForm.show();
			
			bmiEployeeDownloadForm.down('#lmAcademyLocationComboAS').setDisabled(true);
			bmiEployeeDownloadForm.down('#downoladBtnIdAS').setDisabled(true);
			bmiEployeeDownloadForm.getForm().reset();
		}
	},
	 resetBMIFilter: function() {
        var $this = this;
        var filter = $this.getBmifilter().getForm();
        filter.reset();
        var resourceNameItemId = $this.getBmifilter().down("#resourceNameItemId");
        resourceNameItemId.setDisabled(true);
        resourceNameItemId.reset();
    },
   
    selectResourceTypeInCtl:function(combo,$this){
    	var alForm = combo.up('form');
    	var resourceNameCombo = alForm.down('#resourceNameItemIdForm');
    	resourceNameCombo.setDisabled(false);
    	resourceNameCombo.clearAllDataFn();
    	var store = resourceNameCombo.getStore();
		var alCombo = alForm.down("#academyLocationId");
		var academyLocationId = alCombo.getValue();
		if (!isNullOrEmpty(academyLocationId)) {
			if(!isNullOrEmpty(store)) {
				store.getProxy().extraParams = {
		    		resourceTypeId: combo.getValue(),
		    		academyLocationIds : academyLocationId
		    	};
				store.proxy.limitParam=null;
		    	store.load();
			}
		}
    },
    selectAcademyLocationInCtl:function(combo){
    	var $this = this,
    	formWindow = $this.getBmiformresourcewin(),
    	formPanel =  combo.up('form'),
    	resourceGroupCombo = formPanel.down('#cmbResourceGroup');
    	resourceGroupCombo.setDisabled(false);
    	resourceGroupCombo.reset();
    	
    	var resourceNameCombo = formPanel.down('#resourceNameItemIdForm');
    	resourceNameCombo.setDisabled(true);
    	resourceNameCombo.clearAllDataFn();
    	
    	var resourceTypeCombo = formPanel.down('#resourceTypeItemIdForm');
    	resourceTypeCombo.setValue(null);
    	resourceTypeCombo.setDisabled(true);
    	
    },
    getBMIDownloadFile: function(documentId, fileType) {
        if (!isNullOrEmpty(documentId)) {
            var csvForm = Ext.create('Ext.form.Panel');
            csvForm.getForm().submit({
                target: '_blank',
                method: 'POST',
                params: {
                    access_token: Ext.Ajax.defaultHeaders.access_token
                },
                headers: {
                    'Authorization': Ext.Ajax.defaultHeaders.Authorization
                },
                url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL + '?id=' + documentId + '&fileType=' + fileType,
                standardSubmit: true
            });
        }
    },
    saveBMIForm : function(btn){
    	var $this = this;
    	var formPnl = this.getBmiform();
    	var values = formPnl.getForm().getFieldValues();
    	var resourceNameArry=[],attendanceMachineLocation = [];
    	var gridFormRes = $this.getBmiformresourcegrid(),
    	storeFormRes = gridFormRes.getStore();
    	
    	/*new create machine code*/
    	if(isNullOrEmpty(values.id)){
    		if(storeFormRes.data.length>0){
        		storeFormRes.data.each(function(obj) {
        			var objNew = new Object();
        			//objNew.id = obj.data.id;
        			var academyLocation = {
        					id: obj.data.academyLocationId
        			}
        			objNew.academyLocation = academyLocation;
        			var resource = {
        					id: obj.data.resourceId
        			}
        			objNew.resource = resource;
        			attendanceMachineLocation.push(objNew)
        		});
        	}
        	
        	var contentpanel = this.getContentpanel();
        	var getcontroller = this.getController('menu.CoreERPNavigationController');
        	var getTab = getcontroller.getTab(this.getContentpanel().getActiveTab().title);

        	var jsonObj = new Object();
        	jsonObj.machineName = values.machineName;
        	jsonObj.machineIP = values.machineIP;
        	jsonObj.machineCode = values.machineCode;
        	jsonObj.isActive = values.isActive;
        	jsonObj.isDefault = values.isDefault;
        	jsonObj.action = values.action;
        	jsonObj.attendanceMachineLocation = attendanceMachineLocation;
        	

        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        	var submitUrl = SERVERURL.PATH_CREATE_ATTENDANCE_MACHINE;
        	Ext.Ajax.request({
        		type : 'rest',
        		url : submitUrl,
        		jsonData : jsonObj,
        		method : 'POST',
        		success : function(form1, action) {
        			Ext.getBody().unmask();
        			//formPnl.getForm().reset();
        			/**
        			 * This is to remove tab from content panel
        			 */
        			if (getTab != null) {
        				contentPanel.remove(getTab, true);
        			}
        			 var grid = $this.getBmigrid();
                     $this.resetPageSetting(grid.getStore());
                     grid.getStore().reload();
                     grid.getSelectionModel().deselectAll();
                     storeFormRes.removeAll();
                     //gridFormRes.getSelectionModel().deselectAll();
        			showSuccessMessage(getCommonTranslation('EDIT_BMI_INFORMATION'), getCommonTranslation('SAVEDSUCCESSFULLY'));
        		}
        	});
    	}
    	else{
    		/*Update machine code*/
    		if(storeFormRes.data.length>0){
        		storeFormRes.data.each(function(obj) {
        			var objNew = new Object();
        			objNew.id = obj.data.id;
        			var academyLocation = {
        					id: obj.data.academyLocationId
        			}
        			objNew.academyLocation = academyLocation;
        			var resource = {
        					id: obj.data.resourceId
        			}
        			objNew.resource = resource;
        			attendanceMachineLocation.push(objNew)
        		});
        	}
        	
        	var contentpanel = this.getContentpanel();
        	var getcontroller = this.getController('menu.CoreERPNavigationController');
        	var getTab = getcontroller.getTab(this.getContentpanel().getActiveTab().title);

        	var jsonObj = new Object();
        	jsonObj.id = values.id;
        	jsonObj.machineName = values.machineName;
        	jsonObj.machineIP = values.machineIP;
        	jsonObj.machineCode = values.machineCode;
        	jsonObj.isActive = values.isActive;
        	jsonObj.isDefault = values.isDefault;
        	jsonObj.action = values.action;
        	jsonObj.attendanceMachineLocation = attendanceMachineLocation;
        	

        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        	var submitUrl = SERVERURL.PATH_UPDATE_ATTENDANCE_MACHINE;
        	Ext.Ajax.request({
        		type : 'rest',
        		url : submitUrl,
        		jsonData : jsonObj,
        		method : 'POST',
        		success : function(form1, action) {
        			Ext.getBody().unmask();
        			//formPnl.getForm().reset();
        			/**
        			 * This is to remove tab from content panel
        			 */
        			if (getTab != null) {
        				contentPanel.remove(getTab, true);
        			}
        			 var grid = $this.getBmigrid();
                     $this.resetPageSetting(grid.getStore());
                     grid.getStore().reload();
                     grid.getSelectionModel().deselectAll();
                     storeFormRes.removeAll();
                     //gridFormRes.getSelectionModel().deselectAll();
        			showSuccessMessage(getCommonTranslation('EDIT_BMI_INFORMATION'), getCommonTranslation('SAVEDSUCCESSFULLY'));
        		}
        	});
    	
    	}
    	
    },
    loadBmiGrid : function() {
    	var $this = this;
    	var filter = $this.getBmifilter();
    	var acadmyLocationId = filter.down('#academyLocationItemId').getValue();
    	var machineCode = filter.down('#machineId').getRawValue();
    	var machineName = filter.down('#machineName').getRawValue();
    	var action = filter.down('#actionItemId').getValue();
    	var resourceTypeId = filter.down('#resourceTypeItemId').getValue();
    	var resourceId = filter.down('#resourceNameItemId').getValue();
    	var resourceGroupItemId = filter.down('#cmbResourceGroupItemId').getValue();
    	
    	var grid = $this.getBmigrid();
    	var store = grid.getStore();
    	store.getProxy().extraParams = {
    			academyLocationId :acadmyLocationId,
    			machineCode : machineCode,
    			machineName : machineName,
    			action : action,
    			resourceTypeId : resourceTypeId,
    			resourceId : resourceId,
    			resourceGroup: resourceGroupItemId
    	};
    	$this.resetPageSetting(store);
    	grid.getSelectionModel().deselectAll(true);
    	store.load();
    },
    deleteBMIDetailGrid: function(type, $thisMain) {
        var $this = this,
        grid,
        serverURL,
        idVal=[],
        titleTranslation;
        var gridMain = $thisMain.getBmigrid();
        if (type == 'AL') {
            grid = $this.getBmidetailsalgrid();
            titleTranslation = getCommonTranslation('BMI_AL_DETAIL');
        } else if (type == 'Resource') {
            grid = $this.getBmiresourcedetailsgrid();
            titleTranslation = getCommonTranslation('BMI_RESOURCE_DETAIL');
        }
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(titleTranslation, getCommonTranslation('BMI_DELETE_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    var records = grid.getSelectionModel().getSelection();
                    var recordMainGrid = gridMain.getSelectionModel().getSelection();
                    
                    
                    if (type == 'AL') {
                    	Ext.each(records, function(data) {
                        	idVal.push(data.get('academyLocation').id);
                        });
                    	/*var params = {
	  	        			  machineId : recordMainGrid[0].get('id'),
	  	        			  academyLocationIds : idVal.join()
	  	        		  };*/
                    	var params = new Object();
                    	params.machineId = recordMainGrid[0].get('id');
                    	params.academyLocationIds =idVal.join();
                    	
                    	serverURL = SERVERURL.PATH_DELETE_ATTENDANCE_MACHINE_LOCATION;
                    } else if (type == 'Resource') {
                    	Ext.each(records, function(data) {
                        	idVal.push(data.get('id'));
                        });
                    	var params = {
  	  	        			  attendanceMachineLocationIds : idVal.join()
  	  	        		  };
                    	serverURL = SERVERURL.PATH_DELETE_ATTENDANCE_MACHINE_LOCATION_RESOURCE;
                    }
                    Ext.Ajax.request({
                        method: 'POST',
                        type: 'rest',
                        url: serverURL,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        params : params,
                        success: function(form, action) {
                        	var bmiStore = gridMain.getStore();
                        	$thisMain.resetPageSetting(bmiStore);
                        	bmiStore.load();
                        	gridMain.getSelectionModel().deselectAll(true);
                            Ext.getBody().unmask();
                            grid.up('window').close();
                            showSuccessMessage(titleTranslation, getCommonTranslation('RECORD_DELETE_SUCCESS'));
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
        }
    },
    deleteBiometricMachine : function () {
    	var $this = this;
    	var grid = $this.getBmigrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection();
    		var ids = [];
    		for(var i in records ){
    			ids.push(records[i].get('id'));
    		}
    		Ext.Ajax.request({
    			method: 'GET',
    			type: 'rest',
    			url: SERVERURL.PATH_FIND_ATTENDANCE_MACHINE_USER,
    			params : {
    				machineIds : ids.join()
    			},
    			success: function(response, action) {
    				var responseData = Ext.decode(response.responseText);
    				if(responseData.length > 0) {
    					showWarningMessage(getCommonTranslation('BMI_GRID_TITLE'), getCommonTranslation('BMI_DELETE_MACHINE_DETAILS_DEPENDENCY_EXISTS'));
    				} else {
   					 showConfirmMessage(getCommonTranslation('BMI_GRID_TITLE'), getCommonTranslation('BMI_DELETE_MESSAGE'), function(btn, text) {
   						if (btn == 'yes') {
   							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
   							Ext.Ajax.request({
   	    		    			method: 'DELETE',
   	    		    			type: 'rest',
   	    		    			url: SERVERURL.PATH_DELETE_MACHINE,
   	    		    			headers: {
   	    		    				'Content-Type': 'application/json'
   	    		    			},
   	    		    			params : {
   	    		    				machineId : ids.join()
   	    		    			},
   	    		    			success: function(form, action) {
   	    		    				var bmiStore = grid.getStore();
   	    		    				$this.resetPageSetting(bmiStore);
   	    		    				grid.getSelectionModel().deselectAll(true);
   	    		            		grid.getStore().reload();
   	    		    				Ext.getBody().unmask();
   	    		    				showSuccessMessage(getCommonTranslation('BMI_GRID_TITLE'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
   	    		    			}
   	    		    		});
   						}
   					});
   				
    				}
    			}
    		});
    	}
    	else{
    		showWarningMessage(getCommonTranslation('EDIT_BMI_INFORMATION'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    	}
    },
    
    addBMIFormResourceRecordWin: function(){
    	var $this = this;
    	var formWindow = $this.getBmiformresourcewin();
    	if (!formWindow) {
    		Ext.widget('bmiformresourcewin');
    		formWindow = $this.getBmiformresourcewin();
    	}
    	formWindow.show();
    },
    editBMIFormResourceRecordWin: function(){
    	var $this = this,
    	grid = $this.getBmiformresourcegrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		formWindow = $this.getBmiformresourcewin();
        	if (!formWindow) {
        		Ext.widget('bmiformresourcewin');
        		formWindow = $this.getBmiformresourcewin();
        	}
        	formWindow.show();
        	var contentPanel = $this.getContentpanel(),
        	form = formWindow.down('form');
        	
        	var records = grid.getSelectionModel().getSelection();
    		if (records != "" && records != null && records != undefined) {
    			var idResourceItemId = form.down('#idResourceItemId');
    			if(!isNullOrEmpty(records[0].data.id)){
    				idResourceItemId.setValue(records[0].data.id);
            	}
            	else{
            		form.down('#keyCheckValItemId').setValue(records[0].data.keyCheckVal);
            	}
    			
    			var academyLocationFld = form.down('#academyLocationId');
    			academyLocationFld.getStore().load({
    	            callback: function(operation, success) {
    	                if (success) {
    	                	academyLocationFld.setValue(records[0].data.academyLocationId);
    	                	var cmbResourceGroup = form.down('#cmbResourceGroup');
    	                	var resourceTypeItemIdForm = form.down('#resourceTypeItemIdForm'),
    	        			resTypeStore = resourceTypeItemIdForm.getStore();
    	        			var comboVal = records[0].data.resourceGroup;
    	    		    	if(comboVal == 'All'){
    	    		    		comboVal = null;
    	    		    	}
    	    		    	//cmbResourceGroup.setValue((records[0].data.resourceGroup == "All")?'ALL':records[0].data.resourceGroup);
    	    		    	cmbResourceGroup.setValue(records[0].data.resourceGroup);
    	    		    	resTypeStore.getProxy().extraParams = {
    	    	    			resourceGroup: comboVal
    	    	    		};
    	    		    	resTypeStore.load({
    	        	            callback: function(operation, success) {
    	        	                if (success) {
    	        	                	resourceTypeItemIdForm.setValue(records[0].data.resourceTypeId);
    	        	                	
    	        	                	var resourceNameItemIdForm = form.down('#resourceNameItemIdForm'),
    	        	    		    	resNameStore = resourceNameItemIdForm.getStore();
    	        	    		    	
    	        	    		    	if (!isNullOrEmpty(records[0].data.academyLocationId)) {
    	        	    					if(!isNullOrEmpty(resNameStore)) {
    	        	    						resNameStore.getProxy().extraParams = {
    	        	    				    		resourceTypeId: records[0].data.resourceTypeId,
    	        	    				    		academyLocationIds : records[0].data.academyLocationId
    	        	    				    	};
    	        	    						resNameStore.load({
    	        	    		    	            callback: function(operation, success) {
    	        	    		    	                if (success) {
    	        	    		    	                	resourceNameItemIdForm.setValue(records[0].data.resourceId);
    	        	    		    	                	resourceNameItemIdForm.setDisabled(false);
    	        	    		    	                }
    	        	    		    	            }
    	        	    		    	        });
    	        	    					}
    	        	    				}
    	        	                }
    	        	            }
    	        	        });
    	                }
    	            }
    	        });
    		}
    	}
    	else{
    		showWarningMessage(getCommonTranslation('BMI_RESOURCE_INFORMATION'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    	}
    },
    selectResourceGroupCombo: function(combo){
    	var $this = this,
    	formWindow = $this.getBmiformresourcewin(),
    	formPanel = combo.up('form'),
    	resourceTypeCombo = formPanel.down('#resourceTypeItemIdForm');
    	resourceTypeCombo.setDisabled(false);
    	
    	var resourceNameCombo = formPanel.down('#resourceNameItemIdForm');
    	resourceNameCombo.setDisabled(true);
    	resourceNameCombo.clearAllDataFn();
    	
    	resourceTypeCombo.setDisabled(false);
    	resourceTypeCombo.reset();
    	var store = resourceTypeCombo.getStore();
    	var comboVal = combo.getValue();
    	if(comboVal == 'All'){
    		comboVal = null;
    	}
    	store.getProxy().extraParams = {
			resourceGroup: comboVal
		};
    	store.load();
    },
    submitResourceFormRecord: function(){

    	var $this = this,
    	formWindow = $this.getBmiformresourcewin(),
    	form = formWindow.down('form').getForm(),
    	values = form.getValues();

    	var grid = $this.getBmiformresourcegrid(),
    	store = grid.getStore(),

    	academyName = form.findField('academyLocation').getRawValue();
    	resourceGroup = form.findField('resourceGroup').getValue();
    	resourceType = form.findField('resourceTypeForm').getRawValue();
    	var dataArr = [],
    	isFlag = false, displayMsgFlag = false;
    	if(!isNullOrEmpty(values.resourceName) && values.resourceName.length>0){
    		values.resourceName.forEach(function(obj){
    			var uniqueKey = values.academyLocation + '-' + values.resourceTypeForm + '-' + obj.data.id;
    			
    			var rec = store.findRecord('keyCheckVal', uniqueKey);
    			if(!isNullOrEmpty(rec)){
    				 Ext.MessageBox.alert(getCommonTranslation('WARNING'), getCommonTranslation('BMI_ALREADY_MAPPED_ACADEMY_MESSAGE'));
    				 isFlag = true;
    				 return;
    			}
    			if(isNullOrEmpty(values.id)){
    				var keyCheckValItemId = form.findField('keyCheckVal').getValue();
    				var recNew = store.findRecord('keyCheckVal', keyCheckValItemId);
    				if(!isNullOrEmpty(recNew)){
    					displayMsgFlag = true;
    					store.remove(recNew);
    				}
    				else{
    					displayMsgFlag = false;
    				}
    				var data = {
        					academyLocationName : academyName,
        					resourceGroup : isNullOrEmpty(resourceGroup) ? 'All' :resourceGroup,
        					resourceType: resourceType,
        					resourceName : obj.data.value,
        					academyLocationId : values.academyLocation,
        					resourceTypeId : values.resourceTypeForm,
        					resourceId : obj.data.id,
        					keyCheckVal: uniqueKey
        			}
        			dataArr.push(data);
    			}
    			else{
    				if(isFlag == false){
    					var rec = store.findRecord('id', values.id);
        				store.remove(rec);
        				displayMsgFlag = true;
        				var data = {
        						id:values.id,
            					academyLocationName : academyName,
            					resourceGroup : isNullOrEmpty(resourceGroup) ? 'All' :resourceGroup,
            					resourceType: resourceType,
            					resourceName : obj.data.value,
            					academyLocationId : values.academyLocation,
            					resourceTypeId : values.resourceTypeForm,
            					resourceId : obj.data.id,
            					keyCheckVal: uniqueKey
            			}
            			dataArr.push(data);
    				}
    			}
    		});
    	}

    	if(isFlag == false){
    		store.loadRawData(dataArr, true);
    		formWindow.close();
    		if(dataArr.length>0){
    			if(displayMsgFlag == true){
    				showSuccessMessage(getCommonTranslation('BMI_RESOURCE_DETAIL'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));	
    			}
    			else{
    				showSuccessMessage(getCommonTranslation('BMI_RESOURCE_DETAIL'), getCommonTranslation('RECORD_ADD_SUCCESS'));
    			}
    			
    		}
    		else{
    			showSuccessMessage(getCommonTranslation('BMI_RESOURCE_DETAIL'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
    		}
    		
    		
    	}
    },
    closeFormWindow: function() {
    	var $this = this,
    	formWindow = $this.getBmiformresourcewin();
    	if (!formWindow) {
    		Ext.widget('bmiformresourcewin');
    		formWindow = this.getBmiformresourcewin();
    	}
    	formWindow.close();
    },
    
    showBmiAttendanceMachineUserMappingWin: function(grid, fromView) {
    	var $this = this;
		var formWindow = $this.getBmiattendancemachineusermappingwin();
		if (!formWindow) {
			Ext.widget('bmiattendancemachineusermappingwin');
			formWindow = $this.getBmiattendancemachineusermappingwin();
		}
		if(grid.getItemId() == 'studentbmimachinedetailsgridItemId'){
			formWindow.down('#userTypeId').setValue('STUDENT');
		} else if(grid.getItemId() == 'facultybmimachinedetailsgridItemId') {
			formWindow.down('#userTypeId').setValue('FACULTY');
		}
		if(fromView != 'ADD'){
			var records = grid.getSelectionModel().getSelection();
			if(records.length > 0) {
				var attendanceMachineUserId = records[0].raw.attendanceMachineUserId;
				var machineId = records[0].raw.machineId;
			    var clientUserId = records[0].raw.clientUserId;
			    var status = records[0].raw.status;
			    var attendanceMachineCombo = formWindow.down('#attendanceMachineItemId');
			    $this.loadAttendanceMachineOrGridStore(grid, attendanceMachineCombo);
			    formWindow.down('#attendanceMchineUserMappingId').setValue(attendanceMachineUserId);
			    formWindow.down('#attendanceMachineItemId').setValue(machineId);
			    formWindow.down('#machineUserItemId').setValue(clientUserId);
			    formWindow.down('#userMappingActiveItemId').setValue(status);
			}
		}
		formWindow.show();
    },
    
    saveUserMapping : function(grid){
    	var $this = this;
    	var jsonObj = this.getAttendanceMachineUserMappingJson(grid);
    	if(!isNullOrEmpty(jsonObj)) {
    		jsonObj = Ext.encode(jsonObj)
    		serverURL = SERVERURL.PATH_SAVE_ATTENDANCE_MACHINE_USER_AND_MAPPING;
    		$this.applyWindowMask();
			Ext.Ajax.request({
        		type : 'rest',
        		url : serverURL,
        		jsonData : jsonObj,
        		method : 'POST',
        		success : function(response, action) {
        			$this.hideWindowMask();
        			if(!isNullOrEmpty(response)) {
        				if(response.responseText == 'DUPLICATE_CLIENT_USER_ID') {
        					showWarningMessage(getCommonTranslation('BMI_MACHINE_DETAILS_ON_PROFILE'),getCommonTranslation('DUPLICATE_CLIENT_USER_ID'));
        				} else if(response.responseText == 'MACHINE_USER_MAPPING_EXIST_MSG') {
        					showWarningMessage(getCommonTranslation('BMI_MACHINE_DETAILS_ON_PROFILE'),getCommonTranslation('MACHINE_USER_MAPPING_EXIST_MSG'));
        				} else if(response.responseText == 'SUCCESS') {
        					showSuccessMessage(getCommonTranslation('BMI_MACHINE_DETAILS_ON_PROFILE'),getCommonTranslation('SUCCESS'));
        					var bmiattendancemachineusermappingwin = $this.getBmiattendancemachineusermappingwin();
        					grid.getStore().load();
            				bmiattendancemachineusermappingwin.close();
        				}
        			}
        			
        		}
        	});
    	}
    },
    
    getAttendanceMachineUserMappingJson : function(grid) {
    	var bmiattendancemachineusermappingwin = this.getBmiattendancemachineusermappingwin();
    	var attendanceMchineUserMappingId = bmiattendancemachineusermappingwin.down('#attendanceMchineUserMappingId').getValue();
    	var clientUserId = bmiattendancemachineusermappingwin.down('#machineUserItemId').getValue();
    	var machineId = bmiattendancemachineusermappingwin.down('#attendanceMachineItemId').getValue();
    	var status = bmiattendancemachineusermappingwin.down('#userMappingActiveItemId').getValue();
    	
		var jsonObj = new Object();
		
		var attendanceMachine = new Object(); 
		var userMapping = new Object(); 
		var academiaUser = new Object(); 
		
		if(grid.getItemId() == 'studentbmimachinedetailsgridItemId'){
		   academiaUser.id = grid.up('studentprofile').getUserId();
		} else if(grid.getItemId() == 'facultybmimachinedetailsgridItemId') {
			academiaUser.id = grid.up('facultyprofile').getUserId();
		}
		
		userMapping.academiaUser = academiaUser;
		userMapping.clientUserId = clientUserId;
		
		attendanceMachine.id = machineId;
		
    	if(!isNullOrEmpty(attendanceMchineUserMappingId)) {
    		var records = grid.getSelectionModel().getSelection();
    		
    		userMapping.id = records[0].raw.userMappingId;
    		jsonObj.id = attendanceMchineUserMappingId;
    	}
    	
    	jsonObj.attendanceMachine = attendanceMachine;
		jsonObj.userMapping = userMapping;
		jsonObj.status = status;

		return jsonObj;
    },
    
    getGrid : function(){
    	var win = this.getBmiattendancemachineusermappingwin();
		var userType = win.down('#userTypeId').getValue();
		var grid = null;
		if(userType == 'STUDENT') {
			var studentProfile = this.getActiveTabfromContentPanel();
    	    grid = studentProfile.down('#studentbmimachinedetailsgridItemId');
		} else if(userType == 'FACULTY') {
			var facultyprofile = this.getActiveTabfromContentPanel();
    	    grid = facultyprofile.down('#facultybmimachinedetailsgridItemId');
		}	
		return grid;
    },
    loadAttendanceMachineOrGridStore : function(grid, object){
    	var userId;
		if(grid.getItemId() == 'studentbmimachinedetailsgridItemId'){
			userId = grid.up('studentprofile').getUserId();
		} else if(grid.getItemId() == 'facultybmimachinedetailsgridItemId') {
			userId = grid.up('facultyprofile').getUserId();
		}
		var store = object.getStore();
		store.getProxy().extraParams = {
			userId: userId
		};
		store.load();
    },
    
    deleteBMIFormResourceRecordWin: function(){
    	var $this = this,
    	serverURL,
    	idVal=[],
    	titleTranslation;
    	var grid = $this.getBmiformresourcegrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getCommonTranslation('BMI_RESOURCE_INFORMATION'), getCommonTranslation('BMI_DELETE_MESSAGE'), function(btn, text) {
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				var records = grid.getSelectionModel().getSelection();
    				Ext.each(records, function(data) {
    					if(!isNullOrEmpty(data.get('id'))){
    						idVal.push(data.get('id'));
    					}
    				});

    				if(!isNullOrEmpty(idVal) && idVal.length>0 ){
    					var params = {
    							attendanceMachineLocationIds : idVal.join()
    					};
    					serverURL = SERVERURL.PATH_DELETE_ATTENDANCE_MACHINE_LOCATION_RESOURCE;

    					Ext.Ajax.request({
    						method: 'POST',
    						type: 'rest',
    						url: serverURL,
    						headers: {
    							'Content-Type': 'application/json'
    						},
    						params : params,
    						success: function(form, action) {
    							Ext.getBody().unmask();
    							var store = grid.getStore();
    							$this.resetPageSetting(store);
    							//store.load();
    							Ext.each(records, function(data) {
    								store.remove(data);
    							});
    							grid.getSelectionModel().deselectAll(true);
    							showSuccessMessage(getCommonTranslation('BMI_RESOURCE_INFORMATION'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
    						}
    					});
    				}
    				else{
    					var store = grid.getStore();
    					Ext.each(records, function(data) {
    						store.remove(data);
    					});
    					Ext.getBody().unmask();
    					showSuccessMessage(getCommonTranslation('BMI_RESOURCE_INFORMATION'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
    				}
    			}
    		});
    	} else {
    		showWarningMessage(TRANSLATIONS.ALERT, TRANSLATIONS.PLEASE_SELECT_RECORD);
    	}

    }
});