/**
 * @author Varsha Gour
 */
Ext.define('Academia.controller.leavemanagement.report.FacultyLeaveReportsController', {
    extend: 'Academia.controller.base.BaseController',

    views: ['reports.faculty.FacultyLeaveDashBoard',
            'reports.common.DashboardReportTabStructure',
            'programCourseDashboard.organizationUnit.OrganizationUnit',
            'leavemanagement.report.LMEmployeeLeaveReportFilter',
            'leavemanagement.report.LMEmployeeLeaveReportStructure',
            'leavemanagement.report.LMEmployeeLeaveReportGrid',
			'leavemanagement.report.LMOrganizationUnit',
			'leavemanagement.report.LMLeaveApprovalFlowReportStructure',
			'leavemanagement.report.LMLeaveApprovalFlowReportFilter',
			'leavemanagement.report.LMLeaveApprovalFlowReportGrid',
			'leavemanagement.report.LMEmployeeLeaveReportTimelineWin',
			'leavemanagement.report.LMLeaveSLAReportStructure',
			'leavemanagement.report.LMLeaveSLAReportFilter',
			'leavemanagement.report.LMLeaveSLAReportGrid',
			'leavemanagement.report.LMEmployeeLeaveSLAReportStructure',
			'leavemanagement.report.LMEmployeeLeaveSLAReportFilter',
			'leavemanagement.report.LMEmployeeLeaveSLAReportGrid',
			'leavemanagement.report.LMEmployeeLeaveBalanceReportStructure',
			'leavemanagement.report.LMEmployeeLeaveBalanceReportFilter',
			'leavemanagement.report.LMEmployeeLeaveBalanceReportGrid',
			'leavemanagement.report.LMLeaveEncashmentReportStructure',
			'leavemanagement.report.LMLeaveEncashmentReportFilter',
			'leavemanagement.report.LMLeaveEncashmentReportGrid',
			'leavemanagement.report.LMLeaveCarryForwardReportStructure',
			'leavemanagement.report.LMLeaveCarryForwardReportFilter',
			'leavemanagement.report.LMLeaveCarryForwardReportGrid',
			'leavemanagement.report.LMLeaveLapseReportStructure',
			'leavemanagement.report.LMLeaveLapseReportFilter',
			'leavemanagement.report.LMLeaveLapseReportGrid',
			'leavemanagement.report.LMLeaveCreditReportStructure',
			'leavemanagement.report.LMLeaveCreditReportFilter',
			'leavemanagement.report.LMLeaveCreditReportGrid'],

   stores : ['reports.servicerequest.FacultyLeaveDashBoardTreeStore',
			 'facilitiesresources.resourcebooking.AcademyLocationListByUserStore',
			 'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
			 'common.DesignationTypeStore',
			 'facilitiesresources.resourcebooking.departmentFilterStore',
			 'leavemanagement.report.LMLevaeApprovalReportSerachStore',
			 'criteriabuilder.userquicksearch.QuickSearchName',
			 'leavemanagement.leaveapprovalsetup.LMLeaveRequestStatusStore',
			 'leavemanagement.LeaveTypeStore',
			 'leavemanagement.report.LMEmployeeLeaveReportGridStore',
			 'leavemanagement.leaveapprovalsetup.LMLeaveRequestDetailStore',
			 'leavemanagement.report.LMLeaveSLAReportGridStore',
			 'leavemanagement.report.LMEmployeeLeaveSLAReportGridStore',
			 'leavemanagement.report.LMEmployeeLeaveBalanceReportGridStore',
			 'leavemanagement.leavecreditsetting.LeaveYearStore',
			 'leavemanagement.report.LMLeaveEncashmentReportSerachStore',
			 'leavemanagement.report.LMLeaveCreditReportStore',
			 'leavemanagement.leavecreditsetting.LeaveCreditPeriodEnumStore'],
			   
   models : ['leavemanagement.report.LMLeaveApprovalReportGridModel',
	         'leavemanagement.report.LMEmployeeLeaveReportGridModel',
	         'leavemanagement.leaveapprovalsetup.LMLeaveRequestDetailModel',
	         'leavemanagement.report.LMLeaveSLAReportGridModel'],

    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'facultyleavedashboard',
        selector: 'facultyleavedashboard'
    }, {
		ref : 'lmorganizationunit',
		selector : 'lmorganizationunit[itemId=employeeLeaveApprovalFlowOrganizationUnit]'
	}, {
        ref: 'dashboardreporttabstructure',
        selector: 'dashboardreporttabstructure'
    }, {
        ref: 'facultyChildSearchResultGrid',
        selector: 'searchresultgrid[itemId=facultyChildSearchResultGrid]'
    },{
        ref: 'lmemployeeleavereportstructure',
        selector: 'lmemployeeleavereportstructure'
    },{
        ref: 'lmemployeeleavereportfilter',
        selector: 'lmemployeeleavereportfilter'
    },{
        ref: 'lmemployeeleavereportgrid',
        selector: 'lmemployeeleavereportgrid'
    },{
		ref : 'lmleaveapprovalflowreportstructure',
		selector : 'lmleaveapprovalflowreportstructure'
	},{
		ref : 'lmleaveapprovalflowreportfilter',
		selector : 'lmleaveapprovalflowreportfilter'
	},{
		ref : 'lmleaveapprovalflowreportgrid',
		selector : 'lmleaveapprovalflowreportgrid'
	},{
		ref : 'lmemployeeleavereporttimelinewin',
		selector : 'lmemployeeleavereporttimelinewin'
	},{
        ref: 'lmleaveslareportstructure',
        selector: 'lmleaveslareportstructure'
    },{
        ref: 'lmleaveslareportfilter',
        selector: 'lmleaveslareportfilter'
    },{
        ref: 'lmleaveslareportgrid',
        selector: 'lmleaveslareportgrid'
    },{
        ref: 'lmemployeeleaveslareportstructure',
        selector: 'lmemployeeleaveslareportstructure'
        	
    },{
        ref: 'lmemployeeleaveslareportfilter',
        selector: 'lmemployeeleaveslareportfilter'
        	
    },{
        ref: 'lmemployeeleaveslareportgrid',
        selector: 'lmemployeeleaveslareportgrid'
        	
    },{
        ref: 'lmemployeeleavebalancereportstructure',
        selector: 'lmemployeeleavebalancereportstructure'
    },{
    	ref: 'lmemployeeleavebalancereportfilter',
        selector: 'lmemployeeleavebalancereportfilter'
    },{
    	ref: 'lmemployeeleavebalancereportgrid',
        selector: 'lmemployeeleavebalancereportgrid'
    },{
    	ref: 'lmleaveencashmentreportstructure',
        selector: 'lmleaveencashmentreportstructure'
    },{
    	ref: 'lmleaveencashmentreportfilter',
        selector: 'lmleaveencashmentreportfilter'
    },{
    	ref: 'lmleaveencashmentreportgrid',
        selector: 'lmleaveencashmentreportgrid'
    },{
    	ref: 'lmleavecarryforwardreportstructure',
        selector: 'lmleavecarryforwardreportstructure'
    },{
    	ref: 'lmleavecarryforwardreportfilter',
        selector: 'lmleavecarryforwardreportfilter'
    },{
    	ref: 'lmleavecarryforwardreportgrid',
        selector: 'lmleavecarryforwardreportgrid'
    },{
    	ref: 'lmleavelapsereportstructure',
        selector: 'lmleavelapsereportstructure'
    },{
    	ref: 'lmleavelapsereportfilter',
        selector: 'lmleavelapsereportfilter'
    },{
    	ref: 'lmleavelapsereportgrid',
        selector: 'lmleavelapsereportgrid'
    },{
    	ref: 'lmleavecreditreportstructure',
        selector: 'lmleavecreditreportstructure'
    },{
    	ref: 'lmleavecreditreportfilter',
        selector: 'lmleavecreditreportfilter'
    },{
    	ref: 'lmleavecreditreportgrid',
        selector: 'lmleavecreditreportgrid'
    }],
    config: {
    	LEAVE_APPROVAL_FLOW_REPORT_PERMISSIONS:  Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LEAVE_APPROVAL_FLOW_REPORT_PRIVILEGES'),
    	EMPLOYEE_LEAVE_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_LEAVE_REPORT_PRIVILEGES'),
    	LEAVE_SLA_REPORT_PERMISSIONS:  Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LEAVE_SLA_REPORT_PRIVILEGES'),
    	EMPLOYEE_LEAVE_BALANCE_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_LEAVE_BALANCE_REPORT_PRIVILEGES'),
    	EMPLOYEE_LEAVE_ENCASHMENT_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_LEAVE_ENCASHMENT_REPORT_PRIVILEGES'),
    	EMPLOYEE_LEAVE_CARRY_FORWARD_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_LEAVE_CARRY_FORWARD_REPORT_PRIVILEGES'),
    	EMPLOYEE_LEAVE_LAPSE_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_LEAVE_LAPSE_REPORT_PRIVILEGES'),
    	EMPLOYEE_LEAVE_CREDIT_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_LEAVE_CREDIT_REPORT_PRIVILEGES')
    },
    init: function(application) {
    	this.control({

    		'lmorganizationunit[itemId=employeeLeaveApprovalFlowOrganizationUnit] multiselectcombofield[itemId=academyLocationItemId]' : {
    			change : function(combo) {
    				this.resetAllLinkedStore();
    				this.searchBtnEnableDisable(combo);
    			},
    			focus : function(combo) {
    				this.resetAllLinkedStore();
    			}
    		},
    		'lmorganizationunit[itemId=employeeLeaveApprovalFlowOrganizationUnit] radiogroup[itemId=organizationRadioUnitId]' : {
    			render : function(obj) {
    				this.setAllAlIds(obj,null);
    			}
    		},
    		'lmorganizationunit[itemId=employeeLeaveApprovalFlowOrganizationUnit] button[itemId=resetBtn]' : {
    			click : function(obj, record) {
    				this.resetOrganizationunit(obj);
    			}
    		},
    		'facultyleavedashboard':{
    			render:function(structure){
    				var $this = this;
    				structure.body.on('scroll', function(e, target) {
    					var activeTab = structure.down('#employeeLeaveApprovalFlowTabStructure').getActiveTab();
    					if(!isNullOrEmpty(activeTab)){
    						var grid = activeTab.down('grid');
    						$this.getGridHeaderFreezeForEmpLeaveGrids(grid,structure);
    					}
    				});
    			}
    		},
    		'dashboardreporttabstructure':{
    			tabchange:function(tabStructure){
    				var strucutre= this.getFacultyleavedashboard();
    				strucutre.scrollBy(0,-1);
                	strucutre.scrollBy(0,1);
    			}
    		},
    		'facultyleavedashboard panel[itemId=facultyReportView] treepanel[itemId=facultyReportTreePanelItemId]':{
    			itemclick : this.openEmployeeReportStructure
    		},

    		'facultyleavedashboard treepanel[itemId=facultyReportTreePanelItemId]': {
                render: function(treePanel) {
                	//treePanel.getStore().load();
                    var treePnlRootNode = treePanel.getRootNode();
                    this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode, this.getLEAVE_APPROVAL_FLOW_REPORT_PERMISSIONS(), "PERMISSION_LEAVE_APPROVAL_FLOW_REPORT");
                    this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode, this.getEMPLOYEE_LEAVE_REPORT_PERMISSIONS(), "PERMISSION_EMPLOYEE_LEAVE_REPORT");
                    this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode, this.getLEAVE_SLA_REPORT_PERMISSIONS(), "PERMISSION_LEAVE_SLA_REPORT");
                    this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode, this.getEMPLOYEE_LEAVE_BALANCE_REPORT_PERMISSIONS(), "PERMISSION_EMPLOYEE_LEAVE_BALANCE_REPORT");
                    this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode, this.getEMPLOYEE_LEAVE_ENCASHMENT_REPORT_PERMISSIONS(), "PERMISSION_EMPLOYEE_LEAVE_ENCASHMENT_REPORT");
                    this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode, this.getEMPLOYEE_LEAVE_CARRY_FORWARD_REPORT_PERMISSIONS(), "PERMISSION_EMPLOYEE_LEAVE_CARRY_FORWARD_REPORT");
                    this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode, this.getEMPLOYEE_LEAVE_LAPSE_REPORT_PERMISSIONS(), "PERMISSION_EMPLOYEE_LEAVE_LAPSE_REPORT");
                    this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode, this.getEMPLOYEE_LEAVE_CREDIT_REPORT_PERMISSIONS(), "PERMISSION_EMPLOYEE_LEAVE_CREDIT_REPORT");
                }
            },
    		
    		'lmleaveapprovalflowreportstructure':{
    			render:function(f){
    				var this$ = this;
    				var form = this$.getLmorganizationunit();
    				var combo = form.down('#academyLocationItemId');
    				this.searchBtnEnableDisable(combo);
    				this.onLMLeaveApprovalFlowReportStructureRender(f);
    			}
    		},
    		'lmleaveapprovalflowreportfilter customcombobox[itemId=empItemId]':{
    			render:function(combo) {
    				this.loadUserComboData(combo);
    				var lmorganizationunitForm = this.getLmorganizationunit().getForm();
    		    	var alValues = lmorganizationunitForm.getValues();
    		    	var academyLocationIdListStr = null;
    		    	var academyLocationIdList = [];
    		    	if (alValues.academyLocationId != undefined && alValues.academyLocationId.length > 0 && alValues.academyLocationId[0]!="") {
    		    		this.loadLMLeaveApprovalGrid();
    		    	}

    				/*var lmorganizationunitForm = this.getLmorganizationunit().getForm();
    		    	var alValues = lmorganizationunitForm.getValues();
    		    	var academyLocationIdListStr = null;
    		    	var academyLocationIdList = [];
    		    	if (alValues.academyLocationId != undefined && alValues.academyLocationId.length > 0) {
    		    		var records = alValues.academyLocationId;
    		    		for (i in records) {
    						var record = records[i];
    						if(Ext.isObject(record)){
    							academyLocationIdList.push(record.data.id);	
    						}else {
    							academyLocationIdList.push(record);
    						}
    					}
    		    		academyLocationIdListStr = academyLocationIdList.join();

    		    	}
    		    	var empStore = combo.getStore();
    				empStore.getProxy().extraParams = {
    					academyLocationIds:academyLocationIdListStr
    				};
    				empStore.load({
    					callback: function(record, operation, success) {
    						if (success) {
    						}
    					}
    				});
    				combo.bindStore(empStore);
    				 */}
    		},
    		'lmleaveapprovalflowreportfilter button[itemId=searchLMLeaveApprovalFlowReportFilterItemId]': {
    			click: function() {
    				this.loadLMLeaveApprovalGrid();
    			}
    		},
    		'lmleaveapprovalflowreportfilter button[itemId=resetLMLeaveApprovalFlowReportFilterItemId]': {
    			click: function() {
    				this.resetLmleaveapprovalflowreportfilter();
    			}
    		},
    		'lmemployeeleavereportfilter': {
    			render: function(me){
    				setTimeout(function(){
    					me.down('#moreDetailsEmployeeLeaveReport').collapse();
    				},300);
    			}
    		},
    		'lmemployeeleavereportfilter button[itemId=resetBtn]': {
    			click : function(){
    				var form = this.getLmemployeeleavereportfilter();
    				lmFromDateId = form.down('#lmFromDateId')
    				lmFromDateId.setMaxValue(null);
    				lmToDateId = form.down('#lmToDateId')
    				lmToDateId.setMinValue(null);
    				form.getForm().reset();
    				form.down('#searchBtn').setDisabled(true);
    			}
    		},
    		'lmemployeeleavereportfilter customcombobox[itemId=requesterNameOrIdItemId]':{
    			render : function(combo) {
    				this.loadUserComboData(combo,false)
    			}
    		},
    		'lmemployeeleavereportfilter button[itemId=searchBtn]':{
    			click : function(){
    				var isTrue = this.checkAcademyLocation();
    				if(isTrue == true) {
    					Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    					this.loadEmployeeLeaveReportData();
    				} else if(isTrue == false){
    					showWarningMessage(getPersonModuleTranslation('HRM_EMPLOYEE_LEAVE_REPORT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
    				}
    			}
    		},
    		'lmleaveapprovalflowreportgrid': {
    			render: function(grid){
    				var this$ = this;
    				this$.doAccessControlValidation(grid, this$.getLEAVE_APPROVAL_FLOW_REPORT_PERMISSIONS()); 
    			},
    			beforerender: function(grid) {
    				grid.getStore().removeAll();
    				this.resetPageSetting(grid.getStore());
    			}
    		},
    		'lmemployeeleavereportgrid': {
    			render: function(grid){
    				var this$ = this;
    				this$.doAccessControlValidation(grid, this$.getEMPLOYEE_LEAVE_REPORT_PERMISSIONS()); 
    			},
    			beforerender: function(grid) {
    				grid.getStore().removeAll();
    				this.resetPageSetting(grid.getStore());
    			},
    			cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
    				var $this = this;
    				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				if(e.target.tagName == 'A'){
    					if(columnName == "view") {
    						var record = grid.getSelectionModel().getSelection()[0];
    						var employeeleavereporttimelinewin = $this.getLmemployeeleavereporttimelinewin();
    						if(isNullOrEmpty(employeeleavereporttimelinewin)){
    							Ext.widget('lmemployeeleavereporttimelinewin');
    							employeeleavereporttimelinewin = $this.getLmemployeeleavereporttimelinewin();
    						}
    						var employeeLeaveReportTimelineGrid = employeeleavereporttimelinewin.down('#lmEmployeeLeaveReportTimelineGrid');
    						this.openEmployeeLeaveReportTimelineWin(record,employeeleavereporttimelinewin,employeeLeaveReportTimelineGrid, grid);
    					}
    				}
    			}
    		},
    		'lmemployeeleavereporttimelinewin grid[itemId=lmEmployeeLeaveReportTimelineGrid]':{
    			cellclick:function(){
    				var $this = this;
    				var win = this.getLmemployeeleavereporttimelinewin();
    				var grid = win.down('#lmEmployeeLeaveReportTimelineGrid');
    				var record = grid.getSelectionModel().getSelection()[0];
    				var form = win.down('#lmEmployeeLeaveReportTimelineFormItemId');
    				var approveBtn = form.down('#lmApproveButtonId');
    				var rejectBtn = form.down('#lmRejectButtonId');
    				var record = grid.getSelectionModel().getSelection()[0];
    				var approverLevelId = record.data.approverLevelId;
    				var approvalFlow = record.raw.approverType;
    				var prevRecord;
    				if(approvalFlow == 'SEQUENTIAL' && approverLevelId != 1) {
    					var allRecord = record.store.data.items;
    					for(var i=0; i<allRecord.length; i++) {
    						if(allRecord[i].data.approverLevelId == approverLevelId-1) {
    							prevRecord = allRecord[i].data;
    							break;
    						}
    					}
    					if((prevRecord.status == 'Approved' || prevRecord.status == 'Escalated')&&(record.data.status == "Pending")) {
    						this.reqPendingActionDetailBtnEnableDisable(approveBtn,rejectBtn,record);
    					} else {
    						approveBtn.setDisabled(true);
    						rejectBtn.setDisabled(true);
    					}
    				}else  {
    					this.reqPendingActionDetailBtnEnableDisable(approveBtn,rejectBtn,record);
    				}
    			}
    		},
    		'lmemployeeleavereporttimelinewin form[itemId=lmEmployeeLeaveReportTimelineFormItemId] button[itemId=lmApproveButtonId]':{
    			click: function() {
    				this.empLeaveReportTimelineBtnClick('APPROVED')
    			}
    		},
    		'lmemployeeleavereporttimelinewin form[itemId=lmEmployeeLeaveReportTimelineFormItemId] button[itemId=lmRejectButtonId]':{
    			click: function() {
    				this.empLeaveReportTimelineBtnClick('REJECTED')
    			}
    		},
    		'lmemployeeleavereporttimelinewin form[itemId=lmEmployeeLeaveReportTimelineFormItemId] button[itemId=lmCancelButtonId]':{
				click: function() {
					var $this = this;
    				var win = this.getLmemployeeleavereporttimelinewin();
    				var grid = this.getLmemployeeleavereportgrid();
    				var record = grid.getSelectionModel().getSelection()[0];
    				var form = win.down('#lmEmployeeLeaveReportTimelineFormItemId');
					var comment = form.down('#rpaCommentItemId').getValue();
					var leaveRequestId = record.raw.hrLeaveReqId;
					
					var empLeaveRequest = new Object();
					empLeaveRequest.cancelFrom = new Date(record.get('fromDate'));
					empLeaveRequest.cancelTo = new Date(record.get('toDate'));
					empLeaveRequest.cancelReason = comment;
					empLeaveRequest.id = leaveRequestId;
					empLeaveRequest.isEventTrigger = true;
					empLeaveRequest = Ext.encode(empLeaveRequest);
					

					showConfirmMessage(getServiceRequestTranslation('CANCEL'),getPersonModuleTranslation('LMAS_LEAVE_CANCEL_CONFIRM_MESSAGE'),function(btn,text) {
						if (btn == 'yes') {
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.PATH_CANCEL_LEAVE,
								jsonData: empLeaveRequest,
								method: 'POST',
								success: function(frm, action) {
									$this.getLmemployeeleavereportgrid().getStore().load();
									win.close();
									Ext.getBody().unmask();
									showSuccessMessage(getCommonTranslation('LM_LEAVE_REQUEST'), 'Your leaves have been cancelled successfully');
								}
							});
						}
					});
				
					
				}
			  },
    		'lmemployeeleavereportfilter datefield[itemId=lmFromDateId]': {
    			select: function(lmFromDateId) {
    				if(!isNullOrEmpty(lmFromDateId.value)) {
    					var filter = this.getLmemployeeleavereportfilter();
    					var lmToDateId = filter.down('#lmToDateId');
    					if(!isNullOrEmpty(lmToDateId.value)) {
    						var isTrue = this.checkAcademyLocation();
    						var searchBtn = filter.down('#searchBtn');
    						if(isTrue == true) {
    							searchBtn.setDisabled(false);
    						} else if(isTrue == false) {
    							searchBtn.setDisabled(true);
    						}
    					}
    				}
    			}
    		},
    		'lmemployeeleavereportfilter datefield[itemId=lmToDateId]': {
    			select: function(lmToDateId) {
    				if(!isNullOrEmpty(lmToDateId.value)) {
    					var filter = this.getLmemployeeleavereportfilter();
    					var lmFromDateId = filter.down('#lmFromDateId');
    					if(!isNullOrEmpty(lmFromDateId.value)) {
    						var isTrue = this.checkAcademyLocation();
    						var searchBtn = filter.down('#searchBtn');
    						if(isTrue == true) {
    							searchBtn.setDisabled(false);
    						} else if(isTrue == false) {
    							searchBtn.setDisabled(true);
    						}
    					}
    				}
    			}
    		},
    		'lmleaveslareportfilter datefield[itemId=slaFromDateId]': {
    			select: function(slaFromDateId) {
    				if(!isNullOrEmpty(slaFromDateId.value)) {
    					var filter = this.getLmleaveslareportfilter();
    					var slaToDateId = filter.down('#slaToDateId');
    					if(!isNullOrEmpty(slaToDateId.value)) {
    						var isTrue = this.checkAcademyLocation();
    						var searchBtn = filter.down('#searchBtn');
    						if(isTrue == true) {
    							searchBtn.setDisabled(false);
    						} else if(isTrue == false) {
    							searchBtn.setDisabled(true);
    						}
    					}
    				}
    			}
    		},
    		'lmleaveslareportfilter datefield[itemId=slaToDateId]': {
    			select: function(slaToDateId) {
    				if(!isNullOrEmpty(slaToDateId.value)) {
    					var filter = this.getLmleaveslareportfilter();
    					var slaFromDateId = filter.down('#slaFromDateId');
    					if(!isNullOrEmpty(slaFromDateId.value)) {
    						var isTrue = this.checkAcademyLocation();
    						var searchBtn = filter.down('#searchBtn');
    						if(isTrue == true) {
    							searchBtn.setDisabled(false);
    						} else if(isTrue == false) {
    							searchBtn.setDisabled(true);
    						}
    					}
    				}
    			}
    		},
    		'lmleaveslareportfilter button[itemId=resetBtn]': {
    			click : function(){
    				var form = this.getLmleaveslareportfilter();
    				form.getForm().reset();
    				form.down('datefield[name=slaFromDateId]').setMinValue(null);
    				form.down('datefield[name=slaFromDateId]').setMaxValue(null);
    				form.down('datefield[name=slaToDateId]').setMaxValue(null);
    				form.down('datefield[name=slaToDateId]').setMinValue(null);
    				form.down('#searchBtn').setDisabled(true);
    			}
    		},
    		'lmleaveslareportfilter button[itemId=searchBtn]': {
    			click : function() {
    				var form = this.getLmleaveslareportfilter();
    				var grid = this.getLmleaveslareportgrid();

    				var lmOrganizationForm = this.getLmorganizationunit();
    				var combo = lmOrganizationForm.down('#academyLocationItemId');
    				var academyLocationId = combo.getValue();
    				var alIds = [];
    				var academyLocationIds = null;
    				if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
    					for (var i in academyLocationId) {
    						if (Ext.isObject(academyLocationId[0])) {
    							alIds.push(academyLocationId[i].get("id"));
    						} else {
    							alIds.push(academyLocationId[i]);
    						}
    					}
    					academyLocationIds = alIds.join();
    				}

    				var store = grid.getStore();
    				store.removeAll();
    				this.resetPageSetting(grid.getStore());
    				grid.down('#dockedItemsItemId').show();
    				var fromDate = form.down('#slaFromDateId').getValue();
    				var toDate = form.down('#slaToDateId').getValue();
    				form.config.fromDate = fromDate;
    				form.config.toDate = toDate;
    				if(!isNullOrEmpty(toDate)){
    					toDate = Date.parse(toDate);
    				}
    				if(!isNullOrEmpty(fromDate)){
    					fromDate = Date.parse(fromDate);
    				}
    				store.getProxy().extraParams = {
    					from: fromDate,
    					to: toDate,
    					academyLocationIds: academyLocationIds
    				};
    				store.load();
    				/*pdf & excel report header filter*/
    		    	grid.config.searchFilterForm = form;
    			}
    		},
    		'lmleaveslareportgrid': {
            	render: function(grid) {
            		var this$ = this;
            		this$.doAccessControlValidation(grid, this$.getLEAVE_SLA_REPORT_PERMISSIONS()); 
            	},
    			beforerender: function(grid) {
    				grid.getStore().removeAll();
    				this.resetPageSetting(grid.getStore());
    				grid.down('#dockedItemsItemId').show();
    			},
    			cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
    				var $this = this;
    				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				if(e.target.tagName == 'A'){
    					if(columnName == "totalRequest" || columnName == "complied" || columnName == "violated") {
    						var $this = this;
    						var academyLocationId = record.raw.academyLocationId;
    						var reportstructure = $this.getFacultyleavedashboard();
    						var tabStructure =  reportstructure.down('dashboardreporttabstructure');
    						var tabName = getPersonModuleTranslation('LM_LEAVE_REQUESTS');
    						var lmEmployeeLeaveSLAReportStructure = Ext.widget('lmemployeeleaveslareportstructure');
    						var getLeaveRequestsTab = tabStructure.items.findBy(function(tab) {
    							if(tab.title === tabName){
    								return tab;
    							}
    						})
    						if (getLeaveRequestsTab != null) {
    							tabStructure.remove(getLeaveRequestsTab, true);
    						}
    						openTab(tabStructure, tabName, lmEmployeeLeaveSLAReportStructure, CONSTANTS.MENU_COLOR_THREE);
    						$this.loadLmemployeeleaveslareportgridData(columnName, grid)
    					}
    				}
    			}
    		},
    		'lmemployeeleaveslareportgrid' : {
    			beforerender: function(grid) {
    				grid.getStore().removeAll();
    				this.resetPageSetting(grid.getStore());
    			},
    			cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
    				var $this = this;
    				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				if(e.target.tagName == 'A'){
    					if(columnName == "view") {
    						var record = grid.getSelectionModel().getSelection()[0];
    						var employeeleavereporttimelinewin = $this.getLmemployeeleavereporttimelinewin();
    						if(isNullOrEmpty(employeeleavereporttimelinewin)){
    							Ext.widget('lmemployeeleavereporttimelinewin');
    							employeeleavereporttimelinewin = $this.getLmemployeeleavereporttimelinewin();
    						}
    						var employeeLeaveReportTimelineGrid = employeeleavereporttimelinewin.down('#lmEmployeeLeaveReportTimelineGrid');
    						this.openEmployeeLeaveReportTimelineWin(record,employeeleavereporttimelinewin,employeeLeaveReportTimelineGrid, grid);
    					}
    				}
    			}
    		},
    		/*'lmemployeeleaveslareportfilter' : {
            	render : function(filter) {
            		var this$ = this;
    		    	var form = this$.getLmorganizationunit();
    		    	var combo = form.down('#academyLocationItemId');
    		    	this.searchBtnEnableDisable(combo);
            	}
            },*/
    		'lmemployeeleaveslareportfilter button[itemId=resetBtn]' : {
    			click : function() {
    				var form = this.getLmemployeeleaveslareportfilter();
    				form.down('#lmLeaveTypeId').reset();
    			}
    		},
    		'lmemployeeleaveslareportfilter button[itemId=searchBtn]' : {
    			click : function() {
    				this.loadLmemployeeleaveslareportgridData(null, null);
    			}
    		},
    		'lmemployeeleavebalancereportstructure':{
    			render:function(f){
    				var this$ = this;
    				var form = this$.getLmorganizationunit();
    				var combo = form.down('#academyLocationItemId');
    				this.searchBtnEnableDisable(combo);
    				//this.onLMLeaveApprovalFlowReportStructureRender(f);
    			}
    		},
    		'lmemployeeleavebalancereportfilter button[itemId=resetLMEmployeeLeaveBalanceReportFilterItemId]': {
    			click: function() {
    				var form = this.getLmemployeeleavebalancereportfilter();
    				form.getForm().reset();
    				var status = form.down("#statusComboItemId")
    				status.getStore().load({
     					callback: function(records, operation, success) {
     						for (i in records) {
     							if(records[i].data.code == "ACTIVE"){
     								status.setValue(records[i].data.code);
     							}
     						}
     					}
     				});
    			}
    		},
    		'lmemployeeleavebalancereportfilter button[itemId=searchLMEmployeeLeaveBalanceReportFilterItemId]': {
    			click: function(btn) {
    				this.loadLMEmployeeLeaveBalanceReportGrid(btn);
    			}
    		},
    		'lmemployeeleavebalancereportgrid': {
    			render: function(grid){
    				var this$ = this;
    				var itemIdPrivilegeNameArray = [{"#exportReportItemId" : "EXPORT_REPORTS" }];
  	        		this$.disableRadioGroupAndOtherPivileges(grid, this$.getEMPLOYEE_LEAVE_BALANCE_REPORT_PERMISSIONS(), itemIdPrivilegeNameArray);
    			},
    			beforerender: function(grid) {
    				grid.getStore().removeAll();
    				this.resetPageSetting(grid.getStore());
    			}
    		},
    		'lmemployeeleavebalancereportgrid button[itemId=exportReportItemId]': {
           	 click: function(btn) {
        		 this.exportXlsEmployeeLeaveBalanceReport();
        	 }
         },
         'lmemployeeleavebalancereportfilter customcombobox[itemId=empLeaveBalanceItemId]':{
 			render:function(combo) {
 				this.loadUserComboData(combo);
 			}
         },
         'lmemployeeleavebalancereportfilter customcombobox[itemId=statusComboItemId]':{
  			render:function(combo) {
 				combo.getStore().load({
 					callback: function(records, operation, success) {
 						for (i in records) {
 							if(records[i].data.code == "ACTIVE"){
 								combo.setValue(records[i].data.code);
 							}
 						}
 					}
 				});
 			
  			}
          },
         
         'lmleaveencashmentreportfilter customcombobox[itemId=leaveEncashmentPeriodId]':{
        	 select: function(combo) {
        		 var filter = this.getLmleaveencashmentreportfilter();
        		 var btnSearch = filter.down('#searchLMLeaveEncashmentReportFilterItemId');
        		 this.searchBtnEnableDisable(combo);
        	 }
         },
         'lmleaveencashmentreportfilter button[itemId=searchLMLeaveEncashmentReportFilterItemId]': {
        	 click: function() {
        		 var filter = this.getLmleaveencashmentreportfilter();
        		 var gridStore = this.getLmleaveencashmentreportgrid().getStore();
        		 this.loadLMReportGrid('ENCASHMENT',filter, gridStore);
        		 /*pdf & excel report header filter*/
        		 this.getLmleaveencashmentreportgrid().config.searchFilterForm = filter;
        	 }
 		},
 		'lmleaveencashmentreportfilter button[itemId=resetLMLeaveEncashmentReportFilterItemId]': {
 			click: function() {
 				var filter = this.getLmleaveencashmentreportfilter();
 				filter.getForm().reset();
 				var btnSearch = filter.down('#searchLMLeaveEncashmentReportFilterItemId');
 				btnSearch.setDisabled(true);
 			}
 		},
 		'lmleaveencashmentreportgrid': {
 			render: function(grid){
 				var this$ = this;
 				this$.doAccessControlValidation(grid, this$.getEMPLOYEE_LEAVE_ENCASHMENT_REPORT_PERMISSIONS()); 
 			},
 			beforerender: function(grid) {
 				grid.getStore().removeAll();
 				this.resetPageSetting(grid.getStore());
 			}
 		},
 		'lmleavecarryforwardreportfilter customcombobox[itemId=leaveCarryForwardPeriodId]':{
       	 select: function(combo) {
       		 var filter = this.getLmleavecarryforwardreportfilter();
       		 var btnSearch = filter.down('#searchLMLeaveCFReportFilterItemId');
       		 this.searchBtnEnableDisable(combo);
       	 }
        },
        'lmleavecarryforwardreportfilter button[itemId=searchLMLeaveCFReportFilterItemId]': {
       	 click: function() {
       		 var filter = this.getLmleavecarryforwardreportfilter();
    		 var gridStore = this.getLmleavecarryforwardreportgrid().getStore();
       		 this.loadLMReportGrid('CARRY_FORWARD',filter, gridStore);
       		/*pdf & excel report header filter*/
       		this.getLmleavecarryforwardreportgrid().config.searchFilterForm = filter;
       	 }
		},
		'lmleavecarryforwardreportfilter button[itemId=resetLMLeaveCFReportFilterItemId]': {
			click: function() {
				var filter = this.getLmleavecarryforwardreportfilter();
				filter.getForm().reset();
				var btnSearch = filter.down('#searchLMLeaveCFReportFilterItemId');
				btnSearch.setDisabled(true);
			}
		},
		'lmleavecarryforwardreportgrid': {
 			render: function(grid){
 				var this$ = this;
 				this$.doAccessControlValidation(grid, this$.getEMPLOYEE_LEAVE_CARRY_FORWARD_REPORT_PERMISSIONS()); 
 			},
 			beforerender: function(grid) {
 				grid.getStore().removeAll();
 				this.resetPageSetting(grid.getStore());
 			}
 		},
 		'lmleavelapsereportfilter customcombobox[itemId=leaveLapsePeriodId]':{
 	       	 select: function(combo) {
 	       		 var filter = this.getLmleavelapsereportfilter();
 	       		 var btnSearch = filter.down('#searchLMLeaveLapseReportFilterItemId');
 	       		this.searchBtnEnableDisable(combo);
 	       	 }
 	        },
        'lmleavelapsereportfilter button[itemId=searchLMLeaveLapseReportFilterItemId]': {
        	click: function() {
        		var filter = this.getLmleavelapsereportfilter();
        		var gridStore = this.getLmleavelapsereportgrid().getStore();
        		this.loadLMReportGrid('LAPSE',filter, gridStore);
        		this.getLmleavelapsereportgrid().config.searchFilterForm = filter;
        	}
        },
        'lmleavelapsereportfilter button[itemId=resetLMLeaveLapseReportFilterItemId]': {
        	click: function() {
        		var filter = this.getLmleavelapsereportfilter();
        		filter.getForm().reset();
        		var btnSearch = filter.down('#searchLMLeaveLapseReportFilterItemId');
        		btnSearch.setDisabled(true);
        	}
        },
        'lmleavelapsereportgrid': {
        	render: function(grid){
        		var this$ = this;
        		this$.doAccessControlValidation(grid, this$.getEMPLOYEE_LEAVE_LAPSE_REPORT_PERMISSIONS()); 
        	},
        	beforerender: function(grid) {
        		grid.getStore().removeAll();
        		this.resetPageSetting(grid.getStore());
        	}
        },
 		'lmleavecreditreportfilter customcombobox[itemId=leaveCreditYearId]':{
	       	 select: function(combo) {
	       		 var filter = this.getLmleavecreditreportfilter();
	       		 var btnSearch = filter.down('#searchLMLeaveCreditReportFilterItemId');
	       		this.searchBtnEnableDisable(combo);
	       	 }
	        },
       'lmleavecreditreportfilter button[itemId=searchLMLeaveCreditReportFilterItemId]': {
       	click: function() {
       		var filter = this.getLmleavecreditreportfilter();
       		var gridStore = this.getLmleavecreditreportgrid().getStore();
       		this.loadLMReportGrid('CREDIT',filter, gridStore);
       		this.getLmleavecreditreportgrid().config.searchFilterForm = filter;
       	}
       },
       'lmleavecreditreportfilter button[itemId=resetLMLeaveCreditReportFilterItemId]': {
       	click: function() {
       		var filter = this.getLmleavecreditreportfilter();
       		filter.getForm().reset();
       		var btnSearch = filter.down('#searchLMLeaveCreditReportFilterItemId');
       		btnSearch.setDisabled(true);
       	}
       },
       'lmleavecreditreportgrid': {
       	render: function(grid){
       		var this$ = this;
       		this$.doAccessControlValidation(grid, this$.getEMPLOYEE_LEAVE_CREDIT_REPORT_PERMISSIONS()); 
       	},
       	beforerender: function(grid) {
       		grid.getStore().removeAll();
       		this.resetPageSetting(grid.getStore());
       	}
       },
       'lmemployeeleavereporttimelinewin':{
			render:function(win){
				var permissionsMap = this.getEMPLOYEE_LEAVE_REPORT_PERMISSIONS();
				var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				var cancelBtn = win.down('#lmCancelButtonId');
				cancelBtn.setVisible(false);
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'CANCEL') {
						if (!isNullOrEmpty(cancelBtn)) {
							cancelBtn.setVisible(true);
						}
					}
				});
			}
		}
    	});
      },
    
      resetAllLinkedStore:  function(){
      	var me = this;
      	if(Ext.isDefined(me.getLmemployeeleavereportfilter())) {
      		var requesterNameField = me.getLmemployeeleavereportfilter().down('#requesterNameOrIdItemId');
      		requesterNameField.clearValue();
      		requesterNameField.rawValue = '';
      		requesterNameField.lastValue = '';
      		requesterNameField.lastQuery = '';
      		requesterNameField.getStore().removeAll();
      	} 
      	if(Ext.isDefined(me.getLmleaveapprovalflowreportfilter())) {
      		var empField = me.getLmleaveapprovalflowreportfilter().down('#empItemId');
      		empField.clearValue();
      		empField.rawValue = '';
      		empField.lastValue = '';
      		empField.lastQuery = '';
      		empField.getStore().removeAll()
      	} 
      	if(Ext.isDefined(me.getLmemployeeleavebalancereportfilter())) {
      		var empField = me.getLmemployeeleavebalancereportfilter().down('#empLeaveBalanceItemId');
      		empField.clearValue();
      		empField.rawValue = '';
      		empField.lastValue = '';
      		empField.lastQuery = '';
      		empField.getStore().removeAll()
      	} 
      },
    
    openEmployeeReportStructure : function(treePanel, record, item, index, e, eOpts){
   	 var $this = this;
   	 var reportstructure = $this.getFacultyleavedashboard();
   	 var treeTab = reportstructure.down('#facultyReportTreePanelItemId');
   	 var tabStructure =  reportstructure.down('dashboardreporttabstructure');
   	 var tabDetail = record.data;
   	 var structure = Ext.widget(tabDetail.reportXtype);
   	 var tabs = tabStructure.items.items;

   	 if (!isNullOrEmpty(tabDetail.text) && !isNullOrEmpty(tabDetail.reportXtype)
   			 && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
   		 treeTab.toggleCollapse();
   		 openTab(tabStructure, tabDetail.text, structure);
   		 treePanel.getSelectionModel().deselectAll();
   		//var leaveApprovalGrid = $this.getLmleaveapprovalflowreportgrid();
   		/*if(!isNullOrEmpty(leaveApprovalGrid) && leaveApprovalGrid != undefined) {
   			var leavePagingToolbar = leaveApprovalGrid.down('custompagingtoolbar');
   			leaveApprovalGrid.getStore().removeAll();
   			leavePagingToolbar.bindStore(leaveApprovalGrid.getStore());
   			leavePagingToolbar.onLoad();
   		}*/
   	 }
    },
    
    openEmployeeReportStructureByDashlet : function(columnName, academyLocationId, status, fromDate, toDate){
    	var $this = this;
    	var facultyId = $this.getCurrentlyLoggedInUser().id;
    	var facultyCode = $this.getCurrentlyLoggedInUser().code;
    	var reportstructure = $this.getFacultyleavedashboard();
    	var treeTab = reportstructure.down('#facultyReportTreePanelItemId');
    	var tabStructure =  reportstructure.down('dashboardreporttabstructure');
    	var structure = Ext.widget('lmemployeeleavereportstructure');
    	var tabs = tabStructure.items.items;

    	treeTab.toggleCollapse();
    	openTab(tabStructure,getServiceRequestTranslation('EMPLOYEE_LEAVE_REPORT'), structure);
    	var reportFilter = $this.getLmemployeeleavereportfilter();
    	var frmDate = reportFilter.down('#lmFromDateId');
    	var endDate = reportFilter.down('#lmToDateId');
    	frmDate.setValue(dateRender(fromDate));
    	endDate.setValue(dateRender(toDate));
    	
    	var alForm = $this.getLmorganizationunit();
    	var alCombo = alForm.down('#academyLocationItemId');
    	
		var requesterName = reportFilter.down('#requesterNameOrIdItemId');
		var store = requesterName.getStore();
		
		var configStatus = reportFilter.down('#lmConfigStatus');
		var configStore = configStatus.getStore();
		
		alCombo.getStore().load({
			callback: function(records, operation, success) {
				for (i in records) {
					if(records[i].data.id == academyLocationId){
						alCombo.setValue(academyLocationId);
						break;
					}
				}
			}
		});
		Ext.defer(function() {
			//$this.loadUserComboData(requesterName,true);
			/*store.getProxy().extraParams = {
				academyLocationIds : academyLocationId,
				name:facultyCode,
				isBeforeLoadRequired: false
			};*/
			
			/*store.load({
    			callback: function(records, operation, success) {
    				if (success) {
    					for(var i in records){
    						if(records[i].data.id == facultyId){
        						requesterName.setValue(records[i].data.id);
        					}
    					}
    					
    					
    					configStore.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								for(var i in records){
    									if(records[i].data.value == status){
    										configStatus.setValue(records[i].data.value);
    			    						break;
    			    					}
    								}
    								
    								$this.loadEmployeeLeaveReportData();
    							}
    						}	   
    					});
    				}
    			}	   
    		})*/
			configStore.load({
				callback: function(records, operation, success) {
					if (success) {
						for(var i in records){
							if(records[i].data.value == status){
								configStatus.setValue(records[i].data.value);
	    						break;
	    					}
						}
						
						$this.loadEmployeeLeaveReportData();
					}
				}	   
			});
		}, 1000);
    	
       },
    
    resetOrganizationunit:function(obj){
    	var form = obj.up('form');
    	form.down('#academyLocationItemId').reset();
    	var academyLocationCombo = form.down('#academyLocationItemId');
		var contentPanel = Ext.ComponentQuery.query('contentPanel');
		if (contentPanel.length == 1) {
			var x = contentPanel[0].getActiveTab();
			if (x.getXType() == 'facultyleavedashboard') {
				var a = academyLocationCombo.el.down('[name=academyLocationId]');
				if (a != null) {
					a.setHeight('auto');
				}
				academyLocationCombo.el.dom.style.height = 'auto';
				academyLocationCombo.up('form').doLayout();
			}
		}
    },
    onLMLeaveApprovalFlowReportStructureRender:function(form){
    	var this$ = this;
    	var form = this$.getLmorganizationunit();
    	var combo = form.down('#academyLocationItemId');
    	this.searchBtnEnableDisable(combo);
    	/*
    	var this$ = this;
    	var lmorganizationunitForm = this$.getLmorganizationunit().getForm();
    	var alValues = lmorganizationunitForm.getValues();
    	var academyLocationIdListStr = null;
    	var academyLocationIdList = [];
    	if (alValues.academyLocationId != undefined && alValues.academyLocationId.length > 0) {
    		var records = alValues.academyLocationId;
    		for (i in records) {
				var record = records[i];
				if(Ext.isObject(record)){
					academyLocationIdList.push(record.data.id);	
				}else {
					academyLocationIdList.push(record);
				}
			}
    		academyLocationIdListStr = academyLocationIdList.join();
    		
    	}
			var empStore = this$.getStore('criteriabuilder.userquicksearch.QuickSearchName');
			empStore.getProxy().extraParams = {
				academyLocationIds: academyLocationIdListStr
			};
			empStore.load({
				callback: function(record, operation, success) {
					if (success) {
					}
				}
			});
		*/},
		loadUserComboData : function(combo,isDashlet) {
			var this$ = this;
			/*var proxyCK = true;
			try{
				proxyCK = combo.getStore().getProxy().extraParams.isBeforeLoadRequired;
			}
			catch(e){
				console.log('');
			}*/
			//if(proxyCK){
				combo.getStore().on('beforeload', function(){
					var alForm = this$.getLmorganizationunit();
					var alCombo = alForm.down('#academyLocationItemId');
					var academyLocationId = alCombo.getValue();
					var alIds = [];
					var academyLocationIds = null;
					var store = combo.getStore();
					if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
						for (var i in academyLocationId) {
							if (Ext.isObject(academyLocationId[0])) {
								alIds.push(academyLocationId[i].get("id"));
							} else {
								alIds.push(academyLocationId[i]);
							}
						}
						academyLocationIds = alIds.join();
					    if(!isNullOrEmpty(store)) {
					    	store.getProxy().extraParams = {
								academyLocationIds : academyLocationIds
							};
					    }
					   // this$.resetAllLinkedStore()
						return true;
					} else {
						this$.resetAllLinkedStore()
						return false;
					}
				});
		//	}
		},
		loadLMLeaveApprovalGrid: function() {
	    	var this$ = this;
	    	var lmorganizationunitForm = this$.getLmorganizationunit().getForm();
	    	var alValues = lmorganizationunitForm.getValues();
	    	var academyLocationIdListStr = null;
	    	var academyLocationIdList = [];
	    	if (alValues.academyLocationId != undefined && alValues.academyLocationId.length > 0) {
	    		var records = alValues.academyLocationId;
	    		for (i in records) {
					var record = records[i];
					if(Ext.isObject(record)){
						academyLocationIdList.push(record.data.id);	
					}else {
						academyLocationIdList.push(record);
					}
				}
	    		academyLocationIdListStr = academyLocationIdList.join();
	    		
	    	}
	    	var leaveApprovalFilter = this$.getLmleaveapprovalflowreportfilter();
			var empIdField = leaveApprovalFilter.down('#empItemId')
			var departmentIdField = leaveApprovalFilter.down('#cmbDepartmentItemId');
			var designationIdField = leaveApprovalFilter.down('#designationItemId');
			var statusField = leaveApprovalFilter.down('#statusComboItemId');
			var empId = null;
			var departmentId = null;
			var designationId = null;
			if(empIdField!=null || empIdField!=undefined){
				empId = empIdField.value;
			}
			if(departmentIdField!=null || departmentIdField!=undefined){
				departmentId = departmentIdField.value;
			}
			if(designationIdField!=null || designationIdField!=undefined){
				designationId = designationIdField.value;
			}
			if(statusField!=null || statusField!=undefined){
				status = statusField.value;
			}
			
			var leaveApprovalGrid = this$.getLmleaveapprovalflowreportgrid().getStore();
			leaveApprovalGrid.getProxy().extraParams = {
					academyLocationIds:academyLocationIdListStr,
					employeeId:empId,
					departmentId:departmentId,
					designationId:designationId,
					status:status
				};
			this.resetPageSetting(leaveApprovalGrid);
			leaveApprovalGrid.load();
			/*pdf & excel report header filter*/
			this$.getLmleaveapprovalflowreportgrid().config.searchFilterForm = leaveApprovalFilter;
			}, 
		resetLmleaveapprovalflowreportfilter: function() {
	        var form = this.getLmleaveapprovalflowreportfilter();
	        form.getForm().reset();
	    },
	    setAllAlIds:function(form,alDashlet){
	    	var $this = this;
	    	var academyLocationCombo = $this.getLmorganizationunit();
	    	var combo = academyLocationCombo.down('#academyLocationItemId');
	    	var academyLocationIds=[];
	    	combo.getStore().load({
	    		callback: function(records, operation, success) {
	    			for (i in records) {
	    				var record = records[i];
	    				if(Ext.isObject(record)){
	    					academyLocationIds.push(record.data.id);	
	    				}else {
	    					academyLocationIds.push(record[i]);
	    				}
	    			}
	    			if(alDashlet == null){
	    				combo.setValue(academyLocationIds);
	    			}else{
	    				//combo.setValue(alDashlet);
	    			}
	    			
	    		}
	    	});
	    },
	    loadEmployeeLeaveReportData:function(){
	    	var $this = this;
	    	var alForm = $this.getLmorganizationunit();
	    	var alCombo = alForm.down('#academyLocationItemId');
	    	var academyLocationId = alCombo.getValue();
	    	var alIds = [];
	    	var academyLocationIds = null;
	    	if(typeof academyLocationId!="object" && academyLocationId>0){
	    		academyLocationIds = academyLocationId
			}
	    	else if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
	    		for (var i in academyLocationId) {
	    			if (Ext.isObject(academyLocationId[0])) {
	    				alIds.push(academyLocationId[i].get("id"));
	    			} else {
	    				alIds.push(academyLocationId[i]);
	    			}
	    		}
	    		academyLocationIds = alIds.join();
	    	}
	    	var employeeLeaveReportFilter = this.getLmemployeeleavereportfilter();
	    	var requesterId = employeeLeaveReportFilter.down('#requesterNameOrIdItemId').value; 
	    	var fromDate = employeeLeaveReportFilter.down('#lmFromDateId').value; 
	    	var toDate = employeeLeaveReportFilter.down('#lmToDateId').value; 
	    	var status = employeeLeaveReportFilter.down('#lmConfigStatus').getRawValue(); 
	    	var leaveTypeId = employeeLeaveReportFilter.down('#lmLeaveTypeId').value; 
	    	var departmentId = employeeLeaveReportFilter.down('#cmbDepartment').value; 
	    	var designationId = employeeLeaveReportFilter.down('#designationCombo').value;
	    	
	    	if(fromDate != null){
	    		fromDate= new Date(fromDate);
	    		fromDate = Ext.Date.format(fromDate, 'Y-m-d');
                  }
            
            if(toDate != null){
            	toDate= new Date(toDate);
            	toDate = Ext.Date.format(toDate, 'Y-m-d');
                  }
	    	
	    	

	    	var employeeLeaveReportGrid = this.getLmemployeeleavereportgrid();
	    	var employeeLeaveReportStore = employeeLeaveReportGrid.getStore();
	    	employeeLeaveReportStore.getProxy().extraParams = {
	    		academyLocationIds : academyLocationIds,
	    		empId : requesterId,
	    		//fromDate : fromDate.toISOString().split('.')[0],
	    		//toDate : toDate.toISOString().split('.')[0],
	    		fromDate :fromDate,
	    		toDate : toDate,
	    		status : status,
	    		leaveTypeId : leaveTypeId,
	    		departmentId : departmentId,
	    		designationId : designationId
	    	};
	    	$this.resetPageSetting(employeeLeaveReportStore);
	    	employeeLeaveReportStore.load();
	    	Ext.getBody().unmask();
	    	/*pdf & excel report header filter*/
	    	employeeLeaveReportGrid.config.searchFilterForm = employeeLeaveReportFilter;
	    },
	    reqPendingActionDetailBtnEnableDisable : function(approveBtn,rejectBtn,record) {
			var approverId;
			approverId = this.getCurrentlyLoggedInUser().id;
			
			if(record.data.reqApprover.id == approverId) {
				if(record.data.status == 'Pending') {
					approveBtn.setDisabled(false);
					rejectBtn.setDisabled(false);
				}
			} else {
				approveBtn.setDisabled(true);
				rejectBtn.setDisabled(true);
			}
		},
	    openEmployeeLeaveReportTimelineWin: function(record,formWindow,employeeLeaveReportTimelineGrid, grid) {
	    	var $this =this;
	    	var reqId;
	    	var fromDate =  new Date(record.get('fromDate'));
			var currentDate = new Date().setHours(0,0,0,0);
			currentDate = new Date(currentDate);
			if(formWindow.xtype == 'lmemployeeleavereporttimelinewin') {
				if(this.getCurrentLoggedPortalId()== 1) {
					formWindow.down('#lmCancelButtonId').setVisible(true)
					if(currentDate<=fromDate) {
						formWindow.down('#lmCancelButtonId').setDisabled(false)
					} else {
						formWindow.down('#lmCancelButtonId').setDisabled(true)
					}
					
				} else {
					formWindow.down('#lmCancelButtonId').setVisible(false)
				}
			}
	    	if(!isNullOrEmpty(grid) && grid.panel.xtype == 'lmemployeeleaveslareportgrid') {
	    		reqId = record.raw.leaveRequestId; 
	    	} else {
	    		reqId = record.raw.hrLeaveReqId; 
	    	}

	    	if(record.data.status != 'Pending') {
	    		var lmEmployeeLeaveReportTimelineForm = formWindow.down('#lmEmployeeLeaveReportTimelineFormItemId');
	    		lmEmployeeLeaveReportTimelineForm.setVisible(false)
	    		
	    	}

	    	if(this.getCurrentLoggedPortalId()==1){
	    	    if(record.data.status =='Approved'){
	    	    	  var lmEmployeeLeaveReportTimelineForm = formWindow.down('#lmEmployeeLeaveReportTimelineFormItemId');
	    	          lmEmployeeLeaveReportTimelineForm.setVisible(true)
	    	          formWindow.down('#lmCancelButtonId').setVisible(true);
	    	          formWindow.down('#lmCancelButtonId').setDisabled(false);
	    	          formWindow.down('#lmApproveButtonId').setDisabled(true);
	    	          formWindow.down('#lmRejectButtonId').setDisabled(true);
	    	}
	    	    }
	        var store = employeeLeaveReportTimelineGrid.getStore();
	        
	        store.getProxy().extraParams = {
	        	requestId: reqId
	        };
	        store.load({
	        	callback : function(records,operation,success) { 
	        		var approverFlow;
	        		var lmEmployeeLeaveReportTimelineWin = $this.getLmemployeeleavereporttimelinewin();
	        		if(!isNullOrEmpty(lmEmployeeLeaveReportTimelineWin)) {
	        			lmEmployeeLeaveReportTimelineWin.config.grid = grid;
	        			approverFlow = $this.getLmemployeeleavereporttimelinewin().down('#approvalFlowItemId');
	        		}
	        		if(records.length > 0) {
	        			if(records[0].raw.approverType == 'SEQUENTIAL') {
	        				approverFlow.setValue('Sequential');
	        			}else if(records[0].raw.approverType == 'PARALLEL'){
	        				approverFlow.setValue('Parallel');
	        			}
	        		} else {
	        			approverFlow.setValue('Auto Approve');
	        		}
	        	}});
	        formWindow.show();
	    },
	    empLeaveReportTimelineBtnClick : function(approveOrReject) {
	    	var $this=this;
	    	var win = this.getLmemployeeleavereporttimelinewin();
	    	var grid = win.down('#lmEmployeeLeaveReportTimelineGrid');
	    	var form = win.down('#lmEmployeeLeaveReportTimelineFormItemId');
	    	var record = grid.getSelectionModel().getSelection()[0];
	    	var approverLevelId = record.data.approverLevelId;
	    	var allRecord = record.store.data.items;
	    	var comment = form.down('#rpaCommentItemId').getValue();
	    	var empLeaveRequest = record.raw;
	    	if(!isNullOrEmpty(comment)) {
	    		empLeaveRequest.comment = comment;
	    	}
	    	empLeaveRequest.status = approveOrReject;
	    	if(approveOrReject == 'APPROVED') {
	    		var flag = true;
	    		for(var i=0; i<allRecord.length; i++) {
	    			if(allRecord[i].data.approverLevelId != approverLevelId && allRecord[i].data.status == 'Pending') {
	    				flag = false;
	    				break;
	    			}
	    		}
	    		if(flag == true) {
	    			empLeaveRequest.parentStatus = 'APPROVED';
	    		}
	    	}else {
	    		empLeaveRequest.parentStatus = 'REJECTED';
	    	}
	    	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	    	Ext.Ajax.request({
	    		type: 'rest',
	    		url: SERVERURL.HR_EMP_LEAVE_REQUEST_DETAILS_UPDATE,
	    		jsonData: empLeaveRequest,
	    		method: 'POST',
	    		success: function(frm, action) {
	    			var data = frm.responseText;
	    			showSuccessMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('SUCCESS'));
	    			win.config.grid.getStore().load();
	    			win.close();
	    			Ext.getBody().unmask();
	    		}
	    	});
	    },
	    checkAcademyLocation : function(){
    		var $this = this;
			var alForm = $this.getLmorganizationunit();
			var alCombo = alForm.down('#academyLocationItemId');
			var academyLocationId = alCombo.getValue();
			if(typeof academyLocationId!="object" && academyLocationId>0){
				return true;
			}
			else if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
				return true;
			} else {
				return false;
			}
    	},
    	searchBtnEnableDisable : function(combo) {
    		if(!isNullOrEmpty(combo.getValue())){
    			if(Ext.isDefined(this.getLmemployeeleavereportfilter())) {
    				var filter = this.getLmemployeeleavereportfilter();
    				var isTrue  = this.checkAcademyLocation();
    				var searchBtn = filter.down('#searchBtn');
    				var lmFromDate = filter.down('#lmFromDateId');
    				var lmToDate = filter.down('#lmToDateId');
    				if(isTrue == true && !isNullOrEmpty(lmFromDate.getValue()) && !isNullOrEmpty(lmToDate.getValue())) {
    					searchBtn.setDisabled(false);
    				}else if(isTrue == false) {
    					searchBtn.setDisabled(true);
    				}
    			} 
    			if(Ext.isDefined(this.getLmleaveapprovalflowreportfilter())) {
    				var filter = this.getLmleaveapprovalflowreportfilter();
    				var isTrue  = this.checkAcademyLocation();
    				var searchBtn = filter.down('#searchLMLeaveApprovalFlowReportFilterItemId');
    				if(isTrue == true) {
    					searchBtn.setDisabled(false);
    				} else if(isTrue == false) {
    					searchBtn.setDisabled(true);
    				}
    			}
    			if(Ext.isDefined(this.getLmleaveslareportfilter())) {
    				var filter = this.getLmleaveslareportfilter();
    				var isTrue  = this.checkAcademyLocation();
    				var searchBtn = filter.down('#searchBtn');
    				var slaFromDateId = filter.down('#slaFromDateId');
    				var slaToDateId = filter.down('#slaToDateId');
    				if(isTrue == true && !isNullOrEmpty(slaFromDateId.getValue()) && !isNullOrEmpty(slaToDateId.getValue())) {
    					searchBtn.setDisabled(false);
    				}else if(isTrue == false) {
    					searchBtn.setDisabled(true);
    				}
    			}
    			if(Ext.isDefined(this.getLmemployeeleavebalancereportfilter())) {
    				var filter = this.getLmemployeeleavebalancereportfilter();
    				var isTrue  = this.checkAcademyLocation();
    				var searchBtn = filter.down('#searchLMEmployeeLeaveBalanceReportFilterItemId');
    				if(isTrue == true) {
    					searchBtn.setDisabled(false);
    				} else if(isTrue == false) {
    					searchBtn.setDisabled(true);
    				}
    			}
    			if(Ext.isDefined(this.getLmleaveencashmentreportfilter())) {
    				var filter = this.getLmleaveencashmentreportfilter();
    				var periodCombo = filter.down('#leaveEncashmentPeriodId');
    				var isTrue  = this.checkAcademyLocation();
    				var searchBtn = filter.down('#searchLMLeaveEncashmentReportFilterItemId');
    				if(isTrue == true && !isNullOrEmpty(periodCombo.getValue())) {
    					searchBtn.setDisabled(false);
    				} else if(isTrue == false) {
    					searchBtn.setDisabled(true);
    				}
    			}
    			if(Ext.isDefined(this.getLmleavecarryforwardreportfilter())) {
    				var filter = this.getLmleavecarryforwardreportfilter();
    				var periodCombo = filter.down('#leaveCarryForwardPeriodId');
    				var isTrue  = this.checkAcademyLocation();
    				var searchBtn = filter.down('#searchLMLeaveCFReportFilterItemId');
    				if(isTrue == true && !isNullOrEmpty(periodCombo.getValue())) {
    					searchBtn.setDisabled(false);
    				} else if(isTrue == false) {
    					searchBtn.setDisabled(true);
    				}
    			}
    			if(Ext.isDefined(this.getLmleavelapsereportfilter())) {
    				var filter = this.getLmleavelapsereportfilter();
    				var periodCombo = filter.down('#leaveLapsePeriodId');
    				var isTrue  = this.checkAcademyLocation();
    				var searchBtn = filter.down('#searchLMLeaveLapseReportFilterItemId');
    				if(isTrue == true && !isNullOrEmpty(periodCombo.getValue())) {
    					searchBtn.setDisabled(false);
    				} else if(isTrue == false) {
    					searchBtn.setDisabled(true);
    				}
    			}
    			if(Ext.isDefined(this.getLmleavecreditreportfilter())) {
    				var filter = this.getLmleavecreditreportfilter();
    				var periodCombo = filter.down('#leaveCreditYearId');
    				var isTrue  = this.checkAcademyLocation();
    				var searchBtn = filter.down('#searchLMLeaveCreditReportFilterItemId');
    				if(isTrue == true && !isNullOrEmpty(periodCombo.getValue())) {
    					searchBtn.setDisabled(false);
    				} else if(isTrue == false) {
    					searchBtn.setDisabled(true);
    				}
    			}
    			/*if(Ext.isDefined(this.getLmemployeeleaveslareportfilter())) {
    				var filter = this.getLmemployeeleaveslareportfilter();
    				var isTrue  = this.checkAcademyLocation();
    				var searchBtn = filter.down('#searchBtn');
    				if(isTrue == true) {
    					searchBtn.setDisabled(false);
    				} else if(isTrue == false) {
    					searchBtn.setDisabled(true);
    				}
    			}*/
    		}
    	},
    	loadLmemployeeleaveslareportgridData : function(columnName, grid) {
    		var $this = this;
    		var academyLocationId;
    		if(!isNullOrEmpty(columnName)) {
    			var filter = $this.getLmleaveslareportfilter();
    			var fromDate = filter.config.fromDate;
    			var toDate = filter.config.toDate;
    			
    			var employeeLeaveSlaReportFilter = $this.getLmemployeeleaveslareportfilter();
    			employeeLeaveSlaReportFilter.down('#slaLeaveFromDateId').setValue(fromDate);
    			employeeLeaveSlaReportFilter.down('#slaLeaveToDateId').setValue(toDate);
    			employeeLeaveSlaReportFilter.down('#academyLocationItemId').setValue(grid.getSelectionModel().getSelection()[0].data.academyLocation)
        		
    			if(!isNullOrEmpty(toDate)){
        			toDate = Date.parse(toDate);
        		}
        		if(!isNullOrEmpty(fromDate)){
        			fromDate = Date.parse(fromDate);
        		}
        		employeeLeaveSlaReportFilter.config.columnName = columnName;
        		employeeLeaveSlaReportFilter.config.academyLocationId = grid.getSelectionModel().getSelection()[0].data.academyLocationId;
        		academyLocationId = employeeLeaveSlaReportFilter.config.academyLocationId;
    		}else {
    			var employeeLeaveSlaReportFilter = $this.getLmemployeeleaveslareportfilter();
    			var fromDate = employeeLeaveSlaReportFilter.down('#slaLeaveFromDateId').getValue();
    			var toDate = employeeLeaveSlaReportFilter.down('#slaLeaveToDateId').getValue();
    			var leaveTypeId = employeeLeaveSlaReportFilter.down('#lmLeaveTypeId').getValue();
    			if(!isNullOrEmpty(fromDate)){
    				fromDate = Date.parse(fromDate);
    			}
    			if(!isNullOrEmpty(toDate)){
    				toDate = Date.parse(toDate);
    			}
    			columnName = employeeLeaveSlaReportFilter.config.columnName;
    			academyLocationId = employeeLeaveSlaReportFilter.config.academyLocationId;
    			}
			var grid = $this.getLmemployeeleaveslareportgrid();
			var store = grid.getStore();
			var requestType;
			if(columnName == "totalRequest"){
				requestType = 'TOTALREQUEST';
			} else if(columnName == "complied" ) {
				requestType = 'COMPLIEDREQUEST';
			} else if(columnName == "violated" ) {
				requestType = 'VIOLATEDREQUEST';
    		}
			store.getProxy().extraParams = {
				requestType : requestType,
				academyLocationId : academyLocationId,
				from : fromDate,
				to : toDate,
				leaveTypeId : leaveTypeId
			};
			this.resetPageSetting(store);
			store.load();
    	},
    	loadLMEmployeeLeaveBalanceReportGrid: function(btn){

	    	var $this = this;
	    	var alForm = $this.getLmorganizationunit();
	    	var alCombo = alForm.down('#academyLocationItemId');
	    	var academyLocationId = alCombo.getValue();
	    	var alIds = [];
	    	var academyLocationIds = null;
	    	if(typeof academyLocationId!="object" && academyLocationId>0){
	    		academyLocationIds = academyLocationId
			}
	    	else if ((!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0)) {
	    		for (var i in academyLocationId) {
	    			if (Ext.isObject(academyLocationId[0])) {
	    				alIds.push(academyLocationId[i].get("id"));
	    			} else {
	    				alIds.push(academyLocationId[i]);
	    			}
	    		}
	    		academyLocationIds = alIds.join();
	    	}
	    	var lmEmpLeaveBalanceReportFilter = this.getLmemployeeleavebalancereportfilter();
	    	var requesterId = lmEmpLeaveBalanceReportFilter.down('#empLeaveBalanceItemId').value; 
	    	var departmentId = lmEmpLeaveBalanceReportFilter.down('#leaveBalancecmbDepartmentItemId').value; 
	    	var designationId = lmEmpLeaveBalanceReportFilter.down('#leaveBalanceDesignationItemId').value;
	    	var statusComboItemId = lmEmpLeaveBalanceReportFilter.down('#statusComboItemId').value;

	    	var lmEmpLeavebalReportGrid = this.getLmemployeeleavebalancereportgrid();
	    	var lmEmpLeavebalReportStore = lmEmpLeavebalReportGrid.getStore();
	    	lmEmpLeavebalReportStore.getProxy().extraParams = {
	    		academyLocationIds : academyLocationIds,
	    		staffId : requesterId,
	    		departmentId : departmentId,
	    		designationId : designationId,
	    		status:statusComboItemId
	    	};
	    	$this.resetPageSetting(lmEmpLeavebalReportStore);
	    	lmEmpLeavebalReportStore.load();
	    	Ext.getBody().unmask();
	    	
    	},
        
    	exportXlsEmployeeLeaveBalanceReport : function() {

    		var $this = this;
    		var dt = new Date();
    		var dateString = Ext.Date.format(dt, 'YmdHis'); 
    		var reportTitle = "Employee Leave Balance Report (Pivot)"+"_"+dateString;
    		var code = 'EMPLOYEE_LEAVE_BALANCE_XCEL_EXPORT_REPORT';

    		var alForm = $this.getLmorganizationunit();
    		var alCombo = alForm.down('#academyLocationItemId');
    		var aLId = alCombo.getValue();
    		var alIds = [];
    		var academyLocationId = null;
    		if(typeof aLId!="object" && aLId>0){
    			academyLocationId = aLId
    		}
    		else if (!isNullOrEmpty(aLId) && aLId.length > 0) {
    			for (var i in aLId) {
    				if (Ext.isObject(aLId[0])) {
    					alIds.push(aLId[i].get("id"));
    				} else {
    					alIds.push(aLId[i]);
    				}
    			}
    			academyLocationId = alIds.join();
    		}
    		var lmEmpLeaveBalanceReportFilter = this.getLmemployeeleavebalancereportfilter();
    		var requesterId = lmEmpLeaveBalanceReportFilter.down('#empLeaveBalanceItemId').value; 
    		var departmentId = lmEmpLeaveBalanceReportFilter.down('#leaveBalancecmbDepartmentItemId').value; 
    		var designationId = lmEmpLeaveBalanceReportFilter.down('#leaveBalanceDesignationItemId').value;
	    	var statusComboItemId = lmEmpLeaveBalanceReportFilter.down('#statusComboItemId').value;

    		var reportParams = new Object();
    		reportParams.requesterId = requesterId;
    		reportParams.academyLocationId = academyLocationId;
    		reportParams.designationId = designationId;
    		reportParams.departmentId = departmentId;
    		reportParams.status = statusComboItemId;

    		reportParams.headerName = getProgramandcourseTranslation('Employee Leave Balance Report');
    		$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.EXPORT_EMPLOYEE_LEAVE_BALANCE_REPORT);
    	},
    	
    	loadLMReportGrid: function(report, filter, gridStore) {
    		var this$ = this;
    		var lmorganizationunitForm = this$.getLmorganizationunit().getForm();
    		var alValues = lmorganizationunitForm.getValues();
    		var academyLocationIdListStr = null;
    		var academyLocationIdList = [];
    		if (alValues.academyLocationId != undefined && alValues.academyLocationId.length > 0) {
    			var records = alValues.academyLocationId;
    			for (i in records) {
    				var record = records[i];
    				if(Ext.isObject(record)){
    					academyLocationIdList.push(record.data.id);	
    				}else {
    					academyLocationIdList.push(record);
    				}
    			}
    			academyLocationIdListStr = academyLocationIdList.join();

    		}
    		var periodId;
    		var year;
    		var leaveCreditPeriod;
    		if(report == 'ENCASHMENT') {
    			periodId = filter.down('#leaveEncashmentPeriodId');
    		} else if(report == 'CARRY_FORWARD'){
    			periodId = filter.down('#leaveCarryForwardPeriodId');
    		} else if(report == 'CREDIT'){
    			year = filter.down('#leaveCreditYearId');
    			leaveCreditPeriod = filter.down('#leaveCreditPeriodId');
    		} else {
    			periodId = filter.down('#leaveLapsePeriodId');
    		}
    		
    		var empIdField = filter.down('#empItemId');
    		var departmentIdField = filter.down('#cmbDepartmentItemId');
    		var designationIdField = filter.down('#designationItemId');
    		var leaveTypeField = filter.down('#lmLeaveTypeId');
    		
    		var empId = null;
    		var departmentId = null;
    		var designationId = null;
    		if(empIdField!=null || empIdField!=undefined){
    			empId = empIdField.value;
    		}
    		if(departmentIdField!=null || departmentIdField!=undefined){
    			departmentId = departmentIdField.value;
    		}
    		if(designationIdField!=null || designationIdField!=undefined){
    			designationId = designationIdField.value;
    		}
    		
    		if(report == 'CREDIT') {
    			gridStore.getProxy().extraParams = {
        			academyLocationIds:academyLocationIdListStr,
        			year:year.getValue(),
        			leaveCreditPeriod : leaveCreditPeriod.getValue(), 
        			leaveTypeId:leaveTypeField.getValue(),
        			staffId:empId,
        			departmentId:departmentId,
        			designationId:designationId
        		};
    		} else {gridStore.getProxy().extraParams = {
    			report:report,
    			academyLocationIds:academyLocationIdListStr,
    			year:periodId.getValue(),
    			leaveTypeId:leaveTypeField.getValue(),
    			staffId:empId,
    			departmentId:departmentId,
    			designationId:designationId
    		};}
    		this.resetPageSetting(gridStore);
    		gridStore.load();
    	}
});
