/**
 * @author Deepak Nigam
 */
Ext.define('Academia.controller.manageDetention.ManageDetentionController', {
	extend : 'Academia.controller.base.BaseController',
    stores: ['manageDetention.DetentionCriteriaListStore','manageDetention.DetentionMappedEventStore','common.ProgramStore','enquiry.BatchAndStartEndDateStore',
             'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','manageDetention.DetentionAvailableEventStore','manageDetention.DetainedStduentStore',
             'manageDetention.DetentionGradeStore'],
    models: [],//'
    views: ['baselayout.contentarea.ContentPanel','manageDetention.ManageDetentionStrucure','manageDetention.manageDetentionGrid','manageDetention.DetentionCriteriaWin',
            'manageDetention.ApplyToDetentionCriteria','manageDetention.MappedEventGrid','manageDetention.ApplyToAddStructure','manageDetention.EventMappingFilter',
            'manageDetention.EventList','manageDetention.DetainedStudents','manageDetention.DetainedStudentGrid'],
    config:{
   	 	//GRADE_MASTER_GROUP_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('GRADE_MASTER_GROUP_PRIVILEGES')
    },
    refs: [{
		 	   ref : 'contentPanel',
			   selector : 'contentpanel' 
		   },{
		        ref: 'managedetentionstrucure',
		        selector: 'managedetentionstrucure'
	    	},{
		        ref: 'managedetentiongrid',
		        selector: 'managedetentiongrid'
	    	},{
		        ref: 'detentioncriteriawin',
		        selector: 'detentioncriteriawin'
	    	},{
		        ref: 'applytodetentioncriteria',
		        selector: 'applytodetentioncriteria'
	    	},{
		        ref: 'mappedeventgrid',
		        selector: 'mappedeventgrid'
	    	},{
		        ref: 'applytoaddstructure',
		        selector: 'applytoaddstructure'
	    	},{
		        ref: 'eventmappingfilter',
		        selector: 'eventmappingfilter'
	    	},{
		        ref: 'eventlist',
		        selector: 'eventlist'
	    	},{
		        ref: 'detainedstudents',
		        selector: 'detainedstudents'
	    	},{
		        ref: 'detainedstudentgrid',
		        selector: 'detainedstudentgrid'
	    	}],
    init: function(application) {
        this.control({
	        
        	'managedetentiongrid' : {
            	render: function(obj) {
            		obj.getStore().load();
            	}
        	},
        	
        	'eventlist  button[itemId=btnAdd]': {
	            click: function(obj) {
	            	this.applyDetentionCriteria();
	            }
	        },
	        
	        'eventlist': {
	            render: function(obj) {
	            	obj.getStore().removeAll();
	            	obj.getStore().loadData([]);
	            }
	        },
        	'mappedeventgrid  button[itemId=btnAdd]': {
	            click: function(obj) {
	            	this.OpenAddEventMapping();
	            }
	        },
	        
	        'mappedeventgrid  button[itemId=btnDelete]': {
	            click: function(obj) {
	            	this.deleteMappedEvent();
	            }
	        },
	        
	        'eventmappingfilter customcombobox#programItemId':{
			   select : function(obj,record){
				   var $this = this;
				   var data = record[0].data.id;
				   var form = $this.getEventmappingfilter().getForm();
				   var program = form.findField("programId");
				   var batch = form.findField("batchId");
				   var period = form.findField("periodId");
				   batch.reset();
				   period.disable();
				   period.reset();
				   batch.enable();
				   batch.getStore().getProxy().extraParams={
					   id:data,
					   isActive:true
				   };
				   batch.getStore().load();
				   
			   }
	        },
	        
	        'eventmappingfilter customcombobox#batchItemId':{
				   select : function(obj,record){
					   var $this = this;
					   var data = record[0].data.id;
					   var form = $this.getEventmappingfilter().getForm();
					   var program = form.findField("programId");
					   var batch = form.findField("batchId");
					   var period = form.findField("periodId");
					   period.reset();
					   period.enable();
					   period.getStore().getProxy().extraParams={
						   id:data
					   };
					   period.getStore().load();
				   }
	        },
	        
	        'eventmappingfilter button[itemId=quickSearchId]': {
	            click: function(obj){
					   var $this = this;
					   var form = $this.getEventmappingfilter().getForm();
					   var grid = $this.getManagedetentiongrid();
					   var program = form.findField("programId");
					   var batch = form.findField("batchId");
					   var period = form.findField("periodId");
					   var gridStore = $this.getEventlist().getStore();
					   var examDetentionCriteriaId;
					   if(grid.getSelectionModel().getSelection()[0]){
						   examDetentionCriteriaId=grid.getSelectionModel().getSelection()[0].data.id;
					   }else{
						   examDetentionCriteriaId=null; 
					   }
					   gridStore.getProxy().extraParams={
						   programId:program.getValue(),
							  batchId:batch.getValue(),
							  periodId:period.getValue(),
							  examDetentionCriteriaId:examDetentionCriteriaId ,
							  limit:100
					   };
					   gridStore.load();
    
				   }
		     },
		     
		     'eventmappingfilter button[itemId=resetBtn]': {
		            click: function(obj){
						   var $this = this;
						   var form = $this.getEventmappingfilter().getForm();
						   var program = form.findField("programId");
						   var batch = form.findField("batchId");
						   var period = form.findField("periodId");
						   form.reset();
						   batch.disable();
						   period.disable();
					   }
			     },
        	
        	'managedetentiongrid  button[itemId=btnAdd]': {
	            click: function(btn) {
					
	            	var formWindow = this.getDetentioncriteriawin();
    				if (!formWindow) {
    					Ext.widget('detentioncriteriawin');
    					formWindow = this.getDetentioncriteriawin();
    				}
    				formWindow.show();
    				Ext.apply(formWindow,{
		        		code:null,
		     		  setCode : function(code){
		     			 formWindow.code = code;
		     		  },
		     		  getCode:function(){
		     			  return formWindow.code;
		     		  }
					});
    				formWindow.setCode(null);
	            }
	        },
	        'managedetentiongrid  button[itemId=btnEdit]': {
	            click: function(){
	            	var $this=this;
	            	var formWindow = this.getDetentioncriteriawin();
	            	var grid = $this.getManagedetentiongrid();
	            	
        			if(grid.getSelectionModel().getCount()>0){
        				var record = grid.getSelectionModel().getSelection()[0].data;
        				if (!formWindow) {
        					Ext.widget('detentioncriteriawin');
        					formWindow = this.getDetentioncriteriawin();
        				}
        				formWindow.show();
        				var name = formWindow.down('#detentionNameItemId');
    	            	var from = formWindow.down('#percentagefromItemId');
    	            	var to = formWindow.down('#percentageToItemId');
    	            	var dt = formWindow.down('#attendancePercentageAsOnDateId');
    	            	var detentionGrade = formWindow.down('#detentionGrade');
    	            	var submitButtonId = formWindow.down('#submitButtonId');
        				name.setValue(record.criteriaName);
        				from.setValue(record.fromPercentage);
        				to.setValue(record.toPercentage);
        				dt.setValue(dateRender(record.tillAttendanceDate));
        				detentionGrade.setRawValue(record.detainGrade);
        				detentionGrade.setReadOnly(true);
        				detentionGrade.setDisabled(true);
        				submitButtonId.setText(getExaminationTranslation(' Save '));
        				Ext.apply(formWindow,{
			        		code:null,
			     		  setCode : function(code){
			     			 formWindow.code = code;
			     		  },
			     		  getCode:function(){
			     			  return formWindow.code;
			     		  }
						});
        				formWindow.setCode(record.criteriaName);
        			} else {
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        			}
	            }
	        },
	        
	        'managedetentiongrid  button[itemId=btnView]': {
	            click: function(obj) {
	            	var $this=this;
	            	var formWindow = this.getDetentioncriteriawin();
	            	var grid = $this.getManagedetentiongrid();
	            	
        			if(grid.getSelectionModel().getCount()>0){
        				var record = grid.getSelectionModel().getSelection()[0].data;
        				if (!formWindow) {
        					Ext.widget('detentioncriteriawin');
        					formWindow = this.getDetentioncriteriawin();
        				}
        				formWindow.show();
        				var name = formWindow.down('#detentionNameItemId');
    	            	var from = formWindow.down('#percentagefromItemId');
    	            	var to = formWindow.down('#percentageToItemId');
    	            	var dt = formWindow.down('#attendancePercentageAsOnDateId');
    	            	var detentionGrade = formWindow.down('#detentionGrade');
    	            	var submitButtonId = formWindow.down('#submitButtonId');
        				name.setValue(record.criteriaName);
        				from.setValue(record.fromPercentage);
        				to.setValue(record.toPercentage);
        				detentionGrade.setRawValue(record.detainGrade);
        				dt.setValue(dateRender(record.tillAttendanceDate));
        				
        				name.setReadOnly(true);
        				from.setReadOnly(true);
        				to.setReadOnly(true);
        				dt.setReadOnly(true);
        				detentionGrade.setReadOnly(true);
        				detentionGrade.setDisabled(true);
        				submitButtonId.setVisible(false);
        			} else {
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        			}
	            }
	        },
	        'managedetentiongrid splitbutton[itemId=spBtnMoreActions] #applyToBtn':{
 			   click : function(){
 				   this.mapDetentionEvent();
 			   }
 		   },
 		   
 		  'managedetentiongrid splitbutton[itemId=spBtnMoreActions] #detainStudentBtn':{
			   click : function(){
				   this.openDetainedStudent();
			   }
		   },
		   'detainedstudentgrid button[itemId=btnAdd]':{
	            click: function(obj) {
	            	this.saveDetainedStudent();
	            }
		   },
		   
	        'managedetentiongrid  button[itemId=btnDelete]': {
	            click: function(obj) {
	            	var $this=this;
	            	var grid = $this.getManagedetentiongrid();
        			if(grid.getSelectionModel().getCount()>0){
        				var record = grid.getSelectionModel().getSelection()[0].data;
        				showConfirmMessage(getExaminationTranslation('MANAGE_DETENTION'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn, text) {
            				if (btn == 'yes') {
            					var ids = [];
            					ids.push(record.id);
								Ext.Ajax.request({
									method : "DELETE",
									type : 'rest',
									url : SERVERURL.PATH_DELETE_DETENTION_CRITERIA+"?ids="+ids.join(),
									headers : {
										'Content-Type' : 'application/json'
									},
									success : function(form,action) {
								showSuccessMessage(getExaminationTranslation('COVERAGE_PLAN'),getCommonTranslation('SUCCESS'));									
										grid.getStore().reload();
									}
								});
            				}
        				});
        			} else {
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        			}
	            }
	        },
	        
	        'detentioncriteriawin  button[itemId=submitButtonId]': {
	            click: function(btn) {
					btn.disable();	 //disable btn to prevent the multiple clicks
	            	var $this = this;
	            	var windowForm = $this.getDetentioncriteriawin();
	            	var grid = $this.getManagedetentiongrid();
	            	var name = windowForm.down('#detentionNameItemId');
	            	var from = windowForm.down('#percentagefromItemId');
	            	var to = windowForm.down('#percentageToItemId');
	            	var dt = windowForm.down('#attendancePercentageAsOnDateId');
	            	var detentionGrade = windowForm.down('#detentionGrade').getValue();
	            	var submitButtonId = windowForm.down('#submitButtonId');
	            	if(submitButtonId.getText()!=" Save "){
	            	if(!isNullOrEmpty(detentionGrade)) {
	            		var splitValue=detentionGrade.split("@");
	            		var gradeName=splitValue[0];
	            		var gradePoint=splitValue[1]; 
	            	 } 
	            	} 
	            	
	            	var submitValue, submitUrl;
	            	if(submitButtonId.getText()!=" Save "){
	            		submitValue={
		            			criteriaName:name.getRawValue(),
		            			fromPercentage:from.getRawValue(),
		            			toPercentage:to.getRawValue(),
		            			tillAttendanceDate:windowForm.down('form').getValues().attendancePercentageAsOnDate,
		            			detainGrade:gradeName,
		            			detainGradePoints:gradePoint
		            	};
	            		submitUrl=SERVERURL.PATH_SAVE_DETENTION_CRITERIA;
	            	} else {
	            		var record = grid.getSelectionModel().getSelection()[0].data;
	            		submitValue={
		            			criteriaName:name.getRawValue(),
		            			fromPercentage:from.getRawValue(),
		            			toPercentage:to.getRawValue(),
		            			tillAttendanceDate:windowForm.down('form').getValues().attendancePercentageAsOnDate,
		            			id:record.id,
		            			detainGrade:record.detainGrade,
		            			detainGradePoints:record.detainGradePoints
		            	};
	            		submitUrl=SERVERURL.PATH_UPDATE_DETENTION_CRITERIA;
	            		submitButtonId.setText(getExaminationTranslation('Save'));
	            	}
	            	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		  			Ext.Ajax.request({
  						type : 'rest',
  						url : submitUrl,
  						jsonData : submitValue,
  						method : 'POST',
  						success : function(form, action) {
  							 Ext.getBody().unmask();
  							 showSuccessMessage(getExaminationTranslation('MANAGE_DETENTION'),getCommonTranslation('SUCCESS'));
  							 grid.getStore().reload();
  							 grid.getSelectionModel().deselectAll();
  							 windowForm.close();
  						}
		  			});
	            }
	        },
	        
	        'detentioncriteriawin textfield[itemId=detentionNameItemId]' : {
            	blur : function(obj) {
	            	 var $this = this;
	            	    var structFilter = $this.getDetentioncriteriawin();
	            	    if(!isNullOrEmpty(structFilter.getCode())){
	            	    	 var defaultText=structFilter.getCode();
	 	                    if(!isNullOrEmpty(structFilter.getCode())){
	 	                    	//Unique check here
	 	                    	if(!isNullOrEmpty(structFilter.getCode())){
	 		                    	if(structFilter.down('#detentionNameItemId').getValue()!=structFilter.getCode()){
	 		                    		var grid = $this.getManagedetentiongrid();
	 		               				var record = grid.getSelectionModel().getSelection()[0].data;
	 			                    	var editUrl = SERVERURL.PATH_DETENTION_CRITERIA_UNIQUENESS;
	 			                    	Ext.Ajax.request({
	 			                    		method: "GET",
	 			                    		type: 'rest',
	 			                    		url: editUrl,
	 			                    		params: {
	 			                    			name: structFilter.down('#detentionNameItemId').getValue(),
	 			                    			id: record.id
	 			                    		},
	 			                    		success: function(response, action) {
	 			                    			var receiptData = Ext.JSON.decode(response.responseText);
	 			                    			if(receiptData==false){
	 			                    				structFilter.down('#detentionNameItemId').setValue(defaultText);
	 			                    				showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('INVALID_CITERIA_NO'));
	 			                    			}
	 			                    		}
	 			                    	});
	 		                    	}
	 	                    	}else{
	 	                    		structFilter.down('#detentionNameItemId').setValue(defaultText);
	 	                    		showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('INVALID_CITERIA_NO'));
	 	                    	}
	 	                  }
	            	   } else {
	            		   var editUrl = SERVERURL.PATH_DETENTION_CRITERIA_UNIQUENESS;
	                    	Ext.Ajax.request({
	                    		method: "GET",
	                    		type: 'rest',
	                    		url: editUrl,
	                    		params: {
	                    			name: structFilter.down('#detentionNameItemId').getValue(),
	                    		},
	                    		success: function(response, action) {
	                    			var receiptData = Ext.JSON.decode(response.responseText);
	                    			if(receiptData==false){
	                    				structFilter.down('#detentionNameItemId').setValue(defaultText);
	                    				showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('INVALID_CITERIA_NO'));
	                    			}
	                    		}
	                    	});
	            	   }
	            }
	        },
	        
	        'detentioncriteriawin  button[itemId=cancelButtonId]': {
	            click: function(obj) {
	            	this.getDetentioncriteriawin().close();
	            }
	        }
        });
    },
    /**
     * Mapped Event to detention criteria open tab
     * **/
    mapDetentionEvent:function(){
 	   var me = this;
 	   var grid = me.getManagedetentiongrid();
 	   if (grid.getSelectionModel().getCount() > 0) {
 		   var contentpanel = me.getContentPanel();
			   var studentRoomStructure = Ext.widget('applytodetentioncriteria');
			   var tabName = getExaminationTranslation('APPLY_TO');
			   /**
			    * This is to remove tab from content panel and open same tab again 
			    */
			   var getcontroller=this.getController('menu.CoreERPNavigationController');
			   var getTab=getcontroller.getTab(tabName);
			   if(getTab!=null){
				   contentpanel.remove(getTab, true);
			   }
			   openTab(contentpanel, tabName, studentRoomStructure,CONSTANTS.MENU_COLOR_FOUR);
			   var evetnGrid = me.getMappedeventgrid();
			   evetnGrid.getStore().getProxy().extraParams={
				   examDetentionCriteriaId:grid.getSelectionModel().getSelection()[0].data.id
			   };
			   evetnGrid.getStore().load();
 	   } else {
 		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
 	   }
    },
    
    /**
     * Map Event Adding open tab
     * **/
    OpenAddEventMapping:function(){
 	   var me = this;
 	   var grid = me.getManagedetentiongrid();
 	   if (grid.getSelectionModel().getCount() > 0) {
 		   var contentpanel = me.getContentPanel();
			   var studentRoomStructure = Ext.widget('applytoaddstructure');
			   var tabName = getExaminationTranslation('APPLY_TO')+"- "+grid.getSelectionModel().getSelection()[0].data.criteriaName;
			   /**
			    * This is to remove tab from content panel and open same tab again 
			    */
			   var getcontroller=this.getController('menu.CoreERPNavigationController');
			   var getTab=getcontroller.getTab(tabName);
			   if(getTab!=null){
				   contentpanel.remove(getTab, true);
			   }
			   openTab(contentpanel, tabName, studentRoomStructure,CONSTANTS.MENU_COLOR_FOUR);
			   var evetnGrid = me.getMappedeventgrid();
			   evetnGrid.getStore().getProxy().extraParams={
				   examDetentionCriteriaId:grid.getSelectionModel().getSelection()[0].data.id
			   };
			   var eventStore = evetnGrid.getStore();
			   eventStore.sorters.clear();
			   evetnGrid.getStore().load();
 	   } else {
 		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
 	   }
    },
    
    /**
     * Apply detention crietria
     * **/
    applyDetentionCriteria:function(){
 	   var $this = this;
 	   var form = $this.getEventmappingfilter().getForm();
 	   var period = form.findField("periodId");
 	   var grid = $this.getEventlist();
 	   var criteriaGrid = $this.getManagedetentiongrid();
 	   if (grid.getSelectionModel().getCount() > 0) {
 		  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 		  var submitValue=[];
 		  var records = grid.getSelectionModel().getSelection();
 		  for (var i in records){
 			  var data={
 					 periodId:period.getValue(),
 					 eventId:records[i].data.eventId,
 					 courseVariantId:records[i].data.courseVariantId,
 					 examDetentionCriteriaId:criteriaGrid.getSelectionModel().getSelection()[0].data.id
 			  };
 			 submitValue.push(data);
 		  }
 		  var	submitUrl=SERVERURL.PATH_DETENTION_SAVE_EVENT;
			Ext.Ajax.request({
				type : 'rest',
				url : submitUrl,
				jsonData : submitValue,
				method : 'POST',
				success : function(form, action) {
					 Ext.getBody().unmask();
					 showSuccessMessage(getExaminationTranslation('APPLY_TO'),getCommonTranslation('SUCCESS'));
					 var grid = $this.getMappedeventgrid();
					 grid.getStore().reload();
					 var contentpanel = $this.getContentPanel();
					 var tabName = getExaminationTranslation('APPLY_TO')+"- "+criteriaGrid.getSelectionModel().getSelection()[0].data.criteriaName;;
					 var getcontroller=$this.getController('menu.CoreERPNavigationController');
					 var getTab=getcontroller.getTab(tabName);
					 if(getTab!=null){
						 contentpanel.remove(getTab, true);
					 }
				}
			});
 	   } else {
 		  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
 	   }
    },
    
    deleteMappedEvent:function(){
  	   	 var $this = this;
	  	 var grid = $this.getMappedeventgrid();
	  	 if (grid.getSelectionModel().getCount() > 0) {
	  		showConfirmMessage(getExaminationTranslation('APPLY_TO'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
					function(btn, text) {
						if (btn == 'yes') {
							 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							 var records = grid.getSelectionModel().getSelection();
					  		 var ids=[];
					  		 for (var i in records){
					  			ids.push(records[i].data.id);
					  		 }
					  		Ext.Ajax.request({
								method : "DELETE",
								type : 'rest',
								url : SERVERURL.PATH_DETENTION_DELETE_EVENTS+ '?ids='+ids,
								headers : {
									'Content-Type' : 'application/json'
								},
								params : {
									ids : ids
								},
								success : function(form,action) {
									showSuccessMessage(getExaminationTranslation('APPLY_TO'),getCommonTranslation('SUCCESS'));
									grid.getStore().reload();
									Ext.getBody().unmask();
								}
							});
						}
	  		});
	  	 } else {
	  		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	  	 }
    },
    openDetainedStudent:function(){
 	   var me = this;
 	   var grid = me.getManagedetentiongrid();
 	   if (grid.getSelectionModel().getCount() > 0) {
 		   var contentpanel = me.getContentPanel();
			   var detainedStudentsStructure = Ext.widget('detainedstudents');
			   var tabName =getExaminationTranslation('DETAIN_STUDENT');
			   /**
			    * This is to remove tab from content panel and open same tab again 
			    */
			   var getcontroller=this.getController('menu.CoreERPNavigationController');
			   var getTab=getcontroller.getTab(tabName);
			   if(getTab!=null){
				   contentpanel.remove(getTab, true);
			   }
			   openTab(contentpanel, tabName, detainedStudentsStructure,CONSTANTS.MENU_COLOR_FOUR);
			   var studentGrid = me.getDetainedstudentgrid();
			   studentGrid.getStore().getProxy().extraParams={
				   examDetentionCriteriaId:grid.getSelectionModel().getSelection()[0].data.id
			   };
			   studentGrid.getStore().load();
 	   } else {
 		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
 	   }
    },
    saveDetainedStudent:function(){
  	   var me = this;
  	   var grid = me.getDetainedstudentgrid();
	   var manageDetentionGrid = me.getManagedetentiongrid();
   	   var manageDetetionRecord=manageDetentionGrid.getSelectionModel().getSelection();
  	   if (grid.getSelectionModel().getCount() > 0) {
  		 var records = grid.getSelectionModel().getSelection();
  		 var saveData=[];
  		 for(var i in records){
  			 var data={
  					evaluationSequenceDetailId:records[i].data.evaluationSequenceDetailId,
  					admissionId:records[i].data.admissionId,
  					courseVariantId:records[i].data.courseVariantId,
  					sectionId:records[i].data.sectionId,
  					examinationResultId:records[i].data.examinationResultId,
  					attendancePercentage:records[i].data.attendancePercentage,
  					periodId:records[i].data.periodId,
  					examDetentionCriteriaId:manageDetetionRecord[0].data.id
  			 };
  			saveData.push(data);
  		 }
  		showConfirmMessage(getExaminationTranslation('DETAIN_STUDENT'),getExaminationTranslation('DETENTION_CNFRM_MSG'),
				function(btn, text) {
  			if (btn == 'yes') {
  				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	  			var	submitUrl=SERVERURL.PATH_DETENTION_STUDENT;
				Ext.Ajax.request({
					type : 'rest',
					url : submitUrl,
					jsonData : saveData,
					method : 'POST',
					success : function(form, action) {
						 Ext.getBody().unmask();
						showSuccessMessage(getExaminationTranslation('DETAIN_STUDENT'),getCommonTranslation('SUCCESS'));
						grid.getStore().reload();
					}
				});
  			}
  		});
  	
 	   } else {
 		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
 	   }
    }
});
   