/**
 * @author Prathamesh.Sheth
 * This is used for to handle configuration of system events/messages.  
 * 
 */
Ext.define('Academia.controller.messaging.SystemEventConfigurationController', {
	
	extend: 'Academia.controller.base.BaseController',

    views: [
            'messaging.SystemEventsPanel','messaging.SystemEventsSearchForm',
            'messaging.SystemEventConfigMasterForm','messaging.SystemEventConfigBasicInfoForm',
            'messaging.SystemEventConfigMessageScopes','messaging.SystemEventConfigInitiationSchedule',
            'messaging.SystemEventConfigInitiationRule','messaging.SystemEventConfigDistributionList',
            'messaging.SystemEventConfigDistributionListEntity','messaging.SystemEventConfigDistributionRule',
            'messaging.SysEveConfigDistributionRulePanel','messaging.SystemEventConfigRepetationSchedule',
            'messaging.systemEventMessagingRuleEditor.systemEventMessagingRuleEditor',
            'messaging.systemEventMessagingRuleEditor.SearchCriteriaGroupForMessaging',
            'messaging.systemEventMessagingRuleEditor.SearchCriteriaLineItemForMessaging',
            'messaging.systemEventMessagingRuleEditor.SearchConfigDataSourceForMessaging',
            'messaging.report.SystemMsgEventReportPanel', 'messaging.report.SystemMessageEventSearchForm','messaging.SystemPanelView'
           ],
    
    model:['Academia.model.criteriabuilder.AdvancedSearchConfig'],       
           
    stores: ['messaging.MessageCategoryStore',
             'messaging.ConfigLevels','Academia.store.common.AcademyLocationNameSeparated',
             'messaging.SystemEventConfigSelectorStore','messaging.RecipientType','Academia.store.messaging.MessageSearchConfigs',
             'organization.academylocations.AcademyLocationStore','messaging.SystemEventMessageStore',
             'messaging.MessageTemplate','messaging.MessageEntity','messaging.SendingPriorityStore',
             'organization.academylocations.ActiveAcademyLocationStore','messaging.MessageSystemEventCodeStore',
             
             'messaging.MessageEventType'
            ],

    refs: [           
	
	/* system event list  reference */
	
    {
        ref: 'systemEventSearchForm',
        selector: 'systemeventssearchform[itemId=systemEvent_quickSearch]'
    }, {
        ref: 'systemEventSearchResultGrid',
        selector: 'searchresultgrid[itemId=systemEventSearchResultGrid]'
    }, {
        ref: 'systemMsgEventReportSearchResultGrid',
        selector: 'searchresultgrid[itemId=systemMsgEventReportSearchResultGrid]'
    }, {
        ref: 'systemMessageEventReportSearchForm',
        selector: 'systemmessageeventsearchform[itemId=systemMessageEventReportSearchForm]'
    },{
        ref: 'systemeventspanel',
        selector: 'systemeventspanel'
    }],
    config: {
    	SYSTEM_MESSAGING_EVENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SYSTEM_MESSAGE_EVENT_PRIVILEGES'),
    	SYSTEM_MESSAGING_EVENT_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SYSTEM_MESSAGE_EVENT_REPORT_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	//**************************Export**************************************************************************  
			  'searchresultgrid[itemId=systemEventSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
		            }
		        },
		        'searchresultgrid[itemId=systemEventSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
		            }
		        },
		        'searchresultgrid[itemId=systemEventSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
		            }
		        },
		        'searchresultgrid[itemId=systemEventSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
		            }
		        },
		      //**************************Export**************************************************************************  
		      //**************************Export**************************************************************************  
				  'searchresultgrid[itemId=systemMsgEventReportSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
			            click: function() {
			                this.exportEventReportList(SERVERURL.PDFEXPORT,'pdf',false);
			            }
			        },
			        'searchresultgrid[itemId=systemMsgEventReportSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
			            click: function() {
			                this.exportEventReportList(SERVERURL.PDFEXPORT,'pdf',true);
			            }
			        },
			        'searchresultgrid[itemId=systemMsgEventReportSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
			            click: function() {
			                this.exportEventReportList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
			            }
			        },
			        'searchresultgrid[itemId=systemMsgEventReportSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
			            click: function() {
			                this.exportEventReportList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
			            }
			        },
			      //**************************Export**************************************************************************  
        	'systemeventssearchform combo[itemId=configLevelId]': {
                select: function(combo,records){
                	this.showDependentCombo(combo,records);                	                	                					                	                	                	
                }
            },                        
                      
            'systemeventssearchform combo[itemId=ACADEMY_LOCATION]':{
	          	   render:function(combo){        		             		              		   
	          		   combo.getStore().load(); 		   
	          	   }
             },
                          
             'systemeventmessagingruleeditor[itemId=initiationRuleAdvancedSearchPanel] button[itemId=SaveSearchButtonForMessaging]':{
            	 click:function(button){            		 
            		 this.setInitiationRuleAdvancedSearchObject(button.up('panel'),button.up('#systemEventConfigInitiationRule'));            		 
            	 }            	    
             },
             
             'systemeventmessagingruleeditor[itemId=systemEventConfigDistributionListRuleEditor] button[itemId=SaveSearchButtonForMessaging]':{
            	 click:function(button){
            		 this.setSystemMessageRecipientObject(button.up('panel'),button.up('#systemEventConfigDistributionList'),'distrListInstance');
            		 button.up('window').close();            		 
            		 showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('DISTRIBUTION_LIST_RULE_CRITERIA_SAVED_MSG')); //Distribution list criteria has saved successfully
            	 }            	    
             },
             
             'systemeventmessagingruleeditor[itemId=systemEventConfigDistributionRuleEditor] button[itemId=SaveSearchButtonForMessaging]':{
            	 click:function(button){
            		 this.setSystemMessageRecipientObject(button.up('panel'),button.up('#sysEveConfigDistributionrulepanel'),'distrRuleInstance');
            		 button.up('window').close();            		 
            		 showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('DISTRIBUTION_RULE_CRITERIA_SAVED_MSG')); //Distribution rule criteria has saved successfully
            	 }            	    
             },
             
             'systemeventconfigbasicinfoform combo[itemId=systemMessageEventCombo]': {
                 select: function(combo,records){                	 
                	   this.onSystemEventSelection(combo,records);         	                  	                     	
                 }                					                	                	                	                
             },
             
             'systemeventconfigbasicinfoform combo[itemId=academyLocationCombo]': {
            	 select: function(combo,records){                	 
                	   this.onAcadLocSelection(combo,records);         	                  	                     	
                 }                					                	                	                	                
             },
                  
             'systemeventconfigmessagescopes combo[itemId=messageScopeCombo]': {
                 select: function(combo,records){                	 
                	 this.loadSystemEventConfigSelector(combo,records);           	                  	                     	
                 }                					                	                	                	                
             },
             
            /* system event component Events  */
                        
            'systemeventssearchform button[itemId=systemEventFindButtonId]': {
                click: this.loadTemplateGridAndSearchRequest
            },
            'systemeventssearchform button[itemId=systemEventClearSearch]': {
                click: this.clearSearchForm
            },
            'systemeventspanel grid[itemId=systemEventSearchResultGrid]': {
                afterrender: function(grid){
                	this.loadTemplateGridAndSearchRequest();
                	this.gridRenderFunction(grid);
                	//this.genericCBGridAccessControlValidation(grid, this.getSYSTEM_MESSAGING_EVENT_PERMISSIONS());
                	//this.disableMoreActionPivileges(grid, this.getSYSTEM_MESSAGING_EVENT_PERMISSIONS());
                	//var viewButton = grid.down("#searchResultGridBtnView");
 			   		//viewButton.setVisible(false); 
                },
                cellclick:function(grid){
                	var strucutre = this.getSystemeventspanel();
                	var grid = this.getSystemEventSearchResultGrid();
                	grid.getHeader().removeCls('gridFixHeader');
                    grid.columnManager.headerCt.removeCls('gridFixHeader');
                    grid.dockedItems.items[3].removeCls('gridFixHeader');
                    strucutre.scrollBy(0,-1);
                	strucutre.scrollBy(0,1);
                }
            },
            
            /* system event configuration form component Events  */
            
            'systemeventconfigmessagescopes[itemId=systemEventConfigMessageScopes] button[itemId=btnSaveMessageScopeForm]':{
           	 	click:function(button){            		 
           	 		  this.saveMessageScopeObjectIncache(button);     		 
           	 	}            	    
            },
            
            'systemeventconfigdistributionlistentity button[itemId=buildListButton]': {
                click:function(button){           
                	this.showBuildListWindow(button);                	                	
                } 
            },                        
            
            'systemeventconfigmasterform button[itemId=btnSaveSysEveConfigForm]':{
            	click: function(button){
            		this.saveSystemMessageCofiguration(button);
            	}
            },
                        
            'systemeventconfigmasterform button[itemId=btnCancelSysEveConfigForm]': {
                click: function(button){                	
                	button.up('form').close();
                }
            },
            
            /* System Event Grid Button Events  */
            
            'systemeventspanel button[itemId=searchResultGridBtnAdd]': {
                click: function(button){                	
                	this.openNewSystemEventConfigurationTab(button);
                }
            },
            
            'systemeventspanel button[itemId=searchResultGridBtnEdit]': {
                click: function(button){                	
                	var me=this;
                	var grid =button.up('grid');
                	if(grid){                		
                		if (grid.getSelectionModel().getCount() > 0) {        	
                			me.openSystemEventConfigurationTab(button,grid);
                        } else {
                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                        }
                	}
                }
            },
            
            'systemeventspanel button[itemId=searchResultGridBtnView]': {
                click: function(button){                	
                	var me=this;
                	var grid =button.up('grid');
                	if(grid){                		
                		if (grid.getSelectionModel().getCount() > 0) {        	
                			me.openSystemEventConfigurationTab(button,grid,'VIEW');
                        } else {
                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                        }
                	}
                }
            },
            
            'systemeventspanel button[itemId=searchResultGridBtnDelete]': {
                click: function(button){                	
                	this.deleteSystemMessageConfiguration(button);
                }
            },
            
            /*'systemeventspanel menuitem[itemId=enableDisableBtn]': {
                click: function(button){                	
                	this.enableDisableMessageEvent(button);
                }
            },*/
            
            'systemeventspanel button[itemId=enableDisableBtn]': {
                click: function(button){                	
                	this.enableDisableMessageEvent(button);
                }
            },
            
            'searchresultgrid[itemId=systemEventSearchResultGrid]': {
            	/*render:function(grid){
            		grid.addButtonToolbar();
            	},*/
                select: function(rowModel, record, index, eOpts){                	
                	this.setEnableDisableButtonText(rowModel, record, index, eOpts);
                }
            },
            
            
            'systemeventspanel button[itemId=addAdhocMessageBtn]': {
                click: function(button){
                	this.openTab("Adhoc Message", 'templatebasicsetupform',CONSTANTS.MENU_COLOR_THIRTEEN);                	
                }
            },
            'systemmsgeventreportpanel searchresultgrid[itemId=systemMsgEventReportSearchResultGrid]': {
                render: function(grid){
                	grid.addButtonToolbar();
                	this.genericCBGridAccessControlValidation(grid, this.getSYSTEM_MESSAGING_EVENT_REPORT_PERMISSIONS());
                	grid.down("#searchResultGridBtnView").setVisible(false); 
 			   		grid.down("#searchResultGridBtnAdd").setVisible(false);
 			   		grid.down("#searchResultGridBtnEdit").setVisible(false);
 			   		grid.down("#searchResultGridBtnDelete").setVisible(false);
                }
            },
            'systemmessageeventsearchform[itemId=systemMessageEventReportSearchForm] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadMessageEventSearchReportGrid();
                }
            },
            'systemmessageeventsearchform[itemId=systemMessageEventReportSearchForm] button[itemId=resetButtonId]': {
                click: function(){
                	this.resetMessageEventSearchResultForm();
                }
            },
            'systemmessageeventsearchform[itemId=systemMessageEventReportSearchForm] combo[itemId=messageCategory]': {
                select: function(combo,records){
                	var searchForm = this.getSystemMessageEventReportSearchForm();
                	var messageSubCategory = searchForm.down('#messageSubCategory');
                	messageSubCategory.setDisabled(false);
                	var selectedCategoryId=combo.getValue();
                	if(!isNullOrEmpty(selectedCategoryId)){
                		var store = messageSubCategory.getStore();
                		store.getProxy().extraParams={
        					id:selectedCategoryId
        				};
                		store.load();
                	}  
                }
            },
            
            'systemmessageeventsearchform[itemId=systemMessageEventReportSearchForm]': {
                render: function(){
                	var searchForm = this.getSystemMessageEventReportSearchForm();
                	var messageSubCategory = searchForm.down('#messageSubCategory');
                	messageSubCategory.setDisabled(true);
                }
            }
            
        });
    },
    
    /**
     * Load Message Event Search Report Grid
     */
    loadMessageEventSearchReportGrid: function(){
    	
        var searchForm = this.getSystemMessageEventReportSearchForm();
        var jsonFormatFormData = this.createSearchResultReportJsonFormat(searchForm);
        var resultGrid = this.getSystemMsgEventReportSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.MESSAGING_SYSTEM_MSG_EVENT_REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        Ext.getBody().unmask();
    },
    /**
     * Create Search Result Report Json Format
     * @param searchForm form
     */
    createSearchResultReportJsonFormat: function(searchForm){
    	var this$=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.MESSAGING_SYSTEM_MSG_EVENT_REPORT_BASIC_CONFIGCODE;

        formValues = searchForm.getValues();        
        
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'START_DATE' && key !== 'END_DATE'
            	&& key !== 'DELIVERY_MODE'){
                var keyValueJsonObject = this$.getJsonObject( key , value);
                this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }
        /*V2D-13391*/
        var deliveryModes = formValues['DELIVERY_MODE'];
        if(deliveryModes != undefined){
        	var arr = [];
        	if(deliveryModes.length == undefined){
        		arr.push(deliveryModes);
        	}else{
        		for(var i=0;i<deliveryModes.length;i++) {
        			arr.push(deliveryModes[i]);
        		} 
        	}
        	var keyValueJsonObj = this$.getJsonObject('DELIVERY_MODE', arr.join());
        	this$.pushJsonObjectInArray(keyValueJsonObj,searchcriteria);

        }
       
        
        if(!isNullOrEmpty(formValues.START_DATE) || !isNullOrEmpty(formValues.END_DATE)){
        	var keyValueJsonObject = this$.getJsonObject( "START_DATE", formValues.START_DATE);
            this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        
        if(!isNullOrEmpty(formValues.END_DATE)){
        	var endDate =  Ext.Date.add (new Date(formValues.END_DATE),Ext.Date.DAY,1);
        	
        	var keyValueJsonObject = this$.getJsonObject( "END_DATE",Ext.Date.format(endDate, CONSTANTS.SUBMIT_DATE_FORMAT));
            this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        values.searchCriterias = searchcriteria;
        return values;
    },
    /**
     * Reset Message Event Search Result Form
     */
    resetMessageEventSearchResultForm: function(){
    	var searchForm = this.getSystemMessageEventReportSearchForm();
    	searchForm.getForm().reset();
    	searchForm.down("#startDate").setMaxValue(null);
    	searchForm.down("#startDate").setValue("");
    	searchForm.down("#startDate").setMinValue(null);
    	searchForm.down("#endDate").setMaxValue(null);
    	searchForm.down("#endDate").setValue("");
    	searchForm.down("#endDate").setMinValue(null);
    	var messageSubCategory = searchForm.down('#messageSubCategory');
    	messageSubCategory.getStore().removeAll();
    	messageSubCategory.setDisabled(true);
    },
    

    /**
     * This method is used for to set system message event configuration initiation rule object
     * @param initiationRulePanel - initiation Rule Panel reference
     * @param form - initiation Rule Panel container form
     *           
     */
    setInitiationRuleAdvancedSearchObject:function(initiationRulePanel,form){
    	var me=this;
    	if(initiationRulePanel && form){
    		var advancedSearchDTOObj=initiationRulePanel.getSearchCriteriaJsonObject();
    		if(!isEmpty(advancedSearchDTOObj)){
    			var dataProviderInstanceObject=me.createSystemMessageEventConfigInstanceObject(form,advancedSearchDTOObj);
    			if(!isEmpty(dataProviderInstanceObject)){
    				var masterForm=form.up('systemeventconfigmasterform');
    				if(masterForm){
    					masterForm.down("#dataProviderInstance").setValue(Ext.encode(dataProviderInstanceObject));
    					showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('INITIATION_RULE_CRITERIA_SAVED_MSG')); //Initiation Rule criteria has saved successfully.
    				}    				
    			}
    		}	
    	}
    },
    
    /**
     * This method is used for to set system message event configuration Recipient object
     * @param Panel - Recipient Panel reference
     * @param form - Recipient Panel container form
     *           
     */
    setSystemMessageRecipientObject:function(Panel,form,instanceType){
    	var me=this;
    	var masterForm=me.getTabReferenceByTabTitle();    	
    		if(masterForm){
    			var wsMsgEventRecipientConfigs=new Array();
    			var selectedRecipientTypeId="";
    			var selectedRecipientTemplateId="";
    			var isExist=false;
    			var eventData=null;
    			var templateCombo=null;
    			
    			var systemEventConfigBasicInfoForm=masterForm.down("#systemEventConfigBasicInfoForm");
    			if(systemEventConfigBasicInfoForm){    				
    				var systemMessageEventCombo=systemEventConfigBasicInfoForm.down("#systemMessageEventCombo");
    				templateCombo=systemEventConfigBasicInfoForm.down("#templateCombo");
    				
    				if(systemMessageEventCombo){
    					eventData=systemMessageEventCombo.getStore().getById(systemMessageEventCombo.getValue());    					
    				}
    			}
				
				if(form){
	    	    	var formDataObject=form.getValues();
	    	    	if(!isEmpty(formDataObject) && !isNullOrEmpty(formDataObject.msgRecipientTypeId)){
	    	    		selectedRecipientTypeId=formDataObject.msgRecipientTypeId;
	    	    		if(!isNullOrEmpty(formDataObject.msgTemplateConfigId)){	    	    			
	    	    			selectedRecipientTemplateId=(eventData.whetherCommonMsgTemplate)?templateCombo.getValue():formDataObject.msgTemplateConfigId;
	    	    		}
	    	    		if(eventData.data.whetherCommonMsgTemplate){
	    	    			selectedRecipientTemplateId=templateCombo.getValue();
	    	    		}	    	    		
	    	    	}
	    	    }
    			
    			var wsMsgEventRecipientConfigsObjString=masterForm.down("#wsMsgEventRecipientConfigs").getValue();
				if(!isNullOrEmpty(wsMsgEventRecipientConfigsObjString)){
					
					wsMsgEventRecipientConfigs= Ext.decode(masterForm.down("#wsMsgEventRecipientConfigs").getValue());
	    	    	if(!isEmpty(wsMsgEventRecipientConfigs)){
	    	    			    		
	    	    		for(var count=0;count<wsMsgEventRecipientConfigs.length;count++){
	    	    			var wsMsgEventRecipientConfigObject=wsMsgEventRecipientConfigs[count];
	    	    			if(!isEmpty(wsMsgEventRecipientConfigObject)){
	    	    				var msgRecipientTypeId=wsMsgEventRecipientConfigObject.msgRecipientTypeId;
	    	    				if(msgRecipientTypeId==selectedRecipientTypeId){
	    	    					isExist=true;
	    	    					var advancedSearchDTOObj=Panel.getSearchCriteriaJsonObject();
	    	    		    		if(!isEmpty(advancedSearchDTOObj)){
	    	    		    			advancedSearchDTOObj=me.setDefaultSearchCriteriaInDistribution(advancedSearchDTOObj,form);
	    	    		    			var instanceObject=me.createSystemMessageEventConfigInstanceObject(form,advancedSearchDTOObj);
	    	    		    			wsMsgEventRecipientConfigs[count][instanceType]=instanceObject;
	    	    		    			wsMsgEventRecipientConfigs[count]["msgTemplateConfigId"]=selectedRecipientTemplateId;
	    	    		    			masterForm.down("#wsMsgEventRecipientConfigs").setValue(Ext.encode(wsMsgEventRecipientConfigs));
	    	    		    			break;
	    	    		    		}	
	    	    				}
	    	    			}
	    	    			    			
	    	    		} 
	    	    		
	    	    	}
				}
				
				if(!isExist){
	    			var recipientObject=new Object();
	    			var advancedSearchDTOObj=Panel.getSearchCriteriaJsonObject();
		    		if(!isEmpty(advancedSearchDTOObj)){		    			
		    			advancedSearchDTOObj=me.setDefaultSearchCriteriaInDistribution(advancedSearchDTOObj,form);
		    			var instanceObject=me.createSystemMessageEventConfigInstanceObject(form,advancedSearchDTOObj);		    			
		    			recipientObject.msgRecipientTypeId=selectedRecipientTypeId;
		    			recipientObject.msgTemplateConfigId=selectedRecipientTemplateId;
		    			if(instanceType==='distrRuleInstance'){
		    				recipientObject.distrRuleInstance=instanceObject;
		    			}else if(instanceType==='distrListInstance'){
		    				recipientObject.distrListInstance=instanceObject;
		    			}
		    			wsMsgEventRecipientConfigs.push(recipientObject);
		    			masterForm.down("#wsMsgEventRecipientConfigs").setValue(Ext.encode(wsMsgEventRecipientConfigs));
		    		}		    			
	    		}
    			
    		}    	 	
    },
    
    
    /**
     * This method is used for to set default search criteria object in distribution list
     * @param advancedSearchDTOObj - initiation Rule Panel reference
     * @param form - distribution list/rule container form
     *           
     */
    setDefaultSearchCriteriaInDistribution:function(advancedSearchDTOObj,form){
    	if(advancedSearchDTOObj){
    		if(!isEmpty(advancedSearchDTOObj.cbSearchCriteria)){
    			if(advancedSearchDTOObj.cbSearchCriteria.searchCriterias){
    				if(!isNullOrEmpty(form.down("#defaultSearchCriterias").getValue())){
    					var defaultSearchCriteria=Ext.decode(form.down("#defaultSearchCriterias").getValue());
    					if(!isEmpty(defaultSearchCriteria)){            							            							
    						advancedSearchDTOObj.cbSearchCriteria.searchCriterias.push(defaultSearchCriteria);            							
    					}
    				}            					
    			}
    		}
    	}    
    	return advancedSearchDTOObj;
    },
    
    /**
     * This method is used for to set Implicit Recipient type Object in distribution list          
     *           
     */
    setSystemMessageImplicitRecipientObject:function(){
    	var me=this;
    	var masterForm=me.getTabReferenceByTabTitle();    	
    		if(masterForm){
    			var wsMsgEventRecipientConfigs=new Array();    			    			
    			
    			var systemEventConfigDistributionListEntity=masterForm.down("#systemEventConfigDistributionListEntity");
    			if(systemEventConfigDistributionListEntity){    				
					masterForm.down("#wsMsgEventRecipientConfigs").setValue("");					
					Ext.each(systemEventConfigDistributionListEntity.items.items, function(form) {
						var recipientObject=new Object();    						
		    			if(form){
		    	    		var formDataObject=form.getForm().getValues();
		    	    		if(!isEmpty(formDataObject)){
		    	    			if(!isNullOrEmpty(formDataObject.id)){
		    	    				recipientObject.id=	formDataObject.id;
		    	    			}
		    	    			recipientObject.msgRecipientTypeId=(!isNullOrEmpty(formDataObject.recipientTypeId))?formDataObject.recipientTypeId:null;
		    	    			recipientObject.msgTemplateConfigId=(!isNullOrEmpty(formDataObject.msgTemplateConfigId))?formDataObject.msgTemplateConfigId:null;    		    	    			
		    	    		}
		    	    		
		    	    		var instanceObject=me.createSystemMessageEventConfigInstanceObject(form);
		    	    		instanceObject.dataProviderId=(!isNullOrEmpty(formDataObject.distrListProviderId))?formDataObject.distrListProviderId:null;
		    	    		if(!isNullOrEmpty(formDataObject.distrListInstanceImplicitId)){
		    	    			instanceObject.id=formDataObject.distrListInstanceImplicitId;									
							}else{
								instanceObject.id=null;
							}
				    		recipientObject.distrRuleInstance=null;		    			
				    		recipientObject.distrListInstance=instanceObject;
		    	    	}
			    			
			    		wsMsgEventRecipientConfigs.push(recipientObject);
					});
					if(wsMsgEventRecipientConfigs.length>0){
    					masterForm.down("#wsMsgEventRecipientConfigs").setValue(Ext.encode(wsMsgEventRecipientConfigs));
    		    	}    					
    			}
    		}    		    			    		    	 
    },
    
    /**
     * This method is used to create System Message Event Config Instance Object and keep inside form hidden value
     * @param form - Initiation rule container form OR distribution list/rule container form
     * @param advancedSearchDTOObj - advance search criteria builder json oject 
     * 
     */        
    createSystemMessageEventConfigInstanceObject:function(form,advancedSearchDTOObj){
    	
    	var instanceDataObject=new Object();    	
    	instanceDataObject.whetherUpdate=true; //Send this flag always true
    	
    	if(form){
    		var formDataObject=form.getValues();
    		if(!isEmpty(formDataObject)){
    			instanceDataObject.id=(!isNullOrEmpty(formDataObject.id))?formDataObject.id:null;
    			instanceDataObject.dataProviderId=(!isNullOrEmpty(formDataObject.dataProviderId))?formDataObject.dataProviderId:null;
    			instanceDataObject.savedRuleRefId=(!isNullOrEmpty(formDataObject.savedRuleRefId))?formDataObject.savedRuleRefId:null;
    			instanceDataObject.searchConfigCode=(!isNullOrEmpty(formDataObject.searchConfigCode))?formDataObject.searchConfigCode:"";
    			instanceDataObject.searchResultViewCode=(!isNullOrEmpty(formDataObject.searchResultViewCode))?formDataObject.searchResultViewCode:"";
    			instanceDataObject.advancedSearchDTO=(!isEmpty(advancedSearchDTOObj))?advancedSearchDTOObj:null;
    		}
    	}
    	
    	return instanceDataObject;
    	
    },
    
    /**
     * This method is used for to create/update system event message configuration
     * @param button - button reference         
     *  
     */
    saveSystemMessageCofiguration:function(button){
    	var me=this;
    	var eventData=null;
    	var masterForm=button.up('form');
    	if(masterForm){
    		    		
    		var systemEventConfigBasicInfoForm=masterForm.down("#systemEventConfigBasicInfoForm");
            if(!systemEventConfigBasicInfoForm.isValid()){
            	showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_BASIC_FORM_DETAILS')); //Please enter basic form details
	    		return 0;
            }

            var systemMessageEventCombo=masterForm.down("#systemMessageEventCombo");            
            if(systemMessageEventCombo){
            	
            	var sysEveMsgId=systemMessageEventCombo.getValue();
            	if(!isNullOrEmpty(sysEveMsgId)){
            		eventData=systemMessageEventCombo.getStore().getById(sysEveMsgId);

            		var systemEventConfigMessageScopes=masterForm.down("#systemEventConfigMessageScopes");
                    if(eventData.data.whetherMsgScopeApplicable && systemEventConfigMessageScopes){
                    	if(!systemEventConfigMessageScopes.isValid()){
                    		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_MESSAGE_SCOPE_FORM_DETAILS')); //Please enter message scope form details
            	    		return 0;
                		}/*else{
                			var returnVal=me.validateMessageScope(masterForm,systemEventConfigMessageScopes);                			
							if(returnVal==0){
								return 0;	
							}
                		}  */                  	                    	
                    }
                    
            		var systemEventConfigInitiationSchedule=masterForm.down("#systemEventConfigInitiationSchedule");
                    if(eventData.data.whetherScheduledEvent && systemEventConfigInitiationSchedule){ 
                    		if(!systemEventConfigInitiationSchedule.isValid()){
		                    	showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_INITIATION_SCHEDULE_DETAILS')); //Please enter initiation schedule details
		        	    		return 0;
                    		}
                    }

            		var dataProviderInstanceStr=masterForm.getValues()['dataProviderInstance'];
                	if(eventData.data.whetherInitiationRuleApplicable && isNullOrEmpty(dataProviderInstanceStr)){
                		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_INITIATION_RULE_CRITERIA')); //Please enter initiation rule criteria
        	    		return 0;
                	}
                    
                	var systemEventConfigInitiationSchedule=masterForm.down("#systemEventConfigInitiationSchedule");
                    if(eventData.data.whetherScheduledEvent && !systemEventConfigInitiationSchedule.isValid()){
                    	showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_INITIATION_SCHEDULE_DETAILS')); //Please enter initiation schedule details
        	    		return 0;
                    }
                    
                    var systemeventconfigrepetationschedule=masterForm.down("#systemEventConfigRepetationSchedule");
                    if(eventData.data.whetherRepetationApplicable && !systemeventconfigrepetationschedule.isValid()){
                    	showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_REPATATION_SCHEDULE_DETAILS')); //Please enter repatation schedule details
        	    		return 0;
                    }
                	                    
                    var returnVal=me.validateDistributionList(masterForm,eventData);                			
					if(returnVal==0){
						return 0;	
					}                                        
            	}
            }
    		        	
        		var submitUrl="",methodType="",isUpdate=false;
    	        var id = masterForm.down('#masterId').getValue();
    	        if(isNullOrEmpty(id)){        	        	     	        	
    	        	submitUrl = SERVERURL.SYSTEM_MESSAGE_EVENT_CONFIG_CREATE, //URL-:rest/systemMsgEventConfigResource/create
    	        	methodType = 'POST';
    	        	isUpdate=false;
    	        }else{    	        	
    	        	submitUrl = SERVERURL.SYSTEM_MESSAGE_EVENT_CONFIG_UPDATE, //URL-:rest/systemMsgEventConfigResource/update
    	        	methodType = 'POST';
    	        	isUpdate=true;
    	        }
    	        
    	        var jsonFormatFormData = me.getJsonDataToSaveSystemMessageEventConfig(masterForm,eventData);
    	        if (!isNullOrEmpty(jsonFormatFormData)) {
                	Ext.Ajax.request({
                        type: 'rest',                                    
                        url: submitUrl,
                        jsonData: jsonFormatFormData,
                        method: methodType,
                        success: function(form, action) {
                        	masterForm.close();
                        	if(isUpdate){
                        		showSuccessMessage(getMessagingModuleTranslation('UPDATE_SYS_MESSAGE_EVENT_CONFIG'), getMessagingModuleTranslation('UPDATE_SYS_MESSAGE_EVENT_CONFIG_MSG')); //System message event configuration updated successfully
                        	}else{
                        		showSuccessMessage(getMessagingModuleTranslation('ADD_SYS_MESSAGE_EVENT_CONFIG'), getMessagingModuleTranslation('ADD_SYS_MESSAGE_EVENT_CONFIG_MSG')); //System message event configuration added successfully
                        	}         
                        	var SearchForm = me.getSystemEventSearchForm();
                        	if(SearchForm){
                        		var systemEventClearSearchBtn=SearchForm.down("#systemEventClearSearch");
                        		if(systemEventClearSearchBtn){
                        			systemEventClearSearchBtn.fireEvent('click',systemEventClearSearchBtn);                        			
                        		}
                        		me.loadTemplateGridAndSearchRequest();
                        	}                        	                        	
                        }
                    });
                }   	
    		}        		    	
    },
    
    
    /**
     * This method is used for to create json for saving system message event configuration    
     * @param masterForm - main panel form container 
     * @param eventData -  system message event panel config data
     *           
     */
    getJsonDataToSaveSystemMessageEventConfig: function(masterForm,eventData) {
    	var me=this;
    	var jsonDataObject=new Object();                    	            	            	    	
    	
        /* Added System Event Basic Configuration Json Data */
        
        var systemEventConfigBasicInfoForm=masterForm.down("#systemEventConfigBasicInfoForm");
        if(systemEventConfigBasicInfoForm){
        	jsonDataObject=systemEventConfigBasicInfoForm.getValues();
        	//TODO:Remove Hard Code Value
        	jsonDataObject.sendingPriority="IMMEDIATE";
        	if(!isEmpty(eventData) && !eventData.data.whetherCommonMsgTemplate){
        		jsonDataObject.msgTemplateConfigId=null;
        	}
        	
        	/* In case of academyLocationId add this for msgConfigLevelValue */
        	if(!isEmpty(jsonDataObject) && !isNullOrEmpty(jsonDataObject.academyLocationId)){
        		jsonDataObject.msgConfigLevelValue=jsonDataObject.academyLocationId;
        		delete jsonDataObject.academyLocationId;
        	}        	
        }
        
        /* Added System Event Json Data(hidden form values) */
    	
    	var whetherEnabledStr=masterForm.getValues()['whetherEnabled'];
    	if(!isNullOrEmpty(whetherEnabledStr)){    		
    		jsonDataObject.whetherEnabled=whetherEnabledStr;
        }
    	
        /* Added System Event Message Scopes Json Data */
        
        var systemEventConfigMessageScopes=masterForm.down("#systemEventConfigMessageScopes");
        if(systemEventConfigMessageScopes && masterForm  && eventData.data.whetherMsgScopeApplicable){
        	
        	var msgEventScopesStr=masterForm.getValues()['msgEventScopes'];
        	if(!isNullOrEmpty(msgEventScopesStr)){
        		var msgEventScopes=Ext.decode(msgEventScopesStr);
        		if(!isEmpty(msgEventScopes)){
        			jsonDataObject.msgEventScopes=msgEventScopes;
            	}else{
            		jsonDataObject.msgEventScopes=new Array();
            	}            	            	
        	}        	        	        	
        }
        
        /* Added System Event Initiation Rule Json Data */
        
        var systemEventConfigInitiationSchedule=masterForm.down("#systemEventConfigInitiationSchedule");
        var initiationScheduleObject=new Object();
        if(eventData.data.whetherScheduledEvent){
            initiationScheduleObject=systemEventConfigInitiationSchedule.getValues();
            if(systemEventConfigInitiationSchedule){        	 
            	initiationScheduleObject.initScheduleMetaData="ABCDEFG";        	
            }   
        }else if(!eventData.data.whetherScheduledEvent){
        	delete initiationScheduleObject.initScheduleCronDef;
        }                          
        if(masterForm){             	
            	var dataProviderInstanceStr=masterForm.getValues()['dataProviderInstance'];
            	if(!isNullOrEmpty(dataProviderInstanceStr) && eventData.data.whetherInitiationRuleApplicable){
            		var dataProviderInstanceObj=Ext.decode(dataProviderInstanceStr);
            		if(!isEmpty(dataProviderInstanceObj)){
            			if(!isEmpty(dataProviderInstanceObj.advancedSearchDTO.cbSearchCriteria)){
            				if(dataProviderInstanceObj.advancedSearchDTO.cbSearchCriteria.searchCriterias){
            					if(!isNullOrEmpty(masterForm.down("#defaultSearchCriterias").getValue())){
            						var defaultSearchCriteria=Ext.decode(masterForm.down("#defaultSearchCriterias").getValue());
            						if(!isEmpty(defaultSearchCriteria)){            							            							
            							dataProviderInstanceObj.advancedSearchDTO.cbSearchCriteria.searchCriterias.push(defaultSearchCriteria);            							
            						}
            					}            					
            				}
            			}
                		initiationScheduleObject.dataProviderInstance=dataProviderInstanceObj;
                	}else{
                		initiationScheduleObject.dataProviderInstance=null;
                	}            	                	
            	}else{
            		if(eventData.data.whetherScheduledEvent){
            			initiationScheduleObject.dataProviderInstance=null;
            		}            		
            	}  
            	if(!isEmpty(initiationScheduleObject)){
            		jsonDataObject.msgInitRuleConfig=initiationScheduleObject;
            	}
            }
        //}
        
        /* Added System Event Repetation Rule Json Data */
        
        
        var systemEventConfigRepetationSchedule=masterForm.down("#systemEventConfigRepetationSchedule");
        if(systemEventConfigRepetationSchedule && eventData.data.whetherRepetationApplicable){        	
        	var repetationScheduleObject=systemEventConfigRepetationSchedule.getValues();        	        	
        	jsonDataObject.msgRepetationRuleConfig=repetationScheduleObject;            	            	           
        }
        
        /* Added System Event Distribution List and Distribution Rule Json Data */
        
        if(masterForm){        	
        	var sysMsgEventId=masterForm.down("#masterId").getValue();
        	if(!isNullOrEmpty(sysMsgEventId)){
        		jsonDataObject.id=sysMsgEventId;
        	}
        	
        	var isImplicitFlow=masterForm.down("#isImplicitFlow").getValue();
        	if(isImplicitFlow=="true"){
        		me.setSystemMessageImplicitRecipientObject();
        	}
        	        	
        	var wsMsgEventRecipientConfigStr=masterForm.getValues()['wsMsgEventRecipientConfigs']; 
        	if(!isNullOrEmpty(wsMsgEventRecipientConfigStr)){
        		var wsMsgEventRecipientConfigObj=Ext.decode(wsMsgEventRecipientConfigStr);
        		if(!isEmpty(wsMsgEventRecipientConfigObj)){
            		jsonDataObject.wsMsgEventRecipientConfigs=wsMsgEventRecipientConfigObj; 
            	}else{
            		jsonDataObject.wsMsgEventRecipientConfigs=wsMsgEventRecipientConfigObj; 
            	}     	
        	}
        }               
        
        return Ext.encode(jsonDataObject);
    },
    

    /**
     * This method is used for to validate message scopes
     * @param masterForm - system event master configuration form 
     * @param systemEventMessageScope - system event message scope panel
     * 
     */
    validateMessageScope:function(masterForm,systemEventMessageScope){
    	
    	var messageScopeCombo=systemEventMessageScope.down("#messageScopeCombo");
    	var msgEventScopesHiddenField=masterForm.down("#msgEventScopes");
		if(!isNullOrEmpty(msgEventScopesHiddenField.getValue())){
			msgEventScopes = Ext.decode(msgEventScopesHiddenField.getValue());
			
			for(var msgEventScopeCount=0;msgEventScopeCount<messageScopeCombo.getStore().data.length;msgEventScopeCount++){
				var messageScopeId=messageScopeCombo.getStore().data.items[msgEventScopeCount].data.id;
				var messageScopeValue=messageScopeCombo.getStore().data.items[msgEventScopeCount].data.value;
				
				var isMessageScopeExist=false;
        		for(var count=0;count<msgEventScopes.length;count++){        			
        			if(messageScopeId===msgEventScopes[count].msgScopeParamId){
        				isMessageScopeExist=true;
        				break;        	            				         				
        			}    			
        		}   
        		
        		if(!isMessageScopeExist){
        			showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_MESSAGE_SCOPE_FOR')+messageScopeValue); //Please select message scope for
        			return 0;
        		}
				
			}    	            		    	            		
		}else{
			showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_MESSAGE_SCOPE')); //Please select message scope
			return 0;
		}
    },
    
    
    /**
     * This method is used for to validate distribution list    
     * @param masterForm - main panel form container 
     * @param eventData -  system message event panel config data
     *           
     */
    validateDistributionList:function(masterForm,eventData){
    	    	    	    	
    	var returnVal=1;
    	var systemEventConfigDistributionListEntity=masterForm.down("#systemEventConfigDistributionListEntity");
    	var wsMsgEventRecipientConfigField=masterForm.down('#wsMsgEventRecipientConfigs');
    	
    	if(systemEventConfigDistributionListEntity){
    		
	    	if(eventData.data.whetherImplicitDistributionList && eventData.data.whetherCommonMsgTemplate){
	    		return 1;
	    	}else if(eventData.data.whetherImplicitDistributionList && !eventData.data.whetherCommonMsgTemplate){
	    		Ext.each(systemEventConfigDistributionListEntity.items.items, function(form) {
	    			var formDataObject=form.getForm().getValues();
    	    		if(!isEmpty(formDataObject)){
    	    			var fieldSetObj=form.down('fieldset');
    	    			if(isNullOrEmpty(formDataObject.msgTemplateConfigId)){
    	    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_TEMPLATE_FOR')+fieldSetObj.title+getMessagingModuleTranslation('RECEIPIENT')); //Please select template for _____ Receipient 
    	    				returnVal=0;
    	    				return false;
    	    			}    	    			    	    			    		    	    			
    	    		}
	    		});
	    	}else if(!eventData.data.whetherImplicitDistributionList && eventData.data.whetherCommonMsgTemplate){
	    		Ext.each(systemEventConfigDistributionListEntity.items.items, function(form) {
	    			var formDataObject=form.getForm().getValues();
    	    		if(!isEmpty(formDataObject)){
    	    			var fieldSetObj=form.down('fieldset');
    	    			var recipientTypeId=formDataObject.recipientTypeId;
    	    					
    	    			if(!isNullOrEmpty(wsMsgEventRecipientConfigField.getValue())){
    		    			var wsMsgEventRecipientConfigs=Ext.decode(wsMsgEventRecipientConfigField.getValue());
    		    			
    		    			if(wsMsgEventRecipientConfigs.length>0){
    		    				for(var count=0;count<wsMsgEventRecipientConfigs.length;count++){
    								var recepientObj=wsMsgEventRecipientConfigs[count];
    								if(!isEmpty(recepientObj)){
    									if(recipientTypeId==recepientObj.msgRecipientTypeId){
    										
    										if(isNullOrEmpty(recepientObj.distrListInstance)){
    				    	    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SET_DISTRIBUSTION_LIST_FOR')+fieldSetObj.title+getMessagingModuleTranslation('RECEIPIENT')); //Please set distribustion list for _____ Receipient 
    				    	    				returnVal=0;
    				    	    				return false;
    				    	    			}
    										
    										if(isNullOrEmpty(recepientObj.distrRuleInstance) && eventData.data.whetherDistributionRuleApplicable){
    				    	    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SET_DISTRIBUSTION_RULE_FOR')+fieldSetObj.title+getMessagingModuleTranslation('RECEIPIENT')); //Please set distribustion rule for _____ Receipient 
    				    	    				returnVal=0;
    				    	    				return false;
    				    	    			}
    										
    	    							}
    								}    							
    							}
    		    			}	    			
    		    		}else{
							showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SET_DISTRIBUSTION_LIST_FOR')+fieldSetObj.title+getMessagingModuleTranslation('RECEIPIENT')); //Please set distribustion list for _____ Receipient 
    				    	returnVal=0;
    				    	return false;
						}		  
    	    		}
	    		});
	    	}else if(!eventData.data.whetherImplicitDistributionList && !eventData.data.whetherCommonMsgTemplate){
	    		
	    		Ext.each(systemEventConfigDistributionListEntity.items.items, function(form) {
	    			var formDataObject=form.getForm().getValues();
    	    		if(!isEmpty(formDataObject)){
    	    			var fieldSetObj=form.down('fieldset');
    	    			var recipientTypeId=formDataObject.recipientTypeId;
    	    			
    	    			if(isNullOrEmpty(formDataObject.msgTemplateConfigId)){
    	    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_TEMPLATE_FOR')+fieldSetObj.title+getMessagingModuleTranslation('RECEIPIENT')); //Please select template for _____ Receipient 
    	    				returnVal=0;
    	    				return false;
    	    			}
    	    					
    	    			if(!isNullOrEmpty(wsMsgEventRecipientConfigField.getValue())){
    		    			var wsMsgEventRecipientConfigs=Ext.decode(wsMsgEventRecipientConfigField.getValue());
    		    			
    		    			if(wsMsgEventRecipientConfigs.length>0){
    		    				for(var count=0;count<wsMsgEventRecipientConfigs.length;count++){
    								var recepientObj=wsMsgEventRecipientConfigs[count];
    								if(!isEmpty(recepientObj)){
    									if(recipientTypeId==recepientObj.msgRecipientTypeId){
    										
    										if(isNullOrEmpty(recepientObj.distrListInstance)){
    				    	    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SET_DISTRIBUSTION_LIST_FOR')+fieldSetObj.title+getMessagingModuleTranslation('RECEIPIENT')); //Please set distribustion list for _____ Receipient 
    				    	    				returnVal=0;
    				    	    				return false;
    				    	    			}
    										
    										if(isNullOrEmpty(recepientObj.distrRuleInstance) && eventData.data.whetherDistributionRuleApplicable){
    				    	    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SET_DISTRIBUSTION_RULE_FOR')+fieldSetObj.title+getMessagingModuleTranslation('RECEIPIENT')); //Please set distribustion rule for _____ Receipient 
    				    	    				returnVal=0;
    				    	    				return false;
    				    	    			}
    										
    	    							}
    								}    							
    							}
    		    			}	    			
    		    		}else{
							showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SET_DISTRIBUSTION_LIST_FOR')+fieldSetObj.title+getMessagingModuleTranslation('RECEIPIENT')); //Please set distribustion list for _____ Receipient 
    				    	returnVal=0;
    				    	return false;
						}		  
    	    		}
	    		});
	    	}else{
	    		returnVal=1;				
	    	}
	    	
	    	return returnVal;
    	}    	
    },
    
    /**
     * This method is used for to make array for System Event Message Scope Configuration
     * @param selectedMessageScopes - Selected Message Scope Array 
     * @param systemEventConfigMessageScopes - system Message Scope form container
     * @param messageScopeArrayObject - Message Scope Array Object
     * 
     */
    /*messageScopeArrayObject:function(selectedMessageScopes,systemEventConfigMessageScopes,messageScopeArrayObject){    	    	
    	
    	var messageScopeInnerObject=new Object();
    	var messageScopeArray=new Array();
    	    	        	
    	if(systemEventConfigMessageScopes){
    		var messageScopeCombo=systemEventConfigMessageScopes.down("#messageScopeCombo");
    		if(messageScopeCombo && !isNullOrEmpty(messageScopeCombo.getValue())){
    			messageScopeInnerObject.msgScopeParamId=messageScopeCombo.getValue();
    			
    			for(var count=0;count<selectedMessageScopes.length;count++){
    	    		
    	    		var object=new Object();
    	    		object.recordId=selectedMessageScopes[count];
    	    		
    	    		messageScopeArray.push(object);
    	    	}    	
    	    	messageScopeInnerObject.msgEventScopeRecords=messageScopeArray; 
    	    	messageScopeArrayObject.push(messageScopeInnerObject);    	    	        			
    		}
    	}
    		
    	return messageScopeArrayObject;
    },*/
    /*
     * This method resets scoping configs
     */
    onAcadLocSelection:function(combo,records){
    	var systemEventConfigMessageScopesForm=combo.up('systemeventconfigbasicinfoform').up('systemeventconfigmasterform').down('systemeventconfigmessagescopes');
    	if(!isEmpty(systemEventConfigMessageScopesForm)){
    		var systemEventConfigSelector=systemEventConfigMessageScopesForm.down("#messageScopeSelector");
	    	var messageScopeCombo=systemEventConfigMessageScopesForm.down('#messageScopeCombo');
	    	messageScopeCombo.reset();
	    	systemEventConfigSelector.reset();
	    	systemEventConfigSelector.getStore().removeAll();
	    	systemEventConfigSelector.reset();
	    	systemEventConfigSelector.getStore().removeAll();
    	}
    },
    /**
     * This method is used to add recipient types dynamically
     * @param combo - System event message config combo Reference
     * @param records- System event message config combo record of that selected event value 
     * 
     */
    loadSystemEventConfigSelector:function(combo,records){
    	var me=this;    	
    	var systemEventConfigMessageScopesForm=combo.up('form');
    	var systemMessageEventCombo=combo.up('systemeventconfigmessagescopes').up('systemeventconfigmasterform').down('#systemMessageEventCombo');
    //	var record= systemMessageEventCombo.getStore().findRecord( 'id', systemMessageEventCombo.getValue());
    	var index = systemMessageEventCombo.getStore().findExact('id', systemMessageEventCombo.getValue());
    	var record=null;
    	if (index !== -1) {
    	    record = systemMessageEventCombo.getStore().getAt(index);
    	}else{
    		record= systemMessageEventCombo.getStore().findRecord( 'id', systemMessageEventCombo.getValue());
    	}
    	var acadLocId=null;
    	if(!isEmpty(record) && record.data.msgConfigLevel.code!="Organization"){
        	var academyLocationCombo=combo.up('systemeventconfigmessagescopes').up('systemeventconfigmasterform').down('#academyLocationCombo');
        	if(academyLocationCombo.isValid( )){
        		acadLocId=academyLocationCombo.getValue();
        		var messageScopeId=combo.getValue();
             	var messageScopeRawValue=combo.getRawValue();
             	if(systemEventConfigMessageScopesForm && !isNullOrEmpty(messageScopeId) && !isNullOrEmpty(messageScopeRawValue)){                 		
             		me.loadMessageScopeSelectorStore(systemEventConfigMessageScopesForm,messageScopeRawValue,false,acadLocId);     		                     	                     	
             	}
        	
        	}else{
        		combo.reset();
        		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_ACAD_LOC')); 
        	}
        	
    	}else{
    		var messageScopeId=combo.getValue();
         	var messageScopeRawValue=combo.getRawValue();
         	
         	if(systemEventConfigMessageScopesForm && !isNullOrEmpty(messageScopeId) && !isNullOrEmpty(messageScopeRawValue)){                 		
         		me.loadMessageScopeSelectorStore(systemEventConfigMessageScopesForm,messageScopeRawValue,false);     		                     	                     	
         	}
    	}
     	
    }, 
    
    /**
     * This method is used to load Message Scope Selector Store
     * @param combo - System event message config combo Reference
     * @param records- System event message config combo record of that selected event value 
     * 
     */
    loadMessageScopeSelectorStore:function(systemEventConfigMessageScopesForm,messageScopeRawValue,isUpdate,acadLocId){
    	var submitURL="";
    	var SystemEventConfigSelector=systemEventConfigMessageScopesForm.down("#messageScopeSelector");
 		if(SystemEventConfigSelector){
 			if(messageScopeRawValue==='PROGRAM_IDS'){                     			
        		if(isNullOrEmpty(acadLocId))
        			submitURL=SERVERURL.PROGRAMS_FIND_ALL;  //URL-rest/program/findAll
        		else
        			submitURL=SERVERURL.FIND_PROGRAMS_BY_ACADEMY_LOCATION_IDS+"?academyLocationIds="+acadLocId;    //URL-rest/program/findByAcademyLocationIds
 				
     		}else if(messageScopeRawValue==='PROGRAM_BATCH_IDS'){                     			
     			if(isNullOrEmpty(acadLocId))
     				submitURL=SERVERURL.APPLICATIONS_BATCHES_FIND_ALL;  //URL-rest/batch/findAll
     			else
     				submitURL=SERVERURL.FIND_BATCHES_BY_ACADEMY_LOCATIONS+"?id="+acadLocId;  //URL-rest/batch/findAllByAcademyLocations
     			
     		}else if(messageScopeRawValue==='ACADEMY_LOCATION_IDS'){ 
        		submitURL=SERVERURL.ACADEMY_LOCATION_FIND_ALL_ACTIVE;  //URL-rest/academyLocation/findAllActive
     		}                 			
 			if(!isNullOrEmpty(submitURL)){
 				SystemEventConfigSelector.getStore().removeAll();
 				SystemEventConfigSelector.reset();
 				SystemEventConfigSelector.getStore().getProxy().api.read =submitURL;
 				SystemEventConfigSelector.getStore().load({
					callback: function(records, operation, success) {
    					if(records.length>0){    						    	
    						var systemeventconfigmasterform=SystemEventConfigSelector.up('systemeventconfigmasterform');    						
    						//SystemEventConfigSelector.getStore().sort('value', 'DESC');
							if(systemeventconfigmasterform){								
								var msgEventScopes=systemeventconfigmasterform.down("#msgEventScopes");
								var messageScopeCombo=systemeventconfigmasterform.down('#messageScopeCombo');
								
								var messageScopeComboId=messageScopeCombo.getValue();
								
								if(msgEventScopes && !isNullOrEmpty(msgEventScopes.getValue()) && !isNullOrEmpty(messageScopeComboId)){
									var msgEventScopeObjects=Ext.decode(msgEventScopes.getValue());
									
									for(var msgEventScopeObjectCount=0;msgEventScopeObjectCount<msgEventScopeObjects.length;msgEventScopeObjectCount++){
	    								var messageScopeObject=msgEventScopeObjects[msgEventScopeObjectCount];	    								
	    								if(!isEmpty(messageScopeObject)){
	    									if(messageScopeComboId==messageScopeObject.msgScopeParamId){
	    										if(messageScopeObject.msgEventScopeRecords.length>0){    							    							
	    			    							var scopeIDS=new Array();
	    			    							for(var idCount=0;idCount<messageScopeObject.msgEventScopeRecords.length;idCount++){
	    			    								var messageScopeRecordObject=messageScopeObject.msgEventScopeRecords[idCount];
	    			    								if(!isEmpty(messageScopeRecordObject) && !isNullOrEmpty(messageScopeRecordObject.recordId)){
	    			    									scopeIDS.push(messageScopeRecordObject.recordId);
	    			    								}
	    			    							}
	    			    							SystemEventConfigSelector.setValue(scopeIDS);
	    			    						}
	    										break;
	    									}	    									
	    								}
	    							}
									
								}
								
							}							    						
    					}
					}
 				});    				
 			}                 			  
 		}
    },
    /**
     * Save Message Scope Object 
     */
    saveMessageScopeObjectIncache: function(button){
    	var this$ = this;
		var systemeventconfigmasterform=button.up('systemeventconfigmasterform');
		
    	if(systemeventconfigmasterform){
    		
			var msgEventScopes=systemeventconfigmasterform.down("#msgEventScopes");
			var messageScopeCombo=systemeventconfigmasterform.down('#messageScopeCombo');
			var messageScopeSelector=systemeventconfigmasterform.down('#messageScopeSelector');
			var messageScopeComboId=messageScopeCombo.getValue();
			
			if(msgEventScopes &&  messageScopeSelector && !isNullOrEmpty(messageScopeComboId)){
				this$.setMessageScopeJson(msgEventScopes, messageScopeSelector, messageScopeComboId);
				
			}else{
				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_MESSAGE_SCOPE')); //Please select message scope
			}
    	}	
    },
    /**
     * Set Message Scope Object 
     * @param msgEventScopes
     * @param messageScopeSelector
     * @param messageScopeComboId
     */
    setMessageScopeJson : function(msgEventScopes, messageScopeSelector, messageScopeComboId){
    	var this$ = this;
		var msgEventScopeObjects=[];
		var isExist = false;
		var selectedMsgScopeArray = messageScopeSelector.getValue();
		if(!isNullOrEmpty(msgEventScopes.getValue())){
			msgEventScopeObjects=Ext.decode(msgEventScopes.getValue());
    	}	
		var removeRecordIndex = null;
		for(var scopeCount=0; scopeCount<msgEventScopeObjects.length; scopeCount++){
			
			var messageScopeObject = msgEventScopeObjects[scopeCount];
			if(!isEmpty(messageScopeObject)){
				if(messageScopeComboId==messageScopeObject.msgScopeParamId){
					isExist = true;
					if(selectedMsgScopeArray.length == 0){
						removeRecordIndex = scopeCount;
					}else{
						msgEventScopeObjects.splice(scopeCount, 1);
						msgEventScopeObjects = this$.getMsgEventScopeObjects(msgEventScopeObjects, selectedMsgScopeArray, messageScopeComboId);
						
					}
					
				}
			}
		}
		if(!isNullOrEmpty(removeRecordIndex)){
			msgEventScopeObjects.splice(removeRecordIndex, 1);
		}
		if(!isExist){
			msgEventScopeObjects = this$.getMsgEventScopeObjects(msgEventScopeObjects, selectedMsgScopeArray, messageScopeComboId);
		}
		msgEventScopes.setValue(Ext.encode(msgEventScopeObjects));
		console.log(msgEventScopeObjects)
		showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('MESSAGE_SCOPE_CRITERIA_SAVED_MSG'));
    	
    },
    /**
     *  Get Msg Event Scope Objects
     */
    getMsgEventScopeObjects: function(msgEventScopeObjects, selectedMsgScopeArray, messageScopeComboId){
    	var this$ = this;
    	var messageScopeObject = {};
		var msgEventScopeRecords = this$.getMessageScopeSelectorRecords(selectedMsgScopeArray);
		messageScopeObject.msgEventScopeRecords = msgEventScopeRecords;
		messageScopeObject.msgScopeParamId = messageScopeComboId;
		msgEventScopeObjects.push(messageScopeObject);
		return msgEventScopeObjects;
    },
    /**
     *  Set Message Selector Records to Json
     */
    getMessageScopeSelectorRecords: function(selectedMsgScopeArray){
    	var msgEventScopeRecords = [];
    	for(var i = 0; i< selectedMsgScopeArray.length; i++ ){
			var record = {
					recordId : selectedMsgScopeArray[i]
			};
			msgEventScopeRecords.push(record);
		}
    	return msgEventScopeRecords;
    },
    /**
     * This method is used to save selected Message Scope inside cache        
     * @param button - button reference    
     * 
     */        
    /*saveMessageScopeObjectIncache:function(button){    		    					    						    	
    	    	   		
    		var me=this;
    		var systemeventconfigmasterform=button.up('systemeventconfigmasterform');
    		
        	if(systemeventconfigmasterform){
        		
    			var msgEventScopes=systemeventconfigmasterform.down("#msgEventScopes");
    			var messageScopeCombo=systemeventconfigmasterform.down('#messageScopeCombo');
    			var messageScopeSelector=systemeventconfigmasterform.down('#messageScopeSelector');
    								
    			var messageScopeComboId=messageScopeCombo.getValue();
    								
    			if(msgEventScopes &&  messageScopeSelector && !isNullOrEmpty(messageScopeComboId)){
    				
    				var isExist=false;
    				var msgEventScopeObjects=new Array();
    				var selectedMsgScopeArray=messageScopeSelector.getValue();
    				if(selectedMsgScopeArray.length>0){
    					if(!isNullOrEmpty(msgEventScopes.getValue())){
        					msgEventScopeObjects=Ext.decode(msgEventScopes.getValue());
    						
            				for(var msgEventScopeObjectCount=0;msgEventScopeObjectCount<msgEventScopeObjects.length;msgEventScopeObjectCount++){
            					var messageScopeObject=msgEventScopeObjects[msgEventScopeObjectCount];	    								
            					if(!isEmpty(messageScopeObject)){
            						if(messageScopeComboId==messageScopeObject.msgScopeParamId){
            							        							 
    									if(selectedMsgScopeArray.length==0){
    										messageScopeObject.msgEventScopeRecords=new Array();	
    									}else if(selectedMsgScopeArray.length>0){ 
    										var updatedMsgScopeArray=new Array();  										
            								for(var idCount=0;idCount<selectedMsgScopeArray.length;idCount++){        									
    											var isExistInMessageScopeArray=false;
    											var selectedMessageScopeId=selectedMsgScopeArray[idCount];
    											for(var existingIdCount=0;existingIdCount<messageScopeObject.msgEventScopeRecords.length;existingIdCount++){
    												var existingMsgObject=messageScopeObject.msgEventScopeRecords[existingIdCount];
    												if(existingMsgObject.recordId==selectedMessageScopeId){
    													isExistInMessageScopeArray=true;
    													updatedMsgScopeArray.push(existingMsgObject);	
    													break;
    												}
    											}        	
    											if(!isExistInMessageScopeArray){
    												var scopeObject=new Object();
            										scopeObject.recordId=selectedMessageScopeId;
            										updatedMsgScopeArray.push(scopeObject);										
    											}
            								}   				
            								if(updatedMsgScopeArray.length>0){
            									messageScopeObject.msgEventScopeRecords=updatedMsgScopeArray;
            								}																
            							}        							
            							msgEventScopes.setValue(Ext.encode(msgEventScopeObjects));
                	    				showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('MESSAGE_SCOPE_CRITERIA_SAVED_MSG')); //Message Scope criteria has saved successfully.
            							        							
            							isExist=true;
            							break;
            						}	    									
            					}
            				}        				        				       				        				        				
        				}
        				
        				if(!isExist){
        					var systemEventConfigMessageScopes=systemeventconfigmasterform.down("#systemEventConfigMessageScopes");
        			        if(systemEventConfigMessageScopes){        			        	        			        	
        			        	var msgScopeArray=me.messageScopeArrayObject(systemEventConfigMessageScopes.down("#messageScopeSelector").getValue(),systemEventConfigMessageScopes,msgEventScopeObjects);        			        	
        			        	msgEventScopes.setValue(Ext.encode(msgScopeArray));
    	    					showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('MESSAGE_SCOPE_CRITERIA_SAVED_MSG')); //Message Scope criteria has saved successfully.
        			        }
        				}
    				}else{
    					showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_AVAILABLE_ITEMS')); //Please select available items
    				}    				
    			}else{
					showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_MESSAGE_SCOPE')); //Please select message scope
				}
    								
        	}							    						        	
    },*/
    
    /**
     * This method is used to call on system event config selection
     * @param combo - System event message config combo Reference
     * @param records- System event message config combo record of that selected event value 
     * 
     */
    onSystemEventSelection:function(combo,records){
    	var me=this;
     	var selectMessageEventId=combo.getValue();
     	if(!isNullOrEmpty(selectMessageEventId) && !isEmpty(records[0].data)){
     		
     		var eventData=records[0].data;
     		var basicInfoPanel=combo.up('form');
     		
     		/* hide/show system event configuration screen panels */
     		me.setSystemEventConfigurationPanelVisibility(eventData,combo);
     		
     		/* hide/show academy location combo */
     		me.hideShowAcademyLocationCombo(eventData,basicInfoPanel);
     		
     		/* hide/show template combo */
     		me.hideShowCommonTemplateCombo(eventData,basicInfoPanel);
     		
     		
     		/* load template combo */
     		if(!isNullOrEmpty(eventData.msgCatagoryId)){
     			var msgCategoryIdParam=new Object();                	
     			msgCategoryIdParam.msgCatagoryId=eventData.msgCatagoryId;
     			msgCategoryIdParam.availableForAdhoc=false;
         		
     			me.loadDependentComboData(combo,records,msgCategoryIdParam,'#templateCombo');
     		}
     		
     		/* load message scope combo */
     		if(eventData.whetherMsgScopeApplicable && !isNullOrEmpty(selectMessageEventId)){
     			var msgEventIdParam=new Object();                	
     			msgEventIdParam.id=selectMessageEventId;
     			var  systemEventConfigMessageScopes= basicInfoPanel.up('systemeventconfigmasterform').down('#systemEventConfigMessageScopes');
     			var messageScopeSelector = systemEventConfigMessageScopes.down('#messageScopeSelector');
     			messageScopeSelector.getStore().removeAll();
     			systemEventConfigMessageScopes.getForm().reset();
     			me.loadDependentComboData(combo,records,msgEventIdParam,'#messageScopeCombo');
     		}                     	                     	
     		
     		/* Add recipient types dynamically */
     		var systemeventconfigmasterform=combo.up('systemeventconfigmasterform');
     		if(systemeventconfigmasterform){
     			var systemeventconfigdistributionlistentity=systemeventconfigmasterform.down("#systemEventConfigDistributionListEntity");
         		if(!eventData.whetherImplicitDistributionList){
         			if(systemeventconfigdistributionlistentity){
     	    			systemeventconfigdistributionlistentity.setTitle(getMessagingModuleTranslation('EXPLICIT_DISTRIBUTION_LIST'));
     	    		}     	    		
         			me.addRecipientTypes(combo,records,eventData);
         		}else if(eventData.whetherImplicitDistributionList){         			         	    	     	    		
         	    	if(systemeventconfigdistributionlistentity){
         	    		systemeventconfigdistributionlistentity.setTitle(getMessagingModuleTranslation('IMPLICIT_DISTRIBUTION_LIST'));
         	    	}      	    		
         	    	systemeventconfigmasterform.down("#isImplicitFlow").setValue(true);     	    		
         	    	me.addRecipientTypes(combo,records,eventData);         	    	     			
         		}
     		}     		     		     		
     		
     		/* Add Initiation Rule Advanced Search Panel dynamically */
     		if(eventData.whetherInitiationRuleApplicable){
     			me.addInitiationRulePanel(combo,records,eventData,false);
     		}
     		
     		basicInfoPanel.down('#uiDisplayCodeItemId').setValue(combo.getRawValue());
     	}    
    	
    },
    
    
    /**
     * This method is used for to hide/Show Common Template Combo
     * @param eventData - System event message config data
     * @param basicInfoPanel- basic config form reference  
     * 
     */
    hideShowCommonTemplateCombo:function(eventData,basicInfoPanel){
    	if(basicInfoPanel && !isNullOrEmpty(eventData.whetherCommonMsgTemplate)){
    		var templateCombo=basicInfoPanel.down('#templateCombo');
    		if(templateCombo){
    			if(eventData.whetherCommonMsgTemplate){         			     			     				
    				templateCombo.setVisible(true);
    				templateCombo.setDisabled(false);
 				}else{
 					templateCombo.setVisible(false);
 					templateCombo.setDisabled(true);	
 	    		} 		
 			}	
 		}
    },
    
    /**
     * This method is used for to hide/Show Common Template Combo
     * @param eventData - System event message config data
     * @param basicInfoPanel- basic config form reference  
     * 
     */
    hideShowAcademyLocationCombo:function(eventData,basicInfoPanel){
    	if(basicInfoPanel){
    		var academyLocationCombo=basicInfoPanel.down('#academyLocationCombo');
    		if(!isEmpty(eventData.msgConfigLevel)){
     			if(eventData.msgConfigLevel.code==="Organization"){         			     			     				
         			basicInfoPanel.down('#msgConfigLevelId').setValue(eventData.msgConfigLevel.id);
         			basicInfoPanel.down('#msgConfigLevelValue').setValue(eventData.msgConfigLevel.id);     			
         			if(academyLocationCombo){
         				academyLocationCombo.reset();
         				academyLocationCombo.setVisible(false);
         				academyLocationCombo.setDisabled(true);
         			}     			                 			
         		}else{
         			basicInfoPanel.down('#msgConfigLevelId').setValue(eventData.msgConfigLevel.id);
     				basicInfoPanel.down('#msgConfigLevelValue').setValue("");
     				if(academyLocationCombo){
         				academyLocationCombo.setVisible(true);
         				academyLocationCombo.setDisabled(false);
         			}
         		}
     		}
    	}    	
    },
    
    /**
     * This method is used to add  Initiation Rule Advanced Search Panel dynamically
     * @param combo - combo Reference
     * @param records - selected system message event record
     * @param eventData - selected system message event model data 
     * @param isUpdate - update mode flag
     * @param updateData- json data in update mode
     * 
     */    
    addInitiationRulePanel:function(combo,records,eventData,isUpdate,updateData){
    	var me=this; 	 	
    	var systemeventconfigmasterform=combo.up('systemeventconfigmasterform');
    	if(systemeventconfigmasterform){
    		var systemEventConfigInitiationRule=systemeventconfigmasterform.down("#systemEventConfigInitiationRule");
    		if(systemEventConfigInitiationRule){
    			
    			if(isUpdate){    									
						if(!isEmpty(updateData.advancedSearchDTO)){
                    		
                    		var qyeryBuilderView=systemEventConfigInitiationRule.down("#initiationRuleAdvancedSearchPanel");                    		
                    		if(!qyeryBuilderView){                    			
                    			systemEventConfigInitiationRule=me.addInitiationRuleQueryBuilderViewPanel(systemEventConfigInitiationRule,updateData.searchConfigCode,updateData.searchResultViewCode);
                    			qyeryBuilderView=systemEventConfigInitiationRule.down("#initiationRuleAdvancedSearchPanel");
                    		}else{
                    			
                    			systemEventConfigInitiationRule.remove(qyeryBuilderView);
                        		systemEventConfigInitiationRule.doLayout();
                        		
                    			systemEventConfigInitiationRule=me.addInitiationRuleQueryBuilderViewPanel(systemEventConfigInitiationRule,updateData.searchConfigCode,updateData.searchResultViewCode);
                    			qyeryBuilderView=systemEventConfigInitiationRule.down("#initiationRuleAdvancedSearchPanel");                    			
                    		}
                    		
                    		systemEventConfigInitiationRule.getForm().findField("id").setValue(updateData.id);
                    		systemEventConfigInitiationRule.getForm().findField("dataProviderId").setValue(updateData.dataProviderId);
                    		systemEventConfigInitiationRule.getForm().findField("savedRuleRefId").setValue(updateData.savedRuleRefId);
                        	systemEventConfigInitiationRule.getForm().findField("searchConfigCode").setValue(updateData.searchConfigCode);
                        	systemEventConfigInitiationRule.getForm().findField("searchResultViewCode").setValue(updateData.searchResultViewCode);
                        	
                        	var retainSearchCriteriasIncached=me.setDefaultSearchCriteriaInCached(systemeventconfigmasterform,updateData.advancedSearchDTO.cbSearchCriteria,qyeryBuilderView);
                        	
                        	var dataProviderInstance=systemeventconfigmasterform.down("#dataProviderInstance");
                        	if(dataProviderInstance && !isNullOrEmpty(dataProviderInstance.getValue())){
                        		var dataProviderInstanceObject=Ext.decode(dataProviderInstance.getValue());
                        		if(!isEmpty(dataProviderInstanceObject.advancedSearchDTO.cbSearchCriteria.searchCriterias)){
                        			dataProviderInstanceObject.advancedSearchDTO.cbSearchCriteria.searchCriterias=retainSearchCriteriasIncached;
                        		}                        		
                        		systemeventconfigmasterform.down("#dataProviderInstance").setValue(Ext.encode(dataProviderInstanceObject));            						            
                        	}
                    	}											
				}else{
					if(!isNullOrEmpty(eventData.id)){    				    				
	    				var paramObject=new Object();
	    				paramObject.id=eventData.id; 
	    				
	    				me.sendGetAjaxRequest(SERVERURL.FIND_DEFAULT_CONFIG_BY_MESSAGE_ID, 'GET', paramObject, function(option, success, response) {
	                		if(success){	
	                			var data = Ext.decode(response.responseText);
	                            if(!isEmpty(data)){	                            	
	                            	if(!isEmpty(data.advancedSearchDTO)){
	                            		
	                            		var qyeryBuilderView=systemEventConfigInitiationRule.down("#initiationRuleAdvancedSearchPanel");
	                            		if(!qyeryBuilderView){
	                            			systemEventConfigInitiationRule=me.addInitiationRuleQueryBuilderViewPanel(systemEventConfigInitiationRule,data.advancedSearchDTO.configCode,data.advancedSearchDTO.viewCode);
	                            			qyeryBuilderView=systemEventConfigInitiationRule.down("#initiationRuleAdvancedSearchPanel");
	                            		}else{
											systemEventConfigInitiationRule.remove(qyeryBuilderView);
											systemEventConfigInitiationRule.doLayout();
											
											systemEventConfigInitiationRule=me.addInitiationRuleQueryBuilderViewPanel(systemEventConfigInitiationRule,data.advancedSearchDTO.configCode,data.advancedSearchDTO.viewCode);
	                            			qyeryBuilderView=systemEventConfigInitiationRule.down("#initiationRuleAdvancedSearchPanel");                   			
	                            			
										}
	                            		
	                            		systemEventConfigInitiationRule.getForm().findField("dataProviderId").setValue(data.dataProviderId);
	                            		systemEventConfigInitiationRule.getForm().findField("savedRuleRefId").setValue(data.savedRuleRefId);
	                                	systemEventConfigInitiationRule.getForm().findField("searchConfigCode").setValue(data.advancedSearchDTO.configCode);
	                                	systemEventConfigInitiationRule.getForm().findField("searchResultViewCode").setValue(data.advancedSearchDTO.viewCode);
	                                	                                	                            	
		                            	//qyeryBuilderView.loadConfiguration(qyeryBuilderView,data.advancedSearchDTO.cbSearchCriteria);
	                                	me.setDefaultSearchCriteriaInCached(systemeventconfigmasterform,data.advancedSearchDTO.cbSearchCriteria,qyeryBuilderView);
	                                		                                		                                
	                            	}	                            	                            		                            		                            	
	                            }
	                		}     
	        			});
	    				
					}						
				}    						
    		}
    	}
    },
    
    /**
     * This method is used for to set default Search Criteria In Cache
     * @param systemeventconfigform - form container which contain advance search panel
     * @param cbSearchCriteria- advance search json data object  
     * @param qyeryBuilderView- advance searh panel 
     * 
     */    
    setDefaultSearchCriteriaInCached:function(systemeventconfigform,cbSearchCriteria,qyeryBuilderView){
    	
    	if(!isEmpty(cbSearchCriteria)){
    		
    		var whetherPassedDefaultSearchCriteriaToCMP=false;
    		var componentCopyOfCbSearchCriteria=cbSearchCriteria;	                                		
    		var defaultSearchCriteria=cbSearchCriteria;
    		
    		var defaultSearchCriterias=new Array();
    		var passedToCmpSearchCriterias=new Array();
    		
    			                                			
    			if(!isEmpty(cbSearchCriteria.searchCriterias) && cbSearchCriteria.searchCriterias.length>0){
    				for(var searchCriteriaCount=0;searchCriteriaCount<cbSearchCriteria.searchCriterias.length;searchCriteriaCount++){
    					var searchCriteriaObject=cbSearchCriteria.searchCriterias[searchCriteriaCount];
    					if(!isEmpty(searchCriteriaObject)){	                                						
    						if(searchCriteriaObject.visibility==false && searchCriteriaObject.whetherEditable==false){
    							defaultSearchCriterias.push(searchCriteriaObject);	                                								                                						
    						}else if(searchCriteriaObject.visibility==true && searchCriteriaObject.whetherEditable==true){
    							passedToCmpSearchCriterias.push(searchCriteriaObject);	                                							
    							if(!whetherPassedDefaultSearchCriteriaToCMP){
    								whetherPassedDefaultSearchCriteriaToCMP=true;
    							}
    						}/*else{
    							defaultSearchCriterias.push(searchCriteriaObject);
    						}*/	                                						
    					}
    				}
    				
    				if(defaultSearchCriterias.length>0){
						if(!defaultSearchCriterias[0].searchCriterias){
							defaultSearchCriteria.searchCriterias=defaultSearchCriterias;    						 	
							if(defaultSearchCriteria.visibility==false && defaultSearchCriteria.whetherEditable==false){
    							systemeventconfigform.down("#defaultSearchCriterias").setValue(Ext.encode(defaultSearchCriteria));
    						}
						}else{
							if(defaultSearchCriterias[0].visibility==false && defaultSearchCriterias[0].whetherEditable==false){
    							systemeventconfigform.down("#defaultSearchCriterias").setValue(Ext.encode(defaultSearchCriterias[0]));
    						}
						}    					
    				}
    				
    				if(passedToCmpSearchCriterias.length>0){
    					componentCopyOfCbSearchCriteria.searchCriterias=passedToCmpSearchCriterias;	                                					
    				}
    				    				
    					                                				
    				qyeryBuilderView.loadConfiguration(qyeryBuilderView,componentCopyOfCbSearchCriteria,whetherPassedDefaultSearchCriteriaToCMP);
    				
    				return passedToCmpSearchCriterias;
    					                                					                                								
    			}
    		//}	                                		
    	}
    	
    },
    
    /**
     * This method is used for to set default Search Criteria In Cache
     * @param systemEventConfigInitiationRule - form container which contain advance search panel
     * @param configCode- config Code  
     * @param viewCode- view Code 
     * 
     */    
    addInitiationRuleQueryBuilderViewPanel:function(systemEventConfigInitiationRule,configCode,viewCode){
    	
    	if(systemEventConfigInitiationRule && !isNullOrEmpty(configCode) && !isNullOrEmpty(viewCode)){
    		systemEventConfigInitiationRule.add({
        		xtype: 'systemeventmessagingruleeditor',
        		itemId:'initiationRuleAdvancedSearchPanel',		 
        		searchConfigCode : configCode,
        		searchResultViewCode: viewCode                            		
        	});
    		systemEventConfigInitiationRule.doLayout();
    	}
    	
    	return systemEventConfigInitiationRule;
    },
    
    
    /**
     * This method is used to add recipient types dynamically
     * @param combo - combo Reference
     * @param records - selected system message event record
     * @param eventData - selected system message event model data
     * @param isUpdate - update flag
     *  
     */
    addRecipientTypes:function(combo,records,eventData,isUpdate){
    	var me=this;
    	var systemeventconfigmasterform=combo.up('systemeventconfigmasterform');
    	if(systemeventconfigmasterform){
    		var systemEventConfigDistributionListEntity=systemeventconfigmasterform.down("#systemEventConfigDistributionListEntity");
    		if(systemEventConfigDistributionListEntity){
    			if(!isNullOrEmpty(eventData.id) && !isNullOrEmpty(eventData.msgCatagoryId)){
    				var whetherImplicitDistributionList=eventData.whetherImplicitDistributionList;
    				var whetherCommonMsgTemplate=eventData.whetherCommonMsgTemplate;
    				
    				var paramObject=new Object();
    				paramObject.sysMsgEvtId=eventData.id;
    				paramObject.msgCatagoryId=eventData.msgCatagoryId;
    				
    				me.sendGetAjaxRequest(SERVERURL.FIND_ALL_MESSAGEING_RECIPIENT_TYPE, 'GET', paramObject, function(option, success, response) {
                		if(success){	
                			var data = Ext.decode(response.responseText);
                			if(data.length==0){
                        		systemEventConfigDistributionListEntity.setVisible(true);
                        	}
                            if(!isEmpty(data)){                            	
                            	
                            	/* First Remove All Components */
                            	systemEventConfigDistributionListEntity.removeAll();
                            	/*Ext.each(systemEventConfigDistributionListEntity.items.items, function(formCmp) {
                            		systemEventConfigDistributionListEntity.remove(formCmp);
                            	});*/
                            	
                            	for(var dataCount=0;dataCount<data.length;dataCount++){
                            		var recipientTypeObject=data[dataCount];
                            		if(!isEmpty(recipientTypeObject)){
                            			
                            			var entityRecipientTypeForm=null;
                            			if(!isNullOrEmpty(recipientTypeObject.code)){
                            				
                            				entityRecipientTypeForm=systemEventConfigDistributionListEntity.down("#"+recipientTypeObject.code+'recipientTypeForm');
                            				if(!entityRecipientTypeForm){
                            					systemEventConfigDistributionListEntity=me.addDistributionListQueryBuilderViewPanel(systemEventConfigDistributionListEntity,recipientTypeObject,whetherImplicitDistributionList,whetherCommonMsgTemplate);
                            					entityRecipientTypeForm=systemEventConfigDistributionListEntity.down("#"+recipientTypeObject.code+'recipientTypeForm');
                            				}
                            				
                            				if(entityRecipientTypeForm){
                            					var templateCombo=entityRecipientTypeForm.down("#templateCombo");
                                    			if(templateCombo && !isEmpty(recipientTypeObject.msgTemplateConfigs) && recipientTypeObject.msgTemplateConfigs.length>0){                        				
                                    				templateCombo.getStore().loadData(recipientTypeObject.msgTemplateConfigs);
                                    			}     
                                    			
                                    			
                                    			if(isUpdate){       
                                    				                                    				
                                    				var recipientTypeId=entityRecipientTypeForm.getValues()['recipientTypeId'];   	
                        	            			var masterFormValues=systemeventconfigmasterform.getForm().getValues();
                        	            			var isImplicitFlow=systemeventconfigmasterform.down("#isImplicitFlow").getValue();
                        	            			
                        	            				if(!isEmpty(masterFormValues)){
                        	            					if(!isNullOrEmpty(masterFormValues.wsMsgEventRecipientConfigs)){
                        	                					var wsMsgEventRecipientConfigs=Ext.decode(masterFormValues.wsMsgEventRecipientConfigs);
                        	                					
                        	                					if(wsMsgEventRecipientConfigs.length>0){
                        	                						for(var count=0;count<wsMsgEventRecipientConfigs.length;count++){
                        	                							var recepientObj=wsMsgEventRecipientConfigs[count];
                        	                							if(!isEmpty(recepientObj)){
                        	                								if(recipientTypeId==recepientObj.msgRecipientTypeId){
                        	                									
                        	                									if(isImplicitFlow=="true" && !isEmpty(recepientObj.distrListInstance)){
                        	                										recepientObj.distrListInstanceImplicitId=recepientObj.distrListInstance.id;
                        	                										delete recepientObj.distrListInstance.id;
                        	                									}
                        	                									entityRecipientTypeForm.getForm().setValues(recepientObj);
                        	                									break;
                        	                    							}
                        	                							}    							
                        	                						}
                        	                					}
                        	                				}
                        	            				}
                                    			}                                    			
                            				}
                            				                            				                            				
                            			}
                            			
                            		}
                            	}
                            	
                            }
                		}    
        			});    				    				
    			}    			
    		}
    	}
    },
    
      
    /**
     * This method is used to add recipient form dynamically
     * @param systemEventConfigDistributionListEntity - recipient form panel container reference 
     * @param recipientTypeObject - form data object to set in recipient form
     * @param whetherImplicitDistributionList - whether Implicit Distribution List flag
     * @param whetherCommonMsgTemplate - whether Common Msg Template flag
     *  
     */
    addDistributionListQueryBuilderViewPanel:function(systemEventConfigDistributionListEntity,recipientTypeObject,whetherImplicitDistributionList,whetherCommonMsgTemplate){
    	    	
    	if(systemEventConfigDistributionListEntity && !isEmpty(recipientTypeObject)){
    		
    		systemEventConfigDistributionListEntity.add({
    			xtype:'form',
    			plugins: "formlabelrequired",
        		itemId: recipientTypeObject.code+'recipientTypeForm',
        		items:[{
    		        xtype: 'fieldset',    		        
    		        title: getMessagingModuleTranslation(recipientTypeObject.code),   //getMessagingModuleTranslation('STUDENT'),                        		        
    		        padding: '10 0 0 0',        
    		        items: [{
		        			xtype:'hidden',
		        			name:'id',
		        			itemId:'id'
        				},{
    	        			xtype:'hidden',
    	        			name:'recipientTypeId',
    	        			itemId:'recipientTypeId',
    	        			value:recipientTypeObject.id
            			},{    	    
            				xtype:'hidden',
            				name:'msgRecipientTypeId',
            				itemId:'msgRecipientTypeId'	
            			},{
    	        			xtype:'hidden',
    	        			name:'distrListProviderId',
    	        			itemId:'distrListProviderId',
    	        			value:recipientTypeObject.distrListProviderId
    	        		},{
    		        		xtype:'hidden',
    		        		name:'distrRuleProviderId',
    		        		itemId:'distrRuleProviderId',
    		        		value:recipientTypeObject.distrRuleProviderId
    		        	},{
    		        		xtype:'hidden',
    		        		name:'distrListInstanceImplicitId',
    		        		itemId:'distrListInstanceImplicitId'
    		        	},{
    			        xtype: 'fieldcontainer', 
    			        layout: 'hbox',
    			        defaults: {
    			            labelAlign: 'top',
    			            width: 226
    			        },
    			        items: [{
    			        	xtype:'textfield',
    			        	name:'buildListName',
    			        	itemId:'buildListName',
    			        	hidden:(whetherImplicitDistributionList)?true:false,
    			        	fieldLabel: getMessagingModuleTranslation('BUILD_LIST_NAME'),
    			        	hidden:true,
    			            allowBlank: false
    			        },{
    			            xtype: 'customcombobox',
    			            fieldLabel: getMessagingModuleTranslation('SELECT_TEMPLATE'),
    			            editable: false,
    			            name: 'msgTemplateConfigId',
    			            itemId: 'templateCombo',
    			            valueField: 'id',
    			            queryMode: 'local',
    			            displayField: 'code',
    			            hidden:(whetherCommonMsgTemplate)?true:false,
    			            //store:'messaging.MessageTemplate',
    			            allowBlank: false,
    			            listeners: {
    			            	render: function(combo){
    			            		var store = Ext.create('Academia.store.messaging.MessageTemplate');
    			            		combo.bindStore(store);
    			            	}
    			            }
    			        },{
    			            xtype: 'button',
    			            text: getMessagingModuleTranslation('BUILD_LIST'),
    			            itemId: 'buildListButton',
    			            buttonAlign: 'right',
    			            hidden:(whetherImplicitDistributionList)?true:false,
    			            ui: 'CustomBtnSubmit',
    			            style:{
    			            	marginTop:'28px'
    			            },
    			            scale: CONSTANTS.BUTTONSIZE
    			        }]
    			    }]
    	        }]
    		});
        	
        	systemEventConfigDistributionListEntity.doLayout();
    	}
    	
    	return systemEventConfigDistributionListEntity;
    	    	    	
    },
    
    /**
     * This method is used to show Build List Dialog Box
     * @param button - Button Reference
     * 
     */
    showBuildListWindow: function(button){
    	var me=this;
    	var cachedRecipientDistrbutionListObject=null;
    	var cachedRecipientDistrbutionRuleObject=null;
    	var systemeventconfigmasterform=button.up('systemeventconfigmasterform');
    	if(systemeventconfigmasterform){
    		var systemMessageEventCombo=systemeventconfigmasterform.down("#systemMessageEventCombo");
    		if(systemMessageEventCombo){
    			    	    	
    	    	
    			var selectMessageEventId=systemMessageEventCombo.getValue();    			
    	     	if(!isNullOrEmpty(selectMessageEventId)){
    	     		var record=systemMessageEventCombo.getStore().getById(selectMessageEventId);
    	     		if(!isEmpty(record.data)){
    	     			
    	     			var eventData=record.data;    	     			
    	     			var systemeventconfigdistributionrule=me.showWindow('systemeventconfigdistributionrule');
    	     			if(systemeventconfigdistributionrule){
    	     				
    	     				systemeventconfigdistributionrule.setTitle(button.getText());
    	     				
    	     				var systemEventConfigDistributionList=systemeventconfigdistributionrule.down('#systemEventConfigDistributionList');
    	     				var sysEveConfigDistributionrulepanel=systemeventconfigdistributionrule.down('#sysEveConfigDistributionrulepanel');
    	     			
    	     				me.setVisibility(systemEventConfigDistributionList,!eventData.whetherImplicitDistributionList);
    	     				me.setVisibility(sysEveConfigDistributionrulepanel,eventData.whetherDistributionRuleApplicable);
    	     				
    	     				var recepientTypeform=button.up('form');
    	        	    	if(recepientTypeform){
    	        	    		
    	        	    		var recipientTypeId=recepientTypeform.getValues()['recipientTypeId'];   	
    	            			var masterFormValues=systemeventconfigmasterform.getForm().getValues();
    	            			
    	            				if(!isEmpty(masterFormValues)){
    	            					if(!isNullOrEmpty(masterFormValues.wsMsgEventRecipientConfigs)){
    	                					var wsMsgEventRecipientConfigs=Ext.decode(masterFormValues.wsMsgEventRecipientConfigs);
    	                					
    	                					if(wsMsgEventRecipientConfigs.length>0){
    	                						for(var count=0;count<wsMsgEventRecipientConfigs.length;count++){
    	                							var recepientObj=wsMsgEventRecipientConfigs[count];
    	                							if(!isEmpty(recepientObj)){
    	                								if(recipientTypeId==recepientObj.msgRecipientTypeId){
    	                									cachedRecipientDistrbutionListObject=recepientObj.distrListInstance;
    	                									cachedRecipientDistrbutionRuleObject=recepientObj.distrRuleInstance;
    	                									break;
    	                    							}
    	                							}    							
    	                						}
    	                					}
    	                				}
    	            				}        				    	    	
    	        	    	}
    	     				
    	        	    	
    	     				/* Add Distribution List dynamically */    	        	    	
    	     	     		if(!eventData.whetherImplicitDistributionList){
    	     	     			me.addSystemEventMessagingRuleEditorPanel(button,systemeventconfigmasterform,systemeventconfigdistributionrule,'#systemEventConfigDistributionList','systemEventConfigDistributionListRuleEditor','distrListProviderId',cachedRecipientDistrbutionListObject);    	     	     			
    	     	     		}
    	     	     		     		
    	     	     		
    	     	     		/* Add Distribution Rule dynamically */
    	     	     		if(eventData.whetherDistributionRuleApplicable){
    	     	     			me.addSystemEventMessagingRuleEditorPanel(button,systemeventconfigmasterform,systemeventconfigdistributionrule,'#sysEveConfigDistributionrulepanel','systemEventConfigDistributionRuleEditor','distrRuleProviderId',cachedRecipientDistrbutionRuleObject);
    	     	     		}
    	     			}
    	     		}    	     		
    	     	}	
    	     	
    	     	
    		}
    	}     	
    },
    
    
    /**
     * This method is used to add System Event Messaging Rule Editor Panel dynamically
     * @param button - button Reference
     * @param systemeventconfigdistributionrule - This is main form panel container reference  
     * @param systemEventConfigurationPanelId - This is a container panel id  
     * @param ruleEditorItemId - This is a item ID of System Event Messaging Rule Editor Panel
     * @param providerId - This is a provider Id name of form 
     * @param cachedRecipientObject - cached Recipient Object
     * 
     */
    addSystemEventMessagingRuleEditorPanel:function(button,systemeventconfigmasterform,systemeventconfigdistributionrule,systemEventConfigurationPanelId,ruleEditorItemId,providerId,cachedRecipientObject){
    	var me=this;
    	var recepientTypeform=button.up('form');
    	
    	if(recepientTypeform){
    		var systemEventConfigurationPanel=systemeventconfigdistributionrule.down(systemEventConfigurationPanelId);
    		if(systemEventConfigurationPanel){
    			    			
    				if(isEmpty(cachedRecipientObject)){
    					
    					var providerValue=recepientTypeform.getValues()[providerId];
    	    			if(!isNullOrEmpty(providerValue)){
    	    				var paramObject=new Object();
    	    				paramObject.id=providerValue;				
    	    				    				
    	    				me.sendGetAjaxRequest(SERVERURL.FIND_DEFAULT_CONFIG_BY_DATA_PROVIDER_ID, 'GET', paramObject, function(option, success, response) { //URL - :'rest/sysMsgEvtDefaultRecipientResource/findDefaultDataProviderConfigById'
    	                		if(success){
    	                			if(!isNullOrEmpty(response.responseText)){
    	                				var data = Ext.decode(response.responseText);
        	                            if(!isEmpty(data)){
        	                            	
        	                            	if(!isEmpty(data.cbSearchCriteria)){
        	                            		
        	                            		var qyeryBuilderView=systemEventConfigurationPanel.down("#"+ruleEditorItemId);
        	                            		if(!qyeryBuilderView){
        	                            			systemEventConfigurationPanel=me.addDistributionRuleQueryBuilderViewPanel(systemEventConfigurationPanel,ruleEditorItemId,data.configCode,data.viewCode);
        	                            			qyeryBuilderView=systemEventConfigurationPanel.down("#"+ruleEditorItemId);
        	                            		}
        	                            		
        	                            		systemEventConfigurationPanel.getForm().findField("msgRecipientTypeId").setValue(recepientTypeform.getValues()['recipientTypeId']);
        	                            		systemEventConfigurationPanel.getForm().findField("msgTemplateConfigId").setValue(recepientTypeform.getValues()['msgTemplateConfigId']);
            	                            	systemEventConfigurationPanel.getForm().findField("dataProviderId").setValue(providerValue);        	                            	
            	                            	systemEventConfigurationPanel.getForm().findField("searchConfigCode").setValue(data.configCode);
            	                            	systemEventConfigurationPanel.getForm().findField("searchResultViewCode").setValue(data.viewCode);
        	                                	                                	                            	        	                            	        	                            	
            	                            	me.setDefaultSearchCriteriaInCached(systemEventConfigurationPanel,data.cbSearchCriteria,qyeryBuilderView);
        	                            	}                       	
        	                            }
    	                			}    	                			
    	                		}    
    	        			});    				    				
    	    			}
    				}else{
    					
						if(!isEmpty(cachedRecipientObject.advancedSearchDTO)){
                    		
							var qyeryBuilderView=systemEventConfigurationPanel.down("#"+ruleEditorItemId);
                    		if(!qyeryBuilderView){
                    			systemEventConfigurationPanel=me.addDistributionRuleQueryBuilderViewPanel(systemEventConfigurationPanel,ruleEditorItemId,cachedRecipientObject.searchConfigCode,cachedRecipientObject.searchResultViewCode);
                    			qyeryBuilderView=systemEventConfigurationPanel.down("#"+ruleEditorItemId);
                    		}
                    		
                    		systemEventConfigurationPanel.getForm().findField("id").setValue(cachedRecipientObject.id);
                    		
                    		systemEventConfigurationPanel.getForm().findField("msgRecipientTypeId").setValue(recepientTypeform.getValues()['recipientTypeId']);
                    		systemEventConfigurationPanel.getForm().findField("msgTemplateConfigId").setValue(recepientTypeform.getValues()['msgTemplateConfigId']);
                        	systemEventConfigurationPanel.getForm().findField("dataProviderId").setValue(cachedRecipientObject.dataProviderId);
                        	systemEventConfigurationPanel.getForm().findField("savedRuleRefId").setValue(cachedRecipientObject.savedRuleRefId);                        	
                        	systemEventConfigurationPanel.getForm().findField("searchConfigCode").setValue(cachedRecipientObject.searchConfigCode);
                        	systemEventConfigurationPanel.getForm().findField("searchResultViewCode").setValue(cachedRecipientObject.searchResultViewCode);
                        	
                        	me.setDefaultSearchCriteriaInCached(systemEventConfigurationPanel,cachedRecipientObject.advancedSearchDTO.cbSearchCriteria,qyeryBuilderView);                        	
                    	}	
						
    				}

    			}
    			    			
    		}
    	
    },
    
    /**
     * This method is used to distribution rule/list advanced search panel
     * @param systemEventConfigurationPanel  - panel reference which contain advance search panel
     * @param ruleEditorItemId - rule Editor Item Id
     * @param configCode - config Code 
     * @param viewCode - view Code    
     * 
     */    
    addDistributionRuleQueryBuilderViewPanel:function(systemEventConfigurationPanel,ruleEditorItemId,configCode,viewCode){
    	
    	if(systemEventConfigurationPanel && !isNullOrEmpty(ruleEditorItemId) && !isNullOrEmpty(configCode) && !isNullOrEmpty(viewCode)){
    		
    		systemEventConfigurationPanel.add({
    			xtype: 'systemeventmessagingruleeditor',
        		itemId:ruleEditorItemId,		 
        		searchConfigCode :configCode,
        		searchResultViewCode:viewCode                            		
        	});
    		systemEventConfigurationPanel.doLayout();
    	}
    	
    	return systemEventConfigurationPanel;
    },
    
    /**
     * This method is used to load template grid according to search criteria
     * @param model 
     * @param records
     * @return request according to search criteria
     */
    loadTemplateGridAndSearchRequest: function(model, records) {
        var SearchForm = this.getSystemEventSearchForm();
        var jsonFormatFormData = this.createJsonFormat(SearchForm, records);
        var systemEventSearchResultGrid = this.getSystemEventSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.MESSAGE_SYSTEM_EVENT_LIST_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        systemEventSearchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        setTimeout(function(){
        	 Ext.getBody().unmask();                          			
		},1500);
       
    },
    
    /**
     * This method is used to create JSON format of form values
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createJsonFormat: function(SearchForm) {
    	var me=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();
        
        values.configCode = CONSTANTS.CB.MESSAGE_SYSTEM_EVENT_LIST_BASIC_CONFIGCODE;
        formValues = SearchForm.getValues();
                
       
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All'){
            	if(key==='ACADEMY_LOCATION_ID'){        		
            		var academyLocationIds=new Array();
        			Ext.each(value, function (academyLocationId) {
        				if(academyLocationId instanceof Object){ 
            				academyLocationIds.push(academyLocationId.data.id);	
    					}        				
        			});
        			var ACADEMY_LOCATION_IDS = this.getJsonObject('ACADEMY_LOCATION_ID', academyLocationIds,null,true);
        			me.pushJsonObjectInArray(ACADEMY_LOCATION_IDS,searchcriteria);
        		}else if(key==='CONFIG_LEVEL'){
        			if(value==='ORGANIZATION'){
        				value=1;
        			}else if(value==='ACADEMY_LOCATION'){
        				value=2;
        			}
        			var keyValueJsonObject = me.getJsonObject( key , value);
        	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        		}else{
        			var keyValueJsonObject = me.getJsonObject( key , value);
        	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        		}        		
            }
        }

        values.searchCriterias = searchcriteria;
        return values;
    },
    
    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue,extraParam) {
    	if(extraParam){
   		 if (value != '' && additionalValue == undefined) {
   	            return {
   	                "paramCode": key,
   	                "paramValues": value
   	            };
   	        }
   	}
   	else if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
    } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    
    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     *
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },

    /**
     * This method is used to clear fields on template search Form
     * @param button which is reference of button
     */
    clearSearchForm: function(button) {
        
        var form=button.up('form');        
        if(form){
        	var basicForm = form.getForm();
        	basicForm.getFields().each(function(field) {
                field.reset();
            });
        
        	var academyLocationCombo=form.down("#ACADEMY_LOCATION");     
            var configLevelIdCombo=form.down("#configLevelId");
            
            if(configLevelIdCombo && isNullOrEmpty(configLevelIdCombo.getValue())){
//        		academyLocationCombo.setVisible(false);
    			academyLocationCombo.setDisabled(true);
        	}
        }                    	
    },

    /**
     * This method is used to add tool-bar at search result grid
     */
    gridRenderFunction: function(grid) {
        grid.addDocked({
            xtype: 'toolbar',
            itemId: 'functionButtonsToolbar',
            dock: 'top',
            items: [{
                xtype: 'button',
                itemId: 'searchResultGridBtnAdd',
                tooltip: getCommonTranslation('ADD'),
                iconCls:'icon-addbutton',
				 cls:'addbutton'
            }, {
                xtype: 'button',
                itemId: 'searchResultGridBtnEdit',                
                tooltip: getCommonTranslation('EDIT'),
                iconCls:'icon-editbutton',
				cls:'editbutton'
            }, {
                xtype: 'button',
                itemId: 'searchResultGridBtnView',
                tooltip: getCommonTranslation('VIEW'),
                iconCls: 'icon-View',
				cls:'iconView'		
            },{
                xtype: 'button',
                itemId: 'searchResultGridBtnDelete',                
                cls: 'CustomToolbarBtnReject',
                tooltip: getCommonTranslation('DELETE'),
                iconCls: 'icon-Delete',
				cls:'iconDelete'
            },
            {				
            	/*xtype : 'splitbutton',
		        itemId:'spBtnMoreActions',
		        text : getCommonTranslation('MOREACTIONS'),
		        menu:[{
		            text:getExaminationTranslation('ENABLE'),
		            itemId:'enableDisableBtn'
		        }],
		        listeners: { click: function() { this.showMenu(); }}*/
            	
            	xtype: 'button',
                itemId: 'enableDisableBtn',                
                //cls: 'CustomToolbarBtnReject',
                text:getExaminationTranslation('ENABLE'),
                tooltip: getExaminationTranslation('ENABLE'),
                //glyph: ICONGLYPH.DELETEGLYPH
            },
            /*{
                xtype: 'button',
                itemId: 'enableDisableBtn',
                text:getMessagingModuleTranslation('ENABLE_DISABLE'),                
                tooltip: getMessagingModuleTranslation('ENABLE_DISABLE')
                //glyph: ICONGLYPH.DELETEGLYPH
            }*/,'->',{
		        xtype: 'splitbutton',
		        itemId: 'exportToPdfBtn',
		        cls: 'CustomToolbarBtnExport export-cls',
		        iconCls:'export-pdf-icon',
		        //text: 'Export To Pdf',      
		        menu: [{
		            text: 'Export Current Page',
		            itemId: 'exportCurrentPage'
		        }, {
		            text: 'Export All',
		            itemId: 'exportAll'
		        } ],
		        listeners: { click: function() { this.showMenu(); } }
		    },{
		        xtype: 'splitbutton',
		        itemId: 'exportToXcelBtn',
		        cls: 'CustomToolbarBtnExport export-cls',
		        iconCls:'export-excel-icon',
		        //text: 'Export To Xcel',      
		        menu: [{
		            text: 'Export Current Page',
		            itemId: 'exportCurrentPage'
		        }, {
		            text: 'Export All',
		            itemId: 'exportAll'
		        } ],
		        listeners: { click: function() { this.showMenu(); } }
		    }]
        });
    },
    
    /**
     * This method is used for to load dependent combo 
     * @param combo - combo reference     
     * @param records - selected combo record
     * @param params - param object to send parameter
     * @param comboItemId -dependent combo Item Id 
     */
    loadDependentComboData:function(combo,records,params,comboItemId,selectedRecordId){
    	var me=this;
    	var systemEventConfigMasterForm=combo.up('systemeventconfigmasterform');
    	var selectedSysEventConfigId=combo.getValue();
    	if(systemEventConfigMasterForm && !isNullOrEmpty(selectedSysEventConfigId)){
    		var dependentCombo=systemEventConfigMasterForm.down(comboItemId);
    		if(dependentCombo){    	    			
    			dependentCombo.reset();    			    			
    			dependentCombo.getStore().removeAll();
    			dependentCombo.getStore().load({
    					params:params
    				});
    			}
    		}    	
    },
    
    
    /**
     * This method is used to handle show and hide of academy location combo 
     * @param combo - combo reference after firing select event
     * @param records - selected record from combo    
     */
    showDependentCombo: function(combo,records) {
    	var serachForm=combo.up('form');
    	var selectedCode=combo.getValue();    	
    	if(serachForm && !isNullOrEmpty(selectedCode)){
    		var academyLocationCombo=serachForm.down("#ACADEMY_LOCATION");
    		if(academyLocationCombo){
    			if(selectedCode==='ACADEMY_LOCATION'){
//    				academyLocationCombo.setVisible(true);
    				academyLocationCombo.setDisabled(false);
        		}else if(selectedCode==='ORGANIZATION'){
//        			academyLocationCombo.setVisible(false);
    				academyLocationCombo.setDisabled(true);
        		}else{
//        			academyLocationCombo.setVisible(false);
    				academyLocationCombo.setDisabled(true);
        		}
    		}    		
    	}
    },
    
    /**
     * This method is used to open New System Event Configuration Tab 
     * @param button - button reference after firing click event    
     */
    openNewSystemEventConfigurationTab:function(button){
    	this.openTab(getMessagingModuleTranslation('ADD_SYSTEM_MESSAGE_EVENT'), 'systemeventconfigmasterform',CONSTANTS.MENU_COLOR_THIRTEEN);
    },
    

    /**
     * This method is used to open Template Tab 
     * @param button -  button reference after firing click event
     * @param grid -  grid reference    
     */
    openSystemEventConfigurationTab:function(button,grid,View){
    	var me=this;
    	var record = grid.getSelectionModel().getSelection()[0];
    	var tabTitle = null;
    	if(View == 'VIEW'){
    		tabTitle = getMessagingModuleTranslation('VIEW_SYSTEM_MESSAGE_EVENT');
    	}else{
    		tabTitle = getMessagingModuleTranslation('EDIT_SYSTEM_MESSAGE_EVENT');
    	}
    	
        var ID = record.get("ID");
        
        if (!isNullOrEmpty(tabTitle) && !isNullOrEmpty(ID)) {
        	
        	var submitUrl=SERVERURL.SYSTEM_MESSAGE_EVENT_CONFIG_FIND_BY_ID;  //URL-:rest/msgTemplateConfigResource/findById
        	submitUrl=submitUrl.concat("?id="+ID);
        	
        	me.sendGetAjaxRequest(submitUrl, 'GET', null, function(option, success, response) {
        		if(success){	
        			var data = Ext.decode(response.responseText);
                    if(!isEmpty(data)){
                    	var systemMessageConfigTab=me.getTabReferenceByTabTitle(tabTitle);                    
                        if (systemMessageConfigTab) {
                        	me.closeTab(systemMessageConfigTab);
                        }                    	
                        systemMessageConfigTab=me.openTab(tabTitle, 'systemeventconfigmasterform',CONSTANTS.MENU_COLOR_THIRTEEN);
                    	if(systemMessageConfigTab){             
                    		                    		
                    		/* Set id and configuration data in master form */
                    		systemMessageConfigTab.down("#masterId").setValue(data.id);
                    		
                    		
                    		/* Set id and configuration data in master form */
                        	if(!isNullOrEmpty(data.whetherEnabled)){    		
                        		systemMessageConfigTab.down("#whetherEnabled").setValue(data.whetherEnabled);
                            }  
                    		
                    		
                    		/* Set basic information data in basic info form */                    		
                    		var systemEventConfigBasicInfoForm=systemMessageConfigTab.down("#systemEventConfigBasicInfoForm");
                    		
                    		if(systemEventConfigBasicInfoForm){
                    			
                    			if(!isNullOrEmpty(data.systemMsgEventId)){
                        			var systemMessageEventCombo=systemEventConfigBasicInfoForm.down('#systemMessageEventCombo');
                        			var templateCombo=systemEventConfigBasicInfoForm.down('#templateCombo');
                        			var messageScopeCombo=systemMessageConfigTab.down('#messageScopeCombo');
                        			var messageScopeSelector=systemMessageConfigTab.down('#messageScopeSelector');
                        			var academyLocationCombo=systemEventConfigBasicInfoForm.down('#academyLocationCombo');
                        			var uiDisplayCodeTxt=systemEventConfigBasicInfoForm.down('#uiDisplayCodeItemId');
                        			var systemEventConfigMessageScopesForm=messageScopeCombo.up('form');
                        			
                        			if(systemMessageEventCombo){
                        				systemMessageEventCombo.getStore().load({
                        					callback: function(records, operation, success) {
                            					if(records.length>0){
                            						
                            						var selectedSystemMessageEventRec=systemMessageEventCombo.getStore().getById(data.systemMsgEventId);                            						
                            						systemMessageEventCombo.setValue(data.systemMsgEventId);
                            						systemMessageEventCombo.setReadOnly(true);
                            						/* hide/show system event configuration screen panels */
                            						if(!isEmpty(selectedSystemMessageEventRec)){                            							
                                			     		me.setSystemEventConfigurationPanelVisibility(selectedSystemMessageEventRec.data,systemMessageEventCombo);                                			     		
                            						}
                            						
                            						/* hide/show academy location combo */
                            			     		me.hideShowAcademyLocationCombo(selectedSystemMessageEventRec.data,systemEventConfigBasicInfoForm);
                            						
                            			     		/* hide/show template combo */
                            			     		me.hideShowCommonTemplateCombo(selectedSystemMessageEventRec.data,systemEventConfigBasicInfoForm);
                            			     		
                            						if(templateCombo && !isNullOrEmpty(data.msgTemplateConfigId)){                            							                        						
                                						if(!isEmpty(selectedSystemMessageEventRec) && !isNullOrEmpty(selectedSystemMessageEventRec.data.msgCatagoryId)){
                                							templateCombo.getStore().load({
                                								params:{
                                									msgCatagoryId:selectedSystemMessageEventRec.data.msgCatagoryId,
                                									availableForAdhoc: false
                                								},                            								
                                            					callback: function(records, operation, success) {
                                                					if(records.length>0){
                                                						templateCombo.setValue(data.msgTemplateConfigId);
                                                					}
                                                				}
                                							});
                                						}                                						                                			     		                                			     		
                            						}
                            						
                            						if(academyLocationCombo && !isNullOrEmpty(data.msgConfigLevelValue)){                            							                        						
                                						if(!isEmpty(selectedSystemMessageEventRec) && (selectedSystemMessageEventRec.data.msgConfigLevel.code==="AL")){
                                							academyLocationCombo.getStore().load({                     								
                                            					callback: function(records, operation, success) {
                                                					if(records.length>0){
                                                						academyLocationCombo.setValue(data.msgConfigLevelValue);
                                                					}
                                                				}
                                							});
                                						}                                						                                			     		                                			     		
                            						}
                            						                            						                            						
                            						if(messageScopeCombo && data.msgEventScopes.length>0 && !isNullOrEmpty(data.msgEventScopes[0].msgScopeParamId)){
                            							systemMessageConfigTab.down("#msgEventScopes").setValue(Ext.encode(data.msgEventScopes));
                            							
                                						if(!isEmpty(selectedSystemMessageEventRec) && !isNullOrEmpty(selectedSystemMessageEventRec.data.id)){
                                							messageScopeCombo.getStore().load({
                                								params:{
                                									id:selectedSystemMessageEventRec.data.id
                                								},                            								
                                            					callback: function(records, operation, success) {
                                                					if(records.length>0){
                                                						messageScopeCombo.setValue(data.msgEventScopes[0].msgScopeParamId);
                                                						messageScopeSelector.getStore().removeAll();
                                                						
                                                						var messageScopeRecord=messageScopeCombo.getStore().getById(data.msgEventScopes[0].msgScopeParamId);
                                                						if(messageScopeRecord){
                                                							var messageScopeRawValue=messageScopeRecord.get('value');
                                                							if(!isNullOrEmpty(messageScopeRawValue)){          
                                                								var acadLocId=null;
                                                								
                                                								var systemMessageEventCombo=messageScopeCombo.up('systemeventconfigmessagescopes').up('systemeventconfigmasterform').down('#systemMessageEventCombo');
                                                						    	var record= systemMessageEventCombo.getStore().findRecord( 'id', systemMessageEventCombo.getValue());
                                                						    	if(!isEmpty(record) && record.data.msgConfigLevel.code!="Organization"){
                                                						        	var academyLocationCombo=messageScopeCombo.up('systemeventconfigmessagescopes').up('systemeventconfigmasterform').down('#academyLocationCombo');
                                                						        	if(academyLocationCombo.isValid( )){
                                                						        		acadLocId=academyLocationCombo.getValue();
                                                						        	}
                                                						    	}
                                                								me.loadMessageScopeSelectorStore(systemEventConfigMessageScopesForm,messageScopeRawValue,true,acadLocId);                                                        						
                                                							}
                                                						}
                                                						
                                                						
                                                					}
                                                				}
                                							});
                                						}                                							                            							
                            						}else{
                            							/*messageScopeCombo.getStore().extraParams = {
                    									id:selectedSystemMessageEventRec.data.id
                    								};
                        							messageScopeCombo.getStore().load();*/
                        							messageScopeCombo.getStore().load({
                        								params:{
                        									id:selectedSystemMessageEventRec.data.id
                        								}
                        							});
                            					}
                            						/* Set initiation schedule data in Initiation Schedule Configuration form */
                                            		var systemEventConfigInitiationSchedule=systemMessageConfigTab.down("#systemEventConfigInitiationSchedule");
                                            		if(systemEventConfigInitiationSchedule && !isEmpty(data.msgInitRuleConfig)){                                            			
                                            			systemEventConfigInitiationSchedule.getForm().setValues(data.msgInitRuleConfig);
                                            			if(!isEmpty(data.msgInitRuleConfig.dataProviderInstance)){
                                            				systemMessageConfigTab.down("#dataProviderInstance").setValue(Ext.encode(data.msgInitRuleConfig.dataProviderInstance)); 
                                            				
                                            				/* Add Initiation Rule Advanced Search Panel dynamically */
                                                     		if(selectedSystemMessageEventRec.data.whetherInitiationRuleApplicable){
                                                     			me.addInitiationRulePanel(messageScopeCombo,null,selectedSystemMessageEventRec.data,true,data.msgInitRuleConfig.dataProviderInstance);
                                                     		}
                                            			}                    			                    			
                                            		}
                                            		
                                            		
                                            		
                                                   //  Set Repetation schedule data in Repetation Schedule Configuration form 
                                            		
                                            		var systemEventConfigRepetationSchedule=systemMessageConfigTab.down("#systemEventConfigRepetationSchedule");
                                            		if(systemEventConfigRepetationSchedule && !isEmpty(data.msgRepetationRuleConfig)){                                            			
                                            			systemEventConfigRepetationSchedule.getForm().setValues(data.msgRepetationRuleConfig);
                                            		}
                                            		
                                             		/* Add recipient types dynamically */
                                             		if(!selectedSystemMessageEventRec.data.whetherImplicitDistributionList){
                                             			if(data.wsMsgEventRecipientConfigs.length>0){                                             				
                                             				systemMessageConfigTab.down("#wsMsgEventRecipientConfigs").setValue(Ext.encode(data.wsMsgEventRecipientConfigs));
                                             				me.addRecipientTypes(messageScopeCombo,null,selectedSystemMessageEventRec.data,true);
                                             			}                                             			                                             			
                                             		}else if(selectedSystemMessageEventRec.data.whetherImplicitDistributionList){
                                             			var systemeventconfigmasterform=messageScopeCombo.up('systemeventconfigmasterform');
                                             	    	if(systemeventconfigmasterform && data.wsMsgEventRecipientConfigs.length>0){
                                             	    		systemeventconfigmasterform.down("#isImplicitFlow").setValue(true);                                             	    		
                                             				systemMessageConfigTab.down("#wsMsgEventRecipientConfigs").setValue(Ext.encode(data.wsMsgEventRecipientConfigs));
                                             				me.addRecipientTypes(messageScopeCombo,null,selectedSystemMessageEventRec.data,true);                                             	    		
                                             	    	}     			
                                             		}
                                             		     		
                            					}    						
                            		         }		
                        				});                    				
                        			}                    			
                        		}                    
                    			
                    			systemEventConfigBasicInfoForm.getForm().setValues(data);
                    			if(View == 'VIEW'){
                    				systemMessageConfigTab.down('#btnSaveSysEveConfigForm').setVisible(false);
                    				systemMessageConfigTab.down('#resetButtonId').setVisible(false)
                    				var messageScopeSaveBtn=systemMessageConfigTab.down('#btnSaveMessageScopeForm');
                        			academyLocationCombo.setReadOnly(true);
                        			templateCombo.setReadOnly(true);
                        			uiDisplayCodeTxt.setReadOnly(true);
                        			messageScopeSaveBtn.setVisible(false);
                        			setTimeout(function(){
                            			var tempComb2 = Ext.ComponentQuery.query('#templateCombo')[1];
                            			tempComb2.setReadOnly(true);
                            			var systemEventConfigInitiationSchedule=systemMessageConfigTab.down("#systemEventConfigInitiationSchedule");
                            			if(systemEventConfigInitiationSchedule != undefined){
                            				systemEventConfigInitiationSchedule.down('#initScheduleCronDef').setReadOnly(true);
                            			}                            			
                        			},500);
                        			
                    			}else{
                    				systemMessageConfigTab.down('#btnSaveSysEveConfigForm').setVisible(true);
                    				systemMessageConfigTab.down('#resetButtonId').setVisible(true)	
                    			}
                    			
                    			
                    		}
                    	}                    	
                    }
        		}
        		
            });        	
        }        
    },
    
    /**
     * This method is used to set visibility of system event config panel 
     * @param eventData -  object which contains all the parameters
     * @param  combo - combo reference      
     */
    setSystemEventConfigurationPanelVisibility:function(eventData,combo){
    	var me=this;
    	var systemeventconfigmasterform=combo.up('systemeventconfigmasterform');
//    	systemeventconfigmasterform.down('#resetButtonId').setVisible(false);
    	if(systemeventconfigmasterform){
    		var systemEventConfigMessageScopes=systemeventconfigmasterform.down('#systemEventConfigMessageScopes');
    		var systemEventConfigInitiationSchedule=systemeventconfigmasterform.down('#systemEventConfigInitiationSchedule');
    		var systemEventConfigRepetationSchedule=systemeventconfigmasterform.down('#systemEventConfigRepetationSchedule');
    		var systemEventConfigInitiationRule=systemeventconfigmasterform.down('#systemEventConfigInitiationRule');
    		var systemEventConfigDistributionListEntity=systemeventconfigmasterform.down('#systemEventConfigDistributionListEntity');
    		    		
    		me.setVisibility(systemEventConfigMessageScopes,eventData.whetherMsgScopeApplicable);
    		me.setVisibility(systemEventConfigInitiationSchedule,eventData.whetherScheduledEvent);
    		me.setVisibility(systemEventConfigRepetationSchedule,eventData.whetherRepetationApplicable);
    		me.setVisibility(systemEventConfigInitiationRule,eventData.whetherInitiationRuleApplicable);
    		me.setVisibility(systemEventConfigDistributionListEntity,!eventData.whetherImplicitDistributionList);
    	}    	 
    },
    
    
    /**
     * This method is used to set visibility of system event config panel 
     * @param panel -  panel reference for to show or hide
     * @param  whetherVisible - hide or show panel depends on this value     
     */
    setVisibility:function(panel,whetherVisible){
    	if(panel){
			if(whetherVisible || panel.itemId==="systemEventConfigDistributionListEntity"){
    			panel.setVisible(true);
    			panel.expand();
    		}else{
    			panel.setVisible(false);
    			panel.collapse();
    		}
		}
    },
            
    /**
     * This method is used for to delete system message configuration  
     * @param button - button reference   
     */
    deleteSystemMessageConfiguration: function(button) {    	
    	var grid =button.up('grid');
    	if(grid){
    		var grdStore = grid.getStore();
    		if (grid.getSelectionModel().getCount() > 0) {        	
            	showConfirmMessage(getMessagingModuleTranslation('DELETE_SYSTEM_MESSAGE_CONFIG'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                    if (btn == 'yes') {
                    	 if (grid.getSelectionModel().getCount() > 0) {
                             var records = grid.getSelectionModel().getSelection();
                             for (var count = 0; count < records.length; count++) {
                                 var id = ""; 
                                 var submitURL="";
                                 if (!isNullOrEmpty(records[count].get("ID"))) {
                                     id = records[count].get("ID");
                                 }
                                 if(isNullOrEmpty(submitURL) && !isNullOrEmpty(id)){
                                	 submitURL=SERVERURL.SYSTEM_MESSAGE_EVENT_CONFIG_DELETE;  //URL-rest/systemMsgEventConfigResource/delete
                                	 submitURL=submitURL.concat("?id="+id);
                                 }
                                 Ext.Ajax.request({
                                     type: 'rest',                                     
                                     url: submitURL, 													 
                                     method: 'DELETE',                                     
                                     success: function(form, action) {
                                    	 if(form.responseText=="EXCEPTION"){
                                    		 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DEPENDENCY_EXIST_MSG')); 
                                    	 }else{
                                    		 showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('DELETE_SYSTEM_MESSAGE_CONFIG_MSG')); //System message configuration deleted successfully
                                    	 }
                                    	 grdStore.reload();                                         
                                     }
                                 });
                             }
                         }
                    }
                });        	
            } else {
            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
            }
    	}                        
    },
    
    /**
     * This method is used for to enable or disable system message event    
     * @param button - button reference
     *    
     */
    enableDisableMessageEvent:function(button){
    	var grid = button.up('grid');
    	var status="";
    	if(grid){    		
    		if(grid.getSelectionModel().getCount() > 0) {    			
                var record = grid.getSelectionModel().getSelection()[0];
                if(!isEmpty(record.data)){                	
                    var selectedId=record.get("ID");
                    var selectedStatus=record.get("WHETHER_ENABLED");
                    if (!isNullOrEmpty(selectedId) &&  !isNullOrEmpty(record.get("WHETHER_ENABLED"))){
                        if(selectedStatus == getMessagingModuleTranslation('YES')){
                        	selectedStatus=false;                        	
                        }else{
                        	selectedStatus=true;
                        }
                        
                        Ext.Ajax.request({
                            type: 'rest',                                     
                            url: SERVERURL.SYSTEM_MESSAGE_EVENT_CONFIG_CHANGE_STATUS, //URL - :'rest/systemMsgEventConfigResource/changeStatus', 													 
                            method: 'PUT',         
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            params:{
                            	id:selectedId,
                            	status:selectedStatus
                            },
                            success: function(form, action) {
                            	grid.getStore().reload();
                            	if(selectedStatus){
                            		showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('ENABLED_MESSAGE')); //System message enabled successfully                        	
                                }else{
                                	showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('DISABLED_MESSAGE')); //System message disabled successfully
                                }                                
                            }
                        });
                    }                	
                    
                }    			 
    		} else {
            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
            }    		
    	}    	
    },
    
    /*
     * This function is used for to change button text on selection of grid record
     *     
     */
    setEnableDisableButtonText: function(rowModel, record, index, eOpts) {
    	var me=this;
    	var systemEventPanel=me.getTabReferenceByTabTitle();   
    	if(rowModel){
    		var enableDisableBtn=systemEventPanel.down('#enableDisableBtn');
    		if(!isEmpty(record.data)) {
                if(record.get('WHETHER_ENABLED') == getMessagingModuleTranslation('YES')){
                	enableDisableBtn.setText(getMessagingModuleTranslation('DISABLE'));
                	enableDisableBtn.setTooltip(getMessagingModuleTranslation('DISABLE'));
                }else{
                	enableDisableBtn.setText(getMessagingModuleTranslation('ENABLE'));
                	enableDisableBtn.setTooltip(getMessagingModuleTranslation('ENABLE'));
                }
            }
    	}        
    },
    //******************************Export ******************************************************
	    exportUserList : function(exportUrl,filetype,whetherAll) {
	        var quickSearchForm=this.getSystemEventSearchForm(); 
	        var searchResultGrid = this.getSystemEventSearchResultGrid();
	        var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	        var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	        var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	        var visibleColumns=this.getVisibleColumns(searchResultGrid);
	        var reportTitle=getCommonTranslation('SYSTEM_MESSAGE_EVENT_LIST');
	if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
	                      jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	               }
	searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	
	},
	 exportEventReportList : function(exportUrl,filetype,whetherAll) {
	        var quickSearchForm=this.getSystemMessageEventReportSearchForm(); 
	        var searchResultGrid = this.getSystemMsgEventReportSearchResultGrid();
	        var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	        var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	        var jsonFormatFormData=this.createSearchResultReportJsonFormat(quickSearchForm);
	        var visibleColumns=this.getVisibleColumns(searchResultGrid);
	        var reportTitle=getCommonTranslation('SYSTEM_MESSAGE_EVENT_LIST');
	if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
	                      jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	               }
	searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	
	},

	createSearchCriteriaString: function(searchForm) {
		  	var me=this;
		        var formValues = new Array();
		        formValues = searchForm.getValues();        
		        var searchCriteriaString="";
		        for (var key in formValues) {
		        	var value = formValues[key]; 
		        	var i=0;
		            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
		            	var keyValueJsonObject = me.getJsonObject( key , value);
		            	if(keyValueJsonObject.paramCode != "DELIVERY_MODE"){
		            	    searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
		            	}else{
							for(i in value){
								if(keyValueJsonObject.paramCode == "DELIVERY_MODE" && value[i] == 1){
									searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+getMessagingModuleTranslation('EMAIL') + " ,";
								}else if(keyValueJsonObject.paramCode == "DELIVERY_MODE" && value[i] == 2){
									searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+getMessagingModuleTranslation('SMS') + " ,";
								}else if(keyValueJsonObject.paramCode == "DELIVERY_MODE" && value[i] == 3){
									searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+getMessagingModuleTranslation('LETTER') + " ,";
								}else if(keyValueJsonObject.paramCode == "DELIVERY_MODE" && value[i] == 4){
									searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+getMessagingModuleTranslation('SYS_INTERNAL_MSG')+ " ,";
								}else if(keyValueJsonObject.paramCode == "DELIVERY_MODE" && value[i] == 5){
									searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+getMessagingModuleTranslation('WEB_LINK')+ " ,";
								}	            	    
							}
		            	}
		            }
		        }
		        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
		        return searchCriteriaString;
		},
    //******************Disable reset password button**********************************
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	buttonsToolBar = gridReference.query('toolbar')[0];
    	var moreActionButton = gridReference.down('#spBtnMoreActions');
    	moreActionButton.setVisible(false);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'MOREACTIONS') {
        		var button = buttonsToolBar.query('#spBtnMoreActions')[0];
        		if(!isNullOrEmpty(button)){
        			moreActionButton.setVisible(true);
        		}        		
        	}
    	});
    },
    
});
