/*
  * This controller is used for Academy-Locations Tab(Academy Location Links)   
 */
Ext.define('Academia.controller.organization.academylocations.AcademyLocationController', {
    extend: 'Academia.controller.base.BaseController',
    models: ['common.IdValueDataModel', 'organization.academylocations.AcademyLocationLinkModel'],
    stores: ['organization.academylocations.AcademyLocationLinksStore', 'organization.academylocations.LocationStore', 
             'organization.academylocations.AcademyStore', 'organization.academylocations.AcademyLocationPurposeStore', 'common.CountryStore',
             'organization.academylocations.AcademySmartSearchStore','organization.academylocations.LocationSmartSearchStore',
             'organization.academylocations.OwnershipStore','common.TerminologyStore','common.DirectionStore','common.LatitudeDirectionStore','common.LongitudeDirectionStore',
             'organization.academylocations.ListOfCampusStore','organization.academylocations.VenueUkprnStore'],

    views: ['organization.academylocations.AcademyLocation', 'organization.academylocations.AcademyLocationLinkGrid', 
            'organization.academylocations.AcademyLocationFormWindow', 'organization.academylocations.AddLogoWindow',
            'personinfo.common.personalinfo.PhotoUploadForm', 'baselayout.header.Logo', 'baselayout.header.DefaultLogo',
            'organization.academylocations.AcademyLocationPurposeGrid','organization.academylocations.AcademyLocationAddOtherInfoWin','document.SimpleDocumentForm'],

    alias: "widget.academylocationcontroller",

    refs: [{
        ref: 'academylocation',
        selector: 'academylocation'
    },{
        ref: 'grdAcademyLocationLink',
        selector: 'academylocationlinkgrid'
    },{
        ref: 'grdacademylocationpurpose',
        selector: 'academylocationpurposegrid'
    }, {
        ref: 'winAcademyLocationFormWindow',
        selector: 'academylocationformwindow'
    }, {
        ref: 'academyLocationLinkForm',
        selector: 'academylocationformwindow form[itemId=academyLocationForm]'
    },{
    	ref: 'logoSection',
    	selector: 'logosection'
    }],
    config: {
    	ORGANIZATION_STRUCTURE_ACADMY_LOCATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ORGANIZATION_STRUCTURE_ACADMY_LOCATION_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            'academylocationlinkgrid button[itemId=btnAdd]': {
                click: this.addAcademyLocation
            },
            'academylocationlinkgrid button[itemId=btnEdit]': {
                click: Ext.bind(this.editAcademyLocation, this, [false])
            },
            'academylocationlinkgrid button[itemId=btnView]': {
                click: Ext.bind(this.editAcademyLocation, this, [true])
            },
            'academylocationlinkgrid button[itemId=btnDelete]': {
                click: this.deleteAcademyLocation
            },
            'academylocationlinkgrid button[itemId=uploadLogo]': {
                click: function(button) {
                	var grid = this.getGrdAcademyLocationLink();
                	if (grid.getSelectionModel().getCount() > 0 && button.itemId === "uploadLogo") {
                			this.showLogoWindow(button);
	        		} else {
						showWarningMessage(getCommonTranslation('ACADLOCTT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					} 
                } 
            },
            'academylocation': {
                activate: function() {
                    var grid = this.getGrdAcademyLocationLink();
                    grid.getStore().load();
                    grid.getSelectionModel().deselectAll();
                  //  this.getGrdacademylocationpurpose().getStore().removeAll();
                    this.resetGridSetting(this.getGrdacademylocationpurpose());
                    var store = this.getGrdacademylocationpurpose().getStore();
                    if(!isNullOrEmpty(store.getProxy().extraParams.id)){
                    	delete store.getProxy().extraParams.id;
                    }
                    store.load();
                }
            },
            'academylocationlinkgrid': {
                select: this.selectAcademyLocationGridRecord,

                /**** Load store when render grid *****/
               /* render: function(component, options) {
                    component.getStore().load();
                }*/
            },
            'academylocationlinkgrid[itemId=academyLocationLinkGrid]': {
            	render: function(grid) {
                    //this.doAccessControlValidation(grid, this.getORGANIZATION_STRUCTURE_ACADMY_LOCATION_PERMISSIONS());
            		this.hideShowAddOtherInformationBtn(grid, this.getORGANIZATION_STRUCTURE_ACADMY_LOCATION_PERMISSIONS());
                }
            },
            'academylocationformwindow button[itemId=btnSaveAcademyLocationForm]': {
                click: this.saveAcademyLocationForm
            },
            'academylocationformwindow button[itemId=btnCancelAcademyLocationForm]': {
                click: this.cancelAcademyLocationForm
            },

            /**** Load store when render combos on dialog box*****/
            'academylocationformwindow combo': {
                render: function(component, options) {
                    component.getStore().load();
                    var $this=this;
                	var form = component.up('form').getForm();
                	var ownershipField = form.findField('ownership');
                	ownershipField.allowBlank=true;
                }
            },
            
            'academylocationformwindow customcombobox[itemId=academy_name]': {
                select: function(obj, record) {
                	var $this=this;
                	var form = obj.up('form').getForm();
                	var ownershipField = form.findField('ownership');
                	if(record[0].data.code=="RECRUITING_ORGANIZATION") {
                		ownershipField.setVisible(true);
                		ownershipField.reset();
                		ownershipField.allowBlank=false;
                	} else {
                		ownershipField.setVisible(false);
                		ownershipField.reset();
                		ownershipField.allowBlank=true;
                	}
                }
            },
            
            'addlogowindow button#btnSaveLogo': {
            	click: function(btn) {
            		this.saveLogo(btn);
            	}
            },
            'addlogowindow photouploadform[itemId=logoUploadField] filefield[itemId=photoFileImage]':{
            	change: function(photoFileImage, value, eOpts) {
            		//this.loadImageInField();
            		value = value.replace('C:\\fakepath\\', '');
            		var newValue = value.replace(/ +/g, " ").split(' ').join('_');
            		photoFileImage.setRawValue(newValue);
            	}
            },
            'academylocationlinkgrid button[itemId=addOtherInfo]': {
                click: function(button) {
                	var grid = this.getGrdAcademyLocationLink();
                	if (grid.getSelectionModel().getCount() > 0 && button.itemId === "addOtherInfo") {
                			this.showAddOtherInfoWin(button);
	        		} else {
						showWarningMessage(getCommonTranslation('ACADLOCTT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					} 
                } 
            },
            'academylocationaddotherinfowin filefield[itemId=imageUploadField]':{
            	change: function(photoFileImage, value, eOpts) {
            		value = value.replace('C:\\fakepath\\', '');
            		var newValue = value.replace(/ +/g, " ").split(' ').join('_');
            		photoFileImage.setRawValue(newValue);
            		
            		var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
            		if(!isNullOrEmpty(value)){
            			if (extension == "gif" || extension == "png" || extension == "bmp"
            				|| extension == "jpeg" || extension == "jpg") {
            				
            			}else{
                			photoFileImage.reset();
                			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
            			}
            		}

            	}
            },
            'academylocationaddotherinfowin button#btnSaveALCatalogue': {
            	click: function(btn) {
            		this.saveALCatalogueDetails(btn);
            	}
            }

        });
        this.getStore('organization.academylocations.AcademyLocationPurposeStore').on('beforeload', function(store, operation, eOpts) {
            var grid = this.getGrdAcademyLocationLink();
            if (grid.getSelectionModel().getCount() > 0) {
                var records = grid.getSelectionModel().getSelection();
                if (records != "" && records != null && records != undefined) {
                    store.getProxy().extraParams = {
                        id: records[0].get('id')
                    };
                }
            }
        }, this);
    },

    /*
     * This function is used for to show Academy Location Details Dialog box after clicking on Add button   
     */
    addAcademyLocation: function() {
        this.getGrdAcademyLocationLink().showAcademyLocationForm();
    },

    /*
     * This function is used for to show Academy Location Details Dialog box with values after clicking on edit button   
     */
    editAcademyLocation: function(isView) {
        var me = this;
        var grid = this.getGrdAcademyLocationLink();
        if (grid.getSelectionModel().getCount() > 0) {
            this.getGrdAcademyLocationLink().showAcademyLocationForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var academyLocationLinkForm = this.getAcademyLocationLinkForm();
                academyLocationLinkForm.loadRecord(records[0]);
                academyLocationLinkForm.down('#academy_name').setValue(records[0].data.academy.id);
                academyLocationLinkForm.down('#terminology').setValue(records[0].data.terminology);
                if(!isNullOrEmpty(records[0].data.ownership)) {
                	academyLocationLinkForm.down('#ownership').setVisible(true);
                	academyLocationLinkForm.down('#ownership').allowBlank=false;
                    academyLocationLinkForm.down('#ownership').setValue(records[0].data.ownership);
                }else {
                	academyLocationLinkForm.down('#ownership').setVisible(false);
                	academyLocationLinkForm.down('#ownership').allowBlank=true;
                }
                academyLocationLinkForm.down('#academy_location').setValue(records[0].data.location.id);
             
                var campusArray = [];
                var campusdata=records[0].data.academyLocationCampus;
                if(!isNullOrEmpty(campusdata)) {
                    for(var i in campusdata){
                    	campusArray.push(campusdata[i].campus.id);
                    }
                }
                
                academyLocationLinkForm.down('#campus').getStore().load({
                    callback:function(records){
                        
                    	 academyLocationLinkForm.down('#campus').setValue(campusArray); 
                            
                        }
                    
                });
                
                var sysSettings = this.setAcademyLocationSystemSettings(records[0].data.academyLocationSettings);
                if (sysSettings.length > 0) {
                    academyLocationLinkForm.down('#txtImportLoc').setValue(sysSettings.get(1)); //1="Import File Location"
                    academyLocationLinkForm.down('#txtExportLoc').setValue(sysSettings.get(2)); //2="Export File Location"
                    //academyLocationLinkForm.down('#cmbDefCountry').setRawValue(sysSettings.get(3)); //3="COUNTRY"
                    
                    
                    if (!isNullOrEmpty(sysSettings.get(10))) {
                    	academyLocationLinkForm.down('#cmbDefCountry').getStore().load({
                            callback: function(records, operation, success) {
                            	academyLocationLinkForm.down('#cmbDefCountry').setValue(parseInt(sysSettings.get(10))); //3="COUNTRY"
                            }
                        });
                    }
                    academyLocationLinkForm.down('#chkEmailBox').setValue(sysSettings.get(4)); //4='Data Change Notification Via Email'
                    academyLocationLinkForm.down('#chkSMSBox').setValue(sysSettings.get(8)); //8='Data Change Notification Via SMS'
                    academyLocationLinkForm.down('#chkThumbnailBox').setValue(sysSettings.get(9)); //9='Show Thumbnail Image'
                    var currency=  academyLocationLinkForm.down('#currency');
                    if(null!=records[0].raw.currency){
                    currency.setValue(records[0].raw.currency.id);
                    currency.setReadOnly(true);
                    }
                    var whetherPublicCatalogueId=  academyLocationLinkForm.down('#whetherPublicCatalogueId');
                    whetherPublicCatalogueId.setValue(records[0].raw.whetherPublishInCatalogue);
                    
                    var modeOfDelivery =  academyLocationLinkForm.down('#modeOfDeliveryId');
                    modeOfDelivery.setValue(records[0].raw.whetherModeOfDelivery);
                }
                if (isView) {
                    var winAcademyLocationFormWindow = me.getWinAcademyLocationFormWindow();
                    winAcademyLocationFormWindow.down('#btnSaveAcademyLocationForm').setVisible(false);
                    toggleReadOnlyFormItems(academyLocationLinkForm.getForm(), true);
                }
            }
        } else {
            showWarningMessage(getCommonTranslation('ACADLOCTT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*
     * This function is used for to delete academy location after clicking on delete button   
     */
    deleteAcademyLocation: function() {
        var this$ = this;
        var grid = this.getGrdAcademyLocationLink();
        var grdStore = grid.getStore();
        if (grid.getSelectionModel().getCount() > 0) {
        	showConfirmMessage(getCommonTranslation('ACADLOCTT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                        if (grid.getSelectionModel().getCount() > 0) {
                            var records = grid.getSelectionModel().getSelection();
                            for (var count = 0; count < records.length; count++) {
                                var id = "";
                                if (records[count].get("id") != "" && records[count].get("id") != undefined && records[count].get("id") != null) {
                                    id = records[count].get("id");
                                }
                                Ext.Ajax.request({
                                    type: 'rest',
                                    url: SERVERURL.ACADEMY_LOCATION_DELETE, //URL-rest/academyLocation/delete													 
                                    method: 'DELETE',
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    params: {
                                        id: id
                                    },
                                    success: function(form, action) {
                                        grdStore.reload();
                                        //Relode AcademyLocationPurpose grid
                                        var ALPC = this$.getController('Academia.controller.organization.academylocations.AcademyLocationPurposeController');
                                        ALPC.getGrdAcademyLocationPurpose().getStore().reload();
                                        showSuccessMessage(getCommonTranslation('ACADLOCTT'), getCommonTranslation('DELETE_ACADEMY_LOCATION_MSGS')); //Academy Location deleted successfully.
                                    }
                                });
                            }
                        }
                    }
            });
        } else {
        	showWarningMessage(getCommonTranslation('ACADLOCTT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    /*
     * This function is used for to save academy location Details after clicking on save button    
     */
    saveAcademyLocationForm: function(model, records) {
    	var this$ = this;
        var winAcademyLocationFormWindow = this.getWinAcademyLocationFormWindow();
        var grid = this.getGrdAcademyLocationLink();
        var grdStore = grid.getStore();
        var academyLocationLinkForm = this.getAcademyLocationLinkForm();
        var submitUrl, isUpdate = false;
        var academyHiddenField = academyLocationLinkForm.down('#academy_hidden_field');
        if (academyHiddenField.getSubmitValue() == null || academyHiddenField.getSubmitValue() == "" || academyHiddenField.getSubmitValue() === undefined) {
            submitUrl = SERVERURL.ACADEMY_LOCATION_CREATE; //URL-rest/academyLocation/create
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.ACADEMY_LOCATION_UPDATE; //URL-rest/academyLocation/update				    			
            isUpdate = true;
        }
        var jsonFormatFormData = this.createJsonFormat(grid,academyLocationLinkForm, records, isUpdate);
        this$.applyWindowMask(); 
      
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(form, action) {
            	  this$.hideWindowMask();
                winAcademyLocationFormWindow.close();
                grid.getSelectionModel().deselectAll();
                grdStore.reload();
                if (isUpdate) {
                	showSuccessMessage(getCommonTranslation('ACADLOCTT'), getCommonTranslation('UPDATE_ACADEMY_LOCATION_MSG')); //Academy location updated successfully.											
                } else {
                	showSuccessMessage(getCommonTranslation('ACADLOCTT'), getCommonTranslation('ADD_ACADEMY_LOCATION_MSG')); //Academy location added successfully.										
                }
                this$.getDefaultCountryCode();
            },
            failure: function(form, action) {
            	  this$.hideWindowMask();
                winAcademyLocationFormWindow.close();
              grdStore.reload();
            }
        });
    },

    /*
     * This function is used for to close Academy Location Details Dialog box after clicking on cancel button   
     */
    cancelAcademyLocationForm: function() {
        this.getWinAcademyLocationFormWindow().close();
    },

    /*
     * This function is used for to create JSON FORMAT for saving academy location details    
     */
    createJsonFormat: function(grid,academyLocationLinkForm, record, isUpdate) {
        var academyNameCombo = academyLocationLinkForm.down('#academy_name');
        var ownershipCombo = academyLocationLinkForm.down('#ownership');
        var academyLocationCombo = academyLocationLinkForm.down('#academy_location');
        var versionIdField = academyLocationLinkForm.down('#versionId_hidden_field');
        var mobileEnableField = academyLocationLinkForm.down('#mobileEnable');
        var terminologyField = academyLocationLinkForm.down('#terminology');
        var currency = academyLocationLinkForm.down('#currency');
        var values = new Object();
        if (isUpdate && academyLocationLinkForm.getValues().id != "" && academyLocationLinkForm.getValues().id != null) {
            values.id = academyLocationLinkForm.getValues().id;
        }
        values.academy = {
            id: academyNameCombo.getValue()
        };
        values.location = {
            id: academyLocationCombo.getValue()
        };
        values.currency = {
                id: currency.getValue()
            };
        var date = new Date();
        date = Ext.Date.format(date, 'Y-m-d');
        values.currentTransactionDate = date;
        values.academyLocationSettings = this.getAcadSysSettinJsonObject(isUpdate);
        values.displayName = academyLocationLinkForm.down('textfield#academyLocationDisplayName').getValue();
        values.version = versionIdField.getValue();
        values.ownership = ownershipCombo.getValue();
        values.mobileEnable = mobileEnableField.getValue();
        values.terminology = terminologyField.getValue();
        values.latdegree = academyLocationLinkForm.down('textfield#latdegree').getValue();
        values.latminute = academyLocationLinkForm.down('textfield#latminute').getValue();
        values.latseconds = academyLocationLinkForm.down('textfield#latseconds').getValue();
        values.latdirections = academyLocationLinkForm.down('textfield#latdirections').getValue();
        values.longdegree = academyLocationLinkForm.down('textfield#longdegree').getValue();
        values.longminute = academyLocationLinkForm.down('textfield#longminute').getValue();
        values.longseconds = academyLocationLinkForm.down('textfield#longseconds').getValue();
        values.longdirections = academyLocationLinkForm.down('textfield#longdirections').getValue();
        values.displayNameOL = academyLocationLinkForm.down('textfield#displayNameOL').getValue();
        values.whetherPublishInCatalogue = academyLocationLinkForm.down('#whetherPublicCatalogueId').getValue();
        values.whetherModeOfDelivery = academyLocationLinkForm.down('#modeOfDeliveryId').getValue();
        
        var campusArray=[];
        var campusIdsArray=[];
        var ALCampusId;
        var campusId=academyLocationLinkForm.down('#campus').getValue();
		var campusIds = null;
		var academyLocationCampus=new Array();
		 var selctedRecord = grid.getSelectionModel().getSelection();
		 if(grid.getSelectionModel().getCount() > 0){
			  ALCampusId = selctedRecord[0].data.academyLocationCampus;
		 }
		 var files;
		if(isUpdate){
			Ext.each(ALCampusId,function (campusData){
				campusIdsArray.push(campusData.id);
			});
			if(campusId!=undefined && campusId.length>0 && campusId[0]!=""){
				for (var i=0; i<campusId.length; i++) {
					if(typeof campusId[i] == 'object'){
						if(campusIdsArray[i]!=undefined){
							var id;
						    for(var k in ALCampusId){
						    	if(ALCampusId[k].campus.id == campusId[i].data.id){
						    		id = ALCampusId[k].id;
						    		break;
						    	}
						    }
							files={
									"id": id,
									"campus":{'id':(campusId[i]!=undefined)?((campusId[i].data!=undefined)?campusId[i].data.id:campusId[i]):campusId[i]},
							}	
						}else{
							files={
									"campus":{'id':(campusId[i]!=undefined)?campusId[i].data.id:campusId[i]},
							}	 
						}
						academyLocationCampus.push(files)
					}else{
						if(campusIdsArray[i]!=undefined){
							var id;
						    for(var k in ALCampusId){
						    	if(ALCampusId[k].campus.id == campusId[i]){
						    		id = ALCampusId[k].id;
						    		break;
						    	}
						    }
							files={
									"id": id,
									"campus":{
										 'id':(campusId[i]!=undefined)?campusId[i]:campusId[i]
									},
							}	
						}else{
							files={
									"campus":{'id':(campusId[i]!=undefined)?campusId[i]:campusId[i]},
							}	 
						}
						academyLocationCampus.push(files)
					}
				}
			}
			 
		}else{
			if(campusId!=undefined && !isNullOrEmpty(campusId[0])){
				Ext.each(campusId,function (campusData){
					var campus=new Object();
		            var campusObj=new Object();
		            if(campusData.data!=undefined){
		            	campus.id=campusData.data.id;
		            }
		            else
		            	{
		            	if(!isNullOrEmpty(campusData)){
		            		campus.id=campusData;	
		            	} 
		            	}
		            campusObj.campus=campus;
		            
		            if(!isNullOrEmpty(campus)){
		        		academyLocationCampus.push(campusObj);
		        	} 
		            
		        });
			}
		}
		values.academyLocationCampus=academyLocationCampus;
        var formData = Ext.encode(values);
        return formData;
    },

    /*
     * This function is used for to reload purpose grid after selecting record from academic location grid    
     */
    selectAcademyLocationGridRecord: function(obj, record, index, eOpts) {
        if (record != "" && record != null && record != undefined) {
            this.getStore('organization.academylocations.AcademyLocationPurposeStore').load({
                id: record.data.id
            });
        }
    },

    /*
     * This function is used for to create HashMap for to set academic location system settings     
     */
    setAcademyLocationSystemSettings: function(systemSettings) {
        var acadLocationSystemSetting = new Ext.util.HashMap();

        var fixedSystemSettings = new Array();
        fixedSystemSettings.push({
            id: 1,
            value: 'Import File Location'
        });
        fixedSystemSettings.push({
            id: 2,
            value: 'Export File Location'
        });
        fixedSystemSettings.push({
            id: 10,
            value: 'COUNTRY'
        });
        fixedSystemSettings.push({
            id: 4,
            value: 'Data Change Notification Via Email'
        });
        fixedSystemSettings.push({
            id: 8,
            value: 'Data Change Notification Via SMS'
        });
        fixedSystemSettings.push({
            id: 9,
            value: 'Show Thumbnail Image'
        });


        /*******here we have checked fixed system settings with server side system settings if match found then put value in map else put empty value */
        for (var fixedSystemSettingCount = 0; fixedSystemSettingCount < fixedSystemSettings.length; fixedSystemSettingCount++) {
            for (var systemSettingCount = 0; systemSettingCount < systemSettings.length; systemSettingCount++) {
                if (systemSettings[systemSettingCount].setting.id == fixedSystemSettings[fixedSystemSettingCount].id) {
                    acadLocationSystemSetting.add(systemSettings[systemSettingCount].setting.id, systemSettings[systemSettingCount].value);
                    break;
                }
            }
            if (systemSettingCount == systemSettings.length) {
                acadLocationSystemSetting.add(fixedSystemSettings[fixedSystemSettingCount].id, "");
            }
        }

        return acadLocationSystemSetting;
    },

    /*
     * This function is used for to create JSON FORMAT for saving academy location system settings     
     */
    getAcadSysSettinJsonObject: function(isUpdate) {
        var academyLocationLinkForm = this.getAcademyLocationLinkForm();
        var txtImportLocVal = academyLocationLinkForm.down('#txtImportLoc').getValue();
        var txtExportLocVal = academyLocationLinkForm.down('#txtExportLoc').getValue();
        //var cmbDefCountryVal = academyLocationLinkForm.down('#cmbDefCountry').getRawValue();
        var cmbDefCountryVal = academyLocationLinkForm.down('#cmbDefCountry').getValue();
        var chkEmaililVal = academyLocationLinkForm.down('#chkEmailBox').getValue();
        var chkSMSVal = academyLocationLinkForm.down('#chkSMSBox').getValue();
        var chkThumbnailVal = academyLocationLinkForm.down('#chkThumbnailBox').getValue();

        var fixedSystemSettings = new Array();
        fixedSystemSettings.push({
            id: 1,
            fieldName: 'Import File Location'
        });
        fixedSystemSettings.push({
            id: 2,
            fieldName: 'Export File Location'
        });
        fixedSystemSettings.push({
            id: 10,
            fieldName: 'COUNTRY'
        });
        fixedSystemSettings.push({
            id: 4,
            fieldName: 'Data Change Notification Via Email'
        });
        fixedSystemSettings.push({
            id: 8,
            fieldName: 'Data Change Notification Via SMS'
        });
        fixedSystemSettings.push({
            id: 9,
            fieldName: 'Show Thumbnail Image'
        });

        var academyLocationSettings = [];
        if (txtImportLocVal !== "" && txtImportLocVal != null && txtImportLocVal != undefined) {
            academyLocationSettings.push({
                id: (isUpdate) ? fixedSystemSettings[0].id : "",
                setting: fixedSystemSettings[0],
                value: txtImportLocVal
            });
        }
        if (txtExportLocVal !== "" && txtExportLocVal != null && txtExportLocVal != undefined) {
            academyLocationSettings.push({
                id: (isUpdate) ? fixedSystemSettings[1].id : "",
                setting: fixedSystemSettings[1],
                value: txtExportLocVal
            });
        }
        if (cmbDefCountryVal !== "" && cmbDefCountryVal != null && cmbDefCountryVal != undefined) {
        	
        	if( isUpdate ){
        		var locationSettingId = "";
        		
        		var grid = this.getGrdAcademyLocationLink();
                if (grid.getSelectionModel().getCount() > 0) {
                	if(!isUpdate){
                     this.getGrdAcademyLocationLink().showAcademyLocationForm();
                	}
                    var records = grid.getSelectionModel().getSelection();
                    if (records != "" && records != null && records != undefined) {
                    	if (records[0].data.academyLocationSettings != "" && records[0].data.academyLocationSettings != null && records[0].data.academyLocationSettings != undefined) {
                    		var settingsArray = records[0].data.academyLocationSettings;
                    		for(var index in settingsArray){
                    			var settingObj = settingsArray[index];
                    			if(settingObj.setting.fieldLabel == "COUNTRY"){
                    				//countrySettingPresent = true;
                            		locationSettingId = settingObj.id;
                            		break;
                    			}
                    		}
                    	}
                    }
                }
                
    			academyLocationSettings.push({
                    id: locationSettingId,
                    setting: fixedSystemSettings[2],
                    value: cmbDefCountryVal
                });
        	} else {
        		academyLocationSettings.push({
                	id: "",
                    setting: fixedSystemSettings[2],
                    value: cmbDefCountryVal
                });
        	}
        }
        if (!isNullOrEmpty(chkEmaililVal)) {
            academyLocationSettings.push({
                id: (isUpdate) ? fixedSystemSettings[3].id : "",
                setting: fixedSystemSettings[3],
                value: chkEmaililVal
            });
        }
        if (!isNullOrEmpty(chkSMSVal)) {
            academyLocationSettings.push({
                id: (isUpdate) ? fixedSystemSettings[4].id : "",
                setting: fixedSystemSettings[4],
                value: chkSMSVal
            });
        }
        if (!isNullOrEmpty(chkThumbnailVal)) {
            academyLocationSettings.push({
                id: (isUpdate) ? fixedSystemSettings[5].id : "",
                setting: fixedSystemSettings[5],
                value: chkThumbnailVal
            });
        }
        return academyLocationSettings;
    },
    
    /**
     * method to show the logo window
     * @author Akshay.Kalbhor
     */
    showLogoWindow: function(btn) {
    	var academyLocationGrid = btn.up('grid');
    	var acadLogoWindow = this.showWindow('addlogowindow');
    	var form = acadLogoWindow.down('form');
    	var academyLocNameField = form.down('textfield#academyLocDisplayName');
    	var imageContainer = form.down('image#organizationLogo');
    	
    	if (academyLocationGrid.getSelectionModel().getCount() > 0) {
            var record = academyLocationGrid.getSelectionModel().getSelection()[0];
            var academyLocationId = record.get('id');
            var downloadUrl = SERVERURL.ACADEMY_LOCATION_LOGO_DOWNLOAD;
        	Ext.Ajax.request({
                type: 'rest',
                binary: true,
                url: downloadUrl,
                params: {
                	academyLocationId: academyLocationId
                },
                method: 'GET',
                success : function(response){
                	if(response.responseBytes.length>0){
    					 var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
    					 var url = window.URL.createObjectURL(blob);
    					 imageContainer.getEl().dom.src=url;
    				} else {
    					imageContainer.getEl().dom.src='resources/images/headerLogo/academiaLogo.png';
    				}
               }
            });
            
        	var academyLocationIdField = form.down('hidden#academyLocationId');
        	academyLocNameField.setValue(record.get('displayName'));
        	academyLocationIdField.setValue(record.get('id'));
        }
    },
    
    /**
     * Method to save the logo, Calls the saveAcadLocLogoUpload method.
     * @author Akshay.Kalbhor
     */
    saveLogo: function(btn) {
    	var form = btn.up('form');
    	var academyLocationId = form.down('hidden#academyLocationId').getValue();
    	this.saveAcadLocLogoUpload(form, academyLocationId);
    },
    
    
    /**
     * Method to upload the selected logo for the selected academy location.
     * @param  form
     * @param AcademyLocationId
     * @author Akshay.Kalbhor
     */
    saveAcadLocLogoUpload : function(form, academyLocationId){
    	var this$ = this;
    	var addLogoWindow = form.up('window');
    	var uploadForm = form.down('photouploadform');
    	var photoFileImage = uploadForm.down('filefield#photoFileImage');
    	var fileUploadPath = photoFileImage.getValue();
    	var uploadUrl = SERVERURL.ACADEMY_LOCATION_LOGO_UPLOAD;
    	
    	if(!isNullOrEmpty(fileUploadPath)){
    		var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
    		if (extension == "gif" || extension == "png" || extension == "bmp"
                || extension == "jpeg" || extension == "jpg") {
    			
    			form.getForm().submit({
    	             type: 'rest',
    	             url: uploadUrl,
    	             method: 'POST',
    	             params:{
     	        		academyLocationId : academyLocationId
     	        	 },
    	             success: function(form, action) {
    	            	 addLogoWindow.close();
    	            	 showSuccessMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('PHOTO_UPLOAD_SUCCESS'));
    	            	 /**
    	            	  * Check if the selected AL is the same as the current AL, Only then call to change the image in the header.
    	            	  */
    	            	 if(this$.getCurrentAcademyLocation() === parseInt(academyLocationId)) {
    	            		 this$.setUploadedPhotoToHeader(academyLocationId);
    	            	 } 
    	             }
    	         });
    		}else{
    			photoFileImage.reset();
    			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
    		}
    		
    	}
    },
    
    /**
     * method to set the uploaded photo to the header.
     * @param {Integer} academyLocationId
     */
    setUploadedPhotoToHeader : function(academyLocationId){
    	//var logoSection = Ext.widget('baselayout.header.Logo');
    	var logoSection = this.getLogoSection();
    	var logoContainer = logoSection.down("image#organizationLogo");
    	var orgNameField = logoSection.down("component#organizationName");
    	/*
 		 * Call to fetch the logo of the selected academy location
 		 */
 		var academyLocationDisplayName = this.getAcademyLocationDisplayName(academyLocationId);
    	
    	if(!isNullOrEmpty(academyLocationId)){
    		//var url = this.downloadLogo(academyLocationId);
    		var downloadUrl = SERVERURL.ACADEMY_LOCATION_LOGO_DOWNLOAD;
        	Ext.Ajax.request({
                type: 'rest',
                binary: true,
                url: downloadUrl,
                params: {
                	academyLocationId: academyLocationId
                },
                method: 'GET',
                success : function(response){
                	if(response.responseBytes.length>0){
                		var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
                		var url = window.URL.createObjectURL(blob);
                		//logoContainer.getEl().dom.src=url;
                		logoContainer.setVisible(true);

                		if(!isNullOrEmpty(url)) {
                			logoContainer.getEl().dom.src=url;
                		} 
                		var image = new Image();
                		image.src = url;
                		image.onload = function() {
                			//console.log('height: ' + this.height+ ' width: '+ this.width);
                			var ratio = this.width/this.height;
                			width = 55*ratio;
                			logoSection.down('#organizationLogo').setWidth(width);
                			logoSection.doLayout();
                			orgNameField.getEl().dom.innerHTML = academyLocationDisplayName;
                		};

                		//orgNameField.getEl().dom.innerHTML = academyLocationDisplayName;
                	} else {
    					logoContainer.getEl().dom.src='resources/images/headerLogo/academiaLogo.png';
    					orgNameField.getEl().dom.innerHTML = getCommonTranslation('ACADEMIA_ERP_DEFAULT_TEXT');
    				}
               }
            });
    	}
    	
    },
    
    getDefaultCountryCode : function(){
		Ext.Ajax.request({
    		type: 'rest',
    		url: SERVERURL.DEFAULT_COUNTRY_CODE_BY_ACADEMY_LOCATION,
    		method: 'GET',
    		success: function(response, action) {
    			var MSSG = response.responseText;
    			var jdata = Ext.decode(response.responseText);
    			Ext.app.defaultCountryCode = jdata.isdCode;
    		}
    	});
	},
	hideShowAddOtherInformationBtn: function(gridReference,permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

		var addOtherInfo = gridReference.down('#addOtherInfo');
		addOtherInfo.setVisible(false);

		Ext.each(permissionList, function(privilege) {
			if (privilege === 'ADD_OTHER_INFORMATION') {
				if (!isNullOrEmpty(addOtherInfo)) {
					addOtherInfo.setVisible(true);
				}
			}
		});
	},
	showAddOtherInfoWin: function(btn) {
		var academyLocationGrid = btn.up('grid');
		var acadLogoWindow = this.showWindow('academylocationaddotherinfowin');
		var form = acadLogoWindow.down('form');
		var academyLocNameField = form.down('textfield#academyLoctionDisplayName');
		var imageContainer = form.down('image#organizationLogo');
		var venueukprnItem = form.down('#venueukprnItemId');
		
		var imageUploadFieldArr = ['imageUploadField'];
		var academyLocationId = this.getCurrentAcademyLocation();
		
		if (academyLocationGrid.getSelectionModel().getCount() > 0) {
			var record = academyLocationGrid.getSelectionModel().getSelection()[0];
			var academyLocationId = record.get('id');
			Ext.Ajax.request({
				url: SERVERURL.PATH_FIND_ALL_VENUE_UPKRN_BY_AL_ID,
				method: 'GET',
				async: false,
				params: {
					academyLocationId:academyLocationId,
				},
				success: function(response) {
					var json = JSON.parse(response.responseText);
					if(json.id) {
						venueukprnItem.getStore().load({
		 					callback: function(records, operation, success) {
		 						for(var i in records){
		 							if(records[i].data.id==json.id){
		 								venueukprnItem.setValue(records[i].data.id);
		 							}
		 						}
		 					}	   
		 				});
						
						//venueukprnItem.setValue(json.value);
					}
				}
			})
		}
		

		Ext.Ajax.request({
			url: SERVERURL.COMMON_FORM_FIELD_INFO,
			method: 'GET',
			async: false,
			params: {
				academyLocationId:academyLocationId,
				languageCode:'en'
			},
			success: function(response) {
				var json = JSON.parse(response.responseText);
				var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
				fieldInfo.set("formFieldsInfo", json);
				if( !isNullOrEmpty(json) ){
					if( !isNullOrEmpty(json.academylocationaddotherinfowin) ){
						var academyLocationDetailDFRConfig = json.academylocationaddotherinfowin;
						for( i in academyLocationDetailDFRConfig){
							var fieldConfig = academyLocationDetailDFRConfig[i];
							if( imageUploadFieldArr.includes(fieldConfig.formFieldId) ){
								var alCatalougeImage = form.down("#organizationLogo");
								if(!fieldConfig.isVisible){
									alCatalougeImage.setVisible(false);
								}else{
									alCatalougeImage.setVisible(true);
								}
							}
						}
					}
				}
			}
		});
		if (academyLocationGrid.getSelectionModel().getCount() > 0) {
			var record = academyLocationGrid.getSelectionModel().getSelection()[0];
			var videoURLCatalogue = form.down('#videoURLCatalogueId');
			var whetherPublicCatalogueId = form.down('#whetherPublicCatalogueId');
				videoURLCatalogue.setValue(record.raw.catalougeVideoURL);
			whetherPublicCatalogueId.setValue(record.raw.whetherPublishInCatalogue);
			var academyLocationId = record.get('id');
			var downloadUrl = SERVERURL.PATH_FIND_IMAGE_DOC_BY_ACADEMY_LOCATION_ID;
			Ext.Ajax.request({
				type: 'rest',
				binary: true,
				url: downloadUrl,
				params: {
					academyLocationId: academyLocationId
				},
				method: 'GET',
				success : function(response){
					if(response.responseBytes.length>0){
						var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
						var url = window.URL.createObjectURL(blob);
						imageContainer.getEl().dom.src=url;
					}
					else {
    					imageContainer.getEl().dom.src='resources/images/headerLogo/academiaLogo.png';
    				}
				}
			});

			var academyLocationIdField = form.down('hidden#academyLocationId');
			academyLocNameField.setValue(record.get('displayName'));
			academyLocationIdField.setValue(record.get('id'));
		}
	},
	saveALCatalogueDetails: function(btn) {
		var this$ = this;
		var form = btn.up('form');
		var imagePath = form.down('#imageUploadField').getValue();
			var academyLocationId = form.down('hidden#academyLocationId').getValue();
		var grid = this$.getGrdAcademyLocationLink();
		if (grid.getSelectionModel().getCount() > 0) {
			if(!isNullOrEmpty(imagePath)){
				form.getForm().submit({
		             type: 'rest',
		             url: SERVERURL.ACADEMY_LOCATION_CATALOUGE_UPLOAD,
		             method: 'POST',
		             params:{
		        		academyLocationId : academyLocationId
		        	 },
		             success: function(form, action) {
		            		 this$.saveALCatalogueDetails2(btn);
		             }
		         });
			}else{
				 this$.saveALCatalogueDetails2(btn,imagePath,grid);
			}
		}
	},
	saveALCatalogueDetails2: function(btn) {
		var form = btn.up('form');
		var academyLocationId = form.down('hidden#academyLocationId').getValue();
		var catalougeVideoURL = form.down('#videoURLCatalogueId').getValue();
		var whetherPublishInCatalogue = form.down('#whetherPublicCatalogueId').getValue();
		var venueUKPRN = form.down('#venueukprnItemId').getValue();
		var grid = this.getGrdAcademyLocationLink();
		
		
		
		if (grid.getSelectionModel().getCount() > 0) {
			var json = {
					academyLocationId: academyLocationId,
					catalougeVideoURL:catalougeVideoURL,
					whetherPublishInCatalogue:whetherPublishInCatalogue,
					venueUKPRN:venueUKPRN
				}
			if(!venueUKPRN) {
				delete json.venueUKPRN;
			}
			var updateUrl = SERVERURL.PATH_SAVE_AL_CATALOGUE_DETAILS;
			Ext.Ajax.request({
				method: "GET",
				type: 'rest',
				url: updateUrl,
				headers: {
					'Content-Type': 'application/json'
				},
				params: json,
				success : function() {
					btn.up('window').close();
					grid.getStore().reload();
					showSuccessMessage(getDMSTranslation('SUCCESS'),getDMSTranslation('SUCCESS_MSG'));
				}
			});
		}
	}
});
