/*
 * This controller is used for Academy-Locations Tab(Academy Location Purposes)   
 */
Ext.define('Academia.controller.organization.academylocations.AcademyLocationPurposeController',
				{
					extend : 'Academia.controller.base.BaseController',
					models : [ 'common.IdValueDataModel','organization.academylocations.AcademyLocationLinkModel'],
					stores : [ 'organization.academylocations.AcademyLocationPurposeStore',
							'organization.academylocations.PurposesStore',
							'calendar.ActiveCalendarStore',
							'organization.academylocations.AcademicYearStore',
							'organization.academylocations.AcademicTenureStore',
							'organization.academylocations.FacultyFeePlanStore',
							'common.UsersComboStore','organization.academylocations.AcademyLocationPurposeDocument'],

					views : [
							'organization.academylocations.AcademyLocation',							
							'organization.academylocations.AcademyLocationPurposeFormWindow',
							'organization.academylocations.AcademyLocationPurposeGrid',
							'organization.academylocations.AcademyLocationPurposeDocumentGrid'],

					alias : "widget.academylocationpurposecontroller",

					refs : [ {
						ref : 'grdAcademyLocationPurpose',
						selector : 'academylocationpurposegrid'
					},{
						ref : 'winAcademyLocationPurposeFormWindow',
						selector : 'academylocationpurposeformwindow'
					},{
						ref : 'academyLocationPurposeForm',
						selector : 'academylocationpurposeformwindow form[itemId=academyLocationPurposeForm]'
					},{
						ref : 'grdAcademyLocationLink',
						selector : 'academylocationlinkgrid'
					},{
						ref : 'academyLocationPurposeDocumentWin',
						selector : 'academylocationpurposedocumentgrid'
					}],
					config: {
						ORGANIZATION_STRUCTURE_ACADMY_LOCATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ORGANIZATION_STRUCTURE_ACADMY_LOCATION_PRIVILEGES')
				    },
					init : function(application) {
						this.control({
							'academylocationpurposegrid button[itemId=btnAdd]' : {
								click : this.addAcademyLocationPurpose
							},							
							'academylocationpurposegrid button[itemId=btnEdit]' : {
								click : Ext.bind(this.editAcademyLocationPurpose, this, [false])
							},
							'academylocationpurposegrid button[itemId=btnView]' : {
								click : Ext.bind(this.editAcademyLocationPurpose, this, [true])
							},
							'academylocationpurposegrid button[itemId=btnDelete]' : {
								click : this.deleteAcademyLocationPurpose
							},
							'academylocationpurposeformwindow button[itemId=btnSaveAcademyLocationPurposeForm]' : {
								click : this.saveAcademyLocationPurposeForm
							},
							'academylocationpurposeformwindow button[itemId=btnCancelAcademyLocationPurposeForm]' : {
								click : this.cancelAcademyLocationPurposeForm
							},
							'academylocationpurposeformwindow combo[itemId=cmbPurposeName]' : {
								select :this.enableDisableDependentCombo
							},
							/**** Load store when render grid*****/
							'academylocationpurposegrid' : {								
								render : function(component, options) {
									component.getStore().load();									
								},
								cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
									var $this =this;
									if (e.target.tagName == 'A') {
										var gridWindow = $this.getAcademyLocationPurposeDocumentWin();
										if (!gridWindow) {
											Ext.widget('academylocationpurposedocumentgrid');
											gridWindow = $this.getAcademyLocationPurposeDocumentWin();
										}
										gridWindow.show();

										var grid = gridWindow.down('grid');
										var store = grid.getStore();
										store.getProxy().extraParams = {
											id: record.get('id')
										};
										store.load();
									}
								}
							},
							'academylocationpurposegrid[itemId=academyLocationPurPosegrid]': {
								render: function(grid) {
				                    //this.doAccessControlValidation(grid, this.getORGANIZATION_STRUCTURE_ACADMY_LOCATION_PERMISSIONS());
				                }
							},
							/**** Load store when render combos on dialog box*****/
							'academylocationpurposeformwindow combo' : {								
								render : function(component, options) {
								    component.getStore().load();									
								}
							},
							'academylocationpurposeformwindow combo[itemId=cmbAcademicYear]':{
								select : function( combo, records, eOpts ) {								    									
								    var academyYearId=this.getAcademyLocationPurposeForm().down('#cmbAcademicYear').getValue();								    
								    if(!isNullOrEmpty(academyYearId)){
								    	this.getAcademyLocationPurposeForm().down('#cmbAcademicYearTenure').getStore().load({params:{academyYearId:academyYearId}});
								    }								    
								}
							},
							'academylocationpurposegrid menuitem[itemId=purposeuploadDoc]':{
								click:function(){
									var grid = this.getGrdAcademyLocationPurpose();
									if(grid.getSelectionModel().getCount()>0){
										this.getDocumentController().showDocumentFormWindow('academylocationpurpose', 'DOCUMENT');
									}else{
										showWarningMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
									}
								}
							},
							 'documentformwindow[itemId=academylocationpurpose] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]':{
								  click: this.getUploadALPDocument
							  },
							  'academylocationpurposedocumentgrid grid[itemId=academylocationpurposedocumentgridId]':{
								  cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
									  if (e.target.tagName == 'A') {
										  var documentId = record.get("documentId");
										  if (!isNullOrEmpty(documentId)) {
											  this.getDownloadFileForALPDocument(documentId);
										  }
									  }
								  }  
							  },
							  'academylocationpurposedocumentgrid grid[itemId=academylocationpurposedocumentgridId] button[itemId=btnDelete]' : {
								  click : function() {
									  var $this = this;
									  var ALPGrid = this.getGrdAcademyLocationPurpose();
									  var grid=$this.getAcademyLocationPurposeDocumentWin().down('grid');
									  if (grid.getSelectionModel().getCount() > 0) {
										  showConfirmMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
												  function(btn,text) {
											  if (btn == 'yes') {
												  var records = grid.getSelectionModel().getSelection();
												  var id = records[0].get("academyLocationPurposeDocumentId");
												  Ext.Ajax.request({
													  method : "DELETE",
													  type : 'rest',
													  url : SERVERURL.DELETE_DOCUMENT_ACADEMY_LOCATION_PURPOSE+ '?id='+ id,
													  headers : {
														  'Content-Type' : 'application/json'
													  },
													  success : function(form,action) {
														  grid.getStore().reload();
														  ALPGrid.getStore().reload();
														  showSuccessMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
													  }
												  });
											  }
										  });
									  } else {
										  showWarningMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please
									  }
								  }
							  },
							  'simpledocumentform button#documentCancelButtonId':{
								  click:function(){
									  this.getDocumentController().closeDocumentFormWindow();
								  }
							  },
						});
					},

					/*
					 * 
					 * This function is used for to enable or disable dependent combos
					 */
					enableDisableDependentCombo:function(){
						var academyLocationPurposeForm=this.getAcademyLocationPurposeForm();																							
						var selectedPurpose=academyLocationPurposeForm.down('#cmbPurposeName').getValue();
						if(selectedPurpose==='COURSE_EXECUTION' || selectedPurpose==='PLACEMENT'){
							academyLocationPurposeForm.down('#cmbAcademicYear').setDisabled(false);
							academyLocationPurposeForm.down('#cmbAcademicYearTenure').setDisabled(false);
							academyLocationPurposeForm.down('#cmbFacultyFeePlan').setDisabled(false);
						}else{
							academyLocationPurposeForm.down('#cmbAcademicYear').setDisabled(true);
							academyLocationPurposeForm.down('#cmbAcademicYearTenure').setDisabled(true);
							academyLocationPurposeForm.down('#cmbFacultyFeePlan').setDisabled(true);
						}
					},
					/*
					 * This function is used for to show Academy Location Purpose Details Dialog box after clicking on Add button   
					 */		
					addAcademyLocationPurpose : function() {						
						var grid=this.getGrdAcademyLocationLink();
						if(grid.getSelectionModel().getCount()>0){
							var records=grid.getSelectionModel().getSelection();
							var inactiveStatus=this.checkInactiveStatus(records[0].data.academy,records[0].data.location);
							if(inactiveStatus){
								showWarningMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'),getCommonTranslation('ACADEMY_OR_LOCATION_INACTIVE_MSG'));//Academy or Location status now inactive so you can not add purpose. 
							}else{
								this.getGrdAcademyLocationPurpose().showAcademyLocationPurposeForm();							
								if(records!="" && records!=null && records!=undefined){							
									var academyLocationPurposeForm=this.getAcademyLocationPurposeForm();																
									academyLocationPurposeForm.down('#hidAcademyLocationField').setValue(records[0].data.id);	
									this.setDateValidations(records[0],academyLocationPurposeForm);
								}
							}							
						}else{
							showWarningMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'),getCommonTranslation('PLEASE_SELECT_ACADEMY_LOCATION'));//Please select a Academy Location record.							
						}
					},
					
					/*
					 * This function is used for to show Academy Location Purpose Details Dialog box with values after clicking on Edit button   
					 */
					editAcademyLocationPurpose : function(isView) {	
						var me=this;
						var grid=this.getGrdAcademyLocationPurpose();
						if(grid.getSelectionModel().getCount()>0){
							this.getGrdAcademyLocationPurpose().showAcademyLocationPurposeForm();
							var records=grid.getSelectionModel().getSelection( );
							if(records!="" && records!=null && records!=undefined){							
								var academyLocationPurposeForm=this.getAcademyLocationPurposeForm();
								academyLocationPurposeForm.loadRecord(records[0]);
								academyLocationPurposeForm.down('#dateStartDate').setValue(dateRender(records[0].data.startDate));
								academyLocationPurposeForm.down('#dateTillDate').setValue(dateRender(records[0].data.tillDate));
								me.enableDisableDependentCombo();
								academyLocationPurposeForm.down('#cmbPurposeCalendar').setValue(records[0].data.calendar.id);
								if(!isNullOrEmpty(records[0].data.academyYear)){
									academyLocationPurposeForm.down('#cmbAcademicYear').setValue(records[0].data.academyYear.id);
								}if(!isNullOrEmpty(records[0].data.academyYearTenure)){	
									academyLocationPurposeForm.down('#cmbAcademicYearTenure').setValue(records[0].data.academyYearTenure.id);
								}if(!isNullOrEmpty(records[0].data.facultyFeePlan)){
									academyLocationPurposeForm.down('#cmbFacultyFeePlan').setValue(records[0].data.facultyFeePlan.id);
								}
								academyLocationPurposeForm.down('#cmbOwner').setValue(records[0].data.owner.id);
								academyLocationPurposeForm.down('#hidAcademyLocationField').setValue(records[0].data.academyLocation.id);
								if(isView){
									var winAcademyLocationPurposeFormWindow = me.getWinAcademyLocationPurposeFormWindow();
									winAcademyLocationPurposeFormWindow.down('#btnSaveAcademyLocationPurposeForm').setVisible(false);									
									toggleReadOnlyFormItems (academyLocationPurposeForm.getForm(),true);
								}
							}
						}else{
							showWarningMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record.
						}
					},
					
					/*
					 * This function is used for to delete academy location purpose details after clicking on Delete button   
					 */
					deleteAcademyLocationPurpose : function() {
						var grid=this.getGrdAcademyLocationPurpose();
						var grdStore=grid.getStore();
						if(grid.getSelectionModel().getCount()>0){
							showConfirmMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				                if (btn == 'yes') {
						    	if(grid.getSelectionModel().getCount()>0){
						    		  var records=grid.getSelectionModel().getSelection( );						        
								        for(var count=0;count<records.length;count++){
								        	var id="";
								        	if(records[count].get("id")!="" && records[count].get("id")!=undefined && records[count].get("id")!=null){
								        		id=records[count].get("id");
								        	}
								        	Ext.Ajax.request({
												 type: 'rest',
												 url : SERVERURL.ACADEMY_LOCATION_PURPOSE_DELETE,//URL-rest/academyLocationPurpose/delete												 													 
												 method:'DELETE',
												 headers: {
							                            'Content-Type': 'application/json'
							                        },
												 params:{
													 id:id
												 },
													success:function(form, action){
														grdStore.reload();
														showSuccessMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'),getCommonTranslation('DELETE_ACADEMY_LOCATION_PURPOSE_MSG'));//Academy Location Purpose deleted successfully.														
													}
												});
								        }
						    	}						      
						    }
						
						});
						} else {
					        	showWarningMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					       }
					},					
					
					/*
					 * This function is used for to save Academy Location Purpose Details after clicking on Save button on dialog box   
					 */
					saveAcademyLocationPurposeForm : function(model, records) {
						var winAcademyLocationPurposeFormWindow=this.getWinAcademyLocationPurposeFormWindow();
						var grid=this.getGrdAcademyLocationPurpose();
						var grdStore=grid.getStore();
						var academyLocationPurposeForm=this.getAcademyLocationPurposeForm();			    						
						//var values = academyLocationLinkForm.getValues();
						if(academyLocationPurposeForm.isValid( )){
						var submitUrl,isUpdate=false;
						var academyPurposeHiddenField=academyLocationPurposeForm.down('#hidAcademyPurposeField');//			    		
			    		if (academyPurposeHiddenField.getSubmitValue() == null || academyPurposeHiddenField.getSubmitValue() == "" || academyPurposeHiddenField.getSubmitValue() === undefined) {
			    			submitUrl= SERVERURL.ACADEMY_LOCATION_PURPOSE_CREATE;//URL-rest/academyLocationPurpose/create			    			
			    			isUpdate=false;
			    		} else {
			    			submitUrl= SERVERURL.ACADEMY_LOCATION_PURPOSE_UPDATE;//URL-rest/academyLocationPurpose/update			    			
			    			isUpdate=true;
			    		}	    								 
						 var jsonFormatFormData=this.createJsonFormat(academyLocationPurposeForm,records,isUpdate);
						 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						 Ext.Ajax.request({
							 type: 'rest',
							 url : submitUrl,	
							 jsonData:jsonFormatFormData,
							 method:'POST',
								success:function(form, action){
									winAcademyLocationPurposeFormWindow.close();
									grid.getSelectionModel().deselectAll();
									grdStore.reload();
									if(isUpdate){
										showSuccessMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'),getCommonTranslation('UPDATE_ACADEMY_LOCATION_PURPOSE_MSG'));//Academy location purpose updated successfully.											
									}else{
										showSuccessMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'),getCommonTranslation('ADD_ACADEMY_LOCATION_PURPOSE_MSG'));//Academy location purpose added successfully.										
									}																	
								},
								failure: function(form, action) {
									winAcademyLocationPurposeFormWindow.close();
									grdStore.reload();
									showErrorMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'),getCommonTranslation('ERROR_MSG'));//Error occured while performing transaction																		
								}
							});
						 	Ext.getBody().unmask();
						}else{
							showWarningMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'),getCommonTranslation('ENTER_VALID_INPUT'));//please enter a valid input.							
						}
			    	},
			    	
			    	/*
					 * This function is used for to close Academy Location Purpose Details dialog box after clicking on cancel button   
					 */
					cancelAcademyLocationPurposeForm : function() {
						this.getWinAcademyLocationPurposeFormWindow().close();
					},
					
					/*
					 * This function is used for to create JSON FORMAT for saving Academy Location Purpose Details 
					 */
					createJsonFormat:function(academyLocationPurposeForm,record,isUpdate){		
						var formDataValues=academyLocationPurposeForm.getValues();
						var cmbPurposeCalendar=academyLocationPurposeForm.down('#cmbPurposeCalendar');
						var cmbAcademicYear=academyLocationPurposeForm.down('#cmbAcademicYear');
						var cmbAcademicYearTenure=academyLocationPurposeForm.down('#cmbAcademicYearTenure');
						var cmbFacultyFeePlan=academyLocationPurposeForm.down('#cmbFacultyFeePlan');						
						var cmbOwner=academyLocationPurposeForm.down('#cmbOwner');
						var hidAcademyLocation=academyLocationPurposeForm.down('#hidAcademyLocationField');
						var versionIdField=academyLocationPurposeForm.down('#versionId_hidden_field');
						
						var values=new Object();
						if(isUpdate && formDataValues.id!="" && formDataValues.id!=null && formDataValues.id!=undefined){
							values.id=formDataValues.id;
						}
						//values.academy=eval('({"id":'+academyNameCombo.getValue()+',"value":'+academyNameCombo.getRawValue()+'})');						
						//values.location=eval('({"id":'+academyLocationCombo.getValue()+',"value":'+academyLocationCombo.getRawValue()+'})');						
						values.calendar={id:cmbPurposeCalendar.getValue(),value:cmbPurposeCalendar.getRawValue()};		
						if(!isNullOrEmpty(cmbFacultyFeePlan.getValue())){
							values.facultyFeePlan={id:cmbFacultyFeePlan.getValue(),value:cmbFacultyFeePlan.getRawValue()};
						}if(!isNullOrEmpty(cmbAcademicYear.getValue())){
							values.academyYear={id:cmbAcademicYear.getValue(),value:cmbAcademicYear.getRawValue()};
						}if(!isNullOrEmpty(cmbAcademicYear.getValue())){
							values.academyYearTenure={id:cmbAcademicYearTenure.getValue(),value:cmbAcademicYearTenure.getRawValue()};
						}
						values.owner={id:cmbOwner.getValue(),value:cmbOwner.getRawValue()};
						values.academyLocation={id:hidAcademyLocation.getValue(),value:null};
						values.purpose=formDataValues.purpose;
						values.startDate=formDataValues.startDate;
						values.tillDate=formDataValues.tillDate;					
						values.version=versionIdField.getValue();
						
						 var formData = Ext.encode(values);
						 return formData;
					
					},

					setDateValidations:function(record,academyLocationPurposeForm){
						/******* For to set start date and end date**/
						var academyStartDate=record.data.academy.startDate;
						var locationStartDate=record.data.location.startDate;
						var resultDate=this.compareDate(academyStartDate,locationStartDate,"Start Date");
						if(!isNullOrEmpty(resultDate)){
							academyLocationPurposeForm.down('#dateStartDate').setMinValue(resultDate);									
						}
						
						var todayDate=new Date();
//						todayDate=Ext.Date.format(todayDate, CONSTANTS.DATE_FORMAT);
						resultDate=this.compareDate(resultDate,todayDate,"End Date");
						if(!isNullOrEmpty(resultDate)){
							academyLocationPurposeForm.down('#dateTillDate').setMinValue(resultDate);									
						}
						
						var academyEndDate=dateRender(record.data.academy.tillDate);
						var locationEndDate=dateRender(record.data.location.tillDate);
						if(isNullOrEmpty(academyEndDate) && !isNullOrEmpty(locationEndDate)){
							academyLocationPurposeForm.down('#dateStartDate').setMaxValue(locationEndtDate);
							academyLocationPurposeForm.down('#dateTillDate').setMaxValue(locationEndtDate);
						}
						if(!isNullOrEmpty(academyEndDate) && isNullOrEmpty(locationEndDate)){
							academyLocationPurposeForm.down('#dateStartDate').setMaxValue(academyEndDate);
							academyLocationPurposeForm.down('#dateTillDate').setMaxValue(academyEndDate);
						}
						if(!isNullOrEmpty(academyEndDate) && !isNullOrEmpty(locationEndDate)){
							var resultEndDate=this.compareDate(record.data.academy.tillDate,record.data.location.tillDate,"End Date");
							if(!isNullOrEmpty(resultEndDate)){
								academyLocationPurposeForm.down('#dateStartDate').setMaxValue(resultEndDate);
								academyLocationPurposeForm.down('#dateTillDate').setMaxValue(resultEndDate);
							}
						}
					},
					
					compareDate:function(StartDate,EndDate,type){
						
						var startDate=null;
						var endDate=null;						 
						var returnDate="";
						if(!isNullOrEmpty(StartDate)){
//							startDate=new Date(StartDate.replace( /(\d{2})-(\d{2})-(\d{4})/, "$2/$1/$3"));
							startDate=new Date(StartDate);
						};
						
						if(!isNullOrEmpty(EndDate)){
//							endDate=new Date(EndDate.replace( /(\d{2})-(\d{2})-(\d{4})/, "$2/$1/$3"));
							endDate=new Date(EndDate);
						};
						
						if(startDate instanceof Date && endDate instanceof Date){
							if(startDate==endDate){
								return startDate;
							}
							if(type==="Start Date"){
								if(startDate>endDate){
									return endDate;
								}else{
									return startDate;
								}
							}else if(type==="End Date"){
								if(startDate<endDate){
									return endDate;
								}else{
									return startDate;
								}
							}								
						};
						  // Convert back to days and return
//						  return Math.round(difference_ms/one_day); 

						return returnDate;
						},	
						
						checkInactiveStatus:function(academy,location){
							if(academy.status==false){
								return true; 
							}else if(location.status==false){
								return true;
							}else{
								return false;
							}
						},
						getDocumentController : function(){
				        	var this$ = this;
				        	return this$.getController('Academia.controller.document.DocumentController');
				        },
				        getUploadALPDocument : function(){
				        	var $this=this;
				        	var grid=this.getGrdAcademyLocationPurpose();
				        	var isTransient = false;
				        	var module = 'academylocationpurpose';
				        	var entityId ;
				        	var entityType = 'academylocationpurpose';
				        	$this.applyWindowMask(); 
				        	$this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){
				        		if (grid.getSelectionModel().getCount() > 0) {
				        			var record = grid.getSelectionModel().getSelection()[0];
				        			var id = record.get("id");
				        			var documentId = Ext.decode(response.responseText);
				        			var updateUrl = SERVERURL.DOCUMENT_ACADEMY_LOCATION_PURPOSE+'?id='+id+'&documentId='+documentId;
				        			Ext.Ajax.request({
				        				type : 'rest',
				        				url : updateUrl,
				        				method : 'POST',
				        				success : function(response, action) {
				        					$this.hideWindowMask();
				        					showSuccessMessage(getCommonTranslation('ACADEMY_LOCATION_PURPOSES'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
				        					grid.getStore().reload();
				        				}
				        			});    
				        		}
				        		$this.getDocumentController().closeDocumentFormWindow();
				        	}, isTransient);
				        },
				        getIdValueJson: function(id, value) {
				    		if (id) return {
				    			id: id,
				    			value: value
				    		};
				    	},
				    	getDownloadFileForALPDocument : function(documentId){
				    		if(!isNullOrEmpty(documentId)){
				    			var csvForm = Ext.create('Ext.form.Panel'); 
				    			csvForm.getForm().submit({
				    				target: '_blank',
				    				method:'GET',
				    				params :{
				    					access_token : Ext.Ajax.defaultHeaders.access_token
				    				},
				    				headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				    				url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
				    				standardSubmit :true
				    			});
				    		}
				    	},
				});
