/**
 * This controller is used for the faculty disciplinary functionality.
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.personinfo.faculty.FacultyDisciplinaryController', {
    extend: 'Academia.controller.personinfo.common.PersonDisciplinaryController',

    alias: "widget.facultydisciplinarycontroller",
    
    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personDisciplinaryActionForm',
        selector: 'disciplinaryactionform[itemId=facultyDisciplinaryActionForm]'

    }, {
        ref: 'personPositiveIncidentForm',
        selector: 'positiveincidentform[itemId=facultyPositiveIncidentForm]'

    }, {
        ref: 'personNegativeIncidentForm',
        selector: 'negativeincidentform[itemId=facultyNegativeIncidentForm]'

    },{
		ref : 'disciplinaryactiondocumentgrid',
		selector : 'disciplinaryactiondocumentgrid'

	},{
		ref : 'disciplinaryactiondocumentlist',
		selector : 'disciplinaryactiondocumentlist'

	},{
		ref : 'disciplinaryactiondocumentlistgrid',
		selector : 'disciplinaryactiondocumentlistgrid'

	},{
		ref : 'disciplinaryactiongrid',
		selector : 'disciplinaryactiongrid[itemId=facultyDisciplinaryActionGrid]'
	},{
		ref : 'positiveincidentdocumentlist',
		selector : 'positiveincidentdocumentlist[itemId=facultyPositiveIncidentReportDocument]'
	}/*,{
		ref : 'positiveincidentdocumentlistgrid',
		selector : 'positiveincidentdocumentlistgrid[itemId= facultypositiveincidentdocumentlistgrid]'
	}*/,{
		ref : 'positiveincidentdocumentgrid',
		selector : 'positiveincidentdocumentgrid'

	},{
		ref : 'positiveincidentgrid',
		selector : 'positiveincidentgrid[itemId= facultyPositiveIncidentGrid]'
	}],
    config: {
    	FACULTY_DISCIPLINARY_ACTIONS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_DISCIPLINARY_ACTIONS_PRIVILEGES'),
    	FACULTY_NEGATIVE_INCIDENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_NEGATIVE_INCIDENTS_PRIVILEGES'),
    	FACULTY_POSITIVE_INCIDENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_POSITIVE_INCIDENTS_PRIVILEGES'),
    	FACULTY_PROFILE_DISCIPLINARY_ACTIONS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_DISCIPLINARY_ACTIONS_PRIVILEGES'),
    	FACULTY_PROFILE_POSITIVE_INCIDENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_POSITIVE_INCIDENTS_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            /**
             *  Disciplinary Action
             */
        								
            'disciplinaryactiongrid[itemId= facultyDisciplinaryActionGrid]': {
                render: function(grid) {
                  //  this.loadGridStore('#facultyDisciplinaryActionGrid', SERVERURL.DISCIPLINARY_ACTION_GRIDDATA);
                    var portalId = this.getCurrentLoggedPortalId();
            		if (portalId == 1){
            			this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_DISCIPLINARY_ACTIONS_PERMISSIONS());	
            		} else if (portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_DISCIPLINARY_ACTIONS_PERMISSIONS());
            		}
                },
                afterrender : function(grid){
                	this.loadGridStore('#facultyDisciplinaryActionGrid', SERVERURL.DISCIPLINARY_ACTION_GRIDDATA);
                	if(this.getCurrentLoggedPortalId() == 2){
                		grid.down('#btnAdd').hide();
                		grid.down('#btnDelete').hide();
                	}
                }
            },
         	 
        	'disciplinaryactiongrid[itemId=facultyDisciplinaryActionGrid]':{
 			   cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
 				   var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
// 				   var documentId = record.data.document.id;
 				   if(columnName == "documents"){
          			   if(e.target.tagName=='A'){
          				  if(record.data.documents.length == 1){
             			    	var whetherFile = false;
               			    	var documentId= record.data.documents["0"].id;
               			    	if(!isNullOrEmpty(documentId)){
               			    	Ext.Ajax.request({
               			            type: 'rest',
               			            url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
               			            method: 'GET',
               			            callback : function(opt, success, response){
               			            	if(response.responseText == 'true') {
               			            		var csvForm = Ext.create('Ext.form.Panel'); 
               			        	    	csvForm.getForm().submit({
               			        		    	target: '_blank',
               			        		    	method:'GET',
               			        		    	params :{
               			        		    		access_token : Ext.Ajax.defaultHeaders.access_token
               			        		    	},
               			        		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
               			        		    	url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
               			        		    	standardSubmit :true
               			        	    	});
               			            	} else {
               			            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
               			            	}
               			            }
               			         });
               			    	}} else if(record.data.documents.length > 1){
          					  var docWindow = this.getDisciplinaryactiondocumentlist();
          					  var ID = record.data.id;
          					  if (!docWindow) {
          						  //Ext.widget('disciplinaryactiondocumentlist');
          						  docWindow = Ext.widget('disciplinaryactiondocumentlist',{
          							  itemId:'facultyDisciplinaryReportDocument'
          						  });
          						  //docWindow = this.getDisciplinaryactiondocumentlist();
          					  }
          					  docWindow.show();
          					  docWindow.down('form').down('#incidentDate').setValue(dateRender(record.data.incidentDate));
          					  docWindow.down('form').down('#details').setValue(record.data.details);
          					  docWindow.down('form').down('#actionTaken').setValue(record.data.actionTaken);
          					  var disciplinaryactiondocumentlistgrid = docWindow.down('#disciplinaryactiondocumentlistgridItemId');
          					  disciplinaryactiondocumentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
          					 // var portalId = this.getCurrentLoggedPortalId();
          					  /*var facultyId = this.getCurrentlyLoggedInUser().id;
          					  if(portalId==2 && facultyId==ID) {
          						  docWindow.down("#btnDelete").setVisible(false);
          					  }*/
          					  var store = disciplinaryactiondocumentlistgrid.getStore();
          					  store.getProxy().extraParams = {
          						  ID: record.data.id
          					  };
          					  store.load();
          					  
          					var portalId = this.getCurrentLoggedPortalId();
                    		if (portalId == 1){
                    			this.doAccessStudentDAGridDeleteButton(disciplinaryactiondocumentlistgrid, this.getFACULTY_PROFILE_DISCIPLINARY_ACTIONS_PERMISSIONS(),ID);
                    		} else if (portalId == 2){
                    			this.doAccessStudentDAGridDeleteButton(disciplinaryactiondocumentlistgrid, this.getFACULTY_DISCIPLINARY_ACTIONS_PERMISSIONS(),ID);
                    		}
          				  }
          			   }
 				   }
 			   }
 		   }, 
 		   'disciplinaryactiondocumentlist[itemId=facultyDisciplinaryReportDocument] disciplinaryactiondocumentlistgrid button[itemId=downloadDocumentItemId]':{
  				click:function(obj){
  					this.documentReportDocumentZip();
  				}
        	 },
 		   
 			/*'disciplinaryactiondocumentlistgrid':{
 				 render: function(grid) {
 					  this.doAccessControlValidation(grid, this.getFACULTY_POSITIVE_INCIDENTS_PERMISSIONS());
                 },
 				 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				 if(columnName == "documentName"){
    					 if(e.target.tagName=='A'){
    						 this.getDownloadFile(record.get('documentId'));
    					 }
    				 }
    			 }
    		 },*/
 		   
      		'documentformwindow[itemId=faculty_disciplinary_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
    			click : function() {
    				var $this = this;
    				var isTransient = true;
    				var module = 'disciplinaryAction';
    				var entityId;
    				var entityType = 'disciplinaryActionDocument';

    				$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
    						function(success,response,isCallBackTransient) {
    							var documentModel = new Academia.model.personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentModel();
    							documentModel.set("documentName",response.name);
    							documentModel.set("path",response.path);
    							documentModel.set("type",response.type);
    							documentModel.set("documentName",response.name);
    							documentModel.set("createdBy",$this.getIdValueJson(
    											response.createdBy.id,response.createdBy.value));
    							var disciplinaryactionDocGrid = $this.getDisciplinaryactiondocumentgrid();
    							var store = disciplinaryactionDocGrid.getStore();
    							store.add(documentModel);
    							if (disciplinaryactionDocGrid.isHidden() && store.data.items.length > 0) {
    								disciplinaryactionDocGrid.setVisible(true);
    							}
    							$this.getDocumentController().closeDocumentFormWindow();
  							   showSuccessMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION'),getPersonModuleTranslation('DISCIPLINARY_ACTION_DOCUMENT_ADD_SUCCESSFULLY'));
    						}, isTransient);
    			}
    		},
    		'documentformwindow[itemId=faculty_disciplinary_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
    			click : function() {
    				this.getDocumentController()
    				.closeDocumentFormWindow();
    			}
    		},
    		
    		'disciplinaryactionform[itemId=facultyDisciplinaryActionForm] button#uploadDisciplinaryItemId' : {
    			click : function() {
    				this
    				.getDocumentController()
    				.showDocumentFormWindow(
    						'faculty_disciplinary_hidden_field',
    						'DOCUMENT');
    			}
    		},
  		   
    		'disciplinaryactionform[itemId=facultyDisciplinaryActionForm] disciplinaryactiondocumentgrid button#btnDelete' : {
    			click : function() {
    				var $this = this;
    				var grid = $this.getDisciplinaryactiondocumentgrid();
    				if (grid.getSelectionModel().getCount() > 0) {
    					Ext.MessageBox.confirm(getCommonTranslation('DISCIPLINARY_ACTION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn,text) {
    						if (btn == 'yes') {
    							var store = grid.getStore();
    							var record = grid.getSelectionModel().getSelection()[0];
    							var id = record.get("id");
    							if (!isNullOrEmpty(id)) {
    								Ext.Ajax.request({
    									method : "DELETE",
    									type : 'rest',
    									url : SERVERURL.COURSE_DOCUMENT_DELETE_DOCUMENT_URL + '?id=' + id,
    									headers : {
    										'Content-Type' : 'application/json'
    									},
    									success : function(form,action) {store.reload();
    									showSuccessMessage(getCommonTranslation('DISCIPLINARY_ACTION'), getCommonTranslation('DOCUMENT_SUCCESS_MSG'));}
    								});
    							} else {
    								if (record) {
    									store.remove(record);
    									showSuccessMessage(getCommonTranslation('DISCIPLINARY_ACTION'), getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
    								}
    							}
    						}
    					});
    				} else {
    					showWarningMessage(getCommonTranslation('DISCIPLINARY_ACTION'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
    				}
    			}
    		},
    		'disciplinaryactionform[itemId=facultyDisciplinaryActionForm] disciplinaryactiondocumentgrid' : {
    			cellclick : function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				var $this = this;
    				var documentGrid = $this.getDisciplinaryactiondocumentgrid();
    				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

    				if (columnName == "documentName") {
    					if (e.target.tagName == 'A') {
    						var documentId = record.get("documentId");
    						if (!isNullOrEmpty(documentId)) {
    							$this.getDocumentController().downloadDocumentFile(documentId);
    						}
    					}
    				}
    			}
    		},
            'disciplinaryactiongrid[itemId=facultyDisciplinaryActionGrid] button[itemId=btnAdd]': {
                click: function() {
                	var me=this;
                	me.showPersonCommonWindow('DISCIPLINARY_ACTION', 'facultyDisciplinaryActionForm');
                	me.setReporterForDisciplinaryAction(false);
                }
            },
            'disciplinaryactiongrid[itemId=facultyDisciplinaryActionGrid] button[itemId=btnEdit]': {
            	click: function(){
            		this.editDisciplinaryActionFormWindow('DISCIPLINARY_ACTION', 'facultyDisciplinaryActionForm', '#facultyDisciplinaryActionGrid');
            		this.setReporterForDisciplinaryAction(true);
            	}
            },
            'disciplinaryactiongrid[itemId=facultyDisciplinaryActionGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewDisciplinaryActionFormWindow('DISCIPLINARY_ACTION', 'facultyDisciplinaryActionForm', '#facultyDisciplinaryActionGrid');
            	}
            },
            'disciplinaryactiongrid[itemId=facultyDisciplinaryActionGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteDisciplinaryActionRecord('#facultyDisciplinaryActionGrid', SERVERURL.DISCIPLINARY_ACTION_DELETE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] disciplinaryactionform[itemId=facultyDisciplinaryActionForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.saveDisciplinaryAction('#facultyDisciplinaryActionGrid', SERVERURL.DISCIPLINARY_ACTION_ADD, SERVERURL.DISCIPLINARY_ACTION_UPDATE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] disciplinaryactionform[itemId=facultyDisciplinaryActionForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },
            
            'personcommonwindow[itemId=personCommonWindow] disciplinaryactionform[itemId=facultyDisciplinaryActionForm] customcombobox[itemId=reportedByUserIdField]': {
            	select : function(combo, records, eOpts){
                	this.validateDisciplinaryReportedIdField(combo, records, eOpts);
                }
            },
            
                     
            	/**
             *  Positive Action
             */

            'positiveincidentgrid[itemId= facultyPositiveIncidentGrid]': {
                render: function(grid) {
                    this.loadGridStore('#facultyPositiveIncidentGrid', SERVERURL.POSITIVE_INCIDENT_GRIDDATA);
                    var portalId = this.getCurrentLoggedPortalId();
            		if (portalId == 1){
            			this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_POSITIVE_INCIDENTS_PERMISSIONS());
            		} else if (portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_POSITIVE_INCIDENTS_PERMISSIONS());
            		}
                },
                afterrender : function(grid){
                	this.loadGridStore('#facultyPositiveIncidentGrid', SERVERURL.POSITIVE_INCIDENT_GRIDDATA);
                	if(this.getCurrentLoggedPortalId() == 2){
                		grid.down('#btnAdd').hide();
                		grid.down('#btnDelete').hide();
                	}
                }
            },
            'positiveincidentgrid[itemId=facultyPositiveIncidentGrid]':{
  			   cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
  				   var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
//  				   var documentId = record.data.document.id;
  				   if(columnName == "documents"){
           			   if(e.target.tagName=='A'){
           				  if(record.data.documents.length == 1){
           			    	var whetherFile = false;
           			    	var documentId= record.data.documents["0"].id;
           			    	if(!isNullOrEmpty(documentId)){
           			    	Ext.Ajax.request({
           			            type: 'rest',
           			            url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
           			            method: 'GET',
           			            callback : function(opt, success, response){
           			            	if(response.responseText == 'true') {
           			            		var csvForm = Ext.create('Ext.form.Panel'); 
           			        	    	csvForm.getForm().submit({
           			        		    	target: '_blank',
           			        		    	method:'GET',
           			        		    	params :{
           			        		    		access_token : Ext.Ajax.defaultHeaders.access_token
           			        		    	},
           			        		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
           			        		    	url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
           			        		    	standardSubmit :true
           			        	    	});
           			            	} else {
           			            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
           			            	}
           			            }
           			         });
           			    	}} else if(record.data.documents.length > 1){
           					  var docWindow = this.getPositiveincidentdocumentlist();
           					  var ID = record.data.id;
           					  if (!docWindow) {
           						  Ext.widget('positiveincidentdocumentlist');
           						  docWindow = Ext.widget('positiveincidentdocumentlist',{
           							  itemId:'facultyPositiveIncidentReportDocument'
           						  });
           						  docWindow = this.getPositiveincidentdocumentlist();
           					  }
           					  docWindow.show();
           					  docWindow.down('form').down('#incidentDate').setValue(dateRender(record.data.incidentDate));
           					  docWindow.down('form').down('#type').setValue(record.data.type.value);
           					  docWindow.down('form').down('#actionTaken').setValue(record.data.actionTaken);
           					  var positiveincidentdocumentlistgrid = docWindow.down('#positiveincidentdocumentlistgridItemId');
           					  positiveincidentdocumentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
           					  var portalId = this.getCurrentLoggedPortalId();
           					  if(portalId == 3) {
           						  docWindow.down("#btnDelete").setVisible(false);
           					  }
           					  var store = positiveincidentdocumentlistgrid.getStore();
           					  store.getProxy().extraParams = {
           						  ID: record.data.id
           					  };
           					  store.load();
           					  // var a = Ext.ComponentQuery.query('positiveincidentgrid')[0];
           					  this.doAccessStudentPositiveIncidentGridDeleteButton(positiveincidentdocumentlistgrid, this.getFACULTY_POSITIVE_INCIDENTS_PERMISSIONS(),ID);
           				  }
           			   }
  				   }
  				   
  			   }
  		   },
  		 /*  'positiveincidentdocumentlistgrid[itemId=positiveincidentdocumentlistgridItemId]':{
				 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
 				 if(columnName == "documentName"){
 					 if(e.target.tagName=='A'){
 						 this.getDownloadFile(record.get('documentId'));
 					 }
 				 }
 			 }
 		 },*/
       	 'positiveincidentdocumentlist[itemId=facultyPositiveIncidentReportDocument] button[itemId=btnDelete]':{
				click:function(obj){
					this.deleteIncidentDocument();
				}
     	 },
         
        'positiveincidentdocumentlist[itemId=facultyPositiveIncidentReportDocument] positiveincidentdocumentlistgrid button[itemId=downloadDocumentItemId]':{
				click:function(obj){
					this.incidentDocumentReportDocumentZip();
				}
     	 },
     	
     	/* 'positiveincidentdocumentlistgrid button[itemId=btnDelete]':{
				click:function(obj){
					this.deleteDocument();
				}
      	 },*/
          'positiveincidentdocumentlist grid[itemId=periodGridWin]':{
 			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
 				 if(columnName == "documentName"){
 					 if(e.target.tagName=='A'){
 						 this.getDownloadFile(record.get('documentId'));
 					 }
 				 }
 			 }
 		 },
            'documentformwindow[itemId= faculty_positive_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
    			click : function() {
    				var $this = this;
    				var isTransient = true;
    				var module = 'positiveIncident';
    				var entityId;
    				var entityType = 'positiveIncidentDocument';

    				$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
    						function(success,response,isCallBackTransient) {
    							var documentModel = new Academia.model.personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentModel();
    							documentModel.set("documentName",response.name);
    							documentModel.set("path",response.path);
    							documentModel.set("type",response.type);
    							documentModel.set("documentName",response.name);
    							documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
    							var positiveincidentDocGrid = $this.getPositiveincidentdocumentgrid();
    							if(!positiveincidentDocGrid) {
    								positiveincidentDocGrid = Ext.widget('positiveincidentdocumentgrid');
    							}
    							var store = positiveincidentDocGrid.getStore();
    							store.add(documentModel);
    							if (positiveincidentDocGrid.isHidden() && store.data.items.length > 0) {
    								positiveincidentDocGrid.setVisible(true);
    							}
    							$this.getDocumentController().closeDocumentFormWindow();
    							showSuccessMessage(getPersonModuleTranslation('POSITIVE_INCIDENT'),getPersonModuleTranslation('POSITIVE_INCIDENT_DOCUMENT_ADD_SUCCESSFULLY'));
    						}, isTransient);
    			}
    		},
    		'documentformwindow[itemId=faculty_positive_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
    			click : function() {
    				this.getDocumentController()
    				.closeDocumentFormWindow();
    			}
    		},
            'positiveincidentform[itemId=facultyPositiveIncidentForm] button#uploadPositiveIncidentItemId' : {
    			click : function() {
    				this.getDocumentController().showDocumentFormWindow('faculty_positive_hidden_field','DOCUMENT');
    			}
    		},
        	'positiveincidentdocumentgrid button#btnDelete' : {
    			click : function() {
    				var $this = this;
    				if($this.getContentPanelActiveTab().xtype!='studentprofile'){
    					var grid = $this
        				.getPositiveincidentdocumentgrid();
        				if (grid.getSelectionModel()
        						.getCount() > 0) {
        					Ext.MessageBox
        					.confirm(
        							getCommonTranslation('INCIDENT'),
        							getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
        							function(btn,
        									text) {
        								if (btn == 'yes') {
        									var store = grid.getStore();
        									var record = grid.getSelectionModel().getSelection()[0];
        									var id = record.get("id");
        									 if (!isNullOrEmpty(id)) {
        										 Ext.Ajax
             									.request({
             										method : "DELETE",
             										type : 'rest',
             										url : SERVERURL.COURSE_DOCUMENT_DELETE_DOCUMENT_URL
             										+ '?id='
             										+ id,
             										headers : {
             											'Content-Type' : 'application/json'
             										},
             										success : function(
             												form,
             												action) {
             											store.reload();
             											showSuccessMessage(
             													getCommonTranslation('INCIDENT'),
             													getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
             										}
             									});
        									 }else{
        										 if (record) {
        	                 							store.remove(record);
        	                 						showSuccessMessage(
        	                 							getCommonTranslation('INCIDENT'),
    													   getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
        	                 						}
        									 }
        									
        								}
        							});
        				} else {
        					showWarningMessage(
        							getCommonTranslation('INCIDENT'),
        							getCommonTranslation('PLEASE_SELECT_RECORD')); 
        				}
    				}
    				
    			}
    		},
    		'positiveincidentdocumentgrid' : {
    			cellclick : function(grid, td,
    					cellIndex, record, tr,
    					rowIndex, e, eOpts) {
    				var $this = this;
    				var documentGrid = $this
    				.getPositiveincidentdocumentgrid();
    				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

    				if (columnName == "documentName") {
    					if (e.target.tagName == 'A') {
    						var documentId = record
    						.get("documentId");
    						if (!isNullOrEmpty(documentId)) {
    							$this
    							.getDocumentController()
    							.downloadDocumentFile(
    									documentId);
    						}
    					}
    				}
    			}
    		},
            'positiveincidentgrid[itemId=facultyPositiveIncidentGrid] button[itemId=btnAdd]': {
                click: function() {
                	var me=this;
                	me.showPersonCommonWindow('POSITIVE_INCIDENT', 'facultyPositiveIncidentForm');
                    me.setReporterForPosstiveDisciplinaryActions(false);
                }
            },
            'positiveincidentgrid[itemId=facultyPositiveIncidentGrid] button[itemId=btnEdit]': {
            	click: function(){
            		var  me=this;
            		this.editPositiveActionFormWindow('POSITIVE_INCIDENT', 'facultyPositiveIncidentForm', '#facultyPositiveIncidentGrid');
            		 me.setReporterForPosstiveDisciplinaryActions(true);
            	}
            },
            'positiveincidentgrid[itemId=facultyPositiveIncidentGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewPositiveActionFormWindow('POSITIVE_INCIDENT', 'facultyPositiveIncidentForm', '#facultyPositiveIncidentGrid');
            		
            	}
            },
            'positiveincidentgrid[itemId=facultyPositiveIncidentGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deletePositiveActionRecord('#facultyPositiveIncidentGrid', SERVERURL.POSITIVE_INCIDENT_ACTION_DELETE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] positiveincidentform[itemId=facultyPositiveIncidentForm] combo[itemId=reportedByField]': {
                select: function(combo) {
                    this.showHidePositiveReportedField(combo);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] positiveincidentform[itemId=facultyPositiveIncidentForm] nestedJsonCombo[itemId=typeOfIncidentCombo]': {
            	beforerender : function(combo){
            		combo.store.proxy.extraParams = {
            				category: 'POSITIVE'
            				
                    };
                }
            },
            'personcommonwindow[itemId=personCommonWindow] positiveincidentform[itemId=facultyPositiveIncidentForm] customcombobox[itemId=reportedByUserIdField]': {
            	select : function(combo, records, eOpts){
                	this.validatePositiveReportedIdField(combo, records, eOpts);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] positiveincidentform[itemId=facultyPositiveIncidentForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.savePositiveAction('#facultyPositiveIncidentGrid', SERVERURL.INCIDENT_ACTION_ADD, SERVERURL.INCIDENT_ACTION_UPDATE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] positiveincidentform[itemId=facultyPositiveIncidentForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },
            /**
             * Negative Action
             */
            'negativeincidentgrid[itemId=facultyNegativeIncidentGrid]': {
                render: function(grid) {
                	this.loadGridStore('#facultyNegativeIncidentGrid', SERVERURL.NEGATIVE_INCIDENT_GRIDDATA);
                	this.doAccessControlValidation(grid, this.getFACULTY_NEGATIVE_INCIDENTS_PERMISSIONS());
                }
            },
            'negativeincidentgrid[itemId=facultyNegativeIncidentGrid] button[itemId=btnAdd]': {
            	click: function() {
                    this.showPersonCommonWindow('NEGATIVE_INCIDENTS', 'facultyNegativeIncidentForm');
                }
            },
            'negativeincidentgrid[itemId=facultyNegativeIncidentGrid] button[itemId=btnEdit]': {
            	click: function(){
            		this.editNegativeActionFormWindow('NEGATIVE_INCIDENTS', 'facultyNegativeIncidentForm', '#facultyNegativeIncidentGrid');
            	}
            },
            'negativeincidentgrid[itemId=facultyNegativeIncidentGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewNegativeActionFormWindow('NEGATIVE_INCIDENTS', 'facultyNegativeIncidentForm', '#facultyNegativeIncidentGrid');
            	}
            },
            'negativeincidentgrid[itemId=facultyNegativeIncidentGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteNegativeActionRecord('#facultyNegativeIncidentGrid', SERVERURL.INCIDENT_ACTION_DELETE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=facultyNegativeIncidentForm] combo[itemId=reportedByField]': {
                select: function(combo) {
                    this.showHideNegativeReportedField(combo);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=facultyNegativeIncidentForm] livesearchcombo[itemId=reportedByUserIdField]': {
            	select : function(combo, records, eOpts){
                	this.validateNegativeReportedIdField(combo, records, eOpts);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=facultyNegativeIncidentForm] nestedJsonCombo[itemId=typeOfIncidentCombo]': {
            	beforerender : function(combo){
            		combo.store.proxy.extraParams = {
            				category: 'NEGATIVE'
                    };
                }
            },
            'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=facultyNegativeIncidentForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.saveNegativeAction('#facultyNegativeIncidentGrid', SERVERURL.INCIDENT_ACTION_ADD, SERVERURL.INCIDENT_ACTION_UPDATE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=facultyNegativeIncidentForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            }

        });
    }, 
    getDocumentController : function() {
    	var this$ = this;
    	return this$
    	.getController('Academia.controller.document.DocumentController');
    },
    
    doAccessStudentDAGridDeleteButton: function(grid, privilegesMap, recordId) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);

        var btnDelete = grid.down('#btnDelete');
        btnDelete.setVisible(false);
        
        var loggedInUserId = this.getCurrentlyLoggedInUser().id;
        var portalId = this.getCurrentLoggedPortalId();
        Ext.each(permissionList, function(privilege) {
        	if(portalId == 1){
        		if(privilege == 'PF_DOCUMENT_DELETE') {
        			btnDelete.setVisible(true);
        		}
        	}else if(portalId == 2){
        		if (privilege == 'FP_DOCUMENT_DELETE') {
        			if(portalId == 2 && loggedInUserId == recordId) {
        				btnDelete.setVisible(false);
        			} else {
        				btnDelete.setVisible(true);
        			}
        		} 
        	}
        });
    },
    doAccessStudentPositiveIncidentGridDeleteButton: function(grid, privilegesMap,recordId) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);

        var btnDelete = grid.down('#btnDelete');
        btnDelete.setVisible(false);
        
        var loggedInUserId = this.getCurrentlyLoggedInUser().id;
        var portalId = this.getCurrentLoggedPortalId();
        Ext.each(permissionList, function(privilege) {
        	if(portalId == 1) {
        		if(privilege == 'PF_PI_DOC_DELETE') {
        			btnDelete.setVisible(true);
        		}
        	} else if(portalId == 2) {
        		if (privilege == 'FP_PI_DOC_DELETE') {
        			if(loggedInUserId == recordId) {
        				btnDelete.setVisible(false);
        			} else {
        				btnDelete.setVisible(true);
        			}
        		} 
        	}
        });
    },
    
    setReporterForDisciplinaryAction : function(isEdit) {
		var me = this;
		var userId = me.getCurrentlyLoggedInUser().id;
		var Name = me.getCurrentlyLoggedInUser().value;
		var form = me.getPersonDisciplinaryActionForm();
		var RepoertId = form.down('#reportedByUserIdField');
		var RepoertName = form.down('#reportedByUserNameField');
		var Repoerter = RepoertId.getStore();
		var grid = me.getDisciplinaryactiongrid();
		var gridData = grid.getSelectionModel().getSelection();

		if(gridData!=undefined && isEdit &&grid.getSelectionModel().getCount()>0){
			var reporterUserId = gridData[0].data.reportedByUser.id;
			Repoerter.load({
				callback: function(rec, callback,response) {
					var index = RepoertId.getStore();
					rec.forEach(function(obj){
						if(obj.data.id == reporterUserId){
							RepoertId.setValue(reporterUserId);
							RepoertName.setValue(obj.data.value);
						}
					});
				}
			});

		}else{
			Repoerter.load({
				callback: function(rec, callback,response) {
					var index = RepoertId.getStore();
					RepoertId.setValue(userId);
					RepoertName.setValue(Name);
				}
			});
		}
	},
	setReporterForPosstiveDisciplinaryActions : function(isEdit) {
		var me = this;
		var userId = me.getCurrentlyLoggedInUser().id;
		var Name = me.getCurrentlyLoggedInUser().value;
		var form = me.getPersonPositiveIncidentForm();
		var RepoertId = form.down('#reportedByUserIdField');
		var RepoertName = form.down('#reportedByUserNameField');
		var Repoerter = RepoertId.getStore();
		var grid = me.getPositiveincidentgrid();
		var gridData = grid.getSelectionModel().getSelection();

		if(gridData!=undefined && isEdit &&grid.getSelectionModel().getCount()>0){
			var reporterUserId = gridData[0].data.reportedByUserId;
			Repoerter.load({
				callback: function(rec, callback,response) {
					var index = RepoertId.getStore();
					rec.forEach(function(obj){
						if(obj.data.id == reporterUserId){
							RepoertId.setValue(reporterUserId);
							RepoertName.setValue(obj.data.value);
						}
					});
				}
			});

		}else{
			Repoerter.load({
				callback: function(rec, callback,response) {
					var index = RepoertId.getStore();
					RepoertId.setValue(userId);
					RepoertName.setValue(Name);
				}
			});
		}
	}
   
});
