/**
 * @author Sachin.Bangar
 * This controller is used for faculty past history information actions.   
 */
Ext.define('Academia.controller.personinfo.faculty.FacultyPastHistoryController', {
    extend: 'Academia.controller.personinfo.common.PersonPastHistoryController',
    mixins : {
		AddressController : 'Academia.controller.organization.AddressController'
	},

    alias: "widget.facultypasthistorycontroller",
    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personEducationForm',
        selector: 'educationform[itemId=facultyEducationForm]'
    }, {
        ref: 'personWorkExperienceForm',
        selector: 'workexperienceform[itemId=facultyWorkExperienceForm]'
    }, {
        ref: 'personMedicalHistoryForm',
        selector: 'medicalhistoryform[itemId=facultyMedicalHistoryForm]'
    },{
        ref: 'personVaccinationForm',
        selector: 'vaccinationform[itemId=facultyVaccinationForm]'
    },{
        ref: 'personExtraCurricularForm',
        selector: 'extracurricularform[itemId=facultyExtraCurricularForm]'
    },{
        ref: 'personResearchTypeForm',
        selector: 'researchtypeform[itemId=facultyResearchTypeForm]'
    },{
        ref: 'personResearchTypeFormFacultyPortal',
        selector: 'researchtypeform[itemId=researchtypeformfacultyportal]'
    },{
        ref: 'personResearchDocumentViewForm',
        selector: 'researchdocumentviewform[itemId=facultyResearchDocumentViewForm]'
    },{
        ref: 'personSeminarDetailsForm',
        selector: 'seminardetailsform[itemId=facultySeminarDetailsForm]'
    },{
        ref: 'personSeminarDocumentViewForm',
        selector: 'seminardocumentviewform[itemId=facultySeminarDocumentViewForm]'
    },{
        ref: 'personPatentDetailsForm',
        selector: 'patentdetailsform[itemId=facultyPatentDetailsForm]'
    },{
        ref: 'personPatentDocumentViewForm',
        selector: 'patentdocumentviewform[itemId=facultyPatentDocumentViewForm]'
    },{
        ref: 'personTrainingDetailsForm',
        selector: 'persontrainingdetailsform[itemId=facultyPersonTrainingDetailsForm]'
    },{
        ref: 'personTrainingDocumentViewForm',
        selector: 'persontrainingdocumentviewform[itemId=facultyTrainingDocumentViewForm]'
    },{
    	ref: 'personCompetitiveExamForm',
        selector: 'competitiveexamform[itemId=facultyCompetitiveExamForm]'
    }/*,{
    	ref: 'transportpersondetailsgrid',
        selector: 'transportpersondetailsgrid[itemId=facultyTrainingPersonDetailsGrid]'
    }*/ ,{
        ref: 'personChurchInformationForm',
        selector: 'churchinformationform[itemId=facultyChurchInfoForm]'
    },{
    	ref:'churchemploymenthistorywindow',
    	selector:'churchemploymenthistorywindow'
    },{
		ref : 'simpledocumentform',
		selector : 'simpledocumentform'

	},{
		ref : 'employeevaccinationinfodocumentgrid',
		selector : 'employeevaccinationinfodocumentgrid'

	},{
		ref : 'employeevaccinationinfodocumentlist',
		selector : 'employeevaccinationinfodocumentlist'

	},{
		ref : 'employeevaccinationinfodocumentlistgrid',
		selector : 'employeevaccinationinfodocumentlistgrid'

	},{
		ref : 'vaccinationgridforapplicantfaculty',
		selector : 'vaccinationgridforapplicantfaculty[itemId=facultyVaccinationGrid]'
	},
	{
		ref : 'addressformwindow',
		selector : 'addressFormWindow[itemId=facultyTrainingAddressDetails]'
	}, 
	{
        ref: 'addressfieldsform',
        selector: 'addressFormWindow form[itemId=addressfieldsform]'
    },{
        ref: 'patentdetailssupervisorrwindow',
        selector: 'patentdetailssupervisorrwindow[itemId=studentpatentdetailssupervisorrwindow]'
    },{
        ref: 'employeeReferenceGrid',
        selector: 'employeeReferenceGrid'
    },{
        ref: 'employeereferenceform',
        selector: 'employeereferenceform'

    },{
        ref: 'employeereferenceformwindow',
        selector: 'employeereferenceformwindow'

    },{
        ref: 'facultynonacademicachievementsgrid',
        selector: 'facultynonacademicachievementsgrid'
    },{
        ref: 'facultynonacademicachievementsform',
        selector: 'facultynonacademicachievementsform'
    },{
        ref: 'employeephysicalcharacteristicsform',
        selector: 'employeephysicalcharacteristicsform'
    },{
        ref: 'employeephysicalcharacteristicsgrid',
        selector: 'employeephysicalcharacteristicsgrid'
    },{
    	ref:'employeeinsurancehistoryform',
    	selector:'employeeinsurancehistoryform'
    },{
    	ref:'physicalcharacteristicsform',
    	selector:'physicalcharacteristicsform'
    }],
    config: {
    	FACULTY_EDUCATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_EDUCATION_PRIVILEGES'),
    	FACULTY_WORK_EXPERIENCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_WORK_EXPERIENCE_PRIVILEGES'),
    	FACULTY_MEDICAL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_MEDICAL_PRIVILEGES'),
    	FACULTY_VACCINATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_VACCINATION_PRIVILEGES'),
    	FACULTY_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES'),
    	FACULTY_RESEARCH_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_RESEARCH_DETAILS_PRIVILEGES'),
    	FACULTY_SEMINAR_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_SEMINAR_DETAILS_PRIVILEGES'),
    	FACULTY_PATENT_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PATENT_DETAILS_PRIVILEGES'),
    	FACULTY_TRAINING_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_TRAINING_PRIVILEGES'),
    	FACULTY_COMPETITIVE_EXAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_COMPETITIVE_EXAM_PRIVILEGES'),
    	FACULTY_HOSTEL_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_HOSTEL_DETAILS_PRIVILEGES'),
    	FACULTY_TRANSPORT_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_TRANSPORT_DETAILS_PRIVILEGES'),
    	FACULTY_CHURCH_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_CHURCH_INFORMATION_PRIVILEGES'),
    	FACULTY_PROFILE_EDUCATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_EDUCATION_PRIVILEGES'),
    	FACULTY_PROFILE_WORK_EXPERIENCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_WORK_EXPERIENCE_PRIVILEGES'),
    	FACULTY_PROFILE_MEDICAL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_MEDICAL_PRIVILEGES'),
    	FACULTY_PROFILE_VACCINATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_VACCINATION_PRIVILEGES'),
    	FACULTY_PROFILE_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES'),
    	FACULTY_PROFILE_RESEARCH_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_RESEARCH_DETAILS_PRIVILEGES'),
    	FACULTY_PROFILE_SEMINAR_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_SEMINAR_DETAILS_PRIVILEGES'),
    	FACULTY_PROFILE_PATENT_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_PATENT_DETAILS_PRIVILEGES'),
    	FACULTY_PROFILE_TRAINING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_TRAINING_PRIVILEGES'),
    	FACULTY_PROFILE_HOSTEL_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_HOSTEL_DETAILS_PRIVILEGES'),
    	FACULTY_PROFILE_TRANSPORT_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_TRANSPORT_DETAILS_PRIVILEGES'),
    	FACULTY_PROFILE_COMPETITIVE_EXAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_COMPETITIVE_EXAM_PRIVILEGES'),
    	FACULTY_PROFILE_CHURCH_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_CHURCH_INFORMATION_PRIVILEGES'),
    	FACULTY_PROFILE_EMPLOYEE_REFERENCES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_REFERENCES_PRIVILEGES'),
    	FACULTY_REFERENCES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_REFERENCE_PRIVILEGES'),
    	FACULTY_PROFILE_CHURCH_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_CHURCH_INFORMATION_PRIVILEGES'),
    	FACULTY_PROFILE_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_NON_ACADEMIC_ACHIEVEMENTS_PRIVILEGES'),
    	FACULTY_PORTAL_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_NON_ACADEMIC_ACHIEVEMENTS_PRIVILEGES'),
    	FACULTY_PORTAL_PHYSICAL_CHARACTERISTICS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PHYSICAL_CHARACTERISTICS_PRIVILEGES'),
    	FACULTY_PHYSICAL_CHARACTERISTICS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_PHYSICAL_CHARACTERISTICS_PRIVILEGES'),
    	FACULTY_PROFILE_INSURANCE_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_INSURANCE_HISTORY_PRIVILEGES'),
    	FACULTY_PORTAL_INSURANCE_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_INSURANCE_HISTORY_PRIVILEGES'),
        FACULTY_QUALIFICATION_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_QUALIFICATION_DETAILS_PRIVILEGES'),
    },
    init: function(application) {
        this.control({
        	
        	
        	/**
        	 * Vaccination Document Details
        	 */
        	        	 
            'employeevaccinationinfodocumentgrid': {
                render: function(grid) {},
                cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	   				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
	   				 if(columnName == "documentName"){
	   					 if(e.target.tagName=='A'){
	   						 this.getDownloadFile(record.get('documentId'));
	   					 }
	   				 }
	   			}
            },
        	
        	/**
        	 * Education Details
        	 */

            'educationhistorygrid[itemId=facultyEducationHistoryGrid]': {
                render: function(grid) {
                	this.loadGridStore('#facultyEducationHistoryGrid', SERVERURL.EDUCATION_HISTORY_GRIDDATA, grid);
                	var portalId = this.getCurrentLoggedPortalId();
                	if(portalId == 2) {
                		this.doAccessControlValidation(grid, this.getFACULTY_EDUCATION_PERMISSIONS());
                	}
                	else if(portalId == 1){
                		this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_EDUCATION_PERMISSIONS());
                	}
                }
            },
            'educationhistorygrid[itemId=facultyEducationHistoryGrid] button[itemId=btnAdd]': {
            	click: function() {
                    this.showPersonCommonWindow('EDUCATION', 'facultyEducationForm');
                }
            },
            'educationhistorygrid[itemId=facultyEducationHistoryGrid] button[itemId=btnEdit]': {
                click: function(){
                	this.editEducationHistoryFormWindow('EDUCATION', 'facultyEducationForm', '#facultyEducationHistoryGrid');
                }
            },
            'educationhistorygrid[itemId=facultyEducationHistoryGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewEducationHistoryFormWindow('EDUCATION', 'facultyEducationForm', '#facultyEducationHistoryGrid');
            	}
            },
            'educationhistorygrid[itemId=facultyEducationHistoryGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteEducationHistoryRecord('#facultyEducationHistoryGrid', SERVERURL.EDUCATION_HISTORY_DELETE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] form[itemId=facultyEducationForm]': {
                afterrender: function() {
                    this.afterEducationFormRender();
                },
                /*validitychange: function() {
                    this.validateEducationForm();
                }*/
            },

            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] combo[itemId=isExistingStudent]': {
            	change: function(combo, records, eOpts) {
                    this.showHideStudentEnrollmentField(combo, combo.getValue());
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] combo[itemId=resultStatusId]': {
                change: function(combo, records, eOpts) {
                	this.shoHideMarksDeatilFields(combo, records, eOpts);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] combo[itemId=gradeMark]': {
                change: function(combo, records, eOpts) {
                	this.showHideGradeMarkFileds(combo, records, eOpts);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] combo[itemId=subject]': {
                select: function(combo, records, eOpts) {
                	var subject = combo.nextSibling();
                	var mk=subject.nextSibling();
                	var sub=subject.nextSibling().nextSibling().nextSibling().nextSibling();
                	subject.setDisabled(false);
                	sub.setDisabled(false);
                	mk.setDisabled(false);
                	if(subject){
                		subject.setDisabled(false);
                		sub.setDisabled(false);
                	    mk.setDisabled(false);
                	}
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] textfield[itemId=marks]': {
            blur: function(textfield, eOpts) { 
                	var num = textfield.getValue();
                	if(!isNaN(num)&&!isEmpty(num)){	
                	var number=Math.round(num*100)/100;
        	    	textfield.setValue(number); 
                   }
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.saveEducationHistory('#facultyEducationHistoryGrid', SERVERURL.EDUCATION_HISTORY_ADD, SERVERURL.EDUCATION_HISTORY_UPDATE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] combo[itemId=examBoard]': {
            	change: function(combo) {
            		var id = combo.getValue();
            		var examBoardOther = null;
            		var value = combo.getRawValue();
            		var window = this.getPersonEducationForm();
            		var educationForm = this.getPersonEducationForm().getForm();
            		var form =window.getForm();
            		if(value == 'Others'){
            			examBoardOther = true ;
            		}
            		else{
            			examBoardOther = false ; 
            		}
            		var subjectField =  form.findField("subject");
            		var store = subjectField.getStore();
            		if (window.items.items != null && window.items.items.length > 0) {
            			Ext.each(window.items.items, function(val) {
            				if(val.itemId =='subjectMarkPanel'){
            					Ext.each(val.items.items, function(valueSubject){
            						valueSubject.items.get('subject').reset();
            						valueSubject.items.get('marks').reset();
            					});

            				}
            			});
            		}
            		store.getProxy().extraParams = {
            			id:id ,
            			examBoardOther:examBoardOther
            		};
            		store.load();
            		if(value == 'Others'){
            			var window = this.getPersonEducationForm();
            			var educationForm = this.getPersonEducationForm().getForm();	
            			var form =window.getForm();
            			var ExamConducted =  form.findField("examConductedBy").setDisabled(false);
            			var examConduct = form.findField("examConductedBy");
            			examConduct.reset();
            		}
            		else{
            			var window = this.getPersonEducationForm();
            			var educationForm = this.getPersonEducationForm().getForm();	
            			var form =window.getForm();
            			var ExamConducted =  form.findField("examConductedBy").setDisabled(true);
            			var examConduct = form.findField("examConductedBy");
            			examConduct.reset();
            		}
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] combo[itemId=educationDepartmentId]': {
            	select: function(combo, records, eOpts) {
            		var window = this.getPersonEducationForm();
            		var educationForm = this.getPersonEducationForm().getForm();	
            		var form = window.getForm();
            		var value = combo.getValue();
            		var educationDepartmentIsOther = false;
            		var educationDepartmentId =null;
            		var campaignSchool = form.findField('campaignSchool');
            		var countryId = null;
      		  	    var countryRegionId = null;
      		  	    var cityId = null;

            		educationDepartmentId = combo.getValue();
            		form.findField('instituteName').reset();
            		form.findField('campaignSchool').reset();
            		form.findField('campaignSchool').setDisabled(false);
          			form.findField('campaignSchool').setDisabled(false);

            		if(campaignSchool.getRawValue()==='Others' || campaignSchool.getRawValue()==='Other'){
            			form.findField('instituteName').reset();
            			form.findField('instituteName').setDisabled(false);
            			educationForm.findField('instituteName').setVisible(true);
            			form.isValid();
            		}else{
            			form.findField('instituteName').reset();
            			form.findField('instituteName').setDisabled(true);
            			educationForm.findField('instituteName').setVisible(false);
            			form.isValid();
            		}

            		if(combo.getRawValue()==='Others' || combo.getRawValue()==='Other'){
            			educationDepartmentIsOther = true;
            		}
            		if(form.findField('country').getValue()!=undefined && !isNullOrEmpty(form.findField('country').getValue())){
          			  countryId = form.findField('country').getValue();
          		    }
          		    if(form.findField('countryRegion').getValue()!=undefined && !isNullOrEmpty(form.findField('countryRegion').getValue())){
          			  countryRegionId = form.findField('countryRegion').getValue();
          		    }
          		    if(form.findField('city').getValue()!=undefined && !isNullOrEmpty(form.findField('city').getValue())){
          			  cityId = form.findField('city').getValue();
          	   	    }
            		campaignSchool.getStore().getProxy().extraParams = {
            			educationDepartmentId: educationDepartmentId,
            			educationDepartmentIsOther:educationDepartmentIsOther,
            			isOthersSchoolReq:true,
            			countryId:countryId,
      		  		    countryRegionId:countryRegionId,
      		  		    cityId:cityId
            		};
            		campaignSchool.getStore().load();
            		window.getForm().checkValidity();
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] nestedJsonCombo[itemId=countryItemId]' : {
    			select:function(obj, record){
    				var this$ = this;
    				var form = this$.getPersonEducationForm();
    				var countryRegionComboBox = form.down('#countryRegionItemId');
    		    	var cityComboBox = form.down('#cityItemId');
    		    	var campaignSchool = form.down('#campaignSchoolId');
    		    	var educationDepartment = form.down('#educationDepartmentId');
    		    	var instituteName = form.down('#instituteNameId');
    		    	var educationDepartmentIsOther = false;
    		  		var educationDepartmentId =null;
    		  		  
    		        countryRegionComboBox.setDisabled(false);
    		        countryRegionComboBox.reset();
    		        cityComboBox.setDisabled(true);
    		        cityComboBox.reset();
    		        var countryId = record[0].get("id");
    		        
    		        var countryRegionStore = countryRegionComboBox.getStore();
    		        countryRegionStore.getProxy().extraParams = {
    		            cid: countryId
    		        };
    		        countryRegionStore.load();
    		        
    		        instituteName.reset();
    		        instituteName.setDisabled(true);
    		        instituteName.setVisible(false);
    		        campaignSchool.reset();
    		  		  
    		        if(educationDepartment.getValue() != undefined && !isNullOrEmpty(educationDepartment.getValue())) {
    		        	educationDepartmentId = educationDepartment.getValue();
    		        }
    		  		if(educationDepartment.getRawValue()==='Others' || educationDepartment.getRawValue()==='Other'){
    		  			educationDepartmentIsOther = true;
    		  		}
    		  		campaignSchool.getStore().getProxy().extraParams = {
    		  			educationDepartmentId: educationDepartmentId,
    		  			educationDepartmentIsOther:educationDepartmentIsOther,
    		  			isOthersSchoolReq:true,
    		  			countryId:countryId
    		  		};
    		  		campaignSchool.getStore().load();
    		  		form.getForm().checkValidity();
    			}
    		},
    		'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] nestedJsonCombo[itemId=countryRegionItemId]' : {
    			select:function(obj, record){
    				var this$ = this;
    				var form = this$.getPersonEducationForm();
    				var countryComboBox = form.down('#countryItemId');
    		    	var cityComboBox = form.down('#cityItemId');
    		    	var campaignSchool = form.down('#campaignSchoolId');
    		    	var educationDepartment = form.down('#educationDepartmentId');
    		    	var instituteName = form.down('#instituteNameId');
    		    	var educationDepartmentIsOther = false;
    		  		var educationDepartmentId =null;
    		  		var countryId = null;
    		  		  
    		        cityComboBox.setDisabled(false);
    		        cityComboBox.reset();
    		        var countryRegionId = record[0].get("id");
    		        
    		        var cityStore = cityComboBox.getStore();
    		        cityStore.getProxy().extraParams = {
    		        	id: countryRegionId
    		        };
    		        cityStore.load();
    		        
    		        instituteName.reset();
    		        instituteName.setDisabled(true);
    		        instituteName.setVisible(false);
    		        campaignSchool.reset();
    		  		 
    		        if(countryComboBox.getValue() != undefined && !isNullOrEmpty(countryComboBox.getValue())) {
    		        	countryId = countryComboBox.getValue();
    		        }
    		        if(educationDepartment.getValue() != undefined && !isNullOrEmpty(educationDepartment.getValue())) {
    		        	educationDepartmentId = educationDepartment.getValue();
    		        }
    		  		if(educationDepartment.getRawValue()==='Others' || educationDepartment.getRawValue()==='Other'){
    		  			educationDepartmentIsOther = true;
    		  		}
    		  		campaignSchool.getStore().getProxy().extraParams = {
    		  			educationDepartmentId: educationDepartmentId,
    		  			educationDepartmentIsOther:educationDepartmentIsOther,
    		  			isOthersSchoolReq:true,
    		  			countryId:countryId,
    		  			countryRegionId:countryRegionId
    		  		};
    		  		campaignSchool.getStore().load();
    		  		form.getForm().checkValidity();
    			}
    		},
    		'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] nestedJsonCombo[itemId=cityItemId]' : {
    			select:function(obj, record){
    				var this$ = this;
    				var form = this$.getPersonEducationForm();
    				var countryComboBox = form.down('#countryItemId');
    				var countryRegionComboBox = form.down('#countryRegionItemId');
    		    	var cityComboBox = form.down('#cityItemId');
    		    	var campaignSchool = form.down('#campaignSchoolId');
    		    	var educationDepartment = form.down('#educationDepartmentId');
    		    	var instituteName = form.down('#instituteNameId');
    		    	var educationDepartmentIsOther = false;
    		  		var educationDepartmentId =null;
    		  		var countryId = null;
    		  		var countryRegionId = null;
    		  		  
    		        cityComboBox.setDisabled(false);
    		        var cityId = record[0].get("id");
    		        
    		        instituteName.reset();
    		        instituteName.setDisabled(true);
    		        instituteName.setVisible(false);
    		        campaignSchool.reset();
    		  		  
    		        if(countryComboBox.getValue() != undefined && !isNullOrEmpty(countryComboBox.getValue())) {
    		        	countryId = countryComboBox.getValue();
    		        }
    		        if(countryRegionComboBox.getValue() != undefined && !isNullOrEmpty(countryRegionComboBox.getValue())) {
    		        	countryRegionId = countryRegionComboBox.getValue();
    		        }
    		        if(educationDepartment.getValue() != undefined && !isNullOrEmpty(educationDepartment.getValue())) {
    		        	educationDepartmentId = educationDepartment.getValue();
    		        }
    		  		if(educationDepartment.getRawValue()==='Others' || educationDepartment.getRawValue()==='Other'){
    		  			educationDepartmentIsOther = true;
    		  		}
    		  		campaignSchool.getStore().getProxy().extraParams = {
    		  			educationDepartmentId: educationDepartmentId,
    		  			educationDepartmentIsOther:educationDepartmentIsOther,
    		  			isOthersSchoolReq:true,
    		  			countryId:countryId,
    		  			countryRegionId:countryRegionId,
    		  			cityId:cityId
    		  		};
    		  		campaignSchool.getStore().load();
    		  		form.getForm().checkValidity();
    			}
    		},
    		'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] combo[itemId=campaignSchoolId]': {
          	  select: function(combo, records, eOpts) {
          		  var window = this.getPersonEducationForm();
          		  var educationForm = this.getPersonEducationForm().getForm();	
          		  var form =window.getForm();
          		  if(combo.getRawValue()==='Others' || combo.getRawValue()==='Other'){
          			  form.findField('instituteName').reset();
          			  form.findField('instituteName').setDisabled(false);
          			  educationForm.findField('instituteName').setVisible(true);
          			  form.isValid();
          		  }else{
          			  form.findField('instituteName').reset();
          			  form.findField('instituteName').setDisabled(true);
          			  educationForm.findField('instituteName').setVisible(false);
          			  form.isValid();
          		  }
          	  }
            },
        	/**
             *  Work Experience Details
             */
        	'workexperiencegrid[itemId=facultyWorkExperienceGrid]': {
                render: function(grid) {
                    this.loadGridStore('#facultyWorkExperienceGrid', SERVERURL.WORK_EXPERIENCE_GRIDDATA, grid);
                    var portalId = this.getCurrentLoggedPortalId();
                	if(portalId == 2) {
                		this.doAccessControlValidation(grid, this.getFACULTY_WORK_EXPERIENCE_PERMISSIONS());
                	}
                	else if(portalId == 1){
                		this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_WORK_EXPERIENCE_PERMISSIONS());
                	}
                }
            },
        	'workexperiencegrid[itemId=facultyWorkExperienceGrid] button[itemId=btnAdd]': {
        		click: function() {
                    this.showPersonCommonWindow('WORK_EXPERIENCE', 'facultyWorkExperienceForm');
                }
            },
            'workexperiencegrid[itemId=facultyWorkExperienceGrid] button[itemId=btnEdit]': {
            	click: function(){
            		this.editWorkExperienceFormWindow('WORK_EXPERIENCE', 'facultyWorkExperienceForm', '#facultyWorkExperienceGrid');
            	}
            },
            'workexperiencegrid[itemId=facultyWorkExperienceGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewWorkExperienceFormWindow('WORK_EXPERIENCE', 'facultyWorkExperienceForm', '#facultyWorkExperienceGrid');
            	}
            },
            'workexperiencegrid[itemId=facultyWorkExperienceGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteWorkExperienceRecord('#facultyWorkExperienceGrid', SERVERURL.WORK_EXPERIENCE_DELETE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=facultyWorkExperienceForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.saveWorkExperience('#facultyWorkExperienceGrid', SERVERURL.WORK_EXPERIENCE_ADD, SERVERURL.WORK_EXPERIENCE_UPDATE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=facultyWorkExperienceForm] datefield[itemId=dateOfJoining]': {
            	select: function(field, The, eOpts ){
            		this.calculateExperience(field);
            	}
            },
           
           'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=facultyWorkExperienceForm] datefield[itemId=exitDate]': {
        	   select: function(field, The, eOpts ){
        		   this.calculateExperience(field);
        	   }
           },
            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=facultyWorkExperienceForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },

            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=facultyWorkExperienceForm] radiogroup[itemId=currentOrgGroupId]': {
            	change: function(cb, nv, ov){

            		var form = this.getPersonWorkExperienceForm()
            		var datOfExit = form.down('#exitDate');
            		datOfExit.reset(); 
            		if(nv.whetherCurrentOrg){
            			datOfExit.setDisabled(true);
            		} else {
            			datOfExit.setDisabled(false);
            		}
            	}
            },
            
            /**
             *  Medical Details
             */

            'medicalgrid[itemId=facultyMedicalGrid]': {
                render: function(grid) {
                    this.loadGridStore('#facultyMedicalGrid', SERVERURL.MEDICAL_HISTORY_GRIDDATA, grid);
                    var portalId = this.getCurrentLoggedPortalId();
                	if(portalId == 2) {
                		this.doAccessControlValidation(grid, this.getFACULTY_MEDICAL_PERMISSIONS());
                	}
                	else if(portalId == 1){
                		this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_MEDICAL_PERMISSIONS());
                	}
                }
            },
            'medicalgrid[itemId=facultyMedicalGrid] button[itemId=btnAdd]': {
                click: function() {
                   var formWindow = this.showPersonCommonWindow('MEDICAL', 'facultyMedicalHistoryForm');
                   var form = formWindow.down('#facultyMedicalHistoryForm');
                   var countryFieldItemIDArray = ["#doctorTelephoneCountryCodeItemId"];
                   this.setDefaultCountryCode(form, countryFieldItemIDArray);
                   var countryCodeField = form.down("#doctorTelephoneCountryCodeItemId");
                   var mobileField = form.down("#doctorTelephoneNoItemId");
                   this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                  
                }
            },
            'medicalgrid[itemId=facultyMedicalGrid] button[itemId=btnEdit]': {
            	click: function(){
            		var form = this.editMedicalHistoryFormWindow('MEDICAL', 'facultyMedicalHistoryForm', '#facultyMedicalGrid');
            		if(!isNullOrEmpty(form)){
            			var countryFieldItemIDArray = ["#doctorTelephoneCountryCodeItemId"];
            			this.setDefaultCountryCode(form, countryFieldItemIDArray);
            			var countryCodeField = form.down("#doctorTelephoneCountryCodeItemId");
                        var mobileField = form.down("#doctorTelephoneNoItemId");
                        this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                       
            		}
            	}
            },
            'medicalgrid[itemId=facultyMedicalGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewMedicalHistoryFormWindow('MEDICAL', 'facultyMedicalHistoryForm', '#facultyMedicalGrid');
            	}
            },
            'medicalgrid[itemId=facultyMedicalGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteMedicalHistoryRecord('#facultyMedicalGrid', SERVERURL.MEDICAL_HISTORY_DELETE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] medicalhistoryform[itemId=facultyMedicalHistoryForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.saveMedicalHistory('#facultyMedicalGrid', SERVERURL.MEDICAL_HISTORY_ADD, SERVERURL.MEDICAL_HISTORY_UPDATE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] medicalhistoryform[itemId=facultyMedicalHistoryForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },
            
            /**
             *  Vaccination Details
             */

            
              'vaccinationgridforapplicantfaculty[itemId=facultyVaccinationGrid] button[itemId=btnAdd]': {
              	click: function() {
                  var form = this.showPersonCommonWindow('VACCINATION', 'facultyVaccinationForm');
                      form.down('#studentStatusItemId').setVisible(false);
                      this.processVaccinationInfoDetailsWindow('btnAdd');
                  }
              },
              'vaccinationgridforapplicantfaculty[itemId=facultyVaccinationGrid] button[itemId=btnEdit]': {
            	  click: function(){
            		  this.editVaccinationInfoFormWindow('VACCINATION', 'facultyVaccinationForm', '#facultyVaccinationGrid');
            		  var form =    this.showPersonCommonWindow('VACCINATION', 'applicantVaccinationForm');
                      form.down('#studentStatusItemId').setVisible(false);
            		  this.processVaccinationInfoDetailsWindow('btnEdit');
            	  }
              },
              'vaccinationgridforapplicantfaculty[itemId=facultyVaccinationGrid] button[itemId=btnView]': {
            	  click: function(){
        		  this.viewVaccinationInfoFormWindow('VACCINATION', 'facultyVaccinationForm', '#facultyVaccinationGrid');
        		  this.processVaccinationInfoDetailsWindow('btnView');
        		  var a = Ext.ComponentQuery.query("personcommonwindow");
        		  if( a != undefined & a.length > 0){
        			//  a[0].down("#cancelButtonId").setVisible(false);
        			  a[0].down("#studentStatusItemId").setVisible(false);
        			  a[0].down("#submitButtonId").setVisible(false);
        			  a[0].down("#uploadVaccinationItemId").setVisible(false);
        		  }
        		  var b = this.getEmployeevaccinationinfodocumentgrid();
        		  if(b != undefined){
        			b.down("#btnDelete").setVisible(false); 
        		  }
            	  }
              },
              'vaccinationgridforapplicantfaculty[itemId=facultyVaccinationGrid] button[itemId=btnDelete]': {
            	  click: function(){
            		  this.deleteVaccinationInfoRecord('#facultyVaccinationGrid', SERVERURL.VACCINATION_INFO_DELETE);
            	  }
              },
              'vaccinationgridforapplicantfaculty[itemId=facultyVaccinationGrid]':{   
            	  render: function(grid) {
            	  this.loadGridStore('#facultyVaccinationGrid', SERVERURL.VACCINATION_INFO_GRIDDATA, grid);
            		  var portalId = this.getCurrentLoggedPortalId();
            		  if(portalId == 2) {
            			  this.doAccessControlValidation(grid, this.getFACULTY_VACCINATION_PERMISSIONS());
            		  }
            		  else if(portalId == 1){
            			  this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_VACCINATION_PERMISSIONS());
            		  }
            	  },
	   			   cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
					   var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
	//				   var documentId = record.data.document.id;
					   if(columnName == "documents"){
	         			   if(e.target.tagName=='A'){
	         				  if(record.data.documents.length == 1){
	   						   var csvForm = Ext.create('Ext.form.Panel'); 
	   						   csvForm.getForm().submit({
	   							   target: '_blank',
	   							   method:'GET',
	   							   params :{
	   								   access_token : Ext.Ajax.defaultHeaders.access_token
	   							   },
	   							   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	   							   url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + record.data.documents["0"].id,
	   							   standardSubmit :true
	   						   });
	         				  } else if(record.data.documents.length > 1){
	         					  var docWindow = this.getEmployeevaccinationinfodocumentlist();
	         					  var ID = record.data.id;
	         					  if (!docWindow) {
	         						  Ext.widget('employeevaccinationinfodocumentlist');
	         						  docWindow = Ext.widget('employeevaccinationinfodocumentlist',{
	         							  itemId:'disciplinaryReportDocument'
	         						  });
	         						  docWindow = this.getEmployeevaccinationinfodocumentlist();
	         					  }
	         					  docWindow.show();
	        					  docWindow.down('form').down('#vaccinationNameItemId').setValue(record.data.name);
	        					  docWindow.down('form').down('#vaccinationDateItemId').setValue(dateRender(record.data.vaccinationDate));
	         					  var grid = docWindow.down('#employeevaccinationinfodocumentlistgridItemId');
	         					  grid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
	         					  var store = grid.getStore();
	         					  store.getProxy().extraParams = {
	         						  ID: record.data.id
	         					  };
	         					  var proxy = store.getProxy();
	         					  var newApi =  {read: SERVERURL.VACCINATION_INFO_DOCUMENT_FIND_BY_ID};
	         					  Ext.apply(proxy.api,newApi);
	         					  store.getProxy().url=SERVERURL.VACCINATION_INFO_DOCUMENT_FIND_BY_ID;
	         					  store.load();
	         				  }
	         			   }
					   }
				   }
			   },
			   'employeevaccinationinfodocumentlistgrid':{
		 			 
					 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	  				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
	  				 if(columnName == "documentName"){
	  					 if(e.target.tagName=='A'){
	  						 this.getDownloadFile(record.get('documentId'));
	  					 }
	  				 }
	  			 }
	  		 },
			'employeevaccinationinfodocumentgrid button#btnDelete' : {
				click : function() {
					var $this = this;
					var grid = $this
					.getEmployeevaccinationinfodocumentgrid();
					if (grid.getSelectionModel()
							.getCount() > 0) {
						Ext.MessageBox
						.confirm(
								getCommonTranslation('VACCINATION_INFO'),
								getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
								function(btn,
										text) {
									if (btn == 'yes') {
										var store = grid.getStore();
										var record = grid.getSelectionModel().getSelection()[0];
										var id = record.get("id");
										if (record) {
	                 							store.remove(record);
	                 						showSuccessMessage(
	                 							getCommonTranslation('VACCINATION_INFO'),
												   getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	                 					}
										
									}
								});
					} else {
						showWarningMessage(
								getCommonTranslation('VACCINATION_INFO'),
								getCommonTranslation('PLEASE_SELECT_RECORD')); 
					}
				}
			},
	  		'employeevaccinationinfodocumentlistgrid button[itemId=downloadDocumentItemId]':{
					click:function(obj){
						this.documentReportDocumentZip('employee');
					}
	    	 },
	    	 'employeevaccinationinfodocumentlistgrid button[itemId=btnDelete]':{
					click:function(obj){
						this.deleteVaccinationDocument('employee');
					}
	     	 },
              'personcommonwindow[itemId=personCommonWindow] vaccinationform[itemId=facultyVaccinationForm] button[itemId=submitButtonId]': {
            	  click: function(){
            		  this.saveVaccinationInfo('#facultyVaccinationGrid', SERVERURL.VACCINATION_INFO_ADD, SERVERURL.VACCINATION_INFO_UPDATE,'FACULTY');
            	  }
              },
              'personcommonwindow[itemId=personCommonWindow] vaccinationform[itemId=facultyVaccinationForm] button[itemId=cancelButtonId]': {
              	click: this.closePersonCommonWindow
              },  
              'personcommonwindow[itemId=personCommonWindow] vaccinationform[itemId=facultyVaccinationForm] button[itemId=uploadVaccinationItemId]' : {
      			click: function() {
      				this
      				.getDocumentController()
      				.showDocumentFormWindow(
      						'employee_vaccination_hidden_field',
      						'DOCUMENT');
      			}
          	   },
  	     	'documentformwindow[itemId=employee_vaccination_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
      			click : function() {
      				var $this = this;
      				var isTransient = true;
      				var module = 'vaccinationInfo';
      				var entityId;
      				var entityType = 'vaccinationInfoDocument';
      				$this
      				.getDocumentController()
      				.saveDocumentForm(
      						entityId,
      						module,
      						entityType,
      						'DOCUMENT',
      						function(success,
      								response,
      								isCallBackTransient) {
      							var documentModel = new Academia.model.personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentModel();        							        							
      							documentModel
      							.set(
      									"documentName",
      									response.name);
      							documentModel
      							.set(
      									"path",
      									response.path);
      							documentModel
      							.set(
      									"type",
      									response.type);
      							documentModel
      							.set(
      									"documentName",
      									response.name);
      							documentModel
      							.set(
      									"createdBy",
      									$this
      									.getIdValueJson(
      											response.createdBy.id,
      											response.createdBy.value));
      							var vaccinationInfoDocGrid = $this.getEmployeevaccinationinfodocumentgrid();
      							var store = vaccinationInfoDocGrid
      							.getStore();
      							store
      							.add(documentModel);
      							vaccinationInfoDocGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount());
      							if (vaccinationInfoDocGrid
      									.isHidden()
      									&& store.data.items.length > 0) {
      								vaccinationInfoDocGrid
      								.setVisible(true);
      							}
      							$this
      							.getDocumentController()
      							.closeDocumentFormWindow();
    							   showSuccessMessage(getCommonTranslation('VACCINATION_INFO'),getCommonTranslation('VACCINATION_INFO_DOCUMENT_ADD_SUCCESSFULLY'));
        					
      						}, isTransient);
      			}
      		},
      		'documentformwindow[itemId=employee_vaccination_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
      			click : function() {
      				this.getDocumentController()
      				.closeDocumentFormWindow();
      			}
      		},
              'personcommonwindow[itemId=personCommonWindow] vaccinationform[itemId=facultyVaccinationForm] button[itemId=cancelButtonId]': {
              	click: this.closePersonCommonWindow
              },
              
              
              'personcommonwindow[itemId=personCommonWindow] vaccinationform[itemId=facultyVaccinationForm]':{
            	  afterrender:function(form){
            		 var studentStatus = form.down('#studentStatusItemId');
                      studentStatus.setVisible(false);
                      studentStatus.allowBlank = true;
                      form.getForm().checkValidity();
            	  }
              },
              /**
               *  Extra Curricular Details
               */

              'extracurriculargrid[itemId=facultyExtraCurricularGrid]': {
            	  render: function(grid) {
            		  this.loadGridStore('#facultyExtraCurricularGrid', SERVERURL.EXTRA_CURRICULAR_GRIDDATA, grid);
            		  var portalId = this.getCurrentLoggedPortalId();
            		  if(portalId == 2) {
            			  this.doAccessControlValidation(grid, this.getFACULTY_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS());
            		  }
            		  else if(portalId == 1){
            			  this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS());
            		  }
            	  }
              },
              'extracurriculargrid[itemId=facultyExtraCurricularGrid] button[itemId=btnAdd]': {
            	  click: function() {
                      this.showPersonCommonWindow('EXTRA_CURRICULAR', 'facultyExtraCurricularForm');
                      this.extraCurricularActivityFormRender();
                  }
              },
              'extracurriculargrid[itemId=facultyExtraCurricularGrid] button[itemId=btnEdit]': {
            	  click: function(){
            		  this.editExtraCurricularFormWindow('EXTRA_CURRICULAR', 'facultyExtraCurricularForm', '#facultyExtraCurricularGrid');
            	  }
              },
              'extracurriculargrid[itemId=facultyExtraCurricularGrid] button[itemId=btnView]': {
            	  click: function(){
            		  this.viewExtraCurricularFormWindow('EXTRA_CURRICULAR', 'facultyExtraCurricularForm', '#facultyExtraCurricularGrid');
            	  }
              },
              'extracurriculargrid[itemId=facultyExtraCurricularGrid] button[itemId=btnDelete]': {
            	  click: function(){
            		  this.deleteExtraCurricularRecord('#facultyExtraCurricularGrid', SERVERURL.EXTRA_CURRICULAR_DELETE);
            	  }
              },
              'personcommonwindow[itemId=personCommonWindow] extracurricularform[itemId=facultyExtraCurricularForm] button[itemId=submitButtonId]': {
            	  click: function(){
            		  this.saveExtraCurricular('#facultyExtraCurricularGrid', SERVERURL.EXTRA_CURRICULAR_ADD, SERVERURL.EXTRA_CURRICULAR_UPDATE);
            	  }
              },
              'personcommonwindow[itemId=personCommonWindow] extracurricularform[itemId=facultyExtraCurricularForm] button[itemId=cancelButtonId]': {
            	  click: this.closePersonCommonWindow
              },
              /**
               *  Research Details 
               * 
               */
              'researchtypegrid[itemId=facultyResearchTypeGrid]': {
                  render: function(grid) {
                      this.loadGridStore('#facultyResearchTypeGrid', SERVERURL.FIND_ALL_PERSON_RESEARCH,grid);
                      var portalId = this.getCurrentLoggedPortalId();
            		  if(portalId == 2) {
            			  this.doAccessControlValidation(grid, this.getFACULTY_RESEARCH_DETAILS_PERMISSIONS());
            		  }
            		  else if(portalId == 1){
            			  this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_RESEARCH_DETAILS_PERMISSIONS());
            		  }
                  },
                  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

                	  var searchResultGrid =  grid.ownerCt;
                	  var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

                	  if(columnName=='noOfdocument'){
                		  if (e.target.tagName == 'A') {
                			  this.showPersonCommonWindow('RESEARCH_VIEW_DOCUMENT', 'facultyResearchDocumentViewForm');
                			  var form = this.getPersonResearchDocumentViewForm();
                			  var grid = form.down('#researchdocumentviewId');
                			  this.loadDocumnetGrid(record,grid);
                		  }
                	  }
                  }
              },
              'researchtypeform[itemId=facultyResearchTypeForm] radiogroup[itemId=whetherUCSubmittedId]':{
            	change:function(obj,rec){
            		this.onChangeIsucsubmmited(obj,rec);
            	}  
              },
              'researchtypeform[itemId=facultyResearchTypeForm] button[itemId=submitButtonId]':{
            	  click:function(){
            		  var personProfile = this.getContentPanelActiveTab();
            		  var grid = personProfile.down('#facultyResearchTypeGrid');
            		  var form = this.getPersonResearchTypeForm();
            		  this.saveResearchTypeDetails(grid,form, SERVERURL.CREATE_PERSON_RESEARCH,SERVERURL.UPDATE_PERSON_RESEARCH);
            	  }  
                },
                
                /**
                 * Reset of Research Type 
                 */
                'researchtypeform[itemId=facultyResearchTypeForm] button[itemId=cancelResetId]':{
              	  click:function(){              		  
              		  var form = this.getPersonResearchTypeForm().getForm();
              		  form.reset();
              	  }  
                }, 
                
                'researchtypeform[itemId=facultyResearchTypeForm] button[itemId=uploadDocItemId]':{
                	click : function() {
                		this.getDocumentController().showDocumentFormWindow('facultyResearchTypeForm','DOCUMENT');
                	}
                },
                'documentformwindow[itemId=facultyResearchTypeForm] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
              	  click : function() {
              		  var form = this.getPersonResearchTypeForm();
              		  var docGrid = form.down('#researchTypeDocument');
              		  var module = 'facultyResearchType';
              		  var entityType = 'facultyResearchType';
              		  this.pastHistroyTypeDoceSave(docGrid,module,entityType);
              	  }
        		},
        		'researchtypeform[itemId=facultyResearchTypeForm] researchtypedocument button#btnDelete' : {
          			click:function(obj){
          				this.deleteDocument(obj,SERVERURL.RESEARCH_TYPE_DOC_DELETE,'#facultyResearchTypeGrid');
          			}
          		},
        		 'researchtypeform[itemId=facultyResearchTypeForm] researchtypedocument': {
        			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
        				 var $this = this;
        				 var documentGrid =  grid.ownerCt;
        				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

        				 if (columnName == "documentName") {
        					 if (e.target.tagName == 'A') {
        						 var documentId = record.get("documentId");
        						 if (!isNullOrEmpty(documentId)) {
        							 $this.getDocumentController().downloadDocumentFile(documentId);
        						 }
        					 }
        				 }
        			 }
        		 },
              'researchtypegrid[itemId=facultyResearchTypeGrid] button[itemId=btnAdd]': {
            	  click: function() {
            		    personType='FACULTY',
            		    tabPanelTitle= 'RESEARCH_TYPE';
            	    	tabPanelItemId= 'facultyResearchTypeFormDetails';
            	    	tabPanelItemXtype = 'researchtypeform',
            	    	xtypeItemId = 'facultyResearchTypeForm',
            	    	//render = true,
            	    	defaultPanel= true;
            	    	if(this.getCurrentLoggedPortalId() == 2){
            	    		var contentpanel = this.getContentPanel();
            	    		var researchtypeformtab = Ext.widget('researchtypeform',{
            	    			itemId:'researchtypeformfacultyportal'
            	    		});
            	    		var tabName = getPersonModuleTranslation('RESEARCH_TYPE_PORTAL');
            	    		openTab(contentpanel, tabName, researchtypeformtab,CONSTANTS.MENU_COLOR_THREE);            	    		
            	    	}else{
            	    		this.showResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);	
            	    	}
//            		  
            	    	
            	    	 
                  }
              },
           'researchtypegrid[itemId=facultyResearchTypeGrid] button[itemId=btnEdit]': {
            	  click: function() {
            		    personType='FACULTY',
            		    tabPanelTitle= 'RESEARCH_TYPE';
            	    	tabPanelItemId= 'facultyResearchTypeFormDetails';
            	    	tabPanelItemXtype = 'researchtypeform',
            	    	xtypeItemId = 'facultyResearchTypeForm',
            	    	//render = true,
            	    	defaultPanel= true;
            	    	gridItemId ='#facultyResearchTypeGrid';
            	    	
            	    	if(this.getCurrentLoggedPortalId() == 2){
            	    		  var contentpanel = this.getContentPanel();
            	    		  var grid = contentpanel.down('#facultyResearchTypeGrid');
            	    		  this.editResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid);
            	    	}else{
            	    		var personProfile = this.getContentPanelActiveTab();
            	            var grid = personProfile.down(gridItemId);
            	    		this.editResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid);
            	    	}
                  }
              },
              'researchtypegrid[itemId=facultyResearchTypeGrid] button[itemId=btnView]': {
            	  click: function() {
            		    personType='FACULTY',
            		    tabPanelTitle= 'RESEARCH_TYPE';
            	    	tabPanelItemId= 'facultyResearchTypeFormDetails';
            	    	tabPanelItemXtype = 'researchtypeform',
            	    	xtypeItemId = 'facultyResearchTypeForm',
            	    	//render = true,
            	    	defaultPanel= true;
            	    	gridItemId ='#facultyResearchTypeGrid';
//            		  this.viewResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId);
            	    	if(this.getCurrentLoggedPortalId() == 2){
          	    		  var contentpanel = this.getContentPanel();
          	    		  var grid = contentpanel.down('#facultyResearchTypeGrid');
          	    		  this.viewResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid);
          	    	}else{
          	    		var personProfile = this.getContentPanelActiveTab();
          	            var grid = personProfile.down(gridItemId);
          	    		this.viewResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid);
          	    	}
                  }
              },
              'researchtypegrid[itemId=facultyResearchTypeGrid] button[itemId=btnDelete]': {
            	  click: function(){
            		  this.deleteResearchDetails('#facultyResearchTypeGrid', SERVERURL.DELETE_PERSON_RESEARCH);
            	  }
              },
              /**
         		 * Document Download on click of document count on grid
         		 */
      		 'researchdocumentviewform[itemId=facultyResearchDocumentViewForm] researchtypedocument': {
      			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
      				 var $this = this;
      				 var documentGrid =  grid.ownerCt;
      				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

      				 if (columnName == "documentName") {
      					 if (e.target.tagName == 'A') {
      						 var documentId = record.get("documentId");
      						 if (!isNullOrEmpty(documentId)) {
      							 $this.getDocumentController().downloadDocumentFile(documentId);
      						 }
      					 }
      				 }
      			 }
      		 },
      		 
      		 /**
              * researchtypeformfacultyportal
              * Save for faculty portal 
              */
      		 'researchtypeform[itemId=researchtypeformfacultyportal] radiogroup[itemId=whetherUCSubmittedId]':{
      			 change:function(obj,rec){
      				 this.onChangeIsucsubmmited(obj,rec);
      			 }  
      		 },
               'researchtypeform[itemId=researchtypeformfacultyportal] button[itemId=submitButtonId]':{
            	   click:function(){
            		   var contentpanel = this.getContentPanel();
            		   var grid = contentpanel.down('#facultyResearchTypeGrid');
            		   var form = this.getPersonResearchTypeFormFacultyPortal();
            		   this.saveResearchTypeDetails(grid,form,SERVERURL.CREATE_PERSON_RESEARCH,SERVERURL.UPDATE_PERSON_RESEARCH);
            	   },  

               },
               'researchtypeform[itemId=researchtypeformfacultyportal] button[itemId=uploadDocItemId]':{
            	   click : function() {
            		   this.getDocumentController().showDocumentFormWindow('researchtypeformfacultyportal','DOCUMENT');
            	   }
               },
               'documentformwindow[itemId=researchtypeformfacultyportal] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
             	  click : function() {
             		  var form = this.getPersonResearchTypeFormFacultyPortal();
             		  var docGrid = form.down('#researchTypeDocument');
             		  var module = 'facultyResearchType';
             		  var entityType = 'facultyResearchType';
             		  this.pastHistroyTypeDoceSave(docGrid,module,entityType);
             	  }
       		},
       		'researchtypeform[itemId=researchtypeformfacultyportal] researchtypedocument button#btnDelete' : {
         			click:function(obj){
         				this.deleteDocument(obj,SERVERURL.RESEARCH_TYPE_DOC_DELETE,'#facultyResearchTypeGrid');
         			}
         		},
       		 'researchtypeform[itemId=researchtypeformfacultyportal] researchtypedocument': {
       			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
       				 var $this = this;
       				 var documentGrid =  grid.ownerCt;
       				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

       				 if (columnName == "documentName") {
       					 if (e.target.tagName == 'A') {
       						 var documentId = record.get("documentId");
       						 if (!isNullOrEmpty(documentId)) {
       							 $this.getDocumentController().downloadDocumentFile(documentId);
       						 }
       					 }
       				 }
       			 }
       		 },
      		 
              /***
               *  Seminar Type
               *  
               */
              'seminardetailsgrid[itemId=facultySeminarDetailsGrid]': {
                  render: function(grid) {
                      this.loadGridStore('#facultySeminarDetailsGrid', SERVERURL.FIND_ALL_PERSON_SEMINAR, grid);
                      var portalId = this.getCurrentLoggedPortalId();
            		  if(portalId == 2) {
            			  this.doAccessControlValidation(grid, this.getFACULTY_SEMINAR_DETAILS_PERMISSIONS());
            		  }
            		  else if(portalId == 1){
            			  this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_SEMINAR_DETAILS_PERMISSIONS());
            		  }
                  },
                  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

                	  var searchResultGrid =  grid.ownerCt;
                	  var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

                	  if(columnName=='noOfdocument'){
                		  if (e.target.tagName == 'A') {
                			  this.showPersonCommonWindow('SEMINAR_VIEW_DOCUMENT', 'facultySeminarDocumentViewForm');
                			  var form = this.getPersonSeminarDocumentViewForm();
                			  var grid = form.down('#seminardocumentviewId');
                			  this.loadDocumnetGrid(record,grid);
                		  }
                	  }
                  }
              },
               'seminardetailsgrid[itemId=facultySeminarDetailsGrid] button[itemId=btnAdd]': {
             	  click: function() {
                       this.showPersonCommonWindow('SEMINAR_TYPE', 'facultySeminarDetailsForm');
                   }
               },
               'seminardetailsgrid[itemId=facultySeminarDetailsGrid] button[itemId=btnEdit]': {
              	  click: function() {
                        this.editSeminarType('SEMINAR_TYPE', 'facultySeminarDetailsForm', '#facultySeminarDetailsGrid');
                    }
                },
                'seminardetailsgrid[itemId=facultySeminarDetailsGrid] button[itemId=btnView]': {
              	  click: function(){
              		  this.viewSeminarType('SEMINAR_TYPE', 'facultySeminarDetailsForm', '#facultySeminarDetailsGrid');
              	  }
                },
                'seminardetailsgrid[itemId=facultySeminarDetailsGrid] button[itemId=btnDelete]': {
              	  click: function(){
              		  this.deleteSeminarType('#facultySeminarDetailsGrid', SERVERURL.SEMINAR_DELETE);
              	  }
                },
               'personcommonwindow[itemId=personCommonWindow] seminardetailsform[itemId=facultySeminarDetailsForm] button[itemId=submitButtonId]': {
             	  click: function(){
             		 var form = this.getPersonSeminarDetailsForm();
             		 var docGrid = form.down('#seminarTypeDocument');
             		  this.saveSeminarType('#facultySeminarDetailsGrid', SERVERURL.SEMINAR_CREATE, SERVERURL.SEMINAR_UPDATE,docGrid);
             	  }
               },  
               'personcommonwindow[itemId=personCommonWindow] seminardetailsform[itemId=facultySeminarDetailsForm] button[itemId=cancelButtonId]': {
             	  click: this.closePersonCommonWindow
               },
               'seminardetailsform[itemId=facultySeminarDetailsForm] button[itemId=uploadDocItemId]':{
            	   click : function() {
            		   this.getDocumentController().showDocumentFormWindow('facultySeminarDetailsForm','DOCUMENT');
            	   }
               },
               'documentformwindow[itemId=facultySeminarDetailsForm] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
              	  click : function() {
              		  var form = this.getPersonSeminarDetailsForm();
              		  var docGrid = form.down('#seminarTypeDocument');
              		  var module = 'facultySeminarType';
              		  var entityType = 'facultySeminarType';
              		  this.pastHistroyTypeDoceSave(docGrid,module,entityType);
              	  }
        		},
        		'seminardetailsform[itemId=facultySeminarDetailsForm] seminartypedocument button#btnDelete' : {
        			click:function(obj){
        				this.deleteDocument(obj,SERVERURL.SEMINAR_TYPE_DOC_DELETE,'#facultySeminarDetailsGrid');
        			}
        		},
        		'seminardetailsform[itemId=facultySeminarDetailsForm] seminartypedocument': {
        			cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
        				var $this = this;
        				var documentGrid =  grid.ownerCt;
        				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

        				if (columnName == "documentName") {
        					if (e.target.tagName == 'A') {
        						var documentId = record.get("documentId");
        						if (!isNullOrEmpty(documentId)) {
        							$this.getDocumentController().downloadDocumentFile(documentId);
        						}
        					}
        				}
        			}
        		},
        		'seminardetailsform[itemId=facultySeminarDetailsForm] datefield[itemId=fromDate]':{
             	   select : function() {
             		   this.DayCountbetweenDate();
             	   }
                },
                'seminardetailsform[itemId=facultySeminarDetailsForm] datefield[itemId=toDate]':{
             	   select : function() {
             		   this.DayCountbetweenDate();
             	   }
                },
        		/**
           		 * Document Download on click of document count on grid
           		 */
        		 'seminardocumentviewform[itemId=facultySeminarDocumentViewForm] seminartypedocument': {
        			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
        				 var $this = this;
        				 var documentGrid =  grid.ownerCt;
        				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

        				 if (columnName == "documentName") {
        					 if (e.target.tagName == 'A') {
        						 var documentId = record.get("documentId");
        						 if (!isNullOrEmpty(documentId)) {
        							 $this.getDocumentController().downloadDocumentFile(documentId);
        						 }
        					 }
        				 }
        			 }
        		 },
        		 
        		 /**
                 *  Patent Details
                 *  
                 */
                'patentdetailsgrid[itemId=facultyPatentDetailsGrid] ': {
                	render: function(grid) {
                		this.loadGridStore('#facultyPatentDetailsGrid', SERVERURL.PERSON_PATENT_GRID, grid);
                		var portalId = this.getCurrentLoggedPortalId();
                		if(portalId == 2) {
                			this.doAccessControlValidation(grid, this.getFACULTY_PATENT_DETAILS_PERMISSIONS());
                		}
                		else if(portalId == 1){
                			this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_PATENT_DETAILS_PERMISSIONS());
                			this.addDataGridConfigButton(grid,this.getFACULTY_PROFILE_PATENT_DETAILS_PERMISSIONS());
                		}
                	},
                    cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

                  	  var searchResultGrid =  grid.ownerCt;
                  	  var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

                  	  if(columnName=='noOfdocument'){
                  		  if (e.target.tagName == 'A') {
                  			  this.showPersonCommonWindow('PATENT_VIEW_DOCUMENT', 'facultyPatentDocumentViewForm');
                  			  var form = this.getPersonPatentDocumentViewForm();
                  			  var grid = form.down('#patentdocumentviewId');
                  			  this.loadDocumnetGrid(record,grid);
                  		  }
                  	  }
                  	 if(columnName=='supervisorId'){
  	              		  if (e.target.tagName == 'A') {
  	              			this.loadSupervisorGrid(record,grid);
  	                	}
  	              	  }
                    }
                }, 
                'patentdetailsgrid[itemId=facultyPatentDetailsGrid] button[itemId=btnAdd]': {
                	click: function(btn) {
                		this.showPersonCommonWindow('PATENT_TYPE', 'facultyPatentDetailsForm');
                		var formWindow = this.getPersonCommonWindow();
                		var facultyPatentDetailsForm = formWindow.down('patentdetailsform');
                		var patentTypeSMId = facultyPatentDetailsForm.down('#patentTypeSMId');
                		var personId= this.getPersonObj().id;
                		patentTypeSMId.getStore().getProxy().extraParams = {
                			patentTypeId: 0,
                			personId:personId
                		};
                		patentTypeSMId.getStore().load();
                	}
                },
                'patentdetailsgrid[itemId=facultyPatentDetailsGrid] button[itemId=btnEdit]': {
                	click: function(btn) {
                		this.editPatentType('PATENT_TYPE', 'facultyPatentDetailsForm', '#facultyPatentDetailsGrid');
                	}
                },
                'patentdetailsgrid[itemId=facultyPatentDetailsGrid] button[itemId=btnView]': {
                	click: function(){
                		this.viewPatentType('PATENT_TYPE', 'facultyPatentDetailsForm', '#facultyPatentDetailsGrid');
                	}
                },
                'patentdetailsgrid[itemId=facultyPatentDetailsGrid] button[itemId=btnDelete]': {
                	click: function(){
                		this.deletePatentType('#facultyPatentDetailsGrid', SERVERURL.DELETE_PATENT_TYPE);
                	}
                },
                'personcommonwindow[itemId=personCommonWindow] patentdetailsform[itemId=facultyPatentDetailsForm] button[itemId=submitButtonId]': {
                	click: function(){
                		var form = this.getPersonPatentDetailsForm();
              		    var docGrid = form.down('#patentTypeDocument');
                		this.savePatentType('#facultyPatentDetailsGrid', SERVERURL.SAVE_PATENT_TYPE, SERVERURL.UPDATE_PATENT_TYPE,docGrid);
                	}
                },
                'personcommonwindow[itemId=personCommonWindow] patentdetailsform[itemId=facultyPatentDetailsForm] button[itemId=cancelButtonId]': {
               	  click: this.closePersonCommonWindow
                 },
                'patentdetailsform[itemId=facultyPatentDetailsForm] button[itemId=uploadDocItemId]':{
                	click : function() {
                		this.getDocumentController().showDocumentFormWindow('facultyPatentDetailsForm','DOCUMENT');
                	}
                },
                'documentformwindow[itemId=facultyPatentDetailsForm] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
                	click : function() {
                		var form = this.getPersonPatentDetailsForm();
                		var docGrid = form.down('#patentTypeDocument');
                		var module = 'facultyPatentType';
                		var entityType = 'facultyPatentType';
                		this.pastHistroyTypeDoceSave(docGrid,module,entityType);
                	}
         		},
                'patentdetailsform[itemId=facultyPatentDetailsForm] patenttypedocument button#btnDelete' : {
           			click:function(obj){
           				this.deleteDocument(obj,SERVERURL.PATENT_TYPE_DOC_DELETE,'#facultyPatentDetailsGrid');
           			}
           		},
           		'patentdetailsform[itemId=facultyPatentDetailsForm] patenttypedocument': {
           			cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
           				var $this = this;
           				var documentGrid =  grid.ownerCt;
           				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

           				if (columnName == "documentName") {
           					if (e.target.tagName == 'A') {
           						var documentId = record.get("documentId");
           						if (!isNullOrEmpty(documentId)) {
           							$this.getDocumentController().downloadDocumentFile(documentId);
           						}
           					}
           				}
           			}
           		},
           		
           		/**
           		 * Document Download on click of document count on grid
           		 */
        		 'patentdocumentviewform[itemId=facultyPatentDocumentViewForm] patenttypedocument': {
        			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
        				 var $this = this;
        				 var documentGrid =  grid.ownerCt;
        				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

        				 if (columnName == "documentName") {
        					 if (e.target.tagName == 'A') {
        						 var documentId = record.get("documentId");
        						 if (!isNullOrEmpty(documentId)) {
        							 $this.getDocumentController().downloadDocumentFile(documentId);
        						 }
        					 }
        				 }
        			 }
        		 },
           		
           		/**
                 *  Training Details
                 *  
                 */
                'trainingpersondetailsgrid[itemId=facultyTrainingPersonDetailsGrid] ': {
                	render: function(grid) {
                		this.loadGridStore('#facultyTrainingPersonDetailsGrid', SERVERURL.PERSON_TRINING_GRID, grid);
                		var portalId = this.getCurrentLoggedPortalId();
                		if(portalId == 2) {
                			this.doAccessControlValidation(grid, this.getFACULTY_TRAINING_DETAILS_PERMISSIONS());
                		}
                		else if(portalId == 1){
                			this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_TRAINING_PERMISSIONS());
                		}
                	},
                    cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

                  	  var searchResultGrid =  grid.ownerCt;
                  	  var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

                  	  if(columnName=='noOfdocument'){
                  		  if (e.target.tagName == 'A') {
                  			  this.showPersonCommonWindow('TRAINING_VIEW_DOCUMENTS', 'facultyTrainingDocumentViewForm');
                  			  var form = this.getPersonTrainingDocumentViewForm();
                  			  var grid = form.down('#trainingdocumentviewId');
                  			  this.loadDocumnetGrid(record,grid);
                  		  }
                  	  }else{
                		if (e.target.tagName == 'A') {
    						this.manageCompanyAddressType(
    								grid, td, cellIndex,
    								record, tr, rowIndex,
    								e);
    					}
                  	  }
                    }
                }, 
                'trainingpersondetailsgrid[itemId=facultyTrainingPersonDetailsGrid] button[itemId=btnAdd]': {
                	click: function() {
                		//this.showPersonCommonWindow('TRAINING_DETAILS', 'facultyPersonTrainingDetailsForm');
                		personType='FACULTY',
            		    tabPanelTitle= 'TRAINING_DETAILS';
            	    	tabPanelItemId= 'facultyTrainingFormDetails';
            	    	tabPanelItemXtype = 'persontrainingdetailsform',
            	    	xtypeItemId = 'facultyPersonTrainingDetailsForm',
            	    	//render = true,
            	    	defaultPanel= true;
            	    	if(this.getCurrentLoggedPortalId() == 2){
            	    		var contentpanel = this.getContentPanel();
            	    		var trainingtypeformtab = Ext.widget('persontrainingdetailsform',{
            	    			//itemId:'persontrainingdetailsformfacultyportal'
            	    			itemId:'facultyPersonTrainingDetailsForm'
            	    		});
            	    		var tabName = getPersonModuleTranslation('TRAINING_TYPE_PORTAL');
            	    		openTab(contentpanel, tabName, trainingtypeformtab,CONSTANTS.MENU_COLOR_THREE);            	    		
            	    	}else{
            	    		this.showTrainingDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
            	    	}
            	    	var form = this.getPersonTrainingDetailsForm().getForm();
                		form.reset();
                	}
                },
                'trainingpersondetailsgrid[itemId=facultyTrainingPersonDetailsGrid] button[itemId=btnEdit]': {
                	click: function() {
                		//this.editTrainingType('TRAINING_DETAILS', 'facultyPersonTrainingDetailsForm', '#facultyTrainingPersonDetailsGrid');

                		//this.editTrainingType('TRAINING_DETAILS', 'studentPersonTrainingDetailsForm', '#studentTrainingPersonDetailsGrid');
                		personType='FACULTY',
            		    tabPanelTitle= 'TRAINING_DETAILS';
            	    	tabPanelItemId= 'facultyTrainingFormDetails';
            	    	tabPanelItemXtype = 'persontrainingdetailsform',
            	    	xtypeItemId = 'facultyPersonTrainingDetailsForm',
            	    	//render = true,
            	    	defaultPanel= true;
            	    	gridItemId ='#facultyTrainingPersonDetailsGrid';
            	    	if(this.getCurrentLoggedPortalId() == 2){
            	    		var contentpanel = this.getContentPanel();
            	    		var grid = contentpanel.down('#facultyTrainingPersonDetailsGrid');
            	    		//this.editTrainingDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid);
            	    		var tabPanelTitle = 'TRAINING_TYPE_PORTAL';
            	    		this.editTrainingDetailsModified(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid, CONSTANTS.MENU_COLOR_FIVE);
            	    	}else{
    	    	    		var personProfile = this.getContentPanelActiveTab();
    	    	            var grid = personProfile.down(gridItemId);
    	    	    		//this.editTrainingDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid);
    	    	    		this.editTrainingDetailsModified(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid, CONSTANTS.MENU_COLOR_FIVE);
    	    	    	}
                	
                	}
                },
                'trainingpersondetailsgrid[itemId=facultyTrainingPersonDetailsGrid] button[itemId=btnView]': {
                	click: function(){
                		//this.viewTrainingType('TRAINING_DETAILS', 'facultyPersonTrainingDetailsForm', '#facultyTrainingPersonDetailsGrid');

                		//this.viewTrainingType('TRAINING_DETAILS', 'studentPersonTrainingDetailsForm', '#studentTrainingPersonDetailsGrid');

                		personType='FACULTY',
            		    tabPanelTitle= 'TRAINING_DETAILS';
            	    	tabPanelItemId= 'facultyTrainingFormDetails';
            	    	tabPanelItemXtype = 'persontrainingdetailsform',
            	    	xtypeItemId = 'facultyPersonTrainingDetailsForm',
            	    	//render = true,
            	    	defaultPanel= true;
            	    	gridItemId ='#facultyTrainingPersonDetailsGrid';
            	    	if(this.getCurrentLoggedPortalId() == 2){
            	    		  var contentpanel = this.getContentPanel();
            	    		  var grid = contentpanel.down('#facultyTrainingPersonDetailsGrid');
            	    		  var tabPanelTitle = 'TRAINING_TYPE_PORTAL';
            	    		  this.viewTrainingDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid,CONSTANTS.MENU_COLOR_FIVE);
            	    	}else{
              	    		var personProfile = this.getContentPanelActiveTab();
              	            var grid = personProfile.down(gridItemId);
              	    		this.viewTrainingDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid,CONSTANTS.MENU_COLOR_FIVE);
              	    	}
                	
                	}
                },
                'trainingpersondetailsgrid[itemId=facultyTrainingPersonDetailsGrid] button[itemId=btnDelete]': {
                	click: function(){
                		this.deleteTrainingType('#facultyTrainingPersonDetailsGrid', SERVERURL.DELETE_TRAINING_DETAILS);
                	}
                },
                'persontrainingdetailsform[itemId=facultyPersonTrainingDetailsForm] button[itemId=submitButtonId]': {
                	click: function(){
                		/*var form = this.getPersonTrainingDetailsForm();
              		    var docGrid = form.down('#trainingTypeDocument');
                		this.saveTrainingType('#facultyTrainingPersonDetailsGrid', SERVERURL.CREATE_TRAINING_DETAILS, SERVERURL.UPDATE_TRAINING_DETAILS,docGrid);*/
                		
                		var form = this.getPersonTrainingDetailsForm();
              		    var docGrid = form.down('#trainingTypeDocument');
              		    
              		    var grid;
              		    if(this.getCurrentLoggedPortalId() == 2){
    	      	    		var contentpanel = this.getContentPanel();
    	      	    		grid = contentpanel.down('#facultyTrainingPersonDetailsGrid');
    	    	    	}else{
    	    	    		gridItemId ='#facultyTrainingPersonDetailsGrid';
    	    	    		var personProfile = this.getContentPanelActiveTab();
    	    	            grid = personProfile.down(gridItemId);
    	    	    	}              		    
              		    this.saveTrainingType(grid,'#facultyTrainingPersonDetailsGrid',form, SERVERURL.CREATE_TRAINING_DETAILS, SERVERURL.UPDATE_TRAINING_DETAILS,docGrid);
                	}
                },
                'persontrainingdetailsform[itemId=facultyPersonTrainingDetailsForm] button[itemId=cancelButtonId]': {
                	click: function(obj){
                		try{
            	    		var form = this.getPersonTrainingDetailsForm().getForm();
            	    		form.reset();
            	    	}
            	    	catch(e){
            	    		console.log('');
            	    	}
                	}
                },
                'persontrainingdetailsform[itemId=facultyPersonTrainingDetailsForm]  button[itemId=personAddressDisplayField4]' : {
    				click : function(obj) {
    					var buttonId = obj.itemId;
    					var form = obj.up('form');
    					var academyLocationId = null;
    					this.getCommonAddressDetails(buttonId,academyLocationId);
    				}
    			},
    			'addressFormWindow#facultyTrainingAddressDetails  button[itemId=saveButtonId]' : {
    				click : this.addCompanyAddress
    			},
    			'addressFormWindow#facultyPersonTrainingDetails  button[itemId=cancelButtonId]' : {
    				click : function() {
    					//this.getCloseAddressDetail();
    					var formWindow = this.getAddressformwindow();
    					formWindow.close();
    				}
    			},
    			'addressFormWindow#facultyTrainingAddressDetails button#cancelButtonId': {
                    click: this.resetForm
                },
    			/* from Address Controller */
    			
    			'addressFormWindow#facultyTrainingAddressDetails form[itemId=addressfieldsform]  customcombobox#parentCountryRegionId': {
                    select: function(obj1, record) {
                        var cityComboBox = this.getAddressfieldsform().down('customcombobox#cityId');
                        cityComboBox.reset();

                        var countryRegion1 = record[0].get("id");
//                        var store = this.getStore('organization.CountryRegionStore1');
                        var store = this.getStore('organization.CityByCountryRegion');
//                        store.getProxy().api.read = SERVERURL.COUNTRY_FINDALL;
                        store.getProxy().extraParams = {
                            id: countryRegion1
                        };
                        store.reload();
                    }
                },
                'addressFormWindow#facultyTrainingAddressDetails form[itemId=addressfieldsform]  customcombobox#countryId': {
                    select: function(obj, record) {
                    	var newValue = record[0].data.id;
                    	var phoneCountryCode = this.getAddressfieldsform().down('customcombobox#phoneCountryCode');
                  	    var cellCountryCode = this.getAddressfieldsform().down('customcombobox#cellCountryCode');
                  	    var countryStore = this.getAddressfieldsform().down('customcombobox#countryId').getStore();
                  	    var val=  countryStore.getById(newValue);
                  	    phoneCountryCode.setValue(val);
                  	    cellCountryCode.setValue(val);
                        var cityComboBox = this.getAddressfieldsform().down('customcombobox#cityId');
                        cityComboBox.clearValue();

                        var genericField1ComboBox = this.getAddressfieldsform().down('customcombobox#parentCountryRegionId');
                        genericField1ComboBox.reset();

                       /* var genericField2ComboBox = this.getAddressfieldsform().down('customcombobox#genericFieldId2');
                        genericField2ComboBox.reset();*/

                        var countryId = record[0].get("id");
                        
                        
                        var cityStore = cityComboBox.getStore();
                        cityStore.getProxy().extraParams = {
                            id: countryId
                        };
                        cityStore.load();
                        
                        var countryRegionStore = genericField1ComboBox.getStore();
                        countryRegionStore.getProxy().extraParams = {
                            cid: countryId
                        };
                        countryRegionStore.load();
                        
                        /*var countryRegion2Store = genericField2ComboBox.getStore();
                        countryRegion2Store.removeAll();*/
                    }//,
                    //V2D-96112
//                    change: function(obj, newValue) {
//                 	   var phoneCountryCode = this.getAddressfieldsform().down('customcombobox#phoneCountryCode');
//                 	   var cellCountryCode = this.getAddressfieldsform().down('customcombobox#cellCountryCode');
//                 	   var countryStore = this.getAddressfieldsform().down('customcombobox#countryId').getStore();
//                 	   var val=  countryStore.getById(newValue);
//                 	   phoneCountryCode.setValue(val);
//                 	   cellCountryCode.setValue(val);
//                 }
                },
                /*'addressFormWindow#studentTrainingAddressDetails button#saveButtonId': {
                    click: this.saveAddress
                },*/
    			
    			/* from Address Controller */
                'personcommonwindow[itemId=personCommonWindow] persontrainingdetailsform[itemId=facultyPersonTrainingDetailsForm] button[itemId=cancelButtonId]': {
               	  click: this.closePersonCommonWindow
                 },
                'persontrainingdetailsform[itemId=facultyPersonTrainingDetailsForm] button[itemId=uploadDocItemId]':{
                	click : function() {
                		this.getDocumentController().showDocumentFormWindow('facultyPersonTrainingDetailsForm','DOCUMENT');
                	}
                },
                'documentformwindow[itemId=facultyPersonTrainingDetailsForm] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
               	  click : function() {
               		  var form = this.getPersonTrainingDetailsForm();
               		  var docGrid = form.down('#trainingTypeDocument');
               		  var module = 'trainingTypeDocument';
               		  var entityType = 'trainingTypeDocument';
               		  this.pastHistroyTypeDoceSave(docGrid,module,entityType);
               	  }
         		},
                'persontrainingdetailsform[itemId=facultyPersonTrainingDetailsForm] trainingtypedocument button#btnDelete' : {
           			click:function(obj){
           				this.deleteDocument(obj,SERVERURL.TRAINING_TYPE_DOC_DELETE,'#facultyTrainingPersonDetailsGrid');
           			}
           		},
           		'persontrainingdetailsform[itemId=facultyPersonTrainingDetailsForm] trainingtypedocument': {
           			cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
           				var $this = this;
           				var documentGrid =  grid.ownerCt;
           				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

           				if (columnName == "documentName") {
           					if (e.target.tagName == 'A') {
           						var documentId = record.get("documentId");
           						if (!isNullOrEmpty(documentId)) {
           							$this.getDocumentController().downloadDocumentFile(documentId);
           						}
           					}
           				}
           			}
           		},
           		/**
           		 * Document Download on click of document count on grid
           		 */
           		'persontrainingdocumentviewform[itemId=facultyTrainingDocumentViewForm] trainingtypedocument': {
           			cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
           				var $this = this;
           				var documentGrid =  grid.ownerCt;
           				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

           				if (columnName == "documentName") {
           					if (e.target.tagName == 'A') {
           						var documentId = record.get("documentId");
           						if (!isNullOrEmpty(documentId)) {
           							$this.getDocumentController().downloadDocumentFile(documentId);
           						}
           					}
           				}
           			}
           		},
           		/**
                 *  Competitive Exam Details
                 */

               'competitiveexamgrid[itemId=facultyCompetitiveExamGrid]': {
            	   render: function(grid) {
            		   this.loadGridStore('#facultyCompetitiveExamGrid', SERVERURL.COMPETITIVE_EXAM_DETAIL_GRID,grid);
            		   if(portalId == 2) {
            			   this.doAccessControlValidation(grid, this.getFACULTY_COMPETITIVE_EXAM_PERMISSIONS());
            		   }
            		   else if(portalId == 1){
            			   this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_COMPETITIVE_EXAM_PERMISSIONS());
            		   }
            	   },
            		cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
           				var $this = this;
           				var documentGrid =  grid.ownerCt;
           				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

           				if (columnName == "filePath") {
           					if (e.target.tagName == 'A') {
           						var documentId=[];
           					    

          			    	  var csvForm = Ext.create('Ext.form.Panel'); 
          					   csvForm.getForm().submit({
          						   target: '_blank',
          						   method:'POST',
          						   params :{
          							   access_token : Ext.Ajax.defaultHeaders.access_token,
          							   path: record.get("filePath")
          						   },
          						   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
          						   url: SERVERURL.PATH_FILE_DOWNLOAD_TEMP_API ,
          						   standardSubmit :true
          					   });
          				
           					}
           				}
           			}
               }, 
               'competitiveexamgrid[itemId=facultyCompetitiveExamGrid] button[itemId=btnAdd]': {
             	  click: function() {
                       this.showPersonCommonWindow('COMPETITIVE_EXAM', 'facultyCompetitiveExamForm');
                   }
               },
               'competitiveexamgrid[itemId=facultyCompetitiveExamGrid] button[itemId=btnEdit]': {
                   click: function(){
                 	  this.editCompetitiveExamFormWindow('COMPETITIVE_EXAM', 'facultyCompetitiveExamForm', '#facultyCompetitiveExamGrid');
                   }
               },
               'competitiveexamgrid[itemId=facultyCompetitiveExamGrid] button[itemId=btnView]': {
                   click: function(){
                 	  this.viewCompetitiveExamFormWindow('COMPETITIVE_EXAM', 'facultyCompetitiveExamForm', '#facultyCompetitiveExamGrid');
                   }
               },
               'competitiveexamgrid[itemId=facultyCompetitiveExamGrid] button[itemId=btnDelete]': {
                   click: function(){
                 	  this.deleteCompetitiveExamRecord('#facultyCompetitiveExamGrid', SERVERURL.COMPETITIVE_DELETE);
                   }
               },
               'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=facultyCompetitiveExamForm] button[itemId=submitButtonId]': {
                   click: function(){
                 	  this.saveCompetitiveExam('#facultyCompetitiveExamGrid', SERVERURL.COMPETITIVE_CREATE, SERVERURL.COMPETITIVE_UPDATE);
                   }
               },
               'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=facultyCompetitiveExamForm] button[itemId=cancelButtonId]': {
             	  click: this.closePersonCommonWindow
               },
               'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=facultyCompetitiveExamForm] button[itemId=removeButtonId]': {
                 	click: this.removeCompetitiveExamDocument
                 },
               /**
                *  Transport Details
                *  
                */
               'transportpersondetailsgrid[itemId=facultyTransportPersonDetailsGrid]': {
            	   render: function(grid) {
            		   this.customloadGridStore('#facultyTransportPersonDetailsGrid', SERVERURL.FIND_TRANSPORT_REPORTS_FOR_USER,grid);
            		   var portalId = this.getCurrentLoggedPortalId();
            		   if(portalId == 2) {
            			   this.doAccessControlValidation(grid, this.getFACULTY_TRANSPORT_DETAILS_PERMISSIONS());
            		   }
            		   else if(portalId == 1){
            			   this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_TRANSPORT_DETAILS_PERMISSIONS());
            		   }
            	   }
               },
               /**
                *  Transport Details
                *  
                */
               'hostelpersondetailsgrid[itemId=facultyHostelPersonDetailsGrid]': {
            	   render: function(grid) {
            		   this.loadGridStore('#facultyHostelPersonDetailsGrid', SERVERURL.EMPLOYEE_FIND_HOSTEL_HISTORY,grid);
            		   var portalId = this.getCurrentLoggedPortalId();
            		   if(portalId == 2) {
            			   this.doAccessControlValidation(grid, this.getFACULTY_HOSTEL_DETAILS_PERMISSIONS());
            		   }
            		   else if(portalId == 1){
            			   this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_HOSTEL_DETAILS_PERMISSIONS());
            		   }
            	   }
               },
               
               /**
                *  Church information Details
                */
           	'churchinformationgrid[itemId=facultyChurchInformationGrid]': {
           		render: function(grid) {
           			this.loadChurchInfoGridStore('#facultyChurchInformationGrid', SERVERURL.CHURCH_INFORMATION_GRIDDATA);
           			var portalId = this.getCurrentLoggedPortalId();
           			if(portalId == 2) {
           				this.doAccessControlValidation(grid, this.getFACULTY_CHURCH_INFORMATION_PERMISSIONS());
           			}
           			else if(portalId == 1){
           				this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_CHURCH_INFORMATION_PERMISSIONS());
           			}
           		},
                   cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
       				   if (e.target.tagName == 'A') {
       					this.viewEmploymentHistory(grid,record);
       				   }
       			   }
               },
           	'churchinformationgrid[itemId=facultyChurchInformationGrid] button[itemId=btnAdd]': {
           		click: function() {
                       this.showPersonCommonWindow('CHURCH_INFORMATION', 'facultyChurchInfoForm');
                   }
               },
               'churchinformationgrid[itemId=facultyChurchInformationGrid] button[itemId=btnEdit]': {
             	  click: function(){
             		  this.editChurchInfoFormWindow('CHURCH_INFORMATION', 'facultyChurchInfoForm', '#facultyChurchInformationGrid');
             	  }
               },
               'churchinformationgrid[itemId=facultyChurchInformationGrid] button[itemId=btnView]': {
             	  click: function(){
             		  this.viewChurchInfoFormWindow('CHURCH_INFORMATION', 'facultyChurchInfoForm', '#facultyChurchInformationGrid');
             	  }
               },
               'churchinformationgrid[itemId=facultyChurchInformationGrid] button[itemId=btnDelete]': {
                   click: function(){
                   	this.deleteChurchInfoRecord('#facultyChurchInformationGrid', SERVERURL.CHURCH_INFORMATION_DELETE);
                   }
               },
               'personcommonwindow[itemId=personCommonWindow] churchinformationform[itemId=facultyChurchInfoForm] button[itemId=submitButtonId]': {
                   click: function(){
                   	this.saveChurchInfo('#facultyChurchInformationGrid', SERVERURL.CHURCH_INFORMATION_ADD, SERVERURL.CHURCH_INFORMATION_UPDATE);
                   }
               },
               'personcommonwindow[itemId=personCommonWindow] churchinformationform[itemId=facultyChurchInfoForm] button[itemId=cancelButtonId]': {
               	click: this.closePersonCommonWindow
               },
               'personcommonwindow[itemId=personCommonWindow] churchinformationform[itemId=facultyChurchInfoForm] button[itemId=btnAddEmploymentHistory]': {
           		click: function(obj){
    				   this.addChurchEmploymentHistory(obj);
    			   }
           	},
           	'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] combo[itemId=yearItemId]':{
        		render : this.loadFacultyEducationYearData
        	},
        	'personcommonwindow[itemId=personCommonWindow] educationform[itemId=facultyEducationForm] datefield[itemId=yearOfExam]':{
        		render: function(obj) {
       			 this.setYearOfEaxmDateMinvalue(obj);
       		 },
       		 select: function(obj,value){       
        		 this.setFacultyEducationYearMonthData(obj,value);
        		}
        	},
        	'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=facultyCompetitiveExamForm] combo[itemId=yearItemId]':{
        		render : this.loadYearDataOfFacultyComExam
        	},
        	'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=facultyCompetitiveExamForm] datefield[itemId=yearOfExam]':{
        		render: function(obj) {
       			 this.setYearOfEaxmDateMinvalue(obj);
       		 },
       		 select: function(obj,value){       
        		 this.setYearMonthDataOfFacultyComExam(obj,value);
        		}
        	},
        	'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=facultyCompetitiveExamForm] nestedJsonCombo[itemId=officerFormativeQualified]':{
        		render: function(obj) {
        			var store = obj.getStore();
        			store.getProxy().extraParams={
        				type:'Officer Formative Qualified'
        			};
        			store.load();
        		},
        		select: function(obj, record) {
        			var $this = this;
        	    	var getComExamForm = $this.getPersonCompetitiveExamForm();
        	    	var newValue = record[0].data.value;
        	    	var completionDate = getComExamForm.down('#completionDate');
        	    	if(newValue=='Yes' || newValue=='In Progress') {
        	    		var status = $this.checkCompletionDateDfrSetting(getComExamForm);
        	    		if(status==false) {
        	    			completionDate.setVisible(true);
        	    		}
        	    	}
        	    	else {
        	    		completionDate.setVisible(false);
        	    		completionDate.allowBlank=true;
        	    		completionDate.reset();
        	    	}
        	    	getComExamForm.getForm().checkValidity();
        		}
        	},
        	'employeeReferenceGrid[itemId=employeeReferenceGrid]': {
         	   render: function(grid) {
         		  this.employeeReferenceGrid('#employeeReferenceGrid', SERVERURL.EMPLOYEE_REFERENCE_GRIDDATA);
         		   var portalId = this.getCurrentLoggedPortalId();
         		  if(portalId == 2) {
         				this.doAccessControlValidation(grid, this.getFACULTY_REFERENCES_PERMISSIONS());
         			}
         			else if(portalId == 1){
         				this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_EMPLOYEE_REFERENCES_PERMISSIONS());
         			}
         	   }
            },
            'employeeReferenceGrid[itemId=employeeReferenceGrid] button[itemId=btnAdd]': {
           		click: function() {
           			this.addReferences();
                   // this.showPersonCommonWindow('REFERENCE', 'facultyChurchInfoForm');
                }
            }, 
            'employeeReferenceGrid[itemId=employeeReferenceGrid] button[itemId=btnEdit]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var referenceGrid = applicantProfile.down('#employeeReferenceGrid');
                        me.editReferences(referenceGrid, false);
                    }
                }
            },
            'employeeReferenceGrid[itemId=employeeReferenceGrid] button[itemId=btnView]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var referenceGrid = applicantProfile.down('#employeeReferenceGrid');
                        me.editReferences(referenceGrid, true);
                    }
                }
            },
            'employeeReferenceGrid[itemId=employeeReferenceGrid] button[itemId=btnDelete]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var referenceGrid = applicantProfile.down('#employeeReferenceGrid');
                        me.deleteReferences(referenceGrid);
                    }
                }
            },
            'employeereferenceform button[itemId=btnSaveReferencesForm]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var referenceGrid = applicantProfile.down('#employeeReferenceGrid');
                        var window = me.getEmployeereferenceformwindow();
                        me.saveReferences(referenceGrid, window);
                    }
                }
            },
            'employeereferenceform button[itemId=btnCancelReferencesMasterForm]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var window = me.getEmployeereferenceformwindow();
                        window.close();
                    }
                }
            },
            /**Employee Physical Characteristics **/
            
            'physicalcharacteristicsgrid[itemId=facultyPhysicalCharacteristicsGrid]': {
          	  render: function(grid) {
          		  this.loadGridStore('#facultyPhysicalCharacteristicsGrid', SERVERURL.PHYSICAL_CHARACTERISTICS_GRID,grid);
          		  portalId = this.getCurrentLoggedPortalId();
          		  if(portalId == 2){
          			  this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_PHYSICAL_CHARACTERISTICS_PERMISSIONS());
          		  }else{
          			this.doAccessControlValidation(grid, this.getFACULTY_PHYSICAL_CHARACTERISTICS_PERMISSIONS());
          		  }
          	  }
            },
            'physicalcharacteristicsgrid[itemId=facultyPhysicalCharacteristicsGrid] button[itemId=btnAdd]': {
          	  click: function() {
                    this.showPersonCommonWindow('FACULTY_PHYSICAL_CHARACTERISTICS', 'facultyPhysicalCharacteristicsGrid');
                }
            },
            'physicalcharacteristicsgrid[itemId=facultyPhysicalCharacteristicsGrid] button[itemId=btnEdit]': {
          	  click: function(){
          		  this.editPhysicalCharFormWindow('FACULTY_PHYSICAL_CHARACTERISTICS', 'facultyPhysicalCharacteristicsGrid', '#facultyPhysicalCharacteristicsGrid');
          	  }
            },
            'physicalcharacteristicsgrid[itemId=facultyPhysicalCharacteristicsGrid] button[itemId=btnView]': {
          	  click: function(){
          		  this.viewPhysicalCharFormWindow('PHYSICAL_CHARACTERISTICS', 'physicalcharacteristicsform', '#facultyPhysicalCharacteristicsGrid');
          	  }
            },
            'physicalcharacteristicsgrid[itemId=facultyPhysicalCharacteristicsGrid] button[itemId=btnDelete]': {
          	  click: function(){
          		  this.deletePhysicalCharRecord('#facultyPhysicalCharacteristicsGrid', SERVERURL.PHYSICAL_CHARACTERISTICS_INFO_DELETE);
          	  }
            },
            
            'employeephysicalcharacteristicsform button[itemId=submitButtonId]': {
          	  click: function(){
          		  this.saveEmployeePhysicalCharInfo('#facultyPhysicalCharacteristicsGrid', SERVERURL.PHYSICAL_CHARACTERISTICS_INFO_ADD, SERVERURL.PHYSICAL_CHARACTERISTICS_INFO_UPDATE);
          	  }
            },
            ' employeephysicalcharacteristicsform button[itemId=cancelButtonId]': {
              	click: this.closePersonCommonWindow
              },
            
              /**
               *  Employeee Insurance History
               */
            'insurancehistorygrid[itemId=facultyInsuranceHistoryGrid]': {
              	  render: function(grid) {
              		  this.loadGridStore('#facultyInsuranceHistoryGrid', SERVERURL.EMPLOYEE_INSURANCE_HISTORY_GRID,grid);
              		  var portalId = this.getCurrentLoggedPortalId();
              		if(portalId == 2){
              			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_INSURANCE_HISTORY_PERMISSIONS());
              		}else{
              			this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_INSURANCE_HISTORY_PERMISSIONS());
              		}
              	  }
             },
             'insurancehistorygrid[itemId=facultyInsuranceHistoryGrid] button[itemId=btnAdd]': {
                	  click: function() {
                          this.showPersonCommonWindow('FACULTY_INSURANCE_HISTORY', 'facultyInsuranceHistoryGrid');
                      }
              },
              'employeeinsurancehistoryform button[itemId=submitButtonId]': {
                  	  click: function(){
                  		  this.saveEmployeeInsuranceHistory('#facultyInsuranceHistoryGrid', SERVERURL.EMPLOYEE_INSURANCE_HISTORY_ADD, SERVERURL.EMPLOYEE_INSURANCE_HISTORY_UPDATE);
                  	  }
              },
              'employeeinsurancehistoryform button[itemId=cancelButtonId]': {
                      	click: this.closePersonCommonWindow
              },
              'insurancehistorygrid[itemId=facultyInsuranceHistoryGrid] button[itemId=btnEdit]': {
              	  click: function(){
              		  this.editEmployeeInsuranceHistoryFormWindow('FACULTY_INSURANCE_HISTORY', 'facultyInsuranceHistoryGrid', '#facultyInsuranceHistoryGrid');
              	  }
                },
              'insurancehistorygrid[itemId=facultyInsuranceHistoryGrid] button[itemId=btnView]': {
              	  click: function(){
              		  this.viewEmployeeInsuranceHistoryFormWindow('FACULTY_INSURANCE_HISTORY', 'employeeinsurancehistoryform', '#facultyInsuranceHistoryGrid');
              	  }
                },
              'insurancehistorygrid[itemId=facultyInsuranceHistoryGrid] button[itemId=btnDelete]': {
              	  click: function(){
              		  this.deleteEmployeeInsuranceHistoryRecord('#facultyInsuranceHistoryGrid', SERVERURL.EMPLOYEE_INSURANCE_HISTORY_DELETE);
              	  }
                },
            
        	/**
             *  Faculty Non Academic Achievements
             */
        	'facultynonacademicachievementsgrid[itemId=facultynonacademicachievementsgrid]': {
        		render: function(grid) {
        			this.loadNonAcademicAchievementsGridStore('#facultynonacademicachievementsgrid', SERVERURL.FACULTY_NON_ACADEMIC_ACHIEVEMENTS_GRID);
        			portalId = this.getCurrentLoggedPortalId();
        			if(portalId == 2) {
           				this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS());
           			}
           			else if(portalId == 1){
           				this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS());
           			}
        		}
            },
            'facultynonacademicachievementsgrid[itemId=facultynonacademicachievementsgrid] button[itemId=btnAdd]': {
        		click: function() {
                    this.showPersonCommonWindow('FACULTY_NON_ACADEMIC_ACHIEVEMENTS','facultynonacademicachievementsform');
                }
            },
            'facultynonacademicachievementsgrid[itemId=facultynonacademicachievementsgrid] button[itemId=btnEdit]': {
          	  click: function(){
          		  this.editFacultyNonAcademicAchievementsInfoForm('FACULTY_NON_ACADEMIC_ACHIEVEMENTS','facultynonacademicachievementsform', '#facultynonacademicachievementsgrid');
          	  }
            },
            'personcommonwindow[itemId=personCommonWindow] form[itemId=facultynonacademicachievementsform]':{
  	    	   render: function() {
  	            		var this$ = this;
  	            		var form = this$.getFacultynonacademicachievementsform();
  	                	var sportEventStore = form.down('#sportEvent').getStore();
  	                	sportEventStore.getProxy().extraParams={
  	            			type:'SportEvent'
  	            		};
  	                	sportEventStore.load();

  	            		var levelEventStore = form.down('#levelEvent').getStore();
  	            		levelEventStore.getProxy().extraParams={
  	            			type:'LevelEvent'
  	            		};
  	            		levelEventStore.load();
  	            		
  	            	}
  	    	 },
  	    	'facultynonacademicachievementsgrid[itemId=facultynonacademicachievementsgrid] button[itemId=btnDelete]': {
                click: function(){
                	this.deleteNonAcademicAchievementsInfoRecord('#facultynonacademicachievementsgrid', SERVERURL.FACULTY_NON_ACADEMIC_ACHIEVEMENTS_DELETE);
                }
            },
	    	 'facultynonacademicachievementsgrid[itemId=facultynonacademicachievementsgrid] button[itemId=btnView]': {
	          	  click: function(){
	          		  this.viewFacultyNonAcademicAchievementsInfoForm('FACULTY_NON_ACADEMIC_ACHIEVEMENTS', 'facultynonacademicachievementsform', '#facultynonacademicachievementsgrid');
	          	  }
	            },
  	    	'personcommonwindow[itemId=personCommonWindow] facultynonacademicachievementsform[itemId=facultynonacademicachievementsform] button[itemId=submitButtonId2]': {
                click: function(){
                	this.saveFacultyNonAcademicAchievementsForm('#facultynonacademicachievementsgrid', SERVERURL.FACULTY_NON_ACADEMIC_ACHIEVEMENTS_SAVE, SERVERURL.FACULTY_NON_ACADEMIC_ACHIEVEMENTS_UPDATE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] facultynonacademicachievementsform[itemId=facultynonacademicachievementsform] button[itemId=cancelButtonId2]': {
             	click: this.closePersonCommonWindow
             }, 
          });
    },
    
    DayCountbetweenDate : function() {
		 var ONE_DAY = 1000 * 60 * 60 * 24
	   
	   var form = this.getPersonSeminarDetailsForm();
	   var fromdate = form.down("#fromDate");
	   var todate = form.down("#toDate");
	   var numberOfDays = form.down("#numberOfDays");
	   // Convert both dates to milliseconds
	   var fromdate_ms = fromdate.getValue();
	   var todate_ms = todate.getValue();
	   
	   // Calculate the difference in milliseconds
	   var difference_ms = Math.abs(fromdate_ms - todate_ms)
	   if(todate_ms != null && fromdate_ms != null){
		   // Convert back to days and return
		   numberOfDays.setValue(Math.round(difference_ms/ONE_DAY+1));
	   }
	 },
	 processVaccinationInfoDetailsWindow: function(buttonAction){
	    	
	    	if( buttonAction == 'btnView' || buttonAction == 'btnEdit' ){
		    	var vaccinationInfodocumentGrid = Ext.ComponentQuery.query('employeevaccinationinfodocumentgrid');
		        
		        var $this = this;
		        var store = vaccinationInfodocumentGrid[0].store;
		         	
		        var a = Ext.ComponentQuery.query('[itemId=facultyVaccinationGrid]');
		        var currentId = 0;
		        if(a.length > 0){
		        	l = a[0].getSelectionModel().selected;
		        	if(l != undefined){
		        		if( l.items != undefined && l.items.length > 0 ){
		        			if( l.items[0].data != undefined ){
		        				if( l.items[0].data.id != undefined ){
		        					currentId = l.items[0].data.id;
		        				}
		        			}
		        		}
		        	}
		        }
		         	
		        if( currentId != 0 ){
		        	store.getProxy().extraParams = {
					  ID: currentId
					};
		        	//var proxy = store.getProxy();
					//var newApi =  {read: SERVERURL.APPLICANT_VACCINATION_INFO_DOCUMENT_FIND_BY_ID};
					//Ext.apply(proxy.api,newApi);
					store.load();
					var vaccinationInfoDocGrid = $this.getEmployeevaccinationinfodocumentgrid();
					if (vaccinationInfoDocGrid.isHidden() /*&& store.data.items.length > 0*/) {
						vaccinationInfoDocGrid
						.setVisible(true);
					}	  					
		        }
	    	  }
	    	
	  		  if(buttonAction == 'btnView'){
		          var a = Ext.ComponentQuery.query("personcommonwindow");
		  		  if( a != undefined & a.length > 0){
		  			//  a[0].down("#cancelButtonId").setVisible(false);
		  			  a[0].down("#submitButtonId").setVisible(false);
		  			  a[0].down("#uploadVaccinationItemId").setVisible(false);
		  		  }
		  		  var b = this.getEmployeevaccinationinfodocumentgrid();
		  		  if(b != undefined){
		  			b.down("#btnDelete").setVisible(false); 
		  		  }
	  		  }
	    },
	    getCommonAddressDetails : function(buttonId,
				academyLocationId) {
			var this$ = this;
			
			/* to check if current tab is for updation or addition */
			var form = this.getPersonTrainingDetailsForm();

	        var submitUrl, isUpdate = false;
	        var id = form.down('#training_hidden_field');
	        if (isNullOrEmpty(id.getSubmitValue())) {
	            isUpdate = false;
	        } else {
	            isUpdate = true;
	        }
	        /* to check if current tab is for updation or addition */
			
			if (isUpdate) {
				try{
					var showWinButton = Ext.ComponentQuery.query('#'+buttonId)[0].up('form').down('#submitButtonId').isVisible();
				}
				catch(e){
					var showWinButton = false;
				}
				
				var addressWindowItemId = "addressformwindow";
				var addressFormWindow = Ext.widget(
						'addressFormWindow', {
							itemId : 'facultyTrainingAddressDetails'
							//itemId : 'addressfieldsform'
						});
				addressFormWindow.show();
				
				//---hide/show button
				addressFormWindow.down('#saveButtonId').setVisible(showWinButton);
				
				var addressDetailsform = addressFormWindow
						.down('form');
				var form = addressDetailsform.getForm();
				var url = SERVERURL.VEHICLE_ADDRESS_FIND_BY_ID;
				
				var contentpanel = this.getContentPanel();
	    		var grid = contentpanel.down('#facultyTrainingPersonDetailsGrid');
				var records = grid.getSelectionModel().getSelection()[0];
				
				var addressId;
				
				if( records.get("address") != null && records.get("address") != undefined ){
					addressId = records.get("address").id;
				}
				
				if (isUpdate && addressId != undefined && addressId != null && addressId != "" ) {
					var params = {
						id : addressId
					};
					
					var data = records.get("address");
					//form.setValues(data);
					this.populateTrainingAddressDetails(form, data);
					// #############################################
					/*if (forms) {
						forms.down('#saveButtonId').hide();
						var formaddwindow=forms.down('form');
						var form = formaddwindow.getForm();
						var fields=	formaddwindow.getForm().getFields();
						Ext.each(fields.items, function(i) {
							i.setReadOnly(true);
						});
					}*/
				}
				
				if(showWinButton == false){
					var form = addressFormWindow.down('form').getForm();
					var fields=	form.getFields();
					Ext.each(fields.items, function(i) {
						i.setReadOnly(true);
					});
				}
				
				var formTraining = this.getPersonTrainingDetailsForm();
				try{
					if(!isNullOrEmpty(formTraining.getForm().getCode())){
						this.populateTrainingAddressDetails(form, formTraining.getForm().getCode().data);
					}
				}catch(er){
					
				}
			} else {
				var addressWindowItemId = "addressformwindow";
				var addressFormWindow = Ext.widget(
						'addressFormWindow', {
							itemId : 'facultyTrainingAddressDetails'
							//itemId : 'addressfieldsform'
						});
				addressFormWindow.show();
				var addressDetailsform = addressFormWindow
						.down('form');
				var form = addressDetailsform.getForm();
				var formTraining = this.getPersonTrainingDetailsForm();
				try{
					if(!isNullOrEmpty(formTraining.getForm().getCode())){
						this.populateTrainingAddressDetails(form, formTraining.getForm().getCode().data);
					}
				}catch(er){
					
				}
			}
			var $this = this;
			//addressDetailsform.down('#saveButtonId').setDisabled(false);
			//addressDetailsform.down('#saveButtonId').show();
		},
		
		populateTrainingAddressDetails: function(addressForm, addressData){
			form = addressForm;
			data = addressData;
			form.setValues(data);
			/*form.findField('addressText').setValue(data.addressText);
			form.findField('phoneAreaCode').setValue(data.phoneAreaCode);
			form.findField('pincode').setValue(addressDetails.pincode);
			form.findField('phoneNo').setValue(data.phoneNo);
			form.findField('cellNo').setValue(data.cellNo);
			form.findField('primaryeEmailId').setValue(data.primaryeEmailId);
			form.findField('alternateEmailId').setValue(data.alternateEmailId);*/
			var country = form.findField('country');
			var city = form.findField('city');
			var parentCountryRegion = form.findField('parentCountryRegion');
			var countryRegion = form.findField('countryRegion');
		
			if (data.country) {
		
				country.getStore().load({
									callback : function(rec,operation,success) {
										country.setValue(data.country.id);
									}
								});
				var cityStore = city.getStore();
				cityStore.getProxy().extraParams = {
									id : data.parentCountryRegion.id
								};
				cityStore.load({
							callback : function(rec,operation,success) {
								city.setValue(data.city.id);
							}
						});
				var pcrStore = parentCountryRegion.getStore();
				pcrStore.getProxy().extraParams = {
					cid : data.country.id
				};
				pcrStore.load({
							callback : function(rec,operation,success) {
								parentCountryRegion.setValue(data.parentCountryRegion.id);
							}
						});
		
				if (data.countryRegion) {
					var crStore = countryRegion.getStore();
					crStore.getProxy().extraParams = {
						pid : data.parentCountryRegion.id
					};
					crStore.load({
								callback : function(rec,operation,success) {
									countryRegion.setValue(data.countryRegion.id);
								}
							});
				}
			}
		},
		
		/*
		 * View Training Details Address in popup on cell click
		 */
		manageCompanyAddressType : function(grid, td, cellIndex,
				record, tr, rowIndex, e, eOpts) {
			var $this = this;
			/*var mngCompanyStructure = this
					.getCreatecompanystructure();*/
			var records = grid.getSelectionModel().getSelection()[0];
			var id = records.get("address").id;
			var addressDetails = records.get("address");
			//$this.openCompanyDetailAddress();
			
			var formWindow = Ext.widget(
					'addressFormWindow', {
						itemId : 'facultyTrainingAddressDetails'
						//itemId : 'addressfieldsform'
					});
			//addressFormWindow.show();
			
			formWindow.show();
			
			var forms = $this
					.getAddressformwindow();
			var form = forms.down('form').getForm();
			this.populateTrainingAddressDetails(form,addressDetails);
			if (forms) {
				forms.down('#saveButtonId').hide();
				var formaddwindow=forms.down('form');
				var form = formaddwindow.getForm();
				var fields=	formaddwindow.getForm().getFields();
				Ext.each(fields.items, function(i) {
					i.setReadOnly(true);
				});
			}
		},
		
		/*
		 * Save address details
		 */
		addCompanyAddress : function(button) {
			var $this = this;
			// var formWin = $this.getAddressformwindow();
			var form = button.up().up();
			var filterForm = this.getPersonTrainingDetailsForm().getForm();
			var values = form.getValues();
			
//			if(this.validatePhone(values)){
				// var studentId=Ext.getCmp('id').getValue();
				var dataModel = new Academia.model.organization.Address;
				dataModel.set('id', values.id);
				dataModel.set('addressId', values.addressId);
				dataModel.set('version', values.version);
				dataModel.set('addressText', values.addressText);
				dataModel.set('country', $this
						.getIdValueJson(values.country));
				dataModel.set('parentCountryRegion', $this
						.getIdValueJson(values.parentCountryRegion));
				dataModel
						.set('city', $this.getIdValueJson(values.city));
				dataModel.set('pincode', values.pincode);
				dataModel
						.set('cellCountryCode', values.cellCountryCode);
				dataModel.set('cellNo', values.cellNo);
				dataModel.set('phoneCountryCode',
						values.phoneCountryCode);
				dataModel.set('phoneAreaCode', values.phoneAreaCode);
				dataModel.set('phoneNo', values.phoneNo);
				dataModel
						.set('primaryeEmailId', values.primaryeEmailId);
				dataModel.set('alternateEmailId',
						values.alternateEmailId);
				//dataModel.set('addressType', null);
				dataModel.set('countryRegion', $this
						.getIdValueJson(values.countryRegion));
				//dataModel.set('salutation', values.salutation);
				Ext.apply(filterForm, {
					code : null,
					setCode : function(code) {
						filterForm.code = code;
					},
					getCode : function() {
						return filterForm.code;
					}
				});
				filterForm.setCode(dataModel);
				showSuccessMessage(getPersonModuleTranslation('TRAINING_DETAILS'), getPersonModuleTranslation('TRAINING_TYPE_ADDRESS_SUCCESS'));
				button.up().up().up().close();
//			}
		},
		
		/* For Training Details Address Management */
		
	    resetForm: function(button) {
	    	button.up('window').close();
	    },
	    

	    validatePhone:function(data){
	    	var isValid;
	    	if(!data.phoneNo && !data.cellNo){
	    		showWarningMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'),getCommonTranslation('ADD_PHONE_NO'));
	    		isValid= false;
	    	}
	    	else{
	    		isValid=true;
	    	}
	    	return isValid;
	    },
	    /*getIdValueJson: function(id, value) {
	        if (id) return {
	            id: id,
	            value: value
	        };
	    },*/
	    /*setIdFromNestedObject: function(object, field) {
	        if (object && object[field] && object[field].hasOwnProperty('id')) {
	            object[field] = object[field]["id"];
	        }
	    }*/
	    loadFacultyEducationYearData : function(cmb){
	    	var records= new Array ();
	    	var currentYear = Ext.Date.format(new Date(), 'Y');
	    	for(var num = currentYear ;num >=1950; num--){
	    		records.push({
	                value: num,
	                id : num.toString()
	            });
	    	}
	    	var store = cmb.getStore();
	    	store.loadData(records);
	    },
	    setFacultyEducationYearMonthData:function(obj,value){
	    	var getYearValue = Ext.Date.format(new Date(value), 'Y');
	    	var getMonthValue = Ext.Date.format(new Date(value), 'm');
	    	var $this = this;
	    	var getEducationForm = $this.getPersonEducationForm();
	    	var getMonthField = getEducationForm.down('#monthItemId');
	    	var getYearField = getEducationForm.down('#yearItemId');
	    	var getMonthOfExamination = getEducationForm.down('#monthOfExamination');
	    	var getYearOfExamination = getEducationForm.down('#yearOfExamination');
	    	
	    	getMonthField.getStore().load({
				   callback: function(records, operation, success) {
					   for(var i in records){
						   if(records[i].data.id==getMonthValue){
							   getMonthField.setValue(records[i].data.value);
						   }
					   }
				   }	   
			   });
	    	
	    	getYearField.setValue(getYearValue);
	    },
	    loadYearDataOfFacultyComExam : function(cmb){
	    	var records= new Array ();
	    	var currentYear = Ext.Date.format(new Date(), 'Y');
	    	for(var num = currentYear ;num >=1950; num--){
	    		records.push({
	                value: num,
	                id : num.toString()
	            });
	    	}
	    	var store = cmb.getStore();
	    	store.loadData(records);
	    },
	    setYearMonthDataOfFacultyComExam:function(obj,value){
	    	var getYearValue = Ext.Date.format(new Date(value), 'Y');
	    	var getMonthValue = Ext.Date.format(new Date(value), 'm');
	    	var $this = this;
	    	var getComExamForm = $this.getPersonCompetitiveExamForm();
	    	var getMonthField = getComExamForm.down('#monthItemId');
	    	var getYearField = getComExamForm.down('#yearItemId');
	    	
	    	getMonthField.getStore().load({
				   callback: function(records, operation, success) {
					   for(var i in records){
						   if(records[i].data.id==getMonthValue){
							   getMonthField.setValue(records[i].data.value);
						   }
					   }
				   }	   
			   });
	    	
	    	getYearField.setValue(getYearValue);
	    },
	    setYearOfEaxmDateMinvalue:function(obj){
	    	var getYearValue = Ext.Date.format(new Date(), 'Y');
	    	var getCurrentLastYearValue = getYearValue+'/12/31/';
	    	obj.setMinValue(Ext.Date.format(new Date('1950/01/01'), 'Y-m-d'));
	    	obj.setMaxValue(Ext.Date.format(new Date(getCurrentLastYearValue), 'Y-m-d'));
	    	
	    }
});
